/* d_mos1.c  93.12.19
 * mos model equations: spice level 1 equivalent
 */
#include "ecah.h"
#include "branch.h"
#include "d_mos.h"
#include "error.h"
#include "io.h"
#include "options.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	eval_mos1(branch_t*);
/*--------------------------------------------------------------------------*/
extern const struct ioctrl io;
extern const struct options opt;
/*--------------------------------------------------------------------------*/
void eval_mos1(branch_t *brh)
{
 static struct mos *x;
 static struct mmod *m;
 double sarg;
 double dsarg_dvbs;

 x = (struct mos*)brh->x;
 m = x->m;
 
 if (x->vbs <= 0.){
    sarg = sqrt(m->phi - x->vbs);
    dsarg_dvbs = -.5 / sarg;
    x->sbfwd = NO;
 }else{
    double sphi3 = pow(m->phi, 1.5);
    sarg = sqrt(m->phi) / (1. + .5 * x->vbs / m->phi);
    dsarg_dvbs = -.5 * sarg * sarg / sphi3;	/* is wrong!! */
    x->sbfwd = YES;
    if (!io.suppresserrors){
       error((sarg <= 0.) ? bPICKY : bTRACE,
          "%s: source fwd biased.  vbs=%g\n", printlabel(brh,NO), x->vbs);
    }
 }

 x->von = m->vto + m->gamma * (sarg - sqrt(m->phi));
 x->vgst = x->vdsat = x->vgs - x->von;
 if (x->vdsat < 0.)
    x->vdsat = 0.;
 x->cutoff = (x->vgst < 0.);
 x->saturated = (x->vds > x->vdsat);

 if (x->cutoff){
    x->gm = x->ids = x->gmb = 0.;
    x->gds = opt.gmin;
 }else if (x->saturated){
    x->gm  = x->beta * x->vgst * (1. + m->lambda * x->vds);
    x->ids = x->gm * (.5 * x->vgst);
    x->gds = .5 * x->beta * m->lambda * x->vgst * x->vgst;
    x->gmb = - x->gm * m->gamma * dsarg_dvbs;
 }else{ /* linear */
    x->gm  = x->beta * x->vds * (1. + m->lambda * x->vds);
    x->ids = x->gm * (x->vgst - .5*x->vds);
    x->gds = x->beta * 
    	((x->vgst - x->vds) + m->lambda * x->vds * (2.*x->vgst - 1.5*x->vds));
    x->gmb = - x->gm * m->gamma * dsarg_dvbs;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
