/* crtset.c  93.12.22
 * Copyright 1983-1992   Albert Davis
 * set up crt plotting parameters
 */
#include "ecah.h"
#include "error.h"
#include "io.h"
#include "pixelh.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void		cmd_crtset(const char*,int*);
static	void		setq(const char*,int*,int*);
	int		testcrt(void);
	struct graph	*initcrt(void);
/*--------------------------------------------------------------------------*/
extern const struct ioctrl io;

extern struct graph *initsun(struct graph *);
extern struct graph *initibm(struct graph *);
extern struct graph *initbasic(struct graph *);
extern struct graph *initpostscript(struct graph *);
extern struct graph *initunix(struct graph *);
extern struct graph *initx(struct graph *);
static int crttype;
static struct graph d;
/*--------------------------------------------------------------------------*/
void cmd_crtset(const char *cmd, int *cnt)
{
 static int sw_c, sh_c;
 static int beenhere = NO;

 if (!beenhere){
    d.sw    = 640;
    d.sh    = 200;
    sw_c    = 80;
    sh_c    = 25;
    d.ppc   = d.sw / sw_c;
    d.lpc   = d.sh / sh_c;
    d.gmode = 6;
    d.tmode = 2;
    d.pri   = 1;
    d.sec   = -2;
    d.grid  = -8;
    d.back  = 0;
    d.palette = 0;
 }
 beenhere = YES;

 if (pmatch(cmd,cnt,"Ascii")){
    crttype = '\0';
 }else if (pmatch(cmd,cnt,"None")){
    crttype = '\0';
 }else if (pmatch(cmd,cnt,"Basic")){
    crttype = 'b';
 }else if (pmatch(cmd,cnt,"Hercules")){
    crttype = 'h';
 }else if (pmatch(cmd,cnt,"Ibm")){
    crttype = 'i';
 }else if (pmatch(cmd,cnt,"Postscript")){
    crttype = 'p';
 }else if (pmatch(cmd,cnt,"Sun")){
    crttype = 's';
 }else if (pmatch(cmd,cnt,"Unix")){
    crttype = 'u';
 }else if (pmatch(cmd,cnt,"X")){
    crttype = 'x';
 }else if (pmatch(cmd,cnt,"Zenith")){
    crttype = 'z';
 }else if (!cmd[*cnt]){
    mprintf(io.mstdout,"%c\n", crttype);
    mprintf(io.mstdout,"%dx%d, %dx%d\n", d.sw, d.sh, sw_c, sh_c);
    mprintf(io.mstdout,"%d, %d\n", d.gmode, d.tmode);
    mprintf(io.mstdout,"%d, %d, %d, %d\n", d.pri, d.sec, d.grid, d.back);
    mprintf(io.mstdout,"%d\n", d.palette);
    return ;
 }else{
    syntax_check(cmd,cnt,bERROR);
 }

 setq(cmd,cnt,&d.sw);
 setq(cmd,cnt,&d.sh);
 setq(cmd,cnt,&sw_c);
 setq(cmd,cnt,&sh_c);
 d.ppc = d.sw / sw_c;
 d.lpc = d.sh / sh_c;
 setq(cmd,cnt,&d.gmode);
 setq(cmd,cnt,&d.tmode);
 setq(cmd,cnt,&d.pri);
 setq(cmd,cnt,&d.sec);
 setq(cmd,cnt,&d.grid);
 setq(cmd,cnt,&d.back);
 setq(cmd,cnt,&d.palette);
}
/*--------------------------------------------------------------------------*/
static void setq(const char *cmd, int *cnt, int *value)
{
 skipbl(cmd,cnt);
 if (isdigit(cmd[*cnt]) || cmd[*cnt]=='-')
    *value = (int)ctof(cmd,cnt);
 else
    skiparg(cmd,cnt);
}
/*--------------------------------------------------------------------------*/
int testcrt(void)
{
 return crttype;
}
/*--------------------------------------------------------------------------*/
struct graph *initcrt(void)
{
 switch (crttype){
    case 'b':
        return initbasic(&d);
#ifdef MSDOS
    case 'i':
	return initibm(&d);
#endif
    case 'p':
        return initpostscript(&d);
#ifdef SUNVIEW
    case 's':
        return initsun(&d);
#endif
    case 'u':
        return initunix(&d);
    case 'x':
        return initx(&d);
    default:
        return (struct graph*)NULL;
 }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
