#! /bin/sh
#
# Copyright (C) 1995 Debian Association, Inc.
# Written by Ian A. Murdock <imurdock@debian.org>
#
# Install the kernel on a Debian GNU/Linux system.
#
# This script is called from /usr/src/linux/arch/i386/boot/install.sh.
# If you install it as /sbin/installkernel, you can do a "make install"
# from a generic kernel source tree, and the image will be installed to
# the proper place for Debian GNU/Linux.
#
# This script can also be used, as of Release 6, to install a kernel image
# from the `kernel' archive.  To install a kernel image, it should be used
# as follows: "installkernel ./<name-of-kernel-image>-<version>".  As an
# example, to install the kernel image "sound-blaster-1.2.10", you would
# type: "installkernel ./sound_blaster-1.2.10".

if [ $# = 1 ]
then
  img="$1"
  ver=`echo $img | cut -d '-' -f 2`
else
  if [ $# = 4 ]
  then
    img="$2"
    map="$3"
    ver="$1"
    # $(INSTALL_PATH), passed as $4, is ignored--Debian GNU/Linux uses /boot.
  else
    echo "Usage: installkernel <kernel>"
    echo "Usage: installkernel <version> <zImage> <System.map> <directory>"
    exit 1
  fi
fi

if [ -f /boot/vmlinuz-$ver ]
then
  mv /boot/vmlinuz-$ver /boot/vmlinuz-$ver.old
fi
if [ -f /boot/System.map-$ver ]
then
  mv /boot/System.map-$ver /boot/System.map-$ver.old
fi
cat $img > /boot/vmlinuz-$ver
( cd /boot ; \
  ln -fs vmlinuz-$ver vmlinuz ; \
  ln -fs psdatabase-$ver psdatabase )
if [ $map ]
then
  cp $map /boot/System.map-$ver
fi

mkboot

if [ -x /usr/sbin/psupdate ]
then
  if [ -f /usr/src/linux/vmlinux ]
  then
    /usr/sbin/psupdate
  fi
fi
