#!/bin/sh

# collection - stop/start collection
# $Id: collection.sh,v 1.3 2001/08/28 15:22:24 remstats Exp $

# - - -   Version History - - -
# $Revision: 1.3 $

# - - -   Setup   - - -

if [ $# != 1 ] ; then
	echo >&2 "usage: `basename $0` {stop MSG|start|status}"
	exit 0
fi

what="$1"
file="@@TMPDIR@@/STOP-run-remstats"

# - - -   Mainline   - - -

case "$what" in 
	start)
		if [ -f $file ] ; then
			rm -f $file
			echo "stop-file removed ($file)"
		else
			echo "no stop-file; it's not stopped"
		fi
		;;
	stop)
		if [ -f $file ] ; then
			echo "stop-file exists ($file); it's stopped already"
		else
			echo >$file "`date +%Y-%m-%d %H:%M:%S`"
			if [ ! -z "$2" ] ; then
				echo >>$file "Reason: $2"
			else
				echo >>$file "Reason: unknown"
			fi
		fi
		;;
	status)
		if [ -f $file ] ; then
			echo "REMSTATS STOPPED"
			cat $file
		else
			echo "remstats collection not stopped"
		fi
		;;
	*)
		echo >&2 "usage: `basename $0` {stop|start|status}"
		exit 0
		;;
esac

