#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <dirent.h>

#include "config.h"
#include "support.h"

#define	USRDIR	".ppxp"

char *usrPPxP, *sysPPxP;

char *
Strdup(char *org)
{
    char *new;

    if ((new = strdup(org)) == NULL) {
	fprintf(stderr, "Strdup: memory allocation error!!\n");
	exit(-1);
    }
    return(new);
}

void *
Malloc(size_t size)
{
    void *p;

    if ((p = malloc(size)) == NULL) {
	fprintf(stderr, "Malloc: memory allocation error!!\n");
	exit(-1);
    }
    return(p);
}

void *
Calloc(size_t num, size_t size)
{
    void *p;

    if ((p = calloc(num, size)) == NULL) {
	fprintf(stderr, "memory allocation error!!\n");
	exit(-1);
    }
    return(p);
}

void *
Realloc(char *org, size_t size)
{
    char *new;

    if ((new = realloc(org, size)) == NULL) {
	fprintf(stderr, "Realloc: memory allocation error!!\n");
	exit(-1);
    }
    return(new);
}

int
DecodeArgs(char *argv[], unsigned char *buf, int len, int max)
{
    unsigned char *ep;
    int argc = 0;

    ep = buf + len;
    max --;
    while (buf < ep) {
	argv[argc ++] = Strdup(buf);
	buf += strlen(buf) + 1;
	if (argc == max) break;
    }
    argv[argc] = NULL;
    return(argc);
}

void
FreeArgs(int argc, char *argv[])
{
    int a;

    for (a = 0; a < argc; a ++) if (argv[a]) Free(argv[a]);
}

void
DirNameInit(uid_t uid)
{
    if (usrPPxP) {
	Free(usrPPxP);
	usrPPxP = NULL;
    }

    if (uid) {
	struct passwd *pw;

	if ((pw = getpwuid(uid)) != NULL && pw->pw_dir) {
	    usrPPxP = Malloc(strlen(pw->pw_dir) + 1
			     + sizeof(USRDIR) + 1);
	    sprintf(usrPPxP, "%s/"USRDIR, pw->pw_dir);
	}
    }
    if (!sysPPxP) sysPPxP = Strdup(PPXPDIR);
}

char *
GenUdsName(char *buf, char *ifname, int max)
{
    int len;

    len = sizeof(_PATH_RUN_PPXP"/ppxp-") + strlen(ifname) + 1;
    if (!buf || max < len) return(NULL);
    sprintf(buf, _PATH_RUN_PPXP"/ppxp-%s", ifname);
    return(strrchr(buf, '/') + 1);
}

struct list_s *
FileList(char *top, const char *name)
{
    struct dirent *dir;
    DIR *dp;
    struct stat st;
    char path[MAXPATHLEN], *np;
    struct list_s *lp, *hp=NULL;

    sprintf(path, "%s/%s/", top, name);
    np = path + strlen(path);
    if ((dp = opendir(path)) == NULL) return(NULL);
    while ((dir = readdir(dp)) != NULL) {
	strcpy(np, dir->d_name);
	if (!lstat(path, &st) && S_ISREG(st.st_mode)) {
	    lp = TCALLOC(struct list_s);
	    lp->name = Strdup(dir->d_name);
	    lp->data = Strdup(path);
	    lp->next = hp;
	    hp = lp;
	}
    }
    closedir(dp);
    return(hp);
}

struct list_s *
SortList(struct list_s *op)
{
    struct list_s *hp, *lp, *lp0, *tp, *tpn;
    int i, n;

    hp = op;
    tp = op->next;
    hp->next = NULL;
    while (tp) {
	tpn = tp->next;
	lp0 = NULL;
	lp = hp;
	while (lp) {
	    if (strcasecmp(tp->name, lp->name) < 0) break;
	    lp0 = lp;
	    lp = lp->next;
	}
	if (lp0) {
	    tp->next = lp0->next;
	    lp0->next = tp;
	} else {
	    tp->next = hp;
	    hp = tp;
	}
	tp = tpn;
    }
    return(hp);
}

void
DestroyList(struct list_s *lp)
{
    struct list_s *tp;

    while (lp) {
	if (lp->data) Free(lp->data);
	if (lp->name) Free(lp->name);
	tp = lp->next;
	Free(lp);
	lp = tp;
    }
}

#if defined(HAVE_PUTENV) && !defined(HAVE_SETENV)
int
setenv(const char *name, char *value, int overwrite)
{
    char *env;

    env = Malloc(strlen(name) + strlen(value) + 2);
    strcpy(env, name);
    strcat(env, "=");
    strcat(env, value);
    return(putenv(env));
}
#endif
