#
#
#
#

Widget:DefineClass RadioBox ButtonBox radio:create radio:config radio_proc

set radio_proc(get)	radio:get

proc radio:create {w a} {
    global radio_conf
    set radio_conf($w,variable) radio_variable($w)
}

proc radio:config {w opt val} {
    global radio_conf

    switch -- $opt {
	-buttons {
	    radio:set_buttons $w $val
	    radio:set_variable $w $radio_conf($w,variable)
	}
	-variable {
	    radio:set_variable $w $val
	}
	default {
	    return 1
	}
    }
    return 0
}

proc radio:set_buttons {w buttons} {
    set cmd_list {}
    foreach i $buttons {
	set b [lindex $i 0]
	set v [lindex $i 1]
	set t [lindex $i 2]

	set cmd "radiobutton $w.$b -value $v"
	if {$t != ""} {
	    set cmd "$cmd -text $t"
	}
	lappend cmd_list $cmd
    }
    bbox:config $w -buttons $cmd_list
}

proc radio:set_variable {w varname} {
    global radio_conf

    set radio_conf($w,variable) $varname

    foreach b [$w subwidget buttons] {
	$b configure -variable $varname
    }
}

proc radio:set_state {w} {
    global radio_conf

    set state $radio_conf($w,state)
    foreach b $radio_conf($w,buttons) {
	$b configure -state $state
    }
}

proc radio:get {w a} {
    global radio_conf

    upvar \#0 $radio_conf($w,variable) var
    return $var
}

proc radio:test {} {
    option add *aho.text aho
    option add *baka.text baka
    option add *tawake.text tawake

    RadioBox .box1 -buttons {{aho aho} {baka baka} {tawake tawake}} \
	-variable test_var1
    .box1 label .box1.label -text ahoaho
    button .b1 -text Print1 -command {puts $test_var1}

    RadioBox .box2 -buttons {{aho aho} {baka baka} {tawake tawake}} \
	-orient vertical -row 2
    .box2 label .box2.label -text bakabaka
    button .b2 -text Print2 -command {puts [.box2 get]}
    button .b3 -text Normal   -command {.box2 configure -state normal}
    button .b4 -text Disabled -command {.box2 configure -state disabled}

    grid .box1 -column 0 -row 0 -sticky ewns
    grid .b1   -column 0 -row 1
    grid .box2 -column 1 -row 0 -sticky ewns
    grid .b2   -column 1 -row 1
    grid .b3   -column 2 -row 0
    grid .b4   -column 2 -row 1
}
