#
#
#
#

set indicator_resource_table(35) {
    {0 activeColor1 disabledColor1} {1 activeColor1 disabledColor1}
    {2 activeColor1 disabledColor1} {3 activeColor1 disabledColor1}
    {4 activeColor1 disabledColor1} {5 activeColor1 disabledColor1}
    {7 activeColor1 disabledColor1}
    {10 activeColor2 disabledColor2} {13 activeColor2 disabledColor2}
    {19 activeColor2 disabledColor2} {26 activeColor2 disabledColor2}
    {37 activeColor2 disabledColor2} {51 activeColor2 disabledColor2}
    {71 activeColor2 disabledColor2}
    {100 activeColor3 disabledColor3} {138 activeColor3 disabledColor3}
    {193 activeColor3 disabledColor3} {268 activeColor3 disabledColor3}
    {372 activeColor3 disabledColor3} {517 activeColor3 disabledColor3}
    {719 activeColor3 disabledColor3}
    {1000 activeColor4 disabledColor4} {1389 activeColor4 disabledColor4}
    {1930 activeColor4 disabledColor4} {2682 activeColor4 disabledColor4}
    {3727 activeColor4 disabledColor4} {5179 activeColor4 disabledColor4}
    {7196 activeColor4 disabledColor4}
    {10000 activeColor5 disabledColor5} {13894 activeColor5 disabledColor5}
    {19306 activeColor5 disabledColor5} {26827 activeColor5 disabledColor5}
    {37275 activeColor5 disabledColor5} {51794 activeColor5 disabledColor5}
    {71968 activeColor5 disabledColor5}
}

set indicator_resource_table(20) {
    {0 activeColor1 disabledColor1}
    {2 activeColor1 disabledColor1}
    {3 activeColor1 disabledColor1}
    {6 activeColor1 disabledColor1}
    {10 activeColor2 disabledColor2}
    {18 activeColor2 disabledColor2}
    {32 activeColor2 disabledColor2}
    {56 activeColor2 disabledColor2}
    {100 activeColor3 disabledColor3}
    {178 activeColor3 disabledColor3}
    {316 activeColor3 disabledColor3}
    {562 activeColor3 disabledColor3}
    {1000 activeColor4 disabledColor4}
    {1778 activeColor4 disabledColor4}
    {3162 activeColor4 disabledColor4}
    {5623 activeColor4 disabledColor4}
    {10000 activeColor5 disabledColor5}
    {17783 activeColor5 disabledColor5}
    {31623 activeColor5 disabledColor5}
    {56234 activeColor5 disabledColor5}
}

proc indicator:update {frame table_name elem} {
    global PPxPInfo indicator_cell_table
    upvar \#0 $table_name table

    set rate $PPxPInfo($elem)

    set i 0
    foreach t $table($frame) {
	if {$rate > [lindex $t 1]} {
	    set color [lindex $t 2]
	} else {
	    set color [lindex $t 3]
	}
	set cell [lindex $t 0]
	$frame.$cell configure -background $color
    }
}

proc Indicator {frame in_label_image out_label_image pady} {
    global indicator_resource_table
    global indicator_in_cell_table indicator_out_cell_table

    set f [frame $frame]
    set cell_num [option get $frame cellNum {}]
    if {$cell_num == ""} {
	set cell_num 35
    }
    set i 0
    set indicator_cell_table($f) {}
    foreach c $indicator_resource_table($cell_num) {
	set threshold [lindex $c 0]
	set active_color [option get $f [lindex $c 1] {}]
	set disabled_color [option get $f [lindex $c 2] {}]
	lappend indicator_in_cell_table($f) \
	    [list inCell$i  $threshold $active_color $disabled_color]
	lappend indicator_out_cell_table($f) \
	    [list outCell$i $threshold $active_color $disabled_color]

	incr i
    }
    grid rowconfigure $f 1 -minsize $pady

    label $f.inLabel  -image $in_label_image
    label $f.outLabel -image $out_label_image
    grid $f.inLabel  -column 0 -row 0 -sticky ew
    grid $f.outLabel -column 0 -row 2 -sticky ew
    grid columnconfigure $f 0 -weight 1

    set width  [option get $f cellWidth  {}]
    set height [option get $f cellHeight {}]
    if {$width  == ""} {set width  4}
    if {$height == ""} {set height 6}

    set cell_image [image create photo -width $width -height $height]
    $cell_image blank

    set column 1
    foreach c $indicator_in_cell_table($f) {
	set cell  [lindex $c 0]
	set color [lindex $c 3]
	label $f.$cell -image $cell_image -background $color
	grid $f.$cell -column $column -row 0
	grid columnconfigure $f $column -weight 0

	incr column
    }
    set column 1
    foreach c $indicator_out_cell_table($f) {
	set cell  [lindex $c 0]
	set color [lindex $c 3]
	label $f.$cell -image $cell_image -background $color
	grid $f.$cell -column $column -row 2

	incr column
    }
    PPxP:UpdateInfoWidget $f recv.nrate \
	[list indicator:update $f indicator_in_cell_table recv.nrate]
    PPxP:UpdateInfoWidget $f send.nrate \
	[list indicator:update $f indicator_out_cell_table send.nrate]

    return $f
}
