<?php
/**
 * Core file for the Web Links part.
 *
 * @module links
 * @modulegroup content_handling
 * @package phpWebSite
 */
$phpgw_info['flags']['currentapp']='wcm';
$phpgw_info['flags']['noheader']=True;
include("../header.inc.php");
global $phpgw;

if (!isset($mainfile)) 
{
  /**
   * Defines core functions.
   */
  include("mainfile.php");
}

/**
 * Global configuration file.
 */
include("config.php");

function headblock()
{
	echo "<!--INDIVIDUAL BLOCKS-->
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
<tr>
	<td class=\"type4\">Web Links</td>
</tr>
<tr>
	<td class=\"type5\">
	";
}

function tailblock()
{
	SearchForm();

	echo "<br />";

	$mainlink = 69;
	menu($mainlink);
	
	echo "</td></tr></table></td></tr></table>";
	include("footer.php");
}

function menu($mainlink)
{
	echo "
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
<tr>
	<td class=\"type4\">".lang("Navigation")."</td>
</tr>
<tr>
	<td class=\"type5\">
<table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\" align=\"center\">
<tr>
	"; 

	if ($mainlink>0)
	{
		echo "<td class=\"type5\"><a href=\"links.php\">".lang("Links Main")."</a></td>";
 	}
	
 	echo "
	<td class=\"type5\"><a href=\"links.php?op=AddLink\">".lang("Add Link")."</a></td>
	<td class=\"type5\"><a href=\"links.php?op=NewLinks\">".lang("New Links")."</a></td>
	<td class=\"type5\"><a href=\"links.php?op=TheBest\">".lang("The Best")."</a></td>
	<td class=\"type5\"><a href=\"links.php?op=RandomLink\" target=\"blank\">".lang("Random Link")."</a></td>
</tr>
</table>
</td></tr></table>
</td></tr></table>
	";
}

function SearchForm()
{
	global $phpgw,$phpgw_info;
	echo "
<form action=\"links.php?op=search&amp;query=$query\" method=\"post\">
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">
<tr>
	<td class=\"type5\">
	<input type=\"text\" size=\"30\" maxlength=\"200\" name=\"query\" />
	<input type=\"submit\" value=\"".lang("Search")."\" /><br />
	";

	$phpgw->db->query("select * from wcm_links_links");
	$numrows = $phpgw->db->num_rows();

	echo lang("There are")." $numrows ".lang("Links in our Database");
	echo "
	</td>
</tr>
</table>
</form>
	";
}

function index()
{
	global $phpgw,$phpgw_info;
	$phpgw->common->phpgw_header();
	include("header.php");

	echo "
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
<tr>
	<td class=\"type4\" colspan=\"3\">".lang("Web Links") . 
help(lang("Web Links")) . "</td>
</tr>
<tr>
	";

	$phpgw->db->query("select cid, title from wcm_links_categories order by title");
	$count = 0;

	while($phpgw->db->next_record())
	{
		$cid=$phpgw->db->f("cid");
		$title=$phpgw->db->f("title");
		if ($count == "3")
		{
			echo "
</tr>
<tr>";
			$count = 0;
		}

		$phpgw->db->query("select sid, title from wcm_links_subcategories where cid=$cid order by title");

		echo "
	<td class=\"type5\" valign=\"top\" width=\"33%\">
	<a href=\"links.php?op=viewlink&amp;cid=$cid\">$title</a><br />";

		while($phpgw->db->next_record()) {	
			$sid=$phpgw->db->f("sid");
			$title=$phpgw->db->f("title");
			echo "
	<b>&gt;</b>&nbsp;<a href=\"links.php?op=viewslink&amp;sid=$sid\">$stitle</a><br />";
		}

		echo "
	</td>";
		$count++;
	}

	while($count < 3)
	{
		echo "
	<td class=\"type5\" valign=\"top\" width=\"33%\">&nbsp;</td>";
		$count++;
	}
	
	$phpgw->db->query("select * from wcm_links_links");
	$numrows = $phpgw->db->num_rows();
	
	echo "
</tr></table>
</td></tr></table>
<br />
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
<tr>
	<td class=\"type4\" colspan=\"3\">".lang("Search Web Links")."</td>
</tr>
<tr>
<td class=\"type5\" colspan=\"3\"><br />
";

	SearchForm();
	echo "</td></tr></table>";

	echo "</td></tr></table><br />";
	$mainlink = 0;
	menu($mainlink);
	include("footer.php");
}


function AddLink() {
	global $phpgw,$phpgw_info;
	$phpgw->common->phpgw_header();
    include("header.php");
echo"<!--INDIVIDUAL BLOCKS-->
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
		<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
			<tr>
				<td class=\"type4\">
				".lang("Add Link")."
				</td>
			</tr>
			<tr>
				<td class=\"type5\"><form method=\"post\" action=\"links.php?op=Add\">
    ".lang("Page Title").": <input type=\"text\" name=\"title\" size=\"50\" maxlength=\"100\" /><br />
    ".lang("Page URL").": <input type=\"text\" name=\"url\" size=\"50\" maxlength=\"100\" value=\"http://\" /><br />
    ".lang("Description").": ".lang("(255 characters max)")." <br /><textarea name=\"description\" cols=\"60\" rows=\"5\" wrap=\"soft\"></textarea><br /><br />
    ".lang("Your Name").": <input type=\"text\" name=\"name\" size=\"30\" maxlength=\"60\" /><br />
    ".lang("Your Email").": <input type=\"text\" name=\"email\" size=\"30\" maxlength=\"60\" /><br />
    <input type=\"hidden\" name=\"op\" value=\"Add\" />
    <center><input type=\"submit\" value=\"".lang("Submit")."\" /></center><br /><br />
    </form></td></tr></table></td></tr></table><br />";
    $mainlink = 1;
    menu($mainlink);
    include("footer.php");
}

function Add($title, $url, $name, $cat, $description, $name, $email)
{
	global $phpgw,$phpgw_info;
	$phpgw->db->query("select url from wcm_links_links where url='$url'");
	$numrows = $phpgw->db->num_rows();

	if ($numrows > 0)
	{
		$phpgw->common->phpgw_header();
		include("header.php");
		headblock();
		echo "<span class=\"onebiggerred\">".lang("ERROR: This URL is already listed in the Database!")."</span><br />";
		tailblock();
		exit();
	}
	else
	{
		// Check if Title exist
		if ($title=="")
		{
			include("header.php");
			headblock();
			echo "<span class=\"onebiggerred\">".lang("ERROR: Add Failed. Please enter a title.")."</span><br />";
			tailblock();
			exit();
		}

		// Check if URL exist
		if ($url==""|| $url=="http://")
		{
			include("header.php");
			headblock();
			echo "<span class=\"onebiggerred\">".lang("ERROR: Add Failed. Please enter a URL.")."</span><br />";
			tailblock();
			exit();
		}

		// Check if Description exist
		if ($description=="")
		{
			include("header.php");
			headblock();
			echo "<span class=\"onebiggerred\">".lang("ERROR: Add Failed. Please enter a description")."</span><br />";
			tailblock();
			exit();
		}

		$cat = explode("-", $cat);
		if ($cat[1]=="") $cat[1] = 0;

		$title = stripslashes(FixQuotes($title));
		$url = stripslashes(FixQuotes($url));
		$description = stripslashes(FixQuotes($description));
		$name = stripslashes(FixQuotes($name));
		$email = stripslashes(FixQuotes($email));

		$phpgw->db->query("insert into wcm_links_newlink values (NULL, '$cat[0]', '$cat[1]', '$title', '$url', '$description', '$name', '$email')");

		include("header.php");
		headblock();
		echo "<h3>".lang("We received your Link submission. Thanks!")."<br />
		".lang("You'll receive an E-mail when it's approved.")."</h3><br /><br />";
		tailblock();
	}
}

function NewLinks() {
	global $phpgw,$phpgw_info;
	$phpgw->common->phpgw_header();
    include("header.php");
    include("config.php");
      echo "<!--INDIVIDUAL BLOCKS-->
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
		<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
			<tr>
				<td class=\"type4\">
				$newlinks ".lang("Last Links Added to Database")."
				</td>
			</tr>
			<tr>
				<td class=\"type5\">";

    $phpgw->db->query("select lid, cid, sid, title, description, date, hits from wcm_links_links order by date DESC limit 0,$newlinks");
    while($phpgw->db->next_record()) {
	$lid=$phpgw->db->f("lid");
	$cid=$phpgw->db->f("cid");
	$sid=$phpgw->db->f("sid");
	$title=$phpgw->db->f("title");
	$description=$phpgw->db->f("description");
	$time=$phpgw->db->f("date");
	$hits=$phpgw->db->f("hits");

	if (is_an_author($phpgw_info['user']['current_id'])) {
	    echo"<a href=\"links.php?op=visit&amp;lid=$lid\" target=\"blank\">$title</a>&nbsp;";
    	    echo "[ <a href=\"admin.php?op=LinksModLink&amp;lid=$lid\">".lang("Edit")."</a> ]<br />";
	} else {
	    echo "<a href=\"links.php?op=visit&amp;lid=$lid\" target=\"blank\">$title</a><br />";
	}

	echo "<span class=\"searchprops\">".lang("Description").": </span>$description<br />";
	
	setlocale ("LC_TIME", "$locale");
	ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime);
	$datetime = strftime("%d-%b-%Y", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
	$datetime = ucfirst($datetime);
	
	echo "<span class=\"searchprops\">".lang("Added on").": </span>$datetime ".lang("Hits").": $hits<br />";
	$phpgw->db->query("select title from wcm_links_categories where cid=$cid");
	$phpgw->db->next_record();
	$ctitle=$phpgw->db->f("title");
	echo "<span class=\"searchprops\">".lang("Category").": </span>$ctitle";
	$phpgw->db->query("select title from wcm_links_subcategories where sid=$sid");
	while($phpgw->db->next_record()) {
   	    $stitle=$phpgw->db->f("title");
	    echo " / $stitle";
	}
	echo "<br /><br />";
    }
    echo "</td></tr></table>";    

    echo "</td></tr></table><br />";
	$mainlink = 1;
    menu($mainlink);


    
    include("footer.php");
}

function TheBest() {
	global $phpgw,$phpgw_info;
	$phpgw->common->phpgw_header();
    include("header.php");
    include("config.php");
echo "<!--INDIVIDUAL BLOCKS-->
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
		<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
			<tr>
				<td class=\"type4\">
				 $toplinks ".lang("Most Visited Links")."
				</td>
			</tr>
			<tr>
				<td class=\"type5\">";
    $phpgw->db->query("select lid, cid, sid, title, description, date, hits from wcm_links_links order by hits DESC limit 0,$toplinks");
    while($phpgw->db->next_record()) {
	$lid=$phpgw->db->f("lid");
	$cid=$phpgw->db->f("cid");
	$sid=$phpgw->db->f("sid");
	$title=$phpgw->db->f("title");
	$description=$phpgw->db->f("description");
	$time=$phpgw->db->f("date");
	$hits=$phpgw->db->f("hits");
	if ($hits>0) {

	if (is_an_author($phpgw_info['user']['current_id'])) {
	    echo"<a href=\"links.php?op=visit&amp;lid=$lid\" target=\"blank\">$title</a>&nbsp;";
	    echo "[ <a href=\"admin.php?op=LinksModLink&amp;lid=$lid\">".lang("Edit")."</a> ]<br />";
	} else {
	    echo "<a href=\"links.php?op=visit&amp;lid=$lid\" target=\"blank\">$title</a><br />";
	}
	
	echo "<span class=\"searchprops\">".lang("Description").": </span>$description<br />";
	
	setlocale ("LC_TIME", "$locale");
	ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime);
	$datetime = strftime("%d-%b-%Y", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
	$datetime = ucfirst($datetime);
	
	echo "<span class=\"searchprops\">".lang("Added on").": </span>$datetime ".lang("Hits").": $hits<br />";
	$phpgw->db->query("select title from wcm_links_categories where cid=$cid");
	$phpgw->db->next_record();
	$ctitle=$phpgw->db->f("title");
	echo "<span class=\"searchprops\">".lang("Category").": </span>$ctitle";
	$phpgw->db->query("select title from wcm_links_subcategories where sid=$sid");
	while($phpgw->db->next_record()) {
		$stitle=$phpgw->db->f("title");
	    echo " / $stitle";
	}
	echo "<br /><br />";
    }
    }
    echo "</td></tr></table>";
    echo "</td></tr></table><br />";	
$mainlink = 1;
    menu($mainlink);
    include("footer.php");
}

function RandomLink() {

	global $phpgw,$phpgw_info;
    $phpgw->db->query("select * from wcm_links_links");
    $numrows = $phpgw->db->num_rows();
    srand((double)microtime()*1000000);
	if ($numrows > 1){
		$random = rand(1,$numrows);
    		$phpgw->db->query("select url from wcm_links_links where lid='$random'");
		$phpgw->db->next_record();
		$url=$phpgw->db->f("url");
	}else if ($numrows == 1) {
		$phpgw->db->query("select url from wcm_links_links where lid='1'");
		$phpgw->db->next_record();
		$url=$phpgw->db->f("url");
	}else 
		$url ="$nuke_url";

    $phpgw->redirect($phpgw->link("$url"));
}

function viewlink($cid, $min) {
	global $phpgw,$phpgw_info;
    include("config.php");
    if (!isset($min)) $min=0;
    if (!isset($max)) $max=$min+$perpage;
include("header.php");
$countcat = 0;
$countsub = 0;
echo "<!--INDIVIDUAL BLOCKS-->
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
		<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
			<tr>
				<td class=\"type4\">".lang("Web Links")."</td>
			</tr>
			<tr>
				<td class=\"type5\">";
 $phpgw->db->query("select title from wcm_links_categories where cid=$cid");
    $phpgw->db->next_record();
    $title=$phpgw->db->f("title");
        echo "<!--INDIVIDUAL BLOCKS-->
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
		<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
			<tr>
				<td class=\"type4small\"><a href=\"links.php\">".lang("Main")."</a>
	 / <a href=\"links.php?op=viewlink&amp;cid=$cid\">$title</a>
				</td>
			</tr>
			<tr>
				<td class=\"type5\">";
    $phpgw->db->query("select lid, title, description, date, hits from wcm_links_links where cid=$cid AND sid=0 limit $min,$perpage");
    $x=0;
    while($phpgw->db->next_record()) {
		$lid=$phpgw->db->f("lid");
		$title=$phpgw->db->f("title");
		$description=$phpgw->db->f("description");
		$time=$phpgw->db->f("date");
		$hits=$phpgw->db->f("hits");
		if (is_an_author($phpgw_info['user']['current_id'])) {
	    echo"<a href=\"links.php?op=visit&amp;lid=$lid\" target=\"blank\">$title</a>&nbsp;";
    	    echo "[ <a href=\"admin.php?op=LinksModLink&amp;lid=$lid\">".lang("Edit")."</a> ]<br />";
	} else {
	    echo "<a href=\"links.php?op=visit&amp;lid=$lid\" target=\"blank\">$title</a><br />";
	}
	echo "<span class=\"searchprops\">".lang("Description").": </span>$description<br />";
	setlocale ("LC_TIME", "$locale");
	ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime);
	$datetime = strftime("%d-%b-%Y", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
	$datetime = ucfirst($datetime);
	echo "<span class=\"searchprops\">".lang("Added on").": </span>$datetime ".lang("Hits").": $hits<br />";
	$x++;
    }
    echo "<br />";
    
echo "<!--INDIVIDUAL BLOCKS-->
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"50%\" align=\"center\">
<tr>
	<td class=\"type0\">
		<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
			<tr>
				<td class=\"type4\">
				".lang("Sub-Categories")."
				</td>
			</tr>
			<tr>
				<td class=\"type5\">";
    $phpgw->db->query("select sid, title from wcm_links_subcategories where cid=$cid");
    while($phpgw->db->next_record()) {
	$sid=$phpgw->db->f("sid");
	$title=$phpgw->db->f("title");
	$countsub++;
	$phpgw->db->query("select * from wcm_links_links where sid=$sid");
	$numrows = $phpgw->db->num_rows();
	if ($numrows > 0) {
	echo "&nbsp;&nbsp;<a href=\"links.php?op=viewslink&amp;sid=$sid\">$title</a> ($numrows) <br />";} else {
	echo "&nbsp;&nbsp;$title <br />"; }
    }
if ($countsub == "") {
echo lang("No Sub-Categories Available");
}
echo "</td></tr></table></td></tr></table><br /></td></tr></table>";



    $prev=$min-$perpage;
    if ($prev>=0) {
	print "<a href=\"links.php?op=viewlink&amp;cid=$cid&amp;min=$prev\">";
	print "<br /><br />".lang("Previous Page")."</a>";
    }

    $next=$min+$perpage;
    if ($x>=$perpage) {
	print "<a href=\"links.php?op=viewlink&amp;cid=$cid&amp;min=$max\">";
	print "<br /><br />".lang("Next Page")."</a>";
    }

    echo "</td></tr></table>";

echo "</td></tr></table>";
echo "</td></tr></table><br />";

    $mainlink = 1;
    menu($mainlink);
    include("footer.php");
}


function viewslink($sid, $min) {
	global $phpgw,$phpgw_info;
	$phpgw->common->phpgw_header();
    include("header.php");
    include("config.php");
    if (!isset($min)) $min=0;
    if (!isset($max)) $max=$min+$perpage;
    headblock();
    $phpgw->db->query("select cid, title from wcm_links_subcategories where sid=$sid");
    $phpgw->db->next_record();
    $cid=$phpgw->db->f("cid");
    $title=$phpgw->db->f("title");
    
    $phpgw->db->query("select cid, title from wcm_links_categories where cid=$cid");
    $phpgw->db->next_record();
    $cid=$phpgw->db->f("cid");
    $title=$phpgw->db->f("title");

    echo "<!--INDIVIDUAL BLOCKS-->
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
<tr>
	<td class=\"type0\">
		<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\">
			<tr>
				<td class=\"type4small\"><a href=\"links.php\">".lang("Main")."</a>
	 / <a href=\"links.php?op=viewlink&amp;cid=$cid\">$title</a> / $stitle
				</td>
			</tr>
			<tr>
				<td class=\"type5\">";

    $phpgw->db->query("select lid, url, title, description, date, hits from wcm_links_links where sid=$sid limit $min,$perpage");
    $x=0;
    while($phpgw->db->next_record()) {
		$lid=$phpgw->db->f("lid");
		$url=$phpgw->db->f("url");
		$title=$phpgw->db->f("title");
		$description=$phpgw->db->f("description");
		$time=$phpgw->db->f("date");
		$hits=$phpgw->db->f("hits");
		
		if (is_an_author($phpgw_info['user']['current_id'])) {
	    echo"<a href=\"links.php?op=visit&amp;lid=$lid\" target=\"blank\">$title</a>&nbsp;";
    	    echo "[ <a href=\"admin.php?op=LinksModLink&amp;lid=$lid\">".lang("Edit")."</a> ]<br />";
	} else {
	    echo "<a href=\"links.php?op=visit&amp;lid=$lid\" target=\"blank\">$title</a><br />";
	}
	echo "<span class=\"searchprops\">".lang("Description").": </span>$description<br />";
	setlocale ("LC_TIME", "$locale");
	ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime);
	$datetime = strftime("%d-%b-%Y", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
	$datetime = ucfirst($datetime);
	echo "<span class=\"searchprops\">".lang("Added on").": </span>$datetime ".lang("Hits").": $hits<br /><br />";
	$x++;
    }
	if ($x == "") {
	echo "No Links Available<br /><br /><br /><br /><br /><br /><br />";
}
    echo "</td></tr></table>";
    
    $prev=$min-$perpage;
    if ($prev>=0) {
	print "<a href=\"links.php?op=viewslink&amp;sid=$sid&amp;min=$prev\">";
	print "<br /><br /><center>".lang("Previous Page")."</center></a>";
    }

    $next=$min+$perpage;
    if ($x>=$perpage) {
	print "<a href=\"links.php?op=viewslink&amp;sid=$sid&amp;min=$max\">";
	print "<br /><br /><center>".lang("Next Page")."</center></a>";
    }

    echo "</td></tr></table>";


echo "</td></tr></table>";
echo "</td></tr></table><br />";
    $mainlink = 1;
    menu($mainlink);
    include("footer.php");
}

function visit($lid) {
//    dbconnect();
	global $phpgw,$phpgw_info;
    $phpgw->db->query("update wcm_links_links set hits=hits+1 where lid=$lid");
    $phpgw->db->query("select url from wcm_links_links where lid=$lid");
    $phpgw->db->next_record();
    $url=$phpgw->db->f("url");
    $phpgw->redirect($phpgw->link("$url"));
}

function search($query, $min) {

    include("config.php");
	global $phpgw,$phpgw_info;
	$db2=$phpgw->db;
	$db3=$phpgw->db;
    if (!isset($min)) $min=0;
    if (!isset($max)) $max=$min+$linksresults;

	if (strlen($query) > 0) {
		$query = stripslashes($query);
		$phpgw->db->query("select lid, cid, sid, title, url, description, date, hits from wcm_links_links where title LIKE '%$query%' OR description LIKE '%$query%' ORDER BY title DESC LIMIT $min,$linksresults");
	$nrows  = $phpgw->db->num_rows();
	$db2->query("select * from wcm_links_subcategories where title LIKE '%$query%' ORDER BY title DESC");
	$nrowsx  = $db2->num_rows();
	} else
		$nrows = 0;

    $x=0;

    include("header.php");
    $mainlink = 0;
    menu($mainlink);
    echo "<table class=\"type0\" width=\"100%\" cellspacing=\"0\" cellspacing=\"1\" border=\"0\"><tr><td colspan=\"2\">
    <table width=\"100%\" cellspacing=\"0\" cellpadding=\"8\" border=\"0\"><tr><td class=\"type5\"><br /><center>";
    SearchForm();
	echo"</center>";
    if ($nrows>0 || $nrowsx>0) {
	
	$db2->query("select cid, sid, title from wcm_links_subcategories where title LIKE '%$query%' ORDER BY title DESC");
	echo "<center>".lang("Search Results for").": <span class=\"onebiggerrd\">$query</span></center><br /><br />";
	echo "<table width=\"100%\"><td class=\"type2\">".lang("Sub-Categories")."</td></tr></table>";
	while($db2->next_record()) {
	    $cid=$db2->f("cid");
	    $sid=$db2->f("sid");
	    $stitle=$db2->f("title");
	    $db3->query("select title from wcm_links_categories where cid=$cid");
	    $db3->next_record();
	    $ctitle=$db3->f("title");
	    $db3->query("select * from wcm_links_links where sid=$sid");
	    $numrows = $db3->num_rows();
	    $ctitle = ereg_replace($query, "<b>$query</b>", $ctitle);
	    $stitle = ereg_replace($query, "<b>$query</b>", $stitle);
	    echo "	<a href=\"links.php?op=viewslink&amp;sid=$sid\">$ctitle / $stitle</a> ($numrows)<br />";
	}
	echo "<br /><table width=\"100%\"><tr><td class=\"type2\">Links</td></tr></table>";
        while($phpgw->db->next_record()) {
		$lid=$phpgw->db->f("lid");
		$cid=$phpgw->db->f("cid");
		$sid=$phpgw->db->f("sid");
		$title=$phpgw->db->f("title");
		$url=$phpgw->db->f("url");
		$description=$phpgw->db->f("description");
		$time=$phpgw->db->f("date");
		$hits=$phpgw->db->f("hits");
	    $title = ereg_replace($query, "<b>$query</b>", $title);

	    	if (is_an_author($phpgw_info['user']['current_id'])) {
	    echo"<a href=\"links.php?op=visit&amp;lid=$lid\">$title</a>&nbsp;";
    	    echo "[ <a href=\"admin.php?op=LinksModLink&amp;lid=$lid\">".lang("Edit")."</a> ]<br />";
	} else {
	    echo "<a href=\"links.php?op=visit&amp;lid=$lid\">$title</a><br />";
	}
	    $description = ereg_replace($query, "<b>$query</b>", $description);
	    echo "<span class=\"searchprops\">Description: </span>$description<br />";
	    setlocale ("LC_TIME", "$locale");
	    ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $time, $datetime);
	    $datetime = strftime("%d-%b-%Y", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
	    $datetime = ucfirst($datetime);
	    echo "<span class=\"searchprops\">".lang("Added on").": </span><b>$datetime</b> ".lang("Hits").": $hits<br />";
	    $db3->query("select title from wcm_links_categories where cid=$cid");
	    $db3->next_record();
	    $ctitle = $db3->f("title");
	    $db3->query("select title from wcm_links_subcategories where sid=$sid");
	    $db3->next_record();
	    $stitle = $db3->f("title");
	    if ($stitle=="") {
		$slash = "";
	    } else {
		$slash = "/";
	    }
	    echo "<span class=\"searchprops\">Category: </span>$ctitle $slash $stitle<br /><br />";
	    $x++;
        }
                
    } else {
        echo "<center><span class=\"onebiggerred\">".lang("No matches found to your query")."</span></center><br /><br />";
    }

    $prev=$min-$linksresults;
    if ($prev>=0) {
	print "<a href=\"links.php?op=search&amp;query=$query&amp;min=$prev\">";
	print "<br /><br /><center>".lang("Previous Page")."</center></a>";
    }

    $next=$min+$linksresults;
    $tmp = $linksresults-1;
    if ($x>=$tmp) {
	print "<a href=\"links.php?op=search&amp;query=$query&amp;min=$max\">";
	print "<br /><br /><center>".lang("Next Page")."</center></a>";
    }

    echo "<br /><br /><center>
    ".lang("Try to search")." \"$query\" ".lang("in others Search Engines")."<br />
    <a target=\"_blank\" href=\"http://www.altavista.com/cgi-bin/query?pg=q&amp;sc=on&amp;hl=on&amp;act=2006&amp;par=0&amp;q=$query&amp;kl=XX&amp;stype=stext\">Altavista</a> | 
    <a target=\"_blank\" href=\"http://www.google.com/search?q=$query\">Google</a> | 
    <a target=\"_blank\" href=\"http://www.hotbot.com/?MT=$query&amp;DU=days&amp;SW=web\">HotBot</a> | 
    <a target=\"_blank\" href=\"http://www.infoseek.com/Titles?qt=$query\">Infoseek</a> | 
    <a target=\"_blank\" href=\"http://www.dejanews.com/dnquery.xp?QRY=$query\">Deja News</a> | 
    <a target=\"_blank\" href=\"http://www.lycos.com/cgi-bin/pursuit?query=$query&amp;maxhits=20\">Lycos</a> |  
    <a target=\"_blank\" href=\"http://search.yahoo.com/bin/search?p=$query\">Yahoo</a>
    <br />
    <a target=\"_blank\" href=\"http://es.linuxstart.com/cgi-bin/sqlsearch.cgi?pos=1&amp;query=$query&amp;language=&amp;advanced=&amp;urlonly=&amp;withid=\">LinuxStart</a> |  
    <a target=\"_blank\" href=\"http://search.1stlinuxsearch.com/compass?scope=$query&amp;ui=sr\">1stLinuxSearch</a> | 
    <a target=\"_blank\" href=\"http://www.linuxlinks.com/cgi-bin/search.cgi?query=$query&amp;engine=Links\">LinuxLinks</a> | 
    <a target=\"_blank\" href=\"http://www.freshmeat.net/search.php?query=$query\">Freshmeat</a> | 
    <a target=\"_blank\" href=\"http://www.justlinux.com/bin/search.pl?key=$query\">JustLinux</a>";

    echo "</td></tr></table></td></tr></table>\n";
    echo "</td></tr></table></td></tr></table>\n";
    
    include("footer.php");

}

switch($op) {

    case "menu":
	menu($mainlink);
	break;

    case "AddLink":
	AddLink();
	break;

    case "NewLinks":
	NewLinks();
	break;

    case "TheBest":
	TheBest();
	break;

    case "RandomLink":
	RandomLink();
	break;

    case "viewlink":
	viewlink($cid, $min);
	break;

    case "viewslink":
	viewslink($sid, $min);
	break;

    case "visit":
	visit($lid);
	break;

    case "Add":
	Add($title, $url, $name, $cat, $description, $name, $email);
	break;

    case "search":
	search($query, $min);
	break;

    default:
	index();
	break;
    
}

?>
