<?php
/**
 * Global configuration file.
 *
 * This file contains variables that allow you to customize your
 * phpwebsite. Most of the variables are commented to make they're
 * function clear. If you are not sure what a variable does...DO NOT
 * CHANGE IT!
 *
 * @module config
 * @modulegroup core
 * @package phpWebSite
 */

/**
 * For automatic version checking.
 */ 

$check_version = 0;  # Change to 0 to disable the up-to-date check in admin section.

################
# URL to EMAIL #
################
$url_to_email = 1; 	# Set to 0 for articles to list the url for the author of an article
			# Set to 1 for it to list their email

###############
#  MAIN MENU  #
###############

$extend_menu = 0;   #0 = Menu NOT fully extended by default
                    #1 = Menu IS fully extended by default

$menu_bullet = "<b>&#183;</b>&nbsp;"; # Set this to whatever you like for a menu bullet, "" for none.

##############
#  CACHE     #
##############
$limit_cache = 0; ## set to one to disable browser cacheing

###############
#  WEB LINKS  #
###############

$category_type = 2;        #0 = No categories
                           #1 = Categories only
			   #2 = Categories with Sub-Categories

###################
# Default Theme   #
###################

$default_theme = "Default"; #Set this to the theme of your choice. Note 
                           #you MUST leave the Default Theme directory
                           #even if you wish to use a different theme 
                           #as default.

$disable_themes = 1;	   #Change this to 0 to disable user theme selection and force default theme.


####################
#  User Variables  #
####################

$max_user_comments = 50;   #This is the maximum number of comments allowed per user/per article.

####################
# Display Switches #
####################

$show_comments = 1;  # Change to 0 to disable user comments.
$login_switch = 1;   # Change to 0 to turn off the user login.
$block_percent = 20; # Adjust percentage to desired Block Width

#######################
# Main Page Variables #
#######################

$main_page_sections = 2;


$main_page_images = "/usr/httpd/html/phpwebsite/images/main_page/";	# System path to main page image directory.
$main_images_webdir = "./images/main_page/";					# Web directory for path given above.

######################
# New Page Variables #
######################

$default_num_sections = 5;	# Number of sections for "create pages". 
                                #If this number is decrememnted it could destroy sections on previously created pages.
				#Look for this to be fixed in the future.


$num_layouts = 6;	                                                     # Don't touch
$user_directory = "/usr/httpd/html/phpwebsite/images/user_pages/";   # System path to main page image directory.
$user_images_webdir = "./images/user_pages/";                                # Web directory for path given above.
$max_user_file_size = 75000;	                                             # Max file size upload for images.
$user_file_types = "image/jpeg, image/gif, image/pjpeg, image/x-png";	     # Dont touch

###################
# Database Config #
###################

$dbhost = "localhost";		# Mysql Database host
$dbuname = "db_username";		# Mysql user
$dbpass = "your_password";	# Mysql password
$dbname = "phpwebsite";		# Mysql Database name

#################
# Security Hash #
#################

#### CHANGE THIS ####

$security_hash = "sGw2mDi5vosEW74ngid2V5H7Ed7ske";	#You need to change this to a random string, it can be any
							#length but longer is better.  This fixes the security problem
							#that occurs when multiple instances of phpWebSite are installed 
							#under a single domain. If you only have a single instance of 
							#phpWebSite per domain, you need not worry about this fix - although
							#setting the security hash to a random string won't hurt :-)

#### CHANGE THIS ####

#########################
# Cookies Configuration #
#########################

$cookieadmtime = "2592000";
$cookiePrefix = "phpWebSite_info"; # Change this to be unique for your site.

##############################
# Site Identification Config #
##############################

$sitename = "phpWebSite";	                # Your Site Name
$nuke_url = "http://phpwebsite.appstate.edu";	# Your sites URL
$titletag = "Appalachian State University";	# This is appended to your site name in the browsers titlebar.
$titlebar = "phpWebSite";			# This will appear in the header on each page.
$startdate = "January 2001";			# When did your site launch?
$adminmail = "your_handle@your_site.com";      # Admin email.
$top = "10";					# Number of Announcements to display by default.
$oldnum = "20";
$ultramode = "1";

################################
# Banners / Advertising Config #
################################

$banners = "0";
$myIP = "10.0.0.1";

#################################
# Footer Messages for each page #
#################################

# Change these to fit your needs.

$foot1 = "Copyright &copy; Appalachian State University 2001";
$foot2 = "This Site is powered by phpWebSite &copy; The Web Technology Group, Appalachian State University";
$foot3 = "phpWebSite is licensed under the <a href=\"http://www.gnu.org/copyleft/gpl.html\">GNU GPL</a>";

##############################
# Backend / Headlines Config #
##############################

$backend_title = "phpWebSite";
$backend_language = "en-en";
$backend_image = "$nuke_url/images/";
$backend_width = "88";
$backend_height = "31";

###################
# Language Config #
###################

$locale = "en"; # Language code for your location.

####################
# Web Links Config #
####################

$perpage = 10;
$popular = 50;
$newlinks = 10;
$toplinks = 10;
$linksresults = 10;

#############################
# Mail New Stories to Admin #
#############################

$notify = 1;	# Set to 0 if you don not want to be notified about new announcement submissions.
$notify_email = "your_name@your_mailserver.com";	# Who should be notified.
$notify_subject = "News for $sitename";		# Subject line for email.
$notify_message = "You have a new news submission titled $subject\n---\n$story";	#Message format.
$notify_from = "webmaster";	# Email from.

##########################################
# Moderation Config (not working yet)    #
##########################################

$moderate = 1;	# 1 for comment moderation by admin
              	# 2 for moderation by anyone
	      	# 0 for no moderation

$reasons = array('As Is',
		'Offtopic',
		'Flamebait',
		'Troll',
		'Redundant',
		'Insightful',
		'Interesting',
		'Informative',
		'Funny',
		'Overrated',
		'Underrated');
# number of "Bad" reasons in $reasons, skip 0 (which is "As Is", neutral)
$badreasons = 4;

################################################
# Filters Options (yes in works in phpWebSite) #
###############################################

$MaxTextLength   = 0;     # Maximum # of displayable characters, ignoring HTML
$MaxTotalLength  = 0;     # Max # of characters total
$CensorList   = array('fuck','cunt','shit');
$CensorMode   = 1;        # 0: no filtering
			  # 1: exact match
                    	  # 2: match word beginnings
                          # 3: match string anywhere in words
$CensorReplace   =  '%@!#$&';  # Character to replace the bad words in $Censorlist

#########################
# Some Comments Options #
#########################

$commentlimit = 4096;
$anonymous = "Anonymous";

# 2 means accept all qualifiers: <foo bar>
# 1 means accept the tag only: <foo>

$AllowableHTML = array("p"=>2,
                      "b"=>1,
                      "i"=>1,
                      "a"=>2,
                      "em"=>1,
                      "br"=>1,
                      "strong"=>1,
                      "blockquote"=>1,
                      "tt"=>1,
                      "li"=>1,
                      "ol"=>1,
                      "div"=>2,
                      "ul"=>1);

########################
# Voting Booth Options #
########################

$maxOptions = "12";
$BarScale = "1";
$setCookies = "1";

######################################
# Images and Fonts for Dynamic Pages #
######################################

$default_topic_image = "alltopics.gif";
$tipath = "./images/topics/";
$userimg = "./images/menu/";
$adminimg = "./images/menu/admin/";
$admingraphic = "1";

# Font stuff below is legacy Nuke - we will remove it soon

$font1 = "<font face=\"Arial,Helvetica\" size=\"1\">";
$font2 = "<font face=\"Arial,Helvetica\" size=\"2\">";
$font3 = "<font face=\"Arial,Helvetica\" size=\"3\">";
$font4 = "<font face=\"Arial,Helvetica\" size=\"4\">";

#############################
# Other Misc System Options #
#############################

$system = "0";
$admart = "20";
$minpass = "5";
$httpref = "1";
$pollcomm = "1";
$events = 1;

$use_blocks_plugin = 0;                 # Change this to 1 to enable blocks from sql tables and not the default theme blocks.
                                        # No movement of the blocks will occur if this is set to 0.
					# ALL Blocks must be contained in the Blocks table.

######################################
# Do NOT touch the Following Options #
######################################

$uimages = "$userimg$language";

?>
