<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.bonscontact.inc.php,v 1.11 2001/09/06 22:56:15 bettina Exp $ */

	class bonscontact
	{
		var $action;
		var $start;
		var $query;
		var $sort;
		var $order;
		var $filter;
		var $cat_id;

		var $public_functions = array
		(
			'read_contacts'			=> True,
			'read_single_contact'	=> True,
			'save_contact'			=> True,
			'delete_contact'		=> True,
			'check_values'			=> True,
			'select_contact_list'	=> True,
			'read_abook'			=> True
		);

		function bonscontact($session=False, $action = '')
		{
			global $phpgw;

			$this->sonscontact = CreateObject('netsaint.sonscontact');

			if ($session)
			{
				$this->read_sessiondata($action);
				$this->use_session = True;
			}

			global $start, $query, $filter, $sort, $order, $cat_id;

			if(isset($start)) { $this->start = $start; }
			if(isset($query)) { $this->query = $query; }
			if(!empty($filter)) { $this->filter = $filter; }
			if(isset($sort)) { $this->sort = $sort; }
			if(isset($order)) { $this->order = $order; }
			if(isset($cat_id)) { $this->cat_id = $cat_id; }
		}

		function type($action)
		{
			switch ($action)
			{
				case 'contact'	: $column = 'netsaint_contact'; break;
				case 'cg'		: $column = 'netsaint_cg'; break;
			}
			return $column;
		}

		function save_sessiondata($data, $action)
		{
			global $phpgw;

			if ($this->use_session)
			{
				$column = $this->type($action);
				$phpgw->session->appsession('session_data',$column,$data);
			}
		}

		function read_sessiondata($action)
		{
			global $phpgw;

			$column = $this->type($action);
			$data = $phpgw->session->appsession('session_data',$column);

			$this->start	= $data['start'];
			$this->query	= $data['query'];
			$this->filter	= $data['filter'];
			$this->sort 	= $data['sort'];
			$this->order	= $data['order'];
			$this->cat_id	= $data['cat_id'];
		}

		function read_abook($start, $query, $qfilter, $sort, $order)
		{
			global $phpgw, $phpgw_info;

			$this->d	= CreateObject('phpgwapi.contacts');
			$account_id = $phpgw_info['user']['account_id'];

			$cols = array('n_given' 	=> 'n_given',
						'n_family'		=> 'n_family',
						'tel_pager' 	=> 'tel_pager',
						'email'			=> 'email',
						'email_home'	=> 'email_home');

			$entries = $this->d->read($start, True, $cols, $query, $qfilter, $sort, $order, $account_id);
			$this->total_records = $this->d->total_records;
			return $entries;
		}

		function read_contacts($action, $start, $limit, $query, $filter, $sort, $order, $cat_id)
		{
			if ($action == 'contact')
			{
				$contact = $this->sonscontact->read_contacts($start, $limit, $query, $filter, $sort, $order, $cat_id);
				$this->total_records = $this->sonscontact->total_records;
			}
			else
			{
				$contact = $this->sonscontact->read_cgs($start, $limit, $query, $filter, $sort, $order, $cat_id);
				$this->total_records = $this->sonscontact->total_records;
			}
			return $contact;
		}

		function read_single_contact($action, $c_id)
		{
			if ($action == 'contact')
			{
				$contact = $this->sonscontact->read_single_contact($c_id);
			}
			else
			{
				$contact = $this->sonscontact->read_single_cg($c_id);
			}
			return $contact;
		}

		function select_contact_list($action, $selected)
		{
			$c = $this->sonscontact->select_contact_list($action, $selected);
			return $c;
		}

		function check_values($action, $values)
		{
			global $phpgw;

			if (!$values['name'])
			{
				$error[] = lang('Please enter a name !');
			}
			else
			{
				if (strlen($values['name']) >= 25)
				{
					$error[] = lang('The short name can not exceed 25 characters in length !');
				}
				else
				{
					$exists = $this->sonscontact->exists($action, $values['name'], $values['id']);
					if ($exists)
					{
						$error[] = lang('This name has been used already !');
					}
				}
			}

			if (!$values['alias'])
			{
				$error[] = lang('Please enter a description !');
			}

			if (strlen($values['alias']) >= 255)
			{
				$error[] = lang('The description can not exceed 255 characters in length !');
			}

			if ($action == 'contact')
			{
				if ((!$values['csv_period']) || (!$values['h_period']))
				{
					$error[] = lang('Please choose the time periods !');
				}

				if ((!$values['s_comand']) || (!$values['h_comand']))
				{
					$error[] = lang('Please choose the commands !');
				}

				if ($values['check_wemail'] && $values['check_hemail'])
				{
					$error[] = lang('Please choose only one of the email addresses !');
				}

				if ((!$values['email']) && (!$values['pager']))
				{
					$error[] = lang('Please choose the contact !');
				}
			}

			if (is_array($error))
			{
				return $error;
			}
		}

		function save_contact($action, $values)
		{
			if ($values['access'])
			{
				$values['access'] = 'private';
			}
			else
			{
				$values['access'] = 'public';
			}

			if ($action == 'contact')
			{
				if ($values['s_rec'])
				{
					$values['s_rec'] = '1';
				}
				else
				{
					$values['s_rec'] = '0';
				}

				if ($values['s_crit'])
				{
					$values['s_crit'] = '1';
				}
				else
				{
					$values['s_crit'] = '0';
				}

				if ($values['s_warn'])
				{
					$values['s_warn'] = '1';
				}
				else
				{
					$values['s_warn'] = '0';
				}

				if ($values['h_rec'])
				{
					$values['h_rec'] = 1;
				}
				else
				{
					$values['h_rec'] = 0;
				}

				if ($values['h_down'])
				{
					$values['h_down'] = 1;
				}
				else
				{
					$values['h_down'] = 0;
				}

				if ($values['h_unreach'])
				{
					$values['h_unreach'] = 1;
				}
				else
				{
					$values['h_unreach'] = 0;
				}

				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sonscontact->edit_contact($values);
					}
				}
				else
				{
					$this->sonscontact->add_contact($values);
				}
			}
			else
			{
				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sonscontact->edit_cg($values);
					}
				}
				else
				{
					$this->sonscontact->add_cg($values);
				}
			}
		}

		function delete_contact($action,$c_id)
		{
			$this->sonscontact->delete_contact($action, $c_id);
		}
	}
?>
