<?php
	/**************************************************************************\
	* phpGroupWare - Inventory                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: viewdist.php,v 1.13 2001/07/03 12:10:00 bettina Exp $ */

	if ($submit || !$id)
	{
		$phpgw_info['flags'] = array('noheader' => True,
									'nonavbar' => True);
	}

	if (! $id)
	{
		Header('Location: ' . $phpgw->link('/inv/listdist.php','sort=' . $sort . '&order=' . $order . '&query=' . $query . '&start=' . $start
							. '&filter=' . $filter));
		$phpgw->common->phpgw_exit();
	}

	$phpgw_info['flags'] = array('currentapp' => 'inv',
					'enable_categories_class' => True);

	include('../header.inc.php');
	$this = CreateObject('phpgwapi.contacts');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('view' => 'view_dist.tpl'));

	$hidden_vars = '<input type="hidden" name="id" value="' . $id . '">' . "\n";
	$t->set_var('hidden_vars',$hidden_vars);

	$fields =  array('org_name'		=> 'org_name',
					'org_unit'		=> 'org_unit',
					'n_given'		=> 'n_given',
					'n_family'		=> 'n_family',
					'industry_type'	=> 'industry_type',
					'software'		=> 'software',
					'email'			=> 'email',
					'tel_work'		=> 'tel_work', 
					'tel_fax'		=> 'tel_fax',
					'tel_pager'		=> 'tel_pager',
					'note'			=> 'note',
					'url'			=> 'url',
					'url_mirror'	=> 'url_mirror',
					'ftp'			=> 'ftp',
					'ftp_mirror'	=> 'ftp_mirror',
					'access'		=> 'access'
	);

	$fields = $this->read_single_entry($id,$fields,$access,$cat_id,$tid='n');

	$t->set_var('lang_action',lang('View distributor'));

	$t->set_var('lang_company',lang('Company name'));
	$t->set_var('lang_department',lang('Department'));
	$t->set_var('lang_software',lang('Software'));
	$t->set_var('lang_url',lang('WWW'));
	$t->set_var('lang_url_mirror',lang('WWW mirror'));
	$t->set_var('lang_industry_type',lang('Industry type'));
	$t->set_var('lang_firstname',lang('first name'));
	$t->set_var('lang_lastname',lang('last name'));
	$t->set_var('lang_notes',lang('Notes'));
	$t->set_var('lang_pager',lang('pager'));
	$t->set_var('lang_ftp',lang('FTP'));
	$t->set_var('lang_ftp_mirror',lang('FTP mirror'));
	$t->set_var('lang_email',lang('Email'));
	$t->set_var('lang_phone',lang('business phone'));
	$t->set_var('lang_fax',lang('business fax'));
	$t->set_var('lang_contact',lang('Contact'));
	$t->set_var('lang_access',lang('Access'));
	$t->set_var('lang_cat',lang('Category'));

	$url = $fields[0]['url'];
	$url_mirror = $fields[0]['url_mirror'];
	$ftp = $fields[0]['ftp'];
	$ftp_mirror = $fields[0]['ftp_mirror'];
	$access = $fields[0]['access'];

	$t->set_var('company',$fields[0]['org_name']);
	$t->set_var('department',$fields[0]['org_unit']);
	$t->set_var('firstname',$fields[0]['n_given']);
	$t->set_var('lastname',$fields[0]['n_family']);
	$t->set_var('industry_type',$fields[0]['industry_type']);
	$t->set_var('software',$fields[0]['software']);
	$t->set_var('email',$fields[0]['email']);
	$t->set_var('wphone',$fields[0]['tel_work']);
	$t->set_var('fax',$fields[0]['tel_fax']);
	$t->set_var('pager',$fields[0]['tel_pager']);
	$t->set_var('access',lang($access));

	if (!$url || ($url == 'http://')) { $url = ''; }
	else
	{
		$url = $phpgw->strip_html($url);
		if (! ereg('http://',$url)) { $url = 'http://'. $url; }
    }
    $t->set_var('url',$url);

    if (!$url_mirror || ($url_mirror == 'http://')) { $url_mirror = ''; }
    else
	{
		$url_mirror = $phpgw->strip_html($url_mirror);
		if (! ereg('http://',$url_mirror)) { $url_mirror = 'http://'. $url_mirror; }
	}
    $t->set_var('url_mirror',$url_mirror);

    if (!$ftp || ($ftp == 'ftp://')) { $ftp = ''; } 
    else
	{
		$ftp = $phpgw->strip_html($ftp);
		if (! ereg('ftp://',$ftp)) { $ftp = 'ftp://'. $ftp; }
	}
    $t->set_var('ftp',$ftp);

    if (!$ftp_mirror || ($ftp_mirror == 'ftp://')) { $ftp_mirror = ''; }
    else
	{
		$ftp = $phpgw->strip_html($ftp_mirror);
		if (! ereg('ftp://',$ftp_mirror)) { $ftp_mirror = 'ftp://'. $ftp_mirror; }
	}
    $t->set_var('ftp_mirror',$ftp_mirror);

	$t->set_var('notes',$fields[0]['notes']);
    $t->set_var('cat',$phpgw->categories->id2name($fields[0]['cat_id']),'name');

    $t->set_var('done_action',$phpgw->link('/inv/listdist.php','cat_id=' . $cat_id));
    $t->set_var('lang_done',lang('Done'));

    $t->pparse('out','view');

    $phpgw->common->phpgw_footer();
?>
