<?php
	/**************************************************************************\
	* phpGroupWare - Inventory                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: editcategory.php,v 1.46 2001/07/19 00:13:57 bettina Exp $ */

	if (! $cat_id)
	{
		Header('Location: ' . $phpgw->link('/inv/index.php','sort=' . $sort . '&order=' . $order . '&query=' . $query
											. '&start=' . $start . '&filter=' . $filter));
	}

	$phpgw_info['flags']['currentapp'] = 'inv';
	include('../header.inc.php');

	$inventory = CreateObject('inv.inventory');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('form' => 'category_form.tpl'));
	$t->set_block('form','add','addhandle');
	$t->set_block('form','edit','edithandle');

	$c = CreateObject('phpgwapi.categories');
	$grants = $phpgw->acl->get_grants('inv');
	$grants[$phpgw_info['user']['account_id']] = PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;

	$hidden_vars = '<input type="hidden" name="sort" value="' . $sort . '">' . "\n"
				. '<input type="hidden" name="order" value="' . $order . '">' . "\n"
				. '<input type="hidden" name="query" value="' . $query . '">' . "\n"
				. '<input type="hidden" name="start" value="' . $start . '">' . "\n"
				. '<input type="hidden" name="cat_id" value="' . $cat_id . '">' . "\n"
				. '<input type="hidden" name="filter" value="' . $filter . '">' . "\n";

	if ($new_parent)
	{
		$cat_parent = $new_parent;
	}

	if ($submit)
	{
		$errorcount = 0;

		if (!$cat_name) { $error[$errorcount++] = lang('Please enter a name !'); }
		if (!$error)
		{
			if (!$cat_parent) { $exists = $c->exists('appandmains',$cat_name,$cat_id); }
			else { $exists = $c->exists('appandsubs',$cat_name,$cat_id); }
			if ($exists == True) { $error[$errorcount++] = lang('That name has been used already !'); }
		}
		$cat_data = Array();
		$cat_data['tax'] = $tax;
		$cat_data['number'] = $number;
		$cat_data = serialize($cat_data);

		if ($access) { $cat_access = 'private'; }
		else { $cat_access = 'public'; }

		if (! $error)
		{
			$c->edit(array
			(
				'id'		=> $cat_id,
				'name'		=> $cat_name,
				'descr'		=> $cat_description,
				'parent'	=> $cat_parent,
				'data'		=> $cat_data,
				'access'	=> $cat_access
			));
		}
	}

	if ($errorcount) { $t->set_var('message',$phpgw->common->error_list($error)); }
	if (($submit) && (! $error) && (! $errorcount)) { $t->set_var('message',lang('Category x has been updated !',$cat_name)); }
	if ((! $submit) && (! $error) && (! $errorcount)) { $t->set_var('message',''); }

	$cats = $c->return_single($cat_id);
	$data = unserialize($cats[0]['data']);
	$tax = $data['tax'];
	$number = $data['number'];

	$t->set_var('lang_procent',lang('%'));
	$t->set_var('lang_action',lang('Edit category'));
	$t->set_var('actionurl',$phpgw->link('/inv/editcategory.php'));
	$t->set_var('doneurl',$phpgw->link('/inv/index.php'));
	$t->set_var('hidden_vars',$hidden_vars);
	$t->set_var('lang_number',lang('Category ID'));
	$t->set_var('lang_name',lang('Name'));
	$t->set_var('lang_descr',lang('Description'));
	$t->set_var('lang_tax',lang('tax'));
	$t->set_var('lang_par_cat',lang('Parent category'));
	$t->set_var('lang_none',lang('None'));
	$t->set_var('lang_choose',lang('Choose the parent category'));
	$t->set_var('lang_access',lang('Private'));

	$t->set_var('par_cat_list',$c->formated_list('select','all',$cats[0]['parent'],False));
	$t->set_var('number',$number);
	$t->set_var('cat_name',$phpgw->strip_html($cats[0]['name']));
	$cat_description = $phpgw->strip_html($cats[0]['description']);
	$t->set_var('cat_description',$cat_description);
	$cat_id = $cats[0]['id'];
	$t->set_var('tax',sprintf("%1.2f",$tax));

	if ($cats[0]['access']=='private') { $t->set_var('access', '<input type="checkbox" name="access" value="True" checked>'); }
	else { $t->set_var('access', '<input type="checkbox" name="access" value="True">'); }

	$t->set_var('lang_editbutton',lang('Edit'));
	$t->set_var('lang_done',lang('Done'));

	if ($inventory->check_perms($grants[$cats[0]['owner']],PHPGW_ACL_DELETE) || $cats[0]['owner'] == $phpgw_info['user']['account_id'])
	{
		$t->set_var('delete','<form method="POST" action="' . $phpgw->link('/inv/deletecategory.php','cat_id=' . $cat_id . '&start=' . $start . '&query=' . $query
							. '&sort=' . $sort . '&order=' . $order . '&filter=' . $filter) . '"><input type="submit" value="' . lang('Delete') .'"></form>');
	}
	else { $t->set_var('delete','&nbsp;'); }

	$t->set_var('edithandle','');
	$t->set_var('addhandle','');

	$t->pparse('out','form');
	$t->pparse('edithandle','edit');

	$phpgw->common->phpgw_footer();
?>
