<?php
	/**************************************************************************\
 	* phpGroupWare - Inventory                                                 *
 	* http://www.phpgroupware.org                                              *
 	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
 	*            Bettina Gille [ceb@phpgroupware.org]                          *
 	* -----------------------------------------------                          *
 	* This program is free software; you can redistribute it and/or modify it  *
 	* under the terms of the GNU General Public License as published by the    *
 	* Free Software Foundation; either version 2 of the License, or (at your   *
 	* option) any later version.                                               *
 	\**************************************************************************/
	/* $Id: addcategory.php,v 1.52 2001/07/19 00:13:57 bettina Exp $ */

	$phpgw_info['flags']['currentapp'] = 'inv';
	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('form' => 'category_form.tpl'));
	$t->set_block('form','add','addhandle');
	$t->set_block('form','edit','edithandle');

	$c = CreateObject('phpgwapi.categories');

	if ($new_parent)
	{
		$cat_parent = $new_parent;
	}

	if ($submit)
	{
		$errorcount = 0;
		if (!$cat_name)
		{
			$error[$errorcount++] = lang('Please enter a name !');
		}
		if (!$error)
		{
	    	if (!$cat_parent)
	    	{
				$exists = $c->exists('appandmains',$cat_name,$cat_id='');
	    	}
	    	else
	    	{
				$exists = $c->exists('appandsubs',$cat_name,$cat_id='');
	    	}
	    	if ($exists == True)
	    	{
				$error[$errorcount++] = lang('That name has been used already !');
	    	}
		}

		if (! $error)
		{
			$cat_data = Array();
			$cat_data['tax'] = $tax;
			$cat_data['number'] = $number;
			$cat_data = serialize($cat_data);

    	    if ($access)
			{
				$cat_access = 'private';
			}
			else
			{
				$cat_access = 'public';
			}

			$c->add(array
			(
				'name'	=> $cat_name,
				'descr'	=> $cat_description,
				'parent'	=> $cat_parent,
				'data'		=> $cat_data,
				'access'	=> $cat_access
			));
		}
	}

	if ($errorcount) { $t->set_var('message',$phpgw->common->error_list($error)); }
	if (($submit) && (! $error) && (! $errorcount)) { $t->set_var('message',lang('Category x has been added !',$cat_name)); }
	if ((! $submit) && (! $error) && (! $errorcount)) { $t->set_var('message',''); }

	$t->set_var('lang_action',lang('Add category'));
	$t->set_var('actionurl',$phpgw->link('/inv/addcategory.php'));
	$t->set_var('doneurl',$phpgw->link('/inv/index.php')); 

	$hidden_vars = '<input type="hidden" name="sort" value="' . $sort . '">' . "\n"
				. '<input type="hidden" name="order" value="' . $order . '">' . "\n"
				. '<input type="hidden" name="query" value="' . $query . '">' . "\n"
				. '<input type="hidden" name="start" value="' . $start . '">' . "\n"
				. '<input type="hidden" name="filter" value="' . $filter . '">' . "\n";

	$t->set_var('hidden_vars',$hidden_vars);

	$t->set_var('lang_procent',lang('%'));
	$t->set_var('lang_none',lang('None'));
	$t->set_var('lang_par_cat',lang('Parent category'));
	$t->set_var('par_cat_list',$c->formated_list('select','all',$cat_parent,False));

	$t->set_var('lang_number',lang('Category ID'));
	$t->set_var('lang_name',lang('Name'));
	$t->set_var('lang_descr',lang('Description'));
	$t->set_var('lang_tax',lang('tax'));
	$t->set_var('number',$number);
	$t->set_var('cat_name',$cat_name);
	$t->set_var('cat_description',$cat_description);
	$t->set_var('tax',$tax);
	$t->set_var('lang_access',lang('Private'));
	if ($access) { $t->set_var('access', '<input type="checkbox" name="access" value="True" checked>'); }
	else { $t->set_var('access', '<input type="checkbox" name="access" value="True"'); }
	$t->set_var('lang_addbutton',lang('Add'));
	$t->set_var('lang_reset',lang('Clear Form'));
	$t->set_var('lang_done',lang('Done'));
	$t->set_var('edithandle','');
	$t->set_var('addhandle','');
	$t->pparse('out','form');
	$t->pparse('addhandle','add');

	$phpgw->common->phpgw_footer();
?>
