<?php

/*************************************************************************\
* Bookkeeping (phpGroupWare app)                                          *
* http://www.phpgroupware.org                                             *
* Written by Rick Bakker <r.bakker@linvision.com>                         *
* --------------------------------------------                            *
* This program is free software; you can redistribute it and/or modify it *
* under the terms of the GNU General Public License as published by the   *
* Free Software Foundation; either version 2 of the License, or (at your  *
* option) any later version.                                              *
\*************************************************************************/

/* $Id: index.php,v 1.6 2001/06/18 22:13:57 darw1n Exp $ */

// HTTP_GET_VARS
$order	= $HTTP_GET_VARS['order'];
$sort	= $HTTP_GET_VARS['sort'];
$filter	= $HTTP_GET_VARS['filter'];
$qfield	= $HTTP_GET_VARS['qfield'];
$start	= $HTTP_GET_VARS['start'];
$query	= $HTTP_GET_VARS['query'];

if ($start == '')
{
        $start = 0;
}
if ($order == '')
{
	$order = 'account_lastname';
}
if ($sort == '')
{
	$sort = 'ASC';
}

//
//
//
$phpgw_info['flags']['currentapp'] = 'bookkeeping';
$phpgw_info['flags']['enable_nextmatchs_class'] = True;
include('../../header.inc.php');

//
//
//
$bookkeeping       = CreateObject('bookkeeping.bookkeeping');
$bookkeeping_admin = CreateObject('bookkeeping.bookkeeping_admin');

$template_header   = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
$template          = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
$template_footer   = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);

//
// Header template
//
$template_header->set_file(array('bookkeeping_header' => 'bookkeeping_header.tpl'));

$template_header->set_var('head_color', $phpgw_info['theme']['th_bg']);
$template_header->set_var('lang_app_title', lang('bookkeeping'));
$template_header->set_var('lang_module', lang('module'));
$template_header->set_var('module', lang('admin'));
$template_header->set_var('lang_bookkeeping_account', lang('bookkeeping_account'));
$bookkeeping_info['bookkeeping_account_id'] = $phpgw->session->appsession('id', 'bookkeeping');
if ($bookkeeping_info['bookkeeping_account_id'] == '')
{
	$bookkeeping_account = '*' . lang('non_selected') . '*';
}
else
{
	$phpgw->db->query("SELECT bookkeeping_account FROM phpgw_bk_ba WHERE bookkeeping_account_id='" . $bookkeeping_info['bookkeeping_account_id'] . "'");
	$phpgw->db->next_record();
	if ($phpgw->db->num_rows() == 0)
	{
		$bookkeeping_account = '*' . lang('no_valid_bookkeeping_account') . '*';
	}
	else
	{
		$bookkeeping_account = $phpgw->db->f('bookkeeping_account');
	}
}
$template_header->set_var('bookkeeping_account', $bookkeeping_account);

//
// Main template
//
$template->set_file(array('admin' => 'admin/index.tpl'));
$template->set_block('admin', 'bk_admin_list', 'bk_admins');

$bookkeeping_admin = $bookkeeping_admin->get_bookkeeping_admin_list($order, $sort);
$total = count($bookkeeping_admin);

$template->set_var('left_next_matchs',$phpgw->nextmatchs->left('/bookkeeping/admin/index.php',$start,$total));
$template->set_var('right_next_matchs',$phpgw->nextmatchs->right('/bookkeeping/admin/index.php',$start,$total));
$template->set_var('head_color', $phpgw_info['theme']['th_bg']);
$template->set_var('lang_loginid', $phpgw->nextmatchs->show_sort_order($sort,'account_lid',$order,'/bookkeeping/admin/index.php',lang('loginid')));
$template->set_var('lang_lastname', $phpgw->nextmatchs->show_sort_order($sort,'account_lastname',$order,'/bookkeeping/admin/index.php',lang('lastname')));
$template->set_var('lang_firstname', $phpgw->nextmatchs->show_sort_order($sort,'account_firstname',$order,'/bookkeeping/admin/index.php',lang('firstname')));
$template->set_var('lang_delete', lang('delete'));

if (($start + ($phpgw_info['user']['preferences']['common']['maxmatchs'] - 1)) >= ($total-1))
{
	$end = ($total - 1);
}
else
{
	$end = ($start + $phpgw_info['user']['preferences']['common']['maxmatchs'] - 1);
}
if ($total == '0')
{
	$template->set_var('tr_color', '');
	$template->set_var('loginid', '&nbsp;');
	$template->set_var('firstname', '&nbsp;');
	$template->set_var('lastname', '&nbsp;');
	$template->set_var('delete', '&nbsp;');
	$template->parse('bk_admins', 'bk_admin_list', true);
}
else
{
	for ($i=$start; $i<=$end; $i++)
	{
		$template->set_var('tr_color', $phpgw->nextmatchs->alternate_row_color($tr_color));
		$template->set_var('loginid', $bookkeeping_admin[$i]['phpgw_account_lid']);
		$template->set_var('firstname', $bookkeeping_admin[$i]['phpgw_account_firstname']);
		$template->set_var('lastname', $bookkeeping_admin[$i]['phpgw_account_lastname']);
		$template->set_var('delete', '<a href="'.$phpgw->link('/bookkeeping/admin/delete_admin.php','phpgw_account_id='.$bookkeeping_admin[$i]['phpgw_account_id']).'">'.lang('delete').'</a>');
		$template->parse('bk_admins', 'bk_admin_list', true);
	}
}
$template->set_var('actionurl', $phpgw->link('/bookkeeping/admin/add_admin.php'));
$template->set_var('lang_add', lang('add_bookkeeping_admin'));

//
// Footer template
//
$template_footer->set_file(array('bookkeeping_footer' => 'bookkeeping_footer.tpl'));
$template_footer->set_var('head_color', $phpgw_info['theme']['th_bg']);

//
//
//
$template_header->parse('out', 'bookkeeping_header', true);
$template_header->p('out');

$template->parse('out', 'admin', true);
$template->p('out');

$template_footer->parse('out', 'bookkeeping_footer', true);
$template_footer->p('out');

$phpgw->common->phpgw_footer();

?>
