#!perl

use Test::Most tests => 3;

use English qw{-no_match_vars};
use GnuPG::Interface;
use IO::Handle;
use Path::Class;

my $gnupg_homedir = dir('t', 'data', 'gnupg_homedir');
my $gnupg_pubkeys_dir = dir('t', 'data', 'pubkeys');

sub importKeyFile ($) {
    my $file = shift;

    my $gnupg = GnuPG::Interface->new();
    $gnupg->options->hash_init( homedir      => $gnupg_homedir );
    my ( $input, $output, $error ) = (IO::Handle->new(),
                                      IO::Handle->new(),
                                      IO::Handle->new(),
                                     );
    my $handles = GnuPG::Handles->new(stdin     => $input,
                                      stdout    => $output,
                                      stderr    => $error,
                                     );
    my $pid = $gnupg->import_keys( handles => $handles );

    my $key_str;
    unless ($key_str = $file->slurp) {
        warn "Could not slurp file '$file'.";
        return undef;
    }

    print $input $key_str;
    close $input;

    my @std_output   = <$output>;  # reading the output
    my @error_output = <$error>;   # reading the error
    close $output;
    close $error;

    waitpid $pid, 0;  # clean up the finished GnuPG process

    no warnings;
    return 1 if ($CHILD_ERROR == 0);
    use warnings;
    warn @error_output;
    return undef;
}

ok(importKeyFile(file($gnupg_pubkeys_dir, 'intrigeri.asc')));
ok(importKeyFile(file($gnupg_pubkeys_dir, 'rms.asc')));
is(system('gpg', '--homedir', $gnupg_homedir, '--update-trustdb'), 0, "updated GnuPG trustdb");
