/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cxxtest/TestSuite.h>

#include <saml/saml.h>
#include <sstream>

using namespace saml;
using namespace std;

class SAMLAttributeTest : public CxxTest::TestSuite {
public:
    XMLCh *name,*ns,*value,*value2;

    void setUp() {
        name = XMLString::transcode("foo");
        ns = XMLString::transcode("foons");
        value = XMLString::transcode("bar");
        value2 = XMLString::transcode("bar2");
    }

    void tearDown() {
        XMLString::release(&name);
        XMLString::release(&ns);
        XMLString::release(&value);
        XMLString::release(&value2);
    }
    
    void testSAMLAttribute(void) {
        TS_TRACE("testing SAMLAttribute class");

        const XMLCh* values[2] = { value, value2 };
        auto_ptr<SAMLAttribute> a(new SAMLAttribute(name, ns, NULL, 0, ArrayIterator<const XMLCh*>(values,2)));

        TS_ASSERT(a.get());
        auto_ptr<SAMLAttribute> a2((SAMLAttribute*)a->clone());

        stringstream str1,str2;
        str1 << *a.get();
        str2 << *a2.get();
        
        TS_ASSERT_EQUALS(str1.str(),str2.str());

        auto_ptr<SAMLAttribute> a3(new SAMLAttribute(str1));
        a->addValue(value);
        a3->addValue(value);
        stringstream str3,str4;
        str3 << *a.get();
        str4 << *a3.get();

        TS_ASSERT_EQUALS(str3.str(),str4.str());
        TS_ASSERT(!XMLString::compareString(a3->getValues()[2],value));
    }
};
