/* client.h
 * - Client function headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __ICECAST_CLIENT_H
#define __ICECAST_CLIENT_H


void client_login(connection_t *con, char *line);
void put_client(connection_t *con);
client_t *create_client();
void gen_playlist(connection_t *con, request_t *req);
void show_mountlist(connection_t *con, request_t *req);
void util_increase_total_clients ();
void util_decrease_total_clients ();
void del_client(connection_t *client, source_t *source);
int client_wants_content_length(connection_t *con);
int client_wants_icy_headers(connection_t *con);
int client_wants_metadata (connection_t *con);
int client_wants_udp_info (connection_t *con);
int client_errors (const client_t *client);
void greet_client(connection_t *con, source_t *source);
void describe_client (const com_request_t *req, const connection_t *clicon);
const char *client_type (const connection_t *clicon);
#endif

























