///////
   //    SchedulerEntry.h
   //    Scheduler Entry Class declaration
   //
   //    Class for interfacing the Schedule table of the DB
   //
   //    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: SchedulerEntry.h,v 1.14 2002/02/18 10:44:59 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 14.09.1999
///////

#ifndef _SCHEDULERENTRY_H
#define _SCHEDULERENTRY_H

#include <Object.h>
#include <htString.h>
#include "_Server.h"
#include <iostream.h>


class SchedulerEntry : public Object
{

   // Write the object to the output
   friend ostream& operator <<( ostream&, const SchedulerEntry& );
   
   public:
   
      // Construction / Destruction
      SchedulerEntry() {}
      SchedulerEntry(const String &u);
      virtual ~SchedulerEntry();

      enum Schedule_Status
      {
         Url_Empty,           // Not yet assigned
         Url_ToBeRetrieved,
         Url_Retrieved,
         Url_CheckIfExists,
         Url_Checked,
         Url_BadQueryString,
         Url_BadExtension,
         Url_MaxHopCount,
         Url_FileProtocol,
         Url_EMail,
         Url_Javascript,
         Url_NotValidService,
         Url_Malformed
      };


///////
   //    Public Interface
///////

      void Reset();
      void SetScheduleUrl(const String &u) { ScheduleUrl = u; }
      void SetIDSchedule (unsigned int id) { IDSchedule = id; }
      void SetIDServer (unsigned int id) { IDServer = id; }
      void SetIDReferer (unsigned int id) { IDReferer = id; }
      void SetHopCount (unsigned int hc) { HopCount = hc; }
      void SetServer (_Server *s);
      void SetMalformed (bool b) { is_malformed = b; }
      void SetStatus (Schedule_Status s) { Status = s; }


      void SetNewUrl(const String &u);
                                       // New Url definition
                                       // Reset the schedule and assign the
                                       // status to "ToBeRetrieved" by default

      void RetrieveStatus (String &) const;  // Insert into a string the value
                                       // for the Status (converts a Schedule_Status
                                       // value into a String).
                                       
      int SetStatus (const String &Status);  // Set the Schedule_Status value
                                             // depending on the Status string value
      
      const String &GetScheduleUrl() const { return ScheduleUrl; }
      unsigned int GetIDSchedule() const { return IDSchedule; }
      unsigned int GetIDServer() const { return IDServer; }
      Schedule_Status GetStatus() const { return Status; }
      const _Server *GetServer() const { return server; }
      unsigned int GetIDReferer() const { return IDReferer; }
      unsigned int GetHopCount() const { return HopCount; }
      unsigned int IsMalformed() const { return is_malformed; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}

///////
   //    Protected attributes
///////

   protected:

      unsigned int IDSchedule;
      unsigned int IDServer;
      _Server *server;           // For accessing server information
      
      String ScheduleUrl;
      
      Schedule_Status Status;

      // ID of referring URL
      unsigned int IDReferer;
      
      // Hop count (number of clicks from the first accessed page)
      unsigned int HopCount;

      // Boolean flag for malformed url
      bool is_malformed;

///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level

};

#endif
