/*
** Copyright 2000-2002 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"cmlmbounce.h"
#include	"cmlmcleanup.h"
#include	"cmlmmoderate.h"
#include	"cmlmarchive.h"
#include	"dbobj.h"
#include	"afx/afx.h"
#include	"afx/afxtempl.h"
#include	<stdio.h>
#include	<string.h>
#include	<fcntl.h>
#include	<time.h>
#include	<ctype.h>
#include	<errno.h>
#include	<iostream>
#include	<fstream>
#include	<utime.h>
#include	"mydirent.h"

static const char rcsid[]="$Id: cmlmcleanup.C,v 1.6 2002/07/13 17:20:12 mrsam Exp $";

static int chkbounces(CString d, int &counter);

//////////////////////////////////////////////////////////////////////////////
//
// Cleanup
//
//////////////////////////////////////////////////////////////////////////////

int cmdhourly(int argc, char **argv)
{
int counter;
ExclusiveLock hourly_lock(HOURLYLOCKFILE);
time_t	current_time;
DIR	*dirp;
struct	dirent *de;
struct	stat	stat_buf;
CString	n;

	time(&current_time);

	// Delete stuff from TMP that's more than 8 hours old

	dirp=opendir(TMP);
	while (dirp && (de=readdir(dirp)) != 0)
	{
		if (de->d_name[0] == '.')	continue;

		n= TMP "/";
		n += de->d_name;
		if (stat(n, &stat_buf) == 0 &&
			stat_buf.st_mtime + 8 * 60 * 60 < current_time)
			unlink(n);
	}
	if (dirp)	closedir(dirp);

	// Delete stuff from commands that's more than 48 hours old,
	// except keep bounces for 14 days.

	dirp=opendir(COMMANDS);
	while (dirp && (de=readdir(dirp)) != 0)
	{
		if (de->d_name[0] == '.')	continue;

	unsigned h=48 * 60 * 60;

		{
		CString	hs;

			hs=cmdget("PURGECMD");
			if (hs.GetLength() > 0)
			{
			unsigned n=atoi(hs);

				if (n)
					h= n * 60 * 60;
			}
		}

		if (strncmp(de->d_name, "bounce", 6) == 0)
		{
			h= 14 * 24 * 60 * 60;
			{
			CString	hs;

				hs=cmdget("PURGEBOUNCE");
				if (hs.GetLength() > 0)
				{
				unsigned n=atoi(hs);

					if (n)
						h= n * 24 * 60 * 60;
				}
			}
		}

		n= COMMANDS "/";
		n += de->d_name;
		if (stat(n, &stat_buf) == 0 &&
			(time_t)(stat_buf.st_mtime + h) < current_time)
		{
		// Once more, with locking

		CommandLock	cmd_lock;

			if (stat(n, &stat_buf) == 0 &&
				(time_t)(stat_buf.st_mtime + h) < current_time)
				unlink(n);
		}
	}
	if (dirp)	closedir(dirp);

int	rc=0;

	counter=atoi(cmdget("MAXBOUNCES"));
	if (counter <= 0)	counter=20;

	dirp=opendir(BOUNCES);
	while (dirp && (de=readdir(dirp)) != 0)
	{
		if (de->d_name[0] == '.')	continue;
		if (counter == 0)	break;

		n= BOUNCES "/";
		n += de->d_name;
		rc=chkbounces(n, counter);
		if (rc)	break;
	}
	if (dirp)	closedir(dirp);
	if (rc) return (rc);

	// Remoderate

	n=cmdget("POST");

	if (n.GetLength() > 0 && n == "mod")
	{
	time_t	t;
	int	nn=atoi(cmdget("REMODERATE"));
	ExclusiveLock modqueue_lock(MODQUEUELOCKFILE);

		counter=atoi(cmdget("MAXMODNOTICES"));
		if (counter <= 0)	counter=20;

		if (nn == 0)	nn=12;
		time (&t);
		t -= nn * 60 * 60;

		dirp=opendir(MODQUEUE);
		while (dirp && (de=readdir(dirp)) != 0)
		{
			if (de->d_name[0] == '.')	continue;
			if (counter == 0)	break;
			n= MODQUEUE "/";
			n += de->d_name;

			if (stat(n, &stat_buf))		continue;
			if (stat_buf.st_mtime >= t)	continue;
			utime(n, NULL);
			int i_fd=open(n, O_RDONLY);

			if (i_fd < 0)
				continue;

			afxipipestream	f(i_fd);

			rc=sendinitmod(f, de->d_name, "modtext2.tmpl");
			if (rc)
			{
				closedir(dirp);
				return (rc);
			}
			--counter;
		}
		if (dirp)	closedir(dirp);
	}
	return (0);
}

static void purgecommands()
{
CommandLock cmd_lock;
DbObj	db;
CStringList	purgelist;

	if (db.Open(COMMANDSDAT, "W"))	return;

char	*key, *val;
size_t	kl, vl;
CString	k, v;
CString	f;
struct	stat	stat_buf;

	for (key=db.FetchFirstKeyVal(kl, val, vl); key;
		key=db.FetchNextKeyVal(kl, val, vl))
	{
		memcpy(k.GetBuffer(kl), key, kl);
		k.ReleaseBuffer(kl);

		memcpy(v.GetBuffer(vl), val, vl);
		v.ReleaseBuffer(vl);
		free(val);

		f=COMMANDS "/";
		f += v;
		if (stat(f, &stat_buf) && errno == ENOENT)
			purgelist.AddTail(k);
	}

	while (!purgelist.IsEmpty())
	{
		k=purgelist.RemoveHead();
		db.Delete(k, k.GetLength());
	}
}

static void purgebounces()
{
ExclusiveLock bounce_lock(BOUNCESLOCK);
DbObj	db;
CStringList	purgelist;

	if (db.Open(BOUNCESDAT, "W"))	return;

char	*key, *val;
size_t	kl, vl;
CString	k, v;
CString	f;
struct	stat	stat_buf;

	for (key=db.FetchFirstKeyVal(kl, val, vl); key;
		key=db.FetchNextKeyVal(kl, val, vl))
	{
		memcpy(k.GetBuffer(kl), key, kl);
		k.ReleaseBuffer(kl);

		memcpy(v.GetBuffer(vl), val, vl);
		v.ReleaseBuffer(vl);
		free(val);

		f=BOUNCES "/";
		f += v;
		if (stat(f, &stat_buf) && errno == ENOENT)
			purgelist.AddTail(k);
	}

	while (!purgelist.IsEmpty())
	{
		k=purgelist.RemoveHead();
		db.Delete(k, k.GetLength());
	}
}

static void purgearchive()
{
struct	stat	stat_buf;
CString	buf;
time_t	t;
unsigned long n;

	buf=cmdget("PURGEARCHIVE");
	n=atol(buf);
	if (n == 0)	return;
	time(&t);

ArchiveList list;

	while ((buf=list.Next()).GetLength())
	{
		if (stat(buf, &stat_buf))	continue;
		if (stat_buf.st_mtime + (time_t)(n * 24 * 60 * 60) < t)
			unlink(buf);
	}
}

// Subscription report

class SubReport {
public:
	time_t when;
	CString address;
} ;

static void read_sublog(CList<SubReport, const SubReport &> &sub_list,
			CList<SubReport, const SubReport &> &unsub_list,
			CList<SubReport, const SubReport &> &bounce_list)
{
	ifstream list(SUBLOGFILE);

	CString buf;
	SubReport new_report;

	while ((buf << list) == 0)
	{
		const char *p=buf;
		time_t t=0;
		CList<SubReport, const SubReport &> *list_ptr;

		while (isdigit((int)(unsigned char)*p))
		{
			t = t*10 + (*p-'0');
			++p;
		}
		
		while (*p && isspace((int)(unsigned char)*p))
			++p;

		if (strncmp(p, "SUBSCRIBE", 9) == 0)
		{
			p += 9;
			list_ptr= &sub_list;
		}
		else if (strncmp(p, "UNSUBSCRIBE", 11) == 0)
		{
			p += 11;
			list_ptr= &unsub_list;
		}
		else if (strncmp(p, "BOUNCE", 6) == 0)
		{
			p += 6;
			list_ptr=&bounce_list;
		}
		else continue;

		while (*p && isspace((int)(unsigned char)*p))
			++p;

		if (*p)
		{
			new_report.when=t;
			new_report.address=p;
			list_ptr->AddTail(new_report);
		}
	}
}

static void subreportsection(afxopipestream &o,
			     CList<SubReport, const SubReport &> &l,
			     const char *template_name)
{
	POSITION p;

	if (l.IsEmpty())	return;

	copy_report(template_name, o);

	for (p=l.GetHeadPosition(); p; )
	{
		SubReport &record=l.GetNext(p);

		o << "    " << record.address << endl;
	}
}

static void subreport()
{
	CList<SubReport, const SubReport &> sub_list, unsub_list, bounce_list;

	CString report_addr=cmdget("REPORTADDR");
	SubExclusiveLock sub_lock;

	if (report_addr.GetLength() > 0)
	{
		read_sublog(sub_list, unsub_list, bounce_list);
		if (sub_list.IsEmpty() && unsub_list.IsEmpty() && bounce_list.IsEmpty())
			return;

		const char *argv[6];

		argv[0]="sendmail";
		argv[1]="-f";

		CString me=get_verp_return("owner", 0);

		argv[2]=me;
		argv[3]="-N";
		argv[4]="fail";
		argv[5]=0;

		pid_t p;

		afxopipestream report(sendmail(argv, p));

		report << "From: " << me << endl
		       << "To: " << report_addr << endl;

		copy_report("subreporthdr.tmpl", report);


		subreportsection(report, sub_list, "subreporthdr1.tmpl");
		subreportsection(report, unsub_list, "subreporthdr2.tmpl");
		subreportsection(report, bounce_list, "subreporthdr3.tmpl");

		copy_report("subreportfooter.tmpl", report);

		report.close();

		if (wait4sendmail(p))
			return;
	}

	CString	f=mktmpfilename();
	CString	ufilename= UNSUBLIST "/log." + f;

	rename(SUBLOGFILE, ufilename);
}

int cmddaily(int argc, char **argv)
{
ExclusiveLock dailylock(DAILYLOCKFILE);

	purgecommands();
	purgebounces();
	purgearchive();
	subreport();
	return (0);
}

//////////////////////////////////////////////////////////////////////////////
//
// WARNING MESSAGE GENERATION
//
//////////////////////////////////////////////////////////////////////////////

//
//  Ok, poke around in the bounce directory.
//  Returns: 0 - ignore this, hasn't aged enough.
//          -1 - remove immediately, something wrong.
//           1 - generate a warning message.
//

static int chkbouncedir(CString d, CString &addr, CString &lastbounce)
{
DIR	*dirp;
struct	dirent *de;

	{
	ifstream	addy(d + "/.address");

		if (addr << addy)	return (-1);
	}

	if (getinfo(addr, isfound))
		return (-1);		// Not subscribed any more

	dirp=opendir(d);
	if ( !dirp )	return (0);

time_t	oldestbounce=0;
time_t	last_bounce_time=0;
CString	n;
struct	stat	stat_buf;
time_t	current_time;

	time (&current_time);

	while ((de=readdir(dirp)) != 0)
	{
		if (de->d_name[0] == '.')	continue;

		n=d + "/";
		n += de->d_name;

		if (stat(n, &stat_buf))	continue;
		if (oldestbounce == 0)
		{
			last_bounce_time=oldestbounce=stat_buf.st_mtime;
			lastbounce=n;
		}
		if (stat_buf.st_mtime < oldestbounce)
			oldestbounce=stat_buf.st_mtime;
		if (stat_buf.st_mtime > last_bounce_time)
		{
			last_bounce_time=stat_buf.st_mtime;
			lastbounce=n;
		}
	}
	closedir(dirp);
	if (oldestbounce == 0)	return (0);

	CString grace=cmdget("STARTPROBE");

	if (grace.GetLength() == 0)
		grace="3";

	if (oldestbounce + atoi(grace) * 24 * 60 * 60 < current_time)
		return (1);
	return (0);
}

static void rmrf(CString d)	// Well, almost
{
	// Delete bounce dir after we're done.

DIR	*dirp;
struct	dirent *de;

	dirp=opendir(d);
	while (dirp && (de=readdir(dirp)) != 0)
	{
		if (strcmp(de->d_name, ".") == 0)	continue;
		if (strcmp(de->d_name, "..") == 0)	continue;
		unlink(d + "/" + de->d_name);
	}
	if (dirp)	closedir(dirp);
	rmdir(d);
}

static int chkbounces(CString d, int &counter)
{
CString	addr;
CString	lastbounce;

	if (chkbouncedir(d, addr, lastbounce) == 0)	return (0);

	// Once more, locked.

ExclusiveLock bounce_lock(BOUNCESLOCK);

int	rc=chkbouncedir(d, addr, lastbounce);

	if (rc == 0)	return (0);
	if (rc > 0)
	{
		rc=bouncewarning(addr, lastbounce, d);
		--counter;
	}
	else	rc=0;
	rmrf(d);
	return (rc);
}
