/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"rfc1035.h"
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<arpa/inet.h>

static const char rcsid[]="$Id: rfc1035ipv6to4.c,v 1.4 2000/05/28 18:34:51 mrsam Exp $";

#if RFC1035_FREEBSD40
#define	s6_addr16	__u6_addr.__u6_addr16
#define s6_addr32	__u6_addr.__u6_addr32
#endif

#if RFC1035_IPV6

void rfc1035_ipv6to4(struct in_addr *ip4, const struct in6_addr *ip6)
{
	ip4->s_addr=ip6->s6_addr32[3];
}

void rfc1035_ipv4to6(struct in6_addr *ip6, const struct in_addr *ip4)
{
	memset(ip6, 0, sizeof(*ip6));
	ip6->s6_addr16[5]= ~0;
	ip6->s6_addr32[3]= ip4->s_addr;

	if (ip4->s_addr == INADDR_ANY)
		*ip6= in6addr_any;
}
#endif

