// Copyright (c) 2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Created by postproc-shortwords 1.8 on 2009-03-22 11:11:34
// From input file /tmp/good_quad_input4567_sort.utf8
// See compact_lang_det.cc for usage
//
#include "encodings/compact_lang_det/cldutil.h"

// Suppressed:
//      ms-Latn gl-Latn mt-Latn af-Latn eu-Latn mk-Cyrl fa-Arab

// Remapped:
//      xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl

// ms/id probabilities leveled

static const int kQuadTableBuildDate = 20090322;    // yyyymmdd

COMPILE_ASSERT(MONTENEGRIN == 160, k_montenegrin_changed);
COMPILE_ASSERT(EXT_NUM_LANGUAGES == 209, k_ext_num_languages_changed);

// Nil-grams: 18 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC ORIYA INUKTITUT

// Uni-grams: 6 languages
//     Japanese Korean Chinese VIETNAMESE ChineseT ZHUANG

// Words/Quads/Gibberish: 38 languages in range ENGLISH..NORWEGIAN_N:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     Ignore BULGARIAN CROATIAN SERBIAN TAGALOG TURKISH UKRAINIAN
//     HINDI INDONESIAN MALAY ARABIC CATALAN SLOVENIAN MARATHI
//     VIETNAMESE SLOVAK NORWEGIAN_N

//  ENGLISH 1836
//  DANISH 1263
//  DUTCH 1882
//  FINNISH 3458
//  FRENCH 2322
//  GERMAN 3061
//  HEBREW 16668
//  ITALIAN 1061
//  NORWEGIAN 1063
//  POLISH 5152
//  PORTUGUESE 1502
//  RUSSIAN 3933
//  SPANISH 1199
//  SWEDISH 1922
//  CZECH 3770
//  ICELANDIC 3554
//  LATVIAN 3970
//  LITHUANIAN 3229
//  ROMANIAN 2290
//  HUNGARIAN 4997
//  ESTONIAN 3612
//  Ignore 13                         [mapped to English]
//  BULGARIAN 4362
//  CROATIAN 2379
//  SERBIAN 4261
//  TAGALOG 1543
//  TURKISH 4038
//  UKRAINIAN 7551
//  HINDI 8958
//  INDONESIAN 2285
//  MALAY 51                      [Indonesian]
//  ARABIC 16053
//  CATALAN 1226
//  SLOVENIAN 1804
//  MARATHI 131                [Hindi]
//  VIETNAMESE 2870
//  SLOVAK 2464
//  NORWEGIAN_N 64          [Norwegian]


static const int kQuadTableSize = 32768;    // Bucket count
static const int kQuadTableKeyMask = 0xffff0000;    // Mask hash key

// 422572 possible entries:
// 130982 filled (30%), 815 merged (0%), 290775 dropped (68%)
static const cld::IndirectProbBucket4 kQuadTable[kQuadTableSize] = {
  // key[4], words[4] in UTF-8
  // value[4]
  { {0xcb670001,0x6db20002,0xb5da0003,0x99dd0004}},	// [000] шате_, cław, _لبدء_, stňu
  { {0x20070005,0x23bf0006,0xbddb0007,0xdce10002}},	//   _kuni_, täjä_, stèr, _zalą
  { {0x71730003,0x11d70003,0xddc40008,0x5d3b0009}},	//   تهلا, جولة_, _križ, _בתיא
  { {0xdfcf000a,0xf989000b,0xc2c60003,0x2007000c}},	//   ويل_, ור_, _نيجي, _muni_
  { {0x2007000d,0x3ea0000e,0xd3370009,0x97570009}},	//   _luni_, áit_, _דרכה_, שינו_
  { {0xef1f000f,0x6e360010,0xb4e00011,0x6c340012}},	//   tjük_, šybo, _तरफ़_, مفتا
  { {0x3ea00013,0xdc870014,0xbc670003,0x4c940015}},	//   šit_, исъл_, لمون_, сийс
  { {0xef1f000f,0x63bb0016,0xdb0d0017,0xa5bb0018}},	//   rjük_, giun, riaç, nsór
  { {0x36670019,0xe8d9001a,0x2fc6001b,0x7f3b0009}},	//   _като_, _đỡ_, mnog_, _שעמו
  { {0x2fc6001c,0x645e001d,0x98be001e,0x63a9001f}},	//   lnog_, _oppi, egtā_, ahen
  { {0x2b9c0020,0x7528001e,0xab660021,0xc19b0009}},	//   _tích_, _iedz, _ввел, דשיי
  { {0x63a90022,0x63bb000d,0x749b0009,0x4c9b0009}},	//   chen, ciun, _שיאפ, _שבאו
  { {0x69dc0023,0xa5070024,0x6fdd0025,0x333b0009}},	//   _okre, иявл, xécu, _יתאמ
  { {0x71730003,0x92b70009,0x99d30012,0xda7b0009}},	//   _وهنا, _דפדף_, _وتوا, _שנגר
  { {0x75280026,0x8937000b,0x66160002,0x6db20002}},	//   _medz, _כרגע_, _etyk, sław
  { {0x248d0027,0x6d470028,0x7afd0029,0x2fc60027}},	//   ćem_, sgja, ľstv, jnog_
  { {0x2fc6001c,0x6d5a002a,0xafb80003,0x6b8d002b}},	// [010] dnog_, _obta, _خطوط_, rjag
  { {0x63bb000d,0x6443002c,0x7ac4002d,0x6b8d002e}},	//   ziun, yuni, істе, sjag
  { {0x6b820027,0x6563002f,0x997d0030,0x6aad0031}},	//   _onog, venh, zňů_, szaf
  { {0x63bb000d,0xa8570009,0x6d5a0032,0x02d90012}},	//   xiun, שיאה_, _abta, _موجب_
  { {0xd6ab000a,0x63a90033,0x75280034,0x98780035}},	//   خدام_, vhen, _bedz, kšķa_
  { {0x27ed0036,0x69c6000e,0xb9950012,0xaaca0011}},	//   _when_, ékel, _الآب, ापनक
  { {0x27ed0036,0xa3ae0037,0x4c920001,0x2fc60027}},	//   _then_, _कतम_, зијс, bnog_
  { {0xc052000b,0xc17e0010,0xa3d70037,0x7e6d0038}},	//   _מזל_, šėte_, ाकि_, _osap
  { {0x67290039,0x2918003a,0x63a9003b,0x1306003c}},	//   _ieej, ıran_, rhen, щный_
  { {0xd9450001,0x2475001e,0xa9690001,0xdb090028}},	//   љени, _tām_, ћина_, _ánæg
  { {0xa3d70037,0xddc4003d,0x44310034,0x3c440012}},	//   ाका_, _priž, jsz_, _وَكِ
  { {0x38780028,0x4431000e,0x60080009,0xedb20011}},	//   ærra_, dsz_, יִשְ, ुच्छ
  { {0xeab3000a,0x6601003e,0x7e6d000f,0x4431003f}},	//   _بعض_, _kilk, _csap, esz_
  { {0x201a0006,0x2fc60027,0xb21b0040,0x7bdd0041}},	//   yppi_, znog_, _kræf, _aksu
  { {0x10150003,0x4431000e,0xe4da0012,0x28cf0011}},	//   _ابتد, gsz_, اوزت_, _सुचि
  { {0xee3f0042,0x69dc0043,0x28bd0011,0x260a0011}},	//   brý_, _skre, ्पनि, ादमी_
  { {0x2fc6001c,0xa3d70044,0x44310002,0x8f1b0009}},	// [020] vnog_, ाक़_, asz_, _גופת
  { {0x0ae90003,0xe2450012,0xa5bb0018,0x44250045}},	//   شرقي_, تخفي, ssór, _owl_
  { {0x75280039,0xef1a0046,0xc209000b,0x2fc60027}},	//   _redz, гме_, תה_, tnog_
  { {0x4386000a,0xbb860003,0xa3e70037,0x7e2a0024}},	//   _الحق, _الحي, _मील_, гіка_
  { {0x65940047,0x7e56002d,0x2fc60027,0x529a0048}},	//   жалу, стец, rnog_, _съня_
  { {0x291e0028,0xd5b3000b,0xdb160028,0x2fc60049}},	//   _ýta_, ּׁה_, ábær, snog_
  { {0x3cf40037,0x40960003,0xb8960003,0x2fc60027}},	//   ेखें_, _الزر, _الزع, pnog_
  { {0x53980014,0xe644003a,0x7646004a,0xdb0d0028}},	//   рвия_, şlığ, kuky, nnað
  { {0x539b000b,0xcb670001,0x5b330012,0x314a0009}},	//   טיקו, сање_, سعير, ְתֹּ
  { {0x44310002,0xdbde004b,0x7dc60012,0x316a004c}},	//   ysz_, nţân, _اترك, ушио_
  { {0x3bd6002d,0x89db0009,0xec130012,0x1d170009}},	//   _людс, רחיי, _فولد, _הקבר_
  { {0x96f9004d,0x65ab004e,0x7bc8004f,0x478b0050}},	//   иент_, _mühe, édul, усом_
  { {0x65ab0051,0x27fc0029,0x36d50024,0xa3020011}},	//   _lühe, ívny_, іогр, लखोज_
  { {0xe5c70015,0x4431000e,0x98b8003a,0xf2370009}},	//   ссмо, tsz_, _ları_, _פרוץ_
  { {0x7995003e,0xe8d90020,0x71bb000b,0xdb0d0028}},	//   _rozw, _đủ_, _תצוג, fnað
  { {0x69c80052,0x44310053,0xb4e90011,0x67d40048}},	//   lnde, rsz_, _बरी_, _нощу
  { {0x7995003e,0x91b90014,0x4431000e,0x7e6d002c}},	// [030] _pozw, агат_, ssz_, _usap
  { {0x672f003e,0x67290051,0x64410054,0x5a340055}},	//   lacj, _seej, àlis, янут
  { {0xe719000a,0x64410056,0xe5880009,0x515b0009}},	//   ليات_, álid, _הָרָ, רכבו
  { {0xe00b0037,0x672f0002,0xcfab0012,0x22400057}},	//   _संसद_, nacj, دائم_, brik_
  { {0xdce8001e,0xed4e0001,0xfe450024,0x68080030}},	//   _radā, мо_, інко, _dědi
  { {0xd658000b,0xdb1b003a,0xb21b0058,0x63ad0059}},	//   ציות_, onuç, _præf, lhan
  { {0x672f003e,0x69da005a,0xbca50012,0x6601005b}},	//   kacj, dote, تمثي, _vilk
  { {0xdb000051,0xeb99005c,0xe3b10003,0x69c8005d}},	//   himõ, рии_, برت_, ende
  { {0xbfa80014,0x69da0051,0x672f0002,0x6609005e}},	//   _утре_, fote, dacj, _uuek
  { {0xb21b0058,0x4999004d,0x63ad002e,0x11d60012}},	//   _træf, ртия_, hhan, يوية_
  { {0xa3e90044,0x77ca0001,0x98b8003a,0x6ca70024}},	//   यता_, илог_, _yarı_, _ураж
  { {0x8b67000a,0x672f003e,0x99860002,0x22590015}},	//   _دائم, gacj, _ktoś_, _виды_
  { {0x6db20002,0x75e0000e,0xa3d80037,0xcf560009}},	//   płat, közt, िवस_, חברת_
  { {0x98a5005f,0x67c40031,0x22400060,0x867a0009}},	//   _миле, dője, vrik_, ברשו
  { {0x8fe6000a,0xdb0d0028,0xe885002d,0x98a5001e}},	//   _وأعم, tnað, _єгип, balā_
  { {0x42260014,0x7bc90061,0x63ad0062,0xc0520009}},	//   ждав, nneu, ghan, _חזה_
  { {0xa3bb0044,0xf11a0003,0x764b0052,0xda660003}},	// [040] _अगर_, لغات_, _ägyp, غاري
  { {0x65ab0051,0x42550063,0x98b80060,0x99920064}},	//   _pühe, ятст, _sarı_, kryť_
  { {0x106a0015,0xd70a003c,0x60260024,0x32270030}},	//   рией_, анее_, ідда, _čtyř_
  { {0x68e30065,0xddcd0066,0x225d0030,0x5ea60012}},	//   _mynd, _vrať, ízký_, يمال
  { {0xa3d70037,0x69c6000e,0x20070028,0xc7b30009}},	//   ाकर_, ékek, ínir_, ובא_
  { {0x672f003e,0xa2d30037,0x64410067,0x45b70024}},	//   zacj, _भुट्, šlie, огію_
  { {0x6d4a0068,0xfbaa0024,0x07a60069,0xb21b0040}},	//   rgfa, итий_, _давн, _præg
  { {0xd326002d,0x7bc90061,0x6e460003,0x63a4006a}},	//   цьки, gneu, _ونأم, nkin
  { {0xdcfe0039,0xaa66002d,0x63a4006b,0x69da006c}},	//   _kopē, ітик, ikin, tote
  { {0xb2bb000b,0x27e0006d,0x672f0002,0x69da006e}},	//   ימפר, _akin_, wacj, uote
  { {0xdb06000f,0x672f0002,0x69c80052,0x2610001a}},	//   _elké, tacj, rnde, _hào_
  { {0x2907006f,0x63a40070,0x28bd0011,0xc2760012}},	//   _egna_, jkin, ्पति, _وُضع
  { {0x672f003e,0xd250000a,0x5f940014,0x20180071}},	//   racj, _أنت_, фият, ūri_
  { {0x1dbc0011,0x63a40072,0x3e5e0035,0x98be0073}},	//   ्चित, ekin, mātā_, egtą_
  { {0x7bc00051,0x2610001a,0x2ca50074,0xe4e40024}},	//   oimu, _lào_, áld_, дітн
  { {0x52150075,0xb8e00037,0x20040076,0x7b88004c}},	//   здат, ूप_, _nimi_, ољуб_
  { {0x26100020,0xd6280001,0x3e5e001e,0xdc3c0035}},	// [050] _nào_, _доње_, nātā_, kšķe
  { {0xddc2003e,0x63a40077,0x63ad0078,0x27e60025}},	//   rtoś, akin, shan, elon_
  { {0x35f8000a,0xddc20002,0x7bc00079,0x2eed0034}},	//   _بريد_, stoś, kimu, _szef_
  { {0x7bc0007a,0xdc88000b,0x201e0010,0x2610001a}},	//   jimu, _וְשָ, ipti_, _bào_
  { {0xab5d003e,0x79a70001,0x7bc0007b,0x6b7a0009}},	//   niże, _дрве, dimu, _פרשנ
  { {0x5a34007c,0x98a5007d,0x8afa007e,0xbafa000b}},	//   _інст, nală_, _להרי, _להרש
  { {0xdd8e0003,0x96bb0011,0xf9920009,0xfd360012}},	//   اوى_, _शेरॉ, _ארם_, سكيب_
  { {0xb21b0058,0xf7730012,0xdb4e0012,0xe1ff0034}},	//   _træd, _غاز_, هَى_, _psów_
  { {0x82350012,0xa2c10011,0x76420025,0x7bc9007f}},	//   أربا, लपट्, croy, rneu
  { {0x14190003,0x314b0009,0x9c870012,0x27e00080}},	//   _هيئة_, ׁתִּ, _وشاه, _skin_
  { {0x3cdb0011,0xf6490009,0xe8e00081,0xb33b0060}},	//   _खुले_, _תצ_, riệu_, _elçi
  { {0xf7720003,0x94040003,0x3e5e001e,0xe3b30012}},	//   راج_, _قوله, bātā_, _غرض_
  { {0xd5c8001a,0xddc90082,0xa3c10037,0xdb0d005e}},	//   iền_, _mrež, ्चन_, nnaõ
  { {0x98ab0037,0x427a000b,0x98a5000d,0xdb000018}},	//   चनाए, _לאנג, gală_, rimô
  { {0x07a60001,0xc0e2002d,0xa0a50083,0x2a6d0084}},	//   _накн, _пошк, _хайд, lweb_
  { {0x883a000b,0x69c10085,0xccf20009,0xd7760012}},	//   _התקו, lile, תכל_, _رابع
  { {0xc64a0003,0xeb970086,0xfe720012,0x98a5004b}},	// [060] _اجعل_, чит_, _أدب_, bală_
  { {0x98a5000d,0xb6bb000b,0xfa490003,0xab5d0002}},	//   cală_, _לצפי, تشفى_, roży
  { {0x859b000b,0xa0670014,0x69c6000e,0x759b0009}},	//   _השיו, заха_, ékei, _הייח
  { {0x2d9a0087,0xb21b0040,0xab5d0034,0x7bc00088}},	//   _hope_, _dræb, poży, ximu
  { {0x67220039,0x7bc0007a,0x69c10089,0xc7b3000b}},	//   rboj, vimu, kile, עבד_
  { {0x2610008a,0x6d5c008b,0x63ab0051,0x865b000b}},	//   _vào_, nfra, _algn, מדני
  { {0x69c1008c,0x7bc0008d,0x661b008e,0x2918008f}},	//   dile, timu, _etuk, _ifra_
  { {0xdb000006,0xa857000b,0x3057000b,0x34370003}},	//   yhmä, _מילה_, _משלך_, أسود_
  { {0xadc3008a,0xb21b0040,0x7bc00090,0x69c1005b}},	//   _quản, _træe, rimu, file
  { {0x69c10091,0x7bc00092,0x361b0009,0x9aeb0009}},	//   gile, simu, _לומד, מַיִ
  { {0xf9930093,0x30a30014,0x660d0010,0xc057002d}},	//   תרת_, еряв, _suak, пія_
  { {0x65b0004a,0x201e0010,0xeb970094,0xd36f0012}},	//   _lähd, rpti_, _них_, _مهم_
  { {0x98a5000d,0x8ae3002d,0x69c10095,0x82330012}},	//   tală_, _пішл, bile, _كروا
  { {0x65b00006,0xceb3000b,0xaa3b000b,0x29d30012}},	//   _nähd, גיש_, _פתוח, _كينس
  { {0xd5c80020,0x515b000b,0x98a5000d,0x415b0009}},	//   yền_, _הכוו, rală_, _הדוג
  { {0x6d4e002c,0x443f0096,0x6d5c0097,0xc1780073}},	//   agba, ču_, afra, ldė_
  { {0xc73c000b,0x98a5000d,0xe2f8002d,0x6d5c0052}},	// [070] _התחת, pală_, зеті_, bfra
  { {0x5c070098,0x67d2001e,0xc1780073,0x7ae60099}},	//   _няма, māja, ndė_, _dykt
  { {0x3ea6001e,0x8014002d,0x661b009a,0x8f990012}},	//   _ļoti_, ефіц, _stuk, ينئذ_
  { {0x6443009b,0x69c1009c,0xa7140024,0x60f80024}},	//   vrni, zile, емці, їнця_
  { {0xee38002d,0x69c1003a,0x4b7a0009,0x6ee70012}},	//   зні_, yile, _וארו, أسال
  { {0xe6780009,0x8d540048,0x7bdf009d,0xddd6009e}},	//   פתוח_, етъч, loqu, _kryš
  { {0x6458009f,0x644300a0,0x05740012,0x24f70009}},	//   gtvi, urni, عاهد, הֶ֗ם_
  { {0x98a50010,0x67d2001e,0xe3b10012,0xa2c20011}},	//   nalą_, kāja, ضرب_, _रेड्
  { {0x64580071,0x75e0000e,0xd24e0012,0x28bd0011}},	//   atvi, közp, لني_, ्पवि
  { {0x67d2001e,0x81f60003,0xd0590024,0xeeeb0081}},	//   dāja, وفير_, ормі_, ýờng_
  { {0x69c100a1,0xe3c200a2,0xc948000b,0x4b550014}},	//   rile, lmış_, הֲרֹ, _жълт
  { {0x69c100a3,0x907a0009,0xcb690012,0x207a0009}},	//   sile, קטרי, _ذمته_, קארא
  { {0xe3c200a2,0x65b000a4,0x2d9a00a5,0xb9b50048}},	//   nmış_, _lähe, _pope_, _оскъ
  { {0x65ab0051,0x9c7c009b,0x90c500a6,0x8afa0009}},	//   _püha, _izčr, _обле, _והני
  { {0x6d5c00a7,0x66030015,0xed570014,0x65b000a8}},	//   rfra, тпра, ьор_, _nähe
  { {0x25b40010,0x6c070003,0x67d2001e,0x5ea60012}},	//   _šalį_, ِيِّ_, bāja, _يمثل
  { {0x69de00a9,0x8f8b0009,0xd5b20012,0x550d0011}},	// [080] tope, _וְיֵ, _لفظ_, िखाए_
  { {0x31a4000e,0x65ab0032,0x7bcd00aa,0xb14300ab}},	//   _közi_, _hühn, anau, кнул
  { {0xb21b0058,0x8b26004c,0x65ab0032,0x98a50073}},	//   _præc, _одне, _kühn, balą_
  { {0xdfd20003,0x201c001e,0x46ea00ac,0xa3e90011}},	//   خيص_, īvi_, оден_, यतः_
  { {0x65b0004a,0xaff70012,0x42d60024,0xfe6f0012}},	//   _tähd, ذفها_, _ціну, لدو_
  { {0x645800ad,0x644a0032,0xaac500ae,0xd6e900af}},	//   ttvi, tufi, _ستُن, הַצָ
  { {0x91030015,0x84380003,0x70560012,0x645800b0}},	//   _апре, أكبر_, _تنزا, utvi
  { {0xda080020,0x8aa6002d,0x69cf0061,0xc2740001}},	//   _hỏi_, дрод, écen, елиј
  { {0x026a0024,0xd7570012,0x200e00b1,0x870b0009}},	//   іший_, _تلقت_, _sufi_, _וּבֶ
  { {0xb5aa0003,0x67d2001e,0x5e9b000b,0x6e9b0009}},	//   _بارك_, vāja, _ובמק, _ובמח
  { {0xc1780010,0x76400028,0x65ab0032,0xda080081}},	//   rdė_, ámyn, _bühn, _mỏi_
  { {0x67d2001e,0xdce50029,0xd5c80081,0x73360012}},	//   tāja, _pohľ, iềm_, _آرائ
  { {0x69cb000e,0x7bdf00b2,0xc3fb0009,0xabfb0009}},	//   égek, voqu, _ולאש, _והאר
  { {0x2907007a,0x58d400b3,0x6c1b0012,0xdcfa0035}},	//   žnai_, _полт, قترح_, _notī
  { {0x7bcd0010,0x7c380070,0xab5d0034,0xe3c20060}},	//   tnau, nsvr, liża, zmış_
  { {0x628200b4,0xcc770009,0x62090012,0x466b00b5}},	//   _kroo, וגלת_, كْرِ_, _дром_
  { {0x2aab002d,0xdee70003,0xa3d60011,0x62340024}},	// [090] цтво_, _تأثي, _सदन_, кету
  { {0xd1310003,0xf9930003,0x51f8003c,0x30eb0048}},	//   اما_, خبر_, дную_, офен_
  { {0x200900b6,0x1dd80012,0x7bdf00b7,0x753500b8}},	//   _kiai_, _تبيع_, poqu, mazz
  { {0x65b000b9,0xa295002d,0xa635002d,0x753500ba}},	//   _vähe, _замі, енді, lazz
  { {0x59de0044,0x799c002a,0xdf360012,0xcfb80009}},	//   नकार, _forw, ركوت_, ולאי_
  { {0x65b00005,0xba430010,0xc58b0015,0x6234004c}},	//   _tähe, žįst, ющее_, _јеру
  { {0x645c0051,0xc01c001a,0x98140012,0x753500b8}},	//   _äril, rước_, _لبقا, iazz
  { {0x6aca0037,0x58050003,0xe3c2003a,0xf3f10012}},	//   ापूर, _أورك, pmış_, دأت_
  { {0xeab10003,0xc9550015,0x99580030,0xc6740012}},	//   طعة_, нтны, láři_, _لطلب
  { {0xf991000a,0x69c50065,0x7c3a0010,0xe5c400bb}},	//   ابة_, nihe, štri, _исхо
  { {0xfc30000a,0xa3c10044,0xdb510003,0xf992000b}},	//   _نحن_, ्चा_, _مَا_, ארי_
  { {0xd7760003,0xbb840012,0x43840012,0x24860064}},	//   راجع, _للمي, _للمق, _čom_
  { {0xee3700bc,0x23ae0065,0x628200bd,0xa68300be}},	//   ння_, _nýja_, _groo, гляд
  { {0xceb200bf,0xf9c700c0,0x753500c1,0x68020035}},	//   נים_, _ющен, gazz, _jēdz
  { {0x61d6000b,0xdb0b0061,0xab62005e,0x99580030}},	//   _אוסף_, _algé, üügi, jáři_
  { {0xebe3002d,0x2009001a,0xddcd0010,0x61e1008e}},	//   госп, _giai_, _graž, loll
  { {0xe8df0020,0x661c009b,0x65ab0052,0x86c60012}},	// [0a0] _khỏi_, _črko, _kühl, _سيدن
  { {0x61e100c2,0x63a900c3,0x99e900af,0x000000c4}},	//   noll, hken, פַּ֥,
  { {0x7c960003,0x799c0052,0x25a5004a,0x6dc50012}},	//   _أشخا, _vorw, ölle_, _جزيل
  { {0x1bba0003,0x38780028,0x644e001e,0xf4f3002d}},	//   _راجع_, ærri_, mubi, _якiй_
  { {0x63a900c5,0x539b000b,0xdfcf0003,0x92b60012}},	//   dken, _זיכו, حين_, _أحجا
  { {0x6b8b00c6,0xb21b0058,0x63a900c7,0x645c004b}},	//   _angg, _kræn, eken, otri
  { {0x61e1004a,0x186700ac,0x443a000e,0xb1980081}},	//   doll, _пари_, ép_, _nhưỡ
  { {0x628200c8,0x645c00c9,0x67d20035,0xf4130009}},	//   _proo, _ärim, dājo, נפח_
  { {0x645c00ca,0x81c60048,0xa3ae0011,0x1af40048}},	//   htri, ещне, _कतई_, ъпия
  { {0x7abb000b,0x6b8b00b6,0xf6090012,0xd2570009}},	//   פציו, _engg, _قتله_, עשיה_
  { {0xd8f8007c,0xf1b30093,0xdd8f0003,0x69cb000e}},	//   ьної_, רסת_, _دول_, égei
  { {0xd4690003,0xd379002d,0x628200cb,0xb4be0011}},	//   _تحكم_, _очі_, _troo, ीपी_
  { {0x65ab0052,0x21ef0052,0x69c60031,0x657a00cc}},	//   _fühl, fühl_, ékes, _kath
  { {0xb8940003,0x645c0052,0x40940003,0x67d200cd}},	//   _للتع, ftri, _للتر, bājo
  { {0xddcd001c,0xa4d4002d,0x94d40001,0xf9930009}},	//   _traž, горі, горц, _תרצ_
  { {0x657a002c,0x2d9e00ce,0x61fe00cf,0x995800d0}},	//   _lath, _lote_, empl, váři_
  { {0x3df50098,0x71790046,0x2d8c00d1,0xef640014}},	// [0b0] _изис, мбар_, _onde_, _също
  { {0xc4b00011,0xd944004c,0x77a60018,0x3eb30060}},	//   जनाओ, леђи, _róxi, ıntı_
  { {0xb21b00d2,0x764f0034,0x71d70009,0x03f9004c}},	//   _græn, lucy, עובד_, _оној_
  { {0x07a40024,0xc43a0009,0x2eab0009,0x2d8c00d3}},	//   лаєн, _קתרי, ּשַּ, _ande_
  { {0x8b9a000b,0xf6530003,0x99580066,0x64c90037}},	//   _חברת, ائص_, sáři_, िप्श
  { {0x6594002d,0x7bc200d4,0xdd9b0048,0x657a00d5}},	//   лачу, _amou, яше_, _cath
  { {0xabd50046,0x69cf0061,0x10480015,0xa7150024}},	//   кциј, écem, _пяти_, _амбі
  { {0xc1780010,0x68e30052,0x2d8c00d6,0xe4c80012}},	//   klės_, ündu, _ende_, عبون_
  { {0x657a0036,0x853c0010,0x7d08000e,0x7e2b002d}},	//   _fath, _plėt, _kérü, _хіба_
  { {0x92640003,0x36040003,0x657a00d7,0x63a900d8}},	//   اديم, _موقف, _gath, sken
  { {0xb6040066,0x65b0005e,0x644100d9,0xddcd0034}},	//   ntář, _näha, álil, _draż
  { {0x61e1004a,0x2ca70028,0x6b8b00b6,0xdce80030}},	//   soll, mynd_, _ungg, _ladě
  { {0x31a4000e,0xd5b7001a,0xab5d0002,0x442100da}},	//   _közt_, ắng_, liżo, _ath_
  { {0x614500db,0x88c50012,0xd9450048,0xdce80030}},	//   _река, _لتعل, _реки, _nadě
  { {0xb0240020,0xc5f8001e,0xfce600dc,0x84ac0009}},	//   _trườ, ķē_, тово, ִימִ
  { {0x2c7c0066,0xc6d60012,0x645c00dd,0x1e86003c}},	//   ládá_, _لتخت, rtri, _алим
  { {0xc3320093,0x3ce80037,0x7f77000b,0x715a00de}},	// [0c0] יון_, _चुने_, _יעקב_, дрес_
  { {0x7aeb007a,0x3f8d0054,0xa96a0003,0xadfa0012}},	//   _mygt, _aneu_, ظمام_, _تربط_
  { {0x20330003,0xdd05000d,0x2d9e00df,0x657a00e0}},	//   لفلس, ăsăt, _rote_, _rath
  { {0xdce80026,0x6d41003a,0xe3b8003a,0x62840010}},	//   _podľ, _adla, _atın_, _šiom
  { {0x6eb60012,0x66730012,0xdee3004c,0xfecd0009}},	//   خصائ, لدور, аоци, ּמוּ
  { {0x2fc6007a,0x7c3a0029,0xd1320003,0x645c0051}},	//   siog_, štru, _خمس_, _ärik
  { {0x6da30046,0xd4670001,0x6aca0037,0x2ca70058}},	//   рија, вије_, ाप्र, gynd_
  { {0x07a30046,0x50db000b,0xc4d3000b,0xe76a0003}},	//   _касн, _חקלא, יגו_, _تحسن_
  { {0xa6650003,0xcb670001,0x2d9e00e1,0x7fd50024}},	//   _مطلو, тање_, _tote_, _сірі
  { {0x2d8c007d,0x601e0039,0xd5fb0081,0xf426008e}},	//   _unde_, _līme, _trú, öäsi_
  { {0x3137000b,0x9f35002d,0x89370009,0x5c56004c}},	//   כנים_, лені, כריע_, _штаф
  { {0x69c300e2,0xddcd0002,0x6c570009,0x07e40024}},	//   _emne, _wraż, _ייבא_, ицям
  { {0xf773000b,0xcb67004c,0x7c220064,0xaab70012}},	//   בקר_, _јаче_, _čora, _لدور_
  { {0xdcf5001e,0xa382005e,0xc2370009,0xdbd10097}},	//   edzā, öõnn, _ירדו_, lýðs
  { {0xd5b800e3,0xb4ad0037,0x98a30001,0xdce80066}},	//   тся_, कने_, _вије, _radě
  { {0x9cd7000b,0x6bd40012,0x88bc0030,0x21ef005e}},	//   דולה_, لتقر, yběj, rühm_
  { {0x6284007a,0x69c8004a,0x27e900b6,0xdd910012}},	// [0d0] _šioj, oide, _ikan_, _هوة_
  { {0x4a5b000b,0x645a0054,0x69c800e4,0x61150024}},	//   ודמו, àtic, nide, уджу
  { {0x98140003,0xc1e80015,0x290700e5,0x69c800e6}},	//   لبنا, тьте_, äna_, iide
  { {0x69c800e7,0x224900e8,0xa8ab0009,0xb5fb00e9}},	//   hide, prak_, וֹדִ, stád
  { {0x69c800ea,0x3f810066,0xb3ba0009,0xf7740009}},	//   kide, ěhu_, _נמשכ, יקף_
  { {0x27310020,0x601e001e,0x8e08002d,0x6d550070}},	//   ạn_, _zīme, внів_, ngza
  { {0x25a10066,0xe8940015,0x61e50042,0xf1b20009}},	//   _mohl_, _карь, mohl, _פסל_
  { {0x99840010,0xdb090017,0xdddb00eb,0xb8f70011}},	//   ksmų_, nheç, _druš, ाप_
  { {0x443e0058,0xdce1001e,0x38780002,0x11e50048}},	//   _evt_, _palē, _zsrr_, лжим
  { {0x27e900ec,0x63ad00ed,0x6d410040,0x67f80064}},	//   _akan_, hkan, _udla, ríje
  { {0x65ab0051,0x07a600b3,0x63ad00ee,0x8fa600ef}},	//   _tühj, ганн, kkan, гане
  { {0xa5bb0002,0x63ad00f0,0xebd90048,0xa8a80009}},	//   spól, jkan, _ядеш_, דֹשִ
  { {0x200d00c1,0xdddb00f1,0xe1ee0015,0xe7f60011}},	//   _miei_, _zruš, _гг_, ेषता_
  { {0x23a70051,0xcc120037,0x26190081,0x6abb0032}},	//   _mõju_, _ढूँढ_, _mèo_, mzuf
  { {0x225f000e,0x74160012,0x98ac004b,0x443e00f2}},	//   ltuk_, اورا, radă_, ét_
  { {0xa6960046,0xc0520093,0x7bc900f3,0xd1380010}},	//   _број, _הזה_, nieu, _žą_
  { {0x225f00c6,0x6abb0052,0xdd04003a,0x98ac004b}},	// [0e0] ntuk_, nzuf, ırıs, padă_
  { {0x6e24003a,0x11da0003,0x5ebb0009,0x65b00032}},	//   _itib, روضة_, _נזיק, _zähn
  { {0x601e0039,0x11d70003,0x9c7c0010,0x64a600f4}},	//   _tīme, دولة_, _tyči, _сана
  { {0xaf360003,0xe29a0014,0xcf260012,0xd00f0012}},	//   ارات, _зам_, ارضي, سله_
  { {0x657e000e,0x4733002d,0xe5c600f5,0x97570009}},	//   _kaph, сніс, лско, רינו_
  { {0x225f000f,0x8b080066,0x69cb0031,0x3eb20035}},	//   dtuk_, apří, éget, _čatā_
  { {0xbcaa0003,0x8078000b,0xf8780009,0x90780009}},	//   عدتك_, _בְּה, _בְּל, _בְּפ
  { {0xafe60015,0xbc670003,0x7bc900f6,0x69c800f7}},	//   _собл, امين_, gieu, wide
  { {0x0d560003,0x69c800f8,0x85560012,0xb5fb00f9}},	//   _مخاد, tide, _مخاط, ntác
  { {0x104a00fa,0x63ad009b,0x27e600fb,0xd6cf0012}},	//   нями_, zkan, loon_, _عقل_
  { {0xbca60003,0x2a600051,0xa2cb0011,0x0c2600fc}},	//   _حماي, htib_, _सेन्, _смен
  { {0x64410039,0x8c1b000b,0x7bc90061,0x27e600fd}},	//   šlik, _נודי, cieu, noon_
  { {0x78ba000f,0x88bc0066,0xb8eb0011,0x69c800fe}},	//   sztv, zběh, _रे_, pide
  { {0x63a20051,0x99840010,0x3eb90060,0x98a70073}},	//   _hoon, rsmų_, _üste_, _seną_
  { {0x24190015,0x27e6004a,0x63a200ff,0x89370009}},	//   тобы_, koon_, _koon, _גרוע_
  { {0x63a20051,0x25a10052,0x68f50100,0x67f60029}},	//   _joon, _wohl_, üzde, pája
  { {0x65ab0051,0x1a5b0012,0xa2940024,0xc9870086}},	// [0f0] _lühi, عشرة_, баті, лужи
  { {0x7e6d0101,0x2bc60037,0x60d3001e,0xb5fb000e}},	//   _ipap, रोबा, ņemš, stáb
  { {0x27e60070,0x61e50066,0x225f0102,0x3f150103}},	//   foon_, rohl, ztuk_, адес
  { {0xa857000b,0xbddb0061,0xd5b60001,0xd5c8001a}},	//   ריאה_, ssèd, cикл, iều_
  { {0x69cb000e,0xbb3a007e,0x433a0009,0xef180024}},	//   éges, _בערי, _בערב, умі_
  { {0xdcfa00a2,0xdca50104,0xce380009,0x75ed0031}},	//   _altı, иали, נאות_, húzv
  { {0x9f420042,0xbd180024,0x6b9b0032,0x63a20105}},	//   soké_, уції_, tjug, _boon
  { {0x225f000e,0x8a950003,0x747c0009,0xdb040031}},	//   ttuk_, لشخص, תנהג, lkiá
  { {0x7bc90106,0x6d450107,0xdfd80048,0xc7b20009}},	//   rieu, _odha, _сър_, _ובן_
  { {0x7bc90108,0x79c5002d,0xd9450001,0x89a9004d}},	//   sieu, рйоз, јени, тков_
  { {0x229a007a,0x40490014,0xe8f60109,0x7e6d010a}},	//   ešką_, ъпно_, иль_, _apap
  { {0x6d45000e,0x225f000e,0x6283001e,0xe73a0015}},	//   _adha, ptuk_, ānoj, ъем_
  { {0x2bb8000a,0x67d2001e,0x8f9a0009,0x69c7001b}},	//   _حالة_, nāji, דירי, _omje
  { {0xc9870001,0xb2ba0009,0x057a0012,0x69dd0031}},	//   _људи, _שמסר, خمسة_, ésed
  { {0x80880012,0x80e90011,0x2d840030,0x99610035}},	//   _مضيف_, _ऑडिओ_, ěme_, tīņu_
  { {0x65b00052,0x67d2001e,0xb21b0040,0xd8da0009}},	//   _zähl, kāji, _græk, _בקצר
  { {0x9a25000a,0xfd120003,0x42230014,0xd2a7010b}},	// [100] معلن, _وجد_, ждув, акте_
  { {0x1e3b0093,0x64410066,0x27e60070,0xc0460003}},	//   _שגיא, _ovli, woon_, لخصو
  { {0x7e7b007d,0xa3e50037,0xe73a010c,0x27e6010d}},	//   _asup, पका_, вее_, toon_
  { {0x78a30006,0xd823002d,0x753c0002,0x60230024}},	//   änva, ідчи, larz, ідча
  { {0x27e6010e,0xee770003,0x7e7b000e,0x6d410028}},	//   roon_, لصوت_, _csup, ðlag
  { {0x224d005e,0x753c010f,0x644e0110,0xef1f0060}},	//   drek_, narz, orbi, zcü_
  { {0xb7960001,0x9423004c,0x9b440012,0x27e60111}},	//   _краћ, омје, منغو, poon_
  { {0xafe3007c,0x67d2001e,0x5a340048,0xfba7003c}},	//   _досл, bāji, бнит, итый_
  { {0xfbb7000b,0xe57a0001,0x753c0112,0xf6690012}},	//   יפקת_, _иза_, karz, _محله_
  { {0x20180113,0x65ab0051,0x2bc60037,0x63a20070}},	//   _kuri_, _tühi, रोता, _woon
  { {0x753c003e,0x63a20114,0x09f70009,0xd1170009}},	//   darz, _toon, שמים_, יקיה_
  { {0x65b0008b,0xdddb0002,0x22400115,0x3f800017}},	//   _wähl, _opuś, ksik_, _caiu_
  { {0x95cb0014,0x539b000b,0x644e0116,0x3bbb0009}},	//   вува_, _שידו, erbi, _במאד
  { {0x95cb0001,0x2735001a,0x67030037,0x0dcb0001}},	//   тума_, ấn_, रेषक_, туми_
  { {0xab950046,0x51fb000b,0xb21b0058,0xd1380002}},	//   бављ, _שהוצ, _træk, ając_
  { {0x69c7001c,0xbf350014,0xc2c50012,0x7e620117}},	//   _smje, _унищ, ميزي, ktop
  { {0x2bc60011,0x33770009,0xb062008e,0xa7fd0060}},	// [110] रोधा, סתמך_, äänl, atıc
  { {0xdce1007a,0xa6db0028,0xdcb1001a,0x673d0118}},	//   _galė, taðf, ở_, lasj
  { {0xcd76000b,0x4dda000b,0xa34c0010,0x4ddc0009}},	//   _העתק_, _תחתו, dėžė_, _בחזו
  { {0x9f05000a,0x67d20039,0x673d0119,0x33950003}},	//   موضو, tāji, nasj, _الحز
  { {0x2d810051,0x7bcd0010,0x6455011a,0xe7580024}},	//   _kahe_, miau, luzi, ричі_
  { {0x85e8002d,0x69c70027,0x7bcd0010,0xbddb0061}},	//   адів_, _umje, liau, crèt
  { {0x23b1000f,0xb5b8000b,0x673d011b,0x2db80009}},	//   _fájl_, שלוח_, kasj, שלון_
  { {0xdd3a000d,0x2d810051,0x7bcd011c,0x9cd80009}},	//   păşi, _lahe_, niau, יווה_
  { {0x6575000e,0xcbc40012,0x27ed0060,0x46150012}},	//   kezh, تزوي, _iken_, _طوار
  { {0x2d810052,0xd9f90037,0x3f800017,0xb5fd0010}},	//   _nahe_, ्गित_, _saiu_, _apšv
  { {0xe73a0104,0x7bcd0010,0x600a011d,0x65750031}},	//   лен_, kiau, лном_, dezh
  { {0x673d011e,0x753c0112,0x22400052,0xa4f60009}},	//   gasj, warz, ysik_, _הצעד_
  { {0x73c40003,0xa969011f,0x2169011f,0x753c0120}},	//   _بينم, _била_, _били_, tarz
  { {0x64a6002d,0x41260014,0xf77f0017,0x6575000e}},	//   бага, _лошо_, boço_, gezh
  { {0xa34a0014,0x645c0051,0x27ed0121,0x01360009}},	//   лзва_, _ärit, _oken_, _הרצת_
  { {0xd4670001,0x7bcd0010,0x7395002d,0x753c0002}},	//   љите_, giau, ошує, sarz
  { {0x1757000b,0x20180122,0x11da0012,0x63bb0032}},	// [120] _הספר_, _suri_, هورة_, ihun
  { {0x645500c1,0x25a5006f,0x2c610123,0xbdfa0012}},	//   buzi, _noll_, kód_, _حربا_
  { {0x6c86000a,0x645500c1,0xddd60010,0x7bcd0010}},	//   _الجم, cuzi, _kryž, biau
  { {0xb73a0003,0xe7e9002d,0xa3bc0037,0xb5fb0124}},	//   اثاء_, афік_, _अति_, ntán
  { {0x66e6002d,0x444400ff,0x67630003,0xd7ef0012}},	//   щода, _hv_, سُول, ركه_
  { {0x2018007a,0x62830002,0x63bb0052,0x6b840125}},	//   _turi_, łnoc, ehun, ldig
  { {0x29cf001e,0x7e620126,0x628b0127,0x5c740024}},	//   aļas_, stop, _argo, ілит
  { {0xdce30066,0x2bba0012,0xe44f0012,0xb8cc0011}},	//   leně, طاعة_, رضى_, गह_
  { {0xd130000a,0x67d20039,0x2a9a0012,0x6b840128}},	//   ومة_, nāju, ائعة_, idig
  { {0x361b000b,0x7c2a0033,0x1543010c,0x7bde0025}},	//   _עובד, ppfr, _неум, épub
  { {0x673d0119,0xc19b000b,0x9f990129,0x1f7500de}},	//   tasj, אשיי, авну_, олня
  { {0xf8b30093,0x753a0070,0x63bb012a,0x61e8012b}},	//   פשר_, _hetz, chun, sodl
  { {0x4444012c,0x673d012d,0xcaf60012,0x67d20035}},	//   _av_, rasj, _اساب, jāju
  { {0xb21b00c5,0x753a0052,0x645c0051,0x67d2001e}},	//   _kræv, _jetz, _äris, dāju
  { {0xb062004a,0x2d81005e,0xe0d3004c,0x65750031}},	//   ääll, _vahe_, _ношњ, rezh
  { {0xddc4012e,0x753a008b,0x645500c1,0xccab0009}},	//   _vpiš, _letz, ruzi, אֱמֹ
  { {0x7bcd012f,0x67d2001e,0xc2090012,0x2d81005e}},	// [130] riau, tājv, لقرن_, _tahe_
  { {0x753a008b,0x26360002,0x79c80003,0x7bcd0010}},	//   _netz, dło_, موقف_, siau
  { {0xddc40027,0x90d5001a,0x72040012,0x26360034}},	//   _upiš, hàn, أولم, eło_
  { {0x25a5008b,0x6fd4002d,0x18770009,0xd6d10012}},	//   _soll_, пціє, מעבר_, وقا_
  { {0x9599007c,0xb5fd001c,0x67d2001e,0x2c610002}},	//   итку_, _opšt, cāju, wód_
  { {0x5e58000b,0x2bb10037,0x98ac0002,0x7afd0130}},	//   מידע_, जस्थ, sadę_, _izst
  { {0x65b00006,0x4c920001,0x79950052,0x25a50052}},	//   _sähk, дијс, _inzw, _voll_
  { {0x5bc50003,0x2c610002,0x27ed0033,0xa0240052}},	//   تقبل, ród_, _uken_, stöß
  { {0x6025007a,0x25a50131,0x49990024,0xb21b0040}},	//   _dėme, _toll_, атня_, _usæd
  { {0xfc330003,0xc5fb0012,0xdb1d0097,0x65ab0032}},	//   _فحص_, _إعرض_, _umsæ, _mühs
  { {0xc9520093,0xf7720012,0x6faa0012,0x32050132}},	//   ומי_, واح_, لهدف_, rmly_
  { {0xe3b3000a,0x661b0006,0x628b0133,0x22950012}},	//   _عرض_, _kuuk, _trgo, _ولاس
  { {0x6443006f,0x645c0051,0x333f0061,0x69cf0061}},	//   lsni, _ärir, maux_, éces
  { {0x67d20039,0x98ac0030,0xb5fb0134,0x75d60012}},	//   vāju, nadě_, stán, زيزا
  { {0x70520003,0xb97a000b,0xb4b40037,0x833a010c}},	//   _قنوا, _כנסי, झने_, ичат_
  { {0x67d20039,0x0457000a,0x333f0061,0x6b840070}},	//   tāju, تلفة_, naux_, udig
  { {0x9f5f001a,0x49ca0001,0xba290003,0x65b00038}},	// [140] _thuê_, алан_, مسلم_, _lähi
  { {0xa7fd003a,0xb5fb0135,0x3ce00060,0xe0d20012}},	//   ntın, ntál, şivi_, وزا_
  { {0xdce10039,0x67d2001e,0x3e64004a,0xef1a0136}},	//   _dalī, sāju, löt_, аме_
  { {0xf1bf000f,0x753a0052,0x69c6000e,0xb4fb0009}},	//   _után_, _setz, ékez, _כפיי
  { {0x64410026,0x60250010,0x96b70001,0x3e640137}},	//   šlit, _rėme, жују_, nöt_
  { {0x27380020,0xd639002d,0xc7b9000e,0x64430058}},	//   ẩn_, сяці_, _elő_, fsni
  { {0x2636003e,0xe73a0138,0x64430139,0x2918013a}},	//   sło_, _веб_, gsni, _igra_
  { {0x6fb60003,0x79830070,0x8c1b000b,0xdee6013b}},	//   _بمرا, _aanw, סופי, _доби
  { {0xd6250003,0x6443013c,0xf1aa0012,0xdfcf0012}},	//   _فعلي, asni, لاده_, _شيك_
  { {0x36fe0037,0x6d480058,0x65b00052,0x62840010}},	//   रेज़ी_, _udda, _fähi, _šios
  { {0xdfd10003,0x69dd0061,0x3f84013d,0x7c28013e}},	//   فيد_, ésea, _kamu_, _utdr
  { {0xc7c7002d,0x442e0052,0xd7f9000d,0x333f0061}},	//   існи, mpf_, ptăm_, caux_
  { {0x22940014,0x8d770012,0xb9c60012,0x9f4e0031}},	//   _хиля, ياسا, _وتته, ónál_
  { {0x69ca00a7,0x64580066,0x6d5c013f,0xa6db0097}},	//   _umfe, ouvi, ggra, taðb
  { {0x6021001e,0x2ba70001,0x93970012,0x43950024}},	//   _tēma, ојав, يجرا, павс
  { {0xcfe90003,0xdce1001e,0x3f85001e,0xc053000b}},	//   _دفعه_, _salī, ēlus_, _חזק_
  { {0xdce10039,0x23ae0065,0x1ddb0037,0x201c0051}},	// [150] _palī, _nýju_, _बदलत, _huvi_
  { {0x644300e2,0x69da0140,0x6458004a,0xdce70034}},	//   ysni, nnte, kuvi, zeję
  { {0x6e29007a,0x65ab008b,0x7d7a000b,0xe7190003}},	//   _steb, _führ, _הנתו, ميات_
  { {0x69da0052,0x6443013f,0x547a0009,0xa3af0011}},	//   hnte, vsni, _פטרו, _कवि_
  { {0x7afd0039,0x333f0061,0x539a000b,0xcb9a000b}},	//   _uzst, vaux_, _הירו, _הסרט
  { {0xd658000b,0xae7c000b,0x3d190037,0x0dc8002d}},	//   קיות_, שְׁת, _दलों_, олій_
  { {0x9f35002d,0xe3b10003,0x333f0061,0x8cd10037}},	//   _неві, فرة_, taux_, _डेमो
  { {0x65b00006,0x6e380028,0x69da0141,0xeb99004d}},	//   _vähi, ðabú, ente, сии_
  { {0x333f0061,0x64430142,0x98ac0066,0x798300b6}},	//   raux_, ssni, padě_, _panw
  { {0x6443007a,0x65b00051,0x7abc000b,0x5ce50012}},	//   psni, _tähi, יצחו, _فكذل
  { {0xb5fb000e,0x645c0051,0xa7fd003a,0x79830070}},	//   rtál, _ärip, rtın, _vanw
  { {0xb4fa000b,0x2d850143,0x34fa0009,0x3e64008e}},	//   _הפעי, _hale_, _ההעד, töt_
  { {0x19950014,0xa2cb0011,0x65ab0032,0xa7fd0060}},	//   _надя, _सेल्, _rühr, ptın
  { {0xa7fd003a,0x67d2001e,0x2d870144,0xd1840024}},	//   ltıl, tājs, ndne_, _олій
  { {0x9f920145,0x3e64004a,0x64a60146,0x291c0029}},	//   lší_, söt_, чава, ázať_
  { {0xa7fd00a2,0x22520058,0xa5bb0028,0x42260104}},	//   ntıl, tryk_, fpós, здав
  { {0x6e46000a,0x27e000b6,0xab5d0002,0x9f9200d9}},	// [160] _عندم, _ijin_, liżs, nší_
  { {0xb4660147,0x67f80064,0x9f920030,0x48e60148}},	//   _екол, ríjm, iší_, позв
  { {0xe1ff0149,0xab5d003e,0x41dd0011,0x7d7b0009}},	//   _após_, niżs, _मदरस, _פנטו
  { {0x3f860066,0xa6db0028,0x78720028,0x20550055}},	//   udou_, laða, _aðvö, ьтур
  { {0x9f92014a,0x9b170009,0x69da014b,0x3f86014c}},	//   jší_, _מחכה_, ynte, rdou_
  { {0xa6db014d,0x63b60065,0x8afb000b,0x2d85000d}},	//   naða, lkyn, _להכי, _cale_
  { {0x69ce002c,0x3f8400b6,0x8c960024,0x986c0035}},	//   _imbe, _tamu_, ярді, rķēt_
  { {0x69dd0108,0x7d07014e,0xb21b014f,0x50db0009}},	//   ésen, léré, _græs, _הקלא
  { {0xc9860046,0x539b007e,0xa6db0097,0x201c0150}},	//   пуни, מיקו, kaða, _suvi_
  { {0xdebb000b,0x7d070061,0xa7fd003a,0x2d850151}},	//   _הממל, néré, atıl, _gale_
  { {0xf993000b,0x9f920066,0x601e001e,0x69da0152}},	//   גרת_, aší_, _zīmj, rnte
  { {0x60280066,0xc0530009,0x09b90011,0x3cfb0009}},	//   _něme, עזר_, _इत्य, _פלאנ
  { {0xa6db0028,0xc7b30009,0x63b60030,0x69ce0153}},	//   faða, גבר_, dkyn, _ombe
  { {0x7afd0154,0xca970009,0xa6db0097,0xc27b0009}},	//   üste, _מדדי_, gaða, _לרדי
  { {0x7d070061,0x9f420042,0xe1ff0034,0x14180012}},	//   déré, soká_, _opór_, كيّة_
  { {0xa3bc0044,0x69ce0155,0xf8db0009,0xd8db0009}},	//   _अतः_, _ambe, _לחומ, _לקור
  { {0xdcf2001e,0x7d070156,0xda780024,0x52150024}},	// [170] īgāk, féré, зях_, ддат
  { {0xa5bb0028,0xdebc0009,0x76bc0009,0xbef80012}},	//   rpós, _למחל, _למחפ, _عريض_
  { {0x7bdb0002,0xb21b0058,0xdcee000d,0xd91b0009}},	//   ynuu, _præs, rebă, צואל
  { {0x256f003a,0x69ce0157,0x2d850158,0xa8570009}},	//   zılı_, _embe, _sale_, ליבה_
  { {0xeafa0037,0x442c0066,0x256f0060,0x64480159}},	//   ्धृत_, _atd_, yılı_, _avdi
  { {0xcb12015a,0x93b50020,0x9f920004,0x929a0009}},	//   _שלך_, _cũn, vší_, _וישת
  { {0x6da20014,0xc1720009,0x201c0030,0x6592004c}},	//   тища, _שחל_, ívit_, тају
  { {0x395e001e,0xd498000b,0xdcfe001e,0x9f92015b}},	//   egts_, לכות_, _japā, tší_
  { {0x2d85015c,0xa3be0011,0xa3cc0011,0xa7fd0060}},	//   _tale_, ीफ़_, रफ़_, rtıl
  { {0xdcfe0039,0xb5fb000f,0x3ce80037,0xab5b0052}},	//   _lapā, stáj, _चुके_, _flüg
  { {0xd371000a,0x41050047,0x256f003a,0x3cf0015d}},	//   _لها_, ьзов, rılı_, čové_
  { {0x256f003a,0x65b0015e,0x2252003a,0x9f920042}},	//   sılı_, _läht, ünkü_, pší_
  { {0xb8f4015f,0x8f9a000b,0xa6db0028,0xa294002d}},	//   _से_, קישי, taða, _паці
  { {0x273c0020,0x7987003e,0x3615002d,0x6d430160}},	//   ận_, _najw, еєст, nana
  { {0xdddb0027,0x2c870066,0x7646006f,0x80240012}},	//   _oruž, vídá_, ssky, _كريم
  { {0x6d430161,0x63a40010,0x6b890162,0x76460064}},	//   hana, ujin, ndeg, psky
  { {0x63a60163,0xdb0b0164,0x7d07000e,0x59e10037}},	// [180] ökni, _algú, téré, _पदार
  { {0x50d60012,0x23bc0031,0x61470031,0x50ba0012}},	//   وزار, _díja_, vélí, يداد_
  { {0x7bc7007a,0x628b006f,0x859b0009,0xa0670048}},	//   _įjun, ågor, _ושיו, даха_
  { {0x62830035,0x645c0165,0x7d070025,0x657c0166}},	//   ānor, muri, séré, lerh
  { {0x4733002d,0x7d070061,0xdfcf0003,0x4e7a0003}},	//   тніс, péré, جين_, تحاد_
  { {0x657c008b,0x6d430167,0xf2d30009,0x60c90030}},	//   nerh, gana, _יער_, _řeme
  { {0x67f6000e,0x7bc00168,0xd75a0012,0xd8230048}},	//   láju, thmu, _ولست_, _адси
  { {0x69c10169,0x8c1b0009,0x657c016a,0xb5fb0031}},	//   ehle, חוקי, herh, tták
  { {0x53c60037,0x0aea0003,0x657c016b,0x6ac70011}},	//   रोएश, غربي_, kerh, _रेफ़र
  { {0x60280030,0x645c016c,0x442c016d,0xb5fb0097}},	//   _němc, kuri, _ttd_, rták
  { {0x3957000b,0x1957000b,0x63ab000e,0xb5fb000e}},	//   ושים_, וביל_, _fogn, sták
  { {0x33930003,0x9b930003,0x63060012,0xe29a003c}},	//   _للمز, _للمت, _قوال, _мае_
  { {0xdce8007a,0xc3330009,0xe664016e,0x81a60012}},	//   _padė, _סוס_, ктро, _يحتل
  { {0x12fb000b,0xceb3000b,0x645c016f,0x8afb0009}},	//   _והדב, דיש_, furi, _והדי
  { {0xdb06000f,0x67d50170,0xb4b80012,0xa7fd0060}},	//   _elkü, _поку, وافذ_, ntık
  { {0x9fe70003,0x6d430171,0xcf270012,0x62830034}},	//   _تسته, zana, _غربي, łnom
  { {0x9e07002d,0x6e200172,0x65950173,0x657c0174}},	// [190] _очол, _numb, _запу, berh
  { {0x15e90037,0x89340012,0xa7fd0060,0x6f000060}},	//   _फ़ीचर_, نعما, ktık, ümce
  { {0x2a690005,0x917b0020,0xdddb001c,0x1048002d}},	//   stab_, _hệ_, _pruž, дячи_
  { {0x6d430175,0xf0930009,0xaad00011,0x69c10030}},	//   wana, כנע_, _सेवक, zhle
  { {0xcb360093,0xee38007c,0x65b00176,0x69c10066}},	//   _ראשי_, дні_, _täht, yhle
  { {0x65940177,0x6e920003,0x0d840024,0xa2bf0011}},	//   качу, الوا, клін, लैण्
  { {0x917b0020,0x6d3c000b,0x6d430178,0x577b0012}},	//   _lệ_, חתונ, rana, _وصرح_
  { {0x6d430179,0x65b00052,0xb5fb017a,0xe3b10012}},	//   sana, _jähr, stáh, طرب_
  { {0xd24e0003,0x6e20017b,0x645c017c,0x6d43017d}},	//   مني_, _gumb, zuri, pana
  { {0xa2f8000b,0xa6db0028,0xd1c6003c,0xd6180012}},	//   ומחה_, taðn, елье_, _قتلا_
  { {0xab950001,0x657c017e,0x67f60031,0x6724017f}},	//   _пажљ, verh, záju, žije
  { {0x9056000b,0x6d410180,0xa8560009,0xf0920009}},	//   עברו_, _hela, עירה_, אנט_
  { {0x6d4100c6,0xe3c2003a,0x3e690029,0x657c0181}},	//   _kela, nlış_, nút_, terh
  { {0x92c100a2,0x6d4100c6,0x9aa40003,0xdb09004a}},	//   ığın, _jela, _جمهو, rkeä
  { {0x6d4100ec,0xddcd000d,0x61e6000e,0xeb9a00b3}},	//   _mela, _spaţ, ékle, пив_
  { {0x6d410182,0x58f60009,0x645c0183,0xb8760009}},	//   _lela, _אמצע_, ruri, _נתפס_
  { {0xc332000b,0x6e930003,0x2249002c,0x39450184}},	// [1a0] טון_, _مليا, gsak_, oals_
  { {0x39450185,0xe889001a,0x645c0186,0x4c860187}},	//   nals_, _kẻ_, puri, _злов
  { {0x6e2000c6,0xc172000b,0xe53b000b,0x21f40052}},	//   _sumb, רחב_, _מתיר, fähr_
  { {0xfaa60188,0xa2cb0011,0xdeba0009,0x999f0035}},	//   _замо, _सेक्, ּמַל, āršo_
  { {0xe889001a,0xc7d70009,0xaff70012,0x3c3e0030}},	//   _lẻ_, עוני_, رفها_, lův_
  { {0xa4d4002d,0xdce1003a,0xa7fd003a,0xb5fb0031}},	//   колі, _anlı, ttık, ttái
  { {0xc5f3000b,0xe44f0012,0xa3cc0011,0x91e30189}},	//   אדג_, مضي_, रफल_, _соре
  { {0x6d410005,0x3e69018a,0x6e20018b,0x7669008e}},	//   _eela, bút_, _tumb, ösyö
  { {0xdac20024,0xb5fb0031,0x1a5a0012,0x6d41018c}},	//   кцiя_, stái, أشعة_, _fela
  { {0xbe13000a,0x64a60098,0xa7fd003a,0xb5fb000e}},	//   _موقع, _паза, ptık, ltáv
  { {0xc7b10012,0x22490060,0xc1730009,0xdb120097}},	//   لّد_, zsak_, אחת_, _ágæt
  { {0xfa88008a,0x765d004a,0x83360003,0x765a0002}},	//   _từ_, tusy, _أراض, ątyn
  { {0xb5fb0018,0x3945018d,0x996c0035,0xddcd0073}},	//   itáv, bals_, vēņu_, _apaš
  { {0x9f4b0013,0x917b001a,0x9a870003,0xc8f40014}},	//   mocí_, _vệ_, _أَوْ_, _излъ
  { {0x661a004a,0xdcfc0034,0xef1f0060,0x644a018e}},	//   _mitk, odrę, ndük_, nsfi
  { {0xd138007a,0x917b001a,0x7bdf018f,0xc2c50012}},	//   lbą_, _tệ_, unqu, نيزي
  { {0x66d3000f,0x4fd8000b,0x95c50012,0x3ced0011}},	// [1b0] _műkö, _רוחב_, _ليظه, _आँके_
  { {0x65b0008b,0x44210190,0x22490191,0x644a0192}},	//   _währ, _tuh_, rsak_, ksfi
  { {0x2009001a,0x6d470193,0xdce30034,0xe8890081}},	//   _khai_, maja, ofną, _xẻ_
  { {0x6d410194,0x3e690029,0x6d470195,0x18980012}},	//   _sela, tút_, laja, عضلة_
  { {0x69dd000f,0x6b9d0052,0x46a4002d,0x6d410196}},	//   ések, _insg, лаїв, _pela
  { {0xdce80039,0xab5b0052,0x6b8d0197,0xddab0048}},	//   _gadī, _flüc, ldag, ятел_
  { {0xab5b0052,0xe58c0009,0xd49b0198,0x3e690031}},	//   _glüc, לָהָ, ярд_, sút_
  { {0x1adc0037,0xe65d003a,0xe889001a,0x6d470199}},	//   मपंथ, ştığ, _rẻ_, haja
  { {0x6d4100c6,0xe889001a,0x6458019a,0xd7e40024}},	//   _tela, _sẻ_, arvi, _сіро
  { {0x46150003,0x93bc004b,0x6d47019b,0x6995019c}},	//   _شوار, _stăt, jaja, трих
  { {0x6d47019d,0xf992000b,0xb902002d,0x3945019e}},	//   daja, ברי_, изьк, rals_
  { {0xe889001a,0xcb350048,0xdcfa0034,0x63af0034}},	//   _vẻ_, _редъ, _natę, _nocn
  { {0x93b60093,0x63a9001c,0x3945019f,0xb9950012}},	//   _שלנו_, mjen, pals_, _للإب
  { {0xceb20093,0xeab00003,0x865a000b,0xd256000b}},	//   סים_, _دعم_, ודשי, _ישנה_
  { {0xddc20039,0x22510002,0xdce8001e,0xc5f2000b}},	//   ntoš, ązku_, _radī, ידך_
  { {0x6b8d0101,0xa00a0003,0x69d701a0,0x63a901a1}},	//   gdag, _تقبل_, eixe, njen
  { {0x6b8b01a2,0x4b23007c,0x61e20061,0x63a90027}},	// [1c0] _magg, рмув, éolo, ijen
  { {0xfe1e0037,0x00da0003,0x63a901a3,0x63bb01a4}},	//   _यूएस_, وبات_, hjen, hkun
  { {0x8c43003a,0xdce8001e,0x661a000e,0x63bb01a5}},	//   üşte, _vadī, _ritk, kkun
  { {0x93c7007d,0xdfcf0003,0x6b8b01a6,0x69d701a0}},	//   _plăţ, ييل_, _nagg, aixe
  { {0x661a004a,0xddc2001e,0x443e00b6,0x63a901a7}},	//   _pitk, etoš, _swt_, djen
  { {0x8d630046,0xe626001a,0x69c50168,0xb5fb01a8}},	//   авље, _đôla_, chhe, stáv
  { {0xd5b10020,0x98be001e,0x3ea0000d,0x6b8b01a9}},	//   _tín_, katā_, ţit_, _bagg
  { {0xfe1e0037,0x64a30001,0x63a901aa,0xe3b20012}},	//   _यूऍस_, раћа, gjen, شرع_
  { {0xd00f000a,0xfbd30093,0x661a000e,0x97570009}},	//   _ذلك_, יתה_, _titk, _שימו_
  { {0xa3f50013,0x6feb0002,0x661a0070,0x6b8d000e}},	//   ější_, ięce, _uitk, zdag
  { {0x2d9e01ab,0xd1380010,0x115b000b,0x6d4701ac}},	//   _inte_, rbą_, ודיע, vaja
  { {0x2d8c01ad,0x63bb0052,0x317e0052,0x63a901ae}},	//   _hade_, ckun, setz_, cjen
  { {0xc9aa0046,0x42540003,0xf77f003a,0x6d4701af}},	//   _овде_, _إنتر, reç_, taja
  { {0xea77000b,0xa4d5002d,0x7bc20030,0x20d60012}},	//   _סגור_, гогі, _hlou, _لتعج
  { {0x2d8c0036,0x29230029,0xb97b01b0,0xf5e40024}},	//   _made_, árať_, _חנוי, ріям
  { {0x6b800058,0x49170009,0x88f70009,0xd407003c}},	//   nemg, _בקול_, _שזהו_, тяги
  { {0xf8eb0011,0x6b8d01b1,0xf8e20011,0x7bc20030}},	// [1d0] _जुड़ा_, rdag, _पशुप, _mlou
  { {0x79c80012,0x49540012,0x2d8c01b2,0xc69200af}},	//   نوقف_, لخمس, _nade_, _פאי_
  { {0x442701b3,0x69dd000f,0x6b8d01b4,0xc9530009}},	//   _în_, ései, pdag, שמע_
  { {0xb4c10037,0x2d9e01b5,0x82370012,0xfecb0009}},	//   ्छी_, _ante_, _لرسا, ֽמַּ
  { {0x6b8b01a2,0x4ea70098,0xe78401b6,0x6d4501b7}},	//   _ragg, ържа, рухо, _keha
  { {0xf2d20093,0xe618002d,0x66d2003a,0x1d0901b8}},	//   _פעם_, вді_, _sıkç, нели_
  { {0x6b8b0101,0xb5fb000f,0x6c350003,0x63bb00da}},	//   _pagg, ltás, دفعا, tkun
  { {0x93bc000d,0xddc201b9,0x9f420064,0x7bc201ba}},	//   _stăr, rtoš, sokú_, _clou
  { {0xb5fb000f,0xee840015,0x7bc20066,0x63a901bb}},	//   ntás, _выхо, _dlou, rjen
  { {0xdcbb0098,0x6d45009b,0xa8550009,0xc50b0012}},	//   _още_, _neha, ְיָה_, _قتال_
  { {0x2dd8000a,0xf1c30010,0x361a000b,0x1c1f0037}},	//   _شبكة_, _ryšį_, _נועד, _मंगल_
  { {0xf772000a,0xdb0601bc,0xc43a0009,0xdb0f0018}},	//   حاد_, _loká, _נתני, _você
  { {0xa6db0028,0xb5fb000e,0x69d50070,0x4e270048}},	//   naðh, jtás, _omze, лоян_
  { {0x88c50003,0x4ed5002d,0x7bc20027,0xbbbc0011}},	//   _متعل, рюют, _zlou, ईस्क
  { {0xa3ea0014,0xe0550003,0xf8a80003,0x43760055}},	//   едва_, _إختب, _لديه_, луат
  { {0x7afd0013,0x44250051,0xd497001a,0xdcf5001e}},	//   _byst, _mul_, ừng_, edzē
  { {0xa95a0003,0xdcfc01bd,0xe2450012,0x7e970012}},	// [1e0] فجار_, merč, لخلي, _منير_
  { {0xd5b10020,0x3f820051,0x10a6002d,0x6d4501be}},	//   _nó_, leku_, лизн, ðhal
  { {0xdce3007a,0x98be000d,0x2d8c01bf,0xdb060042}},	//   menė, mată_, _rade_, _doká
  { {0x224d00a2,0xd5ed0020,0x3f820051,0xf1bf0066}},	//   ksek_, _trạ, neku_, _stát_
  { {0x98be004b,0xdcf80035,0xb5fb0031,0xb4c10011}},	//   oată_, devā, mtár, ्ज़ी_
  { {0xd5b1008a,0x7bc20013,0x98be000d,0x4425003a}},	//   _có_, _slou, nată_, _bul_
  { {0xd4670001,0x98be000d,0x6da3004c,0x2d8c01c0}},	//   гије_, iată_, сија, _vade_
  { {0x5398005c,0xba540001,0x3f820027,0x1faa002d}},	//   твия_, авиј, jeku_, _якби_
  { {0xdb06000e,0x316a0048,0x7dc60097,0xae890012}},	//   _elkö, ншно_, _aðse, _لخلق_
  { {0xc05a002d,0x644e0058,0x6021001e,0x5eeb000b}},	//   нім_, ksbi, _lēmu, _אַבְ
  { {0x98be007d,0x09f7000b,0xd9170015,0xdfd10003}},	//   dată_, רמים_, лью_, قيد_
  { {0x6d4500c6,0xdcf5001e,0x69c3000e,0xa6db0028}},	//   _seha, zdzē, _elne, laði
  { {0x86740024,0xe667003c,0x98be004b,0x798101c1}},	//   бляє, ытно, fată_, belw
  { {0xbb1b0061,0x98be000d,0xb5fb01c2,0xe5c70015}},	//   _maît, gată_, etár, усмо
  { {0xb4c10037,0x69da01c3,0x6c540024,0xcc780009}},	//   ्छे_, mite, йкру, כְּר
  { {0x7afd0006,0xa3cf0037,0xa09b000b,0x9cd70009}},	//   _pyst, वों_, _טיוט, אולה_
  { {0x79d5002d,0x6d450051,0x98be000d,0x69c8004a}},	// [1f0] ажає, _teha, bată_, ohde
  { {0x98be007d,0xb5fb01c4,0x645a01c5,0xdcf50035}},	//   cată_, rtás, átic, udzē
  { {0x7afd003e,0x69da00e6,0x69c8008e,0xf20401c6}},	//   _wyst, iite, ihde, сято
  { {0xe7190003,0xdcfe0002,0x31e101c7,0xf43a0009}},	//   نيات_, _napę, _पद्ध, _שגרמ
  { {0x98aa001e,0xa6db0028,0x442501c8,0x97580009}},	//   ējām_, faði, _sul_, רידו_
  { {0x93bc000d,0xa159003c,0x63ad01c9,0xa6db0097}},	//   _stăp, _шагу_, ljan, gaði
  { {0xe3b1000a,0xa7fd00a2,0x63ad0010,0x10890009}},	//   قرة_, ntıs, ojan, _בָּֽ
  { {0x98be007d,0xe3b10003,0x69da0052,0xdb1d0028}},	//   zată_, ترت_, eite, _umsó
  { {0xdcfc0010,0x69c30064,0x69da01ca,0x798101cb}},	//   verč, _plne, fite, telw
  { {0x27e9004a,0xb5fb000e,0x98be000d,0x224d01cc}},	//   _ajan_, ztár, xată_, rsek_
  { {0x3f820027,0x98be000d,0x63ad0028,0x66ca000e}},	//   teku_, vată_, kjan, _töké
  { {0xe0d60014,0xc6000037,0xfe670012,0x69c8008e}},	//   рвю_, ोग्य_, يد_, ahde
  { {0x98be007d,0xab5b0032,0xc6330012,0x9e630048}},	//   tată_, _plün, يفَة, овяд
  { {0x7bc90061,0x69c80052,0x63ad01cd,0x3f8201ce}},	//   lheu, chde, ejan, seku_
  { {0x98be007d,0xdd0e003a,0xfc270012,0xe5880009}},	//   rată_, _dışa, تح_, נָשָ
  { {0xc052000b,0x7bc90061,0x98be000d,0x63ad01cf}},	//   _וזה_, nheu, sată_, gjan
  { {0x57fb000b,0x7bc9004a,0x661e017b,0xd7fb01b0}},	// [200] _בלקו, iheu, _tipk, _בהקל
  { {0xb5fb000e,0xc8960001,0x2896004c,0x7d090030}},	//   stár, ирењ, ијес, řesa
  { {0xb5fb000e,0xcf8f0001,0xa3af0037,0x394701d0}},	//   ptár, ој_, _कवच_, _mens_
  { {0x69da01d1,0x9e660012,0xd7ef0012,0x63ad0034}},	//   zite, لاتن, وكل_, cjan
  { {0xe8e20037,0xa6db0028,0xeda60021,0xb8fd0011}},	//   _पश्च, taði, ишко, _ते_
  { {0x7c960012,0x394701a0,0xd5e30024,0x8e970009}},	//   لشعا, _nens_, ожчи, ידנו_
  { {0xa6db0028,0x29270029,0x26c001d2,0x2bda0011}},	//   raði, ávať_, šio_, _बगदा
  { {0xa6db0065,0xa037000b,0x6b8401d3,0x69da0034}},	//   saði, _כאלה_, neig, wite
  { {0xc1a60001,0xa3c70011,0xab5d0034,0xf1ba0011}},	//   ајни, _उतर_, niży, _इवान
  { {0xda160037,0x497301d4,0x9d530012,0x78ba008e}},	//   थगित_, ольс, _ونقت, tytv
  { {0xc953000b,0x58d8002d,0xa9c3002d,0xe9cf0003}},	//   חמת_, удня_, іськ, بغي_
  { {0x39470070,0x27e601d5,0x04db0009,0xa8570009}},	//   _eens_, nnon_, _בקבל, סיכה_
  { {0x5f940098,0xf773000b,0x22580015,0x2005001e}},	//   цият, חקר_, _силы_, ēli_
  { {0x6d48001c,0x7bc60006,0xb2bb000b,0x39470007}},	//   _jeda, _alku, _במדר, _gens_
  { {0x63ad01d6,0xf77f01d7,0xb9370009,0xd7f9004b}},	//   tjan, ança_, _דרוג_, luăm_
  { {0xe0fb000b,0x394c0058,0xa7fd003a,0x63ad0010}},	//   _שלהל, lads_, atır, ujan
  { {0xc2990015,0x24180015,0xadf60011,0x926b0048}},	// [210] ыках_, роты_, इवान_, ърва_
  { {0x6f09003e,0x6d4801d8,0x99d40012,0x780f0011}},	//   _rzec, _neda, يتلا, िष्क_
  { {0x6b840039,0x6d410097,0x04950012,0x6f0901d9}},	//   beig, ðlau, _الجح, _szec
  { {0x20140054,0x27e601da,0x7d08005e,0xfe710012}},	//   _èxit_, gnon_, üdse, كدت_
  { {0x23da0037,0x9e640024,0x6d4801db,0xc7d80009}},	//   _बग़द, жвід, _beda, סודי_
  { {0xce380093,0x63a201dc,0x7ad00011,0xdcfe0030}},	//   סאות_, _anon, _सेटअ, _napě
  { {0x97a70014,0xa6db0028,0xd64d002d,0xd7950014}},	//   _крал, maðu, _гiпе, _ливъ
  { {0xc245002d,0x1bb90012,0x394701dd,0xa6db0097}},	//   бник, طابع_, _sens_, laðu
  { {0x65870015,0xe1f901de,0x248c016d,0x7bc901df}},	//   _выез, лги_, _esdm_, rheu
  { {0x6b84008b,0xa6db0065,0x7db40003,0x6d4801e0}},	//   zeig, naðu, _وصلا, _geda
  { {0xa3e801e1,0x7dc20029,0xdce3001e,0xeae40011}},	//   _बदल_, _dôsl, ienī, _गश्त_
  { {0x7dc20029,0x5fc70037,0x907a0009,0x487a0009}},	//   _pôso, लसिल, נטרי, נטרס
  { {0xa7fd00a2,0xa6db0028,0xbc1a0009,0x394701e2}},	//   ttır, kaðu, _עונש, _tens_
  { {0x6e2100b6,0xab18002d,0x8e070024,0x6e2901e3}},	//   _jilb, _тієї_, йняв_, _mueb
  { {0x7d090066,0xa7fd003a,0x8c950024,0x18350012}},	//   řesn, rtır, орті, _ارتح
  { {0xf1bf001a,0xa7fd003a,0xbbe90012,0x00560009}},	//   _quán_, stır, لرقم_, _השקת_
  { {0xa7fd003a,0xda650012,0x69c10159,0xa6db0097}},	// [220] ptır, قالي, okle, faðu
  { {0x01d7000a,0x5d860003,0xd1960001,0x49960001}},	//   موقع_, _الدل, љшањ, љшат
  { {0x444401e4,0x6d4e0101,0x94760003,0x0219002d}},	//   _uw_, maba, _ادخا, ріть_
  { {0x6d4e01e5,0x68fc0052,0xb0990024,0x6d4801e6}},	//   laba, ürdi, штує_, _seda
  { {0x319f001e,0xc3330009,0xd6770012,0x6d4801e7}},	//   _bāzē_, _מור_, محوا_, _peda
  { {0x6d4e0101,0x3f580081,0xa91c0064,0x225f01e8}},	//   naba, ứu_, deľn, druk_
  { {0x2bbf0037,0xef1f003a,0xb5fb01e9,0x394c0035}},	//   _एकमा, ndür_, duál, vads_
  { {0xa3d20037,0x6f000002,0xa857000b,0x8c430001}},	//   हों_, _tymc, _לילה_, чеће
  { {0x4fbb000b,0x7dcb003a,0x4422000e,0x6d4e01ea}},	//   _עצמא, _hüse, _mik_, kaba
  { {0xce37000b,0xd9fa0037,0x6d4e01eb,0x018a01ec}},	//   _לאמת_, ्तित_, jaba, ущий_
  { {0x6d4e01eb,0x672d00eb,0x9f4201e9,0xa98b0009}},	//   daba, žaje, soký_, אָכִ
  { {0x2902001e,0x69dd0061,0x69de01ed,0x57190024}},	//   āka_, éser, hipe, ижня_
  { {0x2bbf0037,0x69de01ee,0x645a0097,0x95cb0048}},	//   _एकबा, kipe, átin, гува_
  { {0xbd450003,0x30a601ef,0xf1bf0164,0xea010081}},	//   تنسي, _грив, _cuál_, _đắp_
  { {0x2a600051,0x89db000b,0x69de01f0,0xb9db0009}},	//   erib_, _תחוי, dipe, _תחוש
  { {0x69c7001c,0x44220039,0xeb480024,0x6e460097}},	//   _slje, _cik_, йчук_, ðubú
  { {0x6d4e0101,0x539b000b,0xa6db0028,0xa9270012}},	// [230] baba, נימו, taðu, معاه
  { {0x24890002,0xe4e7002d,0x99d70012,0x35be0011}},	//   łami_, _гімн, حترا, ्सफ़
  { {0x44220058,0xa91c0029,0x1dac0011,0x20100034}},	//   _fik_, ieľo, चानत, łnił_
  { {0x6e290164,0x4422014f,0x6e2101f1,0x20180012}},	//   _pueb, _gik_, _silb, متنع_
  { {0x7bdf01f2,0x7d070031,0xda660012,0x6e2901f3}},	//   miqu, _újsz, _تُ_, _queb
  { {0xb5fb0042,0x7bdf01f4,0x69de01f5,0xa6db0097}},	//   xuál, liqu, cipe, laðs
  { {0xddcc007a,0x0dc80001,0x7c2201f6,0xf9920009}},	//   _žiūr, ључи_, _bior, _קרל_
  { {0xa91c0026,0x7bdf01f7,0x7bcd01f8,0x23c90011}},	//   teľn, niqu, nhau, रसिद
  { {0x3e72007d,0x66030029,0x49c9002d,0xd24e0012}},	//   cât_, plnk, илин_, نني_
  { {0x09f60003,0x7bdf0061,0x42060024,0x225f00b0}},	//   يفية_, hiqu, жньо_, rruk_
  { {0xd7ea0047,0x0fda0003,0xbddb0054,0x6d4e01f9}},	//   имое_, لبحث_, ipèd, vaba
  { {0x7c2201a2,0xdd0e00a2,0x61fa0051,0x6d4e00b6}},	//   _gior, lışm, aotl, waba
  { {0x6008000b,0x61fa003a,0x7bdf01fa,0xd8080009}},	//   מִשְ, botl, diqu, מִשָ
  { {0x2d8701fb,0x992b0015,0xdd0e003a,0x112b002d}},	//   nene_, _сюда_, nışm, _сюди_
  { {0x2d8701fc,0x628f01fd,0xdcfc004b,0x6c360012}},	//   iene_, _asco, deră, تفزا
  { {0xb5fb000f,0x7bdf01f2,0x6d410028,0x27ed013a}},	//   trác, giqu, ðlar, _njen_
  { {0x2d87011b,0xe9da013b,0x6d4e01fe,0xed5a0198}},	// [240] kene_, ака_, paba, _коп_
  { {0x93c7008a,0xdcf5003a,0xdcfc000d,0x2d870082}},	//   _hoặ, _çağr, geră, jene_
  { {0x442201ff,0x30860003,0x2d870200,0x628f0201}},	//   _tik_, تلاف, dene_, _esco
  { {0x394a0054,0x443a0002,0xb5fb0042,0xc2090009}},	//   _webs_, _itp_, prác, דה_
  { {0x2e470014,0x2d870202,0xfe6f0012,0xb21b0040}},	//   оящо_, fene_, ندو_, _psæt
  { {0x3e720203,0xfc4b0030,0x443a016d,0x2d870204}},	//   rât_, říž_, _ktp_, gene_
  { {0x60280066,0xdfd20012,0xa7860012,0xab5b0032}},	//   _těmi, _قيس_, _وشرو, _blüh
  { {0x4422006f,0x7bc40010,0xd3770015,0xa3ba0012}},	//   ök_, nkiu, очь_, شاعر_
  { {0xa91c0026,0xf413000b,0xa3cf0037,0x6d5a0003}},	//   teľo, ופה_, वोट_, _نجاح_
  { {0x2fc90205,0xc27b0009,0x61e80206,0xa6db0097}},	//   _slag_, סריי, undl, kaðr
  { {0x09b7000a,0x6f0d0002,0x28f8002d,0xeb070037}},	//   تطيع_, _szac, сень_, _शर्त_
  { {0x32050036,0x7bdf0061,0xea010081,0xab5b0032}},	//   ally_, xiqu, _đập_, _glüh
  { {0x69dc009b,0x2fc90070,0x501b0009,0x87070012}},	//   _omre, _vlag_, יוטו, تبدل
  { {0x99d30003,0xf5aa0009,0x3834004c,0x7e620035}},	//   _يتوا, ׁבָּ, _енкр, irop
  { {0x7bdf0207,0x4c94002d,0xa6db0208,0xc4940024}},	//   tiqu, мирс, taðs, мирщ
  { {0x79880002,0x5a350209,0x08570009,0x442c0132}},	//   ledw, знат, _ובהם_, _mud_
  { {0x7bdf020a,0x6d41003a,0xa6db0028,0x2d930203}},	// [250] riqu, ılab, raðs, _taxe_
  { {0x442c0070,0x7bcd020b,0x7bdf020c,0x7bc4020d}},	//   _oud_, shau, siqu, akiu
  { {0x96180003,0xf8ca0037,0x7bdf0007,0xf7710012}},	//   _بغير_, ानिय, piqu, ّات_
  { {0xf8b3000b,0xb4fa0009,0xacfa0009,0x6d5a0031}},	//   ושע_, _לפתי, _להתכ, _adta
  { {0xd6db0046,0x2d870119,0xdd0e003a,0xf7700003}},	//   јте_, tene_, tışm, ضان_
  { {0x3aba000b,0xb2ba000b,0xa2ba000b,0x2aba0009}},	//   _המשנ, _המשר, _המשט, _המשא
  { {0x3ea9000d,0x9f51000e,0xc1720009,0x7d7c0009}},	//   ţat_, óból_, _רחל_, ינגו
  { {0x7e62009b,0x5ba9020e,0x398a0034,0xc245020f}},	//   brop, ским_, rósł_, пник
  { {0x2362000f,0xe9d90210,0xdce70060,0xe6880012}},	//   ókja_, йки_, ğlıl, _ونفى_
  { {0xdb060029,0x6ca70211,0x6455000e,0xa7fd003a}},	//   _pokú, _мреж, kszi, yrıc
  { {0x7bc40010,0xdcfa001e,0xfaf9001e,0x38150009}},	//   ykiu, _datē, egūt_, ּקָם_
  { {0xe29f0065,0x547a000b,0x27fd002a,0x69ca0212}},	//   _orð_, _לטעו, nown_, _elfe
  { {0xb902015f,0x6298001e,0xadf80037,0x7bcb0213}},	//   _ने_, āvok, ंकलन_, _ilgu
  { {0xceb20214,0x7995003e,0x69c500bd,0x7c3a006f}},	//   עים_, _nazw, jkhe, _yttr
  { {0x2cc90009,0x61e10215,0x64a30216,0xa50a0217}},	//   זֶּ֑, mill, нара, сева_
  { {0x61e10218,0xe8d6000b,0x60d6000b,0x3ce50031}},	//   lill, _מוצר_, _מוצא_, úlva_
  { {0x2737001a,0x61e1004a,0x5e570003,0x6f790009}},	// [260] _ủng_, oill, _فليس_, _וְתו
  { {0x6d41003a,0xa96a0003,0x61e10219,0x7e62021a}},	//   ılac, إمام_, nill, vrop
  { {0x55bb000b,0x6e3b002c,0x5dbb000b,0x79950032}},	//   _המיו, _atub, _הזיה, _dazw
  { {0x63a6021b,0x79880034,0x2d98021c,0x6d430032}},	//   _unkn, zedw, ldre_, ebna
  { {0xdfcf000a,0x96b70001,0x539b000b,0xd5ba0015}},	//   دين_, зују_, _היכו, йск_
  { {0x61e1021d,0x4639002d,0xb5fb00d9,0x8e570009}},	//   jill, іччя_, hrán, לינג_
  { {0xb5fb0065,0x4c940014,0xa91c0029,0xa0240052}},	//   krán, фийс, teľm, größ
  { {0x9f590061,0x79950002,0x33730048,0x7dcb0060}},	//   posé_, _zazw, егър, _müsa
  { {0x6033000d,0xdcfa001e,0xe3af0012,0x6d430031}},	//   _răma, _patē, ارى_, bbna
  { {0xe1d8002d,0x442c000e,0xdcf5001e,0xa63b000b}},	//   ідні_, _tud_, udzī, _לגמר
  { {0x6d3b000b,0xdcf5001e,0x442c00b6,0x7c3a021e}},	//   _התבנ, rdzī, _uud_, _uttr
  { {0xdc8b0009,0xec130012,0x3ea0021f,0x61fe0220}},	//   _לְדָ, _كولد, _brit_, hopl
  { {0x539b0009,0x2ba90011,0x61e10221,0xe3bf01e3}},	//   _ליאו, कारा, bill, _niña_
  { {0xba180003,0x64550222,0xba170012,0x99760223}},	//   _بيتا_, tszi, _فينا_, _худш
  { {0x717b000b,0xe97b000b,0x317b000b,0xa97b000b}},	//   _הנוס, _הנוש, _הרומ, _האוכ
  { {0xcf270003,0x61fe002a,0xd6d10012,0x3ea00224}},	//   _عربي, eopl, _لقب_, _frit_
  { {0x61eb000f,0xb7dc000b,0x6455000e,0x91b90014}},	// [270] _állí, _לקהי, sszi, огат_
  { {0x2d8a0017,0x9aa40012,0x64550031,0x454b0048}},	//   cebe_, عملو, pszi, _учим_
  { {0x721b000b,0x7c260225,0x27fd0226,0x7d7a0009}},	//   מומח, _fikr, town_, _ונתו
  { {0xe29f0065,0x629b0010,0xa0370009,0xe7580024}},	//   _eyða_, yvuo, פאדה_, зиці_
  { {0x6ff5003e,0x0f58000b,0x27fd002a,0x98be0066}},	//   jące, ליאם_, rown_, tatě_
  { {0xd126000a,0xdb070025,0x6ff50034,0x6b890227}},	//   _لم_, _éléc, dące, weeg
  { {0x4426001c,0x6b890051,0x61e10228,0x8d5c0009}},	//   _bio_, teeg, vill, זכוי
  { {0xc4780009,0x5f940229,0x2fc6001b,0xfaf10012}},	//   פתחו_, _пист, ckog_, َثة_
  { {0xc3340093,0x60180015,0x8d87022a,0x61e1022b}},	//   עוץ_, _хотя_, _нужд, till
  { {0x26c2007a,0x61e1022c,0x20c50024,0x629b0073}},	//   vyko_, uill, дйом, rvuo
  { {0x7dd00006,0xb5fb022d,0x63b9002a,0x31360009}},	//   _jäse, trán, _town, ונתם_
  { {0xdee6022e,0x3ea00061,0xb4fa007e,0x61e1022f}},	//   доми, _prit_, _ולער, sill
  { {0x7dd0006f,0xcf56000b,0xd7f9000d,0xb5fb0164}},	//   _läse, וברת_, crăm_, rrán
  { {0x7c260230,0xb21b0231,0xa3d90011,0x442600b8}},	//   _sikr, _spæn, डोर_, _zio_
  { {0x3e760058,0xc1050012,0x113a0009,0xc1040012}},	//   sæt_, _توثي, _ותצל, _كوهي
  { {0x6ff60003,0xf8b20009,0xf7720012,0xf7f60012}},	//   _تستط, _ישו_, _شاب_, _تستد
  { {0x3b070098,0x42260232,0x27f70012,0x764b0040}},	// [280] дето_, ддав, _تفيد_, _ægyp
  { {0xc9860003,0x2fcd000d,0x60280066,0xdb240031}},	//   بشري, _aleg_, _těmt, éséi
  { {0x8cb50044,0x7c26007a,0xf2c9000b,0x19b900fa}},	//   _उपयो, _tikr, סע_, чуть_
  { {0x61fe00c5,0x672d0027,0x4f0a022a,0xb5fb0066}},	//   sopl, žajn, онен_, hrál
  { {0x44260233,0xa91c0064,0xdcf80030,0x501b00af}},	//   _rio_, teľk, bevě, קונו
  { {0x7d780003,0x2fc60027,0xddc20066,0xdd900012}},	//   سمبر_, skog_, stož, اوث_
  { {0xd497003c,0xe5a3004c,0x6da3004c,0x52b80011}},	//   дры_, тији, тија, ेन्स
  { {0xcfaa0003,0x5e460012,0x29180034,0xeb97004c}},	//   _باسم_, _يَأْ, ągać_, дић_
  { {0x8cb50037,0xd1660014,0x44260164,0xdb0d0097}},	//   _उपभो, мъни, _vio_, nkað
  { {0xe29f0065,0x27e00175,0x7c3e0027,0xb5fb0234}},	//   æða_, _amin_, _otpr, stáz
  { {0xf993000b,0x44260235,0x48aa0024,0xf1bf0081}},	//   דרת_, _tio_, ітом_, _quái_
  { {0xdb0d0065,0x443e0236,0x5ba5002d,0x72c60237}},	//   kkað, _itt_, _пріз, _обез
  { {0xc7b3000b,0xff040048,0xa7fd0060,0x753d0031}},	//   דבר_, вярн, brın, _őszi
  { {0x27e000a2,0x7ae90238,0x3f8b017b,0x41770012}},	//   _emin_, _žeto, secu_, _يمنح_
  { {0xe4e4002d,0x6286001e,0xc1780010,0xc173000b}},	//   вітн, _apko, snės_, _יחס_
  { {0x5f950014,0xd0110012,0xe7870024,0xddc90030}},	//   _чиит, _حلب_, _цуко, _dveř
  { {0x6feb003e,0xda150001,0xbbbf0011,0x52150239}},	// [290] jęci, едањ, _एकीक, едат
  { {0x6277000b,0x91e40001,0x443e023a,0xdddb023b}},	//   וגמא_, вође, _ott_, _opuš
  { {0x35f8000a,0x6d55022d,0xab5b0052,0x29070097}},	//   _تريد_, maza, _blüt, æna_
  { {0x251a0093,0x6d55023c,0xad1a000b,0x2ef50001}},	//   _מותא, laza, _מותר, нзер
  { {0x443e023d,0xbb3a000b,0xde58002d,0x433a000b}},	//   _att_, _מערי, дачі_, _מערב
  { {0x3e320003,0xdcee0010,0x6b82023e,0x6d55023f}},	//   دفور, gebė, _abog, naza
  { {0x26c90027,0x63bd0240,0xd1380002,0x67d5003c}},	//   šao_, _kosn, dcą_, _зову
  { {0xa3d90037,0xd9b90011,0x6ab50048,0x03790012}},	//   डों_, ेस्ट, есох, سحبت_
  { {0x443e0241,0xb5fb0242,0x60160042,0x6d550243}},	//   _ett_, trál, náme, kaza
  { {0xf1b10003,0x9c870003,0x66e4004c,0x2a620031}},	//   اءة_, _يشاه, _рођа, ákba_
  { {0x67240013,0xe3bf0164,0xf1b20009,0x9f420030}},	//   žijt, _niño_, אסי_, liké_
  { {0x649a000b,0x78bc006f,0x0b780012,0x4c9a0009}},	//   _מסעד, ärva, _يصنع_, _מבעו
  { {0xa7fd00a2,0xe1ee0014,0x6d41003a,0x3f9e0066}},	//   ntıy, _бг_, ılan, ětu_
  { {0x7bcf01a2,0x99840012,0x7bc90244,0x69c80245}},	//   _alcu, _للهو, lkeu, ckde
  { {0xb0420020,0xc5f2000b,0x6feb0034,0x63bd0246}},	//   _trưở, אדם_, zęci, _bosn
  { {0x42d6002d,0x97c60012,0x7bc9008e,0x8b26004c}},	//   нізу, _ستعم, nkeu, едбе
  { {0x7bc90006,0x443e001e,0xada60247,0x21a6003c}},	// [2a0] ikeu, ūt_, _запл, ниам
  { {0xdb0d0065,0x2002004a,0x42070001,0x0b170012}},	//   rkað, loki_, енуо_, رقلة_
  { {0x7bc9004a,0x7dcb003a,0x7c3e00ad,0x71730012}},	//   kkeu, _müsl, _utpr, اهما
  { {0x2ca50058,0x6e280248,0x60160249,0xdc3b00af}},	//   ælde_, _sidb, lámb, _מעטר
  { {0x9757000b,0x7bc90070,0xdcee0010,0x6289001e}},	//   תינו_, dkeu, tebė, _ģeog
  { {0xab5b0052,0x245a001e,0xa2d90011,0x61e50060}},	//   _flüs, tīm_, _नेट्, cihl
  { {0xc9770009,0x25f10011,0x7d090030,0x6458008e}},	//   _רגלי_, ँचती_, řesv, usvi
  { {0xd1380002,0xe8df0081,0x2d9a0073,0x6b9b020d}},	//   wcą_, _chửi_, _lape_, gdug
  { {0x60e0007a,0x9f42008e,0x249c0073,0x7b140048}},	//   žymė, inkä_, _žymė_, ъдих
  { {0x91e30001,0xaa770009,0x9aeb0009,0xddcc0060}},	//   лоње, עתיד_, לַיִ, _ğişt
  { {0xc057002d,0x443e001e,0xc32a0003,0x6d55024a}},	//   нія_, _utt_, _فكان_, vaza
  { {0x2d9c000e,0xd65e0024,0x4bda0012,0xc7e60009}},	//   ldve_, _вiдд, _عباد_, תוֹ֙_
  { {0x0e340015,0x63bd024b,0xdb060064,0xb7db0009}},	//   лняю, _rosn, _poký, לקטי
  { {0xbbc90037,0x7d03024c,0x5b13002d,0xdb06003a}},	//   रस्क, _ønsk, _сміт, _dokü
  { {0x5ff50014,0x3137000b,0x63bd009b,0xc953000b}},	//   _изку, _ארוך_, _posn, _עמק_
  { {0xfc30000a,0x6d5a0028,0x40eb0009,0x4394003c}},	//   صحف_, ótar, _מַחֲ, ласс
  { {0xe1670001,0x8c1b000b,0x0e150001,0x4975024d}},	// [2b0] еђен, לולי, _имиџ, клас
  { {0x8cb10044,0x60160164,0x932400ae,0x000000c4}},	//   _अपलो, ráme, ارِن,
  { {0x4ddc000b,0x6fc60018,0xa7fd0060,0x2d8e0060}},	//   _מחזו, _sóci, yrıl, defe_
  { {0xe8170037,0x60c5004a,0xbcb6000b,0xfecb0009}},	//   _धीमा_, ryhm, _ספרו_, ּמַּ
  { {0xee38007c,0xa3b40044,0x6016000e,0xd3560009}},	//   ені_, ञान_, lámc, _שישי_
  { {0x31350001,0x7bc90070,0x8d620015,0x85780014}},	//   _јевр, wkeu, авше, есът_
  { {0xcd98000b,0x645a024e,0x02c90011,0x27e6024f}},	//   גדות_, štiv, िन्न, bion_
  { {0xddc20010,0x47340003,0x64430250,0xdc8c0009}},	//   ruoš, _مركز, rpni, לְחָ
  { {0x442b000d,0x7bc90251,0x7dd0006f,0x62720012}},	//   _mic_, rkeu, _läsa, لهيئ
  { {0x3f8f0028,0x3cfa0011,0x10a5004c,0xdd940012}},	//   legu_, _ऊँचे_, вион, _مجمع
  { {0x9991000f,0xa3c30037,0xc212000b,0x55ba0009}},	//   öző_, ्सा_, שהי_, _קמעו
  { {0xf7720003,0x442b0252,0x34b6000b,0xe4580024}},	//   جاد_, _nic_, _בפעם_, _їжі_
  { {0x44330108,0x2f5a000b,0x2d9a0253,0x6603005e}},	//   _aux_, ודרנ, _pape_, oonk
  { {0x7d0400a2,0x67eb004a,0xd6560009,0x80e50012}},	//   şise, töjä, כישת_, _لأعل
  { {0xdce1003a,0x8ca40037,0xd6270254,0x80c00011}},	//   _kalı, कियो, торе_, _एथें
  { {0x27e60255,0x2d9c0031,0x66030256,0xe3630257}},	//   xion_, zdve_, honk, икси
  { {0x2ebd0037,0x44330061,0x27e60258,0xa206004d}},	// [2c0] ्नोत, _eux_, vion_, впад
  { {0xdcfc001e,0x0657000b,0x602c003a,0x24920002}},	//   ndrī, _שייך_, _aşma, łymi_
  { {0xe0d20003,0xdcfc001e,0xd12f0003,0xdb060034}},	//   جزء_, idrī, زمن_, _pokó
  { {0x2d850036,0xddce0002,0xbe8a0001,0xf8b20009}},	//   _able_, żdża, дске_, ישב_
  { {0xa3ab0044,0x64410259,0x4420025a,0x7d090030}},	//   खाई_, _atli, mmi_, řest
  { {0x3f8f0051,0xf1bf001a,0xdb060002,0x4420025b}},	//   aegu_, _quát_, _wokó, lmi_
  { {0x3183000e,0xdce1003a,0x319b0009,0x61eb0025}},	//   észő_, _balı, _קבלנ, ègle
  { {0xb4fb000b,0xb8f60037,0xdcfc001e,0xd9ca0037}},	//   ופצי, िन_, edrī, िस्ट
  { {0x313400b3,0xdf370012,0xdce10060,0x64410032}},	//   лепр, _شكلت_, _dalı, _etli
  { {0x79a6025c,0x2e260012,0x29d40012,0x4420025d}},	//   трие, _شفاف, ايدس, hmi_
  { {0xc157000b,0xc60e0037,0xb5fb000e,0xbb860012}},	//   כשיו_, ितीय_, lság, _للاي
  { {0x6d41003a,0x4420025e,0x9f4b01e3,0xa91c0064}},	//   ılam, jmi_, vocó_, deľt
  { {0xb5fb000f,0x29020002,0xb9960012,0xe6670048}},	//   nság, łka_, _للشب, ътно
  { {0x4420025f,0x7dcf0260,0x6d580261,0x3f8f0034}},	//   emi_, _løsn, nava, zegu_
  { {0x2ca50028,0x645c006f,0x61e80262,0xe7f30011}},	//   íld_, gsri, midl, _अदला_
  { {0xef670098,0xa3ab0037,0xc334000b,0xa7750001}},	//   _ръко, खाए_, רוּ_, _слич
  { {0x799c0263,0xd2340048,0x5b150264,0x6d580265}},	// [2d0] _barw, интъ, умат, kava
  { {0xc27b000b,0xb5fb0074,0x51f80015,0x44200266}},	//   ורמי, dság, вную_, ami_
  { {0x3c38000f,0xc1040012,0x3f8f005e,0x44200064}},	//   _név_, لوكي, tegu_, bmi_
  { {0xe4a4002d,0x1b4b0003,0x2d91000d,0xb5fb0018}},	//   _трьо, _تؤدي_, leze_, cuár
  { {0x645a0267,0x35a80037,0xb5fb000e,0x8e850268}},	//   štit, _छोड़, gság, الته
  { {0x3e7b0061,0x2d91000d,0xed580029,0xa3c30011}},	//   rêt_, neze_, _poľa_, ्सव_
  { {0x60160028,0xdb0b0061,0xc172000b,0xb4bf0011}},	//   háma, _ingé, _לחם_, ुने_
  { {0xe2b90001,0x6603000e,0x6d580269,0xbcd80012}},	//   ећој_, sonk, aava, خذها_
  { {0xd1790024,0x6603026a,0x2fc0026b,0x8d770012}},	//   нсні_, ponk, _roig_, _لاضا
  { {0xe5730003,0x987e003a,0x46150012,0x3c380025}},	//   _خطر_, _açıp_, _صوار, _fév_
  { {0x7bcd004a,0x4420026c,0x35c60011,0x43750012}},	//   kkau, ymi_, रॉफ़, _مهار
  { {0xbb1b0025,0xeb9f0040,0x61e8005e,0x366a026d}},	//   _abîm, _skøn_, aidl, намо_
  { {0x200f003a,0xd5a70024,0xd6cf0024,0xee370048}},	//   ilgi_, _пiдп, йтi_, лня_
  { {0x6da6004c,0x63bb026e,0x61e8026f,0x7bcd0270}},	//   ћива, ljun, cidl, ekau
  { {0x2a7f0051,0xdca1002d,0xb5fb0271,0x69fa0009}},	//   ltub_, остi_, zság, _אלסק
  { {0x6d580272,0x44200273,0x8cb50037,0xdb0f0018}},	//   zava, umi_, _उपरो, _incê
  { {0xc3320093,0xa3b40037,0xdcfa001e,0x7fd70009}},	// [2e0] מון_, ञात_, _patī, _תופס_
  { {0xfd4a002d,0xb5fb0017,0xddd40029,0x7644002c}},	//   _язок_, suár, _ťažk, _itiy
  { {0xe4e30037,0xd12f0003,0x2a7f0051,0x63bb0028}},	//   _केलि_, أمم_, htub_, kjun
  { {0x44440274,0xb5fb000e,0xb4c20037,0x6033004b}},	//   _it_, tság, ्नी_, _cămi
  { {0xa3c30037,0x6d580275,0xf5360009,0xb7d70012}},	//   ्सर_, tava, ְנֵי_, دونا_
  { {0x2703001a,0xb5fb0031,0xd49a0276,0x44440277}},	//   ổng_, rság, ери_, _kt_
  { {0xb5fb000f,0x61e80107,0x39570009,0xbc670012}},	//   sság, vidl, _תשלם_, همون_
  { {0x7dc60065,0xf77f0017,0x2d910278,0x6f090034}},	//   _aðst, viço_, zeze_, żeci
  { {0xd130000a,0x0aea0003,0x9fb801bd,0xfd760012}},	//   يمة_, عربي_, nčí_, _مداخ
  { {0x2d91000d,0xfe370009,0x82330012,0xf62a0012}},	//   xeze_, _ערבי_, حريا, _أسرى_
  { {0x28f800fa,0x44440279,0x33860048,0x2d9e0018}},	//   тень_, _nt_, _булв, _iate_
  { {0xb4fb000b,0x3cfb0009,0xcb0a0012,0x2d9e0132}},	//   _אלבר, _אלבנ, _كيان_, _hate_
  { {0xa91c0026,0x4444027a,0x61e8027b,0x2d91027c}},	//   teľs, _at_, pidl, teze_
  { {0x7dcb0005,0xb5fb0042,0x5a9b0009,0xaa9b0009}},	//   _küsi, hráv, _נשוא, _נבוכ
  { {0xa157000b,0xa4d4002d,0xd13f0002,0x1957000b}},	//   _גבוה_, борі, łącz_, _גבול_
  { {0x2d9e0087,0x2d91027d,0x9ee90012,0x7bcd008e}},	//   _late_, seze_, _لفعل_, ukau
  { {0x7bcd027e,0xfc3f01e9,0x1155027f,0xb9550048}},	// [2f0] rkau, _čím_, икаю, иващ
  { {0x11540024,0x44440280,0x54550281,0x7bcd0282}},	//   йкую, _ft_, _квот, skau
  { {0xa0a7003c,0xdcf80035,0x44440283,0x893700af}},	//   ышал, ievē, _gt_, ארבע_
  { {0xb4d10037,0xd6d10003,0xf7730003,0x900b0012}},	//   वनी_, يقا_, صاص_, رزاق_
  { {0x2d9e0284,0x8db50024,0x7fb60012,0x44440031}},	//   _bate_, искі, شهور_, _zt_
  { {0xd658007e,0x4ade0044,0xb5fd0066,0x60180066}},	//   ניות_, _नेटव, _ovše, tímc
  { {0xdcf80039,0xeb9900be,0xabd50001,0xdb06000e}},	//   devē, вий_, ициј, _inká
  { {0xea01001a,0xd2650148,0x68e30097,0xdb4e0012}},	//   _đẹp_, акий, úndu, وَى_
  { {0x2d9e0285,0x59a60011,0xd7f8004c,0x63bb0286}},	//   _fate_, _कोहर, _сур_, rjun
  { {0x2d9e0287,0x6ff20035,0x7dcb005e,0xe8850288}},	//   _gate_, māci, _füsi, агоп
  { {0x7c950003,0x6ce4002d,0xf992000b,0x2a7f0051}},	//   _خلاص, _ліце, חרי_, stub_
  { {0x44440289,0x2249002c,0xe29f0097,0x645a0025}},	//   _rt_, kpak_, _eyði_, âtim
  { {0xa3b90044,0x6ff2001e,0x4444028a,0xe9ce028b}},	//   चान_, nāci, _st_, _дк_
  { {0x9fb80066,0x4444028c,0x69c30060,0x98a500b5}},	//   včí_, _pt_, önel, _вике
  { {0xb4c20044,0x2d9e0026,0xa3cc0037,0x442f0058}},	//   ्ने_, ľte_, _रकम_, _kig_
  { {0x6ff20039,0x44440051,0x2d9e00f1,0xd3720012}},	//   kāci, _vt_, žte_, تهر_
  { {0x6016000e,0x60180042,0xe61a00db,0x3e7f004b}},	// [300] lámo, jíma, _иди_, cît_
  { {0x673b0029,0xbbd20037,0xe9d7028d,0x5bd20011}},	//   ľuje, _तत्क, аку_, _तत्व
  { {0x4444028e,0x6d4e000e,0x2d9e028f,0x290e0097}},	//   _ut_, mbba, _rate_, æfa_
  { {0xddc20039,0x6d410290,0xc334000b,0x03a60188}},	//   droš, _afla, _לוֹ_, _тимо
  { {0xeb970014,0x6ff2001e,0x7dcb005e,0xd707004c}},	//   _тия_, gāci, _süsi, анце_
  { {0x7dcb0051,0xdb0b0123,0x04660291,0x6d5c0292}},	//   _püsi, _logó, атим, nara
  { {0x601d0061,0xb5fb014a,0x442f0293,0x8f760024}},	//   léme, práv, _big_, _вузі
  { {0x0b8a011f,0x938a0294,0x309b0009,0x6d5c0295}},	//   тски_, тска_, _בשלמ, hara
  { {0x442f0296,0x601d0061,0x6d5c0297,0x600b0009}},	//   _dig_, néme, kara, _יִמְ
  { {0x4e7b0093,0x6d5c00c6,0x867b0009,0xb5fb0031}},	//   _באמצ, jara, _ברמו, zsáb
  { {0x31370093,0xdfd1000a,0x54730003,0x2918006f}},	//   ינים_, كيد_, _وهكذ, åra_
  { {0x961f0037,0x6d4e006f,0xe6950015,0x3ea90298}},	//   पष्ट_, ebba, бимы, _prat_
  { {0x6d5c0163,0x8674002d,0xaaba0012,0x75d50012}},	//   fara, оляє, _جدار_, ميحا
  { {0x3f55001a,0x6d5c0299,0xf2db0009,0xb6070024}},	//   ấu_, gara, _שַׁל, рямк
  { {0x6ff20039,0x61ef0061,0x19bb0009,0x621b0009}},	//   zāci, ècle, _במגב, _שווק
  { {0x3ea90052,0x83350048,0x60290034,0xb5fb0031}},	//   _trat_, снах, _ośmi, usáb
  { {0xba550003,0x69da004a,0xd7fc000b,0x27e9029a}},	// [310] صناع, ohte, _שהחל, _iman_
  { {0xe29f0065,0xc1780010,0xf5950012,0x6d99003c}},	//   æði_, ngė_, _الدج, _своё_
  { {0xd138029b,0xf7730012,0x69da029c,0xda080012}},	//   рху_, قاش_, ihte, جيله_
  { {0x60180028,0x6ff2001e,0xb5fb029d,0xd0f70009}},	//   tíma, tāci, arát, סמאת_
  { {0x6d410052,0x6016000e,0xb6a5002d,0x27f2000e}},	//   _pfla, zámo, силл, ézni_
  { {0x6ff20039,0x8e08002d,0xddc2013a,0xe5780024}},	//   rāci, анів_, troš, изі_
  { {0xe3b10003,0x27e9004a,0x6ff20035,0x98be0073}},	//   كرة_, _oman_, sāci, matė_
  { {0x351c000b,0x1bf90037,0x69da0051,0x7c940012}},	//   כוונ, ्किल_, ehte, تشها
  { {0x36d4002d,0x93b8000b,0xfbb8000b,0xeb920009}},	//   _дотр, שלחו_, שפחת_, פָה_
  { {0x69da029e,0xdef80015,0x27e9029a,0x7c24029f}},	//   ghte, _тыс_, _aman_, zmir
  { {0x07a6002d,0x69c30052,0x1bf90011,0x39410032}},	//   банн, _vone, ्काल_, ichs_
  { {0xcdc90093,0x6d5c02a0,0x69da02a1,0x69c302a2}},	//   _אך_, wara, ahte, _wone
  { {0xdb24003a,0x32450012,0x539a0009,0x69c302a3}},	//   üsün, _انتف, _תינו, _tone
  { {0x32b8000a,0x69da02a4,0x7dd0004a,0xe6170015}},	//   _خدمة_, chte, _täsm, йдя_
  { {0x04460001,0x64a60014,0x91ba0009,0x4e160009}},	//   себн, щава, _תמצי, מחשב_
  { {0xa3ca0037,0x6bb5002d,0x9f820028,0x7dd00269}},	//   रॉप_, осує, _góð_, _käsk
  { {0x09360003,0xb7db000b,0x01360003,0x395802a5}},	// [320] مراج, _תקפי, معاد, _pers_
  { {0x6016000f,0x8d560001,0x601d0061,0x24890034}},	//   záml, _утич, réme, łamy_
  { {0x88860047,0xfbd20003,0x601d0061,0x395802a6}},	//   слеж, _فتح_, séme, _vers_
  { {0x25a10052,0xca290009,0x9e660012,0x87260024}},	//   _zahl_, גם_, ماتن, бмеж
  { {0x69da004a,0xe5c60063,0x82360012,0xdfa50012}},	//   yhte, йско, _درجا, تحلي
  { {0xa3ca0037,0x63a402a7,0x3ea6008e,0x443a02a8}},	//   रॉन_, ldin, rvot_, _kup_
  { {0xf41f004a,0xe9d700fa,0x628402a9,0x515b0009}},	//   _yhä_, _укр_, ltio, _תכלו
  { {0x00f7000b,0xb33b0060,0x443a02aa,0xd00a02ab}},	//   _המלך_, _kaça, _mup_, _себе_
  { {0x7ae90065,0x7dcb0052,0x60290002,0x32ba0012}},	//   _þett, _küst, _uśmi, ادعة_
  { {0xf77f00a2,0x984a0014,0xba9b000b,0xdcfc001e}},	//   miçi_, ляма_, נסיי, nerē
  { {0xa7b90001,0x6d5a001e,0xdb4f02ac,0xbda50012}},	//   алну_, _ieta, _ню_, _بحقو
  { {0x6016000e,0x0c2602ad,0xaba50012,0x63a402ae}},	//   lámj, _умен, _وإنه, jdin
  { {0xdb1d0013,0x6d5a0190,0x93a90012,0x7e6202af}},	//   _posí, _keta, _خالف_, nsop
  { {0x27070020,0xd6d8007c,0xc27b000b,0x6d5a0025}},	//   ống_, стю_, _תרגי, _jeta
  { {0x7a29007a,0xb1e50003,0xa4d4002d,0xdce8003a}},	//   _užti, _بأنه, порі, _kadı
  { {0x25a10052,0xd0f70009,0x7c150024,0x395e02b0}},	//   _wahl_, _למות_, ідає, lats_
  { {0x82f80003,0x39410061,0x7a570012,0x2418003c}},	// [330] مركز_, tchs_, إضرا, соты_
  { {0x7c3a02b1,0xb5fb02b2,0x6f1b0002,0x395e02b3}},	//   _outr, rrás, _rzuc, nats_
  { {0xb5fb0028,0x7c3a02b4,0x8d5a0009,0x50950012}},	//   srás, _nutr, _דכתי, تلاء
  { {0x61c50044,0xc885003a,0xdef10003,0x907b0009}},	//   _लक्ष, vaşı_, وًا_, רטאי
  { {0x7c3a02b5,0x9e64002d,0x628402b6,0xb5fd01bd}},	//   _autr, звід, ctio, _avša
  { {0x9628000a,0xdcfc001e,0x6d5a02b7,0x3135004d}},	//   مكنك_, cerē, _ceta, _февр
  { {0x9f5f000e,0xdb060248,0x7c3a02b8,0x59a60011}},	//   óról_, _enkä, _cutr, _कोइर
  { {0x04560003,0x77d70012,0x7dcb02b9,0xc24502ba}},	//   آلية_, _اغسط, _küss, оник
  { {0x7e62000f,0x69c7001c,0x85b900ac,0xe9d902bb}},	//   csop, _koje, _клас_, ики_
  { {0x7dcb008b,0x63a4007a,0x91e5002d,0x395e02bc}},	//   _müss, zdin, іоне, gats_
  { {0x7e640028,0xc172000b,0xcea90009,0x7649008e}},	//   _svip, וחי_, _שי_, _htey
  { {0x200b0054,0x907a000b,0xa3a90037,0x2465001e}},	//   goci_, סטרי, _गोल_, mēm_
  { {0xa294007c,0x2465001e,0x8f9a0009,0x68e1005e}},	//   _наці, lēm_, בירי, _üldf
  { {0x7dd002bd,0xca36000b,0xe29f0028,0x395e02be}},	//   _käsi, _ונסה_, æðu_, cats_
  { {0x7bc602bf,0x60160042,0x8c430294,0x7dcb0032}},	//   _poku, námk, десе, _rüst
  { {0x7dcb0005,0xa3e40011,0x628402c0,0x63a402c1}},	//   _süst, भों_, ttio, udin
  { {0x98a5003a,0x9a6a0003,0xda650003,0xe2460003}},	// [340] malı_, شمال_, كالي, تخزي
  { {0xfd120003,0x63a40010,0xba170012,0x7bc60034}},	//   _يجد_, sdin, قيقا_, _woku
  { {0xdbd1003a,0x291c0248,0x7649020d,0xa3ca0011}},	//   _güçl, åva_, _atey, रॉड_
  { {0x98a5003a,0x2465001e,0x6d5a02c2,0xddcd0002}},	//   nalı_, dēm_, _seta, _gwał
  { {0xd5ba0047,0x4e960003,0x63a20054,0xde960003}},	//   иск_, تشار, _raon, تجاب
  { {0xe452000a,0x3ead0054,0x7c3a00b6,0x3f580081}},	//   وضع_, _dret_, _putr, ẩu_
  { {0x98a500a2,0x26090037,0x395e0054,0xd64b0024}},	//   kalı_, ाक़ी_, vats_, _дiял
  { {0x98ba007a,0x9faf0066,0x2d9802c3,0x326602c4}},	//   lapį_, tří_, here_, отов
  { {0x6d5a00c6,0x98f50020,0x395e02c5,0x2d9802c6}},	//   _teta, uản, tats_, kere_
  { {0xddc20002,0x395e0054,0x601d0061,0x670e0037}},	//   społ, uats_, déma, _सड़क_
  { {0xeb9a0098,0x63a20101,0x395e02c7,0x24650035}},	//   _вие_, _taon, rats_, cēm_
  { {0x56950001,0x8c430060,0x395e02c8,0x69c102c9}},	//   памт, üşme, sats_, ajle
  { {0x370702ca,0x3949000d,0x395e02cb,0x57fb0009}},	//   ючов, _şase_, pats_, שלכו
  { {0xddcf000d,0x2d9802cc,0x68e1005e,0x6ff50034}},	//   ducţ, gere_, _üldg, rąci
  { {0xa177000b,0xfbd30003,0xa802003a,0xfd100012}},	//   _ועוד_, وتر_, şıya, نجف_
  { {0xedb70037,0xa0080012,0xa7740048,0xb5fb0031}},	//   _इच्छ, _وقول_, _жлъч, csán
  { {0x539b000b,0xe1f30003,0x2465001e,0x69c702cd}},	// [350] סימו, وسط_, zēm_, _poje
  { {0x44220005,0x91b80015,0x7a380024,0x2d9802ce}},	//   _ehk_, огут_, цпфр_, cere_
  { {0xdb1d0066,0xb8810066,0x69c70042,0x91a80012}},	//   _dosá, žíve, _voje, تهلك_
  { {0x69c70002,0x4c9a000b,0x3ead02cf,0x320c02d0}},	//   _woje, _פברו, _pret_, hody_
  { {0xb3ba000b,0x9bba000b,0x320c0034,0x501c0009}},	//   _המרכ, _הצרפ, kody_, בואו
  { {0x53a3015f,0x270a0020,0x7c2202d1,0x85e8002d}},	//   _खोजश, ờng_, _ahor, одів_
  { {0xc212000b,0x98a5003a,0x85580009,0xd5ae0012}},	//   _נהל_, yalı_, חשוב_, طفي_
  { {0x442900a2,0xe4fc000b,0x34fc000b,0x3ead0054}},	//   nma_, יפוש, יהוד, _tret_
  { {0xa263001a,0x2465001e,0x6d5a0028,0xf414000b}},	//   _giố, sēm_, ðtak, ופק_
  { {0x6aa902d2,0xe9d902d3,0x442902d4,0x320c0034}},	//   rvef, ско_, hma_, gody_
  { {0x98a5003a,0x224d00b6,0xc7a60024,0x601601e3}},	//   talı_, spek_, пинк, lámi
  { {0x224d000e,0xd8d6000b,0x25a502d5,0x53a40012}},	//   ppek_, פורט_, _hall_, _يملك
  { {0x98ab00a2,0x44290051,0xbb3a000b,0x98a5003a}},	//   ılık_, dma_, _העני, ralı_
  { {0x7bcb0028,0xd1bb0012,0x44d70081,0x7c2902d6}},	//   ögun, _خاصا_, õ_, lmer
  { {0xb5fb0066,0x98a5003a,0x81bc001e,0x25a502d7}},	//   psán, palı_, kmēj, _mall_
  { {0x6376003a,0x9e660001,0x2d9802d8,0x442902d9}},	//   münü, _евид, sere_, gma_
  { {0x6d4100a2,0xb77b0093,0x6376003a,0x877b0009}},	// [360] ılar, _האפש, lünü, _האפי
  { {0xa7fd00a2,0xb33b02da,0xddcf000d,0x7c290052}},	//   nsın, _faço, rucţ, hmer
  { {0x6d5e0039,0x7c290033,0x80a60003,0xb53b000b}},	//   _iepa, kmer, ثمان, _לגיש
  { {0xc2090009,0xa8560009,0x1cbb0009,0xf1ba0081}},	//   אה_, פינה_, _המטע, _nhơn_
  { {0x6d5e00c6,0xa7fd00a2,0xa3b90037,0x44d7001a}},	//   _kepa, ksın, चार_, ẽ_
  { {0x7c220036,0x6d5e00b6,0x1ea90003,0x7c2902db}},	//   _shor, _jepa, غاني_, emer
  { {0x25a501a2,0x7c2902dc,0x320c0042,0x395c02dd}},	//   _dall_, fmer, vody_, _revs_
  { {0x6c470003,0xdcf8001e,0x320c0002,0x6d5e02de}},	//   أليف_, levī, wody_, _lepa
  { {0x44d70020,0x63a602df,0x320c02e0,0x25a502e1}},	//   ã_, _makn, tody_, _fall_
  { {0x6720001c,0x2003001c,0xd8f8002d,0xdca602e2}},	//   _izmj, čkim_, жної_, _нази
  { {0xa3190037,0x6376003a,0x9f9902e3,0x7c2202e4}},	//   _दर्ज_, günü, овну_, _thor
  { {0xd0f7000b,0xc43b000b,0x63a6013a,0x4c3b0009}},	//   למית_, _התאי, _nakn, _התאב
  { {0xb80d0044,0x6d5e00bd,0xe80d0037,0x7c3e0061}},	//   िकतम_, _bepa, िकता_, _aupr
  { {0x6d5e00b6,0x7ae40029,0x224b0029,0xe29b000b}},	//   _cepa, dzit, ícke_, _לשדר
  { {0x7c3e000d,0x3f990051,0xdcf8001e,0x6d5e02e5}},	//   _cupr, pesu_, devī, _depa
  { {0xec34002d,0x69dc02e6,0xd0110012,0x8afd0030}},	//   енсь, _alre, _جلب_, saře
  { {0x25ed0037,0x5a350232,0xa2940024,0x9f4b0030}},	// [370] _अगली_, днат, наті, nicí_
  { {0x7c2902e7,0x443e02e8,0x799a00c7,0x05790012}},	//   zmer, _out_, netw, _بمدة_
  { {0x4429003a,0xb4670003,0x66280066,0x7c670012}},	//   pma_, _عدده, řské, _عادل
  { {0xc104000a,0xa7fd003a,0x69dc000e,0x98170012}},	//   روني, zsın, _elre, أبطا
  { {0xf7700003,0x81bc001e,0x999f000e,0x63760060}},	//   طان_, rmēj, őről_, zünü
  { {0xf650000a,0x443e02e9,0x6d470002,0x601602ea}},	//   ائن_, _but_, ncja, rámi
  { {0x63a600c6,0x98170003,0xdca20014,0x64a20014}},	//   _yakn, _فبرا, ващи, ваща
  { {0x49060037,0x7dd002eb,0x25a502ec,0x8d180012}},	//   _सँजो_, _häst, _wall_, أزهر_
  { {0x443e0061,0x25a502ed,0x6d470002,0xb33b0060}},	//   _eut_, _tall_, kcja, _raçl
  { {0x39e9007c,0x443e02ee,0x6376003a,0xc5fb0003}},	//   ідно_, _fut_, tünü, _اعرض_
  { {0x443e02ef,0xa7fd003a,0x7c2902f0,0x7bdd003a}},	//   _gut_, rsın, pmer, _olsu
  { {0x637600a2,0x7bcb0065,0x7dd002f1,0x7e690073}},	//   rünü, ögul, _läst, _kvep
  { {0x63a60028,0xceb2000b,0x2e240032,0x63760060}},	//   _rakn, ֣ים_, höfe_, sünü
  { {0x7dd00163,0x63a6006f,0xf2d20009,0x69b70011}},	//   _näst, _sakn, _בעד_, _ऍचटी
  { {0x7bcb0005,0x31780034,0x764d0060,0x63a902f2}},	//   _kogu, órze_, _etay, oden
  { {0x305a0009,0x42d60024,0x237a0012,0xab7a0012}},	//   _ודקד, мізу, تمرد_, تمرا_
  { {0x7bcb02f3,0x7dd0006f,0x6d5e00b6,0xde1a0003}},	// [380] _mogu, _bäst, _tepa, _وقعت_
  { {0x6b9b0070,0x63a9004a,0x70f60003,0x00da0012}},	//   heug, hden, وسائ, يبات_
  { {0xd7ef0001,0x55bb0009,0x9f4b0030,0xb8650012}},	//   ву_, _ומיו, zicí_, فانو
  { {0x799a0002,0xef1a02f4,0xf9890009,0x63a902f5}},	//   zetw, оме_, יר_, jden
  { {0x27f9000e,0x7dd0006f,0x539b000b,0x96b7004c}},	//   érni_, _fäst, _ויכו, дују_
  { {0x443e02f6,0x69c302f7,0x63a90204,0x7dd002f8}},	//   _put_, önet, eden, _gäst
  { {0xa4d8002d,0x6feb0002,0x2075003c,0x78450073}},	//   ядку_, ręcz, _путё, _tėva
  { {0x7a290010,0x69ca02f9,0x60080060,0xd4990024}},	//   _užtr, _sofe, nımd, ярі_
  { {0xa80200a2,0x5a340014,0x443e0032,0x65630018}},	//   ğıda, ннит, _wut_, banh
  { {0x7abb000b,0x05760012,0x63a902fa,0xdb1b0097}},	//   קציו, _زائد, aden, rkuð
  { {0x7dd00052,0xc057002d,0x764d002a,0x443e02fb}},	//   _läss, мія_, _stay, _uut_
  { {0x601d0025,0x2fc60031,0x2d9c02fc,0xb5fb0031}},	//   rémo, njog_, leve_, csáj
  { {0x03d7000b,0xc6e70024,0xcf570009,0x60080060}},	//   _קודם_, фінп, ובכת_, dımd
  { {0x7dd40054,0x9f4f0025,0xdb040032,0xd3370009}},	//   _bàsi, rigé_, weiß, _חרדה_
  { {0x2bbb0003,0xab950001,0x2d87003a,0x16340021}},	//   يارة_, нављ, _önem_, теря
  { {0x8b5b0012,0xe4510009,0xaad20011,0x2d9c02fd}},	//   تجسس_, רֶם_, _तथाक, heve_
  { {0x160e0037,0xd2510012,0xa7fd0060,0x9f4f00b0}},	// [390] ाकार_, انئ_, nsım, nngå_
  { {0xdbd60005,0x6b9b008b,0x2d9c0027,0xdeb6000b}},	//   _hääl, zeug, jeve_, _נפתח_
  { {0xdb0b006f,0x9961001e,0x7dd002fe,0x63a902ff}},	//   _ingå, nūšu_, _väst, yden
  { {0x7e6d001e,0x9cd60009,0xe7580024,0x44260081}},	//   šapm, _נורה_, диці_, _nho_
  { {0x7dd00006,0x2003001c,0x65630017,0x501c000b}},	//   _täst, čkih_, tanh, קודו
  { {0x44390274,0x0ea8007c,0x2918006f,0xd1260003}},	//   _his_, ькій_, _fyra_, _مم_
  { {0xfc460026,0x7bcb0300,0x4439000e,0x683a0066}},	//   žíva_, _pogu, _kis_, _vůdc
  { {0x4426008a,0x4439007a,0x62890301,0xa3ca0011}},	//   _cho_, _jis_, tteo, रॉल_
  { {0x66f30302,0x65630017,0x44390303,0xeab10003}},	//   _अधिक_, panh, _mis_, اعب_
  { {0x3f9d0002,0x7e7d0304,0x2d9c00b8,0xd2560009}},	//   lewu_, dusp, ceve_, עשתה_
  { {0x05c30037,0x7c2d0305,0x94a80306,0x60160031}},	//   शानब, kmar, _отца_, zámu
  { {0xf772000a,0xe73a0015,0x2919001e,0x6441000d}},	//   داد_, яем_, āsa_, _iuli
  { {0x96ba0046,0x64410101,0x201e001e,0xa3b90037}},	//   чуну_, _huli, ēti_, चाई_
  { {0x270e001a,0x64410307,0x64480018,0xdca6004c}},	//   ộng_, _kuli, ídio, наги
  { {0x4439008b,0x65610149,0xfce60308,0x8dfa0009}},	//   _bis_, _melh, хово, להשת
  { {0x7c2d0309,0x04570003,0xf0620014,0x442d030a}},	//   gmar, علقة_, _скъп, nme_
  { {0x160f0044,0x291e001c,0x6008003a,0x4439030b}},	// [3a0] िवार_, _šta_, rımd, _dis_
  { {0x442d008b,0xdb060013,0x7c2d030c,0x6f160034}},	//   hme_, _jaké, amar, życk
  { {0x6441007b,0xb5fb0031,0x7c2d030d,0x442d030e}},	//   _nuli, zsák, bmar, kme_
  { {0x7dd00006,0x3f8200b6,0x69c3030f,0x8afd0030}},	//   _täss, ngku_, öner, zařa
  { {0x245e0013,0xceb3000b,0xeb3b0009,0x433b0009}},	//   lům_, ָיו_, _מעכש, _מעכב
  { {0x4439000d,0x7a8b0009,0x867b0009,0x442d0310}},	//   _zis_, _מָלַ, פרצו, eme_
  { {0xdcfc0039,0xb7960046,0xd4970047,0x245e0066}},	//   derī, _праћ, еры_, nům_
  { {0x442d0311,0x251b0009,0x68e1005e,0x6561005e}},	//   gme_, הוצא, _ülda, _eelh
  { {0x65610272,0x539b0009,0x245e0030,0x2327004c}},	//   _felh, ליקו, hům_, ноћи_
  { {0x44260036,0x245e0066,0x2ca90002,0x27e00312}},	//   _who_, kům_, łada_, _alin_
  { {0x33d6007c,0x29180065,0xdfd10003,0xdbd6004a}},	//   _підт, æra_, ليد_, _pääl
  { {0x04db000b,0x245e0066,0x7e7d0038,0x1ae60313}},	//   _מקבל, dům_, tusp, _поем
  { {0x9f4b0054,0xa3d50011,0x0cc90011,0x7c2d0248}},	//   ricà_, _सकत_, रह्म, vmar
  { {0x2d85003a,0x69ce0314,0xb8660003,0xddc20030}},	//   üle_, _nobe, _كابو, hrož
  { {0xd5b80015,0xdbd6004a,0xe4e4002d,0x98a30001}},	//   хся_, _tääl, гітн, _бије
  { {0xb5fb0066,0x7c2d0315,0x9cbb0009,0xe3b30012}},	//   zsáh, umar, הצלח, درس_
  { {0x98ac00a2,0x44390316,0x9f4b005e,0x69da016d}},	// [3b0] madı_, _vis_, öjõu_, okte
  { {0x98ac003a,0x4efc0009,0x91e4004c,0x601d0030}},	//   ladı_, _מהחו, гође, kémk
  { {0xe3c300a2,0x99840003,0x69c80070,0xfe360009}},	//   ngıç_, المو, ijde, _שרתי_
  { {0xa857000b,0x65610066,0x83190012,0x64410132}},	//   גיאה_, _selh, _يقدر_, _ruli
  { {0x2fcd0070,0xe72e0001,0x6441010a,0xe7e20011}},	//   _voeg_, ре_, _suli, _खतरा_
  { {0x69ce0317,0x0c950048,0x7b07004b,0xc6940009}},	//   _gobe, вшия, ăptă, ראס_
  { {0x301b0003,0xd6180003,0x65610318,0xdb060031}},	//   _فترة_, رتها_, _velh, _raké
  { {0x7bcf000d,0xeb9900de,0x403401ec,0xae0f0011}},	//   _jocu, фии_, _бесс, िवहन_
  { {0x69d8000f,0x1309007c,0x8b250014,0x628d0319}},	//   öveg, ьний_, ъдие, ntao
  { {0x7bcf031a,0x6441031b,0x63ad031c,0xb5fb0031}},	//   _locu, _tuli, hdan, aráz
  { {0x9b950003,0xf8e10037,0xac740012,0x80cb0011}},	//   _للات, पनिय, _مانش, ाहें
  { {0x6008003a,0x245e0066,0xaa890012,0xa3b00011}},	//   dımc, vům_, _ينضم_, _टों_
  { {0x3f8c0002,0x21e40052,0x69c40037,0xdb060029}},	//   ędu_, _höhe_, रामी, _také
  { {0x7ae9000f,0x63ab0028,0x245e0066,0x69da031d}},	//   mzet, _hagn, tům_, ckte
  { {0xa8060098,0xa3d50037,0xa0a5002d,0xe5880009}},	//   _изкл, _सका_, _райд, עָשָ
  { {0xd00f0003,0x6f160002,0x245e0066,0x7bdb004a}},	//   _ولو_, życi, rům_, nkuu
  { {0x61460046,0xd5b1001a,0xe7f70037,0xd9460001}},	// [3c0] веза, ốc_, ूचना_, вези
  { {0x7ae9000e,0xdb0d0028,0xbd460012,0x7e60004b}},	//   izet, rjað, _جندي, âmpu
  { {0x7bdb0006,0xa0670014,0x1d0a00f5,0xa50a031e}},	//   kkuu, ваха_, _цени_, _цена_
  { {0x9985000e,0x69ce031f,0x9e660012,0xd7ef0012}},	//   illő_, _wobe, ناتن, يكل_
  { {0x69da0033,0xc7b3000b,0x6e940003,0xe737022a}},	//   ykte, יבא_, التا, вец_
  { {0x6146004c,0x69d80031,0xa6130024,0x44440320}},	//   _јева, öved, аміч, _ku_
  { {0x44a30003,0x9cb40003,0x8cc40012,0xd1970009}},	//   لموق, امبت, اقعه, _שכלי_
  { {0x3d160321,0xc4d30009,0x60160031,0x601d0030}},	//   _पुणे_, שגה_, zámr, rémk
  { {0x8c1b000b,0x7ae90322,0x81bc0035,0xb5fb0031}},	//   ווקי, gzet, kmēt, msáv
  { {0x44440323,0xbda50003,0x6008003a,0x6e3a0070}},	//   _ou_, _محمو, yımc, _uitb
  { {0xb97b0093,0xddc2003e,0x417b000b,0x44440324}},	//   וניי, zpoś, וניב, _nu_
  { {0xb5fb0017,0x63ab0325,0xd0060003,0x9cd70009}},	//   nsáv, _gagn, صل_, _שואה_
  { {0x44440326,0xd2500003,0x2f5b000b,0x77640327}},	//   _au_, _انت_, ודכנ, _deix
  { {0x444400a1,0xceb3000b,0x63ab0328,0xee310009}},	//   _bu_, ביש_, _zagn, ֶֽם_
  { {0x444401b3,0x499b000b,0x7dcb000e,0xa99b0009}},	//   _cu_, _חשוב, _küsz, _חבור
  { {0x3137000b,0x60080060,0x3ed50012,0x7b770012}},	//   _ברוך_, rımc, _مقبر, ضطرا
  { {0x44440329,0xfc300012,0x63a00034,0x7c34004c}},	// [3d0] _eu_, زحف_, iemn, ретх
  { {0x444401a2,0xa294002d,0xddc20002,0x6b84002c}},	//   _fu_, рафі, groż, agig
  { {0xf775002d,0x82340003,0xf1ba001a,0x94d5002d}},	//   гулю, شركا, _chơi_, _сонц
  { {0x2e240028,0x6280032a,0xf7700012,0x7ae90031}},	//   nöfn_, kumo, قاه_, yzet
  { {0x4444032b,0x6280001e,0x6008003a,0xdb7a0009}},	//   _zu_, jumo, nıma, _אנרכ
  { {0xee38007c,0x7ae9012e,0x8d540014,0xbef30037}},	//   вні_, vzet, атъч, _अधीन_
  { {0x64450005,0x4444001a,0xc1050003,0xcd98000b}},	//   _juhi, _xu_, _صوري, דדות_
  { {0xac96000a,0x3d3c000b,0x3ea9004a,0x672c000e}},	//   انيا_, וגוס, _osat_, öljü
  { {0x7ae90027,0x62800010,0x7c3d032c,0xd945005f}},	//   uzet, gumo, _misr, лепи
  { {0xb0ae0037,0xf2d2000b,0x60180028,0x2d830058}},	//   टिंग, צעי_, símt, _øje_
  { {0x228b0119,0x7ae9000e,0x545502d3,0x88f60009}},	//   søk_, szet, _свет, ָ֖יו_
  { {0x92b50012,0xdb0d005e,0x2cae0031,0x6280032d}},	//   _محتا, ljaõ, üldő_, bumo
  { {0x64450051,0xe73700b3,0x7f190024,0xaa890012}},	//   _auhi, лею_, віру_, _أنتم_
  { {0x4444032e,0xc3320009,0xd24e00ae,0xdb1d032f}},	//   _pu_, _הוד_, _عنى_, _insè
  { {0x444402b5,0x3ea90039,0x9999007a,0xdce3007a}},	//   _qu_, _esat_, ūsų_, kanč
  { {0xdce3007a,0x44440330,0x81bc0035,0xdd030073}},	//   janč, _vu_, smēt, ūrėm
  { {0x6d410331,0xac070015,0xdce30010,0x6b840051}},	// [3e0] _ogla, унта_, danč, rgig
  { {0x69c40037,0x44440332,0x7a220064,0x2f1d0031}},	//   राधी, _tu_, rôto, ságú_
  { {0x81bc0333,0x7fd6002d,0xcf9a0001,0x44440334}},	//   slēg, ліді, ејл_, _uu_
  { {0xd3da0003,0x4b550014,0x6d410335,0x7f860012}},	//   _أبدا_, _върт, _agla, الإن
  { {0xddc4009b,0x6d5c00f1,0x2d8a003a,0x44200336}},	//   _zviš, obra, _öbek_, mli_
  { {0xc693000b,0x7d1e008e,0xdb0000b0,0x0caa0337}},	//   צאו_, _kyps, ndmå, етии_
  { {0x601d0025,0x44200338,0xaf9a0024,0x2a070198}},	//   sémi, oli_, _птах_, _серп_
  { {0x442000a2,0xc2740001,0x3a740294,0xb2740339}},	//   nli_, алиј, алир, алиш
  { {0xdd250010,0x4420033a,0xfbd30009,0x8e0a0024}},	//   rūši, ili_, מתה_, _знав_
  { {0x2a97000a,0x81bc001e,0x44200107,0x79a60148}},	//   ائية_, emēr, hli_, урие
  { {0x02170093,0x683e007a,0xbb860003,0x4ddb0009}},	//   רחים_, _būda, _ملاي, _רחבו
  { {0x75280039,0x273a003a,0x3137000b,0x01370009}},	//   _izdz, _günü_, טנים_, טרית_
  { {0xdb190002,0xeab20003,0xa3b80011,0x1bfb0009}},	//   _dowó, _دعا_, चयन_, _אלאב
  { {0x44320002,0xdb000052,0x045b0012,0xf1a30048}},	//   emy_, rdmä, فجرت_, _грън
  { {0x721b000b,0x4420033b,0xdb1d0061,0x55bb0009}},	//   _רווח, fli_, _insé, עמלו
  { {0x81bc001e,0x4420033c,0xa7750048,0xb355033d}},	//   slēd, gli_, _тлич, ркаш
  { {0x6d5c033e,0xd2510012,0x644a0025,0x9f490060}},	// [3f0] bbra, زنا_, _éfin, _amaç_
  { {0x6d5c0017,0x61fa033f,0xdcfc001e,0x44f50063}},	//   cbra, nitl, sgrā, _впос
  { {0xdce30340,0xa3d50011,0x8f550012,0x8b030030}},	//   tanč, _सकल_, لناش, ěřil
  { {0xa802003a,0x8e550024,0x4fc80012,0xb4c30011}},	//   şına, аткі, ُولُ_, ्ही_
  { {0xea00001a,0x8d650341,0xa6350024,0xc0c60097}},	//   _giầy_, авле, анді, _óánæ
  { {0x3f750020,0xc27a000b,0xaaa80014,0xb5fb000e}},	//   ều_, _ברשי, _съюз_, csát
  { {0xfbd10003,0x228f0342,0xadd80009,0x7a2b0032}},	//   قتة_, lük_, רווח_, güte
  { {0x7c640003,0x2a6d0051,0x0b450014,0x6d5c0343}},	//   حاول, tseb_, шнин, zbra
  { {0x4a450001,0x11e5022a,0x7aed0344,0x83b60009}},	//   јнов, ижим, nzat, בִיא_
  { {0x84670098,0x063b0003,0x7bcd004a,0x6d4100eb}},	//   _бъде, _أسرع_, hjau, _ugla
  { {0xf1b20093,0x23c50037,0x44320002,0x55ba000b}},	//   קסט_, वादद, ymy_, _שמעו
  { {0xd5b10020,0x5b150345,0x2295022a,0x39580060}},	//   ốn_, _кмет, _видя, ırsa_
  { {0x228f000f,0x25a30058,0x81bc001e,0x1e830048}},	//   jük_, fejl_, rmēr, олям
  { {0x44200034,0x7aed0064,0x61fa0346,0xdb040018}},	//   wli_, dzat, citl, ldiç
  { {0x64a6011f,0x8f76002d,0x6d5c0347,0xdb000348}},	//   шава, _купі, rbra, rdmå
  { {0x35c70044,0xdb040149,0x7d1e0066,0xef1f0052}},	//   लाड़, ndiç, _vyps, rfür_

  { {0x89660046,0x4b550014,0x68e10051,0x5166002d}},	// [400] икаж, съст, _üldj, иваб
  { {0x48b60014,0xa1c3026d,0x70560012,0x68e40030}},	//   ищет, обуд, لنطا, _řidi
  { {0x3205002a,0x161f0037,0x6d7b0009,0x757b0009}},	//   inly_, _मीटर_, _באיח, _בטיפ
  { {0x99870010,0x1e0e0037,0x2cac0028,0x2d870349}},	//   _kinų_, ाक्ष_, æddu_, egne_
  { {0xe5c6034a,0x63a4034b,0x228f0060,0xb5fb0031}},	//   иско, mein, cük_, csás
  { {0xd49a034c,0xdd900012,0xde030024,0x8d63004c}},	//   ври_, سوب_, опчи, овље
  { {0x53e60104,0xcbe6022a,0x83f8034d,0x9c57004c}},	//   ициа, иции, лекс_, ашњу_
  { {0xa7fd003a,0xaf490012,0xfc2f0012,0xe3b20012}},	//   nsıt, _مشكل_, وحي_, زرع_
  { {0x75e20029,0x9f7b000b,0xe7b30012,0x6fb30012}},	//   _rôzn, _שנמח, _بمقد, _بمقا
  { {0x63a4008b,0xe61f0061,0x2a790031,0x9f590025}},	//   hein, ntôt_, ásba_, misé_
  { {0x7aed034e,0x9f590108,0x228f034f,0x59d30012}},	//   zzat, lisé_, zük_, تغير
  { {0x228f00a2,0x61d30044,0xf8b3000b,0xdce80029}},	//   yük_, _दक्ष, קשר_, _obdĺ
  { {0x42540012,0x9f590025,0xe1ff0064,0x63a40350}},	//   _انتر, nisé_, _kvót_, dein
  { {0x752d0066,0xadf80037,0x6008003a,0x63a40032}},	//   řaze, ्चिन_, lıml, eein
  { {0x3157000b,0xd4370003,0x7b670015,0x7bcd001e}},	//   _דיון_, لعرب, итае, tjau
  { {0x600800a2,0x7aed0054,0x228f000e,0x7ff40003}},	//   nıml, tzat, tük_, _وسيا
  { {0x6e950351,0x5e95000a,0x7bcd0006,0xe695000a}},	// [410] _الخا, _الخط, rjau, _الخد
  { {0x68e10051,0xa802003a,0xc05b002d,0x20190352}},	//   _üldk, şıla, від_, losi_
  { {0xea00001a,0x7aed000e,0x36340003,0xdce3001e}},	//   _giấy_, szat, _بريس, kanā
  { {0x5f740003,0x4f580012,0xa2360035,0x20190353}},	//   قاهر, لجهد_, āršā_, nosi_
  { {0xf1a70001,0xef1f003a,0x6008003a,0x539a0009}},	//   _крвн, zgün_, dıml, _גירו
  { {0xe618002d,0xbb3a000b,0xa1840015,0xd658000b}},	//   аді_, _תעשי, _мысл, סיות_
  { {0xddc9007d,0x55780009,0x33f50024,0xac960012}},	//   _aveţ, בעון_, йчис, منوا_
  { {0xd7740003,0xf3f2000b,0x58050012,0x5ff5004c}},	//   _واقع, ּ֣ה_, _اورك, _узбу
  { {0x68f70073,0x65680031,0x75eb0031,0x9f59008e}},	//   žadė, _fedh, _küzd, insä_
  { {0x7bc20354,0xdb060066,0xdb040018,0x86c40012}},	//   _enou, _jaká, sdiç, _بيكن
  { {0x27330020,0xcea9000b,0x34b30037,0x69d50355}},	//   _ảnh_, _רי_, ुमोद, _moze
  { {0x6d45002c,0xdb060356,0x03940024,0xeb900012}},	//   _agha, _inkö, _мрія, _يظن_
  { {0xe9ce00ac,0xc2cb0012,0x1dc30011,0x07a30357}},	//   _ек_, _جبال_, शांत, чаян
  { {0x9f59004a,0x63a40032,0x6448016d,0xd3360009}},	//   ensä_, wein, _yudi, _פרסה_
  { {0xe0550003,0xb4260003,0x8afd0066,0x40920003}},	//   _اختب, معرو, daři, _فلور
  { {0x680b0002,0x2d8c0002,0x6b890358,0x661801bd}},	//   lędn, żde_, ngeg, zovk
  { {0xb5fb0017,0x6b890359,0x63a4035a,0x06970012}},	// [420] rsár, igeg, rein, _هنية_
  { {0xb5fb0149,0x05aa035b,0x9f590061,0x4586035c}},	//   ssár, _свой_, visé_, _угов
  { {0xb8650003,0x6008003a,0xa802003a,0x7c960003}},	//   قانو, yıml, şıma, _اشخا
  { {0xd0190024,0xa067004c,0x2d870060,0x263d0064}},	//   афі_, саца_, _öner_, _dňom_
  { {0x8408000e,0x501b0009,0xa6fa0012,0x92b60012}},	//   _előá, נונו, دعاء_, _احجا
  { {0x2d9100a2,0x244e0026,0x9f590061,0xd5b1001a}},	//   _özel_, _kým_, risé_, _cá_
  { {0xd4670046,0xa3cc0037,0x65680058,0x27040011}},	//   бије_, लाप_, _vedh, रपुर_
  { {0x9473000a,0xba540001,0x69c3035d,0xdb0601bd}},	//   أدوا, овиј, _anne, _zaká
  { {0x6ff5003e,0x75eb00a2,0xdd3a000d,0x6008003a}},	//   jący, _yüzd, făţi, rıml
  { {0xee370046,0x31c60015,0xa074035e,0x1e570009}},	//   _гну_, ссив, огоч, _לשמר_
  { {0x6448035f,0x621b000b,0x20190360,0xc19b0009}},	//   _uudi, רויק, tosi_, נשטי
  { {0x61fe003a,0xa3cc0037,0x69dc0361,0x493b0009}},	//   hipl, लाफ_, öreb, טגיו
  { {0xa3cc0044,0xdce1001e,0x2d980362,0xfc170009}},	//   लान_, _ielā, ffre_, _פקדי_
  { {0x15eb002d,0xddcd0002,0xa158002d,0x93250003}},	//   уємо_, _stał, _таку_, _برمن
  { {0x3c78000b,0xe478000b,0x41dc0011,0x6ff50034}},	//   יָּב, יָּש, _मक़स, rącz
  { {0x68e10005,0xdfd10012,0xb8de0011,0xdb0f01e3}},	//   _üldi, _آية_, ीम_, _hacé
  { {0xdd910003,0x7769000d,0x27e90363,0xb7940012}},	// [430] _قوة_, _reex, _ilan_, _رؤيت
  { {0x645c0364,0x9e150024,0x49580009,0x49750024}},	//   bpri, _єдні, שֻּׁ, ілес
  { {0x7afb0029,0x1bd50048,0xdb0f0025,0xa3d50365}},	//   _ľutu, _доня, _macé, _донч
  { {0x75eb00a2,0x680b0002,0xd5bf001e,0x7a2f00b0}},	//   _düze, zędn, žādi_, møte
  { {0xf41f008e,0xdc0f0030,0xdb060366,0x62350367}},	//   _ikä_, něčn, _taká, _мему
  { {0x27180020,0x4efc000b,0x49cb003c,0x75eb0368}},	//   ọng_, נהגו, _сумм_, _füze
  { {0x27e900a2,0x6812001e,0x75eb003a,0x6ff50002}},	//   _olan_, lāde, _güze, zący
  { {0x5f940046,0x8c4202ad,0x3a990024,0xd7940048}},	//   _нист, меще, атою_, _нисъ
  { {0xdd3a007d,0x6b890369,0xdb0b0052,0x22430227}},	//   tăţi, rgeg, _ungü, _kijk_
  { {0x6b89036a,0xef1f003a,0x27e9036b,0xf9890012}},	//   sgeg, rgül_, _alan_, جندي_
  { {0xa0690046,0x6b890070,0xe5c4003c,0xdd3a004b}},	//   јама_, pgeg, _эсто, răţi
  { {0xd9a60037,0xcdc9000b,0xb8d10011,0x644200b8}},	//   _ऑस्ट, _בך_, _ऑन_, _gioi
  { {0x8db6002d,0x11d5002d,0x501a000b,0x51f50012}},	//   осві, _мікр, שורו, _وستر
  { {0xcb36000b,0x11440012,0x0446004c,0x69c3036c}},	//   _ואני_, _فَهُ, жевн, _unne
  { {0x2ea60037,0x25a5005e,0x7a300248,0x23600227}},	//   _गन्त, õlla_, näte, tbij_
  { {0xf0920009,0xa6ca0012,0xfe080081,0x200d0073}},	//   _חנה_, _نوبل_, iữa_, _njei_
  { {0x236000bd,0x3ea00027,0x6812001e,0xd6cf0012}},	// [440] rbij_, _upit_, gāde, _لقي_
  { {0x645c0108,0x244e022d,0xc9860003,0xf77f036d}},	//   ppri, _tým_, تشري, rkçe_
  { {0x80a60003,0x321a02e0,0xf0aa0048,0x224302ae}},	//   تمان, ropy_, ркел_, _dijk_
  { {0x7a30004a,0xca290009,0x7ee60012,0x44240081}},	//   däte, דם_, يكان, _óm_
  { {0xdce7001e,0x661c0070,0xf1a90011,0x680b0034}},	//   majā, oork, क़ान, zędo
  { {0xddc90013,0x78af0006,0xdce7001e,0x1cba0012}},	//   _kteř, äivä, lajā, لاعب_
  { {0x37e6002d,0xdfa60012,0x63b60073,0x75eb0060}},	//   _довг, _وحري, odyn, _yüzb
  { {0x2d80000d,0xdce7001e,0x63b60112,0x9ad40048}},	//   şie_, najā, ndyn, зжич
  { {0xcb670046,0xc1a60001,0x6442008e,0x7bdb0009}},	//   цање_, ојни, _vioi, שקפו
  { {0x68e90066,0x1a9b000b,0x81bc0035,0x929b0009}},	//   _ředi, סייע, alēn, סיית
  { {0xf2df0020,0xc953000b,0xa054002d,0xdce7001e}},	//   _ngân_, ומת_, явні, kajā
  { {0xad1b0009,0x429a0012,0x6ac60012,0x8ae60024}},	//   _דובר, _ننصح_, _وقام, _мілл
  { {0xf773000b,0xd6d80015,0x68e1005e,0x661c036e}},	//   וקר_, отр_, _üldv, fork
  { {0xdcfa003a,0x69d8000e,0x63b60002,0x25570030}},	//   _hatı, övel, edyn, dělí_
  { {0xdcfa00a2,0x2007000e,0x22430070,0xdb6b036f}},	//   _katı, énik_, _rijk_, ирал_
  { {0xda670003,0x3eb0004a,0x69d80370,0xaa550048}},	//   قائي, ältä_, _hove, зваш
  { {0x2aab0046,0x161a0037,0x8bd7000b,0xd2290003}},	// [450] штво_, धवार_, קומו_, مكره_
  { {0x68120039,0x645a01a2,0x7c3a0010,0xd1640048}},	//   rāde, _otti, įtra, дъци
  { {0x6d550002,0x69d80371,0x55bc0009,0xb4b5003c}},	//   mcza, _move, _כמזו, _эйнш
  { {0x99980010,0x2bb60037,0x27e9000e,0x6d48002c}},	//   _virš_, _अफगा, óan_, _agda
  { {0x9e64002d,0xf1bc0011,0x645a0372,0xed590373}},	//   двід, ्ञान, _atti, бол_
  { {0xbb3a000b,0x7a300052,0x8f1c0009,0xbdc7003c}},	//   _לערי, täte, בודת, ющей
  { {0x05760003,0xdcfa003a,0x6da200fa,0xd57c0009}},	//   سمية_, _batı, хища, שָׂר
  { {0x6e950015,0x2bb90003,0x7a300374,0xf7730012}},	//   _нибу, صابة_, räte, _زار_
  { {0x645a00a2,0x69d800bd,0xc7b2000b,0x201d0002}},	//   _etti, _bove, _אבן_, mowi_
  { {0x200b0002,0x69d80375,0x201d0002,0x99150024}},	//   enci_, _cove, lowi_, зьмі
  { {0x6d55003e,0xc6170037,0xc6890009,0x6c490012}},	//   dcza, दकीय_, _תא_, _الصف_
  { {0x201d0002,0xf74600de,0x34b60009,0x6d550034}},	//   nowi_, яемо, _מפעם_, ecza
  { {0xdce80066,0x33f40003,0x2477000d,0xdce70035}},	//   _oddě, _تسلس, lăm_, vajā
  { {0x725a000b,0x2ca90002,0x52d6000b,0xdef60009}},	//   _הכספ, ładu_, _מונע_, למרט_
  { {0xdce70039,0xdcfa003a,0x201d0002,0x99d40003}},	//   tajā, _yatı, kowi_, _تتنا
  { {0x487a0093,0x78ba000e,0x6b8d0376,0x69d80377}},	//   _הטקס, _átvi, ggag, _zove
  { {0x63b60002,0x661c0378,0x2477001a,0x201d0034}},	// [460] rdyn, pork, hăm_, dowi_
  { {0x4efb000b,0x6b8d002c,0x63a9006e,0x20020379}},	//   _להפו, agag, heen, liki_
  { {0x4ddb0093,0x2451037a,0x2477000d,0x6296002c}},	//   _החיו, _nám_, jăm_, styo
  { {0x2002037b,0x63a90227,0xf9890009,0xa1130012}},	//   niki_, jeen, טר_, رونت
  { {0xa3cf0037,0xdb06006f,0x3ebf0025,0x8bd70009}},	//   शान_, _bakå, _crut_, _זוכו_
  { {0xdcfa00a2,0xf1d0001a,0x9f590042,0x746a0024}},	//   _satı, _mạch_, visí_, брив_
  { {0x247701b3,0xd5b10020,0x64580061,0x44220051}},	//   găm_, ối_, _évid, _kkk_
  { {0x69d801d5,0x6d550002,0x75eb003a,0xd4670001}},	//   _sove, zcza, _müza, чиће_
  { {0x64460065,0x6d550002,0x69d8037c,0x5a3402ad}},	//   _miki, ycza, _pove, мнит
  { {0x68e100c5,0xe9f8002d,0x6831037d,0x51f80024}},	//   fyld, інні_, råde, інню_
  { {0xf1af0003,0x2477000d,0x68e1037e,0x2002037f}},	//   اءً_, căm_, _üldt, fiki_
  { {0x6d550002,0xa263001a,0xf1d0001a,0x27e60380}},	//   wcza, _khố, _bạch_, nkon_
  { {0x3bbb0009,0xf1940223,0x9f4d0248,0xb3bb0009}},	//   _למאד, _жиль, _umeå_, _למאכ
  { {0xc27b000b,0x7a2b003a,0xbb3b0009,0x4a7b0009}},	//   _פרוי, gütl, _העדי, _פרוב
  { {0xc9b7000b,0x6d550002,0x2c55001e,0xec09001a}},	//   _זהות_, rcza, _kāda_, iến_
  { {0x683f0039,0x1bd40109,0xfbd30012,0x671e0011}},	//   _līdz, нося, رتز_, _युवक_
  { {0xe8020037,0x2477000d,0xe2930003,0x877c0009}},	// [470] _लगता_, zăm_, عذر_, _האחי
  { {0x96b30037,0x64460010,0xceb4000b,0xda0c0011}},	//   _इनबॉ, _eiki, _טיפ_, िचित_
  { {0x628402d1,0x4ddc000b,0xdb0b000e,0xb5fb000e}},	//   ario, _לחזו, _magá, ppáb
  { {0xdb0f0164,0xa857000b,0xd9a90037,0x2477000d}},	//   _hací, פידה_, _कस्ट, văm_
  { {0xa2630020,0x6812001e,0x201d0002,0x24510042}},	//   _chố, nāda, rowi_, _sám_
  { {0x6da20014,0x2477000d,0x20020343,0x201d0002}},	//   виша, tăm_, ziki_, sowi_
  { {0x58840015,0x63a90381,0xe5700012,0x201d0034}},	//   _пыта, teen, اطه_, powi_
  { {0x24510382,0xf8b2000b,0x24770383,0x4429003a}},	//   _vám_, _בשל_, răm_, nla_
  { {0x2477000d,0x63a90384,0x5ac90024,0x3ebf0385}},	//   săm_, reen, ілом_, _urut_
  { {0x13060047,0x81bc0039,0x68e10386,0x2451001a}},	//   ьный_, blēm, _ülds, _tám_
  { {0xc172000b,0x2002009b,0xf1d0001a,0x66030387}},	//   כחי_, tiki_, _sạch_, mink
  { {0x3f8f00c6,0x9f4b0164,0x48e20024,0x66030388}},	//   nggu_, dicó_, тоюв, link
  { {0x7c2900a2,0x69d8000e,0x44290389,0x8f9a0009}},	//   mler, övek, dla_, חירי
  { {0xc3320093,0x9f4b0164,0x64a6038a,0x6603038b}},	//   _סוג_, ficó_, мага, nink
  { {0x81bc0039,0x644600c6,0x8cc00037,0x27ed00b9}},	//   klēj, _piki, वियो, _olen_
  { {0x7c2900a2,0x2d84003a,0xc8f90011,0x7a2b005e}},	//   nler, şme_, ्पैम_, sütl
  { {0xec090020,0x877b000b,0xb77b000b,0x41c90037}},	// [480] yến_, _ואפי, _ואפש, रांस
  { {0x6603007b,0xea00001a,0x7c29038c,0x644601ee}},	//   jink, _phẩy_, hler, _wiki
  { {0x7c29038d,0x11d70003,0x64460010,0x16c60037}},	//   kler, بولة_, _tiki, लम्ब
  { {0xa263001a,0xdb0f0066,0xc209000b,0xd0120012}},	//   _phố, _zací, בה_, خلص_
  { {0x27e6004a,0x2c55001e,0xfbdf001a,0x7c29038e}},	//   rkon_, _rāda_, _kiên_, dler
  { {0xa3cc0044,0x7bdd0052,0x4420008e,0x68360031}},	//   लाव_, ösun, loi_, ládd
  { {0x7c2900a2,0x64a30001,0x81bc001e,0x7ae4004a}},	//   fler, ваја, blēj, lyit
  { {0xfbdf008a,0xdfa6000a,0xa2630020,0xbc370003}},	//   _liên_, _تحسي, _thố, وسيا_
  { {0x23270001,0xe3af0003,0x518601b6,0xc986038f}},	//   моћи_, شري_, муна, муни
  { {0x442900a1,0xfbdf001a,0x66030002,0xdce70002}},	//   zla_, _niên_, cink, lają
  { {0x69dc0390,0x44290391,0x5ce60003,0xca48001a}},	//   _more, yla_, _تكال, _mời_
  { {0xca480020,0xd0110003,0x4429006f,0xdce70002}},	//   _lời_, الح_, xla_, nają
  { {0xe81f0044,0x6bd70003,0xfbdf001a,0x683f0066}},	//   यकता_, _تونس_, _biên_, jádř
  { {0xbf9b0392,0xf1aa0003,0x7c200393,0x2a69003a}},	//   ciên, _ذاته_, lomr, _çaba_
  { {0xdb0f02d1,0xdce70002,0x26c20030,0xd498004c}},	//   _vací, kają, _škol_, мрт_
  { {0x1bb80003,0xdb0d0017,0xdce70002,0x66030394}},	//   واقع_, ndaç, jają, zink
  { {0xdce7003e,0x5a350146,0x6d5a0395,0xc3340009}},	// [490] dają, енат, _ofta, תוּ_
  { {0x7c29003a,0x68ed0066,0x41c90037,0x69dc0396}},	//   zler, _řadi, राइस, _core
  { {0x96180003,0x69dc0397,0x7c290398,0x65750031}},	//   _تغير_, _dore, yler, mazh
  { {0xdd0d0002,0xdce70002,0x6d5a0399,0xca48001a}},	//   półp, gają, _afta, _dời_
  { {0x6603007a,0xcff80093,0x7af6003e,0x7c29039a}},	//   tink, וצאה_, czyt, vler
  { {0x04b50014,0x6603004a,0x69dc039b,0xed590055}},	//   есия, uink, örel, чок_
  { {0x6603039c,0xdcfe00a2,0x7c29039d,0x24e90024}},	//   rink, _yapı, tler, ямки_
  { {0x7c3b001e,0xdce70002,0xdb060029,0x6603039e}},	//   umur, cają, _rakú, sink
  { {0x7c2900a2,0x52a60015,0xc24501d4,0x41c90011}},	//   rler, евым_, нник, राऊस
  { {0xe1ff003e,0x7bdd0002,0x7c29039f,0x9ce70014}},	//   _swój_, _losu, sler, _оцел
  { {0x7c2003a0,0xbc68000a,0xbf9b0017,0xdc12003a}},	//   bomr, _يمكن_, riên, aşın
  { {0x34bd0037,0x35c70037,0xcc560009,0x8cae0011}},	//   ्मीद, लाक़, _טבעי_, ूटरो
  { {0x6264002d,0x6d47000e,0xaae70012,0x442003a1}},	//   _авіа, _újab, _تساو, voi_
  { {0x63bb008b,0xdce70002,0xec09001a,0xf1d0001a}},	//   ldun, zają, iếm_, _hạnh_
  { {0xfbdf0020,0x32050036,0xe1ff003e,0x07a6002d}},	//   _viên_, mily_, _twój_, _зайн
  { {0xca48001a,0x683f0010,0x442003a2,0x63bb03a3}},	//   _rời_, _būdu, uoi_, ndun
  { {0xfbdf0020,0xf1d00020,0x69dc03a4,0x63bb0052}},	// [4a0] _tiên_, _mạnh_, _pore, idun
  { {0x171b000b,0xdce70002,0xd5b1001a,0x4420004a}},	//   _מופע, wają, ốt_, soi_
  { {0x69dc00c5,0x4420007d,0xdce70002,0x629b0051}},	//   _vore, poi_, tają, htuo
  { {0x14d7000b,0xc209000b,0x629b0010,0x63ad03a5}},	//   _נוכל_, זה_, ktuo, cean
  { {0x2bd30044,0xdce7003e,0x3f9a0002,0xd6d00012}},	//   थाना, rają, ępu_, ؤقت_
  { {0xd5b30009,0x200f03a6,0x02460012,0x32050030}},	//   ָׁה_, angi_, _سَأَ, jily_
  { {0x7e7c001e,0x68e10051,0x987e0066,0x3f6a0103}},	//   _ārpu, _üldp, _péče_, _ниво_
  { {0xf1d00020,0xd3700003,0xa2c40037,0x7e7b001e}},	//   _cạnh_, جهة_, रिप्, šupi
  { {0x63b90002,0xeb9f0033,0x75280002,0xc43b0009}},	//   _dawn, _kjør_, _wydz, התקי
  { {0x4e7b000b,0x75280002,0xf65f0028,0x7dc50003}},	//   _מאמצ, _tydz, lvæg_, _لتمك
  { {0x68150002,0x2bb80037,0xa7fd003a,0x09f70009}},	//   ląda, _आसपा, msız, גמים_
  { {0xc02e0020,0x9cd7000b,0x7c650003,0x20d50010}},	//   _điều_, _רואה_, _شامل, džią_
  { {0x91e60046,0x95cb0014,0x2d8501c5,0x320503a7}},	//   _поде, пува_, óleo_, bily_
  { {0xa2c40044,0x92f2003a,0x2d91003a,0xa7fd003a}},	//   रिन्, ığım, _özet_, nsız
  { {0x19bb0009,0x7c840048,0x03c703a8,0xa25b0018}},	//   _ממגב, луте, нсам, _crôn
  { {0xdb000058,0x7a2b0032,0x68380097,0xa0970009}},	//   remæ, müti, nídd, _נדחק_
  { {0x59b70037,0xa7fd003a,0xe9870001,0x75eb003a}},	// [4b0] _असमर, ksız, ећен, _yüzl
  { {0xdb00005e,0x99990073,0xe9810024,0x63ad03a9}},	//   memä, _rusų_, ражi_, sean
  { {0x4426001c,0xef20003e,0xdb00004a,0x78ba0029}},	//   _oko_, ążek_, lemä, _štvr
  { {0x660701e4,0x200f00c1,0xe9380012,0xdb1d0248}},	//   lijk, ungi_, رسلت_, _anså
  { {0x212b008a,0x7c2d00a1,0xed4e0001,0x2369000d}},	//   ́ch_, mlar, ио_, mbaj_
  { {0xeb9f0119,0xd658000b,0xdcee001e,0x85e8002d}},	//   _gjør_, עיות_, labā, ндів_
  { {0x34bd0037,0xdb000051,0x66e7001e,0x320503aa}},	//   ्मेद, hemä, _sīkā, vily_
  { {0x7c2d00a1,0xdb00004a,0xdb4e0012,0x3035003c}},	//   nlar, kemä, يَى_, _ребё
  { {0x660700bd,0x75240066,0x13c80009,0x52a90024}},	//   kijk, řizp, תּוֹ_, євом_
  { {0x3d1a0044,0x629b03ab,0x7c2d030f,0xcaa40012}},	//   _मुझे_, rtuo, hlar, اصيي
  { {0x23e7007c,0x9be7002d,0xc952000b,0x3205002a}},	//   _підв, _підк, ימי_, rily_
  { {0x7c2d003a,0x6812001e,0x3205027b,0x2fdf0025}},	//   jlar, rādo, sily_, _joug_
  { {0x26c40013,0x443f03ac,0x7c2d03ad,0xb5fb0066}},	//   ímo_, mmu_, dlar, rpán
  { {0x644b0101,0x7c2d0051,0x600b004a,0x91e2003c}},	//   _higi, elar, tömä, _воше
  { {0x7b96007c,0x7c2d00a2,0xeb9a002d,0xc0d20012}},	//   краї, flar, мив_, _نيوب
  { {0x442d00a2,0x6f1e0002,0xd1160009,0xccf20009}},	//   nle_, ępcz, _בקצה_, בכל_
  { {0x3b070014,0x2006004a,0xbf9b0009,0xae210011}},	// [4c0] вето_, vioi_, _חיפש, यवान_
  { {0xc64a0003,0x644b03ae,0xa25b03af,0xf1aa0012}},	//   _تجعل_, _ligi, _trôn, باره_
  { {0xdce30066,0x7d7b0009,0x48b60048,0x7a30008e}},	//   raně, _קנטו, ъщат, säto
  { {0x7aeb000f,0x27e0002a,0x5fb20011,0x186703b0}},	//   ölté, _join_, ज़िल, таци_
  { {0x442d0013,0x96960098,0xa7fd003a,0x7c2403b1}},	//   dle_, треш, tsız, moir
  { {0xceb3000b,0x27e00061,0x6d480010,0x60860003}},	//   ייד_, _loin_, ždau, _لشرك
  { {0xa37b0005,0x2006004a,0xeb9f0033,0xa7fd003a}},	//   _klõp, pioi_, _kjøp_, rsız
  { {0xe4e3007c,0xeb970046,0x6ce3002d,0x27e0004a}},	//   рішн, вић_, ріше, _noin_
  { {0xea00001a,0x644b03b2,0x37140009,0x2d9603b3}},	//   _nhảy_, _digi, _עַֽל_, _арес
  { {0x644b0065,0x6804000e,0x7c2d003a,0xa697000b}},	//   _eigi, sődl, zlar, _בכמה_
  { {0xf993000b,0x44260027,0x7c2d03b4,0xdfd10012}},	//   ברת_, _tko_, ylar, ميد_
  { {0x6838015b,0x27e003b5,0x442d03b6,0xb4fb0009}},	//   bíde, _coin_, cle_, _קלאר
  { {0xa3cc0044,0x69ce0070,0xea00001a,0x4ab60011}},	//   लाई_, _onbe, _chảy_, _अनिव
  { {0x4b370093,0x2458001a,0xe9180024,0x20c60024}},	//   _סרגל_, _kém_, _полі_, _асиг
  { {0x7c2d00a2,0x660700bd,0x48e30001,0x2d5800b3}},	//   tlar, rijk, _војв, тись_
  { {0xe414007c,0x0a6b0046,0x24580066,0xfbdf001a}},	//   адсь, држи_, _mém_, _tiêm_
  { {0x7c2d00a2,0x6d5c00c5,0x6440004a,0xba740012}},	// [4d0] rlar, bcra, immi, لالت
  { {0x442d00a2,0x7c2d003a,0x75d50003,0x35b502ad}},	//   zle_, slar, _إيدا, _сбор
  { {0x21a4007c,0x7c2d00a2,0xd141003e,0x3947006f}},	//   риєм, plar, cząć_, äns_
  { {0x3b640014,0x442403b7,0x6f950012,0x20570009}},	//   _върв, jom_, الإض, דיאל_
  { {0xde580024,0xa2c40011,0x68e30248,0x5ea50012}},	//   вачі_, रिण्, ändb, امتل
  { {0x69d8000f,0xdb060066,0x68e8006f,0xf624002d}},	//   övet, _jaký, kydd, адіо
  { {0xe3b10003,0x18b80015,0x63bd0082,0xa3cf0011}},	//   مرة_, _игры_, _kasn, शाल_
  { {0xf42a004a,0x5f450003,0x442403b8,0xa3cc0011}},	//   _isää_, _منزل, gom_, लाए_
  { {0x11d90003,0xeb920009,0x68150034,0xda650012}},	//   فوظة_, צָה_, lądo, داعي
  { {0x644003b9,0x27e00061,0xd70d0011,0x628901e3}},	//   ammi, _soin_, सपैठ_, rreo
  { {0x644b002c,0x91050015,0x27e000b6,0x442d03ba}},	//   _tigi, упне, _poin_, ple_
  { {0xcbc70012,0xd00f0012,0x8cc00011,0x442403bb}},	//   _جزئي, كلٍ_, विरो, com_
  { {0x27e0004a,0x7c2403bc,0x9bb60009,0xfe710012}},	//   _voin_, voir, _תהנה_, ْدِ_
  { {0x7a7a0009,0x8e750024,0xdb040018,0x7bdb005e}},	//   _טרנס, шуюч, leiç, ljuu
  { {0x7c240108,0x6d5c002a,0x621a0009,0x6c550024}},	//   toir, rcra, _אוסק, иттє
  { {0xf092000b,0x42d6002d,0x7bdd03bd,0xc1780073}},	//   _הנה_, лізу, ösuh, _žė_
  { {0x070a0012,0x7afb0032,0x230a0012,0x7ae903be}},	// [4e0] _سيدي_, nzut, رتري_, nyet
  { {0x7bcf02d1,0x764b0061,0x7a2b0051,0xbb430024}},	//   _encu, _égyp, kütu, сеук
  { {0x98a60027,0x5d9b0009,0x659b0009,0xf9360024}},	//   čiće_, _אביה, _אייק, ухаю
  { {0x27e00065,0x61e003bf,0x788000f1,0xdb040017}},	//   ðin_, _पक्ष, _návš, jeiç
  { {0x7e2a002d,0x4a750015,0x98090003,0x69d8000e}},	//   ніка_, _выст, ختلف_, öves
  { {0xdcba0014,0x69ce03c0,0xe8560012,0xa3cc0011}},	//   ещи_, _unbe, _منسد, लाक_
  { {0xa1160003,0x54a60003,0x98be003a,0x6da30012}},	//   _صورت, احتف, yatı_, صميم
  { {0x0c730012,0xccf30009,0x63a403c1,0x7afb0032}},	//   حدود, מכו_, nfin, fzut
  { {0x81bc0039,0x63a403c2,0x41e60024,0x99630064}},	//   klēt, ifin, гіна, líši_
  { {0xa7fd003a,0x68380066,0xdd1f0029,0xd2b70009}},	//   apıl, bídc, _líši, נלית_
  { {0xf9930093,0xea000020,0xd1300003,0xc057002d}},	//   זרת_, _chạy_, تمد_, лія_
  { {0x1e1d0037,0xd36f0003,0x3c0c0030,0xad1b0009}},	//   पक्ष_, _فهم_, těvu_, _אובר
  { {0xe9800024,0x6b7b0009,0x75f00064,0x0f540012}},	//   _далi_, _טראנ, _väzn, صَّح
  { {0xdb07000f,0x63bd0039,0x52830003,0xdb06000e}},	//   ámít, _sasn, _الوك, _lakó
  { {0xa0c30012,0x683603a7,0x63bd03c3,0x7e7d0032}},	//   _هيوو, mádn, _pasn, sssp
  { {0xf1d20037,0x7bc00051,0x75eb003a,0x7a2b0052}},	//   तावन, ndmu, _müzi, hütt
  { {0x2ba60037,0xdb060029,0x497501d4,0x92950063}},	// [4f0] क्या, _taký, илас, разц
  { {0xd91b0015,0x2c510034,0x7d200031,0x200b03c4}},	//   нье_, _sądu_, ézsé, lici_
  { {0xd7e7002d,0xffe7002d,0xfaf90010,0xb0f90003}},	//   лідо, людн, lbūt_, خفاض_
  { {0xf3f10020,0xdef10003,0xa295002d,0x200b03c5}},	//   _mục_, يًا_, _камі, nici_
  { {0xb5fd007a,0x7c3a0061,0x4b7a0009,0xe37a0009}},	//   _atša, ître, _בארו, _שרשר
  { {0x7bc70039,0x48770003,0x644f0164,0xdb1f0051}},	//   ējum, _مدرس, _hici, övõi
  { {0xdb1d00c5,0x2c550039,0xc212000b,0x200b003a}},	//   _ansø, _kādi_, _והם_, kici_
  { {0x6a850014,0x62d50012,0x69c90011,0x7afb0032}},	//   алиа, لآخر, _होती, tzut
  { {0xde59002d,0x91d5002d,0x200b03c6,0xa7fd0060}},	//   _разі_, ацні, dici_, rpıl
  { {0x7a30004a,0xb9550001,0x7bdb0051,0x644f03c7}},	//   vätk, штић, sjuu, _lici
  { {0xf1b20009,0xf4840024,0x7cd90012,0x2d850132}},	//   חסי_, _гучн, _جواز_, _idle_
  { {0x644f03c8,0x200b03c9,0x92b50012,0xf3f10081}},	//   _nici, gici_, _نحتا, _dục_
  { {0x9a880003,0xd7360024,0xaa670254,0x68120035}},	//   _مَنْ_, рхнь, _стек, nādi
  { {0x644f001e,0xa2c40037,0x7ae6006f,0x7e6403ca}},	//   _aici, रिस्, äkte, _vtip
  { {0xda480009,0xab5d0034,0x399a0009,0x200b03cb}},	//   _עֲנָ, adże, _ייסד, bici_
  { {0x69c10065,0x61e3000e,0x3ead0027,0x9f1a0012}},	//   ldle, _honl, _opet_, _لآخر_
  { {0xda650003,0xfbd20009,0x7e64001b,0xb956004c}},	// [500] مالي, חתן_, _utip, атећ
  { {0x8e7b000b,0x867b0009,0xe1f703cc,0xba170012}},	//   _שניה, _שריו, агу_, ليقا_
  { {0xf3f10020,0xd8260148,0x6f660012,0x03a603cd}},	//   ệc_, аджи, لهام, _кино
  { {0x68e30163,0xb8ce0037,0x46ea0014,0x657c03ce}},	//   ända, _कह_, кден_, larh
  { {0x2fc00054,0xa6b60014,0x6812001e,0xddd60042}},	//   _maig_, рсещ, gādi, _zvyš
  { {0x443203cf,0xc6f7002d,0x6444004a,0x200b03d0}},	//   lly_, шніх_, lmii, zici_
  { {0xeb0e0044,0xed570046,0x200b003a,0x7a30004a}},	//   ाप्त_, шој_, yici_, jäti
  { {0x44320036,0xd7f20003,0x25a00066,0xe8d7000b}},	//   nly_, _بكر_, řil_, _דולר_
  { {0x69c10070,0xda660003,0x1ea90003,0x44320042}},	//   fdle, جابي, _مالي_, ily_
  { {0x6444004a,0x7e9b0009,0xfe9b0009,0x657c001b}},	//   hmii, _בסמו, _ביממ, jarh
  { {0x3a370093,0x3957000b,0x2360009b,0xf957000b}},	//   שרים_, ישים_, kcij_, יסית_
  { {0xcb6a0001,0xb5fb03d1,0x82a603d2,0xa34603d2}},	//   _раде_, ppák, _вадж, _кэлл
  { {0x67010037,0xe1fa0001,0xab5d0002,0x61e3003a}},	//   _लेखक_, _игд_, udże, _fonl
  { {0xf3f10020,0xfaf903d3,0xf6e40024,0xdb04005e}},	//   _tục_, rbūt_, іцян, ndiõ
  { {0x6ab60044,0x52b60044,0x245c000f,0x6804000e}},	//   _अनुर, _अनुस, _cím_, ződi
  { {0xd0f7000b,0x26c9001a,0x62820051,0x2d980033}},	//   _כמות_, _trao_, _kvoo, agre_
  { {0xa3a80044,0xe8e0001a,0xd2510012,0xa2c40011}},	// [510] ख्य_, ưới_, سنا_, रिष्
  { {0x68380013,0xf9930003,0x2ba60037,0x996703d4}},	//   vída, تبر_, क्ता, ртал
  { {0x44320036,0xb9c40003,0x3ead009b,0x2c550035}},	//   bly_, تقلي, _spet_, _tādi_
  { {0x1ab60037,0x4432002a,0xd7880012,0x4035003c}},	//   _अनूठ, cly_, لنمو_, щеес
  { {0x683d0108,0xec09001a,0x7a3d0061,0xe1ff0034}},	//   céde, iết_, lète, _dwór_
  { {0x68120039,0x442903d5,0xec090081,0x8de40012}},	//   rādi, loa_, hết_, يكنه
  { {0xfc3f001a,0x22590260,0x7a3d0025,0xd7590012}},	//   _khí_, _husk_, nète, _ملأت_
  { {0x3ea90054,0x61e3003a,0xd7940014,0x04560003}},	//   çats_, _sonl, _мисъ, حلية_
  { {0x7aed03d6,0xeab10003,0x645c000e,0xdb1d0061}},	//   nyat, سعة_, _érin, _basé
  { {0x61fa002a,0x7a3003d7,0x7aed0060,0xcef40012}},	//   ghtl, täti, iyat, _بأفغ
  { {0x4429004a,0x443203d8,0xb8750024,0x6444008e}},	//   koa_, yly_, алiз, ymii
  { {0x6be40003,0x7aed00b6,0xc5e90009,0x25f50011}},	//   _وكلم, kyat, _אד_, ऍसवी_
  { {0x7a300006,0x0cd00037,0x290b0002,0xfaf90010}},	//   säti, हम्म, ńca_, rbūs_
  { {0x4432002a,0x6da60001,0x69dc006f,0x61fa0358}},	//   wly_, љива, öret, chtl
  { {0x40950351,0x443203d9,0x9c59004c,0x74160012}},	//   _العر, tly_, ишту_, موسا
  { {0xfc3f0020,0x44f3001a,0x3ce5006f,0x7a30006f}},	//   _chí_, ị_, älva_, nätv
  { {0x44320036,0x77f7000b,0x68e302f1,0x6444008e}},	// [520] rly_, _למקד_, ändn, rmii
  { {0xc332000b,0x245c014a,0x200e0002,0x443203da}},	//   לון_, _tím_, ślić_, sly_
  { {0xef6500a2,0x2c550039,0xe1650003,0xe93a0001}},	//   ğını_, _kādu_, تدقي, учај_
  { {0x8b9600fa,0xef65003a,0xc0a90012,0xea000081}},	//   _уроч, şını_, شامل_, _thầy_
  { {0x68380013,0x8f9b0009,0x479b0009,0xe7f90011}},	//   bídn, ריני, רינס, ्फ़ा_
  { {0x63b60028,0x99d60003,0x6296003a,0x6dc30048}},	//   leyn, _اتحا, muyo, зсъж
  { {0xec090020,0x7589002d,0x6296003a,0xbcaa0012}},	//   yết_, рсів_, luyo, ادتك_
  { {0x62860010,0xcfaa0003,0xc7a30103,0x8fa303db}},	//   škom, _حاسم_, _ниск, _насе
  { {0x6296003a,0xfd9a0003,0x03d70009,0xd9f8003c}},	//   nuyo, _مئات_, מוקם_, иниц_
  { {0xf2d3000b,0x660e00b6,0x7abb0009,0x7de50012}},	//   פעת_, jibk, נציו, _وسلم
  { {0x20190017,0x64c60012,0x68360031,0x60110064}},	//   ério_, _ديال, mádj, sťme
  { {0x3137000b,0x6812001e,0x6836000e,0x5bc50012}},	//   מנים_, kādu, ládj, _وتنف
  { {0x41c80037,0x83360012,0x442903dc,0xf7490012}},	//   रयास, _اراض, voa_, شلسي_
  { {0x329b0093,0x9e150024,0xa2b70011,0x2327004c}},	//   _עבוד, ідві, ्टर्, _уочи_
  { {0xfc3f0020,0x44290006,0xb97b0009,0x657a03dd}},	//   _phí_, toa_, _גרוז, _meth
  { {0x317e03de,0x7a3d0025,0x9ee90012,0x99940030}},	//   latz_, rète, _نفعل_, _češi_
  { {0x1a5b0003,0x6296002c,0xd00c000b,0x442903df}},	// [530] اشرة_, guyo, _תּוֹ, roa_
  { {0x645a0108,0x9f4b0066,0xf77f0054,0x442903df}},	//   _outi, nkcí_, laç_, soa_
  { {0xe8e0008a,0x7a300006,0x3178003e,0xfc3f001a}},	//   ười_, jätu, órzy_, _thí_
  { {0x389b000b,0xa09b0009,0x7ce80009,0x825b0012}},	//   ריאנ, ריאט, _הַשֶ, _مؤسس_
  { {0x7c2900bd,0x539a000b,0x62860010,0x20190061}},	//   voer, _דירו, škoj, insi_
  { {0xdc3c001e,0xa87b0012,0x2ba60011,0x6d470031}},	//   kšēj, _محرر_, क्सा, _újak
  { {0x8ccc0037,0x69d500f1,0x44f3001a,0x4429001a}},	//   हियो, _inze, ụ_, _ưa_
  { {0xfbdf008a,0x69c5000e,0xd0100012,0x645a03e0}},	//   _tiêu_, ldhe, _كلّ_, _duti
  { {0x0ae60015,0x200f009b,0xe7dd0011,0xe1f903e1}},	//   ждый_, migi_, यानप, иги_
  { {0x78a90001,0x8a05002d,0x200f01ea,0x888503e2}},	//   аког_, ізне, ligi_, олож
  { {0xf9920093,0x32f40020,0x7a30004a,0xdc3c001e}},	//   ורי_, ày_, mätt, gšēj
  { {0x6296003a,0x69dc006f,0x81bc001e,0x44290028}},	//   yuyo, örer, slēp, _ða_
  { {0xddc2001e,0x200f0051,0xe9d90083,0x69d503e3}},	//   lpoš, iigi_, _вкл_, _onze
  { {0xf3f1008a,0xdce80066,0x3a240024,0x6b9b005e}},	//   ện_, _nedě, _еміг, lgug
  { {0x2c55001e,0x5cac0009,0x2ba60011,0x69c3008e}},	//   _tādu_, ְׁמַ, क्वा, _iane
  { {0x69d503e4,0x6b9b0051,0x6aa400c1,0xf77f03e5}},	//   _anze, ngug, ttif, caç_
  { {0x2c55001e,0x63b60028,0x6aa4002a,0x261a0037}},	// [540] _kāds_, reyn, utif, _बदली_
  { {0xea000020,0x69c303e6,0x6296003a,0x238c0010}},	//   _thấy_, _jane, ruyo, mėjų_
  { {0x20dc0029,0x69c303e7,0x02b60011,0x9b760012}},	//   pšiť_, _mane, _अन्न, _واحص
  { {0xe29a03e8,0xc66a004c,0x99850030,0xe7dd0011}},	//   _кам_, ашке_, kolů_, यायप
  { {0x645a03e9,0x777b0061,0x26cd0164,0x13b70009}},	//   _suti, _deux, _creo_, _והכל_
  { {0x62860010,0x8c66002d,0x7c360028,0x7aeb0032}},	//   škok, отид, llyr, ägte
  { {0xf77f003a,0x63a903ea,0x4ddb0009,0x8cb70012}},	//   yaç_, ffen, יחסו, قديس_
  { {0x7a3403eb,0x628403ec,0x26c0008e,0x238c0073}},	//   màti, osio, _osio_, kėjų_
  { {0x32f4001a,0x442f000e,0x7a3002fe,0x9e650012}},	//   ùy_, _dkg_, bätt, _فالن
  { {0xc3330093,0x094a0146,0x3ebb000b,0x51f8002d}},	//   ווח_, ични_, _דצמב, сною_
  { {0xf8160020,0x645a0006,0x69b7000b,0x61e30052}},	//   ước_, _uuti, חליף_, önli
  { {0x317e0052,0x69c5000e,0x2fc6002c,0x628403ed}},	//   satz_, zdhe, ndog_, ksio
  { {0x7a2f024c,0x0aba0003,0x69c303ee,0xf77f03ef}},	//   tøtt, _خطاب_, _fane, raç_
  { {0x3ea6001e,0xfba60037,0x81f80003,0x683f001e}},	//   itot_, क्रम, _دفتر_, _jūdz
  { {0x271c0020,0x1bd50014,0x80270003,0x71260012}},	//   ỉnh_, повя, _وربم, _برشل
  { {0x683f0333,0xdfd1000a,0x60240001,0xe0fb0009}},	//   _lūdz, _أية_, _одја, _כלול
  { {0xec09001a,0x27e9000d,0xe4510009,0xaabc0011}},	// [550] iếp_, _ioan_, תֶם_, ्टिक
  { {0x78a50028,0x27e9001a,0xdb0003f0,0xef650060}},	//   tthv, _hoan_, lemó, ğımı_
  { {0x9f400065,0xd7590003,0x55ba000b,0x3ea6001e}},	//   _hlið_, ملات_, _המתו, etot_
  { {0x27e903f1,0xd91b0009,0x9ed9003c,0x200f005e}},	//   _joan_, סואל, ймет_, uigi_
  { {0x7bda000b,0xf65f0028,0x15ff0037,0x200f00c1}},	//   _הקרו, kvæm_, _उतार_, rigi_
  { {0x7c2d007d,0x8e08002d,0xdd910003,0x27e903f2}},	//   loar, онів_, روع_, _loan_
  { {0x7a3003f3,0x3fb70003,0x69c50097,0x69c303f4}},	//   rätt, _وإرس, _óhei, _rane
  { {0xc2c5000a,0x7a3003f5,0xcfb40014,0x644203f6}},	//   كيبي, sätt, _обсъ, _choi
  { {0x44240003,0x69c10028,0x63a903f7,0xd5bb03e1}},	//   بروف, _óles, rfen, _все_
  { {0x238c0010,0xfad60009,0xbef80012,0x1306003c}},	//   vėjų_, פותך_, _برفض_, яный_
  { {0x69c30005,0xf865002d,0x26040012,0x63a90032}},	//   _vane, явно, _تولّ, pfen
  { {0xb4d70037,0x60160010,0xe53a0009,0x6d3a0009}},	//   ामी_, kšme, _התער, _התענ
  { {0x4dd60024,0x69c303f8,0x644903f9,0x7c2d03fa}},	//   півф, _tane, mmei, doar
  { {0x7c2d000d,0x2c55001e,0x82370012,0xa1c40024}},	//   eoar, _tāds_, _برصا, _обід
  { {0xf1b20093,0x8cce0037,0xdb0b0002,0x79810052}},	//   _נסה_, थियो, _tagó, malw
  { {0x628403fb,0x7c2d000d,0x683d0066,0x74160012}},	//   tsio, goar, lédn, أورا
  { {0x57fb000b,0xd7fb000b,0x62840010,0x6ffb0009}},	// [560] _ללקו, _להקל, usio, _להקפ
  { {0x3f8200c6,0x7d270031,0x60c90035,0x7a3401a0}},	//   laku_, érsé, _ņema, tàti
  { {0x23bd0044,0xd6250003,0x64490051,0x5577000b}},	//   ्याद, _تعيي, kmei, _מעין_
  { {0xca29000b,0xdb1d0066,0x7a300052,0x7882000e}},	//   אם_, _zasí, täts, _hívá
  { {0x7882000f,0x64490051,0xf3f1001a,0xcf260012}},	//   _kívá, dmei, _cụm_, أرضي
  { {0x7bc603fc,0xeb3b000b,0x2bd10037,0x6f020070}},	//   _haku, _לעכש, _दोबा, rzoc
  { {0x3ea60006,0x3243002d,0x7bc6002c,0xa2c40037}},	//   stot_, _черг, _kaku, रिक्
  { {0xbc670003,0x3f8202a1,0xa2c80011,0x22ae0035}},	//   أمين_, jaku_, ़िल्, pēkā_
  { {0x7bc60101,0x6b800065,0xf1e00011,0x9bb70009}},	//   _maku, ramg, नापन, להקה_
  { {0xeaaf0003,0x7bc600b6,0x6e2e000e,0x4efb0009}},	//   اعي_, _laku, jobb, _ההמו
  { {0xdfd10012,0x6568016d,0xd7950048,0x6e2e03fd}},	//   نيد_, _ifdh, минъ, dobb
  { {0x04db0093,0x1ae60014,0x3f8203fe,0xec4a003c}},	//   _לקבל, _ноем, gaku_, _узел_
  { {0xf3f10020,0xa3c00044,0xe66702ad,0xeb970048}},	//   ệm_, ंजन_, ятно, _хич_
  { {0x61140046,0x91e303ff,0x52d70009,0x53da0011}},	//   _одлу, _поче, _מודע_, भावश
  { {0x7c2d007d,0x680b0002,0x657e00b6,0xa4d40024}},	//   toar, iędz, _deph, норі
  { {0x03c40014,0x5454010b,0x80a30012,0x6c540400}},	//   нсум, евст, _أمين, ексу
  { {0x7c2d0401,0x92a40034,0xdd0c0034,0xba55004c}},	// [570] roar, ółpr, góła, двај
  { {0x5a340046,0x68380013,0x7c2d000d,0x7e6d0402}},	//   енут, bídk, soar, _itap
  { {0x7c2d007d,0xad3a002d,0xdb0b0028,0xf8b90012}},	//   poar, _квiт, _lagð, تهاب_
  { {0x27e9014d,0x2d9c0163,0xb5fb0028,0x68360017}},	//   ðan_, _över_, ppás, tádi
  { {0x6fa50037,0x7e69000d,0x9e640024,0x62490403}},	//   _कानू, _împă, евід, _džor
  { {0x7bc60404,0xfe700012,0x2d830405,0xddc4004b}},	//   _zaku, ادن_, naje_, _itiţ
  { {0x64580061,0x64490051,0x25de0011,0xfdf80009}},	//   _évit, tmei, खाती_, הצגת_
  { {0x69d800c5,0xeb990406,0x9cd80009,0xf7730012}},	//   _anve, ции_, לווה_, _سار_
  { {0xdcfc009b,0x644901f8,0x680b0034,0x3f820407}},	//   varč, rmei, będz, vaku_
  { {0xe2a60028,0xa9e40003,0x42090024,0x08890306}},	//   æðin_, ّثَن, інно_, обой_
  { {0x39450094,0x02ba0037,0x22a3001e,0x7c3a0097}},	//   ьног, _उन्न, lūkā_, ðbrö
  { {0x6d410408,0x7bc7001e,0x645e0409,0x69d8040a}},	//   _izla, ējus, _rupi, _enve
  { {0xf8c6000e,0xa2e40024,0xfbda0011,0x63bb040b}},	//   óért_, _поїд, भारम, meun
  { {0x2bbd0044,0x8d760012,0xdd920012,0x7bc6040c}},	//   ्यवा, باحا, ضور_, _saku
  { {0xb80a0003,0x7bc6040d,0x63ad040e,0x7e6d040f}},	//   _ويتم_, _paku, ffan, _etap
  { {0x680b0002,0x645a0054,0x487a0009,0x89360009}},	//   zędz, ítiq, _וטקס, _קרקע_
  { {0xf412000b,0x62860410,0xc1ea027f,0x11da0012}},	// [580] דפן_, škov, одаж_, يورة_
  { {0xfe46002d,0x68380411,0x7c290412,0x2aa60064}},	//   _інно, mídi, čera, rôb_
  { {0xafe6002d,0x106a0015,0x76400066,0x7bc60413}},	//   можл, цией_, ůmys, _taku
  { {0x63bb0414,0x680b0034,0xd6d90034,0xdfd00012}},	//   jeun, wędz, _szła_, طيت_
  { {0xa3e10037,0x7de60024,0xf5e60024,0x63bb0415}},	//   दान_, дійд, дійм, deun
  { {0x63a200c1,0x7bc90052,0xf1b80009,0xaa460024}},	//   _scon, edeu, _מֶֽל, _цегл
  { {0xdb0b0028,0xbc670012,0xf79a0012,0xacf80198}},	//   _sagð, ومون_, _ونسب_, янку_
  { {0x69c70416,0x828a00de,0x6143004c,0x683d0417}},	//   _zaje, особ_, _реса, gédl
  { {0x752d003a,0x680b0002,0xf6970012,0x22580418}},	//   ğaza, pędz, _ينفع_, _kirk_
  { {0x6b840051,0x24f60063,0x27e60419,0x64b60012}},	//   haig, _очер, ljon_, _يحار
  { {0x63ad00a2,0x72330003,0x7e6d041a,0xd4c60012}},	//   yfan, خريط, _stap, _تغذي
  { {0xb8e60044,0x628b000e,0x68e3041b,0x7e60041c}},	//   _उन_, ágok, ändi, _kump
  { {0x2905003a,0x41e60012,0x2bbd0011,0xd839001b}},	//   azla_, _يستف, ्यरा, juče_
  { {0xc1c80037,0xbb3b000b,0x69d8041d,0x828b0009}},	//   रयोग, _ועדי, _unve, _וְהֶ
  { {0x63ad0065,0x7e60041e,0xebc70001,0xe534003c}},	//   tfan, _lump, мљан, верь
  { {0xeac80020,0x2d83041f,0xa0080003,0x44220002}},	//   _kỹ_, saje_, _يقول_, _cjk_
  { {0x26c50039,0x27e6000e,0x877c0009,0x68380420}},	// [590] ālos_, djon_, _ואחי, cídi
  { {0xeac80020,0x63ad0421,0xa2c40011,0xa2940024}},	//   _mỹ_, sfan, रिज्, тафі
  { {0x6b84007a,0x61e7006f,0x63ad0422,0xf1a40048}},	//   baig, öjli, pfan, ъртн
  { {0xf7700003,0xfe710012,0x749a0009,0x7e600423}},	//   لاه_, هدت_, _צירפ, _bump
  { {0xdb1d0424,0x644d0108,0x6d410002,0x7e600425}},	//   _ansö, mmai, _szla, _cump
  { {0xc27a000b,0x7a2b0052,0xa5940014,0x2fc90070}},	//   _מרשי, hütz, връщ, _laag_
  { {0x63bb00bd,0xdce3001e,0x271b0011,0xc57c0009}},	//   teun, manī, नपुर_, חרות
  { {0x2d810051,0xee3f0029,0xdd580009,0xdb1d0030}},	//   _lehe_, dtým_, ובוט_, _zasá
  { {0xb065004a,0x17f80012,0x9dab0048,0xc6a40426}},	//   kyää, _غرفة_, _мъжа_, _архи
  { {0xc5fb0003,0x6b84000e,0xdb040017,0x89a9010c}},	//   _بعرض_, zaig, nfiá, чков_
  { {0x07a6007c,0x6d410039,0x83fc0027,0x86080012}},	//   нанн, _uzla, _suđe, _تقلق_
  { {0x60da000e,0xc4760009,0x73c50012,0xcc760009}},	//   _átme, _נתנו_, _سيتم, _נענה_
  { {0xbbbd0044,0xdce10010,0x8f9a0009,0xbf9a0009}},	//   ्यीक, _pelė, הירי, הירש
  { {0xd839001b,0x6b840032,0x27ed005e,0xceb20009}},	//   vuče_, waig, _loen_, איך_
  { {0x27ff00a2,0x62860427,0x6b840010,0xc5f20009}},	//   _olun_, škot, taig, נדל_
  { {0x27ed0119,0xfc1a0012,0x7c3b020d,0xd4910081}},	//   _noen_, أقرب_, nlur, ờn_
  { {0x7c3b000d,0x69960109,0x62890428,0x6b840429}},	// [5a0] ilur, ерех, nseo, raig
  { {0xe7ac0044,0x1677000b,0x41c60012,0xa2d30012}},	//   ट्रप, _רגיל_, عقاق, ديكت
  { {0x22580028,0x7d7b000b,0xdfda0048,0xdb1d0031}},	//   _virk_, _מניו, зъл_, _vasá
  { {0xf9890009,0xe1080009,0x08090012,0xc6a6042a}},	//   מר_, וּנָ, وزني_, ерки
  { {0x27ed00bd,0x27e6000e,0x4420042b,0xf7770009}},	//   _doen_, rjon_, mni_, געני_
  { {0x44320101,0x27e6042c,0xfcc60001,0x7c3b0190}},	//   loy_, sjon_, ељим, elur
  { {0xc5f3000b,0xeac8001a,0x7c3b0028,0x4420042d}},	//   רדו_, _sỹ_, flur, oni_
  { {0x2bba0003,0x4420042e,0xcb0a0014,0x7c3b0028}},	//   ساعة_, nni_, зход_, glur
  { {0x61ee0119,0xb4bd0011,0x6ec50012,0xe3af0012}},	//   _kobl, _इन्_, _لتلق, صري_
  { {0x22580065,0x44ce003e,0xd8f8002d,0x84e60015}},	//   örk_, _tę_, дної_, _позж
  { {0x7a2b008b,0x5a17000b,0x4432002c,0x0217000b}},	//   tütz, תקין_, koy_, תחים_
  { {0x6d5e002c,0x7c3b042f,0x80f5000b,0x889b000b}},	//   _agpa, clur, דֶשׁ_, הבטי
  { {0xd6d801d4,0x69dc0227,0x8c430430,0xee3f03a7}},	//   нтр_, _onre, _сеце, stým_
  { {0x63a60431,0x94770012,0x30a60024,0xaacd0011}},	//   _ackn, فدرا, _зрив, ़िरक
  { {0x44200065,0x11e90003,0xdce30035,0x9c470223}},	//   fni_, _تعني_, vanī, ехал
  { {0x493b000b,0x69dc0052,0x69ca0432,0x3c0c0030}},	//   _מגוו, _anre, _hafe, těvy_
  { {0x5a350014,0x600c000b,0xa2940024,0x2369004b}},	// [5b0] внат, _מִזְ, латі, rcaj_
  { {0xf2040024,0x20fc0081,0x44200433,0xa91c0064}},	//   ляхо, ỏi_, ani_, naľo
  { {0xdcfc001e,0x718b0009,0x82340012,0xec680048}},	//   parā, לְאַ, ارقا, _пряк_
  { {0xe7190003,0x69dc0207,0x6d45009b,0x87e40434}},	//   ويات_, _enre, _izha, люче
  { {0x539a0093,0xf7700012,0xcee80012,0x02bc0011}},	//   _קישו, صان_, فرون_, ्टोन
  { {0x27e00039,0x44d1007a,0xdce80039,0xceb4000b}},	//   ķina_, _ką_, _nedē, ריס_
  { {0x27ed0070,0x7c3b000d,0xdb040028,0xdce1001e}},	//   _toen_, tlur, leið, _ielī
  { {0x7bcd0065,0xa158002d,0x19580015,0x04dc0009}},	//   ndau, _часу_, _часы_, לקול
  { {0x2fc00051,0x24800027,0x7c3a0061,0x1ef80012}},	//   õige_, ćima_, îtri, _كعكة_
  { {0x929d0002,0x7c3b0028,0x44200435,0x69ca0436}},	//   szło, slur, zni_, _cafe
  { {0xa3e10037,0x7ff60012,0x62890437,0x44200438}},	//   दाद_, نسحا, sseo, yni_
  { {0x339b000a,0x2d870439,0xdb040028,0x5b15004d}},	//   _رخصة_, lane_, keið, _имет
  { {0x76480006,0x20fc001a,0x4420043a,0x2d87004b}},	//   _yhdy, ải_, vni_, oane_
  { {0x7bcb03eb,0x44200002,0xa6e30028,0xca96000b}},	//   _hagu, wni_, æðas, _ידני_
  { {0x2aab00c5,0x7bcb0167,0x15f40037,0x4432043b}},	//   løb_, _kagu, _अवसर_, toy_
  { {0x4420043c,0x3e66043d,0x69ca0060,0x2d87043e}},	//   uni_, _tôt_, _zafe, hane_
  { {0x6b840005,0x09fa0003,0x66060015,0x4432043f}},	// [5c0] _õige, وفرة_, _аппа, roy_
  { {0xfe9b0093,0x9f440054,0x60d50002,0x7bdd0440}},	//   _קיימ, _romà_, _brzm, _ensu
  { {0x7af6004a,0x18a60015,0x7e64004a,0xd5fb0009}},	//   syyt, таем, _huip, _חפיר
  { {0xef1a0047,0x66010051,0xdb040028,0x937a0012}},	//   мме_, _allk, beið, _تصدر_
  { {0x5f060014,0xf62a002d,0xc1780010,0x7e2a002d}},	//   ъзда, міки_, ybė_, міка_
  { {0x998c0066,0x68380017,0x2aab0058,0x69dc0441}},	//   vodů_, vídu, døb_, _unre
  { {0x6abc0044,0x7bcb0160,0x69ca0442,0xa91c0064}},	//   ्ट्र, _bagu, _rafe, vaľo
  { {0x6e960003,0xfc2f0003,0xab5d0002,0xccf30009}},	//   _للرا, يحي_, jeżd, שכה_
  { {0xf413000b,0x5a340406,0x7bcb0443,0xe737003c}},	//   יפה_, лнит, _dagu, _ает_
  { {0x32050444,0x683d0445,0x998c0030,0x7dc50012}},	//   ghly_, médi, rodů_, _متمك
  { {0x09f7000b,0xbb1b000d,0x319b000b,0xc19b0009}},	//   דמים_, _neîn, ובינ, ושיי
  { {0xdfd10003,0x63a40227,0x3f840446,0x1d1700af}},	//   حيح_, jgin, _jemu_, _בקבר_
  { {0x44d1003e,0x99ea0012,0x8a0600fc,0x683d0025}},	//   _są_, _يعتق_, _изде, nédi
  { {0x7bc00005,0x2731001a,0x0e340367,0x99160012}},	//   lemu, ỡng_, иняю, _لبعض
  { {0xab950447,0xde88001a,0x6d5c0029,0xde58002d}},	//   ливі, hị_, _úrad, тарі_
  { {0x7bc000b6,0x3957000b,0x260d001e,0x63a40448}},	//   nemu, _בשום_, ežot_, ggin
  { {0x36d50449,0x2019044a,0xdcee0035,0x1ec40012}},	// [5d0] _сопр, misi_, fabē, _نقيّ
  { {0xdb040065,0xe718000b,0x6618044b,0x44d1044c}},	//   reið, _שחזר_, jivk, _tą_
  { {0x7bc00179,0xab5d0034,0x2bab0011,0xa1150012}},	//   kemu, leże, _छापा, دوات
  { {0x2d87003e,0xba77000a,0xe894002d,0x4426009b}},	//   wane_, _لاست, раць, _njo_
  { {0xf3f10020,0x539a0093,0x4b7a0093,0xb2840015}},	//   ệu_, _אירו, _ראשו, _выск
  { {0xa2b80044,0xd1260003,0x68e3006f,0x2019004a}},	//   ्बन्, _هم_, änds, hisi_
  { {0x64b50003,0x2d87044d,0xdd8e0012,0x2019044e}},	//   احتر, rane_, سوي_, kisi_
  { {0x7bc0044f,0x2019003a,0x2d870450,0x5ac90451}},	//   gemu, jisi_, sane_, елим_
  { {0x2d870452,0x645d0453,0xe3b6003c,0x20190454}},	//   pane_, _misi, убы_, disi_
  { {0x1ddb000a,0xf9910012,0xe4d70012,0x3f9e0073}},	//   _تبرع_, حبة_, _لتصب, ėtum_
  { {0xa2ca0037,0x63a40455,0x5f060011,0xafdb0040}},	//   _सैन्, ygin, सैन्_, dløb
  { {0xbb1b000d,0x2d850456,0x889a0009,0x8ba40024}},	//   _reîn, _hele_, עברי, _виїж
  { {0xa3e70037,0x443f0457,0xc7d60009,0xfc300012}},	//   पान_, mlu_, אורי_, _بحل_
  { {0x22920003,0xaa920003,0x64a60458,0x20190459}},	//   _الوس, _الوث, лага, érir_
  { {0x69c100a1,0x645d0101,0x2d85007d,0x2fe60012}},	//   mele, _bisi, _mele_, _مكثف
  { {0x3ec9004a,0x2019045a,0x443f045b,0xb4250012}},	//   ättä_, cisi_, nlu_, لعقو
  { {0xc68f0003,0x8c430014,0xd36f0003,0x645d045c}},	// [5e0] _فِي_, сете, سهل_, _disi
  { {0x4439045d,0xdb0a0061,0x2d850284,0x7a300032}},	//   _eks_, énér, _nele_, lätz
  { {0xd5fb000b,0x69c1045e,0x34aa0288,0x3ea2045f}},	//   _נפטר, iele, _явно_, lukt_
  { {0xf3f10020,0xdc9b000b,0xc169000b,0x69c10460}},	//   ệt_, _איטל, לח_, hele
  { {0x68e3006f,0x69c10461,0xce360009,0xa3d70011}},	//   ändr, kele, ְאֶת_, ायन_
  { {0x69c1000f,0x2d850462,0x7a300052,0x629b0010}},	//   jele, _cele_, hätz, druo
  { {0x29550098,0x7bc002b7,0x443f0463,0x2a3b0009}},	//   _вътр, temu, flu_, _נעלמ
  { {0xab5d0002,0x68e30464,0x443f0465,0xa3ab0011}},	//   zeże, ånde, glu_, गभग_
  { {0x69c1000f,0xcff7000b,0xb21b0058,0x2d850031}},	//   fele, _עצמה_, _ivær, _fele_
  { {0x60c90039,0x32b70003,0xdcfa000d,0x2d850070}},	//   _ņemi, ادية_, _cetă, _gele_
  { {0x3a37000b,0xca370009,0xe0200011,0x629b0073}},	//   ררים_, רניה_, मचंद_, aruo
  { {0x3157000b,0x7c240027,0xa835004c,0x6d480466}},	//   טיין_, jnir, ремљ, _izda
  { {0xcaf6000a,0xa3e10037,0xddc9000d,0x20190467}},	//   _حساب, दार_, _uteţ, risi_
  { {0x201900c6,0x6828003a,0xd2500003,0x75eb003a}},	//   sisi_, rıda, _بنت_, _yüzy
  { {0xe4e4007c,0x0217000b,0x344b0001,0x443900b6}},	//   бітн, _תחום_, ечан_, _pks_
  { {0xfbdf008a,0xe7870001,0x17fb0003,0xc6e70024}},	//   _thêm_, _суко, _سرعة_, _біоп
  { {0x7a30004a,0x7c280061,0xdcf80010,0x9bc80012}},	// [5f0] läty, édra, ravę, دوقك_
  { {0x91e40001,0xd9990012,0x98a80011,0x69ce0468}},	//   бође, ئنات_, _कमाए, _cabe
  { {0x69ce008b,0x628d004a,0xa3d70011,0xa9080012}},	//   _dabe, ssao, ायम_, هيكل_
  { {0xe8d7000b,0xf093000b,0x628b000e,0xedc50011}},	//   טובר_, מנע_, ágos, _लघुछ
  { {0x66f70037,0x69c1045b,0x66e5025c,0x22590012}},	//   ुनिक_, yele, рола, _للحد_
  { {0x2bda0037,0xb88200d9,0x7c950469,0x44a50012}},	//   _मोबा, _číns, ариц, لمتق
  { {0xfdf8000b,0x69c1046a,0xf3e5002d,0x443f046b}},	//   רצות_, vele, ижко, tlu_
  { {0xdcfa007d,0x06f70011,0xc2c50012,0x7a30008e}},	//   _setă, ुनाव_, ليبي, däty
  { {0x443f046c,0xbda70003,0x0205046d,0x800402ad}},	//   rlu_, _محاو, изин, _учре
  { {0xd24e0003,0xcef40001,0x6b890051,0x7c87034a}},	//   وني_, _упућ, saeg, _буде
  { {0xd00a035c,0xd59a0009,0xd945046e,0xd12e0012}},	//   вене_, _יֹאכ, рени, ِمٍ_
  { {0xdcfe0039,0x2d8a002c,0x31360009,0xb9360009}},	//   _nepā, wabe_, ירתך_, ינתו_
  { {0x629d000e,0x79950002,0x09e500de,0xa0360009}},	//   ásod, _odzw, _волн, שארה_
  { {0x44d50333,0x7a30008b,0xd1670014,0x3ea2046f}},	//   _kā_, sätz, _съди, rukt_
  { {0x6b660098,0x2d8a0470,0x44d5001e,0xa2cd0011}},	//   иква, rabe_, _jā_, तिक्
  { {0x3ced015f,0x7afb0060,0x27e0020d,0x69ce0201}},	//   _अपने_, oyut, _unin_, _sabe
  { {0x883b007e,0xcb000037,0x69ce0471,0xd1860472}},	// [600] _בתקו, लैंड_, _pabe, илай
  { {0x9359002d,0xe1ff0028,0xb21b0262,0x41b30012}},	//   урсу_, _stór_, _svær, يمقر
  { {0x6f660001,0x661c0473,0x759b0009,0x859b0009}},	//   авез, mirk, _בייח, _בשיו
  { {0x661c045b,0xb5fd001b,0xb955004c,0x61fe0474}},	//   lirk, _bušo, стућ, skpl
  { {0xdfcf0003,0x683d0061,0x3ed40012,0xfe6f0012}},	//   بين_, cédu, إقتر, ودو_
  { {0xa613007c,0x2735001a,0x661c0475,0x94aa0012}},	//   оміч, ụng_, nirk, نطبق_
  { {0x6da30046,0xb21b0058,0xfce80012,0xb4e00011}},	//   ција, _tvær, افعي_, दमे_
  { {0x661c00b6,0xcfaa0012,0x4c9b0009,0x07a30476}},	//   hirk, _جاسم_, דבקו, _масн
  { {0x15f80044,0x52140047,0xbf9b000b,0xa3200011}},	//   ुसार_, йдит, _שימש, मपेज_
  { {0x44c7000e,0x7cdc000d,0x7178003c,0x9966004c}},	//   _fő_, _pără, ыбор_, штил
  { {0xd4910020,0xf9930093,0x661c00b6,0x69fb0009}},	//   ời_, חרת_, dirk, דליק
  { {0xa2b80037,0xdb1d000e,0x34fb0009,0xa3e10011}},	//   ्बद्, _vasú, _שהאד, दाः_
  { {0xc7b3000b,0x69a70011,0x7a30008e,0x661c0477}},	//   חבר_, _चाली, säty, firk
  { {0x18660046,0x2723001a,0x2abb0009,0x82330012}},	//   _књиг, ằng_, _סמוא, _وروا
  { {0x40940351,0xedf40044,0xe654007c,0xb8940003}},	//   _البر, _अवैध_, івсь, _البع
  { {0x5398002d,0x515b000b,0xab5d0002,0x415b000b}},	//   ився_, _בכוו, leża, _בדוג
  { {0x99670406,0x24580015,0xe1670001,0x1a5b0003}},	// [610] ател, рать_, ађен, نشطة_
  { {0xc73c000b,0x2b85001a,0xe2c80012,0xea770009}},	//   _בתחת, ặc_, ؤولو_, יגמר_
  { {0x6d5a0010,0xa3e70011,0xf2040024,0x27230064}},	//   žtar, पाद_, цято, kčnú_
  { {0x4e950003,0x80140024,0x7bc4004b,0x3f69004c}},	//   مشتر, офіц, ceiu, ћило_
  { {0x1de20044,0xa3ea0044,0xd6d9003e,0x201c0054}},	//   पांत, मान_, _była_, èvia_
  { {0xee38007c,0x6e920003,0x85780048,0x92a90034}},	//   ані_, ألوا, асът_, agłó
  { {0x69c50051,0xcd98000b,0xd6180012,0xbca80012}},	//   mehe, בדות_, جتنا_, لديك_
  { {0x69c50005,0x661c0052,0xf8b20009,0xf4120009}},	//   lehe, zirk, _משל_, ּ֤ה_
  { {0x6032001e,0xe7eb0011,0xe299004c,0x60060478}},	//   lāmg, टाना_, ћао_, _nóma
  { {0x44d50039,0xa2050479,0xcb120009,0x1a05047a}},	//   _tā_, спод, פלי_, спом
  { {0xa3d70037,0x3f89042f,0x629d01e9,0x3860005e}},	//   ायद_, _beau_, ásob, _piir_
  { {0x661c0052,0x69c50052,0x34b60009,0xd7ef0012}},	//   wirk, hehe, _לפעם_, ّكَ_
  { {0x7e61004a,0x661c047b,0x63a9047c,0xaac60011}},	//   _kilp, tirk, mgen, _रैंक
  { {0x99850003,0x3f9e003a,0x77430012,0xa2db0011}},	//   _الثو, ştu_, سَّم, निन्
  { {0x661c003a,0x61e3047d,0xddcd000d,0x61fc047e}},	//   rirk, _innl, _staţ, örle
  { {0xf3f10020,0x78fa000b,0x60dc03ee,0x644f047f}},	//   ệp_, _תפקו, ærme, _chci
  { {0xfe72000a,0x38b10029,0x63a90347,0xd4550024}},	// [620] _عدة_, lár_, igen, ітсь
  { {0x2002004a,0x6d41003a,0x69c501e0,0xcaa50012}},	//   lkki_, _oyla, gehe, تصفي
  { {0xa3d70044,0x04b60014,0xdcfe000d,0x395c006f}},	//   ाया_, _успя, _depă, ävs_
  { {0xa6e90020,0x20020006,0x4f0a0063,0xe7eb0011}},	//   _trự, nkki_, лнен_, टाया_
  { {0xadec015f,0x248d0039,0x6d41003a,0x60c9001e}},	//   ञापन_, ņemt_, _ayla, _ņemt
  { {0x44d80066,0x4733002d,0x6d410010,0x6032001e}},	//   _kč_, чніс, _byla, lāmd
  { {0xdd99002d,0x63a90480,0xf8780009,0xa0a30198}},	//   рші_, fgen, _כְּל, _нард
  { {0x3a3a0163,0x68150002,0xb2740447,0xc274004c}},	//   lopp_, ządz, олиш, олиј
  { {0xfbd3000b,0x93fb000b,0x644400fd,0x42540012}},	//   לתה_, טלקי, ilii, ينبر
  { {0x60060074,0x3eb90248,0x63a90481,0xbe1300ae}},	//   _róma, _ästa_, agen, _فوقع
  { {0xabaa0003,0x4ddb000b,0xeb9a0048,0x3f890025}},	//   _مهام_, _תחבו, _бие_, _peau_
  { {0x3942001e,0x82a600de,0xc4d30009,0x61e300b0}},	//   āks_, _гадж, _מגע_, _ennl
  { {0xab5d003e,0x60dc0058,0xa3e70037,0x501b0009}},	//   leżn, ærmb, पास_, רוכו
  { {0xddcd0002,0x862701d4,0xcd740048,0x38b10482}},	//   _uważ, сьме, згръ, bár_
  { {0x4c98000b,0x55590048,0x9f4401a0,0x69c50483}},	//   יֹּא, равя_, _comú_, vehe
  { {0xcc77000b,0x321e0484,0x00770009,0x68150034}},	//   מעלה_, lity_, _פתחי_, sądz
  { {0x7a3d0108,0xe3b00003,0xeab00003,0x6b8d0070}},	// [630] mètr, عرف_, فعل_, raag
  { {0x32070485,0x99670209,0xddab0103,0x7e7d0486}},	//   óny_, стал, _стил_, mpsp
  { {0x094b010c,0x753a0032,0x321e008e,0x237f0034}},	//   учаи_, ützt, iity_, ybuj_
  { {0x69c5008b,0xad1a000b,0x248d001e,0x69da0028}},	//   sehe, _כותר, ņems_, _óten
  { {0x8e55002d,0x38b1000e,0x8f9c0009,0x8d650487}},	//   откі, zár_, רידי, овле
  { {0x56b80009,0x999e0073,0x171c0009,0xdc990488}},	//   צפון_, imtų_, נוגע, атиш_
  { {0xfbda0037,0x20020028,0x63a901e0,0xcc8602ad}},	//   _मोहम, ykki_, tgen, обще_
  { {0x6b840051,0x9f350024,0x58050012,0xdb0d01e3}},	//   _õigl, _дебі, _بورك, leañ
  { {0x7e61038e,0x23290129,0xab290489,0x4209004c}},	//   _tilp, ропи_, ропа_, инио_
  { {0x38b1000f,0x31250015,0xb5fd0027,0xb2360012}},	//   tár_, ждог, _mušk, يكيا_
  { {0x2903048a,0xd7ea0177,0x621a0009,0x63a90227}},	//   ája_, амне_, שותק, pgen
  { {0xa3ea0044,0x290b0002,0x38b10028,0x3ea0048b}},	//   माण_, ąca_, rár_, šite_
  { {0xd4910020,0x20020006,0x34c20044,0x2903009b}},	//   ần_, rkki_, शब्द, šja_
  { {0x27380020,0x27e0001e,0x2ca7002a,0x321e03e0}},	//   ứng_, ķini_, ound_, city_
  { {0xdbc70065,0x44290065,0xed5a048c,0x3e6f005e}},	//   töðu, fna_, ров_, _eüt_
  { {0xc4d20093,0x1c46002d,0x68360029,0x2407002d}},	//   וגל_, інам, hádz, онси_
  { {0xdbc70028,0xa3c90011,0xdb110025,0x7c29048d}},	// [640] röðu, ऊज़_, éfèr, iner
  { {0x7c290052,0x644401a3,0x6b8b048e,0x27e50035}},	//   hner, slii, _legg, ēlne_
  { {0x63af0006,0xd6d9003e,0x6444048f,0x55bb0009}},	//   ännö, _było_, plii, _דמיו
  { {0x7c3b0108,0x1eaa0012,0x44290490,0x7c290491}},	//   jour, لاتي_, cna_, jner
  { {0xa3e70044,0x62860066,0x6e3c0070,0xa8570009}},	//   पार_, škoz, oorb, קינה_
  { {0xa6e30065,0x2ba80037,0x3ecb000b,0x44200492}},	//   æðis, गलवा, שֶׁ֣, lii_
  { {0x25a000a2,0x2ca70065,0x1db20037,0x2d8e0052}},	//   ğil_, gund_, _जानत, rafe_
  { {0x44200493,0x321e0002,0x25a0003a,0x7c3b0061}},	//   nii_, wity_, şil_, gour
  { {0x6ab6003e,0x2489001b,0xe7f90011,0x9c870064}},	//   ntyf, ćama_, ूसरा_, _počú
  { {0x44200494,0xa2bb0009,0x44290495,0x2ca70496}},	//   hii_, סמיט, zna_, bund_
  { {0x104b0047,0x3cf60037,0xc173000b,0x321e0497}},	//   иями_, ीनों_, וחת_, rity_
  { {0x321e002a,0x4429006f,0x7c3b0440,0x1ae6003c}},	//   sity_, xna_, cour, _моем
  { {0x77640098,0x6e3c0260,0xcf930009,0xa3d70011}},	//   държ, forb, וטר_, ायर_
  { {0x44290002,0x2d8c0052,0x6b8b0070,0x40940012}},	//   wna_, _jede_, _zegg, _فلتر
  { {0xa3e70044,0x317b000b,0x2d8c0498,0xa4d40024}},	//   पाल_, _דרומ, _mede_, морі
  { {0x2d8c0262,0x80c70011,0x6ff40012,0x78a80040}},	//   _lede_, ़बरे, _يسيط, mudv
  { {0x416b0001,0x44290499,0xd839017b,0x69c80227}},	// [650] ајем_, rna_, juči_, oede
  { {0xa2b20037,0xdb110061,0x2d8c0260,0xd5b20011}},	//   _आमन्, éfér, _nede_, _जायज
  { {0x81bc0039,0x68360029,0x6024000e,0x18a4002d}},	//   tnēj, vádz, sőme, даєм
  { {0x2d910027,0x98b30027,0x69c8049a,0x4420049b}},	//   laze_, žeći_, hede, cii_
  { {0x63ad038e,0xb7dc000b,0x76c70003,0xf2070014}},	//   mgan, יקאי, تغال, _дяво
  { {0x63ad049c,0x69c8049d,0xe618002d,0xe7300012}},	//   lgan, jede, оді_, خصم_
  { {0x7c3b049e,0x68360064,0x7e6d016d,0xe3c50012}},	//   tour, rádz, _luap, كْثَ
  { {0x2ca7049f,0x63ad04a0,0xb8ff0011,0x73fb0009}},	//   rund_, ngan, ति_, יּ֖ו
  { {0x29ff0002,0x2d8c04a1,0x2ca704a2,0xa2d20012}},	//   ałań_, _fede_, sund_, فييت
  { {0x11d5000a,0x6b8b04a3,0x7c3b04a4,0xddc4001b}},	//   ستخد, _wegg, sour, _stiž
  { {0x38b503ee,0xcea90009,0x394504a5,0x61fc0248}},	//   når_, _תי_, яног, örla
  { {0x6e3c0052,0x69d504a6,0xdcfa0030,0x9c820030}},	//   worb, _laze, _letě, áčen
  { {0x63ad00c5,0x93270012,0x63bb04a7,0xa2e50264}},	//   dgan, _بران, mfun, _холд
  { {0x9c8204a8,0x2d8c0017,0xa2f6000b,0x69c804a9}},	//   ščen, úde_, _ממנה_, cede
  { {0x61420001,0x1d0701ef,0x40920012,0x442004aa}},	//   _пеша, пери_, _كلور, tii_
  { {0xb89a000b,0x68fc006f,0x25e20011,0x78fa0009}},	//   _הבקש, ärde, _टोनी_, _לפצו
  { {0x2fc00101,0x442004ab,0x06970012,0xd38704ac}},	// [660] _ibig_, rii_, _فنية_, яйте_
  { {0xa3e20037,0x6ab60002,0x4a4304ad,0x25db0011}},	//   _फोन_, rtyf, енув, _गोली_
  { {0x2d8c04ae,0xd5fb000b,0x5dfb000b,0xb5fb000b}},	//   _rede_, _הפיר, _הפינ, _הליכ
  { {0xde6d001a,0x46ea00de,0x69c80123,0xd0190024}},	//   _hươn, йден_, zede, офі_
  { {0x073a000a,0x69d50149,0xf8a80037,0x6d40003a}},	//   حساب_, _faze, _कम्प, şmad
  { {0x69d504af,0x6b840032,0xd839001b,0x02460012}},	//   _gaze, lbig, ruči_, _رَأَ
  { {0xdb0f0108,0x629d000e,0x2d85000e,0x63bb0052}},	//   _accè, áson, űleg_, ffun
  { {0x8cbd0037,0xde6d001a,0x69c804b0,0x929d0034}},	//   _शहरो, _lươn, wede, zyłe
  { {0x6b84002c,0x69c804b1,0x6296002c,0x61f8017b}},	//   ibig, tede, nsyo, _povl
  { {0x27e00039,0x320a0002,0x6faa0037,0x69c804b2}},	//   ķinu_, óby_, _काउं, uede
  { {0xb4c80037,0x6aa40358,0xdd7b000b,0x2ee000b6}},	//   ोटो_, hrif, _הטבל, _arif_
  { {0x62960101,0xe45a04b3,0x4420003a,0xc4c50012}},	//   ksyo, _уже_, _öi_, _تتكو
  { {0xf2060098,0x56940048,0x78a80040,0x2d910064}},	//   _няко, наят, sudv, taze_
  { {0x9c8304b4,0xd29b000b,0xa2db0037,0x3205002a}},	//   účov, _פשוט, निस्, ckly_
  { {0x49bb000b,0xc1bb000b,0x19bb007e,0xde6d001a}},	//   _המוס, _המוש, _המוב, _dươn
  { {0x6b840101,0xdfd10012,0x929d0034,0x69d50030}},	//   gbig, _شيخ_, syłe, _saze
  { {0x6aa4008b,0x8f9c000b,0xc6190015,0x979c000b}},	// [670] grif, _היחי, _моих_, _השחק
  { {0x20c80044,0x6f0f003a,0x63ad04b5,0xde6d0081}},	//   रबंध, ıncı, sgan, _gươn
  { {0x60320039,0x7fd5002d,0xe3c70010,0x55ba0009}},	//   lāma, ділі, ščių_, _ומתו
  { {0x290f0002,0x7af20030,0xdc880009,0x2c7104b6}},	//   ąga_, _šetř, _מְשָ, _rád_
  { {0xdcf8001e,0x16a9002d,0x2907013a,0x9ea90024}},	//   kavē, івки_, šna_, івка_
  { {0xc604002d,0x45d20001,0x68e1000e,0xb9c50012}},	//   нзій, вољс, _áldo, _تقسي
  { {0x24890027,0xd2500012,0x8cd30011,0x63bb04b7}},	//   ćamo_, _إنّ_, डिटो, tfun
  { {0xdfd40015,0xdb0f04b8,0x13090055,0x3a990198}},	//   _посы, _accé, жний_, отою_
  { {0x2d9e0028,0x35b500b5,0x05dd0011,0x17f80012}},	//   ótek_, _обар, मयाब, _عرفة_
  { {0x22560003,0x86c40012,0xe8100011,0x3eab04b9}},	//   وليد_, _سيمن, ासभा_, duct_
  { {0xc6090037,0x07a604ba,0x7c2d03ce,0x8fa600ac}},	//   वसीय_, манн, knar, мане
  { {0x7c940012,0xbb550012,0xde6d0081,0xa03a0012}},	//   _أشلا, _قناب, _sươn, تأخر_
  { {0xc9f50003,0xa3ea0037,0x7c2d009b,0xac06002d}},	//   _يستع, मार_, dnar, _інша_
  { {0x200d0054,0x09e40024,0xf1ac0011,0x3f820034}},	//   _llei_, _поін, _चाइन, dłuż_
  { {0x9e630046,0xe1f00003,0x3eb90070,0x442d04bb}},	//   тврд, _حسن_, atst_, one_
  { {0x443f04bc,0x9c7c01bd,0x442d04bd,0xdbf20030}},	//   nou_, _urče, nne_, přís
  { {0xde6d0020,0xc053000b,0x6aa40051,0x7c2901bd}},	// [680] _tươn, _בזה_, urif, čerp
  { {0x443f0013,0x2b8c001a,0x6296002c,0x64490052}},	//   hou_, ếc_, rsyo, hlei
  { {0x443f014a,0x851c0011,0x2006008e,0x200d04be}},	//   kou_, _भेंट_, tkoi_, _blei_
  { {0xa2db0044,0x6296002c,0x787a0073,0x442d04bf}},	//   निश्, psyo, _nįve, jne_
  { {0x629d000e,0x443f04c0,0x644904c1,0x200704c2}},	//   ásol, dou_, dlei, ênia_
  { {0x44ce0066,0xa2db0037,0x644904c3,0x01660012}},	//   _př_, निर्, elei, _يُحَ
  { {0xd5ed008a,0xa3ea0037,0x94aa002d,0x0caa002d}},	//   _quả, माल_, ітка_, ітки_
  { {0x443f0017,0x27e0001e,0x68e30058,0xaa7b0029}},	//   gou_, ķins_, ænde, _urýc
  { {0x61fc012b,0x6e23002c,0x3e7b004b,0xfbcf0012}},	//   _korl, binb, _câtă_, شتي_
  { {0x4efb0009,0xcb57000b,0x442d04c4,0xc3330009}},	//   _והמו, וספה_, ane_, כוח_
  { {0x25eb0037,0x644904c5,0xdfd10012,0x9e650012}},	//   चारी_, blei, هيد_, _ساكن
  { {0x443f04c6,0x60320035,0x60240031,0x0bd40012}},	//   cou_, tāma, tőma, _سيتح
  { {0x442404c7,0x61fc0070,0x64400010,0xdb24004a}},	//   mim_, _oorl, momi, äräy
  { {0x8a030014,0x6032001e,0x3eab04c8,0x929d0034}},	//   _изче, rāma, ruct_, syłc
  { {0x443f0020,0x64400051,0x718b0009,0x6ed50011}},	//   _ưu_, oomi, _וְחַ, _मैनु
  { {0xfc300012,0x889b0009,0xb89b0009,0x69da04c9}},	//   لحق_, _ובהי, _ובהש, ldte
  { {0xa3b60037,0xcd040066,0xba550001,0x7c2d04ca}},	// [690] _जान_, vněž_, евај, rnar
  { {0x443f04cb,0x45d5004c,0x442d04cc,0xd2b70009}},	//   zou_, _џонс, zne_, ולמת_
  { {0x39470058,0x8e380012,0xdb040031,0x644004cd}},	//   æns_, _تسير_, rgiá, komi
  { {0x64400010,0x443f0017,0x155a000b,0xa2a70037}},	//   jomi, xou_, _מכתב, _चिप्
  { {0x9f400065,0x3d170037,0x937a000b,0x38b8000e}},	//   ðið_, _भेजे_, _מטרת, hér_
  { {0x7bc20036,0x442d003e,0xc3320093,0x9f59006f}},	//   _abou, wne_, _תוך_, ckså_
  { {0xe3b1000a,0xfdf8000b,0x443f04ce,0x6aad0097}},	//   هرة_, וצגת_, tou_, luaf
  { {0x442d007d,0x61fc003a,0x6e23006f,0x644004cf}},	//   une_, _zorl, sinb, gomi
  { {0x78ba0033,0x442d04d0,0x8a0504ad,0x645b04d1}},	//   ettv, rne_, езпе, rmui
  { {0xe1f1000a,0x5d840003,0xa2a70037,0x9c8204d2}},	//   اسة_, _للكل, _चिन्, ščan
  { {0x69d800a2,0x6594007c,0x2d87009b,0x38b80058}},	//   _dave, _раху, mbne_, gér_
  { {0x68fc006f,0xf649000b,0x2be50011,0xa3b60011}},	//   ärda, _הצ_, काओं_, _जाय_
  { {0x7ae204d3,0xef120009,0x69d804d4,0x2ac30035}},	//   _grot, ָּר_, _fave, nībā_
  { {0xa3d70037,0xdd920003,0x2d9e0061,0x8afa0009}},	//   ायक_, طور_, ûte_, _מהני
  { {0xd00a0046,0xa3b60011,0xddc90412,0x7bd9016d}},	//   _неке_, _जाम_, _otež, _kawu
  { {0xb6020013,0xe73a0015,0xd91a000b,0xccf20009}},	//   _žádo, _ней_, _מוצל, נכן_
  { {0x1f66002d,0x52aa02ac,0xfaa304d5,0x437504d6}},	// [6a0] _яким, явам_, лато, туст
  { {0xa3b10037,0x7c24004a,0x442404d7,0xe9d704d8}},	//   फ़्त_, siir, zim_, нку_
  { {0xa3ea0098,0x4424003a,0x1bea0014,0x61fc04d9}},	//   _една_, yim_, _едни_, _vorl
  { {0xa3ba0037,0x442404da,0x61fc04db,0xfbae0011}},	//   _आउट_, xim_, _worl, _टाइम
  { {0x442404dc,0x3f860004,0x2f970009,0x600601e3}},	//   vim_, rbou_, תכנן_, _cómi
  { {0x999a0034,0x29050073,0xf2d30009,0xfe790030}},	//   żyły_, kyla_, _געש_, _trůn_
  { {0x81bc001e,0x442404dd,0x8c1a0009,0xdc030030}},	//   inēt, tim_, ּוִי, ačís
  { {0x961d0044,0xd4670046,0xccf3000b,0x6440004a}},	//   _नष्ट_, није_, רכה_, uomi
  { {0x6d48003e,0x69d8007a,0x07b7000a,0x2ac3001e}},	//   _wyda, _pave, _سهلة_, cībā_
  { {0x442404de,0xe9f80024,0x644004df,0x38b804e0}},	//   sim_, єнні_, somi, tér_
  { {0x0b8a00e3,0x290a000f,0x9f440164,0x7ae204e1}},	//   _если_, ába_, _tomó_, _wrot
  { {0x929d003e,0x2897000b,0x69d8002a,0x2c7504e2}},	//   syła, עדכן_, _wave, _råd_
  { {0x93fb000b,0x7bcd04e3,0x69d804e4,0xabfb0009}},	//   _מלאי, veau, _tave, _מהאר
  { {0x8cd70037,0x29050066,0x5eeb0009,0xb8f40012}},	//   _मनमो, byla_, הַלְ, _لكتب
  { {0x248d0027,0x8c250012,0x58d40048,0xda650012}},	//   ćemo_, نفسه, _ройт, _شاهي
  { {0x21030029,0x59c60011,0x8cc20011,0x442204e5}},	//   nčiť_, _रॉबर, _लहरो, _cmk_
  { {0x6b840005,0xc3340009,0x7b740012,0x49cb003c}},	// [6b0] _õigu, דוּ_, اطفا, зуем_
  { {0x7bcd04e6,0x6d4104e7,0x78a804e8,0x21030064}},	//   seau, ülas, ordv, hčiť_
  { {0x5f950014,0x48ab0014,0xc078002d,0x6250004a}},	//   виет, ятам_, есії_, päon
  { {0xfbab0047,0x629d000f,0x200b0066,0xf4070012}},	//   _этой_, ások, nkci_, _أبدً
  { {0x6283001c,0x79a70001,0xc66b003c,0x21030064}},	//   ćnos, _прве, чшее_, dčiť_
  { {0x171c000b,0x62500051,0x2ac3001e,0x644d04e9}},	//   הודע, näol, rībā_, llai
  { {0xdce10002,0x6cd20003,0x25d8000b,0x69c10037}},	//   _oglą, لقوا, גוון_, र्णी
  { {0x7c84004c,0x644d04ea,0x8ca20011,0x5f740012}},	//   ћује, nlai, _गिरो, _ماكر
  { {0x3ced0011,0x68fc0248,0x961d0035,0x02bd0011}},	//   _अपके_, ärdn, _atņe, ्बेन
  { {0x2fcf04eb,0xf9910012,0x201c0035,0x85b8004c}},	//   legg_, جبة_, īvie_, _плус_
  { {0x6abb04ec,0xc1720009,0x93b5004c,0xd6560009}},	//   stuf, יחי_, _абец, _סיעת_
  { {0x7d070002,0xa0880009,0x764304ed,0x27ed0032}},	//   dyjs, עְתִ, lony, _jnen_
  { {0x93940003,0x441a000b,0x78a80070,0x9aa40003}},	//   _إجما, _קונס, ardv, _ممنو
  { {0xceb20009,0x6f060034,0xc5d50024,0x6b8904ee}},	//   ביך_, rykc, лісь, lbeg
  { {0xdcfc0039,0xdde4000e,0x201a0012,0xb1160012}},	//   varē, ésőb, _يتبع_, _لقوا_
  { {0x644d0061,0xd1640048,0x27ff0132,0x6b8904ef}},	//   glai, _съчи, _noun_, nbeg
  { {0xee3a04f0,0xab660014,0xab270103,0x62660012}},	// [6c0] _они_, твал, вота_, ناطق
  { {0x1757000b,0x6b890032,0x48e6004c,0x7d010032}},	//   _בספר_, hbeg, козв, älsc
  { {0x2d9804f1,0xdfda0048,0x7d070034,0x35c40011}},	//   mare_, дъл_, cyjs, ल्फ़
  { {0x6aa90119,0x661d007a,0x78fa007e,0x644d04f2}},	//   kref, _įska, ופעו, clai
  { {0x443204f3,0x5ed30012,0x7ed30012,0xc6d30012}},	//   mny_, لتوز, لزوا, لتوت
  { {0xa2a701e1,0x443204f4,0x8f1b000b,0x2d9804f5}},	//   _चित्, lny_, וונת, nare_
  { {0x44320002,0xd5e9001a,0x7f860003,0x61ee04f6}},	//   ony_, _qué, _للأن, _inbl
  { {0x6459003e,0x2cf20037,0x2000000d,0x69dc04f7}},	//   _chwi, _अपील_, _noii_, _hare
  { {0x69dc00ec,0x20d3007d,0x2d980163,0xd6cf0003}},	//   _kare, _aţi_, kare_, _وقف_
  { {0xd8f8002d,0x69dc0070,0x2a6a000e,0x76430002}},	//   еної_, _jare, öbb_, cony
  { {0x2d9804f8,0x47d50012,0x98c5001b,0x6aa904f9}},	//   dare_, هيدر, čuće_, aref
  { {0x27ff0065,0x443204fa,0x032604fb,0x3ea904fc}},	//   ðun_, jny_, _иден, šate_
  { {0xdcf50039,0x4ea70014,0x63a200c1,0x96f80014}},	//   pazī, ърна, _idon, веят_
  { {0x69dc0133,0xc0aa0003,0x2d9804fd,0x08fa0012}},	//   _nare, _قابل_, gare_, _يرغب_
  { {0x20d30003,0x6b840051,0x6d4004fe,0xdfd10012}},	//   _نتيج, _õigs, şman, _هيث_
  { {0xec3401b6,0x7d070002,0x764304ff,0xd0f70009}},	//   ансь, ryjs, zony, _ימות_
  { {0x7d070002,0xfe790066,0x36050003,0x5a3500a6}},	// [6d0] syjs, _prům_, _موظف, гнат
  { {0x2d980500,0x44320501,0x69dc0502,0x52140198}},	//   care_, any_, _care, адут
  { {0x26080044,0x5f770003,0x644d0503,0x44320504}},	//   _सकती_, ناشر, plai, bny_
  { {0xac19002d,0x44320002,0xd491001a,0xe10b0009}},	//   _чому_, cny_, ầu_, וּדָ
  { {0x7c3a000f,0x501c0009,0xf7700012,0xa3d60011}},	//   étre, וואו, زان_, ाजन_
  { {0x62720002,0x63a20505,0x3eaf0506,0x7bdd016d}},	//   _młod, _adon, rugt_, _hasu
  { {0x3f990066,0x7bdd0507,0x25a9003a,0xfbd10003}},	//   kasu_, _kasu, ğal_, متة_
  { {0x2d98007d,0x44290508,0x6aa90509,0x249e0064}},	//   zare_, nia_, tref, átmi_
  { {0x7bdd050a,0x36d40447,0x4429005e,0x04560012}},	//   _masu, _котр, iia_, دلية_
  { {0x44320002,0x2d98000d,0x386d050b,0x4ea40048}},	//   zny_, xare_, _hier_, _ърса
  { {0x4432050c,0x4429050d,0xabb50003,0x2d98050e}},	//   yny_, kia_, _مماث, vare_
  { {0x4429004a,0x999e0030,0xafdb0040,0x7bdd050f}},	//   jia_, botů_, dløs, _nasu
  { {0x539a000b,0x2d980510,0x765a004a,0x7e600070}},	//   _ניסו, tare_, _yhty, ïmpo
  { {0x06560003,0x44320002,0xb7c2001e,0x98e50003}},	//   انسح, wny_, ēģin, _مكتو
  { {0xd5b8001e,0x03a60511,0x44320512,0x7bdd0513}},	//   ļā_, ливо, tny_, _basu
  { {0x44e300a2,0x59c60037,0x69dc0514,0x2d980515}},	//   _mı_, र्नर, _sare, sare_
  { {0xc0170009,0x6250008e,0x62720034,0x44e30060}},	// [6e0] _תקפו_, säom, _głod, _lı_
  { {0x81a50003,0x44320516,0x36f70009,0xeef70009}},	//   لحمل, sny_, _עצים_, _עמיר_
  { {0x44e3003a,0xd00a0014,0x7c290517,0x3ea000b0}},	//   _nı_, неже_, kier, _hvit_
  { {0xe73a0047,0xb8dc0037,0x69dc0518,0xaaac0037}},	//   нее_, _आम_, _ware, _चिपक
  { {0x539b000b,0xc7a30014,0xdfcf0003,0xadf00037}},	//   _איכו, сичк, ثين_, चालन_
  { {0xceb3000b,0x386d0519,0x12eb0009,0x3f990034}},	//   מיד_, _eier_, _אַלּ, zasu_
  { {0x7c29051a,0x30d8000b,0x7ae4051b,0x6282051c}},	//   fier, _בַּע, lvit, _stoo
  { {0x79950002,0x28030066,0x7c29051d,0x8f970012}},	//   _zezw, ěrná_, gier, _منفذ_
  { {0xf5b60003,0xaae60003,0xd4030015,0x7bdb000b}},	//   _مصاد, اسبو, сящи, תקפו
  { {0xf2d3000b,0x7dc50003,0xddcd0066,0x660100b6}},	//   צעת_, _نتمك, _staž, _golk
  { {0x7c29051e,0xddcd000d,0x9c7c0029,0x09f7000b}},	//   bier, _luaţ, _krčm, אמים_
  { {0xaae6000a,0xb606001e,0x62720034,0x998c0073}},	//   _مستو, _lašā, _płod, todų_
  { {0xcf270003,0x6d40003a,0x7bdd051f,0xa2940024}},	//   ارجي, şmal, _rasu, _талі
  { {0xd2b70093,0x27310020,0x4429003e,0x44e3003a}},	//   _עלות_, ạng_, wia_, _yı_
  { {0xa2a70044,0xe97b000b,0x44290520,0x75140009}},	//   _चिह्, _אנוש, tia_, בַּע_
  { {0x60060097,0x44290521,0x8d5b00af,0x60c50522}},	//   _dóms, uia_, תכלי, _ähma
  { {0xd2bb0012,0x7ed70012,0x59c60011,0x290d0064}},	// [6f0] عارض_, _إزعا, र्भर, čkať_
  { {0x386d0033,0xdb160028,0x44290523,0x7c290524}},	//   _sier_, reyð, sia_, zier
  { {0x7bdd0005,0x6013003a,0xdcfc0010,0x7d7a000b}},	//   _tasu, _açma, darė, _בנתו
  { {0xb4fa000b,0x7c290052,0xe84b0003,0x79950002}},	//   _ספרי, xier, رجان_, _wezw
  { {0x6b8d00c6,0x6ec40003,0x539a0009,0x2d940029}},	//   mbag, متوق, _בירו, ždeň_
  { {0x7c29003e,0x6b8d0525,0x68e30526,0xbe640012}},	//   wier, lbag, ånds, مهني
  { {0x7c290527,0xd6180012,0x80790009,0x386d0528}},	//   tier, دتنا_, _יְ֭ה, _tier_
  { {0xa0c40012,0x7c2901e3,0x66010529,0x4b860048}},	//   _ديفو, uier, _wolk, айън_
  { {0x21f5007c,0x929d0034,0xe29f0097,0x6601052a}},	//   аїнс, myłk, éð_, _tolk
  { {0x7c29052b,0x20c5002d,0xcad80009,0xa3cc0011}},	//   sier, айом, רוזת_, _शॉन_
  { {0xbe640012,0xd3b90024,0x60320035,0x5bb9052c}},	//   _اهلي, _алеї_, lāmi, _алея_
  { {0xfc670014,0x7ae4004a,0xb4fa0009,0xf8b60009}},	//   _съзн, yvit, _בפעי, ספרי_
  { {0x636b00a2,0xc7d6000b,0x6032001e,0x7d01006f}},	//   _dönü, בורי_, nāmi, älsn
  { {0x91fc0333,0x6b8d00b6,0x6b9b052d,0x6289052e}},	//   rmāc, ebag, laug, mpeo
  { {0x3b960046,0xc3960001,0xf50300b3,0xd5ed0081}},	//   ијат, ијањ, озро, _quá
  { {0xe8e0001a,0x6b8d002c,0x3ea000eb,0x69c5052f}},	//   _hiệp_, gbag, šiti_, efhe
  { {0xf3f70020,0x27e000b6,0xd4670530,0x60320035}},	// [700] ợng_, _iain_, рите_, jāmi
  { {0x5e9b000b,0x7ae40531,0x0e9b0009,0x26060018}},	//   _שביק, rvit, _ששיל, _vôos_
  { {0xa3b60044,0x636b003a,0x27e000ed,0x6b9b0532}},	//   _जाल_, _yönü, _kain_, kaug
  { {0x4375002d,0xdb20000e,0xbc7b000b,0x929d0002}},	//   _гурт, ítóg, _שנכת, szły
  { {0x2fdf007a,0x27e00533,0x6aad0534,0xdcfc0073}},	//   _daug_, _main_, craf, tarė
  { {0x27e00535,0x4426048b,0x39420002,0xeca60001}},	//   _lain_, _smo_, ększ_, ајин
  { {0xadf70003,0x44260051,0xd4970015,0x4c940015}},	//   شروط_, _pmo_, ары_, щийс
  { {0xa3c90044,0xeca70037,0xef190034,0x99850030}},	//   ल्प_, _गिरफ, _leży_, filů_
  { {0xf1c60037,0xf1c20035,0xb8810018,0x76d30012}},	//   र्थन, pašā_, üíne, _ويفض
  { {0xdb0d0028,0xdb09003a,0xdebb0009,0x82330012}},	//   ngaá, zgeç, _בממל, ْرَا
  { {0xa3e6015f,0x9f910028,0xe3ba0014,0x80270012}},	//   पया_, _búðu_, _абе_, لرحم
  { {0xf1c60037,0x6d5a0536,0x6250008e,0x2ee9004b}},	//   र्तन, _izta, säoh, _praf_
  { {0x2bba0011,0x8c1b0009,0x787e0035,0xabfb0009}},	//   इलना, _בואי, _dīva, _שהדר
  { {0x99840012,0x59af0011,0x88c70030,0x6f1d0537}},	//   _الغو, _फ़ायर, _sněž, rzsc
  { {0xf5e4002d,0x26c2004a,0xac190538,0xda5b0009}},	//   ціям, atko_, гову_, _שכול
  { {0x200400c1,0xd3750001,0x2d9c0539,0x27e00503}},	//   _nomi_, слаћ, have_, _gain_
  { {0x6b8d00c6,0xf9930003,0xda780021,0x91870012}},	// [710] rbag, قبض_, аях_, لجام
  { {0x98da0044,0xd999000a,0xf8da0044,0x41b50003}},	//   _बनाए, انات_, _बनाय, إمار
  { {0x6aad003a,0x2907000d,0xe4e40024,0xa3d60011}},	//   sraf, âna_, _діян, ाजा_
  { {0x6aad053a,0x0ee20011,0xa25b0025,0xd7590012}},	//   praf, पिंड, _apôt, هلات_
  { {0x7c2d053b,0xa8580009,0x217b0012,0xa2670048}},	//   miar, ביאה_, _لحزب_, _въвл
  { {0x9c7c0027,0x929d0002,0x4d880012,0x7e240024}},	//   _grčk, syłk, لَهُ_, одіж
  { {0x4c920001,0x6b9b0068,0x60320035,0x20d400ae}},	//   пијс, taug, sāmi, _وتفج
  { {0x2d82000f,0xf538007e,0xa954002d,0xf77f003a}},	//   _őket_, ינוי_, _єкті, _üç_
  { {0xa3c90044,0xa3d60037,0xa7150001,0x3f150015}},	//   ल्य_, ाज़_, _удаљ, _удас
  { {0x6b9b053c,0x75280002,0xe1f90103,0xe6130012}},	//   saug, ździ, уго_, _بشر_
  { {0x62720034,0xafdb00b0,0x27e0053d,0x62890132}},	//   _płoc, tløp, _pain_, speo
  { {0x9f06000a,0x7d560093,0x6d40003a,0xa3c90037}},	//   موجو, _היעד_, şmak, ल्म_
  { {0x27e00006,0xdce300a2,0x201e007a,0x5285000a}},	//   _vain_, manı, ėti_, _التك
  { {0xe29f0065,0xdce300a2,0x62720002,0x64490227}},	//   áðu_, lanı, _włoc, loei
  { {0x7c2d0058,0x26c20002,0x0c790015,0x291e0002}},	//   fiar, stko_, исты_, czta_
  { {0x2d9c012e,0xdce3003a,0x442d053e,0x05550024}},	//   zave_, nanı, nie_, ітря
  { {0x38a3003a,0x26de001e,0x63a60028,0xf9920012}},	// [720] lır_, ātos_, ókni, كبا_
  { {0x9c82012e,0x2176002d,0xd24f0012,0xf1a90012}},	//   ščin, суар, ّنك_, لامه_
  { {0x38a300a2,0xcb09000b,0xdce3003a,0xf8aa0001}},	//   nır_, על_, kanı, увек_
  { {0x442d001e,0x68fc0248,0x2d9c053f,0xd0590024}},	//   jie_, ärdi, wave_, арчі_
  { {0x9f490065,0xdcfc0039,0xf62a002d,0xf7460015}},	//   ðað_, karī, ліки_, щедо
  { {0x442d0005,0x6b8200c1,0x97570009,0x38a30060}},	//   eie_, _sfog, זינו_, kır_
  { {0xdcfc0039,0xdce3003a,0xc19b0009,0x54e60012}},	//   darī, fanı, _תשלי, إستق
  { {0x5b140047,0x38a300a2,0x6d5a0066,0x2d9c009b}},	//   жмит, dır_, _vzta, save_
  { {0x3866006f,0x0aea0012,0x41e60024,0x60320035}},	//   mmor_, اربي_, біна, nāmu
  { {0xff17000b,0x7c2d00c1,0x38a3003a,0x867b0009}},	//   _הקמת_, ziar, fır_, _ערבו
  { {0x2bca007c,0x66050005,0xf8140020,0x19580047}},	//   _було_, _rohk, ược_, раны_
  { {0x39570093,0x3c77000b,0x3157000b,0xa157000b}},	//   משים_, _התאם_, מיין_, מביה_
  { {0x291e0540,0xf1d80011,0x7c2d0541,0x000000c4}},	//   szta_, ड़ान, viar,
  { {0xe84c0066,0x7f2b0009,0x09e3003c,0xdb0d0018}},	//   ětší, אֵלֶ, _ночн, lgaç
  { {0xe654007c,0xa99b0009,0x6c850012,0xee2e0024}},	//   ївсь, _גבור, تلزم, ьнi_
  { {0x3881007a,0x54550024,0x29370009,0x89370009}},	//   _nėra_, іват, _לאון_, _לרוע_
  { {0x24580015,0xda670012,0xdb0d0018,0x99990542}},	// [730] сать_, مائي, igaç, икат_
  { {0xdce3003a,0xff18000b,0xdd910003,0x442d0543}},	//   zanı, _לקחת_, _تود_, zie_
  { {0xa25b0026,0xdce3003a,0x7c2d0544,0x6d8c0009}},	//   _spôs, yanı, piar, _עָזְ
  { {0xc1c40037,0x9c7c0159,0x69d80064,0x9f550545}},	//   वभुग, _grči, ôver, овеч
  { {0x38a3003a,0x9f34002d,0xb9e70024,0x41e70024}},	//   zır_, пеці, _ліви, _ліва
  { {0x2d83003e,0xd9fd0037,0x442d0546,0x38a3003a}},	//   ncje_, _उचित_, wie_, yır_
  { {0xdce3003a,0x442d0547,0xed5900b3,0xeb910012}},	//   tanı, tie_, шок_, وظة_
  { {0xd2a90015,0x24090015,0x1d180009,0x6c350012}},	//   акие_, рнии_, מקור_, تفعا
  { {0xdce300a2,0x2d830002,0x13060015,0x0325002d}},	//   ranı, kcje_, жный_, юдин
  { {0x38a300a2,0xdce3003a,0x88c900de,0x442d0548}},	//   tır_, sanı, алов_, sie_
  { {0xf1b2000b,0x999e0066,0x5e440012,0xdce30060}},	//   וסי_, nitř_, _عَمْ, panı
  { {0xb9010044,0x7e7b0005,0xa3b60044,0x4c570003}},	//   _नई_, _kuup, _जाए_, _اضطر
  { {0xb7da000b,0x38a3003a,0xf7720012,0x6d580030}},	//   בקרי, sır_, باد_, _úvaz
  { {0x644f0549,0xf267004c,0xdcf50034,0x75e90031}},	//   _akci, _уђем, zczą, böző
  { {0xd24e000a,0xc5f2000b,0xdcf50002,0xd4f50015}},	//   _جنو_, ודם_, yczą, пяты
  { {0x69c50037,0x6ab60028,0x6e2e0031,0x69de054a}},	//   ़्री, tuyf, sibb, _óper
  { {0xfbd2000b,0x7ae9004a,0xa206024d,0xa3ab0011}},	// [740] ותן_, nvet, опад, कृय_
  { {0xe2460003,0x915f001a,0x63bb00b6,0x42560024}},	//   آخري, _sắp_, hgun, ітат
  { {0x69d90037,0x60260472,0x30a50024,0xe0da054b}},	//   नज़ी, оджа, зрів, рве_
  { {0xb8f20044,0x46ea0014,0x9c7c0107,0x8bb60012}},	//   _वह_, иден_, _urči, _بإدا
  { {0x4e0e0037,0xaad80037,0x8703003c,0x64410025}},	//   _हवाई_, _बैंक, дяще, élie
  { {0x6ce50044,0x11d60003,0xf1c60037,0xb4fe0037}},	//   किंग_, _بتحد, र्शन, _उपाय_
  { {0x9f450066,0x6fb60012,0x62720034,0x08c3004c}},	//   ělé_, _ومسا, _błon, _обрн
  { {0x61e30070,0x63bb054c,0xa6aa0012,0xbc670012}},	//   _aanl, ggun, _ناطق_, يمون_
  { {0x7ae9000e,0x75d60012,0x2d830034,0x62720034}},	//   gvet, _ويرا, ycje_, _dłon
  { {0x82f70093,0x3218003e,0x61e3003a,0x91ba0009}},	//   קציב_, óry_, _canl, ׁמִי
  { {0xb97b000b,0xb21b0028,0x717b0009,0x91bb0009}},	//   יניי, _stæk, יניס, סמטי
  { {0x68e30058,0x69ca0037,0x27e6054d,0xdce50064}},	//   ændi, स्ती, ndon_, _pehľ
  { {0xee3f0066,0x62500051,0xeb910009,0xc2c40012}},	//   krýt_, näos, _נָא_, _ريغي
  { {0x2e4b00a6,0x27e6008e,0x799c0034,0xdcfa0035}},	//   рямо_, hdon_, _nerw, _netī
  { {0x80c90037,0x7afd054e,0x2d830034,0xdb1f054f}},	//   _रहें, ästv, rcje_, seqü
  { {0x27e4023d,0x27e60550,0xdc8b0009,0x61e30060}},	//   _namn_, jdon_, יְמָ, _zanl
  { {0xa3cc0037,0x9b6b0014,0x61e3003a,0x799c00b6}},	// [750] श्य_, ршва_, _yanl, _berw
  { {0xd2510003,0x3eb90051,0x51f80024,0x20d60011}},	//   رنا_, must_, оную_, ठबंध
  { {0x21270020,0x3eb90005,0x7ae90551,0x4dda0009}},	//   ành_, lust_, zvet, _החתו
  { {0x69ce0552,0x69ca0037,0xc1570009,0x63a0001b}},	//   _ebbe, त्ती, חשבו_, jamn
  { {0xf770000a,0x3eb90051,0xfd4c001a,0xdbc60051}},	//   ناه_, nust_, _triề, tööd
  { {0xc27a000b,0x7ae9003a,0x62720002,0xd5b10012}},	//   _לרשי, vvet, _słon, رفع_
  { {0x1c0f0037,0xcd98000b,0x3eb9005e,0x62720034}},	//   _सवाल_, חדות_, hust_, _płon
  { {0x3eb900b4,0x6d3c000b,0x63bb0052,0xeb910009}},	//   kust_, יתונ, ugun, ךָ֙_
  { {0xeab10003,0x61e3002c,0x63bb0553,0x93fc0009}},	//   رعة_, _panl, rgun, שלחי
  { {0x3eb90554,0x321e0555,0x35b40024,0x7ae90556}},	//   dust_, ghty_, _обур, rvet
  { {0x61e3028e,0xa3bb0003,0x43750012,0x9a240012}},	//   _vanl, _ناشر_, _فهار, بعين
  { {0xd3b8002d,0x7ae9000e,0xe4d40012,0xe8f60557}},	//   _душі_, pvet, _تتكب, їля_
  { {0xdbd90065,0xf7720003,0x23760003,0xa3e60037}},	//   væðu, عاج_, _عمود_, _योग_
  { {0xa3c90037,0x7afd005e,0x32130081,0x59c20011}},	//   ल्स_, ästu, _ôxy_, _शायर
  { {0xdbd90028,0xed5a035b,0xf9fa0009,0x3c890009}},	//   tæðu, сов_, _להסמ, מָּ֑
  { {0x799c003e,0x6c360003,0x6aa40558,0x1c460024}},	//   _serw, أفرا, tsif, їнам
  { {0x3cdd0044,0x799c00c6,0xc8650003,0xdbd90028}},	// [760] _कैसे_, _perw, _تطوي, ræðu
  { {0xa3ab0044,0x6aa40559,0x7c3b0032,0x2cb80032}},	//   कृत_, rsif, hnur, purd_
  { {0x799c055a,0xc329000b,0x3d150037,0xc5eb000b}},	//   _verw, נו_, तनों_, _הַכֹ
  { {0xdcf50002,0x1eaa0003,0xd3da0012,0xe7160009}},	//   jczę, ماتي_, _ابدا_, ּחַר_
  { {0x799c055b,0x03770009,0x6f7b0009,0x17790024}},	//   _terw, _מתכת_, צְאו, ісць_
  { {0xf536000b,0x26c6004a,0xd49a00f5,0x7c3b055c}},	//   ּנֵי_, rtoo_, бри_, enur
  { {0x721b0009,0x80da0011,0x4420005e,0x621b0009}},	//   _פולח, _बनें, ohi_, _פולק
  { {0xb6030039,0x4420002c,0x6bd60003,0xa08b000b}},	//   īšan, nhi_, ستعر, _לְמִ
  { {0xade70037,0x27f70145,0x18670024,0xb6030035}},	//   _टोकन_, šení_, _хати_, ūšan
  { {0x3eb90005,0x39140001,0x63a0055d,0x2bac0081}},	//   vust_, дмор, samn, ớc_
  { {0x764e055e,0x69bd0011,0x3eb902a2,0x3ea60035}},	//   doby, _शारी, wust_, lsot_
  { {0x3eb90005,0x8fa40001,0x9f35002d,0xe759002d}},	//   tust_, наџе, демі, жимі_
  { {0xe6670014,0x6b9d055f,0x38850035,0x3f860018}},	//   зтво, _resg, _pērc_, icou_
  { {0xacf90560,0x3eb90561,0x68fc0248,0xa8a60488}},	//   онгу_, rust_, ärds, _ерик
  { {0x3eb90051,0x61f80070,0xb2290012,0xd6570009}},	//   sust_, _invl, _بأنك_, פילת_
  { {0x5c740098,0xb157000b,0x3957000b,0x3157000b}},	//   елст, _מסוג_, _משום_, _מיון_
  { {0x69da0562,0x8e840012,0xc7fa0009,0x5c370009}},	// [770] oete, _كليه, _וִיר, פרמן_
  { {0xdce7003a,0xdcf50002,0x644d0017,0x69da0563}},	//   sajı, zczę, soai, nete
  { {0xdb0d0028,0x320a00d9,0x91fc0035,0x20190073}},	//   ngaú, _doby_, emāk, ūriu_
  { {0x7985008b,0x69c8003a,0x44200564,0x98c5001b}},	//   schw, _öden, chi_, žući_
  { {0xa2a70037,0xcee80012,0x69bd0011,0xf7730012}},	//   _चिट्, كرون_, _शाली, راص_
  { {0x8afa000b,0xee38002d,0x02fa0009,0x12fa0009}},	//   _והשי, пні_, _ולשמ, _והשב
  { {0xd0d40098,0x3cdd0037,0x1d060014,0xa5060048}},	//   _поръ, _कैशे_, дещи_, деща_
  { {0x3ea90006,0x61e7000e,0xea890217,0x2b150024}},	//   _ovat_, _hajl, обил_, дьор
  { {0x69ca0037,0x37c40012,0x7aed0565,0x66120031}},	//   स्वी, _سيلف, nvat, ükkö
  { {0xb33b00a2,0x7aed000e,0xf8a90055,0x02fc0009}},	//   _geçe, ivat, овок_, מלחמ
  { {0x7aed0566,0x34940014,0xa3c80011,0x44200024}},	//   hvat, _захр, _लॉक_, _зi_
  { {0x7ad80011,0x5b15004c,0x7aed0567,0x99910034}},	//   _बैकअ, _омет, kvat, ózł_
  { {0x6d49000d,0x5f760012,0xddc10073,0xf7720012}},	//   şeal, بادر, _milž, ضاح_
  { {0x7a20000f,0x61e70568,0x7aed0558,0x32450012}},	//   _köte, _najl, dvat, _تنتف
  { {0x25fe0011,0x3ea90227,0x7aed0569,0x4420056a}},	//   लाती_, _evat_, evat, thi_
  { {0xb09a000b,0xc952000b,0xa09a000b,0x7a20006f}},	//   _ויקר, _שמה_, _ויקט, _möte
  { {0x0b170003,0x2eff0052,0xfaa3034a,0x7aed056b}},	// [780] وقفة_, äuft_, като, gvat
  { {0xe9d7007c,0xc1d80011,0x9f9d0097,0x4420056c}},	//   мку_, ड़ेग, læði_, shi_
  { {0x2d9e01a2,0x4999002d,0xd7e6002d,0x25e70037}},	//   _rete_, яття_, діло, _छोटी_
  { {0xb33b00a2,0x6d40003a,0x69da056d,0x2d9e056e}},	//   _seçe, şmas, zete, _sete_
  { {0xc7a30046,0x63b90002,0x61e70027,0x07a30001}},	//   тичк, ówne, _fajl, тачн
  { {0xdce80029,0xdd8f0012,0xdc8a003c,0x3f9f01e3}},	//   _vedľ, لوه_, осил_, _eeuu_
  { {0xdb190002,0xa1160012,0xa5c40011,0x68e30040}},	//   _obwó, _غورت, _राठौ, ændt
  { {0xd4670001,0x690b000b,0xe10b0009,0x44c80032}},	//   мије_, _וּמְ, _וּמָ, iß_
  { {0xe457000b,0xc274004c,0xd403056f,0xee3a0050}},	//   ויקט_, нлиј, тящи, _дна_
  { {0xf8d20044,0x6ffe000d,0x7ae2009b,0x63a40258}},	//   _सहाय, _făcâ, _vsot, hain
  { {0xd130000a,0x29180570,0xe8df001a,0x9f450066}},	//   امج_, ára_, _buộc_, ělí_
  { {0xe8df0020,0x63a40571,0x7aed0042,0xc1730009}},	//   _cuộc_, jain, yvat, כחת_
  { {0xd6d9003e,0x44c80052,0x6b960572,0xa3bf0011}},	//   _były_, eß_, dbyg, ूऍस_
  { {0x7bc00058,0xe731000b,0xaa570003,0x3e64008e}},	//   lgmu, אֵל_, _قلنا_, yöte_
  { {0x1bd50014,0x18970003,0x645c001e,0x49bb0009}},	//   новя, _قضية_, _īrij, _ומוס
  { {0x69ca0037,0xec68002d,0x3ea9013a,0xc4540012}},	//   त्री, друк_, šati_, نَّب
  { {0x44c80052,0xc0540009,0xeaf80012,0xcb340048}},	// [790] aß_, _בזק_, وركت_, ветъ
  { {0xdb000108,0xc2c4000a,0xe9d30003,0x42550012}},	//   ramè, ئيلي, ضغط_, رنار
  { {0xd131000a,0x31c40014,0x7aed01a3,0xe7c60011}},	//   دما_, ъств, svat, _वामप
  { {0x9516000b,0x63a40573,0x201900b6,0x27e90574}},	//   _נקרא_, cain, nksi_, _jaan_
  { {0x2019004a,0x27e90575,0xfbb60009,0x22840060}},	//   iksi_, _maan_, _אפרת_, _gök_
  { {0x6442004a,0xff18000b,0x56920001,0x8e080024}},	//   _ajoi, וקדת_, ћајт, мнів_
  { {0x64480025,0xf41f0248,0x25a10032,0x57b700ae}},	//   édig, _klä_, _mehl_, _يحرز
  { {0x5ba90001,0x3eb20010,0xc4f80003,0x1309002d}},	//   чким_, šyta_, بعها_, зний_
  { {0x9f9d0065,0xeb92000b,0xef540014,0x7c3a0576}},	//   væði_, נָה_, _акть, étri
  { {0x2019004a,0xbef80003,0x7a200052,0xf41f004a}},	//   eksi_, _ترفض_, _töte, _llä_
  { {0xf65f0058,0x79a80009,0x20890048,0x27e90227}},	//   rtæl_, וֹרַ, яйни_, _baan_
  { {0xcdc9015a,0xc1720009,0x59cf0011,0x80a00011}},	//   _לך_, טחי_, स्तर, _खबरे
  { {0xef170047,0x9f9d0065,0x27e9002c,0x6836001e}},	//   емя_, ræði_, _daan_, gšda
  { {0x20190577,0xfce60578,0xc6920009,0x443f0579}},	//   aksi_, ного, ראם_, lnu_
  { {0x22840163,0xa3cc0044,0xd46a0001,0x621a000b}},	//   _sök_, श्व_, зиве_, _מוסק
  { {0x27e900bd,0x6b89057a,0x7dd3003a,0x3c3a001e}},	//   _gaan_, nceg, lısı, tīvi_
  { {0x41b6057b,0xdd2f0066,0x443f057c,0x883b0009}},	// [7a0] есет, _měře, inu_, _מתקו
  { {0x2b9e001a,0x8e97000b,0x7dd30060,0x6aa90035}},	//   ắc_, _רדיו_, nısı, isef
  { {0x69c800a1,0xf1c60037,0x659b000b,0xdb00057d}},	//   _ödem, र्गन, _מייק, ramé
  { {0xad37000b,0x40560003,0xa2b20037,0xc1bd0037}},	//   _טניס_, رئاس, ेंद्, ्भुग
  { {0x68e30058,0xddc3000e,0x5b7b0009,0x201f004b}},	//   ændr, elnő, _מרכא, _dlui_
  { {0xd49a057e,0xc73b0009,0x7c24057f,0x41c70011}},	//   при_, התנת, lhir, _लायस
  { {0x443f0028,0x69c10027,0xf41f008e,0x2019008e}},	//   fnu_, dgle, _ylä_, yksi_
  { {0x66e6002d,0x2c610029,0x443f0580,0x59c20011}},	//   _поба, tóda_, gnu_, _शाहर
  { {0xdcea00a2,0xe7d5003a,0x99a40030,0xe3af0012}},	//   rafı, lığı, átům_, حرى_
  { {0x27e90581,0xf3ff001a,0xd5e90003,0x69c10582}},	//   _saan_, _nhãn_, _يعلن_, ggle
  { {0x3a370093,0x0dc90003,0x9f400028,0x39580058}},	//   תרים_, _تبقى_, _snið_, ærs_
  { {0x645b0583,0xb8d80037,0x443f0584,0x69c10585}},	//   clui, _चि_, cnu_, agle
  { {0x27e9004a,0x6e350032,0x6a660097,0x69c10032}},	//   _vaan_, tizb, eðfe, bgle
  { {0x7dd3003a,0xdb020018,0x6d5a0030,0xa3cc0011}},	//   cısı, _adoç, _kyta, श्र_
  { {0x64410108,0xf65f0028,0x69b90037,0xa4d40024}},	//   élio, ltæk_, _एफ़टी, лорі
  { {0xe7d500a2,0x515b000b,0xb6f50001,0x3c3a0035}},	//   dığı, _מכוו, _азиј, būve_
  { {0xc87f003a,0x61ea0097,0x6a660097,0x57b4003c}},	// [7b0] ışma_, _kafl, aðfe, _сбыт
  { {0x69de0586,0x28c40011,0xc73c0009,0xe9190024}},	//   gepe, लंपि, _מתחת, мозі_
  { {0x399b0009,0x999e0031,0x4c95004c,0x443f0587}},	//   פיאד, nitő_, _шинс, ynu_
  { {0x80d20011,0x7dd30060,0x69c10412,0x6e950588}},	//   _ठहरे, zısı, zgle, виду
  { {0x7dd300a2,0x9178001a,0x7ac700fa,0x443f0589}},	//   yısı, hời_, _ясне, vnu_
  { {0x3eb9002a,0x69de000d,0xc1780010,0xe618002d}},	//   irst_, cepe, ndės_, нді_
  { {0x443f058a,0xdb0d0028,0xd7950012,0x6d5a0034}},	//   tnu_, ngaþ, _للأخ, _cyta
  { {0x201f007d,0xcec10002,0x2ef50136,0x443f058b}},	//   _ului_, _pięć_, _избр, unu_
  { {0x04560003,0x69c10032,0x7dd30060,0xe2910012}},	//   خلية_, tgle, tısı, جذب_
  { {0x443f001c,0xd24e0003,0x645b0070,0x5f440012}},	//   snu_, يني_, slui, _إنكل
  { {0x69c1008b,0x7dd3003a,0x69a20037,0x6e21006f}},	//   rgle, rısı, _ग़री, _illb
  { {0x69c10052,0x69de0123,0xf6490009,0xe73a03cd}},	//   sgle, zepe, _וצ_, дем_
  { {0x69c70027,0x7dd3003a,0xdb060004,0x7bdf058c}},	//   _ocje, pısı, _odká, dequ
  { {0xc332000b,0xdd920012,0xf2050011,0x69c60031}},	//   _דוד_, شور_, राफ़_, őker
  { {0x6da30046,0x2731001a,0xed5702d3,0xa00a0012}},	//   риса, ạnh_, вор_, _يقتل_
  { {0xe8d6000b,0x60d6000b,0x88ba0009,0xc1780073}},	//   _יוצר_, _יוצא_, _חזקי, adės_
  { {0xf9920003,0x7799000b,0xaf4a0012,0xb33b0018}},	// [7c0] لبا_, _אֹתו, _تشغل_, _peça
  { {0xceb90066,0xe7d5003a,0xb21b058d,0x7c24058e}},	//   áře_, tığı, _stær, shir
  { {0x7bdf0017,0x291c022d,0x69de058f,0x91e3004c}},	//   bequ, áva_, repe, рохе
  { {0xdfcf0003,0x6d5a0073,0x6fb30012,0x69de0590}},	//   قيم_, _ryta, لمما, sepe
  { {0x442200a2,0xdfcf000a,0x3ed40003,0xa6fa0003}},	//   _ilk_, تين_, اقتر, بعاء_
  { {0x6d5a003e,0xceb3000b,0x4a750015,0x63a20051}},	//   _pyta, שיג_, _быст, _seon
  { {0xa3c90044,0x10a3002d,0x04c70003,0x3ead003a}},	//   ल्क_, _висн, نووي_, _evet_
  { {0x94230001,0x21670024,0xa7850012,0x61ea0060}},	//   имје, _риси_, _مشكو, _safl
  { {0x7c23007d,0x59cf0037,0x6ac30012,0x68260031}},	//   _înre, स्वर, لقيم, _módd
  { {0xd5af0012,0x6cd60012,0x7e7a0227,0x66250034}},	//   _وفق_, _لقطا, _uitp, ątkó
  { {0x859b015a,0x91bb000b,0x23e20037,0x2cb8000e}},	//   _חשבו, ומיי, _पसंद, _írd_
  { {0xc9530093,0x92a90002,0x28c40037,0x3c3a001e}},	//   ימת_, nałó, लंबि, tīvu_
  { {0x8c1b0009,0x8f9b0009,0x64410025,0x61ea0591}},	//   _קודי, ויכי, élim, _tafl
  { {0xf773000b,0x6e940015,0xb8f40003,0x82d7000b}},	//   יקר_, риру, _مكتب, _סווג_
  { {0x6272003e,0x4a7b000b,0x1dd20037,0xc1030003}},	//   _słow, _קרוב, द्धत, _نووي
  { {0xd10f0044,0x7bc401a2,0xa177000b,0x5fa70037}},	//   ाहरण_, ggiu, _בעוד_, _ख़िल
  { {0x24580047,0xc334000b,0xda670012,0x7bdf0592}},	// [7d0] тать_, אוּ_, نائي, requ
  { {0x442200bd,0x4d99002d,0x9f440054,0xd5350003}},	//   _elk_, _якою_, _camí_, _مفخخ
  { {0xe01e0011,0x5fa70011,0x2419003c,0x6d410064}},	//   पसंद_, _ख़ाल, _зоны_, úlad
  { {0x787a0013,0x251a0009,0x50640223,0xd7890012}},	//   _důvo, _נורא, атча, رنتو_
  { {0x539a000b,0x03d6000b,0xdb0d0051,0x17540024}},	//   _רישו, _גורם_, ngaü, авця
  { {0x7c220108,0x26360002,0x5187035c,0x0dc8004c}},	//   _alor, słon_, _шума, вући_
  { {0x6aad00b6,0x6da20593,0xadd80009,0x64e80012}},	//   lsaf, щища, דווח_, َّهِ_
  { {0x32cb0119,0xd46600a6,0xc57c0009,0x20f3001b}},	//   tøy_, лище_, ורות, _ići_
  { {0x65950594,0x27ff008e,0xdb040031,0x92390595}},	//   _базу, _inun_, taié, ечну_
  { {0x2d810020,0xc5fb0003,0xf9d4002d,0xb33b0025}},	//   _nghe_, _تعرض_, ацюю, _leço
  { {0x07a600c0,0x8cc40012,0x69c50132,0x64c40012}},	//   ланн, _نقله, ighe, _نيلل
  { {0xf3f00003,0xc5e90009,0xcaf50012,0x25a50596}},	//   _وأن_, _מד_, _مستب, _hell_
  { {0x25a50597,0x9f8a0051,0x38b90028,0xdcee003a}},	//   _kell_, _tööd_, _býrð_, vabı
  { {0x2aba0093,0x7c22009b,0x63a90598,0x02450012}},	//   _נמצא, _zlor, laen, _حَتَ
  { {0x91fc0039,0xdcee003a,0x27ff003a,0x61e10599}},	//   rmāt, tabı, _onun_, mell
  { {0x61e10006,0x74160012,0x80cd0011,0x40920012}},	//   lell, دورا, _सहजे, _الير
  { {0xab66059a,0x04570012,0x23270430,0xcaa50012}},	// [7e0] увал, القة_, готи_, لصلي
  { {0xdcee00a1,0x55e60047,0x25a501a2,0x787a0013}},	//   sabı, _сооб, _nell_, _půvo
  { {0x60c1059b,0xa9880009,0x63a9059c,0x61e1059d}},	//   nulm, דָנִ, kaen, iell
  { {0xe29a007c,0x7643059e,0x61e1059f,0x6a660097}},	//   _пам_, enny, hell, iðfa
  { {0x66ad000b,0x61e105a0,0xf6d30012,0x8f9b0009}},	//   ֵיהֶ, kell, مزود, גיני
  { {0xf38f0020,0x69d30037,0x25a505a1,0x60c105a2}},	//   uảng_, _बॉली, _cell_, kulm
  { {0x25a505a3,0x83fd000e,0xbca40003,0xda5b000b}},	//   _dell_, klőd, جمعي, _נכלל
  { {0xe4f70044,0x4422000f,0x61ee0164,0x61e1004a}},	//   ुमति_, ók_, _habl, eell
  { {0xbc67000a,0xa3c90037,0xe3af0003,0x25a502c3}},	//   دمين_, ल्ट_, سري_, _fell_
  { {0xd8f8007c,0xf1c60066,0x3c3a001e,0x2000000d}},	//   вної_, _část_, tīvs_, _anii_
  { {0x5bc6000a,0x6444004a,0x3257000b,0x73c60012}},	//   _مقال, knii, רסים_, _ميام
  { {0x0eeb0015,0x64560132,0xd2590035,0x82a60365}},	//   ньги_, joyi, ruņa_, _бадж
  { {0x62860010,0xb33b0061,0x6fc60037,0x33170012}},	//   _nuko, _reço, _वारं, _مزود_
  { {0x6ecc0011,0x6d5e05a4,0xc0aa0012,0x27ed05a5}},	//   _समनु, _bypa, _كابل_, žen_
  { {0xf993000b,0x55590014,0x63a60227,0x63b90034}},	//   _פרק_, тавя_, _bekn, ówno
  { {0xf8b30009,0x60df0031,0x628605a6,0x9b95042a}},	//   _השק_, őzmé, _buko, риац
  { {0x7655003e,0x3ce40037,0x64480061,0x53470001}},	// [7f0] pozy, झौते_, édia, ухва
  { {0x321e0002,0xa5350024,0xbc840081,0xc7b90031}},	//   nkty_, _вноч, _ướn, _elől_
  { {0xc5f8001e,0x69c505a7,0xd2620035,0x69dd0031}},	//   ķēt_, rghe, diņā_, őseg
  { {0x627205a8,0x765a05a9,0x25a505aa,0x4c9a0009}},	//   _złot, _akty, _sell_, _שברו
  { {0xddc8007a,0x69d80470,0x65640066,0x8f9c0009}},	//   _didž, _obve, řihl, תידי
  { {0x44290149,0xf770000a,0x60c1003a,0xb2ba0009}},	//   lha_, سان_, yulm, _במשר
  { {0x999e0066,0x63a90262,0x3e320012,0x20f3001b}},	//   entů_, taen, تفور, _ući_
  { {0x442905ab,0x25a5029e,0xbae50012,0xdb510012}},	//   nha_, _well_, لكبي, يَغ_
  { {0x7412000a,0xcda9000a,0x25a5002a,0xb2250001}},	//   تويا, _لهذه_, _tell_, имил
  { {0xd262001e,0x60c1003a,0xe8f9002d,0x6abb05ac}},	//   ciņā_, tulm, вло_, rruf
  { {0x5d84000a,0x44290101,0x83fd000e,0x69ca0011}},	//   _المل, kha_, tlőd, स्टी
  { {0x60c100a2,0x43750146,0xc1560009,0x16030011}},	//   rulm, _култ, ישתו_, लावर_
  { {0x46e7007c,0x8c1a0093,0x26020037,0x83fd000e}},	//   адян_, _שוני, शाली_, rlőd
  { {0x43720003,0x7c2905ad,0x442905ae,0x628605af}},	//   _ظهور, lher, eha_, _ruko
  { {0xed5a035b,0x845a046d,0x628605b0,0x9268004c}},	//   тов_, врат_, íkov, _срца_
  { {0xb8db0044,0x6d5e05b1,0x61ee05b2,0x200005b3}},	//   ें_, _vypa, _sabl, _unii_

  { {0x62720002,0x6d5e0002,0xdcfc001e,0x935a0001}},	// [800] _głos, _wypa, obrī, трву_
  { {0xb33b00a2,0xc693000b,0x1daa0037,0x3c3f004a}},	//   _geçm, _ואז_, _क़ित, tävä_
  { {0x55bb000b,0xdfa6004c,0x61ee0159,0xd5bb0009}},	//   _במיו, ајло, _vabl, _בזיל
  { {0x1eaa0003,0xfa88001a,0x442905b4,0x386d05b5}},	//   ناتي_, _lừa_, cha_, _cher_
  { {0x539b000b,0xd9e50037,0xd262001e,0x66f40055}},	//   _ביכו, क़ात_, tiņā_, сплу
  { {0x386d0052,0x4096011f,0xdb000097,0xc896004c}},	//   _eher_, _врат, jamá, _врањ
  { {0x7589002d,0x95080012,0x29070248,0xdb000097}},	//   усів_, اقعك_, änat_, damá
  { {0x6a6b0052,0x0163002d,0x1d070001,0x6e3c05b6}},	//   rüfe, _єкто, рећи_, hirb
  { {0x5a340014,0x8ff90003,0xf5ea0014,0x9294004c}},	//   йнит, _حرّر_, _имал_, љаоц
  { {0x5cd6002d,0xf2d30009,0xc2110009,0xcb67004c}},	//   _відх, קעת_, ִ֔י_, шање_
  { {0xdcb1001a,0x621b000b,0xa3e60037,0x442005b7}},	//   ởi_, דויק, फ़ा_, kki_
  { {0xb33b00a2,0x7c2905b8,0x6d3b000b,0xcfab0012}},	//   _seçm, cher, _בתבנ, خادم_
  { {0x3294000a,0x229405b9,0xaa940003,0xfe730003}},	//   _التأ, _التس, _التث, قدس_
  { {0x8afb000b,0xbafb0009,0x442005ba,0xaadb0009}},	//   _שהגי, _שהגש, eki_, _סחור
  { {0x2ba70046,0x62720002,0xda050037,0x44260577}},	//   ијав, _włos, रासत_, _klo_
  { {0x717b0093,0xe97b0093,0x417b000b,0x5bb80015}},	//   _בנוס, _בנוש, _בנוב, ился_
  { {0xb0660051,0xe9870001,0xaed50001,0x442905bb}},	// [810] svää, аћен, _уопш, rha_
  { {0x9178001a,0x82340012,0x7ac401c6,0xd1b80012}},	//   _sớm_, يرلا, юссе, لاما_
  { {0xda78004d,0x442005bc,0x4ddc0009,0xa3d60011}},	//   рят_, bki_, _יחזו, िभा_
  { {0xa3ce0044,0xe8df0020,0x442005bd,0xfd560009}},	//   _राय_, _quốc_, cki_, _לשתי_
  { {0xd9f80037,0x161b0321,0x7ff40012,0x20e805be}},	//   ्ञात_, _नकार_, تسلا, _eşi_
  { {0x7c29002a,0xcb120009,0x63ad05bf,0x2d910034}},	//   wher, _צלם_, laan, ncze_
  { {0xa3ce0037,0x7c2905c0,0xdd8e0012,0x29070248}},	//   _राम_, ther, روي_, ånad_
  { {0x40350014,0x44390051,0x61e50066,0xd4e4002d}},	//   _уебс, _jms_, lehl, юючи
  { {0x32d0001a,0x7c2905c1,0x7c3b05c2,0xdcfc0035}},	//   gày_, rher, riur, tbrī
  { {0xc332000b,0x69c805c3,0x6ecc0011,0x442005c4}},	//   פוי_, ggde, _समतु, zki_
  { {0x44200002,0xfa88001a,0x6d40003a,0x6c850012}},	//   yki_, _vừa_, şmaz, _الصم
  { {0x33f40012,0x6e3c0032,0xa0880009,0x2d910034}},	//   _وسنس, wirb, יְשִ, ecze_
  { {0x2bcb0037,0x44200133,0xfc300012,0xf4120009}},	//   िलना, vki_, _تحل_, _מפא_
  { {0x4420003e,0x23740029,0x51950003,0x69dd000e}},	//   wki_, ňajú_, _الغذ, őseb
  { {0x1d19007c,0x8234000a,0x50db0037,0x442005c5}},	//   ають_, _برنا, _बहिष, tki_
  { {0x3eb2007a,0x3f80007a,0x711a000b,0xb38605c6}},	//   šyti_, žiui_, _תוקפ, слал
  { {0x61e50052,0xc053000b,0x3b070014,0x629b004a}},	// [820] fehl, _מזה_, бето_, npuo
  { {0x7dea0015,0x7afd008e,0xdb0d0097,0x99850073}},	//   _смог_, ästy, rgað, milų_
  { {0xf77f0017,0x7cd60012,0x443905c7,0xa06a05c8}},	//   meça_, _اتخذ, _fms_, гажа_
  { {0xa2aa0037,0xdb06000e,0xa9670014,0xddc80034}},	//   _फ़िल्, _leké, щиха_, _widż
  { {0x92f6002d,0x20d1001a,0x29070248,0x61e50064}},	//   _учні, hái_, änar_, behl
  { {0xf77f0018,0x20d10031,0xe0860012,0x442605c9}},	//   neça_, kái_, _هجري, _slo_
  { {0x645d0006,0x6f1d0002,0xd5b90024,0x88980009}},	//   _yksi, zysc, рсі_, _כֹּה
  { {0x94180015,0x2d910002,0x786a015b,0xcce50012}},	//   ржит_, zcze_, býva, تسهي
  { {0x59cf0037,0x6a700248,0xdfcf0012,0xdb060031}},	//   स्कर, räff, _سيل_, _beké
  { {0x98a700a2,0x6d4000a2,0xef170001,0x23ad0010}},	//   _aynı_, şmay, _уму_, mųjų_
  { {0xc0aa0003,0x20f7004b,0xd5af0012,0x09f70009}},	//   داخل_, _căi_, _سفن_, זמים_
  { {0xbb860003,0x43860003,0x4420001a,0x2d910002}},	//   _الإي, _الإق, _ôi_, wcze_
  { {0x29180051,0xf1a80037,0x23ad0073,0x316b0034}},	//   ärab_, गरान, nųjų_, ęcza_
  { {0x41c70037,0xf1c70011,0x65940048,0x443905ca}},	//   _लाइस, _लाइन, зару, _sms_
  { {0x63ad05cb,0x786a01bd,0x80a40012,0xb4250034}},	//   taan, zýva, _بمعن, łżeń
  { {0x25bf000d,0x53990015,0xdc8b0009,0xd0110012}},	//   şul_, рвая_, טְמָ, _آلة_
  { {0x7b6705cc,0xf77f0017,0x443905cd,0x91870012}},	// [830] стве, beça_, _vms_, مجام
  { {0xd2500012,0xd3010024,0x63ad05ce,0x23ad0073}},	//   ّنْ_, кiвс, saan, dųjų_
  { {0x63ad05cf,0x61e50029,0xd1b80012,0x89db0009}},	//   paan, rehl, صالا_, רחבי
  { {0x7c670003,0x7aee004a,0xdc880009,0xfde10011}},	//   _داخل, äntä, _לְשָ, फ़्फ
  { {0xa3ce0037,0xa3e60011,0x95850189,0xcebb004c}},	//   _रात_, फ़र_, олле, уље_
  { {0xae030044,0x2c4c0066,0x7c95046d,0x291e0010}},	//   लाइन_, věda_, ориц, kyta_
  { {0x44f80020,0x7c840001,0x41090009,0xafdb0040}},	//   _cĩ_, пуње, _דִּ֣, rnøj
  { {0xa4b80093,0xfc310003,0x291e0010,0x7c2d05d0}},	//   צלחה_, بحت_, dyta_, nhar
  { {0xc7b9000e,0x20f7000d,0x7bc905d1,0x7bfa0009}},	//   _idő_, _săi_, rgeu, בִיה
  { {0x39450055,0xdcf5003a,0xd1790024,0xaa560012}},	//   жног, hazı, исні_, يليا_
  { {0x7bcf05d2,0x629b05d3,0xa96905d4,0x7afc0035}},	//   _occu, spuo, рина_, ārta
  { {0xe8df0020,0x629b008e,0x7d560009,0x20d105d5}},	//   hiệm_, ppuo, _ויעד_, rái_
  { {0xdcb1001a,0x65690066,0xc7d6000b,0xd5b1001a}},	//   ẩn_, řehl, חורי_, _góc_
  { {0xb33b00a2,0x443f05d6,0x442d0017,0x7c2d00b6}},	//   _geçi, liu_, lhe_, ehar
  { {0xf77f03eb,0x7afd05d7,0x442d01a4,0xa06a05d8}},	//   reça_, _arst, ohe_, _кака_
  { {0xccf20093,0xdb000051,0xb466002d,0xd8760003}},	//   וכל_, bamä, ікал, _باتب
  { {0x63ab05d9,0xda050037,0x89aa01ef,0xcfb70009}},	// [840] _megn, रांत_, икав_, _ולפי_
  { {0x62830066,0x644905da,0x4ce60048,0x682605db}},	//   _jino, hnei, _джоб, _kódo
  { {0x443f0010,0x045a0003,0x7afd0204,0xbfaa00b5}},	//   kiu_, _نجحت_, _erst, атле_
  { {0x6826000f,0xd5b10020,0x30760015,0x62990002}},	//   _módo, ức_, цузс, _otwo
  { {0x44f80020,0x98ab001e,0xf4130009,0x27e60132}},	//   _sĩ_, āmās_, _חפר_, reon_
  { {0x7c240005,0xdcba0098,0x35e10011,0x4efb0009}},	//   lkir, ащи_, फ़ग़, יהנו
  { {0x7a200052,0x291c0051,0x443f0029,0x1cba0009}},	//   _nöti, ävad_, fiu_, ׁמַע
  { {0xb33b00a2,0x2900007a,0x62830006,0x44f8001a}},	//   _seçi, _čia_, _aino, _vĩ_
  { {0x63b90002,0x63ab00b8,0xafdb00b0,0x7c2405dc}},	//   ówni, _degn, snøk, ikir
  { {0x291e0010,0xee370001,0x628b05dd,0x442d05de}},	//   tyta_, _дну_, _dugo, ahe_
  { {0x7233000a,0xf9930093,0x69fb000b,0xfa330003}},	//   بريط, ורת_, בליק, بريد
  { {0xb084002d,0x63ab05df,0x443f05e0,0x291e05e1}},	//   овiд, _gegn, ciu_, ryta_
  { {0xd5b10020,0xc7b3000b,0x3866000d,0xa87b000b}},	//   _hóa_, ובר_, ilor_, יאטר
  { {0x765c05e2,0x22570012,0x644005e3,0x7ae205e4}},	//   gory, _وجوب_, limi, _ipot
  { {0x644000e6,0xa99b0009,0x45d40048,0xe6540024}},	//   oimi, _דבור, ьорс, євсь
  { {0x59dd0037,0xdb000029,0x04c80012,0x28380012}},	//   न्नर, pamä, توفي_, _وأية_
  { {0xdceb00a2,0x83350014,0xf77f0017,0x7c2d05e5}},	// [850] ınız, чнах, meço_, rhar
  { {0xf1c30020,0x7c240006,0x7afd0133,0xe1670001}},	//   _giờ_, akir, _vrst, ођен
  { {0xab95002d,0x7c380028,0x6449004a,0x58d40048}},	//   _нині, ðará, ynei, дохт
  { {0xdce50020,0x443f0054,0x8d5a0009,0xb8e30011}},	//   _nghĩ, xiu_, _לכתי, _एट_
  { {0x06fb0037,0x6605034c,0xe8e0001a,0x69d80011}},	//   एटिव_, зпла, _khớp_, न्ही
  { {0x63ab01a2,0x61e8001c,0xee38002d,0x65650051}},	//   _segn, jedl, оні_, ühho
  { {0x62990002,0x85780014,0x2bb20037,0x443f05e6}},	//   _stwo, осът_, _ज़मा, tiu_
  { {0xc1040003,0x644005e7,0x09b50011,0xe50c0011}},	//   _توفي, gimi, ूल्य, हमति_
  { {0x63ab05e8,0x442d05e9,0x0b4500b3,0x1306003c}},	//   _vegn, rhe_, янин, зный_
  { {0xd6280001,0x02160009,0x61e80132,0x7ae00032}},	//   _дође_, ִ֗ים_, gedl, _ämte
  { {0x91fc001e,0x644f0002,0x644005ea,0x0ef40011}},	//   plān, _ojci, bimi, इट्स_
  { {0x644005eb,0x628b002c,0x16030037,0x66e601b6}},	//   cimi, _tugo, लाकर_, пома
  { {0x6299003e,0x765c05ec,0x661a0522,0x7c2405ed}},	//   _utwo, tory, ötko, vkir
  { {0x8afa000b,0x915e001a,0x9b160009,0xa3ce0011}},	//   _להני, hắm_, _מחנה_, _राह_
  { {0xd5b10020,0xdd8f0003,0x32070002,0xd46a0012}},	//   _xóa_, اوف_, _inny_, محرم_
  { {0xc952000b,0xc4830345,0x58ba000b,0xdddc01bd}},	//   _רמה_, елск, _המקצ, zorň
  { {0x0ae90003,0x32180002,0x7c2405ee,0x6fa20011}},	// [860] يركي_, _pory_, rkir, _क्यू
  { {0x17570093,0xd5b1001a,0x7c2405ef,0xa3ce0011}},	//   _מספר_, ứa_, skir, _राव_
  { {0x6440003a,0x361b000b,0xd12f0012,0x7c240073}},	//   yimi, _הויד, همك_, pkir
  { {0x1fd60011,0x44240081,0x92050011,0xc7f70009}},	//   ठभेड, _ôm_, राउज_, ּ֖את_
  { {0x61f500a1,0x33fb000b,0x38660168,0xabfb0009}},	//   _fazl, _ההכנ, rlor_, _ההכר
  { {0xc3330009,0x7c2b0097,0x61f50060,0xcf250012}},	//   _טור_, _algr, _gazl, برمي
  { {0x80c00037,0x8fa605f0,0xe6a90011,0xc5f30009}},	//   _विधे, _наве, _कब्ज, גדו_
  { {0xb7da0003,0xdc9b000b,0xd92b0009,0x60c80248}},	//   _دورا_, זיקל, _הֵמָ, vudm
  { {0x7afc001e,0xe7c60037,0x298a002d,0x644005f1}},	//   ārto, _वाजप, йсно_, rimi
  { {0x80c00044,0xd337000b,0x4b37000b,0x3f800010}},	//   _विदे, פריה_, פריל_, žius_
  { {0xdca3007c,0x859b000b,0x66080058,0xd59b0009}},	//   _захи, _השבו, _indk, _הבבל
  { {0xdcb10020,0x7aed003e,0xa3e30037,0x35d20011}},	//   ẩm_, ywat, _पॉप_, _साड़
  { {0xf77f0149,0x7ae205f2,0x6826000e,0xabfb0009}},	//   reço_, _upot, _kódj, _להאר
  { {0x661a0006,0x4b7b000b,0x8b450012,0xb4b605f3}},	//   _jotk, _האדו, _تضمن, _जिफ़_
  { {0x61db0093,0x7a2d0164,0x61f5048b,0x6826000e}},	//   _הקוד, _fútb, _razl, _módj
  { {0xfc49001a,0xc49b0009,0x7e60004b,0xe4140024}},	//   hận_, משלת, împr, ндсь
  { {0xa3de0037,0x67bc000b,0x35d20011,0xda090012}},	// [870] द्य_, _המחק, _साढ़, ييره_
  { {0x91fc0333,0x2bcb0044,0x661a0065,0xdb0b0040}},	//   klām, िलहा, _notk, _udgå
  { {0x21270020,0xb33b0061,0x4094002d,0x16380009}},	//   ánh_, _reçu, еріт, _מנזר_
  { {0x66080051,0xa2bd0011,0x6fbf0011,0xa4b60009}},	//   _andk, _शिल्, ्लिं, _קלרה_
  { {0xd6db05f4,0x1ec9002d,0x907c0009,0xa6c90024}},	//   сте_, ілки_, צטדי, ілка_
  { {0x9e340024,0x8ee80024,0xfe730012,0x2f230035}},	//   нечч, ямів_, ردش_, _rīgā_
  { {0x3cf90037,0xcd980009,0xac960012,0x644d05f5}},	//   ्में_, הדות_, ونوا_, onai
  { {0x62870164,0x644d05f6,0xf2050011,0x3e640031}},	//   _hijo, nnai, राक़_, lött_
  { {0xb33b003a,0x661a05b1,0xbe980012,0x15f50011}},	//   _geçt, _fotk, _فضلا_, _इसपर_
  { {0x80d9002d,0x7afb0051,0x02390003,0xaa56004c}},	//   оєму_, rvut, تثبت_, мињу_
  { {0xdb0b000e,0xb7bd000d,0x63a40010,0x7643055c}},	//   _megé, _alţi, ybin, miny
  { {0xa3ae0044,0x59dd0044,0x7d1e005e,0x3f6a05f7}},	//   करण_, न्तर, äpse, жимо_
  { {0x9f5f0028,0xcfb6000b,0xe9ce05f8,0xb7da0009}},	//   ðuð_, ולרי_, _ик_, חקרי
  { {0xfce6002d,0x3e64000e,0x764300b6,0x59d40011}},	//   мого, jött_, niny, _दायर
  { {0x33f6002d,0x91fc001e,0x3e64000e,0x26d9004a}},	//   мчас, klāj, dött_, atso_
  { {0x644d05f9,0x68260031,0x69c301e3,0x628f05fa}},	//   gnai, _módk, ónen, _buco
  { {0xd6aa0003,0x09ba0003,0xae9a0003,0xcb6705fb}},	// [880] _بدعم_, قطاع_, _بضبط_, дате_
  { {0x3e640031,0xda050011,0x644d05fc,0x764305fd}},	//   gött_, रागत_, anai, jiny
  { {0xb33b00a2,0x3cf90037,0x7643055c,0x02190024}},	//   _seçt, ्मों_, diny, чіть_
  { {0xfbb20044,0x28c50011,0x0fee0011,0x23b20011}},	//   _ज़िम, _विनि, ज़िश_, _ज़िद
  { {0xe7320012,0xc68f0012,0x7643016d,0x628705fe}},	//   خصا_, لِن_, finy, _fijo
  { {0xd10d0037,0xceb90066,0xd49a05ff,0x59dd0011}},	//   िमाण_, áři_, ори_, न्दर
  { {0xf983024d,0xfce3004c,0xfc490081,0x9e650012}},	//   _агро, војо, rận_, راهن
  { {0xa8030014,0xa9570009,0xa1570009,0x493b00af}},	//   _изсл, _חילק_, _חבלה_, _וגלו
  { {0xa01b0065,0x98460039,0x539b000b,0x6e930003}},	//   lmög, _dēļ_, חיפו, _للقا
  { {0x7a200600,0x03770009,0xc5760012,0xc114004c}},	//   _gött, ותפת_, _قطاع, емој
  { {0x644b0028,0xa3c00011,0x2bbd0011,0xa01b0032}},	//   ðmið, ीला_, ोलशा, nmög
  { {0x3e64000f,0xf5370009,0x3ea9004b,0x78520035}},	//   zött_, _קטאר_, ţate_, tāva
  { {0xe667002d,0x77640014,0x80c00037,0xa77403e1}},	//   дтво, върж, _विवे, ключ
  { {0xe2460003,0xfc3f0030,0x68fc0601,0x7d000035}},	//   _تخصي, _smí_, årds, āmsn
  { {0xa4d40024,0xdcb10012,0x0cd40024,0x7a200602}},	//   корі, طىء_, корю, _löts
  { {0x62870603,0xdb0b000e,0xe0d10009,0xbb4b0024}},	//   _sijo, _segé, _עֲו_, оїзд_
  { {0x8c1b000b,0x3e64000e,0xd3700012,0xeb9101b0}},	// [890] קומי, tött_, لهِ_, אָב_
  { {0x416b0001,0x61f80604,0x99870030,0x21f50012}},	//   ојем_, _javl, ónů_, عكاس
  { {0xc5f20009,0xa3ae0011,0x18a40024,0xe9d00012}},	//   _גדי_, करा_, ваєм, شغل_
  { {0x2c27007c,0x38c40028,0xfc3f0030,0xd6b50048}},	//   _цьог, _sérð_, _umí_, ейдъ
  { {0x28c50044,0x76430605,0x6b9a0009,0x539a0009}},	//   _विभि, tiny, _משרד, _מירו
  { {0xf7700003,0x999e0030,0xad250012,0xd0d50048}},	//   جام_, ditů_, فرعو, _погъ
  { {0xbdf80003,0x29180051,0x44290606,0x76430607}},	//   برنا_, äral_, oka_, riny
  { {0x764300c6,0xf3f2000b,0xa3d70011,0x2101001b}},	//   siny, ָ֣ה_, _साफ_, rčić_
  { {0xa3de0044,0x6ee70012,0xa3d70011,0xd5b10081}},	//   द्ध_, _تسأل, _सान_, _hóm_
  { {0x80c00302,0xedd50003,0xe9d90281,0xa2c20011}},	//   _विशे, _سيؤد, чко_, _लिस्
  { {0x186a029b,0xf4d40003,0x68460063,0x44290608}},	//   зани_, _لتنظ, енна, kka_
  { {0x44f1039c,0xb4fa000b,0xc952000b,0xdb060029}},	//   _iš_, _מפעי, רמט_, _leká
  { {0xc2c80003,0x69d50002,0x93270012,0x78760018}},	//   _قبول_, _ocze, _تران, jáve
  { {0xf6520003,0x7c290609,0x69c301e3,0x7f3a0009}},	//   ائح_, lker, ónel, לערו
  { {0xdb0402d1,0xa9660048,0x1d07060a,0x68e20034}},	//   mbié, _пиша_, нери_, łodz
  { {0x4429060b,0x3c2e0064,0x1ddf0011,0x98160012}},	//   gka_, _býva_, प्तत, _سببا
  { {0x7c29060c,0x28c50037,0x78760018,0xa9a60148}},	// [8a0] iker, _विडि, gáve, еизд
  { {0xe1f7026d,0x2bb20011,0xa01b0032,0x4432060d}},	//   нгу_, _ज़वा, tmög, shy_
  { {0x44320036,0x4c860345,0xf2050011,0x35c90011}},	//   phy_, _плов, राज़_, _राज़
  { {0x442901ab,0x768b003e,0x7c290070,0xbe8a0001}},	//   cka_, _użyc, jker, пске_
  { {0x44f1007a,0x6826060e,0x78760017,0xc8ec0321}},	//   _aš_, _códi, cáve, _जन्म_
  { {0xdcfc00a1,0xceb3007e,0xf7470012,0xdd8f0012}},	//   ları, ניו_, علوي_, موه_
  { {0x3da5007c,0xc43a0009,0xb5a50024,0x64c300ae}},	//   тріб, ּתִי, трій, هيول
  { {0x6f04007d,0x7c29060f,0xd491001a,0xd5770009}},	//   _oric, gker, _dù_, עתקה_
  { {0x3254004c,0x78520035,0xee3a047a,0x59d40610}},	//   квир, tāvn, _ена_, _दादर
  { {0x2d8c0029,0x6da60003,0x7c290611,0x010a0009}},	//   ždej_, _أمام, aker, ִלָּ
  { {0xdcfc00a2,0x3a37000b,0x6d49000d,0x44290612}},	//   karı, גרים_, şeaz, yka_
  { {0xac970003,0x6d0b0009,0x7d570009,0x7c290613}},	//   _أننا_, _מִדַ, _איבד_, cker
  { {0xdcfc003a,0x6f040614,0x6d4801e3,0xd6040024}},	//   darı, _cric, údan, _пiдв
  { {0xbe880015,0x44290002,0x78760017,0xef0e002d}},	//   ессе_, wka_, váve, рмi_
  { {0xf1b3000b,0xd491001a,0x2d850615,0xa407004c}},	//   _עסק_, ề_, äle_, нџак
  { {0x2c090037,0x78760017,0xd6db0345,0x8d77000b}},	//   वाएं_, táve, _ето_, תגלו_
  { {0xf9c7035b,0x17f80012,0x07f80012,0xa3d70011}},	// [8b0] ещен, _سرية_, _سريع_, _साठ_
  { {0x51f80015,0x1ed80012,0x78760616,0x69da0031}},	//   нную_, _أبيب_, ráve, _ötel
  { {0x7fd5002d,0xbc79002d,0xdcfc0060,0x69d80011}},	//   вілі, _обох_, barı, _मानी
  { {0x69d50002,0x64480617,0x9f98004c,0x612b0031}},	//   _wcze, édit, евцу_, lölö
  { {0xe8df001a,0xdb0b0058,0x141a0009,0x8c1a0009}},	//   _thỏa_, _udgø, _חורב, _חורי
  { {0xb5c2002d,0x69d50002,0xd5b1001a,0xf7740009}},	//   айшл, _ucze, _tóm_, נקס_
  { {0xf402000d,0x28c50037,0x2245009b,0xe8df0081}},	//   _faţă_, _विधि, vilk_, _muịc_
  { {0xd1380002,0xb8e70037,0x130900b3,0x78ba0618}},	//   dzą_, ों_, дний_, dstv
  { {0x56950014,0x628a006f,0x28c90011,0x3ed90012}},	//   _разт, _bifo, ांकि, _زواج_
  { {0xdcfc003a,0xaae40012,0xef640048,0x76410097}},	//   zarı, اسيو, _съсо, _umly
  { {0xdcfc00a2,0xf992000b,0xa2bd0037,0x07a600fa}},	//   yarı, ירי_, _शिक्, канн
  { {0x5046004c,0x6f040619,0x7d1a0248,0xd4960009}},	//   темб, _pric, ätsm, _סכנת_
  { {0x539a000b,0x7c26006f,0xdcfc003a,0xfc4600d9}},	//   _חינו, ökre, varı, ších_
  { {0xceb20093,0x2c4c0066,0x6fa20037,0x89350012}},	//   שים_, vědi_, _क्रू, _لعبا
  { {0x61d6000b,0xdcfc003a,0xd1380002,0xdb0b000e}},	//   _יוסף_, tarı, czą_, _megí
  { {0x5184007c,0x2ae50037,0xe8d6000b,0xf0920009}},	//   _суча, _कहाँ_, _סופר_, _דנה_
  { {0x78780149,0xdcfc003a,0x63a900df,0xa3c40011}},	// [8c0] níve, rarı, iben, ौलत_
  { {0xa3d70044,0x4253000a,0xdcfc003a,0x5ee9000b}},	//   _साथ_, لنقر, sarı, _נַפְ
  { {0xdcfc003a,0x6abe0011,0x7afc0035,0x3e69061a}},	//   parı, _एट्र, ārti, nútu_
  { {0xc952000b,0xc7c30015,0x65570009,0x63a9001b}},	//   סמא_, асши, _יביא_, jben
  { {0xa3d70037,0x52860003,0x935a004c,0xfaa6004c}},	//   _सात_, _للحك, _црну_, _јаго
  { {0x78780066,0xd5e30024,0x9f42008e,0x63a9061b}},	//   díve, ижчи, mekä_, eben
  { {0x628a00c1,0xdb0f0018,0xe4d30012,0x3253003c}},	//   _rifo, _recé, لتيب, _твёр
  { {0xa5070001,0xdfd20003,0x31bc0030,0x6826061c}},	//   ђења_, _خير_, bází_, _kódu
  { {0x26dd0002,0x78780017,0x96e50012,0xcec10034}},	//   ctwo_, gíve, _مثلم, _chęć_
  { {0x6206002d,0x78ba061d,0x637b0009,0x3ea6061e}},	//   тчиз, tstv, ונפד, mpot_
  { {0x26c4000e,0x497301d4,0xc4c50012,0x1be20011}},	//   ámon_, ильс, _متنو, खभाल_
  { {0xd1380002,0x14d70009,0x78780018,0x78ba061f}},	//   rzą_, _יובל_, bíve, rstv
  { {0xd138003e,0xe29f0028,0xfbd30009,0x628a0620}},	//   szą_, _orða_, _כתף_, _tifo
  { {0xa3de0044,0xa4d5007c,0x78ba0580,0x3e690064}},	//   द्र_, логі, pstv, bútu_
  { {0xfa77000b,0x69c8003a,0xa3ce0011,0xea7700af}},	//   _שעות_, _ödey, _राख_, _שגור_
  { {0xdfd1000a,0x787600f1,0xe8e0001a,0xb4fb0009}},	//   _اية_, rávc, ýời_, ופלי
  { {0xa8580093,0x2d9e0621,0x337505fb,0x7e63020d}},	// [8d0] _שיחה_, _ofte_, угар, yonp
  { {0x63a90622,0x41b50012,0x5b340012,0x5a340560}},	//   zben, امار, جعفر, анут
  { {0x9848003a,0xdb0b0164,0x27ef0623,0x89780009}},	//   _ağı_, _regí, tegn_, תָּה
  { {0xdb0b000f,0x61fc0036,0xdcb10020,0x6fd40024}},	//   _segí, _earl, ẩu_, иціє
  { {0x787601e9,0x645a0025,0x78780018,0x61fc0624}},	//   náva, étie, xíve, _farl
  { {0xd7740003,0x0e640024,0x6da40012,0x7bc20025}},	//   جامع, акін, لمهم, _adou
  { {0xeb990625,0x26dd0002,0x245a001e,0xd469011d}},	//   ний_, stwo_, zīme_, нике_
  { {0x200d007d,0x1bb90003,0x63a90626,0x7c2d0627}},	//   _unei_, رابع_, uben, nkar
  { {0x7876000e,0xc7b2000b,0x76450058,0x61fc0060}},	//   jáva, _לבן_, _omhy, _yarl
  { {0x78760628,0x38690629,0x96f80003,0x3c310064}},	//   dáva, _akar_, _جعفر_, _dáva_
  { {0x78780017,0x9f4e0066,0xd5b1001a,0x2ba40011}},	//   síve, čním_, _nói_, _ग्वा
  { {0x2c090037,0xb8eb0037,0xc172000b,0xddd50066}},	//   वाओं_, _लि_, מחי_, mozř
  { {0x44f50066,0x09e500f5,0x28c50321,0x91e503e2}},	//   _ať_, _болн, _विवि, _боле
  { {0xdd92000a,0x2edc0011,0x64490097,0x2bbd0011}},	//   صور_, मझौत, liei, ोलका
  { {0x8c7a0014,0x6e210027,0x8cd40011,0xc984004c}},	//   ещат_, _molb, बंधो, _кући
  { {0x7c2d0101,0xc9520009,0x442d062a,0x6449004b}},	//   gkar, _למו_, nke_, niei
  { {0x9b93000a,0x442d062b,0x69da0060,0xb69b0018}},	// [8e0] إلكت, ike_, _ötek, lvân
  { {0x3e760028,0x3b83062c,0x442d0154,0xe9d701d4}},	//   bæta_, слуг, hke_, лку_
  { {0x11d70003,0x3ebf000d,0xd5b1001a,0x442d062d}},	//   اومة_, _avut_, _gói_, kke_
  { {0x442d062e,0xca29000b,0xdbd70052,0x68fc0058}},	//   jke_, הם_, mäßi, ærdi
  { {0xc7d70093,0x7852001e,0x442d062f,0xf4130009}},	//   רוני_, tāvj, dke_, _הפר_
  { {0xccfa0046,0x442d0630,0x6cd40012,0xa6e30097}},	//   ећи_, eke_, لقتا, óðir
  { {0xf8c50044,0x54e60003,0xcce60003,0x44220631}},	//   _विषय, استق, استي, _kok_
  { {0x25f00037,0xd4670001,0x6826000e,0x78a30097}},	//   _इसकी_, лије_, _móds, ínve
  { {0x628e000e,0x2bd50011,0x91fc0035,0x29020035}},	//   _kibo, _धारा, klāt, ākam_
  { {0x2ba40044,0xa3e40044,0xd6cf000a,0x28c50044}},	//   _ग्रा, प्त_, _رقم_, _विशि
  { {0xf593000a,0x8d93000a,0x442200bd,0x7d93000a}},	//   _المج, _المش, _ook_, _المؤ
  { {0xe29a0014,0x442d0632,0x628e0633,0x44220634}},	//   _зад_, cke_, _libo, _nok_
  { {0x80c00037,0xa3ce0011,0x6e950635,0x91aa0011}},	//   _विके, _राज_, ригу, टरफ़े
  { {0x7c220070,0x6e94003c,0x78760636,0x38660227}},	//   _hoor, сиру, ráva, hoor_
  { {0x16d10044,0x7c2d0039,0x7876000f,0x7a36007d}},	//   _सम्ब, tkar, sáva, _câte
  { {0x26de000d,0x7c2d003a,0x44220060,0xa3e70011}},	//   ător_, ukar, _cok_, म्प_
  { {0x4422001c,0xc334000b,0xda670012,0xead50024}},	// [8f0] _dok_, בוּ_, هائي, розь
  { {0x442d0637,0x7c2d0638,0x628e0639,0x7d08063a}},	//   zke_, skar, _cibo, _ords
  { {0xdb0b000e,0x442d004a,0x2907063b,0x628e00b6}},	//   _megá, yke_, ína_, _dibo
  { {0x7c22063c,0xe8d7000b,0x2ba40011,0x44220227}},	//   _noor, רואר_, _ग्ला, _gok_
  { {0x76ab0046,0x63ad063d,0xb3ba000b,0x44c10010}},	//   хтев_, mban, _במרכ, lė_
  { {0xa3e70037,0x1994002d,0x1be20037,0x28c50011}},	//   म्न_, _гаря, क्सल_, _विलि
  { {0x44c1007a,0x442200a2,0x3d080044,0x6e210066}},	//   nė_, _yok_, हिये_, _volb
  { {0x6a6b0052,0xdd1d0029,0x91fc001e,0x63ad063e}},	//   rüfu, ráňt, klās, nban
  { {0x7c22063f,0x02d60003,0xf20a0011,0x7c84004c}},	//   _door, لويب_, _होड़_, љује
  { {0x27ff0006,0x44c10010,0xcb120009,0x442d0640}},	//   _haun_, kė_, קלי_, ske_
  { {0x7c220005,0x63ad0101,0xb69b000d,0x8e840003}},	//   _foor, kban, uvân, _الله
  { {0x44c10010,0x7bc70010,0xdb0f0018,0x63ad0641}},	//   dė_, ėjus, _mecâ, jban
  { {0x92b70003,0x98aa001e,0x93940003,0x501a000b}},	//   _إحصا, ējāt_, _اجما, דורו
  { {0xed5a0046,0x44220642,0xbb3a000b,0xd3560009}},	//   вог_, _sok_, _בעני, _דיני_
  { {0x89da000b,0x44c10010,0xdb0f0164,0x628e04cf}},	//   _יחסי, gė_, _decí, _ribo
  { {0xbb760014,0x141a0012,0x7c3a0035,0x7aa60012}},	//   аузъ, خيرة_, ītro, لإطل
  { {0x386600bd,0xa3d70037,0x6aa4003a,0xc246046d}},	// [900] voor_, _सार_, _çift, анак
  { {0xb77b0093,0x15460001,0x78780066,0xb6bb000b}},	//   _באפש, _веом, díva, _שציי
  { {0xeaf20037,0xf1dd0037,0x26190037,0x91fc001e}},	//   _अन्त_, _मानन, पानी_, olār
  { {0x63bb0039,0xdb0f007d,0xdc9b000b,0xa9670048}},	//   jaun, _decâ, _שיכל, шиха_
  { {0x8f9b000b,0x6f090164,0x27ff00b6,0x46f60014}},	//   דיני, _crec, _daun_, рчет
  { {0x6f0903eb,0x7d00000f,0x7c220643,0x7cec000e}},	//   _drec, járá, _soor, _görö
  { {0xa3e70044,0x787d000e,0x7c220644,0xdd990024}},	//   म्भ_, léve, _poor, уші_
  { {0x6456000e,0x63bb0645,0x8ba90009,0x6c830012}},	//   nnyi, gaun, ְׁתִ, يلوم
  { {0x7c2201e4,0xadba0003,0x44c10010,0xd6cf0012}},	//   _voor, _لهذا_, zė_, _يقف_
  { {0x7c2200bd,0x5a340646,0xc50a0012,0xa3e70011}},	//   _woor, снот, _لتصل_, म्ब_
  { {0xa3d70044,0xd1300003,0x787600f1,0x7c220647}},	//   _साल_, سمح_, rávn, _toor
  { {0x9202001e,0x04db000b,0x78a1000e,0x3e7b0025}},	//   _šāda, _יקבל, _élve, rête_
  { {0x20050066,0xa857000b,0x787d000e,0x83fd0031}},	//   ěli_, שיכה_, jéve, rlőt
  { {0x2005003e,0x44c1007a,0xa3e40037,0x7a320058}},	//   śli_, tė_, प्स_, _sætn
  { {0x8a7b000b,0xcd04003c,0xc5340009,0x4a7b0009}},	//   _שאות, очти, זָּה_, _שרוב
  { {0xec34002d,0xc334000b,0x44c10010,0x8f4700dc}},	//   онсь, ֖וּ_, rė_, _вход
  { {0x290a039c,0x98ab0002,0x787d000e,0x5a350014}},	// [910] _arba_, ącą_, géve, бнат
  { {0x44c1007a,0xe7e80037,0xe9190024,0xf426005e}},	//   pė_, ट्ठा_, лозі_, äära_
  { {0x26140037,0x5f950003,0x7cec000e,0x32640024}},	//   दारी_, ملائ, _vörö, ітув
  { {0x7d00000e,0x7852001e,0x7878029d,0xb8ef0011}},	//   zárá, tāvi, tíva, _शि_
  { {0x7cec000f,0x8c1a000b,0x8416000b,0x3c350248}},	//   _törö, _עושי, _הקרב_, _gåva_
  { {0xfc49001a,0x3cf30011,0xf7700012,0x63a204f9}},	//   hật_, ंबले_, ذان_, _afon
  { {0xe8020037,0x44f8001a,0x7d00000e,0xce38000b}},	//   _रोका_, _cũ_, várá, שאות_
  { {0xed58000b,0x8558000b,0x80c00037,0x644d0010}},	//   יבור_, ישוב_, _विजे, niai
  { {0x7d00000e,0xdb060648,0x1ddb0012,0x6f09004b}},	//   tárá, _sekú, _لبضع_, _urec
  { {0xe4e7007c,0x7876000f,0x6ce7002d,0x629b0061}},	//   _відн, távo, _віде, rquo
  { {0x999e007a,0xa3d70037,0x644d0010,0xe4e4002d}},	//   entų_, सला_, kiai, _міцн
  { {0xaac70037,0x9b950003,0xc952000b,0x7afc001e}},	//   _लिंक, _الإت, למי_, ārtr
  { {0xbb85000a,0x7c3b003a,0x3897000d,0x7b140003}},	//   _الشي, mhur, _mări_, _وبهذ
  { {0x6da3029b,0x6601004a,0xceb20009,0x3c380031}},	//   зира, _jalk, היך_, _véve_
  { {0x2ba60066,0x44e10649,0xf9920009,0x80ce0011}},	//   síců_, nó_, _צרה_, _थिये
  { {0x2c610029,0x8856000b,0x69dc064a,0xdb0a0030}},	//   tódy_, _לֹ֥א_, _scre, šníh
  { {0x290a0027,0xd3b90024,0x44e10081,0x624b0034}},	// [920] _srba_, русі_, hó_, rżon
  { {0xbf9b0149,0x26c2064b,0x228d0073,0x42290009}},	//   ndên, msko_, _užkl_, נֵּ֣
  { {0x787d000f,0x26c2064c,0x3076064d,0x1bf90011}},	//   séve, lsko_, будс, ्याल_
  { {0xe73a0047,0x07b70003,0xf3f9000d,0x644d064e}},	//   лее_, مهمة_, boţi_, ciai
  { {0x2f18064f,0x26c20650,0x44320042,0xd62a0198}},	//   роль_, nsko_, mky_, лоде_
  { {0x50960046,0x63a200c1,0x44320145,0xceb3000b}},	//   _грађ, _sfon, lky_, ליד_
  { {0x91bb000b,0x96c40037,0x71760003,0x44200651}},	//   _תמלי, _रिकॉ, _طهرا, oji_
  { {0x44320652,0x44f8001a,0x3957000b,0x93c5001a}},	//   nky_, _vũ_, _השלם_, _ngắ
  { {0x8c1b000b,0x32660014,0xd3700003,0x26c20653}},	//   רופי, йтов, بهة_, jsko_
  { {0x11d8000a,0xd6250003,0x3e7f0061,0xcb130009}},	//   جودة_, _وعلي, oîte_, פלת_
  { {0x0496000a,0x7174000a,0xdfd10003,0x44e10164}},	//   _الصح, تهدا, ويد_, có_
  { {0xdb0b0163,0x6e25003a,0x26c202a1,0x6fd80011}},	//   _begä, _sohb, fsko_, डलिं
  { {0x7c650003,0x44320107,0xa3760012,0x78780031}},	//   _بالل, dky_, _اداؤ, hívo
  { {0x63b90002,0x39dd0037,0x44200010,0x912a0012}},	//   _zewn, न्फ़ि, eji_, _مسبق_
  { {0x90a60003,0x644d004a,0x94770012,0x7c260654}},	//   _احتم, tiai, مدرا, _bokr
  { {0xb4e90037,0x98c5001e,0x915f001a,0x7d03000e}},	//   _यही_, ūtīt_, _lặp_, eírá
  { {0x78780026,0x44e1000f,0x91b90014,0x2fc90655}},	// [930] tívn, zó_, игат_, _idag_
  { {0x44260051,0x98b8003a,0x44e10164,0xe3bf0164}},	//   _loo_, _ayrı_, yó_, _doña_
  { {0xdce80066,0x443201bd,0x35d20011,0xa0c40012}},	//   _vzdě, bky_, _साज़, كيلو
  { {0x44200656,0x6f0d0070,0x44e10164,0x44320657}},	//   cji_, _krac, vó_, cky_
  { {0x44390108,0xfaff001e,0x7d030658,0xba770012}},	//   _ils_, šību_, bírá, _هاست
  { {0xd126000a,0x44e10659,0x3cf90012,0xaa5d0024}},	//   _قم_, tó_, لعبد_, _регi
  { {0xe3b1000a,0x63b9003e,0x6601065a,0xac39002d}},	//   ورة_, _pewn, _valk, ичих_
  { {0x386d0033,0x69da000e,0x3ea9004a,0x44e1065b}},	//   _uker_, egte, _otat_, ró_
  { {0xb4d60037,0x63b90002,0xe299004c,0x44e1065c}},	//   _सम्_, ówny, јао_, só_
  { {0x5ce50003,0x63b90002,0x915f001a,0x44200002}},	//   _وكذل, _wewn, _gặp_, zji_
  { {0x6f0d00a2,0x35d30037,0xfbdf0017,0xf6520009}},	//   _arac, _ताज़, _ocê_, _קצב_
  { {0x78760029,0x44c5001e,0x186a065d,0x93150012}},	//   mávk, mē_, рами_, _وواش
  { {0x28c5015f,0x44c5001e,0x443200f1,0x96ba004c}},	//   _विकि, lē_, vky_, јуму_
  { {0x4426051c,0x4439065e,0xdb000097,0x26c2065f}},	//   _zoo_, _als_, tamö, rsko_
  { {0x4432022d,0x27ed0052,0x44c5001e,0x7d030030}},	//   tky_, _oben_, nē_, vírá
  { {0xeb970015,0x6a700052,0xd5dc0037,0x17fa0003}},	//   жит_, häft, _बावज, _ضربة_
  { {0x3b070014,0x44200660,0x6f0d0661,0x3a260662}},	// [940] оето_, rji_, _grac, омаг
  { {0x44390663,0x4420003e,0x3205002a,0x78780664}},	//   _els_, sji_, ndly_, tívo
  { {0x10a6022a,0x27ed0031,0xc6170009,0x03b60012}},	//   циен, _bben_, _וחיי_, _وإحد
  { {0xa2a20037,0x24610010,0xe3b20003,0x44c5001e}},	//   _कंप्, tėme_, _ترد_, dē_
  { {0xa25b0029,0x9e660012,0x7680008e,0x63a40060}},	//   _kvôl, ياتن, pöyd, mcin
  { {0x24610010,0x27ed0052,0xa3e70037,0xeca60001}},	//   rėme_, _eben_, म्स_, ојин
  { {0x672f003e,0xd4970015,0x16b70037,0xbfd60012}},	//   zycj, оры_, _अब्ब, _ويسع
  { {0x3e7b0025,0xe4660060,0x711b0009,0x63a40665}},	//   rêta_, _önüş, _דולפ, ncin
  { {0x63a4001e,0x83fd000e,0x69da003a,0x6df60012}},	//   icin, rlőp, _ötes, _وكرا
  { {0xc5160012,0x89da0009,0x7bdb020d,0x26c00073}},	//   _وبات, ׁחִי, aguu, šios_
  { {0xfbca0044,0xc19b000b,0x44260666,0x64950066}},	//   िणाम, ישיי, _too_, _všic
  { {0x4034003c,0x32050132,0x69da020d,0x8b6a0667}},	//   деюс, adly_, sgte, _киев_
  { {0x61ee00c1,0xe67b001a,0x7c650003,0xdb20008e}},	//   _obbl, _hưở, _عامل, ätäl
  { {0x63a40039,0xddda0031,0x6f0d0668,0x7bc00669}},	//   ecin, _kitű, _vrac, lamu
  { {0x6ce4007c,0x6594002d,0xe4e4002d,0x6f0d0120}},	//   міте, дару, мітн, _wrac
  { {0x320d003a,0x26110011,0xc3990024,0x2004066a}},	//   _şey_, _धोनी_, скає_, _nami_
  { {0x44c5001e,0x97ea003a,0x93fb0009,0xe9ab0012}},	// [950] zē_, ışlı, סלמי, لدان_
  { {0xfc49001a,0x78a3000e,0xeab00012,0xceb20009}},	//   hập_, ínvo, ضعك_, _ריי_
  { {0xdfd10003,0x31c4064f,0x15fa0009,0xd5fa0009}},	//   فيا_, ьств, _ההתע, _הפתר
  { {0xa295002d,0x9cd6000b,0x44c5001e,0x7bc0066b}},	//   _намі, _צורה_, vē_, jamu
  { {0xdefb0047,0x63bd0039,0x8c1a000b,0x2004002c}},	//   рые_, _iesn, _הורי, _dami_
  { {0xa6fc000b,0x9e34002d,0xafdb0033,0x2efc0009}},	//   שִׁי, мечч, rnøy, שִׁב
  { {0xfc31000a,0xdfdb0014,0x6605066c,0x6a70066d}},	//   فحة_, _въз_, _mahk, räft
  { {0x6605066e,0xf992000b,0x98170003,0x8d5c000b}},	//   _lahk, _טרם_, _ببسا, יכוי
  { {0xf749000a,0x768b003e,0x3da70014,0x6e280058}},	//   _الذي_, _używ, _дреб, _fodb
  { {0xeb92000b,0x44c5001e,0xc2420055,0x2ddb0012}},	//   עָה_, pē_, еньк, _خبرة_
  { {0x3205002a,0x21690538,0xa969066f,0x9b950012}},	//   rdly_, сини_, сина_, _فلات
  { {0x711a0009,0x7d7a0009,0x3ea40030,0xdb0b0031}},	//   צורפ, _הנעו, ímto_, _megú
  { {0x660500c6,0x20040026,0xdb0b000e,0x539a0009}},	//   _bahk, ľmi_, _legú, _הסנא
  { {0x8b05003e,0x7d790009,0x6d430670,0x80cc0011}},	//   _częś, ֶנּו, ozna, _हिले
  { {0xc6920093,0x91ba000b,0xca36000b,0x19ba000b}},	//   תאם_, _המצי, _מנסה_, _המצב
  { {0xc0a80003,0x26d9002c,0x01340012,0xaac70011}},	//   _باول_, buso_, _تعهد, _लिखक
  { {0x883b000b,0x62950550,0xe29f0028,0xf0930009}},	// [960] _לתקו, _bizo, _yrði_, _אנה_
  { {0xb4bb0011,0xda650012,0x499a003c,0x63bd005e}},	//   _अबू_, والي, стая_, _eesn
  { {0x759b0009,0x859b0009,0x9e650012,0x6ab80011}},	//   _לייח, _לשיו, _تاين, _इब्र
  { {0xfc32000a,0xdb040070,0xd0590024,0x6a7401a0}},	//   _أحد_, ncië, орчі_, ràfi
  { {0xfbd30093,0x80250003,0x7bc00051,0x2004025e}},	//   _אתר_, برلم, vamu, _vami_
  { {0xe8df0020,0x4b7b000b,0xdb0f0017,0x97570009}},	//   _giữa_, _לאכו, _secç, הינו_
  { {0x5ede0011,0xd00a004c,0x69ce0031,0x6026033d}},	//   कंड्_, _леве_, óbem, _едва
  { {0xf8c50321,0x515b0009,0xb3c60011,0xdbcf0030}},	//   _विजय, _הכלו, रृंख, ožád
  { {0xdb06000e,0x69c10671,0x75960012,0x8c1b0009}},	//   _nekü, fale, _فجاء, מוקי
  { {0x7f3b000b,0x7a320028,0xe67b001a,0xfaef0003}},	//   _העמו, _bæti, _tưở, اثي_
  { {0x26190037,0xf1dd0011,0x24890034,0xa01b008e}},	//   पारी_, _मारन, ymam_, lmöi
  { {0xc4860047,0x4c9b0093,0xdb06000e,0xb97b000b}},	//   _элек, _הבאו, _bekü, מניי
  { {0x9b930003,0x63bd009b,0x8b660003,0xee87003c}},	//   _كلمت, _resn, _عاصم, зыво
  { {0x1317000b,0xf1c3001a,0x38a10672,0x12fb0009}},	//   _מחדל_, _chờ_, _fór_, _להדב
  { {0x7a320065,0xc27b000b,0xab5d0002,0x2902001e}},	//   _gæti, _הרגי, raże, ākas_
  { {0x415b0093,0x31c60066,0x2d58002d,0x515b000b}},	//   _לדוג, bízí_, чись_, _לכוו
  { {0xdb0b02d1,0x8f9c000b,0x26c4000e,0xdb040061}},	// [970] _segú, _פיזי, ámot_, nciè
  { {0x61fa0673,0x1758000b,0xdb09000e,0x66bc0009}},	//   netl, _מסחר_, nbeá, _המזה
  { {0x60da003a,0x24890029,0x14d50009,0xa3e50011}},	//   nutm, ňami_, _קוֹל_, _नाप_
  { {0xe0d00003,0xf7750024,0x69c10674,0x61fa0675}},	//   ازل_, мулю, zale, hetl
  { {0x61fa00a2,0xe80e0037,0x660501b6,0xf8680012}},	//   ketl, ियता_, дпла, أمني_
  { {0xf770000a,0x61fa0027,0x238a0029,0xf3f9004b}},	//   دام_, jetl, ňujú_, inţe_
  { {0xc2120093,0x61fa0676,0x91b30081,0x69c10677}},	//   _בהם_, detl, _đèn_, vale
  { {0xc952000b,0x2ef5002d,0x69c10002,0x52a90339}},	//   _סמן_, _озбр, wale, овим_
  { {0x13060015,0xa3df0037,0xe8210037,0xf3f9004b}},	//   дный_, तलब_, याना_, reţ_
  { {0x442b007d,0x88c90015,0x6440003a,0x68e1006f}},	//   _loc_, олов_, ahmi, _älds
  { {0xa3cd0011,0x69c10678,0xdcf60035,0x8c3c0060}},	//   रणा_, rale, ācīb, _buğd
  { {0xcdc90093,0xbca40003,0x64400679,0x78a90159}},	//   _כך_, _أمني, chmi, _čevl
  { {0xdb040070,0x4374010b,0x61fa067a,0x77830198}},	//   rcië, _пушт, betl, клюз
  { {0xcb120009,0xa2940024,0xc1050012,0x329a0009}},	//   _שלג_, _зачі, _يوشي, _ובסד
  { {0x6a7d03eb,0xe2900012,0xd4f5003c,0xe29f0097}},	//   lèfo, _إذن_, няты, _auð_
  { {0x9983007a,0x26c4000e,0xe8d60009,0x6e210097}},	//   ųjų_, ámos_, _חוקר_, ölbr
  { {0xf7460015,0x29030051,0x7ae9067b,0xfaff001e}},	// [980] _цепо, _asja_, ntet, šīnu_
  { {0x7ae9067c,0x7c360010,0x7c2b067d,0xf9920012}},	//   itet, skyr, _logr, نبا_
  { {0x32070036,0xac86002d,0x361b000b,0x7ae9067e}},	//   _many_, _огол, _וויד, htet
  { {0xdfcf000a,0xc9850012,0x7ae9067f,0x68e301a0}},	//   ليم_, رشلي, ktet, ànda
  { {0x7ae9000e,0x33fb000b,0x96fa0003,0x61fa02f7}},	//   jtet, _והכנ, تعار_, yetl
  { {0x768b003e,0x2d9a0033,0x11d60003,0x28db0011}},	//   _użyt, øpe_, _تتحد, मूहि
  { {0xa3e50044,0xddde000e,0xf6570009,0xdd900012}},	//   _नाम_, övőb, וססי_, دوث_
  { {0x47d30003,0x7ae90680,0x442b01a0,0xe29f0097}},	//   _ليفر, ftet, _xoc_, _erðu_
  { {0xae1e0037,0x1ea90003,0x3ea00061,0x68e1006f}},	//   पादन_, _فالي_, _nuit_, _äldr
  { {0xdb040025,0x1e830681,0xe8140011,0xddc30682}},	//   rciè, _алум, _तोबा_, ponš
  { {0x60da0051,0x61fa0683,0x32070684,0xa0550024}},	//   uutm, retl, _dany_, евні
  { {0xf993000b,0x68e1006f,0x3ea00685,0x5cc50012}},	//   כרת_, _ålde, _buit_, _أغلق
  { {0xc7b3000b,0x5b360012,0x3cf10011,0x74130012}},	//   כבר_, _تعار, ँढ़ने_, _جونا
  { {0x6b82009b,0x3ea000b6,0x7f2b0009,0xee84003c}},	//   _izog, _duit_, חֵלֶ, высо
  { {0xd3080020,0x442b0054,0x6e940686,0xfa970009}},	//   _hệ_, _poc_, тиру, _קדוש_
  { {0x7a3f0061,0x443d0002,0xb7e60011,0x1bbb0012}},	//   _vête, ów_, _कायम_, تاسع_
  { {0x6298000e,0x7a320028,0xae0c0011,0x67bc0009}},	// [990] _kivo, _lætu, िएशन_, _ומחק
  { {0x7a3f0061,0xa295002d,0x3e690029,0x62750012}},	//   _tête, хазі, búty_, رهائ
  { {0xd3080020,0x7ae9000e,0xc6920009,0xdb1d0031}},	//   _lệ_, ztet, _תאי_, _mesé
  { {0x7ae90006,0xa2cf0037,0x64480054,0xa9570009}},	//   ytet, _दिल्, èdit, ויבק_
  { {0xd7580012,0xe7240012,0xaac70012,0x8bd60009}},	//   وجها_, َّمَ, _تتجن, _אורו_
  { {0xdb1d0029,0x6298013a,0x99d40012,0x75d50012}},	//   _odsú, _nivo, _لتفا, ريعا
  { {0xba3d0013,0xdfd50015,0x67d50001,0x7c2b0687}},	//   způs, _повы, _пову, _pogr
  { {0xcd980093,0xdcb1001a,0x69c50688,0x83fd000e}},	//   ודות_, ẩy_, lahe, llőz
  { {0xa3e40037,0x7ae9004a,0xed580029,0xba3d0030}},	//   प्ट_, utet, _veľa_, dpůr
  { {0x64950010,0xdb0e000e,0x21990009,0xe29f0097}},	//   _išim, ájáh, ּבֹא, _urðu_
  { {0x61e10065,0x3ea00689,0x245a001e,0x7a320028}},	//   _öllu, _suit_, zīmi_, _gætu
  { {0x7a320065,0xc5e9000b,0x787801bd,0xf9920009}},	//   _hætt, _לד_, tívi, טרי_
  { {0x64850017,0x6d64000d,0x3ea00132,0x2fc001a0}},	//   róid, ătaţ, _quit_, _veig_
  { {0xceb2015a,0xe29f0065,0xd356000b,0x3ea001a0}},	//   רים_, íðu_, _איני_, _vuit_
  { {0x75f3003a,0xa806003a,0x7a32068a,0xe29f0097}},	//   mızı, _alış, _mætt, _orðs_
  { {0x25e40037,0x98a70066,0x52aa0014,0x35dc0011}},	//   ञ्जी_, šně_, звам_, _बाक़
  { {0xa6960046,0xfd650020,0x3d010037,0x69dc0002}},	// [9a0] _прој, _chuẩ, _वैसे_, óreg
  { {0x75f300a2,0x72060003,0xdb090018,0x69c5068b}},	//   nızı, عوام, abeç, gahe
  { {0x261d0037,0x78ab000d,0xba3b01a0,0xec7a05d8}},	//   मारी_, _învă, _suïc, _нпо_
  { {0xe786002d,0xa0670345,0x248d03ca,0x59e20011}},	//   нуло, наха_, jmem_, _पावर
  { {0x2ba80037,0x7a320097,0x11d6002d,0xa857000b}},	//   _ज़्या, _bætt, _півр, עינה_
  { {0x69ce0058,0xad260003,0xbf650012,0x64560060}},	//   _udbe, فربو, خدمو, liyi
  { {0x629800c1,0x7876068c,0x61fe068d,0x6b82068e}},	//   _rivo, návs, mepl, _szog
  { {0xcd030015,0xab5d0002,0x47d60003,0xc4d30009}},	//   учши, waża, _سيطر, אגה_
  { {0xa01b0065,0xcb070003,0xfd9a0003,0xdb080061}},	//   llög, فيين_, _فئات_, élèv
  { {0xd3080020,0x5a340014,0x2486002a,0xc333000b}},	//   _vệ_, тнот, _whom_, טוח_
  { {0xab5d0002,0x7655003a,0x6e2b0009,0x45b70009}},	//   raża, vizy, _מֵאַ, _נפאל_
  { {0x9cd7000b,0x44cc0066,0xd308001a,0x5fb90037}},	//   _טובה_, mě_, _tệ_, आरएल
  { {0x61fe00b0,0x7c260248,0x261d0011,0xe667068f}},	//   kepl, ökru, माली_, етво
  { {0x2c4c0066,0x7b06001e,0x68eb000e,0x61460061}},	//   vědy_, ērtī, éldá, _célé
  { {0x44cc0013,0x69c50005,0xe8210037,0x61fe0690}},	//   ně_, vahe, यादा_, depl
  { {0x897b000b,0x8aa70015,0xb97b0009,0xa97b0009}},	//   _מרוצ, ержд, _מנוי, _מאוכ
  { {0xe2f8002d,0xc29900b3,0x2be10011,0xa3e80011}},	// [9b0] неті_, дках_, फलता, _बान_
  { {0x7a360061,0x25b90012,0xbb840012,0xf3f9004b}},	//   _bâti, _تهدد_, الكي, inţa_
  { {0x65950046,0xe61f001a,0x18a40024,0x78780031}},	//   _јану, _đô_, гаєм, hívu
  { {0x44cc0013,0x7a320058,0xd7590003,0x69c50691}},	//   dě_, _sætt, ولات_, sahe
  { {0x61fe003a,0x22950003,0x245a0035,0xe7f40011}},	//   bepl, _للحس, nīmu_, ेजता_
  { {0xee38007c,0x20090692,0x649501bd,0x44290693}},	//   нні_, žai_, _všim, lja_
  { {0x25e90037,0x16000011,0xf3f9004b,0x85780048}},	//   _जानी_, ऊज़र_, enţa_, нсът_
  { {0x351c000b,0x44290694,0xeb990695,0xf8b20009}},	//   לוונ, nja_, мий_, _כשל_
  { {0xe7db0037,0x48640014,0xb4360009,0x50640696}},	//   _भाजप, _сърб, דָיו_, _стра
  { {0xc334000b,0x44cc0066,0x25ac0697,0x44290269}},	//   רוץ_, bě_, _gfdl_, hja_
  { {0x44290309,0x186a00f5,0x63a90698,0xf3f9004b}},	//   kja_, дани_, pcen, anţa_
  { {0x2c170037,0x2d850060,0x321c0132,0x44290699}},	//   थाओं_, _izle_, _envy_, jja_
  { {0x7c29001c,0x4429069a,0xf0920009,0x3b09004c}},	//   mjer, dja_, ינט_, _цело_
  { {0x0dba0003,0x7aed01aa,0x7d030132,0x2d9e00b0}},	//   باحث_, dtat, owns, øte_
  { {0x3aeb0033,0x44290028,0x1fb6069b,0xd9420014}},	//   løp_, fja_, _испр, _вещи
  { {0x442f069c,0x4429069d,0xb063008e,0xc4d20009}},	//   _jog_, gja_, äätt, יגל_
  { {0x61460108,0x7aed0101,0x442f0027,0x64440051}},	// [9c0] _télé, gtat, _mog_, rhii
  { {0x4a43002d,0x8f370009,0xd5e00011,0x69c3069e}},	//   анув, _סניף_, _नाइज, _jene
  { {0xd5be001e,0x442f0070,0xc879003a,0x7c3b069f}},	//   šāka_, _oog_, luğa_, kkur
  { {0x4429003e,0x44cc0013,0x442f06a0,0xbb860012}},	//   cja_, vě_, _nog_, _للجي
  { {0xab5d003e,0x7aed06a1,0x3aeb00b0,0xb6060048}},	//   ważn, ctat, jøp_, вяйк
  { {0x7673002d,0x44cc0066,0x98a7000d,0xdb06000e}},	//   аліф, tě_, ână_, _bekö
  { {0xc5f30009,0xdff40011,0x0466004c,0x442f06a2}},	//   ידג_, ेजाद_, ктим, _bog_
  { {0xdb0b0017,0x1d070001,0x7c290033,0x2465001e}},	//   _negó, тећи_, gjer, tēma_
  { {0x4e060046,0xbea60098,0x442f06a3,0xa01b0028}},	//   _изаб, _разк, _dog_, kmör
  { {0x8f75002d,0x442906a4,0x3cfa0012,0x44cc0030}},	//   _сусі, zja_, _يعاد_, pě_
  { {0x7aed0272,0x7c3b0039,0x442f000f,0x35dc0037}},	//   ztat, bkur, _fog_, _बाज़
  { {0xc173000b,0x320a00f1,0x7aed000e,0xfd570009}},	//   יחת_, žby_, ytat, _בשבי_
  { {0xada20028,0x7ad40012,0x7641008e,0x2d8c0030}},	//   _þúsu, _إقتص, _ylly, ýden_
  { {0x442f0052,0x12a90003,0x539b0009,0x6f160248}},	//   _zog_, _أدنى_, _חידו, _dryc
  { {0x64480039,0xe29b000b,0xbca50003,0x69fb000b}},	//   īdin, _קשור, امري, _חלוק
  { {0xbf670003,0xe8d7000b,0x69c3000e,0x0ed20011}},	//   _لدخو, _סוחר_, _zene, _सिंड
  { {0x4c9406a5,0x7aed06a6,0x69c306a7,0x629c06a8}},	// [9d0] ритс, utat, _yene, _biro
  { {0xe1f00003,0x201e001e,0x442906a9,0x7aed06aa}},	//   قسم_, ētie_, sja_, rtat
  { {0xdb0b03eb,0x4429000f,0xdce80066,0x645a0054}},	//   _segü, pja_, _vydě, ètic
  { {0x92b70003,0x629c001e,0xdd3a000b,0x645a0061}},	//   _لحسا, _eiro, _נערכ, étit
  { {0x7c29001c,0x16350014,0xd7ee0003,0x442f000d}},	//   vjer, ледя, سكو_, _rog_
  { {0x64420006,0x6d580010,0x7f3c000b,0x442f0052}},	//   _aloi, _žvai, ועדו, _sog_
  { {0x78780026,0x56920001,0x69c806ab,0xe4c80012}},	//   tívt, љајт, dade, نبين_
  { {0x130904b3,0x63ad06ac,0x7c3b0010,0x84580015}},	//   ений_, ncan, ukur, крыт_
  { {0xc0520093,0x69c300c6,0x97ea00a2,0xab5d0034}},	//   _הזן_, _pene, ıştı, rażo
  { {0xc332000b,0x7c290033,0x69c806ad,0xee87003c}},	//   צוי_, sjer, gade, _рыбо
  { {0xe4e4002d,0xa2cf0011,0x6ec60011,0x442f06ae}},	//   _вічн, _दिक्, ़ीनु, _tog_
  { {0x64420061,0x1cba0009,0x69c8005e,0x69c306af}},	//   _gloi, _נמנע, aade, _wene
  { {0xa3e80044,0x63bb06b0,0x93270012,0x85430073}},	//   _बात_, mbun, _جران, šėli
  { {0xa2d80044,0xb0630051,0x63bb06b1,0x2ca506b2}},	//   _मित्, äärt, lbun, _kuld_
  { {0xa01b0028,0xdb1d06b3,0x5d860012,0x33f60223}},	//   rmör, _desí, الأل, лчас
  { {0x6f16006f,0x6e3c04d2,0x60da006f,0xb97a0009}},	//   _tryc, skrb, _åtmi, _אנצי
  { {0x63bb0052,0xc053000b,0x6f160066,0xcaa60012}},	// [9e0] ibun, _לזה_, _uryc, اصري
  { {0xbf9b0009,0x479b0009,0x63ad06b4,0x079b00af}},	//   _איפש, _איפס, acan, _אספל
  { {0x25e90044,0x68e1003a,0x7ae0001e,0x645a0025}},	//   _जाती_, nuld, zumt, étis
  { {0x63ad06b5,0x69c806b6,0x3d170011,0xdb1d0030}},	//   ccan, zade, पटने_, _zesí
  { {0x200d016d,0x601b008e,0xa2cf0011,0x68e106b7}},	//   _daei_, _hämä, _दिग्, huld
  { {0x99850010,0xb5aa0003,0xa5f805c6,0x3cb40024}},	//   nklų_, راتك_, теку_, айкр
  { {0xa3e80044,0x7bc600c6,0x6f0900c1,0x614600b3}},	//   _बाद_, _keku, _esec, _сева
  { {0x7ae006b8,0xb4fb0009,0x711b0009,0x76580073}},	//   tumt, תפקי, _אולפ, sivy
  { {0x38550098,0x200200a2,0x9f4a004a,0x38a80061}},	//   _търс, deki_, ämän_, _sûr_
  { {0x64a6002d,0x2ca50058,0x68e10058,0x787d0031}},	//   _бажа, _fuld_, fuld, névv
  { {0x6e93000a,0x68e1001e,0x5e930012,0xb8210011}},	//   _اللا, guld, _اللط, यालम_
  { {0x6485000e,0x7bc606b9,0xa3bb0610,0x27e606ba}},	//   lóin, _neku, _अभय_, ngon_
  { {0xa8570093,0xac970003,0x20570009,0x69c806bb}},	//   ריכה_, _إننا_, ריכל_, pade
  { {0xdd2006bc,0x539b0009,0xdb9b0009,0xa19406bd}},	//   _může, _ניגו, _נסגר, _калч
  { {0xe7a40037,0x68e10017,0xdb0b0028,0xf1b30009}},	//   _ओलंप, culd, _hegð, _פסק_
  { {0x200200a2,0xa98b0009,0x7bc6016d,0x2480001b}},	//   ceki_, _אָחִ, _ceku, glim_
  { {0xba550001,0x291806be,0xaa550048,0x92b40012}},	// [9f0] авај, _arra_, аваш, محلا
  { {0x5d550024,0x6fc70011,0x249206bf,0x63bb06c0}},	//   _вкот, ारभू, amym_, zbun
  { {0xdfd10003,0x3eb9001e,0x6e9a0009,0x7e9a0009}},	//   قيا_, lpst_, _שבתח, _שסתו
  { {0x64b10039,0x98be0002,0x2ca50097,0x27e9005e}},	//   _jāie, cztą_, íldu_, üan_
  { {0xd00c000b,0xfe710003,0x7c2b005e,0x61f80159}},	//   גּוֹ, يدت_, ögru, _obvl
  { {0xbada000b,0x7c2d06c1,0x68e10060,0x20020034}},	//   _בקשת, ljar, yuld, zeki_
  { {0xce380093,0x91f5001a,0x7dd0000e,0x9d450021}},	//   ראות_, híc, lósí, рейд
  { {0x201f007d,0x68e10070,0x7c2d06c2,0x63bb0415}},	//   _unui_, vuld, njar, ubun
  { {0xe4320012,0x787a0009,0x3aef0060,0x63bb06c3}},	//   تفيد, _יָמו, nüp_, rbun
  { {0x63bb06c4,0x68e10060,0x5f440012,0x994a0060}},	//   sbun, tuld, _انكل, nışa_
  { {0x10210037,0xafdb0058,0x80660024,0x8bd50012}},	//   यांश_, dkøb, ивож, _نقاش
  { {0x68e100a2,0xdd2f0066,0x7afd06c5,0x84640048}},	//   ruld, _běže, _opst, _лъче
  { {0x387e0108,0x7c3a000b,0xb8870028,0x644900da}},	//   _être_, _שתנס, _smíð, mhei
  { {0xbb840003,0x69c706c6,0xff160009,0x9f960009}},	//   _الهي, _neje, בקשת_, ידרה_
  { {0x7afd0039,0xdd920012,0xe47a004c,0x660306c7}},	//   _apst, زور_, вљај_, ienk
  { {0xef1a0014,0x6206001e,0x44f1001a,0x442d06c8}},	//   _ами_, ārlū, _mơ_, nje_
  { {0x69c7000f,0x645a0061,0x442d0027,0x487b000b}},	// [a00] _beje, étiq, ije_, _בטקס
  { {0x601b0006,0x171b000b,0x6f09003a,0xa2d80037}},	//   _tämä, _יופע, çece, _मिस्
  { {0x443f0005,0x4ddb000b,0x442d06c9,0x7bc606ca}},	//   kku_, _בחיו, kje_, _teku
  { {0x1ae60047,0xf992000b,0x351b000b,0xca29000b}},	//   _комм, קרא_, _סוכנ, ום_
  { {0x69c7000e,0x2d810052,0x6485000e,0xa3df0011}},	//   _feje, ühen_, tóin, _ताज_
  { {0xaa460014,0x442d0002,0x443f001e,0x91a70037}},	//   _тегл, eje_, eku_, _फ़्लै
  { {0x44f10020,0xdb0b0028,0x7ae406cb,0x9c46002d}},	//   _cơ_, _segð, luit, ихил
  { {0x644906cc,0x628106cd,0x645b004b,0x64850031}},	//   ghei, ello, giui, sóin
  { {0x23380047,0xab380015,0x55e6003c,0xb8e90011}},	//   уппы_, уппу_, _возб, ली_
  { {0x11d80003,0x442d06ce,0x443f06cf,0x75d30012}},	//   دودة_, aje_, aku_, _ويقا
  { {0x442d009b,0x02170009,0x82330012,0x644606d0}},	//   bje_, בחים_, تريا, _olki
  { {0x442d003e,0xdb190052,0xdb0901a0,0x68e301a0}},	//   cje_, _bewä, cceï, àndi
  { {0x95cb0048,0xe7870560,0x29020030,0x7e770012}},	//   кува_, руно, ňka_, لاسئ
  { {0x7ae40108,0x6e9500f5,0xbb3b0009,0x7aef01a0}},	//   duit, сигу, _בעדי, àcte
  { {0x7c970012,0x6c970012,0x0ed30011,0x69c706d1}},	//   لشرا, لشرط, _तिकड, _reje
  { {0xe5170044,0x386900c6,0x34480001,0x69c706d2}},	//   थिति_, _ujar_, ачун_, _seje
  { {0xd6d1000a,0x7ae406d3,0xdb190052,0x228b0033}},	// [a10] _عقد_, guit, _gewä, søke_
  { {0xc2c40003,0xe4e7002d,0xd2b70009,0x3aef0060}},	//   تيكي, _кімн, ילמת_, rüp_
  { {0x442d06d4,0x7c2206d5,0x64410227,0x929d0034}},	//   yje_, _onor, ëlis, zwło
  { {0x3ea900b6,0x7d15000e,0x7ae406d6,0xc86406d7}},	//   _kuat_, _ázsi, buit, отчи
  { {0x44f10020,0x3b640014,0xe7080003,0x7ae4000d}},	//   _sơ_, _дърв, لتون_, cuit
  { {0x9f56000e,0xc332000b,0xcb360009,0x85e80024}},	//   ágát_, _צום_, _הנשק_, идів_
  { {0xd5ae0003,0x3ea9000d,0x442d06d8,0xfdf80009}},	//   رفي_, _luat_, tje_, יצגת_
  { {0x442d0010,0xa2d80037,0x44f10081,0xdb0b0031}},	//   uje_, _मिश्, _vơ_, _megö
  { {0xa3e80044,0xdb0b000e,0x9b450003,0x442d06d9}},	//   _बार_, _legö, صندو, rje_
  { {0x3e7b0061,0x2b4d0002,0x4a4506da,0xa2d80011}},	//   rêts_, rzec_, снов, _मिर्
  { {0x84670098,0x49990015,0x65150012,0x867a0009}},	//   _къде, ытия_, _دوائ, _ערעו
  { {0x3ea906db,0xa3bb0037,0xd0790024,0x66fa0035}},	//   _buat_, _अभि_, исяч_, bākā
  { {0xac740003,0x14740003,0x44d305bd,0x94740003}},	//   _بالش, _بالج, eć_, _بدلا
  { {0x28d80037,0x6d4e0052,0x877a0009,0x7f760009}},	//   _डिलि, tzba, ראשי, מערב_
  { {0x25e90044,0xc212000b,0x3205002a,0x6efd006f}},	//   _जारी_, _זהו_, mely_, _påbö
  { {0xa01b004a,0x320506dc,0xb60306dd,0x7ae406de}},	//   llön, lely_, _hráč, tuit
  { {0x232706df,0x44d30002,0x32110002,0xab2706e0}},	// [a20] боти_, ać_, _bazy_, бота_
  { {0x239b0010,0x1757000b,0x88c60012,0x7ae406e1}},	//   mąjį_, _לספר_, متصل, ruit
  { {0xa3e80037,0xdfda0014,0x7ae406e2,0x21a30048}},	//   _बाल_, гъл_, suit, чихм
  { {0xa9880009,0x2bba0012,0x6446008e,0x6fe90024}},	//   בָנִ, _حادة_, _ulki, ифів_
  { {0x3205002a,0xd00f0003,0xa2a20037,0xd7f9002d}},	//   kely_, عله_, _कंट्, рує_
  { {0x2bd00037,0x6f1b0052,0x91fc001e,0xcf250012}},	//   तःका, _druc, gnāl, ترمي
  { {0xd1320003,0x2a6f000e,0x186a046d,0x320506e3}},	//   _عمر_, égbe_, _бави_, dely_
  { {0x91fc001e,0x66fa001e,0xe8e0001a,0xf06306e4}},	//   anāl, tākā, _chụp_, _експ
  { {0x64400028,0x6611004a,0x6bd30012,0xffb70012}},	//   rkmi, ökkä, ستير, _طُلب_
  { {0x64400005,0xd6cf0003,0xd8f8002d,0x44d30002}},	//   skmi, _أقل_, аної_, yć_
  { {0x5d86000a,0x28f8002d,0x201200b6,0x2db70009}},	//   _الال, шень_, _bayi_, _הלבן_
  { {0x3ea10051,0x0eeb0024,0x1799003c,0x9f9902e3}},	//   _siht_, льги_, ивны_, ивну_
  { {0x21270020,0x1dac0037,0x9b960012,0xab960012}},	//   ̣nh_, _चलात, _الشت, _الشغ
  { {0xef11000b,0x6d140011,0xb3850012,0x25fb0011}},	//   וּל_, डिंग_, _بجمه, ल्पी_
  { {0x725b000b,0xf65f0058,0x32110002,0x7bcd0028}},	//   _תכופ, dsæt_, _razy_, taau
  { {0x0ca80662,0xc3340009,0x94a806e5,0x44d30034}},	//   стри_, ֗וּ_, стра_, rć_
  { {0x6a350046,0xc3340009,0x8c1b0009,0x60080009}},	// [a30] онађ, חוּ_, נומי, _הִתְ
  { {0x91f5001a,0xdd210010,0xa3e50011,0x69ca01e3}},	//   hín, _rįžt, _नाक_, _jefe
  { {0x82340003,0xcdf60009,0xa3e80011,0x30150560}},	//   أرقا, _ומתי_, बला_, ждер
  { {0xac1906e6,0x06ed0037,0xb9010037,0x753a0052}},	//   _тому_, _जमाव_, _दि_, ätze
  { {0xf5ab000b,0xb066004a,0xcff80009,0x69ca0227}},	//   ְבֵּ, ltää, מצאה_, _oefe
  { {0xf770000a,0x66150002,0x6f1b06e7,0x3e6b003c}},	//   ران_, ndzk, _vruc, ышен_
  { {0xb0660006,0x32050036,0xc212000b,0x91fc001e}},	//   ntää, vely_, _קהל_, rnāl
  { {0x69d806e8,0x4c920001,0x6f1b06e9,0xb066008e}},	//   _adve, мијс, _truc, itää
  { {0x6f1b0002,0x52a60015,0x69ca06ea,0xe7330003}},	//   _uruc, овым_, _befe, _عصر_
  { {0xe4e7002d,0x4f880009,0x239b0073,0xe8f906eb}},	//   _гідн, _הָעֲ, vąjį_, ало_
  { {0x386d012e,0x24610010,0x32050444,0x53fb0003}},	//   _kjer_, nėms_, rely_, _مرشح_
  { {0xc85a002d,0xdb1d004a,0x60dc06ec,0x76430623}},	//   ршої_, _kesä, árma, lkny
  { {0x7bcb001e,0xc7f60009,0x02450012,0x2d8506ed}},	//   _iegu, חזרת_, _وَصَ, ülen_
  { {0x64a60294,0x8afa0009,0x8f9a0009,0xceb20009}},	//   жава, _כהני, יירי, ויך_
  { {0xf3f9007d,0x26090037,0x7bcb00b6,0x6da30294}},	//   enţi_, ाज़ी_, _kegu, дира
  { {0xc486002d,0x628506ee,0xf9920009,0xac860024}},	//   ілак, elho, _קרה_, ігал
  { {0xe7ff0037,0xf65f0058,0x49ca0001,0x764b0010}},	// [a40] ोजना_, tsæt_, илан_, _įgyv
  { {0x5e570003,0x7bcb06ef,0xceb90030,0x69c10032}},	//   _وليس_, _legu, íře_, nble
  { {0xf65f0058,0xf3f9004b,0xad590048,0xe7aa05c8}},	//   rsæt_, anţi_, _грях_, авел_
  { {0x6edb0037,0x225e009b,0x644d01da,0xfe7f01a0}},	//   _निशु, zitk_, chai, nuïn_
  { {0x63b40002,0xb1e60012,0x57fb0009,0x6fcc0011}},	//   ągną, _وأسه, שלנו, ारबं
  { {0x7bcb0051,0x386d0058,0xc4da0001,0x6b8b000e}},	//   _aegu, _ejer_, ађи_, ügge
  { {0xe0d70014,0x344a01d4,0x69dc0034,0xdb070097}},	//   _мвр_, ичин_, órem, élög
  { {0x9cd7000b,0x69ca003a,0x6444004a,0x78a40051}},	//   קופה_, _sefe, nkii, _niiv
  { {0xe3af0003,0x16660014,0x93b7000b,0xcb070003}},	//   خرى_, _двам, חלפו_, قيين_
  { {0x7af6007a,0xa9540046,0xb066004a,0x291c013a}},	//   ityt, звољ, ytää, _prva_
  { {0x6444004a,0xf21f0037,0x7bcb0097,0x69ca0097}},	//   kkii, बाज़_, _fegu, _vefe
  { {0x69ba0037,0xcce50003,0x6aa306f0,0x7bcb0010}},	//   _श्री, _رسمي, _einf, _gegu
  { {0x64b1001e,0xb09b0009,0x889b0009,0x24610073}},	//   _jāin, ייטר, יבטי, zėms_
  { {0x3f850039,0xb066004a,0x69d80040,0x29180248}},	//   ālu_, ttää, _udve, åras_
  { {0x34950046,0x91bb000b,0xa9670001,0x660706f1}},	//   завр, _דמוי, _миља_, rejk
  { {0x1bbb0003,0xa8340012,0x2bbb0012,0x24610073}},	//   شارع_, _يعيش, شارة_, vėms_
  { {0x644d004a,0xe8df001a,0xb066004a,0xdce7003a}},	// [a50] rhai, _thừa_, stää, ğlıd
  { {0x7c26012e,0x539b000b,0x65950294,0x644d01a4}},	//   _enkr, שימו, _напу, shai
  { {0x68e800b6,0x3a380070,0x7af60010,0xc5f20009}},	//   nudd, _dorp_, atyt, _אדי_
  { {0xa6c90003,0x7d7a0009,0x38580024,0x80a80024}},	//   موصل_, _לנתו, орію_, івів_
  { {0x9bb60009,0x54540048,0xd247003c,0x7680008e}},	//   _מהרה_, _цвят, _дэви, pöyt
  { {0xd1260003,0x68e80033,0x24610010,0xbb3a000b}},	//   _كم_, kudd, pėms_, _העשי
  { {0x6aa300b8,0x91fc0035,0x443906f2,0xc5080012}},	//   _rinf, anāk, _kos_, قتيل_
  { {0x443906f3,0xfbd10012,0x44f30018,0xdfd10012}},	//   _jos_, رتب_, rã_, _سيئ_
  { {0xcf27000a,0x9f4f0164,0xec460048,0x78a4005e}},	//   _برأي, regó_, язъл_, _riiv
  { {0x443906f4,0x4426012e,0x7e550003,0x68e800b6}},	//   _los_, _eno_, _عناص, fudd
  { {0x7bcb06f5,0x69c106f6,0x7e7c06f7,0xfe7f01a0}},	//   _tegu, rble, vorp, tuïn_
  { {0x44d7007d,0xe8df0020,0xa06a0001,0xb4fa000b}},	//   mă_, _chứa_, сама_, _לפעי
  { {0x44d7007d,0x644b06f8,0x7d1e02f3,0x78a401a3}},	//   lă_, _ilgi, _srps, _viiv
  { {0x44390149,0x629d0013,0x2fcd06f9,0x539a0009}},	//   _aos_, ůsob, _leeg_, _פיסו
  { {0x44d7007d,0x7ae90006,0x78a4019a,0x88c40012}},	//   nă_, luet, _tiiv, _قتيل
  { {0x44260164,0x443906fa,0x7c950024,0x5baa05c8}},	//   ño_, _cos_, друц, скам_
  { {0x78bb0027,0x443906fb,0x9aa60012,0x29030031}},	// [a60] _čuva, _dos_, سماو, _apja_
  { {0x3af40248,0xd196004c,0x69960048,0x9196004c}},	//   räp_, пшењ, прех, пјеш
  { {0xc006007c,0x18a60015,0xe63b000b,0x44d7000d}},	//   зпек, чаем, _התיכ, jă_
  { {0x44d7000d,0xa3ea0037,0xafdb0623,0xa4b70009}},	//   dă_, _टाइप_, lhør, _מלטה_
  { {0x8c1b0009,0xc7d70009,0xdfcf0012,0x91fc0035}},	//   _הוכי, פוסי_, ايه_, unāk
  { {0xb1460001,0x7bc40010,0x76a9002d,0xceb30009}},	//   _енгл, lbiu, ітів_, עיו_
  { {0x44d7000d,0x69dc06fc,0x4439016d,0xf8e005f3}},	//   gă_, _idre, _yos_, _पटिय
  { {0xb6030333,0xad1b000b,0xbab806fd,0x68e306fe}},	//   ēšan, מוצר, огих_, ánde
  { {0x69ce00c6,0xdee305f7,0x7ae406ff,0x22860700}},	//   _kebe, _поти, nrit, зунг
  { {0x64aa0013,0x44d7000d,0x78ad0027,0xb6bb000b}},	//   _přid, bă_, _čavr, _לצמי
  { {0x44d7007d,0x6e2800c5,0x7ae4008b,0x55bb000b}},	//   că_, _indb, hrit, _המבו
  { {0x69ce008b,0x44260701,0xa2dd0011,0x68e80702}},	//   _lebe, _uno_, _पिल्, rudd
  { {0x69dc001c,0xa857000b,0x8c1b000b,0x96f80048}},	//   _odre, ליטה_, _לואי, пеят_
  { {0x76890065,0x6595002d,0x539b000b,0xdb9b000b}},	//   mþyk, дагу, _הידו, _הסדר
  { {0x7ae40703,0x51fb000b,0x01fb000b,0xd217000b}},	//   erit, _ההוצ, _הפול, _זקוק_
  { {0x3cf60011,0x7ae40704,0x83fd0031,0x69dc0705}},	//   ँढ़ें_, frit, gnőh, _adre
  { {0x44d701b3,0x69ce00c6,0x44390706,0xe3b00003}},	// [a70] ză_, _bebe, _vos_, ارف_
  { {0xe603004a,0x52d8003c,0x69ce0707,0xc87f0032}},	//   ätää, ямую_, _cebe, loß_
  { {0x44390708,0x15fa0009,0x45fa0009,0x629a0073}},	//   _tos_, _והתע, _והתג, imto
  { {0xf990000a,0x44d7000d,0x9cd6000b,0xaadd0037}},	//   ابك_, vă_, _קורה_, _मिलक
  { {0x3ea50051,0x200b0002,0x8c1a0009,0x765e008e}},	//   _pilt_, ieci_, _וורי, _ympy
  { {0x44d701b3,0xcb12000b,0x69ce0358,0xff180009}},	//   tă_, _שלם_, _gebe, פקות_
  { {0x3ea50065,0x7c390002,0xc879003a,0xdb1d0029}},	//   _vilt_, _powr, luğu_, _nesú
  { {0x3ea500bd,0x44d7007d,0x44390028,0x200b0027}},	//   _wilt_, ră_, ðs_, jeci_
  { {0xd5b1008a,0x44d7007d,0x04560003,0xadf50014}},	//   _các_, să_, بلية_, _опаш
  { {0x8f680003,0x44d7000d,0x2d850002,0x39450069}},	//   _عملك_, pă_, _tyle_, дног
  { {0x7ae40026,0x24890709,0xd00a0048,0xb22b0024}},	//   zrit, klam_, оене_, раiн
  { {0x7ae4004a,0x7bcf000d,0xe3b30003,0xd05a0024}},	//   yrit, _necu, _أرض_, ірні_
  { {0xba550014,0xfa350012,0x44f70060,0x63050012}},	//   _откъ, _يرتد, eç_, _آوتل
  { {0xc87900a2,0xf2d20093,0x91fc001e,0x01650001}},	//   duğu_, _יעד_, riāc, _окло
  { {0x7ae4070a,0x91ba0009,0xd12e0012,0x6d43070b}},	//   writ, _ומצי, _نمو_, nyna
  { {0x78b30333,0x69ce070c,0x7bcf000d,0x69c5000e}},	//   ēgvā, _sebe, _cecu, ebhe
  { {0xd5b10020,0xf093000b,0x7bcf070d,0x7bc4070e}},	// [a80] _xác_, _בנה_, _decu, rbiu
  { {0xff5f0108,0x6aa70070,0xe8df001a,0x24890160}},	//   raît_, _cijf, _chữa_, alam_
  { {0xa90a0003,0x7e63004a,0xfbc6070f,0x50ba0012}},	//   تيال_, dinp, _обно, زداد_
  { {0xc879003a,0xa3c30011,0xad1b0009,0x7d1c0097}},	//   buğu_, ्रफ_, _ווטר, _ársi
  { {0x3946001e,0x69ce0710,0xc8790060,0xa09b0009}},	//   ņos_, _tebe, cuğu_, קינט
  { {0xd5b1001a,0x64670002,0x7e630698,0xdcba022a}},	//   _rác_, ąpił, ginp, ощи_
  { {0xaaa70011,0x69350030,0xc6930009,0xe4d30012}},	//   _कूटक, _přeš, דאג_, نتيب
  { {0x64aa0066,0xd7060001,0xdb1d01e3,0x515b0009}},	//   _přib, _озби, _resú, _וכלו
  { {0x41e6002d,0xb9e6002d,0x6d43003a,0x27f70711}},	//   міна, міни, ayna, _تفقد_
  { {0xd626000a,0xd2500003,0x51f8002d,0x2fc6002c}},	//   _تعري, اند_, чною_, lbog_
  { {0xa01b004a,0xbfa3001a,0x45460003,0x248903ef}},	//   llöi, hiề, _تناق, ylam_
  { {0xc32a000a,0xd5b10020,0xb9060011,0x7b6605c8}},	//   _وكان_, _tác_, _पि_, _отле
  { {0xd78b000a,0x20190005,0x200b0712,0x44da0004}},	//   تخدم_, rdsi_, reci_, eď_
  { {0x3eb90164,0x200b0604,0x1cbb0012,0x44cc0034}},	//   _éste_, seci_, قارب_, oś_
  { {0x320c0087,0x7588003c,0xb8860030,0x1df8003c}},	//   medy_, дств_, _smíš, ьеры_
  { {0x28d80011,0xc2c50012,0xc1730009,0x320c0030}},	//   _डिजि, فيري, _שחק_, ledy_
  { {0x6d430002,0x7b670001,0xa3b30011,0x64930060}},	// [a90] zyna, фтве, जुट_, eçic
  { {0x248900b6,0x22f70009,0x66bc0009,0x82150012}},	//   slam_, וזמן_, _ומזה, عواص
  { {0xa3c30044,0x248900a2,0x6aa70070,0xc6780012}},	//   ्रम_, plam_, _vijf, _تحيط_
  { {0xf8b10009,0x26d90713,0x5ed5042a,0x61fe0227}},	//   אשׁ_, osso_, ежду, afpl
  { {0xdb020020,0x320c0029,0xb3ba0009,0x6c560009}},	//   _ngoà, kedy_, _ממרכ, _נישא_
  { {0xee38002d,0x645a001e,0x245100d9,0x88c70012}},	//   мні_, ītie, _máme_, _يتأل
  { {0x645a001e,0x7aed0714,0x61ea0097,0x7e630715}},	//   ūtie, luat, ófle, rinp
  { {0xdb1d024c,0xa1940015,0xf4120009,0x6d430716}},	//   _besø, _расч, ָ֤ה_, ryna
  { {0x2ef40014,0x64aa0066,0x1306003c,0x99f50024}},	//   _изтр, _přic, еный_, няні
  { {0xcb12000b,0x291e0010,0x05b80012,0x320c0132}},	//   נלי_, _štai_, _قدمت_, gedy_
  { {0xa3c10011,0xf1b20011,0xb8990009,0xa5f80024}},	//   ुरा_, _जलसन, ּבָש, _цеху_
  { {0x7aed00b6,0xc6890009,0xad1a0009,0x9d1a0009}},	//   kuat, _הא_, _מוער, _מועט
  { {0x64490052,0x64aa0066,0x201e0066,0x7f190024}},	//   mkei, _třic, ěti_, міру_
  { {0x443d0036,0x8b3a000b,0xbb3a000b,0x24800002}},	//   _how_, _מתנצ, _מעני, woim_
  { {0xf2020037,0x6449004a,0xe8f50012,0x52380012}},	//   र्फ़_, okei, _أستخ, _تسنح_
  { {0x301a0012,0x6da3004c,0x78a90717,0xd0190034}},	//   _رتبة_, уиса, _niev, _nań_
  { {0x3b070098,0x2c010037,0x6449004a,0x7aed0718}},	// [aa0] нето_, व्यू_, ikei, guat
  { {0x9b93000a,0xb77b0093,0x877b000b,0x98d30037}},	//   الكت, _מאפש, _מאפי, _दबाए
  { {0x64490006,0x7afb0051,0xef18001e,0x321803d9}},	//   kkei, htut, āļu_, _vary_
  { {0x443d0036,0x672400bd,0xdfcf0003,0x7aed00b6}},	//   _now_, _krij, ميم_, buat
  { {0xc7d7000b,0x0c230014,0x91fc0035,0x78a90719}},	//   תוני_, _смян, onāt, _diev
  { {0x25fb0037,0x2fc60058,0x2907071a,0xdb02001a}},	//   ल्ली_, sbog_, _opna_, _ngoá
  { {0xa3e40044,0xb8660012,0xc8660012,0xf5170012}},	//   _नया_, _كارو, _كطري, فتيش_
  { {0x6449008b,0xd6d20003,0x85030012,0x6724071b}},	//   gkei, _مقر_, اوين, _orij
  { {0xa3b70003,0x88bc0066,0xdb190052,0x7afb002c}},	//   راير_, zvěd, _gewü, gtut
  { {0x6449007a,0x24510064,0x629e020d,0xdb070025}},	//   akei, _ráme_, nmpo, élég
  { {0x753a0052,0xc5f30009,0x75d30012,0xbd290012}},	//   ätzl, _תדע_, _إيما, _يأمل_
  { {0xa3c30037,0xc173000b,0xbb860012,0x3866071c}},	//   ्रण_, טחת_, _كلاي, nior_
  { {0xc43b0093,0xe29a0014,0x4c3b0009,0x2d8c06ed}},	//   _מתאי, _еад_, _מתאב, üden_
  { {0x27e000a2,0x661a0006,0x23690012,0x6724071d}},	//   _edin_, _jatk, _تحمي_, _drij
  { {0xdcb10020,0x25a5006f,0xdcfa001e,0x7c3d0470}},	//   ể_, äll_, _iztē, _posr
  { {0x68e70029,0xdddc0030,0x661a071e,0x6d58071f}},	//   ájde, borů, _latk, izva
  { {0x88bc0066,0xeab30012,0xde790048,0x2458003c}},	// [ab0] svěd, اعر_, _обич_, хать_
  { {0x83fd000e,0xda7800b3,0xd9f00011,0x78a90720}},	//   lnőt, нях_, चलित_, _siev
  { {0x78a90039,0xa2dd0037,0xd5b1001a,0x7aed00b6}},	//   _piev, _पिक्, _bán_, suat
  { {0xe536000b,0xe8d7000b,0xd3710012,0x33950012}},	//   _סטרט_, תואר_, _نهج_, _للجز
  { {0xdb07004a,0xd5b1001a,0xab5b0070,0x42990003}},	//   ämäs, _dán_, _geüp, _ينجح_
  { {0x8e850721,0xceb40009,0x60da0722,0xa0c50012}},	//   خلته, איס_, kstm, _ليسو
  { {0x92a60002,0x93c6000d,0xd6180003,0xa3d50037}},	//   _dołą, sfăş, عتها_, _सजा_
  { {0xcf7b0003,0x7afb00c1,0x62810002,0xd5b1001a}},	//   _فإذا_, ttut, wolo, _gán_
  { {0xf7730003,0x64490723,0xa3b90011,0x8c1c0009}},	//   _صار_, rkei, _चलन_, לוהי
  { {0x6449065a,0x4a450083,0x200f0724,0x6aaa0040}},	//   skei, тнов, legi_, _ciff
  { {0xf1b2000b,0x7afb0725,0x6aaa0726,0x6724001b}},	//   יסי_, stut, _diff, _srij
  { {0xa3d20044,0xf7670003,0x200400f1,0x91fc001e}},	//   वरण_, لا_, ými_, liāl
  { {0x60c4009b,0xb7da0009,0xe7370048,0x249f0097}},	//   _čime, וקרי, вея_, mmum_
  { {0x63bd00c5,0x9f61000f,0x67240727,0x3f8c001e}},	//   _afsn, ását_, _vrij, ādu_
  { {0x7ae9038e,0x7bd6002c,0xc5f20009,0x9c860012}},	//   lret, tayu, ידם_, نشره
  { {0xc9520093,0x15ee0037,0x3f89001e,0x3ce5000e}},	//   _כמו_, _जाकर_, ļauj_, álva_
  { {0xfbd2000b,0x248d0066,0x7af6004a,0xcb670146}},	// [ac0] יתן_, ilem_, _äytt, вате_
  { {0xd6aa0003,0xae9a0012,0x6fa70011,0x3cea0011}},	//   _تدعم_, _تضبط_, _गणतं, _छिपे_
  { {0x69ce0065,0xfe37000b,0xe5720003,0xa3c30037}},	//   ðbei, _סרטי_, _خطة_, ्रा_
  { {0xd5b10020,0x14d7000b,0x60dc000e,0xb90a0037}},	//   _báo_, _בוטל_, ármi, _मि_
  { {0xd5b1008a,0x69ca0065,0x92a6003e,0x2ca00051}},	//   _cáo_, ðfes, _połą, mmid_
  { {0xe7370001,0x975b0009,0x2ca0005e,0x7bc90227}},	//   тељ_, ודנט, lmid_, ebeu
  { {0x3866006f,0x8d63004c,0x621b0009,0x6fb60012}},	//   pior_, ивље, _קולק, _لمزا
  { {0x6aaa0728,0x248d0729,0x7467003c,0x2918016d}},	//   _siff, glem_, крыв_, _isra_
  { {0x6d47003e,0xa0670001,0x2d810052,0xdb0d0017}},	//   zyja, _рата_, üher_, rcaç
  { {0x91fc0039,0x3eb902d1,0x5ea60003,0xdb1b0028}},	//   ciāl, _ésta_, _شمال, rauð
  { {0x6722072a,0x3eab0064,0xdb1b0097,0xd6570009}},	//   lvoj, žitú_, sauð, _שיבת_
  { {0xdb0402d1,0x01370009,0x4bda0012,0x64930060}},	//   nció, דרטת_, _آباد_, eçin
  { {0x73360003,0xf09f0054,0xb3e90012,0xa2d30012}},	//   _جرائ, rmà_, _أعمل_, _نينت
  { {0x2ca00051,0x52d7000b,0x25bf0011,0xcf930009}},	//   emid_, _יודע_, ्रेण, שטש_
  { {0x984f0002,0xc7c70001,0xdb04000e,0x2a790031}},	//   jęć_, _испи, kció, ésbe_
  { {0x31cb0037,0x3eac0058,0x5c740048,0x2c7a0035}},	//   िर्ध, _lidt_, алст, bīde_
  { {0x6e450003,0xb275072b,0x2d8c0040,0x0bb40024}},	// [ad0] _منظم, глаш, _lyde_, рбую
  { {0x2ca00005,0x7aef0054,0x68e30649,0xa6e30028}},	//   amid_, àcti, ándo, íðus
  { {0xb8b40003,0x7ae9072c,0xa3d20011,0xc7b10012}},	//   لإنت, zret, वरा_, مّا_
  { {0x69ca0028,0x25ff0011,0xae000011,0x7ce80009}},	//   ðfer, श्री_, ल्सन_, _בַשֶ
  { {0x64aa0066,0xa01b004a,0x9f050012,0x98a70073}},	//   _přin, llös, اوتو, šnį_
  { {0xe29a008a,0x644d0006,0xdb0402d1,0xf3f9007d}},	//   _như_, lkai, ació, miţi_
  { {0x91fc0039,0xf3f9000d,0x58d40021,0x644d004a}},	//   riāl, liţi_, _вост, okai
  { {0xdb0402d1,0xc1720093,0xd9bd0037,0x8d740012}},	//   cció, _החל_, ोर्ट, جاها
  { {0x69d5000f,0xac960003,0xf3f9000d,0x644d0606}},	//   _keze, دنيا_, niţi_, ikai
  { {0xa3c30037,0x248d072d,0x25ed0011,0xfdbf0011}},	//   ्रह_, slem_, _घाटी_, ्रोफ
  { {0x644d004a,0x69d5072e,0x2ba40011,0x10a6038f}},	//   kkai, _meze, खेबा, лион
  { {0xf992000b,0x69d50070,0x7ae9072f,0x76410730}},	//   מרי_, _leze, pret, _holy
  { {0xe28e0731,0xa2e50109,0xfc160009,0x64930060}},	//   _га_, _солд, _תקני_, tçin
  { {0xa01b0052,0x75d60003,0xd5b20003,0x7c2f0025}},	//   flös, طيرا, صفر_, _ancr
  { {0x2919001e,0x2d8c0058,0xdb0b0058,0x1d070313}},	//   āsas_, æde_, _afgø, лери_
  { {0xfe7f03eb,0x644d002c,0x2ca0005e,0x63b80030}},	//   duïu_, gkai, umid_, ěvno
  { {0x69d50732,0x2ca00051,0x28d70011,0x33d50024}},	// [ae0] _beze, rmid_, _भौति, ріст
  { {0x7e1d0037,0xe8050037,0x62330001,0xa75b0009}},	//   पयोग_, ष्ठा_, беђу, _נדיר
  { {0x2d85000e,0xbd460012,0xd5b10081,0x00e6016e}},	//   ület_, _إنجي, _cám_, ужен
  { {0x984f0002,0xf3f9004b,0x7d160034,0x97c50012}},	//   ręć_, biţi_, łysk, لتهم
  { {0x442000a2,0x9f34002d,0xb7db000b,0xbe8a0001}},	//   mdi_, релі, תקני, нске_
  { {0x442f0733,0xdd25001e,0x9f970009,0xb9c50012}},	//   _ang_, līša, נדסה_, _نتفه
  { {0x20d1012e,0xdb040734,0xdcfe001e,0x41180009}},	//   jši_, pció, _izpē, _בֵּא
  { {0xdd25001e,0x661e0735,0x44200736,0x3ed60012}},	//   nīša, _lapk, ndi_, _مقرر
  { {0x15f60003,0x78ad00c1,0x7641000e,0xcfb70009}},	//   _مساح, _riav, _foly, _תלמי_
  { {0x8f990014,0x6493003a,0xcb130009,0xda140011}},	//   _ръст_, eçil, צלת_, ड़ित_
  { {0x2d8c003e,0xdfd10003,0x3a37000b,0xd48f00ac}},	//   żdej_, ييد_, ארים_, _гр_
  { {0x4d7b000b,0x228f0051,0x44200737,0xd0e50011}},	//   _ארבע, tükk_, jdi_, _किरण_
  { {0xead40047,0xe29a0020,0xdd250039,0xa2b00037}},	//   _толь, _thư_, dīša, _अंग्
  { {0x442001a2,0x98bc0066,0x33930012,0xf3f9004b}},	//   edi_, ávě_, _الهز, viţi_
  { {0xa4d5007c,0xa9bb0093,0x644d0006,0xfe7f03eb}},	//   робі, _אזור, tkai, duït_
  { {0xf3f9007d,0x859b000b,0x78a20027,0x644d004a}},	//   tiţi_, תשלו, jmov, ukai
  { {0x644d0738,0x4c940015,0xa01b031d,0x90980012}},	// [af0] rkai, ситс, slös, _حضور_
  { {0xf3f9007d,0x644d0739,0x4b7b000b,0x51f80015}},	//   riţi_, skai, תאמו, лную_
  { {0x2127008a,0xf3f9007d,0x9851003e,0xc27b000b}},	//   ính_, siţi_, nąć_, ערבי
  { {0x64420070,0xa3d60037,0xf3f9000d,0x69d50070}},	//   _nooi, हरण_, piţi_, _weze
  { {0x7bda007e,0xcee80003,0x2d9c0064,0xfe7f01a0}},	//   _בקרו, هرون_, _úver_, buït_
  { {0xb5c2002d,0x6493003a,0x20d70012,0xc8d70012}},	//   ойшл, içim, _مترج, _مزرع
  { {0xe3b1000a,0xa3b90037,0x2dd80003,0x7a410066}},	//   يرة_, _चला_, ابهة_, _vítě
  { {0x1309007c,0x20d10604,0x1c4500fa,0x629c01e9}},	//   вний_, vši_, рним, _zhro
  { {0x6d4a00a2,0x76410010,0x44230030,0x387c0031}},	//   ayfa, _toly, ěj_, évre_
  { {0x2480001c,0xf41f006f,0x7aed073a,0xc3320009}},	//   čima_, _skäl_, irat, קוי_
  { {0x6493003a,0x27e00028,0x4420003a,0x7aed073b}},	//   tçil, ðing_, ydi_, hrat
  { {0x186a00be,0xa06a0001,0xe53a0009,0xc60e0011}},	//   тами_, тама_, _בתער, ाज्य_
  { {0x6c840003,0x2bc80365,0x91d80011,0x29180097}},	//   _النم, _сухо_, यरमै, ærar_
  { {0x7aed073c,0x69da073d,0x8cb10011,0xf2d00012}},	//   drat, cate, _आंखो, _رآه_
  { {0xdd250039,0xabd60001,0xada6073e,0x7bcd0032}},	//   tīša, ицај, равл, fbau
  { {0x2b090037,0x417a000b,0x629c073f,0x44200740}},	//   _वहाँ_, _שנקב, _shro, udi_
  { {0xfe7f0054,0x2d85004e,0xe3b70177,0x929d0034}},	// [b00] tuït_, üler_, рбу_, atłe
  { {0xdd25001e,0x09e601d4,0x6edb0009,0x7bdb0032}},	//   sīša, рожн, _שחיפ, hauu
  { {0xaa7b0013,0xdb190052,0x6fb60012,0x67290741}},	//   _svýc, _gewö, لمضا, _arej
  { {0xafdb0058,0x64aa0030,0x2bba0012,0x4d7b0009}},	//   lkør, _přim, _جادة_, _יריע
  { {0x629c0742,0x2bd30037,0x60c9009b,0x78a20042}},	//   _thro, तररा, _čeme, rmov
  { {0x67290040,0x9ce6004c,0x9df8020f,0x78a20743}},	//   _drej, ацил, ункт_, smov
  { {0x98a6002d,0x69da0744,0xde570024,0xd5b90024}},	//   _виве, vate, ращі_, усі_
  { {0x9168001a,0x3205002a,0x9418003c,0x44a30012}},	//   _lực_, efly_, ужит_, يموق
  { {0xe457000b,0x69da0745,0xa2b3003c,0xa08b0009}},	//   ייקט_, tate, обыч, _יְמִ
  { {0x166300de,0x228f005e,0x1efb0009,0xd5d80009}},	//   _двум, tüki_, _בלמע, _תַּש
  { {0x91a9008a,0xa3d60037,0xe1660012,0x6f0d0746}},	//   _đã_, हरा_, شددي, _spac
  { {0x69da0747,0x90e70012,0x50670451,0x228f0522}},	//   sate, جَّل_, ртоа, rüki_
  { {0x98be0010,0x69da0748,0xd2520012,0xfe7f01a0}},	//   dytą_, pate, _ونص_, duïr_
  { {0x69d80065,0x9f400052,0x2d84003a,0x9998000e}},	//   ðvel, _weiß_, ğmen_, űrő_
  { {0x929b000b,0x6a9b0009,0xa3bd0011,0x7ea00032}},	//   _שיות, _ששונ, _आलम_, köpf
  { {0x228b0033,0x6f020749,0x31570009,0x91ad0081}},	//   søkt_, ktoc, _כיון_, _đè_
  { {0x7bcd0039,0x64aa0013,0xdb99002d,0x69d8000e}},	// [b10] rbau, _přij, увач_, _keve
  { {0xab840046,0x78b8003a,0x11d90012,0xa2cd0011}},	//   цуск, _kuvv, اواة_, दीग्
  { {0xdfd1000a,0x69d80054,0x7aed074a,0x24550012}},	//   كيا_, _meve, srat, _هندس
  { {0x6729074b,0x5fe70024,0x8c190009,0x7aed074c}},	//   _prej, ріжж, _גוֹי, prat
  { {0xdd280039,0x4fe8002d,0xdefb0015,0xf7700012}},	//   mēša, рмін_, тые_, واه_
  { {0x9e64007c,0xdd280039,0xddc3000d,0xb60700be}},	//   овід, lēša, dinţ, рядк
  { {0xc212000b,0xd658000b,0x7ae2001e,0xd46905c6}},	//   _מהם_, שיות_, _avot, лике_
  { {0x9cd8000b,0xdd28001e,0x55780009,0xeb990695}},	//   בוהה_, nēša, יעון_, лий_
  { {0x6729012e,0x9f44003a,0x69d8074d,0xc5ff0035}},	//   _urej, ümü_, _beve, ļēji_
  { {0x8b58000b,0xe7300003,0xf6530012,0x6288074e}},	//   ייחס_, _تصف_, _بئر_, godo
  { {0x8d95000a,0xf5950003,0x6442004a,0xc7a90009}},	//   _الاش, _الاج, öoik, _נב_
  { {0xa8560046,0x3d01003e,0x6e21074f,0xcd960009}},	//   стој, mów_, _halb, _הדעת_
  { {0x6e21007a,0x8b68007c,0x3d010002,0x443f001e}},	//   _kalb, _київ_, lów_, mju_
  { {0x69d800bd,0x65c3010c,0xddc3004c,0x8f9a0009}},	//   _geve, збра, збри, טירי
  { {0x3d01003e,0x9168001a,0x98be0010,0xdd920012}},	//   nów_, _vực_, tytą_, سور_
  { {0x443f0750,0xab5d0002,0x69d80070,0x78a30070}},	//   nju_, waży, _zeve, ïnvl
  { {0x4e7a0003,0x8c430014,0x7bd900b6,0x04430751}},	// [b20] _محدد_, чете, _mewu, четн
  { {0x3d01003e,0x443f0051,0xd9f90011,0xe9d70173}},	//   ków_, hju_, ्भित_, йку_
  { {0x3d010002,0x02190024,0xcdb70009,0x09060752}},	//   jów_, шіть_, _לפיה_, спен
  { {0x3d01003e,0xdd28001e,0x6ee60003,0xb69b0753}},	//   dów_, cēša, مستل, ntân
  { {0x443f013a,0xdb060097,0x645b0227,0x6d4e0754}},	//   dju_, _afkö, dhui, lyba
  { {0x7c2400a2,0x44220755,0xddc3000d,0x8f9b000b}},	//   ldir, _hak_, vinţ, ניסי
  { {0x6446007a,0x3d010002,0x89db000b,0x7ae20027}},	//   _koki, gów_, _תחלי, _svot
  { {0x44220756,0x62880002,0xa3cb0037,0x64460757}},	//   _jak_, wodo, रुप_, _joki
  { {0x23600758,0x10a30001,0x64460759,0x35fa0012}},	//   nzij_, _хитн, _moki, _مراد_
  { {0xc3330093,0xddc3007d,0x6e96000a,0x3d010002}},	//   פות_, rinţ, _الطا, bów_
  { {0x443f009b,0x3d010002,0x7c24003a,0x6288075a}},	//   bju_, ców_, kdir, rodo
  { {0x6288012e,0x4422075b,0x7648004a,0xb4250003}},	//   sodo, _nak_, ödyn, _وعنو
  { {0xdd28001e,0x69d8075c,0x76450042,0x69de075d}},	//   vēša, _teve, _pohy, kape
  { {0xdce50029,0x7aef01e3,0xa5f9004c,0x44220227}},	//   _vzhľ, ácte, јеву_, _aak_
  { {0x64aa0013,0xe5730003,0xfa97000b,0xdd28001e}},	//   _přih, سطس_, _הדגש_, tēša
  { {0xb69b075e,0xa1770009,0x92b70012,0x60c7075f}},	//   ctân, _לעוד_, محطا, íjme
  { {0xdd280039,0x3d010002,0x32bb0003,0xe2f90024}},	// [b30] rēša, zów_, ادرة_, резі_
  { {0x7b740003,0x443f009b,0xdd28001e,0x7f3c0009}},	//   أطفا, zju_, sēša, _תעזו
  { {0xd1310003,0xf652000b,0x104b0232,0x672d05b1}},	//   بما_, _חצי_, ляди_, _hraj
  { {0x19a804b3,0x442200b6,0x7c220027,0x64bc001b}},	//   ступ_, _gak_, _naor, _očij
  { {0x3d010002,0xcf240012,0x5f770012,0x29d50012}},	//   wów_, كروي, حاضر, _ويحس
  { {0x3d01003e,0xdb1d0163,0xd0d50014,0xd6290760}},	//   tów_, _besö, _могъ, роке_
  { {0x443f0761,0xed590762,0x660a0060,0x2eb50011}},	//   tju_, рой_, _öfke, ंदुत
  { {0x3d01003e,0x94790001,0x9cd80009,0x27e90060}},	//   rów_, јску_, זוהה_, _ndan_
  { {0x3d01003e,0xa5f90046,0xf414000b,0x645b0070}},	//   sów_, _везу_, לפק_, rhui
  { {0xda65007c,0x3d010002,0x7bdf0763,0x645b0227}},	//   івни, pów_, haqu, shui
  { {0xf9910012,0x443f0764,0xf4870048,0xd9450765}},	//   ببة_, pju_, _лудн, цени
  { {0x7aee003a,0x1faa035c,0x78fa0009,0xa7aa0048}},	//   üntü, икни_, ספרו, икна_
  { {0x92b70003,0x09e50014,0xb69b0284,0x501a0009}},	//   _احصا, _долн, rtân, בורו
  { {0x8aa70766,0xdd1c0066,0xb69b0753,0xa3c30011}},	//   _уред, ráže, stân, ्रक_
  { {0x64460767,0x94aa0012,0xb69b004b,0x44220768}},	//   _poki, لطرق_, ptân, _pak_
  { {0x23600070,0xe8d60009,0x69de0227,0xdb1d0769}},	//   tzij_, _ווקר_, wape, _lesõ
  { {0xf4120093,0x44220070,0x64460010,0x7c24076a}},	// [b40] ופן_, _vak_, _voki, rdir
  { {0x2360009b,0xd1960001,0xb69b004b,0x499600b5}},	//   rzij_, ошењ, ntâl, ошет
  { {0x6446007a,0xdd0f003a,0x2f040028,0x6bd60003}},	//   _toki, mışt, lög_, _وتحر
  { {0xdd0f00a2,0xc172000b,0x3947006f,0xd00a076b}},	//   lışt, וחב_, änsa_, реде_
  { {0x245c000f,0xc6f70024,0x187b0009,0xd7f90024}},	//   _címe_, жніх_, סטנב, сує_
  { {0xf4ea0015,0x6481001e,0xe2970063,0x8f9b0009}},	//   афий_, rķie, _мая_, ביני
  { {0x998c0002,0x9103076c,0xf9870012,0x6ce60024}},	//   zedł_, _опре, _آب_, ціле
  { {0xa4b70009,0x87060012,0xdb1d005e,0x7ae4076d}},	//   חלקה_, _وبذل, _eesõ, osit
  { {0x69dc0272,0x29050002,0xdd0f003a,0x6fd00011}},	//   _kere, etla_, kışt, _ड्यू
  { {0x7648004a,0xd8f8002d,0x7bdf0017,0xc50a0012}},	//   ödyl, бної_, zaqu, _نتصل_
  { {0x69dc00ec,0x91bb000b,0x929b0009,0x2247076e}},	//   _mere, ימיי, שיית, _donk_
  { {0xc867002d,0x66180304,0x9ca50012,0xdfd80048}},	//   ітни, levk, _فإنن, жър_
  { {0x20050002,0x94a90012,0xa92706dd,0x7bdf076f}},	//   ęli_, _اطلق_, _poží, vaqu
  { {0x24890029,0x8f9b0009,0x98be0034,0xaa580012}},	//   čame_, ייכי, zytę_, _دلتا_
  { {0x76480002,0xe599002d,0x16d70011,0x60870012}},	//   _mody, скві_, _डब्ब, _وشبك
  { {0xd6db0015,0x415b000b,0x69dc00c1,0xa0680001}},	//   _кто_, _כדוג, _aere, _маја_
  { {0xc334000b,0x7645004a,0xb6060029,0x8c1b000b}},	// [b50] הוּ_, öhyk, _kráľ, סומי
  { {0x69dc0770,0xc7b40009,0xbebd0073,0xeaf80012}},	//   _cere, _קבץ_, _krūv, ترفت_
  { {0xc0150047,0x7d0d0002,0xe2a60028,0x34950001}},	//   змещ, łasz, íðan_, _наор
  { {0x9d1a0093,0x351a000b,0xa98b0009,0x765a0060}},	//   _פורט, _פורנ, בָדִ, _alty
  { {0x27e00065,0xf43a007e,0xce950014,0x69dc0771}},	//   ðina_, _הגרמ, падъ, _fere
  { {0x2ca90051,0x69dc0772,0x290501bd,0x82d60009}},	//   lmad_, _gere, ytla_, _מושג_
  { {0xdfd50047,0x67d50015,0x7bdd00b6,0x20190773}},	//   _новы, _нову, _kesu, kesi_
  { {0x69c5008b,0xc57c0093,0x4d7c000b,0x20190774}},	//   lche, ירות, ירוע, jesi_
  { {0x69dc00a2,0x76d50003,0xfaf10003,0x7bdd0207}},	//   _yere, _رياض, رثة_, _mesu
  { {0xddce001e,0x2ca901b7,0x8f880009,0xba750012}},	//   ribū, hmad_, _וְעֵ, ثابت
  { {0x69c5008b,0xdcef0010,0x2019013d,0x26180011}},	//   iche, _įdėt, fesi_, फ़री_
  { {0x7bdd007a,0xd59a000b,0x859a000b,0x2d84003a}},	//   _nesu, _הבעל, _השעו, şmek_
  { {0x64aa0066,0xd5b8001e,0x69cc0037,0x24510066}},	//   _přiv, žām_, _द्वी, _námi_
  { {0xfe790013,0xe2980024,0x7aba0009,0x35c7004c}},	//   _svůj_, _даі_, _פצצו, згро_
  { {0x61e103fc,0x6da30046,0xceb20093,0x7bdd008b}},	//   mall, еира, תים_, _besu
  { {0x2ca90027,0x69c50775,0xd467004c,0x98a30306}},	//   gmad_, eche, писе_, _пище
  { {0xdd0f003a,0x7bdd0058,0x7bc40776,0x2d9e01bd}},	// [b60] pışt, _desu, rciu, ťte_
  { {0xada60046,0x7bc400c1,0x4223002d,0x63790024}},	//   _напл, sciu, ндув, істр_
  { {0x7648007a,0xda020037,0x5dbb0009,0xfe790030}},	//   _rody, र्गत_, _לזיה, _tvůj_
  { {0xc8650003,0x69dc0777,0xa06a0001,0x7bdd0778}},	//   وطني, _were, љада_, _gesu
  { {0x61e10006,0xddcf0066,0x387f006f,0xdc8b0009}},	//   kall, _řeše, _djur_, _לְךָ
  { {0x69c500c1,0x78bc00b9,0x61e10779,0x8f9b0009}},	//   cche, _turv, jall, זיני
  { {0x20c10020,0x2019003a,0x7c26009b,0x7bdd00b6}},	//   _nói_, yesi_, _kakr, _yesu
  { {0xd007002d,0x321a0002,0x244e015b,0x6d41008e}},	//   _несе_, lepy_, _týmu_, älai
  { {0xaae60003,0xcb070003,0x66180029,0x67200027}},	//   أسبو, كيين_, pevk, _usmj
  { {0x201900b6,0x3f85003a,0x20c10081,0x61e1077a}},	//   wesi_, şluk_, _bói_, gall
  { {0x69c3009b,0x3ec20010,0x92570012,0x929d0034}},	//   žneg, ųstą_, ثشير_, atło
  { {0x853b0009,0x6d3b0009,0x2bb80011,0x653b0009}},	//   _לגבי, _לתבנ, _अलगा, _לעבד
  { {0x2bd20044,0xaa7b0066,0x2019077b,0x61e1077c}},	//   _ध्या, _svým, resi_, ball
  { {0x61e10036,0x7bdd00c6,0x20190218,0xa1580476}},	//   call, _sesu, sesi_, _малу_
  { {0x4426077d,0x4c95077e,0x89eb0009,0x20c10081}},	//   _kao_, дивс, _הַחֵ, _gói_
  { {0x9584003e,0xe97b000b,0x3f9a0002,0x7c2600b6}},	//   _łącz, _לנוש, ępuj_, _cakr
  { {0xa2b5007c,0x76430002,0x2ca902eb,0x69c5077f}},	// [b70] дбач, yjny, rmad_, tche
  { {0x27e00065,0x24510066,0xe3b00003,0x44260780}},	//   ðinn_, _vámi_, طرق_, _lao_
  { {0xa1670001,0xa01b0028,0x69c50781,0x29190012}},	//   чњак, rnöf, rche, تقاد_
  { {0x69c50782,0xd7590003,0x44260783,0x68e70064}},	//   sche, يلات_, _nao_, ájdi
  { {0xba770003,0x8ee8002d,0x79950002,0x44290784}},	//   _فاست, змів_, _wyzw, mda_
  { {0x999e0010,0xef18002d,0x44290785,0x7c260786}},	//   nktų_, ямі_, lda_, _zakr
  { {0x44260020,0xc1050003,0x7de40003,0x61e10787}},	//   _bao_, _توزي, رسوم, vall
  { {0x44260020,0xcac90015,0xbd18002d,0x4518002d}},	//   _cao_, огие_, яції_, яція_
  { {0xe73f0017,0xdb09003a,0x59e10011,0xb6060030}},	//   _çõ_, _önüm, _फ़ार, _sráž
  { {0x4429004a,0x25a00066,0x99d40024,0x1dc60011}},	//   hda_, řila_, нююч, रुआत
  { {0x443900bd,0x44290101,0x64aa0066,0xd5b8001e}},	//   _ons_, kda_, _přit, žāk_
  { {0xc5e90093,0xfb150003,0x81bc0035,0x61e10788}},	//   _כד_, _يواج, ndēj, sall
  { {0x81bc001e,0x61fe006f,0x44290789,0x61e1078a}},	//   idēj, ygpl, dda_, pall
  { {0x3ebf0006,0x4429078b,0x4439078c,0xda0e001a}},	//   _muut_, eda_, _ans_, _hỏng_
  { {0x90460003,0xba280003,0xe969048c,0x7c26078d}},	//   _ينته, _رسوم_, _файл_, _pakr
  { {0x4429078e,0xf9920009,0x27ed078f,0xf4950198}},	//   gda_, _שרה_, _nden_, ерую
  { {0x7afb0006,0xae1d0037,0x3b070048,0xeb970790}},	// [b80] nuut, फ़ान_, мето_, дит_
  { {0x443903eb,0x2480009b,0x44260791,0x39ea0024}},	//   _ens_, čimi_, žo_, ідео_
  { {0xa5d40044,0x27e0008b,0x7c26009b,0x8e570009}},	//   _ब्यौ, _kein_, _takr, _חייג_
  { {0x7c2900bd,0x7afb0006,0xc209000b,0xd7ef0012}},	//   jder, kuut, יה_, لكم_
  { {0x27e00052,0x47360003,0x7afb008e,0xda660012}},	//   _mein_, براز, juut, _قاسي
  { {0x44260020,0x27ed0792,0xdd1d0042,0xa2e3004c}},	//   _sao_, _eden_, lášt, _јорд
  { {0xac940024,0xda0e0081,0x44260793,0x3494076b}},	//   накш, _bỏng_, _pao_, накр
  { {0xe9a30794,0x32c4003a,0x7af60002,0x27e00795}},	//   _расп, _köy_, oryt, _nein_
  { {0x1dcf0796,0x661c0033,0xd7030014,0x84ea0011}},	//   _स्वत, kerk, _изти, _टिकट_
  { {0xdb22003e,0x64aa0066,0xf626002d,0x44290797}},	//   _źród, _přis, _ідео, zda_
  { {0x44260101,0x09f70093,0xeaaf0003,0x55bb0009}},	//   _tao_, ומים_, جعي_, _ומבו
  { {0x286b002d,0xdbd60269,0xf1b30009,0x7afb0798}},	//   ірно_, _jääd, כסת_, buut
  { {0x27e00052,0xfe730012,0xe8200011,0xa2be0011}},	//   _dein_, ندس_, _बसरा_, _वूल्
  { {0x7ea0004a,0x44290002,0x661c0799,0x539b0009}},	//   töpa, wda_, gerk, _וידו
  { {0xa3b10037,0x443900b6,0xceb80002,0x245c0028}},	//   टेन_, _pns_, _mię_, _síma_
  { {0xd5b80625,0x6493003a,0xaa7b015b,0x4429079a}},	//   ься_, eçir, _zvýh, uda_
  { {0xda67000a,0xf094000b,0x5a350014,0x6e3a0070}},	// [b90] وائي, _בנק_, ннат, _ontb
  { {0x64930060,0x6d45079b,0x91e4004c,0x3ebf005e}},	//   tçis, ähak, кође, _ruut_
  { {0x25d6000b,0xeab10009,0x7c29079c,0x3ff50012}},	//   _אותן_, רֹן_, yder, فكار
  { {0x245c0065,0x603e000d,0xc19b000b,0x7af6079d}},	//   _tíma_, _rămâ, חשבי, bryt
  { {0x6d55000e,0x2294006f,0xa3c20037,0x26000011}},	//   lyza, täkt_, ंशन_, _राशी_
  { {0xceb8003e,0x7afb004a,0x603e000d,0xdce80060}},	//   _cię_, vuut, _pămâ, _azdı
  { {0x63a2000f,0xdc3a003a,0x7c29001e,0x98c3001e}},	//   _azon, _açıs, tder, ēvēt_
  { {0x27ed00c5,0x661c000f,0x64a20014,0x2294006f}},	//   _uden_, zerk, лаща, säkt_
  { {0x8ed80003,0x200c000e,0x64aa0066,0x6628004a}},	//   _يذكر_, ődik_, _přir, öskä
  { {0x7afb0006,0x64b10039,0x27e00022,0xfeb80003}},	//   ruut, _jāiz, _sein_, _قالت_
  { {0x2d80007d,0x661c079e,0x7afb0282,0xc2360009}},	//   şier_, verk, suut, גרתו_
  { {0x661c036a,0x88f60009,0x74280012,0x7afb079f}},	//   werk, עזרו_, _يكلف_, puut
  { {0xa8560009,0x83640012,0x61e50097,0xe81f0011}},	//   גירה_, _لدول, kahl, यज़ा_
  { {0x443e000e,0x7ae907a0,0x42550012,0x27e00032}},	//   _őt_, mset, _سنعر, _wein_
  { {0xdd920003,0x409607a1,0xf6520009,0x7ae907a2}},	//   اوز_, _прит, נצל_, lset
  { {0x46ea0098,0xfc3f0020,0x7bc907a3,0xa2d60012}},	//   _един_, _phía_, nceu, فيرت
  { {0xd9f30037,0xa87b000b,0x2cad021b,0xd38700de}},	// [ba0] _आयात_, _מרקח, imed_, ейте_
  { {0x9985000f,0xdbd6004a,0xcfb7000b,0x9f4200d9}},	//   lelő_, _sääd, _אלפי_, jaké_
  { {0x2cad0051,0x50ba0003,0x7ae907a4,0xf77f0018}},	//   kmed_, سداد_, hset, maça_
  { {0xceb80656,0x27e00028,0xe3a70012,0x375a0009}},	//   _się_, úin_, _مر_, ּכַד
  { {0x2cad0005,0xc7d70009,0x248007a5,0x645a0035}},	//   dmed_, גוני_, mnim_, ūtis
  { {0x2480013a,0x2ca607a6,0x8b0b0009,0x38600097}},	//   lnim_, _shod_, _מִלֵ, _llir_
  { {0xcd930001,0x88c50012,0xf6530009,0x63a20031}},	//   лашћ, _لتقل, רצו_, _szon
  { {0x7ea00006,0x25a00066,0x7ae90028,0xccf30009}},	//   köpo, řilo_, fset, אכה_
  { {0x7ae90065,0xf20601b6,0x1e860024,0xd3700012}},	//   gset, няно, _злам, شهد_
  { {0x2cad0132,0x629a06c0,0x4a5407a7,0x7e290012}},	//   amed_, ulto, ткос, _يسلف_
  { {0x386007a8,0x67d5002d,0x88bc0066,0x7ae907a9}},	//   _blir_, кону, jvět, aset
  { {0x61e50052,0xa3b10037,0x248000eb,0x25a10032}},	//   zahl, टेड_, jnim_, ühle_
  { {0x41e10037,0xdc8b000b,0x8cd90011,0x24800353}},	//   _फ़लस, _צְבָ, _फौजो, dnim_
  { {0xbb3b000b,0x6d550002,0xfc3f001a,0x9bb70009}},	//   _מעדי, tyza, _chín_, _נהגה_
  { {0x89330003,0x75880223,0x6ca70048,0x321e07aa}},	//   _معيا, еств_, ераж, mety_
  { {0x299b000b,0xc19b000b,0x6d550002,0x999b000b}},	//   _מסומ, _משוי, ryza, _מבוט
  { {0xdc8b0009,0x30840012,0x61e50032,0xcf270012}},	// [bb0] לְמָ, _حليف, tahl, _أربي
  { {0x7afd0054,0x3f7c0009,0x2cad0159,0x67220034}},	//   àsti, _מאחס, zmed_, dwoj
  { {0xdfd1000a,0xa3c20037,0x61e502dc,0x248000eb}},	//   ليا_, ्डा_, rahl, bnim_
  { {0x9cd6000b,0x80a70011,0x24800412,0x8f750024}},	//   _שורה_, _टीमे, cnim_, кулі
  { {0xe758002d,0xd9ad0037,0x442b0029,0x4f58002d}},	//   ниці_, _घण्ट, _iac_, ницю_
  { {0x7c2d0065,0x0376000b,0x644f0029,0x9985000e}},	//   ldar, _יתרת_, _hoci, zelő_
  { {0x64aa0013,0xfc31000a,0x2cad0051,0xbe980003}},	//   _přip, لحة_, tmed_, رضها_
  { {0x24890470,0x63a20002,0xd9e10011,0x7ae907ab}},	//   čamo_, żone, _फ़ुट, tset
  { {0x13060015,0xa6ab0003,0x321e07ac,0x1c42003c}},	//   вный_, _فائق_, fety_, рным
  { {0x2480013a,0x442b07ad,0xcb120009,0xa77407ae}},	//   znim_, _lac_, סלי_, _случ
  { {0x320b0002,0x99850031,0x3eba020d,0x7bc30030}},	//   ęcy_, telő_, _ript_, ěnuj
  { {0x7c2d0039,0x7ae907af,0x070a0012,0xc6890009}},	//   jdar, pset, ويجي_, _וא_
  { {0x2480013a,0x442d07b0,0x8c280009,0x7c2d07b1}},	//   vnim_, mde_, _רֵעֵ, ddar
  { {0x7c2b0065,0xf1b10037,0x23690002,0x645b004a}},	//   _hagr, जधान, dzaj_, lkui
  { {0x67220002,0x0c96003c,0x442d07b2,0x7c2d0227}},	//   zwoj, вшая, ode_, fdar
  { {0x644f0164,0xc48305fb,0x644907b3,0xccf20009}},	//   _coci, алск, njei, יכל_
  { {0xc053000b,0x88bc0066,0x2480013a,0xe9d20012}},	// [bc0] _כזה_, svět, rnim_, لغا_
  { {0x442d0006,0x0f57000b,0x6449019a,0xda79002d}},	//   hde_, _סיים_, hjei, няє_
  { {0x27e60101,0x442b000d,0x248000eb,0x7c2d07b4}},	//   taon_, _fac_, pnim_, bdar
  { {0x7e610005,0xd0100003,0x78a907b5,0x30a50024}},	//   _allp, صلت_, _chev, грів
  { {0x442007b6,0xf11e0037,0xbe8a0001,0x23690002}},	//   mei_, _बन्द_, мске_, czaj_
  { {0xdce1003a,0x97570009,0xd627004c,0xa3b90011}},	//   _aylı, כינו_, воље_, _ग़लत_
  { {0x442d0070,0xc5f3000b,0x60c30032,0xc0e60024}},	//   fde_, בדו_, _nunm, _шовк
  { {0x91bf0020,0xd6d20003,0x442d07b7,0x64810035}},	//   _đủ_, _نقر_, gde_, eķij
  { {0x68e10058,0xaf06002d,0x84630048,0x442007b8}},	//   _ældr, _шпал, ръще, iei_
  { {0x38660149,0xdb11000e,0x2c7a0035,0xe61707b9}},	//   lhor_, ágán, vīdu_, _иду_
  { {0xdd1f0029,0xa257000b,0xa5d80037,0x01fb0009}},	//   píšt, דביק_, _न्यौ, ופיל
  { {0xf9930093,0x38660017,0x68e307ba,0x442007bb}},	//   ירת_, nhor_, ândi, jei_
  { {0x6d5803ec,0x2d9e07bc,0x24580031,0x69ce0097}},	//   lyva, üten_, _némi_, _ofbe
  { {0xdce504b4,0xd357000b,0x42560001,0xc7b30009}},	//   _vyhľ, _בידי_, _штет, יבר_
  { {0xc1e00037,0x25a5006f,0xac19028d,0x5db40012}},	//   _पड़ेग, åll_, нову_, لإفر
  { {0x69ce00bd,0xdd25001e,0x442007bd,0x6abc0132}},	//   _afbe, gūša, gei_, _airf
  { {0xfaf30003,0x6d580073,0x52150367,0x644f07be}},	// [bd0] ؤثر_, hyva, лдат, _voci
  { {0x442d00a2,0xa2c30037,0xf09f0054,0x91f40012}},	//   zde_, रदत्, llà_, لأما
  { {0x21270020,0x442007bf,0x50f50001,0xf6520009}},	//   ình_, bei_, узет, _הצי_
  { {0x32070002,0x442007c0,0x61e807c1,0x3cf80011}},	//   żny_, cei_, hadl, ैंने_
  { {0xd9e30037,0xdbd10051,0xe7080003,0xe72e004d}},	//   _ग़लत_, _müüd, نتون_, ще_
  { {0x442d0070,0x6a600028,0x99d40012,0xa0c50012}},	//   wde_, _höfn, _نتفا, _ميسو
  { {0x7c2b007a,0xceb40009,0x64490031,0x9f4001a0}},	//   _pagr, ביס_, tjei, _veié_
  { {0x2901002c,0x6c350003,0xdbd10051,0x6a600097}},	//   muha_, افظا, _nüüd, _jöfn
  { {0x3e660061,0x60c3003a,0x78660164,0x644900e6}},	//   _hôte_, _sunm, _jóve, rjei
  { {0xd9e10037,0x442d060e,0x78660017,0xb7bd000d}},	//   _फ़ोट, sde_, _móve, _naţi
  { {0x61e300c5,0x41b5003c,0x628107c2,0xc1050012}},	//   _venl, ысит, rnlo, دوجي
  { {0x44e1039c,0xf7670003,0x5b250003,0xe43c0066}},	//   mų_, ما_, _مفصل, _příč
  { {0xa3c20037,0x44e10010,0xf092000b,0x78660097}},	//   ्डर_, lų_, מנט_, _nóve
  { {0x29010101,0x3f9e0039,0x249f07c3,0x44200052}},	//   kuha_, ātu_, llum_, wei_
  { {0x44e1007a,0xd7ce0037,0xe8f50012,0x05550024}},	//   nų_, हुँच, _إستخ, аття
  { {0xa3e60037,0xb9560009,0x8c960024,0x786601e3}},	//   _बड़ा_, _תיקח_, ургі, _bóve
  { {0xfc3f022d,0xa25b001a,0xf1fa0012,0x7fe90012}},	// [be0] _dní_, _vuôn, فعات_, _شريف_
  { {0x3205002a,0x44e10010,0xfeba0003,0x81bc001e}},	//   ngly_, kų_, _ثابت_, rdēv
  { {0x44e1007a,0x3e66043d,0x7d160002,0x249f07c4}},	//   jų_, _côte_, łysz, klum_
  { {0x44e10010,0xd5b8001e,0xd46a0001,0x7afb07c5}},	//   dų_, žās_, _чиме_, krut
  { {0xd7f9002d,0xdd1d0029,0x81bc001e,0x46f60345}},	//   тує_, ráťt, ldēt, учет
  { {0x11da0003,0x6d580010,0x2ca007c6,0xfc3f0030}},	//   _سورة_, tyva, llid_, _zní_
  { {0x44e10010,0x2cc90029,0x81bc001e,0xdd900003}},	//   gų_, _ľudí_, ndēt, غوب_
  { {0x54540014,0x249f0028,0x95530012,0x26090011}},	//   рвит, glum_, إخوا, _साथी_
  { {0xa0670001,0x18670001,0x41e6002d,0x30750294}},	//   _сата_, _сати_, ліна, _турс
  { {0xdbd10051,0x7bdb002c,0x44e10010,0x6d580010}},	//   _süüd, abuu, bų_, pyva
  { {0x2ca00051,0xdbd10051,0x94060012,0xb7bd004b}},	//   klid_, _püüd, _مواه, _raţi
  { {0xfc3f001a,0x7afb07c7,0xc0ab0012,0xc1730009}},	//   _phím_, brut, عادل_, מחת_
  { {0x7c93000a,0x04930003,0xc339000e,0xfebb0012}},	//   _النص, _النح, őírá, فاست_
  { {0xcf93000b,0x6a600028,0xb6040024,0x929d0034}},	//   מטר_, _söfn, йяск, tułe
  { {0xf77f0017,0x4a5b0009,0x3ebe07c8,0x09f70009}},	//   paço_, _אדגו, _mitt_, _עמהם_
  { {0x7ae2003e,0x2ca00051,0x3ebe07c9,0x248d02a1}},	//   _kwot, glid_, _litt_, čemo_
  { {0x0ca80015,0xc7d80009,0x44e10073,0x94a8004c}},	// [bf0] утри_, _עוזי_, zų_, утра_
  { {0x2bb80003,0x2bdb0037,0x7aef07ca,0x6b7b0009}},	//   طاقة_, _ग्नू_, ácti, גרמנ
  { {0x7aed07cb,0x47d50012,0xc984005f,0x76ba0009}},	//   ssat, ليار, буци, _שמתפ
  { {0x2c27007c,0xab95002d,0x44e10010,0x961d0037}},	//   _сьог, _вимі, vų_, फ़्ट_
  { {0xd5e5002d,0xb8170037,0xd6db010c,0x2009001e}},	//   ажли, ध्यम_, хте_, ļai_
  { {0x44e1007a,0xacf50001,0x644d07cc,0x628307cd}},	//   tų_, ачиј, ljai, čnos
  { {0xd6580093,0x3ebe07ce,0x249f0028,0xa63c0009}},	//   ריות_, _ditt_, tlum_, תגור
  { {0x9984000a,0xeb990094,0x3ebe071a,0x44e10010}},	//   _الفو, кий_, _eitt_, rų_
  { {0x644d004a,0x44e10010,0xc86401ef,0x8c1c0009}},	//   ijai, sų_, _утри, תוחי
  { {0x62850033,0x3ebe0033,0xba160003,0x7cd1001e}},	//   nnho, _gitt_, ليًا_, _pārd
  { {0x9a76000b,0x4a42002d,0x68460015,0x186a0146}},	//   שתתף_, інюв, анна, вани_
  { {0x78ad0149,0x7cd10039,0xb4c10037,0xcea9000b}},	//   _chav, _vārd, ंदी_, _חי_
  { {0xe73a0001,0x7bda0009,0x644d07cf,0x83fd0031}},	//   њег_, _סקסו, djai, nhőm
  { {0x3ebe000f,0x61e70066,0xa2d20012,0x5f080011}},	//   ött_, _nejl, _بيوت, _समस्_
  { {0xbda50003,0x81bc001e,0xa966002d,0x7d0307d0}},	//   محفو, udēt, _вища_, nuns
  { {0x442f0163,0xdd010066,0xbc6307d1,0xa01b008e}},	//   _jag_, _štěs, овск, nnöl

  { {0x91fc0039,0x442f07d2,0xb89b000b,0x6b850003}},	// [c00] bkād, _mag_, _בבקש, مشكل
  { {0xda66000a,0x4a43002d,0x25a00066,0x27e90028}},	//   جاري, онув, řili_, ðann_
  { {0x2cba0003,0xd5fb000b,0x6aa1006f,0x5dfb0009}},	//   _لاحظ_, _בפיר, illf, _בפינ
  { {0x442f0101,0x3ebe07d3,0x97c50012,0x644b005e}},	//   _nag_, _sitt_, متهم, ögit
  { {0x7c240149,0x61e707d4,0x28130003,0x6e2307d5}},	//   meir, _fejl, تونس, fenb
  { {0xb4c10037,0x7c2407d6,0x6e2307d7,0x8cf40012}},	//   ंदू_, leir, genb, مكتش
  { {0x721b000b,0x3947006f,0xc5f3000b,0xddc80002}},	//   _שולח, änst_, קדה_, _podł
  { {0x7c240149,0xe7f20037,0xcdb70009,0x7c930012}},	//   neir, _आएगा_, ספקה_, يشيا
  { {0xd5b10020,0xcb070003,0x15e60037,0x27e00028}},	//   _máy_, ليين_, करार_, ðinu_
  { {0x7d1e0119,0x80ca0302,0xf1aa0037,0x443207d8}},	//   _opps, _संदे, _करान, hdy_
  { {0x3a370093,0xba37000b,0xd575002d,0xca37000b}},	//   ברים_, בטיח_, _луць, בניה_
  { {0xdd7b000b,0x320a0002,0x69c30260,0xd0f70009}},	//   _בטבל, żby_, _egne, סמכת_
  { {0x7ad4000a,0x236d0002,0xe2f8002d,0x7c2407d9}},	//   _اقتص, czej_, _селі_, deir
  { {0xa2c30044,0x442f0070,0x831b0009,0xbe880223}},	//   रदर्, _zag_, _סווז, ассе_
  { {0xa4d5002d,0x58870015,0xd0870015,0xb7f80011}},	//   собі, _выпа, _выпи, ुलाम_
  { {0x44320002,0x60c00052,0x6130000e,0x24580029}},	//   gdy_, _nimm, zólá, _tému_
  { {0xa3b10044,0x644d004a,0x6a600028,0xdee4004c}},	// [c10] टें_, rjai, _töfl, _доњи
  { {0x78a202a1,0x442407da,0xfe050011,0xeb910009}},	//   elov, hem_, _राइस_, הָב_
  { {0x7fd5002d,0x61130066,0x61e70058,0x644d000e}},	//   білі, dělá, _vejl, pjai
  { {0x78a2012e,0x27e90689,0x9ef50003,0x28f80024}},	//   glov, _jean_, مستش, рець_
  { {0xde59002d,0x53340015,0x8c1a000b,0x238a0029}},	//   ладі_, _деят, _גורי, čujú_
  { {0x8e08002d,0x929d0034,0x98a80030,0x628607db}},	//   инів_, kuła, _brně_, ékol
  { {0x442f01e5,0x40350014,0xbd6b0014,0x60c00028}},	//   _pag_, _левс, ърде_, _fimm
  { {0x7cd10039,0x442407dc,0x30850003,0x64b30037}},	//   _pārb, gem_, _الرف, ुदेश
  { {0x20100029,0x83fd0031,0x7d0307dd,0x98bf0073}},	//   íliž_, lhők, suns, lytė_
  { {0x442f002c,0x6aa10033,0x9f4205b1,0xaae40012}},	//   _wag_, ullf, jaká_, آسيو
  { {0x236d003e,0x25570066,0x443207de,0xa4d40024}},	//   szej_, _dělá_, ydy_, _дохі
  { {0x245c0028,0x7c240017,0x9f440025,0x442407df}},	//   _tími_, xeir, _semé_, cem_
  { {0x4374004c,0x6d5c0034,0x69c30064,0x6d410248}},	//   _мушт, wyra, ľnej, ålan
  { {0xa3bd0037,0xda030037,0x1d0a0232,0x539a0009}},	//   ेखन_, _लागत_, леги_, _גינו
  { {0xba740003,0x11440012,0x33f60024,0x7c2407e0}},	//   _بانت, _وَهُ, йчас, teir
  { {0x29050175,0x3fe60538,0x7876001e,0x232a0472}},	//   mula_, _ужив, kšvi, лоби_
  { {0x64aa0013,0x7c2407e1,0xcad50009,0xc2e90012}},	// [c20] _přiz, reir, מוּת_, لعلم_
  { {0xd9f90037,0x0f37000b,0x200d004b,0x7c2407e2}},	//   ूलित_, _פריט_, _acei_, seir
  { {0x97c60003,0x1e57000b,0x7d1e07e3,0xd657000b}},	//   مقاو, _השיר_, _upps, _היית_
  { {0x18a60063,0xcf460048,0x673b01e3,0x629c0034}},	//   щаем, йней, _bruj, _wkro
  { {0xa6fa0009,0x11d60024,0x442407e4,0x1867004c}},	//   רִ֣י, _гібр, vem_, љачи_
  { {0x412a007c,0x4424003e,0x3a250033,0x5be00037}},	//   _його_, wem_, jelp_, नर्व
  { {0x60c00163,0x26090037,0x78a20580,0x27e00097}},	//   _timm, _सारी_, plov, ðins_
  { {0xbf4d0066,0xb8de0037,0x9cd7000b,0x00f70009}},	//   _šířk, ुआ_, זוקה_, _למלך_
  { {0xc1ea002d,0xe7370015,0xafdb0033,0x6f66002d}},	//   льне_, _лет_, kjør, _уваз
  { {0x3d190044,0x27e907e5,0xdb1d0031,0x7ead0064}},	//   _पहले_, _sean_, özép, túpe
  { {0x3a37000b,0x6e930003,0x27e90051,0xca370009}},	//   זרים_, _علما, _pean_, זניה_
  { {0xc953000b,0x48670014,0x9f4b0061,0xc86707e6}},	//   למת_, съоб, lacé_, стои
  { {0xac970003,0x80ca0037,0x27e901e3,0xa01b0031}},	//   _اننا_, _संवे, _vean_, lnök
  { {0x63a201e5,0xafdb0033,0xee2e0024,0x539b0009}},	//   _iyon, gjør, днi_, _עיגו
  { {0x7cf8000b,0x27e90051,0xdd3a000d,0xba170009}},	//   יִּק, _tean_, văţa, _החוץ_
  { {0x985d003e,0x69d8000e,0x7cd10035,0x9cd70009}},	//   _błąd_, űvel, _jāra, מולה_
  { {0x5ea50003,0xba550001,0xd1380010,0x6d480248}},	// [c30] _ومعل, овај, lvą_, ädar
  { {0x75480031,0x629a07e7,0x1ed800ae,0xe9ab00ae}},	//   ószí, noto, _ابيب_, هدان_
  { {0xc05b0024,0x99d40012,0xdd3a004b,0x9cb50012}},	//   лід_, ستلا, răţa, _ومخت
  { {0x27e901e3,0x3e6b00b0,0x26160011,0x37fc0009}},	//   úan_, _møte_, प्सी_, ָּׁב
  { {0xddc5007c,0x63a201ea,0xa6fb0009,0x9f4b0025}},	//   обли, _nyon, אִ֔י, facé_
  { {0xddc50066,0x34b30011,0x6e940024,0xc2c40012}},	//   _pohř, ुद्द, пичу, _ريفي
  { {0x69c70119,0xe80a0044,0xb7fb0037,0xde940003}},	//   _igje, _वाला_, ्लाम_, أجنب
  { {0xc57c0009,0x64930060,0xe45907e8,0xdd1d0064}},	//   טרות, tçiy, ржи_, kážt
  { {0x60ca0052,0xf8c9001a,0x27ef0097,0x61ea0032}},	//   _aufm, _cẩn_, magn_, _befl
  { {0x629a07e9,0x386907ea,0xba750012,0xc87f0032}},	//   goto, _alar_, تابت, eiß_
  { {0xdddc0010,0xc27a0009,0x602607eb,0xc9a90430}},	//   sirū, שרתי, одна, рвне_
  { {0xe45f0051,0x50460001,0x316b0002,0xf649000b}},	//   ööd_, цемб, ącz_, _בצ_
  { {0x290507ec,0x8e5a004c,0x66260012,0xe1ee07ed}},	//   sula_, ајву_, يرسك, _ог_
  { {0x9bb6000b,0x24890692,0x245c0097,0x61ea016a}},	//   _והנה_, enam_, _límt_, _gefl
  { {0x8c7a0014,0x2c67005e,0xdd920012,0xa8a60012}},	//   ащат_, _sõda_, ذور_, _وصعو
  { {0x9f4f0028,0x69d50227,0x0443004c,0x8c430373}},	//   yggð_, _afze, месн, месе
  { {0xc889000a,0xd467029b,0x1dc90011,0xda660012}},	// [c40] _دخول_, ците_, िखात, ياطي
  { {0xae0e0011,0x25ad0030,0x248907ee,0x7d1507ef}},	//   _साधन_, řela_, anam_, éfsá
  { {0xc92a0014,0x41260012,0x361b0009,0xc7c60635}},	//   роеж_, تفاق, _דויד, осли
  { {0xdfd00003,0x69da0037,0xa3ee0011,0x91da0011}},	//   ريت_, _प्री, _ज़िप_, _प्रै
  { {0x41c90037,0xf1c90037,0x501b0009,0x160e0011}},	//   रशास, रशान, שונו, _सादर_
  { {0x4733007c,0x72c30015,0xccfa0001,0xd1380010}},	//   ьніс, _обяз, аћи_, yvą_
  { {0xf653000b,0xbbb40011,0x68ed0034,0xc43a0009}},	//   וצג_, ुश्क, _ładn, ֹתִי
  { {0x245c0029,0xa01b000e,0x6ab20011,0x60c4005e}},	//   _tímu_, rnök, ँग्र, _niim
  { {0x3ce90027,0x629a07f0,0x69cf0030,0x3e6b00b0}},	//   ćava_, toto, ěcen, _søte_
  { {0xfb1b000b,0x9e660003,0xd25a05fb,0x5d1a0024}},	//   סוימ, _بارن, рци_, _відс_
  { {0x61ea0028,0x7c660012,0x6446008e,0x22570012}},	//   _vefl, _واصل, _onki, تجيب_
  { {0x0b460104,0x7ea0006f,0x7afd001e,0x629a07f1}},	//   _мнен, köps, šsta, soto
  { {0xdfa70003,0x60c400b6,0xa01b008e,0x628f0025}},	//   تحدي, _diim, nnöi, écoc
  { {0x64460002,0x95c80048,0x7aa60012,0xb2370012}},	//   _anki, жута_, _بإصل, _وكنا_
  { {0xe9170024,0xeda40024,0x14d80009,0x6cd80009}},	//   _дощі_, дшто, מַּמ, מַּצ
  { {0x6f020002,0x88f70009,0x3e540060,0x3869016d}},	//   kroc, _וזהו_, _aştı_, _ular_
  { {0x27ef0248,0x248907f2,0x225807f3,0x000000c4}},	// [c50] vagn_, rnam_, _bork_,
  { {0x0b88002d,0x9388002d,0x3cfe013a,0xf7720009}},	//   істи_, іста_, štva_, _נקי_
  { {0xfeb80003,0x0a680001,0xd9990012,0x320c0034}},	//   _بايت_, црти_, حنات_, igdy_
  { {0x88c8002d,0xc0780024,0x859a0009,0x48780024}},	//   ілів_, осії_, _לשתו, осія_
  { {0x4429007d,0x87270003,0xdf780024,0x8bd60009}},	//   mea_, تعام, обці_, _מורו_
  { {0xb3ba000b,0x9bba0009,0x8d550048,0x442907f4}},	//   _למרכ, _לצרפ, зтич, lea_
  { {0x38b20029,0x61140024,0x30850012,0xed59003c}},	//   láre_, _одру, _فلسف, сой_
  { {0x9f440066,0xb066004a,0x68ed0002,0x17f80003}},	//   _zemí_, isää, _łado, _ورقة_
  { {0x4ea70046,0x66f40001,0xa3b50037,0xc6a7004c}},	//   _држа, _опту, छें_, _држи
  { {0x20e7000f,0xcb12000b,0x28cf0037,0xe6640015}},	//   tői_, עלי_, _संदि, _отхо
  { {0x44290006,0x60c40051,0xd9450434,0x614507f5}},	//   kea_, _piim, чени, чена
  { {0xc4d2000b,0xa3bd0037,0xda1c0037,0x6fcb0011}},	//   _נגד_, ेखा_, ब्बत_, िशिं
  { {0xeb8e007c,0x32110002,0x60c407f6,0x7c2907f7}},	//   _чи_, _oczy_, _viim, meer
  { {0xc4c60351,0xbb3a000b,0xd356000b,0x7c290643}},	//   كترو, _לעני, _מיני_, leer
  { {0xc1aa0044,0xceb20093,0x60c40006,0x0446002d}},	//   _करेग, גים_, _tiim, певн
  { {0xa5070046,0x628107f8,0x6f0207f9,0x7c2907fa}},	//   џета_, lilo, yroc, neer
  { {0x77830048,0xb066005e,0x2d850025,0x225807fb}},	// [c60] _плъз, asää, ûler_, _pork_
  { {0x7c2900bd,0x6281007d,0x69de0005,0xb77b000b}},	//   heer, nilo, _õpet, _לאפש
  { {0x27ed0036,0x2366001c,0x7c2907fc,0x2f160058}},	//   _been_, šoj_, keer, læg_
  { {0x22580036,0xdfcf0003,0xa8000066,0x69c30037}},	//   _work_, هيم_, příč_, _रणनी
  { {0x62810065,0xbea6007c,0x26c50082,0x163402ad}},	//   kilo, падк, _bilo_, деля
  { {0x6b89014d,0x98ac003a,0xdef70009,0xde880081}},	//   _þega, ılır_, למנט_, aịn_
  { {0x6281009b,0x15170003,0xf9870012,0x645907fd}},	//   dilo, كزية_, _أب_, _bowi
  { {0x27ed01e4,0x3f6a0047,0x7c29063c,0x2c7a001e}},	//   _geen_, _либо_, geer, līdz_
  { {0x6459003e,0xa6ca0003,0x628107fe,0xda660012}},	//   _dowi, _طوال_, filo, كادي
  { {0x0377000b,0x3377000b,0x271e001e,0x7af60010}},	//   פתית_, פעים_, rānā_, isyt
  { {0x7c290070,0x76480002,0x5bc60003,0x4ddb0009}},	//   beer, _indy, _فقال, _החבו
  { {0xa3e60044,0x7c2900bd,0x7af60006,0xdfd80048}},	//   _बजट_, ceer, ksyt, зър_
  { {0x6a600065,0xb8d30037,0x53340014,0xf1bf0029}},	//   _höfu, _जी_, _целт, čšie_
  { {0xcad70093,0x64470039,0x6281000d,0x3bbb0009}},	//   _צוות_, ējie, cilo, _המדד
  { {0x442901b3,0x3866000e,0x746b0109,0x765a07ff}},	//   tea_, kkor_, брав_, _moty
  { {0xea00001a,0x9f4b0066,0x89330012,0xd5b8003c}},	//   _đạn_, lací_, _أعوا, яся_
  { {0x442901b3,0xe7e3015f,0x24580800,0x20f80027}},	// [c70] rea_, _क्या_, чать_, eči_
  { {0x44290801,0xa01b000e,0x9f4b0066,0x27ed0802}},	//   sea_, gnöv, nací_, _seen_
  { {0x30150803,0x51f40003,0xd1640048,0x32d20081}},	//   ддер, عسكر, нъци, _lây_
  { {0x7c290070,0x91bb0009,0xf1b00012,0x7ea00097}},	//   xeer, זמבי, اءك_, löpp
  { {0xcc56000b,0xef0e0014,0x9f4b0066,0x7c290804}},	//   _חברי_, ъм_, kací_, veer
  { {0x6459008b,0x7c290070,0xc332000b,0xdd1c0066}},	//   _sowi, weer, _שום_, láše
  { {0x6459003e,0x765a04fa,0x9f4b05b1,0x7c290805}},	//   _powi, _doty, dací_, teer
  { {0x32d20020,0xccf80066,0x3866006f,0xdd1c0066}},	//   _bây_, _dvě_, ckor_, náše
  { {0xa0c40003,0x7c290804,0x32d2001a,0x69ca0060}},	//   _سيكو, reer, _cây_, şleş
  { {0x83640003,0x32d2001a,0x7c290806,0xe8f90247}},	//   عديل, _dây_, seer, оло_
  { {0x6281007d,0x382a005c,0xac19002d,0xb69b000d}},	//   rilo, ожно_, _можу_, trân
  { {0x200f0807,0xf7670003,0xd59a000b,0x7af6004a}},	//   nggi_, نا_, _ובעל, ysyt
  { {0x32d20020,0x28cf0037,0x2ca90058,0x62810808}},	//   _gây_, _संवि, dlad_, pilo
  { {0x7cd5007a,0x753c0013,0x248d009b,0x9f4f0025}},	//   _sąra, tvrz, lnem_, gagé_
  { {0x6da3011f,0x3f9e0034,0x64430035,0x67f80031}},	//   вира, łtu_, ēnin, gújí
  { {0x248d0809,0x3cfe080a,0x161f0011,0xd8770012}},	//   nnem_, štvo_, म्बर_, _يموت_
  { {0x32d20020,0x248d0052,0xa5a40037,0xf1fa0012}},	// [c80] _xây_, inem_, _चुनौ, قعات_
  { {0x7cd10039,0x77f80037,0x7af60002,0x2bde0037}},	//   _pārl, ुल्क_, rsyt, _फ्रा
  { {0x81460003,0x2ca90698,0xd7ef0024,0x386d001b}},	//   بنان, blad_, ку_, _bler_
  { {0x629e000f,0x9f4b0066,0x20d3001a,0xe7aa0593}},	//   sopo, zací_, _mãi_, овел_
  { {0x629e080b,0x20d30081,0x3866080c,0x248d080d}},	//   popo, _lãi_, rkor_, dnem_
  { {0xa3c10044,0x8f9b0009,0x200f00b8,0x6df40012}},	//   ंधन_, חיני, aggi_, ركبا
  { {0x386d0163,0x9f4b014a,0xa06a0014,0x99850030}},	//   _fler_, vací_, _дава_, delů_
  { {0x7d0a0052,0x83340048,0x628f0025,0x2ca0080e}},	//   rufs, ених, écon, noid_
  { {0x6d410052,0x41c90037,0xd6260003,0xf2060148}},	//   _erla, रशंस, _يعطي, мяно
  { {0x5a340014,0x5186027f,0x4154027f,0x20d30081}},	//   хнот, дума, евос, _bãi_
  { {0x9f4b0066,0x20d3001a,0x3888000e,0x248d080f}},	//   rací_, _cãi_, zőre_, bnem_
  { {0x32d20020,0x246c0002,0xbb4a0012,0xc1780073}},	//   _tây_, yśmy_, _ولان_, lbėk_
  { {0x80ca0037,0x93140012,0x627903a7,0x6d5a0810}},	//   _संके, _أوتش, vňov, ätan
  { {0x2005003a,0xf1940198,0x7a370024,0xa01b0032}},	//   şli_, _пиль, _опір_, enöt
  { {0xda650003,0x200f0028,0x44fa001e,0x45d4003c}},	//   _ثاني, yggi_, nī_, тосс
  { {0x78fb000b,0xbae50003,0xf993000b,0xac740012}},	//   _ולהפ, فكري, _שרק_, ناقش
  { {0x7b180047,0x290c0051,0xddc80002,0xa2b50538}},	// [c90] мотр_, luda_, _podś, ебач
  { {0xe3b0000a,0x38b2000e,0x248d0811,0x627903a7}},	//   شرق_, mára_, znem_, sňov
  { {0x7cd1001e,0x69dc0028,0x290c0812,0x38b20813}},	//   _pārm, ðrey, nuda_, lára_
  { {0x41df0044,0x5f950098,0x59df0011,0x38880031}},	//   _प्रस, ниет, _प्रर, pőre_
  { {0xcc76000b,0x290c0814,0x248d009b,0x7bda0009}},	//   _נעשה_, _ådan_, vnem_, _מקרו
  { {0x8cb90044,0xb0cf0037,0x99850066,0x44390815}},	//   ्दको, _संलग, xelů_, _has_
  { {0x6da2002d,0xe5a2002d,0x248d0816,0x44390817}},	//   лиша, лиши, tnem_, _kas_
  { {0x387f00b6,0x290c0818,0x44390819,0x38b2029d}},	//   _umur_, duda_, _jas_, kára_
  { {0x99850013,0x4439081a,0x38b2081b,0x539a0009}},	//   telů_, _mas_, jára_, ּיתו
  { {0x443906f4,0xc3320093,0xae1b0037,0x60c9004a}},	//   _las_, נוי_, प्शन_, _hiem
  { {0x60c9000f,0x00860345,0x7cd1001e,0x290c081c}},	//   _kiem, елно, _mārk, guda_
  { {0x60c90010,0x6a6d0029,0xe1080009,0x6d3a0009}},	//   _jiem, _dúfa, וּשָ, _מתענ
  { {0x60c9081d,0x38b2000e,0x644b081e,0xb69b0018}},	//   _miem, gára_, _ingi, arâm
  { {0x442d0006,0x786602d1,0x78bd081f,0xcb120009}},	//   lee_, _móvi, amsv, _עלו_
  { {0x44390820,0x22580012,0x6fa00011,0xfcb6003c}},	//   _bas_, _تجنب_, _गुरू, ещаю
  { {0x44390706,0x60c90821,0xdca600f5,0x141a0012}},	//   _cas_, _niem, хаби, ثيرة_
  { {0x44390822,0x645d0026,0x33d5002d,0x2ca00823}},	// [ca0] _das_, _dosi, тіст, roid_
  { {0xa79b000b,0xae0e0037,0x60c9004a,0x44390051}},	//   _משפח, _साइन_, _aiem, _eas_
  { {0x442d0824,0xdfda0048,0x49ba0012,0x645d0825}},	//   kee_, пъл_, سائد_, _fosi
  { {0x61e3003a,0x7c2d000d,0x6e2e000e,0x60c90826}},	//   ınla, cear, lebb, _ciem
  { {0x3a38007a,0x9f34002d,0x765e0827,0xb65a0009}},	//   _tarp_, телі, _kopy, ּדֶש
  { {0xe45f004a,0xc333000b,0x290c0164,0x644b0828}},	//   öön_, _גוש_, yuda_, _angi
  { {0x89340009,0xa5660012,0xad660012,0x61430048}},	//   _בָּא_, عدتن, عاته, _йера
  { {0x44fa0039,0x8fa60829,0x94170048,0x2b010011}},	//   rī_, _забе, ежът_, _शिशु_
  { {0x7ae4004a,0x44fa0035,0xd3d70012,0x136a0472}},	//   npit, sī_, ربيا_, яшки_
  { {0x4efb000b,0x75d60003,0xda100037,0xe6c60003}},	//   _מהמו, _أيضا, ालित_, _أتري
  { {0xd48f029b,0x018a01ec,0x6df30012,0x79940048}},	//   _бр_, ящий_, _إكما, тинф
  { {0xfd57000b,0xf993000b,0x38b2029d,0x7f440025}},	//   _רשאי_, טרת_, tára_, _briq
  { {0x69dc02d1,0xc6f8002d,0x26d20164,0xab290012}},	//   _ofre, ннях_, _cuyo_, _يسهل_
  { {0x6e2e000e,0x645d082a,0xdd860012,0x7c390034}},	//   gebb, _sosi, لو_, _zawr
  { {0x38b2082b,0x4439082c,0xa8a7082d,0x25e00011}},	//   sára_, _pas_, _прик, कड़ी_
  { {0x7f850012,0x45b70009,0x69a40011,0x6aa90011}},	//   _للعن, תפלל_, _कड़ी, कत्र
  { {0xe4ed0037,0xf8bf0061,0x44390082,0x7cd1001e}},	// [cb0] _जबकि_, mmé_, _vas_, _pārk
  { {0x4439082e,0x60c9082f,0x69da0830,0x99d40012}},	//   _was_, _siem, ncte, هتما
  { {0x60c90039,0x7c2d0036,0x44390831,0x645d019a}},	//   _piem, pear, _tas_, _tosi
  { {0xdddc0010,0x7afd0066,0xb4fa0009,0x39a40024}},	//   mirš, ástk, _קפרי, ушув
  { {0x6f1d0832,0x60c90833,0xe72e0024,0x6a600097}},	//   ntsc, _viem, ше_, _vöfr
  { {0xad8b0009,0x158b0009,0x60c90034,0x442d0834}},	//   ּנֵ֥, ּנֵֽ, _wiem, wee_
  { {0x60c90835,0xdd03001e,0x9181001a,0xc1050012}},	//   _tiem, ērķa, iệc_, _جوزي
  { {0xdd8e000a,0x20d7003a,0x1c450594,0x69da0203}},	//   توى_, _içi_, тним, ecte
  { {0x36d5007c,0xaed5007c,0x2ba70037,0x442d0836}},	//   _розр, _розш, _कुमा, ree_
  { {0x394500be,0xb145002d,0x27f20052,0x6f0f0837}},	//   вног, внол, _seyn_, ducc
  { {0xd00a0838,0x44200839,0x8ccd0011,0x35550012}},	//   мене_, yfi_, _दंगो, _جناز
  { {0x7d56000b,0x59c30037,0xcc140012,0x8bb70012}},	//   _ביעד_, वेयर, _مذهب, _كإشا
  { {0x547a000b,0xa8560009,0x2cbf005e,0x765e0034}},	//   _קטנו, דירה_, mmud_, _popy
  { {0x2cad0036,0x3376000b,0x5bd10011,0xdee3083a}},	//   lled_, _בתנך_, _हलुव, рори
  { {0x6e2e01a2,0xada60800,0x6f1d0070,0x48b6003c}},	//   rebb, тавл, atsc, _ищит
  { {0x64be0044,0x6e2e000e,0x2c7500ad,0x6acd0011}},	//   ्देश, sebb, _nådd_, ़दूर
  { {0x6d45008b,0x44200309,0x7d1c009b,0x2cad083b}},	// [cc0] _erha, rfi_, strs, iled_
  { {0x2cad0013,0x5db60003,0x91e60015,0xeef70009}},	//   hled_, _لإجر, тоже, _שמיר_
  { {0xc0aa0003,0xa3ea027f,0xbca60012,0x161b0011}},	//   واصل_, _одна_, _لمدي, _पॉटर_
  { {0x7afb083c,0x895a000b,0xa0670014,0x21a30048}},	//   ksut, ודעת, каха_, шихм
  { {0x44fe0010,0x2f8d000b,0x78a20051,0xa78d0009}},	//   lį_, ּרוּ, roov, ּאוֹ
  { {0x577b000b,0xa9060003,0x2492083d,0x20ee0066}},	//   וטנצ, _لبرن, lnym_, yři_
  { {0x44fe007a,0x91fc001e,0x6e23059b,0x35ba0011}},	//   nį_, skāk, _önbe, _इरफ़
  { {0x39470058,0x2cad048b,0x3860083e,0x2492083f}},	//   ænse_, gled_, _noir_, nnym_
  { {0x38b9000e,0x501b000b,0xd4330003,0x9c0b000b}},	//   nére_, _קומו, شعيب, וִיִ
  { {0x44fe0010,0xf8ca001a,0x2cad07fb,0x63ab080c}},	//   kį_, _mẩu_, aled_, _dygn
  { {0x7afb0005,0x987e00a2,0x09f7000b,0xe5050012}},	//   asut, _açın_, כמים_, _مبني
  { {0x24920002,0x30a40014,0xdddc0010,0x38b9000e}},	//   jnym_, иряв, virš, kére_
  { {0xd36f0003,0xf8bf0061,0x6f1d0052,0x38b9000e}},	//   _وهم_, rmé_, utsc, jére_
  { {0xb7e30044,0x6f1d03e4,0x2c750058,0x6f0f0840}},	//   _क्रम_, rtsc, _måde_, rucc
  { {0x7cd1001e,0x6f0f053f,0x38720841,0x75880842}},	//   _pāri, succ, _flyr_, вств_
  { {0x853b0009,0x48150373,0x62880843,0x20050073}},	//   וגלי, _смис, lido, ėlis_
  { {0x09bd0037,0x1da90037,0x36d50024,0xcaf40012}},	// [cd0] ्ख्य, _चुनत, _щопр, لسلب
  { {0x62880844,0x7a570003,0x291e0845,0x160e0011}},	//   nido, خضرا, otta_, _सागर_
  { {0xdfd10003,0x49a40001,0x2c71000e,0x249204f3}},	//   ميا_, ајца, _láda_, bnym_
  { {0xd5e8001a,0x24580029,0xb3eb0003,0x2c750846}},	//   _đón, _témy_, _تعدل_, _både_
  { {0xef1f003a,0xf7700012,0xb8fa0011,0x97250012}},	//   ntü_, ياه_, _डू_, افتو
  { {0x98b3003a,0x9f4200d9,0xee380024,0xc66b003c}},	//   ıdır_, jaký_, кні_, ьшее_
  { {0xc212000b,0x63ab0002,0x6288052e,0x2cad0847}},	//   _להם_, _sygn, dido, tled_
  { {0x6288001e,0x39490848,0x24890849,0x7afb084a}},	//   eido, _čas_, niam_, tsut
  { {0x7c3d003a,0x89f50024,0x99830073,0x6a720097}},	//   _masr, лянц, _tajų_, _hæfa
  { {0x38600061,0x2492084b,0x7ead0064,0x5ee80009}},	//   _soir_, znym_, kúpi, _יַעְ
  { {0xe73c00a2,0x64150003,0xd9190009,0x2cad0132}},	//   _küçü, _مواط, עוֹל, pled_
  { {0x7c840264,0x511a0009,0x05a70011,0x47aa0012}},	//   _куче, עֵינ, _गड़ब, ّاسٍ_
  { {0x38600108,0x443f0028,0x6288084c,0x41c30011}},	//   _voir_, mdu_, bido, वेतस
  { {0x24920002,0x44fe0010,0x38b9000e,0x644f084d}},	//   wnym_, tį_, vére_, _anci
  { {0xe8140037,0x2492047f,0x60cd00b8,0xc5f20009}},	//   _डाला_, tnym_, _fiam, מדם_
  { {0x44fe0010,0x3896001e,0x38b9000e,0xe3b20012}},	//   rį_, māro_, tére_, مرء_
  { {0x4bd90625,0x44fe0010,0x8c430014,0x3b070345}},	// [ce0] ться_, sį_, щете, лето_
  { {0xe74705ab,0x44fe007a,0x443d084e,0x249204f3}},	//   ções_, pį_, _law_, snym_
  { {0x38b9000f,0x2bc50037,0xb05b004a,0x600a0760}},	//   sére_, लेबा, lmäa, енем_
  { {0x38600065,0x26cc084f,0xfc320003,0x78bb0017}},	//   ðir_, _sido_, _احد_, _chuv
  { {0x4bfb000b,0x443f0028,0xaff70012,0x57f30024}},	//   _אלכס, ddu_, افها_, спіт
  { {0x0f370093,0x7e610850,0x291e0851,0x5694004c}},	//   טרנט_, _colp, ytta_, јакт
  { {0xf1c30037,0xad260012,0x7e610852,0x60d50853}},	//   वेदन, ارتو, _dolp, _guzm
  { {0xdd04007a,0xccf30009,0xd12f0012,0x44320854}},	//   ūrėt, זכה_, _عمق_, ney_
  { {0xe457000b,0x9a8a0014,0xeb970001,0x2e160012}},	//   ריפט_, ещна_, лић_, _مباح
  { {0xc3330093,0x27e00108,0x60cd00c1,0x44320802}},	//   צות_, _afin_, _siam, hey_
  { {0x291e0006,0xa055002d,0xc27b0009,0x34260012}},	//   utta_, авні, גריי, _مرشّ
  { {0x7cd10039,0xf537000b,0xdfd10003,0x291e0855}},	//   _pārv, _תנאי_, تيح_, rtta_
  { {0x24890856,0xfbd30009,0xb6070024,0x36d506e5}},	//   viam_, _התנ_, лявк, рогр
  { {0x64400028,0xd5a60012,0x60c20032,0x24890034}},	//   ldmi, قف_, hmom, wiam_
  { {0xdcbb0014,0x61fa004e,0x64400857,0xbca50012}},	//   еща_, matl, odmi, لمسي
  { {0x64400051,0x61fa034f,0x67650012,0x44320858}},	//   ndmi, latl, _نُعل, gey_
  { {0x6d4a0065,0x6e95002d,0x50b80003,0x3b550001}},	// [cf0] _áfan, _випу, _حدود_, шкар
  { {0xbbd10037,0x7cd1001e,0xdb24000e,0x290c0859}},	//   _हल्क, _kārt, ásán, orda_
  { {0x39470028,0xd7d50001,0x6d5e004a,0xd1310012}},	//   íns_, ажењ, äpal, تما_
  { {0x9f050003,0xd0ab0012,0x61fa085a,0xfafe0035}},	//   لوصو, رطان_, hatl, _ķīna_
  { {0x07a50046,0xe739085b,0x8e55002d,0x443f0584}},	//   јалн, тел_, иткі, vdu_
  { {0xb95b0003,0x443d085c,0x8d65085d,0xcdd50009}},	//   _كجزء_, _saw_, ивле, ׁךְ_
  { {0xbdf80003,0x3e740051,0xed5900de,0xfbd10012}},	//   ارها_, _jäta_, той_, يتة_
  { {0x443f0006,0x1305076b,0x9cd80009,0xb05b008e}},	//   udu_, азим, נוחה_, ymäa
  { {0xa3a80037,0x290c0164,0x443f085e,0x43750021}},	//   _खुद_, erda_, rdu_, руйт
  { {0xc6a70046,0x4432003a,0xfb1c0009,0x38960035}},	//   _срби, zey_, תוזמ, tāro_
  { {0x7c240065,0xf9910003,0x85040003,0x6e3e00b6}},	//   yfir, تبة_, _هولن, _rapb
  { {0x18a60047,0x92a60002,0xf7460063,0x98a6085f}},	//   рамм, _załą, аемо, риме
  { {0xa3d90037,0x4a750015,0xbca40012,0x290c0860}},	//   ाशन_, _выйт, _امني, arda_
  { {0x91e50001,0xddc1001e,0x4b7a0009,0xe737004c}},	//   _токе, _nolū, _שאסו, јер_
  { {0x44f3007d,0xa3dc0037,0xc4c60012,0xabf605c8}},	//   nţ_, तुक_, لترو, ичащ
  { {0xb05b0861,0x3e7b0066,0x7ae9004a,0xab2a004c}},	//   lmän, eště_, opet, коба_
  { {0xfc3f0018,0xb05b0248,0x3ea70862,0x0b43028b}},	// [d00] _daí_, omän, kont_, онтн
  { {0xf2df001a,0x232704ad,0x4efb0009,0xab270264}},	//   _trân_, рофи_, _שהיו, рофа_
  { {0x69dc0073,0x2fe60012,0x7f4901e3,0x25f905f3}},	//   žreg, لكاف, _areq, _ईज़ी_
  { {0x03a6007c,0x628b0061,0x07ba0012,0x8c460863}},	//   _вимо, égor, نهضة_, _теме
  { {0xbb43002d,0x9168001a,0x61fa003a,0x27e90164}},	//   _деяк, _mức_, yatl, ñana_
  { {0xa01b004a,0x3cfe00eb,0x29d30012,0x7ea0008e}},	//   riöi, štvu_, _ويُس, töpy
  { {0xcd330012,0xd49a00ef,0xc5f30009,0xd6570009}},	//   قريب, кри_, חדו_, ייסת_
  { {0x98a3024d,0x493b0009,0x9c38003c,0xa0670365}},	//   _дисе, _בגלו, упит_, _каса_
  { {0xd2500003,0xc1780010,0x61fa000e,0xda660012}},	//   كنة_, ybės_, tatl, لادي
  { {0x7cd10039,0xe3af0012,0xeb910009,0x15f80009}},	//   _pārt, برى_, לָי_, _תִּמ
  { {0x672d0864,0x67220606,0x02b70009,0x867b0009}},	//   _spaj, ltoj, שהים_, _שרבו
  { {0x61fa0865,0x67220079,0x251b0009,0xdd8f0012}},	//   satl, otoj, _יובא, _توم_
  { {0xab830046,0x62800010,0x73360003,0x67220866}},	//   _мушк, _įmon, _خرائ, ntoj
  { {0xb882014d,0xea000020,0x6722007a,0x237b000b}},	//   _þína, _đến_, itoj, _שָׁמ
  { {0x2abb000b,0xb2bb000b,0x6722004a,0x28d00037}},	//   _שמוא, _שמור, htoj, _संचि
  { {0x115b000b,0x2c75006f,0x57f50001,0x5c740867}},	//   _ידוע, _båda_, _упит, олст
  { {0xa9e70003,0x2bc90037,0xb89c0009,0x88bc0009}},	// [d10] لثان, ाइया, _שבחש, _בזהי
  { {0xd1380002,0x4a540868,0x8e8400ae,0x09f900ae}},	//   ową_, окус, _وليه, افاة_
  { {0xc5f20093,0x67220869,0xb7d50003,0xdd910012}},	//   _מדי_, etoj, مقاب, _روح_
  { {0x201900c6,0xa3c80011,0x8cba0011,0x286b0048}},	//   ngsi_, ोखा_, ्षणो, ързо_
  { {0x28c80011,0x6d5a008e,0x3ea7086a,0xb05b008e}},	//   रगति, ätav, tont_, ymän
  { {0x78a200f1,0xa684002d,0x6ec40012,0xade80012}},	//   čova, олід, يتوق, لفهم_
  { {0x3ea70108,0x28f801d4,0x19940048,0x1d060048}},	//   ront_, _весь_, _даря, бещи_
  { {0xcd98000b,0x0d98000b,0xae1c0037,0xaadb0011}},	//   ידות_, יכום_, _नाथन_, _बढाक
  { {0x7cd10333,0x3ea7086b,0xf7850012,0xd2a9003c}},	//   _pārs, pont_, _الذَ, лкие_
  { {0x9168001a,0xfc3f00d9,0xcb360009,0xfe730012}},	//   _sức_, ží_, צאתי_, _بدر_
  { {0x61f8003a,0x7ae9086c,0x38b20064,0x186a0147}},	//   _devl, spet, lári_, гани_
  { {0x45b6000b,0xf992000b,0x307a0003,0x385a002d}},	//   _הפעל_, לרי_, احدة_, урою_
  { {0x248d0039,0x76890010,0xb05b008e,0x889a0009}},	//   miem_, ažym, mmäl, רברי
  { {0xd5b10020,0x248d001e,0xb05b004a,0x61f80227}},	//   _ký_, liem_, lmäl, _gevl
  { {0xceb2000b,0x9168001a,0xd5b20003,0x628f0025}},	//   פיל_, _tức_, سفر_, écou
  { {0x6722007a,0x28d001e1,0x475a0014,0x248d086d}},	//   ytoj, _सूचि, _броя_, niem_
  { {0xd5b10020,0xf1bf0066,0x04570012,0x59d60012}},	// [d20] _lý_, řád_, حلقة_, مغار
  { {0xb05b086e,0x6f04086f,0x2f5b0009,0x76410870}},	//   hmäl, _ivic, _עדינ, _naly
  { {0xfe370093,0x248d0871,0x64ac0052,0x25d70009}},	//   _פרטי_, kiem_, ußis, _לוין_
  { {0x248d0039,0x91fc0039,0x17fa0003,0x67220872}},	//   jiem_, nkār, اراة_, ttoj
  { {0x248d0039,0xb4c40044,0x501b000b,0x14b50037}},	//   diem_, एगी_, רונו, ंतरण
  { {0x7c2b0052,0x5ee90009,0x66c00248,0x6fb30012}},	//   _abgr, בַקְ, sökf, أمها
  { {0x7641007a,0x67220873,0x91fc0035,0x21670048}},	//   _daly, stoj, kkār, _лири_
  { {0xfd0f0003,0xd197000b,0xb176001a,0x76430002}},	//   رجى_, _הכלי_, _ngượ, adny
  { {0x7cd1001e,0xcb070003,0x988b0009,0xa3a80011}},	//   _pārr, ميين_, _עָלֵ, _खुश_
  { {0x9e65000a,0xc3330093,0xd1380034,0x7c360097}},	//   _والن, לוח_, twą_, heyr
  { {0xd0110003,0x142a0024,0x7afd0874,0x7c36008e}},	//   ولد_, _біло_, ástr, keyr
  { {0xb4b70011,0xd1380034,0x248d0875,0xbec30035}},	//   _छठे_, rwą_, ciem_, ķīmi
  { {0x3e970003,0x5f940014,0x94bb0009,0x61fe0876}},	//   مؤسس, зият, _עמדת, kapl
  { {0x539b000b,0x7d150035,0x91fc0035,0xeb0700ae}},	//   _גידו, tuzs, akār, _اقوى_
  { {0x90e60003,0xb05b004a,0xe5c40014,0x5d780009}},	//   _استن, lmäm, зсто, בָּנ
  { {0x38b90108,0x4917000b,0xb4b30011,0x6444020d}},	//   méro_, _הקהל_, टते_, gdii
  { {0x2ca9002a,0x228f0002,0xfbd00012,0xd9f9004c}},	// [d30] road_, eżka_, فتك_, инац_
  { {0xacf80002,0xf9c70063,0x7f4d0877,0x51f8003c}},	//   _żółt, бщен, _iraq, йную_
  { {0xb05b004a,0xb9250003,0xc1040012,0xe10b0009}},	//   ymäl, تفضي, كولي, ָּבָ
  { {0x6d400039,0xdd000013,0xd825002d,0xdb0f0061}},	//   āmat, štěn, ідли, _lycé
  { {0xbc1a000b,0x76410010,0x248d0878,0x7ce70060}},	//   _דורש, _paly, viem_, _kırg
  { {0x999e000f,0xf1c80044,0x248d0002,0x91fc001e}},	//   hető_, रधान, wiem_, zkār
  { {0x248d0039,0x9f400065,0x38b20029,0xf5560012}},	//   tiem_, _leið_, sári_, قلوب_
  { {0x7b080065,0xa3d90037,0x1309064f,0x26d30018}},	//   _ástæ, ाशि_, аний_, _lixo_
  { {0x290a000f,0xb7bd007d,0x248d0879,0x999e000e}},	//   ában_, _obţi, riem_, dető_
  { {0x248d0039,0x0905007c,0x2f100028,0xb05b0872}},	//   siem_, опон, _lögð_, smäl
  { {0xdd9b064f,0x3896001e,0x91fc001e,0xc212000b}},	//   _сша_, lāri_, tkār, והי_
  { {0xc5e90093,0x9fca0014,0x61fe01e9,0x43750294}},	//   _יד_, игна_, zapl, _мулт
  { {0x27ff0065,0x98c50010,0xdd1e0029,0xe28e0083}},	//   ðuna_, štės_, _víťa, _жа_
  { {0x44290028,0x6e960012,0xc2c40012,0x91fc0035}},	//   efa_, زلزا, _فيني, skār
  { {0xa3c10037,0x61fe003a,0x2911000e,0x261b0037}},	//   ंधक_, vapl, ázad_, _बारी_
  { {0x6f00000f,0x74160003,0x26d30018,0x7f4d0018}},	//   ámcs, تورا, _eixo_, _fraq
  { {0x61fe00a2,0x7aed0101,0x4dd60024,0xc2e90012}},	// [d40] tapl, gpat, _мінф, معلم_
  { {0xf9920003,0x6d5a004a,0x4429087a,0xf2210011}},	//   وبا_, ätas, afa_, _माफ़_
  { {0x27e50002,0x2724087b,0x64970035,0xed5a0373}},	//   ślne_, lön_, rģij, _тон_
  { {0x61fe00a2,0x7c290070,0x6286000e,0xf992000b}},	//   sapl, jfer, ékoz, ורב_
  { {0x27240006,0xaf360003,0xf1ab0011,0x6d430097}},	//   nön_, ترات, _घुसन, _ánar
  { {0xf773000b,0x999e000e,0xf1bb0011,0x25ad004b}},	//   וקד_, zető_, ैधान, şele_
  { {0xafe6002d,0x7c29087c,0x385a0055,0xdd900012}},	//   _мовл, ffer, _краю_, عوب_
  { {0xe8140037,0xa3e50011,0x8c43004c,0x99980035}},	//   _डाटा_, बुल_, деће, _garš_
  { {0x999e000e,0x2724012b,0xbc670012,0x261b0011}},	//   vető_, jön_, تمين_, _बाली_
  { {0x026a002d,0x60dc003a,0x76890010,0x3f82087d}},	//   рший_, _kurm, ržyk, dzku_
  { {0x3a370093,0x4429087e,0x7aed0002,0xc2370009}},	//   חרים_, yfa_, zpat, חריו_
  { {0xf8b00003,0xb05b004a,0xadb70012,0x6d3b0009}},	//   َةَ_, mmäk, _بهما_, _כתבנ
  { {0xe29a0046,0xaa4606a5,0xab770012,0xd2520012}},	//   _кад_, _медл, _ومما_, _ينص_
  { {0x2907000f,0xee2e0024,0xa2c10011,0x628a0032}},	//   ának_, енi_, _रीप्, _umfo
  { {0x12a90003,0xdb06008e,0x05740012,0x0467087f}},	//   _ادنى_, _lykä, وافد, отам
  { {0x69d80010,0x9b890003,0x317b0009,0xd5b801c6}},	//   žvel, منزل_, _כרומ, юся_
  { {0x44290028,0x61fc0880,0xb2750867,0xddde0034}},	// [d50] rfa_, _berl, плаш, _dopł
  { {0x66c00006,0x442900b8,0x656e0031,0xe2170012}},	//   töke, sfa_, ínhá, تبرع
  { {0x2fd90003,0xdc2f001e,0x629a004a,0x7bdc0030}},	//   مواد_, ažād, into, ěruj
  { {0x7c590012,0xf8070024,0x79ab0009,0x7aed0881}},	//   _الحر_, ічен, בֹדַ, ppat
  { {0x8cba0037,0x61fc0028,0x66c0006f,0x9f400028}},	//   ्षरो, _ferl, söke, úið_
  { {0x1af60009,0xc3320009,0xfe420024,0x60dc0882}},	//   _ממשל_, _רום_, еншо, _furm
  { {0x7c290883,0xe5f8000b,0xf3ff0017,0x2d830034}},	//   tfer, חזור_, _joão_, nzje_
  { {0xd59c0009,0x629a0884,0x61fc0032,0x2724008e}},	//   יבול, ento, _zerl, yön_
  { {0x7c29014d,0x5f94007c,0x61fc00a2,0x3834002d}},	//   rfer, _житт, _yerl, _інфр
  { {0x62800010,0xaabd0011,0x7c290885,0xc6d40012}},	//   _įmok, ्गिक, sfer, _قتلت
  { {0x91fc001e,0xe45f0051,0xf2d4000b,0x7c290886}},	//   rkāp, öös_, ועץ_, pfer
  { {0x55ba000b,0x2724004a,0x6d410887,0x38b2000e}},	//   _המעו, tön_, _isla, járt_
  { {0x3869007d,0x31b80037,0xe73a004c,0xaabd0011}},	//   _doar_, _अर्ध, љег_, ्गाक
  { {0xe7370001,0xab64002d,0xbb4205fb,0x2cad0227}},	//   џер_, _ювіл, _чешк, loed_
  { {0x7c2f000d,0x27240137,0xdeba0009,0xdd920012}},	//   _bbcr, sön_, ממשל, رور_
  { {0x07a6002d,0x8fa60024,0xd3f40024,0x61fc0888}},	//   _найн, _найе, вiст, _serl
  { {0x61fc0889,0x8e56002d,0xa87b0009,0x487b0009}},	// [d60] _perl, _етні, _לאקר, _לטקס
  { {0x7c2f0058,0x2002088a,0x1eaa0012,0xdb060034}},	//   _ebcr, laki_, _داعي_, _szkó
  { {0xb5f7000b,0x4ddb000b,0x85f7000b,0x61fc088b}},	//   _מציג_, _לחיו, _מציע_, _verl
  { {0xb4d80037,0x764505b1,0x18a30048,0x60dc0060}},	//   ादी_, _zahy, нахм, _vurm
  { {0x61fc00c6,0x29130054,0x764500b6,0xf4130009}},	//   _terl, arxa_, _yahy, _אפר_
  { {0xd6d9002d,0x929d0002,0x2905088c,0x6446088d}},	//   іті_, ysła, ksla_, _haki
  { {0x3896001e,0xdb07014a,0xe9a30055,0x6446088e}},	//   lāru_, _člán, _зарп, _kaki
  { {0x6446003e,0xc19b0093,0x499b000b,0x399b000b}},	//   _jaki, _השלי, _השלב, _הילד
  { {0x200200a2,0x6b840052,0x8b230001,0x6446088f}},	//   daki_, nzig, едње, _maki
  { {0xb05b0006,0x877b000b,0x38b2000e,0x15460024}},	//   mmäi, _האמי, zárt_, _незм
  { {0xa6e90020,0x2bb90037,0x05760003,0xdb23000e}},	//   _chươ, _आर्थ, _عائد, _öröm
  { {0x63a20002,0x64460890,0xb7d90012,0x41bb0009}},	//   żony, _naki, توحا_, מציע
  { {0x6b8401e4,0x99690029,0x38b2000e,0x61e505b1}},	//   jzig, hŕňa_, várt_, ychl
  { {0x2c710066,0xd357000b,0x539b0009,0x5eeb0009}},	//   _rádi_, _מידי_, _פיגו, מַלְ
  { {0xeda4002d,0x64460891,0xa2c00011,0xb2bb0009}},	//   ешто, _baki, वतन्, _המגר
  { {0x764500b6,0x45240012,0xc9b70009,0x628e0892}},	//   _wahy, عرِّ, _מהות_, _ambo
  { {0x3f9e00a2,0x64460893,0x32010066,0xcb340048}},	// [d70] ştur_, _daki, tahy_, нетъ
  { {0x99d70003,0xf7720009,0x3f7c0009,0x877c0009}},	//   ستطا, _סקי_, _לאחס, _לאחי
  { {0x7c220894,0x29070066,0x61e50895,0x6d410060}},	//   _ocor, éna_, rchl, çlad
  { {0x61e5008b,0x38690065,0xdfd1000a,0x6a73003a}},	//   schl, ðar_, نيا_, _sıfı
  { {0x6497000d,0x600c0009,0x2cad0227,0x7c2d0896}},	//   nţie, מִגְ, voed_, mfar
  { {0x171c0093,0x6d410897,0x20020898,0x442f016d}},	//   מודע, _psla, zaki_, _sbg_
  { {0xa934007c,0x27e90065,0xdca50014,0x6f090066}},	//   _перш, _ofan_, маки, šech
  { {0xe81f0044,0x14bf0037,0x9872001e,0x6d7c0009}},	//   _भाषा_, ्षिण, kšā_, מאוח
  { {0x1c420015,0x200d0899,0x2bdc0011,0x2002089a}},	//   тным, _idei_, मख़ा, vaki_
  { {0xa6e90020,0x9f040012,0xdcf70012,0xddc1004b}},	//   _phươ, _أولو, _فأصب, _colţ
  { {0x3896001e,0x10a601ef,0x19c50109,0x98a60063}},	//   kārt_, динн, ьбом, дине
  { {0x16200044,0x29050028,0x6603089b,0x7d1c0260}},	//   _बाहर_, rsla_, lank, _årsa
  { {0x7c3b0061,0xb9040037,0x9872001e,0xac1801d4}},	//   meur, _भू_, gšā_, _хочу_
  { {0xa6e90020,0x442d089c,0xe2c90003,0x38b2000e}},	//   _thươ, lfe_, _بوتو_, társ_
  { {0xceb20093,0x6446089d,0x5fdd0011,0xb4d80011}},	//   דים_, _paki, यशाल, ादे_
  { {0x6449089e,0x27ff0032,0x6b840032,0x88bd0030}},	//   ndei, _neun_, tzig, htěj
  { {0x6497000d,0x3e740051,0x64460774,0x442d02c3}},	// [d80] cţie, _läti_, _vaki, ife_
  { {0x644600b6,0xfbd10012,0x6b840032,0x1996004c}},	//   _waki, اتِ_, rzig, мјер
  { {0x7c3b00bd,0xb80a0003,0x6603036a,0xcb09000b}},	//   keur, قيام_, dank, של_
  { {0xca29000b,0xccf3000b,0x7c3b089f,0x6bd60012}},	//   ים_, _שכר_, jeur, _يتحر
  { {0xc6f7002d,0x073a0003,0x3896001e,0x7d1c030f}},	//   дніх_, تساب_, lārs_, lurs
  { {0xcb8b000b,0x66030070,0x6e3c00ed,0x442008a0}},	//   _וְלֹ, gank, nerb, lgi_
  { {0x69dc0017,0xa2ab0037,0x442d0204,0x6143003c}},	//   _igre, जकर्, ffe_, _иера
  { {0x3ae4006f,0x4422000e,0xb05b004a,0x6603004a}},	//   _köp_, ük_, lmäv, aank
  { {0x442008a1,0x224708a2,0xbcb70009,0xfee90012}},	//   igi_, _bank_, ופקו_, _فعلى_
  { {0x66c0004a,0xb2380012,0x07a30367,0xf2df004b}},	//   yöka, أكدا_, _раун, _grâu_
  { {0x0217000b,0x018a0015,0x7c3b0070,0x22470832}},	//   וחים_, ющий_, beur, _dank_
  { {0x7d1c0065,0x73c60003,0x1c1d0037,0x3eb90035}},	//   durs, _قيام, _फाइल_, _īsti_
  { {0xdfd80014,0x6a720097,0x42560012,0x6266004c}},	//   дър_, _hæfu, _ينصر, _овда
  { {0x64830005,0xddda0013,0x5333002d,0x69dc01e3}},	//   _kõig, _potř, _решт, _ngre
  { {0xec6b0001,0x08f70012,0xd8bb0012,0xc3480081}},	//   орак_, _قريب_, _ودعا_, _hổ_
  { {0x442008a3,0x261b0037,0x6497004b,0x69dc08a4}},	//   ggi_, _बाकी_, pţie, _agre
  { {0x7c2d0065,0x66c00163,0x64830051,0x43940001}},	// [d90] rfar, söka, _lõig, ватс
  { {0x442008a5,0xa3ce0011,0xaceb0012,0xc3480081}},	//   agi_, षेध_, _ورجل_, _mổ_
  { {0x7d1c08a6,0xc0150306,0xb015004c,0x7c3b08a7}},	//   curs, емещ, емељ, yeur
  { {0x8c3d000d,0xb8090012,0xb8e70011,0x929d0034}},	//   noşt, سيتم_, _उठ_, ysło
  { {0x76480101,0xb4bd0044,0xc348001a,0xa6e7001a}},	//   _bady, ेगी_, _nổ_, _giữ
  { {0x8afa000b,0xc2c50012,0x8f9c0009,0x6f1d00b8}},	//   _מהשי, _سيزي, חידי, iusc
  { {0x7ce700a2,0x7c3b08a8,0x660308a9,0x64490097}},	//   _bıra, teur, rank, tdei
  { {0xc3480020,0x934505cc,0x88bd0066,0x765a08aa}},	//   _bổ_, ение, stěj, _enty
  { {0xc348001a,0x224708ab,0x7c3b020c,0x6f1d08ac}},	//   _cổ_, _pank_, reur, jusc
  { {0xe1f10003,0x27290164,0x7d28006f,0xda0f0037}},	//   دسة_, mún_, örsö, ाणित_
  { {0x9c7c001c,0xa3b60044,0x2d9a0029,0x49990063}},	//   _suče, _चुन_, ĺpec_, ятия_
  { {0xf7670003,0x6e3c0168,0xc1dc0011,0x38a40060}},	//   ها_, werb, _बल्ग, fıra_
  { {0x2418002d,0xd5b8001e,0x224708ad,0x7f76004c}},	//   _цією_, ļām_, _tank_, хунц
  { {0xdce70002,0x6e3c0032,0x387f01a0,0x7bdd020d}},	//   zyją, uerb, _llur_, _agsu
  { {0x387f003a,0x6da300f5,0x11450012,0xd5b208ae}},	//   _olur_, гира, _أَبُ, افز_
  { {0x249f0028,0x69c30027,0x10690003,0x6601000e}},	//   nnum_, _izne, _يحيى_, _lelk
  { {0xb89b000b,0xc4d2000b,0xb09b000b,0x1fb6002d}},	// [da0] _מבקש, רגן_, _מיקר, _яскр
  { {0x7fd7000b,0x6379002d,0x66290029,0xc7d70009}},	//   _אופס_, єстр_, ľský, _אופי_
  { {0x66c00006,0x44200033,0x249f087a,0x8dfb0009}},	//   löko, pgi_, knum_, _מהית
  { {0x44fe0066,0xc209000b,0x7648002c,0x9f7a0009}},	//   mů_, מה_, _sady, ּנַח
  { {0x6136000f,0x272902d1,0xddc80002,0x44fe0066}},	//   _külö, gún_, łoże, lů_
  { {0x7ce700a2,0x66010107,0xe7690030,0xc3480081}},	//   _sıra, _celk, nářů, _rổ_
  { {0x249f0065,0x44fe0066,0xc5f3000b,0xc348001a}},	//   fnum_, nů_, נדה_, _sổ_
  { {0x249f0065,0x66010051,0x5454005c,0x26da009b}},	//   gnum_, _eelk, твит, _lipo_
  { {0xb05b006f,0x6497001e,0x9cd7000b,0x44fe0066}},	//   lläg, eģis, עופה_, hů_
  { {0xdee30098,0x44fe0013,0x179b0009,0xeb330012}},	//   _софи, ků_, _זימב, اريخ
  { {0x2d87003e,0x44fe0013,0xd6cf0003,0x2b910029}},	//   czne_, jů_, _اقل_, môcť_
  { {0xc3480020,0x44fe0013,0x33f60003,0x38a4003a}},	//   _tổ_, dů_, _أساس, tıra_
  { {0xb05b0052,0x6cd30012,0xdb1d0060,0xf09f01a0}},	//   hläg, _إقنا, üyük, rnà_
  { {0x66c0006f,0x877b0009,0x44fe0030,0xa01b016a}},	//   sökn, לאכי, fů_, chön
  { {0x44fe0066,0xac950109,0x4c950024,0x3d340009}},	//   gů_, вавш, вивс, כָּל_
  { {0xdcb80098,0xf969002d,0x7ae200b6,0x91bb0009}},	//   ещу_, _юрій_, _kuot, _ממוי
  { {0x6497007d,0xfaf00003,0x7cd1001e,0x48140015}},	// [db0] nţia, مثل_, _pārz, _смыс
  { {0x7ae20006,0x979c000b,0x64830051,0x44fe0066}},	//   _muot, _משחק, _sõid, bů_
  { {0x7ae20006,0xf1a703e2,0x82a4004c,0x249f0097}},	//   _luot, хран, уште, ynum_
  { {0xc078002d,0x6601004a,0xb066004a,0xb05b08af}},	//   нсії_, _selk, mpää, mmäs
  { {0x7ae2007a,0x386d00bd,0xd6db08b0,0x64830051}},	//   _nuot, _voer_, чте_, _võid
  { {0x88bd0030,0x44e7005e,0x64970073,0x291e08b1}},	//   stěh, _kõ_, dţia, kuta_
  { {0xd658000b,0xa3d90037,0x32050066,0x99d70003}},	//   תיות_, ाशक_, valy_, _ستسا
  { {0x660100bd,0x2d8708b2,0x291e08b3,0x644d08b4}},	//   _welk, rzne_, duta_, ndai
  { {0xb05b004a,0x228f0002,0x249f032c,0x5ba90055}},	//   hmäs, eżki_, rnum_, ьким_
  { {0xc332000b,0x7ed70003,0x7ae20010,0x5edc0011}},	//   סוי_, _أزرا, _duot, _गूग्_
  { {0x249f0028,0x99d4002d,0xb05b08b5,0xfe700012}},	//   pnum_, лююч, ymät, _ادق_
  { {0x3e74006f,0x44fe0066,0xdee60063,0xcea90009}},	//   _lätt_, vů_, коми, _וי_
  { {0xab5b000e,0x10a301b6,0x443f08b6,0xcf43003c}},	//   _szün, риян, meu_, аняй
  { {0x443f03eb,0x63a4007a,0x09e20014,0x44fe0066}},	//   leu_, _žing, _кошн, tů_
  { {0xceb2000b,0x2907004b,0x27ed0032,0x69c30220}},	//   ייך_, ânal_, _ofen_, _uzne
  { {0x44fe0066,0x443f08b7,0x7f860012,0x2ca0005e}},	//   rů_, neu_, _للبن, unid_
  { {0x44fe0066,0x644b08b8,0x443f08b9,0xb0b70009}},	// [dc0] sů_, _magi, ieu_, _בפקס_
  { {0x645d08ba,0xaa7b0028,0x44fe0066,0xaab30011}},	//   _ensi, _stýr, pů_, ुतिक
  { {0x44e7001a,0xc6170009,0xa9260063,0x48060024}},	//   _gõ_, _בחיי_, тдел, впев
  { {0x644b08bb,0xb05b08bc,0x63a40097,0xd6e20034}},	//   _nagi, rläg, _þing, ykłą_
  { {0x443f03eb,0xb606009b,0xb05b006f,0xd00706bd}},	//   deu_, pušč, släg, тече_
  { {0x7bc6009b,0x60c90052,0xb05b08bd,0xddde0066}},	//   _izku, _ehem, pläg, _popř
  { {0x644b00c6,0x443f0054,0x60260014,0x60db00c1}},	//   _bagi, feu_, _идва, _fium
  { {0x443f0054,0x7ce7003a,0x69b50011,0x644b00b8}},	//   geu_, _tırn, _उड़ी, _cagi
  { {0xcb070003,0xb05b006f,0x38b9000e,0x03c30109}},	//   نيين_, kmär, iért_, исьм
  { {0xd8f8002d,0xb05b004a,0x6497000d,0x7ae208be}},	//   нної_, ymäs, rţia, _vuot
  { {0x38b9000f,0x621b000b,0x443f08bf,0xc98603ff}},	//   kért_, וויק, beu_, тупи
  { {0x04460046,0x7ae20006,0x44e70020,0xf1b3000b}},	//   _једн, _tuot, _rõ_, יסת_
  { {0x6b89003e,0x291e08c0,0x6440003a,0xda340015}},	//   czeg, suta_, memi, _белы
  { {0x6497007d,0xd9540003,0x38b90029,0x644b0034}},	//   nţin, _منتخ, véru_, _zagi
  { {0x3e74006f,0xf708001a,0x85b80012,0x443208c1}},	//   _rätt_, hủ_, نافس_, ffy_
  { {0xed100020,0x3e740163,0x644008c2,0x44e708c3}},	//   _đổi_, _sätt_, nemi, _võ_
  { {0x5a350098,0xfbd00003,0x644d08c4,0x40bc0009}},	// [dd0] лнат, قتك_, rdai, _קזחס
  { {0xdce70002,0xf8bf08c5,0x443f08c6,0x644008c7}},	//   zyję, llé_, zeu_, hemi
  { {0x64400006,0x74be0037,0x83fd000e,0x7af60002}},	//   kemi, _वीकृ, rkőz, apyt
  { {0x443f0054,0xc19b000b,0x6497000d,0xcfe90012}},	//   xeu_, ושבי, eţin, رفته_
  { {0x443f08c8,0x8c1a000b,0x200408c9,0x6ca80009}},	//   veu_, _אורי, _demi_, _יֹשְ
  { {0x76240024,0xf8bf08ca,0x7ce70060,0xde580024}},	//   иміз, hlé_, _fırl, качі_
  { {0x443f08cb,0xcd350003,0xf8bf0066,0x6d320012}},	//   teu_, ارتب, klé_, مفوض
  { {0x64400005,0x69c702a1,0xcf270012,0x66050030}},	//   gemi, _izje, _لرئي, _lehk
  { {0x443f03eb,0x09e50001,0x6497000d,0xd2990024}},	//   reu_, лопн, bţin, етні_
  { {0x443f08cc,0x200408cd,0x6b8908ce,0x38b9000e}},	//   seu_, _zemi_, rzeg, zért_
  { {0xe4e7007c,0x44f50014,0x7ce7003a,0xab5b000e}},	//   _різн, _спес, _kırm, _szül
  { {0xa3550003,0x9b450012,0x2c200011,0xa3ea0011}},	//   _مختص, _منصو, _याएं_, _मलय_
  { {0x6d41003a,0x68e30052,0x99750002,0x9cd6000b}},	//   çlan, _wund, nęła_, _עונה_
  { {0x68e3044f,0x539a0009,0xdee3019c,0x2cbf005e}},	//   _tund, _אינו, сори, llud_
  { {0x6497000d,0xa3e70011,0xf8bf08cf,0x66c00097}},	//   nţio, पशप_, blé_, lökk
  { {0xb05b0005,0xdd8f0003,0x91ba0009,0xa97600af}},	//   smär, سوق_, _אמצי, _תתקנ_
  { {0xb05b006f,0x99750034,0x66c00031,0x5b260012}},	// [de0] pmär, jęła_, nökk, طفال
  { {0x38b9000e,0xca4a0012,0x7f290009,0x44320132}},	//   sért_, علاه_, _סֵפֶ, sfy_
  { {0xdce8001e,0x64400060,0x290e08d0,0xba170012}},	//   ēlēt, yemi, éfa_, طينا_
  { {0xd59b0009,0x64400018,0xad1b0009,0xdee604d5}},	//   _טביל, xemi, _אוטר, годи
  { {0x2bba0012,0xb8eb0011,0x5376004c,0xa3ba0012}},	//   _ساحة_, _री_, _сунђ, _ساحر_
  { {0x78a2013a,0x91e30229,0x9cf40024,0x09e308d1}},	//   snov, _горе, азкі, _горн
  { {0x11d5002d,0x6497000d,0xafdb0262,0x644008d2}},	//   _вітр, rţin, ndør, temi
  { {0x5b140014,0x6497000d,0x7b140048,0x5c7406bd}},	//   амит, sţin, адих, рлит
  { {0xf20604ad,0x87250012,0x6497004b,0x3ae90081}},	//   ляно, _نعلم, aţio, _cúp_
  { {0x67220010,0x86c60003,0xd9f60037,0x6497000d}},	//   muoj, _صيان, ेरित_, lţil
  { {0xd6570093,0x6497000d,0x3cf80029,0x644008d3}},	//   _תיבת_, cţio, jprv_, pemi
  { {0xf993000b,0x2cbf000d,0x6497000d,0xe58b000b}},	//   מרת_, clud_, nţil, _אָדָ
  { {0x26de0010,0x67220010,0xf8bf0061,0xa2b90011}},	//   _kito_, nuoj, rlé_, ्तम्
  { {0xb05b008b,0xc7b30093,0x0cbf0011,0xa3d80011}},	//   fläc, מבר_, ्ष्म, ाधन_
  { {0x6d580028,0x6ca7022a,0x765e004a,0x6e350060}},	//   _ával, граж, öpyy, _özbe
  { {0x67220010,0x7ae600b6,0x1f7502ad,0x44ea0081}},	//   kuoj, _bukt, _влия, _mù_
  { {0xd5b10044,0x26de0017,0x66050051,0x67220010}},	// [df0] _आँकड़, _oito_, _tehk, juoj
  { {0x44ea0108,0x26de0101,0x19590015,0x200b0066}},	//   _où_, _nito_, казы_, laci_
  { {0x32b80003,0x629a08d4,0x3ff50012,0xf1ab0012}},	//   ادقة_, iito, لكار, رائه_
  { {0x8934000a,0x6cfa000b,0x90990014,0x9be40024}},	//   إعلا, _שפרס, ъвет_, _гірк
  { {0xe758002d,0x67220010,0x4f580024,0x48040024}},	//   лиці_, guoj, лицю_, спів
  { {0x644f02d1,0x99d70003,0x6286001e,0x870401ec}},	//   _haci, _متزا, ūkoj, сяце
  { {0x200b0013,0x26de08d5,0x6f1d0052,0x365c000b}},	//   kaci_, _dito_, hrsc, תכונ
  { {0x62880006,0x44ea001a,0x24890539,0x200b05dd}},	//   ehdo, _dù_, nham_, jaci_
  { {0xd627000a,0xc482007c,0xe3b10003,0x66270003}},	//   _معاي, ільк, غرب_, _مراك
  { {0x7f840003,0xa7740015,0x644f0054,0x6497000d}},	//   _الكن, _улуч, _laci, pţio
  { {0x66c0000e,0x6497000d,0xf86608d6,0x443908d7}},	//   sökk, lţim, авно, _obs_
  { {0x6288004a,0x200b0729,0x9c8201e9,0xb4fa0009}},	//   ahdo, gaci_, účto, _יפעי
  { {0x23290063,0xa0880009,0xe3b30012,0x661a0034}},	//   _роли_, רְתִ, _ارض_, ótko
  { {0x443903c0,0x41e70024,0xc7d60009,0x6288036c}},	//   _abs_, _сіда, יורי_, chdo
  { {0x9cb60003,0x67220010,0x200b0027,0xa5070014}},	//   لمست, zuoj, baci_, иера_
  { {0x3d080044,0x386008d8,0xc48305fb,0x200b08d9}},	//   _सबसे_, _unir_, олск, caci_
  { {0xb6a6002d,0xa2060731,0x4e1a0015,0x58bb0009}},	// [e00] _випл, ипад, _июня_, _במקצ
  { {0x88bd0013,0xda79002d,0xef1f000e,0x442b00c1}},	//   stět, ляє_, zzük_, _ecc_
  { {0x2bb80037,0x26de08da,0x361b0009,0x600a0198}},	//   _आडवा, _rito_, _בויד, внем_
  { {0x26de01a2,0x09c60044,0xd0100003,0x67220010}},	//   _sito_, _वरीय, سلت_, tuoj
  { {0x6497007d,0x87030075,0x09e6002d,0xe6660594}},	//   rţil, ояще, _вогн, итко
  { {0x200b0013,0x644f08db,0x67220010,0x9757000b}},	//   zaci_, _zaci, ruoj, יינו_
  { {0x6722004a,0x32180002,0x629a08dc,0x3f8008dd}},	//   suoj, órym_, vito, šiu_
  { {0x660a0058,0x3eb808de,0x3c760009,0xbf6b0030}},	//   safk, hort_, יתֶם_, _šíři
  { {0x200b08df,0xc3270012,0x9e660239,0x8aa608e0}},	//   vaci_, لكين_, _квад, ирод
  { {0xc3330093,0xab5b000f,0x44ea001a,0xba180003}},	//   קות_, _szük, _tù_, ديدا_
  { {0xfc660014,0xa446022a,0x25eb0011,0xf27b0009}},	//   _вълн, _внед, _चलती_, דריש
  { {0x859b000b,0x6d41003a,0x80a40012,0x38bc0030}},	//   _בשבו, çlam, ْمَن, píru_
  { {0x2bd20037,0x200b08e1,0xdbe50012,0xd6b70012}},	//   देशा, raci_, _اسمً, لإسب
  { {0x6f1d0052,0xda660003,0x4b7b0009,0x92b30012}},	//   rrsc, _خاصي, _באדו, _وحوا
  { {0xbc0704ad,0xddcf0010,0xfce90012,0xacf70012}},	//   ичай, ūdži, افري_, ؤسست
  { {0x320c01bd,0xe58b0009,0x7e200011,0x7d1a0097}},	//   lady_, דָמָ, बलॉग_, átsa
  { {0x22840163,0x6a15003c,0xc2c50012,0x3b540024}},	// [e10] _söka_, ймау, ميري, октр
  { {0x6d5a00a2,0x78a90027,0x929d0002,0x60c208e2}},	//   _orta, _sjev, bsłu, elom
  { {0x7ed40003,0x78a90027,0x2967004c,0xa167004c}},	//   _بزيا, _pjev, шњав, шњак
  { {0x2547000e,0x24800404,0x291e0028,0x320c0042}},	//   _ről_, ckim_, irta_, hady_
  { {0xfd4c001a,0x26c3009b,0xa01b0052,0xd00e0012}},	//   _thiể, oljo_, rhöh, رلو_
  { {0x52850003,0x7bda000b,0xc0b90066,0x2ee90060}},	//   _السك, _תקשו, _žádá, _muaf_
  { {0xbe3c000b,0x6d5a001b,0x62060031,0xf2d20009}},	//   דעות, _crta, örlő, _זעם_
  { {0xfc310003,0x764308e3,0x8c490198,0x63a40073}},	//   سحب_, seny, упив_, _žina
  { {0x6d5c0065,0x291e08e4,0x752300b8,0x66c00248}},	//   _áran, erta_, sunz, söki
  { {0xf6740003,0x2547000e,0x16380003,0x8e740003}},	//   _والخ, _től_, _نسمة_, _والض
  { {0xd945005c,0x3eb80028,0x05790012,0xd00a08e5}},	//   щени, vort_, _حماة_, лене_
  { {0xb7bd007d,0x3eb80052,0x44290034,0x3cd5003c}},	//   _acţi, wort_, jga_, _ужес
  { {0x42d5002d,0x442904f6,0x3eb808e6,0x291e08e7}},	//   _ліку, dga_, tort_, arta_
  { {0x201e08e8,0x442908e9,0xdb4e0012,0x7bcb08ea}},	//   şti_, ega_, _أَو_, _izgu
  { {0xe8f5000a,0x70f50003,0x80f50003,0x3eb80422}},	//   _استخ, _استئ, _استض, rort_
  { {0x442908eb,0xdb230028,0x6f04002a,0x27e002a1}},	//   gga_, _þróu, _twic, žini_
  { {0xf8b3000b,0x7c360028,0x7c290347,0xc4d20009}},	// [e20] _משה_, rfyr, iger, לגל_
  { {0xa96a010c,0xb05b08ec,0x7c360097,0x216a0337}},	//   лиза_, nlän, sfyr, лизи_
  { {0xd6db000b,0xc693000b,0x6608009b,0xd5b8001e}},	//   _תחיל, _מאז_, _redk, ļās_
  { {0x7c290227,0x3ea70032,0x2cbd010f,0x53a608ed}},	//   jger, ennt_, _nkwd_, _гамб
  { {0x4cbb000b,0xe7f90011,0x60c208ee,0x68fb08ef}},	//   _תזכו, ंडता_, rlom, _čude
  { {0x44ee0020,0xfd65001a,0x010a0012,0x4f650012}},	//   _ký_, _nguồ, _مترو_, تامف
  { {0x9986000a,0x7c2903de,0x27e900eb,0x50f80009}},	//   _الأو, fger, žana_, _כִּד
  { {0xbca40012,0x7ead0064,0x7c2908f0,0x629e08f1}},	//   تمعي, tĺpc, gger, lipo
  { {0x44ee0020,0xf3ef0003,0x77860001,0xa3d80037}},	//   _lý_, رأي_, _улаз, ाधि_
  { {0x3377000b,0x2732000d,0x326a0012,0x326608e0}},	//   צעים_, mân_, احةً_, стив
  { {0x44ee0065,0x85f7000b,0xfdf70009,0x3abb0009}},	//   _ný_, _הצבע_, _הצבת_, רמינ
  { {0xc173000b,0x629d0025,0x320c08f2,0xa3d80011}},	//   לחת_, ésor, sady_, ाधा_
  { {0xeb970015,0x937a0012,0xff040048,0xa4b70009}},	//   _лиц_, _حصار_, зясн, _פלדה_
  { {0x8bd7000b,0x44ee0028,0xcf930009,0xa2d30012}},	//   _הודו_, _bý_, לטר_, _فينت
  { {0x40350406,0x2732001a,0xf5180009,0x54450012}},	//   _дейс, hân_, יֵּל, ينسك
  { {0xcd02003e,0x18a40001,0x98a40001,0xa01b006f}},	//   mość_, _најм, _није, ehöv
  { {0x660e00c6,0x24580015,0x41e70003,0x442908f3}},	// [e30] babk, щать_, مساف, rga_
  { {0xf09f0054,0x4429002c,0x9e0700a6,0x629e0818}},	//   lià_, sga_, _учил, gipo
  { {0xcd02003e,0x442900b0,0x7ce70060,0x94d50012}},	//   ność_, pga_, _hırv, _ويخش
  { {0x17fb0003,0xf8c90037,0x50c90011,0xf09f01a0}},	//   ارضة_, रतिय, रतिष, nià_
  { {0xf1050044,0xd5e5002d,0x2732001a,0x6c560009}},	//   _शब्द_, ожли, gân_, _וירא_
  { {0xcd02003e,0x451905cc,0xee38002d,0x629e0018}},	//   kość_, ация_, йні_, cipo
  { {0x64830051,0xf6960012,0x2ca908f4,0x7c2908f5}},	//   _lõim, تنوع_, onad_, tger
  { {0x2ca90005,0xa2b90037,0xf1c30066,0x7afb08f6}},	//   nnad_, ्तव्, _liší_, tput
  { {0x6497004b,0xf09f01a0,0xb05b0245,0x68ea0032}},	//   nţii, dià_, tlän, _aufd
  { {0x78ad0051,0xe2990001,0x8fa40003,0x7c2908f7}},	//   _ajav, рао_, _عمله, sger
  { {0x63a4014d,0x9f460065,0xb9c50003,0xddab0015}},	//   _þinn, lboð_, تقدي, _стал_
  { {0xfd10000a,0x200f0051,0x61fc003a,0xc156000b}},	//   _أجل_, nagi_, ırla, קשרו_
  { {0xc1c601e1,0x61c601e1,0xe73a0001,0x3b09020e}},	//   _वर्ग, _वर्ष, јег_, _тело_
  { {0x200f0101,0xb7da000b,0x66c0004a,0x3f8c0002}},	//   hagi_, יקרי, yöku, ądu_
  { {0x200f0051,0x3f840029,0x7aeb0028,0x1d0a0538}},	//   kagi_, šmu_, _hugt, реби_
  { {0x07a6002d,0x08c30014,0x90c305cc,0x2ca9006f}},	//   _майн, _общн, _обще, gnad_
  { {0x200f0005,0xc6d60012,0xf1fa0012,0x2002005e}},	// [e40] dagi_, _وتخت, لعات_, mbki_
  { {0x66c00028,0xa01b0032,0x78ad04e5,0xb6a6003c}},	//   töku, nkön, _zjav, _фиол
  { {0x68e40051,0x4fea01de,0x57ea06bd,0x6497004b}},	//   _kiid, амен_, адем_, aţii
  { {0xd7f00003,0x7f860003,0x7ae308f8,0x10a30048}},	//   ركت_, يلان, _lint, михн
  { {0x6497000d,0x2732001a,0xcd020002,0x6d4108f9}},	//   cţii, uân_, zość_, _apla
  { {0x68e40005,0x63a4007a,0x05760003,0xddc1009b}},	//   _liid, _žino, قاعد, _dolž
  { {0xa2b90037,0x200f00b6,0x41180009,0x6e030012}},	//   ्तर्, bagi_, _לֵּא, ذِين
  { {0x69ce012e,0x68e40006,0xd1970009,0x9c7c001b}},	//   _izbe, _niid, _וכלי_, _kuči
  { {0xcd02003e,0xc4d3000b,0xd7ef0003,0x0a6a0294}},	//   wość_, וגה_, _شكل_, арни_
  { {0x5a340014,0xa5f70001,0xcd020002,0xc217002d}},	//   чнот, _међу_, tość_, оєю_
  { {0x7ae3007d,0x15fb0011,0x21660024,0xec4a0048}},	//   _dint, ्रसर_, ітог, _взел_
  { {0x57f40098,0x7ae308fa,0xcd020034,0x320a0034}},	//   мпют, _eint, rość_, źby_
  { {0xb4c80037,0x98b30027,0x5f940014,0x987400b3}},	//   ोगी_, žeća_, дият, фляц
  { {0x648303fb,0x199400ac,0xaa570012,0xcd370012}},	//   _võim, _наля, _ولنا_, يرزب
  { {0x80da0037,0x66cd0029,0x2d850107,0xb05b08fb}},	//   बगाइ, núka, ále_, lläm
  { {0xbca5000a,0xd7fb0098,0xe5710009,0x672208fc}},	//   أمري, _тук_, עַם_, kroj
  { {0x50d40003,0x53340014,0xcb340014,0x787a0009}},	// [e50] _تزور, метт, метъ, _הָיו
  { {0xd251000a,0x64830005,0x200f0034,0x6497004b}},	//   عنا_, _kõik, wagi_, rţii
  { {0x61550012,0xb05b008e,0xdcef0035,0xdcf80035}},	//   ثنائ, yläl, ēdēt, izvē
  { {0x78bd004a,0x66c0006f,0x63ad0028,0xa2cb0011}},	//   nosv, sökt, _þang, _तीर्
  { {0x64830005,0xae1f0037,0x6d5c000e,0xaf040024}},	//   _lõik, _बयान_, _áraj, дпіл
  { {0x7bda000b,0x5b7a000b,0xe7e30037,0x442f08fd}},	//   _לקרו, _הרשא, _गणना_, _scg_
  { {0x20020002,0x661a0002,0xbf0b0037,0xe9180024}},	//   ybki_, ótki, _सौरभ_, _морі_
  { {0xddc70029,0x69c30002,0x6d41009b,0x7c2d08fe}},	//   rejň, _ryne, _vpla, ngar
  { {0xec79001a,0x2d8a0032,0x86c50012,0xbf670012}},	//   _độc_, _üben_, _فيرن, _بدأو
  { {0xc879003a,0x8c3d003a,0xee780003,0x64ac003a}},	//   _hoş_, dişe, _وصلت_, eğil
  { {0x6d4108ff,0x6b890034,0xb05b008e,0x2d980097}},	//   _upla, _żegl, lmäy, _þrep_
  { {0x628a000f,0x2eb60037,0x7cd90015,0x2eb40011}},	//   _elfo, ृत्त, _умер_, ंक्त
  { {0x44f10900,0x442d003a,0x68e40269,0x1eaa0012}},	//   _há_, mge_, _viid, ماسي_
  { {0x8afa000b,0xaa41004a,0x12fa000b,0x24f60024}},	//   _הפסק, ärää_, _ההסב, зчар
  { {0x44f10901,0x62860035,0x27ed0902,0x20d20031}},	//   _já_, īkot, žena_, táid_
  { {0x768f0033,0x66c0004a,0x201e0010,0xb97a0009}},	//   _høyd, töks, ėtis_, _לנצי
  { {0xbae60003,0xcb67046d,0x2ca0005e,0x44f10903}},	// [e60] سكاي, пате_, riid_, _lá_
  { {0x78ab0073,0x6d5e03a7,0x66c00031,0xa01b008e}},	//   engv, _trpa, röks, hköl
  { {0x44f10065,0xf67b000b,0xc879003a,0xc4cb0037}},	//   _ná_, _האימ, _boş_, ाताओ
  { {0xc879000d,0x6aa10052,0xa01b0245,0x67220904}},	//   _coş_, hilf, lhör, troj
  { {0x27e00006,0xd00f0003,0x442d0905,0xd7e30024}},	//   äin_, اله_, dge_, нішо
  { {0x62850906,0xab5b0031,0x6d5c0907,0x29180031}},	//   ckho, _ezüs, _árak, árak_
  { {0x6d5c00bd,0x44f10908,0xd9430909,0x9c83090a}},	//   nvra, _cá_, _пери, ščev
  { {0xd00f000a,0x26c7017b,0x442d090b,0x64490032}},	//   _ملف_, alno_, gge_, geei
  { {0x7690004a,0x3d080011,0xa08b0009,0x7ce70060}},	//   _käyd, _सबके_, _פְלִ, _sırt
  { {0x44f10065,0xaabe0037,0x46a30129,0x442d090c}},	//   _fá_, ्तिक, _заув, age_
  { {0x6f090052,0xe8e0001a,0xf2370009,0x3a370009}},	//   _zwec, _ngồi_, הריץ_, הרים_
  { {0xab2a0047,0x64830005,0x66cd0029,0xdce30073}},	//   _года_, _võik, núkn, dynė
  { {0x4abe0044,0xac970003,0xaabe0037,0x2bdb0037}},	//   ्ताव, _عنها_, ्ताक, मेदा
  { {0x7bdb000b,0x6720000e,0x2ee50052,0xee2e0024}},	//   _הקדו, ámja, ölf_, внi_
  { {0x2a3b000b,0xd23b000b,0x9a3b000b,0xdb1d0066}},	//   _העומ, _הגול, _התוק, _vysí
  { {0x718b0009,0xacfb0009,0x98620034,0x79850012}},	//   _לְחַ, מהלכ, _róć_, _تؤهل
  { {0x6497000d,0x768f0119,0x9cd70009,0x389c0009}},	// [e70] cţiu, _høye, לולה_, _ליהנ
  { {0xedf80044,0x6ce7002d,0xd1380073,0x47340012}},	//   ुरोध_, _німе, otą_, _أريز
  { {0xd138007a,0xc5fb0037,0x7bc60028,0xc0cb0560}},	//   ntą_, ्रीय_, _eyku, буде_
  { {0xd138007a,0x44f10074,0xe9d00012,0x99d40012}},	//   itą_, _rá_, اغك_, رتلا
  { {0x2d83007a,0xb8f40037,0x44f1090d,0xef180024}},	//   lyje_, _सी_, _sá_, змі_
  { {0xd1380010,0xf62b0024,0x17580009,0x7e2b0024}},	//   ktą_, сіди_, פסור_, сіда_
  { {0x442d0663,0x2d830010,0x2d8a0032,0xb05b008e}},	//   tge_, nyje_, _übel_, smäy
  { {0xdbf10013,0x44f1090e,0x78a201bd,0x05760012}},	//   přík, _vá_, ciov, ظمية_
  { {0x2bb90012,0x64490132,0xdfd10012,0xa01b090f}},	//   غابة_, reei, _شيئ_, rköl
  { {0x38690054,0x27360028,0xe299002d,0x6d450910}},	//   _anar_, væn_, іан_, _opha
  { {0x672b0028,0x442d006f,0x91f60009,0xd1380073}},	//   lugj, pge_, ומתו_, gtą_
  { {0xe73a0015,0xa06a0001,0x7afd0051,0x186a01ec}},	//   оем_, цама_, _otst, цами_
  { {0xd1380911,0x2cad0912,0x6d450913,0x883a00af}},	//   atą_, mned_, _apha, חתרו
  { {0xdce30010,0xcb120009,0x6497004b,0xdbc70097}},	//   tynė, _ילד_, rţiu, _röði
  { {0x2cad002a,0x6d4e0070,0x2d830010,0x7afd0259}},	//   oned_, uwba, gyje_, _atst
  { {0x6d5c006f,0x69da0017,0x6497000d,0x6c550024}},	//   rvra, _útei, pţiu, нтує
  { {0xa01b006f,0x2cad021b,0xab5b000e,0xae0d0011}},	// [e80] phör, ined_, _szür, हरान_
  { {0x2cbf00bd,0x0caa0011,0xdddc0159,0x2cad0030}},	//   houd_, _छद्म, akrš, hned_
  { {0x63a90065,0x994a0003,0x74f60012,0x7bc60034}},	//   _þenn, تلال_, _تأخذ, _wyku
  { {0xd12f0012,0x5ca60198,0x7df80011,0x6abe0032}},	//   ؤمن_, _цимб, ुर्ग_, sopf
  { {0x7e7a001c,0x7690004a,0x9b030048,0xd1380034}},	//   _potp, _täyd, _изяд, ztą_
  { {0xccfa0001,0xd1380914,0x2f970009,0x67260097}},	//   оћи_, ytą_, וכנן_, irkj
  { {0xdd900003,0x98a60237,0x68fc0159,0x2a5700af}},	//   طوة_, _живе, _utrd, _קבלן_
  { {0x2cad0036,0xc19b0009,0x399b0009,0xb19b0009}},	//   gned_, _ושלי, _וילד, _וילכ
  { {0xb05b0248,0x8c43004c,0xdd310034,0xe61a052c}},	//   släk, тење, węże, _мда_
  { {0x3254002d,0x6f020164,0x60c40010,0x69cf0034}},	//   хвор, mpoc, _akim, ęcen
  { {0x60f8002d,0xd1380073,0xa3ba0011,0x67260097}},	//   яння_, utą_, _आँक_, erkj
  { {0xd1380915,0x6483005e,0x2d830073,0x3b8604a5}},	//   rtą_, _hõiv, vyje_, _олег
  { {0xd1380916,0xa7740024,0x6497004b,0x27ed05a5}},	//   stą_, вляч, rţit, ženo_
  { {0x2d830010,0x3b53002d,0x61560012,0xd1380073}},	//   tyje_, _шкір, _ينشئ, ptą_
  { {0x7aef0026,0x72330012,0xfa330012,0x7ce70060}},	//   íctv, _شروط, _شرود, _kırp
  { {0xbf35002d,0x2d830010,0x20c7005e,0x6483005e}},	//   _знищ, ryje_, lõiv_, _lõiv
  { {0xa01b008e,0x9f630248,0x22580917,0xac180024}},	// [e90] hkök, åväl_, _bark_, ьоту_
  { {0x2d83007a,0xd3370009,0xdcee0030,0xfc3f0030}},	//   pyje_, ורמה_, íděn, _ajít_
  { {0x22580918,0x49d40009,0xb05b008e,0x38b90919}},	//   _dark_, תֵּן_, eläi, wéry_
  { {0xc87900a2,0x3cfe000f,0x38690164,0xdfd10012}},	//   _kişi_, ítve_, ñar_, هيا_
  { {0xfc3f000f,0x2258003a,0x69c70002,0x7afd07c7}},	//   _amíg_, _fark_, _wyje, _utst
  { {0xaa45004a,0x2cad002a,0x66cd0029,0x05550048}},	//   ävää_, wned_, rúko, етия
  { {0xc2c40003,0x3f890010,0x20e80060,0xafdb00b0}},	//   _شيفي, šau_, _işin_, rdøy
  { {0x44f5091a,0x8c3d000d,0xa3ba0011,0xa2b90011}},	//   _må_, fişa, _आँख_, ्तक्
  { {0x2cad0036,0xff280003,0x27ed091b,0x66150064}},	//   rned_, _يكفي_, _igen_, kazk
  { {0x17fa0037,0x8fa4004c,0x4105091c,0x60c4091d}},	//   ूर्व_, _рађе, нзов, _skim
  { {0x68e9003e,0x44f5091e,0xd8d90009,0xa9690281}},	//   _kied, _nå_, ּקָר, чина_
  { {0xf1b20009,0x62880132,0x2d51001b,0xddc80030}},	//   רסט_, akdo, _iše_, _nadř
  { {0xeb8e091f,0xb3870003,0x8c3d000d,0x6497004b}},	//   _си_, _تجاه, cişa, bţir
  { {0x2006000d,0x24890920,0x443f0921,0x02440012}},	//   zboi_, ekam_, lfu_, _لَهَ
  { {0xceb2000b,0x6f02003e,0x7bcb0052,0x27ed0070}},	//   אים_, zpoc, ügun, _ogen_
  { {0x44f50163,0x63a40010,0x68e90546,0x644d0061}},	//   _då_, _žini, _nied, geai
  { {0x6d4100a2,0x67560003,0xd80b0009,0x2a390009}},	// [ea0] çlar, _أخبر, _מִיָ, ּעֲמ
  { {0x27ed0922,0x44f50923,0x6b960034,0x64590924}},	//   _agen_, _få_, rzyg, _lawi
  { {0x68e90925,0x6483005e,0x905a0009,0x44f50926}},	//   _bied, _rõiv, ּכְת, _gå_
  { {0x6459003e,0x7e7e0927,0xacfb0009,0x805b00af}},	//   _nawi, _hopp, _מהטכ, ּ֣או
  { {0x7e7e0928,0x17540015,0xde58002d,0xc0170009}},	//   _kopp, твля, далі_, תקנו_
  { {0x764e0033,0x27ed0846,0x6f630012,0x753c0929}},	//   neby, _egen_, اهوم, otrz
  { {0x64830005,0x02be0037,0x6c9a0009,0x6abe0011}},	//   _võiv, ्तीन, ּשִׂ, ्तीर
  { {0x7e7e0006,0xbd430003,0xd4970015,0x20120060}},	//   _lopp, انيي, ерь_, _neyi_
  { {0x68e30070,0x82a60015,0xd3360009,0x7e7e008e}},	//   ïnde, ешне, ׂרֵה_, _oopp
  { {0x6fb30003,0x8717000b,0xadba0003,0xd8f8002d}},	//   _إمكا, _נקבע_, _فهذا_, мної_
  { {0xf8ac001a,0xc5690003,0x66150030,0xd9170223}},	//   ưới_, _يحمل_, vazk, нья_
  { {0x64590101,0x10100037,0x60c2005e,0x753c0034}},	//   _gawi, ारिश_, noom, dtrz
  { {0xe787002d,0x44f5092a,0x547b0009,0xdfd80048}},	//   хуно, _så_, _מטאו, еър_
  { {0xa6e7008a,0x6459003e,0xd5a60003,0x15eb0024}},	//   _nhữ, _zawi, لف_, яємо_
  { {0x765a007a,0x66150002,0xa01b004a,0x7e7e092b}},	//   _maty, razk, hköi, _dopp
  { {0x39130014,0x6ca40015,0x27e90604,0xd6d90034}},	//   _смър, груж, žani_, _ppłk_
  { {0x88bc0009,0xd8080009,0xfaf30012,0x5a350048}},	// [eb0] _מזהי, _אִתָ, اثر_, кнат
  { {0x6d4800c5,0x765a0002,0x645b000d,0x21250012}},	//   _opda, _naty, zdui, َّذِ
  { {0x768f0033,0xfe9c000b,0x672f0002,0x26c30010}},	//   _nøya, _מיזמ, lucj, mojo_
  { {0x251a000b,0x351a0009,0x9d1a0009,0xd0580024}},	//   _קורא, _קורנ, _קורט, ерші_
  { {0x8416000b,0xed59001e,0x02d90012,0x673d092c}},	//   _בקרב_, āžu_, _يوجب_, ntsj
  { {0x945d003e,0x68e9012a,0x645900b6,0xf5ab0009}},	//   końc, _wied, _sawi, ּבֵּ
  { {0x68e903fc,0xd658000b,0x25f20011,0x5ff5092d}},	//   _tied, גיות_, ुड़ी_, _азбу
  { {0x2d510066,0x929d0002,0x764e0002,0xd5ae0012}},	//   _vše_, dpła, zeby, تفى_
  { {0x660c000e,0x443f092e,0x645b0227,0x2d81005e}},	//   élkü, rfu_, rdui, äheb_
  { {0x7b440003,0x23620028,0x387f0444,0x26c30073}},	//   ائيل, ækja_, _hour_, jojo_
  { {0x3ea7000f,0xe9d904b3,0x26c30073,0xb05b0032}},	//   mint_, ько_, dojo_, hläu
  { {0x387f0108,0x64830005,0x98a60695,0x7e0a0011}},	//   _jour_, _mõis, тиме, वर्ग_
  { {0xa4d4007c,0x7aea002a,0x929d0034,0x69ce0064}},	//   _соці, _fift, apła, ýber
  { {0x273b0020,0x9f9e0017,0x64ac000d,0x3ea7092f}},	//   iên_, _ação_, işie, nint_
  { {0x71640003,0x64a60014,0x2918000e,0xd0aa0012}},	//   _مايك, вава, árat_, _يطعن_
  { {0x98a6001e,0xb4be0037,0x672f0002,0xccf20009}},	//   bulā_, ेते_, bucj, שכן_
  { {0x753c003e,0x44320930,0xf4120009,0x2d980031}},	// [ec0] strz, rgy_, יפן_, szre_
  { {0x64830051,0xbab30012,0x8a030189,0x7e7e00b0}},	//   _sõit, لمقب, изуе, _uopp
  { {0xc05a002d,0xa2b30037,0x7bcb0010,0x3ea70054}},	//   діл_, _आदर्, _lygu, dint_
  { {0x387f0061,0xfbc70012,0x2db70009,0xb97a0009}},	//   _cour_, _نت_, _ילין_, ונעי
  { {0x69d5000f,0x64830051,0x929d0002,0x765a0010}},	//   _ezze, _võit, zpła, _paty
  { {0xeaa70003,0xa634002d,0x6f02003a,0x8f9b0009}},	//   _ضع_, ункі, _çocu, ויני
  { {0x387f0036,0x69c3000e,0x64b3000d,0xc5f30009}},	//   _four_, ünet, răin, סדה_
  { {0x70560012,0x765a0034,0xa01b0031,0xc7b90031}},	//   _جنرا, _waty, lköv, _időn_
  { {0xd2500003,0xee3a04f0,0xda660012,0x8c3d0060}},	//   منة_, _она_, نادي, mişl
  { {0x63a9007a,0xe3af0003,0xa01b0931,0x78a4000e}},	//   _ženk, ترى_, nköv, _amiv
  { {0x387f0274,0x63ad0028,0x20d20028,0x66d20028}},	//   _your_, _þann, ráin_, tækn
  { {0x387f014d,0xa9c3007c,0x63a4007a,0x8c3d00a2}},	//   ður_, рськ, _žinu, nişl
  { {0x26c3007a,0x90980048,0xe0df00b8,0x66d20040}},	//   tojo_, твят_, rmò_, rækn
  { {0x6fe9001e,0x2fcd0034,0x945d0034,0x996603b0}},	//   _rīcī, żego_, pońc, _атил
  { {0xc986004c,0x7c220159,0xfcc7004c,0x26c30932}},	//   _јули, _kdor, вљам, rojo_
  { {0x273b008a,0x44f80066,0x3cfe000e,0x998c0034}},	//   yên_, _mé_, ítva_, padł_
  { {0x20190933,0x30840012,0x03d5003c,0x1af40934}},	// [ed0] masi_, _خليف, ужаю, иптя
  { {0x7e55007c,0x3ea7000e,0xb05b0052,0x20190935}},	//   _своє, _önt_, rläu, lasi_
  { {0x387f02b5,0x76900006,0xb6020066,0x68ed000e}},	//   _pour_, _käyn, čáte, _kiad
  { {0x64830051,0xdb1d004a,0x5f950014,0x05b60037}},	//   _võis, _pysä, лиет, _अख़ब
  { {0x9cd6000b,0xb05b004a,0x60080024,0x389c0009}},	//   _תורה_, lläs, тнім_, ויאנ
  { {0x645d00c6,0x0ccb0044,0x273b0020,0x2bc60037}},	//   _hasi, ात्म, rên_, _लड़ा
  { {0x20190889,0x41e4002d,0x387f0936,0x3ea70937}},	//   kasi_, _віта, _tour_, rint_
  { {0x2366001c,0x799a0002,0x25d8000b,0x20190938}},	//   _broj_, dztw, כוון_, jasi_
  { {0x7c840001,0x201901b7,0x645d0939,0x69da093a}},	//   рује, dasi_, _masi, _úter
  { {0x6eda0011,0x44f8093b,0x85a7004c,0x2019004b}},	//   _पीपु, _fé_, _ијед, easi_
  { {0x8c3d00a2,0xe4350012,0xb05b008e,0x2019093c}},	//   lişm, _مفاد, ylät, fasi_
  { {0x2019093d,0x645d093e,0xa9880009,0x98a40073}},	//   gasi_, _nasi, דָשִ, įjį_
  { {0x7bcb00a2,0x68ed093f,0x8c1a0009,0x29180097}},	//   _uygu, _diad, _נוסי, árar_
  { {0xed5a0046,0x248d0066,0x2905006f,0xc7d6000b}},	//   ног_, lkem_, ppla_, טורי_
  { {0x98a6000d,0xceb20009,0xa2ba0009,0xd6cf0012}},	//   gulă_, ציל_, _אמסט, سقف_
  { {0x6abe0037,0xa3ea0345,0x1bea0345,0x64a300b5}},	//   ्त्र, едба_, едби_, баса
  { {0xab660015,0x6b9b0052,0xb05b0248,0xceb60012}},	// [ee0] ывал, nzug, rlät, _محدث
  { {0x248d0005,0x645d002a,0xdde40031,0x39580035}},	//   hkem_, _easi, űrűs, _psrs_
  { {0x645d00c6,0xc1ba0012,0xb05b0032,0x4422016d}},	//   _fasi, رائط_, plät, _tdk_
  { {0x2d8a0073,0x645d0940,0x63b60097,0x44f80941}},	//   mybe_, _gasi, _þyng, _ré_
  { {0x248d0066,0x8c3d003a,0x44f80942,0x66180943}},	//   dkem_, rişl, _sé_, tavk
  { {0x4ab80011,0xbb43004c,0xfaa6004c,0x39580073}},	//   _आदिव, _ћерк, _саго, _tsrs_
  { {0x2019003a,0x7afd0066,0xc0aa0012,0x9a670012}},	//   yasi_, ístn, _كارل_, _حمّل_
  { {0x100a0003,0x27ed0944,0x2b400945,0x6b9b0032}},	//   _سترى_, ženi_, otic_, fzug
  { {0x68ed0026,0x36360003,0xb05b0052,0x7b760003}},	//   _riad, _مراس, klär, اطعا
  { {0x201900b6,0x44f80946,0x171b0009,0xcb570009}},	//   wasi_, _té_, _נובע, נסיה_
  { {0x20190947,0xd0110003,0x6df30012,0x98b40060}},	//   tasi_, يلد_, _اكما, çeği_
  { {0x68e200c5,0x23b40037,0xbb560012,0xdd8f0012}},	//   nmod, ंपाद, _منصب, _عون_
  { {0x201900c6,0x6f1d0052,0x2ca60058,0x96f80048}},	//   rasi_, ussc, _imod_, леят_
  { {0x68ed003e,0x20190947,0x2563003a,0x3eaa0052}},	//   _wiad, sasi_, _yıl_, gibt_
  { {0x645d039c,0x6f040948,0xa2ba0037,0x7690004a}},	//   _pasi, _etic, ्वन्, _täyn
  { {0x75280029,0xb05b0052,0x24580109,0x69d80949}},	//   ádza, rläs, лась_, _izve
  { {0xfbd00003,0x291e001e,0xda15004c,0xbae50012}},	// [ef0] كتك_, lsta_, идањ, لكري
  { {0x291e094a,0x248d0030,0x60c9094b,0x8bd70009}},	//   osta_, zkem_, _skem, רומו_
  { {0xb9b50003,0xd5fa0009,0x41550048,0xda4b0009}},	//   جماع, _בפתר, рвес, עֲמָ
  { {0x765e003e,0x291e094c,0x3cfb0037,0x20cb0012}},	//   _zapy, ista_, _लंबे_, رباي_
  { {0x8c1a0009,0x889c0009,0xd9d10011,0x248d0030}},	//   _בורי, עבדי, _हर्ट, vkem_
  { {0x83fd000e,0xab66001e,0x291e094d,0x68e20328}},	//   zdőd, _daļē, ksta_, amod
  { {0x291c0013,0xd6180003,0x248d094e,0xb6380009}},	//   ávat_, اتها_, tkem_, ארוס_
  { {0xcf270003,0x27e50002,0x06b10066,0x03250373}},	//   _مرئي, ślny_, _řídí_, адин
  { {0x67d4002d,0x8c3d003a,0x291e094f,0xd2990024}},	//   _готу, lişk, esta_, втні_
  { {0x3945002d,0x7aa50014,0x78ab0950,0x6b9b0052}},	//   аног, риоз, ligv, rzug
  { {0xe0da0098,0x291e0951,0xade10037,0x3941002a}},	//   кво_, gsta_, गेशन_, nths_
  { {0x78ab0227,0xd3710012,0x29030035,0x26c70952}},	//   nigv, _وها_, īja_, lono_
  { {0xe28e0953,0xa856000b,0x5ea60003,0x291e0954}},	//   _да_, בירה_, لمحل, asta_
  { {0x539a0009,0x91e50955,0xf5060048,0x68e20956}},	//   _בינו, _коле, изго, zmod
  { {0xcce60012,0xc8b6003c,0x26c700b8,0x3da70048}},	//   لسري, _вспы, iono_, акро_
  { {0x77860014,0x99d40003,0x19ba0009,0x91ba0009}},	//   _влиз, _اتها, _במצב, _במצי
  { {0xd6d20003,0x6f040027,0x7ed6002d,0x0c370012}},	// [f00] _وقع_, _utic, _вінч, شكلة_
  { {0xf9920003,0x3860002a,0x7690004a,0xb7db000b}},	//   يبا_, _hair_, _käym, _בקפי
  { {0x26c70957,0x661c0958,0x20d90017,0x867b0009}},	//   dono_, mark, léia_, _סרטו
  { {0x69ce00f1,0xfc320012,0x351b0009,0x50460959}},	//   _vybe, _بحد_, _בוטנ, редб
  { {0x4733002d,0xdfcf0003,0xe7370148,0x91fc0035}},	//   жніс, ويم_, иец_, ndāc
  { {0x628301a2,0x44fc001a,0xc7d70009,0x454a0024}},	//   _nono, _kí_, בוני_, вчим_
  { {0xb87b0013,0x44fc0066,0xc0e60024,0x66d20097}},	//   dmín, _jí_, _вовк, tækj
  { {0x6d5a009b,0xd5b1001a,0x44fc095a,0xd706004d}},	//   _vsta, _séc_, _mí_, _взаи
  { {0xa2c20044,0x389b000b,0x6d5a0002,0xdc8b0009}},	//   रकल्, _סימנ, _wsta, דְיָ
  { {0x7f3b0093,0x661c00b6,0x291e0051,0x6283095b}},	//   _בעמו, jark, tsta_, _cono
  { {0x09f70093,0x99f7000b,0x44fc0066,0xd1380002}},	//   ימים_, יזיה_, _ní_, dząc_
  { {0x28a7002d,0xdcee0010,0x291e095c,0xe53b0009}},	//   ршог, mybė, rsta_, _יתבר
  { {0x44fc0017,0x3860003a,0xdc9b0009,0xd36f0012}},	//   _aí_, _dair_, _ביאל, _يهم_
  { {0x44fc001a,0x7dc70003,0x27fe0066,0x29860015}},	//   _bí_, لتأك, ětna_, _выиг
  { {0x3f420020,0x4426095d,0xaadb0009,0x3860095e}},	//   _lưu_, _kdo_, _שחור, _fair_
  { {0x316d009b,0x26c708b2,0x897b0009,0xd49805c6}},	//   _čez_, zono_, _ירוצ, ару_
  { {0x26c700b6,0x7de0000e,0x24580021,0x7cf50010}},	// [f10] yono_, tásé, шать_, _išre
  { {0x8c3d003a,0xdcee0010,0x9967095f,0x539b0009}},	//   tişk, kybė, ител, דימו
  { {0x161a0044,0x26c700c1,0x29c80003,0x629a019a}},	//   _नज़र_, vono_, لِكَ_, ihto
  { {0x3f42001a,0xa1770009,0xb4c00011,0x27ed001b}},	//   _bưu_, יעבד_, ंको_, ženu_
  { {0xcc76000b,0xf7490012,0x97a7004c,0x6f650012}},	//   _הערה_, التي_, јрел, إهتم
  { {0xee38007c,0x1af6000b,0x24510081,0x39410132}},	//   ині_, _למשל_, _ạm_, pths_
  { {0x26c701a2,0xb9950003,0x99850003,0x05790003}},	//   rono_, _الأب, _الزو, امعة_
  { {0xa8a4007c,0x629a0006,0x45b8000b,0x2db8000b}},	//   _друк, ehto, יפול_, ילון_
  { {0xdd3b0002,0x26c70960,0x02190024,0x1306003c}},	//   ląże, pono_, лінь_, бный_
  { {0x38600017,0x66d20058,0xafdb0260,0x02450012}},	//   _sair_, rækk, rføl, حَدَ
  { {0xb5a70014,0x661c03ec,0xb87b00d9,0x1c170011}},	//   _трай, vark, rmín, तराल_
  { {0x160b0044,0xafdb0033,0x661c0961,0x628300b6}},	//   _स्तर_, pføl, wark, _wono
  { {0x2d8a008b,0xafdb00c5,0xdee6002d,0x44fc0962}},	//   _über_, lføj, йоми, _sí_
  { {0x20d90017,0xde0300ac,0x66030232,0x2cad041d}},	//   réia_, зпри, зпра, lied_
  { {0x69a70037,0xd1380002,0x753c0052,0x201d0963}},	//   _टेली, rząc_, _ärzt, kawi_
  { {0x44fc0964,0x661c0738,0x201d0002,0x2cad002a}},	//   _ví_, sark, jawi_, nied_
  { {0xc9f6000a,0xd4670104,0xb226002d,0x42260024}},	// [f20] مساع, щите_, ймал, йдав
  { {0x78100037,0xe8100037,0x4b230024,0x9b930012}},	//   ार्क_, ार्थ_, ямув, ألكت
  { {0x32180036,0x3f42001a,0xcad60009,0x600a0313}},	//   _very_, _sưu_, צועת_, гнем_
  { {0xdcee0010,0x30a5002d,0x87260012,0xe81a0012}},	//   vybė, орів, معتم, ازات_
  { {0x6d43001a,0x6456003a,0x2cad002a,0xb8650012}},	//   etna, meyi, died_, تالو
  { {0xa01b0006,0x645600a2,0xdcee0010,0x24800027}},	//   hköp, leyi, tybė, ljim_
  { {0xf653000b,0x2cad0965,0x1ea90012,0xd6390024}},	//   פצה_, fied_, جاني_, рячі_
  { {0x645600a2,0xad1b0009,0x83660012,0x9d1b0009}},	//   neyi, אוקר, مدخل, אוקט
  { {0x6d690039,0xc3270003,0x8e3a0003,0x9e3a0003}},	//   _īpaš, مكين_, _مسار_, _مساء_
  { {0x6fb30003,0x32180029,0xddc50029,0xd25a0294}},	//   _عملا, úry_, _zahŕ, уци_
  { {0x2cad00bd,0xa055002d,0x7e7e0028,0x6d430227}},	//   bied_, овні, öppu, ctna
  { {0x661a02bd,0x91bb000b,0x63bb0097,0x8c3d0060}},	//   _hetk, רמטי, _þung, yişi
  { {0x27ed004a,0xbfab0001,0x67240027,0x9f600097}},	//   äen_, утне_, _cvij, ýrðu_
  { {0x67240027,0xd357000b,0x95cb0014,0x0dcb0345}},	//   _dvij, _לידי_, губа_, губи_
  { {0x321e0966,0xceb30009,0x59cf0011,0xc2ed0030}},	//   maty_, ליש_, _सुपर, řící
  { {0x8c3d00a2,0x3eae0967,0xc7ab0012,0x97270024}},	//   tişi, hift_, _مدخل_, _льод
  { {0xfbd30003,0xf8b40009,0xaae70012,0xd5b10081}},	// [f30] ستر_, _משק_, مسئو, _nén_
  { {0xe718000b,0x8c3d003a,0x95c50012,0x661a0968}},	//   _החזר_, rişi, _ويظه, _netk
  { {0x6f160002,0x67240864,0x32010969,0x79590048}},	//   _zwyc, _zvij, rchy_, риер_
  { {0xd7d50001,0x2d81005e,0x228f0060,0x29070035}},	//   ожењ, ähem_, _sıkı_, īna_
  { {0x7ff40003,0x64ac003a,0xf1cf0011,0x9f040012}},	//   أسما, işil, _सुनन, كونو
  { {0x8cab0011,0x321e0030,0x66d20097,0x999e0073}},	//   _जगहो, jaty_, tæki, netų_
  { {0x7d020029,0x4109000b,0xcd280012,0xc9090009}},	//   _čosk, _כִּ֣, مسين_, _כִּ֛
  { {0xcd98000b,0x1305076b,0x76b20034,0x6d410060}},	//   מדות_, озим, głyb, çlay
  { {0x6287001c,0x6d43096a,0x7e61096b,0x2cad096c}},	//   _kojo, stna, _talp, ried_
  { {0xa9250047,0x6456003a,0x52a900bb,0x03780009}},	//   одол, zeyi, рвом_, מתחת_
  { {0x67240027,0x2cad002a,0x69c6003a,0xf769000b}},	//   _svij, pied_, şken, _שק_
  { {0x43750012,0xdb510012,0xd7ea00b5,0x6298096d}},	//   _وهار, _يَا_, имне_, _elvo
  { {0x661a00a2,0xd5b1001a,0x8f990048,0x644900b0}},	//   _yetk, _kéo_, бърт_, mfei
  { {0xd4910020,0x2169096e,0xdc120011,0xa96906bd}},	//   ền_, _вики_, ़र्ड_, _вика_
  { {0xed5a01ef,0x6456003a,0x98c90011,0x20c90011}},	//   шов_, teyi, िकाए, िकाध
  { {0x7c3b096f,0x776d0970,0x64490971,0x6f160972}},	//   ngur, _frax, nfei, _twyc
  { {0x6724001c,0x6d5e0002,0xbb4302ad,0x52aa00a6}},	// [f40] _uvij, _wspa, метк, авам_
  { {0xd36f0003,0x6456003a,0x24920064,0x1ae30973}},	//   ضهم_, seyi, skym_, доум
  { {0x4c160012,0xa9670048,0xb80a0012,0x661a0974}},	//   _وبحس, жиха_, ليام_, _retk
  { {0x50ca0044,0xd46a0001,0x661a0975,0x6722008e}},	//   रविष, _тиме_, _setk, tsoj
  { {0x44200976,0x67220010,0x24860977,0x4e1e0011}},	//   mai_, usoj, _room_, _बजाई_
  { {0xd2520003,0x6b8b006f,0x44200978,0x96140011}},	//   _تنس_, ägge, lai_, डरेट_
  { {0x69dc001e,0x867b0009,0x80ca0011,0x71760012}},	//   _uzre, ירסו, रवाइ, _ظهرا
  { {0xc5f3000b,0x672d001e,0xe9d7002d,0xeb4a0021}},	//   ודו_, šaja, _єкт_, ачок_
  { {0xee3a002d,0x61050010,0x76b20002,0x69d502f7}},	//   _внз_, _vėle, głyc, üzen
  { {0xfa8a0015,0x20e8003a,0xfbd30009,0xcfa90012}},	//   рсий_, _eşit_, ותח_, _طاقم_
  { {0xe45a007c,0x3257000b,0xdd1c0029,0x69fb0009}},	//   _вже_, חסים_, yšše, יליק
  { {0x68fc0979,0x4420097a,0xd0060012,0x7658008e}},	//   _murd, jai_, عل_, levy
  { {0x61010039,0x7cf50010,0x3866097b,0xff040048}},	//   _vēla, _išra, idor_, дясн
  { {0x2455001a,0x6f790009,0xdee70012,0xbb3b00af}},	//   _ấm_, צְרו, تأجي, _כעדי
  { {0xbae30003,0xbd680189,0x6287097c,0x999e0073}},	//   _تكوي, орте_, _rojo, retų_
  { {0x4420097d,0x90c40001,0x69ae0011,0x4815003c}},	//   gai_, _обје, ंछनी, _эмис
  { {0x1eab0003,0x8c3d097e,0xdee70012,0x28c90011}},	// [f50] _نادي_, mişt, _وأخي, िकसि
  { {0x8c3d097f,0x416b0001,0x8a370012,0x768f00b0}},	//   lişt, ијем_, تعرض, _høyv
  { {0xe9f8002d,0xddc1001e,0x44200980,0x6f090981}},	//   інці_, _valū, bai_, _stec
  { {0x68fc00a2,0xe8f8002d,0x8c3d000d,0x18a40024}},	//   _durd, ілі_, nişt, маєм
  { {0xa2ba0037,0x547a0009,0x9f050012,0x82370012}},	//   ्वश्, _הטרו, أوتو, _ورسا
  { {0x8afa000b,0xcee80003,0x20d2000e,0x12fa0009}},	//   _להשי, يرون_, láit_, _להשב
  { {0x78ad0005,0x8cc70037,0xa2ba0037,0xceb40009}},	//   _omav, ावलो, ्वर्, ויס_
  { {0x6d470054,0x7afd0982,0x54e40012,0x25bc0009}},	//   itja, _kust, وسيق, יצומ
  { {0xe3b10003,0xbf150003,0xdaa90048,0x1306003c}},	//   عرب_, _رواب, йвид_, пный_
  { {0xe2990046,0xbb760009,0x7afd0983,0x539c0009}},	//   сао_, פעתו_, _must, ייחו
  { {0x644f0002,0x76b20002,0x20d2000e,0x88ca00de}},	//   _obci, słyc, káit_, йлов_
  { {0xf9920009,0x7afd0984,0xcea900af,0xf8db05f3}},	//   גרט_, _oust, _גי_, बतिय
  { {0x7afd007a,0xd5b70020,0xf7720012,0xb4c90011}},	//   _nust, ống_, راح_, ोती_
  { {0x442000b6,0x442b0164,0x7ac4004c,0xc2c80012}},	//   wai_, _adc_, _осје, _وبول_
  { {0x7c96002d,0xd5b20003,0xe7eb0037,0x44200985}},	//   прац, رفر_, जेता_, tai_
  { {0x249f0149,0x2be20044,0x8c3d05be,0x7af50035}},	//   nhum_, _परमा, mişs, _aizt
  { {0x7af5000f,0xb89b000b,0xf1fa0003,0x883b000b}},	// [f60] _bizt, _לבקש, معات_, _התפו
  { {0x27e000a2,0x44200986,0x7afd0987,0xea1500af}},	//   _izin_, sai_, _dust, לַ֣י_
  { {0xd5fb000b,0x8dfb0009,0xcee90012,0x44200988}},	//   _לפיר, _להית, _برين_, pai_
  { {0x68fc0989,0x48a90024,0xe0d20012,0x7d7b0009}},	//   _vurd, отім_, رزا_, _הנטו
  { {0x68fc032b,0x67260033,0x6d5c000e,0x7afd098a}},	//   _wurd, nskj, _áraz, _gust
  { {0xba550014,0x4255004d,0x35d4003c,0x7c2b098b}},	//   _отсъ, _отст, молё, _adgr
  { {0xd5b00003,0x7afd0480,0xba9b0009,0xddc70034}},	//   ضفة_, _zust, _פסלי, dejś
  { {0x7de7000f,0x957c0002,0xc5f3000b,0xf7460086}},	//   lésé, _rząd, עדה_, _небо
  { {0x8fa3098c,0xcb67004c,0x8c3d004b,0xe4570009}},	//   _зате, зање_, vişt, ליקט_
  { {0x7de7000f,0xcb13000b,0x8f9b000b,0x7c200851}},	//   nésé, עלת_, _הימי, samr
  { {0xade80037,0x59be0011,0xdc3f0064,0x01d80012}},	//   टेशन_, ्थिर, víľk, تودع_
  { {0x290a0039,0x7bc3000d,0xdd7b0009,0x6d7b0009}},	//   ība_, şnui, _לטבל, _לאבח
  { {0x63a40070,0xd491001a,0x999e000e,0x74130012}},	//   jzin, ềm_, retű_, _أوها
  { {0x7cc100cd,0xf1be0037,0xc7b9000e,0x63a4098d}},	//   mēra, ्थान, _időt_, dzin
  { {0xa4d5002d,0x7de7000e,0x661e00b6,0x7afd098e}},	//   дові, désé, _depk, _sust
  { {0x113b000b,0x68e4000d,0xe45f0028,0x6d47000e}},	//   _התהל, _ghid, _mjög_, rtja
  { {0xa3e70037,0x69d8003a,0x83fd000e,0x0aeb0012}},	// [f70] यें_, üven, zdőo, مرئي_
  { {0x8f9c0009,0x979c0009,0xbe150012,0x92b70012}},	//   _ליחי, _לשחק, _تودع, أحرا
  { {0x2bbe0020,0x63a4098f,0x81440012,0x78bd0990}},	//   ịch_, azin, فنلن, onsv
  { {0xddc70002,0x69d50029,0xddde0027,0xa4d90024}},	//   zejś, _vyze, _uopš, _фдму_
  { {0x5f94007c,0x2fcb0012,0x7afd005e,0x07080012}},	//   ницт, حباً_, _uust, كيني_
  { {0x7a29000e,0xfbd20009,0xe5e50012,0x672d0035}},	//   _kötő, _סתם_, وثغي, šajo
  { {0x24e900fa,0x2ddb0012,0xace907a7,0x249f0602}},	//   омки_, حبشة_, омка_, thum_
  { {0x9f650029,0xb4c90037,0x759c000b,0x644d0025}},	//   _štýl_, ोते_, מיוח, nfai
  { {0x769003fc,0x7d1a000e,0xa0c40012,0xe3b10012}},	//   _käyt, átsz, _أيقو, ضرة_
  { {0xaabf0011,0xe3b6003c,0x20d20097,0x09050542}},	//   ्विक, ьбы_, jáir_, мпон
  { {0x6101001e,0x9f9c0097,0x6e230991,0x63a40992}},	//   _vēlo, læða_, manb, zzin
  { {0x7de7000f,0x7bce0032,0x69c30060,0x672600b0}},	//   zésé, ßbuc, üney, tskj
  { {0x10a3077e,0x97da0012,0x93240012,0xa3c90011}},	//   тиян, تبدأ_, _كرون, लॅश_
  { {0x769003fc,0xddc3000f,0x83fd000f,0x8afa000b}},	//   _näyt, lenő, zdől, _והסי
  { {0x67260993,0x1d070430,0x768f00b0,0x443f0994}},	//   sskj, деси_, _høys, ogu_
  { {0x443f0995,0xe1640012,0x672901e3,0xf9900012}},	//   ngu_, _أدوي, _ovej, _حبه_
  { {0x7de7000f,0x9f440006,0x661e003a,0x6e2300b6}},	// [f80] tésé, ämä_, _tepk, kanb
  { {0x236f0065,0xe1f20003,0x63a40996,0x97370009}},	//   ægja_, نسا_, rzin, _קריא_
  { {0x7de7000f,0x765c0002,0x48660014,0x8e7b0009}},	//   résé, mery, дълб, _וניה
  { {0x7de7000e,0x38ab0002,0x765c0997,0x753c0034}},	//   sésé, _górę_, lery, murz
  { {0x9f9c0028,0x7c240998,0x7de70031,0x61050073}},	//   gæða_, mair, pésé, _vėla
  { {0x6283004a,0x443f0999,0x7c24099a,0xc3330009}},	//   önot, egu_, lair, _בוש_
  { {0xa01b0028,0x5ee90009,0xd826004c,0x6026004c}},	//   fjöl, הַקְ, _одви, _одва
  { {0x7c24099b,0xa01b0028,0x628a099c,0xddde0002}},	//   nair, gjöl, _sofo, _kapł
  { {0xd00f0012,0x63ad099d,0x68e3099e,0x000000c4}},	//   _خلق_, _žanr, înde,
  { {0x4b7b0009,0xed5a0024,0x5b7b0009,0x46130012}},	//   קאיו, _моз_, קריא, _لوكر
  { {0x3a370093,0xca37000b,0xc2370009,0xf9c60024}},	//   ורים_, וניה_, וריו_, ьщин
  { {0xe7f50037,0xa01b000e,0x1074002d,0xa1930024}},	//   ुँचा_, lköz, влюю, таюч
  { {0xfbe20037,0xb9050037,0x23e20037,0x68110066}},	//   _परिम, _बी_, _परिद, vědč
  { {0x768f0119,0x4424099f,0xdd860003,0x69ce003a}},	//   _høyr, lam_, هو_, übes
  { {0x20c70146,0x20d20028,0xa2cb0037,0x7c240440}},	//   _осиг, ráir_, सकर्, fair
  { {0x63a40010,0x690b0009,0x32d4008e,0x7ce50018}},	//   _žiny, _וּזְ, käys_, córd
  { {0xfbd0000a,0xf8bf015d,0x644d0061,0xba2b0003}},	// [f90] لتك_, mné_, rfai, قسام_
  { {0xfd5e0020,0x386909a0,0x9f9c0028,0xf8bf0107}},	//   _quyề, _haar_, væða_, lné_
  { {0x673d09a1,0x442409a2,0xedd50012,0x75d50012}},	//   lusj, kam_, _سيحد, _سيحا
  { {0x386900bd,0x9f9c0028,0xdbd90028,0x61d80024}},	//   _jaar_, tæða_, _fæði, ємця_
  { {0x386900bd,0x76900006,0xe0d8007c,0x6d4a0028}},	//   _maar_, _täyt, єві_, etfa
  { {0x9e64002d,0x45190014,0xa01b000e,0xc3320009}},	//   квід, пция_, gköz, _תום_
  { {0xa2cc0037,0xddde0002,0xfaf90010,0xe5760048}},	//   तकर्, _zapł, yvūs_, езщ_
  { {0x386901e4,0xfdf80093,0x6ac70044,0x2b150014}},	//   _naar_, וצות_, रक्र, ньор
  { {0xe452000b,0xf8bf0107,0x6101001e,0x9f040012}},	//   אֶת_, dné_, _vēlm, _لوقو
  { {0x5778000a,0x44240227,0xf3f9004b,0x236d06f7}},	//   _تصفح_, aam_, deţe_, rvej_
  { {0xe9d90098,0x23600034,0xe2a80012,0x765c09a3}},	//   яко_, zwij_, باين_, very
  { {0x7cc10039,0xc19a000b,0xf8bf0061,0xf649000b}},	//   mēro, פשרי, gné_, _לצ_
  { {0x38690070,0x69ce0052,0x6e210010,0xa2950024}},	//   _daar_, über, _kelb, _паді
  { {0x2cbf0051,0x2bb80003,0x78a205b1,0xddda0035}},	//   lnud_, _تامة_, zhov, _datņ
  { {0x69d8007a,0xf8bf022d,0x6b8b006f,0x7c24099a}},	//   _gyve, bné_, äggn, tair
  { {0xa01b000f,0x2cbf0051,0x673d0033,0xf8bf01bd}},	//   zköz, nnud_, busj, cné_
  { {0x7c2409a4,0xccf20009,0x26d101e3,0x69cb0060}},	// [fa0] rair, רכן_, bozo_, şgel
  { {0x32d4004a,0x0566072b,0x4a430048,0x7cc80030}},	//   väys_, _звон, лнув, měre
  { {0x7d010058,0x7c240503,0x6d4a0032,0x91e6003c}},	//   _nuls, pair, xtfa, хоже
  { {0x7690004a,0xafdb0192,0xf5370009,0x442409a5}},	//   _täys, mfør, _אנטי_, xam_
  { {0xf1d00037,0x2cbf0051,0xa01b000e,0x93fb000b}},	//   _तुरन, dnud_, tköz, _מלכי
  { {0x11d6002d,0xf8bf00d9,0x412a028b,0x6d4a09a6}},	//   _зібр, zné_, _ного_, ttfa
  { {0xb7bd007d,0xa0a6007c,0x78a20163,0xc693000b}},	//   _reţe, _завд, phov, ראו_
  { {0xa3e70037,0x4d730003,0x6d4a09a7,0x60c4017b}},	//   येक_, اطور, rtfa, _njim
  { {0x64400005,0x73d70014,0xf8bf00f1,0xe7370103}},	//   rgmi, ндър_, vné_, _пет_
  { {0xc333015a,0x610c003a,0x6e2109a8,0x0e690012}},	//   נות_, _eğle, _gelb, _يصلي_
  { {0xf8bf09a9,0x76450073,0x2be20011,0xa2a60011}},	//   tné_, _rchy, _परवा, टोग्
  { {0x26f90044,0x7ce50002,0xafdb0260,0x442209aa}},	//   ंद्र_, tóre, dfør, _nek_
  { {0x61080066,0x94a90003,0xf8bf09ab,0xf3f9004b}},	//   _děla, _تطلق_, rné_, teţe_
  { {0x386900bd,0xf8bf014a,0x8f9b0009,0x71260012}},	//   _waar_, sné_, ליכי, _كربل
  { {0xf1d00037,0xf8bf022d,0xafdb03ee,0x8d2b0009}},	//   _तुलन, pné_, gfør, ּ֥לֶ
  { {0x89db000b,0x11db000b,0xc4d80001,0x7cc80066}},	//   _מחוי, _מחוב, еђу_, běre
  { {0x6fb9002d,0x4422003a,0xcb340048,0x628e09ac}},	// [fb0] _ігор_, _dek_, летъ, _bobo
  { {0xd0190037,0x44220051,0xe3b00003,0x52d80015}},	//   दर्भ_, _eek_, حرف_, емую_
  { {0x649c0061,0xd13b0014,0xf2c4003c,0x628e09ad}},	//   _réin, яха_, устн, _dobo
  { {0x8934000a,0x6e21008b,0x7cc10039,0xb4950001}},	//   اعلا, _selb, vēro, _римљ
  { {0x3818000b,0x6e2100b6,0x7d0100b6,0x57fc0009}},	//   תקדם_, _pelb, _suls, פלגו
  { {0xed5900be,0xd1380010,0x539a000b,0x7d0109ae}},	//   док_, krą_, _חישו, _puls
  { {0x6abf0044,0x56920046,0x2cbf0051,0xdca50015}},	//   ्वीर, рајт, tnud_, каки
  { {0x0b190003,0x628e08b2,0x248909af,0xd13809b0}},	//   وقعة_, _zobo, njam_, drą_
  { {0x2cbf005e,0xcc080012,0x20050030,0x22960097}},	//   rnud_, رزين_, ělil_, _sæki_
  { {0xb87b0066,0x2cbf005e,0x7cc80030,0x945d0034}},	//   hlíd, snud_, věre, tońs
  { {0x10a609b1,0x2b58000d,0x2bd80011,0x98a606e5}},	//   винн, ărca_, _भुना, вине
  { {0xf8b30011,0xf3ff0081,0x61fa09b2,0x7c2209b3}},	//   ूचिय, _ngã_, _útle, _geor
  { {0xeb8e05ff,0xfc160009,0xc7b20009,0xd1380034}},	//   _ти_, _סקסי_, ֹ֑ר_, arą_
  { {0x764300c6,0xfe0e0020,0x945d0002,0xceb2000b}},	//   ngny, hững_, pońs, ֑ים_
  { {0xceb20093,0x4422003a,0x9e480009,0xb05b0032}},	//   בים_, _pek_, עֲשִ, unäc
  { {0xafdb024c,0x6fb60003,0x68fb0073,0x628e09b4}},	//   rfør, _لمعا, _niud, _sobo
  { {0x442201bf,0x628e09b5,0x63a909b6,0xe8d70009}},	// [fc0] _vek_, _pobo, nzen, _בוקר_
  { {0xafdb0119,0xb87b0030,0x64ac0060,0x27fe0030}},	//   pfør, smít, eşit, ětnu_
  { {0x68fb007a,0xa69b000b,0x29030017,0x442209b7}},	//   _biud, _חשיפ, _cuja_, _tek_
  { {0x68fb0801,0x76430031,0x63a90602,0x3eb809b8}},	//   _ciud, egny, kzen, lirt_
  { {0xdfd20003,0x63a906e7,0x6f0409b9,0x38330024}},	//   جيش_, jzen, _juic, рнір
  { {0x7c2200c6,0x63a904f4,0x5f930001,0x6e940003}},	//   _seor, dzen, ришт, طلبا
  { {0xed570001,0x3f80000d,0xf653000b,0x6d4e09ba}},	//   вој_, ţiu_, יצג_, ntba
  { {0x61e300a2,0x68fb00c1,0x7ce50018,0x6d4e0529}},	//   ünle, _giud, vórc, itba
  { {0x44f70003,0x3dd20002,0x69dc0572,0xd0750012}},	//   خروج_, ływ_, _hyre, _حدّث
  { {0xbbe20044,0xd13809bb,0x61080030,0x7db6004c}},	//   _परीक, trą_, _děln, _исец
  { {0x9a3b0009,0x60c20025,0x27ff0060,0xf9920009}},	//   ותיק, onom, _ygun_, ׁר֙_
  { {0x60c20119,0x6d5a00a2,0x64ac003a,0x69dc09bc}},	//   nnom, _ipta, işis, _myre
  { {0x63a9003e,0xdfd80048,0xb4be0011,0x69dc00b0}},	//   czen, вър_, ँची_, _lyre
  { {0xf773000b,0xa293002d,0x7afc016d,0x6d4e0987}},	//   בקש_, _ваші, _nirt, ftba
  { {0xddda0066,0xec0f001a,0x5c0701ec,0xe4d70012}},	//   _patř, iếng_, вяза, نترب
  { {0x672d0039,0xec34002d,0x2489001e,0x6ca4003c}},	//   šaji, инсь, ujam_, аруж
  { {0x7afc014d,0xd3700003,0x672d009b,0x6bd40012}},	// [fd0] _birt, يهِ_, _uvaj, لتكر
  { {0x2247000f,0x27e40051,0x60c209bd,0x7e990012}},	//   ünk_, ümne_, enom, _أندر_
  { {0xc692000b,0x98ad0010,0x63a909be,0x7afc09bf}},	//   _האי_, ardą_, zzen, _dirt
  { {0x08d4002d,0x91bb0009,0x99810030,0x69dc09c0}},	//   ація, ומבי, sahů_, _dyre
  { {0xc43a0093,0xd4910020,0xab2b0003,0x7ce50028}},	//   _אתרי, ều_, _تسجل_, jóra
  { {0x44290006,0x4aa70044,0xc1050003,0xfe45002d}},	//   laa_, _गतिव, _موسي, унко
  { {0xf2d2000b,0xd658000b,0xed59003c,0xb87b0018}},	//   _העם_, דיות_, хой_, ilíb
  { {0x2005003e,0x44290006,0x27ed0066,0xf5560003}},	//   ślij_, naa_, ženy_, اليب_
  { {0xddc10013,0xb3850012,0x61080030,0xe8940223}},	//   _dalš, اجعه, _bělo, _тать
  { {0x4545000a,0x4429004a,0xc334000b,0xed600004}},	//   _منطق, haa_, בוץ_, ážku_
  { {0x44290006,0x63a909c1,0x26c3009b,0x61080030}},	//   kaa_, szen, dnjo_, _dělo
  { {0x44290006,0xe73a09c2,0xf8d30011,0x3da40400}},	//   jaa_, нем_, तविय, _труб
  { {0x6f0409c3,0x00760009,0xb8cc0011,0x889a0009}},	//   _quic, אתרי_, _गत_, גברי
  { {0xceb2000b,0x5fb60011,0x98a60035,0x2d9809c4}},	//   ֖ים_, _आइसल, tulē_, tyre_
  { {0xceb2007e,0x2d9e0107,0x6da303e1,0x387f0060}},	//   זים_, áte_, бира, _onur_
  { {0x6d4e09c5,0x0b1a0012,0xc4c50012,0x00da0012}},	//   rtba, فقرة_, لتقو, _ثبتت_
  { {0x0aea0048,0x3cc70048,0x38a20034,0xb87b0030}},	// [fe0] едай_, улто_, _góra_, blíb
  { {0x9a6a000a,0x610c003a,0x9e6609c6,0x20d901e3}},	//   عمال_, _ağla, _свод, béis_
  { {0xd5b10020,0xd12f0012,0x64c60012,0x05ba0012}},	//   _xét_, كمل_, _ميدل, _سددت_
  { {0xc209000b,0x7afc00f7,0x673b080d,0x00da0012}},	//   לה_, _wirt, šuje, ربات_
  { {0x14d70093,0xf76f0012,0x7c260035,0x7c29016d}},	//   _תוכל_, كاو_, _iekr, daer
  { {0x96e70024,0xba1a0012,0xbd6a0217,0x69dc09c7}},	//   льща_, _سيرا_, ерие_, _tyre
  { {0x2aa4000f,0xf9870012,0x91fc0035,0x7c26016d}},	//   _több_, _اب_, ndāt, _kekr
  { {0x35db0044,0xb4be0037,0xb97b000b,0x397b0009}},	//   _मुफ़, ँचे_, _אנלי, _אטלנ
  { {0x4093000a,0xb8930012,0x46160012,0xda6600ae}},	//   _القر, _القع, _موذر, هادي
  { {0x59b80037,0xa5da0003,0xc986004c,0x78a409c8}},	//   _आधार, _كبار_, гуми, _aliv
  { {0x78a409c9,0x6e25003a,0x7c260227,0xdd120060}},	//   _bliv, _rehb, _oekr, _rüşv
  { {0x69c30034,0x7cc80030,0xb87b0030,0x99f70009}},	//   źneg, běra, dlíc, טזיה_
  { {0x44290006,0xe29a0001,0xb87b01e3,0x61080030}},	//   vaa_, _пад_, elíc, _tělo
  { {0x2d98000e,0x7bdd0002,0x386d0584,0x44260081}},	//   _üres_, _rysu, žer_, _heo_
  { {0x44290006,0x26c3009b,0xc5340009,0xd2b70009}},	//   taa_, rnjo_, יָּה_, _תלות_
  { {0x317b0009,0x20d90478,0x89eb0009,0x89330012}},	//   _טרומ, réis_, _אַחֵ, _اعوا
  { {0x4429004a,0x26c3009b,0xc334000b,0xe29f0028}},	// [ff0] raa_, pnjo_, יוּ_, _auða_
  { {0x7ce50065,0xb6030066,0x20d90018,0x7e550024}},	//   jórn, část, péis_, _твоє
  { {0x4429004a,0x27ec0002,0x7bdd0002,0x4efa0009}},	//   paa_, ędne_, _wysu, _שהתו
  { {0xddde0013,0x7c2604a3,0x046709ca,0x80270012}},	//   _např, _gekr, _стом, ارام
  { {0xd366000a,0x8f690003,0x7ce50017,0x501c0009}},	//   _به_, ئمتك_, fórn, תודו
  { {0x13ba0009,0xe7eb0011,0x9a870024,0xbd450012}},	//   _יזרע, जेगा_, _сумл, لنتي
  { {0x200e0028,0x41e40024,0x63ad08f0,0x069800af}},	//   ækið_, _гіта, lzan, רדום_
  { {0x3f150024,0x442609cb,0x2db800af,0xf1b200af}},	//   _вдас, _ceo_, טלון_, _וסל_
  { {0x44260027,0x73050001,0x4f580012,0x7c84004c}},	//   _deo_, јпоз, _مجلد_, сује
  { {0xdfd80098,0xe2990001,0x60c90989,0xd7940003}},	//   _със_, тао_, _hjem, _الْخ
  { {0x20c6002d,0x7e63004a,0x7cc80066,0x26c40029}},	//   ийом, menp, měrn, émom_
  { {0x2c150011,0xc9520009,0xac1909cc,0xe45f0248}},	//   _फ्लू_, חמט_, _роду_, _sjön_
  { {0x78a40066,0x6d4309cd,0x8c1a0009,0x501a0009}},	//   _vliv, luna, _סוסי, כורו
  { {0x96ba0001,0x63ad084b,0xe29609ce,0xbb3a0009}},	//   туму_, dzan, _ваш_, _יעני
  { {0xb60601bd,0x2aba0009,0x6ecd0011,0xfcb6003c}},	//   _uváž, _שמצא, _तदनु, ащаю
  { {0xa7fb0164,0x248d0082,0x60c90604,0xb05b008e}},	//   seña, njem_, _njem, nnäl

  { {0x3b070098,0x7ae10052,0xd467031e,0x3a260024}},	// [1000] ието_, ollt, шите_, имаг
  { {0x29070005,0xb77b000b,0xbf9b0009,0x8eb30012}},	//   _kuna_, _יאפש, _סייש, _وميش
  { {0x7c2600a2,0xb4f70037,0x249f0028,0xbe3b000b}},	//   _tekr, ुदाय_, kkum_, _בעית
  { {0x3ea507e3,0x26d809cf,0x290709d0,0x2ca909d1}},	//   _allt_, loro_, _muna_, chad_
  { {0x63ad003e,0x91fc001e,0x248d09d2,0x290707f4}},	//   czan, ndār, djem_, _luna_
  { {0x60c902d1,0x6d430028,0x8d760012,0xe6930012}},	//   _ejem, funa, لاعا, يلند
  { {0xed870014,0x1ea90003,0x6d4309d3,0xda5b0009}},	//   исък_, داني_, guna, _שכלל
  { {0x7ae10028,0xd497003c,0x60c900b0,0x94170048}},	//   ellt, иры_, _gjem, ажът_
  { {0x7ac60015,0x6d4309d4,0x26d809d5,0xbb470012}},	//   исое, auna, koro_, للين_
  { {0x781f0044,0xd257002d,0x239a0010,0x2907097e}},	//   पर्क_, ацю_, mąją_, _buna_
  { {0x63ad01a2,0x672d080a,0x44260051,0xfa770009}},	//   zzan, šajt, _teo_, בעית_
  { {0xd83f0382,0x6d9b0009,0x04930012,0x55bb0009}},	//   _účtu_, _שבאפ, _وللح, _במבו
  { {0x6105007a,0xc053000b,0x34b30012,0xc43b0009}},	//   _vėli, חזר_, _بمنز, _יתאי
  { {0xdb9b000b,0x26d800b6,0x539b0009,0x3ea50031}},	//   _בסדר, goro_, _בידו, ólt_
  { {0xa2d30037,0x98c70015,0x290700b6,0x6e28009f}},	//   डवर्, _вспл, _guna_, _medb
  { {0x63ad03eb,0x7cc10039,0xbd440003,0x76b20002}},	//   tzan, tēri, تنفي, pływ
  { {0x5a350014,0x78bd0269,0xcfe90012,0x7b67004c}},	// [1010] йнат, misv, _حفظه_, штве
  { {0xda780047,0x7d080070,0x63ad09d6,0xb3c80011}},	//   иях_, _ouds, rzan, _रखरख
  { {0x2f0b00c5,0x63ad0002,0x7cc80066,0xe987004c}},	//   _søg_, szan, věrn, шћан
  { {0x6114002d,0x7cc1001e,0x78bd09d7,0x89340012}},	//   ідчу, pēri, nisv, زعما
  { {0x70520003,0xe7680003,0x96b90001,0x7ae109d8}},	//   سنوا, لحون_, луку_, yllt
  { {0x7d0809d9,0x6d4309da,0x68e2001e,0x23ca0037}},	//   _buds, tuna, alod, ापनद
  { {0x248d009b,0xce38000b,0x6d430051,0xd575027f}},	//   tjem_, באות_, uuna, суль
  { {0x60c9012e,0x4c85002d,0x6295000e,0xd0d40048}},	//   _ujem, слив, _hozo, _досъ
  { {0x248d009b,0x249f0028,0xa3d70037,0x6d4309db}},	//   rjem_, rkum_, िथि_, suna
  { {0x6d4309dc,0x29000051,0xfe700003,0x290709dd}},	//   puna, _siia_, _يدل_, _puna_
  { {0xf7690093,0x26d801a2,0x382a0015,0x7c2d09de}},	//   _רק_, voro_, лжно_, kaar
  { {0x14740012,0x84640048,0x515a0009,0x78bd0097}},	//   _وانج, _мъче, נכרו, gisv
  { {0x29000051,0x9991000e,0x6f0901e3,0x907a0009}},	//   _viia_, _mező_, _juec, אטרי
  { {0xfb1a000b,0x87b90015,0xceb20009,0xa3bd0011}},	//   _עוצמ, руют_, ִין_, ेपन_
  { {0xaab40003,0x6da30237,0xc6920009,0x38a90025}},	//   _بإنش, пира, האם_, _sûre_
  { {0x8936000b,0xdd8f0012,0x67240227,0xdca60048}},	//   _הרקע_, روق_, _twij, щаби
  { {0x7e9a0012,0x26d809df,0x60d9036c,0xccf20009}},	// [1020] _منظر_, poro_, dowm, לכל_
  { {0x7c2d002c,0x7cc1001e,0xe7b70009,0x64560132}},	//   aaar, mēru, _להפר_, sfyi
  { {0x68e2001e,0x7c2d09e0,0x3aba0009,0xcb090009}},	//   tlod, baar, נמענ, תל_
  { {0x6c86000a,0x70560003,0x24190024,0x7cc80030}},	//   _الحم, إنشا, _вірю_, věro
  { {0xddd50066,0x7d080027,0xf4130009,0x62830227}},	//   dezř, _suds, _מפר_, _onno
  { {0x9757000b,0xa7850003,0x442009e1,0x6e2e09d1}},	//   מינו_, تشمو, lbi_, nabb
  { {0xb996000a,0xb05b0066,0x6143046e,0x68e209e2}},	//   _الزب, ížít, _нера, plod
  { {0xe3140001,0x6ad00011,0x26c700b8,0xa06a0048}},	//   омињ, सक्र, anno_, _щаба_
  { {0x4420003a,0x389b0009,0xb7ca0012,0xcc330012}},	//   ibi_, _עימנ, _صبرك_, سريع
  { {0x86ea0003,0xaab4002d,0x78a200f1,0xd91a027f}},	//   _إعرف_, ійні, lkov, льм_
  { {0x290a0005,0x867b000b,0x442d002c,0x75d60012}},	//   _juba_, _תרבו, bae_, _ايضا
  { {0x23690002,0x27e90034,0x8c1a0012,0x290a016d}},	//   ywaj_, żane_, _إيشر_, _muba_
  { {0x274b0015,0x290a0051,0x98b80014,0x4420017b}},	//   ычно_, _luba_, слят_, dbi_
  { {0x291802d1,0x7c2d0070,0x7bdc003a,0x9e14002d}},	//   _otra_, waar, ğrud, здрі
  { {0x3abb0093,0x61020039,0xb05b004a,0x62950029}},	//   _תמונ, _vēlr, nnäk, _rozo
  { {0x58d40014,0x9419004d,0xf1b30009,0xd49809e3}},	//   _нощт, ржат_, _מסצ_, бру_
  { {0x4054000a,0x3866006f,0xdfd10003,0xaa070012}},	// [1030] _رئيس, deor_, _زيد_, مظاه
  { {0x539b000b,0xf8bf0061,0x5a35002d,0x7c2d0269}},	//   אימו, lié_, інет, saar
  { {0x4420000f,0x290a09e4,0xeab10009,0x98170012}},	//   bbi_, _cuba_, וֹא_, مبشا
  { {0xe1f00003,0x6d550052,0xec6b004d,0x55ba0009}},	//   رسل_, mtza, _срок_, _כמתו
  { {0xc058002d,0xdb460012,0x7a430031,0x61080030}},	//   сіх_, _تَ_, nítü, _děli
  { {0xb7c60039,0xfd110003,0x236f0028,0xcf580009}},	//   diģē, وجب_, ægju_, צבות_
  { {0x31350046,0x6d47009b,0xcc890015,0x442b00ed}},	//   _фебр, nuja, ибке_, _kec_
  { {0x7ce50002,0x94790001,0x6e2e000e,0x67d50024}},	//   mórk, рску_, zabb, _добу
  { {0xc64b0003,0xcec8001a,0x52a90339,0x3b850024}},	//   _مجال_, uộc_, ивим_, ілог
  { {0xadf90011,0x3a99003c,0x6e2e0032,0x7cc10035}},	//   ंधान_, ртию_, xabb, eērt
  { {0xf8bf0061,0x71b50015,0x208a02ac,0x39e905fb}},	//   fié_, ющих, айни_, рдно_
  { {0xc689000b,0x98a60010,0xd0060012,0x50b60024}},	//   _בא_, kslą_, توحً, існу
  { {0x2cad00c5,0xa856000b,0x7a43000e,0xa01b0097}},	//   mhed_, חירה_, gítü, tjör
  { {0x443909e5,0x78a909e6,0x78a20004,0x0b160012}},	//   _ads_, _llev, zkov, _بقوة_
  { {0xde03007c,0x78a902bd,0x660301b6,0x80e60012}},	//   дпри, _olev, дпра, _وأعل
  { {0x03260098,0xf8bf0061,0x2cad0058,0x6e2e09c5}},	//   ждан, cié_, nhed_, sabb
  { {0x72360003,0x765c0028,0x6d470010,0x20050066}},	// [1040] قراط, _öryg, auja, ělit_
  { {0xe8220037,0xea870048,0x61e30097,0x36c3003c}},	//   मर्थ_, обул_, _kynl, _обыг
  { {0x78a900c5,0x8916000a,0x7c390002,0xc04f0024}},	//   _blev, زبائ, _odwr, мі_
  { {0x78a909e7,0x6ee401a0,0xf80d0009,0xb7e609e8}},	//   _clev, mòbi, ְהוּ, ожек
  { {0x29070065,0xf8b30093,0xbe8a06fd,0x905b0009}},	//   ínar_, ושא_, иске_, שכנת
  { {0xbea30046,0xfd380003,0x877b000b,0x7d020002}},	//   мачк, مكتب_, יאני, _sios
  { {0x27ed000f,0xd639002d,0x7d020002,0xc8660012}},	//   _ezen_, сячі_, _pios, _وطري
  { {0x2cad00c5,0xd91b000b,0x442b0054,0xa6db0097}},	//   ghed_, _כולל, _xec_, irða
  { {0x7cc10039,0xccf3000b,0x320d003a,0xf3660024}},	//   vērt, וכה_, _şeyi_, ітин
  { {0xb7c6001e,0x2bb70003,0xdcea003a,0x7d020002}},	//   riģē, غاية_, ınır, _wios
  { {0xf8bf0061,0xc27b0009,0x7dc60012,0x76b20034}},	//   tié_, בריי, _بقان, słys
  { {0xbb860003,0x6d47004a,0x2cad09e9,0x7c2b0347}},	//   _ولاي, vuja, ched_, _gegr
  { {0x24860163,0x29180259,0xf8bf0061,0xc4f70009}},	//   _inom_, ūra_, rié_, _ומאז_
  { {0x26dc09ea,0x290409eb,0xda660012,0xaa580012}},	//   novo_, _lima_, _ذاتي, _طلبا_
  { {0xdcbb0098,0x25db0037,0x621b000b,0xf98f0003}},	//   аща_, _खुशी_, _דווק, _لبي_
  { {0x2904009b,0x67f5000e,0x291e09ec,0x629801bd}},	//   _nima_, nüjé, mpta_, _hovo
  { {0x63a000d9,0x309c0009,0xe6bc0011,0x442b09ed}},	// [1050] nymn, _כשהמ, ्चाङ, _vec_
  { {0x98a60010,0x7cd3000d,0x60dd006e,0x93fb0009}},	//   rslą_, măre, losm, שלמי
  { {0x89d90003,0x2d8c09ee,0x248609ef,0xddc50034}},	//   حوار_, ädet_, _onom_, _wchł
  { {0xf771000a,0x644f00c1,0x7d1a000e,0x26c40029}},	//   فات_, _ucci, ítse, émov_
  { {0x8e8509f0,0xb4d70037,0x78a90066,0x0a6b0001}},	//   згле, ाकी_, _vlev, _крви_
  { {0xd6db0046,0x23fa000b,0x7ce509f1,0x26dc017b}},	//   ште_, _להרא, móri, govo_
  { {0xa954002d,0xf5920012,0xa63c0009,0x2cad09f2}},	//   _окрі, فلوج, בגור, thed_
  { {0x7cc1001e,0x27180066,0x442b001a,0x644d09f3}},	//   vērs, něný_, úc_, ngai
  { {0x2cad0058,0xce6b0306,0x61e309f4,0xf77000ae}},	//   rhed_, _вред_, _synl, _لال_
  { {0xf3f9007d,0x2cad09f5,0xd2a90015,0x8d770003}},	//   neţi_, shed_, ское_, _واضا
  { {0x25db0037,0x2169077e,0xa9690264,0xd0f50009}},	//   _खुली_, щини_, щина_, ּמָת_
  { {0x85040012,0x66150034,0xd1960009,0x29040558}},	//   _قولن, eczk, לכתי_, öma_
  { {0x8bb70003,0x291e09f6,0x7ea20061,0x61fe01bd}},	//   _بإضا, apta_, _hôpi, _úpln
  { {0x6298080a,0xb7da000b,0x6d4309f7,0x63c80012}},	//   _govo, מקרי, orna, _بِهِ_
  { {0xf3f9007d,0xb7bd000d,0x91e209f8,0xa6c70012}},	//   deţi_, _deţi, _поше, أوّل_
  { {0x236d0002,0xa93a000b,0x113a0009,0xc5f20009}},	//   owej_, _התקפ, _התקל, תדל_
  { {0x7cd3000d,0x7ce509f9,0x14170012,0x2a620031}},	// [1060] căre, góri, سيلة_, őkbe_
  { {0xf3f9007d,0x96960001,0x67bb0009,0xd36f0012}},	//   geţi_, _хриш, _למפק, طهم_
  { {0x7e9b000b,0x0e9b000b,0xa00a0003,0x5e9b000b}},	//   _הסיו, _השיל, مقال_, _הביק
  { {0x62870503,0xc5eb0009,0x6d430159,0x98bf004b}},	//   _enjo, _לַכֹ, drna, mută_
  { {0x443209fa,0x66e60511,0x6d4309fb,0x98bf004b}},	//   may_, пода, erna, lută_
  { {0xf3f901b3,0xcf890003,0x26dc00c1,0x443209fc}},	//   ceţi_, تضمن_, uovo_, lay_
  { {0xd6570009,0xb6ad0009,0xe1690012,0xb1e60012}},	//   פיקת_, שׁוֹ, _وصفه_, _رأسه
  { {0x44320101,0x493b000b,0x3957000b,0xc1570009}},	//   nay_, _לגלו, _משלם_, _משלו_
  { {0x7d06004a,0x629809fd,0x66150034,0xf74303b0}},	//   _miks, _povo, yczk, _пето
  { {0x443209fe,0x7d0609ff,0x8f8b0009,0x139b0009}},	//   hay_, _liks, _לְבֵ, צביע
  { {0x28f9002d,0xb7bd000d,0x05db03bf,0x79a30015}},	//   жень_, _reţi, _मुंब, еряе
  { {0x62980032,0x7cd3004b,0x60c20a00,0x48ab0a01}},	//   _wovo, tăre, niom, стом_
  { {0xe7870001,0xdfdb0014,0x44320a02,0x7c240060}},	//   чуно, сън_, day_, dbir
  { {0xd24f000a,0xb3e90003,0xb2d30003,0x291e079d}},	//   _منه_, _بعمل_, _كينغ, ppta_
  { {0xda5b000b,0xa2d90037,0xf3f9000d,0xa6db0028}},	//   _הכול, नकर्, veţi_, nuði
  { {0x443201e5,0x7ce50a03,0xb4d70037,0x644d0010}},	//   gay_, tóri, ाके_, ugai
  { {0xf3f901b3,0x883c0093,0x28580003,0x78ad003a}},	// [1070] teţi_, _התחו, _رؤية_, _ilav
  { {0x78ad00f1,0x67540003,0x3860001b,0x64ac0060}},	//   _hlav, _أخير, _zbir_, işiy
  { {0x44320101,0x98bf000d,0xf3f9000d,0xd1300003}},	//   bay_, cută_, reţi_, ُمْ_
  { {0x26c3009b,0xe9f8002d,0xd138002d,0xd1170009}},	//   lijo_, їнці_, яху_, פקדה_
  { {0x3b640098,0x7eaf0119,0xf3f9000d,0x6d580035}},	//   _първ, _løpe, peţi_, etva
  { {0x7fb6000a,0x6447007a,0x26c3009b,0x78ad0a04}},	//   ظهور_, ėjim, nijo_, _llav
  { {0x6724001e,0x60c2005e,0xdb080031,0xa3a905f3}},	//   ģija, biom, ölöt, गैर_
  { {0xc9520009,0x5ba90198,0x98a900ae,0xe58c00af}},	//   _שמן_, жким_, _بُرك_, מָחָ
  { {0x33650024,0x98bf004b,0x2d570060,0x6d5c054e}},	//   євог, zută_, hçe_, _äran
  { {0x2d57003a,0x7c24009b,0x957c0034,0x26c30159}},	//   kçe_, zbir, _cząs, jijo_
  { {0xa3e40037,0x26c30a05,0x5e440012,0x7bce0032}},	//   _पुन_, dijo_, _أَمْ, ßbur
  { {0x78ad0a06,0xcea9000b,0x644a000e,0xb4d70011}},	//   _clav, _די_, őfiz, ाको_
  { {0x610c00a2,0x26c30a07,0x7d060153,0xa0360009}},	//   _işle, fijo_, _riks, וארה_
  { {0xa1c5002d,0x60c20002,0x26c3009b,0x7d060577}},	//   _облд, ziom, gijo_, _siks
  { {0x7cd3007d,0x88c60003,0x44320363,0x84e60024}},	//   cărc, _يتعل, tay_, довж
  { {0x442f045d,0x61fa0028,0x78ad0082,0x5f460012}},	//   _jeg_, _útli, _glav, _قنبل
  { {0x442f0a08,0xa857000b,0x26c3009b,0xa08b000b}},	// [1080] _meg_, _חיפה_, bijo_, _וְיִ
  { {0x26c3012e,0xda660003,0x44320a09,0x8e4a0003}},	//   cijo_, باري, say_, _بلدك_
  { {0x7d06007a,0xa96a0003,0x6d580248,0x44320a0a}},	//   _tiks, تمام_, xtva, pay_
  { {0x291c001e,0x3ce9015b,0x7c2f0832,0xf2c90009}},	//   īva_, clav_, _gecr, בע_
  { {0x9ffa0012,0x69d50032,0xf76f0012,0x60c20a0b}},	//   آراء_, _exze, لاو_, riom
  { {0x442f0005,0xdfcf0003,0xd7f9002d,0xb7db000b}},	//   _aeg_, جيه_, чує_, חקני
  { {0x63a40a0c,0xd5b00012,0xafdb07c2,0x442f0a0d}},	//   lyin, طفة_, ngør, _beg_
  { {0x5ba6002d,0x26c3009b,0x2a7800b6,0x54540048}},	//   дроз, zijo_, _harb_, хвит
  { {0x442f03a0,0xbc1b000b,0xcb670001,0xfc3f0028}},	//   _deg_, חופש, дање_, _slík_
  { {0x610c00a2,0x3b070061,0x68e400b6,0x079b0009}},	//   _eşle, _cinq_, _akid, _וסמל
  { {0x67220039,0x6da60003,0x26c3009b,0xc27b000b}},	//   lpoj, _تمام, vijo_, קרטי
  { {0x3cfa0044,0xa9c3007c,0x1417000a,0x63a4004a}},	//   ्दों_, тськ, _قيمة_, kyin
  { {0x5f940014,0xceeb0003,0xd7e4002d,0x7afd0066}},	//   вият, قرآن_, віро, ůsta
  { {0x2d5700a2,0xeb970001,0x7cd3000d,0xaab70012}},	//   tçe_, _циљ_, măra, _يدور_
  { {0x95c50003,0x26c3009b,0xafdb0058,0x9d180345}},	//   ريره, rijo_, ggør, дост_
  { {0x9f55002d,0x63a4002a,0xddc3000d,0x6b820a0e}},	//   _звич, fyin, lenţ, _krog
  { {0x26c3009b,0x18340012,0x92a60034,0xd1380073}},	// [1090] pijo_, _شريح, _odłą, lsą_
  { {0xe9ab0003,0xddc3000d,0x27e901ea,0xeb910009}},	//   يدان_, nenţ, _iyan_, נָן_
  { {0x7c2f003a,0xd1380010,0x7eab0051,0x629c0a0f}},	//   _tecr, nsą_, _hüpo, _doro
  { {0xd8b80003,0xd1380010,0xf9900012,0x20190031}},	//   ودنا_, isą_, جبك_, ncsi_
  { {0x63b6003e,0xbc1a000b,0x8c1a000b,0xddd5000e}},	//   czyn, _מורש, _מורי, mező
  { {0x442f0119,0xd356000b,0x1d09002d,0xd1380010}},	//   _seg_, _אישי_, пеки_, ksą_
  { {0xddc3007d,0xb05b0a10,0x26c9001b,0x5eec0009}},	//   denţ, nnäs, đao_, קַדְ
  { {0x628a0052,0x6d4703d5,0x8b950015,0xeb9902ad}},	//   _anfo, irja, ероч, зии_
  { {0xe3b10003,0x442f0028,0x7c840001,0x86c50012}},	//   طرة_, _veg_, тује, _كيرن
  { {0xeb92000b,0xddc3000d,0x442f0832,0x2ef4004c}},	//   רָה_, genţ, _weg_, _азур
  { {0xa6db0028,0x442f006f,0x5fc50011,0x6b820a11}},	//   nuðu, _teg_, _लेबल, _erog
  { {0x2d980054,0xddd5000e,0x6c840012,0xc19a0009}},	//   _àrea_, jező, _للمم, לשתי
  { {0x6d410028,0x6d470a12,0xec360009,0xe3ae0695}},	//   álan, erja, _נאסר_, _сб_
  { {0xd2510003,0xddc3000d,0x9f56000e,0x2f14006f}},	//   _صنع_, cenţ, égét_, _väg_
  { {0x98a70066,0x9f630030,0x7ae10a13,0xf3f70081}},	//   éně_, ěvák_, molt, ệng_
  { {0xafdb0058,0x63a40258,0x629c0a14,0x91ba0009}},	//   rgør, tyin, _soro, _ממצי
  { {0xcb670a15,0x88bd0066,0x629c0a16,0x434302ad}},	// [10a0] нате_, spěc, _poro, летв
  { {0x35db0037,0x63b60002,0xb05b006f,0x7ae10a17}},	//   _मुक़, rzyn, snät, nolt
  { {0x63b60002,0xc8660345,0x3ad30012,0xa0a6003c}},	//   szyn, етли, ديلز, нажд
  { {0xd4910020,0x60c600b6,0x2ca9006f,0xddc3000d}},	//   _tùy_, nikm, ckad_, zenţ
  { {0x60c60051,0x10020011,0xb05b0a18,0xfe360009}},	//   iikm, ोशिश_, onär, ֲרֵי_
  { {0x7cd3000d,0xfe6f0003,0x26ce0a19,0xfc3f0030}},	//   văra, مدى_, unfo_, _zdí_
  { {0x6b820034,0xddc3004b,0xe4a60560,0xe7c00011}},	//   _srog, venţ, ерпо, _शेरप
  { {0x91e30015,0x1d070001,0x6722008e,0x515b0009}},	//   _сосе, неји_, ppoj, _מכלו
  { {0xddc3007d,0x68e20051,0x7afe08b9,0xc4770009}},	//   tenţ, mood, ompt, תתפו_
  { {0x9bbb000b,0x394c0054,0x7f3b000b,0x6d470028}},	//   פציפ, tuds_, _מעמו, yrja
  { {0x200d00a2,0xd46a0a1a,0xd2b7000b,0x0c26002d}},	//   şmiş_, _ниже_, גלית_, _змен
  { {0xeb9a0098,0x01370093,0xe61f001a,0x7cd3000d}},	//   _ние_, ערכת_, _đôi_, păra
  { {0x28c00037,0xdefb0015,0xfaa60430,0x79830032}},	//   शोधि, зыв_, _падо, _ernw
  { {0x6d5c0052,0x628a002a,0x7ae10a1b,0xb9940012}},	//   ftra, _unfo, colt, _للتب
  { {0x68e203d5,0xc27b000b,0x627b000b,0x7ce50018}},	//   kood, _מרגי, _מנגנ, pórt
  { {0x61430001,0x60c6003a,0xa3e40011,0x6fb50012}},	//   _сећа, cikm, पअप_, _لمبا
  { {0xfbd00003,0x27e9003a,0x6d4e0a1c,0xf7840012}},	// [10b0] متك_, _uyan_, auba, _مليَ
  { {0x2ca9006f,0x7e7a0027,0xa6db0097,0x1db00011}},	//   skad_, _natp, tuðu, जनात
  { {0xc9840001,0xb8350048,0x6d5c0a1d,0x6d4e0a1e}},	//   луци, веещ, ctra, cuba
  { {0xc5f2015a,0xcd96000b,0x7ae1000e,0xd308001a}},	//   _כדי_, _סדרת_, zolt, _iệu_
  { {0x4c9a000b,0xef18002d,0x03d50009,0xce950048}},	//   _חברו, емі_, _יוֹם_, кадъ
  { {0x7bdc00a2,0x44290a1f,0xc6680001,0xa77c0009}},	//   ğrul, lba_, ешће_, פרופ
  { {0x20e10037,0x6917001e,0xc9e50012,0xc8790060}},	//   नवाध, _aģen, _شكرً, _taş_
  { {0xb062005e,0x44290a20,0x4c850a21,0x000000c4}},	//   äätm, nba_, тлив,
  { {0x6d5c0a22,0x60c60097,0xe4520009,0xdb140097}},	//   ztra, vikm, בֶת_, óaðr
  { {0xa3a80012,0x8cc10011,0x17f80012,0x63a600b0}},	//   عطيك_, रोतो, _سرقة_, økna
  { {0x2a76000b,0x60c60010,0x4429000e,0x2d9a0033}},	//   דעתך_, tikm, kba_, øpet_
  { {0xf9920009,0xbb850012,0x7ae10a23,0xddc30035}},	//   ׁ֨ר_, _للصي, solt, cenš
  { {0x98bf06d4,0x3f840066,0x883a000b,0x44290a16}},	//   nutę_, ímu_, ותרו, dba_
  { {0x442902d1,0xbb420001,0x3f5b001a,0xfaa20a24}},	//   eba_, _тешк, iêu_, _вашо
  { {0x65c30a25,0x8a140003,0x8707002d,0x40960012}},	//   абра, _إظها, терв_, _للغر
  { {0x6d4e0a26,0x44290a27,0xa7d60012,0x5cf60024}},	//   ruba, gba_, _لتخص, тягу
  { {0x6d4e0101,0x25e80037,0x68e2005e,0x8cc10011}},	// [10c0] suba, _चुनी_, vood, रोधो
  { {0x7c29038c,0x96fa0012,0xc87f0032,0x610c0060}},	//   hber, _تعبر_, roße_, _aşla
  { {0x98c60044,0xa2a30037,0xf8c60037,0xda650003}},	//   _लगाए, _गवर्, _लगाय, طالي
  { {0xdb0d000e,0xf9920009,0xd3080081,0x4fc60048}},	//   szaá, ירב_, _hệt_, ксла
  { {0xdfcf0003,0x5f730012,0xc0170009,0xb87b0031}},	//   ييم_, لاور, דקנו_, mlít
  { {0xb87b000f,0x68e20051,0x6d5c0051,0x7c290a28}},	//   llít, sood, _ärak, eber
  { {0xceb3000b,0x95530003,0xd5af0012,0x7c290032}},	//   שיו_, لخيا, يفه_, fber
  { {0xb87b000e,0x29180017,0xfc660048,0xfbd20009}},	//   nlít, íram_, тъкн, ֹת֙_
  { {0x26c7012e,0xd4670001,0x0c730012,0xe29f0097}},	//   bino_, тиње_, شديد, _guðs_
  { {0xc3330093,0xa0210028,0x7c290a29,0x26c70a2a}},	//   סות_, _þörf, aber, cino_
  { {0x3a37000b,0x7c290a2b,0x8d770012,0x80bf0011}},	//   כרים_, bber, _لملء_, लोवे
  { {0x7ccc003a,0xa8a70a2c,0x30a70a21,0xfd570009}},	//   oğru, трок, тров, _ישבי_
  { {0x58d4004d,0x35db0011,0x2d9e0a2d,0x1d07004c}},	//   роят, _मुज़, äten_, _реци_
  { {0x41dd0037,0xd3370009,0xddda0073,0x62340a2e}},	//   _नुकस, _ירדה_, _natū, _секу
  { {0xdce30002,0xe6110009,0x8aab0009,0xba290012}},	//   ewnę, מִן_, _קֹדֶ, _أسهم_
  { {0x44290a2f,0xa6db0097,0x628e0a30,0x5d7b0009}},	//   uba_, irði, _anbo, ואלק
  { {0x09bd0037,0x9be7002d,0x6d4a0052,0x1be30011}},	// [10d0] ्प्य, тівк, hrfa, _कुशल_
  { {0x7c29009b,0xdd03003a,0xf1a70a31,0xf1950024}},	//   zber, ırıc, крен, лизь
  { {0xd0110003,0x6cd50003,0x25a5006f,0x6d5c0051}},	//   ملا_, _مقدا, älld_, _ärah
  { {0x30a70014,0x6019003c,0xf1c30073,0xccf80030}},	//   ързв, ходя_, _rašė_, _zpěv_
  { {0x3ea10051,0x6f650003,0x7b090010,0xa3e40011}},	//   _koht_, اهتم, _užuo, पॅम_
  { {0x999c000e,0xc7320012,0xe7eb0011,0x4df50a32}},	//   _levő_, حفوظ, ड़ेगा_, ляйт
  { {0x7c2904a3,0xc6940009,0xe8030011,0x0dc8004c}},	//   tber, יאס_, रेता_, кући_
  { {0x94750003,0x26c701f3,0x24490012,0x3f82009e}},	//   ادثا, sino_, رجعي_, yvku_
  { {0x26c70a33,0xdce5001e,0x2d9a0033,0x13090055}},	//   pino_, _arhī, øper_, нний_
  { {0x6b67001e,0xe6f20081,0x7dd20031,0x7c290a34}},	//   mīgā, _tườ, nűsé, sber
  { {0x27fa003e,0x24550003,0xaadc0009,0xf2d40009}},	//   ępne_, _مناس, וחזר, יעץ_
  { {0x351a0009,0x1cbb0012,0x629a0a35,0x40960a36}},	//   _טוענ, _غاضب_, ajto, урот
  { {0x7ae502bd,0x239b0003,0xf7720012,0x6b670035}},	//   koht, _تخضع_, حاج_, nīgā
  { {0x7ae5004a,0x2cad0a37,0xe39a0009,0x1bb80012}},	//   joht, lked_, _רֹאש, _جامع_
  { {0x92560001,0x2cad0132,0x96c30011,0x270f0011}},	//   _сајт_, oked_, रफ़ॉ, ादुर_
  { {0x2cad0979,0xc9520009,0x63a90025,0x4f960a38}},	//   nked_, _המה_, oyen, _броу
  { {0x577a0003,0x63bb0052,0xa2d60012,0x6d460035}},	// [10e0] _أصبح_, nzun, هيرت, _ākam
  { {0xa6db0028,0xb87b0042,0xe2450012,0x7e56004c}},	//   yrði, slít, لخمي, _стиц
  { {0x09f60063,0xa84a0012,0x210e0011,0xaa570012}},	//   учая, فلام_, िदेश_, الما_
  { {0x7e7e0a39,0xd7fa0015,0x25a50a3a,0x27ed0a3b}},	//   _happ, нул_, älle_, _byen_
  { {0xbea60021,0x96ea00b3,0xa8570009,0xe3b20012}},	//   ладк, нька_, רינה_, _طرح_
  { {0xdee3027f,0x61050073,0xddc70a3c,0x8b8b0009}},	//   бочи, _mėly, lejš, _אָלֶ
  { {0xb5aa0003,0xccf80066,0x8178000b,0x7b090027}},	//   عاتك_, _opět_, _בְּק, _ožuj
  { {0x6b840051,0xddc70a3d,0x7e7e0a3e,0xb8660012}},	//   ovig, nejš, _lapp, _حاسو
  { {0x6b67001e,0xaaa80037,0x63a9000e,0xa5070001}},	//   cīgā, _गवाक, gyen, ћења_
  { {0x6fb30003,0x5a340014,0xf1260109,0x3a3a013e}},	//   _امكا, шнот, льмо, napp_
  { {0x6b840051,0xa526004c,0xd9170223,0x6da60012}},	//   hvig, _смед, лья_, _حمام
  { {0x2cad0036,0x7a48001e,0x91bb0009,0x6fb50012}},	//   cked_, lītē, תמטי, لمجا
  { {0x7eab0051,0x4fc70083,0x0a9401d4,0xa3e40011}},	//   _hüpi, усна, _валю, _पुल_
  { {0xe6100003,0x07090012,0xddc80a3f,0x7e7e03c1}},	//   كشف_, ئيسي_, _madž, _capp
  { {0xccfb0046,0x7eb00051,0x6b670035,0x291c08ca}},	//   ећа_, _täpn, zīgā, íval_
  { {0xb4c10037,0x895b000b,0x99f50024,0x61f50060}},	//   ्चे_, _נדחת, _тячі, üzle
  { {0x36d50047,0x6bd40003,0x5a350229,0xdc8b0009}},	// [10f0] _вопр, متكر, инат, עְלָ
  { {0xccf80013,0x6b670035,0xdb040034,0x68e90a40}},	//   _zpět_, vīgā, dzió, _sked
  { {0xc0cb0046,0x7dd2000e,0xc6920009,0x1ed80012}},	//   нуде_, rűsé, _ואי_, _حبيب_
  { {0xf771000a,0x3aeb0033,0x31570009,0x7ae5005e}},	//   قات_, løpt_, ריאן_, soht
  { {0xcc56000b,0xf43a0009,0x4c3a0009,0xc43a0009}},	//   _דברי_, _בגרמ, _בתרב, _שתשי
  { {0x6b67001e,0x8afd0066,0xd738000b,0x9e640024}},	//   rīgā, otře, נטות_, йвід
  { {0xd658000b,0x7d0f000e,0xf2d2000b,0x40350a41}},	//   איות_, _kics, _ועם_, _вебс
  { {0x63bb008b,0x58d5002d,0x934505cc,0x27f20034}},	//   tzun, _тобт, ание, żyna_
  { {0x2cad0a42,0xe7ec0011,0x63bb0032,0x88bd0030}},	//   rked_, _छुपा_, uzun, rpěl
  { {0x4e78000a,0x2cad0a43,0x88bd0066,0x63bb0052}},	//   _محمد_, sked_, spěl, rzun
  { {0xbd4b0003,0x67240377,0x80a60012,0x3d110011}},	//   _سؤال_, _stij, لمدن, _दंगे_
  { {0x2541007a,0xa3b50044,0x7c2d0002,0xd59a000b}},	//   dėl_, जना_, jbar, _בבעל
  { {0x26ca0101,0x442d0a44,0xddc70a45,0x889a0009}},	//   tibo_, mbe_, vejš, דברי
  { {0xff16000b,0x49b90003,0xdcfc01bd,0xceb20009}},	//   יקשת_, _لابد_, tvrď, ֗ים_
  { {0xceb20093,0xe506000a,0x3f89000d,0x3c42000e}},	//   חים_, لبري, _erau_, _lévő_
  { {0x3f890a46,0x89da01b0,0x7e7e016a,0x26ca020d}},	//   _frau_, _שחקי, _wapp, sibo_
  { {0xd497001a,0xa6db0028,0x03230104,0xddc70a47}},	// [1100] ờng_, erðu, ждун, rejš
  { {0x23600070,0x6d410a48,0x62810a49,0x7c2d0a4a}},	//   rtij_, _ovla, ndlo, abar
  { {0x3af50015,0x442d000e,0x50260012,0x7c2d0906}},	//   сятс, kbe_, لفاك, bbar
  { {0x387f0039,0x442d0a4b,0x351b0009,0xcfa6003c}},	//   _caur_, jbe_, _שוכנ, ишли
  { {0x7ccd0039,0x442d0133,0x6fd60003,0xdddc000e}},	//   _mērķ, dbe_, جزائ, merő
  { {0xdb04000f,0x6b8b0058,0x7d0402bd,0x78a4004a}},	//   rzió, ægge, lmis, _loiv
  { {0x38560014,0x5096004c,0x409602ba,0x5ee90009}},	//   _възс, _крађ, _крат, נַנְ
  { {0x48e3002d,0x41b30012,0x78a40018,0x442d0031}},	//   _досв, _بمفر, _noiv, gbe_
  { {0x3d160037,0xa3d60037,0x4420000d,0x9ae9002d}},	//   _पूरे_, िपि_, ici_, нiше_
  { {0x29180a4c,0x6d4109d4,0x7d040a4d,0xbae30012}},	//   _kura_, šlai, hmis, يكيي
  { {0x442d01a2,0x44200066,0xf426004a,0x0217000b}},	//   bbe_, kci_, ääsi_, יחים_
  { {0x3866038e,0x6e3c031d,0x649c0054,0xd5770009}},	//   nfor_, earb, _néix, _כתבה_
  { {0x7d040005,0x274b0014,0x78a40061,0x6e3c0052}},	//   dmis, ъчно_, _doiv, farb
  { {0x6e3c0a4e,0x44200a4f,0xbb3b0009,0x13bb0009}},	//   garb, eci_, _יעדי, _שֶׁמ
  { {0x63a2004a,0x42fb000b,0xbafb000b,0x51930003}},	//   äonn, _שהוס, _שהוש, _ولهذ
  { {0xdddc000f,0xb0350001,0xc0350001,0x7d040a50}},	//   gerő, _униш, _униј, gmis
  { {0x8afd0013,0x5c070014,0x2fcf006f,0x4374002d}},	// [1110] stře, рява, _ägg_, жуєт
  { {0xe9870001,0x7c3b0002,0x7d0400e6,0xc20b0012}},	//   ићен, zaur, amis, نغام_
  { {0xa81b0012,0x27fe0034,0x180f0011,0x442d0a51}},	//   نتشر_, ętne_, िश्व_, ybe_
  { {0x7c950003,0xd91b0009,0x29180a52,0x44200a53}},	//   _الحص, דואל, _dura_, cci_
  { {0x7bd800a2,0xb4fa000b,0x9203001e,0x44390a54}},	//   şvur, _תפרי, _šādi, _ies_
  { {0x7cd3007d,0xaec4002d,0x8ee80024,0x45450012}},	//   mări, обіл, амів_, منتق
  { {0x20d20026,0x44390a55,0x27fa0002,0xddc80002}},	//   lšie_, _kes_, ępna_, _gadż
  { {0x25d80093,0x9dd8000b,0xadd8000b,0x80c60037}},	//   יוון_, יווק_, יווח_, _लगें
  { {0xdcb1008a,0x7cd3000d,0x44390a56,0x69ce0029}},	//   _của_, nări, _mes_, úben
  { {0x44390a57,0xc334000b,0x2b4d0054,0x7c2200e7}},	//   _les_, חוץ_, rrec_, _efor
  { {0x7d040a58,0x20d20029,0x63ad00b6,0xa969004c}},	//   ymis, hšie_, hyan, ћима_
  { {0x4439007a,0xcea9000b,0xfdf6000b,0x26de0029}},	//   _nes_, _אי_, _הצעת_, čtom_
  { {0xef19003e,0x20d20026,0x78a40006,0xd308001a}},	//   _już_, jšie_, _voiv, _tệp_
  { {0x249f0065,0x6d55007d,0xfbd00003,0x63ad01ea}},	//   ljum_, fuza, _تتم_, dyan
  { {0x7d040005,0x3ea503eb,0x6e3c0202,0x78a4019a}},	//   tmis, _molt_, rarb, _toiv
  { {0x44390108,0x25a5006f,0xbc19000b,0x2d870051}},	//   _ces_, älla_, רוּש, ivne_
  { {0x6a160003,0x7cd3000d,0x44390a59,0x64a3004d}},	// [1120] مبار, gări, _des_, чата
  { {0x44200a5a,0x3f8f0017,0x44390647,0x249f005e}},	//   sci_, _água_, _ees_, hjum_
  { {0xc6930093,0x9985007a,0x5d860003,0x44390054}},	//   _זאת_, malų_, _الجل, _fes_
  { {0x7cd3000d,0x4439006f,0xcb090009,0x71880009}},	//   bări, _ges_, גל_, יְנַ
  { {0x7cd3007d,0x3ea50a5b,0x3866038e,0x60630012}},	//   cări, _bolt_, rfor_, سهول
  { {0x99850010,0x66e3002d,0x44390070,0x8d760012}},	//   nalų_, поча, _zes_, ماعا
  { {0x11da000a,0xceb3000b,0x44390a5c,0x361b0009}},	//   _صورة_, היג_, _yes_, נוקד
  { {0x2912002c,0x3ce005dd,0x249f0097,0xc0d60012}},	//   _niya_, čivo_, gjum_, _ايرب
  { {0xdfcf000a,0xbb470003,0x99850010,0x68ed0060}},	//   _كيف_, ملين_, kalų_, _rkad
  { {0x2561000f,0x314a000b,0xe3af0012,0x28c40011}},	//   ból_, ְתָּ, عري_, लोरि
  { {0x7cd3000d,0xf09f0054,0x25ed0011,0x5d860012}},	//   zări, tjà_, _आँधी_, _دلال
  { {0x29000020,0xdbdd000e,0x09f70009,0x07b90012}},	//   _chia_, sáér, ממים_, لهجة_
  { {0x33f60003,0x2e4b0048,0x7cd3004b,0x2ca0016d}},	//   _اساس, ляво_, xări, djid_
  { {0xd130000a,0x7d1a02bd,0x20d20029,0x44390a5d}},	//   _قمت_, _kuts, všie_, _ses_
  { {0x2ca60051,0x7e75009b,0x82630012,0x44390a5e}},	//   _kood_, rezp, _رهين, _pes_
  { {0x7cd3007d,0x8cf5007c,0xa5070024,0x35b30024}},	//   tări, ізац, сягл, обґр
  { {0x2ca6021b,0xab940024,0xa4b70009,0xab870048}},	// [1130] _mood_, питі, צלמה_, щувк
  { {0x7cd3000d,0x20d20029,0x7d1a0a5f,0x63ad0a60}},	//   rări, ršie_, _outs, ryan
  { {0x7cd3000d,0xceb2000b,0x63ad0a61,0x89d90012}},	//   sări, _חיי_, syan, جوار_
  { {0x20d20026,0x7cd3000d,0xdfd10003,0x43950014}},	//   pšie_, pări, ويا_, _дамс
  { {0xb05b004a,0x46a50014,0x987c0009,0xe7680012}},	//   liäs, жалв, טראק, محون_
  { {0x79820002,0xf7700003,0x256105d9,0x97580009}},	//   łowa, عان_, tól_, מידו_
  { {0x3ea5000f,0x04590003,0x249f0028,0xfc310003}},	//   _volt_, للغة_, tjum_, وحة_
  { {0x2561000f,0x7eab0051,0xc325004d,0xef190034}},	//   ról_, _küps, омик, _tuż_
  { {0xdb00004a,0x2d8c0052,0x249f0028,0xd299002d}},	//   kymä, _erde_, rjum_, атні_
  { {0x02c5007c,0x2912002c,0x62850a62,0x05670030}},	//   ійно, _siya_, ndho, _číně_
  { {0xd4e7007c,0x6ce7002d,0x2bd00037,0x7d1a0052}},	//   _люди, _ліде, _सेना, _guts
  { {0x2ca6084e,0xc1060012,0x9b950012,0xa3e90011}},	//   _good_, توجي, _ولات, यथा_
  { {0xb4e50037,0x443f02b7,0x10a30048,0xe9ff0081}},	//   पकी_, mau_, фиян, _trặc_
  { {0xdcb10020,0x443f0a63,0x6b890097,0x6d480073}},	//   ển_, lau_, mveg, šdam
  { {0xa1560001,0xc6920009,0xa0c60012,0x6b89005e}},	//   _дају_, ואם_, _ويتو, lveg
  { {0x7afd0010,0x842a00b3,0x6d4303b9,0x62850032}},	//   įstu, ржав_, isna, edho
  { {0xd6d20003,0x5aca01ec,0xd3870063,0xbb4a0012}},	// [1140] _يقع_, алам_, ойте_, شلان_
  { {0x386d008b,0x7cd3007d,0x2ca000b6,0x33d5002d}},	//   _aber_, măru, sjid_, чіст
  { {0x998c003e,0x6d41000f,0x64a60a25,0x68460003}},	//   wadź_, álat, _дана, قَال
  { {0x3f8d0054,0x62950070,0xb05b0a64,0x186a0a65}},	//   _breu_, _enzo, chäd, ради_
  { {0x27e000a1,0x4733002d,0x3f8d0054,0x2ca60070}},	//   çin_, дніс, _creu_, _rood_
  { {0x9f61000f,0xde930001,0xc7b3000b,0x1c0d0037}},	//   ését_, дашњ, ובד_, ाइनल_
  { {0x2ca60051,0x6d43013f,0x20d60024,0xadb70012}},	//   _pood_, gsna, _діас, يهها_
  { {0x5c980098,0xa3ae0011,0x636a004c,0x6aa10040}},	//   ския_, _कथा_, арог_, ejlf
  { {0xae7a0047,0x3f8d0a66,0xdc8b0009,0xdb00008e}},	//   _всех_, _greu_, בְיָ, yymä
  { {0x2ca60a67,0x75960012,0x78a20a68,0xc56a0012}},	//   _wood_, _وجاء, ljov, _نحصل_
  { {0xe29a0020,0x81c60015,0x44320002,0x443f0a69}},	//   _chưa_, ющие, kby_, bau_
  { {0x6d580051,0xb97b000b,0xb05b008e,0x7bdc0032}},	//   muva, בנטי, viäs, ßrus
  { {0xdb00004a,0x6bd60003,0x62830584,0x64400a6a}},	//   tymä, _بتار, _fano, mami
  { {0x7c260058,0x62830a6b,0xb05b008e,0x44320929}},	//   _afkr, _gano, tiäs, eby_
  { {0x9c8306bc,0xa3d00044,0xeca70001,0x31c30048}},	//   íčov, _वेब_, ојан, _осъв
  { {0x4c940015,0x6aaa0052,0x19bb000b,0xb4b50011}},	//   мисс, öffn, _כמוב, झसे_
  { {0x7cd3000d,0x7ce50002,0xdfd10012,0xfbd00012}},	// [1150] căru, tórz, _سيد_, نتك_
  { {0x6d41000f,0xba98002d,0x6d58015e,0x291c019a}},	//   álas, овує_, kuva, _kuva_
  { {0xe2a60065,0x67290013,0xa696000b,0x6d580a6c}},	//   _áður_, _stej, _זכתה_, juva
  { {0x6d580051,0x3f8d0054,0x5d7a0009,0xc19b0009}},	//   duva, _preu_, _פארק, ישבי
  { {0x4c9a0009,0xc49a0009,0xbfb80012,0x64400a6d}},	//   _הברו, _השרת, يطها_, dami
  { {0xcf58000b,0x06c8002d,0xc7d8000b,0x8f7c000b}},	//   קבות_, огій_, חודי_, ינדק
  { {0x60cd0a6e,0xce380009,0xbd450012,0x31780012}},	//   _omam, חאות_, أنبي, _وحفظ_
  { {0xb4e50044,0x64400a6f,0x62830006,0x6d4300bd}},	//   पके_, gami, _sano, rsna
  { {0x38a20002,0x20d20029,0x97250012,0xe4c80012}},	//   _góry_, jšia_, _رفضو, تبون_
  { {0x78a90070,0x644000ff,0x6d58005e,0x7cd3004b}},	//   _hoev, aami, buva, văru
  { {0x64400051,0x6d580027,0xe2a80012,0xceb20009}},	//   bami, cuva, تاين_, _ריב_
  { {0x7d020a70,0xe4d70012,0xd5fa0009,0x64400a71}},	//   _ghos, _بتطب, _הפער, cami
  { {0x69c1000f,0x62830101,0xa295002d,0xdd0c0002}},	//   szle, _tano, _наді, różn
  { {0x7d090a72,0x78bb0164,0xe29a001a,0x0ae80012}},	//   lmes, _lluv, _thưa_, _وروي_
  { {0x2a3a000b,0x443200f1,0x6da609c6,0x6df60012}},	//   _העצמ, tby_, чива, سكرا
  { {0x7d0900a2,0x61fc00a2,0x03260a1a,0x8b260015}},	//   nmes, ürle, здан, здае
  { {0xccf20093,0x305b000b,0x905b000b,0x27ed0054}},	// [1160] תכן_, _הדפד, _הכפת, üent_
  { {0x09e6011f,0x7d090052,0x7c2400c1,0x3e6f0060}},	//   позн, hmes, scir, nıtı_
  { {0xfbc9000b,0xe9da0001,0x7d090a73,0xdee50012}},	//   נת_, љке_, kmes, _تأيي
  { {0xb4e50037,0xd12f0003,0x443d0a74,0x4424003a}},	//   पको_, امن_, _new_, _üm_
  { {0x64400005,0x7d090a75,0x945d0034,0x28bd0011}},	//   vami, dmes, hińs, ्फ़ि
  { {0xab270098,0x33fb000b,0xabfb000b,0x61460a76}},	//   _хора_, _להכנ, _להכר, _нега
  { {0x64400a77,0xda780029,0x09e306bd,0xbd870012}},	//   tami, veď_, _зорн, كنون_
  { {0x89db000b,0x672f0002,0x61db000b,0x11db0009}},	//   _החלי, ypcj, _הקלד, _החלב
  { {0xe737035b,0x8cc10037,0x64400a78,0xdc9b0009}},	//   _нет_, रोटो, rami, מיקל
  { {0xc333015a,0x7d02002a,0x7607000e,0x64400a79}},	//   עות_, _whos, nézé, sami
  { {0x7d020036,0x443d0036,0xdbdd000e,0x64400a7a}},	//   _thos, _few_, váír, pami
  { {0xc7d50014,0x69c10051,0xf8bf0066,0x98ba0010}},	//   джмъ, _ülee, uhé_, rupė_
  { {0xdcb10020,0xdb4f0012,0x74130012,0x76070031}},	//   ểm_, _مَن_, _كوما, kézé
  { {0xba17000a,0xe8030037,0x7cc80066,0x4b7b0009}},	//   _فيها_, रेगा_, věry, _לאדו
  { {0xcaa5000a,0x35e4002d,0x65940015,0x7cd3000d}},	//   _تصني, ецтв, нару, părt
  { {0x20d20029,0x6aaa0a7b,0x41db0009,0x11db0009}},	//   pšia_, _hoff, _לחוס, _לחוב
  { {0x2bc70037,0xd3710003,0xe8030011,0xfbd30012}},	// [1170] _रेखा, ضها_, रेखा_, رتر_
  { {0x7b09001c,0x67bc0009,0xd2510012,0x60080009}},	//   _ažur, _למחק, ئنا_, _מִתְ
  { {0x2d8c0119,0x60dd0a7c,0x2d9e0248,0x63080012}},	//   ådet_, onsm, ätet_, أقلّ_
  { {0x98a6000d,0x1869002d,0xda080012,0x7f75026d}},	//   mplă_, іали_, سينه_, дукц
  { {0xfaf8001e,0x9be4002d,0x62980070,0x8e850001}},	//   klī_, _зірк, _onvo, дгле
  { {0xd2290012,0xe3d40012,0x139a0009,0xf4120009}},	//   _ذكره_, _ستُع, _ובשע, _שפך_
  { {0x78a900bd,0x58d5002d,0x291c0066,0x56920001}},	//   _toev, _жовт, ívat_, тајт
  { {0xcd98000b,0x24f70009,0x62870a7d,0xe3b90147}},	//   לדות_, הֶ֖ם_, _hajo, жби_
  { {0xa3e70037,0x27ff003a,0xf7700003,0x7d090a7e}},	//   _मुख_, _uzun_, _مال_, rmes
  { {0xeab10003,0x25e80037,0xce380003,0x6d470051}},	//   ئعة_, _चुकी_, _فأما_, ksja
  { {0x6d550002,0xba160012,0x76430a7f,0x28c40011}},	//   jrza, ويًا_, many, लोकि
  { {0x644b00c5,0x62980a80,0x2b52003a,0x6d550027}},	//   _udgi, _envo, üncü_, drza
  { {0xa49b001a,0x9b94003c,0x4fa30024,0x945d0034}},	//   _phòn, _пицц, вияв, sińs
  { {0x76430a81,0xad3a0024,0x945d0034,0xbae50012}},	//   nany, жчає_, pińs, _تكتي
  { {0x80a60012,0xd5750842,0x6d410031,0x6d470a82}},	//   _يمتن, нуть, álap, gsja
  { {0x764300b6,0x000000c4,0x000000c4,0x000000c4}},	//   hany,   ,   ,
  { {0x24860026,0xd5b8001e,0x52aa0021,0x76430a83}},	// [1180] ľom_, šā_, овам_, kany
  { {0x0f570093,0x24860a84,0x76430a85,0x6d550a86}},	//   _קיים_, žom_, jany, brza
  { {0x7e9b000b,0xa9670014,0x76430a87,0x5e9b0009}},	//   _וסיו, диха_, dany, _וביק
  { {0xd4160003,0x25870066,0x6aaa0011,0x26de0030}},	//   _يبحث, sílá_, _चक्र, čtou_
  { {0xb9060044,0xe3b20003,0xcf7a0003,0x2eee0202}},	//   _पद_, _شرح_, تصاص_, toff_
  { {0xfbd3000b,0x07a30001,0x67000011,0x998c0030}},	//   _יתר_, таљн, ोगिक_, vadž_
  { {0xf98307e6,0x6d5c0a88,0xdd900012,0x7e7c0a89}},	//   _игро, nura, اوب_, ierp
  { {0x98bf0039,0x2ebb0796,0x6aaa00c1,0xeb4a0198}},	//   kstā_, _उत्त, _soff, очок_
  { {0x764300c6,0xda7a02ac,0x7e7c0a8a,0x0e660a8b}},	//   bany, оян_, kerp, _окан
  { {0x63ab00c5,0x3ce90604,0xcb070012,0x139b0009}},	//   øgni, čava_, ويين_, קביע
  { {0x28f9002d,0x3257000b,0xc27b000b,0x672d0a8c}},	//   зень_, וסים_, חריי, _staj
  { {0x04930003,0x23690002,0x7c930012,0xeb9a0048}},	//   _للمح, ytaj_, _للمص, _мие_
  { {0x6d5c0006,0xa08b0009,0xef640048,0x99620030}},	//   eura, קְטִ, къро, _víře_
  { {0xdcfe0066,0x62980052,0x6d550002,0x93fb0009}},	//   _trpě, _unvo, trza, _ולדי
  { {0x62870a8d,0xda5b0009,0x7eb401a0,0x999e0030}},	//   _rajo, _וכול, _càpi, matů_
  { {0x76430a8e,0xe58b0009,0x90e70012,0x6d470a8f}},	//   zany, חָמָ, _تستن, rsja
  { {0x2d9e008b,0x3f850039,0x2d8c01fb,0x3d160037}},	// [1190] äter_, ālus_, åder_, _पूछे_
  { {0x6d5c060b,0x52770012,0x7e7c0132,0x1a5b0012}},	//   bura, بارز, cerp, تشرة_
  { {0x644f000f,0x51840001,0xe8550012,0x90550198}},	//   ócik, куца, فناد, евец
  { {0x2bd00044,0x7643003e,0x2bcb0001,0x18a40024}},	//   _सेवा, wany, _дуго_, каєм
  { {0x764303d6,0xf388001a,0x62870a90,0x69c50031}},	//   tany, _nợ_, _tajo, szhe
  { {0xbb3a000b,0x69c50051,0x44290a91,0x7d0d0a92}},	//   _מעשי, _üheg, lca_, lmas
  { {0x3f84001e,0x76430a93,0xc6a40048,0x7d0d0a94}},	//   _esmu_, rany, ърци, omas
  { {0x7d0d00a2,0x76430a93,0x60c20a95,0xd7c90012}},	//   nmas, sany, chom, _فوزه_
  { {0x98bf0010,0x6bd50012,0x7e88008e,0x76430a96}},	//   lutė_, عتبر, öspä, pany
  { {0x13060047,0xde970003,0x3eac0621,0x96bb0012}},	//   нный_, _تجرب, _godt_, _بارز_
  { {0x98bf007a,0x644f0002,0x7e7e0051,0x7d0d03ad}},	//   nutė_, _odci, õppe, kmas
  { {0x7eb403eb,0xa156000b,0x3cfb0037,0x2ec80037}},	//   _ràpi, עברה_, ्षों_, रफ्त
  { {0xeb990014,0x5bc40012,0x76410073,0x7eb401a0}},	//   _хил_, _لتوف, _kely, _sàpi
  { {0x09e50047,0x83fd000e,0x3ebe0028,0x98bf001e}},	//   _полн, ggőe, ótt_, rstā_
  { {0x99850012,0xc5d50024,0x75d60012,0x27fa0034}},	//   _ألبو, віть, ريرا, ępni_
  { {0x6d5c08d3,0xf8a90012,0x301a0012,0x7eb00032}},	//   rura, _يديه_, _عتبة_, _päps
  { {0x7c2900c1,0x245a003a,0x42560345,0xa3d00011}},	// [11a0] icer, lümü_, етет, _वेश_
  { {0xae0f0037,0xd2630015,0xb05b031d,0x03950048}},	//   ाधान_, лкуй, nhän, ърся
  { {0x245a003a,0x2726001a,0x2e3b0009,0x6d5c016d}},	//   nümü_, _hôn_, _מגינ, qura
  { {0x70f6000a,0xb87b0013,0x7eb00005,0x442903c1}},	//   رسائ, mníc, _täps, cca_
  { {0xb87b0066,0xbc1b0009,0x20d20159,0x8c1b0009}},	//   lníc, _מוכש, jšim_, _מוכי
  { {0x2726001a,0x7c2b02d2,0x2fc60168,0xbea30538}},	//   _môn_, _afgr, rzog_, лачк
  { {0x91e60146,0xceb3000b,0xf388001a,0x27ec0002}},	//   _чове, ריו_, _sợ_, ędny_
  { {0x69c10051,0xcb1b0037,0x916c001a,0x98bf004b}},	//   _ülea, नदंड_, _gốc_, istă_
  { {0xdcfa000d,0x8c1b000b,0x3eac0a97,0xb05b0032}},	//   _astă, הופי, _todt_, fhän
  { {0xf388001a,0x44290a98,0x2bb70012,0xc1ea0024}},	//   _vợ_, zca_, عاية_, зьме_
  { {0x83fd000e,0x7d0d0a99,0x44290a9a,0x010a0009}},	//   ggőb, ymas, yca_, ּלָּ
  { {0xb87b00f1,0x254c0066,0x8d5500fa,0xa9c30024}},	//   dníc, měl_, _штуч, уськ
  { {0x22450070,0xb05b0052,0x5f940014,0xe0df00b8}},	//   balk_, bhän, гият, rnò_
  { {0x44290002,0x245a003a,0x539b0009,0xdb9b0009}},	//   wca_, bümü_, _מידו, _מסדר
  { {0xfaf7000b,0x212d0030,0x3f840097,0xa4d50024}},	//   _רצוי_, _čeho_, æmur_, вові
  { {0xccf80001,0xf9fb0009,0x79fb0009,0x7d0d020d}},	//   ећу_, _מהומ, _מלוח, umas
  { {0x98bf007d,0x44290a9b,0x7d0d0a9c,0x18340012}},	// [11b0] astă_, rca_, rmas, _صريح
  { {0xb87b05b1,0x62350024,0x7e650032,0xa195003c}},	//   bníc, тежу, _uchp, казч
  { {0xa2b20037,0x395e0054,0x7d0d003a,0xd9990012}},	//   _आकर्, nuts_, pmas, بنات_
  { {0x9f35002d,0x254c0066,0xb9540012,0x69c80060}},	//   веді, děl_, ائلت, izde
  { {0x81bc001e,0x8ca40011,0xc87f0032,0x245a0060}},	//   ucēj, कानो, ieß_, zümü_
  { {0x2ca90a9d,0x03d60009,0xf7740009,0x81bc0035}},	//   ljad_, _יורם_, רקס_, rcēj
  { {0xada50014,0xb5c2002d,0x916c001a,0x5de50048}},	//   тайл, ийшл, _tốc_, ъжка
  { {0xeb99005c,0x69cc0029,0x3af40248,0x3ce909df}},	//   дии_, ôlež, läpp_, čavo_
  { {0xe3b10003,0x6d580051,0x9998000d,0x130900fa}},	//   شرة_, arva, _terţ_, мний_
  { {0x7eb00872,0x68f60a9e,0x8a38003c,0x7c290a9f}},	//   _näpp, _skyd, няют_, scer
  { {0x6016003a,0x395e0054,0x22580034,0xb05b0aa0}},	//   _tümü, guts_, órka_, rhän
  { {0xb87b0145,0x245a003a,0x2d980aa1,0xe5080012}},	//   vníc, rümü_, _área_, _كيلو_
  { {0xfd100003,0xb90a0037,0xb05b0245,0x22950012}},	//   _اجل_, _मद_, mhäl, _للإس
  { {0x79820002,0x5b56000b,0xfaa50001,0xb87b00d9}},	//   łowi, _ישנן_, _јако, tníc
  { {0x26c10029,0xdd920012,0xb05b0032,0xe6430aa2}},	//   _dlho_, جوز_, chäo, респ
  { {0x2726001a,0x97c60003,0xb87b0042,0x47d60012}},	//   _tôn_, _لقبو, rníc, _ليعر
  { {0x46ea064f,0x93590109,0x74130012,0xb87b03a7}},	// [11c0] _один_, ерху_, لوفا, sníc
  { {0x6a160012,0x248d0032,0xb87b08ca,0x63a60248}},	//   نبار, hdem_, pníc, äkni
  { {0xae57000b,0x1e570009,0x7d0a004c,0x67240244}},	//   _בסיס_, _בשיר_, _оног_, _huij
  { {0x63b6004a,0x79950002,0x7eaf0033,0x248d0aa3}},	//   pyyn, _drzw, _søpp, jdem_
  { {0xc0a90003,0x23d00037,0x79950052,0x6f1a0aa4}},	//   عامل_, _तेंद, _erzw, _pitc
  { {0x254c0066,0xe2450012,0x6d5801e9,0x201f00b8}},	//   těl_, _مخفي, trva, _egui_
  { {0xa01b000f,0xe9a3026d,0x6eb30011,0x7b060097}},	//   ldöt, _карп, _अवरु, yðub
  { {0x6f1a0aa5,0xd467004c,0x628a026b,0x26d80aa6}},	//   _witc, виће_, _safo, hiro_
  { {0x2c6d000f,0xc4d3000b,0x7bc90052,0xaa820028}},	//   lódó_, יגה_, gzeu, _þýsk
  { {0xbe85000a,0x69c80052,0x254c0030,0x24800aa7}},	//   _مجمو, tzde, pěl_, heim_
  { {0x4a5b0009,0x6aba0032,0x58d90472,0xf2d30009}},	//   ודיו, rktf, едня_, שעת_
  { {0x98bf007a,0xe3ba020e,0x9f350024,0x138a0012}},	//   kstą_, _обе_, лемі, _يخشى_
  { {0xe7030020,0x35a80011,0xc4cf0012,0x87e70048}},	//   _hướ, _कपड़, _بْن_, тюне
  { {0xbc1b000b,0x11d60003,0x7a48001e,0xb3c1001a}},	//   _חודש, _لتعد, nūtē, _ngýờ
  { {0x2ca90051,0x04670055,0xb05b0248,0xa5f80aa8}},	//   tjad_, ктам, lhäm, веру_
  { {0x20d2009b,0x5454002d,0xba170009,0x02170009}},	//   jših_, ивст, _בחוץ_, _בחום_
  { {0x3a750015,0x68e200f1,0x26d80aa9,0x2ca902eb}},	// [11d0] ллар, dnod, biro_, rjad_
  { {0x2ca90051,0xeab40009,0x7a540012,0x75d50012}},	//   sjad_, נִּי_, لضما, _ميخا
  { {0x68e30164,0xe703001a,0x6b840002,0xceb20009}},	//   éndo, _nướ, awig, _היי_
  { {0x236d0034,0x55ba0009,0xc864004c,0x61fc0aaa}},	//   ytej_, _נמרו, атљи, _dyrl
  { {0xdcb10020,0x7645004a,0x8afd0066,0x78bd0070}},	//   ểu_, _kehy, stři, iksv
  { {0xe7030020,0x0e64002d,0x6234011d,0x7d1d0aab}},	//   _bướ, икін, _веру, _hiss
  { {0xb05b008b,0x4519010c,0xc98400f5,0xa5640012}},	//   thäl, нция_, _кути, لدين
  { {0xe7030020,0x05760003,0x7d760012,0xf5760012}},	//   _dướ, امية_, امير_, اميع_
  { {0xb05b0052,0x2b1501b6,0x7d1d0aac,0x248d0aad}},	//   rhäl, льор, _miss, rdem_
  { {0xc9a90015,0x7bc90052,0xdb140028,0x93fc0009}},	//   евое_, rzeu, ðaðr, ולחי
  { {0x291e0108,0x236d084b,0x0165003c,0xd567004c}},	//   _état_, stej_, ыкно, _штап
  { {0x2f040028,0xa3b50037,0xc6890009,0x81760009}},	//   gögn_, ड़ना_, _מא_, נגרס_
  { {0x442d0aae,0xe28e068f,0xddc70031,0x67240aaf}},	//   mce_, _ла_, dejű, _quij
  { {0x7c2d00b6,0x442d0126,0xfaf90073,0x7c3b0ab0}},	//   ecar, lce_, rtūs_, lbur
  { {0x6281007d,0x5de60014,0xdcfa0002,0x8db5002d}},	//   melo, ужва, _wstą, асті
  { {0xa7d60003,0xa9220014,0x93c5001a,0x62810ab1}},	//   _متخص, _удъл, _trắ, lelo
  { {0x78ad0066,0x98bf0010,0x442d0ab2,0xdcf70012}},	// [11e0] žová, ustą_, ice_, افقت_
  { {0x7f3b000b,0xc332000b,0x2480000e,0xdd04003a}},	//   _רעיו, צוב_, seim_, ırır
  { {0x2d960046,0x442d0013,0x68e200bd,0x49960015}},	//   _српс, kce_, tnod, ышат
  { {0xccfa002d,0x70560003,0x5ca60538,0x34fa0024}},	//   _їхні_, انشا, _симб, _їхню_
  { {0xdfd00003,0x442d0ab3,0x6903005e,0x62810ab4}},	//   غيت_, dce_, mõel, kelo
  { {0x62810ab5,0x6d5c0ab6,0xee2a0012,0x442d0ab7}},	//   jelo, orra, رأته_, ece_
  { {0x72c30001,0xf1a70012,0x62810ab8,0x6446016d}},	//   _убрз, _اء_, delo, _keki
  { {0x6f1e0002,0x7c3b0ab9,0x628e0aba,0x4498003c}},	//   _lipc, gbur, _habo, твию_
  { {0x28a80037,0xe0d50015,0xb4e40321,0x6d5c0032}},	//   गानि, _тюрь, _नदी_, hrra
  { {0x26c7072d,0x49740abb,0x6c1b0009,0x62810abc}},	//   chno_, алос, עֵהו, gelo
  { {0xe9f90081,0x764a0097,0xa2f70009,0xa6970009}},	//   _đả_, mafy, רמיה_, _תכבה_
  { {0x0217000b,0x442d0abd,0x64460abe,0x7c3b0060}},	//   טחים_, cce_, _neki, cbur
  { {0x2d9e021e,0x62810abf,0xb4c00011,0x78bd0ac0}},	//   åten_, belo, ँसी_, rksv
  { {0x442d0656,0x7d1d0005,0x62810ac1,0x623403e2}},	//   _że_, _siss, celo, _теку
  { {0x644600bd,0x7c2d00bd,0xc6b7000b,0xd5780009}},	//   _beki, tcar, נהלי_, כָּר
  { {0x69c50051,0xd1380010,0x57b50024,0x28b90011}},	//   _ühea, mpą_, _вбит, _आवधि
  { {0x7d1d0ac2,0x7c2d0ac3,0x2d910030,0xd25b004c}},	// [11f0] _viss, rcar, _ázev_, еце_
  { {0xf8bf0066,0x25a5006f,0x7d1d0358,0x6e670001}},	//   lké_, älls_, _wiss, _стиж
  { {0x60c4004a,0xaae8002d,0x7bdc0060,0x442d0ac4}},	//   _ylim, уєте_, ğruy, yce_
  { {0x69c10051,0x7f5d0061,0xdd3a0009,0x3d0e0011}},	//   _ülem, orsq, _שערכ, ागों_
  { {0x07a50ac5,0xa858000b,0x442d0ac6,0xa8480012}},	//   ралн, רידה_, vce_, الهم_
  { {0x7c220149,0x05550014,0x442d0002,0xed59027f}},	//   _agor, атия, wce_, вок_
  { {0x442d0ac7,0x8aa80009,0xfd110012,0x62810ac8}},	//   tce_, _עֹשֶ, يجب_, velo
  { {0x62810002,0x628e01ae,0x4735077e,0xed640042}},	//   welo, _zabo, _внас, leží_
  { {0xe7300003,0x62810ac9,0x56670012,0x4b25004c}},	//   _فصل_, telo, _مداف, јмов
  { {0x3b090001,0x442d0aca,0x6ab50048,0xd7740012}},	//   ђено_, sce_, рсих, _دافع
  { {0xb0b90044,0xceb8003e,0xfad6000b,0x787c0033}},	//   _आवाग, _więc_, שותך_, _nåvæ
  { {0x65630017,0x7d560009,0xdcfa0034,0x272b0040}},	//   munh, _כיעד_, _ostę, _køn_
  { {0x644603b9,0xd706035c,0xdcfa0073,0xfaa50400}},	//   _reki, изми, _artė, _вало
  { {0xed5a0046,0x98ab0039,0x7c22012e,0x64460acb}},	//   ког_, ībā_, _zgor, _seki
  { {0x2cbf0013,0x68fb003a,0x2bd90011,0xdcfa0034}},	//   okud_, _okud, _बेता, _astę
  { {0xdcfc0027,0xf8bf0107,0xc952000b,0x628e0acc}},	//   tvrđ, cké_, _ומה_, _sabo
  { {0x69c10051,0x3f8c001e,0x4a460345,0x1eca0001}},	// [1200] _ülej, ādus_, инав, _алпи_
  { {0xed460800,0xcfb7000b,0x19960001,0x499605fb}},	//   _кноп, _כלפי_, ијер, ишет
  { {0xae5b0009,0x365b0009,0x0e5b0009,0xf506003c}},	//   _בכיר, _בכינ, _בדיב, _взно
  { {0x26c500c1,0xe73a0014,0xdfda0014,0x4f660012}},	//   _allo_, вед_, къл_, لاتف
  { {0x16340014,0xddd80066,0xa067035c,0xde580024}},	//   беля, devš, рача_, галі_
  { {0x62980029,0xafdb0058,0xf8bf00d9,0x46d00011}},	//   ôvod, sbøg, zké_, थोंह
  { {0x09fa0003,0xbd870003,0x20d20029,0x91e300fa}},	//   _شفرة_, لنون_, lšiu_, _доре
  { {0x26c50164,0xd4970015,0x44220033,0x7b060028}},	//   _ello_, арь_, øk_, gðun
  { {0xef1a0345,0xdc890009,0x82a60337,0x185b0009}},	//   _ама_, רְצָ, ашне, _שכמע
  { {0x291f007d,0xb2730015,0x657e0033,0x33770009}},	//   _ziua_, ольш, _opph, סעים_
  { {0x2163002d,0x5d860003,0x63bb002c,0xe1d8002d}},	//   отяг, _خلال, ayun, удні_
  { {0xddc50066,0xc5f30009,0x55bb0009,0xd1380073}},	//   _schů, _ודע_, _שמאו, rpą_
  { {0xdb02008b,0x69c50005,0x76480026,0x27ed003a}},	//   _groß, _ühen, _kedy, çen_
  { {0x7648003e,0x26c50164,0xf8bf0145,0x7b100052}},	//   _jedy, ólo_, ské_, läuf
  { {0x3a37000b,0xdddc0027,0xc534000b,0xb87b015b}},	//   _דרום_, adrž, מָּה_, lním
  { {0xc05b007c,0x50d40003,0x6ca406fd,0xdddc0042}},	//   _рік_, _وزير, оруж, bdrž
  { {0x75280acd,0x2bba0002,0x53990015,0x04f4002d}},	// [1210] _ludz, jącą_, ывая_, ізую
  { {0x69c10051,0x2d870002,0xd7fc000b,0x68e90a48}},	//   _ülek, ywne_, _בהחל, _sjed
  { {0xc8ab0014,0xdcfa0002,0x2127001a,0x7bcd000e}},	//   къде_, _wstę, ênh_, szau
  { {0xf771000a,0x859a000b,0xe0d00012,0xd0580024}},	//   كات_, _עשרו, وزن_, арші_
  { {0x2bde0037,0x644d0269,0xdcfa0034,0x83fd0031}},	//   _नेपा, maai, _ustę, ggől
  { {0x141a000b,0xddc5002d,0xb87b05b1,0x6e950012}},	//   _תושב, йбли, dním, إلغا
  { {0xcb12000b,0xd658000b,0x2247003a,0x68e90027}},	//   _מלך_, ביות_, _renk_, _tjed
  { {0x68e90ace,0x20d20030,0x0c220048,0xf8bf0064}},	//   _ujed, nšit_, пмън, _ôé_
  { {0x7b060028,0x2cad0acf,0x1c42003c,0x27ff0060}},	//   rðun, rjed_, чным, _uyun_
  { {0x62850119,0xfbd2000b,0x65630018,0x2cad001b}},	//   neho, פתי_, punh, sjed_
  { {0x63bb002c,0x66c20064,0x60dd0ad0,0x95c803b0}},	//   syun, _dôkl, fism, _куца_
  { {0x397a0093,0x67210ad1,0x297a0009,0xe6040012}},	//   נטרנ, _hilj, נטרא, _بِمَ
  { {0x8ca40037,0x6601004a,0x80aa0037,0xeaae02ad}},	//   कारो, _hylk, टाबे, _ей_
  { {0xceb2000b,0x24180024,0x20d20064,0x7d180031}},	//   ֔ים_, _тією_, všiu_, _évsz
  { {0x628500c5,0xceb20214,0x9595002d,0xe5060003}},	//   deho, ליך_, ошті, مبري
  { {0x70b60037,0x6b890002,0x75d30012,0xd5af0012}},	//   _अकेल, oweg, سيقا, رفق_
  { {0x6b890ad2,0x67560012,0x24920034,0x1d070ad3}},	// [1220] nweg, _اخبر, rdym_, сети_
  { {0x8e860012,0x9e660ad4,0x62850a62,0x20d20064}},	//   _الده, _увод, geho, ršiu_
  { {0x657e07e3,0x499a003c,0xccf90034,0xf8b90011}},	//   _upph, ытая_, koś_, _आवशय
  { {0x443f001b,0x20d20064,0x61fc0032,0x77ca003c}},	//   jbu_, pšiu_, ürli, ллег_
  { {0x44320002,0x4b550014,0x67210ad5,0x7bdd0031}},	//   mcy_, _мърт, _bilj, úsul
  { {0xdfa50003,0x6721048b,0xb87b0066,0x7d040ad6}},	//   تحمي, _cilj, vním, llis
  { {0xb05b0ad7,0x26dc0ad8,0x6721001b,0x91fc0035}},	//   mhäv, rivo_, _dilj, agāj
  { {0x39570093,0x6cd40003,0xccf90002,0xb87b0066}},	//   _לשלם_, تقبا, goś_, tním
  { {0x6c770003,0xab94002d,0x7d040ad9,0xe81a0011}},	//   صحيح_, ципі, ilis, नेमा_
  { {0x52d8002d,0xa9540001,0x0bb70009,0xbf370009}},	//   рмою_, овољ, צלים_, _לאמץ_
  { {0x8afb0009,0x69c50051,0xf297000b,0x7dc50012}},	//   רפיק, _ühel, זכיר_, _وتمك
  { {0x23600027,0x66cb003a,0x60c20ada,0xb87b0adb}},	//   krij_, _müke, nkom, mník
  { {0x6d5a0026,0x02fa0037,0x833a0015,0x44320002}},	//   átan, ्ताह_, _счет_, dcy_
  { {0x7d160029,0x98bf0010,0x43570009,0xf1a60760}},	//   emys, putį_, _פסול_, _грин
  { {0xb6bb000b,0x60c208af,0x6d5a05dd,0x60dd0404}},	//   נצלי, kkom, štan, pism
  { {0xf98f000a,0xa4d40024,0x9c390adc,0x66090030}},	//   _أبو_, посі, рпат_, řeko
  { {0xdc9b000b,0x88bd0002,0x2d8c0058,0x4374002d}},	// [1230] נימל, _liśc, æder_, зуєт
  { {0x3255002d,0x644d0051,0x7afa0add,0x6bd40012}},	//   івер, saai, nott, ستقر
  { {0x20d20066,0x18370003,0x27e00028,0x62850ade}},	//   pšit_, مرشح, úinn_, reho
  { {0x6285002a,0xb87b00d9,0x7afa0adf,0x44320034}},	//   seho, dník, hott, ccy_
  { {0x672901e3,0xdddc004b,0x7afa0ae0,0x38600031}},	//   _quej, perţ, kott, óira_
  { {0xe80f0037,0x98aa001e,0x91fc0035,0x7afa0ae1}},	//   ़ेगा_, ājām_, rgāj, jott
  { {0x443f00f1,0x7afa0ae2,0x67210ae3,0xd6580009}},	//   tbu_, dott, _vilj, זיות_
  { {0xa0c50003,0x7ae809bc,0xe81a0011,0xbd480012}},	//   _بيرو, endt, नेडा_, حؤول_
  { {0xb87b0066,0x7b100052,0xa3c20011,0xe3b6003c}},	//   mníh, bäud, एईए_, жбы_
  { {0x6601003e,0xb87b0042,0x6fb80011,0x68ed005e}},	//   _tylk, lníh, ्नरू, _ajad
  { {0x6b8903de,0x44320034,0xb87b068c,0x7d040ae4}},	//   sweg, ycy_, cník, ylis
  { {0xb87b0066,0xcea90009,0x2eb40011,0x95c40012}},	//   nníh, _בי_, ुस्त, _عينه
  { {0x66090030,0x7d040060,0x9ad50012,0x3cf80031}},	//   řekl, vlis, _وتتض, _írva_
  { {0x4432003e,0x272f003a,0x6b94000e,0x8f9a0009}},	//   wcy_, _dün_, üggő, בישי
  { {0x644b00c6,0x60c907f6,0xc8b90011,0x2d980ae5}},	//   _kegi, _olem, _आवंट, uvre_
  { {0xb87b0066,0x25a5006f,0x23600ae6,0xe0df00b8}},	//   jníh, ålla_, trij_, ciò_
  { {0x272f00a2,0x8b26007c,0xeb970015,0xb87b022d}},	// [1240] _gün_, ідже, оит_, dníh
  { {0xda660003,0x44320002,0xda650003,0x88050012}},	//   تاري, scy_, كامي, _عظيم
  { {0x6459003e,0xe9da0001,0x7d040ae7,0x60c20ae8}},	//   _odwi, јке_, plis, tkom
  { {0xdfd20003,0xa8a30001,0x7afa000e,0x2056002d}},	//   ويض_, дршк, zott, ітер
  { {0x02460012,0x2bd90011,0xb05b0245,0xf76f0012}},	//   _وَحَ, _बेला, phäv, ناو_
  { {0x8f9b0093,0x66cb003a,0xd7f9002d,0xe0df00c1}},	//   ייני, _tüke, щує_, ziò_
  { {0xb05b0163,0x2bde0037,0xb87b0066,0x6da30001}},	//   dkän, _नेता, bníh, дија
  { {0x41270ae9,0xb87b0004,0x60c90260,0xc4f70012}},	//   _фото_, rník, _glem, يعيا_
  { {0x7afa000f,0x8e7601ec,0xe0df00b8,0x644b0aea}},	//   tott, _мужч, viò_, _degi
  { {0xa2a70037,0x3ce00051,0x7afa004a,0x6f790009}},	//   फ़ॉल्, hiiv_, uott, _לְעו
  { {0xd8f9002d,0x2730001a,0xdce30066,0x75d60012}},	//   йної_, _hàn_, ntně, _بيضا
  { {0xa9c3002d,0x6ab70011,0xb87b0030,0xb834003c}},	//   фськ, _आक्र, diíc, меющ
  { {0x69c10005,0x6d5a0026,0xdb240051,0xc053000b}},	//   _ülev, štal, öpäe, וזר_
  { {0x20050039,0xdefb0015,0x2730001a,0x7bdb0009}},	//   āli_, рым_, _màn_, _דקדו
  { {0xc4db0001,0x344b00db,0x15150024,0xe5340024}},	//   ађа_, ичан_, здвя, десь
  { {0x5ce7002d,0xa5f80024,0x8d5b0009,0x27300081}},	//   іюва, цесу_, יכלי, _oàn_
  { {0xb87b0013,0x60c0012b,0x10170012,0x28a80011}},	// [1250] vníh, ömme, _ببغد, गारि
  { {0x501c000b,0x8c1b000b,0xb4c70037,0x2d9e0052}},	//   _דוחו, שומי, _उत्_, _orte_
  { {0x62880aeb,0xb87b0aec,0xdc3f022d,0xdb11000e}},	//   iedo, tníh, líčk, égén
  { {0x15fa000b,0x2730001a,0x26f50037,0x7bc00010}},	//   _להתע, _bàn_, ेत्र_, kymu
  { {0x6d55000f,0xb87b0066,0xa7870012,0x7feb0012}},	//   lsza, rníh, تشاو, جراف_
  { {0x7bc00010,0x59ca0037,0x853c0010,0x62880580}},	//   dymu, ानार, _orėd, jedo
  { {0x6e350002,0x645d0010,0x6b8d00c7,0x62880aed}},	//   iczb, ųsim, lwag, dedo
  { {0x28f8002d,0x60db029a,0x60c909bc,0x2919001b}},	//   _десь_, _umum, _ulem, jmsa_
  { {0xf41f004a,0x2d9e0032,0x6b8d0529,0x644b0aee}},	//   ää_, _erte_, nwag, _vegi
  { {0xdd950015,0x69c50051,0xeb92000b,0x02b60009}},	//   _назы, _ühek, תָה_, ִ֔ים_
  { {0x644b0051,0xe8fa002d,0x6abc09d1,0x62950826}},	//   _tegi, йло_, örfa, _mazo
  { {0x62950aef,0xb05b0248,0x7d7a0009,0x69c1005e}},	//   _lazo, skän, _לנעו, _üleu
  { {0x20040065,0x6d550034,0xb05b0248,0x47c30048}},	//   æmi_, esza, mkäl, ебяв
  { {0xdce30af0,0x6d5a0027,0x539a0009,0x9bb60009}},	//   ytně, štam, _לינו, _מהנה_
  { {0x2d9e0107,0x6d55000e,0x6da300f5,0xd5750024}},	//   íte_, gsza, нира, муть
  { {0x7ae1004a,0x91ba000b,0x19ba0009,0xb87b0030}},	//   lilt, _למצי, _למצב, riíc
  { {0xb05b004a,0xab660048,0xe45f0248,0x23690064}},	// [1260] ikäl, явал, _glöm_, guaj_
  { {0x0e660015,0x3f92002c,0x9f9b000b,0xcff70009}},	//   _экон, _isyu_, _פסיפ, _מצפה_
  { {0xdebb000b,0x3ebb000b,0x7bc00002,0xb6bb0009}},	//   _המיל, _הציב, zymu, _הציי
  { {0xdce30066,0x186a024d,0xf8cc0011,0xba170012}},	//   rtně, сади_, ासिय, سينا_
  { {0x4733002d,0x4c9b0009,0xa8570009,0xce940048}},	//   еніс, _הבכו, פיסה_, далъ
  { {0x99640013,0x29060051,0x9757000b,0x7ae1004a}},	//   může_, sloa_, לינו_, jilt
  { {0xb87b0066,0x65930012,0xb0cc0011,0x673b008e}},	//   mnív, فجير, ासाग, _etuj
  { {0x7bc0007a,0x515b000b,0x20040002,0x2730001a}},	//   tymu, _לכלו, _tymi_, _tàn_
  { {0xfc3f0164,0x66cb0051,0x5b14003c,0x2f040097}},	//   ñía_, _lüka, ммит, lögu_
  { {0x7f3b000b,0x86ea0003,0x2aaa0001,0x7ae10af1}},	//   _לעמו, _اعرف_, стио_, gilt
  { {0x6d5a001c,0x69c10051,0xd6cf0003,0xa63b0009}},	//   štaj, _ület, _حقل_, _הגבר
  { {0xeafa0037,0xab5d0002,0x68e20034,0xd1260012}},	//   ्तुत_, wyże, niod, ضم_
  { {0xa4b7000b,0x04430021,0xc4d30009,0x6cc30148}},	//   _מלאה_, _чечн, _אגף_, _яйца
  { {0x96eb0021,0x8c1b0009,0x7ae10030,0x0ebe0011}},	//   сьма_, _הודי, cilt, ्सिड
  { {0xf297000b,0x7a7b000b,0x4a7b000b,0x67250038}},	//   _זכור_, _הרוס, _הרוב, _vihj
  { {0xb9250003,0x6d550053,0x1cbb0012,0x27f20034}},	//   _تفعي, rsza, حاسب_, żyny_
  { {0x6d550272,0x46be0011,0xfc300012,0xa4d40024}},	// [1270] ssza, ्साह, احف_, хоті
  { {0x88bd0034,0xb05b0032,0xd3d80012,0xc1780073}},	//   _ciśn, chär, سبقا_, otė_
  { {0xc1780010,0x5fca0011,0x66bc0009,0x75150048}},	//   ntė_, ़ैसल, _למזה, _омоф
  { {0xc5f20093,0x2ec50044,0xa3cc0037,0xa3be0037}},	//   _ידי_, वस्त, रना_, ीना_
  { {0x22680066,0x69d80028,0x4c9a0009,0x46d10011}},	//   átké_, úver, _וברו, _हताह
  { {0x60cd02d1,0xc7d8000b,0xbe650012,0x2557004b}},	//   _llam, הודי_, ذهبي, tăl_
  { {0x644f00c6,0xf6500003,0xd1640014,0x60cd003a}},	//   _keci, ائه_, _пъти, _olam
  { {0x68e2000d,0x2ee30070,0xd5780009,0xa2d90011}},	//   ciod, hijf_, פתחה_, फोर्
  { {0x3af5002d,0x3e5f001e,0x7ae10af2,0xbe4b0012}},	//   дянс, tātē_, tilt, _هشام_
  { {0x66cf0119,0x69c10af3,0x78bb0017,0xfb160003}},	//   _bøke, _üles, _houv, وقيع_
  { {0xbe640003,0x208a0014,0xa88a010c,0xca360009}},	//   _أهمي, ойни_, ойна_, ונתה_
  { {0xafe600c0,0xc19a000b,0xd7f8000d,0xa4d40024}},	//   домл, קשרי, şăm_, _похі
  { {0x78bb0061,0x92b50003,0x0056000b,0xe20a0037}},	//   _mouv, _يحتا, ושרת_, _वर्ण_
  { {0x8cab0037,0x60cd002e,0x3ced005e,0x7d090af4}},	//   झावो, _elam, lnev_, lles
  { {0xcb120093,0x66d0004a,0x66030024,0x69c70040}},	//   _שלו_, _näke, впра, øjed
  { {0x78bb0108,0xe8f60003,0x6561000e,0xf50a002d}},	//   _nouv, _تستخ, álha, інал_
  { {0x073a000a,0xa2d40037,0x9f1a0012,0x95e90011}},	// [1280] _بسبب_, योक्, _وآخر_, टपुट_
  { {0x244c001a,0x68e20002,0xba6a0012,0x273b004b}},	//   ếm_, wiod, تحرك_, _mână_
  { {0x27340006,0xc04f002d,0xdce9003a,0x2241005e}},	//   _hän_, кі_, _çoğu, _õhku_
  { {0x7d09000f,0x78bb0061,0x644f003a,0x7bcd001e}},	//   jles, _couv, _geci, _ļaun
  { {0x78a9048b,0xba560014,0x69030051,0x2f040028}},	//   _dnev, _отвъ, võet, sögu_
  { {0x2734006f,0xc7d70009,0x6ea70011,0x46a30048}},	//   _män_, ווני_, खाएँ, качв
  { {0xdcb10020,0x2734006f,0x78660012,0x7d090af5}},	//   _hủy_, _län_, _يدرك, fles
  { {0x8d170003,0x78bb0af6,0x05170012,0x99720030}},	//   وزير_, _gouv, وزيع_, těže_
  { {0x66cf03a0,0x69c10051,0x128a0048,0x228a004c}},	//   _søke, _üler, ощни_, ољно_
  { {0xc17a002d,0x60cd0825,0x80da0011,0x76a60012}},	//   оїм_, _slam, पोरे, _تحرك
  { {0x7d090af7,0xa2d40011,0xba9b0009,0xd6250012}},	//   bles, योग्, קסטי, _كعمي
  { {0xe4a5002d,0xd4c60003,0xc1780010,0x6d580af8}},	//   _пріо, _تغطي, rtė_, msva
  { {0xb33b0149,0x644f0af9,0xc1780010,0xe8f1000b}},	//   _orça, _reci, stė_, אֻם_
  { {0x7d00000f,0x5bb7002d,0xfbd3000b,0xd3b7002d}},	//   loms, _юлія_, _בתנ_, _юлії_
  { {0x12fb000b,0x27fa0002,0x8afb000b,0xf98f0012}},	//   _והגב, ępny_, _והגי, _نبي_
  { {0x7d000afa,0x60cd00b6,0x6ee90027,0x9597000b}},	//   noms, _ulam, džbe, וכלו_
  { {0x66d00163,0xd3710003,0xbf0e0037,0xe3150001}},	// [1290] _säke, طها_, िताभ_, емањ
  { {0xd2510003,0x2904002c,0x78bb0afb,0x32070002}},	//   انا_, _akma_, _souv, żnym_
  { {0x78bb0108,0x2d9e006f,0x7d000afc,0x7d090afd}},	//   _pouv, åtet_, koms, yles
  { {0x629801a2,0x9015002d,0xd0110012,0xc0520009}},	//   _lavo, нфлі, هلا_, ָ֖א_
  { {0x8e85011f,0x6d5a079d,0xc43a0009,0xe7580024}},	//   егле, _avta, _מתרי, дичі_
  { {0x62980133,0x6d580028,0x66cf0033,0x3f4d0035}},	//   _navo, fsva, _søkb, ižu_
  { {0xdce8003a,0xd5b10003,0xade80012,0x66360012}},	//   _ardı, افع_, وفهم_, ركيس_
  { {0x273b007d,0xcf7b000a,0xb9250003,0x9f51000e}},	//   _până_, _وإذا_, _أفري, ából_
  { {0x13e9002d,0x76550002,0x63a20afe,0xf7700012}},	//   ямий_, kazy, _cron, _نال_
  { {0xeab1000a,0xaad90044,0x7dee000f,0x394504b3}},	//   اعة_, योंक, nősé, нног
  { {0x88e60015,0x62980052,0xdce3001e,0x8d740012}},	//   ежне, _davo, aunā, _لانا
  { {0x0ef80037,0xd59a0009,0xea000081,0x63a20aff}},	//   ंक्स_, _מבעל, hiếu_, _fron
  { {0xfb680003,0x62980b00,0xcbc70012,0x63a20b01}},	//   _قصوى_, _favo, _تزاي, _gron
  { {0x2734006f,0x62980010,0x76550002,0x8afd00d0}},	//   _vän_, _gavo, gazy, kuři
  { {0xddc1002d,0x99d70012,0xdd920012,0xb87b0064}},	//   аттi_, _تتشا, دوز_, tnít
  { {0x91fc001e,0x89da0009,0x8b660012,0x7a310031}},	//   rgāt, _מחצי, فاطم, _fűté
  { {0xc32a0003,0x29020073,0xb87b068c,0x6abd05f3}},	// [12a0] سكان_, moka_, rnít, ोसूर
  { {0x6d58004a,0x68e60b02,0x29020b03,0x19f6004c}},	//   ysva, likd, loka_, нџер
  { {0xa84a0003,0x80660048,0x91fc0035,0x6abc0b04}},	//   كلام_, евеж, lgār, _vorf
  { {0x7ae5004a,0x25a50058,0x26150011,0xab5d0034}},	//   aiht, ælle_, _धरती_, zyża
  { {0x1dd80037,0x66e60b05,0xe3b20012,0xa8570009}},	//   _भेजत, нода, _صرح_, תינה_
  { {0x66cb003a,0x6d580b06,0x64560b07,0xda6500ae}},	//   _nükl, tsva, layi, _لافي
  { {0x6728001c,0xe9f9001a,0x867b0009,0x69c1005e}},	//   _vidj, _đế_, פרקו, _ülep
  { {0x62980b08,0xdd990024,0x63a20b09,0x692c004b}},	//   _savo, ьші_, _pron, _eşec
  { {0xe3b20003,0xaf490012,0x1e860229,0x29020b0a}},	//   ارع_, _يشكل_, _плам, doka_
  { {0xdce3001e,0x539b000b,0x6456002c,0x629a0058}},	//   runā, ליפו, hayi, udto
  { {0xb0cc0037,0x28f9002d,0x63a20b0b,0xc27b0009}},	//   ासंग, день_, _wron, הריי
  { {0x63a2008a,0x34560003,0x45b70009,0xdfd10012}},	//   _tron, _أنشأ, _רפאל_, ليج_
  { {0x62980b0c,0xd8db000b,0xbfa80015,0x09dd01e1}},	//   _tavo, לקטר, нтре_, _मध्य
  { {0xb3e90003,0x79820002,0x61eb000e,0xdb060b0d}},	//   _تعمل_, łowy, állá, ämäk
  { {0xc8f50048,0x7ae50159,0xa1940048,0x7dee0031}},	//   _изкъ, viht, _райч, vősé
  { {0xb05b004a,0x47d50012,0x88bd0034,0x68e60064}},	//   kkäi, _ليبر, _piśm, cikd
  { {0x66cb003a,0x7dee000f,0xea670046,0x1b780003}},	// [12b0] _yükl, tősé, ењен, فصلة_
  { {0x69110b0e,0x63bd0192,0x3a74003c,0x2bb800ae}},	//   gåen, øsni, ллур, راقة_
  { {0x1df90015,0x7ae5003a,0xa5f9020e,0xb9250012}},	//   _цены_, riht, _цену_, نفطي
  { {0xf7710351,0xcdb60009,0x7ae503bd,0xa9070012}},	//   لات_, _ספרה_, siht, ربان
  { {0xf8b2000b,0x4cba0009,0xd8b80012,0x7d0d0699}},	//   ישׁ_, _חזרו, عدما_, mlas
  { {0x9f380009,0x7d0d0b0f,0x7b060097,0x67d2004c}},	//   תנגד_, llas, iðus, рољу
  { {0xa2a10037,0x6d5a0027,0x8aa40014,0xbe980012}},	//   _कोष्, štav, _сряд, عضها_
  { {0xa2a90011,0xb47b0009,0x6b84004b,0x7d0d0b10}},	//   घाक्, לָ֖י, _ţiga, nlas
  { {0x98a8000d,0xf7730012,0x66d00248,0x999e0073}},	//   _lună_, _حاز_, _läka, katų_
  { {0x7d0d0107,0x23690027,0x6d430b11,0x97240012}},	//   hlas, iraj_, ppna, _مفقو
  { {0xcb120009,0x999e0073,0xa06a0b12,0xddd50031}},	//   שלי_, datų_, мана_, kezű
  { {0xa2a10037,0x48e60014,0xf992000b,0x23690027}},	//   _कोर्, томв, ברט_, kraj_
  { {0x5bc4000a,0xf3670015,0xe28e05f7,0xe0d70048}},	//   _متوف, _чтен, _ка_, твя_
  { {0x6f030b13,0xdce3007d,0x98a8007d,0xf743002d}},	//   nonc, bună, _bună_, реро
  { {0xfc3f0029,0x82340003,0x7d0d0b14,0xd24e0012}},	//   _kníh_, _إرها, flas, _بنى_
  { {0x7bcd001e,0x98b8001e,0x7d0d0b15,0x753c0031}},	//   _ļauj, _otrā_, glas, _érze
  { {0x24780066,0x8bac0009,0x6f030b16,0x24800018}},	// [12c0] _němž_, ּׁבִ, konc, rfim_
  { {0x4a43002d,0x69c50051,0x7d0d01a3,0xd707003c}},	//   инув, _ühes, alas, _иные_
  { {0x442f0033,0x7d0d0b17,0x6f030b18,0xc30500ae}},	//   _ogg_, blas, donc, ابقو
  { {0x00e60014,0xb5f7000b,0xc8630024,0x85f70009}},	//   ъжен, _יציג_, атши, _יציע_
  { {0xcf77000a,0x7b060028,0x09290003,0xd7ef0003}},	//   نصوص_, iður, رسمي_, يكم_
  { {0xcf930009,0x6d5a0064,0x7d040b19,0xb7db0009}},	//   יטד_, štau, lois, וקני
  { {0x8d730003,0xd5b00003,0xb05b0051,0xafdb0033}},	//   لايا, صفة_, skäi, tbøk
  { {0xd197000b,0xc5f3000b,0x69c3004a,0x6aca0037}},	//   _בכלי_, ידו_, änee, िस्र
  { {0xcb670046,0x09ca0011,0xa3e80011,0xa87b0009}},	//   вање_, ान्य, यपट_, _קאמר
  { {0x02a6007c,0x60c00747,0x7d0d0b1a,0x442f02ed}},	//   трим, _homm, zlas, _egg_
  { {0xddc8003e,0x7d040006,0x6c860012,0x32570009}},	//   _wedł, kois, _للام, כסים_
  { {0xc173000b,0x7d04004a,0xac980012,0x60c00b1b}},	//   סחר_, jois, _سنتا_, _jomm
  { {0x7d04004a,0x8bb30012,0x98a8004b,0x999e0073}},	//   dois, _نصوص, _sună_, tatų_
  { {0x98a8004b,0x645d0073,0x3a3a005e,0x7b060097}},	//   _pună_, ųsit, _üpp_, rðus
  { {0xd6d8007c,0x2fcd001c,0xa4d5002d,0x999e0010}},	//   ття_, šeg_, гові, ratų_
  { {0x2369012e,0x60c00061,0x999e0010,0x442f0058}},	//   traj_, _nomm, satų_, øg_
  { {0x7b32003e,0x59ca0037,0x5c070014,0x7658004a}},	// [12d0] _dług, ानकर, тява, kavy
  { {0x4b7b0009,0xd37b0009,0x19eb0012,0xab5d0034}},	//   ואמו, ורמט, وراً_, zyżo
  { {0x7d0d0b1c,0x69da0052,0x89340012,0x66cb005e}},	//   plas, nzte, لعنا, _lükk
  { {0x60c00b1d,0x71d70009,0xf09f01a0,0x244b00ae}},	//   _comm, כובד_, ndà_, _تجدي_
  { {0x6f030164,0x6d410029,0xa3ad0011,0xc7ab0012}},	//   tonc, _stla, _कपट_, بدال_
  { {0x3ce50011,0x76580073,0xfc3f0030,0x2ed10011}},	//   जोने_, gavy, _sníh_, _हतोत
  { {0xf2d2000b,0xceb4000b,0xb6bc0009,0x7db40048}},	//   _פעל_, ייס_, וצגי, исъц
  { {0x26190037,0x7c3b004b,0x629c0b1e,0x69da0035}},	//   येगी_, ucur, _zaro, dzte
  { {0x64490b1f,0xd5bf001e,0xb8f70037,0xac960012}},	//   rbei, _šāds_, िस_, انًا_
  { {0xa3bb0011,0x4a45003c,0x66cb0060,0x64490b20}},	//   _अपन_, ынов, _dükk, sbei
  { {0xfad60093,0xaad90044,0x59ca0011,0x62810b21}},	//   רותך_, योगक, ानगर, rflo
  { {0x3f6a0b22,0x62810b23,0xf746087f,0x27390b24}},	//   нимо_, sflo, лемо, _kèn_
  { {0x69c8003a,0xe365002d,0x7b060028,0x6b65062c}},	//   ayde, _скли, rður, _скла
  { {0x69c80058,0x249f0028,0xdbd10051,0xe296035c}},	//   byde, ldum_, _müüm, _баш_
  { {0x7d040006,0xf652000b,0xba560009,0x6d5c008e}},	//   tois, מצם_, _עסקו_, usra
  { {0x249f0065,0x6d5c0039,0x97c60003,0x7b100052}},	//   ndum_, rsra, _مقبو, räum
  { {0xdd030010,0xcb67011d,0xd91b0009,0x2d850060}},	// [12e0] ūrėj, лате_, _אוקל, çler_
  { {0xda65000a,0x66cf0033,0x8f9b000b,0x7d04004a}},	//   لامي, _søkn, _טיפי, sois
  { {0x20f80010,0x10a6011d,0x66090030,0x7b320034}},	//   ečia_, лижн, řekr, _złud
  { {0x237f0002,0xa09a0003,0x94060012,0xd12f0012}},	//   ktuj_, عضاء_, _موجه, سمه_
  { {0x69c80002,0x4424001a,0xd037002d,0x70c40037}},	//   zyde, _àm_, узії_, _वकील
  { {0xb8cb015f,0x3b0a0015,0x2ca00051,0xf773000b}},	//   _को_, _чего_, ldid_, מקד_
  { {0x45d402ad,0x067b0009,0x2ca0005e,0x63a40b25}},	//   ройс, תנצל, odid_, lvin
  { {0x2ca00005,0xbd870003,0x76580010,0x7ae80132}},	//   ndid_, انين_, savy, widt
  { {0xc676000a,0x7658007a,0xe64606df,0x66d0006f}},	//   _مطاب, pavy, _безп, _räkn
  { {0x69da008b,0x7afc009b,0xe45f004a,0x63ad00d9}},	//   tzte, črto, _ylös_, _šanc
  { {0xd2b7000b,0xe57a0024,0x58d90024,0xf0b50024}},	//   אלית_, _їзд_, вдня_, айнь
  { {0x8dfb0009,0x85970009,0x853b0009,0x55bb0009}},	//   _אהבת, _תדאג_, _נגדי, _רמאו
  { {0x69da000f,0x63a400bd,0x9f350024,0xf09f01a0}},	//   szte, jvin, регі, rdà_
  { {0x539b000b,0x11d60003,0x98bf0010,0x99d60012}},	//   _ניוו, _متعد, ystė_, _متعا
  { {0x58d50015,0xdce30002,0xfd130012,0x7f440b26}},	//   _войт, suną, مجر_, _etiq
  { {0xddd80030,0x20f80073,0x361b00af,0x000000c4}},	//   ravň, yčia_, תולד,
  { {0x395e0039,0xba550001,0x26c10107,0xbec7001e}},	// [12f0] lsts_, ивај, _toho_, ldīš
  { {0xb05b0052,0xcb680012,0x0ab80012,0x2ca0005e}},	//   rkäu, امله_, ُطلب_, adid_
  { {0x38350021,0x6d5a0067,0x80aa0011,0x24f9003c}},	//   анер, štar, _जोडे, _анны_
  { {0x237f003e,0x7a32000e,0x5c070048,0xda080012}},	//   ytuj_, tűtí, _бяга, ديمه_
  { {0x0a6b0046,0x926b0001,0xb05b004a,0xe72e01d4}},	//   _први_, _прва_, lkäs, же_
  { {0x395e0039,0x0f580009,0x20f80b27,0xe81a0011}},	//   ksts_, ניום_, rčia_, नेटा_
  { {0xa564000a,0xfc31000a,0xb05b004a,0xc694000b}},	//   مدين, يحة_, nkäs, מאס_
  { {0x91f5001a,0x999c000e,0x33650086,0xab6505d4}},	//   hác, _nevű_, авиг, авил
  { {0x395e0185,0x249f030f,0xab760012,0xd7fb0024}},	//   ests_, rdum_, لميا_, _чув_
  { {0x752f003e,0x68eb0070,0x237f0002,0xa01b0028}},	//   _licz, ligd, rtuj_, tfön
  { {0x237f0034,0x395e0035,0x25b90012,0x2a760009}},	//   stuj_, gsts_, _جهاد_, בעתך_
  { {0x68eb0070,0x63a40010,0x752f0002,0x237f084b}},	//   nigd, yvin, _nicz, ptuj_
  { {0x443f0b28,0xa01b03ce,0xb8ee0011,0xe8f70148}},	//   mcu_, sfön, _शक_, рля_
  { {0x443f0b29,0x644d0b2a,0x56b50009,0x06760b2b}},	//   lcu_, ebai, ׁפָן_, шумя
  { {0x2d53007d,0x91e200de,0x65c3076c,0x1c3a003c}},	//   nţe_, _моше, обра, вязь_
  { {0x47c6002d,0x8a140012,0x645b0032,0xdddc0073}},	//   _вбив, _اظها, naui, perž
  { {0x63a4000d,0x2ca00051,0xdcb7001a,0xa01b03ce}},	// [1300] uvin, rdid_, ởng_, nföl
  { {0xc332000b,0x55e60015,0xf8bf0061,0x644d0010}},	//   קוב_, _вооб, rmée_, abai
  { {0x765c0b2c,0x8c3b0032,0xe29706e5,0x21a30048}},	//   mary, _saße, рах_, жихм
  { {0x39a50333,0x270e0037,0x3d0f0037,0x21670103}},	//   _mēs_, ित्र_, ातों_, рици_
  { {0x98a6003a,0x443f0b2d,0x40e90009,0xa01b0031}},	//   nslı_, dcu_, נַעֲ, jföl
  { {0x8c9e0037,0x316b0002,0x644c0002,0xa01b006f}},	//   _खोजो, ńczy_, śnię, dföl
  { {0x69c70058,0xdce1003a,0xf6530009,0x3f85004b}},	//   øjel, _aslı, חצו_, ălui_
  { {0x0ca70015,0xc19b000b,0x499b000b,0x399b0009}},	//   атьи_, _בשלי, _בשלב, _בילד
  { {0x22580070,0xafe60867,0x96960024,0xdce30035}},	//   _kerk_, _тоал, _вреш, urnā
  { {0xdce70002,0x7ac60015,0x78a20b2e,0x6fb30012}},	//   mują, рсие, ldov, _بمكا
  { {0x765c007a,0x3a370093,0x20f80010,0x22580b2f}},	//   dary, ירים_, nčio_, _merk_
  { {0x1bea004d,0xd46707e6,0x6d4a0032,0x4d7b0009}},	//   _идеи_, _вице_, mpfa, _ירבע
  { {0xdce70002,0x98bf001e,0x39490b30,0x77f40011}},	//   nują, lstī_, _čase_, _अशोक_
  { {0x8c1b000b,0x0eeb0055,0x96eb0024,0xddc80035}},	//   _סוגי, тьми_, тьма_, _vedņ
  { {0xeda40339,0xb2bb0009,0x6abc0097,0x91f50081}},	//   ошто, _במגר, örfu, rác
  { {0xb4c30044,0xdce7003e,0x04c90003,0xb05b020b}},	//   ्से_, kują, دوري_, rkäs
  { {0xe3b00003,0x644d0605,0x98bf000d,0x30780012}},	// [1310] ورك_, rbai, aptă_, _ضحية_
  { {0xf6990046,0x6e95000a,0xdce70002,0x443f009b}},	//   _свој_, _الدا, dują, zcu_
  { {0x68eb0070,0x28cc0037,0xa01b0031,0xdb040025}},	//   tigd, ासचि, zföl, iviè
  { {0xa3c705f3,0x000000c4,0x000000c4,0x000000c4}},	//   _उथल_,   ,   ,
  { {0xdce70002,0x4fa50345,0x07a506bd,0x443f0b31}},	//   gują, силв, салн, vcu_
  { {0xaaa60037,0x20180003,0x539a0009,0x5e870024}},	//   _कोलक, جتمع_, _גישו, рудз
  { {0x3ea10051,0xad58003c,0x443f0064,0xdce70073}},	//   _maht_, арых_, tcu_, aują
  { {0xfdf80214,0x85f8007e,0x2d53000d,0x3f820b32}},	//   ימוש_, יצוע_, rţe_, ytku_
  { {0x0ab50003,0xcce40003,0xdce70002,0x68e90b33}},	//   محدد, تسوي, cują, _imed
  { {0x9f950051,0x7b320002,0x443f0b34,0xa01b0b35}},	//   _müüa_, _słuc, scu_, rföl
  { {0x39e9022a,0x60c40b36,0x98a60229,0x9f95005e}},	//   удно_, _poim, бине, _lüüa_
  { {0x236d012e,0xfd1f001a,0xa01b0931,0xc9b60009}},	//   prej_, _nhì_, pföl, צהרת_
  { {0x60c40006,0x66cf0033,0xd7f20012,0x6c320012}},	//   _voim, _nøkk, سكس_, _عفوا
  { {0x2cbf0051,0xc332000b,0x3f820b37,0x501a0009}},	//   ljud_, _זוג_, rtku_, טורו
  { {0x60c40b38,0xdce70002,0x68e9006f,0x765c002c}},	//   _toim, zują, _omed, rary
  { {0xd3ba002d,0x6459002a,0xc212000b,0x2fda0003}},	//   лузі_, _jewi, _מהו_, _موعد_
  { {0x3f9e0039,0x7f860012,0xfa360012,0x273d0081}},	// [1320] ātus_, _الخن, مراد, _gìn_
  { {0x7e560001,0x68fb0327,0xd7bb0009,0xf4120009}},	//   _утиц, _ajud, _עציר, לפן_
  { {0xfbc9000b,0x68fb006f,0x98b90010,0xdce70002}},	//   עת_, _bjud, ūrą_, wują
  { {0x22580369,0xdce70002,0x2fdd003a,0x649a0024}},	//   _werk_, tują, _özgü_, _стор_
  { {0x0eea007c,0x26c50026,0x96ea002d,0x20f80010}},	//   льки_, _bolo_, лька_, sčio_
  { {0xdce70002,0x8f9b000b,0xd7f9002d,0x52750109}},	//   rują, טיני, шує_, _мусу
  { {0x6443003e,0xdce70002,0x6b840b39,0x6e870003}},	//   śnie, sują, ltig, صنيف_
  { {0xdce70002,0xd497003c,0x6b8401a0,0x84d60009}},	//   pują, брь_, otig, מֵ֥א_
  { {0xd250000a,0xa5070001,0x6d4a0032,0x8c43004c}},	//   ونة_, љења_, spfa, чење
  { {0x6b840b3a,0x7bcd001e,0x63ab0b3b,0xfbcf0012}},	//   itig, _ļaut, ågni, عتي_
  { {0x7abb000b,0xd9fa0037,0xddc1000e,0x6b840b3c}},	//   אציו, ्थित_, _felő, htig
  { {0x64590b3d,0x0217000b,0x6b840b3e,0x75d30012}},	//   _gewi, מחים_, ktig, _عينا
  { {0xdfd80014,0x351b00af,0x27220b24,0x000000c4}},	//   бър_, _עודנ, _cưng_,
  { {0xeaf50044,0xd9fa0037,0x2d830031,0x35b50024}},	//   ीकृत_, ्थात_, ttje_, обгр
  { {0x2d9e0013,0x69180164,0xa5d80009,0xbd450012}},	//   _jste_, víen, בַּי, تنزي
  { {0x2eee0052,0xd7c90012,0x9d150024,0x5c07003c}},	//   hiff_, _نوعه_, ідач, бяза
  { {0x6b8400c5,0xe4e4002d,0xfc300012,0x9cd70009}},	// [1330] gtig, чірн, فحك_, צומה_
  { {0x8c1b000b,0xfaf30003,0x10140012,0xfaa7004c}},	//   רומי, أثر_, _عبيد, љшан
  { {0x753a008b,0xfd1f0020,0x399a0b3f,0x7bcd00b6}},	//   _nutz, _thì_, _jūs_, syau
  { {0xa8150001,0x399a001e,0xdced0010,0x26c509ae}},	//   одеш, _mūs_, _įkėl, _solo_
  { {0x660400a2,0x6d48001e,0x49180009,0xa08c0009}},	//   şikl, _atda, זקאל_, רְבִ
  { {0x2f5c0009,0xa75c0009,0x501c0009,0x1f5c0009}},	//   נדונ, נדור, אודו, נדוא
  { {0x2cf60037,0x64590002,0x291f001a,0x26c500c1}},	//   ुकूल_, _pewi, _thua_, _volo_
  { {0xf992000b,0xa3c70011,0x753a0032,0x93450357}},	//   _קרן_, ैनल_, _dutz, оние
  { {0x8c64000a,0x7884000e,0xdcfc001e,0x03a500b3}},	//   سطين, hívó, ntrā, ципо
  { {0x05ba0044,0x399a0039,0xdddc000e,0x20230002}},	//   _उपलब, _būs_, zerű, ąpić_
  { {0xc7a9000b,0xc27a000b,0xda090012,0xad580024}},	//   _שב_, ברתי, شيحه_, _гріх_
  { {0xa17a000b,0x6abc006f,0xb9260003,0xa3d90037}},	//   סטרט, örfr, تفجي, ़ना_
  { {0x98160003,0xbc380003,0xa3bb0012,0x94050012}},	//   تبدا, _اسما_, _حاضر_, _بوشه
  { {0x9f960009,0x73040024,0xb4d20011,0x59c50012}},	//   חדשה_, _епіз, वस्_, _ويشك
  { {0xceb20093,0x845a0098,0x629700f1,0x2b4d009b}},	//   וים_, ират_, dexo, lpec_
  { {0xb9560009,0x60dd0b40,0x9e3c01bd,0x63a90b41}},	//   _ויקח_, chsm, _maďa, oven
  { {0xab66002d,0xd3f4002d,0x6b840052,0x58bb0009}},	// [1340] ювал, нiст, utig, _כמקצ
  { {0xc9d60012,0xe1f20012,0x6b840b42,0xb87b0031}},	//   يزاب, وسا_, rtig, siít
  { {0x9e3c0029,0x6aa30b43,0x18a600de,0x28af0011}},	//   _naďa, _manf, жаем, _जोडि
  { {0xa9880009,0x71880009,0x274a004c,0x765a020d}},	//   מָנִ, מְנַ, ачко_, _sety
  { {0x9ffa0003,0x63a90070,0x5f060686,0xc7960012}},	//   جراء_, jven, озда, تشاب
  { {0x501b0093,0x7d16004a,0x2d850054,0x356a0187}},	//   בונו, llys, àleg_, арин_
  { {0x20d700a1,0x8c3b0052,0xa2da0011,0xa96709c6}},	//   _için_, _maßn, _पॄष्, _мира_
  { {0x66cb00a2,0x0caa002d,0x63a90040,0x94aa0635}},	//   _yüks, ртки_, fven, ртка_
  { {0x394904d2,0x63a90070,0xaa880012,0x290b0b44}},	//   _časa_, gven, منظم_, voca_
  { {0x0bb7000b,0xc6d80009,0xc1740223,0x8f9b0009}},	//   קלים_, _פַּר, площ, _דימי
  { {0x09f80351,0x44270020,0x3f860017,0x6d48021e}},	//   صفحة_, ̀n_, ltou_, _utda
  { {0x7aef0b45,0x859b0009,0x28f9003c,0x23720034}},	//   éctr, _כשבו, семь_, kryj_
  { {0x63a9007d,0x3f860149,0xaae60012,0x54530024}},	//   cven, ntou_, _وستو, _цвіт
  { {0xa3ae0044,0x3f860017,0xe2970345,0xf7730009}},	//   किन_, itou_, _мач_, וקש_
  { {0x7b100052,0x99170012,0x78170011,0xd0d50048}},	//   häus, _وبعض, _तर्क_, _нокъ
  { {0xdcee001e,0xdcb80198,0x66cb005e,0x69c301a4}},	//   tubā, ощу_, _püks, änem
  { {0xdc9b0093,0xe4480003,0x28ab0037,0xa0880009}},	// [1350] סימל, تلقى_, _घोषि, _וְתִ
  { {0x238e001e,0x1ec40003,0x0b140009,0xd33700af}},	//   dējā_, _يقيّ, פַּר_, קרבה_
  { {0xdcfc0039,0x0e9a0009,0xc2c40012,0xf3f9004b}},	//   strā, _השתל, بيلي, iaţa_
  { {0x2366001c,0x41740003,0x7985002a,0x63a90b46}},	//   _ovoj_, باكس, rthw, yven
  { {0xba77000a,0x7d0d0b47,0x97d80012,0x4cba0009}},	//   _واست, moas, يظهر_, _הזרו
  { {0x8f9c000b,0x6da50b48,0x8ee80024,0x7d0d0b49}},	//   יידי, зика, омів_, loas
  { {0xd658000b,0x645d0b4a,0x68ed0b4b,0x53340001}},	//   חיות_, _kesi, _omad, _церт
  { {0xd5fc000b,0xdd8e0003,0x63a9048b,0x7d0d08d4}},	//   יפור, اوي_, tven, noas
  { {0x63a90061,0x2b4d0066,0x645d0b4c,0x20840012}},	//   uven, upec_, _mesi, _تلقّ
  { {0x3964004a,0x78a4004a,0x645d0b4d,0x20f80159}},	//   _ässä_, _saiv, _lesi, ečih_
  { {0xa9690046,0x7d0d0006,0x98a60b4e,0xaf080012}},	//   љима_, koas, пине, _بقلم_
  { {0x21060044,0x645d0b4f,0x71d60009,0xd7ca0012}},	//   रवेश_, _nesi, פורד_, موجه_
  { {0xdfd20003,0x78a40606,0x9d1a0009,0x3ea50b50}},	//   ريس_, _vaiv, _פונט, _kalt_
  { {0x75290b51,0xb145004c,0x78a40132,0x60db01a0}},	//   lmez, _енкл, _waiv, _llum
  { {0xceb20093,0x60db003a,0x645d0b52,0x412a0048}},	//   עיל_, _olum, _besi, _локо_
  { {0x0136000b,0x60c90070,0xb05b004a,0x75290060}},	//   _צרפת_, _noem, ljän, nmez
  { {0x2d870051,0x831a0003,0xa87b0009,0x487b0009}},	// [1360] htne_, مقرر_, _האפר, _הטפס
  { {0xd36f0003,0x80250012,0xd3360009,0x691d0025}},	//   اهل_, _غريم, פרעה_, néen
  { {0x7d1600e2,0xbe3b000b,0x2a6a000e,0x66cb000e}},	//   plys, _לעית, óbbi_, _tükr
  { {0x238e001e,0xc952000b,0x80bf0037,0x55bb000b}},	//   tējā_, גמא_, षाये, _המטו
  { {0xa01b0028,0x44630014,0x20ef0030,0x2d870b53}},	//   rgög, _явяв, dřil_, etne_
  { {0x66e3002d,0xc7f70009,0xdee30024,0x7b100032}},	//   ноча, הזנת_, ночи, räus
  { {0xceb3000b,0x3ea50054,0x60c2001e,0x23660b54}},	//   תיו_, _dalt_, pjom, _svoj_
  { {0xd1320003,0x68130002,0x238e001e,0x61230051}},	//   _أمر_, _będą, pējā_, võlg
  { {0x613a0066,0x3ea500b0,0xd3b80024,0x2d870b55}},	//   _důle, _falt_, ілої_, atne_
  { {0x51f80024,0x28130012,0x3ea50b56,0x8ea50012}},	//   жною_, _أوكس, _galt_, _يصلن
  { {0x1ea90012,0xdd8f0012,0x7aee016d,0x21630b2b}},	//   _باقي_, _مول_, _mmbt, нтяг
  { {0xe53b000b,0x55bb000b,0x09f7000b,0x25d70009}},	//   _התאר, _למבו, למים_, _מובן_
  { {0x7d0d007d,0xcce50003,0xa3cd0037,0xdfd80048}},	//   voas, _تسلي, रहण_, пър_
  { {0x57fb0009,0xdab80012,0xa7fb01e3,0xdb9b0009}},	//   מלכו, _ذهبت_, gaña, _לסדר
  { {0xa3e50044,0x56780015,0x645d0b57,0x7d0d0b58}},	//   _भेज_, ября_, _pesi, toas
  { {0x51fb000b,0xba17000b,0xb4f90037,0x01fb0009}},	//   _להוצ, _מחוץ_, ्केप_, _לפול
  { {0x57f5002d,0x60c90070,0x7d0d0b59,0xf0940009}},	// [1370] _іпот, _roem, roas, _טנק_
  { {0x82370003,0x60db0b5a,0x2d8701bd,0x80180012}},	//   سرطا, _slum, ytne_, _عزيز_
  { {0x69da005e,0x629a0b5b,0x645d0b5c,0x60db0b5d}},	//   _ütel, ieto, _tesi, _plum
  { {0x3ce00013,0x2c750012,0x629a0b5e,0x08d40024}},	//   chiv_, _تُحس, heto, нція
  { {0xdcfc000d,0x7bc6004a,0xf09f001a,0xd91c0009}},	//   stră, äkul, goài_, זואל
  { {0x63ad006f,0x97580009,0x501c0009,0xb3ba0009}},	//   mvan, לידו_, צוגו, _ומשכ
  { {0x65920001,0xa1940867,0x3ea50698,0xe5a20024}},	//   вају, _парч, _valt_, вищи
  { {0x9f5f000e,0x33d5002d,0xdcf90012,0x629a005e}},	//   áról_, діот, تفعت_, eeto
  { {0xac160001,0xb05b006f,0x63a2000e,0x4c920001}},	//   моћу_, tjän, _cson, тињс
  { {0xa3ae0037,0xab5d0002,0x3945027f,0xe299004c}},	//   कित_, wyżs, мног, цао_
  { {0xdb24000e,0xf2d2000b,0x7f4d01c5,0x91e50048}},	//   ésén, דעי_, _ataq, фоне
  { {0x3cf90037,0x290f0b5f,0xa9880009,0x7e63008e}},	//   ्कों_, noga_, הָשִ, lanp
  { {0x691d0061,0xe79c003a,0x2ca9006f,0xa3e00060}},	//   péen, _düğü, ddad_, düğü_
  { {0x2ca901e3,0xb05b008e,0x853c0073,0x8f9a0009}},	//   edad_, ljäl, _grės, חישי
  { {0x386d032b,0x290f0604,0x0446004d,0x8c460048}},	//   _oder_, koga_, дебн, дебе
  { {0xc2120009,0xb05b008e,0xa03a0012,0x98b20035}},	//   _שהה_, njäl, _بأثر_, īzē_
  { {0xccf20093,0xfa8e001a,0x61230051,0x394d0159}},	// [1380] דכן_, _mừng_, kõlb, _česa_
  { {0x89f6000a,0x38600132,0xb05b0248,0x7d090159}},	//   وثائ, _heir_, hjäl, česa
  { {0xdebb000b,0x290f00e5,0xb6bb0009,0x2c0a0011}},	//   _ומיל, foga_, _וציי, _हुईं_
  { {0x69da000e,0x50ba0003,0x657c008e,0x629a0b60}},	//   _ütem, غداد_, murh, zeto
  { {0x4c9b0009,0x38600b61,0xcf260012,0xab2a0048}},	//   _ובכו, _meir_, ورتي, _мома_
  { {0x4733002d,0x386d0af1,0x2bbd0011,0xcdda004c}},	//   вніс, _eder_, ोहरा, жњи_
  { {0xc6930093,0xadd8002d,0x6b890b62,0x69d80040}},	//   דאו_, ямку_, eteg, øved
  { {0x66cf0033,0xdc13003a,0x98a60159,0xc53600af}},	//   _søkt, _ağır, omoč_, וָ֥ה_
  { {0xfa8e001a,0x22490060,0x629a0b63,0x000000c4}},	//   _dừng_, _şaka_, teto,
  { {0x7b320002,0xcdd6004c,0xb2700024,0x4d3a0223}},	//   _tłum, _оцењ, внiш, _дядя_
  { {0xa9c30232,0xfa770009,0x9583004c,0x66d003bd}},	//   всяк, ועית_, _алхе, _läks
  { {0xa3de0037,0x657c0028,0x7549000e,0x63ad003a}},	//   तना_, durh, őszö, yvan
  { {0xd0060003,0x26cc0340,0x00570009,0x6d480030}},	//   ال_, _kodo_, ושכת_, ídan
  { {0x7ce30005,0x7d0d0159,0x8c1b00af,0x853c0b64}},	//   _kõrg, čase, _וודי, _urės
  { {0x9f34007c,0xc327000a,0xdc3a00a2,0x758800fa}},	//   тері, _تكون_, _açık, мств_
  { {0x63ad00bd,0xe7ab0029,0x224d0030,0x26cc0b65}},	//   tvan, _ďaľš, _řek_, _lodo_
  { {0x20f80010,0x63ad0b66,0x2ca90b67,0x68e20b68}},	// [1390] nčiu_, uvan, rdad_, dhod
  { {0x26cc0b69,0x7a540012,0xcf270012,0x63ad0b6a}},	//   _nodo_, نضما, _تربي, rvan
  { {0x0656000b,0x63ad0b6b,0xf6560009,0x7ce3005e}},	//   _איתך_, svan, _אסתי_, _nõrg
  { {0x909b0012,0x6b890034,0x26de0b6c,0xef1f0031}},	//   تضطر_, yteg, _alto_, ztül_
  { {0x26cc066e,0xfa8e001a,0x752d0b6d,0xf7480012}},	//   _bodo_, _rừng_, mmaz, وجوه_
  { {0x752d000f,0x6fb20012,0xa77c0009,0xba740012}},	//   lmaz, اموا, קרופ, _لافت
  { {0x31780012,0x66f20034,0x609b0012,0x66cf00b0}},	//   _يحفظ_, ałko, _وخرج_, _søks
  { {0x2f160028,0x752d003a,0xce380009,0xb6380009}},	//   lægt_, nmaz, ואות_, ורוס_
  { {0xe3b10003,0xf7730012,0xe4520009,0x92f50024}},	//   ارب_, _جاز_, נֶה_, ечні
  { {0x16db000a,0x2001003a,0xbfa30081,0x6b890b6e}},	//   _بذرة_, şhis_, riể, rteg
  { {0xfa8e0020,0x78a90051,0xcb12000b,0x6b890b6f}},	//   _từng_, _kaev, רלי_, steg
  { {0xc689015a,0x98b80039,0x6d41002c,0x26c7013a}},	//   _לא_, _kurā_, _iula, ljno_
  { {0x7e610006,0x291e0039,0x43840003,0xb05b004a}},	//   _kelp, ēta_, _للنق, nkäy
  { {0x78a90051,0x68e200f1,0x6d410b70,0x4ac50012}},	//   _laev, zhod, _kula, _سيبق
  { {0x27e6000f,0x23690b71,0x7bcb0032,0x68e203a7}},	//   zzon_, esaj_, ägun, yhod
  { {0x6d4100c6,0x20f80066,0x7693003a,0xc06f0066}},	//   _mula, nčit_, lıyı, íští
  { {0x6836003a,0x7d1b004a,0x68e201bd,0x91290012}},	// [13a0] _müdü, ilus, vhod, _تسوق_
  { {0xe9ff0020,0x7d1b0052,0x752d0035,0x76930060}},	//   _giải_, hlus, amaz, nıyı
  { {0xae5b000b,0x26cc0010,0xe93a0003,0x365b0009}},	//   _מכיר, _rodo_, سسات_, _מכינ
  { {0xa01b0163,0x89160003,0x68e20066,0x2a650032}},	//   mför, ربائ, uhod, halb_
  { {0x7d1b0051,0xa8570009,0x672e0031,0xb1170012}},	//   dlus, גינה_, ombj, رقها_
  { {0x6d410b72,0x6e940264,0xce940048,0x7ce3005e}},	//   _bula, тику, такъ, _põrg
  { {0x1ea90003,0x7c22000e,0x68e20027,0x4096057b}},	//   باني_, _szor, phod, _прат
  { {0x7ce30005,0xf8bf000e,0x7d1b0b73,0x61e10051}},	//   _võrg, rmék_, glus, _ülla
  { {0xa2c40044,0x26cc060e,0xd10d0037,0xcb980024}},	//   राप्, _todo_, िकरण_, євої_
  { {0x9f97000b,0x026a0015,0xd2570024,0x4bd70012}},	//   _אדמה_, чший_, нцю_, عبيد_
  { {0x5cd6002d,0x7c220002,0x1e57000b,0x8cc00037}},	//   _підх, _wzor, _נשאר_, वादो
  { {0x660900a2,0xa01b006f,0x8d5b0009,0x644901a0}},	//   şekk, dför, _זכאי, ccei
  { {0xf8b3000b,0x7c220027,0x6d410052,0x4e160011}},	//   אשר_, _uzor, _zula, _दुबई_
  { {0x661a004a,0x66d0006f,0xa2c40011,0x629e001b}},	//   _kytk, _säkr, राफ्, jepo
  { {0x673a03eb,0xa7fb0b74,0xef1f000e,0xa2c40037}},	//   _mitj, paño, ltük_, रान्
  { {0x57b50148,0xb6340012,0x88c70012,0xc7ab0012}},	//   _абит, افِع, _ستبل, _فدخل_
  { {0x752d01a2,0xb05b004a,0x9be70024,0x2f160040}},	// [13b0] rmaz, hjäk, хівк, tægt_
  { {0xd7fc0009,0x3f640048,0xa1590198,0x752d0b75}},	//   _מהחל, _стъб, дажу_, smaz
  { {0x07360009,0xea770009,0xc6920009,0x52840012}},	//   _שאתם_, תגבר_, _דאי_, المك
  { {0x6d41000d,0xf9900012,0x6ee20064,0x19b80012}},	//   _rula, إبل_, _vôbe, عطلة_
  { {0xf77f00a2,0x7ce30051,0x317e0052,0x78a90051}},	//   nuç_, _võrd, hutz_, _vaev
  { {0x6d410b76,0xef1f0031,0xcf940009,0x2c7a0060}},	//   _pula, dtük_, רטס_, yüdü_
  { {0x7d1b0005,0xceb40093,0xdcfa00a2,0xddc10039}},	//   tlus, טיס_, _artı, _ielū
  { {0x01340012,0x9479004c,0x20f80030,0xdb060b77}},	//   _معقد, фску_, učit_, _erkä
  { {0x64490b78,0xf5060048,0x7e610035,0x20f80030}},	//   rcei, ънъл_, _telp, rčit_
  { {0xccf80066,0x57f406a5,0x539c0009,0x6d410b79}},	//   _svět_, _спут, ליחו, _tula
  { {0x6d41002c,0x7d1b0051,0x04950003,0x95570003}},	//   _uula, plus, _للاح, _أخطا
  { {0x3f6a0a41,0x95540012,0x629e0034,0xb05b0032}},	//   мимо_, _إخلا, zepo, njäh
  { {0x9cd60093,0xa856000b,0xefc7003c,0xd00f0012}},	//   _שונה_, כירה_, влял_, ْلُ_
  { {0x6b8d00c5,0xa01b0163,0x2cad05aa,0xf1e10011}},	//   dtag, tför, lded_, पनान
  { {0x8d630046,0x92580003,0x2cad0132,0xdddc0034}},	//   ивре, _أشهر_, oded_, warł
  { {0xa01b0b7a,0x2cad0b7b,0xa3ae0037,0xdddc0034}},	//   rför, nded_, किल_, tarł
  { {0xa01b02f1,0xcb6700f5,0x6b8d0b7c,0xdca30024}},	// [13c0] sför, кате_, gtag, шати
  { {0xf1fa0003,0xd36f0012,0xa01b0248,0x7bc401a0}},	//   وعات_, زهم_, pför, rxiu
  { {0xd657000b,0xa01b0028,0xef1f000e,0x1677000b}},	//   _שיטת_, ngön, ztük_, _בגיל_
  { {0x3d0b0044,0x29020028,0xdbd2005e,0xb05b0032}},	//   हकों_, nnka_, tüüp, gjäh
  { {0x2ca00051,0x27290029,0xa0730024,0x2cad0132}},	//   meid_, kúnd_, ргіч, dded_
  { {0x2ca00b7d,0xf413000b,0x2cad002a,0xc7d70009}},	//   leid_, _כפר_, eded_, כוני_
  { {0x4420007a,0x7dc40003,0x5fa90037,0x6aaa0b7e}},	//   _ši_, اقعن, _चैनल, _raff
  { {0xef1f000f,0x2ca00051,0x63a40002,0xfd0f0012}},	//   ttük_, neid_, owin, يجي_
  { {0xccf3015a,0x5b140048,0xc7a30048,0xda7a0357}},	//   יכה_, лмит, _китк, мян_
  { {0x2ca000bd,0x63ab0058,0x29020b7f,0x2cad0b80}},	//   heid_, ægni, enka_, aded_
  { {0x60f900bc,0xc27b000b,0x63a40052,0xf1a30014}},	//   ення_, וריי, hwin, арян
  { {0x6aaa0052,0x85f70009,0xdb04008e,0x249f0b81}},	//   _waff, _בצבע_, lviä, ceum_
  { {0x99620013,0x2ca00051,0x64430002,0x4420001a}},	//   _níže_, deid_, śnik, _ái_
  { {0xb9b40012,0x6b800b82,0x2d470b83,0x09f60012}},	//   _ممتع, mumg, _põe_, _لأعد
  { {0x59c30003,0x63a40b84,0xba9b00af,0xa9e303d2}},	//   _نيوك, ewin, _חסוי, _вещa
  { {0xba370093,0x6b8d0b85,0x32370009,0x27240248}},	//   _בטוח_, ttag, _בטון_, röna_
  { {0xfc640048,0x613a0030,0x39490159,0xe53401c6}},	// [13d0] ръсн, _půln, _časi_, реть
  { {0x24730020,0x7a40022d,0xbb190003,0xab94002d}},	//   ệm_, vští, رياض_, рифі
  { {0x75d50003,0x78ad004a,0x8c3d003a,0xac990003}},	//   _إيجا, _kaav, leşe, _كندا_
  { {0xf7710351,0x98ad003e,0xf2df000d,0x60dd0b86}},	//   مات_, _mieć_, _atât_, nksm
  { {0x747a000b,0x78ad00ff,0xaed5002d,0xb05b0032}},	//   _אנרג, _maav, лодш, rjäh
  { {0xd6db0800,0x0684002d,0x753d04ff,0xb7dc0009}},	//   ьте_, игін, _hisz, וקדי
  { {0x6d450005,0xf3f9007d,0x753d000f,0x29880001}},	//   _juha, maţi_, _kisz, _исто_
  { {0xf3f9007d,0xb9250003,0x644d0b87,0x6d450b88}},	//   laţi_, _إفري, ncai, _muha
  { {0x2cad0666,0x753d0b89,0x5f450012,0xe4a800af}},	//   rded_, _misz, _إنطل, דֹתָ
  { {0xdb040149,0xf3f9007d,0x8c1c000b,0x13060015}},	//   rviç, naţi_, ווחי, лный_
  { {0xa2c40037,0x5dd50012,0xf6520009,0xf3f9004b}},	//   रात्, _حقائ, _הצב_, iaţi_
  { {0xcea90093,0x455a000b,0xf4870001,0xf1c30066}},	//   _מי_, _נכנס, _јужн, _alší_
  { {0x8cc00011,0x2ca0005e,0xf8b60009,0x68430012}},	//   वारो, veid_, אפרי_, صَّل
  { {0x201e0039,0xf3f9000d,0x6d450b8a,0x99d50012}},	//   āti_, jaţi_, _buha, _متبا
  { {0xe2960014,0xf3f9000d,0x2ca00acf,0x66060014}},	//   _сащ_, daţi_, teid_, упва
  { {0x61d6000b,0xd5b7001a,0x753d0b8b,0x645b0227}},	//   _תוקף_, ứng_, _cisz, nbui
  { {0xf3f9000d,0x2ca00b8c,0x141a0012,0x43860012}},	// [13e0] faţi_, reid_, ريطة_, طلاق
  { {0x2ca00005,0xf3f9007d,0x33d5002d,0xab770012}},	//   seid_, gaţi_, шіст, املا_
  { {0x394f007d,0xccf90002,0x68e40066,0x07370009}},	//   _însă_, kiś_, _klid, _תאים_
  { {0x74550098,0xa3e30037,0x7d7b000b,0xb78a004c}},	//   _върх, नना_, _אנטו, ељке_
  { {0xda140037,0x7c26001e,0xf3f9000d,0x3f820b8d}},	//   _तुरत_, _uzkr, baţi_, nuku_
  { {0xf3f9007d,0xf8bf000e,0xe1660003,0x32430014}},	//   caţi_, lmét_, _مدري, _герг
  { {0x91e60047,0xa2f70009,0x8cc00011,0x7d040b8e}},	//   _сове, _עמלה_, वालो, onis
  { {0x5ba60511,0x61d70009,0xd3a60024,0x6b800b8f}},	//   гроз, _גולף_, гроп, tumg
  { {0xd70a0014,0x98ad0002,0x09dc0011,0x4806004c}},	//   _знае_, _sieć_, मन्य, _спав
  { {0x8f9b000b,0x78ad07f6,0x92b60003,0xc27a0009}},	//   _אימי, _saav, احظا, ׂרִי
  { {0x78ad019a,0x6c860012,0x765c0b90,0x7d040b91}},	//   _paav, _ملام, dbry, knis
  { {0xf3f9007d,0x2ba50044,0x3a37000b,0xca37000b}},	//   zaţi_, _ऑनला, טרים_, טניה_
  { {0x20ef0030,0x6d450b92,0x7d040b93,0x60dd0b94}},	//   dřit_, _suha, dnis, rksm
  { {0x6d450051,0xf3f9000d,0xf1a60aa8,0x02a30048}},	//   _puha, xaţi_, _брин, _гръм
  { {0xf3f9007d,0x8c3d000d,0x753d0b95,0x7d0406c4}},	//   vaţi_, reşe, _pisz, fnis
  { {0x4fd5002d,0x7afa0b96,0x54550288,0x7d040b97}},	//   _вжит, litt, рват, gnis
  { {0xf3f9007d,0xdbc60052,0x7afa004a,0x753d0865}},	// [13f0] taţi_, röße, oitt, _visz
  { {0x35f5002d,0x6d450b98,0xcf270012,0x62850132}},	//   _впор, _tuha, _حربي, ugho
  { {0x7d04008b,0xf3f9007d,0x7afa004a,0x753d000e}},	//   bnis, raţi_, iitt, _tisz
  { {0xf3f9007d,0x7afa0006,0x6aa100bd,0x78a20058}},	//   saţi_, hitt, zelf, geov
  { {0x7afa004a,0xf3f9000d,0xddd0015b,0x0b8b0048}},	//   kitt, paţi_, _češt, _ясни_
  { {0x7afa004a,0xf8bf0054,0xd9f60037,0xe7330012}},	//   jitt, omés_, ुपात_, حصص_
  { {0x7afa0b99,0x2d910032,0x2d830b9a,0x6cc50b9b}},	//   ditt, ntze_, nuje_, ийка
  { {0x09e10044,0xeb990015,0xbdf80012,0xe7250081}},	//   पनीय, вии_, درها_, _dưỡ
  { {0x2d830107,0xb4d50037,0x4439006f,0xc1040012}},	//   huje_, _सकी_, äs_, _طوكي
  { {0x3ae4006f,0x7d040b9c,0x7afa0b9d,0xa3c60011}},	//   _köpa_, znis, gitt, _उपर_
  { {0x8a380015,0xd5bb0024,0x5c970012,0x90c60048}},	//   ляют_, _яса_, _مؤشر, абне
  { {0x3c47000a,0xf530000a,0xab95007c,0x7afa008e}},	//   _إضاف, _فإن_, _виді, aitt
  { {0xf74601d4,0x8c3b0032,0x7d040b9e,0x39490b9f}},	//   рего, _maßs, čist, _času_
  { {0x3f82001c,0xaa880003,0xc8e20037,0x60230024}},	//   ruku_, _منهم_, _खत्म_, ідра
  { {0xacf60001,0x20ef0066,0x8afa0009,0xa2c40011}},	//   ачај, třit_, _שהצי, रास्
  { {0x7ce3005e,0x2caf0032,0x765c00b0,0x04430ba0}},	//   _põra, _jagd_, sbry, жетн

  { {0x0b1a000a,0xac050003,0xd455002d,0xe8c70048}},	// [1400] نقرة_, مذكو, стсь, _ъгъл_
  { {0x2d830ba1,0xb7db0009,0x23c80011,0x42260024}},	//   buje_, _סקיי, रमबद, адзв
  { {0xc6930093,0x7e7b000b,0x21a6010c,0x767b0009}},	//   _ואת_, _באיז, рием, _בטיח
  { {0x55bb000b,0x7afa0070,0x38490009,0xa2c40011}},	//   _סמכו, zitt, ְאוּ_, राह्
  { {0x69da0679,0x78a20ba2,0xc60e0011,0x4b550048}},	//   zyte, reov, िथ्य_, _гъст
  { {0xa2e60015,0xdd9a0ba3,0xdd900012,0xf2df0081}},	//   _тогд, вши_, كوت_, _huân_
  { {0x7afa0006,0xafdb00c5,0xf8bf0061,0x5f090037}},	//   vitt, ncør, llée_, _सदस्_
  { {0x7afa0aa7,0x718b00af,0xc15700af,0xd49a0557}},	//   witt, _בְמַ, _כשלו_, трк_
  { {0x807b000b,0xa87b0009,0xc6760012,0x7afa0ba4}},	//   _שנמצ, _שאמר, _نطاب, titt
  { {0x1eaa0003,0xf2df001a,0xeb970009,0xd5b80035}},	//   _جاري_, _luân_, סדיר_, _trā_
  { {0xc333000b,0x2d8301e9,0xd2b70009,0x7b320034}},	//   חוז_, xuje_, בלית_, _słus
  { {0x7afa0006,0xd5fb000b,0xb92a0024,0x2d830ba5}},	//   sitt, _בפבר, нкiв, vuje_
  { {0x2d830002,0xcb540003,0xbb540012,0xdfc60012}},	//   wuje_, _انتظ, _انتب, أي_
  { {0xd7f80015,0x539b000b,0xfaa30014,0xdefb0015}},	//   рую_, _סיוו, _мачо, тым_
  { {0x99840003,0x39470ba6,0x8e380012,0x16380012}},	//   _العو, _guns_, لسفر_, لسفة_
  { {0x9a3b000b,0xddc3000d,0x6d480ba7,0xdb0b0052}},	//   _בתוק, lanţ, _muda, _ergä
  { {0x59ae0037,0x6f950003,0x026b0015,0x68fd00ca}},	// [1410] टिकर, _الخض, вшей_, misd
  { {0xcb57000b,0xa2c40037,0xddc3000d,0x3869002a}},	//   יסמה_, राष्, nanţ, _hear_
  { {0xf9f90003,0xe298002d,0x6f1805b1,0x3ce900b0}},	//   دفاع_, рає_, dovc, phav_
  { {0xb4d50037,0x1128002d,0x3d100037,0xf8bf0061}},	//   _सके_, аючи_, ावों_, blée_
  { {0xc7a80003,0x97a7003c,0x6d480ba8,0xb05b008e}},	//   لدول_, ррел, ídav, ljäs
  { {0x6d480ba9,0x9a840001,0xef18002d,0x6f1802a1}},	//   _buda, _мусл, амі_, govc
  { {0xa2c40037,0x5e780009,0xf6960012,0xd13b0048}},	//   रार्, בתון_, صنيع_, _аха_
  { {0xe919002d,0x3869002a,0x3947002a,0xf2df001a}},	//   _собі_, _near_, _runs_, _xuân_
  { {0xde59002d,0x33920003,0x36d50001,0x368b0014}},	//   _базі_, كليز, _лоар, _асен_
  { {0x39400176,0xcac90015,0xf3ff0018,0x99d50012}},	//   _siis_, угое_, _leão_, متجا
  { {0xc7a90093,0xd9f70037,0x38690baa,0x6d480bab}},	//   _רב_, ंछित_, _bear_, _guda
  { {0xcd96000b,0xaac90037,0x6e3c0031,0x69dc00b0}},	//   _לדעת_, राडक, _úrba, ørea
  { {0xe8f70bac,0x39400051,0x2d730027,0x38690bad}},	//   сля_, _viis_, eće_, _dear_
  { {0x501a000b,0xddc3000d,0x7c2b0bae,0xd9f90011}},	//   רושו, canţ, _izgr, ्पात_
  { {0x3869002a,0x8db5002d,0x6d260012,0x6e290030}},	//   _fear_, ості, معرك, řebn
  { {0xf2df0020,0x39910baf,0x6b840070,0x6f180bb0}},	//   _quân_, más_, tuig, zovc
  { {0x3991000f,0x60c40bb1,0xdcfc001e,0x63a90bb2}},	// [1420] lás_, _inim, gurā, nwen
  { {0x78a6000e,0x16aa0063,0x98a6001b,0x7b1d01a0}},	//   lekv, _свои_, omoć_, cèut
  { {0x38690036,0xf2df001a,0x60d6003a,0x39910a27}},	//   _year_, _tuân_, _koym, nás_
  { {0xe894007c,0xb05b0a50,0x3d210011,0x69c10030}},	//   іаль, ljär, मतों_, _šlec
  { {0x351b0093,0x6d480acb,0x78a60010,0xdefa0015}},	//   _תוכנ, _suda, iekv, лык_
  { {0x3ce600f1,0x6ffc001e,0xef1f003a,0x8f9b0009}},	//   _slov_, mācī, ltür_, ריסי
  { {0xddc3000d,0x42e70001,0x60c40027,0xfe6f0012}},	//   vanţ, _умро_, _onim, ردو_
  { {0x3991000f,0xdbdd0026,0xb87b000e,0xcb540001}},	//   dás_, zšír, lhív, овић
  { {0xb7f20037,0x9696011f,0xddc3000d,0x7cfe0010}},	//   _आइटम_, _греш, tanţ, gūra
  { {0x6d48000e,0x2ca40028,0x41dc0037,0x7ac60015}},	//   _tuda, semd_, _यथास, ссие
  { {0xddc3000d,0xf8bf000e,0x3991000e,0x0e570009}},	//   ranţ, jléc_, gás_, _השבט_
  { {0xa8eb0003,0xa193002d,0x7afe003a,0x692c000d}},	//   اعدك_, чаюч, hipt, _aşez
  { {0x7afe014d,0x9d1b0009,0x53a30198,0x3f860018}},	//   kipt, _גואט, _нацб, nuou_
  { {0x5b13002d,0x8c1b000b,0x3869002a,0x39910bb3}},	//   _еміт, _עוגי, _wear_, bás_
  { {0x5d780009,0x38690bb4,0xcb070012,0x9afb0009}},	//   יָּנ, _tear_, _ديون_, _תפוח
  { {0x99860002,0xddc3001e,0xfb560009,0x69de00b0}},	//   łoś_, nanš, ֶׁ֣ר_, dype
  { {0x8b580003,0x8af900f5,0x69dc0248,0x98c50035}},	// [1430] مجلس_, анас_, äref, ūtīs_
  { {0xb87b000f,0xe509001a,0xa9c7002d,0x2d73001b}},	//   ghív, oặc_, йсек, pće_
  { {0x66d00006,0x69670012,0x02440012,0x394a0bb5}},	//   _näky, صداق, أَمَ, _cubs_
  { {0x38690028,0x0cab0014,0x9bc7003c,0x63ae008e}},	//   úar_, _стои_, _лёгк, ännä
  { {0x39910659,0x78a4005e,0x98b90073,0x89340012}},	//   zás_, õiva, ūrė_, أعلا
  { {0xab5b0052,0x7afe00b6,0xe7390086,0xb579027f}},	//   _prüf, cipt, шел_, ащих_
  { {0xed590015,0xd5750024,0x865c0009,0xc69400af}},	//   шой_, цуль, נדהי, פאק_
  { {0x63a90052,0x3991000e,0x7cfe09d4,0xd5ae0012}},	//   twen, vás_, tūra, ئفي_
  { {0x59e10037,0x69dc00e2,0x42e90001,0xd36e0012}},	//   पनकर, øren, имио_, نهي_
  { {0x68e90013,0x63a9008b,0x39910bb6,0x60c40027}},	//   _hled, rwen, tás_, _snim
  { {0xa9690046,0x54550014,0x64c50012,0xddc30159}},	//   јима_, _двет, _ويطل, banš
  { {0x3ea00027,0x2d8705a7,0x6d5c0bb7,0x39910bb8}},	//   đite_, mune_, vpra, rás_
  { {0x7d240047,0xcaf50012,0xdaf50012,0xe7d60024}},	//   _эффе, _وستب, _وستظ, ціню
  { {0x539a000b,0xd706002d,0x917a001a,0xdc1c001e}},	//   _כינו, ізви, hấy_, aņēm
  { {0x3ea70108,0x82370003,0xc3320009,0xe5670012}},	//   ient_, _ارشا, _חוג_, بط_
  { {0xe45a00ac,0xb05b0038,0x70560012,0xb7da0012}},	//   ржа_, sjär, _بنظا, _نوعا_
  { {0x3ea70bb9,0xbf660012,0xb8ee0011,0xbbd50009}},	// [1440] kent_, _بدعو, रा_, חוּץ_
  { {0x3ea70bba,0x8e860012,0x7d1b0bbb,0x2d87005e}},	//   jent_, _بلده, hous, kune_
  { {0xdcfc000d,0x75240052,0x8c4604b3,0x41aa0014}},	//   gură, pliz, _мене, рвен_
  { {0x9f960051,0xab5b0052,0x08c60048,0xc3290009}},	//   _tüüp_, _brüd, юбен, דו_
  { {0xbba80037,0x7d090bbc,0x027f0066,0xc6900012}},	//   _कनेक, čest, _říše_, ِّت_
  { {0xdc1c001e,0x68e20bbd,0xdee30842,0x6f1c0bbe}},	//   zņēm, skod, мочи, norc
  { {0xab5b0051,0x2d870051,0xe8010037,0xc0e6002d}},	//   _prüg, gune_, _लेना_, _довк
  { {0x1517000a,0x68e90133,0x7f860012,0x88c60012}},	//   يزية_, _gled, _ولأن, _بتسل
  { {0xdcfc001e,0xe7a90011,0x0ba60024,0x3ea70bbf}},	//   ltrē, _चैंप, ішим, bent_
  { {0x7e530012,0x2126016d,0xe3af0012,0x7d090bc0}},	//   _ينقص, lloh_, ئري_, anes
  { {0x2d870bc1,0x6104000e,0xdcfc001e,0x7ce3005e}},	//   cune_, zőle, ntrē, _sõrm
  { {0x5bc60003,0x6b96006f,0xdcee001e,0x23660034}},	//   _وقال, ktyg, ēdēj, _twoj_
  { {0xc49b000b,0x8c3d0060,0x6f1c0bc2,0x493b00af}},	//   _כשאת, neşl, forc, יגטו
  { {0x3f50001a,0xfeca0009,0x6f1c071e,0x7d000bc3}},	//   _màu_, ׁמָּ, gorc, lims
  { {0xfc3f0013,0xd5b80ac5,0x52130001,0xccfb0001}},	//   žít_, ост_, _одшт, аћа_
  { {0x8b67000a,0x9f6b0001,0x6104000e,0x3ea70bc4}},	//   قائم, _кроз_, tőle, zent_
  { {0x43940046,0xa3ab0037,0x9cd70009,0x6f1c0516}},	// [1450] матс, _कैश_, קומה_, borc
  { {0xf43b0093,0x6d5a0b0c,0x2732000d,0xb4db001a}},	//   שתמש, _otta, nând_, _giàn
  { {0x3ea70bc5,0xdcf50002,0x41b50012,0x15ab0048}},	//   vent_, erzą, ثمار, _тъпи_
  { {0xaac90044,0x76550002,0xc2370009,0x7cfe0073}},	//   राहक, lczy, קראו_, dūro
  { {0x8cce0037,0x99540066,0xdcfc000d,0xef0e01ec}},	//   थानो, _výše_, sură, ем_
  { {0x7bda000b,0xd00c000b,0x7d000028,0x76550002}},	//   _הקשו, יּוֹ, eims, nczy
  { {0x63a20017,0xdcf50002,0x69dc0260,0x7d090bc6}},	//   _apon, arzą, ørel, tnes
  { {0xe918002d,0x63ad0002,0xeae30011,0x3cc9004c}},	//   _досі_, owan, गस्त_, слио_
  { {0xff53000a,0x291d0002,0xddc10066,0x63ad0b3a}},	//   _آخر_, mowa_, _delš, nwan
  { {0xdd000039,0x63a0006f,0x2732000d,0x291d0002}},	//   ētāj, _ämne, gând_, lowa_
  { {0x386d00bd,0x4225002d,0x63ad0bc7,0x3a250109}},	//   _keer_, ядов, hwan, ямог
  { {0x8c3d003a,0xd59a000b,0x45b60009,0x9b750012}},	//   leşm, _לבעל, _מפעל_, _فاتص
  { {0x386d00bd,0x7ce3005e,0x7c070012,0x5cd20012}},	//   _meer_, _tõrj, _بباك, _سقوط
  { {0x27320bc8,0x501a000b,0xfc300012,0x02450012}},	//   când_, מורו, _شحن_, _عَبَ
  { {0x291d0002,0x63bb02d2,0xa92801e9,0x63ad0120}},	//   kowa_, lvun, ližš, ewan
  { {0x2732000d,0x317a000b,0x63ad0052,0x291d0002}},	//   mâne_, _האקד, fwan, jowa_
  { {0x291d0002,0x2d83006f,0x61e1004a,0x577a0012}},	// [1460] dowa_, arje_, lyll, _اصبح_
  { {0xe81f0037,0x8b230015,0x78b6003a,0x6b96006f}},	//   _बड़ा_, едуе, _hayv, rtyg
  { {0x6edb0093,0x26db0009,0x7edb0009,0xd6db0009}},	//   _החיפ, _הקימ, _הקיצ, _החיל
  { {0x2732000d,0xdcf50002,0xb60805b1,0x3eaa0032}},	//   zând_, trzą, alší, lebt_
  { {0xdcfc0039,0x4cbb000b,0x9cd70009,0x94bb0009}},	//   strē, _הזכו, _זוכה_, _המכת
  { {0x2d980108,0x8f9b000b,0x7cfe0010,0xb4b40037}},	//   otre_, מיני, tūro, _छोड़_
  { {0x6d46000f,0x2902003a,0x2732004b,0x291d0034}},	//   _kika, kika_, vând_, bowa_
  { {0x2d980061,0x3f50001a,0xdc13003a,0x76550002}},	//   itre_, _tàu_, _aşır, zczy
  { {0x3f670014,0x2732000d,0x76550002,0x7f4a0012}},	//   _нито_, tând_, yczy, _طلاق_
  { {0xdb0d0149,0x386d0070,0x248d0017,0x76480073}},	//   rvaç, _zeer_, agem_, _ugdy
  { {0x44270020,0x7dc50003,0x2732000d,0x5a34002d}},	//   ́n_, _يتمك, rând_, ьнот
  { {0x63ad003e,0x76550002,0x6d460bc9,0x3d160011}},	//   ywan, wczy, _nika, थकों_
  { {0x2732000d,0xb4db0054,0x6123005e,0x613f0035}},	//   pând_, _diàl, põlv, _jūli
  { {0x6d460006,0x44260101,0x61360028,0xd37b000b}},	//   _aika, _iyo_, jálf, _פרוט
  { {0x26da01a2,0x6a9b000b,0xe29b0009,0x06fd0066}},	//   _dopo_, _השונ, _השור, _říká_
  { {0xdb0d000e,0xe81e0037,0xa4d40024,0x31e50012}},	//   óköv, _युवा_, носі, _تسهّ
  { {0xa87c0093,0x2d9c0163,0x6d4600c6,0x0f27002d}},	// [1470] _האחר, _även_, _dika, _ньом
  { {0x61120039,0x7cea022d,0xa3bf0037,0x6eef03ee}},	//   māla, _výra, ुमत_, _købe
  { {0x9b17000b,0x291d0002,0xe8010037,0x7522000e}},	//   לחמה_, towa_, _लेता_, _okoz
  { {0xf7710351,0xf1c0008a,0xddde0013,0xc7b10012}},	//   نات_, ương_, _nepř, َّا_
  { {0x6eef0058,0x3f8b003a,0x6112001e,0x4426002c}},	//   _løbe, nucu_, nāla, _nyo_
  { {0xd246000a,0x386d00bd,0x291d0bca,0xad59024d}},	//   _لن_, _weer_, sowa_, орих_
  { {0x6721012e,0xfe700003,0xd658000b,0x9f440066}},	//   _vklj, اده_, היות_, ámé_
  { {0x6112001e,0xa0c50012,0x7d0d0bcb,0x61e1008e}},	//   kāla, _تيرو, nnas, vyll
  { {0x2d8a0058,0x53c90024,0x1dbd0011,0x6ef0005e}},	//   _åben_, ігом_, ्महत, _häbe
  { {0x6721001c,0xa91d0026,0xe578001e,0x6104000e}},	//   _uklj, buľk, šķi_, dőla
  { {0x6f0301a2,0x68ed0bcc,0x8afd0030,0xf8bf0097}},	//   minc, _blad, jpře, rlén_
  { {0x63a4000d,0x63c80031,0x361a0009,0x6f030bcd}},	//   _ţine, érnö, _וועד, linc
  { {0x889a000b,0x1eaa0012,0x8afd0030,0xdb0f0bce}},	//   חברי, ياسي_, epře, _escé
  { {0x2d980bcf,0x68ed0bd0,0x7d0d0bd1,0x7529018f}},	//   ttre_, _elad, enas, llez
  { {0xceb20093,0x60c9048b,0x2d980061,0xddc7009b}},	//   כים_, _onem, utre_, tajš
  { {0xd1320003,0x7d0d087a,0xa3ea0048,0x61120035}},	//   _جمع_, gnas, одба_, bāla
  { {0x0b46002d,0x2d980bd2,0xaac90037,0xddc7025e}},	// [1480] днан, stre_, रांक, rajš
  { {0xbe660003,0x6d4608bb,0xcaa60012,0x05560048}},	//   _تهدي, _wika, بصري, _отмя
  { {0x6d460039,0x7c260002,0xf3e90009,0x91aa0012}},	//   _tika, _wykr, סף_, تهاك_
  { {0x18670046,0x395c001e,0xcb09000b,0x23600070}},	//   даци_, īvs_, בל_, ppij_
  { {0x6f0300c1,0x4f570003,0x7d04004a,0xda660012}},	//   finc, وجود_, miis, _ياسي
  { {0x644b034e,0x9346007c,0x64590070,0x7522009b}},	//   _aggi, _інве, _afwi, _skoz
  { {0x1ea90003,0xdcf50002,0x2900004a,0x6da30001}},	//   ثاني_, erzę, _omia_, вија
  { {0x29020163,0x75290bd3,0x9be60024,0x84a90009}},	//   _öka_, glez, діок, ִיתִ
  { {0xdca3004c,0x2aaa0bd4,0xb7da00ae,0x22860557}},	//   тањи, отно_, _بوذا_, мунг
  { {0x65c60014,0xddc60001,0x2b470054,0x6d5e0027}},	//   _обза, _обзи, _cinc_, _otpa
  { {0x68ed0058,0xdcf50002,0x6d5e0107,0x75290164}},	//   _plad, arzę, ípad, blez
  { {0xf5030014,0x3f8b0060,0x61120035,0x6ef00248}},	//   _изхо, tucu_, tāla, _näbb
  { {0x7ce30005,0x59b00044,0xe53b000b,0x274b002d}},	//   _kõrv, _जनवर, _ותאר, ючно_
  { {0xe8df0020,0x3f8b003a,0x61120035,0x7c2f0060}},	//   _miền_, rucu_, rāla, ücre
  { {0x442d012e,0xc348001a,0xe8df001a,0xf6280024}},	//   _še_, _nổi_, _liền_, діти_
  { {0x30a70046,0x399802be,0x201e000d,0x7d0d0bd5}},	//   _цркв, més_, ştia_, unas
  { {0x39980bd6,0xe66705cc,0x60db0025,0x7d0d0bd7}},	// [1490] lés_, _отно, _roum, rnas
  { {0x0dcb0098,0x95cb0098,0x19eb0003,0x60db0061}},	//   _думи_, _дума_, يراً_, _soum
  { {0x3f99001e,0xa2c40037,0x60db0025,0x60c90227}},	//   _ūsu_, राज्, _poum, _pnem
  { {0x6f030002,0x30150bd8,0xb815004c,0xa0c50012}},	//   winc, ндер, ндеј, عيشو
  { {0x39980061,0xdbd600ff,0x70760012,0xa3c20011}},	//   hés_, _jääm, رموز_, ्मण_
  { {0x8ca10037,0x217b0012,0x6d580025,0xc1780073}},	//   क्नो, _وحزب_, _évac, ksė_
  { {0x7bc20036,0x6f030bd9,0xed560048,0xada50bda}},	//   _arou, rinc, нощ_, хайл
  { {0x273600c5,0x8c3d003a,0x3998057d,0x7bc20bdb}},	//   mæne_, leşi, dés_, _brou
  { {0x613605b1,0x2409003c,0x68e4008e,0x753b0bdc}},	//   nále, янии_, öide, rmuz
  { {0xbda70003,0xa3c20011,0xe299004c,0x75290030}},	//   _يحاو, ्मत_, чао_, slez
  { {0x39980bdd,0x39490bde,0xd9c90011,0x91e50198}},	//   gés_, _bias_, िमेट, хоне
  { {0xf8bf0042,0x2732004b,0xdcf50034,0xa01b0248}},	//   blém_, mâna_, przę, vgör
  { {0x39490149,0x2b470054,0x7d040269,0x69ce0032}},	//   _dias_, _tinc_, viis, äber
  { {0x61360066,0x7d790009,0xbb760009,0xfbd00012}},	//   dále, ּנּו, _טענו_, _ختم_
  { {0x399802be,0x13c80037,0x18a60055,0x6da300f5}},	//   cés_, रम्भ, _займ, лира
  { {0x7cea0042,0x61120035,0xad390557,0x7c6600ae}},	//   _výro, mālo, дчує_, عازل
  { {0x7d0401a3,0x8ca10011,0xdb040097,0x249f0097}},	// [14a0] riis, क्यो, fvið, ifum_
  { {0xda650003,0x7d040574,0x22160bda,0x915e0081}},	//   نامي, siis, нфер, _hẳn_
  { {0xf969002d,0x22930003,0x10ba000b,0x888605fb}},	//   дрій_, المس, ּזְב, ележ
  { {0xdd2f0013,0xa3c20037,0x3f860bdf,0xadd70009}},	//   pěšn, ्मद_, trou_, _נוכח_
  { {0x3998000f,0x2cad05aa,0x3c770009,0x2d870be0}},	//   zés_, deed_, _אתכם_, erne_
  { {0x7bc4007a,0x39980061,0xe578001e,0xf7730009}},	//   _šiuo, yés_, šķu_, נקו_
  { {0xf9870012,0x399800b7,0xb4fa0009,0x6b490073}},	//   _حب_, xés_, ּפִי, _užga
  { {0xe8df0020,0x71260003,0xc19b000b,0x61f2003a}},	//   _tiền_, _أرسل, _משלי, ıklı
  { {0xdccf001a,0x6b9b002c,0x6d3b0009,0x0aea0012}},	//   _tỉnh_, gtug, התקנ, كردي_
  { {0x39980be1,0x877b000b,0x7bc20070,0x13f30015}},	//   tés_, _מאמי, _vrou, узья
  { {0xe6d90028,0x27e60be2,0x22f70009,0x929b0009}},	//   _þráð, lyon_, גזין_, היית
  { {0xa3c20037,0x7cfe0010,0x2cad002a,0x7bc20be3}},	//   ्मा_, kūri, ceed_, _trou
  { {0xe8df0020,0x39980be4,0xb9090037,0x2d9c000e}},	//   _hiển_, sés_, _मक_, ltve_
  { {0x39980be5,0x9f35002d,0x61360042,0xf09f01a0}},	//   pés_, тегі, vále, sfà_
  { {0x2d9c000e,0x26de0be6,0xb2bb0009,0x7cf50030}},	//   ntve_, _moto_, _זמור, _dárf
  { {0x98a40001,0x612a0097,0x61e503a7,0x26de0be7}},	//   _биће, býli, vyhl, _loto_
  { {0x3eba000d,0x853b0009,0xfa87004c,0xa2cd0011}},	// [14b0] _fapt_, לגלי, ећем, साल्
  { {0x26de00c1,0x78a4001b,0x61360030,0x3ce90159}},	//   _noto_, _zbiv, rále, skav_
  { {0xab5b008b,0x7b0b001e,0x249f0028,0x7d0200b8}},	//   _grün, kļuv, yfum_, _omos
  { {0xa954007c,0x3eae0070,0x82340003,0xdb040028}},	//   укці, eeft_, اركا, svið
  { {0xcc760009,0x7f190024,0x9b580048,0x5ff50048}},	//   _שעשה_, міку_, _пият_, ъзду
  { {0x752d01a2,0x86980014,0xe8df001a,0x6e290066}},	//   llaz, етът_, _biển_, řebu
  { {0x5b140001,0x7db20003,0x27e60be8,0x623400b3}},	//   _смрт, لموص, ayon_, _беру
  { {0x752d02d1,0x270e0011,0x78bd0897,0x26fe0011}},	//   nlaz, _सद्र_, jdsv, _उग्र_
  { {0xf6990046,0x78af000d,0x2cad0be9,0x249f0bea}},	//   _овај_, decv, reed_, rfum_
  { {0x99d50003,0xc43c000b,0x7d020beb,0x4c3c0009}},	//   نتجا, התחי, _emos, התחב
  { {0xe4e7002d,0xc332000b,0x9f440030,0x2d9c0064}},	//   _підн, שוי_, ámí_, ctve_
  { {0x23b5000a,0x69c3009b,0x67230bec,0x658e0031}},	//   _لمؤس, _vrne, lonj, sőhá
  { {0x78bb0061,0x907a0009,0x3ae40248,0x1867004c}},	//   _mauv, וטרי, _köpt_, ђари_
  { {0x60cd0bed,0xdb240031,0x6723016d,0x6b890bee}},	//   _enam, ésün, nonj, mreg
  { {0x7c960014,0xd627096e,0x27e6003a,0xc6920009}},	//   крац, воре_, zyon_, יאם_
  { {0xfbe7008a,0xe6d90028,0xc5f2000b,0x7c85004c}},	//   _thể_, _þræð, בדל_, луђе
  { {0x3eba0033,0x0326024d,0x6d4b0a83,0x1c4607b9}},	// [14c0] _tapt_, вдан, _miga, тнам
  { {0x073a0003,0xd36f0003,0x6d4b0bef,0x394a05b1}},	//   _تسبب_, تهك_, _liga, _časy_
  { {0x63a9001e,0xd9460001,0xe2970bf0,0x7c290040}},	//   _ģene, вежи, тах_, _øern
  { {0x6b890070,0x21670294,0x8ca10011,0x480a0048}},	//   kreg, тици_, _कॉलो, меен_
  { {0xa8570093,0x4fb30003,0x60230015,0xd12f0003}},	//   דינה_, لصور, адца, آمن_
  { {0x57fb000b,0xc9860003,0x61380066,0xdb0f0018}},	//   ולנו, _لشري, díle, _escâ
  { {0x27e60bf1,0x6d4b002c,0x80b20011,0xf7470012}},	//   syon_, _biga, ज़ाइ, خلوي_
  { {0x6abc0225,0x399c0054,0x5bb8010c,0x621b0009}},	//   _harf, mís_, елия_, _חולק
  { {0xdfa50003,0x26de00f1,0x9696002d,0x6d4b02a5}},	//   _محلي, _toto_, _ареш, _diga
  { {0x61310163,0xc43b000b,0xb87b000e,0x2ac60001}},	//   håll, ותפי, nkív, тљив
  { {0x68e00028,0x4dda0012,0xa2c30011,0x399c0bf2}},	//   _komd, _توضح_, रयत्, nís_
  { {0xb97b000b,0x7cf8000e,0x78bd0227,0x7cea0097}},	//   ונטי, _hírf, udsv, _dýrk
  { {0xe9ff008a,0x61380066,0x7cf501c4,0xb8fb0011}},	//   _phải_, cíle, _sárg, _डच_
  { {0x6d4b0032,0x6d400bf3,0x61360bf4,0x3d950bd4}},	//   _ziga, lmma, tálc, лигр
  { {0x5e58007c,0x7bc6003e,0x9e090003,0x09e30001}},	//   тися_, _arku, ريرك_, _војн
  { {0xe4a70014,0x6d4e0061,0x6594004c,0x853c0073}},	//   ърго, _ébau, јату, _spėj
  { {0xe3b00003,0xb8f70037,0xe9ff001a,0x6d580061}},	// [14d0] يرك_, सा_, _thải_, _évan
  { {0x8c440046,0x539b000b,0x78bb0061,0xe8df001a}},	//   ређе, וימו, _sauv, _miễn_
  { {0x6136000f,0x78bb0061,0x2247006f,0x2d580061}},	//   lála, _pauv, änk_, _née_
  { {0xfc640098,0xf8bf0061,0xa2a90011,0xfc3f01e3}},	//   _върн, ndé_, _जॉन्, _maíz_
  { {0x6136000f,0x9cd6000b,0x8c3d000d,0x07a50103}},	//   nála, _עושה_, neşt, уалн
  { {0x539a0093,0x2d910066,0xa5b90001,0xa3c00037}},	//   _אישו, ouze_, ећих_, ंटर_
  { {0x69dc0051,0xdb1d0018,0x3f8f005e,0x399c026b}},	//   ärel, _ersã, sugu_, cís_
  { {0x38c2000e,0x7cfe0010,0xce380009,0x91fc0035}},	//   térő_, kūru, כאות_, abāk
  { {0x1b4900de,0x6d4b0bf5,0x07090012,0xd2990024}},	//   нзии_, _viga, _كيري_, нтні_
  { {0xe8df0020,0xe9d90046,0xa6f90009,0x6b890bf6}},	//   _diễn_, еко_, _אִ֣י, rreg
  { {0x0495000a,0x394d0070,0x7c2b0002,0x61380066}},	//   _ملاح, _kies_, _wygr, síle
  { {0xa6e20065,0x6b890bf7,0xdcbb0024,0xbd010030}},	//   _öðru, preg, _іще_, _šéfe
  { {0x7cfe0010,0x6136000e,0x6c7a0009,0xae070011}},	//   gūru, gála, _נאספ, _वेतन_
  { {0x2cbf0051,0x394d0bf8,0xe29905fb,0xe8d00011}},	//   ldud_, _lies_, _чак_, _सच्च
  { {0xd336000b,0xe7370014,0x82d6000b,0x2cbf0051}},	//   _גרסה_, уер_, _תוצג_, odud_
  { {0x7d0904fa,0x2cbf0051,0x399c0054,0x8c3d004b}},	//   nies, ndud_, vís_, beşt
  { {0x8c3d000d,0x6abc0b87,0x752400eb,0x80d10011}},	// [14e0] ceşt, _parf, roiz, धारे
  { {0x80a00044,0x7bc40010,0xd36f0003,0x7d090bf9}},	//   ग्रे, _šiuk, سهم_, hies
  { {0xcd360003,0x7ce30051,0x6abc006f,0x869b0009}},	//   _مرحب, _võrr, _varf, _אייז
  { {0x50ba0003,0x4f660003,0x399c0840,0xa8760012}},	//   عداد_, هاتف, rís_, اطات
  { {0x394d0bfa,0xdee609b1,0x62830bfb,0xc4d30009}},	//   _dies_, лоди, _odno, _הגר_
  { {0x2d80001e,0xd5b00003,0x3f72001e,0x7bcb0009}},	//   ņiem_, قفت_, iņu_, _אֶלֶ
  { {0xc693000b,0xae070037,0xf6570009,0xfa770009}},	//   צאה_, _वेदन_, נסקי_, _תעלת_
  { {0xfc3f0164,0xc5f3000b,0x7d090bfc,0xa534004c}},	//   _raíz_, מדו_, gies, јнич
  { {0xd250000a,0x4e960003,0x9cd7000b,0xc6960012}},	//   ينة_, _مشار, רופה_, _مشاع
  { {0x6136000f,0x8c3d000d,0x3f72001e,0x7cf8000e}},	//   vála, veşt, dņu_, _hírd
  { {0x62340001,0x28f900b3,0x7d090bfd,0xb1150024}},	//   рену, вень_, bies, имош
  { {0x8c3d000d,0x361b0009,0xecb80011,0xe8df0081}},	//   teşt, _אובד, _आसिफ, _tiễn_
  { {0x8cbf0044,0xe4e90012,0xf8bf0bfe,0xead40367}},	//   _लोगो, _جعله_, rdé_, _воль
  { {0x4383000a,0xbb83000a,0x8c3d007d,0xb3bb000b}},	//   _الوق, _الوي, reşt, _נמוכ
  { {0x4a5b000b,0x8ca10037,0x6d580061,0x8c3d000d}},	//   _אדוו, क्वो, _éval, seşt
  { {0xa99b000b,0xdb190052,0x6136000e,0x319b0009}},	//   _נבחר, _erwä, láln, _נבחנ
  { {0xe8df008a,0x1bd40014,0xab950024,0xa3d4003c}},	// [14f0] _hiện_, ботя, ризі, ботч
  { {0xe8df0020,0x7d090002,0xab94002d,0x8c1b0009}},	//   _kiện_, zies, сифі, תומי
  { {0x38600065,0xc333000b,0x9055002d,0x91f90012}},	//   _yfir_, צוע_, авец, خفاء_
  { {0xd7f10003,0xb97b000b,0x02440003,0x7cf50bff}},	//   يكا_, תנאי, حَمَ, _márc
  { {0xdb090028,0x248e0066,0x7d09072a,0x613601bd}},	//   kveð, íjmů_, vies, káln
  { {0x7d09031f,0x2f5c0009,0xb8080012,0x41770012}},	//   wies, עדונ, ديهم_, _مارس
  { {0x8aa4007c,0x4519085b,0xe4510003,0x394d0c00}},	//   _уряд, кция_, يضة_, _ties_
  { {0x7cf80056,0x2bc90011,0x290b017b,0xdcf80035}},	//   _vírg, रिपा, jica_, duvē
  { {0x54a40003,0x28f80021,0x7cf50031,0xe4a80009}},	//   صحيف, _сеть_, _párb, אֹתָ
  { {0x42550046,0x03a80003,0xe8df001a,0xfbd2000b}},	//   штит, اديو_, _biện_, קתי_
  { {0x186a0014,0x7cf8000e,0x6b8d00b6,0x290b0c01}},	//   кани_, _híre, hrag, fica_
  { {0xe8df0020,0x61fa0051,0x3f72001e,0x0fc6002d}},	//   _diện_, _ütle, tņu_, аймн
  { {0x6112001e,0x613d000e,0x07a60001,0x69dc03ee}},	//   nāli, zélg, јагн, ører
  { {0xdcee0066,0xabfa0009,0x0f560009,0x2fc90c02}},	//   ědče, _שהסר, יישם_, _drag_
  { {0x2d9e0108,0xb87b01c4,0xa5460003,0x6b8d00b6}},	//   îte_, tkít, لضرو, erag
  { {0x6b8d08fa,0x3fe6002d,0x82340012,0x3e830060}},	//   frag, _вжив, _ارها, _açtı_
  { {0x6136000f,0x42560014,0x70b20037,0x6d4f0c03}},	// [1500] lálo, атет, ज़ील, _dica
  { {0x8ccc0044,0xe1f20003,0x68e400ff,0xb77b0009}},	//   _दोनो, يسا_, _hoid, _שאיש
  { {0x6d4f0149,0x98da0011,0x61360636,0xf8da0011}},	//   _fica, _बचाए, nálo, _बचाय
  { {0x68e40006,0x3ead0027,0x2c5c0002,0xdbdc014a}},	//   _joid, đete_, _bądź_, lšíc
  { {0x684a0010,0x2635001a,0xd1170009,0x6b8d0c04}},	//   būdž, _áo_, סקנה_, crag
  { {0xdfcf0003,0x160b0011,0xcf930009,0x613d0031}},	//   بيه_, _हेडर_, קטו_, méle
  { {0x80c10037,0xd5b00003,0x6136000e,0x8d63004c}},	//   _रोके, سفة_, váln, овје
  { {0x3ea00013,0x54b80014,0x61360030,0x61380097}},	//   řit_, угия_, dálo, bíla
  { {0x2bc90037,0x3ebe0033,0x7e7c0c05,0x2eb60695}},	//   रिया, _tatt_, karp, _всес
  { {0x60c2007a,0x8f9b000b,0xe8010037,0xdbdc01bd}},	//   ldom, _בימי, _लेगा_, jšíc
  { {0x60c20010,0x32570009,0x20d50012,0xdcf60030}},	//   odom, יסים_, مقدس, ýběr
  { {0xab5b008b,0xe8df001a,0x7e6e006f,0x613d000e}},	//   _früh, _viện_, ebbp, kéle
  { {0x7cf10623,0xb4fb0009,0xe8010011,0x57640012}},	//   _dårl, _בלאר, _लेखा_, قدِّ
  { {0x7e7c006f,0xe8df001a,0x6136000e,0x6b8d00f6}},	//   garp, _tiện_, láll, vrag
  { {0xbbb60044,0x13b60044,0x5bb60037,0x94d5002d}},	//   _अनुक, _अनुभ, _अनुव, бовц
  { {0x89db000b,0x2fc60027,0x6136000e,0x6b8d0c06}},	//   _יחוי, kvog_, náll, trag
  { {0x113c000b,0xfbd00003,0xf7730012,0xdd2f0030}},	// [1510] _בתהל, وتك_, _باع_, _těžb
  { {0xf9c700c0,0xe2930003,0xb4e30011,0xfeb9004c}},	//   ищен, تذر_, _नक्_, _слој_
  { {0x60550003,0x31580003,0xb4db0054,0x6d4f0c07}},	//   مناط, لجنة_, _diàr, _tica
  { {0x6b820027,0x6112001e,0x7bdd005e,0x60c00c08}},	//   _ovog, tāli, äsuk, _camm
  { {0xf8bf0061,0x7d0d0c09,0x9cd60009,0x684a0073}},	//   llés_, mias, _הורה_, pūdž
  { {0x6136000f,0xaf04002d,0xb8820028,0x6112001e}},	//   eáll, опіл, _þíni, rāli
  { {0x61380013,0x645a000d,0x2909004a,0xeef8000b}},	//   síla, _ştii, _omaa_, שמור_
  { {0xa618000b,0x201e000d,0x613601c4,0xeb9902ad}},	//   יקוד_, ştii_, gáll, гии_
  { {0xe5040003,0xe3b10012,0x7cfe0035,0x7cf80031}},	//   تبوي, سرة_, tūrr, _hírc
  { {0x6d440002,0x6b82001b,0x23620097,0x7d0d0c0a}},	//   zmia, _dvog, íkja_, hias
  { {0x7e7c0028,0x613d000e,0x7ae30c0b,0x68e40c0c}},	//   varp, zéle, _vont, _poid
  { {0x3f6a0046,0xa2c90037,0x61d6000b,0xc2120009}},	//   лимо_, _होस्, צורף_, להי_
  { {0x68e40006,0x7e7c0071,0x320b0002,0xe5360009}},	//   _void, tarp, ńcy_, _פטנט_
  { {0x7afa04a3,0x60c20c0d,0x96630048,0x4ac40012}},	//   chtt, zdom, зкре, _وينق
  { {0xf8bf02d1,0xa2db0044,0xb9950003,0x99850003}},	//   glés_, नान्, _العب, _البو
  { {0x4bda0015,0xa9050003,0x62870c0e,0x6ab70011}},	//   льзя_, _وبين, _adjo, _असुर
  { {0xb8de0037,0x7cfc000e,0x61360029,0xdbdc00d9}},	// [1520] ुए_, _férf, nálm, pšíc
  { {0x6136000e,0x3fdb0009,0xf8bf0025,0x290e0034}},	//   záll, _עקיב, blés_, ślać_
  { {0xc879003a,0x7d0d0c0f,0x1e570009,0x613d0025}},	//   _beş_, bias, _לשיר_, séle
  { {0x2732000d,0x3f820002,0x69dc008e,0xd9430048}},	//   mâni_, osku_, ärei, пехи
  { {0x44240020,0xccf3000b,0x7bcd0010,0x2bc90011}},	//   _âm_, _זכר_, _šaun, रिणा
  { {0xb8ef0044,0xbb430024,0x3b0a003c,0x61120035}},	//   _वो_, _неяк, _сего_, mālu
  { {0xa3c20044,0xceb3000b,0xdbf10066,0x6b820027}},	//   ्मक_, פיה_, _dřív, _svog
  { {0xd2170093,0xdb1d006f,0x915e001a,0x8a17000b}},	//   _הקלק_, _ersä, _gắn_, _החלו_
  { {0x6112001e,0x24180015,0x3f820c10,0x369a0012}},	//   nālu, ропы_, jsku_, _مضاد_
  { {0x27f90051,0x7cf5000e,0x2bc90037,0x66e50012}},	//   _üsna_, _vára, रिता, _وألق
  { {0xd2500012,0x5eeb0009,0x7bcb0c11,0xe6c50012}},	//   بند_, _עַמְ, _ergu, _بتقي
  { {0x3a370093,0x7cfc0065,0xca37000b,0x6136000e}},	//   מרים_, _sérf, מניה_, lálj
  { {0x6d5a00c6,0xdcee001e,0x28b80011,0xdb0d0097}},	//   _huta, arbī, इज़ि, kvað
  { {0x6136000f,0x28cf0037,0x7d0d0002,0xf8bf000e}},	//   nálj, _सोनि, wias, tlés_
  { {0x427b000b,0x7d0d0038,0x7a530012,0x7a7b0009}},	//   _גאוג, tias, _عضوا, _גרוס
  { {0xe2170093,0xa4f100a2,0xf8bf000e,0xba17000b}},	//   _לקוח_, _dışı_, rlés_, _לחוץ_
  { {0x28d60044,0x63a40960,0x212b0064,0x99620064}},	// [1530] धारि, gtin, moch_, _ríše_
  { {0xda670003,0x6e950003,0x39460c12,0x3ce6005e}},	//   صائي, _بلدا, emos_, _loov_
  { {0x7cfc000f,0xb9b50003,0xdcfc001e,0x6d5a0b86}},	//   _kérd, تماع, gurē, _nuta
  { {0xd0110003,0x9cb50003,0xc5e80009,0x2ba90011}},	//   ولا_, _بمحت, _הַשֹ, _कहला
  { {0x2919069f,0x63a40c13,0x69d8008e,0xdbf10030}},	//   insa_, ctin, äver, _přív
  { {0x6287000e,0x6136000e,0x3983003a,0xd00c0009}},	//   _udjo, gálj, yıs_, טּוֹ
  { {0x7bc70039,0x05790003,0x3f760002,0x212b0029}},	//   ājum, جمعة_, ału_, koch_
  { {0xe919002d,0x212b0029,0xfdf80009,0xab650400}},	//   _тобі_, joch_, מצות_, овил
  { {0x212b0c14,0x6136000e,0x290f0c15,0x9f4e0030}},	//   doch_, bálj, miga_, žném_
  { {0x290f0c16,0x13090015,0xdb1d02f1,0x29190c17}},	//   liga_, рной_, _ursä, ensa_
  { {0x61460014,0xd9460210,0xc1060012,0x6d5a0c18}},	//   жена, жени, قودي, _guta
  { {0x63a40065,0x290f0051,0xa2a90321,0x7cf5000e}},	//   ytin, niga_, _जॉर्, _zárn
  { {0xe73a035b,0x3f840107,0x7cf5029d,0x6136000e}},	//   ием_, ému_, _háro, lálk
  { {0x7cea0028,0x78ad005e,0x2f5a0009,0x68f80035}},	//   _nýrr, _ebav, ידשנ, īvdi
  { {0x39400274,0x954a0003,0x6916009b,0xdd920012}},	//   _this_, لشرق_, jšeg, ظور_
  { {0x6136000e,0x20d6002d,0x6112001e,0x63a40c19}},	//   zálj, _фікс, tālu, ttin
  { {0x6ef00005,0x23690003,0x290f0c1a,0x2d910034}},	// [1540] _läbi, محلي_, diga_, arze_
  { {0xdcfc0039,0x2d910002,0x29f5001a,0x290f0010}},	//   turē, brze_, óa_, eiga_
  { {0x6136000e,0x7cf50042,0x6da60012,0x80a70011}},	//   válj, _náro, _بمجم, ट्वे
  { {0x7cfc000f,0x61360028,0x290f0051,0x6d5a0c1b}},	//   _kére, dálk, giga_, _ruta
  { {0x39460c1c,0x87ba0015,0xdb040070,0x6916009b}},	//   rmos_, рует_, ntië, ašeg
  { {0x7cfc000e,0x3ce60051,0x141b000b,0x758a0014}},	//   _mére, _soov_, _כוכב, асив_
  { {0xccfa0001,0x6136000e,0x98ca0011,0xaf070012}},	//   ићи_, rálj, ियाए, تقوم_
  { {0x443d008b,0x3eb80052,0xf6530009,0x60c40c1d}},	//   _bzw_, hert_, וצו_, _naim
  { {0xa6860c1e,0x7d030012,0x14a60011,0x212b0064}},	//   _млад, بِيه, क्षण, voch_
  { {0x61360c1f,0x3f800010,0xd25a0001,0x6d5a0c20}},	//   lálh, šius_, шци_, _tuta
  { {0xd62a0015,0xa2db0037,0x212b0029,0x4a5b000b}},	//   _тоже_, नात्, toch_, ידיו
  { {0x6136000f,0x2480000e,0x613d0028,0x2d980c21}},	//   nálh, jaim_, féla, dure_
  { {0x212b0029,0x3eb80c22,0x2d980c23,0x7cfc0018}},	//   roch_, fert_, eure_, _cére
  { {0x6b840058,0x212b0029,0x2d910002,0x539b0009}},	//   dsig, soch_, trze_, _כידו
  { {0x6d42008a,0xa4d5007c,0x2d85000e,0x77f80011}},	//   _khoa, пові, éle_, ्छुक_
  { {0x01fb000b,0x2d830002,0x69dc004a,0x2458027f}},	//   _כפול, rsje_, äreu, жать_
  { {0x2bcd0037,0x7cfc0061,0x20020002,0x6b84002c}},	// [1550] ़िया, _gére, czki_, gsig
  { {0xad670003,0x80a70037,0xdb040061,0x60c40c24}},	//   _واجه, ट्रे, ntiè, _zaim
  { {0x63bb0052,0x6b840c25,0x76ba0009,0x6cd50012}},	//   zwun, asig, _המתפ, _فقدا
  { {0x915e001a,0x63670029,0xab5b0032,0x2fcd00b0}},	//   _sẵn_, nčný, _brüt, _preg_
  { {0x3f99003a,0x9f35002d,0xb8e30011,0xd7f8004c}},	//   nusu_, педі, _ऍस_, жуј_
  { {0x290f0a9d,0xd7bc0009,0xdfce0012,0x1fd80012}},	//   siga_, שֶׁך, ايو_, تظمة_
  { {0x5e78000b,0x63670029,0xad580015,0x7cf80066}},	//   חתון_, kčný, орых_, _mírn
  { {0x7cf5000f,0xd5ae0003,0x20d70003,0x9f44000e}},	//   _váro, افي_, _بتسج, ámú_
  { {0x3ec40006,0x1309002d,0xb8ff0037,0x2d980c26}},	//   östä_, йний_, ता_, _åren_
  { {0x7bc90108,0xa205002d,0x7cf5000e,0x63bb0052}},	//   rveu, зпод, _táro, rwun
  { {0x3eb80c27,0xdcf70012,0xcb120009,0x61360018}},	//   vert_, _وأصب, תלי_, láli
  { {0x443d0002,0x3eb80052,0x3ea10832,0xecbb0012}},	//   _tzw_, wert_, _acht_, _خططت_
  { {0x3eb80c28,0xe28e0a25,0x26c500b6,0x60c40269}},	//   tert_, _па_, _kalo_, _vaim
  { {0xb8f3015f,0xfe670003,0xf6d5002d,0x3eb80052}},	//   _हो_, عد_, міся, uert_
  { {0x3eb80119,0x57b80037,0x60c40051,0x2480000e}},	//   rert_, _इन्ह, _taim, taim_
  { {0x0457000a,0x3eb80c29,0x7d1b015e,0x26c5002c}},	//   كلفة_, sert_, nnus, _lalo_
  { {0x3f99003a,0x6136000e,0x7d1b0c2a,0xc9530009}},	// [1560] cusu_, válh, inus, _אמה_
  { {0x2d9801a2,0x6b8400c5,0x6627000e,0xc7b30009}},	//   pure_, rsig, érké, _טבח_
  { {0xc219002d,0x217a0012,0x365b0009,0xc4bd0011}},	//   оєї_, صحاب_, _לכינ, ्याओ
  { {0x7cf5000f,0x00e60015,0xb05b004a,0xc7c60015}},	//   _bárm, яжен, ydäm, зски
  { {0x6136000e,0x9f980024,0xab5b0032,0x7cf80031}},	//   rálh, івку_, _drüs, _híro
  { {0x7d1b0051,0x6e940001,0x62810c2b,0x8b8b0009}},	//   enus, фику, jalo, _לָלֶ
  { {0x6281000f,0x1ea90003,0x43430bac,0x613d0066}},	//   dalo, تاني_, _черв, déln
  { {0x68e900bd,0x7cf80066,0xf653000b,0x2120013a}},	//   _goed, _míro, עצה_, _njih_
  { {0xd4670001,0xe3c30012,0x6d5e0c2c,0x26c50018}},	//   чиње_, فْيَ, _lupa, _falo_
  { {0xe3af000a,0x98b8007a,0xfee90003,0x6ec50003}},	//   اري_, _kurį_, _وعلى_, _يتلق
  { {0x6d420020,0x672e012e,0x6e930003,0xf2d3000b}},	//   _thoa, dobj, _ألما, געת_
  { {0x93aa0003,0x0217000b,0x63a4000d,0x2df70009}},	//   _هاتف_, לחים_, _ţinu, _מצבך_
  { {0x6d5e0c2d,0x57f40063,0xdb040025,0x3f860018}},	//   _aupa, епят, ptiè, nsou_
  { {0xddc80010,0x628a0058,0x6d5e00b6,0xe5730012}},	//   _medž, _udfo, _bupa, فطر_
  { {0xdd910012,0xa2db0011,0xa5f80560,0x5eef0011}},	//   ضوء_, नास्, перу_, _अवस्_
  { {0xa99b0093,0x2eb90044,0x645a007d,0xc19b000b}},	//   _הבהר, _इस्त, _ştir, _השהי
  { {0x201e00a2,0xd0080046,0x3f860013,0xb05b004a}},	// [1570] ştir_, _неће_, jsou_, hdäk
  { {0x61360149,0xd7fc000b,0x57fc000b,0x7cf8000e}},	//   váli, _להחל, _ללחו, _hírl
  { {0xc692000b,0xf1c20035,0x68fb0c2e,0x4aae0011}},	//   _באי_, jušā_, _plud, ज्यव
  { {0xf9900003,0x89370012,0x7aea0c2f,0x62810c30}},	//   ابل_, أعطا, _loft, zalo
  { {0x68e90070,0x37ab0229,0x3ce00011,0x6f640024}},	//   _voed, стен_, काने_, евіз
  { {0xe8da0037,0x2d510066,0x8f9c000b,0xf7780009}},	//   _बच्च, _všem_, מידי, לעדי_
  { {0x2732007d,0x1ea80003,0xb0f60028,0x95990024}},	//   vânt_, ساوي_, þýða, ітку_
  { {0xed560098,0x7cf5000e,0xd5fc0009,0x5dfc0009}},	//   мощ_, _zárj, מפור, מפונ
  { {0xa2a10037,0xd7940048,0x6d490c31,0x7cf50064}},	//   _खाद्, _питъ, rmea, _hárk
  { {0xcda90003,0x6136000e,0xff530003,0xe4520009}},	//   _وهذه_, nálv, _أخر_, כֶת_
  { {0x63a4007d,0x260d0011,0xf8f90081,0x613d0031}},	//   _ţint, _डेली_, ượt_, réln
  { {0xc6890093,0x7cf5000e,0xdb0401e3,0x2bb60011}},	//   _כא_, _márk, rtié, _अनचा
  { {0x73e4002d,0x62810c32,0x9f4e08ca,0xe8df0081}},	//   _поїз, palo, žním_, _nhọn_
  { {0x387f0108,0xe6120012,0xa3c10011,0x63a90c33}},	//   _leur_, نشأ_, ंबन_, mten
  { {0x64a60014,0x35a30024,0x613d0031,0x63a90c34}},	//   мава, карг, célo, lten
  { {0x249f014d,0x205604fb,0x417a0009,0x6eef0040}},	//   ngum_, _отпр, _ונקב, _købs
  { {0xe8df008a,0xb4db0020,0xb4be0044,0x61380030}},	// [1580] _chọn_, _thàn, _इसी_, sílk
  { {0xf1fa0003,0x7cf5000e,0x613801d7,0xc2c60012}},	//   يعات_, _bárk, míli, بيئي
  { {0x8ca60037,0x7cf5000e,0x6edb0009,0x7edb0009}},	//   _छापो, _várj, _וחיפ, _וקיצ
  { {0x63a90c35,0xdfda0048,0x7cf50030,0x31be0030}},	//   kten, жък_, _dárk, _vůz_
  { {0x4cbb0009,0x69da001b,0x387f0227,0x2d850030}},	//   _וזכו, _šted, _deur_, šlet_
  { {0x61360028,0xdcfc0010,0xbd6a0048,0xad660012}},	//   málu, turė, орие_, وابه
  { {0x63a90c36,0xceb3000b,0x3f860017,0x6136000e}},	//   eten, דיו_, ssou_, lálu
  { {0x2ca00051,0x89d70003,0x249f0028,0x6128003a}},	//   ngid_, _توفر_, ggum_, nıld
  { {0x2ca00051,0x70560012,0x28dd0011,0x8f970012}},	//   igid_, _آنذا, यासि, _ينفذ_
  { {0xbb470012,0x7cfc0025,0x2732004b,0x57430048}},	//   ولين_, _déra, râns_, _ануб
  { {0x6128003a,0x7dc60012,0xdee30048,0xd915003c}},	//   kıld, _تتذك, _шофи, едны
  { {0x61e3006f,0x05770012,0x7bcd0073,0x61360031}},	//   änli, _آمنة_, yvau, zálv
  { {0xa294002d,0xacf7002d,0xcd020002,0xaae60012}},	//   _залі, _іншу_, reść_, _يستو
  { {0xbbbc0011,0x4c3b0009,0xa3d20011,0x2ca0005e}},	//   ्टीक, _ותדב, विन_, egid_
  { {0xfcc70001,0xf92b0003,0x929b000b,0x6136000e}},	//   мљам, _وأبو_, _ויות, válv
  { {0x3ea9001b,0x66250035,0xa2d605f3,0xb86700ae}},	//   đati_, _ārkā, बाक्, _غابو
  { {0xa87c000b,0x4374002d,0x2bbb0012,0x7bcd008e}},	// [1590] _ואחר, вуєт, غارة_, uvau
  { {0xab94002d,0x7bcd0872,0x20dd0011,0x28dd0011}},	//   тифі, rvau, यावध, यावि
  { {0x387f0061,0x98a20034,0x61360031,0x50b500b5}},	//   _peur_, soką_, rálv, еслу
  { {0xf7710003,0x6f15003a,0x1dc20011,0xdcf50035}},	//   هات_, lizc, _वैधत, irzī
  { {0x7afd001e,0xdfa40012,0x63a90c37,0x3f890025}},	//   ūsti, نحوي, xten, éau_
  { {0xd2460351,0x4f9c000b,0x6136000e,0xf774000b}},	//   _من_, קבוצ, lált, דקס_
  { {0x8d550147,0xa8a705d8,0xddd8001b,0x62850c38}},	//   нтич, _орак, tavš, maho
  { {0xd6580093,0x6136000e,0xc9840001,0x6d4d0c39}},	//   ויות_, nált, _јури, nmaa
  { {0x249f0028,0xfbd10003,0x6d4d004a,0x6f15003a}},	//   rgum_, اتب_, imaa, kizc
  { {0x62850101,0xe3c80020,0x63a90c3a,0xc2c50012}},	//   naho, _dự_, rten, ريجي
  { {0x613d000e,0xfeb80012,0xc3320009,0xb87b0030}},	//   mélj, _زالت_, רוי_, ajím
  { {0xb4be0044,0xcea90093,0x60c9005e,0x7cfc0097}},	//   _इसे_, _לי_, _jaem, _hérn
  { {0xb8e80044,0x6d4d0070,0x68ed0018,0x7cfc0031}},	//   _उस_, dmaa, _doad, _kérn
  { {0x6d59002c,0x201e000d,0x6d4d0c3b,0x645d020d}},	//   _hiwa, ăti_, emaa, _agsi
  { {0xe8160037,0x65610017,0x6128003a,0x7cf5000e}},	//   _देना_, _julh, tıld, _párh
  { {0x045a0003,0x65610017,0x6136000e,0x6d4d06f9}},	//   سلطة_, _mulh, gált, gmaa
  { {0x44260149,0x2bd20037,0xf1c9001a,0x6128003a}},	// [15a0] ço_, तिया, _hạ_, rıld
  { {0x28ac0037,0x60db0c3c,0xa857000b,0x6d4d06cf}},	//   ट्रि, _anum, _איפה_, amaa
  { {0x6128003a,0x61360031,0x91fc0035,0x499a0223}},	//   pıld, bált, ecāj, ятая_
  { {0x01fa000b,0xc7ca003c,0x6d46008e,0xf1c90081}},	//   הפעל, зыке_, _uhka, _mạ_
  { {0xf1c9001a,0x703a0012,0x69c30040,0xf0930009}},	//   _lạ_, أساس_, æner, רנד_
  { {0x8f75007c,0xc6f7002d,0xe5c60146,0x7bc60c3d}},	//   туці, нніх_, есио, _isku
  { {0xe3c80020,0xd5b7003c,0x7ec80035,0x6da3004c}},	//   _sự_, есы_, _rūpē, гија
  { {0xed570046,0x35c50037,0x273b001a,0xaa570012}},	//   ној_, विज़, hênh_, _ألفا_
  { {0xe8b500a2,0x7d04004a,0x6d590c3e,0x68ed0c3f}},	//   lışı, ihis, _diwa, _road
  { {0x55e6002d,0x51f8002d,0xf1c9001a,0x6136000e}},	//   _позб, дною_, _bạ_, zált
  { {0x13170093,0x7d04006f,0x61360028,0x7cf80066}},	//   תחיל_, khis, jáls, _círk
  { {0xe3c80020,0x753b000d,0x7bc60c40,0x040b0081}},	//   _tự_, cluz, _osku, _cưỡn
  { {0x0457000a,0x6136000f,0x7d16003a,0x7cfc0c41}},	//   _كلمة_, vált, diys, _héro
  { {0x3ea5000f,0x7bdb000b,0xe8b50060,0xf4570009}},	//   ült_, _מקדו, kışı, _ניגר_
  { {0x7521000e,0x7af5000e,0x27360028,0x6d4d0c42}},	//   élzo, özte, vænt_, tmaa
  { {0x23b70037,0xf98f0003,0x7cf5000e,0x823b0009}},	//   _अहमद, _ابو_, _pári, _מעוצ
  { {0x54550014,0xb9050037,0x628e0002,0x6136000e}},	// [15b0] тват, ना_, óbow, rált
  { {0x7cf50149,0x2d8c0027,0xab18002d,0x6d4d0c43}},	//   _vári, _ovde_, нієї_, smaa
  { {0x394900b6,0xf1c9001a,0xceb20009,0x6d4d0c44}},	//   _khas_, _xạ_, _דיי_, pmaa
  { {0x628500f1,0x44390504,0x05760009,0x628a0031}},	//   saho, _tys_, _שגרם_, ófor
  { {0xc1040003,0x7cfc0061,0x31580012,0x6d59016d}},	//   دوني, _aéro, رجمة_, _riwa
  { {0xa3c00037,0x9f400097,0x613d0031,0x93fa0009}},	//   ूटर_, áið_, félk, _חלשי
  { {0x2bc90037,0x6da20048,0xa9280064,0x613d0031}},	//   रिका, аища, nažé, rélj
  { {0x92580098,0x7cfc0061,0x9ddc000b,0x63ad0839}},	//   _част_, _déro, לקוח, otan
  { {0x3f8b0002,0xd4680012,0xcf270012,0x8e850012}},	//   jscu_, رحيم_, _كرئي, _للذه
  { {0xa3d20037,0xe6cb0037,0x69d50002,0xdcfc001e}},	//   वित_, ायोज, _krze, turī
  { {0x7cfc0c45,0x6d59002c,0x63ad0c46,0xf2d20009}},	//   _kérl, _tiwa, htan, בעי_
  { {0x61360031,0x6b890c47,0xa3c10011,0xdddc001b}},	//   váls, pseg, ंबा_, jarš
  { {0x63ad000e,0x7bc70035,0x7cfc0c48,0xa78c0009}},	//   jtan, ājus, _mérl, ּאלֹ
  { {0x78a2001c,0x69c70027,0xf8c7000e,0xa444002d}},	//   zgov, _osje, áért_, _снід
  { {0x7d160060,0x386d004b,0x63ad0c49,0xad5a04a5}},	//   tiys, _ofer_, etan, драх_
  { {0xad39002d,0x7d04005e,0x7aee01a0,0x61360064}},	//   ечує_, uhis, _sobt, ráls
  { {0x63ad0101,0xa3d20037,0xa03a0012,0x44630024}},	// [15c0] gtan, विध_, _تأثر_, рвув
  { {0x69d50002,0x62830c4a,0x13030237,0xc7d70009}},	//   _brze, _jeno, азум, _יופי_
  { {0x1d0a0345,0xf9690024,0xba170012,0x7bc60034}},	//   _жени_, ерій_, نيكا_, _wsku
  { {0x69d50002,0xa3d20037,0xe8b5003a,0x25d70009}},	//   _drze, विद_, rışı, _סוכן_
  { {0x69d50052,0x10a30c4b,0xc6fa0009,0xe7b40012}},	//   _erze, ричн, ֽלֶך, امتد
  { {0x4733002d,0xcdda0001,0xdd900003,0xf7730009}},	//   аніс, дњи_, موت_, סקו_
  { {0x27e0007d,0xceb3000b,0x69d50002,0x69d80058}},	//   ţin_, ייג_, _grze, æved
  { {0x23ab0058,0x5f960003,0xc5f30009,0x80ca0011}},	//   føj_, _للرئ, שדה_, _सोचे
  { {0xf8bf0061,0x7d03000d,0x62830c4c,0x6d3b0009}},	//   nnée_, _înse, _beno, ותקנ
  { {0x6e29003a,0xe6c50012,0xf1aa0012,0x38600c4d}},	//   şebi, _متمي, واجه_, _agir_
  { {0x26de0036,0x29fc0020,0xe8160044,0xcb13000b}},	//   _into_, ủa_, _देता_, שלת_
  { {0x63ad0c4e,0x62830031,0xcdf700af,0x51f703d2}},	//   ytan, ónoz, _שמאי_, тнюю_
  { {0x7cd70012,0x63ad0c4f,0x62830c50,0x69160c51}},	//   _جونز_, xtan, _feno, pšen
  { {0x8c43035b,0x62830c52,0xd7f80109,0xc0530009}},	//   _тече, _geno, тую_, יזר_
  { {0xd7880020,0xf8bf000e,0xb2bb0009,0x41b40012}},	//   hể_, tnéd_, _חמור, _إمبر
  { {0x26cc01c5,0x6924001b,0x3ead0030,0xcdb70009}},	//   _lado_, nđel, řet_, כפלה_
  { {0xf8bf0061,0xac180001,0x67d5003c,0x613d0031}},	// [15d0] gnée_, воту_, _сопу, vélh
  { {0x69d50656,0x613d0c53,0x80d80011,0x62880c54}},	//   _prze, déli, _नोबे, nado
  { {0xe298002d,0xf9c70014,0x6128003a,0x3264002d}},	//   тає_, ъщан, lıla, ртув
  { {0x45fa0009,0xa3d50011,0x67350034,0x7cf50031}},	//   _נהרג, हिम_, lozj, _járt
  { {0x612800a2,0x69d50002,0x6d5d002c,0xdc9a000b}},	//   nıla, _wrze, _iisa, _אירל
  { {0x69d5003e,0x57fc0009,0xa8580009,0xdb0f01a0}},	//   _trze, ולדו, דידה_, _escò
  { {0x609b0003,0x6d5d0c55,0x26cc052e,0x7cf80c56}},	//   _يخرج_, _kisa, _dado_, _síri
  { {0x248900bd,0x7d02084e,0x23ab0058,0x6128003a}},	//   naam_, _clos, tøj_, kıla
  { {0x6b8d0149,0x7cfc000f,0xed110020,0x6d5d00c6}},	//   nsag, _kérj, _đối_, _misa
  { {0x6d5d0005,0x7d020c57,0x6128003a,0xc43c0009}},	//   _lisa, _elos, dıla, ותחי
  { {0x20100073,0xd1b90012,0x8a160009,0x7cfc0031}},	//   ėlių_, رادا_, ָ֗יו_, _mérj
  { {0x2489005e,0x6d5d0c58,0x29190c59,0x63a00c5a}},	//   jaam_, _nisa, gisa_, bumn
  { {0x6128003a,0x511a0009,0x80a50011,0xe299020f}},	//   gıla, תֵינ, _कारे, _зал_
  { {0x3392000a,0x8c1a000b,0x539a000b,0x6b8d014f}},	//   _الوز, _אוני, _ניצו, dsag
  { {0xd6270345,0x291901ea,0x64460034,0xb1760081}},	//   горе_, bisa_, _szki, _trượ
  { {0x6128003a,0x29190c5b,0x649900b3,0xc5090012}},	//   bıla, cisa_, ктур_, نتقل_
  { {0x612800a2,0x6b8d0c5c,0xf0930009,0x93aa0012}},	// [15e0] cıla, gsag, _הנח_, عارف_
  { {0xf8bf0061,0x877b0009,0x36c60048,0xa2db0011}},	//   rnée_, _ראיי, _сбог, नाग्
  { {0x17570009,0x71650012,0xe1650012,0xaaa60011}},	//   _תסיר_, لانك, لدني, _खासक
  { {0x62880c5d,0x40960012,0x30a50024,0xa926003c}},	//   zado, الشر, ирів, ыдел
  { {0xd12f0003,0xb4c00037,0x62880c5e,0xc4d30009}},	//   أمن_, ंजी_, yado, _פגש_
  { {0xa3c10037,0xa857000b,0x62880c5f,0xc7b30009}},	//   ंबर_, אינה_, xado, צבו_
  { {0x7d03007d,0x6128003a,0xbb3b000b,0xb05b0c60}},	//   _însc, zıla, _נעלי, ndär
  { {0x612800a2,0x7cfc0844,0x3fa60003,0xd37a0c61}},	//   yıla, _térm, _مصطف, нчо_
  { {0x60cd0005,0x29040005,0x7bcd001e,0x9f5100d9}},	//   _raam, _ilma_, _šaur, žbám_
  { {0x26de002a,0x60cd00b9,0x24890070,0xba0a0048}},	//   _unto_, _saam, zaam_, ехме_
  { {0x22580051,0xef1f000e,0x7cf5000e,0x867b0009}},	//   ärk_, ssük_, _párt, _נראו
  { {0x612800a2,0xa055002d,0x6b9b0c62,0x7cfc000e}},	//   tıla, ивні, brug, _mérk
  { {0x33f60012,0x6446005e,0x6b4b0032,0x7cf50031}},	//   _حساس, ükid, lüge, _várt
  { {0x612800a2,0x6d5d0289,0xd5a60003,0x69c5002a}},	//   rıla, _sisa, يف_, ywhe
  { {0xbcfb0108,0x2904003a,0x6b4b0052,0xdb000051}},	//   _liée, _olma_, nüge, rtmä
  { {0x612800a2,0x75240c63,0x3ce70011,0xab5b005e}},	//   pıla, gniz, झाये_, _tsük
  { {0xaae00037,0x6d400038,0x6d5d0c64,0x30780012}},	// [15f0] नांक, ilma, _visa, _صحية_
  { {0x6d5d00c6,0xa3d50037,0x722b0021,0x8c1b0009}},	//   _wisa, हित_, нцев_, גומי
  { {0x6b8d0c65,0x26c30159,0x6d5d0c66,0x929b0009}},	//   ssag, mejo_, _tisa, תיבת
  { {0xe5c4002d,0x69c50132,0x26c30478,0x6b8d0c67}},	//   _усьо, rwhe, lejo_, psag
  { {0x7cfc01c4,0x17550024,0xdb040c68,0x97d80012}},	//   _térj, авдя, stiá, ُظهر_
  { {0x6b4b008b,0x539a000b,0x26c30c69,0x8c1a0009}},	//   füge, _בישו, nejo_, _יורי
  { {0xf4ba0028,0x7cfc0031,0xfce50681,0x26dc0009}},	//   _þýða_, _kérh, иоко, תקומ
  { {0xd6180003,0xe93b0012,0xcdcf004c,0x2d9e001b}},	//   دتها_, _أسست_, тњa_, šteg_
  { {0x69d80005,0x76a70003,0x60c40051,0xab5b0051}},	//   _arve, _محاك, õime, _psüh
  { {0x26c3012e,0x57f40001,0x98140012,0x05870024}},	//   jejo_, _упут, _طبقا, _будм
  { {0x628702d1,0x69d80027,0x26c3009b,0xf8c90011}},	//   _mejo, _crve, dejo_, _रसाय
  { {0x69de0026,0x33d5002d,0xc236000b,0x69d80027}},	//   _špec, _вікт, ירתו_, _drve
  { {0xa9360009,0x320c0034,0x95540012,0x62950159}},	//   שטרה_, azdy_, _اخلا, _odzo
  { {0x3ced012e,0x7cf5000e,0xa856000b,0x394d0017}},	//   ljev_, _társ, יירה_, _lhes_
  { {0xad3a0024,0x2d980c6a,0x94aa0012,0x98bf0060}},	//   вчає_, _året_, َارِ_, aptı_
  { {0x25ed0044,0xc5f2000b,0x88830014,0xa3d20011}},	//   _अपनी_, חדל_, _длъж, विल_
  { {0x75240c6b,0xf7720003,0xed570686,0x6b4b0032}},	// [1600] rniz, _باب_, рот_, züge
  { {0xa25a000a,0x75e80024,0xa696004c,0xbf130012}},	//   نشاء_, _блоґ_, _триј, _وويب
  { {0xa2a70037,0x09fa0003,0x7e9b000b,0x7cfc000e}},	//   _चार्, خفضة_, _בסיו, _férh
  { {0x40690009,0x42550024,0x6143003c,0x53a60c6c}},	//   ְיוּ_, стут, оеха, _камб
  { {0xdfd20003,0xe3b20003,0x43750c6d,0x67d4004c}},	//   تيش_, _برج_, _густ, солу
  { {0x98ab003e,0x9ea70046,0xc7d7000b,0xe29a0015}},	//   mocą_, авља_, יוני_, _шаг_
  { {0xb23a0003,0x4420000d,0x7cfc0061,0xce890003}},	//   _شكرا_, _ţi_, _héri, ائهم_
  { {0x92a6003e,0x6d400c6e,0x7d090c6f,0xd6570009}},	//   _wyłą, ulma, ghes, סיקת_
  { {0x6f1c0052,0x515b0009,0x889b0009,0x409b0009}},	//   kirc, _יכלו, _שבמי, _שבמס
  { {0x2d9c0066,0x0bb70009,0x7cfc0c70,0xfbb70009}},	//   prve_, סלים_, _méri, ספית_
  { {0x98af001e,0x79a30306,0x42fb0009,0x26c30c71}},	//   logā_, оряе, דהיס, vejo_
  { {0x8dfb000b,0xe58b0009,0x6d8b0009,0x1dd30011}},	//   _שהאת, _יָדָ, _יָדְ, थिरत
  { {0x8c430538,0x3945001e,0x394d0035,0x6aab0248}},	//   _деце, ēls_, ķes_, ämfö
  { {0x7cfc0028,0xa2d30003,0x63a40c72,0xabfb0009}},	//   _sérh, _وينت, duin, _בהדר
  { {0x26d1003e,0xe2970001,0x7cfc0061,0xfa770009}},	//   rdzo_, _тај_, _aéri, _דעות_
  { {0x26c30c73,0x63a40097,0xda5b0009,0x65680c74}},	//   sejo_, fuin, _בכול, _mudh
  { {0x63a40c75,0x3ce70037,0xea670001,0x2d58027f}},	// [1610] guin, झाते_, ањен, рить_
  { {0x6e2d00a2,0x883c000b,0xc7b2000b,0x7cfc0061}},	//   şabi, _בתחו, _צבי_, _déri
  { {0x75d50003,0xc3330009,0x32190012,0xdb060031}},	//   _ايجا, קוע_, دياد_, émáb
  { {0xc7950012,0xa3d60011,0x1869004c,0x7bcb0097}},	//   مشتب, ाटा_, ћали_, ægus
  { {0x7f19002d,0x2d910002,0x28ac0011,0x69ca0040}},	//   ліку_, lsze_, ट्टि, æfer
  { {0x16a90014,0x69160066,0x60080024,0x099b0012}},	//   увки_, ašeh, шнім_, _لضرب_
  { {0x92940001,0x3ced0027,0xcee80012,0xc5d50024}},	//   _фасц, tjev_, شرون_, сіль
  { {0xb9250003,0x7af5000e,0xf1b20009,0x2ca90c76}},	//   _افري, _hozt, _מסל_, ngad_
  { {0x3ced009b,0xe4a80009,0x3ec70024,0x7d1b0c77}},	//   rjev_, בֹתָ, _всеб, rius
  { {0xfe700003,0x5f450003,0xfaa50001,0xddde01bd}},	//   _قدم_, _انطل, љано, _lepš
  { {0x5dd50003,0xdb040017,0x2d910002,0xc692000b}},	//   _دقائ, stiç, jsze_, _זאב_
  { {0xf4d40012,0xb47c0024,0x91fc0035,0xe4d40012}},	//   _وتنظ, _акцi, ecās, _وتنب
  { {0xeb9901d4,0xc0520009,0xdb0b0040,0xa2d20011}},	//   _сил_, ּ֖ר_, _opgø, _भोक्
  { {0xa3c10037,0x656800b6,0x613d000e,0xda7b01d4}},	//   ंबई_, _yudh, féls, _ряд_
  { {0x7ae30119,0x6b500163,0xfce60198,0x644e0034}},	//   _innt, lägg, бово, ębie
  { {0x7cfc0108,0x99360003,0x2ca9006f,0x40960003}},	//   _péri, _دفعت, ggad_, _الظر
  { {0x6128003a,0x044a035c,0xc9530009,0xc4d20009}},	// [1620] nılm, упак_, _צמח_, הגן_
  { {0x7cfc0108,0x7c2e0052,0x2d910034,0x2ca90035}},	//   _véri, ßbri, bsze_, agad_
  { {0x8db6002d,0xa75b000b,0x68f6003a,0x28dd0011}},	//   _успі, _תדיר, _koyd, याचि
  { {0x6128003a,0xc9850003,0x94790024,0x3d140011}},	//   kılm, تشكي, _всру_, नोशे_
  { {0xc7a30538,0x2902019a,0x31b1000e,0x8fa300fa}},	//   зичк, ikka_, ház_, заче
  { {0xb033002d,0x09e60048,0x98af0035,0x9f550097}},	//   чніш, _логн, rogā_, æfðu_
  { {0xfb1b000b,0x6d440010,0x867b0009,0x21750048}},	//   _עולמ, olia, ארצו, _мутр
  { {0xbb740046,0xd197000b,0x5398010c,0xdb04004a}},	//   огиј, _לכלי_, авия_, stiä
  { {0x3006002d,0x9f63000e,0x67380027,0xc4d30009}},	//   _узаг, ívül_, povj, לגה_
  { {0x6d440c78,0x6568000e,0x78ad0c79,0x2d910034}},	//   hlia, _tudh, _scav, ysze_
  { {0x4427001a,0xf5390066,0x69da009b,0x69cf0002}},	//   ̃n_, boť_, _štej, łcen
  { {0x4a5b0009,0x613d0031,0xe10b00af,0xd46a0a36}},	//   טדיו, véls, ָּטָ, _сиде_
  { {0x2d91003e,0x34560012,0xb0aa0011,0xc3d70012}},	//   wsze_, _انشأ, _कारग, _هبوط_
  { {0x98be001e,0xa3d50011,0x29020097,0x31b10064}},	//   ētā_, हिर_, akka_, báz_
  { {0xde59002d,0x2d850061,0x95c50012,0xb05b008e}},	//   раві_, èle_, غيره, meäm
  { {0x6d4401a2,0x2d910053,0x32430012,0xbca50012}},	//   glia, rsze_, _عنيف, تمري
  { {0x36d50046,0x4918000b,0x2d91000e,0x6a670003}},	// [1630] _допр, _לקהל_, ssze_, مطال
  { {0xdb510003,0x2d910002,0x4427001a,0xbb840003}},	//   ذَا_, psze_, ăn_, سلمي
  { {0xd879000a,0x2bcf0037,0x6115002d,0x6128003a}},	//   لمات_, _तैना, оджу, zılm
  { {0xe894002d,0x628a000e,0x6128003a,0xda4b0009}},	//   заць, _lefo, yılm, אֲדָ
  { {0xcf9b0046,0x60c40051,0x69dc0c7a,0x7cfc0025}},	//   ује_, õima, _erre, _jéru
  { {0x7d0d0272,0x291d0101,0x7ac70001,0x6b50006f}},	//   lhas, siwa_, _усме, vägg
  { {0xceb4000b,0x24e90264,0xace90c7b,0x7d0d0c7c}},	//   פיק_, имки_, имка_, ohas
  { {0x612800a2,0x28d90037,0xc1050012,0x8b950bd8}},	//   tılm, _बोलि, _بوري, ороч
  { {0x5f740003,0x628a0c7d,0xe3b10003,0x13090511}},	//   _فالر, _befo, ذرة_, иний_
  { {0x6128003a,0xe2990001,0x3dd20002,0x2909008e}},	//   rılm, јан_, ływa_, _alaa_
  { {0x90c60015,0x60c6001e,0x613d000e,0x61280060}},	//   обне, tekm, vélr, sılm
  { {0xf992000b,0x6128003a,0x320b0002,0x7cfc0c7e}},	//   ורט_, pılm, ący_, _sérv
  { {0x3c47000a,0x60c6003a,0x7529000d,0x2902004a}},	//   _اضاف, rekm, mnez, rkka_
  { {0x2bcf0044,0x7ae30033,0xb4c90037,0xcc560009}},	//   _तैया, _unnt, _लघु_, _ובני_
  { {0x7bcf000d,0x96040037,0x96630232,0x6b500a50}},	//   _ascu, रनेट_, дкре, näge
  { {0x681c001e,0x68e40c7f,0xf8bf0031,0xd4670c80}},	//   tādī, _unid, nnél_, жите_
  { {0xd7ef000a,0x6d440a5f,0x2480004b,0xf8bf0031}},	// [1640] _لكي_, rlia, rbim_, inél_
  { {0x681c0333,0x98ad0029,0xcaa60003,0x26c70c81}},	//   rādī, _cieľ_, تصري, jeno_
  { {0x7c2d0065,0xf8bf000e,0x26c70c82,0xe81f0011}},	//   _þarf, knél_, deno_, _मेबा_
  { {0x7d0d0c83,0x61fe0c84,0x61ee0602,0x69160c85}},	//   chas, rypl, äbli, ašev
  { {0x7cfc000e,0xa3ce0011,0x6fca0011,0x67490097}},	//   _mért, _शनि_, िबिं, _ásjó
  { {0x7d040006,0xb7db000b,0xd00f0012,0x644b005e}},	//   lkis, יקני, خله_, ügie
  { {0xb0aa0037,0xbd670015,0xa3d20037,0x62810c86}},	//   _कांग, орые_, विक_, dblo
  { {0x61e1000f,0x3ea00c87,0x88860015,0xe628001a}},	//   _álla, şit_, _флаж, _đồ_
  { {0x2f0b00c5,0x63b60c88,0xd0070103,0x26c70121}},	//   _søge_, ntyn, _дете_, beno_
  { {0x7d0d000e,0x8c1b000b,0x39460c89,0x62810c8a}},	//   zhas, יופי, llos_, gblo
  { {0xfd4d001a,0xaadb0009,0x32db0009,0xbe160012}},	//   ghiệ, בחיר, בחינ, _بوضع
  { {0x39460052,0x6be60012,0x26f50011,0x10740024}},	//   nlos_, _وكام, ीघ्र_, млюю
  { {0xc864007c,0x645d0010,0xc1b70037,0x232a0472}},	//   дтри, žsir, _इङ्ग, _коди_
  { {0x600b0009,0xdb040025,0x8d770012,0x98af0034}},	//   בִלְ, quiè, قارا, mogą_
  { {0x98af0010,0xf27b000b,0xf8bf0066,0x39460071}},	//   logą_, _דרוש, lném_, klos_
  { {0x92a9003e,0x26c70584,0x6b4f0058,0x7d04000e}},	//   kułó, zeno_, røge, gkis
  { {0x6b4f00c5,0x7d0d00c6,0x026b0015,0xc2990021}},	// [1650] søge, rhas, ашей_, йках_
  { {0x32b80003,0x657a000e,0x61360031,0x39460c8b}},	//   قدمة_, _otth, dály, elos_
  { {0xceb2000b,0xc1b90048,0x6924001b,0x7d0d0c8c}},	//   _איי_, слех_, rđev, phas
  { {0x657a000e,0x39460c8d,0x6b500c8e,0x3cda0011}},	//   íthe, glos_, väge, _खोले_
  { {0xf8bf0066,0x66e50048,0x69d80248,0xe72e0306}},	//   jném_, зола, åver, ее_
  { {0xef18002d,0xfe710003,0xf8bf0066,0x644f0c8f}},	//   омі_, ردت_, dném_, _izci
  { {0xf8bf000e,0x753b0002,0x39460c90,0x26c70c91}},	//   tnél_, touz, blos_, reno_
  { {0x6136000e,0x6b500052,0x7d760003,0x2f0f0031}},	//   bály, räge, أمير_, _függ_
  { {0x7645004a,0xe49f001e,0x6b500245,0xf8bf0031}},	//   _lyhy, dēļā, säge, rnél_
  { {0x386900c6,0x753b0066,0x13090015,0xf8bf000e}},	//   _agar_, souz, сной_, snél_
  { {0xcb12000b,0x752f0034,0x7af80064,0x673c09df}},	//   גלי_, _ojcz, _dovt, vorj
  { {0x63b6004a,0x80b80011,0x62810c92,0x2fdf0c93}},	//   ytyn, ेजें, sblo, _krug_
  { {0x673c012e,0xb4d70037,0xe7d5002d,0x8f75002d}},	//   torj, ायी_, мірю, дусі
  { {0xa3cf0037,0x3f9e0107,0x4e1f0037,0x3ebe0028}},	//   _वैध_, čtu_, _बधाई_, ýtt_
  { {0xc27a000b,0xdb040061,0xec2d001e,0x386d0584}},	//   _פרקי, quié, šķām_, žera_
  { {0x2cad0036,0x141a0003,0xa99a000b,0x63b6004a}},	//   nged_, ميزة_, _הבקר, ttyn
  { {0x644f0002,0x7d040c94,0xf42a0029,0xd3f40024}},	// [1660] _czci, rkis, _opäť_, кiст
  { {0xe8160044,0x6fdb0009,0xa3dc0011,0x43460048}},	//   _देगा_, _פקיס, डित_, чезв
  { {0x63b60c95,0x4efb01b0,0xd6fb0009,0x7bdb008e}},	//   styn, _הליג, _הפיכ, hvuu
  { {0x2fdf00c5,0x26ca0026,0x63a900b6,0x92a90002}},	//   _brug_, lebo_, kuen, tułó
  { {0xe8160037,0x2efa0052,0x61e1000e,0x39460c96}},	//   _देखा_, _kopf_, _álln, rlos_
  { {0x69c300bd,0x2fdf0c97,0x290b001e,0x7d0b0051}},	//   _opne, _drug_, ībai_, _algs
  { {0x7bc2072d,0xf8bf0025,0x2fdf0227,0x39460420}},	//   _spou, liée_, _erug_, plos_
  { {0xd3a6002d,0xc19b000b,0x25710066,0x2cad0c98}},	//   проп, _לשלי, _dál_, gged_
  { {0x63a901a2,0x7cfc0065,0xcb670001,0x628e00b6}},	//   guen, _sérs, пање_, _kebo
  { {0xa3ab0037,0x877b0009,0xa3180024,0x957c0034}},	//   गढ़_, _לאמי, іжну_, _prąd
  { {0x64460065,0x02b7000b,0x7bdb004a,0x867b0009}},	//   _lyki, הליך_, avuu, _הרבו
  { {0x63a40c99,0x2906008e,0x68e90035,0x63a90c9a}},	//   krin, nkoa_, ķedo, buen
  { {0x63a902d1,0x5f940098,0x63a40058,0xc6e70024}},	//   cuen, ният, jrin, півп
  { {0x7cfc000e,0x628e0c9b,0xf8bf0025,0x63a40923}},	//   _térs, _nebo, diée_, drin
  { {0x3abb000b,0xb2bb000b,0x2906004a,0x3cfb0037}},	//   _המונ, _המור, kkoa_, ैसले_
  { {0xca47000a,0xf8bf0108,0x645d0097,0xb8830030}},	//   _عليه_, fiée_, ýsig, říbu
  { {0xa3d50044,0x889c0093,0x24580047,0xdb00000e}},	// [1670] हिए_, _הבחי, зать_, ermé
  { {0xd25b0015,0x2bb80012,0x26ca0c9c,0x628e0c9d}},	//   бце_, ثافة_, cebo_, _cebo
  { {0x63a40101,0x3f80000d,0x69160066,0x76ba0009}},	//   arin, ţiul_, pšet, _ומתפ
  { {0xf42a0029,0x5fb10011,0x25e00011,0xf8bf0031}},	//   _späť_, _जमाल, किनी_, dnék_
  { {0xf8bf0061,0x98f40003,0xd7f8004c,0x0efa0011}},	//   ciée_, عثما, зуј_, ्सूस_
  { {0x8d750003,0xd00c000b,0x85790015,0x628e01e0}},	//   وابا, מּוֹ, осит_, _gebo
  { {0x69da012e,0x752d00c1,0x20020002,0x30a70063}},	//   _štev, onaz, zyki_, _нрав
  { {0xb4d70037,0x6b4b0052,0x2fdf0052,0xa3d20011}},	//   ाये_, zügl, _trug_, विच_
  { {0x2be00037,0x2cad0979,0x2f0f0052,0x69dc0260}},	//   निया, rged_, _züge_, æren
  { {0x68fb00bd,0x1a050014,0x78bd0028,0xdddc0010}},	//   _houd, дпом, efsv, varž
  { {0x60d60c9e,0x67230c9f,0x6ce70024,0x68fb0ca0}},	//   _paym, minj, _ніде, _koud
  { {0x27e0007d,0x20020002,0x67230ca1,0x68fb008e}},	//   _prin_, tyki_, linj, _joud
  { {0xcaf50012,0x88ba0009,0x68fb0ca2,0xe29907eb}},	//   _يستب, חזרי, _moud, _дал_
  { {0xdb230006,0x20020002,0x672308e2,0x9a690012}},	//   äräi, ryki_, ninj, _بمثل_
  { {0xa3d50037,0x6e430001,0x68e90029,0xdd1c00d9}},	//   हिक_, верз, _oned, _vážn
  { {0x27e000c5,0x752d00c1,0x68fb004a,0x7bc3000d}},	//   _trin_, gnaz, _noud, ănun
  { {0xdb000028,0xe3b9000e,0x59d50037,0xc953000b}},	// [1680] lumá, ntű_, धिकर, _במה_
  { {0xbf660012,0x67560012,0xf8bf0025,0x89790009}},	//   _تدعو, _تخبر, riée_, ַרְצ
  { {0x3ebe0051,0x67230604,0x63a40ca3,0x2906008e}},	//   õttu_, dinj, srin, tkoa_
  { {0xc5f3000b,0x8fa60014,0x58ba0003,0x66030002}},	//   _סדר_, даде, تائج_, dynk
  { {0xc0570024,0x7b090031,0x2906008e,0x628e0ca4}},	//   міш_, ástó, rkoa_, _tebo
  { {0x8f89000b,0xf8bf000e,0xdddc0002,0x0efa0011}},	//   פְנֵ, tnék_, karż, ्सेस_
  { {0xd5af0014,0x82d70009,0x66e3004c,0xdee3004c}},	//   ъс_, _קולג_, тоја, тоји
  { {0x88c60003,0x25a00ba1,0x68fb0ca5,0xed57004c}},	//   _تتسل, čil_, _goud, мој_
  { {0x644e0002,0x6723001b,0xe04308e0,0x7afc0ca6}},	//   ębio, binj, _анти, _kort
  { {0xadba000a,0x68fb0070,0x6ffb0009,0xd7fb0009}},	//   _وهذا_, _zoud, _והמפ, _והמל
  { {0xf2d30093,0x36060003,0x2d9e0066,0x6d490ca7}},	//   דעת_, _تواف, átel_, blea
  { {0xe5060003,0xcb6a0345,0xd1310012,0xc5f30009}},	//   _تبطي, _даде_, امح_, _שדף_
  { {0xbd5b0009,0xdfc60012,0xd467004c,0x6d400ca8}},	//   _וכאש, دي_, _жице_, moma
  { {0x7afc0ca9,0xdc020030,0xa6f80009,0x33170012}},	//   _nort, nčíc, הִֽי, _يزود_
  { {0xa3d60037,0xccfb0001,0x64550002,0x828b0009}},	//   ाटक_, оћа_, ęzie, _וְחֶ
  { {0x57b5002d,0x657a000e,0x6b50006f,0x50670294}},	//   _збит, ítha, väga, _отпа
  { {0xdb0d0149,0x752d00c1,0x3b5507e8,0xf66b0012}},	// [1690] ntaç, rnaz, екар, _وحده_
  { {0x68e9006f,0x68fb0caa,0x93b70009,0xdb0d0018}},	//   _sned, _soud, ולמו_, itaç
  { {0xda0e0037,0x68fb0cab,0x67230604,0xa7380012}},	//   ानित_, _poud, vinj, _تثير_
  { {0x08d40024,0x97d90024,0xe7f30011,0x2d830227}},	//   кція, зьку_, _आपदा_, mpje_
  { {0x26170037,0x547a000b,0x68fb0061,0x28c10037}},	//   _भेजी_, _מטרו, _voud, ष्यि
  { {0x63ad00b6,0xcaa70003,0xe7330003,0x6b500248}},	//   muan, _تصحي, خصص_, lägn
  { {0xe81f0044,0x672306b6,0x20090cac,0xbef80009}},	//   _मेरा_, rinj, šai_, וצגו_
  { {0x6128003a,0x67d50188,0xdfd5003c,0xc5370009}},	//   nılt, _побу, _побы, וָ֖ה_
  { {0x6d5b0c74,0x386d0cad,0x6d490cae,0x63ad0caf}},	//   rmua, _iger_, rlea, nuan
  { {0xa3e00044,0xfaf1000a,0xf772000b,0xfbd2000b}},	//   थित_, اثة_, _עקב_, נתי_
  { {0x3f990028,0xe126024d,0x6d490cb0,0x76480073}},	//   essu_, емни, plea, _gydy
  { {0xdb090149,0x6d4004da,0x63ad0cb1,0x6cd80024}},	//   nteú, coma, kuan, _офіс_
  { {0x13f40014,0x63ad0cb2,0x6d5a01a0,0x6fe20011}},	//   _изця, juan, ïtam, पियं
  { {0x63ad00b6,0x2d9e001b,0x9ad50012,0x98af0034}},	//   duan, štem_, _ستتض, rogę_
  { {0x2f140163,0x63bb0cb3,0x2d8c0061,0x7d090010}},	//   _lägg_, ltun, ède_, okes
  { {0x1da70011,0x621a0009,0xbe630012,0x7c240412}},	//   _गिनत, _מוצק, اهِي, _žiri
  { {0x63bb0cb4,0xe81f0011,0x61e10031,0x7afc0cb5}},	// [16a0] ntun, _मेला_, _állj, _port
  { {0xdbc60005,0x7fd7000b,0x63bb0cb6,0x77bb0009}},	//   _tööa, _טופס_, itun, _צמיח
  { {0xd8da000b,0x7afc03c0,0xceb70009,0xfd4a0048}},	//   ּקְר, _vort, _אפיק_, _нзок_
  { {0x6601004a,0xc329000b,0xe5f70009,0xf1b20009}},	//   älke, זו_, _נזכר_, רסא_
  { {0xc6fa000b,0x43750001,0x6d460cb7,0xd12f0012}},	//   ּלֶך, _ауст, _ikka, حمن_
  { {0x98c5001e,0xcf93000b,0x479b0009,0xd5b00012}},	//   ītās_, נטו_, לינס, لفت_
  { {0x27420066,0x26da009b,0x2d9a0cb8,0xceb30009}},	//   méně_, _mapo_, épe_, איו_
  { {0x91bb000b,0xc5f3000b,0x6d40004a,0x63bb0052}},	//   _ממלי, רדה_, uoma, ftun
  { {0xd4e30047,0x5ce30015,0xdb040061,0xa1570009}},	//   ующи, ующа, triè, _טבלה_
  { {0x2d6e0013,0x6b4f00c5,0x0bb7000b,0xdb0d0017}},	//   _před_, søgn, עלים_, rtaç
  { {0x6d460065,0xdb040061,0xdb0d0017,0xddc80034}},	//   _okka, rriè, staç, _wzdł
  { {0x69b10044,0xcdf70009,0x8d770009,0xdb0d0018}},	//   _अमरी, _רמאי_, _נגדו_, ptaç
  { {0xa2c10037,0xf8bf01cf,0x389b0009,0xe5050012}},	//   र्ड्, rfé_, היכנ, _جبلي
  { {0x5453007c,0x26da00c1,0x32050066,0x39420051}},	//   _світ, _capo_, byly_, aoks_
  { {0x7c870001,0x692b0066,0x39420cb9,0x6b84005e}},	//   еузе, třed, boks_, epig
  { {0x290b0039,0xa4d4002d,0x04c90012,0x799a0034}},	//   ības_, лосі, بوري_, mstw
  { {0x8aa700be,0x8d5b0009,0x113c0009,0x94740012}},	// [16b0] еред, לכלי, _מתהל, ادفا
  { {0x63ad0cba,0xd25b004c,0x5c370009,0x2fc9020d}},	//   ruan, пце_, תרמן_, _ipag_
  { {0xf9930003,0x692b0066,0x63bb000e,0x39780024}},	//   ابط_, před, ztun, есію_
  { {0xd23b000b,0x7d0f000e,0x60dd0cbb,0xc60d0011}},	//   הגבל, _ulcs, ndsm, सनीय_
  { {0xb8c90044,0x69d5003e,0x389c000b,0x2489009b}},	//   _गए_, _wsze, ליאנ, mbam_
  { {0x6d4d03d5,0x6da50662,0x99850012,0xc0540009}},	//   llaa, вика, _للسو, נזס_
  { {0xda090003,0x7d0900ff,0x6d460028,0xdd910012}},	//   _غيره_, tkes, _ykka, جوع_
  { {0x386d0058,0x6d4d006e,0x63bb0cbc,0x60dd0040}},	//   _uger_, nlaa, ttun, jdsm
  { {0x7d090cbd,0xdb00019a,0x7d03000d,0xdcfc001e}},	//   rkes, kumä, _însu, nprā
  { {0xf8aa0044,0x613d01c4,0x2a030029,0x49b90012}},	//   कल्प, mély, ačať_, واجد_
  { {0x6d4d03fb,0x2fc9002c,0xc27a000b,0x799a0227}},	//   klaa, _apag_, ורתי, gstw
  { {0x6d5a0010,0x60db0cbe,0xbcfb0018,0x9c870012}},	//   įtak, _jaum, _fiéi, _أشاه
  { {0x9d1a000b,0x644b0051,0x26da0017,0x7d06004a}},	//   _קונט, ügil, _papo_, ökse
  { {0xdb040108,0xe1f10003,0x656b0cbf,0x4ed50686}},	//   prié, _نسب_, _high, люст
  { {0xceb2015a,0x7e230001,0xcb12000b,0xc1060012}},	//   יים_, адрж, _דלג_, _لوثي
  { {0x657c000e,0xc172000b,0x68ed0032,0x61280060}},	//   _érhe, _דחה_, _gnad, rıls
  { {0x656b0036,0x26da0010,0x036a0048,0xf8bf0031}},	// [16c0] _migh, _tapo_, диак_, tnév_
  { {0x656b0cc0,0x613d000e,0x29000051,0x7d1e000e}},	//   _ligh, dély, _hoia_, épsz
  { {0x63a9008b,0x644b007a,0xdb1d0058,0x60db0cc1}},	//   hren, _lygi, _opsæ, _baum
  { {0xdcfc001e,0x6b9b0051,0xdcfe001e,0x656b0cc2}},	//   bprā, ksug, īvīb, _nigh
  { {0xab660002,0xa0670001,0xdefa003c,0x6843003c}},	//   _pożą, ваца_, дый_, анца
  { {0xa3c10044,0x501b000b,0xde58002d,0x799a0002}},	//   ूबर_, וונו, налі_, ystw
  { {0xdb040164,0x5db30012,0x63a90cc3,0x2be00011}},	//   stió, لإير, eren, निवा
  { {0x63a90cc4,0x6d590034,0x7d03004b,0xd37a0365}},	//   fren, _chwa, _înst, мчо_
  { {0x63a90cc5,0x50460695,0x799a0034,0xd8770012}},	//   gren, _реаб, wstw, _شملت_
  { {0x86ea0003,0x656b002a,0x68ed0066,0x51f8002d}},	//   _تعرف_, _eigh, _snad, еною_
  { {0x656b002a,0x63a901b7,0x7c2d0097,0x87170009}},	//   _figh, aren, _þarn, _שקבע_
  { {0x94260047,0xe8e0001a,0x799a0120,0x6e170012}},	//   _имее, _trời_, rstw, _جيمس_
  { {0x692b0013,0xf8bf0164,0xc7f80024,0xdb0003bd}},	//   třeb, bién_, вняє_, tumä
  { {0x9f600028,0xf7730009,0x19ba0012,0xf8bf01e3}},	//   ærðu_, יקש_, _قطعة_, cién_
  { {0xf628002d,0x7e28002d,0xdb00006f,0xce940048}},	//   віти_, віта_, rumä, расъ
  { {0x1bd50048,0xfe370009,0x2d580198,0x69d80060}},	//   лобя, דרלי_, вись_, _isve
  { {0x5455059a,0xfbd00003,0x6d4d0cc6,0x24890cc7}},	// [16d0] уват, يتك_, rlaa, rbam_
  { {0xf1b60037,0xe3b00003,0x6d4d0643,0x60080009}},	//   _अमान, ترف_, slaa, _יִתְ
  { {0x60db0101,0x2578000e,0x6d4d0114,0x41740012}},	//   _paum, _nél_, plaa, لانس
  { {0x30150447,0xf9900012,0xe0df00b8,0xf8bf0025}},	//   лдер, تبك_, ndò_, mnés_
  { {0xe8d9008a,0x251a000b,0x443f001a,0xfd56000b}},	//   _chỉ_, _נושא, _âu_, _תשרי_
  { {0x69ca0052,0x656b0cc8,0x8c1a0009,0xa3e00011}},	//   _opfe, _sigh, _טורי, थिर_
  { {0x2578000f,0xddda000e,0xf8bf0061,0x7d0d0a60}},	//   _cél_, _betű, nnés_, okas
  { {0x3ea9007d,0x25780cc9,0x76580009,0xd6580009}},	//   şat_, _dél_, כבוד_, כיות_
  { {0xdc3100a2,0xfc050015,0xa7740024,0x69ca0032}},	//   _düğm, уппо, _влуч, _apfe
  { {0xe1f90047,0x2578000e,0x63a90cca,0x692b0030}},	//   его_, _fél_, rren, yřec
  { {0x9afa000b,0xa2ca0037,0x656b0ccb,0xaaab0011}},	//   תפתח, _सॉफ्, _tigh, _चयनक
  { {0xc2360009,0x3a360009,0xdb1b0025,0xcd2b0012}},	//   טרתו_, טרתם_, itué, _غسان_
  { {0x60d6000b,0xc2c50012,0x2900004b,0x6f010ccc}},	//   נושא_, _ميشي, _voia_, _kolc
  { {0x6295022d,0xa8560009,0x90560009,0xe4500012}},	//   _nezo, טירה_, טברו_, _بضم_
  { {0x7d0d0ccd,0xf8bf0061,0xdd1d0066,0xad5a0055}},	//   fkas, gnés_, lářs, ерах_
  { {0x7d0d0a60,0xa2c10011,0xd24e0012,0x98a20034}},	//   gkas, र्स्, _عني_, ynkę_
  { {0x62950369,0x38bd000e,0xd117000b,0x6eac0011}},	// [16e0] _bezo, záró_, _תקפה_, _जयपु
  { {0x7d0d0cce,0x8a3a0015,0xaf0a0003,0x070a0012}},	//   akas, няет_, _أقدم_, _أيدي_
  { {0xd24f000a,0x88860014,0xdebb0009,0xb05b0032}},	//   كنك_, глеж, _אמיל, nfän
  { {0x7aeb001e,0xc0960012,0xcb090009,0xa3e30011}},	//   ēgta, اجات, הל_, कटाप_
  { {0xa3d2015f,0xdd1d0066,0x316d0164,0x889b0009}},	//   _हैं_, jářs, _diez_, תבני
  { {0xa8570093,0x05b40003,0xdd1d0066,0x629504a3}},	//   ניסה_, لمتح, dářs, _gezo
  { {0x645d014d,0xceb30093,0xdb1b0061,0x6b820027}},	//   ýsin, ציה_, ctué, _stog
  { {0xd1320012,0x5c740306,0x25780097,0x386d001b}},	//   _امر_, шлит, _vél_, žeri_
  { {0x28dd0037,0xa2c10011,0x46b60012,0xdb040018}},	//   _नोटि, र्व्, _محاس, guiç
  { {0xa3d20011,0x8bd70009,0x2d96004c,0x03d70009}},	//   _हैः_, נויו_, _брдс, נוים_
  { {0xaac60044,0x4ac60037,0xd2500003,0x22f70009}},	//   र्यक, र्यव, تند_, אזין_
  { {0xdb040017,0x644b0051,0xf6530009,0x63e60012}},	//   buiç, ügik, _הצע_, _مستك
  { {0xe8d90020,0xa3b30044,0x6f01003a,0x6d440073}},	//   _giờ_, जूद_, _yolc, čiad
  { {0x8c1b000b,0x3dd20002,0x74330024,0x3dda0032}},	//   _אודי, ływu_, _уніф, _bspw_
  { {0x7d020176,0x627b000b,0x05d50011,0xa3dc0011}},	//   _koos, _אנונ, _डैशब, डिक_
  { {0x9983000a,0xf1a90044,0x23e00037,0xa77500b3}},	//   _اليو, _कितन, निंद, _клич
  { {0x89340003,0x7d0d0ccf,0x7b770012,0x2aab004c}},	// [16f0] _دعوا, rkas, اطرا, етео_
  { {0x212b008b,0x6eb20044,0x26de0cd0,0x7d0d0cd1}},	//   lich_, _जाएँ, _nato_, skas
  { {0xe8d90081,0x212b0034,0x7d0d0cd2,0x629509ef}},	//   _nhị_, oich_, pkas, _vezo
  { {0x6f01008b,0x3264059a,0xd0110003,0xc5fa0009}},	//   _solc, стув, يلا_, _ספרט
  { {0xc49a0009,0xdc9a0009,0x6b4b0032,0x1869004c}},	//   _בשרת, _שישל, fügt, њали_
  { {0xaec4007c,0x212b002a,0x945d0002,0x7ceb006f}},	//   йбіл, hich_, zeńs, _förä
  { {0x212b003e,0x41e4002d,0xe8d9001a,0x9f440066}},	//   kich_, _літа, _chị_, ímé_
  { {0xdb040017,0x212b0107,0x63f50003,0x63ad0cd3}},	//   tuiç, jich_, لأخر, oran
  { {0x9ed90098,0x26de0017,0x7529001e,0x92f50024}},	//   _имат_, _fato_, riez, ачні
  { {0x0325002d,0x13090015,0xdb040017,0x63ad0cd4}},	//   рдон, тной_, ruiç, iran
  { {0xcb14000b,0x75290cd5,0xc1060012,0x63ad0cd6}},	//   מלץ_, piez, لودي, hran
  { {0x656f032b,0x95670098,0x3e55001a,0x61e1000e}},	//   _nich, _създ, _ít_, _állu
  { {0x6446005e,0x4ac60011,0x248d0018,0x6d4b0035}},	//   ükit, र्डव, mbem_, _ikga
  { {0xb05b0cd7,0x8c1a0009,0x98630012,0x6b890cd8}},	//   pfän, _בוני, زُّه, mpeg
  { {0x98a2001e,0x27e90cd9,0xf4960055,0xad660012}},	//   aikā_, _eran_, ираю, لاره
  { {0x7de0000f,0x212b0026,0x2a3a000b,0x656f0002}},	//   lásá, cich_, _בעצמ, _cich
  { {0x8b260015,0x03260479,0xb6020030,0xb05b0032}},	// [1700] адае, адан, _řádn, nfäl
  { {0x305b000b,0x9f9b000b,0x4f9b000b,0x905b0009}},	//   _בדפד, _שסיפ, _שביצ, _בכפת
  { {0x656f0cda,0xbcfb0025,0x69c10cdb,0xa2bd0011}},	//   _fich, _piét, ntle, _शान्
  { {0x2ba60044,0xe1650003,0x3fe60001,0xb05b006f}},	//   _खिला, مدني, ижев, kfäl
  { {0x69c10051,0xa81a0003,0xb87b01e3,0x18360012}},	//   htle, ختار_, ndía, جراح
  { {0xa3cf0037,0x656f0070,0xfda60001,0xa857000b}},	//   _वैट_, _zich, ајим, בינה_
  { {0x7de0000f,0x96f70012,0x692b0030,0x60c4005e}},	//   dásá, شعور_, dřen, õims
  { {0xd94305fb,0x5bb8010c,0x44f4072b,0x1da70011}},	//   _деси, глия_, спис, _गिरत
  { {0x69c1003e,0xbcfb000e,0x26de0cdc,0xaac60011}},	//   etle, _kiér, _tato_, र्थक
  { {0xe8d90020,0x5b140075,0xada6002d,0x9b430003}},	//   _thị_, смот, _важл, ينيو
  { {0x29040065,0xd25a0014,0xbcfb0bb6,0x212b0cdd}},	//   _koma_, ъци_, _miér, tich_
  { {0x64460051,0x2d570060,0xfc660048,0xddd40034}},	//   ükis, eçen_, _кълн, łaśn
  { {0xa3dc0037,0x2f14006f,0x656f0cde,0x212b0cdf}},	//   डिओ_, _säga_, _rich, rich_
  { {0x656f008b,0x69dc009b,0x69ce0c62,0x8cc90011}},	//   _sich, _osre, _opbe, ह्नो
  { {0x2d8500bd,0x35e4002d,0x257c0066,0x7afc0028}},	//   ële_, оцтв, _cíl_, örtu
  { {0x2f140005,0xf993000b,0x79690002,0x5c7505f0}},	//   _väga_, _ורק_, _oświ, слат
  { {0xa3dc0044,0xd3710003,0xdc8b0009,0x113c0009}},	// [1710] डिट_, سها_, דְבָ, _שתחל
  { {0xf1da0044,0x656f008b,0xb9da0011,0x8c1b0009}},	//   _बनान, _wich, _बनाऐ, דומי
  { {0x644f0002,0xc692000b,0xf8750003,0x3f8b009b}},	//   _wyci, _מאי_, مهاج, lpcu_
  { {0x7de0000f,0xc879003a,0x69130060,0xf1a90011}},	//   zásá, _başa_, _eçen, _किसन
  { {0x27e90164,0x68e0002c,0x80a80024,0x6b5d0025}},	//   ían_, _damd, рвів_, lège
  { {0x2d950046,0x629804c7,0xc724002d,0x7bdd0ce0}},	//   брис, _nevo, одій, _issu
  { {0xe7f3015f,0x692b0013,0x63a20106,0x7de0000e}},	//   _आपका_, vřen, _avon, vásá
  { {0xce38000b,0xdb090051,0x8638000b,0x5bc50003}},	//   יאות_, steü, ירוב_, مقبل
  { {0x7de0000f,0x692b0066,0xa3d20037,0x62980832}},	//   tásá, třen, हौल_, _bevo
  { {0xf770000a,0xe9d9027f,0xb05b08ec,0xa2ca0011}},	//   _قال_, гко_, rfäl, स्प्
  { {0x7c3b0065,0xa2aa0037,0x7de0000e,0x6e450003}},	//   _þurf, _फ़ार्, rásá, _انضم
  { {0x89360003,0xcdf40003,0x79690002,0x7de0000e}},	//   إعدا, _بأكث, _yświ, sásá
  { {0x4385000a,0xbb850003,0x63850001,0xcc760009}},	//   _التق, _التي, _угла, _הגנת_
  { {0x629800bd,0xc6920009,0xe2990048,0x68e20764}},	//   _gevo, ּאן_, _сак_, zdod
  { {0xba9a0093,0x321e0002,0x7d1b0051,0x057a0003}},	//   _עסקי, czty_, ohus, امرة_
  { {0x31a300a2,0x61430232,0x6564020d,0x82340012}},	//   mız_, _неща, umih, _برها
  { {0xe2920003,0xe45a0ce1,0xed570367,0x29040ce2}},	// [1720] كذا_, ужа_, сот_, _roma_
  { {0xda660003,0x57fb000b,0x7ed5002d,0x62810ce3}},	//   ماضي, _עליו, _діюч, nclo
  { {0x31a300a1,0xd36f0003,0xe0df0054,0x16770009}},	//   nız_, رهم_, clòs_, _לגיל_
  { {0xc8b60003,0xd83f009b,0x752d0ce4,0xa9670048}},	//   إصاب, šček_, ciaz, биха_
  { {0x765a0034,0x68e20035,0x26130081,0x90970024}},	//   _szty, rdod, ẹo_, світ_
  { {0xd0070046,0x201a0002,0x47330024,0x07080012}},	//   сеље_, ąpi_, пніс, شيعي_
  { {0x76a9002d,0x63a20028,0x69dc0027,0x6d410ce5}},	//   ртів_, _svon, _usre, élag
  { {0xc5f3000b,0x25610028,0x629e0ce6,0x7644003a}},	//   לדו_, hólf_, lapo, şiyo
  { {0x2613001a,0x7d060010,0x97bd0024,0x1eaa0012}},	//   ạo_, _moks, _архi, _ماضي_
  { {0x5a340014,0x44200ce7,0xbea30959,0x8c1b0009}},	//   жнот, izi_, _наук, טופי
  { {0x60f900bc,0x14ca0047,0x9cca0047,0x8afb01b0}},	//   ання_, _были_, _была_, אליז
  { {0x54e50012,0xe8d90081,0xbce50012,0x32570009}},	//   _وسنق, _thọ_, _وأنو, מסים_
  { {0x395f0039,0x6ebf0037,0x321e0002,0x4420000e}},	//   ķus_, ल्कु, szty_, jzi_
  { {0x3bbb000b,0x98bd0002,0x44200ce8,0x421a0012}},	//   _עמוד, mową_, dzi_, _مزعج_
  { {0x91860003,0x98bd0002,0x7d060ce9,0x7588003c}},	//   _اجتم, lową_, _boks, йств_
  { {0xf237000b,0x5d55002d,0xa3e50011,0xaac60011}},	//   _לרוץ_, ікат, पटल_, र्सक
  { {0x93970003,0xba99002d,0x2d58027f,0x1b7b0012}},	// [1730] إجرا, иває_, сить_, اصرة_
  { {0x394b0054,0x692b0066,0x9f530034,0x20d30081}},	//   locs_, zřel, ądów_, _ải_
  { {0xe5c700db,0x7bc401a0,0xdb0d0097,0x555905d8}},	//   _успо, atiu, ptaþ, _ваня_
  { {0x7644003a,0x98bd0002,0x905504ad,0xe1f00012}},	//   ğiyl, kową_, овец, عسل_
  { {0x493c000b,0x7bc40cea,0x692b0030,0x98bd0034}},	//   נגדו, ctiu, vřel, jową_
  { {0xdb16001a,0x31a3003a,0x98bd0002,0xa8580009}},	//   huyê, yız_, dową_, ציגה_
  { {0xe8d90020,0x395f002a,0x7d06003a,0x4519022a}},	//   _nhỏ_, _thus_, _yoks, иция_
  { {0x2a7b0010,0xdb850048,0xddc80034,0x394b01a0}},	//   šybą_, огии, _bydł, jocs_
  { {0xfc31000a,0x02c60037,0x6b8d0070,0x4ac60037}},	//   بحث_, र्वभ, npag, र्वव
  { {0xf1c30066,0xe2990001,0x693c00f1,0x69c504a3}},	//   _naší_, шао_, nčen, othe
  { {0x3f8900ec,0x442001a2,0x69c50ceb,0x3e350012}},	//   _atau_, zzi_, nthe, _بفار
  { {0xe56e007c,0xc6890093,0x31a300a2,0x6b8d0070}},	//   _із_, _יא_, rız_, kpag
  { {0x31a3003a,0xb05b0032,0x98bd0034,0x69c5016a}},	//   sız_, nfäh, cową_, hthe
  { {0x60cd0051,0x7d06000e,0x9f440018,0x6b8d0227}},	//   _ebam, _soks, _irmã_, dpag
  { {0x4da90009,0x75d60012,0x6b8d0cec,0xec9a004c}},	//   יֹּ֣, غيرا, epag, итај_
  { {0x7ae301ad,0x44200054,0x92580012,0xa01b0245}},	//   _hant, tzi_, _اشهر_, rbör
  { {0x629e0101,0x44260020,0x73060014,0x7d060623}},	// [1740] tapo, ào_, опаз, _voks
  { {0x78a90ced,0x7ae30cee,0x44200cef,0x29020604}},	//   _adev, _jant, rzi_, ljka_
  { {0x629e004a,0x4420000e,0x75460014,0x6b8d002c}},	//   rapo, szi_, _мноз, apag
  { {0x4fea0014,0xf4b60003,0x290204d2,0x6b8d0cf0}},	//   имен_, _بإدخ, njka_, bpag
  { {0x7e9a000a,0x2ca00051,0xdb16004a,0x493b0009}},	//   لنشر_, maid_, ttyä, סגנו
  { {0xf4130093,0x291d00b6,0x7ae30cf1,0xe7b20011}},	//   _חפש_, ahwa_, _nant, _जिनप
  { {0x629c0039,0xd5b00003,0x29190071,0x27ed0cf2}},	//   _iero, رفة_, ūrai_, _eren_
  { {0x7ae300bd,0x4ac60037,0x98bd0002,0x1d070001}},	//   _aant, र्रव, tową_, жећи_
  { {0xa2ca0037,0x7ae30807,0xa2c10011,0xdddc001b}},	//   स्थ्, _bant, र्क्, jbrž
  { {0xbb470012,0x98bd0034,0xddc9004b,0x26d80cf3}},	//   يلين_, rową_, înţe, jero_
  { {0xdcfc0010,0x98bd0002,0x2ca00051,0xc27b0009}},	//   sprę, sową_, kaid_, יריי
  { {0x2ca00cf4,0xa2ca0037,0x7c060012,0x2d8e0032}},	//   jaid_, स्त्, _وبشك, mpfe_
  { {0xdb040017,0x5f940014,0xb4b60037,0x64360012}},	//   criç, мият, जली_, _براء
  { {0xa3d70037,0xc7b30009,0x7ae30cf5,0x629c0cf6}},	//   ाबर_, ובש_, _gant, _nero
  { {0xf1c30013,0xfb1b0093,0xc1c90037,0xd49b0c1e}},	//   _vaší_, _דוגמ, _रहेग, ира_
  { {0x692b0066,0x68e4001e,0x98a20010,0x6b4f0058}},	//   zřej, _gaid, tiką_, søgt
  { {0x2bb80003,0x26d800c1,0x0ca80014,0xfc300012}},	// [1750] قالة_, bero_, ютри_, نحك_
  { {0x660e0066,0xb87b0066,0x2fc60058,0x693c0584}},	//   ínká, zdíl, dtog_, učen
  { {0x6b8d0070,0x63a40cf7,0xa2bd0011,0xe7e30011}},	//   spag, asin, _शास्, खिका_
  { {0x6f1a000d,0x69c50cf8,0x644b0051,0x27ed0054}},	//   _altc, rthe, ügis, _pren_
  { {0x6cfa015a,0xb4fa000b,0xe4fa000b,0xdb090017}},	//   _הפרס, _הפרי, _הפרש, queç
  { {0x27e40097,0xb05b0032,0x6d4d008e,0xd7ee0012}},	//   æmni_, rfäh, loaa, اكو_
  { {0xb05b0052,0x6d440cf9,0xf5ab0009,0x20d70012}},	//   sfäh, čian, ׁבַּ, _وترج
  { {0xd4d9007c,0xa63c0009,0xdb040018,0xbe3c0009}},	//   ські_, יגור, triç, יעות
  { {0x27ed0070,0x692b0066,0x26c10164,0xe3b10003}},	//   _uren_, přej, _ocho_, ررة_
  { {0x68e40289,0xb436000b,0x441c0009,0xb87b0030}},	//   _said, לָיו_, יוחס, sdíl
  { {0xfc460065,0x63a4003a,0xdb0d0164,0xc0490009}},	//   _þíns_, zsin, ntañ, _עז_
  { {0xef190002,0x7ae30a5f,0x26c10017,0x2ee50cfa}},	//   _duże_, _want, _acho_, _half_
  { {0x2ca00005,0x645d0051,0xd47a0009,0x98560024}},	//   vaid_, üsid, _האנל, ятош
  { {0x65690052,0xdb1c000e,0x9af50012,0x69240031}},	//   lmeh, özün, _ركعت, tőes
  { {0x8afa000b,0xdb0d0061,0x2ca0000e,0x6b4f0058}},	//   _להסי, traî, taid_, søgs
  { {0x629c0cfb,0xdb000002,0x26d80b69,0xaa560012}},	//   _sero, bumó, sero_, _عليا_
  { {0xe1650003,0x1d070294,0x2ca0021b,0x629c0cfc}},	// [1760] _تدوي, чети_, raid_, _pero
  { {0x63a400a1,0x6b500248,0x98bd0034,0xe29a0cfd}},	//   rsin, vägs, mowę_, саж_
  { {0x1e97000b,0x8e7b000b,0xf67b000b,0x63a40cfe}},	//   _מכיל_, _לניה, _לאימ, ssin
  { {0xd5fb0009,0xfd120012,0xf79a0012,0xa9670048}},	//   _הפטר, _أجد_, منصب_, пиха_
  { {0xd5b10020,0x6f08003e,0x4abd0037,0x28c10037}},	//   ớc_, _podc, ्भाव, ष्टि
  { {0xdbc70051,0x7d040033,0xb8e30011,0x6b500032}},	//   tööt, ljis, _एफ़_, rägs
  { {0x39810149,0xdb04006f,0xc1da0011,0x2fc6001b}},	//   _nós_, rriä, _बनेग, stog_
  { {0x718b000b,0xdce40027,0x7d160cff,0xc0e304ac}},	//   _לְמַ, kmič, nkys, _поск
  { {0xdb0d0028,0xd9430103,0x9cd70009,0x61430048}},	//   otað, _чети, לוקה_, _чета
  { {0xfbcf0003,0xef170015,0xdb0d0028,0x65690029}},	//   اتي_, _ему_, ntað, ameh
  { {0x656200b6,0x98a20911,0x75960012,0xa2c10011}},	//   _thoh, likę_, _رجاء, र्ट्
  { {0x2d57003a,0x3a37000b,0x7d7b0009,0x7aeb0035}},	//   rçek_, לרים_, _הנאו, ēgti
  { {0x50640046,0xe9070009,0xdb0d0097,0xdb1b0018}},	//   етра, הֶם֙_, ktað, stuá
  { {0x05770012,0x8d770012,0x941e0060,0x7c24017b}},	//   كارد, كارا, ığıy, dzir
  { {0x9757000b,0x66140066,0x9f440030,0xdb090248}},	//   פילו_, _čeká, ímá_, tteö
  { {0x2a3b000b,0x693c0027,0x91bb000b,0x9a3b000b}},	//   _לעומ, učel, _המהי, _לתוק
  { {0x7f840003,0x98650012,0xdb0d0018,0x50fa0009}},	// [1770] _كلين, _تُظه, nuaç, _וִיד
  { {0x501c000b,0xc3540001,0xf8380009,0x7d040d00}},	//   _לוחו, екуј, _מנחת_, ajis
  { {0xdb040061,0x69c80d01,0x99d90012,0xceb20009}},	//   isiè, ntde, تواء_, _ביי_
  { {0x98a20002,0xf8bf0061,0x31140024,0x62850d02}},	//   fikę_, ngé_, нфіс, scho
  { {0xdb0d0164,0xa8780003,0xe7a8002d,0xe72e035c}},	//   stañ, أحمر_, звіл_, ве_
  { {0x8ae4007c,0x3ce90051,0x7528001e,0x69c8013f}},	//   _післ, ldav_, īdze, ktde
  { {0xf2d2000b,0x78ad0d03,0xcb120009,0x45d2004c}},	//   _שעל_, _odav, _ילך_, војс
  { {0x7ae7000e,0xfdf8000b,0x3ce90051,0x838901b6}},	//   _hajt, לצות_, ndav_, обив_
  { {0x1c45002d,0xfc310003,0x656900a8,0x92b50012}},	//   ьним, ضحة_, rmeh, وحدا
  { {0xc9a90015,0x39810017,0xab290024,0x89a907e6}},	//   овое_, _pós_, іона_, оков_
  { {0x46150003,0xb2090014,0xd9460210,0xcb120009}},	//   _توار, ценз_, дени, דלי_
  { {0xcea90093,0x39810d04,0x07a60048,0xf8bf0d05}},	//   _כי_, _vós_, мамн, diés_
  { {0xbcfb0061,0x200b01a0,0xd9aa0011,0xdb0d0018}},	//   _phén, _àcid_, _चट्ट, cuaç
  { {0xab64002d,0xf8bf0061,0x4b7a0009,0x7ae70d06}},	//   _звіл, fiés_, _ואסו, _najt
  { {0xbb520003,0x28c60037,0xc5d50024,0xf8bf0025}},	//   _جنوب, _वापि, ніть, giés_
  { {0x2cbf0005,0xa99a0009,0x2d530018,0x7d0b0031}},	//   ngud_, _ובקר, mães_, _jogs
  { {0x3ce60026,0x7bc90d07,0x4e7a0012,0x5f2a003c}},	// [1780] ľov_, nteu, _وحدد_, _моим_
  { {0xe8d9008a,0xa3cf0044,0x446302ac,0xe7b70009}},	//   _thể_, _शहर_, твув, _קהיר_
  { {0xf8bf0d08,0xa50a0014,0x4efb01b0,0xaacf0011}},	//   ciés_, _дена_, _והיו, त्यक
  { {0xdb0d0065,0xda650003,0x693c0029,0x44240034}},	//   stað, رالي, mček, yzm_
  { {0x31da0037,0x97da0003,0x98a30406,0x10a30829}},	//   _बन्ध, تظار_, тиче, тичн
  { {0x6d440010,0x66e30001,0x758a00fa,0xdee3004c}},	//   čiam, воља, осив_, вољи
  { {0x7d0b00c5,0xbd870012,0xf1dd0011,0xf5360009}},	//   _bogs, ونون_, _फैलन, ֽנִי_
  { {0xdb0d0017,0x7ae70d09,0xfbaa003c,0xe0d70557}},	//   tuaç, _zajt, отой_, _овс_
  { {0xaec60001,0x33740001,0x693c0030,0x4d730012}},	//   _обал, нгир, yčej, خطور
  { {0x60c40017,0x98a00002,0x2545001e,0x764d003a}},	//   _acim, _imię_, vēle_, şaya
  { {0xe1350047,0x02b7007e,0x69350015,0x19590015}},	//   енны, והים_, енну, заны_
  { {0xdb040061,0x2d850030,0x9da50012,0x26dc0d0a}},	//   ssiè, ílem_, _أصله, levo_
  { {0x7bc90106,0xf8bf0061,0xb5a00001,0xdbd80028}},	//   cteu, rgé_, _енcи, _gæða
  { {0xf8bf0025,0xdb0d00ce,0x272d0c85,0x000000c4}},	//   tiés_, traí, ožni_,
  { {0xb9e6002d,0x3abb000b,0x7ae70102,0xb2bb0009}},	//   _ціли, _ומונ, _rajt, _ומור
  { {0x8c3d003a,0xf8bf0061,0x7ae70d0b,0x04c90012}},	//   laşa, riés_, _sajt, ثوري_
  { {0x3f670047,0x24580015,0xbbb9002d,0x291909d4}},	// [1790] _отоб, дать_, ягає_, ūras_
  { {0xbcfb0061,0xae1e0037,0x60dd0d0c,0xc3340009}},	//   _théo, बनान_, lesm, ׂוּ_
  { {0x6735009b,0x7ac40014,0x85750015,0x26dc080b}},	//   mizj, ъсте, _плох, devo_
  { {0x25f40037,0x60dd02dd,0x67350972,0xdb1d07ef}},	//   ्मनी_, nesm, lizj, _ppsó
  { {0xf8bf0061,0x9f35002d,0x24b60009,0x7aca0011}},	//   chée_, неді, _אהרן_, _सॉकॅ
  { {0x2f180047,0x8c180003,0x539a0009,0x38180009}},	//   мочь_, _غيّر_, _מישו, וקדם_
  { {0xa3e70037,0x9694002d,0x6d480061,0xc3320009}},	//   भिक_, тріш, édag, _עול_
  { {0x3ea10051,0x248900b6,0xeb990015,0xef190002}},	//   _leht_, ncam_, пии_, _duża_
  { {0x24890d0d,0x7f840012,0x2cbf005e,0x4ac60011}},	//   icam_, _للقن, rgud_, र्कव
  { {0x07f80003,0xa205046e,0x60c40d0e,0x7bc906e2}},	//   _ترفع_, епод, _scim, rteu
  { {0xaf340003,0x63bb0038,0xba9a0009,0x68fb0d0f}},	//   _شركت, suun, הסתי, _knud
  { {0x4acf0037,0xaacf0037,0x7bc90061,0x628a00d4}},	//   स्तव, स्तक, pteu, _effo
  { {0x395e001e,0xdce10073,0xbcfb0d10,0x38550048}},	//   ēts_, _sulė, _chém, върс
  { {0xdb090054,0x656d0d11,0x83b60009,0x63a90d12}},	//   dreç, emah, _נפצע_, msen
  { {0xceb20093,0xfb1a000b,0xc3320009,0x61360035}},	//   טים_, _מוסמ, _גוג_, ašla
  { {0x63b6003e,0xe7b60012,0xd5b10081,0x92a90034}},	//   tryn, _كمعد, ớn_, ysłó
  { {0xc2b60001,0x63a90d13,0xa93b0009,0xe3ba0148}},	// [17a0] ељењ, nsen, _מתקפ, яба_
  { {0x3ea10052,0x20ec0081,0x656d020d,0x2489016d}},	//   _geht_, _ới_, amah, acam_
  { {0x217a0003,0x569b000b,0xfe720012,0xda0f0011}},	//   سحاب_, _מייצ, _حدة_, ाहित_
  { {0xc7c6005c,0x98ab000d,0x63a90d14,0xf8bf0025}},	//   ески, mică_, ksen, phée_
  { {0x98ab000d,0x41a60037,0xd47b0009,0x2906008e}},	//   lică_, _कौनस, _מאכל, rjoa_
  { {0x7bcb000b,0x6d5b00b6,0x26dc0164,0xeb91000b}},	//   _מֶלֶ, elua, uevo_, _כָל_
  { {0x98ab007d,0xe357000b,0xc693000b,0x78a60027}},	//   nică_, _נשלח_, נאה_, kakv
  { {0x44f40001,0x63a90040,0xdb09008e,0x78a60097}},	//   тпис, fsen, hreä, jakv
  { {0xcf4606e6,0x64590002,0x8c3d0b47,0x96960024}},	//   _знай, _cywi, taşa, _зреш
  { {0x6d5b004a,0x64590002,0x212000b6,0xbbd30012}},	//   alua, _dywi, _alih_, ازيغ
  { {0x225800c5,0x75d30003,0x60dd0d15,0x7e820035}},	//   ærk_, _ميلا, tesm, ātpā
  { {0x98ab000d,0x67350002,0x28c60011,0x6d5b0c4d}},	//   dică_, wizj, _वाणि, clua
  { {0xd7fb0046,0xac970003,0xc879000d,0x63a9000e}},	//   чун_, _أنها_, _paşi_, csen
  { {0x98ab007d,0xabfb0009,0xc0510009,0x2919020d}},	//   fică_, _מהדר, ׁ֖ם_, sksa_
  { {0xa01b000f,0xaa570d16,0x51f30003,0x98ab000d}},	//   nböz, _كلها_, _مسير, gică_
  { {0xbcfb0061,0x7aea039d,0x4a5b000b,0x5d780015}},	//   _thém, _haft, _מדוו, ейся_
  { {0x7ff70003,0x656d04b0,0x5c750014,0x24890d17}},	// [17b0] _أسعا, rmah, тлат, rcam_
  { {0xdbc70005,0x883c0009,0x24890018,0x3dd20034}},	//   _tööp, _מתחו, scam_, ływy_
  { {0xc333000b,0x6b8200c1,0x6595002d,0x9758000b}},	//   נוע_, _luog, _шану, _איזו_
  { {0x63a9003a,0x5dc80009,0x85960009,0x75240d18}},	//   ysen, _אֶשְ, _שדרג_, chiz
  { {0x34dd0037,0x3d040037,0x6b820010,0x2571001b}},	//   _मसौद, वाने_, _nuog, _ušli_
  { {0x141a0009,0x8f9c0009,0x45d50048,0x60c20073}},	//   _חושב, לידי, вцит, agom
  { {0x40950003,0xd7580003,0xb8950012,0x1ea80012}},	//   _للأر, رجها_, _للأع, راوي_
  { {0xdb1c000e,0xa5f60001,0x5dfc000b,0x63a90d19}},	//   özön, ђењу_, לפונ, tsen
  { {0x777a03eb,0x44290d1a,0x98ab000d,0x6d5b00b6}},	//   _fitx, nza_, zică_, rlua
  { {0x63a90d1b,0x6d5b0097,0x8e840012,0x692b0030}},	//   rsen, slua, _ملكه, zřet
  { {0x2726001a,0x7aea00b6,0x64590002,0x7bcd004a}},	//   _hông_, _daft, _wywi, htau
  { {0x2726001a,0xe8f700b3,0xcd960009,0x6d680012}},	//   _kông_, влю_, _ידעת_, _كملف_
  { {0x692b0066,0x7d090027,0xb87b0066,0x74290012}},	//   vřet, mjes, zdív, _تكشف_
  { {0x81bc0039,0x98ab007d,0xb464002d,0xb05b006f}},	//   izēj, tică_, _скіл, tfär
  { {0xed5a08b0,0x2d9e0061,0x6da30014,0x7d0f000e}},	//   дов_, ète_, иира, _bocs
  { {0x98ab000d,0x693c09d2,0x7d090d1c,0xe4da0012}},	//   rică_, lčev, njes, بورت_
  { {0xa05a0003,0x2726001a,0xb05b02f1,0xed570021}},	// [17c0] _تؤثر_, _nông_, sfär, тот_
  { {0x3ea70d1d,0x7d1b0051,0x81bc001e,0x6d440010}},	//   jant_, hkus, dzēj, čiai
  { {0x18a60075,0x99f5002d,0x7d1b0d1e,0x636b0052}},	//   ваем, ляці, kkus, künf
  { {0x60c20010,0x6ec40037,0x67210154,0x9c660012}},	//   ugom, _राहु, _allj, _لهجو
  { {0x2726008a,0x4429003e,0x2ba90044,0x7c290070}},	//   _công_, cza_, _चौपा, jzer
  { {0xef190002,0x7d090002,0x7c290d1f,0xceb30009}},	//   _dużo_, ejes, dzer, ֑יו_
  { {0x200001b3,0x19b90015,0xceb3000b,0x7afe0054}},	//   ţii_, _путь_, ביו_, _òpti
  { {0x6fb60003,0x2545001e,0x291c001e,0xaa430752}},	//   _لمرا, tēla_, īvas_, _тесл
  { {0xb87b000e,0x765a0002,0xe6c60012,0x98ab0034}},	//   ndít, _wyty, _لتضي, nicą_
  { {0x2d6e0013,0x7d1b004a,0xf8eb0037,0x6d580028}},	//   _přes_, akus, _जोड़ा_, _ívaf
  { {0x691300a1,0xc3330093,0x44290d20,0x3abb000b}},	//   _içer, שות_, zza_, ומינ
  { {0xfe370009,0x64410034,0xf4830d21,0x7c830365}},	//   _ברבי_, _ślim, _кушн, _куше
  { {0xead40047,0xc058002d,0x7c290002,0xc953000b}},	//   _боль, вір_, czer, שמר_
  { {0xdb2300a2,0x21f40003,0x7bc00d22,0x692b0030}},	//   örün, _مكتس, mumu, třes
  { {0x5b7b000b,0xaabe0037,0xde740012,0x912b0012}},	//   _קרוא, _एफ़एक, لدفع, _يسبق_
  { {0x442903eb,0xdb21003a,0x7bcd0a58,0x2a57000b}},	//   tza_, ştür, ttau, _שבהן_
  { {0x2d5808b0,0x3ea70573,0x09340012,0x39ae0073}},	// [17d0] тить_, yant_, _خروج, lęs_
  { {0xdd110039,0x8c3d00a2,0x7d1b009b,0x692b0066}},	//   _kļūd, daşl, zkus, přes
  { {0x9f4900a2,0x44290d23,0x2726001a,0x6d480061}},	//   _araç_, sza_, _sông_, édac
  { {0x7bc00039,0x5df6000b,0x21390d24,0xd23b0009}},	//   kumu, _עזרא_, nish_, וגבל
  { {0x7bc00039,0xdfd10003,0x7d090027,0xa054002d}},	//   jumu, صيغ_, vjes, авці
  { {0xa294002d,0x39ae0010,0x68ed0269,0x36690d25}},	//   _варі, kęs_, _laad, нало_
  { {0x63ad01a2,0xed5906e6,0x39ae0010,0xdce20029}},	//   lsan, нок_, jęs_, _choď
  { {0x7c290d26,0xa3e90014,0x1be90075,0x61fa000e}},	//   tzer, едиа_, едии_, _átla
  { {0xa2ca0037,0xdb0d0017,0x7d090571,0x2139002a}},	//   स्क्, graç, rjes, dish_
  { {0x8c44003a,0x7c290bb2,0x539a0009,0x693c0159}},	//   _öğey, rzer, עיתו, učev
  { {0xbbd00044,0x7c290d27,0x636b004e,0xc6920009}},	//   _सङ्क, szer, münd, _האב_
  { {0x8c3d00a2,0xb05b0052,0x63ad093e,0x3ea50846}},	//   laşm, rgän, ksan, _helt_
  { {0x78a40033,0xb8ec0037,0x68ed0227,0xdb000040}},	//   _veiv, _ला_, _daad, dsmæ
  { {0xf5390026,0x8afc003e,0x8c1a000b,0x248d009b}},	//   liť_, ględ, _רוסי, lcem_
  { {0x63bb001e,0x693c0604,0x657d041d,0xd62a05f7}},	//   lrun, očet, _bish, хове_
  { {0xf5390026,0xf4950015,0x693c0066,0xaacf0011}},	//   niť_, ирую, nčet, त्रक
  { {0x4466002d,0x27f70012,0x63ad0d28,0x3d040011}},	// [17e0] ував, _مفيد_, gsan, वाते_
  { {0x8c3d003a,0xe3b10012,0x69c10d29,0xb87b0d2a}},	//   vaşl, ترِ_, oule, rdít
  { {0x2b890020,0x63bb008b,0xe8d9001a,0xd36f0012}},	//   _lúc_, hrun, _nhớ_, أهل_
  { {0xb95a000a,0xf5390029,0x215a0012,0x69c10034}},	//   رجاء_, jiť_, رجاع_, iule
  { {0xf5390026,0xb8dc0037,0x645d0051,0x6d440002}},	//   diť_, _आय_, üsil, mnia
  { {0x96b70001,0x7bc00d2b,0x6d44044c,0xceb30009}},	//   гућу_, vumu, lnia, ֖יו_
  { {0x6da30001,0x3ea501fb,0x63bb0d2c,0x6d440d2d}},	//   бија, _delt_, erun, onia
  { {0x39ae0010,0xdb0d0017,0x7e640066,0xed570001}},	//   vęs_, traç, řipo, лој_
  { {0x68ed0114,0x3ea501d0,0x69c10025,0x9f8b005e}},	//   _raad, _felt_, eule, _sööt_
  { {0x68ed00b9,0x51f8002d,0x2139002a,0x693c009b}},	//   _saad, вною_, wish_, ačet
  { {0xf5390026,0x21390036,0x69c10d2e,0x68ed0051}},	//   biť_, tish_, gule, _paad
  { {0x63bb09d1,0x63ad0d2f,0xea270024,0xa9270012}},	//   brun, ysan, уцьк_, اعده
  { {0x9cd70093,0x68ed00b9,0x29000002,0x6d440002}},	//   _תודה_, _vaad, _dnia_, dnia
  { {0x6d440d30,0xa294002d,0x69dc0d31,0x7ae10d32}},	//   enia, _такі, _opre, celt
  { {0xde59002d,0x201f0010,0xaab70012,0x2d850025}},	//   таві_, šui_, _صدور_, êle_
  { {0x5c070014,0x636b0d33,0x865b0009,0x2d870031}},	//   ляза, zünd, גדלי, _énem_
  { {0xf8a80037,0x2b89001a,0x8335025c,0x0b940012}},	// [17f0] _कड़िय, _xúc_, анах, مجلد
  { {0xf5390026,0x6d440005,0x63ad0d34,0x2ca9002c}},	//   ziť_, ania, rsan, saad_
  { {0x645d0d35,0x8f7a0009,0xcad70009,0x9f7a0009}},	//   _wysi, _שנתק, רובת_, _שנתח
  { {0x7ae1003a,0x645d0002,0xf1b3000b,0x2d8507ac}},	//   zelt, _tysi, מסע_, _rule_
  { {0xf5390026,0xe6c50003,0x636b004e,0x69c10d36}},	//   viť_, لتغي, tünd, zule
  { {0x645d0051,0xf7960003,0x7d0d0d37,0x95c50012}},	//   üsim, جنوب_, ljas, ليته
  { {0xf5390026,0xdce80010,0x636b0d38,0xff180009}},	//   tiť_, _judė, ründ, רקות_
  { {0x7d0d0006,0x3ea50052,0xa3b90037,0xb605000e}},	//   njas, _welt_, _घटा_, _aláí
  { {0xdcfa0039,0xf5390026,0xf5760003,0x7ae10d39}},	//   _attē, riť_, جميع_, telt
  { {0xadf70037,0xe1f9002d,0xf5390029,0x2d8501a3}},	//   ुमान_, вго_, siť_, _tule_
  { {0x8e84000a,0x7d0d0065,0x06840003,0xf5390029}},	//   _المه, kjas, _المُ, piť_
  { {0xdb000051,0x69c10d3a,0x2b890081,0x63bb0d3b}},	//   esmä, rule, _túc_, prun
  { {0x6d440cf9,0x7d0d0d3c,0x47c30048,0x98ab0034}},	//   čiat, djas, обяв, nicę_
  { {0xf772000a,0xf863002d,0x6d440002,0x98ab001e}},	//   تاج_, івро, wnia, ējās_
  { {0xe8d90020,0x442d0d3d,0x7d0d0028,0x6d440002}},	//   _giữ_, lze_, fjas, tnia
  { {0x7aee00b6,0x69c40011,0xfe430024,0x7786004c}},	//   _sabt, ांसी, інто, _клиз

  { {0x2d98007d,0x69dc0d3e,0x5aca002d,0xeab20003}},	// [1800] spre_, _spre, клам_, قعا_
  { {0x1303002d,0x69dc0033,0x442d0d3f,0x6d440d40}},	//   озум, _ppre, ize_, snia
  { {0xdebb000b,0x2d850066,0x88860447,0x3ebb0009}},	//   _במיל, ílet_, алеж, _בציב
  { {0x316d0061,0x71d6000b,0x7d0b006f,0x9c8301e9}},	//   _chez_, יועד_, ögst, účtu
  { {0x442d0070,0xe8d9001a,0xec47003c,0x59d20011}},	//   jze_, _nhờ_, _взял_, _सहकर
  { {0x501b000b,0x6996002d,0x442d037f,0x47330024}},	//   כונו, _врах, dze_, оніс
  { {0x32070006,0x69dc0029,0xceb3000b,0x98a6002d}},	//   änyt_, _upre, קיה_, _вибе
  { {0x636b00a2,0x75290d41,0xd1970009,0x7dfc004b}},	//   rüne, ghez, _ככלי_, _răsă
  { {0x6eb60003,0x4306002d,0xe8d9001a,0x673c07f6}},	//   _نصائ, аїна, _chờ_, kirj
  { {0x8f9b0009,0x03d70009,0x7dfc004b,0x661c0248}},	//   _סיבי, סוים_, _păsă, kyrk
  { {0x7c2d01a2,0xd5b10020,0xf1c30081,0xe9190024}},	//   zzar, ới_, _ngờ_, гоні_
  { {0xdb000058,0xd1260003,0x7afd001e,0x3946086e}},	//   dsmå, سم_, ēsta, nnos_
  { {0xab94000a,0x442d003e,0x9b940003,0x33940003}},	//   _التغ, cze_, _التت, _التز
  { {0xd724002d,0x69cf000d,0xdced01bd,0x6d480025}},	//   офсп, ăcer, rmač, édan
  { {0xdb000d42,0xeca70001,0x8d770003,0x28d70011}},	//   gsmå, ијан, لارا, ण्डि
  { {0x8a7b0093,0x427b000b,0x3946000e,0x4a7b000b}},	//   _באות, _באוג, jnos_, _ברוב
  { {0x29e8007d,0x67da001e,0xfa870001,0x957c0034}},	// [1810] _aşa_, nājā, аћем, _brąz
  { {0x39460d43,0x39590032,0x75290031,0x7d0d0a94}},	//   enos_, loss_, zhez, sjas
  { {0xeab1000b,0x7c2d0002,0x442d0d44,0xa3b30011}},	//   לֹא_, szar, zze_, _टिक_
  { {0x645d0051,0xa3b30011,0xe45f008e,0xe0020011}},	//   üsik, ड़ूँ_, _työ_, लमंद_
  { {0x2f19002d,0xb8ef0011,0x6aa70031,0x61260097}},	//   лодь_, _शा_, _tejf, _jóla
  { {0x6fb20003,0x86980014,0x394601c5,0x66e5022a}},	//   أموا, атът_, anos_, сока
  { {0xcdc80003,0x98af0010,0x9f4e000e,0x7de40012}},	//   لذين_, eigą_, énél_, قسيم
  { {0x442d0d45,0xf532000b,0x7ae50038,0xcd050337}},	//   tze_, ּ֥ה_, leht, спий
  { {0xc9520093,0x442d0d46,0x5f940198,0x7b16004b}},	//   _זמן_, uze_, _митт, _râur
  { {0x7d02009b,0x442d0d47,0x9b450012,0x2d8c0030}},	//   _enos, rze_, إندو, ídek_
  { {0x442d0d23,0x5d850003,0x5f740003,0x6d440029}},	//   sze_, _الصل, _ذاكر, čiar
  { {0x2d680052,0xe8d9001a,0xacf40012,0x61360064}},	//   eßen_, _thờ_, _وسنت, ošli
  { {0x95540003,0x7ae503bd,0xdb040097,0x59c90011}},	//   _بخلا, keht, krið, ांडर
  { {0x539a000b,0x6b96000b,0xa856000b,0x254c0066}},	//   _עיצו, _הכסף_, מירה_, měla_
  { {0xdb090164,0x69c50051,0xd627072b,0x7e690030}},	//   queñ, juhe, боре_, řepn
  { {0x63a4003a,0x63620d48,0x61360cac,0x8a160009}},	//   _çinc, môni, kšli, _לחצו_
  { {0x138a0003,0x63620017,0xc953000b,0x1bed0011}},	// [1820] اخرى_, lôni, _ממה_, जिटल_
  { {0xed590066,0xadf90037,0xdb040017,0x6ac60012}},	//   hož_, ्मान_, isiç, إقام
  { {0x63700052,0x63620017,0x61460015,0xed590066}},	//   häng, nôni, бежа, kož_
  { {0xf992000b,0x2561000e,0xa2d80011,0xfc270012}},	//   פרד_, bóli_, _नॉर्, _فح_
  { {0x39460d49,0x80250012,0x63aa0030,0x68e60073}},	//   rnos_, يرهم, álně, iekd
  { {0x65640065,0xc7d70009,0x254c0030,0x7d02001b}},	//   llih, מוני_, děla_, _snos
  { {0x3d040037,0x6da3004c,0xf2a3004c,0xe8d90081}},	//   वाले_, пија, _хисп, _nhở_
  { {0x71260003,0x6370031d,0x5bb8022a,0x778604ac}},	//   _ارسل, fäng, алия_, _глаз
  { {0xa3cb0044,0x63700d4a,0xccf3000b,0x7d02009b}},	//   रूप_, gäng, לכה_, _vnos
  { {0x2d820d4b,0x7b390066,0x49d8002d,0xaaa80037}},	//   _like_, lňuj, адою_, गरिक
  { {0xd5b9007c,0x23a90037,0x61260028,0x71270003}},	//   _всі_, चीबद, _sóla, مرحل
  { {0x81bc0039,0x6c860003,0xa2d80037,0x59c90037}},	//   dzēt, _الإم, न्त्, ांतर
  { {0x3959002a,0xa2d30037,0xe3af0012,0x7d1d0d4c}},	//   ross_, _बॉक्, _كرو_, össe
  { {0x6e940015,0xa7fd000e,0x2d680052,0x656402a0}},	//   зиру, _szűk, ußen_, elih
  { {0xa3cb0037,0xd9ec0037,0xe189001a,0xee310009}},	//   रंभ_, _जनित_, _hẳn_, ֵֽל_
  { {0x3eae03e4,0x61260028,0x6144004c,0x7e690030}},	//   haft_, _tóla, _неја, řepo
  { {0xdb040d4d,0xb8cd0037,0x7b3905b1,0x82870012}},	// [1830] trið, गर_, dňuj, مجال
  { {0x8c1b000b,0x69c50028,0xd3710012,0xbcfb0025}},	//   אומי, tuhe, ذها_, _chér
  { {0x60990012,0xa3a90011,0xed690097,0xceb20009}},	//   لناس_, _गौर_, nnþá_, _קיט_
  { {0xc1050012,0xa0c50012,0x2ee10011,0x6d5d020d}},	//   توصي, زيتو, फ़्त, _uksa
  { {0xf7710351,0xb3670048,0x8e8505fb,0x78a9005e}},	//   وات_, _гъвк, огле, _veev
  { {0xa2d80044,0x69c5004a,0x2d9505f0,0xb6a50d4e}},	//   न्द्, puhe, орис, цикл
  { {0xf592000a,0x8d750003,0x212900b6,0x78a90051}},	//   ولوج, يابا, _olah_, _teev
  { {0xa63c000b,0x6370006f,0xb9250012,0x321e0034}},	//   טגור, täng, _بفري, dyty_
  { {0x798a0052,0x63700032,0x27ed026b,0xdce80035}},	//   _aufw, bänd, _usen_, _zudī
  { {0xdb160006,0xe9d90838,0x1c420015,0x9dab0014}},	//   styö, ако_, ьным, _бъда_
  { {0x81bc0039,0xeab2000b,0xc869000b,0x07080012}},	//   dzēs, וֹר_, _סן_, _ديلي_
  { {0xf1b2000b,0x637002f1,0x62830029,0x63620018}},	//   וסט_, mäne, ľnoh, rôni
  { {0x6d4901b3,0x2904003a,0xbf87001a,0xd5b1001a}},	//   mnea, ıma_, _điển_, ấn_
  { {0x907a000b,0xe2990094,0xd5b8001e,0xd5dd0011}},	//   יטרי, _так_, šām_, _महाज
  { {0xad3a002d,0x6d49000d,0xe5060012,0x5fb60011}},	//   ачає_, onea, يبري, _अटकल
  { {0x39b50039,0xc5f2000b,0x62950070,0x0566002d}},	//   mās_, ודל_, _afzo, іван
  { {0x39b50039,0x656400b6,0x39a7000e,0x25a00027}},	// [1840] lās_, rlih, lős_, ćili_
  { {0x70b40037,0x7e640030,0x5de60700,0x6b830d4f}},	//   ुल्ल, řipi, _джоа, _jing
  { {0x63700d50,0x39b50039,0xa3a90037,0xe2970015}},	//   vänd, nās_, गीत_, цах_
  { {0x80660014,0x752d0164,0xdd0f003a,0x6d410025}},	//   овеж, chaz, mışs, élat
  { {0xb4e60037,0x69c10052,0x63700d51,0x7b3901e9}},	//   फ़ी_, hrle, tänd, rňuj
  { {0xab2a0046,0x39b50039,0xa857000b,0x6b830d52}},	//   _тога_, kās_, חינה_, _ning
  { {0x39b50039,0x76a9002d,0x272f0052,0x386d000e}},	//   jās_, стів_, _fünf_, _ezer_
  { {0x39b50039,0x63700c60,0x6d490623,0xc19b0009}},	//   dās_, sänd, gnea, _כשלי
  { {0x44200d53,0xad1b0009,0x25a9001b,0x6b830d54}},	//   nyi_, שופר, ćala_, _bing
  { {0xa3cb0037,0xd3700003,0x63bd000e,0x7bdb0009}},	//   रंत_, عهد_, ásna, סקיו
  { {0x39b5001e,0x6aaa0028,0x28d10011,0x8f750024}},	//   gās_, _veff, _हामि, _хуті
  { {0x394d0149,0xe8d90020,0x6b8308fa,0x94d40003}},	//   ões_, _phố_, _eing, _ريتش
  { {0xf8b3000b,0xb0340015,0x1dc60011,0xdfdb0048}},	//   ושר_, дняш, रूरत, шън_
  { {0x7d06007a,0x44320002,0x2545001e,0x7bd5000d}},	//   _anks, dzy_, vēli_, ăzut
  { {0x39b5001e,0x6d40004a,0xdce20034,0x98af0073}},	//   cās_, oima, _choć, aigę_
  { {0x2545001e,0x6d400d55,0x2d8c0018,0x2129016d}},	//   tēli_, nima, _mude_, _ulah_
  { {0x6d400051,0xe3b30012,0xbe870012,0x69c80d56}},	// [1850] iima, برز_, _وجدو, lude
  { {0x539b007e,0x99d70003,0x2d8c0070,0x78ad0d57}},	//   יימו, قتصا, _oude_, _heav
  { {0x8c3d003a,0x6d400d58,0x2d8c0d59,0x91b00081}},	//   laşt, kima, _nude_, _đạo_
  { {0x6d40007a,0xc4c70012,0xec150012,0xad190009}},	//   jima, _بتدو, _فوجد, _הוֹר
  { {0x4432003e,0x3ce30037,0x07a50014,0x394b000e}},	//   czy_, कड़ों_, чалн, incs_
  { {0x37070047,0x78ad0036,0xf3ff0017,0x6370004a}},	//   ючев, _leav, _irã_, täne
  { {0x6aa70037,0xf62500b3,0x69c80d5a,0xdb020032}},	//   _ग़ौर, ядко, jude, _stoß
  { {0x39b50039,0xdb1b0054,0x69c80051,0x2d8c0d5b}},	//   vās_, truï, dude, _dude_
  { {0x1c450024,0x6d490d5c,0x6b830d5d,0x0d3c00af}},	//   яним, rnea, _ping, יגהב
  { {0x39b50039,0xfbd2000b,0x395d0444,0x49c9085f}},	//   tās_, עתי_, lows_, блон_
  { {0xeccb0037,0xc4cb0037,0x644d0010,0x69c80d5e}},	//   िलाफ, िलाओ, _žaid, gude
  { {0x39b50039,0x69d70054,0x3cf80012,0x6b83096c}},	//   rās_, itxe, _وعند_, _wing
  { {0x39b5001e,0xa3f4002d,0x67070011,0xc796003c}},	//   sās_, _опці, शांक_, ярны
  { {0x39b50039,0x539a000b,0x2d96004d,0x69c80d5f}},	//   pās_, _היסו, зрас, bude
  { {0x64a60d60,0x66030024,0x78a20042,0x8c3d004b}},	//   заба, нпра, ybov, raşu
  { {0x49ba0093,0x78ad0070,0x4420004a,0x19ba000b}},	//   _המקס, _geav, tyi_, _המקב
  { {0x44260020,0xa08b0009,0x5046004c,0x39420a94}},	// [1860] áo_, _לְיִ, _хепб, miks_
  { {0x443204fa,0x883b0009,0x44200d61,0x6d400d62}},	//   rzy_, _לתפו, ryi_, zima
  { {0x2730008a,0x68f600a2,0x4432003e,0xe9da0838}},	//   _hàng_, _kayd, szy_, ске_
  { {0x39420051,0x66010058,0x7d190002,0x7ae80034}},	//   niks_, ælke, _nows, zedt
  { {0x6d40007a,0xf3ff0017,0x78a20d63,0x7d7b0009}},	//   vima, _grã_, rbov, _לנטו
  { {0x39420051,0xb5a60024,0x27300081,0x28d10011}},	//   hiks_, прий, _màng_, _हाथि
  { {0xa5d70003,0x91e3011f,0x2730001a,0x7ae80722}},	//   كبير_, _поре, _làng_, vedt
  { {0x2cea002d,0x5398010c,0x69c80d64,0xa2aa0011}},	//   сько_, овия_, vude, टरव्
  { {0x39420051,0x7bc90d65,0xb8e20011,0x27300081}},	//   diks_, gueu, ूल_, _nàng_
  { {0x59d0015f,0xab970003,0xaacc0037,0xdce60010}},	//   _हमार, أخير_, ालिक, _tikė
  { {0x78ad0005,0x2d8c0051,0x6d400d66,0x69c800ff}},	//   _peav, _uude_, pima, uude
  { {0x39420051,0x63b6004a,0xd5b1001a,0xdb1b0097}},	//   giks_, ksyn, ấm_, stuð
  { {0x27300020,0x63ae0066,0x645d0051,0x69c80d67}},	//   _càng_, áhně, üsit, sude
  { {0x2730001a,0xcb540003,0x3942001e,0x3f850028}},	//   _dàng_, _تنتظ, aiks_, ölu_
  { {0x7bc40005,0x78ad0005,0x68f6003a,0xa4d5002d}},	//   eriu, _teav, _fayd, мові
  { {0xf549001a,0x9a670003,0x04c90012,0x8d740012}},	//   hấn_, _عميل_, توري_, فاقا
  { {0xdcfa001e,0x2bb80003,0xc158000b,0x88bc000b}},	// [1870] _attī, كالة_, _משהו_, _המחז
  { {0x539b0009,0x60dd016a,0xc7b20009,0x6f1a0132}},	//   ציבו, lfsm, _שבי_, _notc
  { {0x79a40015,0x2a980003,0xa3b90011,0x91870012}},	//   ерче, سئلة_, _घटक_, سجام
  { {0xda7b0009,0x7bc4036c,0xf9930009,0x637401a0}},	//   זנבר, briu, גרף_, lànd
  { {0x7bc403eb,0x9f35002d,0x636b003a,0x6d4d0647}},	//   criu, меді, lünm, mnaa
  { {0x6d4d0070,0xdb1b0056,0x7afd0035,0xf77300ae}},	//   lnaa, truí, ēstk, راش_
  { {0x7d19003e,0x80bf0037,0x6d4d00ff,0x272f003a}},	//   _pows, ्लाइ, onaa, _güne_
  { {0xe8d9001a,0xc1050012,0x7bc90025,0x637009ee}},	//   _khổ_, _توري, tueu, mäna
  { {0x47d50003,0x6d480025,0x63a40060,0xab5d0034}},	//   _زيار, édai, _çinl, erża
  { {0x2730001a,0xd7740012,0x80d90011,0x68eb0227}},	//   _ràng_, _كالع, फ्रे, legd
  { {0x2730001a,0x39420d68,0xa0c60012,0x6f7a0009}},	//   _sàng_, tiks_, ويدو, _וְאו
  { {0xd7d10044,0x25450039,0xe7d10044,0x69c5004a}},	//   _समाच, tēlu_, _समाप, irhe
  { {0x69c50052,0x39420d69,0x636b003a,0x316c001e}},	//   hrhe, riks_, tünl, ēdz_
  { {0x2730001a,0x59c50037,0x3942005e,0x65690d6a}},	//   _vàng_, _विपर, siks_, lleh
  { {0x212d00ec,0x636b0060,0xb956004c,0xd62a0365}},	//   _oleh_, rünl, _отић, цове_
  { {0x2730001a,0xa5070048,0x1d0706bd,0x65690d6b}},	//   _tàng_, меса_, меси_, nleh
  { {0x6b8700bd,0x7bc40010,0x5fd20037,0x04430c1e}},	// [1880] _bijg, uriu, _तमिल, ветн
  { {0xdcfd0039,0xd7760003,0xd5b1001a,0x63b60192}},	//   _visā, _تابع, ớp_, rsyn
  { {0x2005001e,0xfe720012,0x56b70009,0x2d950048}},	//   ālie_, _جدة_, _קפטן_, _пряс
  { {0x98b9000d,0x7bc4000d,0x9dc10011,0x98a6003c}},	//   misă_, priu, रूज़ो, фиде
  { {0x69c508de,0x38490009,0xeb9a0048,0x65690030}},	//   arhe, ּאוּ_, _фиг_, dleh
  { {0xa0370009,0xf8370009,0xf5490081,0xdd9a0c6c}},	//   ואנה_, וננת_, uấn_, оши_
  { {0xdd900003,0xac940024,0x66e00011,0x77ea0011}},	//   دوب_, найш, ख्यक_, टबुक_
  { {0x6ba50163,0xdce40d6c,0x13f40048,0xb90306bd}},	//   _åtgä, klič, езия, _изск
  { {0xbcfb0066,0x6f930012,0x98b9004b,0xf8630d6d}},	//   _okén, _للقض, hisă_, _авто
  { {0x7e970003,0x39400061,0x61260028,0x521402ad}},	//   _ينقر_, _amis_, _fólk, едот
  { {0x28f900b3,0x8e4a0012,0xdce407a5,0xa2cf0011}},	//   пень_, _بلاك_, elič, _दार्
  { {0xf3880020,0x0c2606bd,0x7e640030,0x4035003c}},	//   _lợi_, _омен, řips, еемс
  { {0x28d10037,0x63740054,0x60dd0028,0xb05b006f}},	//   _हासि, tànd, rfsm, egär
  { {0x44240002,0x39930017,0x6560000e,0x3940004b}},	//   mym_, _fãs_, lomh, _emis_
  { {0x200d000d,0xf1c50037,0x1df8003c,0x56940bda}},	//   ţei_, _वियन, меры_, таст
  { {0x636b00a2,0xe8d9001a,0x765b003a,0x91bb0009}},	//   rünm, _phổ_, şuyo, _ומהי
  { {0x6d4d0d6e,0x44240d6f,0x68eb0031,0x351b0009}},	// [1890] rnaa, nym_, vegd, קומנ
  { {0x6d4d0070,0x026b00fa,0x59c50011,0xf79c0009}},	//   snaa, ошей_, _विमर, _ובזמ
  { {0x69cf0002,0x69da0d70,0xf9900012,0x6d4d0227}},	//   ąceg, ntte, لبن_, pnaa
  { {0x69da03fc,0xe8d9001a,0xc27b000b,0x44240029}},	//   itte, _thổ_, קראי, kym_
  { {0x7feb0003,0x63700d71,0xc49a0009,0x01380009}},	//   تراف_, männ, _משרת, וראת_
  { {0x7d1d000f,0x98a50073,0x44240d72,0x63700d73}},	//   _hoss, ėlę_, dym_, länn
  { {0xdce4048b,0xf388001a,0x62830029,0xa3cb0037}},	//   zlič, _gợi_, ľnos, रूर_
  { {0x7d1d0006,0x657b002c,0xccf20009,0x69da0032}},	//   _joss, umuh, ָ֛ה_, dtte
  { {0x13e60015,0x2d9e0d74,0xd7770012,0x8b250048}},	//   емый_, _ette_, _قاطع, едпе
  { {0x2545001e,0x65690d75,0x8c9f0011,0x7d1d0d76}},	//   tēls_, sleh, _ग्रो, _loss
  { {0xcb12000b,0x6370006f,0x3869003a,0xb0620872}},	//   אלי_, känn, _ayar_, _ääri
  { {0x7d1d0149,0x44240002,0x20140002,0x6370008e}},	//   _noss, bym_, ścił_, jänn
  { {0x44240002,0xb4270003,0x6370008e,0xdb0b0d77}},	//   cym_, _تعاو, dänn, _avgå
  { {0x7529000f,0x61f5000e,0x7bdb0028,0xb05b006f}},	//   lkez, _oszl, mtuu, tgär
  { {0xc6920093,0x6721006f,0xdd920003,0x6e930003}},	//   ראל_, ölja, اور_, الفا
  { {0x7989003e,0x2d9e001e,0x2a3a0009,0x98b9004b}},	//   _niew, īte_, _מעצמ, risă_
  { {0x7ff60003,0x7d1d04d4,0x7bdb0d78,0x32d90009}},	// [18a0] _أسبا, _doss, ntuu, ּחֲנ
  { {0x272b00b0,0x7c360034,0x7bdb008e,0x48dc0011}},	//   _sønn_, rzyr, ituu, ग्रो_
  { {0xda660003,0x44240002,0xf8bf0061,0xe8d9001a}},	//   راطي, zym_, chés_, _chỗ_
  { {0x7bdb0005,0x8c9f0037,0x69c30164,0xd59b0009}},	//   ktuu, _ग्लो, ánea, _מבטל
  { {0xa7fd000f,0x7f46027f,0xd4360012,0xef660048}},	//   _szűr, недж, _أعجب, нъко
  { {0x57f30001,0xa8470003,0x3cdd0037,0x254c0066}},	//   упшт, علوم_, क्से_, měli_
  { {0x4424003e,0x4ea5002d,0x68e40b2d,0x7d780012}},	//   wym_, тріа, _obid, ومتر_
  { {0x89db000b,0x7529000e,0x2fc60058,0x442404f3}},	//   _מחלי, gkez, prog_, tym_
  { {0x8497000a,0x27340248,0xa8060024,0x39460d79}},	//   رئيس_, _känd_, _язал, mios_
  { {0x307508b0,0x6560024c,0xa91d009b,0x44240002}},	//   _русс, somh, _nižj, rym_
  { {0xc333015a,0xd337000b,0x19590015,0xa1590447}},	//   רות_, גריה_, даны_, дану_
  { {0x98a90029,0xa3cb0011,0xb7f40011,0xdde90012}},	//   _tlač_, रूँ_, _इनाम_, _تركه_
  { {0x7bdb00bd,0xc953000b,0x63700d7a,0xe8030037}},	//   ctuu, רמר_, jäno, लिया_
  { {0x254c0066,0x999e000e,0x636b000e,0x539b0009}},	//   děli_, sztő_, rünk, _ציוו
  { {0x39460010,0x80a20037,0x6370004a,0x8afb0009}},	//   kios_, _क्वे, tänn, _מהגי
  { {0x59c50044,0x9d180ac5,0x63660028,0xc4cb0011}},	//   _वितर, ност_, rðnu, िलेख
  { {0xdb0d0c7e,0x63a4002c,0x7d1d0d7b,0xa8a80009}},	// [18b0] nsaç, gpin, _voss, _אֹתִ
  { {0x69c800bd,0x6370004a,0xdb0d0164,0x86990223}},	//   orde, sänn, trañ, _юкос_
  { {0xd251000a,0xa2d801e1,0xc2c40003,0x200400c1}},	//   جنا_, _मान्, طيني, _armi_
  { {0x69c8000f,0x25ba000b,0x55ba0009,0xad270012}},	//   irde, _קצרמ, _קמרו, _أردو
  { {0x79890087,0x656d00b6,0x69c80052,0xa4b60009}},	//   _view, mlah, hrde, _שלשה_
  { {0xd0060048,0xd00c0009,0x36690d7c,0x2d8b01e3}},	//   теше_, לּוֹ, мало_, _hice_
  { {0x75290272,0x56920046,0x39460d7d,0xed590a2c}},	//   tkez, шајт, bios_, мок_
  { {0x39460d7e,0x7bdb004a,0x61260028,0x27340248}},	//   cios_, ttuu, _tóli, _täng_
  { {0x80a20044,0x442b0020,0x7f950098,0x75290d7f}},	//   _क्षे, ác_, _разх, rkez
  { {0x3eb30036,0xeab10003,0x69ca0017,0x63740054}},	//   _next_, جعة_, áfeg, vànc
  { {0x68fb0176,0x7bdb06cb,0x3f920060,0x75290031}},	//   _kaud, stuu, _suyu_, pkez
  { {0x2eaa0044,0x9e48000b,0x6721006f,0x63740054}},	//   कर्त, _אֲנִ, öljn, tànc
  { {0x69c809a0,0xf8bf0066,0x20040d80,0x88ba0009}},	//   arde, ckém_, ími_, וזרי
  { {0x80a20044,0x07a3024d,0xec360009,0x6f63003c}},	//   _क्रे, рарн, _באנר_, ивяз
  { {0x63bd0163,0x9a690003,0x165901d4,0x3aba0009}},	//   _avsn, _تمثل_, ерть_, _חמצנ
  { {0x68fb0d81,0x57d10037,0x140d0037,0x291f000d}},	//   _naud, _समूह, समूह_, _noua_
  { {0xb87b0d04,0x2d8b0d82,0x69c30064,0xc2b6004c}},	// [18c0] rfíc, _dice_, ánen, вљењ
  { {0x5fb7000b,0x577a0003,0x63a40d83,0xffb70009}},	//   _שהיא_, _تصبح_, rpin, _שליש_
  { {0x394602d1,0x3ebe0028,0x63a40d84,0x9b650012}},	//   tios_, óttu_, spin, اطقه
  { {0xd5b80039,0x1e57000b,0xd0260048,0xc7a60472}},	//   šās_, _ישיר_, кмей, видк
  { {0x68fb0039,0x291f000d,0xa3ba0012,0xf7f30012}},	//   _daud, _doua_, _تاجر_, لسود
  { {0x3946007a,0x8fa30001,0x2d8b000d,0x1eaa0012}},	//   sios_, шаље, _zice_, ذاتي_
  { {0x41aa002d,0x68fb0061,0x39460d85,0xe1f7003c}},	//   _іван_, _faud, pios_, _игр_
  { {0xed570046,0x29dc0164,0x6564004a,0x7bc90d86}},	//   кој_, mía_, noih, freu
  { {0xb8660003,0x1c050011,0x3eb80d87,0x9f4d01e3}},	//   _شارو, रियल_, kart_, _creó_
  { {0x68fb001e,0xe44f0012,0xdb0d0018,0x69c8001b}},	//   _zaud, تضى_, rsaç, trde
  { {0xf2d3000b,0x29dc0d88,0xa3c60037,0x6370006f}},	//   בעת_, nía_, ैंड_, vänl
  { {0x91bb000b,0xf8bf000e,0x2d800002,0x216400fa}},	//   ומטי, mkék_, jmie_, итяг
  { {0x4fc70014,0xdb040164,0xb4ae0037,0x3eb8013f}},	//   ъсна, nsió, करी_, fart_
  { {0x63a20101,0x0ccb0037,0xe8030037,0x2d8b0066}},	//   _iton, िल्म, लिता_, _sice_
  { {0x80d30037,0xcb670001,0xee2e0024,0x29dc01e3}},	//   _डाले, _шаље_, йнi_, jía_
  { {0x29dc0164,0xdb1b0017,0x850d0011,0xa2d80011}},	//   día_, truç, हाइट_, _माड्
  { {0xfbd00003,0x25a90027,0x50b80003,0x3eb8013f}},	// [18d0] قتل_, ćali_, _شديد_, bart_
  { {0xe4e20044,0x29dc02d1,0x1fa40014,0x764e000e}},	//   क्ति_, fía_, _тръг, ányá
  { {0x29dc02d1,0xc6920009,0x99870030,0xdbd10032}},	//   gía_, _לאי_, ánů_, _füße
  { {0xd5b1001a,0x7c32000e,0x63a2051f,0x08d40024}},	//   ấu_, ókró, _oton, иція
  { {0xb8db0037,0x08c40024,0x68fb08a7,0x7d0f0031}},	//   _आज_, рбін, _vaud, _incs
  { {0x29dc02d1,0x7afc0d89,0x2abc0030,0x7bc90ae5}},	//   bía_, _gart, rábí_, vreu
  { {0x29dc02d1,0x69de0070,0x44290d8a,0xc3320009}},	//   cía_, ctpe, lya_, _פול_
  { {0x9f4d00b8,0x7bc90d8b,0x7afc0032,0x63bb0d8c}},	//   _creò_, treu, _zart, tsun
  { {0xe3b1000a,0xbcfb0026,0x7bc90061,0x7d760012}},	//   حرب_, _akék, ureu, دمير_
  { {0x63bb00a2,0x7bc90c23,0xddeb0012,0x89a908d1}},	//   rsun, rreu, _يراه_, нков_
  { {0x5cd50003,0x63bb0d8d,0xe8df0081,0x2d800034}},	//   _مقاط, ssun, _ngừa_, ymie_
  { {0x34950046,0x7fd6002d,0x89360003,0x7bc9000d}},	//   _садр, лігі, اعدا, preu
  { {0x59c50044,0x752d0042,0x798d016d,0x1dcf0011}},	//   _विवर, dkaz, _diaw, सूरत
  { {0x3cff005e,0x61260031,0xdbd10032,0x7d1b0d8e}},	//   lduv_, _rólu, _süße, ljus
  { {0xceb20093,0x442900a2,0xa2d80037,0xe4f90037}},	//   מים_, eya_, _मात्, ्यपि_
  { {0x5c160047,0x29dc02d1,0x4429003a,0xb4c00011}},	//   льзу, vía_, fya_, ीले_
  { {0x07fa0003,0x2d800826,0x7c290d8f,0x2ecf0011}},	// [18e0] _أربع_, rmie_, nyer, _हफ़्त
  { {0x7d1b0005,0x57fb000b,0x0ed20037,0x2d800029}},	//   hjus, _טלפו, _साइड, smie_
  { {0xd5b1008a,0x7afc0757,0x6370006f,0x18a60063}},	//   ất_, _vart, länk, гаем
  { {0x29dc02d1,0x7afc0d90,0x386d0260,0xc3290009}},	//   ría_, _wart, _byer_, הו_
  { {0x6d46003a,0x7afc0d91,0xe8070037,0x6721080a}},	//   _imka, _tart, शिया_, _bolj
  { {0xdb0402d1,0xa2d80037,0xbcfb0029,0x75d40012}},	//   rsió, _माध्, _akéh, ليتا
  { {0xf41f0006,0x7de60003,0x67210027,0x316c001e}},	//   ään_, استم, _dolj, _ūdzu_
  { {0xb4ae0011,0x42530012,0x7c3b0032,0xaa430365}},	//   करे_, _انفر, fzur, _уесл
  { {0x68e40051,0x08f90012,0x14d50011,0x8afc0034}},	//   õidu, _جرّب_, _धारण, klęt
  { {0xef830229,0xeab60009,0x79820034,0x77830024}},	//   _глуп, נִ֥י_, lmow, _глуз
  { {0x6e93000a,0xe693000a,0x5e93000a,0xf6560024}},	//   _الما, _المد, _المط, _стаю
  { {0x286b002d,0xe8d9001a,0x7c29002c,0x7d1b0034}},	//   ерго_, _khứ_, byer, cjus
  { {0xac970003,0xaf370012,0x69cd0073,0xab2a064d}},	//   _إنها_, هرست, _įneš, _пода_
  { {0x88bd003e,0x7bfb000b,0x4aba0048,0xb2a60012}},	//   _kośc, _נפוצ, _чудя_, _صحته
  { {0x637008b5,0x95c800f5,0x2bc70011,0xe5730012}},	//   mänh, лута_, _लिहा, مطر_
  { {0x79820002,0x6aba000e,0x88bd0034,0x316909df}},	//   jmow, latf, _mośc, _ukaz_
  { {0xb8f90044,0x29270002,0x93970003,0x394b0d92}},	// [18f0] ाल_, ętać_, اجرا, mics_
  { {0xdce9080f,0x752d0404,0xd25b0d93,0x44290d94}},	//   vleč, skaz, нце_, rya_
  { {0xdb580015,0x7bcb0028,0xdce90027,0x320700d9}},	//   уют_, águb, zmeđ, íny_
  { {0x97c50003,0x44290115,0x394b0d95,0xbebc0035}},	//   لقصو, pya_, nics_, _slīp
  { {0x94ba0009,0xe8d9001a,0x6721048b,0xa295002d}},	//   _שמשת, _chứ_, _polj, _вагі
  { {0x394b0d96,0x386d0248,0xd70503d2,0x000000c4}},	//   hics_, _vyer_, рзки,
  { {0x7bcd0065,0x67210470,0x2365009b,0xf2040014}},	//   lrau, _volj, volj_, _лято
  { {0x7bcd0032,0xdce90073,0x6d2500b5,0x661a008e}},	//   orau, pleč, рдиз, ätki
  { {0x75ec000f,0x36d50015,0xec790014,0x394b0ce3}},	//   _közö, _возр, ъпи_, dics_
  { {0x82350003,0xef670014,0xff530003,0x96f80012}},	//   لرجا, _събо, _اخر_, _معمر_
  { {0xf7840003,0x7bcd0052,0x88bd0002,0x394b0ce3}},	//   _اللَ, hrau, _gośc, fics_
  { {0x6370006f,0x2b170037,0xab660002,0x00860103}},	//   tänk, नाडु_, _zażą, илно
  { {0x2ba7004c,0xdfd20012,0x2cad0912,0x61260097}},	//   _сјев, غيس_, mbed_, _sóls
  { {0x82a50047,0x79820002,0xc43a000b,0x6370031d}},	//   _такж, zmow, _שתסי, ränk
  { {0x29560098,0x69c30aa3,0x28a70011,0x76000031}},	//   _въпр, šnej, _क्वि, mázá
  { {0xf3880020,0x7600000f,0x636b0d97,0x27ed0d98}},	//   _hợp_, lázá, zünt, _open_
  { {0x4d63002d,0x6a960024,0x9346004c,0xdb000d99}},	// [1900] ікув, ареє, анае, rsmö
  { {0xa87b000b,0x2d8f0d9a,0x487b0009,0x67bb0009}},	//   _באפר, _lige_, _בטפס, _שמיק
  { {0x4add0037,0xe9da069b,0x80a60003,0xa2d80037}},	//   _मानव, тке_, لمان, _मास्
  { {0x88e60047,0xa3e60037,0x865b0009,0x55bb0009}},	//   ржде, _पहल_, _ידיי, _במטו
  { {0xdefa0047,0x79820002,0x76000066,0xa09b000b}},	//   вый_, rmow, kázá, דינט
  { {0xeea70014,0xf4570009,0xceb30009,0xd00f0012}},	//   атък_, _כיכר_, ֗יו_, بله_
  { {0x636b00a2,0x2dd70003,0x6370004a,0xceb30009}},	//   rünt, لبية_, jäni, חיו_
  { {0xe8d90020,0x2cea0024,0xc6170009,0x5ca90009}},	//   _thứ_, тько_, שחקי_, ְׁתַ
  { {0xa5070001,0x61e90027,0xe4e20011,0xc7a30048}},	//   рења_, _ćeli, क्षि_, _митк
  { {0xbb540012,0x7bc60073,0xdfcf0012,0x69cf0034}},	//   إندب, škuo, _آيل_, ącen
  { {0x2bc20037,0xd257002d,0x3377000b,0x2cad002a}},	//   _शिका, ицю_, שעים_, bbed_
  { {0xdd8f0003,0x6d5e0031,0x80a20011,0x26cc0031}},	//   _قول_, épad, कुले, ódon_
  { {0xe53b000b,0xc05b002d,0x29050066,0xad1b0009}},	//   _בתאר, тін_, ěla_, _שודר
  { {0x28a70044,0x20090061,0x29050002,0x6d5602a0}},	//   _क्रि, _vrai_, śla_, enya
  { {0xdb7b000b,0xa3d40037,0x2d840d9b,0xd3370009}},	//   _שנוכ, सूस_, omme_, _דרגה_
  { {0xef190002,0x7bcd0d9c,0xc0cb096e,0x20090d9d}},	//   _duży_, trau, _руке_, _trai_
  { {0x44980015,0x2d8408b5,0x3cde0011,0x2bb80012}},	// [1910] рвую_, imme_, _गाने_, لالة_
  { {0x27340051,0x6d56010a,0x7bcd0d9e,0xdab90012}},	//   _täna_, anya, rrau, اهات_
  { {0xa2dd0044,0xa294002d,0x636b0052,0x40950012}},	//   _पाठ्, іаці, wüns, ملار
  { {0x7bc00010,0x301500fa,0x637d0007,0x27390025}},	//   ksmu, йдер, mène, _mène_
  { {0x98e40003,0x83870015,0xe6c50003,0xcfe90012}},	//   تكنو, _выве, متغي, افته_
  { {0xf549001a,0xb7670021,0x2d8f0d9f,0xcf440024}},	//   hất_, штей, _sige_, оній
  { {0x7bc20061,0xf1590014,0x91f40012,0xd7380009}},	//   _avou, _бивш_, _وأفا, שטות_
  { {0x28a7015f,0x1e580093,0xf658000b,0x067c000b}},	//   _क्लि, ישור_, יסוי_, כנול
  { {0x4034022a,0x63a90da0,0x2cad021b,0x637d0025}},	//   _детс, upen, rbed_, hène
  { {0x7de7007c,0xf5e7007c,0x7c2d003a,0xada40029}},	//   _відд, _відм, iyar, _spĺň
  { {0xa2d80044,0xe8d90020,0x22490001,0xc332000b}},	//   _मार्, _chữ_, упни_, פוט_
  { {0x7c950003,0x04950003,0x645e0002,0x9e760009}},	//   _الإص, _الإح, _śpie, _הגעה_
  { {0x6c85000a,0xd4960009,0xfc670048,0x6d4d0da1}},	//   _الشم, _הכנת_, _тъжн, diaa
  { {0xe4500003,0x39490da2,0xceb20009,0x6d500034}},	//   _تضم_, _emas_, ּין_, ądał
  { {0x5b7a0093,0xd5b10020,0x9f4b000e,0x442d0da3}},	//   _גרסא, ấp_, óját_, lye_
  { {0xe0da0046,0xad390024,0x66d10031,0x1543004c}},	//   _сви_, ачує_, tókü, песм
  { {0x6d5600c6,0x443f0052,0x442d00b6,0xd4690003}},	// [1920] rnya, nzu_, nye_, لحكم_
  { {0x8a3a0015,0x6c330012,0x6c550024,0x442d0060}},	//   ляет_, أفكا, іттє, iye_
  { {0x2d840da4,0xb4f90011,0x6d4d005e,0x7c2d020d}},	//   ymme_, ्याय_, biaa, ayar
  { {0x6d4d0070,0xf9690024,0x661a03bd,0xf77f0060}},	//   ciaa, арій_, ätku, rtçe_
  { {0x3eba002a,0x2912003a,0x2bba0003,0x7b01004a}},	//   _kept_, ıya_, _حاجة_, öytä
  { {0x443f0333,0xc7b3000b,0x29000da5,0xd6cf0012}},	//   dzu_, לבד_, žia_, فقه_
  { {0x7abb000b,0xddea0003,0xe7f40011,0xa3b00011}},	//   _תצלו, ارته_, _इनका_, टीई_
  { {0x7bc60010,0x5c980048,0x88c50012,0x3e830025}},	//   škum, шкия_, _وتقل, lété_
  { {0x251b000b,0x442d000e,0xfc4a0030,0x389b0009}},	//   רופא, gye_, blíž_, _תימנ
  { {0x7d040006,0xdced00eb,0x93fb0009,0x87250012}},	//   hdis, vlač, נליי, _وعلم
  { {0x69c10da6,0x99520066,0xb4c80037,0x7c2d0034}},	//   gsle, lář_, _ईयू_, _żart
  { {0xd257002d,0xf549001a,0xdced01e9,0x78a20042}},	//   сць_, uất_, tlač, ncov
  { {0xc867085b,0x6725004a,0x443f0002,0xad650003}},	//   стни, _pohj, czu_, _باله
  { {0xa857000b,0x00570009,0x88bd0034,0x78bd0035}},	//   מיכה_, משכת_, _nośn, sasv
  { {0x81a60003,0x8d770003,0xb2bb0009,0x99520030}},	//   _احتل, مارا, _גמור, hář_
  { {0xbd6b0015,0x5575002d,0xdced02a1,0x39490018}},	//   урге_, ігат, plač, _umas_
  { {0x24180015,0x68ed00b6,0x7bd600b6,0xac1801d4}},	// [1930] боты_, _ibad, guyu, боту_
  { {0x2b110037,0x6440001e,0x7d040da7,0xe3b00012}},	//   ़ाएँ_, izmi, adis, عرق_
  { {0x7c2d00c6,0x637d0054,0xd095003c,0x314b0009}},	//   syar, lènc, ошлы, ְתְּ
  { {0x27300020,0x26de0b45,0x82340012,0x7c2d0132}},	//   _hành_, _acto_, أركا, pyar
  { {0xa0690001,0x18690001,0xdb09005e,0xb9010011}},	//   јала_, јали_, tseü, _दा_
  { {0xc7d8000b,0x7a3f000e,0xe7360662,0x442d0060}},	//   מודי_, _játé, жеш_, vye_
  { {0x63ad0058,0xf7700003,0x0d850015,0x6569004a}},	//   lpan, راه_, олкн, toeh
  { {0xdce00039,0xbd450003,0xce38000b,0x6f010002}},	//   tomā, تنبي, מאות_, _walc
  { {0x753b000e,0xeb990001,0x63ad0da8,0xfaf50024}},	//   rhuz, јио_, npan, очню
  { {0x637d0054,0x2d9e0066,0xa1c50da9,0x0ee00011}},	//   dènc, ítek_, обод, _नायड
  { {0xf2d2000b,0x443f0002,0x61e50daa,0x5f1d0011}},	//   ועי_, szu_, nthl, मान्_
  { {0x208a0014,0x394f0052,0xa96a035c,0x69c10dab}},	//   ийни_, nigs_, рима_, rsle
  { {0x41c50037,0x637d0054,0xe76a0012,0x27300081}},	//   _विकस, gènc, لحسن_, _bành_
  { {0xdfcf0003,0x179a000b,0x69c10262,0x6b960009}},	//   ضيف_, יישב, psle, _וכסף_
  { {0x2730001a,0x41b50012,0x88bd0034,0x60c90dac}},	//   _dành_, _بمعر, _rośn, _odem
  { {0x2fcd012e,0x6cd60003,0x7d040dad,0x0d99003c}},	//   šega_, تقرا, udis, стры_
  { {0xccf20093,0x637d0054,0x78a201e9,0x8b260a32}},	// [1940] וכן_, cènc, vcov, одае
  { {0x60c902d1,0x636f0260,0xe3b70024,0x7bd60060}},	//   _adem, møns, юбу_, ruyu
  { {0x11d70012,0xf8bf0025,0x6370008e,0xdb0901e3}},	//   قولة_, ckés_, dänt, nseñ
  { {0xcb090093,0xbfaa0001,0x99520030,0x69c30dae}},	//   כל_, атке_, tář_, ânea
  { {0x98a30015,0xbc1a0024,0x38600060,0x65610031}},	//   фиче, _тіні_, çir_, élhe
  { {0x200d008b,0x60c9003a,0xfda60001,0x60090009}},	//   _drei_, _edem, ојим, מִצְ
  { {0x64490065,0x99520066,0xa3dc0011,0x64620034}},	//   _þeir, sář_, तंभ_, źwię
  { {0x6abc014d,0xe0d7002d,0x200d0daf,0xc6930009}},	//   _herf, _мвс_, _frei_, ואו_
  { {0x6abc0065,0x74140003,0x64400027,0x7bc40db0}},	//   _kerf, سودا, uzmi, nsiu
  { {0xba0a0014,0x78790009,0x128a0048,0x9a8a0048}},	//   ахме_, _הָעו, ищни_, ищна_
  { {0xba9b000b,0xa6a90003,0x9af7000b,0x329b0009}},	//   יסיי, _طالق_, חזיק_, יביד
  { {0xe8d90020,0x637d0054,0xe1670012,0x29040db1}},	//   _thử_, tènc, تدخي, _jama_
  { {0x74130012,0x87070048,0xb89a0030,0x2cbf0064}},	//   _يوما, ояве, _šťáv, _ľud_
  { {0x637d03eb,0x290400c6,0xcc770009,0xfe790030}},	//   rènc, _lama_, _ועדה_, řům_
  { {0xda6f002d,0xce940014,0x637d0054,0x454b002d}},	//   _ця_, даръ, sènc, ачам_
  { {0x5c9908b0,0x2905001e,0x29040db2,0xa6340024}},	//   ская_, ēlas_, _nama_, єнті
  { {0xdfdb0014,0x6370006f,0x6abc00b6,0xdb16008e}},	// [1950] _тъй_, jäns, _berf, ksyä
  { {0xd371000a,0xc7b2000b,0x501c000b,0xf549001a}},	//   رها_, _רבי_, _כוחו, hấp_
  { {0x78bb0108,0x6abc0989,0x7bc40db3,0x637008fb}},	//   _peuv, _derf, asiu, vänt
  { {0x26080011,0xc0cb004c,0x7af70db4,0xc9870681}},	//   हिरी_, руже_, sext, цузи
  { {0x251a000b,0x6370004a,0x78bb0025,0xb4c90011}},	//   _הורא, tänt, _veuv, ैली_
  { {0x7052000a,0xa858000b,0x200d000d,0x46a50014}},	//   عنوا, חידה_, _vrei_, чакв
  { {0x31c40001,0x67280027,0x99d40012,0x637401a0}},	//   _оств, _dodj, _يتفا, càni
  { {0x200d000d,0x365c0009,0xb65c0009,0xbdf80012}},	//   _trei_, יכונ, ידוש, ترها_
  { {0xdb090028,0x69bd0037,0x27ff005e,0xdb1b0018}},	//   fseð, वीनी, _usun_, ssuí
  { {0xeb9f0058,0x466b0db5,0x60dd0db6,0x4a450db7}},	//   _esøg_, _крем_, egsm, знов
  { {0xe8030044,0xce380003,0xa2dd0037,0x6aa50032}},	//   लिका_, _وأما_, पलब्, ichf
  { {0x6d4b0052,0xb6070010,0x6723017b,0x69c50db8}},	//   _umga, rašė, ljnj, ishe
  { {0x88bd0002,0x4c9a0009,0xc49a0009,0x17fa0012}},	//   _rośl, _הבנו, _השנת, حرجة_
  { {0x2d9c000f,0x539a000b,0x69c70027,0x395f0248}},	//   _évek_, _פיצו, _ovje, _ljus_
  { {0x6b9d008b,0xb2ba000b,0xa2ba0009,0x2aba0009}},	//   _ausg, _המצר, _המצט, _המצא
  { {0xe9a80003,0xccf90002,0x69c50db9,0xdb0d0060}},	//   _بدون_, neś_, dshe, asaü
  { {0xf993000b,0x7bc40010,0x68fb0051,0xc9850012}},	// [1960] _ארה_, usiu, õude, _تشوي
  { {0x7bc4007d,0x63740054,0x799c00b6,0x6370008e}},	//   rsiu, tàni, _purw, väns
  { {0xa2dd0044,0x27340163,0x6abc0732,0xa69b000b}},	//   _पार्, _länk_, _verf, _לשיפ
  { {0x2367001b,0x637401a0,0xdcfe0073,0x6abc016a}},	//   čnja_, ràni, _rupė, _werf
  { {0x29040027,0x67280dba,0x216706bd,0x29060dbb}},	//   _vama_, _podj, чици_, rdoa_
  { {0x63700163,0x4733002d,0x98890009,0x7d060060}},	//   räns, нніс, חָצֵ, _haks
  { {0x27e601d5,0x7d06083c,0xde930001,0xa3c60037}},	//   ston_, _kaks, нашњ, ैंक_
  { {0xda5b000b,0xc5f30009,0x20c90012,0xf8db0011}},	//   _הכלל, גדה_, _وبقي_, _भाइय
  { {0x69c70027,0xad1b000b,0xdbf80011,0x711b0009}},	//   _zvje, מוקר, ्टेड_, _פומפ
  { {0x883b0093,0x5a340014,0xbec2001e,0x44200054}},	//   _התמו, днот, šība, ixi_
  { {0x7643003e,0x6d950010,0x65870028,0xcb130009}},	//   czny, _išan, árhæ, גלת_
  { {0x44320006,0x395f0051,0xfe370009,0xc27b0009}},	//   kyy_, õus_, _מרבי_, מריי
  { {0x60dd0058,0xfc2f0012,0xcfa7003c,0x2fc60097}},	//   rgsm, _محو_, яшни, nsog_
  { {0x69c5004a,0x3da705cc,0x2c170009,0xa0370009}},	//   yshe, зраб, _מקדש_, לאכה_
  { {0x9e14002d,0x7afa0dbc,0x4b7b0009,0xaa57076b}},	//   ндрі, mett, _האגו, _нишу_
  { {0x3ebe0dbd,0x4a5b000b,0xda5b000b,0x60c20051}},	//   _lett_, _לדוו, _לכול, jaom
  { {0xd11a0037,0x69c70027,0x6d4a001a,0x0fdb0012}},	// [1970] धारण_, _svje, _đoá, _ابعث_
  { {0x2bd40037,0x883c000b,0x69da00f6,0x7afa0dbe}},	//   _दिना, _לתחו, oute, nett
  { {0xf9f90003,0x26c3009b,0x6aa50052,0xceb20009}},	//   تفاع_, majo_, rchf, _שיט_
  { {0x7afa0b0c,0x69da0051,0x26c3009b,0x6aa50032}},	//   hett, iute, lajo_, schf
  { {0xfc640014,0x394d009b,0x96c10011,0x7afa0dbf}},	//   _зърн, _vmes_, वरपॉ, kett
  { {0x7afa0dc0,0x8c1a0009,0xb9e70024,0xe29a0081}},	//   jett, _וושי, _ніби, _ngư_
  { {0x69c7001c,0x945d0002,0xb4d70037,0x69da0dc1}},	//   _uvje, kańc, _साफ़_, jute
  { {0xbe3c000b,0xa294002d,0x76430002,0x69da03bd}},	//   מעות, _часі, rzny, dute
  { {0x7afa01a2,0xb4ad0044,0x26c3009b,0x67d40dc2}},	//   fett, _कभी_, kajo_, _поту
  { {0x26c3012e,0x6fd20037,0x7afa0dc3,0x81c90593}},	//   jajo_, _सितं, gett, огов_
  { {0x26c3009b,0x2d9e0052,0xb6350012,0xc3320009}},	//   dajo_, _gute_, _تفاع, דוי_
  { {0x2734006f,0x6d400dc4,0x7afa079b,0x2d9c0031}},	//   _tänk_, chma, aett, _évei_
  { {0x7d060039,0x6b400163,0x307a0003,0xf8bf000e}},	//   _raks, _höge, تحدة_, rkép_
  { {0x7afa0dc5,0xdb0b006f,0x26c3009b,0xf456000b}},	//   cett, _avgö, gajo_, _קיסר_
  { {0x2d9e0108,0x4df5007c,0x7d060175,0x55e30021}},	//   ête_, нятт, _paks, корб
  { {0x4432004a,0x19ba0009,0xc1ba0009,0x2bd40011}},	//   tyy_, _ומקב, _ומקש, _दिमा
  { {0x26c30164,0xb9020037,0xd3720012,0x7d090dc6}},	// [1980] bajo_, दल_, نهر_, ides
  { {0x2b160037,0x7d09004a,0x32110066,0x753d000e}},	//   ताएँ_, hdes, _brzy_, _elsz
  { {0x00e6007c,0x3ebe0dc7,0x63510066,0x4432004a}},	//   джен, _rett_, měně, syy_
  { {0x3cf90037,0x3ebe0dc8,0x7afa0dc9,0x7d0600b0}},	//   ्यों_, _sett_, zett, _uaks
  { {0x07fa0003,0x48e30037,0x2d9e000d,0xa09b0009}},	//   تراع_, ट्टो_, _sute_, קיסט
  { {0x4375007c,0xeb9f038e,0xf1c00064,0x69da020d}},	//   _зуст, _prøv_, úšky_, yute
  { {0x68e40017,0x7d090227,0x7afa0dca,0x8a0307e8}},	//   _ocid, fdes, vett, _изре
  { {0x26c3009b,0x3ce00058,0x1d070001,0x69da019a}},	//   zajo_, ngiv_, дећи_, vute
  { {0x7afa0dcb,0x3ebe0dcc,0x14180012,0x671e0011}},	//   tett, _tett_, سيدة_, पादक_
  { {0x2004003a,0xcb670001,0xf7720003,0x7afa0b19}},	//   _ismi_, мање_, _شاء_, uett
  { {0x8f8b000b,0xcad7000b,0x2d9e0051,0x26c3009b}},	//   _וְאֵ, ווית_, _uute_, vajo_
  { {0x914b002d,0x7afa0dcd,0x7d7a0012,0xd257003c}},	//   ічна_, sett, _بمصر_, ьцы_
  { {0xb9070037,0x7afa0dce,0xf5370009,0x945d0034}},	//   _पा_, pett, _קנדי_, rańc
  { {0xab770003,0x637400c1,0x60c00dcf,0x2d8c0227}},	//   _قمنا_, tànu, _lemm, ïden_
  { {0x26c3012e,0xf2060014,0x254c0002,0xe5c40210}},	//   rajo_, _цяло, eśli_, ксто
  { {0x9d180014,0xab5d0002,0x60c00dd0,0x20040dd1}},	//   мост_, duży, _nemm, _osmi_
  { {0xc2cb0003,0xd0110012,0x88bc0009,0xa9680012}},	// [1990] قبال_, _إلخ_, _ומחז, _تميم_
  { {0x3211003e,0x7d0904d7,0xdb090018,0xdb0d0097}},	//   _przy_, zdes, mpeã, gsað
  { {0xe8d90020,0x7d090006,0xd2510003,0xe8070037}},	//   _chủ_, ydes, دنا_, शिका_
  { {0xdce4003a,0xd2570009,0x59df0011,0xeb9f00b0}},	//   mliğ, ושבה_, पंतर, _brøt_
  { {0xdce400a2,0xf4090003,0x7ac70c1e,0x7d090dd2}},	//   lliğ, _عيسى_, _осве, vdes
  { {0x26c1014a,0xaadd0037,0x670f0037,0x32110002}},	//   _jeho_, _माइक, ायिक_, _trzy_
  { {0xd5b1000a,0xdce400a2,0xd0d50014,0x60c00dd3}},	//   دفع_, nliğ, _повъ, _femm
  { {0xd5b10020,0x60c000c5,0x7d09004a,0x629c0002}},	//   ấy_, _gemm, udes, _zgro
  { {0x2d990dd4,0x47d50003,0x6d5a0061,0xe4a80009}},	//   _mise_, _سيار, étai, וֹתָ
  { {0xdce4003a,0x26c10029,0xeab10012,0x42250dd5}},	//   kliğ, _neho_, دعة_, едов
  { {0x9f8a0006,0x4ae20037,0x4439001e,0x78a402a1}},	//   töön_, _पासव, šs_, žive
  { {0xa06a0001,0xfe360009,0xcdb60009,0x186a01c6}},	//   зама_, _ארעי_, _נפנה_, зами_
  { {0x2c6c0030,0x98a40035,0x66050dd6,0x6aaa0dd7}},	//   _kódů_, _jomā_, _ashk, _ffff
  { {0x9f8a004a,0xdb090051,0xcc560009,0x2d990025}},	//   söön_, tseõ, _אבני_, _aise_
  { {0xa3e20037,0xe61701d4,0xd62a02ac,0xbb3a0009}},	//   नून_, ндр_, чове_, _מעסי
  { {0x6283001c,0xa1c20048,0x68e4004b,0x20040097}},	//   _izno, _сбъд, _ucid, æmis_
  { {0xb3860015,0xb7960001,0x4f960103,0x26010011}},	// [19a0] елал, _проћ, _проу, _वैसी_
  { {0xe8d90020,0x539a000b,0x60c0000e,0x661b0030}},	//   _phủ_, פיעו, _semm, ácký
  { {0xdebb000b,0xda1f0037,0xb6bb000b,0x599a000b}},	//   _ממיל, यमित_, _מציי, ִשְׁ
  { {0xe1ff003e,0x7bd50002,0xdb1d006f,0xdb0d0028}},	//   łów_, ązuj, _avsä, ssað
  { {0x7bcf0d85,0x213f0030,0x6d56016d,0x69c80031}},	//   ácul, _dluh_, miya, zsde
  { {0xe8d90020,0x2d99000d,0x629c0a35,0x657b016d}},	//   _thủ_, _zise_, _ugro, eluh
  { {0xceb30093,0x7a460061,0x6b630dd8,0x60c00dd9}},	//   ניה_, _mété, _скра, _temm
  { {0xe2970b05,0x7afe0dda,0x6d440018,0x6d560ddb}},	//   _час_, lept, nhia, niya
  { {0x1be70046,0xa3e70001,0xcd97000b,0xe3b20003}},	//   едњи_, едња_, עדפת_, درع_
  { {0xfd1f0020,0x39400ddc,0x6fb30012,0x3e860030}},	//   _nhìn_, _alis_, _إملا, _cítí_
  { {0xf41f0051,0x7f2b0009,0xd25a0048,0x6d44016d}},	//   äär_, _מֵאֶ, яци_, khia
  { {0xfc660098,0x224500a2,0x84660014,0x88bd0002}},	//   _пълн, _ülke_, _пъле, _dośw
  { {0x6d5600b6,0xd0060003,0x2d9900a5,0x54330012}},	//   diya, جل_, _rise_, _مرور
  { {0x8c1b000b,0xcf980001,0x69de0ddd,0xb9c60012}},	//   _מודי, ејс_, kupe, _كتبه
  { {0xe2130003,0x63a2004a,0x8f8b0009,0xa2bb0064}},	//   _مبيع, _huon, לְלֵ, äčše
  { {0xdce400a2,0x4a7b000b,0x26c1000e,0x8a7b000b}},	//   rliğ, _מרוב, óhoz_, _מאות
  { {0x28b40003,0x2d990dde,0x98170012,0x63a2008e}},	// [19b0] _صحيح, _vise_, _أبعا, _juon
  { {0xdce4003a,0x2d99002a,0x26cc000e,0x5f9500b5}},	//   pliğ, _wise_, ódot_, _шипт
  { {0xcad70093,0xda67000a,0x63a20006,0x32190012}},	//   תובת_, رائي, _luon, بياد_
  { {0xacbb0061,0x6d4406b5,0x7fd50024,0x41550048}},	//   _coût, chia, вікі, ъвес
  { {0xb4cd0037,0x63a2002c,0xf8b20009,0x33950012}},	//   रणी_, _nuon, ׁשׁ_, _للحز
  { {0xbec2001e,0x95c50012,0x25770060,0x7d0d0ddf}},	//   šīna, نيته, rçlu_, ldas
  { {0xfd110003,0xff180009,0xae140011,0xc3320009}},	//   لجة_, תקות_, डियन_, _דום_
  { {0x63a20de0,0x2d9903f7,0xacbb0025,0xfe700012}},	//   _buon, öse_, _goût, حده_
  { {0x2d8d00bd,0x2734006f,0xfc310012,0x59640048}},	//   rmee_, _känt_, شحة_, _съра
  { {0x7d0d004a,0x88bd0002,0x78ad01a0,0xd36e0012}},	//   hdas, _pośw, _afav, يهي_
  { {0xcb12000b,0x61460345,0xd9460de1,0xa96a0de2}},	//   בלי_, вена, вени, дина_
  { {0x7afe0052,0x9c390001,0x7db40003,0x45b60009}},	//   zept, _опет_, _إصلا, _יפעל_
  { {0x62830002,0x60c6003a,0x69de0de3,0xeb8e0de4}},	//   _wzno, rakm, zupe, _ви_
  { {0x41d10037,0x661a006f,0x75290864,0x7d0d07ea}},	//   _हिंस, åtko, ljez, edas
  { {0xc8b60015,0x752f0002,0x6d560de5,0x50b6096e}},	//   _испы, _bocz, tiya, _испу
  { {0xe8d90020,0xc56300de,0x32070032,0xdcf60073}},	//   _phụ_, акск, _isny_, plyč
  { {0x7d0b0101,0x7afe007d,0x64490052,0xf74a0012}},	// [19c0] _mags, tept, nzei, _يلبي_
  { {0x60c405df,0x6d560de6,0x4e7a0003,0x8c95002d}},	//   _heim, siya, _يحدد_, урсі
  { {0x64490052,0x3cea0037,0x7afe0de7,0x6d56020d}},	//   hzei, _छापे_, rept, piya
  { {0x7d0b0101,0x6c860003,0xe8d9001a,0xdfd20012}},	//   _nags, _للجم, _thụ_, ليص_
  { {0x87e30015,0x68e20de8,0xacbb0025,0xc0e301c6}},	//   ающе, rgod, _voût, рочк
  { {0x27340051,0xe72f0003,0xdbdb0097,0x75290031}},	//   _tänu_, قصى_, _ráðg, ejez
  { {0x24800039,0x63a200c1,0x64490052,0x2d9c000e}},	//   _šim_, _suon, ezei, _éves_
  { {0x90a50003,0x64490052,0xda4b0009,0x26c7020d}},	//   _محكم, fzei, _חֲמָ, aano_
  { {0x7d0b0de9,0xe8d7000b,0xbb74004c,0x6be30012}},	//   _dags, _שומר_, лгиј, لكيم
  { {0x63a20006,0x39460149,0xdced0027,0x7d0d000e}},	//   _vuon, lhos_, plać, zdas
  { {0x1b770003,0xf549001a,0x2bd40011,0xd3370009}},	//   خصية_, hấy_, _दिवा, דריה_
  { {0x39460149,0x51870001,0x96550048,0x0e570009}},	//   nhos_, ђуна, _съуч, _בשבט_
  { {0x1b2a0003,0x752f0002,0x934603e2,0xe53b0009}},	//   _يأتي_, _rocz, _инде, _קתדר
  { {0x53330001,0xec37000b,0xf0930009,0xee87003c}},	//   _вешт, _באדר_, ינר_, выбо
  { {0x752f003e,0x7e860013,0xa4d5007c,0xa3a80037}},	//   _pocz, _úspě, лові, _खंड_
  { {0x3544002d,0xc1790010,0x7d000ccd,0x90450012}},	//   ахув, rtės_, nems, _منعه
  { {0x24580047,0x7d0d00c6,0xc1790010,0x26c70dea}},	// [19d0] вать_, rdas, stės_, yano_
  { {0x16020044,0x7d1d000e,0x7cde000d,0xdf390012}},	//   लबार_, össz, tărâ, _أكدت_
  { {0x26c70deb,0xb9c40012,0x752f0034,0x995c0030}},	//   vano_, لقلي, _tocz, líř_
  { {0x26c7003e,0x28a70011,0xdce00030,0x09e40024}},	//   wano_, कुचि, romě, роїн
  { {0x69da0052,0x386901d7,0x7529001b,0x26c70dec}},	//   hrte, çar_, vjez, tano_
  { {0xa03c000b,0xaed20001,0x99d70012,0xda660012}},	//   ועדפ, бољш, _لترا, _هُ_
  { {0x7d0b0101,0x78a40ded,0xb062004a,0x15f50012}},	//   _pags, živa, _ääni, استح
  { {0xf3ff05ab,0x24090047,0x39460dee,0x7bcd001e}},	//   ção_, ении_, chos_, osau
  { {0xeb99035b,0xa1580001,0x91b0001a,0x69da0def}},	//   нии_, _рату_, _đảo_, erte
  { {0x6449008b,0x2b1c0044,0xe7300003,0x753b0066}},	//   rzei, नाएँ_, _وصل_, skuz
  { {0x64490df0,0x7d0b09c5,0x7ae50df1,0x2bc40011}},	//   szei, _tags, ight, लीबा
  { {0x4a42002d,0x6146003c,0x48e30024,0x4c150012}},	//   снюв, уема, боюв, _مبتس
  { {0xe5700012,0x44270012,0xed590030,0xfd1f0081}},	//   _بطل_, _جراف, miž_, _chìm_
  { {0xe8e00011,0x06760048,0xed59009e,0x26c509ef}},	//   _पञ्च, губя, liž_, _jelo_
  { {0x2009016d,0xad660012,0x39590df2,0x26c50df3}},	//   _esai_, هاره, biss_, _melo_
  { {0x41b20003,0xc27a000b,0x2cad0df4,0xf1b20009}},	//   _امير, _ארצי, nced_, _פסח_
  { {0xc953000b,0x7ff60003,0x61e10df5,0xf2da0012}},	// [19e0] _למה_, _إسبا, lull, فظات_
  { {0x909b000b,0xec7702e2,0x68e90017,0xaf060187}},	//   _אספק, упу_, _aced, _спол
  { {0x21200066,0x61e10df6,0x6fc10011,0xe0da05c6}},	//   _knih_, null, रीसू, еве_
  { {0x9fca0015,0x6b400028,0x2bd40037,0xa3a60012}},	//   егда_, _gögn, _दिला, _محسن
  { {0x6b9c001e,0xf7f30003,0xc7af0012,0x43860012}},	//   _tirg, مسود, كّن_, _ملحق
  { {0x26c504d2,0xd00f0012,0x1eaa0012,0x96f80048}},	//   _celo_, ثله_, راتي_, тект_
  { {0x21200027,0x7bdb004a,0x26c502a1,0xaa460048}},	//   _onih_, eruu, _delo_, _севл
  { {0x65640028,0x29020027,0x69da0066,0x1d340014}},	//   nnih, jeka_, vrte, рния
  { {0x69d50066,0xdd040010,0x7866064f,0xb8660003}},	//   ázen, ūrės, _сказ, _صارو
  { {0x25a50df7,0x57fb0009,0x69da0159,0x26c50713}},	//   _full_, _אלמו, trte, _gelo_
  { {0x0377000b,0x6576004a,0x87170009,0x5ce60012}},	//   רתית_, koyh, _תקבע_, _مكال
  { {0x26c5012e,0x63700052,0x64a60df8,0xd7e70024}},	//   _zelo_, gänz, _сада, ліго
  { {0xd0e60044,0x3f9e0010,0xdce9003a,0x54360003}},	//   _कारण_, _kitu_, lleğ, _حرار
  { {0xa294002d,0xb4cd0011,0x69da0159,0x92940451}},	//   _калі, रण्_, prte, _калц
  { {0x3f9e0051,0x63a60028,0x99ea0012,0x56950024}},	//   _mitu_, _aukn, _أعتق_, равт
  { {0x2d800df9,0x721b0009,0x867b0009,0x7bcd0dfa}},	//   glie_, _טווח, גרלו, tsau
  { {0x200900b6,0x26050011,0x5c99003c,0x13b40012}},	// [19f0] _usai_, _हैरी_, ткая_, مصلح
  { {0x7ae5002a,0x94740003,0xd4980dfb,0x6d5a0025}},	//   ught, صدقا, урс_, étar
  { {0xaadb000b,0x05790003,0x798d00b6,0x70b50003}},	//   תחבר, _لمدة_, _khaw, لماض
  { {0x7bcd03fc,0x11280014,0x481501de,0x82340012}},	//   psau, лючи_, имес, حركا
  { {0xf771000a,0x26c50149,0x25a501a2,0xf1050011}},	//   يات_, _pelo_, _sull_, _रसीद_
  { {0x3f9e0039,0x7bda000b,0xddc80010,0x45d505fb}},	//   _citu_, _בקשו, _dydž, ацит
  { {0x6b40008b,0xddc20063,0x65c202ad,0xed5900d9}},	//   _mögl, общи, обща, tiž_
  { {0x61e10006,0xd6580093,0x25a50054,0x6b400097}},	//   vull, טיות_, _vull_, _lögl
  { {0x2d53007d,0xa3e50037,0x2cad0dfc,0x442901a0}},	//   nţei_, बंध_, rced_, nxa_
  { {0x3f9e00b6,0xab350001,0x61e10dfd,0x44290521}},	//   _gitu_, рхиј, tull, ixa_
  { {0x2902017b,0x7bdb0269,0xcb120009,0x69260229}},	//   teka_, sruu, קלט_, амна
  { {0x273d0020,0xb33b003a,0xe8f7002d,0x60cb0dfe}},	//   _hình_, _suçl, алю_, nagm
  { {0x290200ec,0x22590034,0x88ba0009,0xb4db01a0}},	//   reka_, ńsk_, כזרי, _plàn
  { {0x61e1004a,0x6c840012,0x8f760024,0xd007004c}},	//   pull, _الهم, румі, јере_
  { {0x26ca012e,0x273d0020,0x3f84001e,0x6f0301e3}},	//   rabo_, _mình_, ēmu_, ienc
  { {0xdca30109,0x20560dff,0x6f030e00,0x6d490e01}},	//   жати, _втор, henc, nhea
  { {0x7c3b00b6,0xb97b0009,0xebe60024,0x717b0009}},	// [1a00] nyur, _בנקי, розп, _שנפס
  { {0xa03b0009,0xdcfb001b,0x224d0030,0xf746004c}},	//   _סעיפ, dluč, _řeka_, _ђено
  { {0x6edb000b,0x6b81006f,0xa3e50037,0x7edb0009}},	//   _בחיפ, illg, बूत_, _בקיצ
  { {0xd9460001,0x61460001,0x3f9e06db,0xc05a0024}},	//   једи, једа, _situ_, кіл_
  { {0x273d0020,0x4cbb000b,0x88bd0002,0x7d040723}},	//   _bình_, _בזכו, _pośr, meis
  { {0xed590029,0x69c30444,0x7d040e02,0x9f530024}},	//   ďže_, _owne, leis, овіч
  { {0x69d50066,0xbd6a0014,0x76a90024,0xad460357}},	//   ázel, крие_, утів_, ихик
  { {0x7d040006,0x6d490e03,0xc0e30e04,0x2fda0012}},	//   neis, ghea, _моск, _لورد_
  { {0xc34a0014,0x7cf1000e,0xdee605f7,0x6f030e05}},	//   вяне_, lóró, _вози, benc
  { {0x79820036,0x6370004a,0xef170024,0x7d040e06}},	//   llow, täny, _кму_, heis
  { {0x7d04050d,0x32180030,0x6d46008e,0x7e970012}},	//   keis, íry_, _olka, _ننكر_
  { {0x7d04004a,0x9257003c,0x6d490e07,0x5a330024}},	//   jeis, рают_, chea, інят
  { {0x386d003a,0x5f770012,0x2bdd0011,0x67220011}},	//   çer_, لاسر, _मिया, मांक_
  { {0xc058002d,0x6d460e08,0x1bfb000b,0xc43b000b}},	//   рію_, _alka, _סלוב, _בתדי
  { {0xd378001c,0x8b8b0009,0x7aef01bd,0x84c7004c}},	//   moć_, _בָהֶ, žitý, иљад
  { {0x929b0093,0xe29b000b,0x4a9b000b,0x44290054}},	//   _ביות, _בשור, _ביוג, txa_
  { {0xf8bf03eb,0x79460002,0x6d400070,0xdfd10003}},	// [1a10] mbé_, _wówc, ikma, _عيد_
  { {0x442903eb,0x6d460070,0xa87c000b,0x2d53004b}},	//   rxa_, _elka, _באחר, rţei_
  { {0x55590014,0x3f8300eb,0x92b40012,0x41e70024}},	//   _баня_, mlju_, تحقا, різа
  { {0x97c50003,0xae1a000b,0xd8b80012,0x79820034}},	//   مقصو, _עורכ, لدها_, glow
  { {0xa054002d,0xb8f20012,0x69de0e09,0x3f830412}},	//   овці, سكوب, arpe, olju_
  { {0xdc9a0009,0xd2460012,0xc5f50012,0x366904a5}},	//   _תישל, _فن_, مثبت, лало_
  { {0x60cb002c,0xed590a2c,0xd5e80012,0x6e440012}},	//   pagm, лок_, لعين_, ينهم
  { {0x7c290054,0x7bdf0e0a,0x9f5f0097,0xc5370009}},	//   txer, orqu, _eruð_, יָ֖ה_
  { {0x273d0020,0x7c3b0060,0x6d490e0b,0x2eb70011}},	//   _tình_, uyur, rhea, _अभूत
  { {0x6aa400a2,0x3b090001,0xf7850012,0x2bdd0011}},	//   _şifr, ћено_, _الطَ, _मिठा
  { {0x60c90e0c,0xdce9001b,0x27e90073,0xbe150012}},	//   _keem, sleđ, šinę_, _دواع
  { {0x64580002,0xcea90009,0xd12f0012,0xa3e20011}},	//   _ściś, _טי_, ّمَ_, नूँ_
  { {0x8d74000a,0x05740003,0x7d740003,0xd05a002d}},	//   _بالا, _بالد, _بالط, урні_
  { {0x7d04008b,0xf1a70037,0x60c9000e,0x8c1a000b}},	//   weis, गदान, _leem, _תוסי
  { {0x19b50003,0x78a9009b,0x7bdf0054,0xf8bf000e}},	//   _احتج, ževa, erqu, bbé_
  { {0x60c90070,0x3f8308ab,0x42360009,0x90c60148}},	//   _neem, alju_, _לנצל_, _убие
  { {0x44260149,0x3f830027,0x7d040e0d,0x6d580073}},	// [1a20] ão_, blju_, reis, _įvad
  { {0x291202d1,0x7d04015e,0x63bb0e0e,0x00570009}},	//   _haya_, seis, ipun, _לשפת_
  { {0x29120175,0x993a002d,0xe9da096e,0x88bd0034}},	//   _kaya_, ляду_, уке_, _pośp
  { {0xc693000b,0x291200b6,0x908a0012,0xf1b20009}},	//   _מאת_, _jaya_, هناك_, פסד_
  { {0x8ff7000a,0xdfcf0003,0x69d50066,0xe73a0e0f}},	//   مرور_, فين_, ázej, лед_
  { {0x78250003,0xa09b000b,0xceb30009,0x389b0009}},	//   تعمل, אינט, ֔יו_, איננ
  { {0xceb3007e,0xd6d9002d,0xa96a00f5,0x2dd70012}},	//   היו_, рті_, _бива_, مبية_
  { {0x93b40024,0xfc4608ca,0x7d1c0035,0xebd80b2b}},	//   обиц, šími_, ērso, адиш_
  { {0x63bb0e10,0x3cf70012,0xe56f0012,0xcbc60012}},	//   gpun, صعيد_, عطى_, حزبي
  { {0xaaba0044,0x51f8002d,0x68fb0b32,0x68ed06d5}},	//   ेरिक, аною_, _zbud, _scad
  { {0x8e860003,0x3f830027,0x7c240010,0x3f9b0025}},	//   _الاه, vlju_, _šird, ïque_
  { {0xa8990001,0x71470015,0xdd8f0012,0x000000c4}},	//   икну_, схож, _كول_,
  { {0x291200c6,0x04960003,0xdfc60012,0xf8bf0025}},	//   _daya_, _الشح, بي_, rbé_
  { {0xf8bf0031,0xec670009,0x000000c4,0x000000c4}},	//   sbé_, _ל֑וֹ_,   ,
  { {0xd5d80009,0x98b90035,0x637d01a0,0x99d30012}},	//   יַּש, aksā_, rènt, _فتيا
  { {0x52830003,0x29120e11,0x78a4001b,0xe16b0012}},	//   _عليك, _gaya_, živj, _حصته_
  { {0x99480003,0xfd4f001a,0x8335022a,0xe5340024}},	// [1a30] _دليل_, _khiế, онах, четь
  { {0x60c90e12,0x394900d9,0xe3c40012,0x02a70217}},	//   _seem, _hlas_, سْمَ, срам
  { {0xe5350015,0x8afc0002,0x27ff0e13,0x3ce900ad}},	//   _день, międ, _spun_, pgav_
  { {0x6f070034,0xb9250012,0x28f9003c,0x6b400097}},	//   lejc, تفصي, редь_, _lögh
  { {0x6aa9000d,0x88c80024,0x95160009,0x63bb0e14}},	//   _şefu, слів_, _וקרא_, xpun
  { {0x8afc0002,0x43940048,0x68fb0034,0xfd4f0081}},	//   nięd, _наяс, _wbud, _nhiế
  { {0x60c9035f,0xc5d5002d,0x39490717,0xaa5d0557}},	//   _teem, ціль, _olas_, _ревi
  { {0x2bd40044,0x63bb0e15,0x68fb0027,0x1c450024}},	//   _दिखा, tpun, _ubud, жним
  { {0x69da0163,0x291200c6,0x1425002d,0x6fe00037}},	//   _åter, _raya_, ідом, _नियं
  { {0xfd4f008a,0x291200ec,0x6d5e0061,0x98880009}},	//   _chiế, _saya_, épar, _הָעֵ
  { {0x6f070066,0x63bb0e16,0x6d4809d4,0x466b0048}},	//   dejc, spun, ūdai, _срам_
  { {0x6fe00037,0xdced0027,0x7c240027,0x78a900eb}},	//   _निमं, klađ, _šire, ževn
  { {0x29120164,0x224d0066,0x88f60009,0x8d740012}},	//   _vaya_, _řekl_, חזרו_, _عاما
  { {0x409a000b,0x39490017,0x65690e17,0x889a0009}},	//   יברס, _elas_, lneh, יברי
  { {0x0b780003,0xa3e50011,0x4536052c,0x9ae80009}},	//   _اصنع_, बूर_, охат, _הַפִ
  { {0x63a307f6,0x6d43000d,0x91b0001a,0x6283002c}},	//   _hinn, _înal, _đào_, _iyno
  { {0x63a30005,0xe577002d,0x5aca0109,0xd9970012}},	// [1a40] _kinn, ізу_, илам_, _بنيت_
  { {0x5db60012,0x261a0011,0x657b0064,0xf77f0018}},	//   _وإجر, _मछली_, houh, puça_
  { {0x0b170003,0x443f00b6,0x8afc0002,0x321c0004}},	//   تقلة_, hyu_, sięg, ívy_
  { {0x63a30176,0x6d4d0070,0x3a99003c,0xe3a70012}},	//   _linn, chaa, стую_, _ير_
  { {0xee020044,0x34a7002d,0x65690029,0xc9530009}},	//   लब्ध_, _євро_, dneh, ומא_
  { {0x501b000b,0xcdda0001,0x175404b3,0x6d440010}},	//   יונו, ањи_, явля, lkia
  { {0x7946003e,0x63ab0065,0x65690052,0xdce4017b}},	//   _równ, _augn, fneh, hnič
  { {0x6d44007a,0x628e048b,0x91030001,0xf8bf000e}},	//   nkia, _izbo, _опсе, njét_
  { {0x63a300bd,0xfd4f001a,0xddce0002,0x6d440010}},	//   _binn, _phiế, ódło, ikia
  { {0x60c20010,0xba540001,0x7d16004a,0xdce40e18}},	//   lbom, звој, hdys, dnič
  { {0x6d44004a,0x8f9b000b,0xdb0f000e,0x63a30802}},	//   kkia, _כימי, ödés, _dinn
  { {0x63a305df,0x8ba60148,0x3ce40011,0x443f020d}},	//   _einn, _дидж, गलों_, byu_
  { {0xfd4f0020,0xe0870012,0x299b0009,0x69d80030}},	//   _thiế, تجدي, יסטמ, ávej
  { {0xdb20004a,0x62660012,0x6d440073,0x3b070048}},	//   ätäm, _واثق, ekia, _мечо_
  { {0xcf57000b,0x26cc0017,0x4db80009,0xc5b80009}},	//   קבלת_, _medo_, מֶּנ, מֶּר
  { {0xdfd10012,0x2010008e,0x26cc0e19,0x63a30e1a}},	//   _كيب_, äliä_, _ledo_, _zinn
  { {0xb2ab0015,0x54550014,0x3172000e,0x6d4d0e1b}},	// [1a50] атеж_, чват, ézze_, rhaa
  { {0x2bdd0037,0xce950014,0x60c20033,0x60cd005e}},	//   _मिसा, _напъ, ebom, _heam
  { {0xa2ad015f,0x60cd00b6,0xc4c70012,0x5f740012}},	//   जशब्, _keam, _وتحو, _تاير
  { {0x7ff50003,0x6440004a,0xa1590001,0x89a80024}},	//   كستا, kymi, љаду_, іків_
  { {0x6fc60037,0x65690029,0xecb60009,0xf48402bb}},	//   रीलं, vneh, _מפרץ_, _журн
  { {0xdc3a000b,0x4c9a0009,0xc43a0009,0x2bc40011}},	//   _העשר, _לברו, _התשי, _लौटा
  { {0x65690e1c,0xa2a20011,0x86980048,0xc3320009}},	//   tneh, _कृप्, отът_, _אום_
  { {0xe5050012,0x70b50011,0x442d01a0,0x63a30e1d}},	//   سبعي, ंडोल, txe_, _sinn
  { {0x399b0333,0xb4bb0044,0x65690e1e,0x69dc000e}},	//   _jūsu_, _अभी_, rneh, áren
  { {0x399b0039,0xaacb0044,0x657b0066,0x6d930e1f}},	//   _mūsu_, िरिक, souh, lçad
  { {0x171a000b,0x6d440e20,0x63a30e21,0x60cd0e22}},	//   _לֵאמ, ykia, _vinn, _beam
  { {0x8dfa000b,0xdce40027,0xf9920003,0x6d930e23}},	//   _להעת, tnič, عبد_, nçad
  { {0x62830002,0xd40b0012,0x10160012,0xe81e0011}},	//   _wyno, _ختام_, أبجد, पिया_
  { {0x26cc0149,0x907a000b,0x20dc001a,0x61e80d1f}},	//   údo_, מטרי, ửi_, budl
  { {0xdce409ea,0x65c60014,0xd946096e,0xf8bf000e}},	//   snič, ябва, _неки, tjét_
  { {0x2a3a000b,0x7d090e24,0x89da000b,0xb33b0017}},	//   _לעצמ, nees, _החקי, _muçu
  { {0x6fb30012,0x945d0034,0x6d440e25,0x23e50557}},	// [1a60] _كميا, mańs, rkia, дієв
  { {0x7d090006,0x8eea002d,0x8afc0002,0x629a0042}},	//   hees, _умов_, mięc, _útok
  { {0x64400002,0x26cc0e26,0x7f3b0009,0x2f3b0009}},	//   zymi, _redo_, _העיו, _הגיד
  { {0x7d09008e,0xd1300012,0xfaf80035,0x33d60024}},	//   jees, ضمت_, lnīt_, _нігт
  { {0x2d82045d,0x8afc003e,0xc953000b,0xad1b000b}},	//   _ikke_, nięc, עמד_, _הוכר
  { {0x6d4b0005,0xc7d70009,0x6d930018,0xb33b0060}},	//   _alga, לוני_, açad, _buçu
  { {0x945d0002,0xb5aa0003,0xa91b0028,0x78ad080a}},	//   kańs, حاتك_, amþy, žava
  { {0xe5a30001,0x6da30001,0x945d0002,0x64400e27}},	//   нији, нија, jańs, tymi
  { {0x6fb60003,0x945d0034,0xd37a0048,0x7bd6016d}},	//   _رمضا, dańs, йчо_, nsyu
  { {0xcc57000b,0x49d8002d,0x2900000d,0xdc8b0009}},	//   פסיק_, одою_, _abia_, מְיָ
  { {0x60cd0005,0xc333000b,0xf1c3001a,0x22f70009}},	//   _peam, תות_, _nhớ_, הזין_
  { {0xf8cc0044,0x39460010,0xce050012,0x2fd90012}},	//   ारिय, nkos_, _تذكي, يوجد_
  { {0xb97b000b,0xb4e80011,0xc9530009,0xcc290012}},	//   מנטי, बली_, תמר_, _وأهم_
  { {0x90980014,0x4c9b0009,0xd7f80842,0x8beb00af}},	//   явят_, _הבדו, чую_, _הַה֗
  { {0x8afb000b,0xfe700003,0x12fb007e,0xb87b000e}},	//   _להגי, هدف_, _להגב, egít
  { {0x2d580047,0x6b400065,0xe8d90081,0x25bb00af}},	//   пись_, _mögu, _thự_, מצלמ
  { {0x6b400028,0xcf270003,0x6728001b,0x8afc0034}},	// [1a70] _lögu, _فردي, _ondj, cięc
  { {0x2aab0046,0x43740012,0xe9ff0081,0x722b0223}},	//   стао_, ّهْر, _hoại_, йцев_
  { {0x442b0020,0x7f3c000b,0x32b80003,0x2247000e}},	//   ̣c_, _לעזו, سدلة_, ánk_
  { {0x2bdd01e1,0xe298002d,0xa3b5002d,0xbcfb0164}},	//   _मिला, чає_, _обмі, _ejér
  { {0x29d80020,0xdb1b02d1,0x16a90015,0x6d930c56}},	//   hĩa_, spué, овли_, rçad
  { {0xe9ff0020,0x7d090070,0x69d800c1,0x40320001}},	//   _loại_, wees, _ovve, тељс
  { {0x7d090006,0x8afc0002,0x8e090024,0x32110034}},	//   tees, zięc, інив_, _uszy_
  { {0x6b400028,0xe3b90829,0x25de0011,0x9e640012}},	//   _dögu, оби_, _गिरी_, عاون
  { {0x46bf0037,0x656d002c,0x69d80e28,0x96bf0011}},	//   ्राह, inah, _avve, ्राउ
  { {0x99060037,0xaadd0037,0xdb030e29,0x7d090038}},	//   षज्ञ_, मणिक, _xinè, sees
  { {0xdb030066,0x63a70070,0x02b60009,0x66f20011}},	//   _jiné, _mijn, ולתך_, _घातक_
  { {0x2ec60037,0xe6c60037,0x69d80017,0xdce00010}},	//   वर्त, वर्ज, ávei, domė
  { {0x657c000e,0x5b350003,0xdb030025,0x945d0034}},	//   _írha, _يعتر, _liné, rańs
  { {0x4c9a000b,0x1ea90012,0x626500db,0x22680030}},	//   _ובנו, كافي_, _овла, átká_
  { {0x8afc003e,0x656d0052,0x945d0002,0x2aba0009}},	//   sięc, fnah, pańs, _ומצא
  { {0x19870014,0xa1870014,0x8afc0034,0x656d0e2a}},	//   _общи_, _обща_, pięc, gnah
  { {0x63a70070,0xf9930009,0x31600060,0x69c10e2b}},	// [1a80] _bijn, _ברה_, _imiz_, lple
  { {0x394d000d,0x656d002c,0xdb090164,0xe8410030}},	//   _ales_, anah, mpeó, ůběž
  { {0xceb30093,0x6b52014f,0xdb030c70,0xe2930009}},	//   _בית_, _lægg, _ciné, תְּ_
  { {0x39460010,0x78ad013a,0x76430034,0xceb90030}},	//   ukos_, žavn, dyny, ěře_
  { {0x6b400028,0xaac60012,0x41170012,0xb4db01a0}},	//   _sögu, _يتسن, بينج_, _clàu
  { {0x394d0149,0xd5ba011f,0x46140003,0xcfa90003}},	//   _eles_, оси_, فوتر, ساهم_
  { {0x53a70044,0xda650003,0x90e60003,0x7769032f}},	//   _कूटश, _كافي, _يسرن, éexi
  { {0x69c10070,0x63a70070,0xb4e80037,0xa2c60037}},	//   dple, _zijn, बले_, िरक्
  { {0xcd330003,0x6fb30012,0xa2a20011,0x0083004c}},	//   ضريب, _لمقا, _कृत्, _алто
  { {0x5a340014,0x628f0002,0x883b0009,0x25f60011}},	//   енот, ęcon, _ותמו, _एमपी_
  { {0x6b400163,0xcb13000b,0x6e460012,0x290b0e2c}},	//   _högs, דלת_, _تنام, teca_
  { {0x1c460001,0xdb1b0097,0x041a0012,0x3ea30031}},	//   _онем, ssuð, _ويضع_, _újta_
  { {0x6d43007d,0xfc2f0003,0x104b002d,0xb8d70011}},	//   _înai, _نحو_, іями_, _जल_
  { {0x290b013a,0x2bb50011,0x4034004c,0x0b180012}},	//   seca_, _अंबा, њерс, _رقبة_
  { {0x63a70834,0x656d0032,0x6b400097,0xd9f20011}},	//   _rijn, tnah, _lögs, _अमित_
  { {0x994400a2,0x61e506dd,0xa87b00ae,0x63a70a82}},	//   mış_, vrhl, _وحظر_, _sijn
  { {0x656d0052,0x1eab0003,0x78ad0051,0x9944003a}},	// [1a90] rnah, _وادي_, _igav, lış_
  { {0xa3e60044,0x1b780003,0x8c1b000b,0x656d0e2d}},	//   _बटन_, وصلة_, חומי, snah
  { {0x3992000f,0x27e60164,0x44220033,0x64b30066}},	//   lása_, eron_, _erk_, třič
  { {0xe4eb0003,0x7e9a0009,0x0e9a0009,0x63a70227}},	//   _بعده_, _מסתו, _משתל, _wijn
  { {0x80270003,0x3992000e,0x7d0d0e03,0xb8220011}},	//   برام, nása_, meas, मियम_
  { {0xf773000a,0x7d0d0e2e,0x9944003a,0x7643004a}},	//   خاص_, leas, kış_, tyny
  { {0x753d003e,0xce490015,0x27e60e2f,0xc1770012}},	//   _kosz, язке_, aron_, _قدرت
  { {0x929400bb,0x7d0d0e30,0x27e60e31,0x39920031}},	//   _расц, neas, bron_, kása_
  { {0xf8b2000b,0x9985000e,0x10140012,0x98140012}},	//   _תשמ_, _élő_, _لبلد, _لبلا
  { {0x3992000f,0xfeb80003,0x6b40006f,0xdb06000e}},	//   dása_, _قامت_, _högr, _kuká
  { {0x5999000b,0xc332000b,0x7c22000d,0xdcfb0066}},	//   ּשָׁ, אוי_, _eror, louč
  { {0x361a000b,0x753d0b8b,0x4abf0011,0xdc75003c}},	//   _מועד, _nosz, _श्रव, _пыль
  { {0x291e0066,0x2d800e32,0x84470012,0x61fa0132}},	//   ěta_, voie_, _تخال, attl
  { {0x7d1b0005,0x79460002,0xa856000b,0xb5aa0012}},	//   ldus, _mówi, גישה_, كارك_
  { {0xceb2000b,0x51f50003,0x2365006f,0xd5b20012}},	//   ריל_, _أستر, milj_, افر_
  { {0x7d1b0e33,0x6fe00037,0x3992000e,0xdb090164}},	//   ndus, _निलं, bása_, mpeñ
  { {0x753d0002,0x6d49004a,0x6b520040,0x032600db}},	// [1aa0] _dosz, ikea, _læge, ндан
  { {0xe2920003,0x7d1b004a,0xa2bb0037,0x6c830012}},	//   هذا_, hdus, शुल्, الْم
  { {0xb4db01a0,0xeef70009,0x6d49008e,0x9af30012}},	//   _clàs, _אמיר_, kkea, اكمت
  { {0x61e3000f,0x7d0d0e34,0x25f60011,0x6a950024}},	//   ánla, ceas, _एमबी_, трує
  { {0x14d7000b,0x5883003c,0xe7860198,0xfc320012}},	//   _אוכל_, лыша, нуко, _صحح_
  { {0x7bc40e35,0xab7a0012,0xf0930009,0x27e60b19}},	//   mpiu, _رمزا_, אנד_, rron_
  { {0x3992000f,0x3872000d,0x6b660061,0x6b810e36}},	//   zása_, _ţară_, _légè, dolg
  { {0x7c22080a,0x21a30001,0x88c50003,0x39ac0066}},	//   _pror, _бисм, _لتكل, _měst_
  { {0x6b81008b,0xb6030039,0x442003eb,0x60d7000b}},	//   folg, āšan, nvi_, _רומא_
  { {0x41e6002d,0x7d1b0051,0x9944003a,0xb7d70003}},	//   німа, adus, tış_, _أولا_
  { {0x44200005,0xf6290003,0xf7770009,0x8b570009}},	//   hvi_, _يسمى_, _טעמי_, גייס_
  { {0x3992000f,0x9944003a,0x44200027,0x6d46006f}},	//   tása_, rış_, kvi_, ökad
  { {0xe53b000b,0x7d0d000d,0xd4090012,0x3d190011}},	//   _מתאר, veas, _يتهم_, _मोटे_
  { {0x7d190002,0x3992000e,0xdca30001,0x23780012}},	//   _zaws, rása_, _сачи, _تمتد_
  { {0x753d003f,0xd5b1001a,0x831b000b,0xa4d5002d}},	//   _posz, ế_, _מוגז, кові
  { {0x2bb50037,0x69da0e37,0xdce00e38,0x39920031}},	//   _अंदा, mste, domī, pása_
  { {0xb97c000b,0xe7cf0037,0x69dc0624,0x7d0d0e39}},	// [1ab0] _מנהי, _सौंप, _avre, reas
  { {0xb4db01a0,0x69da0e3a,0x7d0d0e3b,0xa3e50011}},	//   _plàs, oste, seas, बूट_
  { {0x5ee8000b,0xdcfd001e,0x7d0d0038,0xeb910009}},	//   _אַרְ, _eksā, peas, בָא_
  { {0x6b81000f,0x7bdd0031,0xd4c70024,0x64c40bb7}},	//   zolg, ásuk, _ясоп, nčič
  { {0x69da0052,0x808b0012,0x12e70024,0x399e0030}},	//   hste, أضاف_, _півг, _růst_
  { {0x82370012,0x6f1a0e3c,0x23650248,0x3f830e3d}},	//   _كرزا, _catc, _ölj_, noju_
  { {0xc8f50098,0xceb4000b,0x69da0e3e,0x6b810e3f}},	//   _извъ, ניק_, jste, volg
  { {0x69da0e40,0x6db10035,0xab640060,0xad650012}},	//   dste, _jāai, rmüş, ضاعه
  { {0x6d490e41,0xeb9900de,0x290f0e42,0x69da0e43}},	//   rkea, мии_, mega_, este
  { {0x290f0e44,0x69da0e45,0x42250024,0x26d30478}},	//   lega_, fste, вдов, _nexo_
  { {0x2bd101e1,0x2d68003a,0x2fc003ce,0x69da0128}},	//   _दौरा, iğer_, _stig_, gste
  { {0x290f012e,0x8afc003e,0x50460001,0x44200010}},	//   nega_, wnęt, вемб, yvi_
  { {0xc8da000b,0x7d1c001e,0x50da0009,0x84440012}},	//   וקרט, ērst, וקרא, _مخول
  { {0x69da0e46,0xdf15007c,0x290f0e47,0x5f060048}},	//   bste, льсь, hega_, ъзга
  { {0x290f019d,0x9a240003,0x02190024,0xf77f0018}},	//   kega_, _معين, _ціль_, arço_
  { {0x290f0470,0x44200d6c,0xa2a20321,0x2d680060}},	//   jega_, tvi_, _कृष्, eğer_
  { {0x290f0005,0x8c430015,0x7bdb00ff,0xc4d20009}},	// [1ac0] dega_, аете, nsuu, יגן_
  { {0x7bdb004a,0x212d00b6,0x74130012,0x60090009}},	//   isuu, _aneh_, ؤولا, _נִפְ
  { {0xa9a60014,0xab5b0052,0xcb12000b,0x5d860012}},	//   вижд, _stüc, שלב_, _للدل
  { {0x290f0859,0xd7e60024,0xadd70009,0x106a003c}},	//   gega_, віко, _בוטח_, мией_
  { {0x6fb30003,0x39400061,0x212d009b,0xdfcf0003}},	//   لمنا, _mois_, _dneh_, قين_
  { {0xbcfb0013,0x69dc0039,0x39400573,0x6d930e48}},	//   _jmén, šrei, _lois_, nçan
  { {0x6f0300a2,0x67040044,0x3999000f,0xceb3000b}},	//   _önce, श्यक_, lése_, סיה_
  { {0x6f1a0a5f,0x4c94022a,0x9418003c,0x69da0e49}},	//   _watc, лийс, ежит_, vste
  { {0x3157000b,0xa5070001,0x3999000e,0x98a30df8}},	//   _סימן_, тења_, nése_, _вите
  { {0x69da0e4a,0x5fdc0011,0x4c9b0009,0xbb540012}},	//   tste, _बिजल, ושפע, اندب
  { {0x39400061,0x26d80010,0x28f9002d,0x995e0030}},	//   _bois_, daro_, нень_, _můž_
  { {0xbcfb0061,0x26d30e0a,0x69da0e4b,0x29e70097}},	//   _amén, _sexo_, rste, _síað_
  { {0x394002b1,0xdb030017,0x3f830071,0x69da0e4c}},	//   _dois_, _dinâ, toju_, sste
  { {0x20e3001a,0x3999000e,0xe6bf0037,0x7c650012}},	//   ổi_, dése_, ्रेज, _حامل
  { {0x39400108,0x7e440001,0x98c70001,0x3f420028}},	//   _fois_, ахте, _испл, _yður_
  { {0xb7d90012,0x8d740012,0xb063008e,0x2d840e4d}},	//   _كوبا_, لاقا, ääss, nome_
  { {0x290f0e4e,0x9da80048,0x5399003c,0x6d5e0025}},	// [1ad0] vega_, търа_, евая_, épay
  { {0x61e3000e,0x93fb000b,0xdca40001,0xa2d50012}},	//   ánlo, ולמי, рађи, ايات
  { {0x6d5c007a,0x290f0e4f,0x7c260052,0x2d840e50}},	//   _įran, tega_, _erkr, kome_
  { {0xe5350015,0x2d840010,0xdced001b,0x98e50012}},	//   _семь, jome_, onač, اكشو
  { {0x69c5002a,0x85960009,0xb4c10011,0x00e40024}},	//   sphe, _תדרג_, ुरी_, ржін
  { {0x7784007c,0x20d10020,0x290f0e51,0xf412000b}},	//   аліз, ại_, sega_, _הפך_
  { {0x6234002d,0x64460033,0xfd110003,0x81d40015}},	//   _керу, økin, مجة_, _восх
  { {0xdb0d02d1,0x2d8d004a,0x6d4d0e52,0x02bd0011}},	//   mpañ, ulee_, nkaa, ोर्न
  { {0xfc310003,0x39400061,0x6b520097,0x26d8020d}},	//   صحة_, _rois_, _hæga, yaro_
  { {0x8fa40001,0xdced0027,0x7c840001,0x7d1d0e53}},	//   _вађе, dnač, јуће, _lass
  { {0x6d4d0006,0x3999000f,0xe6590003,0x39400e54}},	//   kkaa, zése_, _ثلاث_, _pois_
  { {0x2d840036,0x7bdb008e,0x7bc10030,0x6d4d0b8f}},	//   come_, psuu, _člun, jkaa
  { {0xeb8e0098,0xd9e00044,0x2bdd0037,0x39400061}},	//   _ги_, _पट्ट, _मिटा, _vois_
  { {0x224c0031,0x7d1d020d,0x39990031,0x65690e55}},	//   ökké_, _aass, vése_, lieh
  { {0xd3360093,0xb4c10037,0x8db5002d,0xb0630051}},	//   _תרצה_, ुरू_, исті, äärs
  { {0x39990272,0x291e0039,0x23b50037,0x6d4d002c}},	//   tése_, ētas_, _अंशद, gkaa
  { {0xdce00039,0xb8f80037,0xb4e40037,0x7d1d0e56}},	// [1ae0] nimā, िर_, _नयी_, _dass
  { {0x3999000e,0x46f6005c,0x65690052,0xa263001a}},	//   rése_, _счит, hieh, _tuổ
  { {0x3999000f,0xeb970001,0x1efb000b,0x60ea0048}},	//   sése_, ћих_, _אליע, емем_
  { {0x39400065,0x3ce20011,0xfd120012,0xdb090018}},	//   ðis_, _गयें_, _اجد_, mpeõ
  { {0x6f1e0272,0x48e30014,0x2d8404cf,0x61fe0e57}},	//   _kapc, сочв, vome_, stpl
  { {0xe7370014,0xa773002d,0x6df40003,0x8c2b0009}},	//   леч_, бліч, لكتا, _אֵלֵ
  { {0x5fe00037,0x29d1009b,0x7c2402d2,0x62830034}},	//   _निकल, jša_, lvir, żnor
  { {0x44260e58,0x74140003,0xb7d60012,0xf6530009}},	//   _pro_, لوبا, _مقرب, מצו_
  { {0x38560014,0x136a0345,0x9b6a00f5,0x69c30071}},	//   _съвс, ешни_, ешна_, _atne
  { {0xa3e50044,0x07a60046,0xbcfb0108,0xdd04003a}},	//   _फिर_, _сазн, _amél, ırıy
  { {0xe1350047,0x19590015,0x65690029,0x69350015}},	//   анны, ваны_, bieh, анну
  { {0x65690026,0x69de00c1,0x44260e59,0xdbd1005e}},	//   cieh, ispe, _مرتف, _püüe
  { {0x64460051,0xf7730003,0x4426009b,0xdce00035}},	//   äkid, ماس_, _uro_, cimā
  { {0x2b8f008b,0x1bf70009,0x8c1b0009,0x2bf70009}},	//   rück_, _עצור_, _נווי, _עמון_
  { {0xb2bb000b,0xe5c40014,0x3abb000b,0xadd50001}},	//   _אמור, йсто, _אמונ, робљ
  { {0x60d60065,0x7c240065,0x6298080a,0x6d4d004a}},	//   _geym, fvir, _izvo, ukaa
  { {0x24580015,0x1d640012,0x53a50012,0x7afd001b}},	// [1af0] гать_, حدَّ, لمرك, đstv
  { {0x6569008b,0x7d1d0e5a,0x2b990061,0x45d5004c}},	//   zieh, _wass, pèce_, _коос
  { {0xc2c40003,0x6db1001e,0x7d1d0e5b,0xdce40034}},	//   صيني, _jāat, _tass, hnię
  { {0xdce4003e,0xf8bf0061,0xdd860003,0x2a980012}},	//   knię, ncé_, _ذو_, ائكة_
  { {0x6d9308bf,0xdb0d0bce,0xc9780009,0x69de0e5c}},	//   nçam, spañ, נגדי_, aspe
  { {0x6d580010,0xb8ec0037,0x99d70012,0xddc50024}},	//   _įvai, _श्_, _مترا, абки
  { {0xf8c90061,0x93c6000d,0x05550048,0xeef80009}},	//   _créé_, rtăş, ития, אמור_
  { {0x15450015,0xf1a404ba,0xdce40034,0xdce00035}},	//   реим, _грун, fnię, timā
  { {0x3201002a,0xc9520009,0x1c42003c,0x6e280032}},	//   lthy_, _ומן_, жным, _erdb
  { {0x3b090001,0x33650021,0xe7870129,0x7bdf0e5d}},	//   њено_, рвог, _субо, isqu
  { {0xdce0001e,0x291f0051,0x069b0012,0x46150012}},	//   simā, _kaua_, _أخذت_, _خوار
  { {0xb4e40044,0xfe70000a,0xa96a0a25,0xc4f80003}},	//   _नये_, _عدل_, тима_, _معها_
  { {0xb4c30044,0xc916000b,0x61e3000e,0x6d93003a}},	//   ्री_, בחרת_, ánlj, rçal
  { {0x2d8b0066,0xfaa50264,0x6446008e,0xab5b0032}},	//   _akce_, _кало, äkie, _stün
  { {0x59760015,0x60d60028,0x6d930054,0x8afc0002}},	//   _выпу, _teym, pçal, zięk
  { {0x7c240e5e,0xda7a007e,0xc27a000b,0x2c090037}},	//   tvir, _שנקר, _ברצי, _वहां_
  { {0x7d040028,0x25a50054,0xdee60e5f,0x3ab6004c}},	// [1b00] rfis, ïlla_, _копи, аљет
  { {0x3fdb000b,0xb7db000b,0x9e660109,0x7c240e60}},	//   _שקיב, _שקיי, _ввод, rvir
  { {0xbd8a0003,0x2be20037,0x8afc0002,0x11d70012}},	//   _لندن_, _पिका, więk, لولة_
  { {0x6d43007d,0x929a000b,0xb4db001a,0x48c3004c}},	//   _înap, דיעת, _hoàn, ољша
  { {0x628e003e,0xb6a30081,0xdb0d0097,0xdb0f004b}},	//   _wybo, huẩ, ppað, _ducâ
  { {0x35e60001,0x69de0248,0x69c30030,0x61eb0060}},	//   ацив, pspe, ínec, ümlü
  { {0x09e3004c,0x65c3004c,0x4367076b,0xe9d70048}},	//   _морн, обја, _тарн_, _вкс_
  { {0xa5340046,0x27e90039,0x1d340048,0x22470032}},	//   снич, šana_, сния, änke_
  { {0xef1a0ac5,0xf8bf0061,0x93460003,0x9c370014}},	//   _има_, ndée_, لخدم, ипът_
  { {0xd00f000a,0xda26002d,0x316b0e61,0xbb830012}},	//   _تلك_, аємо, wicz_, يليي
  { {0xd2b7000b,0x71670012,0xd2500012,0x8ab70009}},	//   ילית_, لاحك, سنح_, יהיו_
  { {0xed590066,0xdb1b0061,0x26dc0a05,0x8c480060}},	//   chž_, nquê, lavo_, _kağı
  { {0xb4d20044,0xf8bf0d65,0x64a6035c,0xca6b0024}},	//   वरी_, rcé_, _тада, дiлi
  { {0x6d930017,0x5bc30012,0x26dc0e62,0xe7870e63}},	//   rçam, _بقول, navo_, румо
  { {0x139b000b,0x539b000b,0xdcfb003a,0xc1790010}},	//   _שבוע, _שיוו, nluğ, urės_
  { {0x48670014,0x0657000b,0x39440c23,0xdd910012}},	//   _въоб, בילך_, _noms_, سوء_
  { {0x96270039,0x3f87003a,0xe97c0009,0x99480012}},	// [1b10] _saņē, yonu_, _שנחש, _خليل_
  { {0x7bdf0108,0x26dc012e,0x2ef50df8,0xdcfb0060}},	//   rsqu, javo_, _узор, kluğ
  { {0x49b80003,0xd1b80003,0x26dc0010,0xaab40024}},	//   لاند_, لانا_, davo_, ійці
  { {0x8c48003a,0xc1040003,0x58d90024,0xc1050012}},	//   _bağı, قومي, уддя_, صوتي
  { {0xf536000b,0xc1040012,0x9be40024,0x656d0e64}},	//   _הנרי_, توني, _мірк, miah
  { {0x8c4800a2,0x20e7001a,0x442b0cea,0x6f640024}},	//   _dağı, ối_, _irc_, овіз
  { {0xcf58000b,0x57580009,0x6b520040,0x60dd0e65}},	//   שבות_, שבוע_, _mægl, kasm
  { {0x7415000a,0xe678000b,0x387e000d,0x5e78000b}},	//   موعا, יתוח_, ştri_, יתון_
  { {0x69c70027,0xb3450018,0x2120016d,0x26dc0e66}},	//   _htje, _noçã, _raih_, bavo_
  { {0xda0e0037,0x4374002d,0xdce0000d,0x798d002c}},	//   _सहमत_, жуют, timă, _akaw
  { {0xe695000a,0x3992000f,0x5e950003,0x72190009}},	//   _الاد, lási_, _الاط, נוֹח
  { {0xf6520093,0x7bc90e67,0x04c90012,0xe8f70055}},	//   _מצב_, ppeu, _صوتي_, блю_
  { {0xe81b0037,0x17fa0003,0x2bbb0012,0xa4b60009}},	//   _पैदा_, درجة_, _شاشة_, _הלנה_
  { {0x200201ae,0x889a0009,0x7c940012,0x8f760024}},	//   rtki_, טברי, _بشما, сумі
  { {0xceb2015a,0x75d60003,0xa6e30028,0x2002053b}},	//   לים_, إيرا, íðar, stki_
  { {0x26dc0e68,0xc212000b,0xba740012,0x39920e69}},	//   zavo_, _זהה_, _باهت, kási_
  { {0x0ab60003,0xdcfb0060,0xdca30024,0x39570009}},	// [1b20] محاد, zluğ, зати, _לשקם_
  { {0xef1a0046,0xb05b0163,0x39440070,0x3992000e}},	//   _смо_, rbät, _soms_, dási_
  { {0x26dc0010,0xf1fa0012,0x8c480060,0x636b0034}},	//   vavo_, طعات_, _sağı, ażno
  { {0x00da000a,0x9fe60003,0x24f60024,0xb4c30011}},	//   ابات_, مسته, _учор, ्रो_
  { {0xdb0e0e6a,0xdb1b0018,0x81bc0035,0x2be20011}},	//   _libé, rquê, evēl, _पिटा
  { {0xa09b000b,0x66e30001,0x501b0009,0xe2aa0012}},	//   ניסט, поља, טונו, _مازن_
  { {0x67210416,0x26dc0e6b,0xe737004c,0x6dbc0064}},	//   _dalj, ravo_, сеј_, _očam
  { {0x6d460006,0x39b7000d,0x75240e6c,0xfe6f0012}},	//   _joka, _găsi_, ndiz, عدو_
  { {0x6d460010,0xe043004c,0xdce00073,0x3f8a001b}},	//   _moka, _енти, jimą, kobu_
  { {0x8c1b0093,0x69c10108,0x60c20e6d,0x88570009}},	//   נויי, _élec, lcom, _השמע_
  { {0xd9150015,0x6d5a001e,0x7c2b0052,0x6115003c}},	//   одны, ītaj, _ergr, одну
  { {0xf53f006f,0xd7fb027f,0x27e00e6e,0xfe370009}},	//   _ihåg_, луг_, šinu_, _לרבי_
  { {0xbfb60020,0xc058002d,0x7d16003a,0xa98b0009}},	//   _điểm_, бір_, deys, רָיִ
  { {0x93fb000b,0xac970003,0xc058002d,0x4aba003c}},	//   _עלוי, _انها_, сію_, _судя_
  { {0x3992000f,0x6f150164,0x656d0029,0xef110009}},	//   zási_, rezc, tiah, וּן_
  { {0x6db1001e,0xb5980003,0xea770009,0x2d980012}},	//   _jāap, مَّا_, _לגור_, مَّد_
  { {0x81bc0039,0xc1740093,0x6d9301f2,0x7ff70003}},	// [1b30] zvēl, _מחק_, nçai, _اسعا
  { {0x656d0026,0xfbd00012,0xcaf40012,0x98880009}},	//   siah, عتق_, كسمب, _לָתֵ
  { {0xfbda0037,0x50b50695,0x82150012,0xf1c80012}},	//   _मौसम, ослу, تواص, مولى_
  { {0x6d460006,0x3992000f,0x75220029,0x9105002d}},	//   ökal, tási_, _naoz, іпле
  { {0x672100b9,0xd91c000b,0xa2d50012,0xf745003c}},	//   _palj, טואל, _ويحت, жело
  { {0x3992000e,0xec36000b,0xf41f008e,0x81bc0035}},	//   rási_, _ואשר_, _isä_, tvēl
  { {0x69c70027,0xe81b0037,0x67210e6f,0x96fc0009}},	//   _utje, _पैसा_, _valj, אלות
  { {0xdd910003,0xd658000b,0x6b520097,0x60c20e70}},	//   بوع_, מיות_, _nægj, ccom
  { {0xe3b600e3,0x6b40000e,0x764e0002,0xb8df0037}},	//   обы_, _rögz, zyby, ूँ_
  { {0x98ad0029,0x8c1c0009,0x75240060,0xdce90073}},	//   _hneď_, רוזי, zdiz, mieč
  { {0x442900ff,0xdce90e71,0xc3340009,0x9e750012}},	//   hva_, lieč, לוץ_, _بهات
  { {0xdb03008e,0x46580012,0xa2f70011,0x44290e72}},	//   _sinä, _اؤكد_, ुभुज_, kva_
  { {0x7d16008e,0x3ea90030,0xdce90073,0xb4270012}},	//   veys, žitě_, nieč, _دعاو
  { {0xbf9b0017,0x83fd000e,0x20ea001a,0x44290e73}},	//   stên, rződ, ời_, dva_
  { {0x7d160006,0x657a0025,0x44290e74,0xdce00073}},	//   teys, étho, eva_, simą
  { {0xdce90010,0x7c290e75,0x27ed0e76,0x442909ee}},	//   kieč, over, šena_, fva_
  { {0x0b460594,0xceb60003,0xdce90010,0xf9930009}},	// [1b40] онан, _وحدث, jieč, _קרח_
  { {0xb2960046,0x6be80009,0x752400b8,0x6d460034}},	//   ојећ, מַעַ, sdiz, _woka
  { {0x32050036,0x8afc003e,0xe8220037,0xc8ca0012}},	//   ntly_, mięt, मिका_, لوان_
  { {0x7c290c16,0x629c0a47,0xc3290009,0x22470248}},	//   kver, _vzro, כו_, änka_
  { {0xb4d60037,0x88160003,0x629c0002,0x6dbc0029}},	//   हरी_, تباط, _wzro, _očak
  { {0x8afc003e,0xe3a7000a,0x7c290e77,0x6d590087}},	//   nięt, _زر_, dver, _alwa
  { {0xd6d900bc,0xd5b70047,0xda0e0037,0x629c0027}},	//   сті_, осы_, _सहित_, _uzro
  { {0xd1320003,0xceb30009,0xb5aa0012,0x6da3004c}},	//   _تمر_, ויו_, جاتك_, мија
  { {0x8b660003,0xd37a0472,0x32050132,0x83fd0031}},	//   قادم, ичо_, etly_, ezőb
  { {0x3f76003e,0x501b000b,0xc7b9000e,0xa3dc0011}},	//   dług_, _דומו, _erős_, णीय_
  { {0x2b470108,0x7abb0009,0x3abb0009,0x2b940032}},	//   _donc_, יציו, ימינ, räch_
  { {0xa9c3007c,0x81bc0039,0x2c830010,0xb4b90037}},	//   ьськ, lvēk, _būdą_, _चले_
  { {0x3205002a,0x20060e78,0x6c7600ae,0xc7f80557}},	//   atly_, ntoi_, _بطائ, оняє_
  { {0xdfd00012,0x46e8003c,0x8afc0034,0x6d930521}},	//   ئيّ_, ждён_, gięt, nçav
  { {0xd250000a,0x32050036,0xb4d60011,0xf41f008e}},	//   _سنة_, ctly_, हरू_, _ssä_
  { {0x6ecb0044,0x865b0009,0xd1310012,0xb87b0018}},	//   _त्रु, בדלי, _أمة_, raíb
  { {0x4c940015,0x351b000b,0x69080009,0xd7fb0048}},	// [1b50] дитс, סומנ, _וּתְ, _туй_
  { {0x8afc0002,0xdce90073,0x60db016d,0x5b14003c}},	//   cięt, vieč, _seum, ммут
  { {0x7bcd039c,0xa2dc0037,0xdb0e000e,0x99870066}},	//   spau, _फ़र्, óján, ínů_
  { {0xdb0b006f,0x7bcd004a,0xdb1b0e79,0xa3b60011}},	//   _utgö, ppau, rqué, _चूक_
  { {0x67250005,0xdd3a000b,0x5d3a000b,0x3d3a000b}},	//   _kahj, _הערכ, _התרא, _הגרס
  { {0x3992000e,0x70b70037,0xfbd2000b,0xa81c0009}},	//   lást_, ःशुल, _אתך_, שֵׁי
  { {0xf7740009,0x63bd0e7a,0xdce90073,0x64460e7b}},	//   וקס_, _husn, sieč, äkin
  { {0x25a90052,0x1c45002d,0x6725019a,0x867c0009}},	//   nmal_, зним, _lahj, ירוו
  { {0xc1040003,0x29190054,0xc5680003,0xf3f10003}},	//   _توقي, desa_, تحول_, رأة_
  { {0x25a90052,0x6d5a001e,0xa0880009,0xdce40060}},	//   hmal_, ītai, _וְעִ, kniğ
  { {0x39490017,0x29190e7c,0x83640012,0x95570012}},	//   _boas_, fesa_, بديل, _وخصا
  { {0x3205002a,0xd24e0003,0xa5c60028,0x9f4205b1}},	//   rtly_, انَ_, slóð, mské_
  { {0x9f420e7d,0x3992000e,0x3205027b,0xbd9a0009}},	//   lské_, dást_, stly_, _פסנת
  { {0x80cc0011,0x32050132,0xf7560012,0x2c1905f3}},	//   _थ्रे, ptly_, أنسج, _नैइं_
  { {0x63bd0052,0x6da602e2,0x8f9a000b,0x3f760002}},	//   _ausn, зива, מישי, sług_
  { {0x3cf60037,0xf8b9001a,0xb4d60037,0xf9920012}},	//   इलें_, _ngũ_, हरे_, _ثبت_
  { {0x29c10020,0x60fb000b,0xfbd10012,0x81a50012}},	// [1b60] _hóa_, _ההפק, َتْ_, _تحول
  { {0x8b230015,0x9479002d,0xed160034,0x25a90e7e}},	//   ндуе, істу_, _łódź_, amal_
  { {0xdebb000b,0xb6bb000b,0x3d1c0037,0x3ebb000b}},	//   _למיל, _לציי, _मसले_, _לציב
  { {0x7ae1008b,0x2d800029,0xf969002d,0xf9920012}},	//   halt, čiek_, орій_, ربا_
  { {0x28cb0011,0xa4b70009,0x9f420030,0x7ae10e7f}},	//   ाड़ि, _מלכה_, eské_, kalt
  { {0xbb4a000a,0x2006004a,0x7ae1004a,0xc49b0009}},	//   _الآن_, rtoi_, jalt, _לשכת
  { {0x6b520028,0x20060e80,0x7e2a0024,0x657b0097}},	//   _nægi, stoi_, сіла_, fnuh
  { {0x6360000f,0xceb3000b,0x7cf6003a,0x6d440e81}},	//   _böng, עיה_, dürü, njia
  { {0x9f59009f,0xdc3a0024,0x7ae10e82,0x6eb60012}},	//   ltså_, ицiї_, falt, _فصائ
  { {0x3992000e,0x6360003a,0xba540001,0xd8770012}},	//   zást_, _döng, двој, _عملت_
  { {0x44270020,0xc333000b,0x442f0070,0xa3dc0037}},	//   ̉n_, גות_, _erg_, णीत_
  { {0x55bb000b,0x7ae100ff,0x1e570009,0x3cf60011}},	//   _המאו, aalt, _משבר_, इलों_
  { {0xbd430003,0xc9530009,0xc0580024,0x45430012}},	//   _سنوي, גמר_, пір_, _سنوق
  { {0x27e601da,0x2327003c,0xbf9b0025,0xbb4305c8}},	//   ison_, _ночи_, ptêm, _печк
  { {0x3992000f,0x44220e83,0x639b0009,0x9aeb0009}},	//   tást_, _ask_, _הסגנ, _הַחִ
  { {0x69fb000b,0x63600028,0x8a7b000b,0x26de04d2}},	//   _הלהק, _lönd, _לאות, _leto_
  { {0x18680001,0x3992000e,0x68ed0e84,0x61fa0e85}},	// [1b70] _наћи_, rást_, _idad, lutl
  { {0x7b770003,0x32130002,0x6d5600b6,0xfaa70594}},	//   أطرا, łbyś_, akya, пшен
  { {0x29c10020,0x98bf007d,0x2b0e0011,0xaa190012}},	//   _xóa_, _nouă_, त्यु_, تياط_
  { {0xe1f00003,0xdb060052,0x9f4200d9,0x7ae10e86}},	//   اسل_, _zukü, vské_, zalt
  { {0xea000020,0x7b02004a,0x63600248,0x7ae10077}},	//   _tiếp_, äytö, _bönd, yalt
  { {0x9f4200d9,0x7c2d0e87,0xbae50012,0xdc3a0009}},	//   tské_, mvar, _زكري, _ועשר
  { {0xe7080003,0xa3df0037,0x7ae1004a,0x63600457}},	//   ستون_, धीन_, valt, _dönd
  { {0x98bf007d,0xe7ee0037,0x27e9006f,0x30150001}},	//   _două_, _जिला_, _ovan_, _одбр
  { {0xbcfb000e,0x7d1a0009,0xf5920012,0x3af50223}},	//   _elég, חֵיה, خليج, мянс
  { {0x636000a1,0x9f420066,0x7cf6003a,0xc43c0009}},	//   _gönd, pské_, türü, מתחי
  { {0x6d5d003a,0x7c2d005e,0x98700064,0x425405d8}},	//   _olsa, hvar, rúča_, етят
  { {0x442f02a1,0x29e7001b,0x2d680060,0x7cf60060}},	//   _trg_, rđa_, nşet_, rürü
  { {0xcfaa0012,0x63600060,0x995c068c,0x7d1b0e88}},	//   قاسم_, _yönd, níš_, meus
  { {0xdfcf0003,0x03d6000b,0x26de0029,0xb3ba0009}},	//   شيف_, _חוסם_, úto_, _ומסכ
  { {0xab280003,0x7d0d0052,0x490e0011,0x79750034}},	//   _رسول_, ffas, ण्डो_, nąws
  { {0x75290e89,0xe5a30e8a,0x99f60009,0x6d4b0e8b}},	//   ndez, виси, _חזקה_, _joga
  { {0x9f5f0e8c,0x9f520028,0x6d4b0e8d,0x71250012}},	// [1b80] _aquí_, ðbót_, _moga, _سريل
  { {0xeb9f0033,0x0aea0024,0xda660012,0xeab20012}},	//   _spør_, ідей_, واضي, نعا_
  { {0x0f57000b,0xc7b3000b,0x9757000b,0x7d1b004a}},	//   _חיים_, _שבת_, _חייו_, keus
  { {0x442d0027,0x27e60e8e,0x3cfa0012,0xcb090009}},	//   kve_, tson_, _بعدد_, יל_
  { {0xd0100003,0x10470048,0xbfaa003c,0x48e30048}},	//   الت_, дящи_, отке_, точв
  { {0x64460051,0x20ee001a,0x61fa003a,0xd6cf0012}},	//   äkim, ội_, yutl, لقه_
  { {0x27e60e8f,0xa3c80011,0x657e0025,0xe80e0011}},	//   sson_, ैठक_, épho, ाढ़ता_
  { {0x636000a2,0x6f1c0e90,0xad660012,0x61fa0060}},	//   _döne, herc, باته, vutl
  { {0x6d4b09ea,0xea00001a,0x15ea0011,0xaf0609cc}},	//   _doga, _khắp_, _टिकर_, _опал
  { {0x6d930d04,0xba0a0048,0xc7260024,0x7e560472}},	//   nçar, охме_, _ідей, _отец
  { {0x7d0d00a2,0x6d4b000f,0x3999000f,0x442d0e91}},	//   yfas, _foga, lési_, ave_
  { {0xbfa3001a,0x316b0024,0x7de50012,0x7c2d0073}},	//   hiế, ішно_, _أسلم, yvar
  { {0xf773000a,0x3999000e,0x28a700b3,0x4c560012}},	//   ناس_, nési_, ьшог, _تضار
  { {0x636000a2,0x69c3000e,0x4c9b0009,0x5f450012}},	//   _yöne, ínek, _ובדו, رنزل
  { {0x7dc7003a,0x42fb000b,0x12fb0009,0xe7eb0011}},	//   _kısa, _והוס, _והוב, _झटका_
  { {0x6728009b,0x7c2d0e92,0x91870012,0xbcfb0e93}},	//   _ladj, tvar, _تجتم, _amér
  { {0x6d4c001a,0x7d0d0052,0x8afc0002,0x2d580061}},	// [1b90] _đoạ, rfas, chęc, _réel_
  { {0x3999000e,0x67280027,0x6f1c0e94,0x7c2d0e95}},	//   dési_, _nadj, cerc, rvar
  { {0x2fcd0163,0x50f50867,0x442d0e96,0xe3b00012}},	//   _steg_, езет, zve_, شرك_
  { {0x6d930e97,0xdb1d0061,0x8aa40e98,0x02a409c2}},	//   rças, _musé, труд, трум
  { {0x8d5a0009,0xf9900012,0x27e90025,0xe7390e99}},	//   _זכרי, جبل_, éan_, зел_
  { {0x25a6000f,0x6d4b0052,0x9f590061,0x92f40012}},	//   _ahol_, _soga, fusé_, _لأفض
  { {0xf7700003,0x6d4b0e9a,0xed59003c,0x3eb30248}},	//   جان_, _poga, зой_, äxt_
  { {0x442d0e9b,0x6f1c015d,0x94250083,0xdb1b0164}},	//   tve_, zerc, емие, rquí
  { {0x442d0108,0xdb0e000f,0x7529000e,0x395f0051}},	//   uve_, _hibá, rdez, _ilus_
  { {0x7ae500a2,0x13090015,0x8bd6000b,0x03d60009}},	//   naht, чной_, עותו_, עותם_
  { {0x8f680003,0x44200002,0xa3e60011,0x06380012}},	//   _تملك_, zwi_, _यौन_, _يسمع_
  { {0xdc330029,0x99f60009,0x04c80012,0xb87b0097}},	//   lúče, עזרה_, _قومي_, raín
  { {0xdbd70269,0x93590024,0xa1560009,0xc4a90011}},	//   _jäät, _нрку_, גברה_, कधोख
  { {0x7ae500b6,0x25ad005e,0x63600032,0x75ca0034}},	//   jaht, lmel_, _mönc, _węze
  { {0x3999000f,0x59c60037,0x6996068f,0xdbd7005e}},	//   zési_, _रूपर, _прих, _läät
  { {0x44200034,0x6f1c0e9c,0x04460024,0x8c46028b}},	//   twi_, serc, небн, небе
  { {0xdde3001e,0x68e00010,0xac860055,0x6f1c0e9d}},	// [1ba0] ērša, _remd, хгал, perc
  { {0xe6250020,0x6b520058,0x68b70009,0x76260024}},	//   _đông_, _nægt, _אלפא_, _змоз
  { {0xfce60731,0x4ae10037,0x7641004a,0x76550002}},	//   _поно, _फ़रव, älyt, cyzy
  { {0x39990272,0x29020e9e,0x68e6002c,0xab5b0052}},	//   tési_, ngka_, nakd, _stüt
  { {0x394d0036,0xc0e70003,0x2d800e9f,0x6576008e}},	//   _does_, رفون_, mnie_, miyh
  { {0x2d800ea0,0x395f0051,0xa2d60012,0xb2d60012}},	//   lnie_, _elus_, _سيرت, _سيرغ
  { {0x3999000f,0x63830014,0x25e30037,0x69ce07a8}},	//   sési_, _сгра, टीपी_, _utbe
  { {0x394d002a,0x3999000e,0x1d340014,0x2d800ea1}},	//   _goes_, pési_, тния, nnie_
  { {0x9f86002d,0xfd660081,0x39b8004b,0x61fe0ea2}},	//   _згад, _khuế, _răsp_, lupl
  { {0x5a340662,0x70170009,0x61fe0ea3,0xdce20ea4}},	//   внот, _אחמד_, oupl, _omoć
  { {0x7d060163,0x6fa70037,0x2d800002,0xd0d50014}},	//   _ocks, _गठबं, knie_, конъ
  { {0xea000020,0x2d800002,0x629801bd,0xc27b0009}},	//   _nhập_, jnie_, _vyvo, לריי
  { {0x2d80003e,0x2bb20037,0xa5690012,0xc5690012}},	//   dnie_, ीददा, _تصلك_, _تحلل_
  { {0x2d80003e,0x61fe0bec,0x291d0034,0xab640060}},	//   enie_, kupl, zewa_, nlüğ
  { {0xdb030013,0xbe88072b,0x6b520028,0x3da7010c}},	//   _jiný, есте_, _lægs, ераб
  { {0xba9b0093,0x65640101,0x5eb40015,0x1a9b000b}},	//   _מסוי, ghih, уйст, _מיוע
  { {0x7ae50051,0x61fe0025,0xab640060,0x2418003c}},	// [1bb0] taht, eupl, klüğ, ноты_
  { {0xd6db0047,0x2d800002,0xa87c0009,0x04940012}},	//   _эти_, anie_, _מאחר, الْح
  { {0x395f0ea5,0x2d800002,0xdbd7004a,0xa4d9027f}},	//   _plus_, bnie_, _säät, _одну_
  { {0xd879000a,0xdbd70006,0x2d80003e,0x60b50012}},	//   ومات_, _päät, cnie_, نمائ
  { {0x7ae50006,0xbcfb0b45,0x61fe005e,0x753d0ea6}},	//   paht, _eléc, aupl, _insz
  { {0x0eac0037,0xbcfb0025,0x23a20097,0x291d016d}},	//   टइंड, _fléc, yðja_, sewa_
  { {0x86980014,0xc9770003,0x7f2c0009,0x62340048}},	//   нтът_, _كارث, לֵהֶ, _йеру
  { {0x1da70037,0x69c70042,0x752d0ea7,0xa63c0009}},	//   _कीमत, íjem, ndaz, לגור
  { {0xe4c80012,0x6c52004c,0x25ad0ea8,0x6d4f0ea9}},	//   ربين_, икћу, rmel_, _moca
  { {0x799d008b,0x6b520028,0xf412000b,0x999f0010}},	//   elsw, _hægr, ספי_, kytų_
  { {0x36d40047,0x2d80003e,0x44260164,0x68e6002c}},	//   _сохр, ynie_, _eso_, takd
  { {0x27e90039,0x999f0010,0x4ad10037,0xf8c10037}},	//   šanu_, dytų_, _द्रव, एशिय
  { {0x25fd0037,0xf1b2000b,0xe5880009,0xfd560009}},	//   रूरी_, יסט_, _אָסָ, _ששני_
  { {0x2d80003e,0x2905000f,0x6b520028,0x5f090011}},	//   wnie_, őlap_, _lægr, _साफ्_
  { {0x66060014,0x2d800ea0,0xa59600de,0xa6e30024}},	//   ъпва, tnie_, вращ, ржсл
  { {0x27ed0eaa,0x16020011,0x106a0012,0xee370048}},	//   _oven_, रंतर_, _يحظى_, ънс_
  { {0xc9530093,0xe3ba0345,0x7ae30eab,0xb8f60011}},	// [1bc0] _כמה_, дба_, _kent, ाँ_
  { {0xd7fb0093,0xab5b0052,0x68e40eac,0xa2cd0011}},	//   _קהיל, _stür, _heid, दुल्
  { {0xeb970046,0xea00001a,0x6dbc080d,0x48e600de}},	//   њих_, _thập_, _včas, воев
  { {0xb2950001,0x81bc001e,0xb8f30012,0xba170012}},	//   ујућ, ovēr, لكمب, ضيها_
  { {0xdb0b003a,0x68e40ead,0x7a130030,0x4c830048}},	//   _bugü, _meid, větš, _вляв
  { {0x3999000e,0xe3b20003,0x7d040eae,0xa8570009}},	//   lést_, _خرج_, lgis, כינה_
  { {0x27ed0eaf,0xab64003a,0x7c240032,0x0f7b0009}},	//   _even_, rlüğ, lwir, ורסל
  { {0xdb190002,0xdce9003a,0x39990eb0,0x63bc0032}},	//   _otwó, rneğ, nést_, _hirn
  { {0x3166000e,0x7c240052,0x7ae30eb1,0x8ca70011}},	//   mhoz_, nwir, _bent, _चरणो
  { {0x4426009b,0xdb18000e,0x3166000e,0xa263001a}},	//   _vso_, _kivé, lhoz_, _trố
  { {0x79820002,0xa2660014,0x81bc001e,0x02fb000b}},	//   onow, тъпл, evēr, ולימ
  { {0xd5e90003,0x92570015,0x99810073,0x316600e9}},	//   _أعلن_, тают_, _čių_, nhoz_
  { {0x7ae3000e,0xf8db0009,0x39990031,0xad650012}},	//   _fent, וחכמ, dést_, _حاله
  { {0x6ae10037,0x999f0010,0x64a30001,0x75200eb2}},	//   _फ़ेर, tytų_, _тача, lemz
  { {0x3166000f,0x79820431,0xd3780eb3,0xbcfb0025}},	//   khoz_, know, mić_, _aléa
  { {0x8ab7000b,0x2bb20037,0x7ae30052,0xd9440001}},	//   _בלוג_, ीदवा, _zent, _већи
  { {0x69c30052,0xd4070015,0x3166000e,0x629c002c}},	// [1bd0] _zune, ъяви, dhoz_, _ayro
  { {0x7ae80002,0xd3780eb4,0xf0e30037,0x7658004a}},	//   nadt, nić_, _ख़ुद_, kyvy
  { {0xfdb900ac,0xa6e30097,0x6d4f009d,0x3f83001b}},	//   _площ_, íður, _toca, mnju_
  { {0xb65a000b,0x79820002,0xa4d5002d,0x31790123}},	//   _נדרש, gnow, _щомі, nisz_
  { {0xb4fa000b,0xe0d8002d,0x9f4205b1,0xbbeb0012}},	//   _אפרי, тві_, lská_, _ترجم_
  { {0x63600028,0xf0940009,0x8fa50012,0xaf040024}},	//   _hönn, סנס_, دمته, ипіл
  { {0x6360008b,0x2d550058,0xd3780027,0x60c404cf}},	//   _könn, _fået_, dić_, žima
  { {0xceb4000b,0xc3d9002d,0x81bd001e,0xdb1d0107}},	//   סיק_, ньої_, zvēr, _musí
  { {0x7ae30eb5,0x6d5b00b6,0xb8e90037,0xcc350003}},	//   _pent, rkua, ोड_, اربع
  { {0x7ae8000f,0x3999000f,0x69c3000d,0x2902006f}},	//   gadt, zést_, _pune, _ökar_
  { {0x52e10037,0x7dc7003a,0xdb030164,0x3f830027}},	//   _फ़ैस, _kısm, _sinó, dnju_
  { {0xf5300003,0x3cfd0037,0x5e440012,0xd4350012}},	//   _وإن_, एलों_, _خَمْ, _معتب
  { {0x68e40333,0xd378003e,0x39990066,0xe9e90029}},	//   _veid, bić_, vést_, dnúť_
  { {0xd378003e,0xa8750015,0x40850001,0x7ae301e3}},	//   cić_, рующ, руџб, _uent
  { {0x3999000f,0x2bdf0037,0x81bd001e,0x79820002}},	//   tést_, पीरा, rvēr, ynow
  { {0x31790002,0x81bd001e,0x6ae10011,0x96d40011}},	//   cisz_, svēr, _फ़ॉर, _ब्रॉ
  { {0xdb19003e,0x3999000e,0xd467022a,0xfafa0012}},	// [1be0] _utwó, rést_, гите_, فراغ_
  { {0x87260047,0x443205b1,0x3999000e,0x83fd000e}},	//   _смож, rvy_, sést_, ezők
  { {0x7c240052,0x3166000e,0x3999000e,0xe8fa072b}},	//   swir, thoz_, pést_, еле_
  { {0xd378003e,0x88e60063,0x629c0042,0x867b0009}},	//   zić_, ужде, _vyro, _טריו
  { {0xdfcf000a,0x629c0002,0x83fd000e,0x3166000e}},	//   كين_, _wyro, szőj, rhoz_
  { {0xe3c80020,0x3166000f,0x25a00051,0x8f340662}},	//   _lực_, shoz_, llil_, рекц
  { {0x6b6300bc,0xd378001c,0xd6d9002d,0x15f30003}},	//   _укра, vić_, тті_, مسيح
  { {0xd378003e,0x5d540014,0x20020060,0x13f40148}},	//   wić_, ркит, kuki_, азия
  { {0xe644003a,0x88860001,0xd3780027,0x90290012}},	//   ılığ, _слаж, tić_, _لألف_
  { {0x96d401e1,0x31790002,0xfbcf0003,0x6c170003}},	//   _ब्लॉ, wisz_, أتي_, اتيح_
  { {0x7bc600e6,0x395202d5,0xc3330009,0x85060012}},	//   _luku, _boys_, מוז_, _موان
  { {0x6ae10037,0x2ee50070,0xe3c8001a,0xd3780404}},	//   _फ़्र, _zelf_, _cực_, sić_
  { {0x8d93000a,0xf5930003,0x69c10061,0xd3780404}},	//   _النش, _النج, _élev, pić_
  { {0x3179003e,0x9f4200d9,0x8cba0011,0x63600097}},	//   sisz_, tská_, ्शनो, _sönn
  { {0x58d50098,0x3179003e,0xe9e90029,0x8b9b0009}},	//   _койт, pisz_, tnúť_, _רבות
  { {0xb4d502ad,0x5839010c,0x9f4200d9,0x39400132}},	//   ржащ, _азия_, rská_, _gnis_
  { {0x7bc600c6,0xa9bc000b,0xe8d8000b,0x3f830027}},	// [1bf0] _cuku, _אזהר, _עוזר_, pnju_
  { {0x7bc600b6,0x9f420066,0xa3e60011,0x88bd0034}},	//   _duku, pská_, यीय_, _zaśw
  { {0xe9e90029,0x77ba000b,0xc0d50003,0x9b170009}},	//   pnúť_, _שמתח, لياب, רחבה_
  { {0x2ee50eb6,0xdc3401bd,0x4dda0009,0x2d99005e}},	//   _self_, _zúča, _שחרו, _ukse_
  { {0xb0af0037,0x50450048,0x83fd0031,0x88c80024}},	//   जेंग, релб, rzők, улів_
  { {0x6d4d0005,0x2b140037,0x7ff40012,0x44390eb7}},	//   ljaa, न्दु_, إسنا, _irs_
  { {0xcf58000b,0x7bc60052,0xf1c9001a,0x42290009}},	//   רבות_, _zuku, _mạc_, _בֵּ֣
  { {0x52840003,0xf1c9001a,0x6d4d0eb8,0xdb1d0018}},	//   _الفك, _lạc_, njaa, _fusã
  { {0x50670046,0x87070003,0x68eb002c,0x69ce0030}},	//   _ства, _مبال, magd, íben
  { {0x466b002d,0xdced003a,0xd7a40037,0x44390503}},	//   _прем_, ynağ, _खींच, _mrs_
  { {0x38ba00a2,0xc332000b,0x6723048b,0x75d1001e}},	//   _türü_, קוט_, menj, _bāze
  { {0xdc340026,0x27e0007d,0x69c70164,0x68eb002c}},	//   _súča, ţine_, _muje, nagd
  { {0xe3c80020,0x7db40003,0xf1c9001a,0xfc3f000e}},	//   _vực_, _اصلا, _bạc_, _szín_
  { {0x8f750024,0x23ab0040,0x7ae70030,0xeb080012}},	//   бусі, føje_, _nejt, _مقهى_
  { {0x7bc6050d,0x200200b6,0x7bca0035,0x39520bb5}},	//   _suku, suki_, ēmuš, _toys_
  { {0x39400061,0x7bc600b6,0xdbd2005e,0x64460248}},	//   _unis_, _puku, _tüüt, åkig

  { {0x68eb0101,0x6723000e,0x31570012,0x5f760012}},	// [1c00] dagd, kenj, _خليج_, _نادر
  { {0x6723080a,0xaae50003,0xdb59002d,0x2bb60034}},	//   jenj, مسمو, лює_, _płci_
  { {0x6723012e,0xe5a6002d,0x66030010,0xb87b0066}},	//   denj, _вини, junk, abíd
  { {0xe3c80020,0x3f980002,0x7bc60eb9,0x66030eba}},	//   _lựa_, loru_, _tuku, dunk
  { {0x6360003a,0x38600028,0x33d5002d,0xd8f70024}},	//   _yönl, áir_, _гіст, рнії_
  { {0x752f003e,0x2b030037,0xa0370009,0x92e90012}},	//   _zacz, _लाएँ_, יאנה_, _مرفق_
  { {0x22470052,0xf62a002d,0xfb1b0009,0x7e2a0024}},	//   änkt_, тіли_, _שולמ, тіла_
  { {0xa6e90020,0x3f980066,0xb4c20037,0x8e570009}},	//   _ngươ, horu_, ्डे_, ייצג_
  { {0x8c430001,0x4d730012,0x70fb0009,0x53460048}},	//   жење, تطور, _שהמח, ахна
  { {0xdb15000f,0x44970015,0x6723013a,0xf4130009}},	//   _kizá, рвью_, cenj, קפת_
  { {0xe3c80020,0xa159002d,0x69c1000e,0x69c0000e}},	//   _dựa_, гану_, _élet, _kime
  { {0x2c5e001e,0x867b0009,0x6446005e,0x65690ebb}},	//   _kādā_, _ברבו, äkis, cheh
  { {0xb8cf015f,0x938a0014,0x752f0002,0x60f8003c}},	//   _कर_, _иска_, _racz, шняя_
  { {0x0b930003,0xc43b000b,0x8c1b0009,0x93930012}},	//   _وجود, _שתגי, _סווי, _وجوا
  { {0xa1870015,0x99420002,0x7ae70ebc,0xeb910009}},	//   _выпл, _dół_, _rejt, _מָה_
  { {0xcdf7000b,0x6360003a,0x3abb000b,0x69c00ebd}},	//   ימלי_, _dönm, _במונ, _nime
  { {0x2ac70001,0x65a5000e,0x31580009,0x39580009}},	// [1c10] аљев, zóho, _כיהן_, _כשהם_
  { {0x34a70037,0x889c000b,0xa4b7000b,0x69c00ebe}},	//   _खरीद, _בבחי, שלמה_, _aime
  { {0xc879004b,0x7648008e,0x6d42004b,0x32790012}},	//   _ieşi_, ädyt, _onoa, دماج_
  { {0x91ac0020,0x7afd0010,0xc198002d,0x5184046d}},	//   _đọc_, ėsti, атії_, оуча
  { {0x7ae70026,0x68eb0101,0x68270015,0x89340003}},	//   _tejt, ragd, рьез, تعلا
  { {0xf1c90003,0xf8bf000e,0x66030b95,0xf4560009}},	//   _موسى_, ldés_, tunk, _הישר_
  { {0x6723001c,0x68eb002c,0xdf480003,0xd6ce0012}},	//   renj, pagd, شؤون_, رقي_
  { {0x9985000a,0x66030961,0x44290002,0xcd29003c}},	//   _الرو, runk, owa_, ужие_
  { {0x681a0039,0xdd2f0066,0xbc390003,0x44390cbe}},	//   gādā, _těžk, اسبا_, ís_
  { {0xe730000a,0xb4e60037,0xe4520009,0x75d50012}},	//   _يصل_, _बड़ी_, לֶת_, _هيئا
  { {0x442900c6,0xcb12000b,0x69c1000e,0xb6350012}},	//   hwa_, הלי_, _éles, _دفاع
  { {0x442900b6,0xce6800a6,0x3f980b2c,0x35b50842}},	//   kwa_, _труд_, woru_, _убер
  { {0x68e909de,0x7d090d33,0x55ba0009,0xbcfb0025}},	//   _meed, mges, _עמנו, _clém
  { {0x59cf0044,0x20f8001a,0x50d80037,0x7d090ebf}},	//   _संपर, ọi_, _भ्रष, lges
  { {0xc879000d,0x59b90037,0x25fd0037,0x03ac0009}},	//   _deşi_, ेदार, रंटी_, _שׁוּ
  { {0x68e90036,0xbf9b0017,0x7d090ec0,0x3f980ec1}},	//   _need, quên, nges, soru_
  { {0x75240039,0x7ff60003,0x7c290ec2,0x3f980ec3}},	// [1c20] reiz, _اسبا, nwer, poru_
  { {0x290d000d,0x7d090052,0x61fe09d2,0xdc880009}},	//   _acea_, hges, trpl, בְעָ
  { {0xcf570093,0x7c29008b,0xb9c1003a,0xe1fa0731}},	//   _הבית_, hwer, _üçün, уге_
  { {0xb4e60037,0x7d090070,0xea00001a,0xf53f0029}},	//   _बजे_, jges, _nhấp_, áťte_
  { {0x7c290070,0x38490009,0xd12f0012,0x68e90ec4}},	//   jwer, ֹאוּ_, عمه_, _deed
  { {0xaa46036f,0x07b70012,0x0ce00011,0x7c2902a2}},	//   _легл, مهنة_, नर्म, dwer
  { {0x6b630015,0x65880066,0x7c290ad2,0x7d090480}},	//   _экра, běhl, ewer, fges
  { {0xea000020,0x2c5e001e,0xbebc001e,0xb5aa0003}},	//   _chấp_, _tādā_, _saīs, داتك_
  { {0x7866048c,0x7ac60024,0x23b40012,0x69c20011}},	//   _указ, йсне, يمبس, _रंजी
  { {0x681a0039,0x26190044,0x6e3c0164,0xd7ef0012}},	//   rādā, _पहली_, _árbo, _أكل_
  { {0x4429003e,0xcb9b000b,0x7f3b000b,0x6e960003}},	//   zwa_, רסיט, _תעבו, _الضا
  { {0x44290002,0x3da5002d,0x3abb0009,0xa0b9004c}},	//   ywa_, _дріб, טמינ, игну_
  { {0xf8ba0037,0x91ca0011,0xdc1d07ee,0x000000c4}},	//   ेशिय, _संवै, kņāt,
  { {0xd7f80015,0x995c0066,0x69da0ec5,0x600b0009}},	//   щую_, jíž_, ppte, נִכְ
  { {0xf1c90020,0x15f80009,0x13170009,0x9df80009}},	//   _hạn_, יִּמ, _החול_, יִּז
  { {0x44290961,0x46d90011,0x98c70ec6,0x6b9a01a0}},	//   twa_, _ब्रह, _ускл, lotg
  { {0x69cd001e,0xf8bf057d,0x8fa50012,0x83fd0031}},	// [1c30] ēneš, rdés_, _ومعه, szőv
  { {0xe2f9002d,0x9aab0003,0x44290002,0xf1c90081}},	//   режі_, هداف_, rwa_, _mạn_
  { {0x442900c6,0x7c2900f7,0x201f004b,0x6aba0097}},	//   swa_, zwer, _spui_, _útfl
  { {0x80e30037,0x4429002c,0xe9190024,0xc1040012}},	//   खरेख_, pwa_, роді_, كومي
  { {0xf1c9001a,0xb4e60037,0xf1940024,0x7af80064}},	//   _nạn_, _बड़े_, чиць, _odvt
  { {0x6d810039,0x7c2f0ec7,0x9e090012,0xef180024}},	//   rķau, _iscr, ليتك_, ймі_
  { {0xc332000b,0x7d09036a,0x68e90051,0x2d580025}},	//   _קול_, tges, _teed, _réer_
  { {0xf1c9008a,0x7c290369,0x160b0037,0x25b60003}},	//   _bạn_, twer, संबर_, يهود_
  { {0x69ca0052,0x69d80259,0x7d090ec8,0x7c290ad2}},	//   _aufe, _atve, rges, uwer
  { {0x7d090732,0xdce00010,0x2d83000e,0x4374027f}},	//   sges, kimė, ője_, зуют
  { {0xea000020,0x7aea003a,0x7d090070,0xdd990004}},	//   _thấp_, _deft, pges, poň_
  { {0x26130017,0x7bdb004a,0x98a60014,0x24190015}},	//   mão_, ppuu, жиме, _воды_
  { {0x26130017,0x9b750012,0xb87b0a19,0x7c2f0ec9}},	//   lão_, _واتص, daís, _nscr
  { {0xe73a0046,0x5334003c,0x26130018,0x88ba0009}},	//   шег_, _нечт, oão_, יזרי
  { {0x3ebe0eca,0x26130017,0x7c2f0ecb,0xd62a0488}},	//   ätt_, não_, _ascr, шове_
  { {0x656d01e5,0xe9730012,0x9f420064,0x7bc30ecc}},	//   ghah, _يهود, nskú_, _hinu
  { {0x64a30046,0x7bc3002c,0x8fe60012,0xe7320012}},	// [1c40] дата, _kinu, _بأعم, _قصد_
  { {0xdb18000f,0x6360008b,0xaac90037,0x8a3a0015}},	//   _kivá, _köni, रशिक, ияет_
  { {0x7bcb0ecd,0x77830024,0x2d9e0025,0x7c2f0ece}},	//   _lugu, _ілюз, îtes_, _escr
  { {0x26130017,0xdce20ecf,0x67160011,0x02aa0011}},	//   dão_, _ploč, द्रक_, _करीन
  { {0x644b0051,0x274a0ed0,0x6d460ed1,0x79b70009}},	//   ägit, ичко_, _inka, קלנד_
  { {0xb033002d,0x883b0009,0x8e3a0012,0xdb1d0060}},	//   ьніш, יתנו, لسعر_, _rusç
  { {0xdbd10017,0x26130017,0x6725005e,0xf1c90081}},	//   qüên, gão_, õhja, _sạn_
  { {0x7bc30005,0xdd900003,0x442200b6,0x54540ed2}},	//   _ainu, عوة_, _kpk_, звит
  { {0xdca30046,0xf1c9001a,0x7bc3002c,0x69ca000d}},	//   маћи, _bạo_, _binu, _sufe
  { {0x8c1b000b,0xb4db0054,0xf1c90081,0x2d680060}},	//   סויי, _anàl, _vạn_, rşey_
  { {0xf2d3000b,0x78ad000e,0x26130017,0x8b030066}},	//   ועת_, _szav, cão_, _úřed
  { {0x7bc30065,0xdb1d008b,0xdb030017,0x3cf60011}},	//   _einu, _zusä, _sinô, ेलों_
  { {0x7bcb0a60,0xf8b00012,0xf5770012,0x75360034}},	//   _gugu, َةُ_, _بمنع_, ddyz
  { {0x60210028,0xf1c9001a,0x83fd000e,0x42560012}},	//   _hámö, _gạo_, rzőt, _ونشر
  { {0x69d80ed3,0xcdd80001,0x1634022a,0x7bcb0032}},	//   _utve, жњу_, меря, _zugu
  { {0xb87b02d1,0xd657000b,0x3f9c0027,0x798d0002}},	//   abía, חילת_, hovu_, _ujaw
  { {0x26130017,0x78ad00d9,0x4422001b,0x3f9a0097}},	// [1c50] zão_, _uzav, _cpk_, ófuð_
  { {0x8aa70294,0xfaa70ed4,0x43740024,0x6a670012}},	//   оред, ошен, муєт, يطال
  { {0x26130017,0x64400028,0x68ed00b6,0xa2be0037}},	//   xão_, _ámin, _kead, _वृद्
  { {0xdeb6015a,0x81c80024,0x26130018,0xe1d80024}},	//   _מפתח_, ігів_, vão_, ідчі_
  { {0x9f420029,0x9cd60009,0x80270012,0x60080024}},	//   vskú_, _מורה_, ترام, жнім_
  { {0x26130149,0xdfce000a,0x3f9c0027,0xd2460003}},	//   tão_, ديو_, govu_, _كن_
  { {0xa6fc000b,0x7bcb0cb1,0xa9550024,0xed590024}},	//   שִׂי, _sugu, _екві, йок_
  { {0x26130149,0x7bcb03eb,0x7bc30ed5,0x7d0d0ed6}},	//   rão_, _pugu, _sinu, ngas
  { {0x26130149,0x9c220015,0x7bc3002c,0xdfd80048}},	//   são_, едыд, _pinu, _дъх_
  { {0x3b090046,0x59cf0037,0x26130017,0x31b60011}},	//   љено_, _संदर, pão_, ृद्ध
  { {0x7c2d03c0,0xe6100012,0xe2990578,0x27e9016d}},	//   hwar, _لشن_, сан_, _awan_
  { {0x50cb0011,0x661c005e,0x22580ed7,0x7c2d0ed8}},	//   िशिष, _ärka, ärka_, kwar
  { {0xf1c90020,0xa4870003,0xa3ab0037,0x69c40051}},	//   _tạo_, _بجان, खता_, _viie
  { {0x5456000b,0xcc56000b,0x69de004a,0xe1f10012}},	//   _מסנן_, _מבני_, yppe, _كسب_
  { {0xb5aa0003,0xd6cf0003,0x0b780012,0x68e20132}},	//   مارك_, اقف_, _بصنع_, ybod
  { {0x442d0002,0x7d0d002c,0x3cca0001,0xf9fa0009}},	//   owe_, ggas, слао_, _ההקמ
  { {0x2bba0012,0x07fa0012,0xa2be0011,0x7c2d0ed9}},	// [1c60] مائة_, _اربع_, वेन्, gwar
  { {0x083b0093,0x103b000b,0xf1c9001a,0xc2b6004c}},	//   _פעיל, _פגיע, _lạm_, пљењ
  { {0xa926005c,0xb6a30061,0xa2ce0037,0xa75b000b}},	//   здел, éâtr, तशब्, _הדיר
  { {0xc7c60001,0x31b205b1,0xcb090009,0x7c3b0040}},	//   пски, báze_, טל_, kvur
  { {0x6d3b000b,0xdbd10054,0x6b810028,0x68e200c7}},	//   _התכנ, qüèn, kilg, rbod
  { {0x501b000b,0xe3a70003,0x33b5003c,0x60c90eda}},	//   מונו, _سر_, _жёст, _egem
  { {0x7d1b0edb,0x7c220edc,0x60cd0035,0x3f9c0edd}},	//   ffus, _spor, žama, rovu_
  { {0x7d780003,0xb063004a,0x3f9c0580,0x1513003c}},	//   تمبر_, ääks, sovu_, едъя
  { {0x69d50066,0x68ed0ede,0x3cf70012,0x6b810248}},	//   ízen, _read, سعيد_, filg
  { {0x68ed03fb,0x44770093,0x27f70013,0x51f8002d}},	//   _sead, פעיל_, ření_, оною_
  { {0xd5be0037,0x68ed0051,0x7edb000b,0xe3af0012}},	//   ्दाज, _pead, _הקבצ, دري_
  { {0x7982003e,0x7aee0052,0xe3b8003a,0xc05b0024}},	//   niow, _lebt, smı_, біг_
  { {0x7c22066e,0xe53b000b,0x4346022a,0x85570009}},	//   _upor, _לתאר, _недв, _משאב_
  { {0xc7c400bb,0x1cbb0009,0x33940012,0xb9040011}},	//   есси, _המדע, _تلتز, _प्_
  { {0x68ed0005,0xd7880020,0x66b40001,0x69ce01e3}},	//   _tead, yển_, ебру, _nube
  { {0x7c2d0edf,0x82330012,0xe5090012,0x4ddb0009}},	//   twar, _أروا, تيرو_, מחלו
  { {0x2d5804b3,0x78fc000b,0x79820002,0x212b0066}},	// [1c70] чить_, _הפחו, diow, mech_
  { {0x212b0ee0,0x6e2d0034,0x8afc0034,0x7c2d0ee1}},	//   lech_, łabi, chęt, rwar
  { {0x20190051,0xbdb50001,0x3f830ee2,0x7aee0bb5}},	//   ltsi_, _обој, miju_, _debt
  { {0xfc3f0020,0x212b0ee3,0x92b40012,0x6b820025}},	//   _trí_, nech_, رحلا, éogr
  { {0x20190051,0x7e61006f,0xdd3a0009,0x5d3a0009}},	//   ntsi_, älpf, _וערכ, _ותרא
  { {0x80a00044,0xf838000b,0x25a90ee4,0xa3ab0011}},	//   _ऐडसे, פנות_, llal_, _कीं_
  { {0xf770000a,0x6d590002,0x26170017,0x644600ad}},	//   دان_, _powa, nço_, åkin
  { {0xc212000b,0x79820002,0x61fa0028,0x1c450055}},	//   _שהן_, ciow, _ætla, дним
  { {0x442d00bd,0x212b0066,0x200b0027,0x6b810ee5}},	//   uwe_, dech_, juci_, tilg
  { {0xf8b2000b,0xe1f90ee6,0x25a90060,0x8c1a0009}},	//   _ישן_, ого_, hlal_, קותי
  { {0xc2c5000a,0xf1c90020,0x290f006f,0x6d590ee7}},	//   بيدي, _tạm_, ogga_, _towa
  { {0x7bdd0005,0x290f0807,0x15f40003,0xd17a002d}},	//   _otsu, ngga_, _أسلح, існі_
  { {0xbf9b0017,0x02aa0037,0x3f830027,0x071f0011}},	//   rrên, _कर्न, fiju_, म्भव_
  { {0x3f830027,0x3ea0000d,0xae210011,0x79820034}},	//   giju_, şite_, _महान_, ziow
  { {0x7bcf0108,0xddd40029,0xad5a0055,0x46a30048}},	//   _aucu, ňažn, орах_, варв
  { {0xdb180006,0x7bcf000d,0x212b0030,0xd1ba0012}},	//   _eivä, _bucu, cech_, _باتا_
  { {0xeafa0003,0x3f830027,0x7bc70ee8,0x672104d2}},	// [1c80] قرات_, biju_, _biju, _oblj
  { {0x3f830ee9,0x63720058,0x91e6004d,0x2d8d0032}},	//   ciju_, _mæng, доже, hnee_
  { {0x637200c5,0x7bc700b6,0x539a0009,0x39990031}},	//   _læng, _diju, קיעו, vész_
  { {0x2d850031,0x257a0035,0x290f0248,0xd2560009}},	//   élet_, pūli_, _ögat_, ושעה_
  { {0xdfcf000a,0xe5710009,0x20890009,0xccf30009}},	//   لين_, _גַם_, ּתוֹ_, _בכר_
  { {0x212b0eea,0x9e140024,0xcdda004c,0x6d5d0248}},	//   zech_, едкі, оњи_, ösan
  { {0x79820002,0x8b030066,0x6360000e,0xde93004c}},	//   piow, _úřad, _dönt, кашњ
  { {0xd8260046,0x60260001,0x3f830027,0x71260012}},	//   _одби, _одба, ziju_, _ترسل
  { {0xf8b20037,0x212b0066,0xc0d30012,0xb8660012}},	//   _जरिय, vech_, _شيلب, _غارو
  { {0xd3700003,0xc21a0024,0xba54004c,0x185b0009}},	//   اهد_, оєм_, евој, _וכמע
  { {0xc3330093,0x212b0066,0x9f59000e,0x3f830027}},	//   דות_, tech_, pusú_, viju_
  { {0xf6530093,0xd788001a,0x7c260058,0x63720eeb}},	//   _בצע_, iểm_, _opkr, _hænd
  { {0x6360003a,0x3205002a,0x55bb000b,0xa3c00037}},	//   _yönt, arly_, _ומאו, ुदा_
  { {0x2d840eec,0x6360006f,0x200b0027,0x2905003a}},	//   lime_, _möns, ruci_, şla_
  { {0x212b01e9,0x3f830eed,0x63600248,0x639b0009}},	//   pech_, riju_, _löns, _וסגנ
  { {0x26170017,0x39490164,0x6360006f,0x69fb0009}},	//   rço_, _unas_, _oöns, _ולהק
  { {0x93b50001,0x91b80003,0x9f4200d9,0x3f830eee}},	// [1c90] ебац, _تطور_, lský_, piju_
  { {0x339b0012,0x326b0012,0x20190035,0x31960035}},	//   آخرة_, يحاً_, _īsi_, rāze_
  { {0x15e80044,0xeab4000b,0x09e4002d,0x2d840010}},	//   टीआर_, תִּי_, воєн, kime_
  { {0xaadf015f,0x4adf0044,0x02df0044,0x394902d1}},	//   _प्रक, _प्रव, _प्रभ, ñas_
  { {0x752d000d,0x63600028,0x60cd0035,0x99870031}},	//   meaz, _pönt, žamo, ínű_
  { {0x752d007d,0xbcfb0017,0xbae50003,0xe7360048}},	//   leaz, _elét, _سكري, ееш_
  { {0x69ca0037,0x11d40003,0x61ca0011,0x17580009}},	//   _संगी, _لتقد, िदृष, וסגר_
  { {0x63600163,0x752d007d,0xf532000b,0xe5050012}},	//   _föns, neaz, ָ֥ה_, ربعي
  { {0x64420108,0x7d1a0009,0x20fb0011,0x4426016d}},	//   _croi, הֵיה, ्लैश_, _cpo_
  { {0x64420108,0x60cd00c6,0xf1c9001a,0x636d0028}},	//   _droi, _agam, _hại_, _búna
  { {0x249b0010,0x80c20011,0x2d840073,0x60c40073}},	//   _žymę_, रेने, bime_, žimt
  { {0x6d5d0eef,0x25d6000b,0x752d000d,0x64420061}},	//   _nosa, _טוען_, jeaz, _froi
  { {0xc7960015,0xf1c9001a,0x26cc0029,0xeb8e0ef0}},	//   ервы, _mại_, ždom_, _би_
  { {0xf1c9008a,0x0dca0003,0x25710066,0x99710002}},	//   _lại_, كبرى_, _dále_, nął_
  { {0x443f0028,0x21cc0030,0x63a10031,0x753b001b}},	//   lvu_, _běhu_, moln, oduz
  { {0xed57057b,0x443f0027,0x6d5d0317,0x753b0ef1}},	//   нос_, ovu_, _cosa, nduz
  { {0xf1ca001a,0x09b70009,0xdced03a7,0x6d5d0ef2}},	// [1ca0] _nại_, _אפקט_, chač, _dosa
  { {0x138a0003,0x909b000b,0x99710002,0x8877000b}},	//   أخرى_, _מספק, jął_, _נתיב_
  { {0x2bb20044,0x32170003,0x9f5f000e,0xa3c00037}},	//   ुगता, فيلد_, _órán_, ंगत_
  { {0x7e61006f,0x443f0027,0xf1ca001a,0x2d840203}},	//   älpe, kvu_, _bại_, xime_
  { {0x40340098,0xa0670001,0x18670345,0xf9930009}},	//   телс, наца_, наци_, נרד_
  { {0xb9070037,0xfc3f0030,0x78ad005e,0xf1ca0081}},	//   _म्_, _vzít_, üava, _dại_
  { {0x8cba0037,0xe5c6022a,0xaac60012,0x8e370012}},	//   ्शको, нсио, _ستسن, فسير_
  { {0xf653000b,0xdb1c003a,0x6da30001,0x44320002}},	//   רצה_, _birç, лија, owy_
  { {0xe4520003,0x70af0037,0x63720058,0xed5e0081}},	//   اضع_, _घरेल, _tænd, _đột_
  { {0x752d007d,0xbf9b0061,0x5c7301d4,0x2d840ef3}},	//   zeaz, trêm, ульт, sime_
  { {0x443f0039,0x2a6a000f,0x7e9a0003,0x672e0058}},	//   avu_, ább_, _عنصر_, debj
  { {0x64420108,0x9f400028,0x32020042,0x9f420042}},	//   _troi, _svið_, čky_, rský_
  { {0x752d000d,0x38660ef4,0xb97b0009,0x48ab04a5}},	//   veaz, nyor_, לנטי, ятом_
  { {0x6601000f,0x33980012,0xd4370009,0xbf9b0025}},	//   álko, _تنتج_, _נטוי_, prêm
  { {0x752d007d,0x79a70104,0x6447001e,0xf1a70ef5}},	//   teaz, _прие, ājie, _прин
  { {0x55580014,0x99710034,0x1cbb00ae,0x2d9c0ef6}},	//   нася_, zął_, كاذب_, _ível_
  { {0x752d007d,0x6d5d0054,0x91bc0009,0xfbd30012}},	// [1cb0] reaz, _vosa, _צמחי, اتر_
  { {0x752d000d,0x673a0027,0xe6950012,0x5e950012}},	//   seaz, _natj, _للخد, _للخط
  { {0x69c90039,0xc987096e,0x61fa074f,0x443f01bd}},	//   _piee, нуди, nstl, zvu_
  { {0xbcfb000f,0x7ff50003,0x92b40003,0xd70e0011}},	//   _elér, نستا, احكا, _साउथ_
  { {0xfbe7001a,0xa3c00037,0xa3c20011,0xf1b40009}},	//   _chế_, ंगा_, ्दा_, אסף_
  { {0x083c000b,0x21040010,0xd7020048,0x257e0030}},	//   פעול, mčių_, азши, vůli_
  { {0xed590015,0xab94002d,0x63a105b1,0x3e320012}},	//   дой_, _сирі, voln, لفور
  { {0xf1ca0020,0x63a1003e,0x27ed0066,0x75d1001e}},	//   _tại_, woln, šeny_, _jāzi
  { {0x2104007a,0xe894002d,0x67d5002d,0x02c90037}},	//   nčių_, _бать, _розу, रश्न
  { {0x21040010,0x4a450695,0x9c180009,0x200f0a94}},	//   ičių_, внов, תחזק_, mugi_
  { {0x44320002,0xf2d2000b,0x443f0269,0xc0e60187}},	//   zwy_, יעי_, svu_, конк
  { {0x63a1000e,0x3f870ef7,0x1e560009,0x44320034}},	//   soln, linu_, _בשער_, ywy_
  { {0x63a1012e,0x8d740003,0x78fa0009,0xe14f0024}},	//   poln, _حالا, ופרו, рсiв_
  { {0x25ad0ef8,0x25a002a1,0x25bf004b,0x82850012}},	//   llel_, čile_, lmul_, _لجعل
  { {0x539a000b,0xe3c8001a,0x21040010,0xf8c7000e}},	//   _קיצו, _cựu_, ečių_, éért_
  { {0x395f0ef9,0x16140037,0x44320002,0x63860025}},	//   _nous_, तंबर_, twy_, _ténè
  { {0x3f870065,0x8cc40037,0xccf2000b,0x711b0009}},	// [1cc0] kinu_, ाइयो, יכן_, _חופפ
  { {0x09ca0037,0x200f0051,0x7e61006f,0xc8870052}},	//   िद्य, dugi_, älpc, ößer_
  { {0xf506057b,0xc332000b,0x7ae50051,0x21040073}},	//   _изно, שוב_, _õhtu, ačių_
  { {0x4a5a015a,0x8e970009,0xb8160011,0x53e60012}},	//   ודעו, _ידיו_, _तमाम_, _لأسف
  { {0x394d014a,0x26140037,0x3f870028,0x200f005e}},	//   _dnes_, नूनी_, finu_, gugi_
  { {0xbf9b0108,0x18670001,0xa0670001,0x07080012}},	//   quêt, ђаји_, ђаја_, ريعي_
  { {0x2bd80037,0xd6270001,0x6aa30052,0x7bca00b8}},	//   _भंडा, воје_, ünft, _rifu
  { {0xfbe70020,0xc693000b,0xc5f3000b,0x2ef80032}},	//   _thế_, יאו_, בדה_, harf_
  { {0x711b0009,0xd0e30011,0xbfc6076b,0xb7d70012}},	//   _קומפ, _क्षण_, _абак, _لوقا_
  { {0x3ce20011,0x3f870efa,0x6376004b,0x1eaa0012}},	//   _ट्रे_, cinu_, _mâng, _قاضي_
  { {0xcb130093,0xd257002d,0x6376000d,0x2ef80052}},	//   בלת_, вця_, _lâng, darf_
  { {0x25a60101,0x79a4003c,0x21040073,0x867b0009}},	//   _ukol_, иряе, yčių_, _קראו
  { {0x69d80066,0xf1bf0018,0x7d020018,0x38340365}},	//   ívej, rmá_, _idos, аняр
  { {0x25750623,0x61fa0032,0x248d0073,0x27e6020d}},	//   _måle_, pstl, _žemo_, ipon_
  { {0xfbb70093,0x0bb70093,0x26060011,0xba550081}},	//   _שפות_, _שלום_, सूची_, _vắcx
  { {0x69cb0037,0x3f870ee2,0xc115004c,0xbe3b0009}},	//   _सूची, zinu_, _смиј, ועלת
  { {0xc05b002d,0x0dc80291,0x511a0009,0x64c40012}},	// [1cd0] _цій_, тури_, _אֵינ, ليفل
  { {0x395f0108,0x41e7002d,0x201e000d,0x81c7001e}},	//   _sous_, віда, ătit_, zmēģ
  { {0x7d020026,0x2104007a,0xe8cb0037,0xe8050037}},	//   _odos, sčių_, िश्च, _रिहा_
  { {0xe4e4002d,0x200f005e,0xe1f00012,0x67d50934}},	//   _вірн, tugi_, تسك_, году
  { {0x395f02b5,0x3f870efb,0x2bce0321,0xb97c0009}},	//   _vous_, tinu_, _हंगा, ונאי
  { {0x753d0272,0xf1ca001a,0x61e50097,0x69c80030}},	//   _hasz, _hạt_, pphl, íjez
  { {0x395f0108,0x6376004b,0x25bf004b,0x753d0efc}},	//   _tous_, _mând, tmul_, _kasz
  { {0x2294007c,0x22490027,0x394d08b9,0x442b00b6}},	//   _тися, _čak_, _unes_, _kpc_
  { {0x69dc0026,0x3af500fa,0xcfab0003,0x753d0a8e}},	//   íren, лянс, _قائم_, _masz
  { {0x69d5003a,0x25bf000d,0xf1ca001a,0xb8820029}},	//   _kuze, smul_, _lạt_, číto
  { {0x75150003,0x200b0efd,0x198a00f5,0xa18a0294}},	//   _مواض, erci_, ебни_, ебна_
  { {0x753d003e,0x9f5e0066,0x058400b3,0x44390efe}},	//   _nasz, čtí_, _кучм, _oss_
  { {0x291e0002,0xb4fa0009,0xe44e0063,0x636401a0}},	//   ęta_, _נפסי, _уж_, _còns
  { {0x6d4f0b4a,0x8c280009,0xa8560009,0x7af50030}},	//   _anca, _יֵצֵ, אישה_, _nezt
  { {0x7bc1008b,0xa3c20037,0x539a000b,0xdb22000e}},	//   mmlu, ्दर_, _איסו, _óráb
  { {0x6d5b00c6,0x656d002c,0x64a60c80,0x7e610248}},	//   njua, gkah, габа, älpa
  { {0x9f4f0028,0xe3ba0ba3,0x2d9200b0,0x7af50eff}},	// [1ce0] yrgð_, еба_, rnye_, _bezt
  { {0x74130003,0x6376000d,0x0057000b,0x656d002c}},	//   صوما, _gând, _עשית_, akah
  { {0xe216000a,0x471b0009,0xccf90034,0x614606e5}},	//   طباع, _אויג, kaś_, лежа
  { {0xfe37000b,0x7c2b0f00,0x22580051,0xba170012}},	//   _ערכי_, _opgr, ärki_, طيها_
  { {0x673e000e,0x68f6003a,0xd12f0012,0x58d70024}},	//   _kapj, _meyd, ثمن_, удія_
  { {0x321e004a,0x8fa30339,0x753d0002,0xeef60009}},	//   ytty_, баче, _zasz, אמַר_
  { {0x7bdd0065,0x09cf0037,0x7c2b098f,0x5e260012}},	//   ísun, _संगठ, _apgr, اعتق
  { {0x4420007a,0x673e000e,0x7bce00b6,0x9f960051}},	//   oti_, _lapj, _hibu, lüüs_
  { {0xb716000a,0x7524000e,0x44200f01,0xa3c00011}},	//   _مباش, ifiz, nti_, ंगल_
  { {0xf0630046,0x673e000e,0x41e6002d,0x69d80011}},	//   _укуп, _napj, ліма, _नंदी
  { {0x6376000d,0x442007f6,0x28c70037,0x2bb70012}},	//   _rând, hti_, रेनि, داية_
  { {0x8446000a,0x7d02003e,0x44200f02,0xddb60012}},	//   _مختل, _udos, kti_, _صحاب
  { {0x4420009b,0x01370009,0xcebf0030,0x200b0025}},	//   jti_, ארכת_, ěřen_, urci_
  { {0x8417000b,0x7524000e,0x44390f03,0xdc3b0009}},	//   _עקוב_, efiz, _rss_, _נעור
  { {0x7afa0006,0x63030003,0xaadb000b,0x75240052}},	//   matt, _طويل, _אחור, ffiz
  { {0x63a50052,0x3d0f0011,0x6d400f04,0x75240031}},	//   wohn, िलें_, ndma, gfiz
  { {0x656d0101,0x44200071,0x8d4b0009,0x0fb9004c}},	// [1cf0] rkah, gti_, עֲלֵ, _илић_
  { {0x2d81000f,0x59d90037,0x753d0002,0x656d005e}},	//   éhez_, _बंदर, _wasz, skah
  { {0x7bce0f05,0x44200f06,0x64400035,0x7afa00b8}},	//   _dibu, ati_, _šmit, iatt
  { {0xd788001a,0x7afa0f07,0x2d8c0031,0x6d4f0f08}},	//   iểu_, hatt, édet_, _unca
  { {0x68f9003e,0x69da0061,0x6cfa000b,0xb4fa0009}},	//   rawd, _éten, _בפרס, _בפרי
  { {0x6d470039,0x7afa0006,0xdb01043d,0xf7450695}},	//   ējam, jatt, polé, реко
  { {0x7afa0b0c,0x539a000b,0xff040055,0xfaa90012}},	//   datt, _יישו, сячн, _شهري_
  { {0xdb01006f,0x05650f09,0x63bc0064,0x24920073}},	//   illå, рвин, _zhrn, _žyma_
  { {0x6d5b00b6,0x320b0002,0x28c70011,0x7afa0f0a}},	//   rjua, ącym_, रेमि, fatt
  { {0x25a0066e,0xb7bd007d,0xba750012,0xe3b10012}},	//   čila_, _opţi, لاجت, غرة_
  { {0x67250051,0x45d50014,0xc3320009,0x44200031}},	//   õhju, _тоес, חוי_, zti_
  { {0x213f00c6,0x64430039,0x44200f0b,0x69d80017}},	//   _jauh_, ānij, yti_, ívei
  { {0x671c0037,0x44200097,0x6fa60012,0x85c80012}},	//   _नामक_, xti_, لإسك, _إِنْ_
  { {0xb4c10037,0xcb6603ff,0x6c7a0009,0xa875003c}},	//   ंधी_, _ваше_, _ברנד, сующ
  { {0x0fc3007c,0x7bce00b6,0xacf60001,0x24f605fb}},	//   ійсн, _ribu, ичај, ичар
  { {0x1a9a000b,0x44200f0c,0x7d160010,0x257100d9}},	//   _ביצע, tti_, ugys, _málo_
  { {0x31bc0066,0xd4670014,0xbbba0012,0x5baa0223}},	// [1d00] níze_, аите_, ندئذ_, вкам_
  { {0xfbdf008a,0xb7fb0009,0xc6960012,0xdcf60060}},	//   _trên_, _שפית, _نشجع, ıcın
  { {0x201f0149,0x69c20070,0x644401a3,0xb2d30012}},	//   _aqui_, tmoe, svii, زينغ
  { {0xc8ca000a,0x39400010,0x7afa000e,0x44200f0d}},	//   نوان_, _jais_, zatt, pti_
  { {0x39400f0e,0xa01b0052,0x97c60695,0x69c20f0f}},	//   _mais_, rzög, айде, rmoe
  { {0x6e33000e,0x26cc05b1,0x88c50012,0xe3a70012}},	//   _újbó, ždou_, حتمل, _ذر_
  { {0x7afa06cb,0xd6d9002d,0x9c8701bd,0x539b0009}},	//   vatt, уті_, počí, _סילו
  { {0x5d540098,0x28c70044,0x39400101,0x64430002}},	//   скит, रेडि, _nais_, łnie
  { {0xa3e70001,0x1be70001,0x4d770009,0xc0aa0012}},	//   адња_, адњи_, יתקל_, _شارل_
  { {0x395203eb,0xd6f8000b,0x7ac60dd8,0xa6f80009}},	//   _anys_, _תִּש, исне, _תִּי
  { {0x0bb7000b,0x9f7b000b,0xfe720003,0x83b7000b}},	//   שלים_, _שנבח, _بدء_, שפיע_
  { {0x64490010,0xa1940024,0xc2370009,0x51f7003c}},	//   _šeim, жаюч, ברטו_, шнюю_
  { {0xb87b0066,0x63760017,0xe0df00b8,0xc8640f10}},	//   dcíc, _cânc, rcò_, отри
  { {0x3ea9007d,0x93fb000b,0x547b000b,0xd7f801ec}},	//   şate_, _ילדי, _שְׁנ, шую_
  { {0x63a800c5,0x3bbb000b,0xf1bf0029,0x39400061}},	//   modn, _שמוד, žšia_, _fais_
  { {0xda5b0093,0x661c005e,0x224d00eb,0x2129016d}},	//   _יכול, _ärku, _ček_, _ubah_
  { {0xa99c000b,0x91bc000b,0x54b90015,0xe4500012}},	// [1d10] _שבחר, _במהי, угая_, وضك_
  { {0x8ae7007c,0x28c70037,0xddce0029,0x2d8c0061}},	//   ріал, रेणि, ždňo, éder_
  { {0xcb370009,0x69da0031,0x1ba80012,0x69d80f11}},	//   שאבי_, _étel, جُلٌ_, _juve
  { {0x291900c6,0xb87b000e,0xe298002d,0x645d079b}},	//   ngsa_, bbít, шає_, äsik
  { {0x8d5a000b,0x59d00037,0x90450012,0x55ba0009}},	//   _עכשי, _संघर, إنته, _תמרו
  { {0x69d80061,0x6fd4002d,0xf1ca001a,0xef180024}},	//   _ouve, іціє, _lạp_, имі_
  { {0x64460028,0xb9e4002d,0x92580021,0x8e490012}},	//   ækin, _міти, _карт_, البك_
  { {0xf1ca001a,0x06980009,0x1e980009,0x59dd0011}},	//   _nạp_, ידום_, יכול_, _नंबर
  { {0x26130011,0xe8180012,0x39400f12,0x69d80f13}},	//   _धमकी_, _نزلت_, _rais_, _auve
  { {0xc6a70046,0x39400f14,0x63a80f15,0x4ea70469}},	//   _креи, _sais_, godn, _креа
  { {0x636d0bff,0xd94605fb,0x8b640012,0xb87b0030}},	//   _júni, бени, تايم, ycíc
  { {0xf7690009,0x598309f8,0x69d80f16,0xdb050b77}},	//   _אק_, злюб, _duve, llhä
  { {0x6be50003,0x493a0009,0xb9000011,0x63a80f17}},	//   _اكتم, נגשו, _तल_, bodn
  { {0x2bdb0044,0x5334022a,0xdee30863,0x75c30031}},	//   _बढ़ा, _мечт, зори, _tőzs
  { {0x26180037,0x1d0a02ac,0x69d80f18,0xfce60024}},	//   बंधी_, леви_, _guve, йово
  { {0xf1d00302,0xa1930001,0x6e930012,0xdb1a0097}},	//   _सूचन, _најч, ألفا, mmtá
  { {0x69d80052,0xb87b0f19,0xd1170009,0x442f0f1a}},	// [1d20] _zuve, rcíc, _הקפה_, _jpg_
  { {0x26180037,0x67350002,0x0b150009,0xcef6004c}},	//   बंदी_, cezj, מַ֣ר_, _учињ
  { {0xbf9b0025,0xeb97004c,0xab270048,0x20020f1b}},	//   rrêt, љих_, соха_, lski_
  { {0x9f490065,0xf8fa0003,0xda650012,0xa1130012}},	//   _hvað_, اءات_, غالي, كومت
  { {0x20020082,0x3014002d,0xb87b000e,0xbf9b0025}},	//   nski_, ідкр, lbír, prêt
  { {0x7c24001e,0x39400073,0xb87b01e3,0x69dc0031}},	//   mtir, žis_, ncía, írek
  { {0x8afb0093,0x7c240f1c,0xbb770009,0xcf250012}},	//   _תהלי, ltir, _פעלו_, ترني
  { {0x25a0066e,0xb9960003,0x8cc40037,0x63a80002}},	//   čilo_, _الرب, ाइलो, wodn
  { {0x20560001,0x69d80f1d,0x26180011,0x0caa003c}},	//   _утвр, _suve, बूती_, ытки_
  { {0x4f650003,0xc43b000b,0xc1ea0015,0x20020f1e}},	//   _والف, נתיי, льме_, dski_
  { {0xe1350047,0x69350015,0xdb1c0061,0x644b05ac}},	//   онны, онну, _chré, _ergi
  { {0xd2b70093,0x721b000b,0x68e204a3,0xba9b0009}},	//   מלית_, נוכח, ncod, רסטי
  { {0xbda50003,0x55bb0009,0x63a8064b,0x6d440f1f}},	//   _بحلو, _עמדו, podn, ddia
  { {0x7bdf0061,0x661c005e,0x24800dac,0x6d440f20}},	//   _équa, _ärks, dzim_, edia
  { {0xf1ca001a,0x41e60003,0xa5f90001,0xa293002d}},	//   _tạp_, _استف, ребу_, _наші
  { {0x7c240028,0xd0110012,0x6bd70012,0x3d060011}},	//   ftir, _قلب_, متطر, _षयों_
  { {0xe5200037,0xf9940009,0x2419003c,0x68e20227}},	// [1d30] _यानि_, _מרק_, розы_, dcod
  { {0x68e20070,0x2474001a,0x6d47001e,0x25a90018}},	//   ecod, ìm_, ējai, soal_
  { {0x7a35000a,0xa4d5002d,0xd2510003,0x42990012}},	//   تفاص, _моні, بنا_, جناح_
  { {0xdb0105db,0xc2c40012,0x621b0009,0xac190f21}},	//   volí, سيني, רואק, _кому_
  { {0xe8f8002d,0xc88b0003,0xe9d00003,0xa3b80011}},	//   слі_, دخال_, رغم_, चता_
  { {0x2d9a000e,0x8cbe0011,0xd7c80012,0xc0180009}},	//   épen_, _शरतो, مونه_, מקדו_
  { {0xdb180042,0xb5790024,0x24740081,0x65c50842}},	//   _chví, ищих_, èm_, обка
  { {0x2409005c,0x637b0025,0x20020b2c,0x2d9c0031}},	//   ании_, _dîne, yski_, _ívet_
  { {0x75ca003e,0xdb20003a,0x3ea90002,0x93590538}},	//   _języ, ütçe, łat_, арну_
  { {0x3b090001,0x1a050695,0x387200b0,0x6d440064}},	//   јено_, опом, øyre_, zdia
  { {0xeab1000a,0xcb12000b,0xe6950003,0x2474001a}},	//   بعة_, ולי_, _بلاد, àm_
  { {0x20020416,0x3a980015,0xf5b70012,0x68fb0025}},	//   tski_, стью_, _اصطد, _jeud
  { {0x443d0052,0xcfaa0003,0xd78a0012,0x644b0f22}},	//   _usw_, لاسم_, لنحو_, _urgi
  { {0xf767000a,0x7d1b0051,0xe8df001a,0x94740012}},	//   ذا_, lgus, _baịn_, _عدنا
  { {0xfc3f02d1,0x212d0f23,0x7d1b0a94,0x64490f24}},	//   _así_, _obeh_, ogus, lvei
  { {0x752900b8,0x20020f25,0x057a0012,0x7d1b0f26}},	//   nfez, pski_, جمرة_, ngus
  { {0x7d1b0051,0x6fb60003,0x64490f27,0xf6d60024}},	// [1d40] igus, _ومعا, nvei, _міня
  { {0x2575006f,0xe2920012,0xda660012,0xc2b6004c}},	//   _håll_, وذا_, ياضي, ољењ
  { {0xcf570009,0x021a0024,0xe0da0f28,0x3946003c}},	//   _ובית_, різь_, аве_, жнег
  { {0x64430002,0xdebb000b,0x7afe0ce7,0xc1780073}},	//   łnia, _כמיל, sapt, _įės_
  { {0x18360003,0x257c0066,0x4fc604ac,0xade00011}},	//   تراح, _cíle_, оска, _खंडन_
  { {0xe4510093,0xbb560003,0xdce2003a,0x7d1b0f29}},	//   _אֶל_, _بنسب, _bloğ, egus
  { {0xd95a0001,0x7afc004b,0xa1160012,0x3f8e0073}},	//   _краљ_, _iert, _ووست, rifu_
  { {0x2fc7020d,0xdb210031,0x31960035,0xd6a90012}},	//   amng_, ütöt, bāzi_, حدهم_
  { {0x7afc0179,0x644900b0,0x7d7b00af,0xe81605f3}},	//   _kert, gvei, ינקו, _तमगा_
  { {0xe3b20003,0x8afc0002,0x7d1b002c,0x1dda0011}},	//   برع_, djęc, agus, भदात
  { {0x64490010,0x27e90f2a,0x394601c5,0xd3370009}},	//   avei, _stan_, odos_, חריה_
  { {0x69dc0f2b,0x39460f2c,0xddcb0b64,0x7afc0f2d}},	//   _mure, ndos_, čiūn, _lert
  { {0x7dd5007a,0xf8ca0037,0xd7fb0001,0xe5710009}},	//   _išsa, िधिय, јум_, _רַב_
  { {0x28c70037,0xb4c80011,0xa6f80009,0x29040097}},	//   रेषि, ोखी_, מִֽי, ómar_
  { {0xccfb0001,0x2e480014,0x86240015,0x55590014}},	//   ића_, оято_, мьте, бавя_
  { {0xdd910012,0x66020034,0x98ca0011,0xc1790073}},	//   روء_, _łokc, िधाए, rpės_
  { {0x7afc00c6,0xd3750001,0x0bd50003,0xdcef000d}},	// [1d50] _bert, плаћ, سياح, _alcă
  { {0x20190f2e,0x27e9001e,0xbbd70009,0x9715003c}},	//   musi_, ķinā_, קובץ_, _эмоц
  { {0x69dc007d,0x64490039,0xea00001a,0x28c70037}},	//   _cure, zvei, _đảo_, रेरि
  { {0xf5590012,0x05590012,0x3f910220,0x69dc0f2f}},	//   _الحب_, _الحظ_, lizu_, _dure
  { {0x8d5a000b,0xe3170012,0x7afc0f30,0x66e503cd}},	//   _הכרי, _وبسب, _fert, пола
  { {0xa3f6000b,0x69dc0061,0x37ab0001,0x394601c5}},	//   _ממשק_, _fure, штен_, ados_
  { {0x7c3900a2,0xfe710012,0xf7700012,0x7bdd0060}},	//   şarı, عدت_, خان_, _husu
  { {0x7afc008b,0xdb01000e,0x7c3b0052,0xf2d20009}},	//   _zert, dolá, twur, _טעם_
  { {0xdbd60051,0x7d1b0673,0xc8640015,0x20190f31}},	//   jään, rgus, _отфи, jusi_
  { {0x547c000b,0x25710028,0x20190f32,0x3f140001}},	//   יטחו, _máli_, dusi_, _одус
  { {0x8d770003,0xa91d0010,0x63720058,0x7ae50832}},	//   _واصا, _amži, _sænk, icht
  { {0xac190047,0x24190015,0xb6ba000b,0x89360012}},	//   _году_, _годы_, _הצעי, أعدا
  { {0x62810102,0x04580012,0x28c70011,0x48b60048}},	//   szlo, _وجهت_, रेलि, ящот
  { {0x2b180011,0x39460073,0x03b70012,0x3f9e005e}},	//   _दाएँ_, zdos_, _بإصد, õtu_
  { {0x272f00a2,0x3ebe0f33,0x644b0028,0x20190010}},	//   mını_, ått_, ægin, ausi_
  { {0x18a6002d,0xceb2000b,0x7ae60066,0x63720058}},	//   _найм, גיל_, ěkte, _tænk
  { {0xd5af000a,0x7afc0f34,0xdca30469,0xf3f10081}},	// [1d60] افق_, _pert, еати, _ặc_
  { {0x272f003a,0xef860055,0x7bdd016d,0x6e2d0034}},	//   nını_, _хлоп, _dusu, łaby
  { {0x6edb000b,0xd6db000b,0x19ba027f,0xeef70009}},	//   _לחיפ, _לחיל, будь_, _ממיר_
  { {0x7afc008b,0x7bdd000d,0xe5a6004d,0x7ae504a3}},	//   _wert, _fusu, _хими, acht
  { {0x7afc00c6,0x69d60101,0xdb01000e,0xdb1e000e}},	//   _tert, _miye, zolá, ampá
  { {0x4cbb000b,0x6d460f35,0x94bb0009,0x272f0060}},	//   _לזכו, _haka, _למכת, jını_
  { {0x2902002c,0x272f003a,0x6d460f36,0xfaa30dc2}},	//   kaka_, dını_, _kaka, _заро
  { {0x7ec7000f,0x6d460947,0xd29b000b,0x2d92003a}},	//   lépé, _jaka, _השלט, niye_
  { {0x6d460f37,0x29020e6f,0x7d000f38,0xb4c80011}},	//   _maka, daka_, rams, ोखे_
  { {0xa87b000b,0x807b000b,0x68430014,0xfc2f0003}},	//   _האמר, _הנמצ, _януа, احي_
  { {0x2d92003a,0xcf250003,0x0cb90011,0xe1390024}},	//   kiye_, _ترقي, _आर्म, озні_
  { {0x6d460f39,0x2019093d,0xdb01000e,0x644a001e}},	//   _naka, tusi_, rolá, āfij
  { {0xdb01000f,0xb0c70037,0x272f003a,0x2d92003a}},	//   solá, रेंग, bını_, diye_
  { {0x272f003a,0x6442008e,0x7bdd0415,0x321a0f3a}},	//   cını_, _isoi, _rusu, kupy_
  { {0x29020163,0x7bdd0f3b,0xae1d0037,0x8b8b000b}},	//   baka_, _susu, बंधन_, _לָהֶ
  { {0x20060006,0xdbd60006,0xd2b7000b,0x6a9b000b}},	//   ksoi_, sään, _מלות_, _לשונ
  { {0xea000020,0xa0080012,0x03d50024,0xfce80012}},	// [1d70] _đạo_, _فقيل_, джаю, سفلي_
  { {0xa87c0093,0xe3b8003a,0x64430002,0x0bb4027f}},	//   _לאחר, nlı_, łnio, ебую
  { {0x7bd5007d,0x6d4600a2,0x7ae50052,0xe3b00003}},	//   _vizu, _faka, rcht, ارق_
  { {0x644203fc,0x637300a2,0x7ae50052,0xd8790003}},	//   _osoi, _sını, scht, يمات_
  { {0xe3b8003a,0x272f003a,0xb4d90011,0x25ad0227}},	//   klı_, yını_, ाशी_, voel_
  { {0x501c0009,0x44290f3c,0x6d460f3d,0x29020f3e}},	//   מודו, mta_, _zaka, zaka_
  { {0xee39007c,0x81bd0039,0x6d46030a,0x95c50012}},	//   іни_, ttēl, _yaka, ويته
  { {0xd6580093,0xd11f0037,0xc2c40012,0x13e90024}},	//   ליות_, _भाषण_, _سيقي, омий_
  { {0x272f003a,0x2d830010,0x2009001e,0xe3b80060}},	//   tını_, ėje_, _nvai_, flı_
  { {0xd389002d,0xe2990001,0xb2f40015,0x44290f3f}},	//   ійне_, жао_, няющ, ita_
  { {0x272f00a1,0x442900b9,0x8e990003,0x29020f40}},	//   rını_, hta_, _بناء_, taka_
  { {0x272f00a2,0xc692000b,0x3d070011,0x8c590012}},	//   sını_, _באב_, षणों_, _ولاء_
  { {0xa01b000f,0x9a99001e,0x3205002a,0x8c4502ad}},	//   szön, _šādā, ssly_, _целе
  { {0xdfd20003,0x81bd001e,0x6d490f41,0x29020f42}},	//   ئيس_, ntēj, ldea, saka_
  { {0x2d92003a,0x290204d2,0x6d460f43,0x32160012}},	//   tiye_, paka_, _paka, _قيود_
  { {0x60d60010,0x9f59004a,0x44290f44,0xf9fa0009}},	//   žymi, essä_, fta_, _והקמ
  { {0x2d92003a,0xdb070028,0xad250012,0x6f030f45}},	// [1d80] riye_, _skjá, عرفو, kanc
  { {0x6d49004a,0x257c0066,0x2d92003a,0xdcef0035}},	//   hdea, _díla_, siye_, ādāt
  { {0x2d800f46,0x753b0070,0x2d9a000e,0x673c0811}},	//   phie_, keuz, épek_, merj
  { {0x27e00006,0xe3b800a2,0xc329000b,0x321a0002}},	//   _kuin_, zlı_, יו_, rupy_
  { {0x7d04083c,0x27e00061,0xe3b8003a,0x29000017}},	//   mais, _juin_, ylı_, _meia_
  { {0xdc8b000b,0x7d040f47,0x29000f48,0x673c0f49}},	//   _וְלָ, lais, _leia_, nerj
  { {0x2f970009,0x27ed0227,0xda090011,0x25780097}},	//   וכסן_, _eten_, _विगत_, _féll_
  { {0x7d040f4a,0x27ed004b,0x7c290f4b,0x6da3004c}},	//   nais, ţeni_, fter, кија
  { {0x4f260046,0x673c00c6,0xe3b8003a,0x2b470f4c}},	//   _одаб, kerj, tlı_, _banc_
  { {0x661c0010,0x2d98000e,0x7d04086e,0x36360012}},	//   kurk, őre_, hais, _يراس
  { {0x7d040006,0x81bd0039,0xe3b800a2,0xa3de0037}},	//   kais, stēm, rlı_, _दूर_
  { {0x2d9e000f,0xc5f3000b,0x7d04004a,0x298b002d}},	//   étel_, _ידע_, jais, існо_
  { {0xdb0801e3,0x9f59008e,0xe3b80060,0x290001a0}},	//   lodí, yssä_, plı_, _deia_
  { {0x81bd001e,0x1cbb0009,0xc0580024,0x7dea0073}},	//   otēk, _ומדע, фію_, _tęsd
  { {0xdfd400e3,0x05770003,0x67d400bb,0x79a702ad}},	//   торы, وارد, тору, _орие
  { {0x9e4b0009,0xf9880012,0x7d040f4d,0x62850159}},	//   חֲמִ, _ينوي_, gais, vzho
  { {0x8cc40037,0x644d0061,0x44290f4e,0x3b550538}},	// [1d90] ाइटो, uvai, uta_, нкар
  { {0x31a4003a,0x752d0f4f,0xa3c30011,0x257c0097}},	//   mıza_, sfaz, ्षय_, _víla_
  { {0xc9150046,0xa1150003,0xb1150001,0xdb1c0028}},	//   едећ, فوات, емеш, _virð
  { {0x6f030f50,0x7c290f51,0x443f0034,0xae1a0009}},	//   wanc, yter, ywu_, _צורכ
  { {0x31a400a2,0xa3c30044,0xe4a70001,0x06f30011}},	//   nıza_, ्षम_, _црно, _अभाव_
  { {0x9f050003,0xf1ca001a,0xabfa0009,0x70520012}},	//   روبو, _dạy_, _מהשר, انوا
  { {0x81bd0039,0xbbbd0037,0x6d49000d,0x45d50014}},	//   rtēj, ्गीक, tdea, нцит
  { {0x7982003e,0x6f030f52,0x443f0034,0x81bd0035}},	//   chow, sanc, twu_, stēj
  { {0x27ed0119,0xfc480020,0x7c290f53,0x81bd001e}},	//   _uten_, _cử_, uter, ptēj
  { {0x2d8c0061,0xfaf10003,0xe3c50012,0x27e00f54}},	//   édez_, دثة_, عْدَ, _ruin_
  { {0x673c0f55,0x7bd80f56,0x68e409ef,0x3a99003c}},	//   verj, _divu, žide, ятию_
  { {0x46380003,0xf2d2000b,0xbd450012,0xe4510012}},	//   _تأكد_, טעי_, _سنتي, _مضت_
  { {0x6007007c,0x27e00054,0xdb01004a,0xa3db0011}},	//   нням_, _quin_, tolä, _ढंग_
  { {0xfbc50842,0x661c0f57,0x5c9a0009,0xa875003c}},	//   _ябло, turk, _צֹאנ, тующ
  { {0xcb12000b,0x8f9a000b,0x02450012,0xf7720009}},	//   _עלה_, לישי, _أَبَ, נקל_
  { {0x2d9f0061,0x661c003a,0x27e00227,0x3f83005e}},	//   nnue_, rurk, _tuin_, ahju_
  { {0xfc480020,0xa99b000b,0xc19b000b,0xdee60209}},	// [1da0] _xử_, _מבקר, _משקי, _попи
  { {0x7d040f58,0x9b460003,0x74130003,0xe3b709e3}},	//   sais, عناو, اولا, ебу_
  { {0x61eb007d,0xc332000b,0xe9da0838,0xdb1c0042}},	//   _înlă, רוב_, чке_, _chrá
  { {0xfbdf0061,0xa87a01b0,0xcb090009,0x25710097}},	//   _prêt_, ּאַר, מל_, _máls_
  { {0x26c70030,0x75c30031,0xa3de0011,0x75e70060}},	//   _únor_, _főzz, _दूं_, _rıza
  { {0xdfcf000a,0x501b000b,0x3dc60f59,0xa8a90009}},	//   مين_, פוצו, _show_, וֹצִ
  { {0xfc48008a,0xe2870003,0xe60f0012,0xf7730009}},	//   _sử_, _إذ_, مشي_, רקו_
  { {0x7bd803fc,0x5d540014,0xc6930009,0x25a0005e}},	//   _sivu, ткит, טאו_, nnil_
  { {0x64a30001,0x6f010f5a,0xdca3004c,0x10a307b9}},	//   лаћа, _felc, лаћи, _битн
  { {0xb8f30037,0x54330003,0xf8bf0025,0x25a00159}},	//   हे_, ارير, ngée_, hnil_
  { {0xc3330093,0xf6560024,0x25a00159,0x26de020d}},	//   אות_, _ятаю, knil_, _igto_
  { {0xbfa50020,0xfc480020,0x546a0014,0x4c86010c}},	//   hiệ, _tử_, _наем_, _плев
  { {0xc953000b,0xb9090037,0x2571000e,0x99840012}},	//   אמר_, _बल_, _vált_, الُو
  { {0xa3c30044,0x25a0012e,0x60c4001e,0xd5df0037}},	//   ्षण_, čilu_, _dzim, _पूँज
  { {0x9757000b,0xde580024,0x83690012,0x4e340009}},	//   עילו_, нарі_, _تصنف_, כָּן_
  { {0x7abb000b,0x257c0066,0x3abb0009,0xd5b8026d}},	//   _מצוו, _dílo_, _ממונ, есу_
  { {0x2ef50098,0x68ed003a,0x321e0002,0x71d80009}},	// [1db0] _изпр, _ifad, luty_, _אוהד_
  { {0x889c000b,0x339b0012,0x35b20011,0x8aa70103}},	//   _מבחי, أخرة_, ँकड़, нред
  { {0x22590003,0x321e0975,0xdd910012,0x314b0009}},	//   بلاد_, nuty_, _نود_, ּתְּ
  { {0x3978002d,0xc0d50012,0x621b0009,0xeab10009}},	//   нсію_, نياب, לובק, בֹד_
  { {0x6d5d0f5b,0x00e40024,0xb0cb0011,0xb87b0030}},	//   _insa, ужін, ़ेंग, ucíh
  { {0x7bdf0108,0x656f008b,0x2b1e0037,0x39490708}},	//   _équi, _hoch, _पाएँ_, žas_
  { {0xfbdf0149,0xb87b000e,0xe7080003,0x63720028}},	//   _três_, gbíz, رتون_, _vænt
  { {0x7dd5007a,0x6f010f5c,0x11d40003,0x6d4d0f5d}},	//   _išsk, _welc, _متقد, ndaa
  { {0x6d4d004a,0x7d02000d,0xb87b0066,0x69c9008e}},	//   idaa, _deos, abíz, _ihee
  { {0x69da0061,0x20c80012,0x87d70012,0x44390f5e}},	//   _éter, _أبِي_, _أغرا, _mps_
  { {0x6a860108,0x60c4000e,0xdce6001e,0x7c2d0f5f}},	//   _réfé, _szim, _lokā, htar
  { {0xc7a9000b,0x656f0f60,0x04b50048,0x7c2d0f61}},	//   _וב_, _noch, _исля, ktar
  { {0x8ccd0044,0x15180003,0x35db0037,0x5d78002d}},	//   देशो, _أزمة_, _मंज़, _яйця_
  { {0x24890f62,0x6d4b0f63,0xaba90012,0xfc460030}},	//   dzam_, _haga, _تهتم_, řích_
  { {0x6d4b0101,0xd62706a5,0x85b60001,0xc7b20009}},	//   _kaga, коре_, вљач, יבך_
  { {0x40960003,0xceb2000b,0x6d4b0f64,0x6d5d004b}},	//   _للعر, ׁים_, _jaga, _cnsa
  { {0x1ae60015,0x60c40027,0x7c2d0aba,0x6d4b0f65}},	// [1dc0] возм, _uzim, gtar, _maga
  { {0x8ad6000a,0xa3c10037,0x3eba0070,0xa3c30037}},	//   نتائ, ंति_, _typt_, ्षि_
  { {0x4dd60003,0xa77b0009,0xf8bf0025,0xdb080030}},	//   _لتحس, _חריפ, rgée_, nodá
  { {0xa1130003,0x69c90f66,0x3f9800b6,0x6d4b0f67}},	//   لومت, _chee, liru_, _naga
  { {0xa3c30044,0xa3c10037,0x95c70024,0xc9530009}},	//   ्षा_, ंता_, _шлюб_, ימא_
  { {0x44200f68,0xbb760014,0x18670001,0x69c90070}},	//   mui_, _румъ, таљи_, _ehee
  { {0x44200f69,0x6d4b050a,0x2d840061,0x96270012}},	//   lui_, _baga, thme_, نكوك_
  { {0x657b002c,0xe5c6004c,0x3ea0004b,0x442d0f6a}},	//   gkuh, њско, ăit_, fte_
  { {0x37e6007c,0xa3c00044,0x75e700a2,0x98be0066}},	//   _розг, ूगल_, _hızl, ětě_
  { {0x61e300a2,0x2bba0003,0x8e3a0012,0x671c0011}},	//   _bunl, باعة_, _يسار_, _नाटक_
  { {0x442000c6,0x831b000b,0x3377000b,0x9a860015}},	//   hui_, וויז, דעים_, тупл
  { {0x6d4b0160,0x64460028,0x6f070034,0x9695004c}},	//   _gaga, ækis, wajc, _сруш
  { {0x44200f68,0x68ed0164,0x442d0f6b,0x96eb0223}},	//   jui_, ñadi, cte_, дьба_
  { {0x321e002a,0x6d4b09d6,0xdce60035,0x29040f6c}},	//   puty_, _zaga, _rokā, _lema_
  { {0x35e4007c,0xda6f0098,0x91e30001,0x7c2d0002}},	//   ицтв, _тя_, _које, wtar
  { {0x29040f6d,0xed14002d,0x6d400f6e,0x7c2d0f6f}},	//   _nema_, имсь, nema, ttar
  { {0x54550047,0x44200f70,0xdb1a000e,0xc7ab0003}},	// [1dd0] ыват, gui_, elté, _يدخل_
  { {0x2d8200bd,0xd9cb0037,0x656f0052,0xbcfb0061}},	//   _elke_, िष्ट, _woch, _poés
  { {0x7bdc00b6,0x521500b3,0x31ae00d9,0x656f0f71}},	//   _diru, удет, lýzy_, _toch
  { {0x4420007d,0x27e400c6,0x6d400f72,0x442d0f73}},	//   bui_, _bumn_, jema, yte_
  { {0x4420053a,0x442d0f74,0x351a0009,0x7bdc0f75}},	//   cui_, xte_, _אורנ, _firu
  { {0x7dd5007a,0x07090003,0x69c9002a,0x442d00f1}},	//   _išsi, ريبي_, _whee, vte_
  { {0x3e320012,0xdcf60034,0x69c90834,0x6d4b0f76}},	//   مفور, łcąc, _thee, _paga
  { {0xc5f40009,0x0554003c,0x58050012,0xa3e70011}},	//   בדק_, атья, _مورك, _मंद_
  { {0xf1bf0026,0x656900ff,0x28050066,0x33d50024}},	//   dlá_, rjeh, ávně_, ліот
  { {0x9ee90003,0xc0c80014,0x2904001e,0x200909d4}},	//   _أفضل_, _русе_, _zema_, šais_
  { {0xadf5022a,0x3f98013a,0x6d400f77,0x6d4b0f78}},	//   _спеш, viru_, bema, _taga
  { {0x2d9a000e,0xeab20009,0x8dfa0009,0x29040f79}},	//   épet_, מֹר_, _נהנת, úma_
  { {0x628e0029,0xd096003c,0xdb080031,0x3f98016d}},	//   úbor, ушны, sodá, tiru_
  { {0x3ced009b,0x749a000b,0xdb080f7a,0xe7c30011}},	//   lcev_, _אינפ, podá, षतिप
  { {0x98a4003a,0xdbd10051,0x6fc00032,0xa3d70011}},	//   ımı_, _müüj, löck, ागन_
  { {0x22580058,0x3ced009b,0x7d090027,0x9da50012}},	//   ærke_, ncev_, naes, لصقه
  { {0x25bf000d,0xe0da01b6,0x75d30012,0x3942005e}},	// [1de0] ilul_, _яви_, إيقا, meks_
  { {0xdd0400a2,0xbb4a0003,0x39420289,0x44200f7b}},	//   ısın, علان_, leks_, rui_
  { {0x63af004b,0x7984016d,0xa3e40011,0x0f570009}},	//   _ţinâ, _kliw, _पूर_, _עיטם_
  { {0x11d70003,0x673b0027,0x39420051,0xfe9b0009}},	//   هولة_, đuje, neks_, _טיימ
  { {0x644a001e,0x79b70009,0x18330012,0x26c50064}},	//   āfis, נלנד_, مروح, ýlov_
  { {0x39420051,0xc808001a,0x47330024,0x6fb40011}},	//   heks_, rở_, йніс, ंकिं
  { {0x63ab000e,0x63830001,0x8cd60011,0x3942005e}},	//   égne, _угра, मेनो, keks_
  { {0x644d0051,0x746a0593,0x78260003,0x81bd001e}},	//   _üliõ, еров_, _معطل, ntēt
  { {0x6d400f7c,0x69d80073,0x9f9a008e,0x39420f7d}},	//   rema, įved, _pään_, deks_
  { {0x6d8702d1,0x5a340014,0xbc370003,0x6d400f7e}},	//   _añad, анот, اسيا_, sema
  { {0xee290003,0x2d9a000e,0xfbb70009,0x0bb70009}},	//   _لأنه_, épes_, רפית_, רלים_
  { {0xc9870012,0x3942005e,0x25bf004b,0x6fc00b77}},	//   اشدي, geks_, clul_, böck
  { {0x05b30012,0xa3d70011,0x63760f7f,0xb97b00af}},	//   _امنح, ागम_, _sânu, תרכז
  { {0x6376000d,0xba0a0003,0xead40f80,0xf1bf0f81}},	//   _cânt, _كتبك_, _коль, slá_
  { {0xa3c30044,0xa3c10037,0x6b7b000b,0x9bbb0009}},	//   ्षर_, ंतर_, _ארגנ, _רצופ
  { {0xbca50003,0x25ad013a,0x79840034,0xc6150011}},	//   لمزي, čelo_, _gliw, _तटीय_
  { {0xe04b0012,0x33f40012,0x3ebe00b0,0x6376004b}},	// [1df0] _أشبه_, مسلس, _lytt_, _fânt
  { {0x98b9001e,0x290b0f82,0xeb930012,0xf8bf01a0}},	//   cesā_, laca_, حظر_, sfés_
  { {0x3ebe028e,0xd6db002d,0x7d060031,0x69df0031}},	//   _nytt_, _яти_, _feks, _épes
  { {0x3135002d,0xe4e4002d,0x99d40003,0x3547002d}},	//   редр, _гірн, متنا, _схов
  { {0x3ced009b,0xd7050c7b,0xa1ac00af,0xf1940557}},	//   vcev_, азли, עֱבִ, щиць
  { {0x9e090003,0x17f80003,0x9172001a,0x3ebe07c7}},	//   نيتك_, ارنة_, rở_, _bytt_
  { {0x2778000b,0x25bf000d,0x6d4f00b6,0x7d09004a}},	//   רגון_, tlul_, _kaca, taes
  { {0x290b001b,0xed590148,0x6e920012,0x6fc00032}},	//   jaca_, тои_, غليا, töck
  { {0x0d82007c,0x3ebe0065,0xb81c0037,0x57270003}},	//   ільн, _eytt_, _नियम_, _مراق
  { {0x30840003,0x15e50011,0xa75700ae,0x6d4f0f83}},	//   _الكف, कदार_, _حضرت, _laca
  { {0x39420005,0x3ced009b,0x5ac6003c,0xc8690009}},	//   teks_, pcev_, ильм_, _קן_
  { {0xd2b6000b,0x49960024,0xe29601c6,0x7c2d004b}},	//   ילתת_, ршот, раю_, _ţaru
  { {0x764e0028,0x6d7a000b,0x39420051,0x7d060f84}},	//   _ábyr, _שאנח, reks_, _reks
  { {0x394203fb,0x8c1a000b,0x6376000d,0x3c8a0009}},	//   seks_, _יוני, _dâns, _שָׁ֑
  { {0x3ebe0028,0x290b00b6,0x539a01b0,0xe81c0011}},	//   ætt_, baca_, _ביסו, _निभा_
  { {0x60c9009b,0x99900002,0x41b30012,0x64590034}},	//   _ozem, żała_, _ومور, _krwi
  { {0x81bd001e,0xcaf60003,0x19bb000b,0x07a60560}},	// [1e00] rtēt, لساب, _במקב, _вапн
  { {0x6e2f000e,0xb8820066,0xddd80010,0x187b0009}},	//   önbö, říkl, tyvū, _סטיב
  { {0xeb970001,0x4a460449,0x590a0048,0x00e60a21}},	//   јих_, рнев, веем_, ажен
  { {0xc2360009,0x7dc50031,0x3f850522,0x7d0605ed}},	//   ירעו_, dóso, _allu_, _ueks
  { {0xa01b000e,0x33d6002d,0x60c90002,0x70540003}},	//   szöv, _вівт, _czem, إنتا
  { {0x2d800002,0xc7a30014,0xa857000b,0x90570009}},	//   lkie_, оичк, יינה_, יבנו_
  { {0xbb3b000b,0x7fd7000b,0x7c240b45,0xe8e00081}},	//   _שעלי, בוסס_, luir, _muối_
  { {0x3f850051,0xdb070f85,0x44320504,0xad660012}},	//   _ellu_, _skjø, oty_, شابه
  { {0x290b0f86,0x89db0009,0x69c2005e,0xf486091c}},	//   vaca_, _יחלי, mloe, руйн
  { {0x6e3e0033,0x44320f87,0xda7a0048,0xdf490012}},	//   _oppb, ity_, вям_, _مؤمن_
  { {0x61e000a2,0xa6960001,0x4432004a,0xcb13000b}},	//   _kiml, _трај, hty_, חלת_
  { {0x6b9a0054,0x60c0004a,0x25780031,0x067b0009}},	//   sitg, _kymm, _célt_, _שנאל
  { {0x248d0002,0xdbdc0066,0x6d440018,0x2d800034}},	//   czem_, lšíh, deia, dkie_
  { {0xe8e00020,0xdb05006f,0x7c24020c,0x6d4f0b45}},	//   _cuối_, llhö, duir, _saca
  { {0xada50029,0xf2060014,0x603a001e,0x290b0027}},	//   skúš, _тяло, lāmā, paca_
  { {0xccf80001,0x443203d9,0x69c8001e,0xaadb0009}},	//   ићу_, fty_, _ūden, _בחור
  { {0x4424014d,0x6562014a,0x5b1500fa,0x7c240f88}},	// [1e10] num_, _mnoh, ймат, guir
  { {0x6d4f00b6,0x8c1b000b,0x9cd7000b,0x2d800002}},	//   _waca, כומי, שומה_, akie_
  { {0xd251000a,0x5a350014,0x32670001,0x60c9000e}},	//   ثنا_, снет, штав, _szem
  { {0xac19002d,0x10150003,0x2d800f89,0x44240f8a}},	//   _йому_, مبتد, ckie_, kum_
  { {0x765a003e,0x44240efb,0x7d0d0f8b,0x27e90f8c}},	//   _arty, jum_, maas, _juan_
  { {0xbb85000a,0xcc76000b,0x44240f8d,0xe7fa0011}},	//   _السي, _הגשת_, dum_, ्ठता_
  { {0x6fcd0029,0xe718000b,0x8e390012,0xff180009}},	//   júce, בחור_, استر_, בקות_
  { {0x44240065,0xa01b0052,0x69c20054,0x31b20029}},	//   fum_, nzös, cloe, bázy_
  { {0x44240f8e,0xec790015,0xe3b90867,0x000000c4}},	//   gum_, упп_, лби_,
  { {0xd774000a,0x5f740003,0x8c1a000b,0x248d0679}},	//   _والع, _والر, נותי, rzem_
  { {0xe9da0098,0xc3320093,0x7c24000d,0x248d0053}},	//   лко_, הוי_, zuir, szem_
  { {0xa06a0001,0xe9a6002d,0x186a01d4,0x6a960009}},	//   гама_, самп, гами_, מכתא_
  { {0x4424007d,0xb09a002d,0x645d0058,0x79ba0009}},	//   cum_, утнє_, æsid, רֶיה
  { {0xa0270065,0xdce9001c,0x5456000b,0xcc56000b}},	//   _stöð, iječ, _לסנן_, _לבני_
  { {0xc9f5000a,0x51f50003,0x2d800002,0x64490052}},	//   _استع, _استر, tkie_, lwei
  { {0x443201d5,0xceb2000b,0x752901e0,0xb6a3048c}},	//   tty_, פין_, ngez, числ
  { {0x98b9007d,0x6449008b,0x69c20070,0x1ddf0037}},	// [1e20] resă_, nwei, vloe, _पूछत
  { {0x212d00b6,0x5f460003,0xa01b000e,0x2d800250}},	//   _aceh_, _اندل, rzöt, skie_
  { {0x7d0d0051,0xd36f0003,0xe8fa0001,0x64490f8f}},	//   baas, عهم_, гле_, hwei
  { {0xed5f0029,0x64550035,0x32170012,0x75290227}},	//   ážte_, āzij, إيند_, jgez
  { {0xa3e70044,0xc013002d,0x3a250070,0x7c240502}},	//   _मूल_, зміщ, hulp_, quir
  { {0xe8200044,0x2fd70003,0xa0070003,0xef0e0048}},	//   _बिना_, موند_, حقول_, амa_
  { {0x52860003,0xb7db000b,0x44240002,0x442007c4}},	//   _الأك, נקצי, wum_, lri_
  { {0x3f9c0006,0x64490052,0x9f84004a,0x9bf40024}},	//   sivu_, fwei, löä_, озич
  { {0x40960003,0x161a0011,0x9dad0011,0x79820034}},	//   _الذر, _नटवर_, ँकड़ो, mkow
  { {0x44200065,0xd2140001,0x7a380024,0x7b660148}},	//   iri_, омоћ, апор_, стие
  { {0xb7d70003,0x8afc0002,0x44240f90,0xd4e60048}},	//   _اولا_, djęt, sum_, _люли
  { {0x7982003e,0x44240065,0x6562004a,0x8afc0002}},	//   nkow, pum_, _unoh, ejęt
  { {0x39520036,0xd0060003,0x27e90f91,0x853b000b}},	//   _days_, بل_, _quan_, _תגדי
  { {0x799d00c6,0x9cd70009,0xf0930009,0xd5be0035}},	//   sisw, _הודה_, לנר_, žādo_
  { {0x7a1c007d,0x53370009,0x4b370009,0x877b0009}},	//   nătă, _לנגן_, _לרגל_, נאלי
  { {0x63ba012e,0xe9a40001,0x7df1001e,0x32530014}},	//   lotn, _најп, _jāsa, _хвър
  { {0x79820002,0x44200f92,0x2d580021,0x6fb50012}},	// [1e30] dkow, gri_, щить_, _ومبا
  { {0x7d0d0051,0x5b150024,0xdce9001b,0x2d9e08cf}},	//   saas, імет, vječ, éter_
  { {0x26c70029,0x7d0d004a,0x64490032,0x27f80159}},	//   _áno_, paas, zwei, _črna_
  { {0xf1c90044,0x41c90037,0x44200f93,0xdce90027}},	//   रतिन, रतिस, bri_, tječ
  { {0xa3d50014,0x63ba0f94,0x18690209,0xe72e0294}},	//   _момч, kotn, рали_, ме_
  { {0x36190047,0x98b90010,0x66fb0011,0xdce9001b}},	//   ацию_, cesą_, ्रिक_, rječ
  { {0x994d0026,0xdce90027,0xdb010060,0xff180009}},	//   môžu_, sječ, rolü, זקות_
  { {0x4c85007c,0x25a90597,0x64490f95,0x06960012}},	//   жлив, nnal_, twei, غنية_
  { {0x61ea0052,0xb4650024,0x39520132,0x13e6003c}},	//   _aufl, ікол, _rays_, омый_
  { {0x6449008b,0x290f0f96,0x3952002a,0xeb9900db}},	//   rwei, laga_, _says_, рио_
  { {0x89aa0047,0x39520108,0x6449008b,0x753d0002}},	//   иков_, _pays_, swei, _obsz
  { {0x290f01b7,0x15a80048,0x44200f97,0xf7690009}},	//   naga_, _лъчи_, yri_, _בק_
  { {0x2bbe0044,0xfd100012,0x43850012,0x25a908ca}},	//   ्तमा, _سجن_, _ولصق, dnal_
  { {0x3952002a,0x79820002,0xbae50012,0x290f0f98}},	//   _ways_, zkow, _بكثي, haga_
  { {0xdb01000f,0x290f0f99,0x79820002,0xaf99027f}},	//   soló, kaga_, ykow, стях_
  { {0xa0a6002d,0xa3c30037,0x290f002b,0xf6520009}},	//   _майд, ्षक_, jaga_, וצל_
  { {0x7d0b000f,0x9f840006,0x0eb60037,0xa7d60012}},	// [1e40] _megs, töä_, _आँकड, _وتخص
  { {0x76410e46,0x44200f9a,0x2bcf0037,0x7d0b0f9b}},	//   _oply, rri_, _सीमा, _legs
  { {0x7982003e,0x98b9007a,0x4375002d,0x61400028}},	//   tkow, resą_, чутт, _nálæ
  { {0x08c6004d,0xed5a04fb,0xae570009,0x9f84008e}},	//   обен, _том_, _וסטס_, söä_
  { {0x79820002,0xf993000b,0x9172001a,0x69c6009f}},	//   rkow, ורא_, iờ_, ilke
  { {0xdfcf000a,0x79820002,0x9af60012,0x394601e3}},	//   نين_, skow, _ذكرت, seos_
  { {0x290f01b7,0xa3d70011,0x394601e3,0x46140012}},	//   baga_, ागर_, peos_, أوبر
  { {0x61e4004a,0x63ba0d61,0xd5b00012,0x71660012}},	//   _niil, wotn, عفة_, _باسك
  { {0x236a0001,0xb143002d,0x61ea000d,0x63ba0826}},	//   ајно_, _інфл, _sufl, totn
  { {0xc43b000b,0x25ad0133,0x2480003a,0x61fe07c7}},	//   סתיי, čeli_, iyim_, oppl
  { {0x3266002d,0x5ea60012,0x63ba0f9c,0xdb0101a0}},	//   ітов, _بمال, rotn, tolò
  { {0x63ba009b,0x656f0052,0x9c660012,0xdebb0009}},	//   sotn, öcht, _وهاو, _דמבל
  { {0x7dd50010,0xdb0101a0,0x7df10035,0x83f80048}},	//   _išsp, rolò, _jāsn, _уелс_
  { {0xa2940024,0x35c30011,0x5bc60012,0x60cd0159}},	//   _налі, _वीज़, _بتصف, _vzam
  { {0x69330013,0x25a00051,0x9df8000b,0x290f002c}},	//   _přeč, fiil_, מִּז, yaga_
  { {0xf568002d,0x481500f5,0xd0110012,0x74a70a36}},	//   ошук_, _емис, _كلب_, ојзе
  { {0x6ebb0037,0x99d40003,0xe8e0001a,0x290f0051}},	// [1e50] _शुरु, _تتوا, _buổi_, vaga_
  { {0xd25b069b,0x03d4002d,0xbcfb0064,0xdb1a0097}},	//   ице_, джую, _iném, amtö
  { {0x25a00051,0xdced0027,0x8aa70024,0xfc3f0081}},	//   biil_, ljač, црад, _axít_
  { {0x99810030,0xdced001b,0xb5a7052c,0xe81c05f3}},	//   ruhů_, ojač, _фрой, _निशा_
  { {0x644f00c1,0x24920002,0xdd100f9d,0xdca60012}},	//   _usci, czym_, _užši, _أى_
  { {0x442900c6,0xdceb0034,0x637f0018,0x69c00060}},	//   mua_, _mogą, _têni, _ekme
  { {0x64420017,0x44290f9e,0xf96b0264,0x91720081}},	//   _apoi, lua_, _край_, hớ_
  { {0x3cf70037,0x76410029,0x4429004b,0x66150031}},	//   ीरें_, _vply, oua_, iszk
  { {0xc9520009,0xdced001b,0x752d0031,0xc0580024}},	//   _אמן_, jjač, igaz, _міф_
  { {0xcf780003,0x4429004b,0xab29004c,0xe3b10012}},	//   _وإلا_, iua_, љона_, عرة_
  { {0x61e4004a,0x764101e9,0x656f0032,0xb6030030}},	//   _piil, _uply, öchs, ýšle
  { {0xe8020044,0x4429004a,0x644f0058,0xed580024}},	//   रीका_, kua_, æcis, _моє_
  { {0x38550014,0x25a0005e,0x66150efc,0x61e40f9f}},	//   мърс, viil_, eszk, _viil
  { {0x442906ac,0xddc10066,0xcc760009,0xabfa0009}},	//   dua_, _splň, _מענה_, _ההסר
  { {0x6abc0032,0x7c290fa0,0x61e4008e,0x25a0005e}},	//   ürft, luer, _tiil, tiil_
  { {0x291e0010,0xceb20009,0xa06a004c,0x63a10fa1}},	//   ėtas_, ׂים_, _гаиа_, liln
  { {0x201a0003,0xd4670a31,0x98a600f5,0xc4c60012}},	// [1e60] _اتبع_, пите_, _хипе, سترو
  { {0x645b004a,0xe7ef0011,0x63a109df,0x909b0009}},	//   ivui, _चढ़ा_, niln, _לספק
  { {0x61fe0065,0xb77b0093,0x2492003e,0x877b000b}},	//   uppl, _האיש, szym_, _האיי
  { {0x3cf70037,0x290d000d,0x7e610058,0x673c0028}},	//   ीरों_, _ceea_, ælpe, lfrj
  { {0xa3cb0044,0xe8e0001a,0xbc190024,0x93c6004b}},	//   लता_, _tuổi_, _мірі_, epăş
  { {0x26c50013,0x68ed0029,0xfbc70012,0xbf9b0025}},	//   _bylo_, ľada, _ست_, mpêc
  { {0x68ed0013,0x63a1012e,0x6b630024,0x16370012}},	//   žada, diln, _якра, كسية_
  { {0x7c290164,0xb6080066,0x63be001b,0x63a10032}},	//   fuer, jišť, lopn, eiln
  { {0x8e200024,0xbd870012,0xbcfb0064,0x26080011}},	//   рiв_, ثنين_, _poéz, _सबकी_
  { {0x57fb0093,0x53be0037,0x70170009,0x53980024}},	//   _ללמו, ्तिश, _מחמד_, івня_
  { {0xfbcf0012,0x7c290032,0x7df10035,0xa3e40011}},	//   دتي_, auer, _jāsl, _पूछ_
  { {0xed590107,0x63be014a,0x9f4401a0,0x6d49004b}},	//   tože_, hopn, _humà_, ceea
  { {0x7c290164,0x53340015,0xf1bf0064,0xf1b00012}},	//   cuer, _желт, ýšia_, اءٍ_
  { {0x44290006,0x61ee0061,0x44a50012,0x07090012}},	//   vua_, _oubl, _تحمّ, تيسي_
  { {0x8b3b000b,0x433b000b,0x733b000b,0xc6680001}},	//   _התוצ, _העוב, _העוס, пште_
  { {0x7d04002c,0x44290fa2,0x7c240fa3,0x66150031}},	//   gbis, tua_, frir, rszk
  { {0x3f8c003a,0x6fcd0029,0x752d000e,0xd91c000b}},	// [1e70] _oldu_, dúcn, rgaz, _הוחל
  { {0x3b540fa4,0x026b003c,0x25a00030,0x7d040fa5}},	//   нкур, йшей_, čily_, abis
  { {0x7bda0065,0x798d0002,0x4429086e,0xb606001b}},	//   imtu, _klaw, sua_, nošć
  { {0xc5f80039,0x44290fa6,0x7dc501c5,0x99d70012}},	//   ģēt_, pua_, pósi, ستضا
  { {0x27ed001a,0x98c70012,0x7c240025,0x44290fa7}},	//   _quen_, أغان, crir, qua_
  { {0xf7710003,0x777a0054,0x394b0025,0xdb23008e}},	//   ضات_, _cotx, hecs_, äräa
  { {0xdce9001e,0x63a10fa8,0x6e950012,0x64420025}},	//   pieļ, viln, بلغا, çoiv
  { {0x27ed0fa9,0x63a10034,0xdb0501a0,0x3f8c0097}},	//   _tuen_, wiln, cohò, _eldu_
  { {0x97250012,0x69c30025,0xed590159,0xfd580009}},	//   _يفرو, îneu, tožb_, לשהי_
  { {0x7d0f000e,0x7d040052,0x33990012,0x645b0227}},	//   _lecs, zbis, تخبة_, rvui
  { {0xcb12000b,0x3ce60029,0x63a10faa,0x3dc9002c}},	//   כלי_, ľovi_, riln, klaw_
  { {0xa96a0046,0x499a007c,0x7c240065,0x7c290164}},	//   цима_, ітня_, yrir, puer
  { {0xbcfb0029,0xc9160009,0x7c290fab,0xd1160009}},	//   _inéh, וחרת_, quer, וקרה_
  { {0x7df50010,0x8c420de1,0x7c240fac,0x3f8c00d9}},	//   _sąsa, _реше, vrir, ódu_
  { {0xaa92000a,0x7d0f000f,0x25ad0058,0xe7370015}},	//   _للوث, _becs, onel_, ьер_
  { {0x3cf50044,0xceb2000b,0x25bf000d,0x99520010}},	//   एँगे_, דיל_, noul_, ršų_
  { {0x7d040101,0x64a30001,0xa01b004a,0x6fcd0029}},	// [1e80] rbis, вата, lyön, júco
  { {0x387f0052,0xaad10011,0x6fcd0064,0x1c39003c}},	//   äure_, _हराक, dúco, яясь_
  { {0x68ed0064,0x72030012,0x7dc50031,0x63be0fad}},	//   ľadn, َوْم, lósu, ropn
  { {0xdce90013,0x2f0a0002,0xda650003,0x80a60012}},	//   ěněn, _mógł_, عالي, ومان
  { {0xb8f60044,0x7bc80028,0xd7ef0003,0x7bc3016d}},	//   _हर_, yldu, لكن_, _oknu
  { {0xa634002d,0x61ee0051,0x4b550048,0x25ad0060}},	//   енкі, _tubl, _пъст, enel_
  { {0x9f8d0028,0x69c40fae,0x97c50012,0x114a0012}},	//   nþá_, _okie, رتهم, _وجرى_
  { {0x2dd7000a,0x99860066,0x1d340048,0xba9b0009}},	//   وبية_, dulů_, хния, _וסלי
  { {0x7e870010,0xdb18068c,0x21a30faf,0x5b7400ae}},	//   _įspū, _akvá, _ритм, ُّخذ
  { {0x42740015,0xa87b0009,0x807b0009,0x307b0009}},	//   егос, _ואמר, _ונמצ, _ואמנ
  { {0xe9f8002d,0xfe460024,0xa159004c,0x798d016d}},	//   янні_, _індо, пану_, _plaw
  { {0xc486007c,0x2167002d,0x1ea90012,0x85f70009}},	//   _олек, фтог, _عالي_, _חמאס_
  { {0xc058002d,0xf5770003,0x10740109,0xa3e70011}},	//   мір_, _تمنع_, вляю, _मंच_
  { {0x0efb0037,0xbc670012,0x27c400ae,0x880605f3}},	//   ्रेस_, _آمون_, َيَّ, सीएफ़_
  { {0x7dea0002,0x3bbb0009,0x5b330012,0x386d004b}},	//   _gęst, _ומגד, _شعور, ţer_
  { {0xcdd80001,0x58d5003c,0x99990034,0x03f9004c}},	//   дњу_, _пойт, żyła_, знај_
  { {0xdb01005e,0x7d0201e3,0x60c00032,0x69dd0fb0}},	// [1e90] rolö, ñosa, ümmt, mmse
  { {0x6d97000d,0x2bb80012,0x1a8b0012,0x43740024}},	//   nţar, والة_, يضاً_, куєт
  { {0x98ac0002,0xdcee0030,0xc50b0012,0xe7e80011}},	//   ędą_, ýděl, _وتحل_, _टूटा_
  { {0x68ed0029,0xe5070012,0x8aab0009,0x7d1d0032}},	//   ľado, _تبدي, חֹדֶ, _udss
  { {0x6cfa0093,0x50670003,0xb4fa000b,0x68ed0107}},	//   _מפרס, بطاق, _מפרי, žado
  { {0x6d420132,0xd00e0012,0x7e550fb1,0x657d0fb2}},	//   _aboa, حلو_, етиц, _hosh
  { {0xee3900bc,0x2bbe0037,0x7c2d0fb3,0x23be0037}},	//   їни_, ्तरा, luar, ्तरद
  { {0xc8670048,0x50670048,0x63a5016d,0xec790048}},	//   _отзи, _отза, lihn, зпи_
  { {0x73e50048,0x25ad0fb4,0x25bf004b,0xed590fb5}},	//   ноиз, rnel_, roul_, rdž_
  { {0xa3bf0037,0x69c401f6,0xe2990001,0x99860066}},	//   ँकि_, _skie, зао_, tulů_
  { {0x61e90006,0x20190028,0x6d4d004a,0x7c2d0051}},	//   _kiel, essi_, keaa, huar
  { {0x865a0009,0xf9920012,0x4c950048,0x99d60012}},	//   _מדעי, ابد_, _пиес, عتدا
  { {0x7a3500a2,0x5576000b,0x656b00c1,0x9c870012}},	//   _bütç, _רענן_, _ingh, _تشاه
  { {0x61e90039,0x7dea007a,0x7c2d08b3,0x69cb0052}},	//   _liel, _tęst, duar, hlge
  { {0x0b780003,0xcb660015,0x3c43001e,0x6d590fb6}},	//   _تصنع_, _чаще_, hīvā_, _kawa
  { {0x6d5900c6,0x6d5b0167,0x52740003,0x69c40034}},	//   _jawa, ndua, _جاهز, _ukie
  { {0x6aa80037,0xeb39000b,0x6d590a60,0x809f0011}},	// [1ea0] कप्र, ּעֲש, _mawa, _खेले
  { {0x68ed0002,0x6d5900b6,0xe45f008e,0xa3c10011}},	//   _zgad, _lawa, _työn_, ूति_
  { {0xc4c9000b,0xe7330009,0xa92603cd,0x2d8f005e}},	//   צג_, _עֵץ_, едел, _olge_
  { {0xb17b006f,0x61e90fb7,0x6d590fb8,0x6d4d0227}},	//   rmåg, _ciel, _nawa, ceaa
  { {0x6376007d,0xd117000b,0x4fc6004d,0x61e90fb9}},	//   _vânz, תקנה_, нска, _diel
  { {0x501b000b,0xdb070028,0x7d160fba,0xfaa60fbb}},	//   לונו, _skjö, lays, _заго
  { {0x6d590160,0x61e90fbc,0x3ce60064,0x7c3b0fbd}},	//   _bawa, _fiel, ľovu_, etur
  { {0xdd970015,0x09e30578,0x6d59016d,0x89da0012}},	//   ешь_, _босн, _cawa, _روذر_
  { {0x7c3b002c,0x6d590fbe,0x98af0073,0xdb1e01a0}},	//   gtur, _dawa, degė_, topè
  { {0x09c90044,0x9696046d,0x61e90fbf,0x51f80024}},	//   रत्य, _преш, _ziel, мною_
  { {0x200d008b,0xeb97000b,0xdb080002,0x61e9002a}},	//   _zwei_, גדיר_, wodó, _yiel
  { {0x6d590a60,0xbbbe0011,0xdb01008e,0x442d0fc0}},	//   _gawa, ्तुक, enlä, bue_
  { {0x20190061,0xe82a0009,0x802a0009,0xc19b0009}},	//   ussi_, הוָֽ, הוָ֥, לשטי
  { {0x6d59003e,0x7bc1007d,0xa3cb0011,0xdb080034}},	//   _zawa, colu, लतः_, rodó
  { {0x7dc50065,0x39820065,0x6f15009b,0x2e4800b3}},	//   póst, _póst_, razc, нято_
  { {0x40950003,0x7bde00b6,0x99810030,0xb8950012}},	//   _للبر, empu, vrhů_, _للبع
  { {0xf9940009,0xb81c0011,0x83350048,0x6d4d09e0}},	// [1eb0] _תרפ_, _निगम_, кнах, reaa
  { {0xb17b0058,0x61e90606,0x3df500f5,0xe9df0031}},	//   småd, _siel, _изос, lmú_
  { {0x61e90039,0x6d4d0fc1,0xfbd00012,0x7c2d0fc2}},	//   _piel, peaa, صتك_, suar
  { {0x4ac40003,0x3c43001e,0x628500d9,0x361a0009}},	//   ديمق, tīvā_, ryho, _קורד
  { {0x61e90fc3,0x6d5900b6,0x89340012,0x7c3b030d}},	//   _viel, _rawa, اعما, xtur
  { {0x61e9003e,0x4429000f,0xdce90027,0x77f8000b}},	//   _wiel, mra_, ljeć, עמוד_
  { {0xead40015,0x44290fc4,0xcf580009,0xcb120009}},	//   _борь, lra_, גבות_, _כלם_
  { {0x1c45002d,0x7c3b0fc5,0x7bc10002,0x8d65004d}},	//   вним, ttur, wolu, твие
  { {0xe432000a,0x44290fc6,0xfc160012,0xddc90031}},	//   لفيد, nra_, نقيب_, ínűb
  { {0x6d5902a0,0x44290fc7,0x7bc1008e,0xe7190012}},	//   _wawa, ira_, uolu, _آيات_
  { {0x36750003,0xa2a70037,0x6d59060b,0xfbd20009}},	//   _جهاز, _टेम्, _tawa, שתי_
  { {0xe4d90003,0x44290fc8,0xdb1e0fc9,0xf8a70012}},	//   _قوات_, kra_, ropé, لة_
  { {0x291200a1,0x9f9b0051,0x4429000e,0x442d0fca}},	//   _veya_, pääs_, jra_, que_
  { {0x44290fcb,0x7aa50003,0x7c290fcc,0x321a0034}},	//   dra_, _لإعل, mrer, yspy_
  { {0xd4f6003c,0x99860012,0x395b0fcd,0x7d0201e3}},	//   вязы, _للثو, _faqs_, ñoso
  { {0x3205002a,0xf86605fb,0xdd920012,0x89360012}},	//   mply_, _авио, جور_, _شعبا
  { {0xa91d001c,0xd7060098,0x2bf60015,0x5f060014}},	// [1ec0] _možd, _изпи, тябр, _изпа
  { {0xaf0a0003,0x6e2e00c1,0x78ad0066,0x7d16002c}},	//   _تقدم_, pubb, šová, says
  { {0x7c29008b,0xfeba0012,0xd24f0012,0xdee6004c}},	//   hrer, _زادت_, ينك_, _јони
  { {0x104a0024,0x9975003c,0xdd05004b,0x637e0030}},	//   дяки_, лучш, ăsăr, _záně
  { {0x81bd001e,0xa8ad0009,0x44290fce,0x7d090fcf}},	//   frēj, ּבוֹ, cra_, dbes
  { {0xe7180003,0x889b000b,0x7dd50010,0xc66a003c}},	//   ريبت_, ובני, _išsy, дшие_
  { {0x98b200a2,0x092a0003,0x7c290fd0,0x1e960048}},	//   ıyı_, _يسري_, erer, ърдр
  { {0xed87002d,0x6ce6002d,0xceb3000b,0x7d090fd1}},	//   вськ_, кіпе, ייו_, gbes
  { {0xdb1c0066,0xc0450012,0x32050132,0xc0e3076b}},	//   _zkrá, _مخلو, eply_, _вотк
  { {0xf4130093,0xe3af0012,0x98750060,0x32540430}},	//   ספת_, ْرَ_, lüğe_, гвор
  { {0xc3330093,0xc56a0003,0xd6250012,0x44290fd2}},	//   בות_, _يحصل_, _معني, zra_
  { {0x6f18009b,0x44290fd3,0x7c290fd4,0x316d0bce}},	//   lavc, yra_, brer, ñez_
  { {0x9c9a0012,0xf2060011,0x60d60034,0x7c29032f}},	//   _تنشط_, वीज़_, _czym, crer
  { {0x547b0093,0x44290fd5,0xe9df0029,0x9cd70009}},	//   _קטגו, vra_, smú_, _סוגה_
  { {0xdb060030,0xb8ca0011,0xcb8b0009,0x2bec05f3}},	//   ámýc, _गे_, _קְדֹ, _अंजू_
  { {0x865b0009,0xa91d0030,0x7bc704a7,0x7afd0030}},	//   ודלי, _kože, _skju, ěste
  { {0xdb1c0065,0xfbd90001,0xfaff001e,0xb4d5003c}},	// [1ed0] _skrá, едај_, žīms_, ужащ
  { {0xa91d077d,0x8f55007c,0xfecb0003,0x17550014}},	//   _može, _свої, _يبدو_, _своя
  { {0x4429000f,0x61ed000e,0x75220b28,0xc2c40012}},	//   sra_, _kial, _odoz, ليكي
  { {0x3264002d,0x629a000e,0x7d090070,0x29190fd6}},	//   штув, izto, xbes, nasa_
  { {0xc19c000b,0x90450003,0x63a80027,0x23b40011}},	//   ושאי, انته, kidn, ुवाद
  { {0x291900c6,0x752200b8,0x2d820fd7,0x89fb0012}},	//   hasa_, _adoz, öken_, _يعزز_
  { {0x6d5d01e5,0x3f810013,0x86980014,0x27ec002a}},	//   _kasa, _mohu_, ктът_, _didn_
  { {0x63a80fd8,0x7c290fd9,0xe4590e5f,0x99d40012}},	//   eidn, trer, ежи_, _نتقا
  { {0x60cd00b6,0x1be9003c,0x6d5d0fda,0x629a0035}},	//   _nyam, ндии_, _masa, ezto
  { {0x60d60002,0x2bd90037,0x7d090fdb,0x7c290fdc}},	//   _rzym, _बीमा, sbes, rrer
  { {0x6fcd0026,0x7d090c86,0x16380012,0x60d60034}},	//   júci, pbes, _لسنة_, _szym
  { {0x6fcd0029,0x2d940024,0x32050132,0x7c290fdd}},	//   dúci, _кріс, rply_, prer
  { {0x9b45000a,0xc952000b,0x7bc50051,0xb0de0011}},	//   _منشو, צמך_, kohu, नेंग
  { {0x9474000a,0x443f0039,0x656f0fde,0xa142001e}},	//   _خدما, mtu_, _anch, ēķin
  { {0x29190101,0x443f065a,0x629a0002,0x62880002}},	//   basa_, ltu_, czto, cydo
  { {0x61ed00c1,0xd5e606bd,0x5de60fdf,0x6da3004c}},	//   _gial, ужби, ужба, биса
  { {0x6d5d00c6,0x69c60010,0x4fb60012,0xfca90012}},	// [1ee0] _dasa, moke, _مصدر, ناكو_
  { {0x443f0fe0,0x28b70037,0x6fcd0fe1,0x656f0fe2}},	//   itu_, _आख़ि, búci, _ench
  { {0x443f0051,0x092a0015,0x201f0054,0x5757000b}},	//   htu_, ежей_, _avui_, _גביע_
  { {0x7d56002d,0x644b014f,0x8d56076b,0x05560fe3}},	//   _стої, _opgi, _сточ, _стоя
  { {0xdefa0047,0x657b0051,0xa0670001,0xa2ca0037}},	//   ный_, djuh, лаца_, _सुन्
  { {0x6d5d0fe4,0xa857000b,0xcb760001,0xdb1c0058}},	//   _zasa, טינה_, _сумњ, _skræ
  { {0x6d5d00a2,0xa01b004a,0x69c6004a,0x569400a6}},	//   _yasa, työk, koke, райт
  { {0x7df5039c,0x99420002,0x010a0012,0x8e470012}},	//   _sąsk, _cóż_, _سترو_, اليك_
  { {0x443f001e,0x41270014,0x94760012,0x35b90011}},	//   gtu_, _щото_, ادعا, आवज़
  { {0x40930003,0xb8930003,0xf2060014,0x291902a0}},	//   _الكر, _الكع, лямо, wasa_
  { {0xc333000b,0x73770009,0xf363003c,0xa1750024}},	//   זות_, אגיד_, стын, агні
  { {0x443f00b6,0x7df50034,0x2919016d,0xdb010018}},	//   btu_, _wąsk, uasa_, gilâ
  { {0x291900c6,0x629a0fe5,0x7d1d0028,0x6d5d0fe6}},	//   rasa_, szto, ðsse, _rasa
  { {0xd3700003,0x98a90002,0x22580058,0x6fcd0fe7}},	//   _ذهب_, żać_, ærks_, túci
  { {0xcddb0046,0x69c6079d,0x25a90fe8,0x12fb0009}},	//   ења_, boke, tial_, _אהוב
  { {0x5558002d,0x2d5804b3,0x56940232,0x3cb50048}},	//   лася_, лись_, щаст, айбр
  { {0xe3150001,0x9986000e,0xdb080018,0x39490fe9}},	// [1ef0] имањ, cslő_, vidê, _ibas_
  { {0x25a90fea,0xa01b004a,0x9cd7000b,0x39b10010}},	//   sial_, vyöh, רומה_, mąsi_
  { {0xd251000a,0x7ceb000e,0xaa55035c,0x3255034a}},	//   تنا_, _körü, рвеш, рвер
  { {0x3d0e0037,0x25fb0011,0x321e0034,0x7bc5005e}},	//   सरों_, _लंबी_, isty_, sohu
  { {0x9987000e,0x443f0107,0xb8fd0037,0xf3ff0017}},	//   énő_, xtu_, _डर_, _irão_
  { {0x8ae7002d,0x16390003,0xdb080017,0xd7020024}},	//   _бібл, نسبة_, sidê, озши
  { {0xed590047,0x66240003,0xd7380009,0xb3ba0009}},	//   вой_, مريك, אטות_, _ימשכ
  { {0xd6ce0003,0x7c2d00c1,0xd5b10003,0x3869000d}},	//   بقى_, orar, تفع_, _orar_
  { {0x9984000a,0x0c360003,0xed600030,0xf9920009}},	//   _القو, لكية_, ážit_, _ורן_
  { {0x657b0051,0x2d8d0feb,0x4a4503db,0x395f0fec}},	//   sjuh, skee_, анов, _haus_
  { {0x659500b3,0x7d0d006f,0xa2cb0011,0xeab10012}},	//   _кажу, kbas, _तुम्, تعة_
  { {0x9f490065,0x2fc70fed,0x88e60021,0x7c2d0fee}},	//   _stað_, long_, ижне, krar
  { {0xa2a70037,0x69c60fef,0x7d1b0ff0,0x2d820159}},	//   _टेस्, roke, maus, _roke_
  { {0x2fc70101,0x2329002d,0xdc9a000b,0xdb1a000e}},	//   nong_, _роки_, _בינל, potá
  { {0x442d000e,0x66e60ff1,0x9f4501a0,0xdee60ff2}},	//   lre_, рова, _milà_, рови
  { {0x7ceb00a1,0x2fc70101,0x7d0d002c,0x442d0ff3}},	//   _görü, hong_, gbas, ore_
  { {0x2fc70175,0xd6d90002,0x6d440ff4,0xdb080025}},	// [1f00] kong_, ęła_, rfia, fidè
  { {0x442d0108,0x8b26002d,0x4432001a,0xdb230028}},	//   ire_, рдже, ruy_, ærða
  { {0x2fc70101,0x442d008b,0x7d1b0cce,0x2d9e0061}},	//   dong_, hre_, kaus, ètes_
  { {0xdb1c006f,0x7d1b0d66,0x61460ff5,0x3ebb0009}},	//   _skrä, jaus, реда, _יציב
  { {0x442d0058,0xed570014,0x79b70009,0x7bdc0ff6}},	//   jre_, _тоя_, סלנד_, _thru
  { {0x2fc701e5,0x5f930001,0x44200190,0x7df50ff7}},	//   gong_, жишт, msi_, _sąsi
  { {0x257c0066,0xd5ba09ca,0x09e60024,0x8e370012}},	//   _síly_, кси_, _вовн, لسير_
  { {0x3006002d,0x7d1b0010,0x395f0010,0x2fc7002c}},	//   _взаг, gaus, _gaus_, aong_
  { {0x2fc70101,0x9f4c0066,0x44200ff8,0x90490012}},	//   bong_, _lidé_, nsi_, _مؤلف_
  { {0x883b0093,0x46a60098,0x23c60037,0xbea60024}},	//   _בתמו, _казв, वविद, _казк
  { {0xd257002d,0x442d0ff9,0x64400ffa,0xa2f70009}},	//   аця_, are_, stmi, ימיה_
  { {0x7d1b0036,0x44200ffb,0x04460014,0xc27b000b}},	//   caus, ksi_, _ведн, דרטי
  { {0xdcef0039,0xd0060003,0x9f840028,0x98b3001e}},	//   ādīt, ثل_, töð_, _ādīt_
  { {0x7c2d075e,0x395f09d4,0xe4510009,0x8c1b0009}},	//   vrar, žus_, _זֶה_, _יודי
  { {0x61410272,0x44200006,0xe5730012,0x22570012}},	//   náló, esi_, يطر_, _نجيب_
  { {0xf27b000b,0x527b000b,0xb1150048,0xb594003c}},	//   _ירוש, _ינוא, _умиш, оисш
  { {0x2fc701e5,0xe4e7007c,0xdce6007a,0x5ce7002d}},	// [1f10] yong_, рівн, _mokė, рюва
  { {0x47350001,0xea670001,0x09bf0037,0x0eb60011}},	//   _унос, ињен, एक्य, _अखंड
  { {0x1756000b,0x442d0ffc,0x44200ffd,0x59bb0011}},	//   _הסתר_, zre_, asi_, _उदार
  { {0xdb080054,0x442d0ffe,0xa91d0412,0x7bc8009e}},	//   sidè, yre_, _boža, hodu
  { {0x2fc70160,0x7d1b004a,0x4dda000b,0x44200f7a}},	//   tong_, vaus, _תחרו, csi_
  { {0x2fc7002c,0x442d0fff,0xdb010031,0x905800af}},	//   uong_, vre_, kilá, יבדו_
  { {0x2295000a,0x1ec90047,0xa6c90015,0xaa950003}},	//   _الأس, ылки_, ылка_, _الأث
  { {0xc6b8000b,0xdeb80009,0xa2a00011,0x05620048}},	//   יהוי_, יפוח_, _गेट्, звън
  { {0x291d0101,0x442d1000,0x31600017,0x2fc71001}},	//   mawa_, ure_, _raiz_, pong_
  { {0x291d002c,0x7d1b0052,0xb4f40011,0xb35f0024}},	//   lawa_, saus, _अल्प_, змiщ
  { {0x442d000f,0xdb06000e,0x7d1b1002,0xa91d0159}},	//   sre_, émák, paus, _zoža
  { {0x291d0101,0xcf89000b,0x6f1c0002,0x68ed022d}},	//   nawa_, _אט_, warc, žadu
  { {0x8d5a000b,0xa4d4002d,0xafe6002d,0xe8d50009}},	//   _תכני, _доці, йомл, מוֹר_
  { {0xa7da0003,0x5bc40012,0x6b9a01e0,0xe8190011}},	//   اوسط_, _وتوف, chtg, नीया_
  { {0xc7d6000b,0xc7af0012,0x644f0035,0x44200a94}},	//   מושי_, رّف_, _apci, wsi_
  { {0x442001a3,0xe5a31003,0x6dac0060,0x3d120011}},	//   tsi_, писи, aşan, ़रें_
  { {0x7b06000f,0x0326002d,0xdd8f0003,0x6141000e}},	// [1f20] _érté, йдан, روك_, záló
  { {0x44201004,0x74130012,0xc9100011,0xa3dd0011}},	//   rsi_, سوما, ार्म_, _थीम_
  { {0xdb07000f,0xa96a0001,0x44201005,0xe1f20012}},	//   ámár, лижа_, ssi_, سسا_
  { {0xf1a5007c,0x291d0101,0xa91d0107,0x6141000e}},	//   орін, gawa_, _poža, váló
  { {0x53c70044,0x25ad0029,0x629e0123,0x493b0009}},	//   रकाश, diel_, szpo, רגנו
  { {0xbb860003,0x9b960003,0x6d4b0052,0x98ad0034}},	//   _الآي, _الست, _abga, żeć_
  { {0x25ad00bd,0x3f851006,0x6444004a,0x8e470012}},	//   fiel_, _dolu_, ltii, ملوك_
  { {0x7bc8003e,0xe5c60001,0xdb011007,0x5bd00011}},	//   wodu, љско, vilá, हत्व
  { {0x764300b6,0x64440038,0x7c960012,0x53980148}},	//   atny, ntii, إشعا, ивия_
  { {0x388e0039,0x5c5b0009,0xa3d80011,0x61e60227}},	//   _vērā_, נדיק, ाति_, emkl
  { {0x64d50044,0x25ad0070,0x3f850028,0x6444004a}},	//   _दर्श, biel_, ölum_, htii
  { {0x64440176,0xb2bb0009,0xad650012,0x3d120011}},	//   ktii, רמטר, _وانه, ़रों_
  { {0xa3d80044,0x23e6002d,0x3f85003a,0x200b094e}},	//   ाता_, _лікв, _yolu_, upci_
  { {0xdbf10013,0x0a94002d,0x92940014,0x291d1008}},	//   _příl, _малю, _малц, zawa_
  { {0xa1430039,0xd6d90002,0x56941009,0xaba50012}},	//   šķir, ęło_, парт, _بإنه
  { {0x81bd0035,0x7df10035,0x6f1a100a,0x000000c4}},	//   grēt, _jāsp, _letc,
  { {0x49b80012,0x5fba0011,0x4dd40012,0x75e70031}},	// [1f30] _داود_, ेवाल, ستفس, _tűzv
  { {0x81bd001e,0xdb1a006f,0x7a050073,0x09f90012}},	//   arēt, botå, _lėte, لفئة_
  { {0x9f840051,0xa5f90001,0x92590015,0x72b90003}},	//   töö_, _њему_, рает_, جهاز_
  { {0xd7f10081,0xbae40012,0x40950012,0x6444005e}},	//   _sĩ_, سكني, يلار, btii
  { {0xc9740003,0x4acf0037,0x3f850404,0x291d100b}},	//   ثالث, _सुनव, _polu_, rawa_
  { {0xcc760009,0x501c0009,0x3f690faf,0x8e7500ae}},	//   _ועשה_, רוגו, рико_, قابض
  { {0x6234002d,0xfd110003,0x2902100c,0xfbd20009}},	//   _неру, وجة_, ycka_, _חתם_
  { {0x7dc5000e,0x91fc001e,0x84290024,0x6fd20040}},	//   lósz, rvāl, ажив_, ræci
  { {0x6d950028,0xa2b90037,0x25ad100d,0xf1b20009}},	//   _fáan, ्थव्, riel_, _חסן_
  { {0x4225062c,0xe3b10012,0xb17b0d1c,0x25ad100e}},	//   одов, ظرة_, smål, siel_
  { {0xc332000b,0xdcfb0082,0xf98a0003,0x25ad100f}},	//   ווי_, ljuč, لندي_, piel_
  { {0x41c90037,0x6d9c0025,0x6444008e,0xe3b80060}},	//   िकिस, _réag, ytii, anı_
  { {0xe45f0006,0x6d560132,0x61e61010,0x29020972}},	//   _myös_, veya, rmkl, rcka_
  { {0xaab90037,0xe3b30012,0xe73a004c,0x6d490e00}},	//   _आशंक, _عرش_, јев_, lfea
  { {0x59c90044,0xf772000b,0xceb20009,0x41c90011}},	//   िकार, וקם_, ֥ין_, िकास
  { {0x64440006,0x799d0052,0xa01b008e,0xf50a0a21}},	//   ttii, chsw, työt, рнал_
  { {0xd4670098,0x81bd001e,0x97c60012,0x47d60012}},	// [1f40] оите_, arēs, _وقبو, _ويعر
  { {0x2d990503,0x0326002d,0x644400ff,0xeab20012}},	//   _else_, іден, rtii, وعا_
  { {0xc3050003,0xa01b004a,0x64441011,0xe8fa1012}},	//   سبلو, syöt, stii, але_
  { {0xfd120003,0x94060012,0x11e90012,0xb2d30012}},	//   _تجد_, _ووجه, معني_, ذينغ
  { {0xe056000a,0xe3b8003a,0x7d041013,0x11d70012}},	//   تخاب, ynı_, mcis, آونة_
  { {0x7d04045a,0xf0930009,0x60290024,0x262a004c}},	//   lcis, ונד_, сіїв_, ацио_
  { {0x4432002a,0xdd9a1003,0x41ca0011,0xbf9b0025}},	//   lry_, иши_, रवास, mpêt
  { {0x44320b0b,0x69cb1014,0x38aa0034,0xe45f008e}},	//   ory_, coge, tórą_, _työt_
  { {0xdb01004a,0xdb1e0058,0x44321015,0x61fc1016}},	//   kilä, ropæ, nry_, _hurl
  { {0x0b8a0075,0xa3e70001,0x6fb60012,0x66760012}},	//   рсии_, одња_, _بمطا, _ودار
  { {0x9d4605cc,0x5b57000b,0x20091017,0x6b830028}},	//   _межд, חייב_, _stai_, öngi
  { {0x9633002d,0xa194002d,0x7c24017b,0x78a2001b}},	//   _ініц, даюч, ksir, ozov
  { {0xa2ca0037,0x9f4c0066,0xd5e90012,0xd1300012}},	//   _सुर्, _lidí_, _اعلن_, ضمّ_
  { {0xc058007c,0x09b70037,0x69cb0052,0xdceb0035}},	//   цію_, _अद्य, zoge, _ungā
  { {0x99d7000a,0x8d770003,0xc6680001,0x44320b0b}},	//   _وتعا, يارا, оште_, ery_
  { {0x7c2400b6,0x212900b6,0x62830052,0x44320504}},	//   fsir, _udah_, änom, fry_
  { {0xb9c40003,0xe571000b,0x7dda0054,0x8d5b0009}},	// [1f50] _تقيي, עַל_, aïso, סכמי
  { {0x67e0004a,0x63ba0052,0x78a20029,0xef1f0002}},	//   töje, nntn, dzov, ążka_
  { {0x7c24007a,0x44321018,0xd1310012,0x6b510097}},	//   asir, ary_, فما_, _aðgæ
  { {0x7dc5000f,0x44260416,0x39591019,0x4432101a}},	//   sósz, _ovo_, ness_, bry_
  { {0xf994000b,0xa2cb0037,0xdb1e005e,0x5d7a0009}},	//   ורף_, _तुर्, fopä, _הארק
  { {0x23fa000b,0xf838000b,0xfc160009,0x38640097}},	//   _להשא, קנות_, _מקשי_, æmri_
  { {0xa3d80037,0xa2ca0011,0xff180009,0x4426101b}},	//   ातर_, _सुल्, חקות_, _avo_
  { {0x79820002,0xc4850294,0x6de40012,0x386d00b0}},	//   cjow, злик, وثيق, _trer_
  { {0x93790003,0xe3b10003,0x29d9101c,0xfc310012}},	//   مصدر_, فرد_, réal_, رحة_
  { {0x79890070,0x29dc0164,0xeb99035c,0xcc760009}},	//   _hoew, nían_, сио_, פעתה_
  { {0x7d040002,0xc3320009,0x4426101d,0xe664003c}},	//   ycis, עוט_, _evo_, _отцо
  { {0x7d1d101e,0xc7a90009,0xc19a0024,0x499a0148}},	//   _ness, _גב_, стої_, стоя_
  { {0xb4fa000b,0x764b0010,0x34fa0009,0x515a0009}},	//   _הפני, žnyč, _ההנד, זכרו
  { {0xfaa50751,0xcb680012,0x6bd70012,0x6dac0060}},	//   _нало, _ومنه_, _بتصر, rşam
  { {0xa5960014,0x4b7a000b,0x29dc0164,0x7d1d101f}},	//   пращ, _לאסו, dían_, _bess
  { {0xb88306bc,0x91e30014,0x39591020,0x7c240b86}},	//   _klíč, _поще, cess_, tsir
  { {0xe319001a,0xed590029,0xeafa0003,0x113b0009}},	// [1f60] _điể, iež_, مرات_, _התפל
  { {0xa01b008e,0x33630024,0xdbf10030,0x44321021}},	//   pyör, нвуг, _přál, rry_
  { {0x4efb000b,0xafdb00c5,0xc332000b,0xe717000b}},	//   _להיו, ktøj, תוב_, _מחיר_
  { {0xfbc9000b,0x9f4c015b,0xe9d20012,0xc1ba0012}},	//   את_, _vidí_, رغا_, حائط_
  { {0x29dc0164,0x4424001a,0x31660031,0xed5909df}},	//   bían_, _ìm_, rdoz_, dež_
  { {0xc7a3057b,0xae000037,0x39590052,0xa2a70037}},	//   ничк, _लंदन_, zess_, _टेक्
  { {0x44260065,0xdb1e1022,0x539b000b,0xa3c10037}},	//   _svo_, ropä, _פילו, ्कन_
  { {0x2abb000b,0x5c980048,0x5c740a32,0xfe6f0012}},	//   _המלא, жкия_, длит, ادو_
  { {0xa5070001,0x65661023,0x6c470012,0xdb0801e3}},	//   чења_, _makh, كليف_, sidí
  { {0xe44f000a,0x389b000b,0x889b0009,0x7ac60adc}},	//   اضي_, _הימנ, _השמצ, зсме
  { {0x39590b5a,0xa9350024,0x3a3a005e,0xa9240064}},	//   tess_, менш, nupp_, ĺžni
  { {0x867b000b,0xd6eb000b,0xd2b7000b,0x02b7000b}},	//   _לרבו, _הַדָ, ללית_, להים_
  { {0x6ab90011,0xa91d00eb,0x6d42004b,0x39591024}},	//   _आश्र, _božj, _icoa, ress_
  { {0xdb1a000e,0x39591025,0xcb670024,0x6447004b}},	//   eltö, sess_, _наче_, ăjit
  { {0x7d1d0149,0x29dc0164,0xc7d70009,0xc3330009}},	//   _pess, vían_, פולי_, _טוס_
  { {0x98b9001e,0x7abb000b,0x61e4000d,0xcad70009}},	//   nesī_, _לצוו, _ghil, _מוות_
  { {0x6ecd0037,0x29dc01e3,0x69cf08ca,0xa3d00011}},	// [1f70] _दुरु, tían_, moce, वकप_
  { {0x889c000b,0xb89c000b,0x25a00b70,0x64a4004c}},	//   _לבחי, _לשחז, ahil_, хађа
  { {0x29dc0164,0xecf9002d,0xbb840003,0x2480004b}},	//   rían_, _менш_, علمي, axim_
  { {0x25a00070,0xc2c40012,0x69cf1026,0x29d20097}},	//   chil_, ريني, noce, láar_
  { {0xf2110011,0x67e01027,0x000000c4,0x000000c4}},	//   डीज़_, löja,   ,
  { {0xccf20009,0xf7730012,0xbc7a0009,0x2d8b001b}},	//   _שכך_, عاش_, _ונשת, _hoce_
  { {0x79890070,0x6b830028,0x99d70012,0x9e640012}},	//   _toew, öngu, _فترا, فاين
  { {0x96270039,0x6d4d00c6,0x6d9c0061,0x75d50003}},	//   _ieņē, nfaa, _réac, بيعا
  { {0x29000029,0x1c420015,0xa834004c,0x73e5019c}},	//   žiac_, вным, _петљ, моиз
  { {0x69d90052,0x57b40024,0xdc880009,0x9f530025}},	//   llwe, _збут, לְתָ, _fixé_
  { {0x6723048b,0x52db0037,0x9f340024,0x7e7e0248}},	//   manj, _भरोस, _чехі, äppt
  { {0xa5c60065,0x2d821028,0x67231029,0x24550012}},	//   rkóð, öket_, lanj, _يناس
  { {0xa5c60028,0xa3bf0011,0xfbbf0011,0x21a3003c}},	//   skóð, ुका_, ्वाम, тиям
  { {0x61e40036,0x98b20002,0x27ff004a,0x7c3b004a}},	//   _whil, żyć_, _muun_, muur
  { {0xd5b20003,0x7c3b005e,0x6449102a,0xba1900ae}},	//   نفس_, luur, ltei, _بيعا_
  { {0xf2d2000b,0x6449001e,0xdb1a0061,0x672304d2}},	//   _שעה_, otei, entè, hanj
  { {0x6723102b,0xbfc60014,0xb9b30003,0x66e7000e}},	// [1f80] kanj, _обик, _جميع, téké
  { {0x6723102c,0x61b80037,0xd9b80037,0x7ed60012}},	//   janj, ेक्ष, ेक्ट, _يزدا
  { {0x2367012e,0x6449083c,0x6723080a,0xb77b0009}},	//   _manj_, htei, danj, _ואיש
  { {0x3a3a0d64,0xe0da102d,0xdcfd0034,0x7c3b102e}},	//   rupp_, ове_, _posą, kuur
  { {0x260302d1,0xdb0e0065,0x9fca0015,0xdcb90015}},	//   _año_, þjón, огда_, _ещё_
  { {0x31bb0037,0x09bb0037,0x6d42000d,0x2367009b}},	//   _उद्ध, _उद्य, _scoa, _nanj_
  { {0x88bd0002,0xc34e0081,0x6449102f,0xda630337}},	//   _odśw, _bổng_, etei, _иври
  { {0xc34e0081,0x64490032,0x7a8b0009,0x661a0064}},	//   _cổng_, ftei, _וָמַ, átky
  { {0x3f980097,0x6e3c0060,0x8e200024,0xdb1a0031}},	//   kkru_, hurb, сiв_, lnté
  { {0x67230604,0xdb050060,0xef180035,0xdb1a1030}},	//   canj, rihç, _poļu_, onté
  { {0xd3370093,0xa294002d,0x3f9b0061,0x53370009}},	//   וריה_, хані, êque_, ונין_
  { {0x6e3c0028,0x64490032,0x6dac0060,0x49740198}},	//   durb, btei, ağaz, влюс
  { {0x14e20044,0x2d8b0013,0xdb1c0066,0xd7770003}},	//   _परिण, _roce_, _skrý, واسع
  { {0x61ee0029,0x9b440012,0x36d500db,0x6e3c0132}},	//   _ďale, _أنغو, еогр, furb
  { {0x5b570093,0x433b0009,0x8b3b0009,0xeb3b0009}},	//   _חיוב_, _ועוב, _ותוצ, _ועוש
  { {0x7bda0028,0x672300eb,0x69360030,0x3f8c0034}},	//   lltu, zanj, _přež, _lodu_
  { {0x2d8b034e,0xf1bf0485,0xdb1a057d,0x3f9e008e}},	// [1f90] _voce_, mná_, enté, _oltu_
  { {0x291f0054,0x4fc7002d,0xc7c7002d,0x7f5c0054}},	//   _seua_, _іспа, _іспи, cerq
  { {0x67231031,0x27f80064,0xc955003c,0x64490035}},	//   vanj, ženú_, етлы, ztei
  { {0x25190009,0xead80024,0xc1050012,0xf1bf1032}},	//   _מוֹא, ємці_, روتي, nná_
  { {0x67230416,0xd8b80003,0xe72e002d,0xb9920012}},	//   tanj, ودها_, ле_, طلوب
  { {0xf7710003,0x141a000b,0xa3dd0037,0x63b10066}},	//   طات_, _מושב, _थीं_, édně
  { {0xe919002d,0x53340001,0x67230082,0x291f01a0}},	//   _нові_, _јест, ranj, _teua_
  { {0x217b000a,0x6723080a,0x64491033,0xf1bf00d9}},	//   _بحسب_, sanj, ttei, jná_
  { {0x64490010,0xf1bf01a8,0x44291034,0x7de30031}},	//   utei, dná_, nsa_, _kősz
  { {0x2d820163,0x4374002d,0x44291035,0xdaa9035c}},	//   öker_, вуют, isa_, звод_
  { {0xc34e0020,0xfbd2000b,0x752f0002,0xd946048c}},	//   _tổng_, רתי_, _odcz, нени
  { {0x0efa015f,0xa96a0001,0x46580003,0x216a1036}},	//   ्ड्स_, чима_, _تؤكد_, чими_
  { {0xaacf0044,0x7524007a,0xb9080037,0x25bf000d}},	//   _सुरक, vaiz, _भर_, mnul_
  { {0xbb850003,0xb464002d,0x2d8f0422,0xe4360009}},	//   _سلبي, _шкіл, ögen_, _נרצח_
  { {0x66010006,0xdce2001e,0xf1bf01bd,0x7c2601bd}},	//   _julk, _bloķ, bná_, škrt
  { {0xdd920003,0xf1bf00d9,0xec160012,0xceb20009}},	//   دور_, cná_, فورد, איל_
  { {0x81bd001e,0x28060002,0xc5f2000b,0xdca30a76}},	// [1fa0] ksēj, ówną_, רדן_, гати
  { {0xa3c10037,0x7d090002,0x6d9c0061,0x672101a3}},	//   ्कि_, hces, _néan, _nelj
  { {0xdb1c0002,0x7d090002,0xe7e30011,0xa91d0159}},	//   _skró, kces, गतना_, _zoži
  { {0xb8660003,0xc329000b,0x6da6002d,0x7c291037}},	//   فاتو, מו_, _чима, kser
  { {0xa3c10037,0xfaf8001e,0x44290031,0x50650012}},	//   ्का_, ldīt_, csa_, َاهِ
  { {0xd7ef000a,0x67210159,0xf1bf1038,0x7c291039}},	//   مكن_, _celj, zná_, dser
  { {0xdb1c0002,0xd2cf0037,0xfbc30015,0x672102a1}},	//   _wkró, _सुलझ, _сбро, _delj
  { {0xceb30009,0xfaf80035,0x6601103a,0xa9670681}},	//   טיו_, idīt_, _dulk, _писа_
  { {0xb7da0003,0xf1bf022d,0x9f4a0054,0x6fb60012}},	//   _فورا_, vná_, ambé_, _كمرا
  { {0x8c530003,0x4274002d,0xdd00003a,0xa8570009}},	//   ائيا, вгос, ıtıl, _אימה_
  { {0xf1bf00f1,0x442902f7,0x9bb70009,0xdc030030}},	//   tná_, zsa_, תהיה_, včíh
  { {0xa91d103b,0x23a4006f,0x6721001b,0xd5b20012}},	//   _poži, _höjd_, _zelj, _حفص_
  { {0xc1730093,0x67e0006f,0x7c290ebc,0x4fc70048}},	//   אחר_, röjn, cser, есва
  { {0xe47b000b,0xf1bf0042,0x69c40035,0x53340511}},	//   _מרדכ, sná_, _ejie, _рект
  { {0x6be30003,0x68e4000e,0x36d50001,0xf1bf0042}},	//   _حكوم, _ezid, товр, pná_
  { {0xcdd80001,0xfa770009,0x4429103c,0xa91d0159}},	//   ењу_, _טעות_, tsa_, _toži
  { {0x41c40003,0x24580015,0x98b90010,0x4429103d}},	// [1fb0] _حقيق, нать_, mesį_, usa_
  { {0x61c90037,0x23a4006f,0x73d80198,0x4429103e}},	//   िक्ष, _nöjd_, едур_, rsa_
  { {0x4429103f,0xa2d40011,0x69dd005e,0x98be0034}},	//   ssa_, _बुद्, olse, ętą_
  { {0xd2b7000b,0x98b91040,0xc198002d,0xfaf8001e}},	//   עלאת_, nesį_, нтії_, ldīs_
  { {0x6601004a,0x0904002d,0x395d0132,0x3f6905c6}},	//   _sulk, упін, rews_, дило_
  { {0xec36000b,0x660109d4,0x5f770012,0xd7f8004c}},	//   _באשר_, _pulk, عاشر, нуј_
  { {0xbbbf0044,0x36660014,0x8fa20015,0x67211041}},	//   ्वीक, ващо_, раще, _velj
  { {0xf67c000b,0xdd8e0003,0x25bf004b,0x644d1042}},	//   לאומ, قوى_, unul_, otai
  { {0xdd8e000a,0x9f5303eb,0x67210fc4,0x25bf000d}},	//   توي_, _així_, _telj, rnul_
  { {0x7d0900c1,0xe2990001,0x75c80066,0x66011043}},	//   sces, дао_, věze, _tulk
  { {0x644d0006,0xb2f40015,0x7a080030,0x25fa0011}},	//   htai, ляющ, _pěta, _ऊंची_
  { {0x7afa0028,0xdb08004a,0x644d0213,0xe2960055}},	//   _útte, eidä, ktai, таю_
  { {0x0db80003,0xd00f0012,0x2ca9001b,0x8c451044}},	//   _ثالث_, يلَ_, jzad_, _реле
  { {0x69dd0005,0x2d8f0070,0x8c1a0009,0x52850012}},	//   alse, _hoge_, _חוסי, _للتك
  { {0x443f004a,0xfaf8001e,0xecc3001e,0xfe670012}},	//   luu_, udīt_, šķās_, جد_
  { {0xdb1a0002,0x3f850028,0x91fc0035,0xfce608d1}},	//   botó, ölur_, rvāt, вобо
  { {0x656b1045,0x443f1046,0x23bf0011,0xc5e90009}},	// [1fc0] _magh, nuu_, ्वंद, ַד_
  { {0xb17b0033,0x91fc001e,0x4e060406,0x61e90051}},	//   småt, mvār, _изоб, _ahel
  { {0x6a860098,0x179b000b,0xe2860014,0x6287004a}},	//   ължа, _חייב, ължи, äjoh
  { {0x656b0101,0x443f00e6,0x61e91047,0xceb30009}},	//   _nagh, kuu_, _chel, _כית_
  { {0xd0070098,0x70540003,0x91fc001e,0x9f340024}},	//   вече_, انتا, nvār, гелі
  { {0x8cc50037,0xdefa0015,0x4fd3002d,0x61e90032}},	//   ापनो, мый_, ажіт, _ehel
  { {0xdb010030,0xacbb0025,0x6d44005e,0x6eb70011}},	//   chlé, _jeûn, ogia, ोपयु
  { {0xc693000b,0x7ae3000e,0xb5aa0003,0x6d441048}},	//   שאה_, ünte, باتك_, ngia
  { {0x91fc001e,0x9f4c004a,0xe7320012,0x80e10011}},	//   jvār, _pidä_, _نصا_, _नरें
  { {0x96b6004c,0x000000c4,0x000000c4,0x000000c4}},	//   _исељ,   ,   ,
  { {0xc7d7000b,0xbb3b000b,0x32630014,0xdfcf0012}},	//   _יומי_, ועיי, атяв, _بيل_
  { {0xf2d3000b,0xc05b0024,0x9f4503a7,0xdd8f0012}},	//   יעת_, міг_, _milý_, _وول_
  { {0x1d070046,0x91fc0039,0x20840003,0x8c43046e}},	//   _речи_, gvār, للَّ, _вече
  { {0xc7c40015,0x64401049,0xf4570009,0x6d44104a}},	//   асси, mumi, _סיור_, egia
  { {0x75e5000f,0xa3c10037,0x7c3a001e,0xe7e30011}},	//   lóza, ्कर_, _ātra, गतता_
  { {0xa2b80044,0x6d4401a2,0xa3b50037,0x644d104b}},	//   ्पन्, ggia, _जगह_, ttai
  { {0x6d9c0108,0x5c75003c,0x39490018,0x6440104c}},	// [1fd0] _réal, ылат, _icas_, numi
  { {0x765a003e,0xe8d8000b,0x5b14002d,0xbbbf0037}},	//   _opty, _בוחר_, имут, ्वेक
  { {0x63af01a0,0x61e9104d,0x644d104e,0x6e95104f}},	//   ècni, _phel, stai, _сину
  { {0x200400b6,0x64401050,0x644d1051,0x81140012}},	//   _bumi_, kumi, ptai, لذها
  { {0x64400039,0x28f8002d,0x97d900fa,0x5d3a0009}},	//   jumi, вець_, ньку_, _אתרא
  { {0x289c000b,0xb6050107,0x889c000b,0x53a70037}},	//   וידא, hláš, ובדי, _गतिश
  { {0x656b01e5,0xc6a70014,0x45d50048,0x28da0011}},	//   _pagh, ърди, лцит, _युनि
  { {0x4efc0093,0x443f004a,0x96fc0009,0x5e560012}},	//   ולוג, tuu_, ולות, اليس_
  { {0x60db003a,0x64401052,0xe4320012,0x2bb90012}},	//   _uyum, gumi, مفيد, فادة_
  { {0x8c1a000b,0xca350009,0x75c80030,0xdd1c0030}},	//   עותי, ְנָה_, tězc, háňk
  { {0xb6070048,0x8ab60009,0xd7df0011,0xf7700012}},	//   _рязк, ָ֔יו_, _पीएच, _باق_
  { {0xa1360003,0x98b2003a,0xf7690009,0x443f0269}},	//   دردش, _sayı_, _מק_, puu_
  { {0xe8f70024,0x98b20060,0x7c2d0248,0x79ba0009}},	//   ллю_, _payı_, jsar, תֶיה
  { {0xdc3a0009,0xafdb00b0,0x7d1b1053,0xe46a0097}},	//   _נעצר, dtøs, lbus, sröð_
  { {0x442d0828,0xfe710012,0x46a30024,0xed5a03e1}},	//   lse_, يدِ_, барв, нов_
  { {0x442d1054,0x69c3014e,0xceb20009,0x09e60024}},	//   ose_, énel, צין_, _щойн
  { {0x5fc30037,0xb4250012,0x70770012,0xc4e6003c}},	// [1fe0] वचाल, لعلو, _مميز_, ужай
  { {0x2bba0003,0x442d1055,0x200403fe,0x8fca0012}},	//   راءة_, ise_, _rumi_, _سِجل_
  { {0x77f7000b,0xb17b0058,0x442d05ac,0x7d0d0132}},	//   _תמיד_, slåe, hse_, bcas
  { {0x442d03fb,0x6dac003a,0xafdb0033,0xcb09000b}},	//   kse_, aşar, støt, לל_
  { {0x25d70093,0x64e20037,0xdfda0014,0x69c20070}},	//   _תוכן_, _परेश, нък_, rnoe
  { {0x64401056,0xa8570009,0xb8070012,0x442d1057}},	//   vumi, ריסה_, ديوم_, dse_
  { {0xe2870003,0xaab80011,0x7c3b1058,0x65600031}},	//   _اذ_, _आधिक, erur, temh
  { {0x64401059,0xc0460012,0xca970009,0xdb1a0097}},	//   tumi, _مخطو, _גדלי_, rntí
  { {0xd32606e6,0xb9930003,0x5b260015,0x48e30014}},	//   льни, _القب, льна, _готв
  { {0x53340001,0x6440105a,0x3946105b,0xbb3a0009}},	//   јент, rumi, lgos_, ׂעִי
  { {0x442d09f5,0x66e60015,0x7c2d001e,0x45460003}},	//   ase_, _сожа, zsar, _مناق
  { {0x3946105c,0xd1260012,0x6440105d,0x7d1d0097}},	//   ngos_, غم_, pumi, ðsst
  { {0xc5f30093,0x6fb50003,0x7c3b000d,0x88bd0002}},	//   _הדף_, لمحا, crur, _leśn
  { {0x66050051,0xe4fb0009,0xf4130009,0x7d0d105e}},	//   _puhk, _נפגש, _הפס_, wcas
  { {0x539b000b,0xa2d40011,0xee84003c,0x7d0d0132}},	//   _איגו, _बुल्, быто, tcas
  { {0x7c87002d,0xc27b0009,0xf1270024,0x63ba105f}},	//   лузе, _טרוי, _сько, litn
  { {0xdfd10003,0x69c30061,0x442f000e,0x3869040f}},	// [1ff0] _ويب_, énem, ég_, _usar_
  { {0x212b04f3,0xe3b30012,0x17550048,0x8f550024}},	//   lach_, حرر_, _твоя, _твої
  { {0x7d02009b,0x442d059b,0x6ffa0009,0xd3d80012}},	//   _ogos, zse_, _שהתפ, ابقا_
  { {0x212b1060,0x442d1061,0xd567038f,0x71270012}},	//   nach_, yse_, _стоп, ارال
  { {0x39490039,0x63ba00b6,0xf8690012,0x18690c80}},	//   ļas_, kitn, ئمتي_, тали_
  { {0x442d0051,0xad9c0029,0xe7360014,0xb65900bb}},	//   vse_, _stĺp, аеш_, вших_
  { {0x7c22001a,0x244f003a,0x212b1062,0x16a60ec6}},	//   _awor, lüm_, kach_, ивши_
  { {0x212b0002,0x629a1063,0x442d1064,0x30150024}},	//   jach_, dyto, tse_, _вдар
  { {0x244f003a,0x212b0120,0x442d1065,0x656f0ec8}},	//   nüm_, dach_, use_, _mach
  { {0x92f5002d,0xeb990001,0xb8940003,0x442d1066}},	//   ичні, тио_, _الْع, rse_
  { {0x212b00f7,0xf0890009,0x9bb60009,0x93b60009}},	//   fach_, _קנ_, שהתה_, שלתו_
  { {0x645d1067,0x212b0002,0xa2b80037,0x656f1068}},	//   _opsi, gach_, ्पत्, _nach
  { {0xd83e0026,0xc5f2000b,0x76431069,0x15f40012}},	//   _účte_, _ודא_, luny, _اسلح
  { {0x629a0029,0xf746004c,0x9c820030,0x1eaa0012}},	//   byto, јево, účel, نازي_
  { {0xc7b20093,0x645d007a,0x39460010,0x7db602ac}},	//   קבל_, _apsi, ygos_, асац
  { {0x3d200037,0x4ad90037,0x212b0002,0x7bc50017}},	//   बरें_, _बुधव, cach_, enhu

  { {0x0446106a,0x6fdf0061,0x8b260015,0x03260760}},	// [2000] резн, pêch, идае, идан
  { {0x109b000b,0x764300b6,0xafdb0722,0x389b0009}},	//   _סביב, kuny, stør, _סיינ
  { {0x7f3b000b,0x32070054,0x34e20011,0x2f3b0009}},	//   _בעיו, _juny_, _पर्द, _בגיד
  { {0x3946007a,0xd2e60037,0x244f003a,0xd1300012}},	//   ugos_, _करीब_, büm_, سمت_
  { {0x629a0120,0x3946106b,0xadf80011,0x69c6106c}},	//   zyto, rgos_, ंगठन_, inke
  { {0x81bd0039,0x57b3002d,0x212b047f,0x656f106d}},	//   lsēt, обіт, zach_, _zach
  { {0xd719002d,0x7c22002a,0x7643016d,0x569409f8}},	//   уючі_, _swor, guny, сайт
  { {0xac540003,0xe5c60001,0x0d96000b,0xb0160003}},	//   منبث, јско, יכֶם_, _نورث
  { {0x88bd003e,0x9da70014,0x2fd8006f,0xf7460001}},	//   _jeśl, ръща_, korg_, _везо
  { {0x26de0013,0x61ed106e,0x212b0002,0x629a0010}},	//   _tyto_, _shal, wach_, tyto
  { {0xc3330093,0xa4e30044,0x212b003e,0x33770009}},	//   חות_, _खर्च_, tach_, בעים_
  { {0x7c22003e,0x3d200037,0x629a106f,0xbd490012}},	//   _twor, बरों_, ryto, _مؤهل_
  { {0x656f1070,0xe53b0009,0x99990031,0x212b1071}},	//   _rach, _יתאר, érő_, rach_
  { {0xd83f0382,0x644f03eb,0xfc5b000b,0x212b1072}},	//   _účet_, àcie, _סכומ, sach_
  { {0x212b0002,0x67280604,0x92580ef5,0xaffc0024}},	//   pach_, _medj, _сайт_, торi
  { {0xdce6001e,0x42fb0009,0xaada0011,0xf9900012}},	//   _sakā, _בהוס, _भड़क, _يبي_
  { {0x19b80003,0xdce6001e,0x25a91073,0x9bc90012}},	// [2010] _خطوة_, _pakā, rhal_, هورك_
  { {0x656f0369,0x244f003a,0xa3e60037,0x82370012}},	//   _wach, rüm_, पति_, لرصا
  { {0xed590013,0x6ff40003,0x7ff40012,0x8bd70009}},	//   liže_, _بسيط, _بسيا, סובו_
  { {0x998d0002,0x29dc01e3,0x7cd90012,0xc1720009}},	//   erdź_, días_, _موجز_, ּ֗א_
  { {0xa2d80037,0xa3e60011,0xe7390229,0x75c80030}},	//   _नुस्, पता_, гел_, tězn
  { {0x785a0039,0x764300b6,0x29dc0164,0x94f60009}},	//   dāvā, tuny, fías_, _לצרף_
  { {0xf7700003,0x61e2003a,0xed590015,0x29dc01e3}},	//   بان_, blol, гой_, gías_
  { {0x9f960028,0x76431074,0xca480012,0x0d850dc2}},	//   hæð_, runy, _خلفه_, слин
  { {0x69d90002,0x24520003,0x7643016d,0xa3db05f3}},	//   mowe, كنيس, suny, डकप_
  { {0x29dc0164,0x2cad0002,0x764300b6,0x69d91075}},	//   bías_, rzed_, puny, lowe
  { {0x29dc0164,0xe1fa004d,0x6b951076,0xc8690009}},	//   cías_, лго_, _mozg, _רן_
  { {0x69d90002,0x35f51077,0x4a5a0009,0x05740012}},	//   nowe, _упер, נדרו, _واند
  { {0x2fd80028,0x14190003,0xf1b20009,0xb8860064}},	//   torg_, _صيغة_, לסט_, _opíš
  { {0xf4120009,0x141a0009,0x999f0030,0x65640032}},	//   _צפו_, _עוצב, butů_, weih
  { {0x69d90002,0x644b0054,0xeb900003,0x6b8304eb}},	//   kowe, àgin, _تظن_, _inng
  { {0xdced0026,0xa2b80037,0x29000010,0x69d90002}},	//   adač, ्पस्, žiai_, jowe
  { {0x7984002c,0xf7460001,0x69d91078,0x16040011}},	// [2020] _iniw, _лепо, dowe, _शंकर_
  { {0x68e0006f,0x25b9005e,0x65641079,0x25a0107a}},	//   _rymd, _emsl_, seih, skil_
  { {0x4906000a,0xd7fb0009,0x2f970009,0x6564008e}},	//   مواق, _תהיל, _הכין_, peih
  { {0x5d860003,0x6146107b,0x443f107c,0x69d90a8f}},	//   _الحل, седа, kru_, gowe
  { {0xb033002d,0xdb03000e,0x783a0001,0x55f70009}},	//   зніш, _elné, уџет_, _למטב_
  { {0xccf90002,0xa857000b,0x33d5002d,0xe0850012}},	//   reśl_, מינה_, _діст, تجمي
  { {0x62650003,0x443f0da7,0xda650012,0x69d90b2c}},	//   _وافق, eru_, _وافي, bowe
  { {0x76a9002d,0x29dc0164,0x86070003,0x443f107d}},	//   штів_, rías_, حقيق_, fru_
  { {0xdb1a0108,0x6ab20037,0xfd0f0003,0x02b80037}},	//   lité, ुप्र, رجي_, _आधुन
  { {0xa3b40024,0x037a0012,0x5a34107e,0x29dc107f}},	//   ібні, احظت_, онот, pías_
  { {0x22580015,0x4df80037,0xe7170009,0x5f170009}},	//   шины_, ंगाई_, _החבר_, _החבא_
  { {0x394d03eb,0x44321080,0x2001005e,0x1d0a0451}},	//   ües_, ksy_, _sihi_, _седи_
  { {0x443f007d,0xac940014,0xcb340048,0x9f960097}},	//   cru_, _фалш, _делъ, tæð_
  { {0x33f60046,0x4fc70015,0x69d90034,0xbce50012}},	//   _учес, ссма, zowe, _بأمو
  { {0xfa330003,0x9f5e0061,0xd357000b,0x6b950002}},	//   _فريد, _cité_, _השוק_, _rozg
  { {0xb8860066,0xe6540024,0xdb1a0025,0x64401081}},	//   _spíš, явсь, dité, ormi
  { {0xe4500003,0xe4e70024,0xbbb90024,0xdd94003c}},	// [2030] فضل_, сівн, агає_, чаты
  { {0x6ac40044,0xa3b30037,0x69d90002,0x2cb80012}},	//   वपूर, जों_, wowe, حافظ_
  { {0x69d9003e,0xb8860026,0x97560009,0xa2b80011}},	//   towe, _vpíš, _ושתף_, ्पष्
  { {0x7bda004a,0xa15902e3,0xec150012,0xda7b0009}},	//   hotu, раду_, _ووجد, טנבר
  { {0x7bda0006,0x6845002d,0x69d908ce,0xf09f01a0}},	//   kotu, інка, rowe, nyà_
  { {0x8cdc0044,0x645c007d,0x69d90002,0xa2d40011}},	//   _पड़ो, ăril, sowe, _बुक्
  { {0x7bda1082,0x86980014,0xdb1a1083,0x753d0031}},	//   dotu, йтът_, cité, ószo
  { {0xa2b80044,0xd0d50014,0x443f1084,0xe6280003}},	//   ्पर्, _добъ, tru_, حثون_
  { {0x386d006d,0xc7c8001a,0x23650082,0x4c850024}},	//   _user_, uốc_, telj_, ілов
  { {0xdfdb0048,0x7e2b0024,0x6d490032,0xdb0e0097}},	//   _съб_, _біда_, sgea, _embæ
  { {0x6d5d0628,0x016601ec,0x64401085,0x32b90012}},	//   _obsa, окно, armi, شددة_
  { {0xdb01004a,0xc1060012,0xdb1a008e,0x7d020073}},	//   kilö, توحي, entä, žosi
  { {0xa3d90044,0x629e0002,0xa156000b,0x25bf004b}},	//   ावा_, zypo, חברה_, miul_
  { {0x6b830033,0x25bf000d,0x6d4f03a2,0x6d5d031d}},	//   _unng, liul_, _acca, _absa
  { {0xa50a010c,0x11d60012,0x1d0a0048,0x99d60012}},	//   иева_, _وتبد, иеви_, _وتبا
  { {0x25bf007d,0xdb1a0061,0x79840002,0x14260014}},	//   niul_, vité, _uniw, ждам
  { {0x29050066,0xf7720012,0xe73a0024,0x249f013d}},	// [2040] ělat_, _قاد_, _кеп_, nyum_
  { {0x1666002d,0x21220011,0x83870024,0xbfc3003c}},	//   _двом, मर्श_, обув_, _обык
  { {0x7a080030,0x75390034,0x3dc9020d,0xed5a1086}},	//   _pěti, _odwz, bnaw_, _кон_
  { {0xf3e90093,0xe9da096e,0x00e607d1,0x80a60012}},	//   דף_, шке_, ожен, يمان
  { {0x25bf000d,0x999c000e,0x7bc80028,0xdb1a1087}},	//   diul_, évő_, yndu, sité
  { {0x907b000b,0x2d991088,0x8bd80009,0x25ad005e}},	//   יטני, ösen_, _הַֽח, ehel_
  { {0x59ca0037,0xf8bf0025,0x5e440012,0x6d470073}},	//   ाचार, mbée_, أَعْ, ėjan
  { {0xdb070065,0x2dd70003,0x1d340014,0x25bf004b}},	//   ámör, يبية_, чния, giul_
  { {0xc5f30093,0x27170066,0xdb1a004a,0x6eda0037}},	//   ודה_, nění_, yntä, _पुरु
  { {0xa3ea0037,0x7c29003a,0x68ed0002,0xdfa60003}},	//   मति_, _çere, _rzad, _بحري
  { {0x86c6000a,0xcb13000b,0xcf93000b,0xd37b0009}},	//   _بيان, ולת_, _קטע_, בריט
  { {0x44260036,0x25bf000d,0xb6060027,0x29000010}},	//   _two_, ciul_, rišć, žiau_
  { {0xf1bf0029,0xa3ea0011,0xcf9b004c,0xa0c50012}},	//   riá_, मता_, ајв_, سيسو
  { {0x27170066,0xa6170012,0x33730024,0xc6a705c8}},	//   dění_, قبرص, _огір, орби
  { {0x3ea5000e,0xc5fb0003,0xb5c90012,0x387e0035}},	//   ált_, لعرض_, موسم_, ātra_
  { {0xdb010051,0xbdf4000b,0x42370009,0xa3b30011}},	//   gilõ, לֶּה_, _ונהל_, जोई_
  { {0xcd97000b,0x030e0037,0xc19c0009,0x5fbc0011}},	// [2050] קדמת_, _सलाह_, _כשהי, ्चाल
  { {0xd3710003,0x8c1b0009,0xda7b0048,0xdc8b0009}},	//   عها_, יומי, ияе_, יְבָ
  { {0xdb01004a,0x9ff80012,0x65a3005e,0x17f800ae}},	//   silö, _بريء_, _jõhk, _برية_
  { {0x6b980260,0x3f9a0097,0xe1f00012,0x661a0e69}},	//   _lovg, öpun_, نسن_, ítke
  { {0x9516000b,0xdcef0010,0xb97c0009,0x65a3005e}},	//   _מקרא_, _įdėk, ינאי, _lõhk
  { {0x6cfa0093,0x6d4d09de,0xb4fa0009,0xe4fa0009}},	//   _לפרס, lgaa, _לפרי, _לפרש
  { {0x67ed000e,0xdf360012,0x2d991089,0x69dd108a}},	//   gúja, سكيت_, _kose_, kose
  { {0x3228002d,0x39150024,0xf1bf0031,0x52140024}},	//   _фірм_, _хмар, _öá_, _ідут
  { {0x65a30005,0xcc350003,0x25bf000d,0x04560003}},	//   _põhj, أربع, riul_, كلية_
  { {0x5ba9108b,0x2d99108c,0x69dd108d,0xfb960009}},	//   ском_, _lose_, eose, ִ֣ית_
  { {0x0dcb002d,0x95cb00bb,0xa3b30011,0xe9da0a38}},	//   _куди_, _куда_, जोए_, йко_
  { {0x186a01d4,0x2d99108e,0x6456008e,0x9df9004c}},	//   бами_, _nose_, ytyi, _унет_
  { {0x69cb0b04,0xda0b0011,0x920b0011,0xd4c70012}},	//   inge, _सूरत_, _सूरज_, _بغاي
  { {0x8c1a000b,0xa4fa000b,0xbca40012,0x69cb0032}},	//   _הוסי, _פלסט, _تمهي, hnge
  { {0xcb120093,0xa3b80003,0x6d4d0070,0x644903b9}},	//   _אלו_, _بانر_, fgaa, luei
  { {0x27170013,0xf9920003,0x2d9900c1,0x6456004a}},	//   tění_, _سبب_, _cose_, ttyi
  { {0xddc1001e,0x1c4600b3,0x6ac40011,0x644901a0}},	// [2060] _aplū, янам, वप्र, nuei
  { {0x287b000b,0x69cb00ed,0x7bc1108f,0x395f1090}},	//   _פנימ, enge, nilu, _abus_
  { {0x4f9b000b,0xbf9b000b,0xa79b000b,0x9f9b000b}},	//   _הביצ, _הייש, _השיח, _הסיפ
  { {0xa158002d,0xa2d30012,0xb2d30012,0xfe370009}},	//   іалу_, رينت, رينغ, _צרכי_
  { {0xd12f0003,0x7d7b000b,0x3f9a001e,0x20051091}},	//   امه_, _הנכו, _kopu_, _bili_
  { {0x26110020,0xb6020066,0x64490054,0x44200ffd}},	//   _báo_, žáda, duei, mpi_
  { {0x2611008a,0x2005003a,0xdbc70269,0xe5c60048}},	//   _cáo_, _dili_, töös, зспо
  { {0xdceb001e,0x69c3000e,0x91e30024,0xad260012}},	//   _sagā, énet, _зосе, أرثو
  { {0xdce40010,0xdceb001e,0x7bc11092,0xc5130012}},	//   keič, _pagā, filu, ربيت
  { {0x0b8a0047,0xa08b0009,0xb8050012,0x76430034}},	//   ссии_, _לְבִ, _قبله, brny
  { {0xf773000b,0xde170012,0xd2570024,0x0ac60223}},	//   _רקע_, _فقلت_, пця_, ящим
  { {0x92570015,0x6d9c0164,0x64490054,0xc27b0009}},	//   чают_, _véas, buei, צרכי
  { {0x64490108,0x7bde004a,0x387f0028,0x2d9902d5}},	//   cuei, kopu, íur_, _rose_
  { {0x22590002,0x6f150002,0xf43b0009,0x6606008e}},	//   ńska_, uczc, _פגומ, _aikk
  { {0x6a130003,0x735b000b,0xe5ab0001,0x2d9902d5}},	//   _كبير, _הכוח, бњак_, _pose_
  { {0x91e40001,0x6606000e,0x9172001a,0x75240031}},	//   _поје, _cikk, rợ_, gbiz
  { {0x113c000b,0x53990015,0x6d4d1093,0x93270003}},	// [2070] _התחל, овая_, rgaa, كران
  { {0x2bbb0012,0x8c1b0009,0x7bde03fe,0xbb850012}},	//   حارة_, צובי, gopu, بلطي
  { {0xdb010052,0xcb080012,0x81c80035,0x44201094}},	//   chlä, أيمن_, _orēķ, api_
  { {0x64440051,0xc7c8001a,0xdb1e004a,0x69cb1095}},	//   brii, uốn_, enpä, unge
  { {0x200d00c1,0xe72e0024,0x320e0034,0x7ff50012}},	//   _quei_, ке_, _lufy_, وستا
  { {0xedf70011,0x7bde004b,0x6d470073,0xdceb004b}},	//   ुद्ध_, copu, ėjam, _lagă
  { {0xe9190024,0x7bc100b8,0xff180009,0xe7300012}},	//   _мові_, vilu, הקות_, اصه_
  { {0x64491096,0x31c40024,0x4c8502ab,0x2005020d}},	//   tuei, _зсув, длив, _wili_
  { {0x20050006,0xd6d90002,0x752f0002,0x2bb90003}},	//   _tili_, ęły_, _mecz, قادة_
  { {0xe2a20020,0x2bb90003,0x1bb90003,0x752f0002}},	//   _thử_, تابة_, تابع_, _lecz
  { {0xc332000b,0xd9461097,0xd6270012,0x753d0034}},	//   כוי_, мени, _رعاي, _odsz
  { {0x5dd8002d,0xc7a90009,0xf8a70012,0x44200073}},	//   _ефір_, _דב_, نة_, ypi_
  { {0x660601a3,0x644901d7,0x7bc11098,0x85040012}},	//   _rikk, quei, pilu, _كومن
  { {0x6606024c,0xeab10003,0xb4fa0009,0x34fa0009}},	//   _sikk, _لعب_, _ופני, _והנד
  { {0x7a080066,0x660601a3,0xe57a0024,0xb9c60012}},	//   _děts, _pikk, озв_, _يتعه
  { {0x69bf0037,0x85ea0024,0x6e930012,0x7aee0032}},	//   लोमी, ідав_, خلفا, übte
  { {0x5f760003,0xa5c60028,0x718b0009,0x61e41099}},	// [2080] _قادر, ljóð, _וְיַ, _ikil
  { {0x443901b3,0x4e1a0012,0x6444005e,0xafdb00b0}},	//   _dvs_, _وتجد_, rrii, ktøy
  { {0x9a6a0003,0x6444109a,0x799b0070,0x1d0a046d}},	//   تمال_, srii, _bouw, _мени_
  { {0x6444109b,0x4420109c,0xfbc90009,0x08c603b0}},	//   prii, ppi_, בת_, мбен
  { {0xd4360012,0x644f01a0,0x2f1801c6,0x7bde109d}},	//   _تعجب, àcil, поль_, popu
  { {0x7a0c007d,0xdb1a109e,0xe3a70012,0xf8b70009}},	//   _aşte, zitâ, _شر_, ופני_
  { {0x63a3109f,0xa3db0011,0x6b9c10a0,0xba5600ae}},	//   önne, डकर_, _iorg, _تنزع
  { {0x65a30005,0xbdf70003,0x5c740c1e,0xdd900012}},	//   _põhi, وريا_, елит, اوة_
  { {0x690b000b,0xe10b000b,0x69c010a1,0x236a004c}},	//   _וּבְ, _וּבָ, _imme, ојно_
  { {0x889b000b,0xb89b0009,0x409b0009,0x6b9c10a2}},	//   _ובמי, _ובמש, _ובמס, _jorg
  { {0x3ddf0070,0x316b0002,0x2b160011,0x6b9c10a3}},	//   bouw_, tecz_, दुएँ_, _morg
  { {0xc6930009,0xca370009,0xc2370009,0x31790031}},	//   _שאף_, ונטה_, ורטו_, udsz_
  { {0x8dfb0009,0x6b9c0227,0xdb1a0018,0xdb1c0031}},	//   _והאת, _oorg, ritâ, _emré
  { {0xead404b3,0x2cb0003a,0x65a3005e,0x5bc60012}},	//   _поль, ıldı_, _jõhv, _تتصف
  { {0xbd050061,0xa3cb0037,0xa3bd0011,0xef670009}},	//   _théâ, रचर_, ीचर_, וֹן֙_
  { {0xc5f80035,0x21e7005e,0xa0210097,0xa9c40557}},	//   _spēj_, põhi_, _þögg, _аськ
  { {0x94ab002d,0xd37b002d,0x24580015,0x6b9c10a4}},	// [2090] цтва_, жче_, мать_, _borg
  { {0x08f80003,0x21f20029,0x47d50012,0xf0920009}},	//   _غريب_, máha_, _سيجر, _עני_
  { {0xc2c40012,0xcff60009,0x656206dd,0xafdb00b0}},	//   نيكي, _רצתה_, _oboh, nrøm
  { {0xd1b80003,0x77b0006f,0x4efa0009,0x32640048}},	//   وانا_, _växe, _מהתו, ътув
  { {0xb06b0003,0xe0ce002d,0x6b9c10a5,0xa9680012}},	//   تصال_, ув_, _forg, ظمهم_
  { {0xdce400a2,0xf41f004a,0xf4560009,0xafdb00b0}},	//   ldiğ, _itä_, _אישר_, ttøy
  { {0x644d10a6,0x4ad90011,0xdcfd0073,0x9ea908d1}},	//   luai, _बँटव, _posė, явка_
  { {0xdce4003a,0x6b9c10a7,0xe1f00012,0xc6a40048}},	//   ndiğ, _zorg, _نسق_, ърчи
  { {0x37c50012,0x443910a8,0x3ddf0227,0x644d10a9}},	//   _كيرف, és_, rouw_, nuai
  { {0x61e410aa,0x56670012,0x57780012,0xf7730012}},	//   _skil, _يداف, _يصلح_, _جار_
  { {0x25a9000f,0x2d8b10ab,0x98a4000d,0x5e450012}},	//   kkal_, _once_, _temă_, _أَصْ
  { {0x5d840003,0x22590034,0x65a3005e,0xa91d0073}},	//   _للمل, ńsko_, _kõhu, _požy
  { {0x54a70012,0x2904054e,0x0c240024,0x7bf9004c}},	//   _تحاف, äma_, _амін, _ендр_
  { {0xdb1a10ac,0x644d10ad,0x649a0009,0xd7f20012}},	//   cità, duai, _מינה, اكس_
  { {0xa6a90003,0xfe670003,0x645b10ae,0x7a090030}},	//   وافق_, دد_, ltui, _větr
  { {0xdb1a10af,0x65aa01bd,0x2aba0009,0xb2ba0009}},	//   pitã, _výho, _ממצא, _ממצר
  { {0xd467031e,0xf3900081,0x04430c80,0xb9060024}},	// [20a0] ните_, _mảnh_, летн, _язик
  { {0xda660003,0x6abd0037,0x32d600ac,0x69c610b0}},	//   فاصي, ्पूर, нцес, like
  { {0x6b9c008b,0x69c6004a,0xdb1a10b1,0x0f570009}},	//   _vorg, oike, nitá, _איים_
  { {0x2d9d003e,0x69c610b2,0x317b0009,0xed5f068c}},	//   _nowe_, nike, ּ֨אמ, ížte_
  { {0x69c6004a,0xf5370009,0xd7e60024,0x645b0227}},	//   iike, _אנכי_, ніко, jtui
  { {0x69c60051,0x7c240f67,0x7bcf10b3,0x61eb10b4}},	//   hike, mpir, écul, algl
  { {0x61fd0065,0xda0b0037,0x61460001,0x412a0294}},	//   ymsl, _संगत_, _пева, _ново_
  { {0xc6930093,0xf3900020,0x22470026,0xd5b70800}},	//   ראה_, _cảnh_, ánke_, есь_
  { {0xdce6001e,0xd5770009,0xb88600d9,0x645b0227}},	//   _nokļ, תתפה_, _blíž, gtui
  { {0x765c0002,0x61e20051,0x10090012,0x883b0009}},	//   ktry, lool, _قتلى_, _מתמו
  { {0xf8bf014d,0x6fb3000a,0x62830027,0x0bb7000b}},	//   _þér_, _حملا, _crno, גלים_
  { {0x765c0572,0x248004d7,0xc2370009,0x67350034}},	//   dtry, kvim_, ערכו_, wazj
  { {0xc86405fb,0xc0ab0012,0xf1c00011,0x644d0018}},	//   лтри, ساحل_, शोधन, xuai
  { {0x32940003,0x7c24009b,0x36d50594,0x22940012}},	//   _للتأ, dpir, вогр, _للتس
  { {0x61e20005,0xc987002d,0xf41f004a,0xdb1a10b5}},	//   kool, _зупи, _stä_, citá
  { {0x69c610b6,0x644d10b7,0x2a570009,0xf0a60081}},	//   cike, tuai, _נבחן_, _đành_
  { {0xdce400a2,0xd1640014,0x59640014,0x26110037}},	// [20b0] rdiğ, _същи, _съща, _दूरी_
  { {0x65a30051,0x3f9e003a,0x657b10b8,0xa91d10b9}},	//   _rõhu, _notu_, zduh, _inži
  { {0xc333000b,0x325500be,0x644d10ba,0x8c440060}},	//   רוע_, твер, suai, ışar
  { {0xaadb0009,0x65a3005e,0x000000c4,0x000000c4}},	//   החבר, _põhu,   ,
  { {0xed600066,0xb9540012,0xef0e026d,0x644d07b5}},	//   ížet_, ائمت, им_, quai
  { {0xf7710003,0xa08c000b,0x98a20aa8,0x10a2004c}},	//   شات_, לְוִ, рише, ришн
  { {0x68e90034,0x3f9e0035,0xb1aa0097,0x03d60009}},	//   _wyed, _dotu_, þýðu, _יושם_
  { {0x65a30051,0xfc3f014a,0xd6ce0003,0x645b10bb}},	//   _tõhu, ším_, تقى_, ttui
  { {0x75c80066,0x672c0031,0x645b008e,0xa5f6004c}},	//   vězt, éljü, utui, њењу_
  { {0x645b0ca5,0xdb1a0031,0x43740024,0xb4fc0009}},	//   rtui, titá, гуют, הפחי
  { {0x2fc709e5,0xcb12000b,0x3869000d,0xe6950012}},	//   ming_, ילי_, _apar_, _جلاد
  { {0xcec40030,0x2fc710bc,0x765c10bd,0xdb1a10be}},	//   hoří_, ling_, vtry, ritá
  { {0x98a40010,0xe6040012,0x2fc70bb5,0xa93a0009}},	//   _temą_, _إِنَ, oing_, ותרפ
  { {0xf7720003,0x69c610bf,0x645c004b,0xdb1a10c0}},	//   جاح_, sike, ărit, pitá
  { {0x644910c1,0xd00700bb,0xdee60d7c,0xed5a10c2}},	//   lrei, тере_, тови, мов_
  { {0xceb20093,0x661c000f,0xb6020028,0x7d1b10c3}},	//   ביל_, _érke, _þátt, ncus
  { {0xe8fa0014,0x69c40002,0x973c0027,0xff2600de}},	// [20c0] _юли_, _imie, _hoće, _импо
  { {0xf837000b,0x4b23002d,0x236a0012,0xa8370009}},	//   _שנית_, имув, بحري_, _שריד_
  { {0x6449008b,0xf1c60037,0x2d9e0061,0x3bd50015}},	//   hrei, _लगान, êtes_, уютс
  { {0x644910c4,0xba9a0009,0xe2450012,0xd9180012}},	//   krei, וסעי, اخلي, ريتش_
  { {0x61e20005,0xdfda0014,0xc9530009,0xe0d20012}},	//   rool, мък_, שמד_, جزا_
  { {0xb17b0163,0x66f60037,0x2fc710c5,0x6e8a004c}},	//   llåt, _इराक_, ging_, дљив_
  { {0x61e20005,0x16370003,0x8fa30001,0xc7b3000b}},	//   pool, نسية_, раје, שבו_
  { {0xfa77000b,0x55740014,0xadf80037,0x644910c6}},	//   _בעלת_, угит, ंगटन_, frei
  { {0x7aea006f,0x7c3b002c,0x644910c7,0xc7c8001a}},	//   _syft, gsur, grei, hối_
  { {0x2fc710c8,0x75c80030,0xafdb0040,0xef83004c}},	//   cing_, tězs, msøg, _клуп
  { {0x7c3b0bad,0xcfb70009,0xafdb0040,0x75290031}},	//   asur, _שלבי_, lsøg, bbez
  { {0xf1a70fdf,0x200c020d,0x644910c9,0x8c1a0012}},	//   трон, _hidi_, brei, _قيصر_
  { {0xc173000b,0xe1ff0164,0xafdb0058,0xbb860012}},	//   בחר_, rmó_, nsøg, _للإي
  { {0x9f5303eb,0x2618001a,0x5c370009,0x5334034d}},	//   _això_, _kéo_, _ירדן_, _сект
  { {0xf8bf0149,0x9f34002d,0xda7a0014,0xcec40066}},	//   mbém_, ресі, _цял_, voří_
  { {0x7c2204b4,0x200c0066,0x798d10ca,0xb9550048}},	//   _ktor, _lidi_, _unaw, _свищ
  { {0x2fc70036,0x6abd0037,0x69c30061,0x85140024}},	// [20d0] ying_, ्प्र, ènem, рмує
  { {0x02a7007c,0x69c404f4,0x98be000d,0xdb07000e}},	//   крем, _zmie, ştă_, _aljá
  { {0x9f5e0006,0xafdb0058,0xd25b0015,0x2fc710cb}},	//   _mitä_, esøg, ьца_, ving_
  { {0x7bc800c6,0xdd950047,0xdb1a10cc,0xe919002d}},	//   hidu, _самы, litä, ході_
  { {0x3944002d,0xafdb0058,0x91bc0009,0x2fc710cd}},	//   рніг, gsøg, ומאי, ting_
  { {0xdb07000f,0xdb1a0052,0x3fe40024,0x68380030}},	//   _eljá, nitä, ажів, _súdá
  { {0xe1db0012,0x37080012,0x6e950012,0xc2c50012}},	//   _قبرص_, نْهُ_, العا, _إيزي
  { {0xf2d2000b,0x7c3b10ce,0xdd8e0012,0xafdb0040}},	//   _העל_, tsur, كوى_, bsøg
  { {0xdb010030,0x91fd0035,0x200c00b8,0x6738001b}},	//   dklá, itād, _fidi_, bavj
  { {0xdb010570,0xa3d90011,0x7c3b10cf,0x7529016a}},	//   eklá, ावट_, rsur, sbez
  { {0xdb1a10d0,0x35550012,0x02c50024,0x68f60034}},	//   entó, _مناز, уйно, _szyd
  { {0x24860274,0x64460010,0x645c000d,0xe5730012}},	//   _from_, škia, ărir, _خطط_
  { {0x35c60037,0xf5390029,0xdb08008e,0x7bc801e3}},	//   रोफ़, mať_, ehdä, bidu
  { {0xf5390029,0x8e7610d1,0x7bc810d2,0x000000c4}},	//   lať_, лубч, cidu,
  { {0xc7c80081,0xf9920012,0x7bda0009,0xdb1a08f4}},	//   uối_, _هبة_, _אקסו, antó
  { {0xceb2000b,0xf5390029,0x69c410d3,0x25ad10d4}},	//   זיל_, nať_, _umie, nkel_
  { {0xb17b0248,0x657d0db9,0x808a00ae,0xcce500ae}},	// [20e0] rlåt, _dash, _أضعف_, لسكي
  { {0xb17b00b0,0x9f5e004a,0x550301d4,0x28970009}},	//   slåt, ötä_, спуб, _עדין_
  { {0xf5390029,0xdb1a003a,0x2ca9002c,0x25ad10d5}},	//   kať_, sitç, ayad_, kkel_
  { {0xe9e5002d,0xf5390029,0x22460029,0x83fd000e}},	//   аціо, jať_, čok_, ltőd
  { {0xf5390026,0xe8940094,0x200c0051,0x07a610d6}},	//   dať_, раль, _pidi_, ладн
  { {0x2d8f0163,0xafdb00c5,0xdb010030,0x7bc810d7}},	//   _ange_, rsøg, zklá, xidu
  { {0x1a78000b,0x6738009b,0x200c00eb,0x72780009}},	//   _בְּמ, ravj, _vidi_, _בְּצ
  { {0x442a0046,0x6d560101,0x9f5e0006,0x7bc80002}},	//   нцом_, ngya, _sitä_, widu
  { {0xa84a0003,0x6d56002c,0x61e610d8,0xa4d40024}},	//   _سلام_, igya, dokl, ропі
  { {0x99860010,0x21f20030,0xdb1a0032,0x7bc8005e}},	//   kslų_, sáhl_, xitä, uidu
  { {0x7bc80005,0xdb1a03d7,0x7c220034,0xf5390064}},	//   ridu, vitä, _wtor, bať_
  { {0x2eb00044,0xd9f60037,0xf5390064,0x25ad10d9}},	//   जनीत, ेषित_, cať_, ckel_
  { {0xab940024,0xcdf70009,0xdb1a02b9,0x7bc810da}},	//   _вилі, _עמדי_, titä, pidu
  { {0x14d7000b,0x2a660002,0xcc570009,0x2d8010db}},	//   _גודל_, łoby_, _עסוק_, edie_
  { {0x9f8b0051,0xe2460012,0x16350048,0x83370009}},	//   _töös_, _إختي, ребя, _גאוס_
  { {0xca470003,0xfe370009,0xa968004c,0x4a5b0009}},	//   _إليه_, טרלי_, _бића_, _נדחו
  { {0xdb1a074a,0x24180024,0x33870048,0xe58b0009}},	// [20f0] pitä, гією_, лужв, עָלָ
  { {0x61e9039c,0x91fd0039,0x6ee7000a,0xf5390026}},	//   _skel, stād, _مسجل, zať_
  { {0x92590015,0x20f4001a,0x7bdb0009,0xfbd00012}},	//   тает_, _ài_, עקבו, ستك_
  { {0xd257000b,0xe9ce002d,0x5e880012,0x62080012}},	//   רשאה_, ік_, _إنَّ_, هْلِ_
  { {0xf53904b4,0xd5b10020,0x3d3a000b,0xdd3a0009}},	//   vať_, _lúc_, _בגרס, _בערכ
  { {0x2259003e,0xdd1c0010,0x10380009,0xf8380009}},	//   ński_, _iššo, נטום_, ננות_
  { {0xfd110003,0x25ad0051,0xf5390029,0xf7700012}},	//   يجة_, tkel_, tať_, ثان_
  { {0xada50015,0x644d0f27,0x067c0009,0x61e90073}},	//   раил, orai, תנהל, _ukel
  { {0x442900c6,0x98480098,0xf5390029,0x644610dc}},	//   npa_, _бяха_, rať_, škin
  { {0x7ff7000a,0xf5390029,0xec680003,0x81bd001e}},	//   _إسرا, sať_, اصيو_, spēl
  { {0x8b88000b,0xaa490014,0x22490014,0x25b0000e}},	//   אָרֶ, ъпна_, ъпни_, álló_
  { {0x69cb008b,0x61e60010,0x6aba003a,0xdb0105b1}},	//   nige, uokl, _ütfe, chlý
  { {0x61e60066,0x81bd001e,0x8fe60012,0x644d0031}},	//   rokl, opēj, لأسم, jrai
  { {0xd0f6000b,0xdfd20003,0x69cb0052,0x7c2910dd}},	//   שמשת_, زيز_, hige, mper
  { {0xa91d00f1,0x6da60015,0xe73703e1,0x5f060048}},	//   _každ, аива, рес_, рзва
  { {0xceb2000b,0x32da000b,0x63a308c5,0x9f43008e}},	//   קין_, _שחקנ, _honn, eljä_
  { {0xb425000a,0x63a3008b,0xa91d0010,0xec7a0014}},	// [2100] معلو, _konn, _mažd, ъпа_
  { {0xeab20003,0x7c2910de,0xaec60024,0x60fb0009}},	//   يعا_, iper, _вбол, _בהפק
  { {0x69cb0052,0xd5b10081,0x6d460031,0xdb010040}},	//   fige, ếc_, ókak, sklæ
  { {0x673c009b,0x69cb0052,0x291200b0,0x629a01a0}},	//   larj, gige, øya_, _àtom
  { {0xdcee0039,0x443f0002,0x660401a3,0x20890009}},	//   ādīj, jsu_, mmik, ָתוֹ_
  { {0x98a40013,0x7c29000e,0x673c009b,0xc66a0015}},	//   _země_, dper, narj, вшие_
  { {0x29560014,0x69cb0052,0x91fd001e,0x66730003}},	//   _възр, bige, ntāc, قدير
  { {0xd378001c,0xef18001e,0x18a6002d,0x443f00b6}},	//   moći_, _daļa_, _кабм, fsu_
  { {0x26160044,0xb0c50037,0x63a303b1,0x6da30012}},	//   _पूरी_, _लेंग, _bonn, تميم
  { {0x6be30003,0x0ba60024,0x63a310df,0xeb060ba0}},	//   يكيم, ршим, _conn, ично
  { {0x63a30edb,0xdb010052,0x673c009b,0x6d460107}},	//   _donn, chlü, darj, _odka
  { {0x7c260027,0xd6cf0003,0x31c70aa2,0x32180034}},	//   _otkr, _تقم_, рсов, _mury_
  { {0xf7730003,0x84630014,0x55bb0009,0xc5f30009}},	//   ياس_, _дъще, _במאו, _ודף_
  { {0x442601e5,0x644d0061,0x660401b7,0xd1030011}},	//   _ito_, vrai, emik, रेषण_
  { {0xc3fb000b,0x639b000b,0x7c260071,0x644010e0}},	//   _שלוש, _בסגנ, _atkr, lsmi
  { {0x79820002,0x44260fae,0xa91d017b,0xf5310009}},	//   jdow, _kto_, _kaže, ּ֥ן_
  { {0x61ed002c,0xdb1e004a,0x752d10e1,0x69fc0009}},	// [2110] _ikal, kipä, rbaz, _בלהק
  { {0xa91d0010,0xdb0e000e,0x69d80061,0xfa870001}},	//   _maže, _elbí, éven, ићем
  { {0x69cb00d6,0xd1310012,0x39150012,0x386d10e2}},	//   tige, كما_, مواز, _sper_
  { {0xf5950003,0x442610e3,0x64400a4a,0x8d950012}},	//   _الحج, _oto_, ksmi, _الحش
  { {0xfd96000b,0xbcfb0061,0xe6cb0028,0xf8690012}},	//   _הדרך_, _obéi, _íbúð, امتي_
  { {0x6d58003a,0xdb1e0051,0x18780009,0x79820034}},	//   ıbaş, gipä, יעדר_, adow
  { {0x98ab0002,0x644210e4,0x3f8110e5,0x86980048}},	//   racę_, _avoi, _mahu_, итът_
  { {0x81bd0333,0xc1c60037,0x63a310e6,0x443f078a}},	//   spēj, _लगेग, _sonn, tsu_
  { {0xb4f50037,0xdb1e0051,0x63a3004a,0x60d5000b}},	//   _आरोप_, bipä, _ponn, _הוּא_
  { {0x5f440003,0x443f10e7,0x6395003c,0x63ba0a0c}},	//   _ونقل, rsu_, сшиф, ghtn
  { {0x443f0065,0x673c009b,0xf7700003,0x2fe40012}},	//   ssu_, varj, _زال_, _بكلف
  { {0x261c0164,0xc7a9000b,0x59990009,0x443f10e8}},	//   _río_, _אב_, אשֹׁ, psu_
  { {0x628a008b,0x95c40003,0x3e61000e,0x973c0027}},	//   _erfo, _بينه, lót_, _moćn
  { {0x79820002,0x232606bd,0x261c01e3,0x63ba0529}},	//   zdow, _лоши_, _pío_, chtn
  { {0xdfcf000a,0x539a000b,0xa91d0b68,0x4b360009}},	//   ريف_, _תיצו, _zaže, _הרצל_
  { {0xdb010422,0xfd950024,0x09e30048,0x91e30048}},	//   rklä, ошую, _нощн, _ноще
  { {0x660410e9,0xe3160003,0xc9b7000b,0xd5af0003}},	// [2120] rmik, مباب, _להקת_, رفك_
  { {0x69c90051,0xa3ca0037,0xdd3c0002,0xb09b0009}},	//   _amee, रोप_, lążk, _עייר
  { {0x8e8610ea,0x9f4c001a,0x0a4a0021,0xdddc0027}},	//   _الجه, _đoàn_, узей_, avrš
  { {0xe93a0003,0xe9da0015,0x7982010f,0x6d460040}},	//   اسات_, ыке_, udow, _udka
  { {0x7982003e,0x60000248,0x67ed0031,0x0f140024}},	//   rdow, römf, yújt, омлю
  { {0xc059007c,0xdefa0015,0xd0f7000b,0xa6660012}},	//   рії_, лый_, זמנת_, مطبو
  { {0xa91d0027,0xf773000b,0x79820052,0xf8bf000e}},	//   _saže, פקה_, pdow, zzé_
  { {0xa91d0010,0xfad7000b,0xdb1e00ff,0xc6930009}},	//   _paže, _הולך_, sipä, לאו_
  { {0x2d820036,0xe0da0001,0x5bb8004d,0xd7f20012}},	//   _make_, _сва_, илия_, _فكر_
  { {0x547b000b,0x4f660003,0xd4e30015,0xa91d0027}},	//   נטיו, _دارف, яющи, _važe
  { {0xc333000b,0xc7b3000b,0xe2f8002d,0x9f8d0066}},	//   הות_, _צבע_, рені_, uží_
  { {0xdb1c0028,0x6456002c,0x9d1a0012,0xc2b70024}},	//   _umræ, kuyi, _إزاء_, слює_
  { {0xafdb03ee,0x673a004a,0x5c060472,0x98a20034}},	//   drør, _ketj, _ляка, ybką_
  { {0x7bcf0061,0x9cd70009,0xf8bf0031,0x439410eb}},	//   écut, _פוגה_, rzé_, _факс
  { {0x25a600ca,0x2bf70009,0x5bc50012,0x15f70012}},	//   _kool_, _המגן_, _بتنف, مسرح
  { {0xd2570009,0xf9930012,0xe4e70024,0x58d50048}},	//   _השהה_, _ربع_, бізн, _мойт
  { {0x3f8100c6,0x3e61000f,0x21f90042,0xf9900012}},	// [2130] _tahu_, zót_, lého_, _أبى_
  { {0x3cfb000b,0x8c1b0009,0xd3710012,0x261a0011}},	//   רלמנ, טומי, ظها_, _मूवी_
  { {0xdb030054,0x21f90107,0x02d90003,0x62750012}},	//   _conè, ného_, جواب_, تهائ
  { {0xd3780027,0x9f4c001a,0x92b40003,0xeab1000b}},	//   moću_, _đoán_, أحكا, וֹד_
  { {0x8fa50063,0x3dcd10ec,0x21f900d9,0xe7390681}},	//   жале, view_, hého_, аел_
  { {0xa858000b,0x21f9014a,0x3e61000e,0x7e8b0009}},	//   מידה_, kého_, tót_, ָאֵ֖
  { {0x56920046,0x99890002,0x39490b45,0x8e550024}},	//   дајт, _miał_, _odas_, іткі
  { {0x3e610053,0x0c250086,0x8c490024,0x75d50012}},	//   rót_, омин, апив_, تيعا
  { {0x61eb10ed,0x28f80024,0x6f000031,0xe3b90b4e}},	//   mogl, _геть_, _kábí, иби_
  { {0xfbc5002d,0x2d84005e,0x394910ee,0x4a4506eb}},	//   ібно, adme_, _adas_, онов
  { {0xdb1a0006,0xe9da0a25,0x69d90002,0x569410ef}},	//   yntö, ико_, onwe, _нафт
  { {0x3e45001e,0x7c2d10f0,0x6c850012,0x7a13004b}},	//   mēt_, kpar, _ولضم, _bătr
  { {0x7a13007d,0x3e450039,0x15180012,0xdca506bd}},	//   _cătr, lēt_, _ازمة_, _фали
  { {0xd5b10020,0x4407022a,0x2d8210f1,0x99890034}},	//   ến_, _учеб, _sake_, _ciał_
  { {0x3e45001e,0xb9c60003,0x2489003a,0x2d8200b6}},	//   nēt_, _وقتي, evam_, _pake_
  { {0x28c50044,0x6b8310f2,0x60000248,0x65690032}},	//   _लेकि, _hang, döme, nfeh
  { {0xfaf80039,0x90c30047,0x7c2d002c,0x61eb10f3}},	// [2140] _šī_, _объе, gpar, dogl
  { {0x6b8300c6,0x0b46002d,0x442d10f4,0xdb1c10f5}},	//   _jang, інен, ipe_, _områ
  { {0x2d8210f6,0x61eb10f7,0x65b501bd,0xd36f0012}},	//   _take_, fogl, _náho, ئهم_
  { {0x673a0065,0x3e450039,0x61eb10f8,0xdb0310f9}},	//   _setj, dēt_, gogl, _coné
  { {0x7984002c,0xb033002d,0x7c2d0018,0x00da0012}},	//   _maiw, дніш, cpar, جبات_
  { {0x6b830167,0x5f930001,0xe7930001,0x69d902a2}},	//   _nang, дишт, дишњ, anwe
  { {0x25a60b7b,0x171b000b,0x8f1b0009,0xd6d00012}},	//   _pool_, בוצע, בוצת, عقب_
  { {0x6b8300bd,0x21f900f1,0x798408bb,0xc0e60024}},	//   _aang, vého_, _naiw, _добк
  { {0x2d820029,0x6b8310fa,0x65b50030,0xc4f70012}},	//   ľke_, _bang, _táhn, يعًا_
  { {0x6444004a,0x7996002a,0x661a0855,0x21f90042}},	//   isii, _anyw, _tutk, tého_
  { {0x0377000b,0xe919002d,0x3e45001e,0x0ac60015}},	//   חתית_, йоні_, cēt_, ющим
  { {0x64440006,0xd46a06fd,0x21f901bd,0xd1260012}},	//   ksii, _виде_, rého_, عم_
  { {0x6d400891,0x395f001e,0xdd8f0003,0x14c70015}},	//   mama, ļus_, _جون_, _мыши_
  { {0xcb670046,0xa91d0010,0x6d4010fb,0x48a80024}},	//   _даље_, _maža, lama, ітям_
  { {0x09f70012,0x81f70012,0x179b0009,0xdb210097}},	//   _وأعد, _وأعط, סילב, ótís
  { {0x65b50013,0x2489009b,0xb2bb0009,0x22510064}},	//   _náhl, tvam_, _כמור, ázke_
  { {0xb4b50044,0x3e450039,0x54550014,0x7bda000d}},	// [2150] जने_, zēt_, яват, ontu
  { {0x6d4010fc,0x2bbb0012,0xc3980024,0xfe500060}},	//   hama, جارة_, окує_, üçük_
  { {0xd3780002,0x6d4010fd,0x877a0009,0x65aa0042}},	//   ieć_, kama, _האתי, _výhr
  { {0xa3ca0044,0x63a7003e,0x3eac0052,0x3e45001e}},	//   रोत_, _wojn, ädte_, vēt_
  { {0xf1b40093,0xd8b80003,0x759a0009,0x7dc50010}},	//   וסף_, يدها_, _הסרג, iųst
  { {0xec36000b,0x907c000b,0x8e490003,0x0058000b}},	//   _מאשר_, שְׁפ, ملتك_, קשות_
  { {0x5f740003,0x1f380009,0x41770012,0x69cd03bd}},	//   ظاهر, חרור_, _وارس, _omae
  { {0x753d003e,0x3e450039,0x3179003e,0x26dc000b}},	//   _jesz, rēt_, jesz_, יקומ
  { {0x442d0108,0xe4510003,0x3e45001e,0x6b8310fe}},	//   upe_, رضة_, sēt_, _pang
  { {0x69dd0108,0x3fb70003,0x753d10ff,0x3e45001e}},	//   éren, _بإرس, _lesz, pēt_
  { {0xa3ca0037,0x9ee90003,0x65690052,0x2bca0037}},	//   रोध_, _افضل_, pfeh, ाफ़ा
  { {0x216a0021,0xe8e0001a,0x6d401100,0x442d1101}},	//   щими_, uyệt_, cama, ppe_
  { {0x251a000b,0x6b831102,0x43950511,0x60d50009}},	//   _הונא, _tang, _надс, לוֹא_
  { {0x78a90051,0x5bc40003,0xa0880009,0x3b840024}},	//   äeva, _يتوف, קְרִ, _оліг
  { {0x753d000f,0xa3b80012,0xbb3a0009,0x7aee00d9}},	//   _besz, _ظاهر_, _העצי, čité
  { {0x3179003e,0x3f8500c6,0x64440005,0x9c261103}},	//   cesz_, _lalu_, tsii, здад
  { {0x39420005,0x43760047,0x49bb000b,0x90460003}},	// [2160] maks_, зует, _למקס, _عنده
  { {0xb9030047,0x0e661104,0x39420cb1,0x64441105}},	//   _язык, _екон, laks_, rsii
  { {0xae0e0044,0x68120066,0x74130003,0x66091106}},	//   ागमन_, _vědě, روما, kmek
  { {0x58860015,0xd3780002,0xa91d0010,0x39420051}},	//   зыка, zeć_, _paža, naks_
  { {0x66090051,0x59bd0011,0x03950035,0x6d401107}},	//   dmek, ्फ़र, _ķīnā_, vama
  { {0x6d4b00c5,0xa857000b,0x39420051,0xa91d0027}},	//   _adga, פיצה_, haks_, _važa
  { {0x7c2b0039,0x39420051,0x6d401108,0x3e870030}},	//   _atgr, kaks_, tama, mítá_
  { {0x0576000a,0x39420051,0x9adb000b,0x8d760003}},	//   ساعد, jaks_, _החלט, ساعا
  { {0x39420051,0xa91d001b,0x3f85056b,0x83fd0031}},	//   daks_, _kažn, _falu_, rtőn
  { {0x88bb000b,0x39420051,0x644f1109,0x58bb0009}},	//   _הזמי, eaks_, ácia, _הממצ
  { {0x21fc0013,0x2179003c,0x2c660064,0x6d40110a}},	//   ního_, ойны_, hôd_, pama
  { {0xdcfd001e,0xa91d017b,0x5afb0009,0xf1bf0030}},	//   _lasā, _lažn, מליצ, uhá_
  { {0xd5b10020,0x4420007d,0xed57002d,0x753d0053}},	//   ếm_, _îi_, _хоч_, _resz
  { {0xad9b008a,0xba760012,0xd7f10081,0x75380034}},	//   _chún, _فاعت, ỗ_, ńczą
  { {0x33fb000b,0x21fc0066,0x93fb0009,0x6e94003c}},	//   _ההגנ, jího_, _הלגי, ниру
  { {0x22f7000b,0xfaf7000b,0xe4e70024,0x9df90024}},	//   _מזון_, _מצוי_, пізн, інат_
  { {0x753d000e,0xa91d0010,0x7c150024,0xc1050012}},	// [2170] _vesz, _bažn, ддає, _توظي
  { {0x88bc0009,0x58bc0009,0xd9b50011,0x753d0034}},	//   _למחז, _למחצ, ंस्ट, _wesz
  { {0xa91d007a,0x753d000f,0x22950003,0x2247000e}},	//   _dažn, _tesz, بلاس, énk_
  { {0x6aaa006f,0x31350055,0x69dd110b,0xc27b0009}},	//   äffa, федр, nnse, מרבי
  { {0xdce0001e,0xdb18000e,0xc5fb0037,0xdbc7004a}},	//   iemē, _elvé, ्षीय_, töäs
  { {0xbcb6000b,0x76550002,0xa6950001,0xab840264}},	//   _חפשו_, orzy, дриј, _пуск
  { {0x21fc0013,0xdb09003a,0x63a30028,0x660905ea}},	//   cího_, ünün, önnu, tmek
  { {0x25bf0051,0x69dd110c,0xa4c0003a,0xe1f30012}},	//   uhul_, érel, nüşü_, _أسس_
  { {0x91fd0333,0x39420005,0xed600066,0x6609110d}},	//   rtāl, vaks_, ížit_, rmek
  { {0xe3b10003,0x63aa0002,0x76550002,0xa3b00011}},	//   ئرة_, _cofn, krzy, टॉप_
  { {0x39420051,0x76550002,0x7afd0002,0x6609001e}},	//   taks_, jrzy, ęsto, pmek
  { {0x44b50047,0x68f60006,0x6d4b0058,0xa91d0010}},	//   _обес, _pyyd, _udga, _mažo
  { {0xe87c00a2,0x76550002,0x21fc0066,0xa3ca0011}},	//   _düşü, erzy, zího_, रोह_
  { {0x39420005,0xa84d0030,0x6be50012,0x6f040030}},	//   saks_, énář_, _تكتم, řice
  { {0xe9d2000a,0x7a420030,0xc3320009,0x248d110e}},	//   _لغة_, _vítá, _יוג_, lvem_
  { {0x2176002d,0xcb120009,0x7bc10097,0x68f6008e}},	//   _цукр, _בלו_, lhlu, _tyyd
  { {0xdcfd001e,0xa91d0027,0xceb80010,0x60040054}},	// [2180] _pasā, _pažn, šę_, lòme
  { {0x22ba0003,0x76550002,0x67220011,0x21fc0030}},	//   يداع_, brzy, _मलिक_, tího_
  { {0xa91d001c,0x4f9b0009,0x994a0012,0xbf9b0009}},	//   _važn, _וביצ, قلال_, _וייש
  { {0x200500b6,0xa91d001e,0x02de0011,0xbbaa0011}},	//   _ahli_, _dažo, _मशीन, _चक्क
  { {0x765c004a,0x7bc100b6,0x6d440182,0xa87a0012}},	//   lury, khlu, maia, تحار_
  { {0x62830082,0x7bdd0061,0x6d4402a5,0x3940110f}},	//   _osno, ésul, laia, _leis_
  { {0x5a550014,0x2e4a0014,0xf7730009,0x60090009}},	//   _пъту, цяло_, דקו_, הִקְ
  { {0x77b403eb,0x1dde0037,0xdb0a0058,0x986a0012}},	//   _màxi, नचित, _ilfø, _وحذف_
  { {0x9be6002d,0x69dd08cf,0xdbc6005e,0xa06a0373}},	//   дінк, érem, _möön, _фаза_
  { {0x5a340014,0xc6760003,0x4bda0003,0x69c20227}},	//   ннот, _يطاب, تبعد_, lhoe
  { {0x8aa3002d,0xcb57000b,0x6d441110,0x5b570009}},	//   вряд, וסיה_, kaia, וייב_
  { {0xf5930003,0x8d930003,0x85060003,0xa194002d}},	//   _للمج, _للمش, _قوان, ваюч
  { {0x3cfa0011,0x5064004c,0x22590034,0x69dd1111}},	//   ्धों_, ктра, ąska_, rnse
  { {0x7655003e,0x7bc10052,0x7d020027,0xafdb0033}},	//   trzy, chlu, _izos, msøk
  { {0xafdb0033,0x99d70003,0x05b20011,0xef110009}},	//   lsøk, _يتعا, _जवाब, ָּם_
  { {0x69d6000e,0x41e70012,0xe3b80060,0xa91d0035}},	//   ézet, _تستف, lkı_, _ražo
  { {0xe9df0026,0x656d008b,0x113c0009,0xa4c00060}},	// [2190] mnú_, rfah, _ותחל, rüşü_
  { {0x76550002,0xe9df0029,0x8c1b0009,0x6606005e}},	//   przy, lnú_, קובי, _ehkk
  { {0x248d0066,0x77b0006f,0x6fd40012,0x33f40248}},	//   zvem_, _växt, _جزيئ, växt_
  { {0xd5a60003,0xe9df0029,0xd258003c,0x29d20159}},	//   _صف_, nnú_, ьцу_, jšal_
  { {0xe4e7002d,0xe3b8003a,0x53470015,0x99d40012}},	//   _цінн, kkı_, _охва, ختلا
  { {0x40920012,0xe79b0012,0xe9df0064,0xdc3a0009}},	//   الور, تخصص_, hnú_, _מעשר
  { {0xfe710003,0xafdb0033,0xe9df0029,0x660d004a}},	//   ادت_, esøk, knú_, omak
  { {0xff18000b,0x91fd001e,0x2247022d,0x660d1112}},	//   וקות_, stāj, ánku_, nmak
  { {0xe9df0029,0x6000006f,0xd5e80012,0xd7fb004c}},	//   dnú_, dömn, بعون_, _дуж_
  { {0xa3ca0037,0xd5b1001a,0xa91d0073,0x87070012}},	//   रोल_, _múi_, _mažm, _قبال
  { {0xe29905f7,0x7bc10097,0xbb3a0009,0x660d1113}},	//   чан_, rhlu, העתי, kmak
  { {0xdb070065,0x3ce00604,0xcb120009,0x8d740012}},	//   _hljó, _žive_, טלי_, _لاها
  { {0xd4c40012,0xbcfb1114,0xdb050032,0x660d1115}},	//   _لغوي, _scén, chhö, dmak
  { {0x78a4019a,0x6d4408ee,0xa2e5003c,0x64491116}},	//   äivi, waia, _полд, msei
  { {0x670f0037,0xe9df0029,0xa91d0027,0x64460010}},	//   ाधिक_, bnú_, _pažl, škit
  { {0xe9a90012,0xe6170048,0x62860035,0xe9df0064}},	//   _يدين_, едс_, ākot, cnú_
  { {0x6b560003,0x64491117,0x998d0034,0xe3ba0048}},	// [21a0] فضائ, nsei, _mień_, пба_
  { {0x43860003,0x64560a39,0x6d441118,0x26cc0017}},	//   علاق, rryi, saia, údos_
  { {0x443201f6,0x14170012,0x6d441119,0xdbc6005e}},	//   spy_, ريمة_, paia, _töön
  { {0x50660014,0x7aba000b,0xc8660867,0x6449111a}},	//   етка, הצעו, етки, ksei
  { {0xad1b000b,0x351b000b,0x83fd0031,0x69c2111b}},	//   _מוכר, _מוכנ, rtőj, rhoe
  { {0xd0100012,0xf41f008e,0xe9df0064,0x7f580d21}},	//   جلت_, _eräs_, znú_, факс_
  { {0x539b000b,0x644b079d,0xc7b30009,0x7d020034}},	//   _צילו, _avgi, רבו_, _szos
  { {0xafdb0033,0xa91d009b,0x7b06001e,0x9f4a00d9}},	//   tsøk, _lažj, ērtē, dobí_
  { {0xdb070065,0xe9df0029,0x91fd001e,0x69c0111c}},	//   _fljó, vnú_, stāk, _ilme
  { {0xa3ca0044,0xafdb0119,0x660d111d,0xe1fb0011}},	//   रों_, rsøk, zmak, ृष्ण_
  { {0xa159111e,0xe9df0029,0x2ec60003,0xdb0e090d}},	//   ману_, tnú_, _ثقاف, _albú
  { {0xe3b8003a,0x64490052,0xb6bb000b,0x3e4c0030}},	//   skı_, bsei, _מצבי, mět_
  { {0x98b80014,0xe9df0029,0xe3b80060,0xecd00011}},	//   елят_, rnú_, pkı_, _सेलफ
  { {0xc5fb0037,0xe9df0029,0x8c1b0009,0x69c000b0}},	//   ्ष्य_, snú_, _זוגי, _llme
  { {0x442203c2,0xd5bb07f5,0x02930012,0x65bc0025}},	//   _auk_, пса_, _مؤيد, _jého
  { {0x7c22004a,0x660d002c,0xdcfb001b,0xb7b50081}},	//   _kuor, umak, uduć, _kịc
  { {0xd7fb0024,0xf3f9004b,0xfc300012,0xf3f10081}},	// [21b0] _нуо_, suţe_, محل_, _ự_
  { {0xa295002d,0xd3710003,0x7c2200b8,0x660d111f}},	//   казі, ؤها_, _muor, smak
  { {0xd1310003,0xb7b5001a,0x660d1120,0x2bb80012}},	//   لما_, _lịc, pmak, راكة_
  { {0x3e4c0013,0x91f60020,0x6449004a,0xdeb60009}},	//   dět_, hún, ysei, _יפתח_
  { {0x7c22050d,0xf7710012,0x690c0009,0x74150012}},	//   _nuor, لاث_, ִּדְ, _لوحا
  { {0x2d8b02d1,0x69c00236,0xa91d0010,0x64490051}},	//   _hace_, _elme, _kažk, vsei
  { {0xbea50365,0x9e090012,0xedcb0009,0xdfce00ae}},	//   тайк, ويتك_, ּמִֽ, تيو_
  { {0xc694000b,0xdcf90002,0x64491121,0xbbb90011}},	//   ראק_, _zawę, tsei, इस्क
  { {0x6d42007d,0xd5ae0003,0x7c2200c1,0xe3b10012}},	//   _deoa, تفي_, _cuor, لرد_
  { {0xb7b5008a,0x25a90051,0x64491122,0x98170012}},	//   _dịc, hjal_, rsei, _أبرا
  { {0x13090047,0x443d1123,0x2b580034,0xbcfb0025}},	//   ьной_, _www_, órca_, _scél
  { {0x7c2200c1,0x2d8b01e3,0x32090081,0x3eba00b0}},	//   _fuor, _nace_, _chay_, øpte_
  { {0xef18001e,0x9b950003,0xe5880009,0xbb850012}},	//   _daļu_, _للإت, _רָעָ, _للشي
  { {0x44221124,0xdce60064,0x61fd0097,0xd75a0012}},	//   _ruk_, ámče, alsl, بلست_
  { {0x7c220052,0xb9c60012,0x63ae001b,0xdb070030}},	//   _zuor, _لتظه, _robn, _bojí
  { {0xc6920009,0xa91d0035,0x44221125,0x2d8d1126}},	//   סאן_, _dažk, _puk_, ndee_
  { {0xdb070066,0xad250012,0x11d70012,0x30060048}},	// [21c0] _dojí, ارفو, _جوية_, _изиг
  { {0x291f0164,0xa01b0028,0xdce4001e,0x25a9005e}},	//   _agua_, svör, ediģ, ajal_
  { {0x68fb02d1,0xcf57000b,0x69c60051,0xdb03000e}},	//   _ayud, _בבית_, ohke, _elnö
  { {0xfbc9000b,0x3e4c0066,0x29d50030,0xf1bb0081}},	//   חת_, vět_, sťan_, _luơn_
  { {0x4153002d,0xf9930009,0x6443001b,0xc7c60306}},	//   рвіс, ירא_, ćnic, кски
  { {0x3e4c0066,0x57f30024,0xc7af0012,0xd7f70048}},	//   tět_, апіт, يّن_, кущ_
  { {0x7c220006,0x6e940003,0xb7db0009,0x7dde0035}},	//   _suor, البا, וקסי, līsi
  { {0xd657000b,0x96b70001,0xceb30009,0xa5330048}},	//   דיקת_, ђују_, שיה_, анъч
  { {0x7dde001e,0x8a17000b,0xc1570009,0x6d42005e}},	//   nīsi, _יחלו_, _ששמו_, _veoa
  { {0x2d80007d,0x7c22004a,0x3e4c0066,0xa7850012}},	//   heie_, _vuor, pět_, _مشمو
  { {0xd7ef0003,0xe3af0003,0x0bb7000b,0x5ea60012}},	//   _بكل_, تري_, דלים_, _جمال
  { {0x7c22004a,0x04960003,0x61e21127,0x3035003c}},	//   _tuor, _للصح, nnol, лемё
  { {0x7c2d003a,0x2d8b04f2,0xdb030031,0x3f8c0522}},	//   _çarp, _race_, _voná, _kadu_
  { {0x7dde0039,0xe7300003,0x6b8a0040,0x40340223}},	//   dīsi, قصف_, _uafg, рерс
  { {0x3209008a,0x8c1b000b,0xa6f80009,0xdb7b0009}},	//   _thay_, _קווי, גִּי, _חנוכ
  { {0x69c6008b,0x6564002c,0xda4b0009,0x13170009}},	//   chke, ggih, _חֲזָ, _בחול_
  { {0x33750019,0xa5f81128,0x61e202a8,0x1df8003c}},	// [21d0] лгар, тету_, dnol, теты_
  { {0x389a000b,0xf092000b,0x1b7b0003,0xd5b1001a}},	//   _ניתנ, _פני_, بصرة_, _hút_
  { {0x387e000d,0x798d020d,0xc9590012,0xf60b0012}},	//   ătre_, _kaaw, فلاش_, _يتجه_
  { {0xe1ff000e,0x83fd0031,0xdb1a04e7,0x61e21129}},	//   nló_, rtői, bitö, gnol
  { {0x80cd0044,0xd5b10020,0x040d001a,0x7fd50024}},	//   _देखे, ếu_, _cườn, лікі
  { {0xa91d007a,0x040d001a,0xf7710012,0x1d160009}},	//   _maži, _dườn, صات_, _תקשר_
  { {0xf770000a,0x2f54002d,0x9e640012,0xb05b0032}},	//   تان_, ртіс, لاين, szäh
  { {0xd5b1001a,0xdddc0066,0x2c6b014f,0x8e760012}},	//   _nút_, zvrž, tød_, اميذ_
  { {0x40590012,0x53b70011,0x661d112a,0x644d112b}},	//   _سلاح_, _आकाश, _misk, nsai
  { {0x3944001e,0x3f8c001e,0x2d8b015b,0x600008af}},	//   _zems_, _gadu_, žce_, tömm
  { {0xd94603e1,0xd5750a2c,0xd5b10081,0x7dde0035}},	//   лени, _буль, _bút_, zīsi
  { {0xcf890009,0xe0c70012,0x661d112c,0x69d90d61}},	//   _מט_, مز_, _nisk, niwe
  { {0xeb8e0909,0x256d0031,0x644d0035,0x6000008e}},	//   _ли_, zóló_, jsai, sömm
  { {0x6c520046,0xd8da000b,0x8b940014,0xe1ff000e}},	//   _укљу, תקשר, _връч, aló_
  { {0x3ebe0028,0xa91d001e,0x2eb50015,0xe2a80012}},	//   átt_, _daži, астс, _لاين_
  { {0x7dde0039,0x0c3a0012,0x8886112d,0x01660048}},	//   tīsi, فكرة_, _ближ, _скио
  { {0xb0d20044,0xb97b0009,0x6b810227,0x69c4004b}},	// [21e0] _देंग, _טנקי, oelg, _ilie
  { {0xdd03007a,0x798d0002,0xdb030061,0x8b2601b6}},	//   ūrėk, _zaaw, _conç, удже
  { {0x7afd0002,0xd7bb0009,0x7dde0035,0x644f0060}},	//   ęstw, _נצטר, sīsi, _evci
  { {0xd5b10020,0xc329000b,0x91fd001e,0xf1fa0012}},	//   ết_, לו_, stāv, رعات_
  { {0x7bc30005,0x6d46001e,0x935a0001,0x69c40064}},	//   _olnu, _ieka, _прву_, _mlie
  { {0x91fd0039,0xa634002d,0x661d01bd,0xdb030411}},	//   ltāt, анкі, _zisk, _gonç
  { {0x03d7000b,0x6d4600b6,0x63aa0028,0xf1c101e9}},	//   _עולם_, _keka, öfnu, ášky_
  { {0x040d001a,0xbdb40001,0xf1b9013a,0x5454112e}},	//   _tườn, рбиј, _piše_, авит
  { {0x136a0014,0xd5b1001a,0x89db0009,0x86070012}},	//   ншни_, _rút_, _נחמי, دقيق_
  { {0xf1b9001c,0xe0d7004c,0xaa74004c,0xf6260024}},	//   _više_, _сву_, агољ, _бджо
  { {0xb3450017,0x69c40052,0x41b50012,0x8cd40011}},	//   _seçã, _blie, لمدر, _बेरो
  { {0x645b01e4,0x6d46112f,0xf2d30009,0xd915003c}},	//   brui, _neka, מעת_, идны
  { {0x7c26007a,0xf3f9000d,0x201e0010,0xa91d0010}},	//   _nukr, suţa_, _kiti_, _paži
  { {0xa3e8015f,0xdb18000e,0x69d90034,0xc7c70048}},	//   _यदि_, _elvá, ziwe, усми
  { {0x8f9b000b,0x69c40e22,0x7bda1130,0xba730012}},	//   עילי, _flie, mitu, _هايت
  { {0x7bda00b9,0x44260010,0x69c40778,0x49bb0012}},	//   litu, _kuo_, _glie, _ساعد_
  { {0x41c40003,0x24580015,0x44260010,0x03d500b3}},	// [21f0] _دقيق, лать_, _juo_, ажаю
  { {0xf1bf0066,0x36d50015,0x201e013a,0x661d0227}},	//   lká_, _воор, _niti_, _wisk
  { {0x44260006,0x644d1131,0x99350003,0x7bda0051}},	//   _luo_, ssai, لفات, iitu
  { {0x3ebe0722,0x6b81059b,0xa1190012,0x89370012}},	//   øtte_, zelg, نقاط_, اعضا
  { {0x4426007a,0x201e0082,0x7bda1132,0x80db0011}},	//   _nuo_, _biti_, kitu, _पेमे
  { {0x7bd50052,0x201e1133,0x62980c57,0x65b501bd}},	//   _umzu, _citi_, _orvo, _náhr
  { {0x74d90037,0xdb050028,0x7de1001e,0x6b811134}},	//   _नेतृ, rkhó, lēsi, velg
  { {0xf2d2000b,0x201e0010,0x4426002c,0x370a0011}},	//   _ועל_, _eiti_, _buo_, ाधड़ी_
  { {0x62980006,0x05a60015,0x7bda1135,0xbf670012}},	//   _arvo, рвый_, fitu, _مداو
  { {0x61e90119,0xe2990001,0xf7730003,0x7bda002b}},	//   _hjel, вао_, _دار_, gitu
  { {0x11d60012,0x8bd60009,0x179a0009,0xd7c80012}},	//   لتحد, שותו_, _שיעב, _حوله_
  { {0x11d60024,0x3f910035,0x6b8107a2,0x6e3a00af}},	//   ріор, edzu_, selg, _יתעד
  { {0x629800bd,0x69c40070,0x91f6000b,0xdb1a004a}},	//   _ervo, _vlie, שמרו_, ehtä
  { {0x6d460acb,0x25ad0051,0xd5eb001a,0x7d06003a}},	//   _seka, ljel_, _đíc, ükse
  { {0x61fb1136,0x6d461137,0x8f880009,0xe6b20011}},	//   _okul, _peka, נְשֵ, ीनेज
  { {0xceb20093,0x96630014,0xf1bf0107,0x67170037}},	//   חיל_, юксе, cká_, धेयक_
  { {0x9f5e004a,0xf9fb0009,0x74160012,0xcce50012}},	// [2200] _yhtä_, _בהקמ, لورا, مسكي
  { {0x91fd00cd,0xe29a00dc,0x909b0009,0x1d1904a5}},	//   grāf, каз_, _יספק, уюсь_
  { {0xa9260015,0x6d46047b,0xaf5b0009,0x2f5b0009}},	//   адел, _teka, _בכיכ, _בדינ
  { {0xc05a002d,0x61e90027,0x201e1138,0x70560012}},	//   вік_, _cjel, _siti_, لنصا
  { {0x61e90027,0x61e60010,0xdb070066,0x6d3b000b}},	//   _djel, inkl, _vojá, _בתכנ
  { {0x91fd0039,0xdfcf0003,0xf1bf05b1,0x3ce01139}},	//   ntār, وين_, zká_, _živo_
  { {0x442601a2,0x6442003e,0x4b7b0093,0x7bda113a}},	//   _suo_, _swoi, _שאלו, vitu
  { {0x61e90119,0xafdb0119,0x420a0024,0x6e970048}},	//   _gjel, nsør, _рнбо_, рвър_
  { {0x2d8f00c5,0xbc670003,0x6c830012,0x98bd0034}},	//   _dage_, لمين_, قليم, tawą_
  { {0xa5070001,0xa91d0010,0x61e6113b,0x6298113c}},	//   шења_, _pažv, enkl, _prvo
  { {0x3f830010,0x7de1001e,0xa91d001e,0x8ae6002d}},	//   veju_, zēsi, _dažu, ріпл
  { {0x6442003e,0x4426113d,0x76bb0009,0xdebb0009}},	//   _twoi, _tuo_, _שמאפ, _שמאל
  { {0xdb0e003a,0x6e2801bd,0xedd30012,0x80b30011}},	//   _albü, _hudb, _بيند, ुनें
  { {0xdcfb00a2,0x2d84039f,0xc7c40015,0xf1bf0145}},	//   lduğ, leme_, осси, ská_
  { {0xba540012,0x69dd113e,0x55590048,0x3f83113f}},	//   _انبع, éres, лавя_, reju_
  { {0xdcfb00a2,0x59d40003,0xf99f0054,0xcb090024}},	//   nduğ, _وغير, rmès_, _схід_
  { {0x69dd1140,0x91fd001e,0x4c940015,0x26e20011}},	// [2210] mise, stās, оитс, गपुर_
  { {0x7de10039,0x61e90428,0x78fc0009,0x3949005e}},	//   rēsi, _sjel, _בפחו, _heas_
  { {0xe695000a,0x6e95000a,0x600d0065,0x20030604}},	//   _الجد, _الجا, núme, mlji_
  { {0x62860002,0x2d841141,0x7de10035,0x7e63008e}},	//   łkow, jeme_, pēsi, vunp
  { {0x9f510066,0x60f80024,0xe4a7004c,0x2d841142}},	//   hozí_, анця_, _трно, deme_
  { {0x69dd0005,0x7dde001e,0x70520012,0x8a370012}},	//   hise, zīst, أنوا, _نعرض
  { {0x320d0036,0x4e950003,0x91fd001e,0x2d8f1143}},	//   _they_, إشتر, orād, _page_
  { {0x59f90015,0x39400028,0x77bd0054,0x63b5000e}},	//   _себя_, ðist_, _mèxi, _hozn
  { {0x69dd0005,0x26c10026,0x7bc70331,0x04560003}},	//   dise, šho_, _klju, ملية_
  { {0x78bd0006,0xb8dd0037,0x6e280027,0xd6db0048}},	//   dysv, ुई_, _fudb, _ите_
  { {0x69dd0119,0x7dde001e,0x2d8f1144,0x3dc61145}},	//   fise, tīst, _tage_, _flow_
  { {0xc9760003,0x3949000d,0x2d8401bd,0xd378001b}},	//   حادث, _ceas_, ceme_, viće_
  { {0x34ab0003,0x27f802c7,0xa9fa0009,0x31fa0009}},	//   _جداً_, torn_, רִית, רִיע
  { {0x6d4b0028,0x7c3b1146,0xd378001b,0x91fd0035}},	//   ðgan, mpur, tiće_, erād
  { {0xada6035b,0xed5a048c,0x96060012,0xfa350012}},	//   бавл, лов_, مبرم, _ارتد
  { {0xd5b10020,0x65690480,0x249f001b,0x1d26004c}},	//   ếp_, ngeh, _šuma_, смам
  { {0x998d0002,0x69d80061,0x61f90002,0x7bc1001e}},	// [2220] _wieś_, èvem, dowl, oklu
  { {0x7f860003,0x91fd001e,0x7dda0066,0x65bc0061}},	//   _الدن, arād, půso, _véhi
  { {0x79860070,0xdceb001e,0xce95001e,0xdcfb003a}},	//   oekw, _angļ, šējā_, yduğ
  { {0x7bc7000e,0xdb1c006f,0x65690070,0xdd9f0064}},	//   _elju, _omrö, jgeh, áňte_
  { {0xdfda0014,0x28d20321,0xc9530009,0xa8770012}},	//   лък_, _देखि, למא_, محور_
  { {0xdfd0000a,0x824a0003,0x3dc6002a,0x660408a0}},	//   بيت_, _مشرف_, _slow_, llik
  { {0x8f9b000b,0x65690052,0x69dd004a,0x29d20035}},	//   טיסי, fgeh, yise, nšas_
  { {0x63b50026,0x69cb0052,0x66041147,0x629c1148}},	//   _zozn, chge, nlik, _irro
  { {0xdcfb003a,0xc34a0d25,0x91bb0009,0x3949005e}},	//   rduğ, ляне_, _עממי, _reas_
  { {0xdee60046,0x2d840051,0x6604003a,0x91fd001e}},	//   _лози, seme_, hlik, zrād
  { {0xd5af085b,0x2904003a,0x5f370009,0x4b7b0009}},	//   _ес_, üman_, _הטבע_, נאטו
  { {0x31c70015,0x59f90015,0x9c830010,0x78bd004a}},	//   ссов, ремя_, ščiu, tysv
  { {0x66040118,0x600d01e3,0xf5060024,0x7bde1149}},	//   dlik, súme, _уздо, kipu
  { {0x7bc1008b,0xcc57000b,0x6ee70003,0x69dd114a}},	//   cklu, _פסוק_, مسأل, sise
  { {0x7de5007a,0x98a500a2,0x91fd001e,0x6377000b}},	//   lėsi, ğlı_, trād, _הגוף_
  { {0xaae50003,0x98a5003a,0x7bcb001e,0x6604114b}},	//   _بسهو, şlı_, īgum, glik
  { {0x5455007c,0xb4b50037,0x7bcb001e,0x73d9004c}},	// [2230] юват, ड़ने_, ūgum, адар_
  { {0x2bbb0003,0xe4d40003,0x3b550024,0xbed9003c}},	//   دارة_, ستقب, ікер, _вдох_
  { {0xc3330093,0x7bc70159,0x6d4d020d,0x69c00031}},	//   פוף_, _vlju, paaa, ömeg
  { {0xdb030026,0x7de50010,0x90990593,0x225c05b1}},	//   _ponú, kėsi, ивет_, ávka_
  { {0xa01b000e,0x628e114c,0xf8650024,0xfd960009}},	//   dvöz, _esbo, івко, _ודרך_
  { {0x44390036,0x7de50010,0x98480015,0x4fe8002d}},	//   _its_, dėsi, сяца_, бмін_
  { {0x5fbc0093,0x65690480,0x2fd60012,0x7ff40012}},	//   רצונ, tgeh, توود_, أسنا
  { {0x442300bd,0xe4590751,0x95990024,0x59c50012}},	//   _hij_, ажи_, ртку_, _بيرك
  { {0x65690052,0xa3b00011,0x6e22114d,0x7de50073}},	//   rgeh, टॉक_, _diob, gėsi
  { {0xd7fb106a,0xa3d30037,0x69dd0061,0x65690052}},	//   _суб_, सों_, èren, sgeh
  { {0x656f00c1,0x44230070,0x6616004a,0xc9aa0ec6}},	//   _occh, _mij_, ymyk, авне_
  { {0xb1da002d,0x7de50010,0x216a01d4,0x7c3b114e}},	//   рьох_, bėsi, шими_, ppur
  { {0xd00a0083,0x23b50012,0x98bd0034,0x6d4b0035}},	//   иеме_, _ومؤس, tawę_, _iega
  { {0x61b60044,0x657d00b6,0xd9b60037,0x69c90070}},	//   _अक्ष, _absh, _अक्ट, _llee
  { {0x6d4b00b6,0x98bd0002,0x3f8709d4,0x6604114f}},	//   _kega, rawę_, ienu_, tlik
  { {0xa3d70044,0x61ed0065,0xe5a3029b,0xc692000b}},	//   ़ोस_, _gjal, миси, ואל_
  { {0x442301e4,0xfc1a0003,0x6d4b1150,0x66041151}},	// [2240] _bij_, لقرب_, _mega, rlik
  { {0x66040005,0x3f870027,0xe73a0001,0x833a052c}},	//   slik, jenu_, _њен_, рчат_
  { {0xdcff001e,0xe29701b6,0x69c90644,0x44391152}},	//   īvāk, жах_, _blee, _ets_
  { {0xf653000b,0x60000052,0xf8bf01a0,0xd1300012}},	//   _קצר_, römu, ccés_, رمت_
  { {0x91fd001e,0x10470014,0x8b660003,0xe7c50011}},	//   duāl, оящи_, _واسم, वसंप
  { {0xc059007c,0x7de1001e,0x44230070,0x6d4b0051}},	//   сії_, zēst, _gij_, _aega
  { {0x60040054,0x69c90802,0x6d4b1153,0xe6660024}},	//   nòmi, _flee, _bega, ітко
  { {0x442300bd,0x5d540014,0xbdf70012,0xd378001b}},	//   _zij_, чкит, يريا_, dića_
  { {0xab5c001e,0x4f5a0003,0xd12f0012,0x7de10035}},	//   ekļa, _نجاد_, _شمل_, vēst
  { {0x7de50010,0x61ed0028,0x547b0009,0x9f580025}},	//   rėsi, _sjal, סטיו, boré_
  { {0xc333000b,0xc7b3000b,0xba0b0014,0x69c9004a}},	//   וות_, _קבע_, ихме_, _ylee
  { {0x7c230052,0xc2b70024,0xbca60012,0x645d0073}},	//   _einr, іляє_, _وماي, šsia
  { {0xc953000b,0x80db0037,0xa50700f5,0x05b30012}},	//   ומר_, _पेशे, _деца_, _تمنح
  { {0x29050039,0x6d4b0002,0xcf270012,0xa2e60012}},	//   āla_, _zega, ترحي, _وأثن
  { {0xcddb1154,0x163b000a,0x7c2b008b,0x454b0014}},	//   ања_, ؤسسة_, _zugr, ичам_
  { {0xa4d5002d,0xca830003,0x442b0054,0xd1310012}},	//   побі, _آليً, _puc_, _ثمة_
  { {0xf8bf0025,0x69c0005e,0x6b880227,0x91bc0009}},	// [2250] rcés_, ömee, oedg, _כמהי
  { {0x29150002,0x69c91155,0xc43b0009,0xaac70012}},	//   ądać_, _slee, יתמי, يتان
  { {0x8ae7007c,0xaa950003,0x0af90003,0x3f871156}},	//   ціал, ثلاث, حفاظ_, venu_
  { {0x44230070,0xd1b80003,0xe2900003,0xd8750012}},	//   _wij_, يانا_, خذك_, كاتب
  { {0x8fa5002d,0x3f870061,0xc0c80001,0x76550002}},	//   зале, tenu_, жује_, lszy
  { {0x94ba0093,0x9f580026,0x9f470061,0x6d4b1157}},	//   _המשת, toré_, onné_, _sega
  { {0xed590047,0x7c2b0010,0x91fd001e,0x92580e0f}},	//   бой_, _sugr, tuāl, _март_
  { {0x656d1158,0xd3780027,0x8d750003,0x61fd001e}},	//   ngah, vića_, سابا, josl
  { {0x478b0015,0x20540015,0x6d4b1159,0x61fd115a}},	//   _всем_, _октя, _vega, dosl
  { {0x4439001e,0xcb690001,0xd378001b,0x0bb60009}},	//   īs_, љане_, tića_, ִ֜ים_
  { {0xc869000b,0x44390113,0x76550002,0x9f4e0066}},	//   _תן_, ūs_, jszy, áním_
  { {0xf1b9001c,0x224700f1,0x76550034,0x61eb0032}},	//   _još_, ánky_, dszy, nngl
  { {0x394d0051,0x29040028,0xa3ae0011,0xf8bd0011}},	//   _mees_, æma_, काम_, ्निय
  { {0x78a60065,0x4c9a000b,0x394d0070,0xe8d6000b}},	//   _ákve, _לבנו, _lees_, לורר_
  { {0x60120028,0x443f115b,0xb7bd004b,0x9f58004b}},	//   væmd, lpu_, _cuţi, borî_
  { {0x09fa0003,0x82d6000b,0xc8bd0037,0x52d6000b}},	//   _دفعة_, _מוצג_, ्नाट, _מוצע_
  { {0xdd8f000a,0x2ea80037,0x76550002,0xe5060012}},	// [2260] دوق_, _कप्त, aszy, سبري
  { {0xdb030108,0x909b000b,0x1877000b,0x317f000d}},	//   _anné, _פסיק, _צעיר_, _abuz_
  { {0x67bb0093,0xd36f0003,0x91e60001,0xf1b9009b}},	//   _המיק, اهم_, поже, _boš_
  { {0x69c60137,0x6fcb003a,0xa96a07b9,0xf9920012}},	//   nkke, _tücc, сида_, عبا_
  { {0x6d44115c,0x859b0009,0xb0330024,0xc7b80024}},	//   mbia, _השכו, еніш, оґа_
  { {0x6d440010,0xdb03000e,0x3f98115d,0xa8570009}},	//   lbia, _enné, ndru_, לינה_
  { {0x3a24007d,0x63b8022d,0x6146115e,0x32060132}},	//   _timp_, _rovn, _нева, ploy_
  { {0x6fcb003a,0xda5b0009,0x99500064,0x86c30012}},	//   _müca, _לכלל, lúži_, عيين
  { {0x69dd0061,0xc3340009,0x4df10011,0x71730012}},	//   èrem, ֽוֹ_, ँकड़े_, _سهلا
  { {0x883b000b,0x7de50010,0xfbaa00fa,0x88570009}},	//   _לתמו, lėst, стий_, _משמע_
  { {0x7f3b000b,0x443f029f,0x11d90012,0x28cf0011}},	//   _העבו, apu_, قودة_, सैनि
  { {0x7c3a0030,0x61e2115f,0x3f980764,0x394d01e3}},	//   _čtrn, niol, edru_, úes_
  { {0x76550002,0x859b0009,0x1da90011,0x77bd01a0}},	//   wszy, _לשאו, कारत, _tèxt
  { {0xb7bd007d,0xfbcf0003,0xcce50003,0x8c180012}},	//   _puţi, _متى_, _تسمي, _بيتر_
  { {0xdb7b0093,0x4b7b007e,0x6b950416,0x64400070}},	//   _הנוכ, _האוו, _razg, lpmi
  { {0x76550002,0x69c60052,0x644a0034,0x9f470064}},	//   rszy, ckke, ćfin, rnné_
  { {0x99f8000b,0x39780003,0x7de50010,0x57f502ca}},	// [2270] _מזהה_, _رصيد_, dėst, _опит
  { {0xbca4000a,0xa3d70037,0x76550002,0x394d1160}},	//   عملي, ़ों_, pszy, _sees_
  { {0x6602000e,0x6b95003a,0x6d441161,0x9f7a0009}},	//   _okok, _vazg, bbia, _ונתח
  { {0x68e20010,0x27e30070,0x9f5c01a0,0xe6640024}},	//   _žodi, lijn_, lovè_, _ятьо
  { {0x759a0009,0x31580009,0x859a0009,0x394d005e}},	//   _וסרג, ליאן_, _ושרו, _vees_
  { {0x4639003c,0x394d0227,0x8b070030,0x10a20024}},	//   очия_, _wees_, _jiří, тишн
  { {0xc3320093,0x6d4f00b6,0x9f5e0025,0x1da90011}},	//   _יום_, _keca, ôté_, कालत
  { {0xf19404b3,0x248d0002,0x7c271162,0x6e380031}},	//   _пись, twem_, _hijr, _évbe
  { {0x6f090030,0x6d4f1163,0x657b0032,0x572700ae}},	//   řech, _meca, rfuh, _فراق
  { {0x0ae90015,0x69cd0051,0x3e57004b,0x999f0073}},	//   ждой_, _alae, păt_, kstų_
  { {0x7c2f1164,0x198a00f5,0xd7580012,0x53360009}},	//   _lucr, обни_, _رجلا_, ונתן_
  { {0x65150003,0x71da002d,0x88e600b3,0x96fa0009}},	//   _قوائ, ієнт_, джме, _ולעת
  { {0x69c60006,0xc1560009,0x66090060,0x999f0073}},	//   rkke, ושרו_, mlek, estų_
  { {0x02450012,0x66091165,0x8b030030,0x61e21166}},	//   _قَتَ, llek, ářsk, ziol
  { {0x6d4f0036,0xe80e0011,0x99d60012,0x44271167}},	//   _beca, ितता_, _يتبا, _iin_
  { {0xc9f6000a,0x7e610065,0x661b004a,0x44271168}},	//   _تستع, álpa, nmuk, _hin_
  { {0x1d070001,0x6d441169,0xe5e50012,0x4376003c}},	// [2280] дети_, rbia, رثفي, дует
  { {0xabaa0003,0x7d060010,0x836a0012,0x4cc80009}},	//   غهام_, _vyks, تصرف_, הֶעֱ
  { {0x6eb50044,0x7549000e,0x7d060002,0x6456004a}},	//   _उपयु, észü, _wyks, ssyi
  { {0x6d4f0480,0xc8ca0012,0xfe9b0009,0x9f5c01bd}},	//   _geca, يوان_, _ויטמ, mové_
  { {0x9f5c014a,0x645d0042,0x91fd0035,0xa3cd0011}},	//   lové_, ásil, krān, रसा_
  { {0x442700a2,0x6602116a,0x661b016d,0x945d0034}},	//   _nin_, _skok, emuk, zyńc
  { {0xd6d0000a,0x6e93002d,0x34b80037,0xc246002d}},	//   طقة_, вищу, ेन्द, _інак
  { {0xd5b0000a,0x27e30227,0x68f6116b,0x4427116c}},	//   افة_, zijn_, _oxyd, _ain_
  { {0x9f5c00d9,0xbdf70012,0x1b4a0012,0xc5f70012}},	//   hové_, بروا_, يؤدي_, بعوض_
  { {0xdfa6000a,0x3946007a,0xa3d80037,0xe8d7000b}},	//   _تحري, lbos_, ठों_, _חומר_
  { {0xbcfb116d,0x2fd70012,0x9f5c0042,0x63bc116e}},	//   _idée, _تولد_, jové_, _morn
  { {0x4427116f,0x7dc30051,0xf6690003,0xb257000b}},	//   _ein_, _tõsi, _رحمه_, ובטח_
  { {0x27e30070,0x44271170,0xeb9a003c,0xa0c50012}},	//   tijn_, _fin_, _мид_, ريسو
  { {0x6d4f00c6,0x73c40012,0x9f5c0030,0x91fd0035}},	//   _seca, _سيعم, fové_, ntāz
  { {0x442f0052,0x12b30012,0xabfb0009,0xd5bb03e2}},	//   _zug_, _لإيج, _והגר, оса_
  { {0xdb18014a,0x8e970009,0x44271171,0x999f0073}},	//   _nové, ודלו_, _zin_, rstų_
  { {0x84150014,0x6d4f001e,0x42180012,0x27e30227}},	// [2290] емах, _veca, _تزوج_, pijn_
  { {0x44271172,0x2fc70020,0xcc77000b,0x60c01173}},	//   _xin_, _ông_, וגמת_, ämme
  { {0xddc3000d,0x2a6c009b,0x9f5c08ca,0x6d4f06a7}},	//   nunţ, nudb_, cové_, _teca
  { {0x28c60044,0xeab00012,0x471a0009,0x6d5d0040}},	//   रैकि, جعك_, _מותג, _udsa
  { {0xdd3a0093,0xf1b40009,0x52ca0011,0xb53a0009}},	//   _מערכ, כסף_, ानुस, _מגרש
  { {0xa6950046,0xdfd10003,0x63bc0864,0xe73900bb}},	//   ериј, طيع_, _gorn, чек_
  { {0x44271174,0x6b68000e,0xed590015,0x77360012}},	//   _rin_, ségü, пой_, ركيز_
  { {0x9f580029,0x44271175,0xa87b0012,0xbbb90011}},	//   vorí_, _sin_, _وحذر_, ेस्क
  { {0x6609006f,0x661b00b6,0x0efc0011,0x9f5c00d9}},	//   rlek, rmuk, _एड्स_, zové_
  { {0xe3b1000a,0x78a60028,0x02ca0037,0x9f580029}},	//   ارة_, _ákva, ानून, torí_
  { {0x8c1c0009,0x1309003c,0xdb1a0032,0x63b80248}},	//   חוזי, яной_, chtü, övni
  { {0x7e9a0093,0x44271176,0x7643020d,0x9f5c06dd}},	//   _מסעו, _win_, mpny, vové_
  { {0x44271177,0xdb030002,0x2ec80011,0xa3c40011}},	//   _tin_, _ponó, रन्त, ौसम_
  { {0x4cba0093,0xa5bb000f,0x9f5c0042,0x44271074}},	//   _מזנו, _fiók, tové_, _uin_
  { {0xb9070044,0xa3ae0037,0x39460010,0x2d991178}},	//   _ये_, कास_, ybos_, _base_
  { {0xceb2000b,0xdb1c0061,0x9f5c0042,0x2d990936}},	//   נין_, _forê, rové_, _case_
  { {0x91690020,0x62870039,0x7de80066,0x9f5c0042}},	// [22a0] _gửi_, _apjo, měst, sové_
  { {0x61e6003a,0x395f000d,0x2d990132,0xa87b0009}},	//   likl, _adus_, _ease_, _צריח
  { {0x599a000b,0x160f0037,0x63bc0052,0xa99a000b}},	//   ּשְׁ, ातार_, _vorn, ּבְר
  { {0x78a41179,0x2d990032,0x249f0097,0x61e6117a}},	//   _kriv, _gase_, kvum_, nikl
  { {0xa927007c,0xb3460017,0xe89400be,0x61e60051}},	//   ніше_, niçõ, таль, iikl
  { {0x6d56117b,0x80a30012,0x2d99117c,0x6444117d}},	//   laya, امون, _zase_, mpii
  { {0x8e2600de,0x61e60b02,0xaade0011,0x628b0034}},	//   нфид, kikl, _फेंक, łgor
  { {0xceb30093,0x3f9a0039,0xa3ae0037,0x39490028}},	//   ריה_, _lapu_, काव_, ðast_
  { {0x61e6117e,0x6444008e,0x53e60842,0x31570009}},	//   dikl, npii, ецна, _רימן_
  { {0x3c77000b,0x3a2900b6,0xb3460017,0x6d560a60}},	//   עתים_, _siap_, diçõ, haya
  { {0xd257002d,0x6d560160,0x61e603ad,0xe1d50024}},	//   нця_, kaya, fikl, вжнь
  { {0xab64003a,0xa1940024,0x7df3004b,0x60120097}},	//   ldüğ, гаюч, păsa, væma
  { {0xdd8f000a,0x7dca00f1,0x6d5602a0,0x8c43004c}},	//   _دون_, _výsl, daya, _бече
  { {0xb4be0037,0x2ca0006f,0x20050029,0x7aeb000e}},	//   ीनी_, dvid_, ôli_, áltá
  { {0xdb9b000b,0x3a2900b6,0xdb15117f,0x78a400ff}},	//   _מסגר, _tiap_, _pozí, _eriv
  { {0x32530098,0x6d560101,0x3ebe00e5,0x49740048}},	//   _свър, gaya, ätta_, _блъс
  { {0x24f80015,0x51fc0009,0x2d991180,0xa4d40024}},	// [22b0] енты_, _מההצ, _vase_, готі
  { {0x1cb80012,0x799d07c2,0x000000c4,0x000000c4}},	//   راقب_, ldsw,   ,
  { {0x6d560160,0x20030010,0x2d991181,0x07360009}},	//   baya, moji_, _tase_, _באתם_
  { {0x2003003a,0x7dde09d4,0x66ee0031,0x645d0031}},	//   loji_, būsi, sőké, ásik
  { {0xe72e0014,0x7dda0066,0xa3ae0037,0x71d80009}},	//   ие_, růst, काश_, עודד_
  { {0xdee50046,0xa01b0028,0xf838000b,0x660d1182}},	//   коли, stöf, ענות_, llak
  { {0xa3ae0044,0x17980009,0x34c90011,0x60c60064}},	//   कार_, גדול_, िन्द, zykm
  { {0x4c850015,0xb4be0011,0xcee80012,0xc485052c}},	//   влив, ीनू_, عرون_, влик
  { {0x91a9001a,0x660d02a0,0x61e61183,0xc8e00011}},	//   _giả_, ilak, vikl, _पेंट
  { {0xf7700003,0x20030010,0xe4c80012,0xd7590012}},	//   _هام_, joji_, عبين_, _آلات_
  { {0x6d560101,0xc64b0003,0x27e709d8,0xeb920009}},	//   yaya, _رجال_, minn_, בָר_
  { {0x27e71184,0x60160017,0x5ee80009,0xb3460018}},	//   linn_, râme, _אַנְ, tiçõ
  { {0xc952000b,0x6d491185,0x320200d9,0x69cb0227}},	//   סמך_, mbea, roky_, ikge
  { {0xb3460017,0x2003009b,0x290c001e,0xa856000b}},	//   riçõ, goji_, āda_, כישה_
  { {0x52b20003,0xb3460017,0x07a30001,0x26c70010}},	//   _نموذ, siçõ, јасн, nyno_
  { {0x660d002c,0x799b0070,0xac9a0012,0x69cb0227}},	//   glak, _nauw, ونزا_, jkge
  { {0xa3ae0037,0x27e70028,0x91fd001e,0x645b0025}},	// [22c0] काल_, kinn_, krāj, nsui
  { {0xa3dc0044,0x201a000a,0x7c2a0054,0xfaa60109}},	//   तों_, _تتبع_, _xifr, казо
  { {0x6d560175,0x660d000e,0x799b0052,0x64440269}},	//   paya, blak, _bauw, spii
  { {0xd5af002d,0x442a00b6,0x7aba0009,0x645b019a}},	//   _всi_, _wib_, וצעו, ksui
  { {0x27e70028,0xf7720003,0x76410073,0x629e0030}},	//   finn_, لاغ_, _atly, _ápov
  { {0x14d7000b,0x27e710c7,0xda660012,0xe123004c}},	//   _יוכל_, ginn_, _لاري, јмљи
  { {0x7dc30051,0xab64003a,0x539b000b,0x6566000e}},	//   _tõst, rdüğ, _קילו, ókho
  { {0x6b9c00c6,0x69cb008b,0x6604004a,0x2bca0037}},	//   _harg, ckge, noik, िस्थ
  { {0xb4cc0044,0xb4be0044,0xdb0a0061,0x60120097}},	//   रने_, ीने_, _infé, væmn
  { {0x67450013,0x799b0002,0x43940001,0xc3320009}},	//   čují, _zauw, ћанс, יו֙_
  { {0xa3e30037,0x6b9c1186,0x5d860012,0xe7f60011}},	//   _नगर_, _marg, _للال, ँचना_
  { {0xdb1c10b7,0x799d0227,0x245d0030,0x9e770009}},	//   _coré, udsw, námý_, _יגבה_
  { {0xf9930009,0xc8670048,0x20031187,0x50670048}},	//   ברר_, ътни, toji_, ътна
  { {0x5ba30098,0x9f580029,0xa3e10011,0x3f850064}},	//   _връз, torá_, नोद_, ýlu_
  { {0x660d000f,0x9e07007c,0x27ed001c,0x6d5d0097}},	//   tlak, вчал, đen_, ðsag
  { {0xa2630020,0x27ed000e,0x59670014,0x95c50012}},	//   _muố, ően_, _ръка, ديره
  { {0x660d00c6,0x08fb0003,0x24580015,0x9d1500de}},	// [22d0] rlak, _ترغب_, кать_, удач
  { {0x9cd7000b,0x6b9c1188,0x6fb50012,0x92eb0012}},	//   דומה_, _carg, _إمدا, وراق_
  { {0x6b9c0778,0x69c00227,0x6fcb0032,0x65620064}},	//   _darg, _bome, _lück, _odoh
  { {0xa1150003,0xa3d70011,0xcad70009,0x27e70032}},	//   هوات, ़ोज_, כובת_, winn_
  { {0x27e70065,0x6b9c0119,0xa3c30037,0x30850012}},	//   tinn_, _farg, _एकल_, التف
  { {0x628a0058,0xe8160011,0xd7f8004c,0x828b0024}},	//   _opfo, णतया_, куј_, _осбб_
  { {0x27e70065,0x2eb40014,0xa263001a,0x645b0132}},	//   rinn_, исъс, _cuố, wsui
  { {0xf1a40001,0x3f910052,0xd2290012,0xf1b9001b}},	//   _крун, hezu_, _أكره_, _pišu_
  { {0x27e70028,0xad9b0029,0x6b9c003a,0xc7f9002d}},	//   pinn_, _akúk, _yarg, _знає_
  { {0xd9cc0037,0xb8f70037,0x60c4004a,0x69c00070}},	//   ास्ट, ान_, äime, _zome
  { {0xdb1c0017,0x39ea0146,0x8bd6000b,0x645b0017}},	//   _poré, едно_, רותו_, ssui
  { {0x6627000a,0xcb120093,0xa06a0001,0x186a00be}},	//   _شراك, מלי_, нама_, нами_
  { {0xa91d007a,0x89da0009,0x8d5a0009,0x6fcb0032}},	//   _pažy, תחרי, _נכסי, _küch
  { {0x3a2d0227,0x5a951086,0xed59001b,0xdee60545}},	//   _liep_, _бриф, laž_, гоги
  { {0xa2630020,0xf7430014,0xcb56000b,0x7dca0028}},	//   _xuố, сесо, _עסקה_, _hýsi
  { {0x29560014,0xa01b000e,0x63b50010,0x2d9f1189}},	//   _съкр, gtöb, šanč, ndue_
  { {0x6da30014,0xb8860066,0xd4670136,0x5baa01c6}},	// [22e0] щита, _kníž, лите_, нкам_
  { {0xa01b004a,0xc053000b,0x6604004a,0x69c0118a}},	//   ttöe, _הזז_, soik, _some
  { {0xc3320093,0x7dca0028,0x69c00a16,0x63bc118b}},	//   צוא_, _lýsi, _pome, örni
  { {0x6b9c00c6,0x7229002d,0x7db60003,0x1da30011}},	//   _warg, вців_, _إصدا, _खोलत
  { {0x2d9200a2,0xd7e6002d,0x6fcb0052,0x17540fbb}},	//   meye_, ліко, _büch, авля
  { {0x6fcb008b,0xccab000b,0x69c0002a,0xc059002d}},	//   _rück, _אֱלֹ, _wome, тії_
  { {0xa263001a,0x96f80015,0x25a00051,0xb765002d}},	//   _quố, ъект_, odil_, ртій
  { {0x7a8b000b,0x25a00051,0x1d340014,0xd5b3000b}},	//   _אָמַ, ndil_, шния, ֶׁת_
  { {0x2480118c,0xf746118d,0xa3ae0011,0x9876004c}},	//   ntim_, _безо, काऊ_, _љубљ
  { {0x54330003,0xe47b000b,0x66da003c,0x14d70009}},	//   حرير, עריכ, _пьер_, טופל_
  { {0x0bb7000b,0x2d92003a,0x3f910027,0x7ac605fb}},	//   אלים_, keye_, vezu_, успе
  { {0x2e160003,0x7dde001e,0x4a5b0009,0xc2b70024}},	//   _صباح, gūst, עדכו, улює_
  { {0xc0ab0012,0x506401c6,0x2d92118e,0x3f91001b}},	//   راحل_, йтра, deye_, tezu_
  { {0x7d060051,0x749b0009,0xed590073,0xddc70159}},	//   üksu, _ניופ, _žž_, dujš
  { {0xa6f8000b,0x3f910027,0x62980027,0xa3ae0011}},	//   דִּי, rezu_, _usvo, काई_
  { {0x4a7b000b,0xb8860029,0xf9930012,0x6dc4003c}},	//   _נרחב, _zníž, _طبع_, бсуж
  { {0xdb6b002d,0x8c250012,0xcb55004c,0x3a2d0227}},	// [22f0] ерел_, لفره, иваћ, _riep_
  { {0x25a0118f,0xcb680a36,0x000000c4,0x000000c4}},	//   adil_, лађе_,   ,
  { {0x17f80003,0x82a70015,0x7f3a0009,0x24801190}},	//   _حرية_, ышае, _בעתו, atim_
  { {0x9f470061,0xe45f0028,0x69cf0030,0xe1ee0024}},	//   miné_, _tvö_, nkce, іг_
  { {0x3f9e00b6,0x24800132,0xbcfb0025,0x25f40011}},	//   _batu_, ctim_, _idéo, ्करी_
  { {0xf7710003,0xdcfd001e,0xa858000b,0x6d4d0227}},	//   زات_, _lasī, ריגה_, lbaa
  { {0x45d50098,0x3f9e1191,0xd7580012,0xf6960012}},	//   ицит, _datu_, اجها_, لنوع_
  { {0xb8860066,0x6d4d0070,0x05a90021,0x2d94003c}},	//   _sníž, nbaa, твий_, брьс
  { {0x61eb00c1,0x9c89002d,0x851f0037,0xed5909ef}},	//   migl, ерiа, मेंट_, raž_
  { {0x98170003,0xa2f50009,0x3d1d0011,0x5f740012}},	//   _إبرا, ֹמֹה_, _मरने_, _هامر
  { {0x6d4d00bd,0xb6040010,0x6b60000e,0xb9c60012}},	//   kbaa, ūšiu, lágí, لقدي
  { {0x78a90119,0x20071192,0x10a6022a,0xdeba0009}},	//   _krev, loni_, аимн, _במעל
  { {0x20070005,0x21a30015,0x76450028,0x9f5c022d}},	//   ooni_, циям, _athy, lová_
  { {0xfe461193,0x61eb00b8,0x6d5b1194,0x20071195}},	//   инго, higl, laua, noni_
  { {0x2d92003a,0xdd920003,0xed5a048c,0x9f5c00d9}},	//   teye_, يوس_, ков_, nová_
  { {0x7bc30028,0x75d60003,0x38600027,0x12fa0009}},	//   _honu, جيرا, širi_, _בהצב
  { {0xd5b70020,0x61fd000e,0x7bc31196,0x2d92003a}},	// [2300] ớng_, érle, _konu, reye_
  { {0xf7460001,0x9f5c0042,0x27ed0025,0x74130012}},	//   _њено, ková_, éent_, قوقا
  { {0x3f9e1197,0x7f5c1198,0xfc3f01e3,0x20071199}},	//   _ratu_, marq, _frío_, doni_
  { {0x3f9e00c6,0x180e0037,0xdb1a038e,0x2251022d}},	//   _satu_, ित्व_, rktø, ázky_
  { {0x4c67002d,0x2715001a,0x2007119a,0x38600025}},	//   _киян_, _án_, foni_, éir_
  { {0x6f09003a,0xc6fa0009,0xcb6a003c,0x26170025}},	//   şece, ֣לֶך, _шаге_, nçon_
  { {0xd1760015,0xfe770012,0x8c2b0009,0x61eb119b}},	//   _вызы, لصيغ_, _יֵלֵ, bigl
  { {0x69d9008b,0x7e610028,0x69c4119c,0xd29b0009}},	//   chwe, álpi, _noie, _בשלט
  { {0x62810002,0x030b0037,0x05730012,0xdb0a0032}},	//   etlo, _सुबह_, زايد, _wofü
  { {0x66e60339,0x9f5c0042,0xa87b0009,0x8e200024}},	//   _коза, bová_, _באמר, хiв_
  { {0x1fb5005c,0xe7370015,0x442e0025,0x69c4004b}},	//   _устр, _тех_, _vif_, _boie
  { {0x09f90003,0x92570015,0xd378001b,0x69cf0a86}},	//   افحة_, шают_, viću_, ukce
  { {0x90981103,0xa3e70037,0x10740109,0x645d119d}},	//   авят_, _बगल_, оляю, ásit
  { {0x92170011,0xad1b0009,0x628e0227,0xc8840060}},	//   _धीरज_, _סוגר, _opbo, mağı_
  { {0x6d4d0070,0x8c1b000b,0x63bc0028,0xdb23003a}},	//   tbaa, _שווי, örnu, ürün
  { {0xcdd80046,0xaabb0009,0x26170025,0xd6d90034}},	//   ању_, _יזוכ, açon_, ął_
  { {0xdce600a2,0xc884003a,0x61eb00c1,0x7f5c119e}},	// [2310] _bakı, nağı_, vigl, barq
  { {0xd795000a,0x2fe40012,0x92a7004c,0x2b58004b}},	//   _الدخ, _وكيف, ијел, _cerc_
  { {0x644600a2,0x99350012,0x6d4d0227,0x69d9119f}},	//   _etki, مفات, pbaa, thwe
  { {0xf9930003,0x7dd80066,0xd1670048,0x8e960009}},	//   تبط_, _píse, ръжи, _פדרו_
  { {0xcdb6000b,0x9f47004a,0xa98c0009,0x98a50aa2}},	//   _הפרה_, ynnä_, דָוִ, силе
  { {0xec36000b,0x9f5c01bd,0x2ba60011,0xfba60011}},	//   _לאשר_, tová_, _कोला, _कोलम
  { {0xe61f0081,0x24950060,0x6f7a0009,0x6b600031}},	//   _khô_, şamı_, רְנו, ságí
  { {0x7bc300a2,0x44390005,0xa3b50044,0x29f8009b}},	//   _sonu, _kus_, झाव_, nčal_
  { {0xdce600a2,0x443911a0,0xcdb8000b,0x9f8f003a}},	//   _yakı, _jus_, שפחה_, _güç_
  { {0xa3e10044,0x3cff0044,0x69c40061,0xe2990001}},	//   नों_, _रखने_, _soie, гао_
  { {0x11d6000a,0x15f90037,0x9f51000e,0x644911a1}},	//   متحد, ्कार_, hozó_, spei
  { {0x9f51000e,0x44390007,0xf9920012,0xd9f70011}},	//   kozó_, _ous_, أبد_, ंचित_
  { {0xc884003a,0x69c4042f,0xf5360009,0xd46911a2}},	//   cağı_, _voie, _הנני_, _силе_
  { {0x7bda03e4,0x6d5900b6,0x7dca0028,0xa01b004a}},	//   chtu, _hewa, _lýst, ttöa
  { {0x4439032b,0xdb180272,0x1ddb0037,0xf99f0054}},	//   _aus_, _tová, _बतात, glès_
  { {0x4439007a,0xf5b5002d,0x41e50012,0x44310035}},	//   _bus_, осую, _وسيف, _aiz_
  { {0x5b360003,0x443111a3,0x2b58000e,0x6d5900b6}},	// [2320] معار, _biz_, _perc_, _mewa
  { {0x6d5900b6,0x2f560538,0x10bb0009,0x443911a4}},	//   _lewa, _утис, _עזיב, _dus_
  { {0x44310149,0x63060003,0x7dd80028,0x80250012}},	//   _diz_, حوال, _vísb, _بريم
  { {0xda650012,0xc2360009,0x11760012,0x60120097}},	//   زامي, צרנו_, إطاح, dæmi
  { {0x1cba0003,0xdce6003a,0xc7c60104,0x443911a5}},	//   _صاحب_, _takı, йски, _gus_
  { {0x161c0037,0x7dd50028,0xd3ba002d,0x61e911a6}},	//   _भीतर_, _rása, _сумі_, _emel
  { {0x8f9b000b,0xe0df00b8,0x2fc50159,0x91fd0035}},	//   ריצי, zzò_, _dolg_, nsāc
  { {0xceb3000b,0xd6d9002d,0x1af7000b,0xc884003a}},	//   ליו_, шті_, _המלל_, tağı_
  { {0x6d5900b6,0xdb1c0054,0x200a11a7,0x493b0009}},	//   _dewa, _horà, kobi_, _תגמו
  { {0xcf890003,0xfa6a0009,0x7bda005e,0x91fd0035}},	//   _نضمن_, ְכָּ, uhtu, ksāc
  { {0x51f9002d,0x200a009b,0x9f58000e,0x91fd001e}},	//   иною_, dobi_, ború_, krāt
  { {0x6d590347,0x2e370009,0xc27b0009,0x600d0097}},	//   _gewa, _הראש_, נרכי, búms
  { {0xae1b000b,0x91fd0035,0xb87b0064,0x645d0073}},	//   _עודכ, drāt, dzíc, šsir
  { {0xa3a80037,0xe47b0009,0x443911a8,0x3ce00159}},	//   _खोल_, _ערוכ, _rus_, dziv_
  { {0xe246000a,0xd35b0093,0x443911a9,0x8a460003}},	//   _اختي, _גדול, _sus_, _ائتم
  { {0x443100a2,0x8e15002d,0x0615002d,0xca470003}},	//   _siz_, ідац, ідаю, _اليه_
  { {0x91a90020,0x320b0002,0xd1310012,0x71f80012}},	// [2330] _giá_, mocy_, _تمة_, _دروس_
  { {0x61e9014d,0x660900bd,0x6fd00052,0x44d4001a}},	//   _smel, zoek, _näch, ì_
  { {0xfbd00003,0xe5350015,0x2b580034,0x3ce0001b}},	//   رتك_, _мень, órcy_, aziv_
  { {0x443902d1,0x7dd10058,0x60120028,0x3264002d}},	//   _tus_, _måsk, væmi, ятув
  { {0x44390005,0x8934000a,0x229a001e,0x718c000b}},	//   _uus_, أعما, _lūk_, רְבַ
  { {0x61ef11aa,0x644d11ab,0xae990012,0xd6a90012}},	//   hicl, mpai, لضبط_, لدعم_
  { {0x644d004a,0x2fc50070,0x9f580029,0xa01b11ac}},	//   lpai, _volg_, torú_, ytön
  { {0x2d8a000e,0x59f90015,0x307b0003,0x61e911ad}},	//   őben_, _тебя_, _محطة_, _umel
  { {0x44390017,0x644d008e,0x6fd00032,0x7bc7005e}},	//   ês_, npai, _fäch, _koju
  { {0x64980098,0x7ff70003,0x3a20002a,0xdb1c11ae}},	//   стър_, _اسرا, _ship_, _horá
  { {0x44d40020,0xdb1c000e,0x6d5900b6,0xf8a90009}},	//   à_, _korá, _tewa, _שש_
  { {0xee2e002d,0x6fd0006f,0x6285002a,0x8ed80012}},	//   _ін_, _täck, itho, _اذكر_
  { {0x349402e3,0xf74609f8,0x7bf90a32,0xa01b11af}},	//   _нацр, жего, _кндр_, rtön
  { {0x2329059a,0xc2c50012,0x8c420060,0x3a200132}},	//   _коли_, _ويشي, üğme, _whip_
  { {0xa01b0028,0x539a000b,0x443f0061,0xdced001e}},	//   mtöl, _כיסו, lqu_, adaļ
  { {0x7dd5000f,0x69dd008b,0xa01b000f,0x78ad03ee}},	//   _máso, chse, ltöl, _frav
  { {0x7dd80066,0x8e200024,0x44660024,0x2f230025}},	// [2340] _císa, цiй_, ював, tégé_
  { {0xab66002d,0x14170003,0x798d0034,0xe3b703cc}},	//   івел, قيقة_, _zbaw, обу_
  { {0x5fb7000b,0xe29a0014,0x78ad009b,0x2ca90051}},	//   _והיא_, рае_, _zrav, avad_
  { {0x9f990028,0x44d40081,0x6fd00032,0x7ddc0031}},	//   láðu_, ỳ_, _säch, _kése
  { {0x91a00020,0xc0960003,0xa3da0011,0x224d0159}},	//   _chỉ_, تجات, ़सद_, _čeke_
  { {0x3cff0044,0x6fcb003a,0x3f98029f,0x6d4400b8}},	//   _रखते_, _hücr, neru_, lcia
  { {0xcdda004c,0x6e430012,0xfa6711b0,0x6d4411b1}},	//   ињи_, ونوم, _марк_, ocia
  { {0x39420005,0x85480010,0xa01b000e,0x7bc70070}},	//   _üks_, brėž, etöl, _zoju
  { {0x2249009b,0xa01b0097,0xa3c80011,0xad9b0064}},	//   _čaka_, ftöl, ैसल_, _zkús
  { {0x69c20070,0x657b002c,0x3f9811b2,0x63a311b3}},	//   ljoe, aguh, jeru_, _cann
  { {0x8c1b000b,0x61ef11b4,0xdfcf0012,0x8ae30024}},	//   שויי, ticl, _جيل_, діял
  { {0xa01b004a,0x51f8003c,0x78ad11b5,0xc4c600ae}},	//   ttöo, жнюю_, _prav, _وتشو
  { {0x2d87000e,0x7dd50004,0x09070024,0x3f980eb3}},	//   őnek_, _záso, ючом, feru_
  { {0x7ddc0061,0x80270003,0xa3ce0011,0x6d4611b6}},	//   _dése, ترجم, _रवि_, _afka
  { {0xbcfb0017,0x9f34002d,0x33770009,0x63770009}},	//   _idéi, дері, _ותוך_, _וגוף_
  { {0x7dd50145,0x7dd8119d,0xd5b8112d,0x29d70060}},	//   _násl, _písa, осу_, _açan_
  { {0xad9b0026,0x61ed0027,0x04590003,0x71880009}},	// [2350] _skús, _imal, صلاة_, _וְתַ
  { {0xdb1c000e,0xa3e50037,0x57f40015,0x7dd80028}},	//   _sorá, बों_, _опыт, _vísa
  { {0x61ed009b,0xe298002d,0x539b000b,0x979a000b}},	//   _kmal, жає_, שיבו, _השתק
  { {0x6d4400c1,0x7df3000d,0x628511b7,0x02fb0009}},	//   ccia, năst, rtho, סלאמ
  { {0x55ba0093,0x6d5d0039,0xadc3001a,0x98f40012}},	//   _המרו, _iesa, hoản, وثها
  { {0x6d5d00a1,0x05a30037,0x1da30011,0xb659003c}},	//   _hesa, _खोजब, _खोजत, бших_
  { {0x6d5d00c6,0xcf58000b,0x61ed0038,0xf4120009}},	//   _kesa, חבות_, _omal, _נפל_
  { {0xbca50003,0xb2220028,0x96fc000b,0xe7080003}},	//   كمبي, áætl, ילות, غتون_
  { {0x2bb90003,0x9627001e,0xa01b004a,0xb4d50037}},	//   مادة_, _izņē, ttöl, सने_
  { {0x7ddc0108,0x95f90011,0x33d40024,0x5f440012}},	//   _rése, ्कुट_, діют, _ينقل
  { {0x443f0108,0xe8e10020,0x2fe40003,0xa01b0028}},	//   squ_, _đều_, _تكلف, rtöl
  { {0x63a300bd,0xdb1c0058,0x6d5d11b8,0xa01b11b9}},	//   _wann, _foræ, _nesa, stöl
  { {0x5d3a000b,0xe4490003,0xe20b0028,0x9f43004a}},	//   _התנא, _التى_, _slóð_, kijä_
  { {0x2bbb000a,0xa01b008e,0x64a20048,0xddc30073}},	//   _خاصة_, ltöj, _чаша, ksnū
  { {0x9f990065,0x6d5d11ba,0x7c3d0052,0xa3b50037}},	//   ráðu_, _besa, _ausr, झाई_
  { {0xa01b004a,0x60120028,0xf0660103,0x6df60012}},	//   ntöj, væmu, _екип, أكرا
  { {0xdd8f0003,0x75d30003,0x99920010,0xe97b0009}},	// [2360] طول_, ريكا, ūzų_, _הנפש
  { {0x69db0006,0x6d4400c1,0x66160623,0xe81b0011}},	//   _alue, scia, slyk, _पीला_
  { {0x8c1a000b,0xcf57000b,0x7f3b000b,0x17570009}},	//   צועי, _מבית_, _לעיו, _מסיר_
  { {0x6d5d008b,0xf3f1001a,0x79a30021,0x20180028}},	//   _gesa, hị_, ерше, llri_
  { {0xf5370093,0x6e290051,0x2d82006f,0x60160017}},	//   _מרכז_, dmeb, _icke_, lâmi
  { {0x9f5c0029,0xd0100003,0x56940247,0xf8670012}},	//   lovú_, خلت_, дакт, أموي_
  { {0xcf260003,0x60160017,0xc7b30009,0xa6c80012}},	//   أرشي, nâmi, תבו_, توغل_
  { {0xade3007c,0x21a30146,0x8afb0009,0x9f5c0064}},	//   ецьк, _писм, _ההלי, novú_
  { {0xdb1c003a,0xbf360012,0x65600097,0x9f94008e}},	//   _borç, _فراغ, ramh, _kää_
  { {0xa01b004a,0x6560006f,0x9f5c0029,0x61ed11bb}},	//   ttöm, samh, hovú_, _smal
  { {0x9f5c0064,0x6b670031,0x394601e3,0x9f94079b}},	//   kovú_, légí, ocos_, _mää_
  { {0x2617003a,0x394611bc,0x9f470018,0x3ddf0227}},	//   rçok_, ncos_, miná_, chuw_
  { {0xdb1c0e23,0x7dd80066,0x7de50012,0x9d1a0012}},	//   _forç, _písn, _تسلم, _ازاء_
  { {0x4c9b000b,0xa5bb001a,0x7a230051,0x6d5d0a12}},	//   _לבדו, _chón, mõte, _sesa
  { {0x6d5d11bd,0xbc1b0009,0x7c3d11be,0xd61b0012}},	//   _pesa, _הוגש, _susr, مترا_
  { {0x42fb0093,0x12fb0009,0xa6340024,0x52830012}},	//   _להוס, _להוב, енсі, _أليك
  { {0x4c940189,0x64400c04,0x82340012,0x50f50024}},	// [2370] нитс, _émil, _ثروا, _ізот
  { {0xd3710003,0x394601e3,0x2d820032,0xdd9906dd}},	//   ئها_, ecos_, _ecke_, zeň_
  { {0xdb580015,0xdd0c0002,0x38690028,0x69da0010}},	//   яют_, góło, _hvar_, _įter
  { {0xd131000a,0x386911bf,0x61fd0028,0xc333000b}},	//   نما_, _kvar_, nnsl, גוע_
  { {0xc0c80001,0xdd990042,0x28f80024,0x186904d6}},	//   зује_, veň_, пець_, цали_
  { {0x25a9000e,0x94ba000b,0x27c7003c,0x945d0034}},	//   ldal_, _ומשת, ящег, zyńs
  { {0x56920001,0x92940345,0xe1f30012,0xa01b008e}},	//   вајт, _парц, _كسر_, ttöj
  { {0x96270039,0x56b80093,0x26dc000b,0x533402d3}},	//   _uzņē, לפון_, מקומ, _чест
  { {0xea00001a,0x248911c0,0xdd990029,0x7dd50028}},	//   _ngại_, ntam_, reň_, _hásk
  { {0xa3e9002d,0x320f11c1,0xcad50009,0xa01b008e}},	//   ідна_, logy_, ֥וֹת_, stöj
  { {0x3ed5000a,0xfe700003,0xf3f1001a,0xdcee001e}},	//   _تقار, _مدن_, rị_, ādāj
  { {0x7dd5000e,0xa01b004a,0x5e440012,0x04950012}},	//   _másk, ltöh, _أَنْ, _يلاح
  { {0xa5bb001a,0xb87b000e,0x25a9000e,0x644b07a8}},	//   _phón, szín, ddal_, _utgi
  { {0x0c24007c,0xe8200037,0x94040012,0x62950227}},	//   _змін, यतया_, _كونه, _opzo
  { {0x16a70098,0x2cad002a,0x6b9c005e,0x9f5c0064}},	//   мври_, lved_, õrge, tovú_
  { {0xcb120093,0xe61a002d,0xc692000b,0x7b03000d}},	//   _שלה_, іда_, כאל_, ăută
  { {0x39a6039c,0x9f94004a,0xa00a0012,0x9f5c0064}},	// [2380] _jūsų_, _pää_, _وقبل_, rovú_
  { {0x39a6007a,0xafdb038e,0x2cad002a,0x9f5c0029}},	//   _mūsų_, spør, ived_, sovú_
  { {0x67bb000b,0xd7bb0009,0xbe660012,0xa5bd0073}},	//   _ומיק, _וציר, _تهجي, rmųj
  { {0xe61a0024,0xa01b008e,0x38660031,0xa1ba0012}},	//   _фдм_, ytök, tsor_, غطاء_
  { {0x395f0c56,0x5fd20011,0xd59b0009,0x6d9b0009}},	//   _deus_, _हवाल, _ובכל, _ובכפ
  { {0xb033007c,0x7a230051,0x77630054,0xdfd00012}},	//   вніш, võte, ganx, طيب_
  { {0x2cad002a,0x61fd0028,0xa3b10037,0xdaba0003}},	//   eved_, ynsl, _ऑफ़_, _ظهرت_
  { {0x6564004a,0xa01b11c2,0x26130018,0xdb080025}},	//   naih, ttök, dãos_, _élép
  { {0xd49a002d,0x23830028,0xc0460012,0xff760012}},	//   іри_, _þrjá_, _آخرو, _يُرج
  { {0x7ddc0108,0x6f0d003a,0x9f580029,0x4e960003}},	//   _désa, şaca, torý_, _يشار
  { {0x33770214,0x0377000b,0xc7b3000b,0xdb030028}},	//   ועים_, ותית_, _שבע_, _ennþ
  { {0xc3330093,0x2b5100a2,0x61e201fb,0x22ac0030}},	//   כות_, ızca_, nhol, _věk_
  { {0x7dd10163,0xe4d60012,0xe4ea0012,0xa01b008e}},	//   _måst, _تتاب, _بعضه_, ltöi
  { {0x251b0009,0xbb840012,0x7dd10d77,0xad1b00af}},	//   _וודא, _ألغي, _låst, _וודר
  { {0xe613000a,0xb595096e,0x637b0009,0x40340bd8}},	//   نشر_, нивш, _ונוד, терс
  { {0x63a7000f,0x2489000e,0x443811c3,0xe5730012}},	//   _sajn, ttam_, _air_, ضطر_
  { {0x443800a1,0x61e200c5,0xb4d90037,0xd7e7002d}},	// [2390] _bir_, dhol, ़ने_, _жіно
  { {0x395f0e23,0x6fd40054,0xd8380a3d,0x1b7b0012}},	//   _seus_, _fàci, _nič_, تصرة_
  { {0x1756000b,0x2cad001e,0x97560009,0x0f560009}},	//   _אסתר_, zved_, _איתו_, _איתם_
  { {0x3ebe0033,0x20110027,0xda080012,0x7c3811c4}},	//   åtte_, lozi_, ويله_, _livr
  { {0x7b67035b,0x6e2d11c5,0x395f01a0,0x443811c6}},	//   _отве, mmab, _veus_, _fir_
  { {0x44380119,0x187c000b,0x60d80009,0x80a80024}},	//   _gir_, קטוב, וודא_, ьвів_
  { {0x6820000e,0x395f08b6,0xe7360313,0xe80e0011}},	//   ködn, _teus_, неш_, ाक़ा_
  { {0xd738000b,0xd5b10003,0x442c0070,0x6fdd0054}},	//   וטות_, افظ_, emd_, _dèca
  { {0x660200b6,0x60120040,0x91fd0035,0x973c0034}},	//   _djok, kæmp, rsāl, _zaćm
  { {0x7dd5000e,0x2cad11c7,0xddc80035,0xf7480012}},	//   _mási, rved_, ļoša, _يلقي_
  { {0xf412000b,0xd6d10003,0x291e0034,0x7c3811c8}},	//   רפי_, _حقا_, ętam_, _divr
  { {0xc332000b,0x7dd801bd,0xcf890009,0x6fd401a0}},	//   טוי_, _písm, _לט_, _ràci
  { {0x6c840003,0x26170017,0xea00001a,0x656411c9}},	//   _للنم, nçou_, hiết_, vaih
  { {0xa7da000a,0xd0f6000b,0x661b083c,0x201100c1}},	//   أوسط_, תמשת_, lluk, gozi_
  { {0x4427008b,0x66e60dfb,0x66060048,0x661b005e}},	//   _ihn_, хова, епва, oluk
  { {0xa3a80044,0x78a40051,0x764100b6,0x6da30177}},	//   _खोज_, _tsiv, _muly, лиса
  { {0x91fd0333,0x0c260867,0x9c260867,0xfce30400}},	// [23a0] ksāj, еман, едад, гото
  { {0x08570093,0xf0930009,0x656411ca,0x44270032}},	//   _רבים_, _ענת_, saih, _jhn_
  { {0x2f5b0093,0x443811cb,0xe7320012,0xd2590024}},	//   _מדינ, _vir_, _حصة_, дці_
  { {0x4438008b,0x2a6a000f,0xceb3000b,0xe2160012}},	//   _wir_, ábbi_, _עיר_, رباع
  { {0x6d3b000b,0x661b0d9a,0xba170012,0x61e21101}},	//   _מתכנ, dluk, ريها_, rhol
  { {0x4ea6004d,0xdc8b0009,0x74160012,0xc6a60048}},	//   ериа, _מְלָ, _أوسا, ерии
  { {0x09e6002d,0xfe6f0003,0x877b0009,0x8f7b0009}},	//   _зовн, مدي_, לאסי, לנסק
  { {0x291e0002,0xbef70003,0xe7f20011,0x7bce005e}},	//   ętaj_, عروض_, _अगवा_, _hobu
  { {0xe58b000b,0x09e30055,0x6d8b0009,0x98ab0060}},	//   הָיָ, _сотн, הָיְ, yacı_
  { {0x44380163,0xb8d40037,0x3ea90002,0xa01b004a}},	//   ör_, जट_, łata_, ltöv
  { {0x45e4008a,0x7c380d65,0x442c11cc,0x79820002}},	//   _đượ, _vivr, rmd_, ogow
  { {0x79820002,0x225c0042,0x61360060,0xd6db0009}},	//   ngow, ávky_, _gülü, _מחבל
  { {0xd5e90003,0xf1b30009,0x9f5800b8,0xe1ff11cd}},	//   _تعلن_, אסר_, vorò_, rnó_
  { {0xb8c90044,0x7dd50028,0x29f80029,0xa3e40011}},	//   _गई_, _rási, očas_, _नति_
  { {0xab270001,0x7a3e0010,0x98ab003a,0x6e9400de}},	//   _поља_, _būte, racı_, лиру
  { {0x63aa0065,0x34950015,0x6e2d002c,0x11d70012}},	//   _hafn, кабр, umab, _ستعد
  { {0x7dd80107,0xe4e70024,0xfd130012,0xdfd10012}},	// [23b0] _získ, хівн, اجز_, _نية_
  { {0x63aa0065,0x661b0060,0x7bda11ce,0xdce00412}},	//   _jafn, zluk, nktu, jamč
  { {0xa0360093,0xbb840003,0xf8360009,0x9f8f005e}},	//   _שאתה_, المي, _שנתת_, _müü_
  { {0x9f580065,0x7ae50051,0xdb0e0017,0xd6560009}},	//   lorð_, _ühte, _robô, _שירת_
  { {0xf994000b,0x9914002d,0x7bda0028,0x9f47008e}},	//   טרף_, льші, kktu, yinä_
  { {0x63aa0065,0x62980070,0x36950109,0xf0940009}},	//   _nafn, _opvo, вшис, רנס_
  { {0x97ac000b,0x5f050014,0xd7050048,0x9f47008e}},	//   לֹהֵ, ъзка, ъзки, vinä_
  { {0xa8490003,0x7ddc0061,0xceb4000b,0xf9930012}},	//   _يلزم_, _déso, ריק_, _حبس_
  { {0x661b046c,0x9f5c0042,0x91fd0035,0x6d4911cf}},	//   rluk, lový_, asāk, rcea
  { {0x91aa0037,0x66dc008e,0x67240030,0x7dd80030}},	//   _जोड़े, näkö, řija, _písk
  { {0xd6db0047,0x8d950003,0x7ddc000e,0xb17b0989}},	//   _эта_, _للاش, _késl, rhån
  { {0x9998001e,0xa06a05fb,0x9f47008e,0x186a0a21}},	//   _kurš_, мама_, sinä_, мами_
  { {0x91a0001a,0xd1320003,0x88c70024,0x95c40012}},	//   _chí_, شمس_, вляв_, _حينه
  { {0x9f5c00d9,0xcc760009,0xbc07003c,0xa0a3004c}},	//   kový_, _יענה_, _ячей, јард
  { {0x91a0001a,0xfaa502c4,0x9f5c01e9,0x96630357}},	//   _thì_, _райо, jový_, икре
  { {0x98be003a,0xceb2000b,0x386d11d0,0xc27a0009}},	//   ştı_, סין_, _over_, _חרקי
  { {0xd4670098,0xe7f20037,0x9f580028,0x91fd001e}},	// [23c0] ките_, _अगला_, borð_, zsāk
  { {0xeafa0003,0x987b0009,0x80890012,0x73ac0009}},	//   ورات_, _קריק, _أضيف_, ּיאֵ
  { {0x386d01a2,0x2777000b,0x2905003a,0x74130012}},	//   _aver_, _בגין_, şlat_, جولا
  { {0xe9da002d,0x7ddc0061,0xc332000b,0xe8fa01ec}},	//   ьке_, _réso, בוב_, мле_
  { {0x7bce0010,0xe8940055,0xb8940012,0x88e60048}},	//   _tobu, уаль, التع, ъжде
  { {0xdfcf000a,0xb4de0037,0x25a00061,0x248d0328}},	//   يين_, तनी_, leil_, dtem_
  { {0x386d002a,0x6fdd0054,0x79960002,0x5ea30012}},	//   _ever_, _tècn, _obyw, لمول
  { {0x63aa0028,0xa01b11d1,0xdbe30025,0x27f80032}},	//   _safn, ltöt, _réél, hirn_
  { {0xc5f30093,0xdb010058,0x9987000d,0x64420061}},	//   ידה_, ndlæ, ţiţi_, _quoi
  { {0x32020026,0xa857000b,0x660d009b,0x6e960003}},	//   enky_, _סיבה_, čaka, _للطا
  { {0xe9f9007c,0x51f9002d,0x5b7b000b,0x5a35010c}},	//   енні_, енню_, וריא, лнот
  { {0x91a00020,0xcb130093,0x91a90020,0xadb70012}},	//   _phí_, ילת_, _khả_, _لهما_
  { {0x386d0108,0x5c730024,0x79540012,0x7a0b0034}},	//   éer_, _вліт, شَّا, jęte
  { {0xdb1c03ee,0x92f60012,0x2005005e,0x2480004b}},	//   _forø, _لأعض, õli_, duim_
  { {0x9f58014d,0xc2c30003,0x25a007c9,0x6b9b0009}},	//   rorð_, _نيوي, feil_, _חשוד
  { {0x32530098,0x1dc50011,0x9f580097,0xdb370009}},	//   _твър, वायत, sorð_, _בנוח_
  { {0x80be0044,0xf367002d,0x99990010,0xdb0a0192}},	// [23d0] ्हों, втен, ūrų_, _anfø
  { {0xc3540001,0x7c840001,0x7dd50028,0x9f5c01bd}},	//   икуј, јуте, _hást, tový_
  { {0xeb910009,0x8ff80012,0x93880048,0x0b880048}},	//   מָא_, _جرير_, ъста_, ъсти_
  { {0xe7e50037,0x9f5c01bd,0x261701d7,0x27ef0034}},	//   कसभा_, rový_, rços_, żoną_
  { {0x248d0066,0xdfd5003c,0x9f5c0042,0xd5b60011}},	//   xtem_, лоды, sový_, _अफ़ज
  { {0x9f5c0004,0x77840024,0xba770012,0x9f840024}},	//   pový_, иліз, _لارت, игід
  { {0x2f98000b,0x4e950003,0xa01b004a,0xdb1805b1}},	//   דכון_, اشتر, ltös, _pový
  { {0x0696000a,0x7dd500f1,0x248d09c5,0x26c90027}},	//   انية_, _nást, ttem_, ćao_
  { {0xbfab002d,0xb17b006f,0xa01b086e,0x248d11d2}},	//   _отже_, rhål, ntös, utem_
  { {0x7dd80028,0x2003001b,0x03a5004c,0xb17b0248}},	//   _vísi, jnji_, ћино, shål
  { {0x17f80003,0x16030037,0x2003048b,0xdb03000e}},	//   _شركة_, रचार_, dnji_, _taní
  { {0xc7a90009,0x64b50012,0x95570012,0x6e3d11d3}},	//   _מב_, _محتر, _شخصا, _nisb
  { {0x6d5b00c6,0x69cb0227,0x6d5d0097,0x20040018}},	//   mbua, ijge, ðsau, émio_
  { {0x69dd083c,0x291e001e,0x75fe001e,0x443c0572}},	//   akse, āta_, vīzi, _giv_
  { {0xf3f0000a,0x25a00052,0x65ba0001,0x93bc000d}},	//   _بأن_, teil_, нуар_, rmăt
  { {0x290500a2,0x75d60003,0x69dd0052,0xdce0001e}},	//   ğlar_, ديرا, ckse, lamā
  { {0x290500a2,0x037a0003,0xb4de0037,0x25a00061}},	// [23e0] şlar_, فحات_, तने_, reil_
  { {0x3d040037,0x7dd501bd,0x07a6004c,0x35c50011}},	//   _रखीं_, _zást, _саон, वाड़
  { {0xa2a90011,0x232a003c,0xdce40073,0x628111d4}},	//   टिट्, хожи_, maič, nulo
  { {0x7cda0039,0x00e6010c,0xc332000b,0x2247004c}},	//   _pārā, лжен, זוב_, упци_
  { {0xd917002d,0xbddb0061,0x78a9000e,0x8a17000b}},	//   льш_, _sièg, _csev, נחנו_
  { {0x660411d5,0xf1bf000e,0xc4d3000b,0xda660003}},	//   lnik, lmát_, _הגש_, _ماري
  { {0x69dd0006,0x1ae60015,0x63a30051,0x998d0029}},	//   ykse, _совм, õnne, _sieť_
  { {0xa01b006f,0x6446004a,0x91a9001a,0x7bde006f}},	//   ntör, _kuki, _thả_, lkpu
  { {0x71d7000b,0xdce411d6,0x2449001a,0xa3e80037}},	//   _עומד_, kaič, _cúm_, _बता_
  { {0xda7a007c,0x644f0017,0x27f8003a,0xb8f80011}},	//   ням_, ícia, _örn_, ाह_
  { {0xd00f0003,0xa01b03ad,0x644611d7,0xdb0301a0}},	//   _علم_, ktör, _luki, _canà
  { {0xa01b11d8,0x69dd0006,0x15460146,0xe1350015}},	//   ytös, ukse, _седм, инны
  { {0x98b80048,0x2003001b,0xa01b0031,0x5c5611d9}},	//   глят_, tnji_, dtör, _стеф
  { {0xdce0001e,0x7d1d006f,0x6fc70011,0x69dd005e}},	//   camā, _ryss, लायं, skse
  { {0x9f35007c,0x539b000b,0xaab70003,0x628111da}},	//   реві, _ניהו, _مدير_, culo
  { {0xa01b07cc,0xddd5000e,0x5d5502ac,0x6446013d}},	//   gtör, tsző, ркат, _buki
  { {0x55070014,0x200304d2,0xc4540012,0x5f160011}},	// [23f0] учва, pnji_, مضلع, _पुस्_
  { {0x9f4b004a,0x2ef5003c,0x69c011db,0x9cd70009}},	//   äjät_, _взор, _anme, אומה_
  { {0x6604012e,0xdb0300f1,0xddd5000e,0x23740003}},	//   bnik, _kaná, ssző, صالح
  { {0x6d420020,0x316b0002,0xc3330009,0x19950472}},	//   _ngoa, nacz_, צוף_, радя
  { {0x6016007d,0xad9b0028,0x601f0017,0xa9680012}},	//   tâmp, _ljúk, lêmi, امهم_
  { {0x3d180037,0x6c7a0009,0x2d840060,0x6cfa0009}},	//   _पड़े_, _באשפ, _ömer_, _יפרס
  { {0x0f58000b,0x65c50015,0xcee6002d,0x97580009}},	//   ניהם_, ибка, идше_, ניהו_
  { {0xbca50003,0x660d009b,0x9cb50012,0x3e320012}},	//   لمبي, čako, لمعت, يفور
  { {0x6d5b00b6,0xe572000b,0xcd290014,0x629c0066}},	//   rbua, חַת_, ъжие_, _zpro
  { {0xdb1802d1,0xabd50001,0x628111dc,0x9cd80009}},	//   _enví, рциј, tulo, טוחה_
  { {0x2cb8001e,0x09f60003,0x660404f3,0xdce40010}},	//   ārda_, لأحد, ynik, vaič
  { {0xdb070013,0xb1da002d,0xb4950001,0x93bc000d}},	//   _nají, тьох_, _видљ, umăr
  { {0x7dd80013,0x3d040044,0x7a230051,0x93bc000d}},	//   _míst, _रखें_, võtl, rmăr
  { {0x6604003e,0x3075003c,0xa9360009,0x917a0081}},	//   wnik, щуюс, יטרה_, _mẩu_
  { {0x316b003e,0xb7f80037,0x09e6005c,0x9bfa000b}},	//   bacz_, ्चतम_, _войн, _שהצט
  { {0xe9df0029,0x395f0097,0xf5060148,0x4a9a00af}},	//   ckú_, ðust_, азбо, _ייצג

  { {0xa356000a,0x629c11dd,0xe4360012,0x6c360012}},	// [2400] لخاص, _spro, لفرد, لفرا
  { {0x66040416,0xd8db000b,0x6820000e,0x3ff30012}},	//   snik, _סקיר, ködi, _وكير
  { {0x463a0003,0x2367000e,0xb77b0009,0x877b0009}},	//   _لأحد_, _menj_, _באיש, _באיי
  { {0x6446004a,0xe0da0001,0xfc48001a,0x201811de}},	//   _tuki, кве_, _lửa_, lori_
  { {0x629c003e,0x9f5111df,0x20870048,0x4fc611e0}},	//   _wpro, lizá_, ийци_, иска
  { {0xdb070066,0x22400051,0xfc48001a,0x67240030}},	//   _zají, _liik_, _nửa_, řijm
  { {0xb765007c,0x539b000b,0x7ddc0061,0xc14b0081}},	//   стій, _שילו, _hési, _câịp_
  { {0x9fa30065,0xba57000b,0xd5b7027f,0xf6570009}},	//   síðu_, _כסלו_, ась_, בסקי_
  { {0x64400061,0xe4e60024,0xe97b0009,0x717b0009}},	//   _émis, рійн, _שנמש, _שנמס
  { {0xfc480020,0x47aa0003,0x60e8003a,0x66090027}},	//   _cửa_, _جارٍ_, ırmı, čeki
  { {0x91fd0039,0x0bb7000b,0xb4db001a,0xa6ca0012}},	//   ksāt, בלים_, _ngàn, _جوال_
  { {0x54a60012,0xedd30012,0xd49a091c,0x7dd80e1f}},	//   _نحتف, _ويلد, _арк_, _míss
  { {0xf993000b,0x2bc90037,0xf8c60011,0x7ae5005e}},	//   חרר_, रामा, लमिय, _ühtn
  { {0xd7fb0046,0xb7f80037,0x7a230051,0x9b940003}},	//   тум_, ्चिम_, võtm, _طلبت
  { {0xdb03000e,0x62350014,0x52840012,0xbddb0025}},	//   _taná, _леку, _العك, _nièc
  { {0x8b3b000b,0x5d780015,0xdb180054,0x433b0009}},	//   _בתוצ, ийся_, _invà, _בעוב
  { {0x40950003,0xb87b000e,0x06140024,0x22a80060}},	// [2410] _الخر, gzít, ідую, _aşk_
  { {0x7ddc0061,0xf4570009,0x6b880248,0x61fd1106}},	//   _dési, יימר_, ngdg, lisl
  { {0xeb480024,0xfb150012,0x2ac7004c,0x4c140012}},	//   рчук_, حواج, шљав, زبكس
  { {0x6d470066,0xc2440024,0x29d70060,0x321901e9}},	//   ějak, інік, _açar_, nosy_
  { {0xc104000a,0xa8a70015,0xdb0a0052,0xdb030032}},	//   يومي, ррек, _anfü, _unnö
  { {0xf7710003,0x764811e1,0x9f580025,0x656d016d}},	//   سات_, _budy, tiré_, laah
  { {0xd00e0003,0x21290064,0xfc480081,0xa49b01a0}},	//   على_, ťah_, _rửa_, _exòt
  { {0xfc480020,0x63a500df,0x78ad0038,0x61fd10b8}},	//   _sửa_, lehn, _osav, jisl
  { {0x22400051,0xdb01000e,0x1fa7002d,0x22470132}},	//   _riik_, melé, _врег, _sunk_
  { {0x91fd001e,0xa7d40012,0x9f580025,0x53c91012}},	//   ksās, _وتلص, piré_, угом_
  { {0x7a230005,0xae78007c,0xf8a9000b,0xcad50009}},	//   võtj, _всіх_, _רש_, צוֹת_
  { {0xdb030392,0x7db40012,0x6fdd0025,0x98a60357}},	//   _lanç, _وصنا, _sèch, биме
  { {0xeb990014,0x91ba000b,0x63c20066,0x201811e2}},	//   _бил_, אמרי, ávní, tori_
  { {0xd91a000b,0x7ddc0061,0xd1160009,0xb4e30011}},	//   רושל, _rési, מקרה_, ननी_
  { {0x67290013,0xdb01000e,0x200711e3,0x20181017}},	//   řejn, kelé, inni_, rori_
  { {0xfbdf001a,0x2291000e,0x93bc000d,0xdb1c0052}},	//   _quên_, mák_, plăc, _vorü
  { {0xbddb0108,0xdb180149,0x2291000e,0x7bd5003a}},	// [2420] _sièc, _invá, lák_, _bozu
  { {0xbddb0061,0x6faa0001,0x77860001,0x9f860055}},	//   _pièc, _свог_, _улоз, _угод
  { {0xfe72000a,0xb87b000f,0x24920002,0x6c330003}},	//   _عدد_, szít, stym_, أفلا
  { {0xed5a0014,0xda650012,0xdb010031,0x69d611e4}},	//   _щом_, تاكي, gelé, _joye
  { {0x69d60108,0x69c40002,0xdb1c0002,0xcdb7000b}},	//   _moye, _mnie, _poró, _הפכה_
  { {0x2291000e,0xba6a0003,0xf8b3000b,0xa09b0009}},	//   kák_, _محرك_, פשו_, ריסט
  { {0xc6770003,0x2291024a,0x645b0061,0xcaa50012}},	//   محيط_, ják_, epui, _وصفي
  { {0xfbc90037,0x3ebe004a,0x7bc311e5,0x442e018a}},	//   राथम, ätty_, _annu, _shf_
  { {0x8afc0002,0x92a80002,0xf1c300d9,0x61fd0042}},	//   zbęd, _małż, šší_, visl
  { {0x13f4002d,0x9cd7000b,0x03f80001,0xb2740129}},	//   ізня, צויה_, рној_, олош
  { {0x1757000b,0x7ae50051,0x639b0009,0x8c1b0009}},	//   _הסבר_, _ühtl, נסטנ, רויי
  { {0xa3b10037,0x14c80037,0x60dd004a,0x63a50052}},	//   _फ़ोन_, रमाण, tysm, zehn
  { {0x682d0029,0xdca3031e,0x361b0009,0x69c411e6}},	//   súde, _наци, _גואד, _dnie
  { {0xdb01000f,0x229111e7,0xe5070009,0xad250012}},	//   zelé, bák_, _ל֖וֹ_, _برمو
  { {0x63970093,0x93fb000b,0x7bfb000b,0xdd9b0014}},	//   _הדוא_, _תלוי, _תפוצ, лша_
  { {0x91ad0020,0xbcfb000e,0x69c40002,0x9f4700d9}},	//   _thẻ_, _idéz, _gnie, diný_
  { {0xdb01000f,0xe3c50012,0xe1ff01e3,0x63a511e8}},	// [2430] velé, يْرَ, mió_, tehn
  { {0x7d1d0052,0x290c003a,0x69c40002,0xab940024}},	//   üssi, ğdat_, _znie, зифі
  { {0xdb01000e,0xa6ab0012,0x539b0009,0x92670012}},	//   telé, _صادق_, ריבו, صدام
  { {0x3ebe00c5,0x201e11e9,0x99840012,0xe1ff11ea}},	//   ætte_, _akti_, كلمو, nió_
  { {0x7ddc0061,0xfe09001a,0x224d11eb,0x00850024}},	//   _jésu, hắc_, _čeku_, ілко
  { {0x6f87002d,0x7e550229,0xf2e703e1,0x988c0009}},	//   судж, отиц, _любо, רָאֵ
  { {0xdcfb0027,0xdb0108c5,0x501c0009,0x99850012}},	//   oguć, pelé, אוגו, _ولسو
  { {0x91a90020,0xcb120009,0x8af80048,0xa194003c}},	//   _nhà_, _חלל_, _унсс_, _насч
  { {0xb4e30044,0xa5090014,0xe1ff11ec,0x1d090048}},	//   नने_, репа_, dió_, репи_
  { {0x69c40039,0xe2910003,0x2291000e,0x69d60061}},	//   _snie, وذج_, ták_, _soye
  { {0xd1ca0046,0xa9a606a5,0xe29911ed,0x2329024d}},	//   алне_, оинд, шан_, рони_
  { {0x36340003,0xbba60011,0xe1ff11ee,0x229111ef}},	//   _فرنس, _ऑस्क, gió_, rák_
  { {0xfba90037,0x69d60061,0x33f50012,0x9f450025}},	//   क़दम, _voye, _وستس, _allé_
  { {0x248000a2,0x69c40034,0x9f470478,0xc49a0009}},	//   vrim_, _wnie, minó_, _כשנת
  { {0x7f430800,0x61e211f0,0x4ded0037,0xfe670003}},	//   держ, ykol, _जताई_, بد_
  { {0xe1ff11f1,0x64430101,0x660911f2,0xceb20009}},	//   ció_, _hini, nnek, ויל_
  { {0x656b000f,0xe617002d,0x6e2400b6,0x644311f3}},	// [2440] _megh, іду_, rlib, _kini
  { {0xdb07000f,0x62810070,0xdb1c0028,0xd9e20011}},	//   _sajá, orlo, _borð, पस्ट
  { {0x442511f4,0x661b11f5,0x16190011,0x479b0009}},	//   ill_, kouk, दवार_, _דייס
  { {0x18a6002d,0x661b004a,0x64590002,0xa92607e8}},	//   жадм, jouk, _otwi, одел
  { {0x61e211f6,0x75fa0066,0x62810032,0x9f430097}},	//   rkol, hůzk, hrlo, mhjá_
  { {0xdb1c0028,0x644311f7,0xe1ff000e,0xb7d70012}},	//   _forð, _nini, zió_, يونا_
  { {0xfe6f0003,0x644b0010,0x1dc50011,0xdb070097}},	//   ندي_, _augi, वांत, _snjö
  { {0x9343007c,0xe1ff0054,0x1af70009,0xdd900012}},	//   _інте, xió_, _ומלל_, روخ_
  { {0x64430101,0xe1ff0164,0x644b00b8,0x9f4701e3}},	//   _bini, vió_, _cugi, ginó_
  { {0x7ddc0108,0xa2f4002d,0x5397003c,0x88bd0034}},	//   _résu, зпоч, овья_, _wyśc
  { {0xe3b8003a,0xe1ff11f8,0x883b0009,0x64430c3e}},	//   llık_, tió_, _כתמו, _dini
  { {0x6443008b,0x201c11f9,0x644b11fa,0x442511fb}},	//   _eini, lovi_, _fugi, all_
  { {0xc1730093,0xe1ff0164,0xe3b8003a,0x2e370009}},	//   וחר_, rió_, nlık_, _וראש_
  { {0xd250000a,0xe1ff03eb,0xbebc001e,0x93b3002d}},	//   _كنت_, sió_, _dzīv, _обіц
  { {0x3dc60036,0x67e20029,0x2ee50028,0x356b0103}},	//   _know_, _môjh, álf_, иран_
  { {0x7a120039,0xc3390066,0xe3b8003a,0x6288009b}},	//   tāte, čítá, klık_, mudo
  { {0x34940a1a,0x94ab0001,0x5ce7002d,0x39490051}},	// [2450] матр, штва_, цюва, _igas_
  { {0xbc680003,0xa2be0037,0xa8580009,0x23cd0011}},	//   تمكن_, षिप्, _ויזה_, ़ायद
  { {0x28380003,0x201c11fc,0x224d0035,0x66000034}},	//   _بأية_, dovi_, _čeks_, kimk
  { {0xda78002d,0x66000066,0xd3370009,0x41e40024}},	//   іях_, jimk, קראה_, міча
  { {0x998d0026,0xa6e20028,0x63a811fd,0xf8cb0011}},	//   _tiež_, öðva, kedn, ामिय
  { {0x27c70015,0x3d3a000b,0x1a5b0003,0x63a808ff}},	//   ющег, _לגרס, _نشرة_, jedn
  { {0xfbd2000b,0xd6a80003,0x64590002,0x2ba90037}},	//   _אתם_, قديم_, _stwi, क़सा
  { {0xee390001,0x2bc90011,0xb9550048,0xc2c40012}},	//   љни_, रावा, _хващ, _تيفي
  { {0x321d0002,0x644311fe,0x9990000d,0x24890018}},	//   mowy_, _pini, ţaţi_, nuam_
  { {0x321d003e,0x80a40003,0x76c70012,0x7ae5005e}},	//   lowy_, _تمكن, _وغال, _ühtk
  { {0x7bd801a2,0xf0890009,0xca350009,0x4b250024}},	//   _dovu, _תנ_, ּנָה_, ямов
  { {0x644b0051,0x321d0002,0xfad60009,0x3d950294}},	//   _tugi, nowy_, לותך_, _хидр
  { {0xdb1801ab,0x6288007a,0x6443002c,0x7bc70498}},	//   _anvä, audo, _tini, _onju
  { {0x9cd6000b,0x3a26000e,0x9f5c11ff,0xdfd20012}},	//   _מונה_, zlop_, tivé_, ريز_
  { {0xfaa20098,0x321d0002,0x92640003,0x92590012}},	//   _защо, kowy_, _قديم, _اشتر_
  { {0x32da000b,0xceb2000b,0xda7a000b,0x9f5c0061}},	//   _לחצנ, עין_, _הנקר, rivé_
  { {0x321d0002,0xac860472,0xd5af0012,0xa5bb0031}},	// [2460] dowy_, ягал, دفق_, _skóc
  { {0x917a001a,0x60fb000b,0x70fb0009,0xa0970009}},	//   _hầu_, _להפק, _להפח, _צדיק_
  { {0xe7db0093,0xb7db000b,0x38690052,0x6fdb000b}},	//   _הקיש, _הקיי, _zwar_, _הקיס
  { {0x63a8003e,0x8c460015,0x628f0002,0x04460015}},	//   zedn, _неме, ńcow, _немн
  { {0x55bb000b,0xdb18006f,0x63c70030,0x29120060}},	//   _המכו, _invå, ární, çya_
  { {0xdb0e02d1,0xe3b8003a,0xdb0a006f,0x3dc61200}},	//   _habí, rlık_, _infö, _snow_
  { {0xfbc90044,0xfaa30434,0x63a80b31,0x7a23005e}},	//   रारम, _паро, vedn, võtv
  { {0x9aeb000b,0xceb3000b,0xe3b8003a,0x9daa0048}},	//   _הַמִ, תיה_, plık_, съка_
  { {0x7bd80027,0x6135000e,0x660008e2,0x201c1201}},	//   _povu, rülé, rimk, povi_
  { {0x628810ad,0x7ae100b0,0xb05b0ed7,0x7ddc0018}},	//   tudo, fylt, lväg, _péss
  { {0xa75b000b,0x6135000e,0x443a000d,0x32020004}},	//   _הדבר, pülé, imp_, fiky_
  { {0xdb0e0013,0x917a0020,0x80b30037,0x62880058}},	//   _nabí, _cầu_, _इनमे, rudo
  { {0x7a230051,0x4fc70014,0x3cf80037,0x25a90132}},	//   mõtt, псва, ूपों_, veal_
  { {0xdd3b000b,0x853b000b,0x2d9c000e,0xa01b000e}},	//   _העדכ, _הגדי, ővel_, ltöz
  { {0x752f003e,0x539b007e,0xb05b006f,0xf413000b}},	//   _szcz, _היוו, kväg, _אפס_
  { {0x63b5001c,0xe3b800a2,0x3ebe0028,0x02450003}},	//   _sazn, ldı_, ætta_, _تَعَ
  { {0x61ed0101,0xb97c000b,0x67ef0058,0xfbd90001}},	// [2470] _ilal, _הנחי, _høje, одај_
  { {0xe3b800a2,0x6725004a,0x68ef003a,0x321d0002}},	//   ndı_, _tyhj, ındı, wowy_
  { {0x98b900a2,0x321d003e,0x24521202,0x25a91203}},	//   ması_, towy_, _lâm_, peal_
  { {0xa954002d,0x68320058,0x22951204,0x7a3f0cac}},	//   екці, ræde, råk_, _būti
  { {0x7a12001e,0x99d40003,0x321d0002,0x7a150002}},	//   nāta, عتما, rowy_, jąte
  { {0x7a230051,0x656f1205,0x389c000b,0xb8d50037}},	//   võtu, _hech, ציונ, _जन_
  { {0xd5e10011,0xcf580009,0x321d0034,0xdce60035}},	//   _नवाज, הבות_, powy_, _iekā
  { {0xb9c5000a,0xe45900f5,0x660d1206,0x7bdc0795}},	//   _تقري, ожи_, nnak, örun
  { {0x660d0101,0x98b9003a,0xdcfd003a,0xe45f0028}},	//   inak, kası_, _kası, _drög_
  { {0x7a12001e,0x13090015,0x2452001a,0xf794003c}},	//   dāta, жной_, _dâm_, _пауэ
  { {0x442b001e,0x32020042,0x69c90132,0x2003013a}},	//   ēc_, tiky_, _knee, diji_
  { {0xd6d80047,0x645d07f6,0x69db0061,0xf1bf0066}},	//   _эту_, _otsi, _joue, slán_
  { {0x917a001a,0x98b9003a,0x660d1207,0x05740012}},	//   _cấu_, fası_, dnak, _ساند
  { {0xdcfd00a2,0x917a0020,0xdce60039,0x67ef0058}},	//   _nası, _dấu_, _nekā, _føje
  { {0x645d039c,0x9f581208,0xfbd20009,0x43720012}},	//   _atsi, rirà_, _בתג_, _شهير
  { {0x7a12001e,0x656f0504,0xf5b50024,0x6e290032}},	//   bāta, _cech, нсую, nleb
  { {0xdcfd00a2,0x2452001a,0x25fd0037,0x200300eb}},	// [2480] _bası, _xâm_, रोधी_, biji_
  { {0x7a3f001e,0x2003048b,0x9f451209,0x9f580d85}},	//   _rūti, ciji_, _allí_, birá_
  { {0x645d0006,0x2cb8001e,0x656f084f,0x7a3f001e}},	//   _etsi, ārdi_, _fech, _sūti
  { {0x79a30046,0xf1a30001,0x6d4b00b6,0x8b08000b}},	//   врше, вршн, _ngga, הִנֵ
  { {0x7a230005,0xe3b8003a,0xb05b006f,0xd9ae0011}},	//   võtt, ydı_, rväg, _घसीट
  { {0x6d590070,0x66040038,0xd0f70009,0xb05b0ed7}},	//   _afwa, liik, ומנת_, sväg
  { {0x7a230051,0x66730012,0x69db0025,0xb05b0248}},	//   tõtt, ندير, _foue, pväg
  { {0x1dd10037,0xc883003a,0x66040872,0x16370012}},	//   हायत, üğü_, niik, وسية_
  { {0xe4520012,0x9f5c0030,0x98b90060,0x9f580018}},	//   خضع_, liví_, yası_, zirá_
  { {0x88bd0002,0x7a12001e,0x8af8046d,0xf1bf0031}},	//   _myśl, vāta, знос_, alál_
  { {0x660d003a,0xe3b8003a,0xddcb0a48,0x200300eb}},	//   ynak, rdı_, žišt, viji_
  { {0x24520020,0x3869004b,0x7c660012,0xdb1c0248}},	//   _tâm_, ţare_, _قاتل, _inrä
  { {0x98b900a2,0x660d0029,0x3e7a001e,0x20030027}},	//   tası_, vnak, līt_, tiji_
  { {0x656f0052,0xa2be0037,0x9f58052e,0xd3b70024}},	//   _sech, षिद्, tirá_, _олії_
  { {0x3e7a0039,0x98b900a2,0xdb08000e,0xa3d20037}},	//   nīt_, rası_, kedé, वान_
  { {0x98b9003a,0x628501bd,0x200300eb,0x9f580b45}},	//   sası_, vrho, siji_, rirá_
  { {0x2298000e,0xd7f10003,0x656f120a,0x20030825}},	// [2490] lék_, _مكة_, _vech, piji_
  { {0xd3710003,0xfbd30003,0x656f0052,0xbcfb000e}},	//   اها_, ختر_, _wech, _beér
  { {0xc7b2000b,0xdcfd003a,0x7bdc0042,0xa0360009}},	//   _גבי_, _vası, _doru, _ראתה_
  { {0x3e7a0039,0xd131000a,0xf1bf120b,0xc333000b}},	//   dīt_, هما_, klám_, דוע_
  { {0xc0c80001,0x07a500f5,0xa0690686,0x8d5a0009}},	//   дује_, еалн, чала_, _מכרי
  { {0x63b8024c,0xdb07120c,0xf1bf0029,0x2298000e}},	//   _navn, _majú, dlám_, kék_
  { {0xd6d1000a,0x26c10013,0xfc480020,0xdce00066}},	//   اقع_, ího_, _gửi_, pamě
  { {0x2486039c,0x917a0020,0x7bdc003a,0x2298000e}},	//   šome_, _mẫu_, _zoru, dék_
  { {0x7bdc003a,0x91ad001a,0xdb070029,0xdb010029}},	//   _yoru, _ghé_, _najú, delá
  { {0xeb990001,0x2e4b0014,0x44230029,0xc0520009}},	//   чио_, _дядо_, ôj_, _עזב_
  { {0x2bb20037,0xe9ff001a,0x212900b6,0xdd00001e}},	//   ीयता, _giản_, _ayah_, ātāj
  { {0x61f900a2,0xe1f20012,0xdeba0009,0xbbdc0011}},	//   _çalı, اسد_, _ממעל, _मक्क
  { {0x442100c6,0x04c80012,0xc4fb0012,0x39440248}},	//   koh_, _يومي_, _بعضا_, äms_
  { {0xcc760009,0x7fd60024,0xdb0e0248,0x16020011}},	//   _טענה_, хімі, _inbö, रोनर_
  { {0xada60015,0x6604004a,0xf7530003,0x4421120d}},	//   навл, tiik, انفج, doh_
  { {0x7bdc00a2,0x11d60003,0xc1ba0003,0xf1b90082}},	//   _soru, _ستبد, _رابط_, _naš_
  { {0x66040051,0x3e7a001e,0x7bdc09b5,0x63a60031}},	// [24a0] riik, zīt_, _poru, őkne
  { {0x1f66002d,0x6604004a,0x25ad08de,0x394d00a5}},	//   _яком, siik, heel_, _ages_
  { {0x88bd003e,0x7a12001e,0x74130003,0xf1b90027}},	//   _wyśl, nāto, دولا, _baš_
  { {0xe9da0198,0x7bdc0032,0x60c4120e,0xf8a405f3}},	//   яке_, _woru, _krim, _ओहाय
  { {0x317b0093,0x25ad0070,0xf123027f,0x7c210040}},	//   פרסמ, deel_, льшо, kolr
  { {0x3e7a0039,0xc059002d,0xdb08000e,0x907b0009}},	//   tīt_, фії_, sedé, לטני
  { {0x4438008b,0x7bdc0028,0xa96a02ac,0x63b8017b}},	//   _ihr_, örum, _нива_, _ravn
  { {0x3e7a0039,0xe2a60028,0x71660003,0xf653000b}},	//   rīt_, öðum_, _سارك, נצח_
  { {0x3e7a0039,0x248d0d04,0x35c50011,0x6e3b0009}},	//   sīt_, guem_, वाज़, התקד
  { {0x2298000f,0xa87b000b,0x64970009,0x44380032}},	//   ték_, _מאמר, עדיף_, _jhr_
  { {0xda770015,0x6e20009b,0x7dd8000e,0x0566120f}},	//   няя_, pomb, _dísz, _звен
  { {0x629a0575,0xcb130009,0xddea0012,0xf1bf0031}},	//   rtto, טלת_, _عرضه_, mlák_
  { {0xf8bf0061,0xc0cb0001,0xebe60406,0xfca90012}},	//   uvé_, чуне_, _подп, _ياهو_
  { {0xf8bf0bfe,0xecb70009,0x7a120035,0xab620522}},	//   rvé_, _נפוץ_, bāto, üüdu
  { {0x443e008b,0x2cb80039,0x5b570009,0x64930fb5}},	//   mmt_, ārdu_, _איוב_, ržiš
  { {0x25a00572,0xbcfb000e,0x442c0851,0x80be0011}},	//   gfil_, _beép, lld_, शिशे
  { {0x644a000f,0x7c970012,0x443e045f,0x4421016d}},	// [24b0] _kifi, عشرا, omt_, toh_
  { {0x44380832,0xdc8b0009,0x67e20064,0x94390012}},	//   _chr_, לְבָ, _dôjs, ذكاء_
  { {0x8c1b0093,0xfc300003,0x67ef0058,0x141b000b}},	//   לומי, صحك_, _nøja, לומב
  { {0x7c3e005e,0x443e0032,0x225c0030,0x7ae5008e}},	//   ampr, hmt_, ívka_, ryht
  { {0xf1b90750,0x25ad0070,0x7ae5004a,0x7c380051}},	//   _vaš_, veel_, syht, _ohvr
  { {0x0058000b,0x9f450164,0x07a50001,0x7d000097}},	//   עשות_, _allá_, такн, _ýmsa
  { {0xa75c000b,0xf6b20003,0xdd910012,0x91ad0081}},	//   הדור, لموج, لوغ_, _chẽ_
  { {0x442c1210,0x24891211,0x6e2d1212,0x7a120035}},	//   eld_, oram_, nlab, vāto
  { {0x6e2d0036,0x8cc40037,0x44380032,0x25ad0834}},	//   ilab, रियो, _yhr_, reel_
  { {0xcf270012,0xa5bb0097,0x68e60073,0x6ca40012}},	//   _كراي, _skól, vykd, اصيل
  { {0x05e10037,0xe2850014,0x6e2d0028,0x0dcb0001}},	//   _नवंब, ълни, klab, _нуди_
  { {0xdd1d000d,0xe4d50003,0xa5670012,0x7a120035}},	//   _câţi, _لتتب, _أدان, rāto
  { {0x48fc0037,0x7c2100b6,0x61d60009,0x69d90227}},	//   _लेखो_, polr, דורף_, ijwe
  { {0xedca0011,0x20071213,0x8b940048,0x98880009}},	//   ाञ्छ, nini_, _бръч, עָרֵ
  { {0x91fd0039,0x7a381214,0x3ad20012,0xa2d20012}},	//   mpān, líte, _نيوز, _نيوت
  { {0x60c401b3,0xa6e90020,0x6e2d1215,0x24890028}},	//   _trim, _trươ, glab, fram_
  { {0x7a38000f,0x69650003,0x1d070103,0xe0210011}},	// [24c0] níte, _صديق, вети_, यवाद_
  { {0x7ae50051,0x74130012,0x6e2d1216,0x9359004c}},	//   _ühts, لوقا, alab, ерцу_
  { {0xd2590024,0xee3a1044,0x6e2d1217,0xeb970b12}},	//   еці_, _оно_, blab, тих_
  { {0x65690070,0x463a0024,0x99460012,0xe297004c}},	//   jbeh, _ічня_, نَاه, ђач_
  { {0xa3d20044,0x40960047,0xf993000b,0x443e0028}},	//   वाद_, трет, שרד_, ymt_
  { {0x65690029,0x44380052,0xc8650003,0x6b6300fa}},	//   ebeh, _uhr_, اطني, _вкра
  { {0x764b0101,0x644a00c1,0xdd900012,0x59b20011}},	//   _bigy, _rifi, موث_, ज़ार
  { {0x442c0070,0x7ae308b5,0x54b805c8,0x09e30189}},	//   wld_, änte, егия_, _косн
  { {0x41d60037,0x7a38000e,0x09e30048,0xc8080081}},	//   धानस, gíte, _тотн, hởi_
  { {0x442c0036,0x6e2d001e,0x52d8002d,0x2bd20011}},	//   uld_, zlab, емою_, ताधा
  { {0x291e000d,0x442c04db,0x7ec80061,0x764b000e}},	//   ştal_, rld_, _dépô, _figy
  { {0xc27b0093,0x627b0009,0x1ea90012,0x2d9200b0}},	//   ורטי, ונטנ, _سامي_, _øye_
  { {0xcdf7000b,0x2cb8001e,0xbbbc0011,0x7a150034}},	//   _במאי_, ārds_, ्फ़ॉक, kątn
  { {0xaa580012,0x629e1218,0xdb030478,0xa91d0e3d}},	//   _كلتا_, ktpo, _canó, _udže
  { {0xdbdc0028,0xd3780002,0xdceb001e,0x5c37000b}},	//   _ráðl, mać_, _iegā, _שרון_
  { {0xd3780002,0x24891219,0x6e2d0060,0x2007121a}},	//   lać_, tram_, ulab, zini_
  { {0x31790002,0x24f60009,0xdb030034,0x20070060}},	// [24d0] masz_, כֶ֑ם_, _fanó, yini_
  { {0xd3780002,0x4427001a,0x7a360028,0x31790540}},	//   nać_, ôn_, máta, lasz_
  { {0x16220037,0xf09f00c1,0xe28b0066,0x7a380031}},	//   मवार_, ltà_, _účtů_, zíte
  { {0x63bc002a,0xa01b0028,0x24860010,0xa5f9011d}},	//   _earn, fsög, šoma_, _чему_
  { {0xd378003e,0x2007121b,0x9d140024,0x3c390025}},	//   kać_, tini_, _вдяч, lève_
  { {0xe0d00003,0x7a38000e,0xf8070048,0xd3780034}},	//   تزم_, víte, ъчен, jać_
  { {0xed5900e3,0x200700a1,0xd378003e,0x9f510164}},	//   ной_, rini_, dać_, lizó_
  { {0x200700a2,0x26c50027,0xcb120009,0xa87b0012}},	//   sini_, _vrlo_, _הלל_, _يحذر_
  { {0x75f50013,0x2007121c,0x31790002,0xdd11003a}},	//   _náze, pini_, dasz_, _düşm
  { {0xd3780002,0x7a38000e,0xdb180030,0xf1bf068c}},	//   gać_, ríte, _zavé, edá_
  { {0x7a38000f,0x224d007a,0xf09f00c1,0x420a0210}},	//   síte, _kiek_, età_, енно_
  { {0x7a38000e,0xf1bf0017,0x75ea0066,0xc3320009}},	//   píte, gdá_, _výzk, מוי_
  { {0x22470013,0x7c25001b,0xdb010248,0xdb03121d}},	//   ínky_, kohr, delå, _panó
  { {0x25bf000d,0xd3780002,0xe8d60009,0x98160012}},	//   ldul_, cać_, אושר_, ابحا
  { {0x98a50039,0xa3d20037,0x539a000b,0x25bf121e}},	//   ālā_, वास_, _ניקו, odul_
  { {0x63bc0051,0x6609121f,0x229c1220,0x25bf1221}},	//   _sarn, niek, vík_, ndul_
  { {0xa3c80037,0x20ce0028,0xfbb70011,0x61e01110}},	// [24e0] _लोड_, iðið_, _असाम, _roml
  { {0x249f0028,0xb3850012,0x141a0012,0x61e00248}},	//   itum_, لجمه, ريضة_, _soml
  { {0xb05b0163,0x6b59000e,0x66091222,0x6441030f}},	//   nvän, _súgó, kiek, imli
  { {0xd3780002,0xbbe00037,0x4e1a0003,0xa3d20037}},	//   zać_, _पक्क, _ستجد_, वाह_
  { {0x44251223,0x66091224,0xd0d40048,0xdb1a0031}},	//   kol_, diek, ролъ, rdté
  { {0xceba0001,0xa01b0028,0xb4c20037,0x7a0b0002}},	//   ељи_, rsög, ्मी_, nętr
  { {0x66090070,0x386600b6,0x249f0028,0x44251225}},	//   fiek, spor_, etum_, dol_
  { {0xd3780656,0x200a003a,0xb05b006f,0x5d540014}},	//   wać_, hibi_, dvän, шкит
  { {0x7ddc000f,0xc7960003,0xd3780002,0x200a003a}},	//   _kész, _مشاب, tać_, kibi_
  { {0x3a260070,0x31790034,0x34b70009,0xd2860009}},	//   loop_, wasz_, נפים_, ְךָ֙_
  { {0xd378003e,0x16660001,0x0e66035c,0x9e6604fb}},	//   rać_, _свем, _скен, _свед
  { {0xf09f01a2,0x2ca00005,0xd378003e,0x91a00037}},	//   ttà_, ktid_, sać_, ग्लै
  { {0x1bd40048,0xd3780034,0xf1bf1226,0x7afa0031}},	//   _воля, pać_, kláv_, sztt
  { {0xc3560098,0x7a360570,0xf09f0850,0x4ae60012}},	//   _съдъ, ráta, rtà_, _مثبّ
  { {0xa36f0029,0xe7f60037,0xf09f10ac,0xd35b0009}},	//   äčši, ीफ़ा_, stà_, _אדול
  { {0xb4c20037,0x8d770012,0x2bd20011,0x9f5101e3}},	//   ्मू_, طارا, तावा, tizó_
  { {0xdbd20051,0x682d0029,0x7b040010,0x8c570012}},	// [24f0] _füüs, súdi, žutė, ائرا
  { {0x41c30044,0xdce00039,0x9f45004a,0x320b1227}},	//   षयवस, lamē, _yllä_, licy_
  { {0xddd0003a,0x41e7002d,0x4155035c,0x644e1228}},	//   _çeşi, ліда, авес, _dibi
  { {0x320b0002,0x249f0028,0xd6d80024,0x69d50011}},	//   nicy_, ytum_, _сть_, णाधी
  { {0x656d00c6,0x4425003a,0x7a3601bd,0x25190009}},	//   mbah, yol_, kátn, _יוֹא
  { {0xdceb007d,0x66090002,0xa265001a,0xba770012}},	//   _legă, wiek, _buộ, _مارت
  { {0xec360093,0x442503eb,0xa3d20044,0xa2650020}},	//   _כאשר_, vol_, वार_, _cuộ
  { {0x3ebe0028,0x249f0839,0x656d07a4,0xfbb70011}},	//   ætti_, ttum_, nbah, _असहम
  { {0x20ce0065,0x25bf09f6,0x44251229,0x6609122a}},	//   rðið_, rdul_, tol_, riek
  { {0x6609007a,0x7a120039,0x13e60015,0xa3ab0037}},	//   siek, māti, имый_, _कॉम_
  { {0x7a38000f,0xc5d5002d,0x249f05df,0xddc70010}},	//   líta, _віль, stum_, gpjū
  { {0xb05b006f,0x249f0028,0xdb24000e,0x7a88000b}},	//   rvän, ptum_, ásáv, נָתַ
  { {0x7a120039,0xb05b006f,0x91360024,0xa3d50011}},	//   nāti, svän, рхні, हाद_
  { {0x88bd0656,0xb4fa000b,0x34fa0009,0xacfa0009}},	//   _wyśw, _בפני, _בהנד, _שהסכ
  { {0x7ddc000f,0x645b02d1,0x245b001a,0xf746122b}},	//   _rész, lqui, _hêm_, рево
  { {0x8e55007c,0xdd920003,0x96550014,0x05660264}},	//   стрі, تور_, сърч, рван
  { {0x7a12001e,0x8cc80037,0xa3d20037,0x93bc000d}},	// [2500] jāti, ़ियो, वाल_, plăt
  { {0x307b0093,0xdb080066,0x63800066,0x27220029}},	//   _שאינ, ledá, dání, nčné_
  { {0xf1da0037,0xdb150017,0x78bb0269,0x9f5c021e}},	//   _बचान, _razã, _asuv, nivå_
  { {0x60c9122c,0x61e4004a,0xb17b01fb,0xc332000b}},	//   _brem, _joil, lkår, חוב_
  { {0xdb1c0061,0x27220029,0xf1bf000e,0x98a30048}},	//   _maré, kčné_, mlát_, жиче
  { {0x18670001,0x7a3d000e,0x2480001e,0x7644003a}},	//   шаљи_, méte, msim_, lmiy
  { {0xf773000b,0x7a3d122d,0x4444122e,0x69c10011}},	//   חקו_, léte, mm_, _रोकी
  { {0x8066007c,0x7866002d,0x61e4000d,0x7644003a}},	//   _вваж, _вказ, _noil, nmiy
  { {0x91830020,0x2bd20037,0xdceb000d,0x4444005b}},	//   _nếu_, ताला, _regă, om_
  { {0x69c2122f,0x320b0034,0xdb150031,0xdb1c01a0}},	//   ldoe, wicy_, _hazá, _parè
  { {0xec37000b,0xfeba0003,0x869a0021,0xcb570009}},	//   שאיר_, _جاءت_, _штат_, יסיה_
  { {0x44440052,0x2480088c,0xa3d20011,0x7d080035}},	//   hm_, ksim_, वाँ_, tīrī
  { {0x61e4000d,0xd5fb0009,0x98b80148,0xdb150030}},	//   _doil, _בפאר, алят_, _mazá
  { {0x7a31006f,0xbec70035,0xdce00035,0xdb181230}},	//   tåtk, stīš, samē, _haví
  { {0x0cb60044,0x34b60037,0x69c0000d,0x64b60037}},	//   _अनुम, _अनुद, _oame, _अनुश
  { {0xdb050163,0x5d55085b,0xb9990001,0xe5550001}},	//   nehå, скат, _свих_, скањ
  { {0x78a20027,0x656d1231,0xc5390024,0xbddb0025}},	// [2510] jtov, rbah, упах_, _bièr
  { {0x63800013,0xeb930003,0x1da60037,0x03d40024}},	//   vání, تظر_, क्तत, ожую
  { {0xcf920093,0x752f0002,0xd9550012,0x645b01e3}},	//   _צטט_, _wycz, مناخ, zqui
  { {0x9183001a,0xdb181232,0xc3330009,0x752f0034}},	//   _yếu_, _naví, קוף_, _tycz
  { {0xf1bf000e,0x7a3601e9,0x7c28119d,0xa01b0248}},	//   llás_, záto, kodr, bröt
  { {0xafe20015,0x68e40051,0x645d0164,0x60c91233}},	//   зошл, äida, ísim, _vrem
  { {0xc6680046,0x7a381234,0xe7ff0037,0x657b002c}},	//   ашње_, mítn, _उतना_, tauh
  { {0xff18000b,0x95990ec6,0x69c01235,0xc3320009}},	//   יקות_, утку_, _game, _זול_
  { {0x02440012,0x2bb90012,0xadd80009,0x78bb005e}},	//   _ذَكَ, هادة_, שוחח_, _usuv
  { {0x248d1236,0x69c01237,0x245b0018,0x7d090097}},	//   rrem_, _zame, _vêm_, _þesu
  { {0x645b05ab,0x7a150002,0x27220029,0x7bc10051}},	//   squi, jątk, rčné_, rdlu
  { {0x245b0017,0xcb12000b,0x69d80037,0xdb08000e}},	//   _têm_, ללי_, याधी, ülés
  { {0xfd56000b,0x70560003,0x61e40061,0x44440002}},	//   _השני_, إنسا, _voil, ym_
  { {0x7a3d000f,0xe9df0029,0x7bdc0248,0xdb080030}},	//   véte, ajú_, örut, sedá
  { {0xaa95000a,0x22950003,0x52850003,0x33760009}},	//   _العث, _العس, _البك, _העצם_
  { {0x5bb70037,0x7a3d000e,0x6a640003,0x6459002c}},	//   _असुव, téte, _بطول, _kuwi
  { {0x228300a2,0x7644003a,0x78a200f1,0x09f70009}},	// [2520] lık_, rmiy, xtov, _למקם_
  { {0x3ea90002,0x660d005e,0x69c01238,0x7a3d1239}},	//   łaty_, aiak, _same, réte
  { {0xcf57000b,0xdcef001e,0x660d0ff4,0xcb0a0012}},	//   _לבית_, _vecā, biak, ديان_
  { {0x88860003,0x7db60003,0xf1bf000e,0x3ebe0028}},	//   مؤتم, _اصدا, llár_, ættu_
  { {0x17540055,0x69c2123a,0xc19b0009,0x78a2123b}},	//   овля, rdoe, רשני, utov
  { {0xf3e6002d,0xdb010623,0x0eb40011,0x7a120035}},	//   _ужго, belø, ंबलड, mātu
  { {0xadd8123c,0x78a2123d,0x75f50030,0x69c0123e}},	//   имку_, stov, _sáza, _tame
  { {0x9b17000b,0x2283003a,0x21a30001,0x1317000b}},	//   _החלה_, dık_, _нисм, _החלל_
  { {0x7a38000f,0xe4e6002d,0x7a150002,0xb87b000e}},	//   líto, сійн, zątk, nyít
  { {0x8cbb0093,0xe0f70009,0x8fe50012,0x7c280073}},	//   נציק, _הצמח_, _وألم, uodr
  { {0x86c60003,0x02a300b3,0xfe720012,0xe1d90024}},	//   _ديان, прям, _ردا_, адні_
  { {0x1e57000b,0x7a120035,0x7a360031,0xa1940024}},	//   _השאר_, kātu, látj, паюч
  { {0x9f410029,0x628102a1,0x88170012,0x17fb0012}},	//   _dlhý_, aslo, مبسط, هرسة_
  { {0x7a38000e,0x8cb70011,0xf7700012,0xb05b008e}},	//   kíto, ्टरो, فاف_, lväk
  { {0xa3d50037,0xa3d20037,0xa6f8000b,0xa3cc0321}},	//   हार_, वाई_, בִּי, _शोध_
  { {0xbd890003,0x64630028,0x7a38000e,0xf1bf000e}},	//   شنطن_, _óvið, díto, rlás_
  { {0xf1d60037,0xc4b60037,0x94770012,0x4c780009}},	// [2530] धारन, _अनोख, إدرا, שָֽׁ
  { {0x660d11d7,0x18780009,0x41a50011,0xa01b0248}},	//   siak, _העזר_, ग्रस, rrös
  { {0x1dc40037,0x765a0010,0x7a380031,0xee3f0081}},	//   _लोकत, _nuty, gíto, _thý_
  { {0xd6e8000b,0x5ee8000b,0xa4d5002d,0xdb010262}},	//   _הַשָ, _הַשְ, _домі, relø
  { {0x7a380066,0xdb010260,0x28a7003c,0x22830060}},	//   mítl, selø, сшег, zık_
  { {0x907c000b,0xf7710012,0x6281123f,0x26cc001b}},	//   רטגי, ذات_, yslo, _brdo_
  { {0xa2940024,0xfe450055,0xa3dc0011,0xdc3a0009}},	//   _нарі, онко, डान_, _כעשר
  { {0x7d09014d,0xdb0a0052,0x26c7009b,0x387e0002}},	//   _þess, _dafü, rvno_, ątrz_
  { {0xa3d50044,0xada80003,0x1fa71240,0x3869016d}},	//   हाल_, صديق_, _грег, _ntar_
  { {0x228300a2,0x98170012,0x10170012,0xd2a9003c}},	//   tık_, _ابرا, _ابرد, акое_
  { {0x60cd00a1,0xbf15000a,0xe9ff001a,0x9f050003}},	//   _aram, _بواب, _nhẫn_, _بوضو
  { {0x6459002c,0x75f5014a,0xf7690009,0xd9f90011}},	//   _tuwi, _zázn, _יק_, ंसित_
  { {0x91bf0020,0x89360003,0x24190015,0x01360012}},	//   _chủ_, تعدا, _коды_, تعدد
  { {0xcb69002d,0x7a12001e,0xf7720003,0xdd010066}},	//   _таке_, vātu, باح_, štěv
  { {0x26cc084c,0x7bc3000d,0x65c60014,0x4e890009}},	//   ído_, _ianu, обва, יָּ֣
  { {0x7bd5008b,0x60cd1241,0xc1ba0012,0x61fd0032}},	//   _anzu, _fram, _ضابط_, chsl
  { {0x7bc30f5f,0x69d601e3,0x9f640060,0xdca31193}},	// [2540] _kanu, _inye, _ütçe_, мати
  { {0x6026007c,0x9f60004a,0x2d8b0034,0x7a381242}},	//   _єдна, ärät_, ócej_, títo
  { {0x0576000a,0x75f51243,0xda650003,0x34b60037}},	//   _واحد, _názo, كاني, _अन्द
  { {0xa3d50037,0xcb120009,0x69c61244,0xdb1a017a}},	//   हाँ_, ולב_, ndke, ndtá
  { {0x7a38000f,0x2db7000b,0x63660066,0x67d40001}},	//   síto, _ולכן_, nční, золу
  { {0x69c40154,0xbe8a022a,0x7a381245,0x03b60012}},	//   _laie, асие_, píto, _بإحد
  { {0xf1ca0044,0x59ca0037,0x38a40c60,0xa0070012}},	//   ियान, ियार, hör_, تقول_
  { {0x95ca0046,0x38a4012b,0xd6570009,0x7de60012}},	//   рука_, kör_, חיקת_, تستم
  { {0x75fc000f,0xa3d50037,0xe9ff001a,0x6fb60003}},	//   _néze, हां_, _hiến_, _ومرا
  { {0xe9ff0020,0x03f80001,0xe6c60012,0x3f9e0030}},	//   _kiến_, сној_, _وتضي, _uctu_
  { {0x80c20037,0x0bb70009,0xc43b0009,0x01d90012}},	//   लिके, חלים_, שתיי, مودع_
  { {0x91bf001a,0x38a4006f,0xe9ff001a,0x61e21246}},	//   _phủ_, för_, _miến_, njol
  { {0x38a4006f,0x32f5001a,0x7a3d0025,0x99a50031}},	//   gör_, áy_, géta, ítők_
  { {0xf0930009,0x7bc31247,0xe4e90012,0xe9ff0081}},	//   ונש_, _ganu, _دعمه_, _phẫn_
  { {0x22630029,0x98ac001e,0xe7300003,0xa6f80009}},	//   ľské_, ādā_, نصف_, זִּי
  { {0x02fb000b,0x91bf001a,0x2d5804b3,0x60cd0f88}},	//   _כלומ, _thủ_, жить_, _tram
  { {0x8ccd0044,0xa80200a2,0xe534002d,0x29020002}},	// [2550] तियो, şıyo, деть, czka_
  { {0x442c0101,0x69a70044,0xe9ff0020,0xd7f10003}},	//   nod_, ट्री, _biến_, _أكد_
  { {0x201100a2,0x77ba000b,0x67ba000b,0x6448003a}},	//   mizi_, _המתח, _המתק, imdi
  { {0x2486001c,0x5bb70796,0x7a38000f,0x2bb70037}},	//   _ovom_, _अस्व, lítj, _अस्थ
  { {0x8dda000b,0x4dda0009,0x442c1248,0x3cf40011}},	//   _הקרק, _החרו, kod_, इनों_
  { {0x201100a1,0xe808002d,0xcc76000b,0x7bd50052}},	//   nizi_, онід_, _מעשה_, _unzu
  { {0xfd4c0020,0xf1c60037,0x38a4000e,0x6e950012}},	//   _triể, _रोकन, zör_, ألعا
  { {0x3d070011,0x61e20034,0x9f470064,0x11d70012}},	//   िछले_, cjol, chný_, _بتسد
  { {0x5f0d0037,0x7a38000e,0x79c80012,0xfd110012}},	//   _डेस्_, kítj, _بوقف_, عجب_
  { {0x1c420015,0x7a361249,0x73050048,0x2011001b}},	//   нным, máti, зпоз, jizi_
  { {0x44390039,0x69c4124a,0xda65002d,0xf412000b}},	//   ēs_, _paie, явни, תפי_
  { {0xa3ab0044,0x38a4124b,0x657d124c,0x20110035}},	//   क्त_, tör_, _nesh, eizi_
  { {0x645d007a,0x455a0093,0x8d5a000b,0xa01b0052}},	//   _nusi, _הכנס, _הכני, rsön
  { {0x7fd5007c,0x764900a2,0xa3ab0037,0x7a3d08c5}},	//   місі, lmey, _कॉल_, réta
  { {0x61fb0005,0xdee6002d,0x38a4003a,0x661b0029}},	//   _olul, чови, sör_, onuk
  { {0x661b0006,0x764900a2,0x6455001e,0x645d1019}},	//   nnuk, nmey, _aizi, _busi
  { {0xdb0a0065,0x6564003a,0x6455003a,0x819b000b}},	// [2560] _hafð, rcih, _bizi, _הספצ
  { {0x60090010,0x1d190024,0xd40a0012,0x64550030}},	//   yžmi, іють_, حترم_, _cizi
  { {0xab69000a,0x7a38000e,0x7649003a,0x6455124d}},	//   تحقق_, sítm, kmey, _dizi
  { {0xdb1c0017,0xaa570003,0xa3cc0011,0xb0c70011}},	//   _parâ, سلها_, _शोर_, लिंग
  { {0x61e900bd,0x442c002c,0x64480028,0xf0f80011}},	//   _doel, yod_, ymdi, ्छेद_
  { {0xe9ff0020,0x6d3b000b,0x6d59002c,0xdb0e0066}},	//   _tiến_, _לתכנ, _agwa, _zabý
  { {0x24860027,0x27e5000e,0xe29700ac,0x8c430487}},	//   _svom_, ölni_, _нар_, _чере
  { {0xceb30093,0xfb1b0009,0x15e70011,0x225c0030}},	//   גיה_, _הולמ, टॉलर_, ívku_
  { {0xc059002d,0x29020248,0x89db0009,0x62830035}},	//   _діє_, _åka_, _פחמי, šnot
  { {0xa2f40511,0x70fb0009,0xbf650012,0x7d000097}},	//   дпоч, _ההמח, _قدمو, _ýmsu
  { {0xdfa50003,0x6448001e,0x67a50012,0x7a380031}},	//   _تحقي, rmdi, _تحقق, vítj
  { {0xbbc80037,0x442c124e,0xbef70009,0xd2570024}},	//   रयुक, sod_, _מצבו_, яць_
  { {0x442c001c,0x7a380031,0xf5ab0009,0x50670357}},	//   pod_, títj, _ה֑וּ, ятна
  { {0x14d7000b,0x7d04084b,0x1cbb0009,0xccf30009}},	//   _מודל_, dzis, _למדע, _רכס_
  { {0x645d039c,0xa3e00044,0xc43b000b,0x7bd80184}},	//   _susi, थान_, _התגי, _invu
  { {0x645500a2,0x7a38000f,0xa4d5002d,0x753d0002}},	//   _sizi, sítj, мобі, ższe
  { {0x7d040010,0x99450012,0x27180011,0x7a38124f}},	// [2570] gzis, _تَظه, धपुर_, míth
  { {0x78fc000b,0xc954000b,0x7a38000e,0xa87c000b}},	//   _לפחו, _אמפ_, líth, _האזר
  { {0xdb1c03eb,0x3f830027,0x64551250,0x63ba1251}},	//   _carà, maju_, _vizi, ietn
  { {0x7a38000f,0x7aea006f,0x63ba000e,0x39150021}},	//   níth, äfta, hetn, ммер
  { {0x645d083c,0xf3f30003,0x48ab05f0,0x61e90227}},	//   _uusi, _كأس_, стем_, _voel
  { {0x63ba00eb,0x2ca90248,0xaca30081,0x629a1252}},	//   jetn, mtad_, _liịc, kuto
  { {0x3e7a0039,0x7649003a,0x2fc50989,0x2ca911ec}},	//   gūt_, tmey, _valg_, ltad_
  { {0x9b440003,0x629a1253,0xceb4000b,0x201c01a0}},	//   _سنقو, duto, תיק_, anvi_
  { {0x764900a2,0xdb170061,0x3f830027,0x1c450024}},	//   rmey, dexé, kaju_, мним
  { {0x9f630006,0x3e7a0039,0xa3c20037,0x4374002d}},	//   ävät_, būt_, ्यय_, нуют
  { {0x3f830027,0x7a3d0107,0xfc460066,0x0cba0011}},	//   daju_, rétn, _říct_, _उन्म
  { {0xcf890093,0x7a3811e7,0x7a12001e,0x2ca91254}},	//   _כט_, gíth, gātp, ktad_
  { {0xb4bc0044,0x7a3d000e,0x850c0037,0xa3c20037}},	//   _आने_, métl, _सेंट_, ्यम_
  { {0xfd100003,0x1c44002d,0x63ba001b,0x344b06bd}},	//   _حجم_, _знім, cetn, _учен_
  { {0xe9ff001a,0x67ef0058,0xceb20009,0xa3d10011}},	//   _nhắn_, _højs, ֣ין_, वयन_
  { {0xa3ab0044,0xceb20093,0xee3a002d,0xda7a0009}},	//   क्स_, כיל_, іна_, _ונקר
  { {0x3f830027,0xbc6a0012,0x25ad0032,0x7a380030}},	// [2580] baju_, زمان_, ifel_, sítk
  { {0xeafa0003,0x60c4003a,0xdb1c0054,0x7b160003}},	//   يرات_, _isim, _parà, وظائ
  { {0xdb1c000f,0xe9ff001a,0xe7db000b,0x91e60686}},	//   _bará, _chắn_, _וקיש, може
  { {0x63ba1255,0xdb1c052e,0xf9920012,0x25ad02a2}},	//   zetn, _cará, ئبا_, jfel_
  { {0x3952004a,0x50ba0012,0x55bb0009,0xe8940198}},	//   äys_, تداد_, _ומכו, халь
  { {0x7a38000e,0x7a361007,0xbfaa0024,0xdce00035}},	//   zíth, mátu, ітле_, samī
  { {0xa3c80044,0xd6d00003,0x97c50012,0x1dda0011}},	//   _लोग_, اقب_, عتهم, भालत
  { {0xddea0003,0xef180035,0x25a01256,0x386d1257}},	//   ترته_, _ceļa_, ngil_, ţeri_
  { {0x7a12001e,0xfe370009,0x91fd0035,0x7a380031}},	//   vātp, ורקי_, kpār, víth
  { {0xb05b027e,0xdb1c1258,0x46b60012,0x2d9f0730}},	//   hwäc, _zará, _يحاس, ague_
  { {0x3f83001c,0x629a004a,0xe2150015,0x63ba1259}},	//   vaju_, uuto, емны, retn
  { {0xdde3000d,0x63ba081f,0x629a125a,0xc05b0024}},	//   ărţi, setn, ruto, жів_
  { {0xc5f30093,0xd1260003,0x7a38125b,0x3f830e6f}},	//   _בדף_, ام_, ríth, taju_
  { {0xbbc80044,0xa01b0163,0x67ef00c5,0x7a38000f}},	//   रयोक, msök, _højr, síth
  { {0x3f83001c,0x60c402bd,0xa01b006f,0x7a38000e}},	//   raju_, _esim, lsök, píth
  { {0x7c3a03ce,0x38600025,0xdcc80081,0x25a0020d}},	//   lltr, _fuir_, _kỉ_, ggil_
  { {0xe81f0037,0xb955002d,0xd847002d,0x2d840010}},	// [2590] _बदला_, _явищ, _охоп, iame_
  { {0x41dd0037,0x9f45000e,0x2c64006f,0xe8d6000b}},	//   यावस, óló_, _död_, _נותר_
  { {0x92590047,0xe298002d,0xa3ab0037,0x7bc70051}},	//   чает_, дає_, क्ष_, _vaju
  { {0x2d84007a,0xa01b006f,0x64580c63,0x09e40024}},	//   jame_, ksök, _livi, коєн
  { {0xb068000a,0xdb1c000e,0x58d90024,0x25ad0248}},	//   وصول_, _vará, яддя_, vfel_
  { {0x764d003a,0x07a20014,0x7a3601cf,0xd0f80009}},	//   lmay, гашн, látt, ומדת_
  { {0x25ad007d,0xa01b006f,0x9f450054,0x75f5000e}},	//   tfel_, esök, _allò_, _házi
  { {0xcf580093,0x764d00a2,0xa3ab0037,0x6b8500b6}},	//   ובות_, nmay, क्र_, lahg
  { {0x2489125c,0x25ad02f1,0xa01b0248,0x9e4c0009}},	//   nsam_, rfel_, gsök, חֲזִ
  { {0x3ec40006,0x7d1a000b,0x25ad006f,0x13090015}},	//   ästä_, לֵיה, sfel_, зной_
  { {0xe7e30037,0xa91d009b,0x764d003a,0x98140003}},	//   खाना_, _deže, kmay, _شبكا
  { {0xc7a90093,0x2d840036,0x69cb125d,0xa01b0248}},	//   _לב_, came_, ndge, bsök
  { {0xe9ff0020,0x7e6100bd,0xe8f70247,0xa01b0031}},	//   _nhận_, _hulp, еля_, csök
  { {0x291e000d,0x2c64006f,0x6458125e,0x6e3b0097}},	//   ăta_, _röd_, _givi, llub
  { {0xa3dc0037,0xabfa0009,0x24460025,0xa3c80011}},	//   डार_, _מהסר, nôme_, _लोट_
  { {0xa2c30044,0x91fd001e,0x7a38000e,0x64580052}},	//   रबन्, spār, lítv, _zivi
  { {0xdd8f0003,0x908a0003,0x28bf0011,0xf50a0048}},	// [25a0] صول_, _عندك_, _शैलि, чнал_
  { {0x61ed00bd,0x75fc000e,0x443a0070,0x7a380031}},	//   _zoal, _nézn, ulp_, nítv
  { {0xdb1c0017,0x877b0009,0x0f7b01b0,0x25f20011}},	//   _març, _מאיי, _מריל, ीसदी_
  { {0xeac9001a,0xdb0f0030,0x30a601c6,0xa5bb0097}},	//   _mẹ_, ádát, еркв, _hjón
  { {0xb05b006f,0x2d84125f,0x7a38000e,0x2be00011}},	//   lvär, vame_, kítv, नादा
  { {0xe7e30037,0x3c340248,0xd12f0012,0x69db1260}},	//   खाया_, rävs_, حمه_, _enue
  { {0x4df40037,0x2d841261,0x75f801bd,0xf7730009}},	//   _इकाई_, tame_, _nízk, נקה_
  { {0xb5aa000a,0xc1ca0037,0x69e20030,0x28c70011}},	//   سابك_, ियोग, áteč, लिखि
  { {0x60c4003a,0x28160012,0x7986016d,0x64bc0011}},	//   çimd, _كورس, dakw, ्टेश
  { {0xa01b0163,0xdb1a024a,0x61ed1118,0x2d8f1262}},	//   rsök, leté, _soal, _edge_
  { {0xa01b006f,0x7a36000e,0x764d003a,0xed5902a1}},	//   ssök, játs, ymay, veže_
  { {0x2d8209ea,0xdb1a000e,0xdcc8001a,0xe919002d}},	//   _neke_, neté, _tỉ_, домі_
  { {0xa3c20044,0x984b0014,0x4e170009,0xf1d60011}},	//   ्या_, зява_, _אחאב_, धाजन
  { {0x2bd70321,0xdb1c0f14,0xdb1a0025,0x629e1263}},	//   _भोपा, _garç, heté, kupo
  { {0x764d00a2,0xdb010032,0xed590412,0x22660034}},	//   tmay, gflä, reže_, ótką_
  { {0xe9ff001a,0x433b000b,0xbdd50014,0xbddb0061}},	//   _phận_, _מעוב, ъобщ, _thèm
  { {0xdbf9003e,0xdb1a000f,0x764d003a,0xe7870001}},	// [25b0] _głów, deté, rmay, _пуно
  { {0xb6030029,0x2418002d,0xd91c000b,0x1368004c}},	//   čšin, нією_, _מוחל, ешци_
  { {0x764d003a,0x91bf001a,0xa01b000e,0x24890c0b}},	//   pmay, _phù_, kröz, ssam_
  { {0xdb1a000f,0x6149001e,0xe9ff001a,0x66041264}},	//   geté, _tūlī, _thận_, chik
  { {0x28f8002d,0x91bf001a,0xa3cc0011,0x7a3d0031}},	//   нець_, _chú_, _शोक_, tétj
  { {0x7e611265,0xd8b80012,0x95160009,0xd942004c}},	//   _pulp, عدنا_, _יקרא_, јеши
  { {0xdb1a000e,0xcf880012,0xa01b0032,0x8e490012}},	//   beté, رضون_, rsöh, ولتك_
  { {0xed590015,0xb6060027,0x7ae3004a,0x9758000b}},	//   мой_, ješć, äntu, עיהו_
  { {0x5dd40015,0xdb1c003a,0x61f6003a,0xf1bf0029}},	//   ующу, _parç, öyle, deá_
  { {0x75f5022d,0x6e3b08a1,0x7e611266,0x44331267}},	//   _názv, slub, _tulp, nox_
  { {0x4421001a,0x49ba0003,0x3f870864,0xfbd20009}},	//   inh_, واحد_, manu_, בתי_
  { {0x7a38000f,0xa5bb0028,0xc332000b,0x3f850028}},	//   sítv, _sjón, שוט_, ðlun_
  { {0xdb01000e,0x7a38000e,0xe44e0048,0x6d5c0030}},	//   jelö, pítv, _вж_, ěrat
  { {0xdb1a0272,0x9d1a0009,0x35a70011,0x889a0009}},	//   zeté, _קוסט, _गाड़, ובשי
  { {0x0eb90015,0xb05b006f,0x2cad1268,0xf7720009}},	//   нуты_, tvär, lted_, שקל_
  { {0xc692000b,0xdb010052,0x7a360bb3,0xdd920012}},	//   יאל_, rflä, ráts, شوط_
  { {0xdb1a000f,0x2cad1269,0xd24f0003,0xb05b006f}},	// [25c0] veté, nted_, _بني_, rvär
  { {0x0e660146,0x395f00b6,0xb05b02fe,0x629e126a}},	//   _икон, _agus_, svär, tupo
  { {0x6b8300ec,0x9ad5002d,0xdb1a000e,0x2cad0051}},	//   _meng, люці, teté, hted_
  { {0x4421001a,0x2018126b,0xb05b0032,0x91bf0081}},	//   anh_, liri_, nwän, _phú_
  { {0xdb1a000f,0x186705fb,0x629e126c,0x8b660012}},	//   reté, вачи_, supo, _لازم
  { {0xe9ff0020,0xdfd00003,0x91030001,0x6d460238}},	//   _phản_, صيب_, рпље, _izka
  { {0xe7e30037,0x52990014,0xcac7011d,0xa2e3026d}},	//   खाता_, _пътя_, _игре_, _корд
  { {0x2cad002a,0x91bf0081,0xceb30009,0xb8960012}},	//   fted_, _thú_, ׁיו_, _للرع
  { {0x2018044f,0xe4e6002d,0x236700eb,0x645c126d}},	//   kiri_, тійн, žnje_, _kiri
  { {0x6b8311d3,0x99800073,0x7a3d004f,0x2249126e}},	//   _ceng, _okių_, méti, _shak_
  { {0x6b8300ec,0x2cad0036,0x201800b6,0xf2c30014}},	//   _deng, ated_, diri_, асян
  { {0xc333015a,0x2ca00051,0xee290012,0xdb150042}},	//   יות_, kuid_, _كأنه_, _nazý
  { {0x2cad0036,0x6b830065,0x7d090002,0x7a38000e}},	//   cted_, _feng, czes, líts
  { {0xf7700003,0xdb170017,0x2ca00070,0xc0510009}},	//   قاف_, nexã, duid_, ֶ֖ם_
  { {0x0d670014,0x7a38000e,0xbe880015,0x8bbb0009}},	//   възм, níts, ксте_, _חזות
  { {0xd357000b,0x645c03ab,0x443e126f,0x6b831270}},	//   _בשוק_, _airi, llt_, _zeng
  { {0x645c00a2,0x6abb0011,0xe4a70048,0x6e350031}},	// [25d0] _biri, ईब्र, ърво, _ízbe
  { {0x91a00020,0x93940003,0x33741271,0x2bbb0012}},	//   _thị_, لجما, игур, بارة_
  { {0x49750001,0x940b0009,0xfb150012,0x7d0900b8}},	//   глес, וּאֵ, دواج, zzes
  { {0xa294007c,0x443e008b,0x5efa000b,0x0a94002d}},	//   раці, hlt_, _נפרד, рацю
  { {0x5d9a000b,0x61fd0010,0xa91d0029,0x69cd0051}},	//   _אברה, iksl, _beža, _maae
  { {0x645c00a2,0x443e000e,0x66021272,0xe50c0011}},	//   _giri, jlt_, _alok, _सेटि_
  { {0x7a38000f,0xb659002d,0x8ea40012,0x099b0012}},	//   gíts, нших_, لصين, _يضرب_
  { {0x6b831273,0x7a3d1274,0x2cad1275,0x3f87001b}},	//   _seng, béti, tted_, sanu_
  { {0x6b831276,0x3f871277,0x89370012,0x2cad0132}},	//   _peng, panu_, _شعرا, uted_
  { {0x2cad0036,0xdce40039,0x6602004a,0x753d05a8}},	//   rted_, nciā, _elok, _mysz
  { {0x66020065,0x7d0910ff,0xddda000e,0x6b831278}},	//   _flok, szes, _ettő, _veng
  { {0x2cad002a,0x60d60034,0x60c90192,0x8a06004c}},	//   pted_, _prym, _ksem, узме
  { {0x25e00044,0x657b00c6,0x6ba40028,0x6b831279}},	//   कारी_, mbuh, útgá, _teng
  { {0x7c92000a,0x04920003,0x66020002,0xdc9a0009}},	//   _الوص, _الوح, _zlok, _ניצל
  { {0x7f19002d,0x44270070,0xa8560009,0x3f85005e}},	//   віту_, _ijn_, טישה_, _melu_
  { {0x2ca00051,0xd6cf002d,0xd7570012,0x7c3e0227}},	//   tuid_, стi_, طلقت_, wlpr
  { {0x765d0a60,0x7a380031,0x75f50031,0x271f0011}},	// [25e0] _disy, zíts, _házs, यपुर_
  { {0x69c9001e,0x1bfc0011,0x307b0009,0x6d460030}},	//   īmeņ, एसएल_, _ראינ, _vzka
  { {0xda65000a,0x657b002c,0x60c90954,0x1c390024}},	//   لاني, kbuh, _asem, тять_
  { {0x6e9b000b,0xd259002d,0x7a38000e,0x7e9b000b}},	//   _אבטח, вці_, víts, _אסטו
  { {0x7bc10df5,0xddc40034,0x248d0dac,0x2ca0127a}},	//   kelu, rmiń, jsem_, quid_
  { {0x3f850eb4,0x7a3d0061,0x3eca0001,0x31570009}},	//   _celu_, réti, ећим_, אינן_
  { {0x60c9127b,0xdcfd001e,0x3f85017b,0x25e00011}},	//   _esem, _iesā, _delu_, काली_
  { {0x443e0480,0x52b20037,0x7a3d0025,0x657b020d}},	//   wlt_, ीबीस, péti, gbuh
  { {0xa0c90003,0xa91d0d6c,0x7a38127c,0x248d000e}},	//   _لذلك_, _teža, síts, gsem_
  { {0x78a201a2,0x43940001,0x03f80001,0x20070eea}},	//   muov, јанс, тној_, chni_
  { {0x7bce0101,0x8c37000b,0x6b880058,0x3f850097}},	//   _mabu, רטיס_, radg, ðlum_
  { {0xccf90002,0xcb130009,0xeac70009,0x6b880040}},	//   byś_, מלת_, נִי֙_, sadg
  { {0x7bc10fb3,0x9f4b0031,0x61fd127d,0x2aae0064}},	//   belu, ülön_, rksl, hýb_
  { {0xb8ed0037,0x7bce127e,0x753d0034,0xdcfd0035}},	//   _रन_, _nabu, _rysz, _nesā
  { {0x7a28003a,0xf3f9000d,0x1bfb0009,0x68f90034}},	//   sıta, _îţi_, _אלגב, zywd
  { {0xe4e7002d,0x7bce002c,0xe6640434,0xd4e70055}},	//   лізн, _aabu, стро, люзи
  { {0xdbd10051,0x69c2038e,0x78270003,0x7c15002d}},	// [25f0] _tüüb, deoe, _معدل, адає
  { {0xa91d0029,0x3f15002d,0x59dd0011,0x26e40011}},	//   _bežn, _вдос, याकर, _कपूर_
  { {0x753d003e,0xdb150164,0xdce4001e,0xd7f1001a}},	//   _wysz, _razó, rciā, _rõ_
  { {0x95640014,0x2a980012,0xd3370009,0x3f85001b}},	//   _гърд, ائلة_, נראה_, _selu_
  { {0x417c0009,0x7bce127f,0x225906dd,0xc4c600ae}},	//   תנדב, _fabu, írky_, _بْ_
  { {0xb8cd0044,0xdfd10003,0xa6950001,0x60c9009b}},	//   _कम_, زيع_, ариј, _vsem
  { {0xc7f80009,0x7bc11280,0xdd2f0030,0x2c690064}},	//   רזות_, velu, věřo, _súd_
  { {0x8cb50083,0x8645004c,0xb5fb0031,0x7bce1281}},	//   асоч, јниж, _hiáb, _zabu
  { {0xb8820066,0xdb050052,0x55bc0009,0x4462003c}},	//   říze, gehö, תמחו, овыв
  { {0x68f6004a,0x248d1282,0xa01b008e,0x76401283}},	//   äyde, rsem_, isös, almy
  { {0x16050044,0xbb4500b3,0x248d1284,0x3a260109}},	//   रसार_, ренк, ssem_, имог
  { {0xa06a0046,0xc1060003,0x186a00be,0xf8a70003}},	//   кама_, لوجي, ками_, ية_
  { {0x3949003e,0x53d00011,0x3eb10032,0x95c40012}},	//   _czas_, _थोकश, etzt_, _دينه
  { {0x7d0d0002,0x661b03ec,0x7afa0192,0xbd440012}},	//   dzas, liuk, bytt, _انهي
  { {0x3f8a0027,0xe73a00f5,0x539a0009,0x7a3d0031}},	//   rabu_, тев_, _סיקו, vétv
  { {0x2aba0009,0x75f503a7,0x7bce1285,0x64411286}},	//   _ימצא, _zázr, _sabu, llli
  { {0xd4670098,0xa3d10037,0xddd5000e,0x9a3b0009}},	// [2600] иите_, वयं_, gszű, _שתפק
  { {0x9b850003,0x60c90060,0x9f4c0031,0x4f960357}},	//   مؤمن, çeme, ódó_, _триу
  { {0x4f9b000b,0xbf9b0009,0x9f9b0009,0xa79b0009}},	//   _בביצ, _בייש, _בסיפ, _בשיח
  { {0xdb18015b,0xe8fa096e,0xf3e90009,0xbcfb0031}},	//   _navý, кле_, וף_, _igén
  { {0x7d0d0002,0xdb1a000e,0x8d63002d,0x26c70034}},	//   czas, vetí, _євре, ewno_
  { {0x4813002d,0x66090051,0x7afa004a,0xd00f0012}},	//   оміс, ehek, yytt, ولن_
  { {0xddc4001e,0x29000029,0x42d50024,0x07a3004c}},	//   rmiņ, šia_, _літу, цајн
  { {0xa01b0163,0x644103d5,0x9757000b,0x66f70009}},	//   nsör, elli, סיקו_, ימצא_
  { {0x186a002d,0x4fa6002d,0xa06a0021,0xda5b0009}},	//   _рази_, _визв, _раза_, _יכלל
  { {0x34b70093,0xf3660046,0xe9ff0020,0x6908003a}},	//   ספים_, штин, _phần_, ırdı
  { {0x8aa300be,0x5a350014,0xa3c50037,0x32660001}},	//   оряд, йнот, उज़_, јтов
  { {0xc27b000b,0xc984035c,0x6df30012,0x4efb0009}},	//   כרטי, жури, _وكلا, _שהאו
  { {0x1bd40098,0x7afa004a,0x6b4f000e,0xdb1a000e}},	//   _голя, sytt, tógé, ldtü
  { {0xe9ff001a,0xfe730012,0xe3af0012,0xd918003c}},	//   _thần_, قدر_, _قرى_, рью_
  { {0x22940003,0xc6680001,0x3a260070,0xa3e00011}},	//   _البس, иште_, knop_, थाई_
  { {0x7a28003a,0xd35b0009,0x735b0009,0x6a140012}},	//   nıtl, _בדול, _בכוח, _وبير
  { {0xf3670014,0x24f80015,0xb4780009,0x7c8709f8}},	// [2610] атен, анты_, רָֽי, рубе
  { {0x60cd1287,0x201c013a,0x04c80012,0x7d0d0034}},	//   _isam, jivi_, ؤولي_, rzas
  { {0x93190003,0x8c3d003a,0xd4040024,0x9e350048}},	//   دقاء_, nuşa, цяти, _генч
  { {0xa2d70037,0x7a3d10b3,0x753d0031,0x442a1288}},	//   यित्, pétu, üszk, _ejb_
  { {0x83870047,0xe9ff0020,0x70190024,0x64411289}},	//   _выбе, _nhấn_, лікт_, ylli
  { {0xed560009,0xd0980012,0x25a9005e,0x8d5a0009}},	//   _לברר_, شئها_, lgal_, _תכשי
  { {0x386906db,0xa294002d,0xaa9406bd,0x67bc0009}},	//   _luar_, _марі, _мирч, דמוק
  { {0xc4851271,0x4c85057e,0xf1cf0011,0x7a280060}},	//   блик, блив, _सोचन, gıtl
  { {0x6609008e,0xe9ff0081,0x61ed008e,0xac960012}},	//   rhek, _chấn_, öalu, منيا_
  { {0xf7700003,0x321d0002,0xf09f10ac,0x9ff40012}},	//   _قام_, liwy_, drà_, _وألص
  { {0x7c220061,0xd7f806e6,0x3946001e,0xc5d50024}},	//   éori, _тут_, _šos_, _гіль
  { {0x4dd40012,0x8a390048,0xf7690009,0x60db128a}},	//   _وتنس, ияят_, _טק_, _krum
  { {0x2a600051,0x89da000b,0x89360012,0x80260012}},	//   _viib_, אחרי, إعجا, مرسم
  { {0x43850003,0x249f0058,0xa9360009,0xbb850012}},	//   _الثق, mrum_, מטרה_, _الثي
  { {0x2bb80003,0xd1380002,0x60cd128b,0xf09f128c}},	//   _خانة_, łą_, _esam, arà_
  { {0x05660014,0x629c001e,0xf09f0054,0x201c0604}},	//   сван, šroc, brà_, zivi_
  { {0x4d4a0001,0x7a3d0028,0x249f006f,0x61e40160}},	// [2620] упан_, rétt, nrum_, _inil
  { {0x69c6060f,0x25a9007b,0x249f0097,0xdb1a0482}},	//   leke, agal_, irum_, letá
  { {0x7a28003a,0x69c60070,0x8c1a000b,0x7ed50024}},	//   yıtl, oeke, נועי, _діяч
  { {0xdb07000e,0xc332000b,0x994a0012,0xb05b0032}},	//   émár, הוב_, هلال_, ewäh
  { {0x201c01a2,0x10a3128d,0x60db0bb5,0xadd70009}},	//   tivi_, зичн, _crum, _הוכח_
  { {0xdb1e000f,0x2bb70066,0x7644003a,0x7a3d122d}},	//   lepí, _věcí_, lliy, nétr
  { {0x2d800002,0xdb0e004a,0x201c0dce,0x1a780009}},	//   obie_, äjän, rivi_, _כְּמ
  { {0xe5c60015,0x69c6004a,0x443c0028,0x5c98010c}},	//   сско, jeke, _skv_, акия_
  { {0x8cdb0037,0x69c6128e,0xdce40034,0x4444128f}},	//   नियो, deke, bcią, ol_
  { {0x600b003a,0x7a28003a,0xf09f00c1,0xda7a118d}},	//   _küme, sıtl, vrà_, лям_
  { {0x76441147,0x61f61013,0xc43b0009,0x643b0009}},	//   kliy, _boyl, רתיי, רעינ
  { {0x4444008b,0xf09f1290,0x69c61291,0x44220031}},	//   hl_, trà_, geke, ők_
  { {0x63bc02a1,0x443a1292,0xf09f01a0,0xfe370009}},	//   _obrn, kop_, urà_, _פרדי_
  { {0x3e6e0013,0xf09f01a2,0xd6c60003,0xa8ab000b}},	//   _být_, rrà_, وق_, נֹכִ
  { {0x8c1b0093,0x2bb7000b,0x44440066,0x6298000e}},	//   _תווי, _הפוך_, dl_, ávol
  { {0x5eb4003c,0xdce40034,0x60cd016d,0x69c61293}},	//   яйст, zcią, _tsam, ceke
  { {0x60c400a2,0x7bc50359,0xa2d00011,0x94190048}},	// [2630] çiml, tehu, धिक्, ажат_
  { {0x4378000b,0x7644003a,0xbddb0061,0xf3670ba0}},	//   שְּׁ, aliy, _chèr, стан
  { {0x2ca00005,0x76440060,0x9fbd0034,0xb9950012}},	//   arid_, bliy, złów_, قلاب
  { {0xddc1007d,0x81a70003,0x314b0009,0x7c3a1294}},	//   _mulţ, إحال, ְתַּ, hotr
  { {0xb05b0029,0x75fc0031,0x378900b5,0xf9940009}},	//   dväz, _jézu, абло_, פרס_
  { {0xd0060014,0x69c6110c,0xbddb0025,0x7c3a001b}},	//   жеше_, zeke, _thès, jotr
  { {0x3209003a,0x69c6000e,0x57fc0009,0xb05b0032}},	//   _olay_, yeke, רלוו, rwäh
  { {0xb05b0052,0x7c281295,0xc3320009,0x72050012}},	//   swäh, endr, _חול_, _بورم
  { {0x69c6000e,0xdb1e000d,0xd8740012,0x37c50012}},	//   veke, cepâ, _فالب, _ويرف
  { {0x0c360003,0x32090115,0x24520012,0x61e41296}},	//   يكية_, _alay_, ونيس, _snil
  { {0xdcfb0010,0x2d800002,0x69c61297,0x8c1a0009}},	//   mbuč, ybie_, teke, שותי
  { {0x3ea70054,0xcad6000b,0x6f0b003a,0x2d8b0027}},	//   munt_, קורת_, ımcı, _nece_
  { {0xa06a0046,0x44440066,0x443a002c,0x7c460028}},	//   рага_, yl_, yop_, ðurö
  { {0x69c6000f,0x290c0002,0x515a000b,0xee3f0004}},	//   seke, ąda_, יכרו, _aký_
  { {0x998c000e,0x9a460012,0x69c61298,0xdb010032}},	//   ődő_, _وضعه, peke, nflü
  { {0x2fc70101,0x62980064,0xe57a019c,0x2ca01299}},	//   heng_, ávom, рза_, trid_
  { {0xee37002d,0x9f880028,0xbddb0061,0x4444129a}},	// [2640] іну_, kóði_, _chèq, tl_
  { {0xa3e70011,0x7656008e,0x244f0060,0xeaba0048}},	//   भाष_, smyy, yüme_, ийз_
  { {0x443a00bd,0x2fc7002c,0x2d8b00c1,0xf1bf000e}},	//   rop_, deng_, _fece_, knál_
  { {0xa3d5015f,0x660d0070,0x752f0002,0x2d8b003a}},	//   ाएँ_, chak, żczy, _gece_
  { {0x69bc0037,0xc5f30009,0xf8ca0011,0x6e3b129b}},	//   ष्यी, _חדר_, िबिय, doub
  { {0x2bae015f,0xd6d00003,0x98cb000b,0x2d8b000d}},	//   ज्ञा, فقت_, שֶׁ֥, _zece_
  { {0x23270098,0xa3e70037,0x6e940012,0x4667003c}},	//   _дори_, भार_, ألبا, орым_
  { {0x16370351,0x7ae1000f,0xdcba0014,0xd5b704b3}},	//   يسية_, _álta, ащо_, ось_
  { {0xf6530093,0xa3d50037,0x442a010b,0xddc90035}},	//   וצה_, ाएं_, ицом_, kmeņ
  { {0x2240000f,0x60cd0e23,0xc0d30003,0x7c3a0010}},	//   _akik_, çame, _زيمب, uotr
  { {0xe73a002d,0x3209129c,0x6604079b,0x79820034}},	//   _теж_, _play_, kkik, obow
  { {0x5ce60003,0x6010006f,0x8c3d003a,0x7c3a129d}},	//   _وكال, _jämf, luşl, sotr
  { {0xf993000b,0xddcd0002,0x1e570009,0x2d8b004b}},	//   ורר_, ymał, _ושאר_, _rece_
  { {0x6e200101,0x39450039,0x600b0051,0x7d0c0060}},	//   limb, āls_, _sümb, ılsı
  { {0x28d10044,0xed8b0046,0x65790061,0xde780009}},	//   _दैनि, исак_, _éché, מְּך
  { {0xdb1c0052,0x22460ff4,0xa5bb0028,0x6e2002a0}},	//   _darü, jlok_, _njót, nimb
  { {0x69c60028,0xa3e70011,0x31690031,0xb5fb0031}},	// [2650] _ókey, भाल_, _igaz_, _fián
  { {0x6e20007d,0x660d004a,0x9f580028,0x66040115}},	//   himb, shak, skrá_, akik
  { {0xc7b2000b,0xa91d09d2,0x99890034,0xdb080018}},	//   _אבי_, _težk, _okaż_, cedô
  { {0xdce90027,0x7bc80979,0xf1ab0012,0x3f91001b}},	//   zbeđ, hedu, شاؤه_, lazu_
  { {0xdb150017,0xd1410002,0xdb1a003a,0x2fc700b6}},	//   _razõ, knął_, betç, teng_
  { {0xf7710351,0x46f50014,0xb4fa0009,0xacfa0009}},	//   رات_, зчит, _הפשי, _ההשכ
  { {0x63b40042,0x60cd0411,0x7d000097,0xf1bf0031}},	//   žený, çamb, eyms, tnál_
  { {0x2fc7002c,0xc3320009,0x909b0012,0xdb1a008e}},	//   seng_, _נון_, _نضطر_, ietä
  { {0xdb1a004a,0xec760015,0xe5250024,0x6e3b129e}},	//   hetä, ппы_, ядип, roub
  { {0x4421102c,0x7bc80051,0x4374002d,0xf1bf000e}},	//   nih_, gedu, муют, snál_
  { {0xf8a9000b,0xed590035,0x3f9e0097,0x7bd5129f}},	//   _תש_, ieži_, ótum_, _mazu
  { {0xdeba000b,0xdb1c0002,0xdb1a004a,0xb6ba0009}},	//   _למעל, _zaró, detä, _לצעי
  { {0x2bac0037,0x257c0066,0xa5bb0028,0xad270003}},	//   _चाला, nálů_, _ljós, _براو
  { {0xd7f20003,0x4421048b,0xdb05000e,0x6cd20003}},	//   ركز_, jih_, eghí, _أقوا
  { {0x8c3d003a,0xa3c10037,0xc0520009,0x5b370012}},	//   nuşm, ्जन_, גזם_, _بعشر
  { {0x8afa0093,0xba9a0009,0x12fa0009,0x9f630030}},	//   _להצי, _הסקי, _להצב, ívám_
  { {0x66040006,0x7bd512a0,0x3e7112a1,0x98ac0035}},	// [2660] rkik, _bazu, _lát_, ādē_
  { {0x7bd5007d,0xa5bb0028,0x442112a2,0x21370009}},	//   _cazu, _bjós, gih_, _מטפל_
  { {0xdb1a00a2,0xa1c60001,0xb5fb000e,0x3f8c013a}},	//   retç, збед, _kiál, _redu_
  { {0x23720039,0xdb1a0060,0xdb1e01a0,0x7bc812a3}},	//   _šajā_, setç, repà, zedu
  { {0x442100ec,0x38b60065,0xdce40002,0x200e00b6}},	//   bih_, nær_, ycię, thfi_
  { {0x660b005e,0x69dd0097,0x25ad12a4,0x22460097}},	//   _algk, _ósen, egel_, slok_
  { {0xc05900bc,0xd2a7002d,0x6e2002a0,0x78a20030}},	//   ції_, _нкре_, timb, srov
  { {0x25ad000e,0xddcf000d,0xd29b000b,0x35b30048}},	//   ggel_, _micş, _לשלט, ебър
  { {0x0ee90011,0xb3ea0012,0x85730012,0x10a30024}},	//   _ऑप्स_, معدل_, رديئ, _питн
  { {0xb8650003,0xac18002d,0xd7760012,0x307b0009}},	//   _قالو, іону_, _رائع, _לאמנ
  { {0x9f7b000b,0x0bb7000b,0x60c40010,0x2d9d0002}},	//   _הנבח, הלים_, _apim, ówek_
  { {0x442102a1,0x60990012,0xd1410034,0x3206020d}},	//   zih_, ينجس_, snął_, nkoy_
  { {0x5c060098,0x3f9100d9,0xb5fb052e,0xfdf70009}},	//   _няка, tazu_, _diál, _מצאת_
  { {0xdb1a0006,0x5453007c,0xa3e30321,0x96050011}},	//   tetä, _звіт, _पोप_, रस्ट_
  { {0x3bbb0214,0x69c00026,0xb3bb000b,0x4421048b}},	//   _המוד, _obme, _המוכ, vih_
  { {0xc27b000b,0x443e12a5,0x77fa0011,0x442c0032}},	//   _פרחי, lot_, ्सुक_, lnd_
  { {0x42380093,0x1df80015,0x442c0070,0x2d580021}},	// [2670] _מנהל_, четы_, ond_, зить_
  { {0x443e0039,0xf0920093,0xb8830066,0xc8b40012}},	//   not_, _שני_, říst, _أصيب
  { {0x8c410052,0x77ba000b,0xe7f00037,0x2d920061}},	//   äßig, _ומתח, चाना_, baye_
  { {0x442112a6,0x661d0028,0xa2a40037,0x99a80012}},	//   sih_, _umsk, _किन्, كُمْ_
  { {0x3e710020,0xddc400a2,0x89370003,0xa5bb0028}},	//   _sát_, lmiş, أعضا, _fjór
  { {0xd366000a,0x443e0039,0xc4d2000b,0x7c3e00b8}},	//   _له_, jot_, _שגם_, copr
  { {0x66ff0037,0xddc4003a,0x629c000e,0x443e12a7}},	//   ैनिक_, nmiş, árol, dot_
  { {0xf2d20093,0x386d12a8,0x8c3d0060,0x644812a9}},	//   _בעל_, _tuer_, ruşm, eldi
  { {0xda340015,0x443e0a9d,0x69cb12aa,0x629800b8}},	//   _четы, fot_, mege, _avvo
  { {0x04560003,0x69d6003a,0x6e2d0032,0x93c2004b}},	//   ولية_, _saye, hnab, _ţăra
  { {0x69cb0070,0xff530003,0x61fb12ab,0x69d60573}},	//   oege, _أخذ_, _koul, _paye
  { {0x29020002,0x61fb004a,0x7ae3004a,0x69cb00c7}},	//   tyka_, _joul, änty, nege
  { {0x9f58000e,0x20040017,0x61fb0ebe,0xbbf50012}},	//   özök_, êmio_, _moul, _يستث
  { {0x9474000a,0x60c4003a,0x764912ac,0x29020504}},	//   _أدنا, çimi, lley, ryka_
  { {0x7f430047,0x6fbf0037,0xa3e70011,0xa3de0011}},	//   верж, ल्यू, भाई_, _दोष_
  { {0x6e2d0065,0x7649033b,0xdbcc0028,0x61fb000d}},	//   gnab, nley, lóðu, _noul
  { {0x75d3000a,0x89eb000b,0x3eaa000d,0xa99b0009}},	// [2680] ضيلا, _וַיֵ, subt_, _ובפר
  { {0x6faa0003,0x4a790009,0x61e912ad,0x27f70012}},	//   _بهدف_, ַרְב, _anel, _يفيد_
  { {0x764900a2,0x600b0051,0x6d460002,0x69cb0054}},	//   kley, _kümn, _wyka, fege
  { {0x61fb12ae,0x69cb0b3d,0x6f030002,0xb9260003}},	//   _coul, gege, dync, وفاي
  { {0x442c0065,0x61fb0061,0x644312af,0x7c3e0404}},	//   ynd_, _doul, _okni, popr
  { {0xdb1c0065,0xebf40009,0xdfd00012,0x33d50024}},	//   _farð, _אֶֽת_, ايث_, _піст
  { {0x7649003a,0x61fb03b1,0x7d040137,0xe7c00011}},	//   fley, _foul, lyis, श्यप
  { {0xceb30093,0x3ea012b0,0xf1bf000e,0xb05b0052}},	//   דיה_, čit_, rnák_, nwär
  { {0xdca30001,0x26c50051,0x443e12b1,0x7d0412b2}},	//   вањи, _eplo_, tot_, nyis
  { {0x442c0742,0x70fb0009,0x60fb0009,0xa2f4003c}},	//   und_, _והמח, _והמק, епоч
  { {0x442c0795,0x443e12b3,0x78a60159,0xd5af12b4}},	//   rnd_, rot_, erkv, _ис_
  { {0x7d040006,0x20ca0037,0x7de50024,0xdddc0030}},	//   kyis, िबंध, _піід, dprů
  { {0xc1050003,0x443e1150,0x9cb30012,0xdb1e005e}},	//   روسي, pot_, _لمنت, lepä
  { {0xa294002d,0xddc4003a,0xdb1e0018,0x7d160034}},	//   _закі, tmiş, cepç, dzys
  { {0x683f0066,0xd0100003,0x6295000e,0x501b0009}},	//   vádě, جلّ_, ázot, קולו
  { {0xc333000b,0xddc4003a,0x7c870001,0x600b0051}},	//   _שוק_, rmiş, дуже, _gümn
  { {0xde640014,0xdc550001,0x69cb0dcc,0x61fb12b5}},	// [2690] търп, евањ, vege, _roul
  { {0x61e90070,0x7649003a,0x69cb0832,0xa4b70009}},	//   _snel, zley, wege, ולמה_
  { {0x7649003a,0x65950024,0x764012b6,0x765b0060}},	//   yley, _пану, komy, ymuy
  { {0x76400002,0xdb1c0028,0x50b50015,0xdddd0034}},	//   jomy, _varð, еску, _wisł
  { {0x61fb0108,0x7d160002,0x4e16000b,0x6d7a0009}},	//   _voul, czys, _נחשב_, _מארח
  { {0x61fb0036,0xd0110003,0x78ab0070,0xf8070024}},	//   _woul, طلع_, rugv, ьчен
  { {0x7649003a,0x20070028,0xba740012,0x2d8f0040}},	//   tley, rkni_, _لاقت, _pege_
  { {0x61e912b7,0x63ad000d,0xd0d50048,0x31c4004c}},	//   _unel, şină, _побъ, _исув
  { {0x764900a2,0x3e75006f,0xe7e001c7,0x88c70012}},	//   rley, _låt_, _गोवा_, _تتأل
  { {0xaf070001,0x2d8f0052,0xdb1e005e,0x7f840012}},	//   _очек, _wege_, bepä, _للكن
  { {0xd9eb0011,0xda0a0012,0x7649020d,0x8c3d004b}},	//   टांत_, كيده_, pley, nuşi
  { {0xc332000b,0xc0490009,0x96350024,0x7afc0248}},	//   רוט_, _הז_, _янец, ärta
  { {0xa3b70037,0xa3c10037,0xe5070012,0x487a0048}},	//   _छाप_, ्जा_, _تباي, ясня_
  { {0x7bd80010,0x34fa0009,0xb4fa0009,0xa3de0011}},	//   _gavu, _מהנד, _מפני, _दों_
  { {0x96560001,0x84640014,0xe7f00011,0x92b50012}},	//   еђај, _ръце, चाता_, _أحتا
  { {0xee3a007c,0x7d040006,0x660912b8,0xfb1a0009}},	//   їна_, tyis, nkek, _מוצמ
  { {0x2cad002a,0x644100ff,0xa3b60011,0x64a305f7}},	// [26a0] nued_, ooli, ङ्क_, лата
  { {0x7d16003e,0xa3e70037,0x113b0009,0x6e24005e}},	//   rzys, भाग_, _מתפל, siib
  { {0x7d16003e,0xa3b70037,0xa3c10037,0x80250012}},	//   szys, _छान_, ्ज़_, _جريم
  { {0xf9920003,0x44250d8a,0xa2d50011,0xda100011}},	//   ابا_, hil_, णिज्, ासित_
  { {0x63ab0066,0x644112b9,0x00da0012,0xab630034}},	//   álné, koli, ثبات_, ążym
  { {0xf0930009,0xe8d9001a,0x889b0009,0xd7e7004c}},	//   ננו_, _ngờ_, לבני, емље_
  { {0xa2e300ac,0x69c412ba,0xa3b30011,0xc7b30009}},	//   _йорд, _obie, टलन_, אבו_
  { {0x7bd812bb,0xdb1e0051,0x387f12bc,0x629c0f27}},	//   _savu, repä, ţuri_, šrok
  { {0x2cad002a,0xddde0035,0xed57004c,0x5d540048}},	//   gued_, _atpū, ноћ_, ъкит
  { {0xdcef001e,0x442512bd,0xe0d70024,0x600b0060}},	//   _secī, gil_, _яву_, _cüml
  { {0xa3b60037,0xf413000b,0x645e12be,0xb05b0032}},	//   ङ्ग_, רפת_, impi, ltäg
  { {0xdc1200a2,0xc3330093,0xb87b0066,0x68e412bf}},	//   rşıl, טות_, jvíc, _brid
  { {0xc05b002d,0xb5fb000b,0x8dfb000b,0x68e40054}},	//   зів_, _מלאכ, _מהאת, _crid
  { {0x9cd70009,0x20d6001b,0xbd290012,0x442512c0}},	//   _נווה_, džić_, _تأمل_, cil_
  { {0x05870001,0x3d080011,0x9f340024,0x6f640012}},	//   еузм, िनके_, гері, ُهُم
  { {0xf6530012,0x9f450060,0x45d404a5,0xaa58003c}},	//   ائس_, _rolü_, лосс, _пищу_
  { {0x629a12c1,0x95c40003,0xa6340024,0xdb010032}},	// [26b0] lsto, طيله, унті, uflö
  { {0x69cf12c2,0x69c4083f,0x600b12c3,0xbca40012}},	//   lece, _zbie, _kümm, املي
  { {0x78bd0052,0x69c40034,0xe9d90034,0x90340012}},	//   ltsv, _ybie, _paź_, _حريص
  { {0xc27b000b,0xdbd701a3,0x629a12c4,0x69cf0cc4}},	//   פרדי, _sääs, isto, nece
  { {0xfd96000b,0x764d003a,0xdbd7015e,0x629a0032}},	//   _בדרך_, mlay, _pääs, hsto
  { {0x6008002d,0x25bf0132,0x63b50034,0x78bd0032}},	//   ннім_, wful_, _uczn, itsv
  { {0x764d003a,0x69cf0225,0x10140012,0x25bf0132}},	//   olay, kece, دبند, tful_
  { {0x78a4001c,0x764d0d33,0x64410034,0x7ceb0097}},	//   šiva, nlay, woli, jörð
  { {0x34b20003,0x25bf12c5,0xe7b20011,0x764d016d}},	//   لميز, rful_, _जालप, ilay
  { {0x13090015,0x23670027,0x2b9c0066,0xc60e0011}},	//   дной_, žnju_, mácí_, _सत्य_
  { {0x764d00a1,0x2cad002a,0x2bd00037,0x8bd60009}},	//   klay, sued_, तज़ा, דותו_
  { {0x412a00b3,0xa2c40011,0x82880009,0x644112c6}},	//   домо_, _रहस्, עְתֶ, soli
  { {0xc19a000b,0x6606000e,0x764d006f,0x69db0052}},	//   ושרי, ökke, dlay, _maue
  { {0x394c001e,0x2ca912c7,0xf0920009,0x764d12c8}},	//   āds_, drad_, שנם_, elay
  { {0x539a0093,0xa0670a25,0x69cf0164,0x78bd0ad2}},	//   _חיצו, тара_, bece, atsv
  { {0xe8df001a,0x3ea5000e,0x69c412c9,0x49c70048}},	//   _cuịa_, álta_, _ubie, _алън_
  { {0x8e55002d,0x3b960001,0x05660345,0x93bc004b}},	// [26c0] утрі, вјет, тван, mnăr
  { {0x61ed12ca,0x31570009,0x7bc112cb,0xf41f0064}},	//   _znal, _ביפן_, nflu, _zväz_
  { {0x69db0052,0xe73a0015,0xe2970ba0,0x93bc004b}},	//   _baue, _цен_, вах_, onăr
  { {0xd7b20037,0x2ca90051,0xcaa50003,0xa2a40011}},	//   _जाँच, brad_, اصلي, _किस्
  { {0x69db0052,0x8c3d003a,0x20d30012,0x21670681}},	//   _daue, luşu, لتوج, вици_
  { {0x9f650029,0xbcfb000e,0xdb210029,0x63830014}},	//   _štát_, _egés, štát, _вгра
  { {0x48ee015f,0x69cf00a2,0xf773000b,0x99860003}},	//   _आपको_, yece, סקה_, _للأو
  { {0x7bdc00c6,0x7f3b000b,0xade3002d,0xc6930009}},	//   _haru, ועצו, ацьк, באה_
  { {0x260302d1,0x7ceb0028,0xa3e70011,0xd7b20011}},	//   _años_, vörð, _मोड_, _जांच
  { {0x8af805fb,0x74140012,0xe3af0012,0x764d0060}},	//   енос_, اودا, يرٍ_, zlay
  { {0x764d003a,0x60140054,0x6d4f0030,0xb8820030}},	//   ylay, _càme, ýcar, říle
  { {0xba9b0009,0x7bdc12cc,0xdddc0034,0x444412cd}},	//   וסטי, _laru, żyłe, ho_
  { {0x63f60003,0x3e7812ce,0x69dd12cf,0xa3b30011}},	//   _لأغر, _hét_, rdse, _टाल_
  { {0x3e78000f,0xc953000b,0x444412d0,0x69cf12d1}},	//   _két_, שמש_, jo_, sece
  { {0x3e78000e,0xb4cb0037,0x764d039a,0x5f9412d2}},	//   _jét_, लब्_, tlay, рист
  { {0x3e78001a,0xa6340024,0x6edb0009,0x4e180012}},	//   _mét_, ансі, וחלפ, نتقد_
  { {0xe3900020,0xda100037,0x764d12d3,0x5d550b48}},	// [26d0] _điề, ासरत_, rlay, укат
  { {0x600b003a,0xf8bf0061,0x69db12d4,0x9b950012}},	//   _mümk, mté_, _saue, الات
  { {0xba740003,0x8c3d003a,0xf8bf0e90,0x764d12d5}},	//   لانت, muşt, lté_, play
  { {0xc3330093,0x8c3d003a,0x68e2001e,0x6010006f}},	//   בוע_, luşt, _šodi, _jämn
  { {0x444412d6,0xf8bf0706,0xbcfb000e,0xa9280066}},	//   bo_, nté_, _egér, vyžá
  { {0xf8bf0061,0x6010006f,0x8c3d003a,0x7bdc12d7}},	//   ité_, _lämn, nuşt, _garu
  { {0x8cdb0037,0x56920001,0x68e202a1,0xaa6711e0}},	//   निको, бајт, avod, _атак
  { {0xa3c10037,0xcf58000b,0x6010006f,0x64450312}},	//   ंभव_, כבות_, _nämn, lohi
  { {0x626c000d,0xb5fb0018,0x24590c04,0x865c0009}},	//   _uşoa, _fiáv, hème_, ודהי
  { {0xabd50001,0x87d70003,0x23d50867,0xe8550012}},	//   уциј, _جغرا, уцир, _صناد
  { {0x6d4b0002,0xcad50009,0xa22a0373,0xf8bf0025}},	//   _wyga, נוֹת_, ежна_, eté_
  { {0xd3360009,0x7bc1086a,0x624801e3,0x3f9812d8}},	//   טרתה_, sflu, eñor, waru_
  { {0x444412d9,0xc985004c,0x93bc004b,0x6d4b0060}},	//   yo_, јуџи, rnăr, _uyga
  { {0x3e710026,0x6e29008b,0x70560003,0xdd2f0066}},	//   _ešte_, lieb, انسا, měňo
  { {0x3e780020,0x1b49002d,0xdb1c0107,0x8c1a000b}},	//   _xét_, _язки_, _obrá, _רוצי
  { {0x660d0101,0x44440501,0x7bdc12da,0x2bc60011}},	//   gkak, wo_, _saru, र्ना
  { {0xee3708b0,0xf8bf0061,0xf1bf000e,0x7d1b0052}},	// [26e0] унт_, cté_, rnát_, nzus
  { {0xb05b004a,0x660d002c,0xd0f70009,0x6e290032}},	//   ttäe, akak, _עמית_, hieb
  { {0x2cbf0005,0x41aa0014,0x799612db,0x7d09008e}},	//   htud_, евен_, _keyw, hyes
  { {0x7bdc12dc,0xa2a50011,0x6abe0032,0xc9850012}},	//   _waru, _चटर्, rtpf, لشهي
  { {0x6736001e,0x79b7000b,0x3d0d0037,0x859b0009}},	//   šajā, רלנד_, िनों_, _אשכו
  { {0xc0e70012,0xd6d00012,0xf6b40012,0x8eb40012}},	//   افون_, ققت_, لمتج, لمتش
  { {0xf8b10037,0x394d002a,0x6d5d0028,0xc7d7000b}},	//   _जम्प, _eyes_, ýsan, רוצי_
  { {0x7c280032,0x7d1b0032,0xa5bd0073,0x3ce612dd}},	//   widr, fzus, liųj, _prov_
  { {0x27ef0013,0xc19b000b,0xb8820066,0xd3700012}},	//   ální_, _רשמי, říje, يهة_
  { {0xd12f000a,0x610a0039,0xc4d3000b,0x986a0003}},	//   _عمل_, _vēlā, צגת_, _أحرف_
  { {0x2bc60037,0xe9ff001a,0x23c60037,0x2bf70009}},	//   र्या, _chặn_, र्यद, אמין_
  { {0x9d9a0003,0x54e60003,0xe9df0029,0x9f5e08cf}},	//   _أنشئ_, _مستق, udú_, _noté_
  { {0xf8bf0061,0x75d30003,0xad8b000b,0x3d000037}},	//   uté_, _دينا, _נְאֻ, ोनों_
  { {0x2bc60044,0x75fc000f,0x1cb7000b,0xf8bf0061}},	//   र्मा, _nézz, _עלול_, rté_
  { {0xdce000a2,0x6b9a0054,0x8c3d003a,0xaed50024}},	//   mamı, matg, ruşt, шовш
  { {0x66020005,0xdce000a2,0xc1050003,0xf8bf0061}},	//   _jook, lamı, _نوعي, pté_
  { {0x20010051,0xcd340012,0x2bc60011,0x94770012}},	// [26f0] _tohi_, مركب, र्भा, ادرا
  { {0x6fb20037,0x60cd002c,0x6b9a0054,0x660212de}},	//   _जाएं, _ipam, natg, _look
  { {0x7c2f0025,0xbcfb0031,0x877a0009,0xdddc001b}},	//   écri, _egép, _באתי, sprš
  { {0xa294002d,0x5efa000b,0xfde90011,0xdb1a0034}},	//   саці, _ספרד, _ऑफिस_, letó
  { {0x759a000b,0xa9350015,0xdce0003a,0x71270012}},	//   _בסרג, шедш, kamı, درال
  { {0x2898000b,0x601008ec,0x7ed50012,0xdee50012}},	//   נדון_, _näml, لزبا, لأعي
  { {0xe5710003,0xf2e4002d,0x6e290070,0x6fb20012}},	//   يطة_, _люто, tieb, زميا
  { {0x7aea00c5,0x8237000a,0xc2c40003,0xdcf50012}},	//   æfte, _إرسا, _ديفي, لأخب
  { {0xc212000b,0xc7d90014,0x6e2912df,0xf1bf0042}},	//   _והן_, _имах_, rieb, riál_
  { {0x7d1b0052,0xe4c80003,0x89340012,0x60db020d}},	//   rzus, ابين_, _اعفا, _isum
  { {0x2cbf0051,0x7d1b00f7,0xfbd20009,0x6602005e}},	//   stud_, szus, חתי_, _fook
  { {0x0166022a,0x20050028,0x998f0073,0xe4d50012}},	//   икно, ölin_, mogų_, _نتتب
  { {0xe0d70098,0xc9560015,0x998f0010,0x5156003c}},	//   авя_, ртны, logų_, ртну
  { {0xf7720003,0xb8ee0037,0x7d06004a,0x8e86003c}},	//   تاح_, _रह_, äkse, игге
  { {0x9f5e12e0,0xa5960014,0x44d60002,0x92f60012}},	//   _poté_, иращ, _zł_, _نفوذ_
  { {0x78a9066e,0x645c002a,0x60db12e1,0x2cad08fd}},	//   ševa, _shri, _osum, ored_
  { {0x3ce80037,0x4c850003,0xdb1a12e2,0x0c26024d}},	// [2700] जिये_, مؤلف, zetü, аман
  { {0x515b0093,0x309b000b,0xb09b0009,0x83870024}},	//   _בכפו, _ששימ, _שייר, ибув_
  { {0xf1eb0037,0xb05b0248,0x93430934,0x60db12e3}},	//   _जोड़_, stäc, онфе, _asum
  { {0xda65000a,0xb05b0163,0x629e12e4,0x6e9b0009}},	//   ماني, ptäc, rspo, _בבטח
  { {0xdce0003a,0x7e6401a4,0xe0d20012,0x645c12e5}},	//   yamı, mmip, تزا_, _thri
  { {0xb8ce015f,0xa2e60047,0x4ea60063,0xf8b30009}},	//   _कि_, _когд, ариа, קשו_
  { {0x99990029,0x68e912e6,0x3e7c0066,0x0ff70003}},	//   losť_, _ered, _jít_, شعوب_
  { {0x3e7c0013,0x2d8012e7,0x2ca0005e,0xdb1a12e8}},	//   _mít_, ncie_, osid_, retü
  { {0x99990029,0xeb0e0037,0x6d590002,0x6b9a0054}},	//   nosť_, ान्त_, _czwa, tatg
  { {0x61e2000f,0xbea6002d,0xd00f0012,0x14180012}},	//   ldol, _важк, _قلق_, ايدة_
  { {0x3377000b,0x6b9a0054,0x2d800fae,0x2cad12e9}},	//   יעים_, ratg, kcie_, ared_
  { {0x2bc60044,0x2ca00005,0x6b9a0054,0xe4e6002d}},	//   र्ता, ksid_, satg, _вікн
  { {0x2cad12ea,0xdce00060,0x6b9a01a0,0x25a612eb}},	//   cred_, pamı, patg, _idol_
  { {0x61e20006,0x99990026,0xbb840003,0x2d800002}},	//   hdol, dosť_, _الغي, ecie_
  { {0xdb1a0149,0x93fb000b,0x442c12ec,0x6c5b0009}},	//   retó, _בלגי, mid_, _שדוח
  { {0xbafb000b,0xef190002,0x13170009,0x8afb0009}},	//   _יהוש, ąż_, _כחול_, _יהוי
  { {0x442c0070,0x04950003,0xbd780024,0x25d70009}},	// [2710] oid_, صلاح, рбує_, סומן_
  { {0x442c109a,0x3f9c0027,0xaada0037,0x4427001a}},	//   nid_, javu_, _बनाक, òn_
  { {0x2bc60044,0xb5fb0149,0x68e9048b,0x2ca0005e}},	//   र्धा, _diár, _sred, asid_
  { {0x68e912ed,0xaaa90011,0x442c12ee,0x27e112ef}},	//   _pred, _किसक, hid_, _hahn_
  { {0x84670098,0xddc20002,0x89a8002d,0xb9c40003}},	//   _въве, _okoł, рків_, تقني
  { {0x96950046,0xcc76000b,0x98f40003,0xdfd10003}},	//   бриш, _לגשת_, تثما, سيع_
  { {0x442c0005,0x56920001,0x6d590002,0x60c209bb}},	//   did_, пајт, _szwa, atom
  { {0xed590015,0xd738000b,0x0f38000b,0x1f380009}},	//   лой_, יטות_, ירוט_, ירור_
  { {0xa3ab015f,0x2d9900c1,0x7d0d003a,0x4c820015}},	//   _गया_, _mese_, nyas, плыв
  { {0x2cad0036,0x2d990119,0x6448080a,0x442c12f0}},	//   rred_, _lese_, godi, gid_
  { {0x249f0065,0x8c1a0093,0x2d800002,0xddc6001e}},	//   ssum_, רותי, ycie_, _likš
  { {0xc332000b,0x2cad12f1,0x36040012,0xc8790060}},	//   לוי_, pred_, _وولف, _kuş_
  { {0x6c850003,0x2005009b,0xdbf00066,0xeb8e12f2}},	//   _التم, _koli_, _zříd, _ни_
  { {0x99990029,0xaf360012,0xeb990048,0x200512f3}},	//   vosť_, مرأت, _сик_, _joli_
  { {0x61e2003a,0x6e2d03b5,0x539a0009,0xa8560009}},	//   ydol, fiab, _עסקא, מישה_
  { {0x2ca00051,0x99990029,0xddcd003a,0x291a0012}},	//   tsid_, tosť_, rmaş, _مقعد_
  { {0x7fd6002d,0x6e360010,0x05560048,0x2d8012f4}},	// [2720] _ліні, rnyb, ствя, rcie_
  { {0x68fb000b,0x2ca00051,0xe0fb000b,0x25e80011}},	//   _עליה, rsid_, _עליל, _चोरी_
  { {0xe80d0044,0x2ca00051,0x9f64003a,0xb6ab0024}},	//   _सकता_, ssid_, ütün_, _змiн
  { {0x60c20006,0x90a60003,0x753d0002,0x7afc0052}},	//   ttom, محتم, ższy, ärti
  { {0x20050026,0x91bb000b,0xdb1e000e,0x6448003a}},	//   _boli_, רמני, lepü, yodi
  { {0xf093000b,0x6ec60003,0x1eaa0012,0xdbf00030}},	//   לנד_, متبق, هابي_, _příd
  { {0x66060005,0x6ab60044,0x64480133,0x8fa30001}},	//   _kokk, _अमेर, vodi, чаје
  { {0xdb010065,0xf1bf000e,0x442c08bb,0x6b980060}},	//   uglý, riák_, wid_, _sevg
  { {0x8fa600be,0x644812f5,0x442c12f6,0x660612f7}},	//   _газе, todi, tid_, _रवैए_
  { {0xb5fb0020,0x3e41007a,0xf3f1000b,0xdbf00066}},	//   _khác, mėte_, ֵ֣י_, _tříd
  { {0x0dca007c,0x95ca007c,0xe9f9007c,0x51f9002d}},	//   _були_, _була_, анні_, анню_
  { {0x442c0005,0x66060065,0xf1ab0012,0xddc80034}},	//   sid_, _nokk, داده_, _ludź
  { {0xa3b80037,0xc5f3000b,0x2486006f,0x2d9900b8}},	//   छला_, _מדף_, _utom_, _rese_
  { {0xd9180015,0x20050028,0x46dc0037,0x94bb0009}},	//   сью_, ðli_, _मनाह, _עמות
  { {0x877b000b,0x53330001,0xb4250003,0xdb1e004a}},	//   ראלי, _нешт, _بعنو, ävän
  { {0x442a0663,0x3e410010,0x7e55002d,0x83370009}},	//   _amb_, kėte_, іває, _לאוס_
  { {0x26c3009b,0xc399002d,0x7c970003,0x53990015}},	// [2730] stjo_, икає_, إشرا, ивая_
  { {0x3e410010,0x7d0d003a,0xb3670015,0x224b10d9}},	//   dėte_, ryas, бъек, lock_
  { {0x7d0d00a2,0x68ed00d9,0x2bca0011,0x20050975}},	//   syas, _hrad, ़्या, _roli_
  { {0xd1310003,0x7d0d003a,0xb95500de,0x32b80012}},	//   وما_, pyas, овещ, صدمة_
  { {0x02440012,0x200512f8,0x3e410073,0x98c70842}},	//   أَنَ, _poli_, gėte_, ссел
  { {0xa295002d,0x6d5d001e,0x889c007e,0xba770012}},	//   _магі, _izsa, רבגי, _هارت
  { {0xb05b0006,0x8db50024,0x3619003c,0x6fac0011}},	//   ytän, оспі, ицию_, _जयसू
  { {0xc4850838,0x34a90001,0x7860006f,0xe7180009}},	//   олик, авио_, möve, מחור_
  { {0x2bc60044,0xe3b10003,0xe616002d,0x26de12f9}},	//   र्वा, ورد_, ідь_, _esto_
  { {0xeb990001,0x9f60000e,0x78a60040,0x5ac912fa}},	//   шио_, űrés_, _ækva, алом_
  { {0xb05b0006,0x68ed003a,0xd7f8001a,0xe2990001}},	//   ttän, _arad, _khăn_, јам_
  { {0xcf890093,0x04c90003,0xdd1e0066,0x90c6091c}},	//   _יט_, _نوصي_, _síťo, обме
  { {0x78600163,0x89da000b,0xb05b12fb,0x660612fc}},	//   höve, בחרי, rtän, _rokk
  { {0x7860012b,0xcb69046d,0xb05b12fd,0x69cd005e}},	//   köve, _кале_, stän, _ebae
  { {0xba3d0010,0x3f6a00f5,0x7bd71135,0x79820034}},	//   grįs, риво_, dexu, ycow
  { {0x2d9f0052,0xb90a0021,0xdb1e0031,0x224b12fe}},	//   naue_, _вниз_, repü, cock_
  { {0x6443009b,0x8f760024,0xad190009,0xd7760012}},	// [2740] čnin, _муні, בוּר, _وادع
  { {0x28b80011,0x6b560479,0xa5bb0034,0x79820034}},	//   उंसि, отех, _omów, wcow
  { {0x61e40101,0x442a0032,0x59c10011,0xfe460048}},	//   _kail, _vmb_, ष्कर, _мноо
  { {0x3e410010,0x6606004a,0x61e60070,0xdcfd0010}},	//   tėte_, _uokk, ndkl, _nesė
  { {0x95880010,0xe89400be,0x8d66002d,0x3e7112ff}},	//   grąž, чаль, _євге, _ašto_
  { {0x3e410010,0x6bd60003,0x799b0070,0xb5fb001a}},	//   rėte_, _بتحر, _eeuw, _thác
  { {0xa01b004a,0xa7140024,0x28da0011,0xdefa003c}},	//   mpöt, ямкі, _मैरि, рыл_
  { {0x78ad001c,0x2dd30014,0x2bc60037,0xf773000b}},	//   šava, джър, र्रा, וקו_
  { {0x6b9c0051,0xbc77003c,0x80da0011,0x7aee0159}},	//   _kerg, обых_, _पैले, _hrbt
  { {0x8c430046,0x9b6a0345,0xddc20002,0x136a0867}},	//   мење, ишна_, _skoń, ишни_
  { {0xb4e30044,0x6b9c1300,0xa5bb0018,0x637b0009}},	//   कटॉप_, _merg, _imóv, יניד
  { {0x68ed007a,0xba2b002d,0x61e41301,0xa2cd0011}},	//   _prad, ріод_, _cail, _सहस्
  { {0x7860000f,0x660f02f1,0xed5700ac,0x61e41302}},	//   zöve, öcke, _доц_, _dail
  { {0xb8670012,0x7c2a04ec,0x3eb81303,0x104b01c6}},	//   تاجو, _umfr, furt_, рями_
  { {0xdb4f002d,0x9e07002d,0x25a0005e,0x3ea50031}},	//   _цю_, очал, fail_, élt_
  { {0x7afc0005,0xddc20002,0x3ead00f1,0x68e00030}},	//   ärtu, _ukoń, čet_, _osmd
  { {0xc05b007c,0x1cb80003,0xb05b004a,0xd37b0c1e}},	// [2750] _він_, قالب_, ltäm, аче_
  { {0xddd60002,0x3eb80052,0xeb900012,0xa3d40148}},	//   omyś, burt_, نظم_, моуч
  { {0xb05b004a,0xd3710003,0x23c20037,0x6a940024}},	//   ntäm, ءها_, _शानद, дріє
  { {0x2bca0037,0x92590015,0xf1a70024,0x6b9c0227}},	//   ़्ता, щает_, ірен, _eerg
  { {0xc5fa0093,0x7860006f,0x5dfa0009,0xddcb0073}},	//   _הפרט, söve, _הפרנ, žiųj
  { {0xa6950001,0xc078002d,0x28080012,0x6d3a0009}},	//   приј, ісії_, يْنَ_, _הֲלו
  { {0xa195007c,0x82a40001,0x99d70012,0x160f0011}},	//   _навч, _оште, _وترا, _सवार_
  { {0x7c3a007d,0xd6ce000a,0xc6680001,0xc8ab0048}},	//   entr, اقي_, ошње_, _въже_
  { {0x6d430052,0x27f60066,0x61e404f2,0xa3e70011}},	//   ßnah, ádní_, _rail, मएल_
  { {0x4b25002d,0x94220015,0xd8740012,0x61e402d5}},	//   змов, емье, _قالب, _sail
  { {0xef20003e,0xddc40002,0x6b850052,0xc7c400b3}},	//   ążki_, gliś, ichg, _юсти
  { {0xb05b0163,0x7a360692,0x61460488,0x60100248}},	//   stäl, kšte, зема, _jämv
  { {0xf992000b,0x25a00573,0x7e691304,0x69d91305}},	//   ערך_, vail_, mmep, iewe
  { {0xb4d70037,0xdb1a1306,0xb05b008e,0x20c4008e}},	//   ाबी_, eetõ, ltäj, röi_
  { {0x63a11307,0xabfa0009,0x64430004,0x4e1f0011}},	//   maln, _להסר, čnil, _बताई_
  { {0xbc760003,0x6e3b0028,0xb05b008e,0x0dc90012}},	//   كهرب, nnub, ntäj, يبقى_
  { {0xee37002d,0x6b9c1308,0x69d900c7,0x5baa0015}},	// [2760] їну_, _perg, dewe, йкам_
  { {0xdce60039,0x26c7013a,0xe5720009,0x63a11309}},	//   _iekļ, ktno_, גַע_, naln
  { {0xb77b000b,0x9f97000b,0x518605fb,0x0f7b0009}},	//   _לאיש, _מדיה_, пула, _לאיב
  { {0xdb1a0051,0xe8fa0015,0xc9160009,0x91ba0012}},	//   petö, йле_, ּחַת_, إطار_
  { {0xb5fb001a,0x6b9c00b6,0x63a1130a,0x3a3f130b}},	//   _khán, _terg, kaln, _djup_
  { {0xb05b004a,0xddc40002,0xd12f0003,0x3e410010}},	//   ytäm, yliś, دمه_, mėta_
  { {0x8c1b000b,0xb7db000b,0x69d90347,0x66160073}},	//   _פולי, מקסי, bewe, okyk
  { {0xbb3b0093,0x6616007a,0xd5e20020,0x333b000b}},	//   _העלי, nkyk, _khỏ, _התלמ
  { {0x2ba606bc,0xd0260014,0xe6110009,0x3e410073}},	//   jící_, _емай, דִי_, nėta_
  { {0xb05b0006,0xb5fb001a,0x22810028,0x2ba60030}},	//   ttäm, _nhán, _bók_, dící_
  { {0xe1d9007c,0x7e7e0051,0x61d90048,0xbf130012}},	//   одні_, _nupp, омня_, _كوكب
  { {0xb05b004a,0x63a10051,0xe717000b,0xa194002d}},	//   rtäm, aaln, _מחבר_, наюч
  { {0xd625000a,0xa207000b,0xdb23000e,0xb05b03f5}},	//   _تعلي, לֶךְ_, _örök, stäm
  { {0x7a360026,0x3e410010,0xb5fb001a,0x36d5130c}},	//   všte, dėta_, _chán, могр
  { {0x3f9e007a,0x7bda130d,0xa857000b,0x628a021e}},	//   _metu_, metu, פילה_, _utfo
  { {0x6443012e,0x8b3b000b,0xc333000b,0x433b000b}},	//   čnim, _לתוצ, _רוק_, _לעוב
  { {0x70bb0011,0xd944004c,0xf9900012,0x7bda03bd}},	// [2770] _ईमेल, _пећи, _صبي_, oetu
  { {0x2bcf0037,0x3138000b,0x9c470024,0x9cd70009}},	//   त्पा, _מנחם_, їхал, הומה_
  { {0x6b850052,0xd7f8001a,0xc2c40012,0x8b670012}},	//   rchg, _chăm_, فيلي, سائم
  { {0x7bda08c0,0x69cb0052,0xeab00003,0x7a360027}},	//   hetu, ufge, اعل_, pšte
  { {0xddc80408,0xba740012,0x37e5003c,0x69d909bf}},	//   _budž, رامت, долг, rewe
  { {0x3cfa0009,0xe0d80024,0x9be40024,0xf8070198}},	//   _ולשנ, яві_, _піск, ячен
  { {0xb05b0006,0x7bda0005,0x63a1012e,0x6e3b002c}},	//   ttäj, detu, valn, tnub
  { {0x60100163,0x63a111f7,0xc3320009,0x67230159}},	//   _hämt, waln, _סון_, rznj
  { {0x63a10afa,0x26c7009b,0x7bda0284,0x443300b7}},	//   taln, stno_, fetu, oix_
  { {0x7bda007d,0x40e8000b,0xb05b004a,0x60100248}},	//   getu, _מַעֲ, stäj, _jämt
  { {0x56940046,0xa3cf0037,0x2bcf0037,0x64a2000d}},	//   _захт, व्य_, स्या, mţiţ
  { {0xc7a90093,0x63a100c6,0x2ba60030,0x74f90012}},	//   _כב_, saln, tící_, _وفاز_
  { {0xa5bd007a,0xe44e002d,0x3ea00027,0x64430027}},	//   siųs, _аж_, ćite_, čnij
  { {0x22810028,0xf8b6000b,0x3cf10011,0xe46b003c}},	//   _tók_, ופשי_, ँटने_, _ушел_
  { {0x41c60037,0xeab10012,0x8c42076b,0x9345130e}},	//   _वापस, _شعث_, _шеше, _юнке
  { {0x44330054,0x96550001,0x25bf130f,0x4a760012}},	//   eix_, еђуј, ngul_, _تُعر
  { {0xb5fb0020,0x66160010,0xf1bf017a,0xb5fd0159}},	// [2780] _thán, rkyk, riát_, emšk
  { {0x8d630047,0x4d63002d,0x660b0058,0x6616004a}},	//   твуе, ткув, _logk, skyk
  { {0x78a901a2,0xb9e6002d,0xb7fb0009,0x41e60024}},	//   _avev, діли, _ופית, діла
  { {0xc693000b,0x22400051,0xd5e2001a,0xfbc9000b}},	//   _שאר_, õik_, _thỏ, ית_
  { {0x00da0012,0xaa050012,0xb86a004c,0xd378001b}},	//   تبات_, عظمه, ојке_, leće_
  { {0xd7f80020,0xd010000a,0x368a002d,0xd0070001}},	//   _thăm_, طلب_, осин_, деље_
  { {0x8f9b0009,0xd5ba0024,0xa2e3003c,0xc0590024}},	//   קיקי, осп_, _иорд, чії_
  { {0x973c0027,0xdb010c56,0xb05b1310,0x78a911f9}},	//   _neće, palê, ttäk, ševi
  { {0x47c60046,0xed570046,0xd657000b,0xe3ce001a}},	//   _обав, моћ_, ויקת_, _dựng_
  { {0x6aba006f,0xa4fb0009,0x7c3e1311,0xbc670012}},	//   tutf, קליט, nnpr, ومين_
  { {0x0bb70093,0x83b70093,0xe2f8002d,0xfbb7000b}},	//   ולים_, ופיע_, чені_, ופית_
  { {0xd378001c,0x7bda03d5,0xdd900003,0x7c210032}},	//   deće_, setu, _صوت_, ahlr
  { {0xa3de0011,0x273c0064,0x7bda1312,0xb05b005e}},	//   ढ़ा_, yšné_, petu, ltäi
  { {0x8ca20037,0x6443017b,0x6aba0040,0xb8f70011}},	//   गठनो, čnik, putf, _सह_
  { {0x3bbb000b,0xf7700003,0xadd50001,0xb3bb0009}},	//   _ומוד, لاف_, новљ, _ומוכ
  { {0xf1d0001a,0x60100052,0x59c60037,0x3e45001e}},	//   _hạng_, _sämt, _वायर, pēte_
  { {0x69dd1313,0x2d58027f,0x189b0012,0x9cc8003c}},	// [2790] mese, дить_, _بضعة_, дыха_
  { {0x443e1314,0xc8670003,0x2bbb0003,0x7a360010}},	//   nnt_, _تطبي, تارة_, mšta
  { {0xddc8003e,0xf1d00020,0x387f0051,0x916d001a}},	//   _budż, _mạng_, _suur_, _hồi_
  { {0xa294007c,0x443e0052,0xf9900012,0xddcf004b}},	//   таці, hnt_, لبه_, _dicţ
  { {0x7a361315,0x69dd0052,0x1bbb0003,0x3e610028}},	//   nšta, iese, _واسع_, jóta_
  { {0x200c03eb,0x8574007c,0xb87b0065,0xb9070037}},	//   _codi_, _шлях, lvís, _बन_
  { {0x7ac4069b,0x69dd026e,0x63a51316,0x22b80012}},	//   _исте, kese, mahn, _يدفع_
  { {0x645a0065,0x63a500b6,0xb05b0051,0x7a360010}},	//   elti, lahn, stäh, kšta
  { {0x2bcf0044,0x629c003e,0xa954002d,0x79c80003}},	//   स्था, _zwro, _акті, _توقف_
  { {0x73050001,0xd3780027,0x2bca0011,0xbb850012}},	//   епоз, zeće_, ़्ला, ةلدي
  { {0xf1d00020,0x7afc0051,0xb87b0066,0x7a360cf9}},	//   _dạng_, ärtp, zvít, ešta
  { {0x2bcf0044,0x8ed80003,0x7afa000e,0xfb1a000b}},	//   स्ता, _تذكر_, _átte, פורמ
  { {0xa1550098,0xddc4003a,0x78bd0051,0x973c001b}},	//   върш, eliş, gusv, _veće
  { {0x66060028,0x201e0028,0x69c40034,0xfaa50bda}},	//   ökkv, óti_, _wcie, _зако
  { {0x8c1a000b,0x63a5051f,0x141a0009,0x20180097}},	//   _מוסי, dahn, _מוסב, rkri_
  { {0x85b50046,0x69c40002,0x64b5003a,0x69dd1317}},	//   кључ, _ucie, _eğiş, cese
  { {0xb4660083,0xfe4301d4,0xd378001b,0xdb010031}},	// [27a0] екал, унто, reće_, dalé
  { {0x6fd300a2,0xaf9a0047,0x24820029,0x61fb1318}},	//   nıcı, _этих_, íkmi_, _anul
  { {0x23c60037,0x479b000b,0xe8030037,0x3f980bd3}},	//   र्गद, _מייס, लाना_, mbru_
  { {0xda650003,0xe9e5002d,0x2bcf0037,0x22930012}},	//   ناني, кціо, त्ता, النس
  { {0xc237000b,0x443e1319,0x629c0031,0x63a5131a}},	//   ערנו_, ynt_, ároz, bahn
  { {0xb05b0006,0x993b0009,0x69dd0540,0x6e240031}},	//   ttäi, התנה, zese, lhib
  { {0x8c4306e6,0xd6d70015,0x7d16004a,0x916d001a}},	//   _сере, еты_, lyys, _mối_
  { {0xa737000a,0xa3d20037,0x443e002c,0xceb3000b}},	//   عثور_, ह्न_, wnt_, איה_
  { {0x59a70044,0x69dd131b,0xdb1c0018,0x25a20035}},	//   _ख़बर, vese, _ucrâ, _mekl_
  { {0xb05b0006,0xe8d7000b,0x69dd0052,0x916d131c}},	//   ltäv, _אומר_, wese, _nối_
  { {0xa1950015,0xfa6a0009,0xb4bd0011,0x6ec50012}},	//   канч, ּכָּ, _इम्_, _لتنق
  { {0x765b02d1,0xda670003,0x23c70037,0xb05b004a}},	//   cluy, عادي, _लाभद, ntäv
  { {0xf1d0001a,0x69a20037,0x66060028,0x63a5016d}},	//   _tạng_, _ख़री, ökku, yahn
  { {0xb05b0006,0xb8030037,0x69dd03ae,0xe8030037}},	//   htäv, लायम_, sese, लाया_
  { {0xc2210037,0x3e45001e,0x6af30012,0x69dd131d}},	//   _मतलब_, lēta_, _مثير, pese
  { {0xcf57000b,0x07080003,0x7e6d020d,0x63a5016d}},	//   גבלת_, ريقي_, umap, wahn
  { {0x32440003,0x9f470029,0xdb1c0002,0x3e45001e}},	// [27b0] _حنيف, rdné_, _obró, nēta_
  { {0x8d740012,0x113c0009,0x68e20034,0x6e240060}},	//   طاقا, _מתחל, dwod, ahib
  { {0xa858000b,0x2ca9006f,0x63a500b6,0xa3d20037}},	//   _איזה_, ssad_, rahn, ह्य_
  { {0xddc4004b,0x50b5003c,0x6fd30060,0xf2040472}},	//   rmiţ, вску, zıcı, лячо
  { {0x6fd300a2,0x601008ec,0xc0e500de,0xf8bf0025}},	//   yıcı, _kämp, толк, nué_
  { {0x7bde007d,0x7640004a,0x3e45001e,0x6d590034}},	//   cepu, enmy, dēta_, _rywa
  { {0xb9950012,0x225b0012,0x99850012,0x68e20034}},	//   _للأب, _فجرب_, _للزو, awod
  { {0xe8d90020,0xfe710003,0x60100da4,0x96fc0009}},	//   _ngữ_, جدت_, _lämp, ללות
  { {0x6fd3003a,0xe1ff0034,0x200c0031,0x36720012}},	//   tıcı, lmów_, ödik_, جهيز
  { {0xb3ca0037,0xea890001,0xb87b0030,0x765b0097}},	//   _सॉफ़्, мбол_, zvír, sluy
  { {0x5dd50003,0x2bb50011,0x23290b48,0x2bc60011}},	//   _لقائ, ूलबा, фони_, र्टा
  { {0x8d870014,0x8e960009,0xc0490009,0x7aea0040}},	//   _чужд, _ידעו_, _וז_, æfti
  { {0x3e45001e,0xf8bf131e,0xec6e091c,0xc2430842}},	//   cēta_, szén_, _вп_, рняк
  { {0xc0e30001,0x5fe10011,0x7d16008e,0x6609079f}},	//   јорк, फ़िल, vyys, ljek
  { {0x5e8c000b,0xada6002d,0xb05b004a,0x6da6072b}},	//   ּאמֶ, кавл, ytäv, кива
  { {0xceb2000b,0x7bd50052,0x82d6000b,0xf8bf0f14}},	//   ייל_, _abzu, _יוצג_, bué_
  { {0x916d0020,0x644100bd,0x59a70037,0x3ddf0070}},	// [27c0] _tối_, onli, _ख़तर, ieuw_
  { {0x6441131f,0x63a31025,0x6609008e,0xd378001b}},	//   nnli, _jenn, hjek, leća_
  { {0xb05b0006,0x3e45001e,0xc20f002d,0xa76601ef}},	//   ttäv, zēta_, ає_, _шкод
  { {0x64410052,0x2bc60037,0x68f60572,0x63a31320}},	//   hnli, र्जा, _kryd, _lenn
  { {0x69c208de,0xdb030040,0xb05b008e,0x2cbf005e}},	//   rgoe, _udnæ, rtäv, juud_
  { {0x64410070,0x63a30052,0x7a360010,0x91bf001a}},	//   jnli, _nenn, kšto, _phụ_
  { {0x2900007d,0x69d600b6,0xe2870012,0x9e340048}},	//   ţia_, _obye, _خذ_, лекч
  { {0x2bcf0037,0x661b002c,0xd3780027,0x6ced0037}},	//   त्सा, gkuk, jeća_, जिंग_
  { {0x916d0020,0xd3780027,0xa2da0037,0xb4be0037}},	//   _mỗi_, deća_, नबक्, ुझे_
  { {0x916d0020,0x3e450039,0x4fea0024,0x29550048}},	//   _lỗi_, rēta_, _імен_, _съср
  { {0x6d440026,0x0c73000a,0x6283007d,0x60100051}},	//   _žiad, جديد, _cuno, _rämp
  { {0xf8bf0061,0x5f370009,0x68f61321,0xd7370009}},	//   tué_, _בטבע_, _bryd, _בטבת_
  { {0xc05b007c,0xac0a0001,0x63a3000e,0x660f1322}},	//   дів_, _онда_, _fenn, _rock
  { {0x63a31323,0xd9180047,0xdfd80048,0x44251324}},	//   _genn, тью_, къс_, chl_
  { {0x6458001e,0xe8030011,0x5f740012,0xfe730012}},	//   _ikvi, लाता_, لافر, لدر_
  { {0x33770093,0xf365002d,0x62810061,0x6377000b}},	//   _בתוך_, _стін, _éloi, _בגוף_
  { {0xf8bf0108,0xde58002d,0x39490002,0x0ba7003c}},	// [27d0] qué_, таті_, żasz_, вшем
  { {0xa4d4002d,0x61ed0c42,0xe3b30012,0x8bb40012}},	//   рофі, _haal, شرط_, لإما
  { {0xe298002d,0xe7ec0037,0x41a70037,0x63a80029}},	//   ває_, _छोटा_, _ख़ास, iadn
  { {0xc333000b,0xeab00012,0x63a80042,0xa3d90011}},	//   סוף_, زعم_, hadn, _डॉन_
  { {0xa954002d,0x25a90643,0x39490017,0x66090027}},	//   акці, maal_, ças_, vjek
  { {0xab94007c,0x973c0027,0xd3780027,0xa6c9010c}},	//   _вирі, _seća, zeća_, елка_
  { {0xb05b004a,0x64410623,0x63a31325,0x7a260097}},	//   ltäs, vnli, _renn, _hóte
  { {0xff7c000b,0xdb030061,0x25a90562,0x24e900de}},	//   וטומ, _fenê, naal_, емии_
  { {0x66090051,0xb05b004a,0x69cc0042,0x34b20012}},	//   rjek, ntäs, ílež, مميز
  { {0xe3b1000a,0x661b0006,0x8d5c000b,0x63a80d27}},	//   حرة_, skuk, וכחי, gadn
  { {0xc5d5007c,0xc4d00037,0xbcfb000e,0x7cfd0028}},	//   _біль, _सङ्ख, _szél, færð
  { {0x26040037,0xa2c40011,0x3e450035,0xbcf50012}},	//   वाणी_, ांत्, mēto_, _مستغ
  { {0x3e45001e,0xbd280003,0x91f6000b,0xb05b008e}},	//   lēto_, _لأول_, אמרו_, ytät
  { {0x395e0039,0xc9520009,0xaa890012,0x2cad005e}},	//   āts_, צמם_, _كنتم_, msed_
  { {0x18670098,0xb05b0d4a,0x61ed003a,0x2cad1326}},	//   уари_, kräf, _faal, lsed_
  { {0xd5e20020,0x2bcf0037,0xc692000b,0x22920003}},	//   _khó, त्रा, מאל_, _اليس
  { {0x05661327,0xdd8f0012,0x26040011,0x2cad0912}},	// [27e0] уван, سول_, वाती_, nsed_
  { {0x309b0093,0x69c9000d,0x69c60070,0x53a60003}},	//   _רשימ, _acee, lgke, اماك
  { {0x3ce50044,0xdb010029,0xd2960024,0xdd120035}},	//   _जैसे_, kalí, урзь, _kļūt
  { {0x2cad0051,0x1d0a0014,0xb05b0aa0,0x69c600ed}},	//   ksed_, _земи_, stät, ngke
  { {0xd5e20020,0x3e4c0013,0xa8560009,0x09360012}},	//   _nhó, něte_, ְיֶה_, دراج
  { {0xcaa60003,0x6e221328,0xd0070014,0x3a261329}},	//   _مصري, _slob, лече_, shop_
  { {0x44440163,0x2cad012e,0xd5e2001a,0x63a80121}},	//   mn_, esed_, _phò, vadn
  { {0xe4e6007c,0xa2810002,0x4444132a,0x9e660012}},	//   гіон, łość_, ln_, داتن
  { {0x39460001,0xd5e2001a,0x2cad005e,0xb146004c}},	//   _снаг, _chó, gsed_, _снал
  { {0x69c6000e,0x4444132b,0xc94b0009,0xf7860012}},	//   egke, nn_, _אֲבֹ, _إلاَ
  { {0x26040037,0x2cad002a,0x61ed002c,0x501b000b}},	//   वादी_, ased_, _paal, _רובו
  { {0xc3330093,0x44440052,0x3377000b,0x443a132c}},	//   מות_, hn_, טעים_, hip_
  { {0x7e7d01a2,0xddc900a2,0x443a0827,0xdddb003a}},	//   _risp, lleş, kip_, lmuş
  { {0x3e41007a,0x44440377,0x43940489,0x8c43132d}},	//   mėti_, jn_, _такс, _лече
  { {0xddc900a2,0x25a90070,0x61ed0070,0x3e410010}},	//   nleş, taal_, _taal, lėti_
  { {0xb05b008e,0xa5070048,0x39150adc,0x4444132e}},	//   ttäs, лязл, _вмир, en_
  { {0x7e7d0039,0x44440028,0x3e410010,0x3e45001e}},	// [27f0] _visp, fn_, nėti_, zēto_
  { {0xddc900a2,0xb05b132f,0x8574002d,0x734b0345}},	//   kleş, dräg, слух, нчев_
  { {0xb05b1330,0xe8030011,0x9b440012,0x78bc0035}},	//   stäs, लासा_, منكو, _ārva
  { {0x443a007a,0x3e41007a,0x636f000e,0x32b80012}},	//   aip_, kėti_, lóné, ادلة_
  { {0x9f470066,0xda4c0009,0x28f80024,0x9df8003c}},	//   rdní_, עֲבָ, лець_, _снят_
  { {0x3e41007a,0x2cad0051,0x25a9009b,0x76b50001}},	//   dėti_, vsed_, _žal_, аљиц
  { {0xe6110012,0xb7fc0009,0xb05b0032,0x7ceb0248}},	//   قشة_, תפות, präf, _förå
  { {0xed59005c,0x2cad0051,0x3e45001e,0x6d5d0002}},	//   кой_, tsed_, rēto_, żsam
  { {0x10d80003,0x3e45001e,0x4c850001,0xa5f6004c}},	//   _مبلغ_, sēto_, јлов, рењу_
  { {0xf3f20009,0xa87b0012,0x660d0269,0x24520012}},	//   ַ֣ת_, _أحرر_, hjak, ينيس
  { {0x7f84000a,0x2cad0036,0x63bc0065,0x3169000e}},	//   _المن, ssed_, órna, _azaz_
  { {0x3e41007a,0xd57500be,0xa4d5002d,0x26c30164}},	//   bėti_, _куль, _воді, dujo_
  { {0x443a003a,0xeb8e1331,0xfc05003c,0x3d010011}},	//   yip_, _ми_, _впло, ोहों_
  { {0x63a70066,0xfaf8001e,0xa0680009,0xe3b90024}},	//   _nejn, _šīm_, ָׁלַ_, _рбк_
  { {0xbf650003,0x4444024c,0x4c3a0009,0x96b9004c}},	//   مدفو, vn_, _שתצב, луту_
  { {0xe8fa0046,0x44440742,0x644f0061,0x6abc0028}},	//   _али_, wn_, écif, árfe

  { {0x6fd6002d,0x62870061,0x4a5b000b,0x62730003}},	// [2800] _кінц, _aujo, _בדקו, _بهيئ
  { {0xd00f0003,0x44441332,0x26c301e3,0xf8bf0031}},	//   _يلي_, un_, bujo_, zzék_
  { {0x67bb000b,0x62870017,0xd7bb0009,0xfbb60009}},	//   _במיק, _cujo, _בציר, שפעת_
  { {0xb05b0052,0x79850012,0xdb0301a0,0x60c2008e}},	//   träg, مؤهل, _venè, tuom
  { {0xda65000a,0x854700b3,0x859b0009,0x26040011}},	//   حالي, _взяв_, _בשכו, वासी_
  { {0x60c2007a,0x6d4e003a,0x58f7000b,0xddc9003a}},	//   ruom, şbak, ימנע_, tleş
  { {0x2120048b,0x60c20010,0xc7b30009,0xfae70012}},	//   ših_, suom, קבה_, _بث_
  { {0xddc900a2,0xfe6f0003,0xe363002d,0x6b63002d}},	//   rleş, ودي_, _єкти, _єкта
  { {0x394d003e,0x7c280444,0x7bc30097,0x9c460bda}},	//   żesz_, thdr, ónug, ихол
  { {0x3e41007a,0x7ed6002d,0x6fb30012,0xf7e90012}},	//   rėti_, _відч, _ومقا, _مرمى_
  { {0x752d01a2,0x23380015,0x8c1b0009,0x3e410073}},	//   zzaz, упны_, דויי, sėti_
  { {0xd258002d,0x25dd0037,0x7f3b000b,0x3e410010}},	//   иця_, _कॉपी_, _בעבו, pėti_
  { {0x04940351,0x7c94000a,0x3ea90027,0x7c3a0c0c}},	//   _التح, _التص, ćate_, pitr
  { {0x34fb000b,0xd3a30048,0xe824003c,0x1b2a0012}},	//   _שהגד, _дръп, офсо, _لأبي_
  { {0xb5a70014,0xfda70001,0x63670014,0xbe8805c6}},	//   ирай, ијам, _кръг_, исте_
  { {0x6d5c00a2,0xe37b000b,0x6b7b000b,0xdd9806fd}},	//   ğraf, _ברור, _ברונ, ишу_
  { {0xcec40066,0xb05b006f,0x9f4500d9,0x660d1333}},	// [2810] teří_, träd, _malá_, rjak
  { {0x2bb80003,0x22460029,0x7bc81334,0xa3b80012}},	//   لامة_, enok_, ngdu, لامر_
  { {0x2d820029,0x5fdc0009,0xd37b003c,0x22470030}},	//   ľkej_, _יחזק, тча_, énko_
  { {0x9756000b,0xdb01000e,0xca840024,0x672d0035}},	//   _לשתף_, nalá, ігій, ģijā
  { {0x66ec0037,0x62801335,0x69cf0011,0x26de0c9d}},	//   झिझक_, _dimo, _थानी, _apto_
  { {0x1d16000b,0x3eb10002,0x7860008e,0x290b01a0}},	//   _הקשר_, oszt_, tövi, ixca_
  { {0x6dbb0034,0xdb0101e9,0x87d40012,0x6fb20012}},	//   ałał, kalá, تغنا, سميا
  { {0xf2d2000b,0xee320009,0x59c60011,0xf9900012}},	//   _מעל_, ּֽה_, _वाइर, _يبق_
  { {0xdb01000f,0xe4590014,0x6e290052,0x315b0012}},	//   dalá, лжи_, rheb, _شجرة_
  { {0x9f4c014a,0x98140012,0x10140012,0x4084034d}},	//   ždé_, _وبلا, _وبلد, _футб
  { {0xdce7003a,0x7a3605b1,0x68ed1336,0x8e850012}},	//   ımız, lšti, _asad, _الصه
  { {0xdb01000e,0xd1ba0012,0x2bd80011,0xa5bb0097}},	//   galá, دادا_, ब्बा, _blóm
  { {0xc9560047,0xf8bf0061,0x7a3600d9,0x26040011}},	//   стны, gré_, nšti, वारी_
  { {0x33950003,0xb4fa000b,0x765d1337,0xeb960024}},	//   _الغز, _תפסי, _aksy, _лиш_
  { {0xd7f10020,0x68ed00c1,0xc2e80012,0xd62a05f7}},	//   _mã_, _esad, _نعيم_, гове_
  { {0x7a360010,0xbbb70011,0xdb080025,0xb05b0032}},	//   kšti, _आयुक, xadé, gräb
  { {0xcc880020,0x61e61120,0xf8bf0061,0x62801338}},	// [2820] _lớn_, mekl, cré_, _rimo
  { {0x2137000b,0x442700b6,0xa3ba0012,0x69db01e3}},	//   _לטפל_, _jln_, طائر_, _abue
  { {0xfc3f0054,0x38170009,0xf0170009,0x63a70034}},	//   _avís_, _הקים_, _הקיץ_, ójny
  { {0x61e600a2,0xd259007c,0xb3460017,0xddcd0060}},	//   nekl, аці_, leçõ, mlaş
  { {0x25a000c6,0x656f0029,0xdb08000e,0xe5f70009}},	//   mbil_, ýchl, radé, _הזכר_
  { {0x5fdb0037,0x98a20034,0xd8d70009,0xe2aa0012}},	//   म्पल, czką_, מונט_, _مارن_
  { {0xddcd003a,0x7a360027,0x26040011,0x6dbb0034}},	//   nlaş, ašti, वाली_, słał
  { {0x7e9b0009,0xdee50012,0x9e140024,0x291d0034}},	//   נספו, تأهي, ідпі, bywa_
  { {0xa9260047,0x2bcf0037,0xc5f3000b,0x68fb1339}},	//   _удал, स्का, לדה_, _grud
  { {0xddcd003a,0x7c930003,0xe3b8003a,0x52d80024}},	//   klaş, أشيا, akın_, амою_
  { {0xdb01082b,0x2bf7000b,0x5f760003,0x57fb0009}},	//   talá, זמין_, _طائر, _תלבו
  { {0xad9b05ab,0x5d86000a,0xc0cb0046,0xcb13000b}},	//   _anún, _الإل, луге_, ללת_
  { {0xfdf7000b,0x661d004a,0xd2640035,0xe3b20012}},	//   _לצאת_, öske, ciņš_, _فرغ_
  { {0xdb01000e,0xf8bf133a,0xd7f10081,0xddcd0060}},	//   salá, rré_, _xã_, flaş
  { {0x501b000b,0x6fda0037,0x8bd7000b,0x291d0002}},	//   נולו, प्यू, _לוגו_, zywa_
  { {0x7e64002c,0x7e91001e,0x61e60c07,0x645a133b}},	//   glip, _jāpa, cekl, loti
  { {0x4238000b,0x68ed133c,0x443e133d,0x7c150024}},	// [2830] _לנהל_, _usad, oit_, одає
  { {0x442706f4,0x7a360013,0xf3f1001a,0x3ce00011}},	//   ón_, všti, họn_, _कहने_
  { {0xfa89001a,0x60080009,0x443e005e,0xd2640035}},	//   _lẫn_, _הִרְ, iit_, ziņš_
  { {0x443e0101,0x7e64000d,0x1df90015,0x92590015}},	//   hit_, clip, _темы_, шает_
  { {0x443e0cb4,0x89a80024,0x645a133e,0xc4c60012}},	//   kit_, сків_, koti, _تْ_
  { {0xa6950046,0xd5bf001e,0x3e45001e,0x96950001}},	//   ориј, žādu_, mēti_, ориш
  { {0xa3be0037,0x645a01ff,0x03090009,0x59c50012}},	//   ेलन_, doti, _דִּֽ, _ويسك
  { {0x7a360027,0x9d550003,0x6448133f,0xbb480012}},	//   pšti, ينغت, endi, _الفن_
  { {0x9f5e03eb,0x442700b6,0x3e45001e,0xde160012}},	//   _botó_, _pln_, nēti_, تقيت_
  { {0xfa890020,0xddcd00a2,0x8fa40001,0x3a29000e}},	//   _dẫn_, ylaş, _нађе, _alap_
  { {0x33650003,0x27e7081f,0xcb690426,0xc1690009}},	//   تهدف, menn_, ране_, _סח_
  { {0x443e1340,0x69cb1341,0x6b9c0060,0x24830227}},	//   ait_, ngge, ırga, _lijm_
  { {0xe3ae0094,0x9f5e000e,0x61e61342,0xa5670012}},	//   _об_, _fotó_, rekl, _ادان
  { {0xf0920093,0x63aa0028,0xa5bb0028,0xb97a0009}},	//   ונך_, _gefn, _flók, ינרי
  { {0xb3460018,0x98ab0035,0xdb070031,0x9f290009}},	//   reçõ, ājās_, _fejé, בֵּ֖
  { {0x22b50039,0x7649004a,0xb05b031d,0x0e660024}},	//   māk_, nney, träc, ікан
  { {0x22b50039,0x3ea00027,0x22a7000e,0x682b0052}},	// [2840] lāk_, ćiti_, lők_, _süde
  { {0x27e70033,0x37c60012,0x629800d9,0x9c820064}},	//   jenn_, _بيدف, _ytvo, _účta
  { {0x74130012,0x22b50035,0x69d90032,0xff0a004c}},	//   بولا, nāk_, ffwe, _тенк_
  { {0xddcd01b3,0x7c3e007a,0x20d2000d,0x443e1343}},	//   rmaţ, sipr, tâi_, zit_
  { {0x3ead001c,0x64480de9,0xe611000b,0x7d0b08ec}},	//   ćete_, yndi, _אִם_, ägst
  { {0x2fc00052,0x7649003a,0x443e1344,0xceba004c}},	//   ßig_, eney, _öt_, аљи_
  { {0xdcf6003a,0x26c70164,0x443e1345,0x9f4c00b8}},	//   mayı, guno_, vit_, _andò_
  { {0xdcf600a2,0x20050b4b,0x22a70031,0x22b50035}},	//   layı, _enli_, dők_, dāk_
  { {0x629e004a,0xa5070001,0x62981346,0xdb030066}},	//   lppo, жења_, _stvo, _dení
  { {0x186a0098,0xfa890020,0xbfc30001,0x47c3004d}},	//   _тази_, _vẫn_, _обук, _обув
  { {0x2bcf0037,0x63aa0028,0x7e91001e,0x3e45001e}},	//   स्टा, _vefn, _tāpa, zēti_
  { {0x2d9200a2,0x0dc7022a,0x2a720066,0xed5a010c}},	//   _üye_, _души_, _chyb_, _кое_
  { {0xda7b0093,0xf1b3000b,0x443e1347,0x3d040011}},	//   ינטר, וסר_, pit_, रमों_
  { {0x7640007a,0xc05b002d,0x22b5001e,0xb6020066}},	//   limy, рім_, bāk_, řádk
  { {0x539b000b,0x54570009,0x6e2d0e00,0x2a66020d}},	//   _דיוו, _וסגן_, thab, klob_
  { {0xd3780027,0x60c2014a,0xb5fb0042,0x5e450012}},	//   jeći_, krom, _cháp, أَرْ
  { {0xd378001c,0x6e2d004e,0x644b0025,0x98be004b}},	// [2850] deći_, rhab, égio, ătă_
  { {0x1c050037,0x3e45001e,0x93270012,0x04670024}},	//   राइल_, rēti_, يران, ітам
  { {0x7640113b,0x6e2d1348,0xde590024,0x3e450035}},	//   kimy, phab, _гані_, sēti_
  { {0x52150015,0xd1b80012,0x36190009,0x69d90032}},	//   ядет, قاها_, _הוֹד, ufwe
  { {0x22b5001e,0x22a7000e,0x26080037,0x85960009}},	//   zāk_, zők_, हारी_, _מדרג_
  { {0x389c000b,0xf8bf000e,0xf807048c,0x251a0009}},	//   סיונ, lzés_, ючен, _הושא
  { {0xd00e0003,0xdce6001e,0x224d0058,0xdb031349}},	//   الى_, _izkā, _tjek_, _pení
  { {0x06090731,0x3e610028,0xf8bf0a27,0x9258003c}},	//   сник_, jótt_, nzés_, _даст_
  { {0xe4d60003,0xdb0301e3,0x60c2134a,0x76490a0c}},	//   كويت_, _vení, crom, rney
  { {0x22a7000f,0x87070003,0x22b5001e,0x98a20034}},	//   tők_, _وبال, tāk_, czkę_
  { {0xa3dd0037,0x2bdd0037,0xa2c00037,0xdb0311f8}},	//   थ्य_, न्या, _विण्, _tení
  { {0x22b50039,0x26f90037,0x2c6d022d,0x38c20028}},	//   rāk_, ्मीर_, _vždy_, _nærð_
  { {0x48fe0011,0x78720040,0x22a70031,0x22b50035}},	//   लियो_, hæve, sők_, sāk_
  { {0x3ce00037,0xd848001a,0xb4fa000b,0xeab10012}},	//   _कहते_, họn_, _לפני, _كعب_
  { {0x0e6a0003,0x44ed0107,0x539a0009,0xdbc6005e}},	//   مصري_, _až_, _פיקו, töök
  { {0xb2ba000b,0xa2c00037,0xa2ba000b,0x69db0051}},	//   _המקר, _वित्, _המקט, õuet
  { {0x973c0027,0x6c860003,0x3cf60037,0x718b0009}},	// [2860] _veći, سلام, ँटें_, _לְיַ
  { {0x1bf30037,0x22420033,0x77ca0001,0x3e45001e}},	//   _असफल_, likk_, _улог_, mētu_
  { {0xdcf600a2,0x38c20065,0xd3780027,0xf8bf000e}},	//   rayı, _færð_, teći_, szét_
  { {0x7aba0093,0xcc88001a,0xdcf6003a,0xfe790066}},	//   מצעו, _sớm_, sayı, jmů_
  { {0xd3780027,0x3e45001e,0x6441134b,0xf9930009}},	//   reći_, nētu_, kili, גרד_
  { {0xb05b008b,0xf093000b,0xd3780027,0xf8b70009}},	//   hrän, ענו_, seći_, לפני_
  { {0xd7f1001a,0xe9a6002d,0xdb080837,0x7fd70009}},	//   ỗi_, _навп, tadí, פוקס_
  { {0xa3d90037,0x11da0003,0x682b003a,0x26c5001b}},	//   ड्स_, _دورة_, _müda, šlog_
  { {0xdced0029,0x786d0029,0x42530012,0x90a50012}},	//   zbaľ, súva, _أنقر, _يحكم
  { {0xa2c00037,0x3e45001e,0x988b000b,0x351b0009}},	//   _विद्, dētu_, _הָאֵ, צוינ
  { {0x644f0108,0x22420119,0xa5bb0002,0xdb080017}},	//   écia, fikk_, _glów, dadã
  { {0xb05b0163,0xdee50003,0x7ae10052,0xdb030018}},	//   grän, _تأكي, _älte, _senã
  { {0xe1ff134c,0x6441134d,0x2167027f,0xca370009}},	//   blón_, bili, ятог, לנטה_
  { {0xb8f5015f,0x629c134e,0x645e0027,0x60c0000e}},	//   _हम_, _otro, jopi, ámma
  { {0x33db000b,0xe2a3001a,0x7bdb0009,0x30340012}},	//   _החוד, _chứ_, _הקוו, رِّر
  { {0x7e9b0009,0x3e450035,0x2bd80011,0xba9b0009}},	//   מסלו, bētu_, ब्रा, _פסחי
  { {0x91bc0093,0xc1bc000b,0x629c134f,0xf8bf000e}},	// [2870] _המחי, _המחש, _atro, rzés_
  { {0xa3be0011,0xf8bf0031,0x753d0031,0x69dd02a2}},	//   ेलि_, szés_, úszi, lfse
  { {0x99890066,0xf1d40037,0x2bd40011,0x41d10011}},	//   íkům_, _थामन, _दाना, _हादस
  { {0x3a26002c,0x78720058,0x682f0058,0xceb20009}},	//   gkop_, ræve, _møde, _ביט_
  { {0xbcfb000f,0xe0ce0014,0xc5fa000b,0x44ed1350}},	//   _ezér, ъв_, _ופרט, _už_
  { {0x23c30108,0x9f4700f1,0x7a360029,0x92c2003a}},	//   _déjà_, lené_, nštr, üşün
  { {0x3e450039,0x320900a2,0xfe790030,0x3a260227}},	//   zētu_, _onay_, tmů_, bkop_
  { {0x9f470026,0xdb070066,0xc7440003,0xdb0301e9}},	//   nené_, _její, عضوي, _nená
  { {0x28080066,0x6292001e,0x81170012,0xf8b90012}},	//   átní_, ējoš, _عذرا, _ذهاب_
  { {0x4b25002d,0x60cb002c,0xd8740012,0xa2f50009}},	//   дмов, mugm, _كالب, ֵמָה_
  { {0x61f600a2,0x22420033,0xbb850003,0x28080066}},	//   _payl, tikk_, بلدي, štní_
  { {0xf8d10037,0x20d10037,0x923a002d,0x249f0028}},	//   _समाय, _समाध, ічну_, ppum_
  { {0x9f4700f1,0x64410175,0xd3780027,0x22420033}},	//   dené_, pili, deću_, rikk_
  { {0x3e450039,0xaac50037,0x26d800c1,0x7e620066}},	//   rētu_, _विपक, ttro_, _zkop
  { {0xcc56000b,0x26d81351,0x6fdf0011,0x2bcc0011}},	//   _קבצי_, utro_, प्यं, ालसा
  { {0x764d0101,0x3e4500cd,0x74a40011,0x290001a0}},	//   gnay, mēts_, चीकृ, _tria_
  { {0x3e45001e,0x629c1352,0xdb081007,0x645e1353}},	// [2880] lēts_, _stro, madá, topi
  { {0xe2a30020,0xf3ca0012,0x6c330012,0x682d0034}},	//   _thứ_, تبره_, نفقا, aźdz
  { {0x3e45001e,0x3e48000d,0x9f4701bd,0x2bdd0011}},	//   nēts_, eşte_, bené_, न्धा
  { {0xa2c00044,0xfaf80039,0xc332000b,0x9f470066}},	//   _विस्, _šīs_, כוב_, cené_
  { {0x08970003,0xc27b0009,0xdb080031,0x20d30012}},	//   وضوع_, קרני, iadá, نتوج
  { {0xb9370009,0x0ee20011,0x889b0009,0x2bdd0011}},	//   וננו_, _पहाड, קבצי, न्दा
  { {0xe7e00044,0xdee30001,0xdb01000e,0x63830511}},	//   ख्या_, воји, bblé, _агра
  { {0x4e770003,0xbb3b000b,0x61eb00c1,0x3e45001e}},	//   وحيد_, _ועלי, cegl, dēts_
  { {0x40930012,0x01d70012,0x83fc001b,0x01630aa2}},	//   _للقر, _توقع_, hođe, _акто
  { {0x83fc001c,0x2240000e,0x9f47022d,0xdb0305b1}},	//   kođe, _amik_, zené_, _sená
  { {0xcc880020,0xd6cf0003,0xac370012,0x97260012}},	//   _mới_, _نقل_, بسيط_, _تفاو
  { {0xdb08000f,0xd6260003,0xc7b80027,0x44441354}},	//   gadá, _تعطي, _dođe_, hi_
  { {0x9f47022d,0x69dd0028,0x99490012,0x7c2e1355}},	//   vené_, rfse, سلسل_, _olbr
  { {0x61eb003e,0x7e6000c6,0x9f430066,0x6bd70003}},	//   zegl, lomp, sejí_, _يونس_
  { {0x83fc0027,0x290d000d,0x3e45001e,0x9f471356}},	//   gođe, ţea_, cēts_, tené_
  { {0x41e7002d,0x98b90048,0x5c99003c,0xf1b90030}},	//   _ціка, _елит_, зкая_, _koše_
  { {0x9f470029,0x5c751357,0x49d60009,0x7bde0032}},	// [2890] rené_, елат, _אֵין_, ffpu
  { {0x68300051,0x78a200f1,0x83fc0027,0x9f4c01bd}},	//   _päde, dpov, bođe, ždá_
  { {0x64890010,0xf1b90027,0x7e6900d9,0xb5fd1358}},	//   _džia, _loše_, ylep, loše
  { {0x60cb002c,0x6830006f,0x7d02000e,0x05190003}},	//   tugm, _väde, _oros, _فيجب_
  { {0x5d850003,0x3e45001e,0xb5fd0027,0x759a0009}},	//   _سلسل, zēts_, noše, _מסרג
  { {0x61eb0d6c,0x46f500b3,0xcf250012,0x2c050011}},	//   segl, ечит, فرعي, राओं_
  { {0x661d0006,0x64450c2a,0x61eb1359,0xa2c00011}},	//   _kosk, mihi, pegl, _विष्
  { {0x6445002c,0x661d004a,0x7d02135a,0xfe710012}},	//   lihi, _josk, _bros, ددت_
  { {0xdfdb0014,0xca29000b,0xa8a7002d,0x74150003}},	//   _мъж_, _ִם_, _ірак, فوظا
  { {0xa2c00044,0x64450101,0x7e690051,0x7af50002}},	//   _विश्, nihi, slep, _kszt
  { {0x43740024,0x6445008e,0x24160009,0x5ed40012}},	//   куют, iihi, תחתן_, _لتنز
  { {0xc8690093,0x64450101,0x661d0039,0x83fc0027}},	//   _הן_, hihi, _nosk, vođe
  { {0x65941154,0x444400a2,0x64450101,0xfce5002d}},	//   _рачу, yi_, kihi, _чоло
  { {0x7bc30028,0x7af5000e,0x9d1a000b,0x4444135b}},	//   ónul, _oszt, _מונט, xi_
  { {0xbcfb000e,0xcf920009,0x26040011,0x9e76004c}},	//   _szép, רטל_, वाची_, ећај
  { {0x26120037,0x62890002,0x44440a87,0xceb20009}},	//   थायी_, _nieo, wi_, טיל_
  { {0x2bb60037,0x7af5000e,0x661d084b,0x6a440031}},	// [28a0] _आजमा, _aszt, _dosk, lőfo
  { {0x3ec500a2,0x4d63002d,0xdb030097,0xa7fc0060}},	//   üstü_, укув, _venæ, _akın
  { {0xdb0c000e,0x660b00b6,0x79fa0009,0xfeba0012}},	//   űköd, _ongk, ּלְח, _عادت_
  { {0xcc88008a,0xf1b20012,0x5e460012,0xdb060030}},	//   _với_, اءا_, _أَحْ, áméh
  { {0x64450101,0x67d40001,0x7af50031,0x26c7135c}},	//   bihi, волу, _eszt, erno_
  { {0xcc880020,0x3e4c0066,0xd6d00003,0x660b0a26}},	//   _tới_, měti_, لقت_, _angk
  { {0xdb0a00c5,0xad9b0028,0x67b70012,0x97a50024}},	//   _udfø, _snúi, راوح_, тріл
  { {0x89a50012,0x95d70048,0xdb240097,0x7d02135d}},	//   _لإكم, едът_, ðsíu, _pros
  { {0xfd120003,0xb17b006f,0x54540646,0xda650012}},	//   اجع_, neåt, квит, _شافي
  { {0xccf30093,0xe0860003,0x88bb0009,0x660b016d}},	//   רכז_, _أجري, _מזמי, _engk
  { {0x200c135e,0xf2e5000d,0xbd8a0012,0x2259003c}},	//   _indi_, ţând_, _فنان_, дины_
  { {0xd5d60012,0xb05b008e,0x7d02135f,0x7c281360}},	//   _ستؤث, rräm, _tros, skdr
  { {0xdca3002d,0x661d004a,0x6445004a,0x64a30024}},	//   _бачи, _rosk, yihi, _бача
  { {0xdb07000e,0xb5fd04d2,0xdb030248,0xf5370009}},	//   _lejá, roše, _benä, _אנדי_
  { {0xadf40037,0x63bc0028,0x3ca90011,0xabfb0009}},	//   _आसान_, órnu, _चौड़ा, _מהגר
  { {0xfe730012,0x29041361,0x5eeb0009,0xab2900ae}},	//   ادس_, _orma_, הַמְ, _تسهل_
  { {0xa5bb0028,0xebc70001,0xf1bf0066,0x64451362}},	// [28b0] _slós, ељен, nkám_, tihi
  { {0x93940003,0x7d06004a,0x69c008b9,0x201e1363}},	//   هجما, äksy, _adme, _noti_
  { {0x644500a2,0x61e80031,0x49d90024,0xdb070031}},	//   rihi, ődle, ддею_, _bejá
  { {0xa294002d,0xb6ba0009,0x200c1364,0x1dd00011}},	//   уаці, _קצרי, _andi_, _सफ़लत
  { {0x7e6d0039,0xe1f00003,0x68300a9d,0xdb0701e3}},	//   mlap, إسم_, _häda, _dejá
  { {0x7e6d1365,0x2898000b,0xab950001,0x7bd50002}},	//   llap, עדון_, _јављ, _uczu
  { {0x316c003e,0xe4540015,0xcc540014,0xf4560009}},	//   ędzi_, _скры, _свръ, _יישר_
  { {0x60c4007a,0x7e91001e,0x7e6d000e,0x682b0052}},	//   šima, _jāpi, nlap, _südl
  { {0x9f4a0054,0x6cd20003,0x9f471366,0x25dd0011}},	//   rebé_, لقيا, mení_, क्षी_
  { {0x9f470145,0xcce40003,0x61fb0824,0xe3b10012}},	//   lení_, اسيي, _haul, جرة_
  { {0x68300005,0xe1bf0037,0xe8d10037,0x26dc01e9}},	//   _näda, ्लंघ, _समुच, ctvo_
  { {0x9f470029,0x660b010a,0x6f480009,0xff160009}},	//   není_, _ungk, _אֲנַ, _בקעת_
  { {0x29040065,0x7e6d001e,0x91ba000b,0x60dd0040}},	//   íma_, dlap, ומרי, gtsm
  { {0x25dd0037,0xd0120003,0x69a20011,0x91a20011}},	//   क्री_, جلس_, _क्री, _क्रै
  { {0x998f0010,0x023a0003,0x23bc0030,0x60dd1367}},	//   nigų_, _يثبت_, hájí_, atsm
  { {0x9f470145,0xdb03004a,0xe8d10011,0xa7fc0060}},	//   jení_, _venä, _समूच, _akıl
  { {0x9f470042,0x44310227,0x0d860db7,0x6a781368}},	// [28c0] dení_, _blz_, тлан, nífe
  { {0xe0b70009,0x6faa0012,0xd9ba0011,0x2bdd0011}},	//   _שליט_, _تهدف_, उण्ट, न्ला
  { {0x3daa0015,0xe9da0015,0xb5fd0029,0xcb0a0003}},	//   _окно_, дке_, alši, بيان_
  { {0x7229002d,0x64890010,0x1e970009,0xdb030040}},	//   нців_, _užin, _שככל_, _genå
  { {0x6c860003,0xb7b5001a,0x314d0009,0x201e1369}},	//   _للحم, _vọn, ּתוּ, _poti_
  { {0x03a3007c,0x493b0009,0x69dd0248,0x913b0009}},	//   _виро, וגנו, _ösen, וענק
  { {0xddcd000d,0xf837000b,0x044300b3,0x9f4700d9}},	//   noaş, כנסת_, _терн, bení_
  { {0x9f470013,0xceb3000b,0x1af70009,0x69a20011}},	//   cení_, ביה_, _במלל_, _क्ली
  { {0x2904000d,0xb8e50012,0x71660012,0xba550048}},	//   _urma_, _مثله, _شارك, _стръ
  { {0xfa8a0020,0xa1050003,0xa84a0012,0x2d8f00b0}},	//   _mẫu_, _حذفه, _غلام_, _egge_
  { {0x0bb7000b,0xd7760003,0x83fc0027,0xfbd30009}},	//   כלים_, _شائع, gođa, בתת_
  { {0xda350015,0x61e20052,0xd7d20037,0xb2bb0009}},	//   уемы, nfol, _साँच, ומטר
  { {0x2e37000b,0xcc88001a,0x9f450042,0x7a260097}},	//   _בראש_, _bớt_, _malý_, _nótu
  { {0x9f4708cd,0xa4b70009,0xa3b60011,0xc7c4003c}},	//   zení_, _ילדה_, _ज़ि_, исси
  { {0xb5fd001e,0x80cc0011,0x6f240024,0x53330048}},	//   loša, _समझे, аєте, _вещт
  { {0xe654002d,0xb5a40015,0x64430002,0x2d8f0058}},	//   авсь, ируй, _zmni, øge_
  { {0x3d0d0044,0xb5fd0039,0x9f47014a,0x55750014}},	// [28d0] समें_, noša, vení_, угат
  { {0x7e6d039c,0xd0f8000b,0x8434002d,0xd7f10012}},	//   slap, _יצחק_, анує, _اكد_
  { {0x68e900c1,0x9f470004,0xa3c40011,0xfbd00012}},	//   _sped, tení_, _एयर_, غتك_
  { {0xb5fd001e,0xe1ff0bb6,0x6e3600d9,0x2c790025}},	//   koša, ndó_, chyb, mède_
  { {0x89a8002d,0xb5fd001e,0x9f470029,0xe0df00c1}},	//   тків_, joša, rení_, ntò_
  { {0xb5fd0039,0x29c3001a,0x3e5a01bd,0x9f4705b1}},	//   doša, ựa_, rďte_, sení_
  { {0x36690047,0x64480f68,0x2bb60037,0x61fb136a}},	//   нако_, didi, _आज़ा, _taul
  { {0xd5b10003,0x83fc0027,0xd9bf0011,0xc7b8001b}},	//   حفظ_, vođa, ्लोट, _vođa_
  { {0x7a260065,0x9f43004a,0xb5fd001e,0x229a001e}},	//   _mótt, lejä_, goša, _rīka_
  { {0x6e950048,0xb05b0032,0x78bd0097,0x6448136b}},	//   _бижу, bräi, dssv, gidi
  { {0x96fb0003,0x84580014,0x6e2d003a,0xdddd0064}},	//   _تعذر_, ърът_, kkab, _zisť
  { {0xb5fd001e,0x9f4701a0,0x98a00073,0x6448136c}},	//   boša, menà_, šią_, aidi
  { {0xfd100003,0x26c5000e,0x3c360058,0x4a430048}},	//   _وجه_, álon_, _hæve_, сняв
  { {0x9f430006,0x7a260017,0xc1bf0011,0xa6aa0012}},	//   kejä_, _rótu, ्लॉग, فارق_
  { {0x7529000e,0x3ebe0028,0xae170037,0xdb010051}},	//   lyez, étt_, थापन_, nalü
  { {0x661b00c6,0x6e2d002c,0x672102eb,0xb17b0262}},	//   njuk, gkab, älja, reår
  { {0x753b0052,0xddc40010,0x8c95002d,0xab64003a}},	// [28e0] nzuz, gliš, архі, zcüğ
  { {0x1c0e0037,0x661b0051,0x6e2d0376,0xbc6a0012}},	//   साइल_, hjuk, akab, رمان_
  { {0x49ca022a,0xd62a011d,0x73950024,0x316d0025}},	//   елен_, _зоне_, ршує, _ayez_
  { {0x32650024,0xb05b0248,0xddc40159,0x6448136d}},	//   атів, tsäg, bliš, zidi
  { {0x28f80800,0xad9b0029,0x9f470029,0x61e2136e}},	//   тель_, _vnút, rdný_, rfol
  { {0xe1ff0031,0xdb030411,0xb5fd136f,0x60c40073}},	//   rlói_, _denú, voša, šimo
  { {0xb7db000b,0x9e14002d,0x7ee30012,0xeaa70012}},	//   תקצי, идкі, مكون, _دع_
  { {0xb5fd0039,0xceb3000b,0xb87b0c56,0x9ed70048}},	//   toša, זיה_, otíc, умът_
  { {0x2fd60003,0xd83f009b,0x25b90028,0x7529000e}},	//   _متاح, ščih_, ðsla_, gyez
  { {0x2a66002c,0x09bf0037,0xb5fd013c,0x3e57004b}},	//   loob_, ्ल्य, roša, răta_
  { {0xd793000a,0x78a40149,0x7d040006,0x6f930003}},	//   _المخ, _ativ, hvis, _المض
  { {0xa2cc0037,0xd357000b,0xb5fd1370,0x5e9b0009}},	//   _हिन्, ריטי_, lošn, _נבדק
  { {0xc5f30093,0xa2c00037,0x9f47014a,0xd5bf0035}},	//   _לדף_, _विक्, mená_, žāku_
  { {0x3ebd004a,0x7a260028,0xe0df00c1,0x9f4701bd}},	//   _äytä_, _sótt, rtò_, lená_
  { {0xf8d10044,0x9f34002d,0xdb9b000b,0x682b0052}},	//   _सम्प, бері, _אסור, _jüdi
  { {0x9f470029,0x63b51371,0x7bca0028,0xadf90037}},	//   nená_, _sezn, ófun, ्ययन_
  { {0x5bcb0001,0x786d0029,0xdb0e0164,0x7c970012}},	// [28f0] ећег_, súvi, _debí, اشرا
  { {0x68ed0101,0x6e220051,0x212b0002,0x9f43004a}},	//   _ipad, _loob, mych_, tejä_
  { {0xe298002d,0x64890010,0xdd910012,0x8f9a0009}},	//   гає_, _užim, _وود_, _ביתי
  { {0xa4d5007c,0xd1310003,0xd6e80009,0x58b90012}},	//   _комі, يما_, _עַתָ, ناتج_
  { {0x212b1372,0x3ce0000d,0x629a0061,0xab95002d}},	//   nych_, ctiv_, _éton, _вигі
  { {0x41260015,0x63ba0027,0x9f43004a,0x389c0009}},	//   рошо_, jatn, pejä_, עיונ
  { {0xdb58002d,0xc7c40015,0xc7d80009,0xbfb80012}},	//   _бют_, ссчи, אווי_, اطها_
  { {0x212b0029,0x9f4a0769,0xd5ae0012,0x64580159}},	//   kych_, lebã_, وفى_, _ajvi
  { {0x680b0039,0x63ba1373,0xe616003c,0x67d5004c}},	//   _pēdē, fatn, рды_, _возу
  { {0x3ce50037,0x13090015,0x442300eb,0xa2cc0011}},	//   _कहीं_, вной_, _joj_, _हिम्
  { {0x9f45000f,0x9f4c0029,0xdb01000e,0x35f5027f}},	//   _való_, ždú_, való, _впер
  { {0xa2d60044,0x7d04004a,0x9f470066,0xcad60009}},	//   मंत्, yvis, cená_, סורת_
  { {0x67210163,0x63ba00b6,0x6d4b0028,0x23dd0011}},	//   äljn, batn, úgal, _मापद
  { {0x5d3a000b,0x645d0061,0x80cd0037,0x98a0001b}},	//   _בתנא, ésid, _सिने, šić_
  { {0xbb42002d,0x61e90027,0x683f0010,0xddc90029}},	//   _мешк, _obel, _išdė, tieň
  { {0x31260014,0x656f0066,0x78a400b8,0xb21b0040}},	//   _вдиг, _bych, _ttiv, lmæn
  { {0x212b003e,0xb21b0058,0x3b960001,0xcd270024}},	// [2900] cych_, omæn, ајет, ажте_
  { {0x69db0164,0x04460001,0x9f4701bd,0x629e052e}},	//   _acue, шезн, zená_, _époc
  { {0x23dd0037,0xb5fd001e,0xb87b1374,0x68fb005e}},	//   _मानद, jošo, stíc, _asud
  { {0x27ed001c,0xcc88001a,0xd356000b,0x2cbf0e0c}},	//   đene_, _lớp_, ביעי_, ksud_
  { {0x6fb60003,0x9f580054,0x9f4701e9,0x656f0032}},	//   لمشا, ldrà_, vená_, üchl
  { {0x2d980066,0xc953000b,0x3ec60021,0x6d3b0009}},	//   ěrem_, חמד_, асиб, _יתכנ
  { {0x212b003e,0x63ba1375,0x9f580054,0x6e22009b}},	//   zych_, vatn, ndrà_, _poob
  { {0x7bc30028,0x88c60003,0x27e90027,0x63ba11f7}},	//   ónuv, _نتطل, đana_, watn
  { {0x9f470029,0xadf70003,0x80a60003,0x10a3077e}},	//   rená_, شريط_, _ضمان, _митн
  { {0x3cf90037,0xddc00030,0xb05b0245,0x7c231376}},	//   _उनसे_, pomů, nrät, _conr
  { {0x212b0656,0x2905001e,0x3c770009,0xdfcf0012}},	//   wych_, ālam_, שתים_, _زين_
  { {0x212b084b,0xade20011,0xe9190024,0xfce602ab}},	//   tych_, क्शन_, гомі_, _водо
  { {0x984b0014,0x92580014,0x68e21377,0x9d1a0012}},	//   вява_, раят_, ntod, _جزاء_
  { {0x50670046,0x656f0145,0x212b0002,0x2bdd0037}},	//   ртма, _rych, rych_, _माया
  { {0xc058007c,0x67160037,0xe7300003,0xf8bf1378}},	//   рія_, थमिक_, وصف_, ssé_
  { {0x7a360010,0xbbaf0011,0x7147003c,0xaa44004c}},	//   kšty, टर्क, _вхож, _мејл
  { {0xd7e7002d,0xadf90037,0xe4d90012,0xfd100012}},	// [2910] _кіно, ्यतन_, طوات_, وجك_
  { {0x63b80033,0x656f00d9,0xb05b0810,0x9c38004c}},	//   _jevn, _vych, träu, апут_
  { {0xd7dc0044,0x656f0002,0x682b0052,0xb9950012}},	//   _बातच, _wych, _südw, ملاب
  { {0x44230002,0xdb05005e,0xed59001b,0x67280248}},	//   _woj_, mahü, laže_, ädje
  { {0x44230027,0xfe000037,0x81c8002d,0x3ce50011}},	//   _toj_, _लोटस_, ргів_, _कहें_
  { {0x73c50003,0xb5fd001e,0xfaa7002d,0x63b81379}},	//   _ديسم, tošo, _вшан, _nevn
  { {0x26c10382,0xf838000b,0x7bc30028,0xab04005e}},	//   ého_, שנות_, ónuu, _ööpä
  { {0xa2c0015f,0x7c2300a2,0xcf580093,0x9f580164}},	//   _विज्, _sonr, יבות_, ndrá_
  { {0x1c45002d,0xdb0705b1,0xed5902a1,0xf5320009}},	//   йним, _nejú, kaže_, ּ֥ח_
  { {0xc6e7007c,0x4ee7002d,0x1c110037,0x2d9f0802}},	//   _відп, _відз, ़ाइल_, scue_
  { {0xd6db0046,0xe36500b3,0xf9890009,0xdddb004b}},	//   _шта_, скни, _נר_, cluş
  { {0xf5950003,0x8d950003,0xe1f20003,0xb21b0040}},	//   _الإج, _الإش, أسد_, smæn
  { {0x6abc0028,0x659a0009,0x5fdc0011,0x5d850012}},	//   árfr, _עיסק, _बादल, _الشل
  { {0xf66a0065,0x07a30345,0x7c3a01e0,0xb4cb0011}},	//   phæð_, зарн, chtr, रूज़_
  { {0xf1d80037,0xfbb6000b,0x2001003a,0xdb1c01bd}},	//   _डालन, _הפצת_, _dahi_, _odrá
  { {0xb05b0032,0xe9da0867,0xc68f0012,0x9f47008e}},	//   tsäc, _ски_, ِّف_, menä_
  { {0x62980052,0xe3b20012,0xca370009,0xa3de0011}},	// [2920] _zuvo, كرا_, _לנקה_, _णाम_
  { {0x8ccf0044,0x05550024,0xddcd0034,0x9c290009}},	//   _दिनो, іття, gnał, נֵּ֥
  { {0x5f060047,0xadf90037,0xdb0a0052,0x5276002d}},	//   _узна, ्यान_, _gefä, буду
  { {0xd5b90015,0x91ba0003,0xb05b09d1,0x87170009}},	//   _всё_, اطار_, srät, _הקטע_
  { {0x660400a2,0xa3d70037,0xb05b006f,0x511800b3}},	//   mdik, िला_, prät, ролю_
  { {0x33d5007c,0xd6da002d,0xdfd00003,0xdfcf0003}},	//   _міст, гти_, ذيب_, فيه_
  { {0xe8190044,0x6604137a,0xfe1c0011,0x8f9b0009}},	//   दाता_, odik, _पचास_, ניקי
  { {0x91e30345,0x1d340048,0xb05b008e,0xf1bf0031}},	//   _носе, жния, isäa, nkát_
  { {0x27330020,0xed87002d,0xbd440003,0x6da30001}},	//   ạn_, йськ_, تنظي, чиња
  { {0x26c5000e,0xf4110009,0xa4fb0009,0x29370009}},	//   álok_, ֵ֤י_, נליט, _האמן_
  { {0x6e960003,0xe6960003,0xd5af137b,0x60c2137c}},	//   _الصا, _الصد, _нс_, lsom
  { {0xc333000b,0xe7170009,0x33770009,0xddcd0034}},	//   פור_, _לחבר_, מעים_, znał
  { {0x9e65000a,0xdb15000e,0x63be00b6,0x914b115e}},	//   _بالن, _vezé, kapn, учна_
  { {0xa055002d,0xf1db0037,0xc1570009,0x7afc0040}},	//   івві, _भावन, משכו_, ærts
  { {0x9f34002d,0xed5907a5,0x8f9b0009,0x2001005e}},	//   пері, raže_, רילי, _vahi_
  { {0x66020005,0x5b57000b,0xd3570009,0x44e20097}},	//   _jaok, _לשון_, _לשוק_, oð_
  { {0x5fc80044,0xe5730003,0x61ed002c,0x3cb80009}},	// [2930] रणाल, سطر_, _ibal, שֶֽׁ
  { {0x44e20065,0x7bda137d,0x7d1d137e,0xdb180025}},	//   ið_, ngtu, ässi, _revê
  { {0xaab50024,0xf2c40012,0xf1bf0031,0xf24b0009}},	//   ійді, كْلُ, bkát_, ְגְּ
  { {0xb05b0422,0x8f880009,0x3c2f0060,0xddc90035}},	//   präs, _לְרֵ, _sıvı_, kleš
  { {0x7bc30065,0x60e7002d,0x5c070048,0xa969004c}},	//   ónus, сцез, _лява, јила_
  { {0xbcfb0061,0x1ef90012,0x16a9016e,0x9ea9137f}},	//   _exéc, لعبة_, авки_, авка_
  { {0x44e20065,0x6298000e,0x2fd60012,0x6235003c}},	//   eð_, ívot, زويد_, _деву
  { {0xe7f50044,0x8237000a,0xf625002d,0x7bda0bb9}},	//   _इसका_, _ارسا, ідпо, egtu
  { {0x7e6900bd,0xee36002d,0xddc9009b,0x6e3b00b6}},	//   roep, інь_, gleš, rhub
  { {0x40e8000b,0x61ed1380,0x9f47008e,0xf1bf0031}},	//   _לַעֲ, _abal, tenä_, zkát_
  { {0xfbd20093,0x44e20028,0x60c40027,0xd8740012}},	//   ותי_, að_, _svim, _راكب
  { {0xc7a90093,0xa2cc0037,0x7bda020d,0x75150012}},	//   _יב_, _हिस्, agtu, _وواض
  { {0xdb0300a2,0x644f0061,0x9f47004a,0x6e440012}},	//   _henü, écis, senä_, _عنهم
  { {0xdb1a000f,0x2cad002a,0x389a0009,0xfc3f0030}},	//   zaté, mped_, יישנ, _stín_
  { {0x7d091381,0x2cad002a,0x02460012,0x44271047}},	//   lves, lped_, _وَتَ, _ion_
  { {0x78a90013,0x27ed001c,0x85050037,0x4427006f}},	//   _otev, đena_, रिंट_, _hon_
  { {0x44271382,0x9c260014,0xdb9a0001,0xec4a0593}},	// [2940] _kon_, одад, атељ_, азал_
  { {0x2aed0044,0xf2020011,0xb87b0018,0x1bba0012}},	//   _जहाँ_, _रोज़_, ntíl, شائع_
  { {0x44270108,0x290d1383,0x1ae30048,0x7c270034}},	//   _mon_, _area_, дохм, _dojr
  { {0x27f81384,0x72160012,0xd2590024,0xb05b0d4c}},	//   lern_, غذائ, бці_, nsän
  { {0x60c20010,0x7bda0010,0xa183003c,0xdb1a1385}},	//   usom, ygtu, мышл, raté
  { {0xb8f20044,0x44271386,0x27f80052,0x4ea600de}},	//   _वि_, _non_, nern_, ориа
  { {0xab2a0019,0xd6d00003,0x1ef70012,0x3e48004b}},	//   _това_, رقة_, قعية_, eşti_
  { {0x69d60037,0xd4b80015,0xcf93000b,0x60cd001e}},	//   _भागी, блиц_, וטו_, šama
  { {0xe4e6007c,0x7d540014,0x44271387,0x27f8031d}},	//   ційн, явих, _bon_, kern_
  { {0x44e20065,0xbc670003,0xe61f0029,0x44271388}},	//   rð_, يمين_, _zhôd_, _con_
  { {0xda7b0047,0xe2f8002d,0x78830066,0xdb030052}},	//   иям_, щені_, _důvě, _genü
  { {0x648906bc,0x63bc0052,0x7d09009b,0x92580015}},	//   _uživ, _lern, bves, жают_
  { {0xc218007c,0x27f80052,0x32040002,0xa6330024}},	//   ією_, fern_, _mamy_, _інші
  { {0xdb181389,0x27f808ec,0x9f4c0042,0xddcd0034}},	//   _levé, gern_, ždý_, znań
  { {0x629c007a,0xf7700003,0xba770003,0xa5c30002}},	//   _nuro, ناف_, _واعت, spół
  { {0x8b3b000b,0xdb18000e,0x26cd0027,0x7f3b0009}},	//   _כתוצ, _nevé, čeo_, בעלו
  { {0x98a20002,0x27f802f9,0xdb0306fe,0x629c138a}},	// [2950] tyką_, bern_, _fenó, _auro
  { {0xf1d80044,0x645a0993,0xddcd004b,0x69dd138b}},	//   _डाउन, nnti, flaţ, lgse
  { {0x63bc0108,0xdb18000f,0x2bb80003,0x645a138c}},	//   _dern, _bevé, زالة_, inti
  { {0xf9c7007c,0x290d007d,0xb5fd0470,0x7b640014}},	//   іщен, _prea_, rošk, фтуе
  { {0x361a000b,0xddc80002,0xe3d70012,0xf9900012}},	//   _הורד, łośc, _وتسع, نبه_
  { {0x629c00c1,0x290d000d,0x09340003,0xdfd10003}},	//   _furo, _vrea_, برمج, ريع_
  { {0x9f470029,0xc9f70012,0xa49b01a0,0x91f70012}},	//   lenú_, _وسرع, _eròt, _وأرا
  { {0xf1bf0065,0x56920001,0x4427138d,0x682f0989}},	//   _þá_, најт, _son_, _nødv
  { {0x7d090010,0xc6480003,0x98170012,0x27f8138e}},	//   uves, تجول_, _وبطا, yern_
  { {0x443e0274,0xfb960009,0x7d09138f,0xf7730012}},	//   ght_, ּ֣ית_, rves, _قاض_
  { {0x4427032b,0x63a5008b,0xdb0e0052,0xcb691390}},	//   _von_, ichn, _gebä, сане_
  { {0x98cf0044,0x2cad0666,0xf8cf0037,0x4427051c}},	//   _हटाए, pped_, _हटाय, _won_
  { {0x200506db,0xb5fd001e,0x44271391,0x263f0034}},	//   _kali_, joši, _ton_, głoś_
  { {0x443e02a4,0x27f80052,0x9f470029,0xec780024}},	//   cht_, uern_, denú_, _дпі_
  { {0x7bc11392,0xec36000b,0xa856000b,0x20051393}},	//   malu, _מאסר_, לישה_, _mali_
  { {0x7bc100c6,0x9f4b000f,0x629a0061,0x27f80052}},	//   lalu, áját_, _étoi, sern_
  { {0x229a001e,0x290000b6,0x4a57000b,0x63bc1394}},	// [2960] _rīki_, _usia_, _משקל_, _pern
  { {0xdb1e000e,0xe8f7003c,0x244a0012,0xdb0a0018}},	//   lapé, _эль_, حجري_, _refú
  { {0xb05b0006,0x4f9b000b,0xe7b7000b,0x7dd6003a}},	//   isäl, _לביצ, _מהיר_, nüsü
  { {0xd36f0003,0x11d70003,0x9f470064,0x62870030}},	//   دهم_, كومة_, benú_, ňkov
  { {0x645a0006,0xe572000a,0x200500c6,0x63bc1395}},	//   ynti, _سطح_, _bali_, _tern
  { {0x66060a73,0x7b01004a,0x7532001e,0xa1570009}},	//   _hakk, äytä, īdzī, הבנה_
  { {0x5f930046,0x644e0101,0xb17b0950,0x6e360010}},	//   ништ, _imbi, mgåe, okyb
  { {0x225a0003,0x6e360010,0x66061396,0x6d440032}},	//   _الرد_, nkyb, _jakk, ozia
  { {0x6d441397,0x361b000b,0xe62a001a,0x3cf80011}},	//   nzia, מוקד, _độ_, ्टें_
  { {0x2005007a,0x113b000b,0x644f0061,0x533404ad}},	//   _gali_, _התמל, écip, деот
  { {0xe41a04b4,0xddcd0013,0xe9f9002d,0xed5902a1}},	//   _kľúč, hlaš, онні_, raža_
  { {0x1e860047,0x0e9b000b,0x60c40010,0xb87b0028}},	//   _элем, _השאל, šimu, rtím
  { {0x58870047,0x6296003a,0x69dd1398,0x9f5e01a0}},	//   зыва, _diyo, rgse, _matí_
  { {0xc9530093,0x6d44003e,0x27ed001c,0xc05b002d}},	//   תמש_, dzia, đeno_, сім_
  { {0xb17b0058,0x86c50012,0x9f5a1399,0x7dd60060}},	//   dgåe, بيزن, _papá_, cüsü
  { {0x33770093,0xb5fd001e,0xa2d30011,0x735b0009}},	//   _מתוך_, toši, _डिब्, _לכוח
  { {0x63a50163,0x6a7d0164,0x7e6d000d,0xddcd0133}},	// [2970] tchn, léfo, roap, glaš
  { {0x00bc0009,0xb5fd139a,0x9f4d0064,0xcf270012}},	//   _המזמ, roši, čnúc_, _فرجي
  { {0x3cf90044,0xd5ed0020,0xc7b2000b,0x0af90003}},	//   _उनके_, hoả, _שבט_, تفاظ_
  { {0x63a5008b,0x66060028,0xddcd009b,0x7bce0002}},	//   schn, _gakk, blaš, óbuj
  { {0x8c3b008b,0x3cf80037,0x99840066,0x63a50034}},	//   _auße, ्टों_, _domů_, pchn
  { {0x8cbf0011,0x60cd0035,0x26c50030,0x20070031}},	//   लीफो, šamo, šlou_, udni_
  { {0x2005139b,0xca770003,0x7d0d139c,0x7d0202a0}},	//   _vali_, _فارغ, lvas, _asos
  { {0xff18000b,0x443c004a,0x200500b6,0xdb1a0fe1}},	//   לקות_, _alv_, _wali_, gatí
  { {0x2bb90003,0xd0d40014,0x2005139d,0x89340012}},	//   يادة_, _потъ, _tali_, _كعكا
  { {0xfc310003,0xa0c40003,0xcac9003c,0x7dd60060}},	//   ئحة_, _أيلو, огое_, tüsü
  { {0xb05b0163,0x3ce90051,0x6d4400c1,0x60c40010}},	//   rsäl, htav_, zzia, šimt
  { {0x7bc1139e,0xc7b8001b,0x05550048,0x7dd60060}},	//   salu, _dođu_, _отля, rüsü
  { {0xbd45000a,0x6609003a,0x95c80024,0xfc310012}},	//   _تنشي, mdek, _хліб_, _لحث_
  { {0x6d440029,0x4c9a0009,0x40950fa4,0xb8f60011}},	//   vzia, _ובסו, ерст, _हि_
  { {0xdee31128,0x28d30037,0xe73a00de,0x3d030037}},	//   кори, _तिथि, цев_, _वनडे_
  { {0x442a1211,0xcad60009,0x9e75004c,0x98a20034}},	//   _sob_, _חוקת_, ећуј, zykę_
  { {0x15fd0044,0x15e20037,0xfe790066,0xdd8f0012}},	// [2980] उज़र_, क्टर_, ilů_, لوف_
  { {0x6e2b00bd,0x6609004a,0xdb1a0030,0x6d44139f}},	//   _logb, hdek, zatí, rzia
  { {0xf093000b,0x98a20010,0x660613a0,0x06860223}},	//   _שנת_, vykę_, _takk, _огон
  { {0xa2d50037,0x7df90037,0xddcd001e,0x2a600051}},	//   _भिन्, ्योग_, plaš, õib_
  { {0x98a20002,0x08fa0012,0x8dfb0009,0xb5fd0035}},	//   tykę_, تراب_, _והכת, nošu
  { {0x6bd60012,0x645d0025,0x76aa0e5f,0x60c909df}},	//   _تتحر, ésil, отив_, _dvem
  { {0xe80f0044,0xd3720003,0x8c3b0052,0xdb1a01c2}},	//   ायता_, _شهر_, _fußb, tatí
  { {0xd5b00003,0x44250058,0x7c2a0c56,0x2498005e}},	//   دفة_, ejl_, _sofr, _hirm_
  { {0x69c00039,0xab5c0039,0x7d1b0054,0x34940048}},	//   _ieme, daļa, _àust, наир
  { {0x6fb30003,0x69c013a1,0xd467004c,0xddc90034}},	//   _لمكا, _heme, миње_, gieł
  { {0x69c000c6,0x03d7000b,0x2057000b,0xa08b000b}},	//   _keme, ווים_, _קיבל_, _וְאִ
  { {0x9f580029,0x682f0260,0x6fdc0011,0x6ec50012}},	//   ceré_, _føds, _बाउं, _أتلق
  { {0x229a0039,0x69c000c6,0x656f0052,0xcd360012}},	//   _rīku_, _meme, ücht, _تراب
  { {0x6441008b,0xd0840015,0x69c006ef,0xdb150031}},	//   chli, выси, _leme, _lezá
  { {0x7641007a,0x32670014,0xfe730012,0x7bdb0009}},	//   ūlym, _отив, ندر_, _וקוו
  { {0xe508001a,0xbddb0f4c,0xdb150042,0xc6900012}},	//   _kỷ_, _amèr, _nezá, لِّ_
  { {0xa2da0037,0xe80f0037,0x61fd13a2,0x6a760028}},	// [2990] पूर्, ायदा_, mesl, gáfu
  { {0x660900a2,0xb05b004a,0x5478000b,0xb5fd0d09}},	//   zdek, isäk, פְּנ, lošt
  { {0xdb15000e,0x60c913a3,0x7d0d13a4,0xde190012}},	//   _bezá, _svem, svas, _فقدت_
  { {0xdb1805b1,0x61fd13a5,0xdb050025,0xddc90034}},	//   _neví, nesl, nché, zieł
  { {0x249813a6,0xe8ee0015,0xadd6000b,0xf1940024}},	//   _firm_, ыл_, _אורח_, виць
  { {0x94ba000b,0x01380009,0xe3d40012,0xe8220011}},	//   _ממשת, ורדת_, _لتفع, माया_
  { {0x20d50065,0x9f580013,0x66090070,0x3ea10051}},	//   _búið_, teré_, tdek, _juht_
  { {0xb87b0017,0xfde60014,0x7bc5001f,0x69c013a7}},	//   luíd, едък_, lahu, _geme
  { {0x61fd13a8,0xfd110012,0xdb1813a9,0x660913aa}},	//   desl, اجب_, _deví, rdek
  { {0xe3b10003,0x60dd0051,0x26dc0010,0x42d5002d}},	//   درة_, dusm, buvo_, німу
  { {0x35b5007c,0x69cc0066,0xab5c001e,0x69c013ab}},	//   _збер, ůlež, taļa, _yeme
  { {0x61fd00bd,0xa96a0001,0xb5fd001e,0x68340054}},	//   gesl, зима_, tošu, _ràdi
  { {0x25b90065,0x7bc5002c,0xddc40066,0xb6340012}},	//   ðslu_, kahu, tliž, _جعلت
  { {0xf8b2000b,0x14d60009,0xd0120012,0x70190024}},	//   רשם_, _נוצל_, دلس_, міст_
  { {0x5e96000a,0x63050003,0xfbd2000b,0x3a3f003a}},	//   فلسط, _أوبل, _עתה_, _olup_
  { {0xdb030052,0xd6270001,0xa49b0054,0x34aa0001}},	//   _benö, носе_, _pròp, звао_
  { {0x8fa6002d,0xc692000b,0x05660014,0xd7e00011}},	// [29a0] _папе, ראן_, хван, _नालच
  { {0xdb1a000f,0x69c013ac,0xf1bf0031,0xec770560}},	//   latá, _seme, nján_, епу_
  { {0x69c000c6,0x67350002,0x4fbb000b,0x6aab000d}},	//   _peme, cyzj, _מציא, _înfă
  { {0xe64601d4,0xdb1a090e,0xda660012,0xfbc90009}},	//   _чемп, natá, راضي, מת_
  { {0xa3cf0037,0xb87b0017,0x26100037,0x33d60024}},	//   षणा_, buíd, _दोषी_, _півт
  { {0x69c606cb,0xe1650003,0xd037002d,0xdb1a000e}},	//   hake, خدمي, нзії_, hatá
  { {0x316c003e,0x141b000b,0xdb1a000e,0x69c613ad}},	//   ędzy_, _צולב, katá, kake
  { {0xb21b0040,0x644b0035,0xddd10073,0xdb1e0064}},	//   mlæg, īgie, _įgūd, napí
  { {0x8066002d,0x2d820033,0xe6110009,0xb21b0040}},	//   _зваж, åke_, בִי_, llæg
  { {0x4444008a,0xdb0a0028,0x9f47022d,0xb05b006f}},	//   nh_, _vefþ, lený_, rsäk
  { {0x229a001e,0xb21b0058,0x444413ae,0x224013af}},	//   _rīks_, nlæg, ih_, _blik_
  { {0x916d0020,0xb5fb000f,0xe5080020,0xdb1a000f}},	//   _nội_, _aján, _tỷ_, gatá
  { {0xdb050061,0xa1940024,0x3ea1005e,0xe5080081}},	//   rché, лаюч, _suht_, _uỷ_
  { {0x2c160044,0xad1b000b,0x79840002,0xc173000b}},	//   ताओं_, _מודר, _dziw, רחש_
  { {0xb87b13b0,0xddc40002,0x29040028,0xddc90002}},	//   ktív, bliż, æmar_, bień
  { {0xb21b0399,0x26080037,0x387f0061,0x9f4701bd}},	//   dlæg, ाएगी_, œur_, jený_
  { {0x3d1b0037,0x7bc513b1,0xb87b0017,0x9f4701bd}},	// [29b0] नमें_, tahu, tuíd, dený_
  { {0x444413b2,0xf3670760,0x5d840012,0xac190024}},	//   gh_, нтен, الكل, ьозу_
  { {0x93190003,0xb87b13b3,0x23e20011,0xfb190012}},	//   بقاء_, ruíd, _पारद, بقاع_
  { {0xd6d8002d,0x7bc50107,0xc6b60009,0x5ee80009}},	//   _ять_, sahu, _שהרי_, _אַשְ
  { {0x7c95000a,0x7bc5002c,0xb21b0058,0x660d003a}},	//   _للحص, pahu, lmæs, mdak
  { {0xdb1a000e,0xbddb0061,0xdb0a0052,0x46f5002d}},	//   zatá, _flèc, _befü, вчит
  { {0xe8220037,0xddcd0002,0x1c0a0037,0x9f470042}},	//   माता_, miał, _होटल_, bený_
  { {0x7c2e13b4,0x60cd0027,0xb05b004a,0x9f4713b5}},	//   _zobr, _ovam, ssäh, cený_
  { {0x98f40003,0xe1ff000e,0xfc310003,0x69c600e6}},	//   _مثلا, deó_, لحد_, vake
  { {0x7e7b0028,0xddcd0002,0x224013b6,0xddc90002}},	//   slup, niał, _slik_, wień
  { {0xdb1a0272,0x2240003e,0xf1c30020,0x2fc713b7}},	//   tatá, _plik_, _trở_, mang_
  { {0x2fc70f37,0xc869000b,0x6b9a0028,0x3eaa022d}},	//   lang_, _ון_, _útge, žité_
  { {0xf1bf000f,0xdd010066,0xdb1a13b8,0x41030048}},	//   pján_, čtět, ratá, азяв
  { {0x65940046,0x2fc713b9,0x6e29000e,0x9cd6000b}},	//   _сачу, nang_, ljeb, _יונה_
  { {0x6c560009,0xf4560009,0xdb1a0031,0x83f6004c}},	//   _שיצא_, _שיצר_, patá, _рејс_
  { {0x2fc713ba,0xb17b006f,0xadf90037,0x8d760012}},	//   hang_, mgån, ्यटन_, ناءا
  { {0x660b0101,0x69c4001e,0x444413bb,0x2fc70160}},	// [29c0] _magk, _ieie, th_, kang_
  { {0xb5fb0065,0x65930001,0x2fc7054c,0x661d13bc}},	//   _hjál, рађу, jang_, _ensk
  { {0x2fc700c6,0x7bc313bd,0x9f48004a,0x9f470029}},	//   dang_, _menu, ähän_, tený_
  { {0xb21b0065,0x660b002c,0x78a40269,0x6e290031}},	//   rlæg, _nagk, _kuiv, jjeb
  { {0x69c40051,0x9f470029,0xb21b0058,0xd946004d}},	//   _meie, rený_, slæg, ъеди
  { {0x9873002d,0xddcd0002,0x9f5c0061,0xb87b11df}},	//   аліц, ciał, levé_, stív
  { {0x44200020,0x2d8013be,0x9f4713bf,0xb87b13c0}},	//   _đi_, _šie_, denó_, quíe
  { {0x27ed001c,0x69c40039,0xfe6f0003,0x628913c1}},	//   đeni_, _neie, يدي_, _gheo
  { {0xf6530093,0x7bc3008b,0x2fc70160,0x867b000b}},	//   יצה_, _benu, bang_, ורקו
  { {0x660d0fc6,0x2fc700b6,0x9f5c0025,0x2175004c}},	//   zdak, cang_, hevé_, _суср
  { {0xdb18000e,0x201e00b6,0x7bdb0009,0xd4370009}},	//   _bevá, _inti_, וקיו, דריק_
  { {0xddcd0002,0xb21b0eeb,0x7bc3005e,0x7e0c0011}},	//   ział, emær, _eenu, हयोग_
  { {0xa4d4002d,0x6a7d13c2,0xa9bb0009,0x91bb0009}},	//   _солі, néfi, וזכר, ומכי
  { {0x200c00c6,0xb21b0eeb,0xe10b0009,0x78a40227}},	//   _jadi_, gmær, וּלָ, _duiv
  { {0xf8c8001a,0xf1bf01e9,0x69c40a46,0x925b0012}},	//   hứ_, áška_, _feie, _يشعر_
  { {0x6397000b,0xf644002d,0x27ed0066,0xddcd0002}},	//   _בדוא_, ахун, řen_, wiał
  { {0xebc70046,0x2d5808b0,0x2fc70175,0xb21b0058}},	// [29d0] вљен, вить_, yang_, smæs
  { {0x5fb70011,0x2e380025,0x6a7d0025,0x2c340009}},	//   _अभिल, _défi_, défi, נָּם_
  { {0xd3710003,0xddcd0002,0xe3b00012,0xf1c90012}},	//   حها_, riał, ترق_, فوضى_
  { {0x2fc70175,0x629e0061,0xddcd0002,0x225913c3}},	//   wang_, _épou, siał, nisk_
  { {0x4dda0093,0xbd6b0001,0x2fc713b9,0x403502ad}},	//   _אחרו, _црне_, tang_, ледс
  { {0x7bc80005,0x2fc70a60,0x07090012,0xab5c0035}},	//   jadu, uang_, فيتي_, taļl
  { {0x660b0101,0x64540001,0x2fc713c4,0x9ef50012}},	//   _pagk, _тврђ, rang_, استش
  { {0x60d6007a,0x2fc70160,0x7bc80051,0x4431000e}},	//   šyma, sang_, eadu, _hoz_
  { {0x7bc300c6,0x2fc70160,0x614a0025,0x6cd20012}},	//   _penu, pang_, _mêlé, مقيا
  { {0xb5fb0065,0x69c413c5,0x2c1c0011,0x9cd60009}},	//   _sjál, _seie, नाएं_, נותה_
  { {0x78a40108,0x7d0413c6,0x8fa40012,0xb05b0032}},	//   _suiv, zwis, _ضمنه, nsäu
  { {0x7d040002,0xcf560009,0xb17b0248,0x41b6003c}},	//   ywis, _גבעת_, rgån, ысот
  { {0xed59048b,0x7bc8026e,0x69c413c7,0xfe700012}},	//   kaži_, badu, _veie, _بدل_
  { {0xdb1c0164,0x7aec000e,0xd8380604,0x5b350012}},	//   _serí, öltö, _tiče_, _معبر
  { {0x69c40051,0xdb1c0201,0xe8190011,0xf7860012}},	//   _teie, _perí, दाजा_, الأَ
  { {0x3ea5007d,0x2259003e,0xdb18014f,0x25ad13c8}},	//   _mult_, cisk_, _bevæ, ncel_
  { {0xdb0a0028,0xddc9001e,0x98f60003,0x448a046d}},	// [29e0] _hefð, pieņ, _إثبا, ебан_
  { {0x629e0054,0x4806002d,0x61e903c8,0x7d0413c9}},	//   _èpoc, _спов, _acel, rwis
  { {0xb0c60037,0x7ae111c9,0xe9da096e,0xddc900eb}},	//   रीनग, nult, еке_, dlež
  { {0xb87b0042,0x539a0009,0xe9e50024,0x61e610fc}},	//   stít, גיעו, иціо, ngkl
  { {0x200c00b6,0x7ae113ca,0x27150081,0x91bb0009}},	//   _padi_, hult, _h́nh_, גמני
  { {0xdcfd0039,0x40940003,0xe8940024,0xf5390030}},	//   _uzsā, جلتر, шаль, dyť_
  { {0xf1ba0020,0xeab40093,0xab610051,0x9f5813cb}},	//   _đơn_, _כִּי_, öüle, nerà_
  { {0x7e641326,0xfb1b0009,0x2dda0012,0x5efb0009}},	//   nnip, _אולמ, ربعة_, תפקד
  { {0x21670046,0x25d7000b,0x200c00b6,0x7bc813cc}},	//   _бити_, אופן_, _tadi_, tadu
  { {0x54540014,0x62980066,0x61e90066,0x3ace0002}},	//   рвот, ůvod, _zcel, tęp_
  { {0xd5e20020,0xb05b004a,0x3c77000b,0xb8930003}},	//   _chọ, isät, רתים_, _اللع
  { {0x3eb8009b,0x9f5813cd,0xaa590024,0x6f4b0009}},	//   dprt_, derà_, тиму_, _אֲדַ
  { {0xf1bf000e,0x3ea50070,0x2715001a,0xd7fb0055}},	//   lják_, _zult_, _ánh_, нув_
  { {0xb5fb0042,0xd40a0012,0xb8fd0011,0x7ae113ce}},	//   _ukáz, _ستتم_, _डि_, bult
  { {0x501b000b,0x33170003,0xdb0a0028,0xf1bf1356}},	//   עולו, _مزيد_, _gefð, ššia_
  { {0x442c006f,0x97570009,0xc3330009,0x68e20073}},	//   ljd_, אילו_, _לוצ_, kuod
  { {0xdc550046,0x26c1000f,0xa3e90037,0x6448004a}},	// [29f0] авањ, ához_, _याद_, ohdi
  { {0x61e900c1,0x68e20010,0xa3d5002d,0x40ec0009}},	//   _scel, duod, рожч, _נַחֲ
  { {0xcb550001,0xe8220037,0x443e13cf,0x442c0070}},	//   јвећ, मारा_, ikt_, ijd_
  { {0xdb1c0149,0x27ed0027,0xf1bf000e,0x99a80003}},	//   _serã, đenu_, dják_, هُمْ_
  { {0x443e0028,0x645a13d0,0x89a8002d,0x68e20073}},	//   kkt_, kiti, уків_, guod
  { {0x443e0070,0xccf2000b,0xd8b80012,0xdb18008e}},	//   jkt_, _וכך_, ادنا_, _kevä
  { {0x2fc50119,0xaa95002d,0xfc3f0164,0xf1bf000e}},	//   _velg_, _вивч, _guía_, gják_
  { {0xe6c40003,0x7ae1004a,0xceb4000b,0xa2a20037}},	//   حتوي, vult, זיק_, गदर्
  { {0x1c450803,0xdb1c0017,0x7bc700b6,0xdcef001e}},	//   иним, _terã, _keju, _izcē
  { {0x1c1f0037,0xf5390029,0xdb95002d,0x660f02c3}},	//   बाइल_, ryť_, ишнь, _lack
  { {0x9f580054,0xff530012,0xcb69038f,0x9f4b008e}},	//   xerà_, _اخذ_, тане_, älän_
  { {0x7bc70039,0x443e0070,0x38ab0058,0x9f5800c1}},	//   _leju, akt_, _kør_, verà_
  { {0xfe70000a,0x9f5813d1,0xe8220011,0xe3ae0173}},	//   _عدم_, derá_, माला_, _мб_
  { {0x443e13d2,0xd116000b,0x76490028,0x9f5813cd}},	//   ckt_, בקשה_, lhey, terà_
  { {0x94740003,0x68e20010,0x66d90021,0xe5160011}},	//   _ادنا, zuod, льтр_, तिथि_
  { {0x29560014,0x7aee022d,0x75d60012,0x9f5800b8}},	//   _въор, žití, شيطا, rerà_
  { {0x527b000b,0xb05b006f,0x290c001e,0xfbd20003}},	// [2a00] _בנקא, tsät, ādas_, قتا_
  { {0xb05b0032,0x9c23004c,0xbab60012,0x27150081}},	//   usät, одуд, لمطب, _t́nh_
  { {0x49ca0015,0xe7db000b,0x660f02f1,0x23ba0037}},	//   влен_, _בקיש, _fack, ेरबद
  { {0x38ab0989,0xb05b00e5,0x9f58052e,0x11d70012}},	//   _bør_, ssät, cerá_, لومة_
  { {0x03a6002d,0xb05b006f,0x55bb0009,0x6448008e}},	//   _виго, psät, _במכו, yhdi
  { {0x66040065,0xc0760046,0xf1bf000f,0x7641007a}},	//   leik, шћењ, tják_, ūlyt
  { {0xe7ee0037,0x68e2004a,0x39400010,0x69cb0058}},	//   _जाना_, suod, šis_, bage
  { {0x38ab091a,0x96b70003,0xd6260003,0xddc90002}},	//   _før_, جاوز_, شعبي, mieś
  { {0x38ab00c5,0xfe6f0003,0x37e60015,0xafe60015}},	//   _gør_, بدو_, _возг, _возл
  { {0x9f580064,0x443e0641,0xf1bf0031,0xdb1a0064}},	//   zerá_, ukt_, pják_, matú
  { {0xddc90002,0x2417000b,0x628200ca,0x443e13d3}},	//   nieś, בחין_, oloo, rkt_
  { {0x443e13d4,0xa75b0009,0xd2460012,0x625101bd}},	//   skt_, _בדבר, سن_, sťov
  { {0xc05b007c,0x9f580017,0xdcef001e,0xdb1e019a}},	//   вів_, verá_, ādīs, lapä
  { {0xc05b002d,0xdd3b000b,0xdb1e0054,0x02a60829}},	//   тім_, _בעדכ, capç, _крим
  { {0xdb1e0051,0x44f00007,0x9f5813d5,0x660f13d6}},	//   napä, là_, terá_, _pack
  { {0x7bc700c6,0x9f5c0066,0xe61f001a,0x6a68003a}},	//   _seju, jeví_, _khôi_, nıfl
  { {0x629f0061,0x2ba70001,0xdb1e0051,0xdb0501e9}},	// [2a10] _époq, ајев, hapä, dchá
  { {0x44f001a2,0xdb1c0164,0xe7ee0037,0x6d4d0070}},	//   ià_, _será, _जाया_, rzaa
  { {0x2bb90037,0xb05b004a,0x44f0001a,0x38ab13d7}},	//   इडबा, ssäs, hà_, _sør_
  { {0x80db0011,0x1af70009,0xc2120009,0xd1b80012}},	//   _निदे, שמאל_, ּ֔א_, لاها_
  { {0xdb1c06fe,0xe7ee0011,0xa2d30011,0x11080012}},	//   _verá, _जामा_, _डिक्, لغوي_
  { {0xfd960009,0x65360009,0x1bb80012,0x44f001a0}},	//   _לדרך_, _האשף_, _نافع_, dà_
  { {0xb9e7002d,0x62820070,0x7bc70028,0x69cb13d8}},	//   _візи, bloo, ðjum, page
  { {0x683d0054,0xf99f0054,0x62560010,0x11d40003}},	//   _mèdi, ndès_, ršok, _وتقد
  { {0x64860065,0xf807002d,0xadf80011,0x49040012}},	//   rðin, _вчен, ्ज़न_, _ووفق
  { {0x30850003,0x1c4500fa,0x20850012,0x0445004c}},	//   _الطف, сном, _الطّ, сеон
  { {0x9f580054,0xddcd05dd,0xe0df10ac,0x78a901e3}},	//   merç_, dlaž, erò_, _huev
  { {0xdef6000b,0xd3560009,0x44f001a0,0x78a113d9}},	//   _למעט_, מיתי_, bà_, _hilv
  { {0x660401ff,0xf6740003,0x8e740003,0x78a911f8}},	//   veik, _بالخ, _بالض, _juev
  { {0x78a901e3,0xf3f10012,0xf9920009,0x7d7a00af}},	//   _muev, _رأت_, פרם_, _גננו
  { {0x66040b3f,0x7ae50051,0x61ed13da,0xf1bf000e}},	//   teik, juht, ällö, bbá_
  { {0x60db0010,0xdb360009,0x6ca60012,0x25bf13db}},	//   šuma, _לנצח_, مصطل, nbul_
  { {0x78a902d1,0x6441001e,0xddc90002,0xd4c60012}},	// [2a20] _nuev, okli, wieś, إغري
  { {0xdd8f0012,0x31570009,0x17fa0012,0x660413dc}},	//   رول_, _ליפן_, _صرخة_, seik
  { {0xb09b0009,0x7d09041d,0xa5bb01e3,0x6a680060}},	//   _תייר, hwes, _inón, yıfl
  { {0xb87b0164,0x0dba0003,0xdb1e0051,0x64900051}},	//   críb, _حادث_, vapä, käig
  { {0xc05a002d,0x3af1001a,0x62820644,0x867b0009}},	//   лік_, háp_, rloo, _תרכו
  { {0x78a10039,0xb9000037,0xdb1a0029,0x62820b8c}},	//   _cilv, _थि_, ratú, sloo
  { {0x645e13dd,0xbbc40011,0xb5fb0097,0x61b80011}},	//   mipi, षरीक, _sjái, _आभूष
  { {0x44f001a2,0x44b4007c,0x64860028,0xc8e00037}},	//   tà_, обис, aðil, _निपट
  { {0xfe6f0003,0xa49b0054,0xb4260012,0x68e60248}},	//   عدى_, _pròx, معدو, jukd
  { {0x25bf003a,0x44f013de,0x6441002c,0x9f5a0054}},	//   abul_, rà_, gkli, _japó_
  { {0x7f86000a,0x547b0093,0xe2f8002d,0x4dda0012}},	//   _الان, רטיו, шені_, _موضح_
  { {0xc333015a,0xe61f001a,0xfce60015,0x3ea20002}},	//   לות_, _thôi_, _годо, _nikt_
  { {0x6da30003,0xf5960012,0x7d960012,0xdb1c008e}},	//   _عموم, _الشج, _الشؤ, _herä
  { {0xdb1c13df,0x5c73002d,0x644113e0,0x6490005e}},	//   _gerç, _еліт, ckli, näid
  { {0xc058002d,0xc6d8000b,0xb3f70009,0x2bf70009}},	//   сія_, יַּר, _המוח_, _המון_
  { {0x7bca014d,0x74bf0011,0x6d9c0064,0x2d8d0034}},	//   _hefu, लीकृ, aťaž, śleń_
  { {0x7c350026,0x69cf0c90,0xdb0300b7,0xb87b0018}},	// [2a30] _pozr, mace, _agnè, luím
  { {0x734b0014,0x4d980015,0x645e005e,0x3ea20035}},	//   лчев_, скую_, gipi, _eikt_
  { {0xe7ee0044,0xe9f90020,0xfbd00003,0x29d50003}},	//   _जाता_, _giả_, عتك_, قياس
  { {0x6441001e,0x7bca0031,0xdd2b0031,0x7ae513e1}},	//   zkli, _lefu, sőűr, ruht
  { {0xbcfb0017,0x7ae500e6,0x69cf13e2,0x7c8704d6}},	//   _exér, suht, iace, _гуве
  { {0xdb1c0163,0xdff5002d,0xdd310002,0x8aa713e3}},	//   _berä, іяль, zęśc, _град
  { {0xd1bb000a,0x80db0037,0x201313e4,0x985d0034}},	//   _ماذا_, _निवे, _maxi_, _głąb_
  { {0xee390e0f,0xa3e90011,0xe8920064,0x5692004c}},	//   рни_, _याँ_, ĺňať_, мајт
  { {0x78a10065,0x6aaa0052,0x82340003,0xe9d90002}},	//   _tilv, _auff, _عرفا, _idź_
  { {0x99480003,0xf9900003,0xa988000b,0xac39002d}},	//   _الكل_, _سبق_, _הָעִ, рчих_
  { {0xdb1c0052,0xc5d5002d,0xb21b0058,0x69cf0830}},	//   _gerä, _діль, rlæn, face
  { {0x60c4004b,0x625a003c,0xadbd0024,0xb51c0011}},	//   ţime, ррор_, _радi, निमय_
  { {0xfe42002d,0xdb1c0017,0x99f60009,0xa3e90011}},	//   _іншо, _terç, חזרה_, _यां_
  { {0xbb450015,0x7bca10c7,0xf8b20009,0x07ba0012}},	//   _мелк, _gefu, ושך_, شهرة_
  { {0x0325002d,0x2bbf0037,0x82860012,0x9b950012}},	//   _єдин, _श्या, _وجعل, _بلغت
  { {0x38af032b,0x3f840333,0x0686002d,0xdcf70037}},	//   _für_, āmu_, іган, ुबंध_
  { {0x62730003,0x75d30003,0x3ea2006f,0x88c60012}},	// [2a40] _تهيئ, بيقا, _vikt_, _بتعل
  { {0xe45f0028,0xf8b3000b,0x628613e5,0x20070c81}},	//   _svör_, _קשת_, llko, jeni_
  { {0x6da6034c,0x41aa0014,0x3ea2001e,0x27e50002}},	//   _мина, авен_, _tikt_, ólne_
  { {0xdb1a0722,0x81460012,0xaac50012,0x66fc0035}},	//   ratø, ينان, ستمن, nākš
  { {0x645e002c,0x73c60012,0xf1bf0031,0xa3e90011}},	//   pipi, _ويحم, mját_, यला_
  { {0xd91b000b,0xdfd00003,0x66160010,0xdb1c004a}},	//   יונל, ريب_, ldyk, _perä
  { {0x44f40006,0x27e000a2,0x4444009b,0x66160073}},	//   lä_, ğin_, mk_, odyk
  { {0x66160915,0xe357000b,0xdb1c0052,0xe2a60028}},	//   ndyk, _ושלח_, _verä, óðum_
  { {0xc693000b,0x44f4004a,0x69cf0029,0x80660015}},	//   ואה_, nä_, vace, _дваж
  { {0xb35401b6,0x6616004a,0xdb1c008e,0x6abe00b0}},	//   зкош, hdyk, _terä, oppf
  { {0x22490070,0x7bca0028,0xf1bf000e,0x66160010}},	//   _plak_, _vefu, kját_, kdyk
  { {0x4438007d,0xb5fb02d1,0xb87b0164,0x2bac0037}},	//   _lor_, _imág, dría, _फ़्रा
  { {0x44f40006,0x7e6000c6,0x2beb01e1,0xba9b000b}},	//   jä_, mimp, _चालू_, יסטי
  { {0x444400bd,0x4438002a,0x44f4004a,0x290b0002}},	//   jk_, _nor_, dä_, rwca_
  { {0xd838009b,0x9057000b,0x6fbf0011,0x6490005e}},	//   _moč_, קבלו_, ्रबं, käib
  { {0xfa340003,0x38af004e,0xf1bf000e,0x68e20b86}},	//   _يريد, _tür_, gját_, krod
  { {0x5d550014,0xa3ae0037,0xfbab027f,0xdfa70012}},	// [2a50] чкат, _कला_, атей_, _وحدي
  { {0xf1bf000e,0x7d0203a2,0x443813e6,0xb87b01e3}},	//   aját_, _mpos, _cor_, bría
  { {0xf7700003,0x661613e7,0xb5fd13e8,0x443813e9}},	//   _لاَ_, bdyk, liše, _dor_
  { {0x6d40007a,0x5a350014,0x69c20070,0x539b01b0}},	//   kyma, янет, gboe, ביבו
  { {0x2ca300bd,0x200713ea,0x68e20002,0x443813eb}},	//   _tijd_, teni_, grod, _for_
  { {0x6d40007a,0x759a000b,0x7c3800b6,0x443813ec}},	//   dyma, _לסרג, _novr, _gor_
  { {0x44290020,0x7e7b0066,0xe73900de,0x7d0d0ad2}},	//   _đa_, toup, сей_, lwas
  { {0x28dc0044,0x7bce0065,0x67f40028,0x8d550014}},	//   _बिलि, ðbun, tþjó, зточ
  { {0xdb05008b,0xb5fb000e,0xab5c0035,0x66fc0035}},	//   schä, _imád, kaļs, vākš
  { {0xbebc0039,0x67f40028,0xc1040012,0xcf270012}},	//   _brīd, rþjó, _توكي, _وراي
  { {0x67f40028,0x7c3813ed,0x59cf0011,0xdc3c0009}},	//   sþjó, _dovr, _हजार, יעזר
  { {0xdb12000f,0x83fc001b,0x41e50012,0x6d3513ee}},	//   égév, viđe, وسُف, _нееф
  { {0x271c0020,0xd24f0012,0x2bbd0011,0xf2210011}},	//   _ảnh_, انُ_, ोरदा, याज़_
  { {0x44f4004a,0x29dc001a,0x66fc001e,0xdb150052}},	//   vä_, ửa_, sākš, _bezü
  { {0x442713ef,0xa2d20012,0xf1bf0031,0xcb6613f0}},	//   _inn_, _كيوت, tját_, _наше_
  { {0x44f403fc,0x4438000e,0xdd920003,0xe7ee0011}},	//   tä_, _sor_, فوز_, _जावा_
  { {0x443813f1,0x7644003a,0xe51c0011,0x59cf05f3}},	// [2a60] _por_, rkiy, निधि_, _हज़र
  { {0x7d1b0006,0x660913f2,0xc9530009,0xac830695}},	//   ivus, heek, _רמז_, егул
  { {0x6d40003e,0x7d1b0005,0x103b000b,0xf6260014}},	//   zyma, hvus, _הגיע, _едно
  { {0xdca609f0,0xd259002d,0x200a003a,0x64a60d60}},	//   _нами, оці_, lebi_, _нама
  { {0xb05b0051,0x69c20070,0x68e20010,0xa1330012}},	//   späe, rboe, urod, فروش
  { {0xb17b0033,0xf8b3000b,0x7d1b0051,0x70540012}},	//   mgåt, עשו_, dvus, بنتا
  { {0x2018001e,0xa91d00f1,0x7d0213f3,0xd6560009}},	//   idri_, _vyža, _spos, ּיִת_
  { {0x171b000b,0x6d4013f4,0x54b8022a,0x7c3813f5}},	//   מוצע, tyma, огия_, _sovr
  { {0x7bce00c6,0x48e3011f,0x7c3813f6,0x88c50012}},	//   _kebu, _потв, _povr, _يتكل
  { {0x88bb0009,0x986a0012,0x80630024,0x200a001b}},	//   _לזמי, _احرف_, _звуж, jebi_
  { {0x4fbb000b,0x67bb000b,0x7e6000b6,0x6d400d30}},	//   _הצבא, _המבק, pimp, syma
  { {0x7d0d0002,0x2246000e,0x442713f7,0x200a005e}},	//   ywas, nkok_, _enn_, eebi_
  { {0x2e37000b,0x9d9a0012,0xbd290012,0x7c380159}},	//   _מראש_, _انشئ_, _وأهل_, _tovr
  { {0x859b000b,0xb5fd02a1,0xd59b0009,0xe44f0012}},	//   _השדו, riše, _הבדל, _مضى_
  { {0xabfb007e,0x33fb0009,0xa3e90011,0x93fb0009}},	//   _ההור, _להגנ, यलर_, _הלוי
  { {0xf8bf0061,0x7d0d002c,0xb5fd02a1,0xf3130012}},	//   ppé_, twas, piše, _أبوظ
  { {0x62560010,0x200a003a,0xa697000b,0xb5fb0028}},	// [2a70] ršot, bebi_, לכלה_, _sjás
  { {0x7c14002d,0x6f0d0034,0xdb070031,0xdb1a067a}},	//   ндує, łaci, _ifjú, katü
  { {0x2bb80003,0x3a290058,0x6235002d,0x4427003a}},	//   سالة_, _knap_, межу, ın_
  { {0xdb1a13f8,0xa3dc0044,0xfd1f001a,0x2cb90012}},	//   lató, तृत_, _trì_, _وُجد_
  { {0xe1f0000a,0xb5fb0065,0x9f510164,0xe0d80024}},	//   اسم_, _fjár, pezó_, зві_
  { {0xc918000b,0xe7bf0037,0x7bce0480,0x3ea6004a}},	//   פחות_, ्रिप, _gebu, _aiot_
  { {0xe7360014,0x6d400051,0xd00e0012,0xae1e0011}},	//   дещ_, _ümar, شلي_, _मोहन_
  { {0x7d1b0051,0xdb1a0123,0x7e6d13f9,0x7bdc13fa}},	//   tvus, ható, nnap, _zdru
  { {0x6fbf0037,0xe7bf0037,0x66090070,0x7cde000d}},	//   ्रां, ्राप, reek, părţ
  { {0x61fd0028,0x39420010,0x7e6d04ec,0xe3b10012}},	//   efsl, vyks_, hnap, خرة_
  { {0x420a00a6,0x93b60009,0xfbd20009,0x8c1c0009}},	//   онно_, ולתו_, כתי_, מוזי
  { {0x1fc6015f,0xd9ff0037,0xc0490009,0x6e890012}},	//   वर्ड, ोजित_, _דז_, _بنصف_
  { {0xd4350003,0xdb0a02f1,0x8e560009,0x71d60009}},	//   _يعتب, _affä, _קינג_, וורד_
  { {0xdb1a13fb,0xe8000011,0x2bb20011,0x7e6d114d}},	//   gató, ल्पा_, _जलधा, enap
  { {0x7bce0185,0xbbd60009,0xa28a0012,0x92660012}},	//   _rebu, _חוצץ_, _وضعك_, _يدعم
  { {0x7bce00c6,0x2ca7001f,0x7bdc0066,0x3eb8000e}},	//   _sebu, _hind_, _sdru, _érte_
  { {0x2ca713fc,0x1be10011,0x33f60223,0x6aae13fd}},	// [2a80] _kind_, _खयाल_, дчес, _subf
  { {0x94060012,0x7e6d020d,0xdb1a13fe,0x22a80060}},	//   ظواه, anap, matò, _aşka_
  { {0x38b401ab,0xc7b3000b,0xeb93000b,0x65c601b8}},	//   _här_, _בבת_, תָּ_, _обна
  { {0x1bf00011,0x38b40248,0x51860451,0xdb1806dd}},	//   _चावल_, _kär_, мула, _nevý
  { {0x644f001e,0x7c490031,0x3ea6053f,0xd8b70012}},	//   īcij, ásró, _riot_, ودوا_
  { {0x7bdc0027,0xceba0001,0x46d20011,0xd0100012}},	//   _udru, ољи_, _तबाह, الث_
  { {0x38b4006f,0xba0a0012,0x62840073,0x2bc40610}},	//   _lär_, _وترك_, _okio, _ल्या
  { {0x442001b3,0x15140048,0x8c3b0032,0x9d140868}},	//   _şi_, едия, _wußt, едич
  { {0x38b401ab,0x6d4400b6,0x2167002d,0x7c3c13ff}},	//   _när_, nyia, _жити_, _korr
  { {0x03f80001,0xdb1c0192,0x113b0009,0x9f5c008e}},	//   чној_, _berø, _ותמל, tevä_
  { {0xf413000b,0x60c2004a,0x9e3c00d9,0x7c3c1400}},	//   דפת_, lpom, _buďt, _morr
  { {0x68ed039c,0x2ca70070,0x75460014,0x60d60010}},	//   žodž, _eind_, _онез, šymu
  { {0xdb1a1401,0x2ca706a3,0xfe9b000b,0x58870015}},	//   tató, _find_, _ויאמ, дыва
  { {0x38b40163,0x9c570003,0x3c440012,0x7c3c1402}},	//   _där_, _يجوز_, _سَعِ, _norr
  { {0x9f5f003a,0xe3b8003a,0xe80e0037,0x442d1403}},	//   _ürün_, mcı_, ाज़ा_, _đe_
  { {0x56940400,0xd7170009,0xdb1a0034,0xb5fb0097}},	//   васт, וחלט_, sató, _smáb
  { {0x7c3c02d1,0xc7c70001,0x28e00037,0x74f80021}},	// [2a90] _borr, _осни, _निषि, метр_
  { {0xe3b8003a,0xe8d8000b,0x69db0028,0x2ca703c2}},	//   ncı_, _חוזר_, ðuef, önd_
  { {0x30780012,0x224d0227,0xdb180031,0x28cb0011}},	//   _تحية_, _plek_, _nevü, ़ीरि
  { {0xddc4000d,0x60cd0070,0xd6d80024,0xe1ff0031}},	//   rniţ, _kwam, _ють_, nfó_
  { {0xb90b0003,0xa803003a,0xc0e5002d,0x3af8001a}},	//   تزام_, _çıkt, холк, hép_
  { {0x91690020,0x68eb06e7,0x443c1404,0x41740012}},	//   _cửa_, rugd, _nov_, خامس
  { {0x9f500065,0xddc4009b,0x39490113,0x98bf003a}},	//   ðaðu_, lniš, šas_, ırım_
  { {0x43940047,0x7c2a008b,0x2ca71405,0xf7700003}},	//   _расс, _anfr, _sind_, جاه_
  { {0xc8f40014,0x6e920012,0x99820034,0x660d0034}},	//   _изтъ, دليا, zekł_, ieak
  { {0xfc31000a,0x6490008e,0xe1ff0034,0x628b1406}},	//   احة_, häin, onów_, llgo
  { {0x3af8000e,0x63ad0b71,0x539a0009,0x0ff80012}},	//   gép_, _şans, ּירו, _تعقب_
  { {0xf089000b,0x23bf0011,0x28c60011,0xdb1a01a0}},	//   _הנ_, _श्रद, रीकि, tatò
  { {0xed4e0047,0xadd60009,0xc56b0012,0x321e0030}},	//   _со_, _נוסח_, _بحال_, ěty_
  { {0x26de0027,0x661b1407,0x6aa90347,0xddc4017b}},	//   štom_, lduk, _lief, dniš
  { {0xe73a0373,0x75221408,0xc2c80012,0x38b40032}},	//   чев_, _zroz, _قبيل_, _wär_
  { {0x661b046c,0xb05b008e,0x60c20034,0xddcd004b}},	//   nduk, isäy, ypom, riaş
  { {0x999e0010,0x33f9000b,0xad660012,0xb05b008e}},	// [2aa0] ėtų_, ּהֲנ, راره, mpän
  { {0x78fb0093,0x3957000b,0xe0fb000b,0x29570009}},	//   _צפיו, _נשים_, _צליל, _נסיך_
  { {0xb8f30037,0x7c3c092b,0x47f70009,0x91690081}},	//   ही_, _vorr, _אציל_, _rửa_
  { {0x91690020,0xddc4012e,0x6a160003,0x78a8006f}},	//   _sửa_, bniš, عبار, _sidv
  { {0x7d1c001e,0xc6930009,0x3af80031,0xe3b80060}},	//   ārsk, _תאר_, zép_, ycı_
  { {0x60c200c1,0xd8d7000b,0xf993000b,0xa9670003}},	//   rpom, גוסט_, ארד_, عموم_
  { {0x09e6007c,0xfae70012,0xda660012,0x865a0009}},	//   _повн, _حث_, _كاري, ּדִי
  { {0xceb3000b,0x7f470012,0x8afb0009,0x9df70048}},	//   ניח_, عليق_, _מהלי, енът_
  { {0x7d1b0018,0xe474004c,0x78a80675,0x28dc1409}},	//   _áust, клињ, _tidv, _बिगि
  { {0x201a000f,0x07a6007c,0x78250003,0x46e10037}},	//   _napi_, _зазн, _لعمل, _फिलह
  { {0x60cd0132,0x93fb0009,0x1c0f0011,0xddc4090a}},	//   _swam, הליי, ़ज़ल_, zniš
  { {0xb5fd140a,0x3af80031,0x75220aef,0xe606008e}},	//   lišn, rép_, _troz, äsää
  { {0x865b0009,0x6490008e,0x44f901a0,0x26190011}},	//   _צדדי, väin, cè_, _मोटी_
  { {0xc5690003,0x20cd0604,0xddc400eb,0xe1ff0034}},	//   _تحمل_, rži_, vniš, ynów_
  { {0x141b000b,0x8c1b0009,0xbc1b0009,0xb87b0097}},	//   _מוגב, _זווי, _מוגש, lrík
  { {0xddc404d2,0x6d1c0011,0xbb770009,0x9f600031}},	//   tniš, निंग_, _רעהו_, árát_
  { {0x6490004a,0xdb200028,0xca7c0009,0xda7c0009}},	// [2ab0] räin, ðtæk, _מנהט, _מנהר
  { {0x6490004a,0x14190003,0xddc404d2,0x660d005e}},	//   säin, بيئة_, rniš, seak
  { {0xf6990046,0xb5fd140b,0xcfb6000b,0x28b70037}},	//   _овој_, dišn, _בלתי_, _इंडि
  { {0xee210024,0xe1ff0034,0x7bc5005e,0xddc4090a}},	//   _темi_, rnów_, _õhuv, pniš
  { {0x25d60009,0x62640031,0x9dd60009,0x9be70024}},	//   _שושן_, dőol, _בורק_, _півк
  { {0x6bd40003,0x7ae20035,0xab87028b,0x66e50fe3}},	//   _متفر, ņota, _зубк, вока
  { {0x6aa90052,0x79c90003,0x3946002c,0xcc760009}},	//   _tief, _يوسف_, ayos_, _יעשה_
  { {0xcf240012,0xa2950024,0x4ada05f3,0x68fd140c}},	//   اروي, _рабі, _भिजव, ktsd
  { {0x44f90054,0xc0150048,0xb87b01e3,0x661b140d}},	//   uè_, _имащ, rríj, rduk
  { {0x76490a58,0x26de000e,0x1c450055,0xe5040012}},	//   skey, átok_, тном, ابيي
  { {0x95d9003c,0x9f040012,0xb87b0064,0x201a016d}},	//   _ждет_, _مولو, príj, _rapi_
  { {0x201a00b6,0x216a00ac,0xcb120009,0xe1f20012}},	//   _sapi_, дими_, בלט_, جسد_
  { {0x89da0009,0x6fd60024,0xe5350048,0x7ae80227}},	//   וחרי, ківц, _шедь, ardt
  { {0xed560046,0xfd56000b,0x1d060345,0x3a3f0d29}},	//   _још_, _בשני_, _реши_, _loup_
  { {0xb5fb0028,0x7b670024,0x17790223,0xfc3f0c8b}},	//   _smáa, _ятде, есть_, _luís_
  { {0x3376000b,0x6028001e,0xceb2000b,0xe5f3000d}},	//   _בעצם_, _zīmē, שין_, văţă
  { {0x201a00c6,0x70560012,0x84ac0009,0xbea307e8}},	// [2ac0] _tapi_, _لنظا, ִיאִ, ратк
  { {0xe1ff0164,0xe5720009,0xf7720012,0x2ed10011}},	//   nión_, בַע_, _ناج_, _सबूत
  { {0x539a0009,0xb5fd001b,0x3e7a0035,0xc32a00ae}},	//   ֵינו, višn, līte_, بكان_
  { {0xc3320093,0x3a3f0573,0xaae50012,0xc6b70009}},	//   יוב_, _coup_, اسلو, _שהכי_
  { {0x24440028,0xdb1e0028,0xf8bf0031,0x60dc0035}},	//   _sömu_, tapó, rvég_, _ārms
  { {0xdb1c000f,0xb7d80003,0x515b000b,0xdcf50066}},	//   _kerü, روبا_, וכנו, ůběh
  { {0xe8e00020,0x8c1b000b,0x200e0028,0xc7b30009}},	//   _ước_, _קולי, refi_, סבה_
  { {0xdb1c000e,0xf773000b,0x13170009,0xeb970a2c}},	//   _merü, יקו_, _בחלל_, _рис_
  { {0x5ea30012,0xb5fd00eb,0x22920097,0xdb1a140e}},	//   جميل, mišl, tákn_, natö
  { {0xe1ff140f,0xcf260012,0xbd9b0009,0xb87b0097}},	//   gión_, _لرصي, וספת, rrík
  { {0x9f580066,0x3d170011,0x07a6004c,0xdb1a005e}},	//   terý_, _बैठे_, _ражн, hatö
  { {0xb87b0026,0xacbb0061,0x28b70011,0xd3370009}},	//   prík, _brûl, _इंदि, דרטה_
  { {0x1e570009,0xdb1a005e,0xc5f30009,0x8e6b0009}},	//   _בשאר_, jatö, _כדף_, _קֳבֵ
  { {0xe1ff06f4,0x5453007c,0xdb1c1410,0x64860028}},	//   ción_, _квіт, _berü, rðis
  { {0x44d0003e,0x386d001c,0xeeab002d,0xc0580024}},	//   eń_, đer_, дтак_, тія_
  { {0x645d001e,0x7c2e1411,0x04c90012,0x02a4003c}},	//   īsie, _anbr, فوري_, _крым
  { {0x9a680012,0x35b40686,0xa5c20034,0xcc99004c}},	// [2ad0] _جميل_, рбур, łówk, евац_
  { {0x7bc50051,0x3ea01412,0xd78b0012,0x54540198}},	//   _õhut, amit_, _يخدم_, авут
  { {0x12b40003,0x3ea01413,0xd3a7137b,0xc7b20009}},	//   لإنج, bmit_, трап, _לבי_
  { {0xe45f006f,0x3ce9009b,0xd7f8000d,0xb21b0040}},	//   _stöd_, prav_, _acă_, mlæs
  { {0x910501ec,0x8bb70012,0x4a5c0009,0x09e40024}},	//   упле, _لإزا, ודאו, роін
  { {0xe1ff0164,0x201106c0,0xdb1a005e,0x46f5003c}},	//   xión_, nezi_, latõ, гчит
  { {0xef12000b,0x27e9003a,0x6490005e,0xaed2004c}},	//   ֶּה_, ğan_, käij, бојш
  { {0x7658007a,0x27e9003a,0x2011004b,0xe8e00081}},	//   _įvyk, şan_, hezi_, âịn_
  { {0x2a640098,0x06960003,0x4c85003c,0x20110060}},	//   _търг, دنية_, ллив, kezi_
  { {0x69d900b6,0x661d1414,0x98a4004c,0x291a0035}},	//   lawe, _lask, _виђе, āpat_
  { {0x44fd001a,0x3ea0004a,0x7bd51415,0x20111416}},	//   hì_, ymit_, _mezu, dezi_
  { {0xceb20093,0xe1ff02d1,0x69d90070,0x63bb003a}},	//   _היא_, sión_, nawe, _şunl
  { {0x64860028,0xfce50ba0,0x4a5a0009,0x69cb0032}},	//   rðir, _соло, תדרו, ibge
  { {0x7e690010,0x6e3b0470,0x44fd00b8,0xb8960012}},	//   liep, ljub, dì_, السع
  { {0x2d8f0052,0x26de00d9,0x63050012,0x661d1417}},	//   ügen_, éto_, _إوبل, _bask
  { {0x2299000e,0xdb1a0028,0x9655004c,0x78690073}},	//   téke_, tatö, ађуј, ržva
  { {0x7bc50051,0x7bd51418,0x79960034,0xb21b0097}},	// [2ae0] _õhus, _bezu, _uzyw, rlæt
  { {0xdb1c000f,0x09cc0037,0xb8f80037,0xdb1a1419}},	//   _terü, ार्य, ाठ_, ratö
  { {0x272300a2,0x5f460003,0x37750015,0xf8bf0061}},	//   _nın_, _إنجل, _выяс, rvée_
  { {0x2485141a,0xdb1a141b,0x9f4101e3,0x6286141c}},	//   holm_, patö, _echó_, noko
  { {0x91e31103,0x9f58097c,0xb5fd0f23,0x1ae00011}},	//   соче, peró_, rišl, _पटकथ
  { {0xd9430046,0x69d60164,0xddcd0002,0x61430001}},	//   сељи, _leye, chał, сеља
  { {0x7524000e,0xe51c0037,0xc8e00011,0xa6340024}},	//   lviz, निकि_, _निकट, инкі
  { {0x60c40149,0x2011004b,0x58d60012,0xe8040011}},	//   _otim, zezi_, _ميرذ, श्ता_
  { {0xacb40046,0x29560014,0xad260012,0x79b70009}},	//   јбољ, _съвр, اربو, _תלמד_
  { {0xb7b5001a,0x06f60037,0xebd60009,0xf1b90aae}},	//   _hạn, ुझाव_, נֵ֥י_, _vaše_
  { {0x2259003c,0x3394003c,0x60c40073,0x5c3701b0}},	//   вины_, ранё, _atim, אטיב_
  { {0xc3330093,0x201e0e9e,0x7524141d,0xed5a0048}},	//   צור_, _hati_, kviz, _пое_
  { {0xb7b50020,0xc2130009,0x8cb00011,0x9a84003c}},	//   _mạn, זהר_, _अंगो, суэл
  { {0x61e400a2,0x661d0039,0xf5930003,0x7afd004b}},	//   _edil, _sask, _الهج, ăstr
  { {0xa91d0029,0x7bda141e,0x661d141f,0x201e1420}},	//   _vyži, matu, _pask, _mati_
  { {0xdb180052,0x02fb0009,0x24490097,0x1c020011}},	//   _bevö, _נלחמ, _rúmi_, र्सल_
  { {0xdb050052,0x7524000e,0xdddb0066,0xb3eb0012}},	// [2af0] schü, gviz, nouš, فعال_
  { {0x7d1d0058,0x6bd40003,0x66040051,0x2bb80003}},	//   æssi, متمر, afik, هامة_
  { {0x5695002d,0xd5b10012,0xc2c40012,0x9f350024}},	//   _вант, _وفد_, ميلي, _тені
  { {0x7bda0cf4,0xb7b5001a,0x5fbf0037,0xdddb0066}},	//   hatu, _cạn, ्रकल, kouš
  { {0xb7b50020,0x26de0029,0xb604119d,0x7bda1421}},	//   _dạn, átov_, íšet, katu
  { {0xb346003a,0xd0090a15,0xe8000037,0xd2d70012}},	//   _kaçı, теке_, ल्ला_, _مغرب
  { {0x7e690070,0xe73900be,0x9169001a,0x201e1422}},	//   tiep, тей_, _lừa_, _dati_
  { {0xa2670098,0xddc20002,0x8aa41423,0xb5fd10dc}},	//   _съгл, _iloś, _груд, mišk
  { {0xf1c80066,0xb5fd1424,0xfbd10012,0xee36003c}},	//   ndář_, lišk, يتد_, рны_
  { {0xeb100037,0x40870015,0x7e690227,0x7bda1425}},	//   ़बूत_, _субб, siep, gatu
  { {0x6604003e,0xe29a0001,0x212900b6,0x8c1a000b}},	//   yfik, као_, _arah_, דותי
  { {0x6926003c,0x8f44003c,0xf7700012,0xf9870012}},	//   амма, _ухуд, _عال_, قب_
  { {0x7bda0005,0x8e840003,0x8a16000b,0x2d8f0052}},	//   batu, _النه, בחרו_, ügel_
  { {0x9f580065,0x7019002d,0x7d1c001e,0x8d5a0009}},	//   ferð_, ліст_, ārst, _בכני
  { {0x9f580065,0x45d6029b,0x76a60003,0xb5fd1426}},	//   gerð_, ицат, لحرك, višj
  { {0x25bf00c6,0x201e0010,0xb5fd078d,0xc4c60012}},	//   ncul_, žti_, dišk, لتطو
  { {0x3e7a001e,0xb21b0033,0x75d30012,0x64431427}},	// [2b00] nīta_, plær, زيلا, _koni
  { {0x752401a2,0xb5a90003,0x3eaf0ad2,0xb5fd1424}},	//   rviz, طاقك_, _ligt_, fišk
  { {0x3a20039c,0xa6ca0003,0xe9da072b,0x201e001b}},	//   _kaip_, _جوجل_, вке_, _rati_
  { {0x2902004a,0x201e0027,0x7bda0102,0x539a0009}},	//   otka_, _sati_, zatu, דיעו
  { {0xb5fd007a,0xb87b0018,0xd378001b,0x7bda016d}},	//   aišk, rrív, maće_, yatu
  { {0x3e7a0039,0x7ee60015,0xdb1c0028,0x26de0042}},	//   dīta_, ацие, _ferð, štou_
  { {0xdb1c0065,0xd6d70047,0x7bda05ef,0xa0890009}},	//   _gerð, аты_, vatu, נְנִ
  { {0xddcd1428,0x96341429,0x95880034,0x7ae3004b}},	//   mnaţ, сниц, aląż, ânte
  { {0x7bda142a,0xdd970015,0xe51c0011,0x99090012}},	//   tatu, ишь_, निटि_, _مغلق_
  { {0xddcd000d,0xe571000b,0x70fb0009,0xc34a0048}},	//   onaţ, לַי_, _בהמח, вяме_
  { {0x0bb70093,0x6f09003e,0xfee90003,0x8433002d}},	//   ילים_, łecz, _معنى_, інює
  { {0xdddb0066,0xe7170009,0x7bda142b,0x9f580097}},	//   pouš, _כחבר_, satu, verð_
  { {0xdfdb0098,0xc693000b,0x7bda142c,0x50f40024}},	//   къв_, _ואף_, patu, озят
  { {0x27ed008b,0xd48f002d,0x9169001a,0x9203001e}},	//   ßen_, _єр_, _vừa_, _šādo
  { {0x749b000b,0xb05b142d,0xe0df13cd,0xb4170012}},	//   _שיופ, npäi, ssò_, _ضغوط_
  { {0xe654007c,0x27ed003a,0x433b0009,0x97570009}},	//   овсь, şen_, _יעוב, בילו_
  { {0x8bb70003,0xdbd10028,0x656d0029,0x26c50010}},	// [2b10] لإضا, _býðu, _ľahk, ūlo_
  { {0xb5fd007a,0x8434002d,0x69dd0f2e,0x57f5013b}},	//   tišk, онує, lase, _упот
  { {0xbebc001e,0xa6ab0003,0x2d870002,0x41b50012}},	//   _drīk, _لاحق_, łne_, ممار
  { {0xdb1c014d,0xb5fd0a05,0x69dd142e,0xd9990012}},	//   _verð, rišk, nase, هنات_
  { {0xb5fd0010,0xfe360009,0xf1cc0011,0xd1090012}},	//   sišk, _הארך_, ारजन, اقته_
  { {0x8934000a,0x69dd00c8,0xd0110012,0x26110081}},	//   تعما, hase, سلع_, _ạo_
  { {0xe1ff000e,0xd7f80594,0xc7aa0009,0x2a69005e}},	//   giók_, руч_, ְׁפָ, _omab_
  { {0x3e7a0039,0x645a00ff,0xdddb13f6,0x7e6d142f}},	//   tīta_, ehti, služ, niap
  { {0x64431430,0xd5490015,0x6d4d00b6,0x69dd0688}},	//   _poni, уппе_, nyaa, dase
  { {0x2d91001e,0x645a0444,0xd378001b,0x79960034}},	//   āze_, ghti, zaće_, żywc
  { {0xd795000a,0x5f95000a,0x6f950003,0x3b090001}},	//   _الاخ, _الائ, _الاض, ћемо_
  { {0xc049000b,0x69dd1184,0x7bce0097,0x6f7a0009}},	//   _אז_, gase, ðbur, _גְדו
  { {0xa3d70037,0x53a70037,0x7e7e000e,0xcdb60009}},	//   सरा_, केतश, éppe, _הפנה_
  { {0x645a0518,0x29020b37,0x7bd80227,0x10a6123c}},	//   chti, rtka_, _gevu, сигн
  { {0x3a20007a,0x8c3b0032,0x7d0f0031,0x290202d0}},	//   _taip_, _fußz, _apcs, stka_
  { {0x69c10030,0x7bc102a2,0x92650012,0xaac40012}},	//   ělec, lclu, _وديم, _بتون
  { {0x291e001e,0x3ae3003a,0xe1ff0031,0xe5a303d4}},	// [2b20] ātas_, lıp_, ziók_, зити
  { {0xb3e90003,0xdceb0073,0x7bc11431,0xe73a004c}},	//   لعمل_, _lygį, nclu, _бео_
  { {0x68e40058,0x3ae3003a,0x60a50003,0x6d4d02a0}},	//   _hvid, nıp_, _بإيق, ayaa
  { {0xeb970800,0xddcd000d,0x90e60003,0x20070028}},	//   щих_, rnaţ, مستن, efni_
  { {0x2d840061,0x645a004a,0xdd920012,0x5fbf0011}},	//   _âme_, yhti, _روس_, ्रचल
  { {0x69dd08b2,0x3ae30060,0xf1b91432,0x8f340048}},	//   zase, kıp_, _vaša_, жекц
  { {0x7646007a,0x39520010,0x69dd0c6e,0x7bdb0009}},	//   _koky, šys_, yase, _תקלו
  { {0xceb3000b,0xdb1c006f,0x03770009,0x1ed70012}},	//   היה_, _berö, _התלת_, حبوب_
  { {0xb05b0006,0x7646007a,0xb5fb0028,0x645d001e}},	//   späi, _moky, _smák, īsin
  { {0x4096000a,0x14b7000a,0xb05b004a,0xb8960003}},	//   _الطر, حديث_, ppäi, _الطع
  { {0x5398002d,0x9f45003a,0xc43b0009,0xe215003c}},	//   рвня_, ülü_, אתיי, омны
  { {0x68e2009b,0x9169001a,0x7bde1433,0x7ae301e3}},	//   osod, _nữa_, hapu, ánti
  { {0xc05b002d,0x68e20b0d,0x3e7a0035,0x69dd1434}},	//   гів_, nsod, līto_, rase
  { {0x69dd03d5,0xd3ba002d,0x3cfb0009,0xdb1c0097}},	//   sase, _суді_, _עלונ, _afrí
  { {0x7ac60001,0xf7730003,0x3e7a0035,0x91690081}},	//   _усле, ساس_, nīto_, _bữa_
  { {0x8afc003e,0x3377000b,0x63770009,0x6f4b0009}},	//   rzęd, _לתוך_, _לגוף_, אֲמַ
  { {0x1dc40012,0x7d040031,0x95c81435,0xfe700012}},	// [2b30] سْلِ, gtis, суса_, ردف_
  { {0x7e6d00b6,0x859b0009,0xa3940030,0xa3a7004c}},	//   siap, רשמו, _důžé_, бјек
  { {0xfb150012,0xfa6b0009,0xe4500012,0x68e406dd}},	//   تواج, ְכְּ, رضك_, _zvid
  { {0x3e7a001e,0xe1f00003,0xb87b0029,0xb5fd017b}},	//   dīto_, فسه_, prís, piši
  { {0x64580164,0xab62003a,0x2c6f0034,0x3ae30060}},	//   _olvi, _çünk, ażda_, zıp_
  { {0x3ae3003a,0x6829000e,0x40ec0009,0xe9d90034}},	//   yıp_, ködő, אַהֲ, _weź_
  { {0x70b50037,0xdc9a0009,0xcee80012,0xf7420048}},	//   ंदुल, _כישל, مرين_, дещо
  { {0x245b0108,0x79960002,0x917a001a,0x17580009}},	//   _même_, żywa, hấp_, מסור_
  { {0x4423012e,0x6447001c,0x628b0e68,0xe1ff1436}},	//   _kaj_, _koji, mogo, ciói_
  { {0xdb1c0052,0x3d090037,0x31780003,0x3ae3003a}},	//   _verö, _वहीं_, _احفظ_, tıp_
  { {0x6490004a,0x68e4001b,0xe1ff0034,0x37c40012}},	//   päiv, _svid, niów_, _رينف
  { {0x7de6000f,0xdb1c003a,0x628b0604,0xc9aa02e3}},	//   _késő, _terö, nogo, ивне_
  { {0xec6e0014,0x229c1437,0xef1f0034,0x6616008e}},	//   _жп_, níka_, óżne_, veyk
  { {0x4423012e,0x9f580061,0x64900051,0x6ca70014}},	//   _naj_, lgré_, näit, _уреж
  { {0xe29a1438,0xf1b9009b,0x3b06002d,0x6616004a}},	//   _как_, _našo_, _дещо_, teyk
  { {0x69db008b,0x7d041439,0x752902a1,0x6df60012}},	//   _neue, ttis, ovez, تكرا
  { {0xe0d20003,0x628b143a,0x64900574,0x0eb60011}},	// [2b40] _غزة_, dogo, käit, _आंकड
  { {0x61e9143b,0xe3b80060,0x8b9608d1,0x5d670148}},	//   _adel, ydım_, ореч, циум_
  { {0xda66002d,0x3bd50015,0x9f060003,0x26050321}},	//   овжи, яютс, _بوجو, _हॉकी_
  { {0x201800a1,0x7afd003e,0xd62a0001,0xa79b0009}},	//   leri_, ństw, _томе_, _כשיח
  { {0xcaa50003,0xfe790066,0x7bde010a,0xc5f30009}},	//   أصلي, dnů_, papu, _קדש_
  { {0xe9f90020,0x61e9143c,0xc953000b,0x6e220027}},	//   _khả_, _edel, ומד_, _saob
  { {0xf8bf143d,0x69db0052,0xcf260003,0xc7af0012}},	//   _één_, _feue, ترشي, نّه_
  { {0xe3b800a2,0x7bdc1144,0xc7b3000b,0x00ca0048}},	//   rdım_, _heru, ובו_, _влак_
  { {0x3e7a001e,0x7bdc00b6,0x99800066,0x2018143e}},	//   sīto_, _keru, _aniž_, keri_
  { {0x94760003,0xb05b004a,0x718b0009,0xdb500012}},	//   تدعا, npät, _דְבַ, َّد_
  { {0x7bdc00c6,0x6490004a,0x42550003,0xdb050052}},	//   _meru, läis, كندر, schö
  { {0xf1b10037,0xbebc001e,0x752904d2,0xbddb0061}},	//   ुँचन, _brīv, bvez, _poèm
  { {0x2906004a,0x6490004a,0xe3b8003a,0x85760012}},	//   ntoa_, näis, ndık_, _بدائ
  { {0x201806b0,0x8afc0034,0x6fd90034,0x3a24143f}},	//   geri_, rzęb, dźcó, _lamp_
  { {0xf647002d,0xff040015,0xcddb0001,0x1bf70009}},	//   охан, мятн, иња_, _וצור_
  { {0x4423012e,0x6490008e,0x7bdc1440,0x16340306}},	//   _saj_, käis, _aeru, меся
  { {0x7bdc1441,0x64470066,0xe4d90012,0xb5fd001b}},	// [2b50] _beru, _poji, صوات_, mišt
  { {0x8afc0002,0x7bdc000d,0x2018000d,0xb5fd0580}},	//   częc, _ceru, ceri_, lišt
  { {0x8c1b000b,0x7bdc1442,0x6f0d0034,0x2906008e}},	//   שובי, _deru, łacz, etoa_
  { {0xf1b9012e,0xe1ff0002,0x3a241443,0xb5fd013a}},	//   _vašo_, riów_, _camp_, ništ
  { {0x4423001c,0x64900051,0x3ea903d5,0x69db0054}},	//   _taj_, täit, mmat_, _veue
  { {0x94ba000b,0x1beb0037,0x44b40014,0xd8220015}},	//   _למשת, _फ़ाइल_, _обяс, едши
  { {0xf6510003,0x13590012,0xe1f30012,0x7d190060}},	//   فئة_, _الأخ_, _يسر_, şası
  { {0xe9df014d,0xa77c000b,0x212d009b,0x52140001}},	//   _þú_, ירופ, _treh_, _одст
  { {0x5fcf0037,0x19580015,0x28b70037,0xb5fd0580}},	//   _स्थल, _даты_, _इंगि, dišt
  { {0x7529000f,0x7188000b,0xf8bf0028,0x3ea900b6}},	//   rvez, _וְעַ, rvél_, hmat_
  { {0x69c10066,0x7bc50052,0xa4480012,0x260c0011}},	//   ělen, ichu, تشيك_, ड्डी_
  { {0xdce7003a,0x69c10002,0x8f9a000b,0xc869000b}},	//   şlık, ślen, _היעי, _גן_
  { {0x55ba000b,0x7c23003a,0x5e440012,0xd378001b}},	//   _המנו, _tanr, _تَنْ, raća_
  { {0x3940004a,0x649000e6,0xd00a004c,0xccf90034}},	//   äisi_, häir, љеве_, muś_
  { {0xa0670001,0x602f0010,0x1867046d,0x07a3004c}},	//   чара_, dėmė, чари_, еарн
  { {0x6b9c0052,0x7bdc041e,0x75f60060,0x7e7b1444}},	//   ürge, _seru, müzü, nnup
  { {0x05660098,0xdd920003,0x7bdc1445,0x51fb000b}},	// [2b60] чван, روط_, _peru, _ההפצ
  { {0xe9f9001a,0x8fa60695,0x6490008e,0xee3f0064}},	//   _thả_, _напе, väis, _chýb_
  { {0x67bb000b,0xddc40002,0x68ed000e,0xc7bb0009}},	//   _למיק, oniż, áadn, _לציט
  { {0xf126002d,0x6490004a,0x2906004a,0xda650003}},	//   зько, täis, ttoa_, واني
  { {0xc5f3000b,0x7bdc1446,0xba290012,0xb05b008e}},	//   _אדר_, _teru, تسلم_, mpär
  { {0x6e260101,0x7c5a0003,0x6490004a,0x2906004a}},	//   _hakb, _السر_, räis, rtoa_
  { {0x29060006,0x6490004a,0x63830177,0xc66a003c}},	//   stoa_, säis, _згра, йшие_
  { {0xe663002d,0x6e260002,0x4b7b000b,0x64901447}},	//   етьо, _jakb, _האלו, päis
  { {0xc7b60012,0x6e3b0009,0x6e261448,0xa7b6004c}},	//   _فصاع, מתקד, _makb, _есеј
  { {0x44441449,0x515b000b,0x69c602f1,0x3b540024}},	//   nj_, _הכמו, ecke, дкор
  { {0x444400bd,0xb5fd024e,0x4f660012,0xe9ff0081}},	//   ij_, tišt, _عاطف, _hoạn_
  { {0x7f3b000b,0x76bb000b,0x6aa40061,0xee290003}},	//   _לעבו, _המאפ, _chif, _وأنه_
  { {0xb5fd001c,0x5a340048,0x3219144a,0x61fd144b}},	//   rišt, хнят, resy_, rgsl
  { {0x7b05004a,0xb97b0009,0x8c43034d,0x69c6144c}},	//   öttö, מרכז, _пече, acke
  { {0x9f34002d,0xb5fd0066,0xe9ff001a,0x3ebe0051}},	//   нері, pišt, _loạn_, _jutt_
  { {0x4444003e,0x61e20051,0x5f940447,0x4b7b0009}},	//   ej_, jaol, хист, _לאוו
  { {0x628f0026,0x61e20051,0x7afa144d,0xb87b0097}},	// [2b70] moco, daol, lutt, lsím
  { {0xf1b90027,0xe2f90024,0xd49b003c,0xe5530031}},	//   _sgš_, жежі_, ёра_, éséé
  { {0xe7a50039,0x93190003,0x7afa144e,0x7c280097}},	//   ādīš, تقاء_, nutt, iddr
  { {0xe1ff144f,0x7bc50732,0x68ed000e,0xe2980024}},	//   ciót_, schu, áado, пає_
  { {0xa954007c,0x3ebe0097,0x08c40024,0x9a880012}},	//   нкці, _autt_, ебін, أَنْ_
  { {0x7afa0006,0xe0d00012,0x75f60060,0x5d3a0009}},	//   kutt, ازن_, yüzü, _ותשא
  { {0xab95002d,0x69c6006f,0xef19002d,0x57240003}},	//   _циві, ycke, іми_, فريق
  { {0xa294007c,0xd738000b,0x7afa0a17,0x60cd004a}},	//   _засі, לטות_, dutt, _otam
  { {0xc212000b,0xd5e80012,0x2b490034,0xee360024}},	//   _בהן_, سعين_, _łac_, єнь_
  { {0x61ed00ec,0xd9280009,0xe53c0009,0x8b070030}},	//   _adal, _מֵעָ, מתחר, _naří
  { {0x60cd003a,0x28b70011,0x1c020011,0x6721001b}},	//   _atam, _इंजि, र्टल_, _uslj
  { {0x442b0034,0xd7f8004b,0x621900af,0x721900af}},	//   śc_, _umăr_, חוֹק, חוֹח
  { {0x98a4000d,0x7afa004a,0x2bfe0011,0xb1430198}},	//   _urmă_, autt, _लालू_, внял
  { {0x1cba000b,0x94ba0009,0xa7da0012,0x5b250012}},	//   _ומסע, _ומסת, توسط_, _يفشل
  { {0x92e8000a,0x66e6002d,0xcec40066,0xdee60024}},	//   _فريق_, ьова, daří_, ьови
  { {0x93240012,0xa695004c,0x6e291450,0xed5a0472}},	//   _أرون, еруј, ndeb, ооб_
  { {0xc986000a,0xfce30047,0x3cf50037,0x44271451}},	// [2b80] _تشغي, кото, एंगे_, _kan_
  { {0x58f7000b,0xb05b0a50,0x44440250,0xa3ba0012}},	//   _קצין_, spär, uj_, زائر_
  { {0x7d090005,0x661b004a,0xe9ff001a,0xe1ff06be}},	//   htes, keuk, _soạn_, ciós_
  { {0x44270020,0x8b070066,0xe1ff0002,0xdb24000e}},	//   _lan_, _zaří, chód_, ésév
  { {0x51830046,0x09360012,0xa0c40012,0x09e30542}},	//   куша, براج, ريغو, точн
  { {0xdfcf0003,0x2056027f,0x7afa1452,0xd943004c}},	//   ليه_, ьтер, yutt, тељи
  { {0x3e7a001e,0xc7b00012,0x90870012,0xe737004c}},	//   līti_, دّث_, بنوك_, деј_
  { {0x442701e4,0x7afa004a,0x7c270034,0xddc9004b}},	//   _aan_, vutt, _zajr, vieţ
  { {0x7eb5007a,0xd7cf0037,0x3e7a001e,0xc0060014}},	//   _išpl, _स्वच, nīti_, _опак
  { {0x442703f2,0x6026002d,0x61e00e26,0x3ebe00b8}},	//   _can_, _ідеа, _heml, _tutt_
  { {0x44271453,0x93f7000b,0x7afa004a,0x69c10002}},	//   _dan_, וציא_, uutt, ślem
  { {0xb87b0065,0xddc9007d,0x7afa1454,0x92580015}},	//   rsím, rieţ, rutt, дают_
  { {0x84460003,0x8b070066,0x44271455,0xbebc0035}},	//   _يختل, _paří, _fan_, _trīs
  { {0xa3df0044,0x44270039,0x3e7a001e,0xd4c50012}},	//   तरण_, _gan_, dīti_, _أغني
  { {0x764b00b6,0xabfb000b,0x626b0066,0xc7b10009}},	//   _yogy, _והור, dřov, ָ֑ם_
  { {0x61ed0b9c,0x7a870012,0xd91b0048,0x69c80030}},	//   _udal, _تشتم, _дьо_, ědec
  { {0x60cd00c6,0xce940014,0xddc9001e,0xb5fb0028}},	// [2b90] _utam, татъ, nieš, _smás
  { {0x201c0027,0x752d00c1,0xd49b0024,0xfdbb0011}},	//   jevi_, rvaz, іра_, _उल्फ
  { {0xa3a90044,0xd371000a,0xc7d6000b,0x201c1456}},	//   खें_, دها_, _אותי_, devi_
  { {0xa4d5002d,0xd3a40014,0xdb0e000e,0x7d09004a}},	//   _помі, труп, áján, ytes
  { {0xcce7000a,0xe6ed0026,0xb5fb014a,0x61e40028}},	//   _تسجي, _väčš, _vlád, ðila
  { {0xa158000b,0xd0110003,0x07a50146,0x8fa5077e}},	//   ובדה_, الغ_, налн, нале
  { {0x44271457,0x2bae0011,0xd00e0012,0x69c10030}},	//   _ran_, झेदा, صلي_, ělej
  { {0x6d250083,0x74d60011,0x87b80009,0x5a340530}},	//   едиз, मीकृ, ולוס_, _инст
  { {0xe5790015,0x6fca0037,0x44271458,0x68e91459}},	//   язи_, _स्कू, _pan_, _uved
  { {0x61e0080a,0x201c00c1,0x3eb9145a,0xc014022a}},	//   _zeml, cevi_, _list_, _имущ
  { {0x4427145b,0xddc9007a,0xdbdc0028,0xe29a013b}},	//   _van_, aieš, ráði, зан_
  { {0xdddb0030,0xc3320009,0x23780031,0x7d09145c}},	//   louž, אוט_, úrja_, ptes
  { {0xddc90039,0xdb1c006f,0x4427145d,0xc19a0024}},	//   cieš, _ifrå, _tan_, ятої_
  { {0x3ead145e,0x32040034,0xf8a70012,0x442701a0}},	//   lmet_, żmy_, طة_, _uan_
  { {0x6a96002d,0xa30e0037,0x6013003a,0x68ed000e}},	//   _приє, _सहेज_, mımı, áadj
  { {0xb5fb145f,0x3e7a001e,0x6013003a,0xe61f0029}},	//   _aláb, tīti_, lımı, _skôr_
  { {0xd5b20003,0xceb2000b,0x626b0066,0x3ead11c9}},	// [2ba0] افذ_, רין_, třov, imet_
  { {0x4f26002d,0x8726002d,0x6013003a,0x61e01460}},	//   _здоб, _змож, nımı, _seml
  { {0x5fdb000b,0x80890003,0x224d0070,0x3e7a001e}},	//   _מחיק, _تضيف_, _boek_, sīti_
  { {0x2cb8032b,0xc332000b,0xb3460017,0x27e10052}},	//   _wird_, טוב_, laçõ, _zehn_
  { {0x645b000f,0xa3df0037,0x6013003a,0xc05a0024}},	//   áció, तरा_, kımı, зій_
  { {0x3ea6002a,0x20c6001a,0xddc9001e,0xb3460017}},	//   _shot_, _môi_, vieš, naçõ
  { {0x5f930538,0xf0930009,0x8ba3003c,0xd7930048}},	//   лишт, אנג_, _бирж, лишъ
  { {0xddc9001e,0x95ca0472,0x9634034d,0x97a90009}},	//   tieš, чука_, тниц, וֹפֵ
  { {0x644e0002,0x442a00b6,0xd406002d,0x61e6013d}},	//   _kobi, _kab_, няни, dakl
  { {0x54540098,0x224d0070,0x2cb8006f,0xfc320003}},	//   твот, _zoek_, örd_, احظ_
  { {0x8afc0002,0x59f900ac,0xd7060024,0xdfa60012}},	//   częl, меня_, _їзди, _أحذي
  { {0x24560065,0xa75b000b,0x375b0009,0x20c60081}},	//   _dæmi_, _מדבר, _מכבד, _bôi_
  { {0x2bd10044,0xf1bf000e,0xf1b9001e,0x8e470012}},	//   _द्वा, ldák_, _paši_, _سلوك_
  { {0xb3460017,0x853b000b,0x6013003a,0xdd3b000b}},	//   gaçõ, _מגדי, cımı, _מעדכ
  { {0xf1b91461,0xdb210060,0xddcd0034,0x61f40248}},	//   _vaši_, ötür, ykań, ådlö
  { {0x61e6003a,0xdb9b000b,0xddcd000d,0x639b0009}},	//   cakl, _מסור, diaţ, _מסונ
  { {0x3eb9045d,0x59d40003,0x3f9e0028,0xc7cb0015}},	// [2bb0] _vist_, _صغير, ýtur_, _ныне_
  { {0x3ead00a2,0xb3460149,0x2bbb0003,0x3eb90070}},	//   zmet_, caçõ, ساطة_, _wist_
  { {0x644e0082,0x442c0028,0x73a90009,0xae210011}},	//   _dobi, idd_, ֵינֵ, _मसलन_
  { {0x41b50012,0xd0d50048,0xe0d5004c,0x60130060}},	//   نمار, водъ, водњ, zımı
  { {0x6e3d0052,0x3e7a001e,0x88c8002d,0x7afe02dc}},	//   _insb, nītu_, елів_, aupt
  { {0xa3bc0044,0x644e02d1,0x442a0052,0xd576000b}},	//   _अलग_, _gobi, _gab_, _יתרה_
  { {0xddcd000d,0xf838000b,0xba770012,0x7d0d1462}},	//   ciaţ, תנות_, _كارت, ltas
  { {0xb3460017,0x99d70012,0xa2be0011,0x7c2a005e}},	//   zaçõ, _سترا, षदर्, _aafr
  { {0x6013003a,0x2d990058,0xc4850055,0xdddb01bd}},	//   tımı, æse_, клик, použ
  { {0x3e7a001e,0x7d0d1463,0x69d90032,0x629d1464}},	//   dītu_, itas, lbwe, elso
  { {0x601300a2,0xb9040037,0x68ed0db3,0x7d0d1465}},	//   rımı, भी_, _avad, htas
  { {0x16110037,0x45d500de,0x645a1466,0x80d80011}},	//   _डॉलर_, _родс, akti, नीके
  { {0xb3460017,0x320c0002,0xb7e60037,0x68ed000e}},	//   taçõ, ędy_, _क़दम_, áadh
  { {0x7d0d00c5,0xdfd20003,0x38a4006f,0xc7ce001a}},	//   dtas, شير_, föra_, hống_
  { {0xb3460149,0xf092000b,0x24960003,0x38a4006f}},	//   raçõ, ינך_, _جنود_, göra_
  { {0x20c6008a,0xdbc90051,0xb3460017,0x644e1467}},	//   _tôi_, _mõõd, saçõ, _sobi
  { {0x6e2b0101,0x27e70028,0xf1bf000e,0x644e1468}},	// [2bc0] _magb, kann_, zdák_, _pobi
  { {0x42d6002d,0x78fb000b,0x7e64002a,0x61e41469}},	//   віду, _קליפ, ship, _heil
  { {0xe3b8003a,0xbddb0007,0x09e60063,0x78ba0097}},	//   ldır_, _poèt, воен, _ritv
  { {0x6e2b0101,0xd259002d,0x6da60003,0xddcd000d}},	//   _nagb, нці_, _لمجم, riaţ
  { {0xe3b8003a,0x442c146a,0x61e4146b,0x644e0edf}},	//   ndır_, ydd_, _meil, _tobi
  { {0x644e0027,0xddcd000d,0xa2d60003,0x27e702dc}},	//   _uobi, piaţ, _ليست, gann_
  { {0xa7fc003a,0x9183001a,0x3e7a001e,0x8a060909}},	//   _alıc, iếp_, zītu_, _изве
  { {0xfaa605cc,0x6604146c,0x61e41326,0xb7bc0035}},	//   _рабо, ngik, _neil, _maģi
  { {0x09060001,0x60c40010,0xd0260014,0x6e2b146d}},	//   _шпан, _nuim, _имай, _dagb
  { {0x78ba00bd,0xdb1c0061,0xe56f0012,0xd467004c}},	//   _uitv, _agré, غطي_, киње_
  { {0x7c2a0065,0x6fd801e1,0x7d0d000e,0x93fb000b}},	//   _vafr, _न्यू, ztas, וליי
  { {0xfee9000a,0x3e7a0039,0xd3780027,0x7d0d146e}},	//   _أعلى_, tītu_, naći_, ytas
  { {0x6e200390,0x61e40028,0xd8770003,0xfdf70009}},	//   memb, _deil, ناسب, _יצאת_
  { {0x2bfe0044,0x1d17000b,0x3e7a001e,0xf1b3000b}},	//   _लागू_, _סקור_, rītu_, יסר_
  { {0x61e40119,0x8c1b000b,0x3e7a001e,0x260f0011}},	//   _feil, _חווי, sītu_, थ्वी_
  { {0xb5950015,0x61e40028,0x01650012,0x68ed001b}},	//   гибш, ðill, _مُعَ, šadi
  { {0xa50700e3,0x55070014,0x3944006f,0x7d0d146f}},	// [2bd0] ъявл, ъчва, ämst_, utas
  { {0x7d0d0f92,0x63f40003,0x648b001e,0xd37b0014}},	//   rtas, لأمر, kļie, мче_
  { {0x3e7a0039,0x7ea50065,0xddc60002,0x6e201470}},	//   nīts_, hópa, _dokł, kemb
  { {0x62820051,0x27e70052,0x7d0d0f84,0x99d40012}},	//   gnoo, wann_, ptas, لتها
  { {0xee3f0029,0xd1b80003,0xe4e4002d,0x7d001471}},	//   _iný_, ناها_, _вісн, jums
  { {0x7eb50073,0x6282020d,0xf8b50011,0xc2c50012}},	//   _išpi, anoo, ूदिय, _ميسي
  { {0x6e2b01e5,0xd8740003,0xe3b8003a,0xd7ee0003}},	//   _pagb, جانب, zdır_, سكي_
  { {0x442100c6,0xddcd0039,0x3e7a0039,0xe3b8003a}},	//   leh_, skaņ, dīts_, ydır_
  { {0xf1b9001e,0x27e70028,0xe616003c,0x7d000035}},	//   _pašu_, pann_, уды_, gums
  { {0x4421012e,0xe9f90020,0x60c40070,0xcf270012}},	//   neh_, _thẻ_, _ruim, _لرؤي
  { {0xf1b91472,0x6569000e,0xf8bf0031,0xbbe10011}},	//   _vašu_, szeh, kvés_, _फ़ैक
  { {0xcd350003,0x75240034,0xeb920009,0x52860012}},	//   _مرتب, ywiz, מָר_, الحك
  { {0x4a5a0093,0x4421016d,0x7afa1473,0x61e41474}},	//   גדרו, keh_, artt, _veil
  { {0xe3b800a2,0x44210027,0x04590012,0x7e62001b}},	//   rdır_, jeh_, _سلعة_, _zlop
  { {0x61e41475,0x99750002,0x3e7a001e,0xc29a003c}},	//   _teil, nęło_, lūta_, _птиц_
  { {0xa2060306,0xd627003c,0xd3560009,0x6fd40011}},	//   _спид, лосе_, _תיקי_, _ब्रू
  { {0x66c7003a,0x0eb90015,0xe9f9001a,0xa1130003}},	// [2be0] _sıkl, туры_, _nhẹ_, _هويت
  { {0x290200b6,0xb4e40011,0xdde30035,0x6e201476}},	//   muka_, _नबी_, ārša, zemb
  { {0x6e200101,0xb17d0029,0x66e60024,0x29021477}},	//   yemb, _reťa, _щона, luka_
  { {0x2cb00010,0x6f79000b,0x3ce80321,0xfbc90009}},	//   _žodį_, _יְרו, _चौथे_, לת_
  { {0xf9920003,0x29020029,0x3e7a001e,0x7a3b008e}},	//   حبا_, nuka_, zīts_, _hätä
  { {0x66c700a1,0x3cf90044,0xb87b0149,0xed590066}},	//   _tıkl, ोंने_, ssív, dyž_
  { {0x77ba0009,0x3c630024,0xe8160011,0x27e7005e}},	//   ׂמְח, _укрг, द्या_, _õnne_
  { {0x7c2e07ca,0x44f41478,0xe3c10060,0x26c5020d}},	//   _habr, апис, ğış_, _dulo_
  { {0x3e7f004a,0x38a40028,0x61ed0028,0xf6530009}},	//   lätä_, vörn_, ðale, מצה_
  { {0x3e7a0039,0x2452000d,0xa98b000b,0x7ea5000e}},	//   tīts_, _câmp_, _אָבִ, rópa
  { {0x36060003,0x68ed000e,0x8fa6010b,0x04970009}},	//   _مواف, áadv, _саже, רכיך_
  { {0x21b5007c,0x0bb7000b,0xa295002d,0x3e7a00cd}},	//   ийня, טלים_, рамі, rīts_
  { {0x6e93000a,0x5e93000a,0xd5ed001a,0x3e7a001e}},	//   _النا, _النط, hoạ, sīts_
  { {0x3e670051,0x6d46004a,0x3e7f008e,0x21580012}},	//   _mõte_, äkau, kätä_, اجَع_
  { {0xab270001,0x395f0259,0x316b0002,0xfc2f0012}},	//   _боја_, šus_, szcz_, _رحو_
  { {0x290200b6,0x7ea50028,0xbb3b000b,0xb5d50001}},	//   buka_, hópn, _טעוי, ржај
  { {0x3cee0044,0x9f430066,0xdbdf0028,0x62830061}},	// [2bf0] ेंगे_, mají_, _bíðu, énom
  { {0xe3b30003,0x9f430066,0x8c440001,0x3ea0008e}},	//   مرض_, lají_, беђе, alit_
  { {0xbb840003,0xb9c50012,0xfbd00012,0x3ea01479}},	//   ملكي, لقضي, ستل_, blit_
  { {0x9f430066,0x82f80012,0xda670012,0x4421147a}},	//   nají_, ارلز_, دائي, seh_
  { {0x7bc60066,0x41af0011,0x2d800064,0x442102a1}},	//   ěkuj, जेंस, _žien_, peh_
  { {0x0084002d,0x9f430066,0x3cfa0009,0xfd960009}},	//   бліо, hají_, _בלשנ, _כדרך_
  { {0xf7710003,0x9f430066,0x0058000b,0x656d0052}},	//   غات_, kají_, רשות_, lzah
  { {0xbb84000a,0x43840003,0x7ae3000d,0xee39147b}},	//   _الفي, _الفق, ântu, тни_
  { {0x9f430066,0x656d0052,0x7c21012b,0xfd460048}},	//   dají_, nzah, telr, изък_
  { {0x9f6b0098,0x99540001,0x26c5004a,0xf8b90012}},	//   _през_, _укуц, _tulo_, _شهاب_
  { {0xba760003,0x3e7a001e,0xc949000b,0x3b090001}},	//   لاحت, sūta_, _קמ_, њемо_
  { {0x6dc7000a,0x67b80003,0xdef6000b,0xcb12000b}},	//   _إزال, _صالح_, _כמעט_, חלט_
  { {0x9f47022d,0x6f03013d,0xfce507a7,0xb5fb147c}},	//   dané_, lunc, _толо, _plán
  { {0x2902001c,0x05a8002d,0xb4fa000b,0x442e147d}},	//   ruka_, _свій_, _יפני, _gaf_
  { {0xfaa60047,0x6f03147e,0x3f9e0028,0xdee60dc2}},	//   _како, nunc, ætu_, роби
  { {0xdbdf0065,0xfaf8001e,0x21290029,0x6e2f0081}},	//   _síðu, rzīt_, ťahy_, _cacb

  { {0x3ea00065,0x7c2e147f,0x6bd60012,0x9cb60012}},	// [2c00] rlit_, _pabr, لتار, لمرت
  { {0xa7fc00a2,0xa4430001,0x33d60024,0xb87b01bd}},	//   _alın, онуд, ріат, usít
  { {0xb7fb0009,0x130a003c,0xb87b0031,0xddc00031}},	//   _בפית, тней_, rsít, zimű
  { {0xb87b000f,0x3e7f004a,0x52760012,0xeb971480}},	//   ssít, rätä_, جائز, ших_
  { {0x3e7f0006,0x93bc000d,0x7bc300c1,0xa3e80011}},	//   sätä_, ndăr, _ognu, बरम_
  { {0xa073007c,0x7d040006,0xb937000b,0x6e241481}},	//   огіч, muis, יננו_, leib
  { {0x8c1b000b,0xe0b7000b,0x7d040feb,0xd6cf0024}},	//   _שולי, בלסט_, luis, ют_
  { {0xa2cb0037,0x95d70014,0x89d70012,0xb0fa0012}},	//   _तंत्, адът_, _نوفر_, _لفرض_
  { {0x9f430066,0xe611000b,0x78b10028,0x68ed000e}},	//   vají_, הִי_, ákvæ, áadt
  { {0xb7960001,0x6e240052,0x9f4701bd,0x8d730012}},	//   _крећ, heib, zané_, غايا
  { {0xe9f90020,0x9f430066,0x439405f7,0x1c0b0011}},	//   _chế_, tají_, санс, स्टल_
  { {0xc3330093,0xa2f70009,0x9f7b0009,0x877b0009}},	//   קור_, סמכה_, _בנבח, _באבי
  { {0xdd92000a,0x9f4700f1,0x4fc7010c,0x7d0413f2}},	//   _بوش_, vané_, исва, juis
  { {0xdc080039,0x78620026,0x611a001e,0x7d041482}},	//   _rēķi, _dôvo, mālā, duis
  { {0xf0b4002d,0x1754002d,0x9f470004,0x4fd70009}},	//   ійсь, овря, tané_, שולב_
  { {0x3bbb000b,0x8f1b000b,0x2c64006f,0xdce6003a}},	//   _במוד, כולת, _röda_, _aykı
  { {0xe4e7002d,0xa2ca0037,0xebc70001,0x611a001e}},	// [2c10] рібн, _सूत्, аљен, nālā
  { {0x6f03003a,0xe8160037,0x656d0052,0xea00001a}},	//   yunc, द्दा_, rzah, _trải_
  { {0xeb090003,0xbebc001e,0x75360010,0x656d0052}},	//   اقصى_, _drīz, avyz, szah
  { {0xe8f5000a,0x80f50012,0x3a980024,0x7d041483}},	//   مستخ, مستض, атію_, buis
  { {0x3cfe015f,0x98da0037,0x361a0009,0xf8da0011}},	//   _लिये_, _बढ़ाए, _גורד, _बढ़ाय
  { {0x61eb1484,0x6f03004b,0xf1bf0031,0xed560009}},	//   sagl, tunc, ldás_, _הבשר_
  { {0x61eb002c,0xe7080003,0xda35003c,0x62860034}},	//   pagl, لتين_, _левы, ynko
  { {0xcb12000b,0x44310164,0x52850003,0x7c251485}},	//   _מלל_, _haz_, _الرك, lehr
  { {0x95550003,0x95990015,0xee36003c,0x64551486}},	//   إخبا, ытку_, сны_, _kozi
  { {0xb4650047,0x3c650803,0xac18002d,0x4431009b}},	//   скол, ског, ацює_, _jaz_
  { {0x61e90005,0x4431001e,0xd259001e,0x8c1a0009}},	//   _keel, _maz_, _ziņa_, אותי
  { {0x99800026,0x78620026,0x64550027,0xddc2009b}},	//   žiť_, _pôvo, _lozi, _zmož
  { {0x61e90005,0xf652000b,0x7c250052,0xfe700012}},	//   _meel, _מצא_, kehr, _تدل_
  { {0xe9f90020,0x7d04004a,0x200c0051,0x66090154}},	//   _thế_, vuis, üdi_, lgek
  { {0x64430065,0x78a3001e,0x74120012,0x2d9200b0}},	//   _inni, ilnv, _رويا, _øyer_
  { {0x9f4500d9,0x22f60009,0xc4c60012,0xa3df0011}},	//   _celé_, _הזקן_, متطو, तरक_
  { {0xceb20093,0x6e240052,0x75290070,0x62990002}},	// [2c20] ליל_, reib, nwez, dowo
  { {0x4806002d,0x3137000b,0x4431000d,0xb9370009}},	//   _упов, _פנים_, _caz_, _פניו_
  { {0x61e90070,0xddcb0002,0x291f004a,0x9f45000e}},	//   _beel, _mogł, _apua_, _felé_
  { {0xa2ca0044,0x44250005,0x2018006f,0xfaf6000b}},	//   _संस्, hel_, lfri_, מצעי_
  { {0x64430006,0x2baa0037,0x61e90070,0x44310017}},	//   _onni, _करवा, _deel, _faz_
  { {0xd259001e,0xbb46027f,0xeb9a0867,0x8459004c}},	//   _viņa_, _легк, _биг_, _крст_
  { {0xf1bf1356,0x61e91487,0x1ef70012,0x8ad80009}},	//   ndár_, _feel, معية_, _כַּפ
  { {0x62990002,0xa6c70003,0x44251488,0x14f8004c}},	//   cowo, حويل_, eel_, анић_
  { {0x89660047,0x64690010,0x4431003a,0xe9f9001a}},	//   _укаж, šsių, _yaz_, _chẽ_
  { {0xe8d7000b,0xddc20107,0x26c210dc,0xe0860012}},	//   _לומר_, _umož, _liko_, _اجري
  { {0xb4db0054,0xd3d70003,0x4c9b0009,0xd7960012}},	//   _gràf, حبًا_, רביו, _الضخ
  { {0x4669002d,0x645c0051,0xfe720003,0x26c20027}},	//   _крім_, örib, _عدا_, _niko_
  { {0x2e370009,0x1dac0011,0xf4d70012,0xc27b0009}},	//   _לראש_, _चरित, _هونغ_, ררכי
  { {0x27ee0065,0x20181489,0xe81b0011,0x2fc5036e}},	//   nafn_, gfri_, प्पा_, ølg_
  { {0x447b000b,0xd6f8000b,0x44310fae,0x9c17000b}},	//   _תנוע, יִּש, _raz_, _החוק_
  { {0xf1ba0037,0xea00001a,0x7c250052,0x6455148a}},	//   ेशान, _trại_, wehr, _sozi
  { {0xdc550046,0xcbc70003,0x545503e2,0xd0110012}},	// [2c30] овањ, مزاي, оват, _قلة_
  { {0xe787002d,0x628a01e3,0xba3d0030,0x61e9148b}},	//   _гумо, éfon, _lhůt, _seel
  { {0x94a80098,0x8c1b000b,0x8afc0002,0x11d70003}},	//   стта_, רובי, częt, متشد
  { {0x4425148c,0x19eb0012,0xe81b0011,0x60c1148d}},	//   zel_, اراً_, प्ना_, _silm
  { {0x4acf0037,0x4425059b,0x61e90114,0x60c901e3}},	//   _संभव, yel_, _veel, _quem
  { {0x212d012e,0x859a0009,0xb17c0009,0x37090012}},	//   _vseh_, _כשרו, נטגר, لْتُ_
  { {0x786b00a2,0xb8d00037,0x62990002,0x2bdf0037}},	//   _güve, _टी_, powo, _प्या
  { {0x44250777,0xa77c0009,0x0f7c0009,0x5eec0009}},	//   wel_, טרופ, טרול, רַגְ
  { {0x60c100c5,0x60c90051,0xddcb0034,0x260a0011}},	//   _tilm, _uuem, _pogł, िलती_
  { {0x75290070,0xb4db0054,0xac960003,0x9f47119d}},	//   rwez, _tràf, ينيا_, laní_
  { {0x2dd50511,0xb7670048,0x224a0048,0x4425148e}},	//   _джер, _утай, апни_, rel_
  { {0x753d000f,0xd6ab0003,0x4425148f,0x6ffb001e}},	//   _orsz, _صدام_, sel_, sācē
  { {0xc5e80009,0x14750012,0x38a4005e,0x8aa80009}},	//   _הַצֹ, _واتج, löri_, מֹשֶ
  { {0x64430028,0x73c40012,0x2a69005e,0x316c0034}},	//   _unni, _فيهم, _elab_, ądz_
  { {0x1fb50232,0x7aa60012,0xe81b0011,0xae7a0024}},	//   зстр, _وإعل, प्या_, асах_
  { {0xcb12000b,0x00ca03e2,0x8afc0034,0x20180841}},	//   _חלה_, _клик_, rzęt, sfri_
  { {0x9f470004,0x80e60012,0x15ba003c,0x786b04e7}},	// [2c40] daní_, _بأعل, рывы_, _süve
  { {0x63a30065,0x3e670051,0x0c230015,0xf1b90066}},	//   _kynn, _võta_, ммун, ýše_
  { {0xeac9001a,0x49ca0104,0xd1380002,0x7a0d000e}},	//   _mẹo_, ален_, łąd_, zőtő
  { {0x7e6d00bd,0xe8160037,0xb1cd0009,0x63a30245}},	//   chap, द्रा_, ְמוֹ, _mynn
  { {0xf6530009,0xbba60011,0xe80e0011,0xd0100012}},	//   _חצר_, _ऑर्क, _सादा_, ّلت_
  { {0x6e360010,0x88c50012,0xaff70012,0xb5fb0031}},	//   ldyb, ستهل, قفها_, _aláh
  { {0x787b000b,0x42d60024,0x3e6a0024,0xb5fb0030}},	//   יָהו, _фігу, ишин_, _bláh
  { {0x2000000d,0xbe8a0001,0x27ee0028,0x42d50024}},	//   şii_, јске_, safn_, _хіру
  { {0xd00a0046,0xceb30093,0xddc2003e,0x61e40028}},	//   _везе_, ויה_, _umoż, ðilu
  { {0x0bf30047,0xc8660003,0xaff70003,0x7d7b0009}},	//   мпью, _بطري, _وفقا_, ינפו
  { {0x61e20027,0x20d0001a,0xe3b8003a,0xfbd30009}},	//   obol, _hài_, ldız_, ותת_
  { {0xb5fb05b1,0x539b0009,0x5ce60048,0x63b500d9}},	//   _vlák, שיטו, _дюка, ýzna
  { {0xa2ca0011,0xb2bb0009,0x26cc0159,0x61ef1490}},	//   _सूर्, ימטר, _hudo_, racl
  { {0x74130012,0x14180012,0x54970012,0x60dd1491}},	//   _يونا, _طيبة_, _وضوح_, rpsm
  { {0x9f34002d,0xa7fc003a,0x8f340129,0xb6d80009}},	//   мері, _alık, мерц, מַּט
  { {0x9757000b,0x61e2048b,0xa195002d,0x19950024}},	//   חילו_, jbol, _найч, _найя
  { {0x9f47015d,0x7e6d1492,0x61e20058,0x6eca0034}},	// [2c50] vaní_, rhap, dbol, _dębi
  { {0xa3a70046,0x61ed002a,0x2ba70001,0x7e64002c}},	//   ојек, _heal, ојев, akip
  { {0xd498002d,0xf429004a,0x58b80003,0x9f470029}},	//   іру_, lmää_, _بايج_, taní_
  { {0x20d00020,0x75220c82,0xe5030011,0x61ed0132}},	//   _bài_, _opoz, _लिपि_, _jeal
  { {0xdd860351,0x20d00020,0x71270003,0xd92b0048}},	//   _أو_, _cài_, ترال, рцел_
  { {0x55ba000b,0x20d0001a,0x660d005e,0x60dc0009}},	//   _למרו, _dài_, lgak, סקונ
  { {0x915e001a,0xb5fd001e,0xf429004a,0xdb03014a}},	//   oặc_, ekša, hmää_, _ozná
  { {0xdb1c000e,0xb5fb0028,0x11d40012,0x38a4005e}},	//   _ugrá, _blái, _يتقد, röri_
  { {0x6447048b,0xa9240010,0x1d22003c,0xc1040012}},	//   _knji, įžki, емым, _يوفي
  { {0x7c2804a3,0xb9240012,0x33d40024,0x1309003c}},	//   gedr, _تفكي, міют, бной_
  { {0x7ea50028,0x07080003,0xbb450695,0x6b560009}},	//   hópi, _ويكي_, ченк, ִישׁ_
  { {0xce380003,0x7d16004a,0xacf50012,0xd5750024}},	//   _وأنا_, ytys, _فستت, _нуль
  { {0xf8cb0037,0x8d770012,0x61ed1493,0x74b906bd}},	//   ादिय, _باضا, _deal, _лукс_
  { {0x5d3a000b,0xfd56000b,0xc9520009,0xfaf10012}},	//   _לתנא, _משני_, תמך_, _كثب_
  { {0x7d09004a,0x6c320003,0x61e20361,0xfbd20009}},	//   lues, _سفيا, ybol, _אתו_
  { {0xee3a0001,0x6446001e,0x644700b6,0x61ed1494}},	//   љна_, ēkie, _anji, ðall
  { {0x2bd20011,0xd00a004c,0xc6920009,0xb4db01a0}},	// [2c60] _सलमा, _лепе_, גאן_, _aràb
  { {0xd7f1001a,0x7e641495,0x628b139d,0xd5af0012}},	//   ữa_, skip, engo, افك_
  { {0xf8b30093,0x8b26002d,0x53a60003,0x7d16004a}},	//   _רשת_, ядже, أماك, stys
  { {0x7659003e,0x2ab2000f,0x0ae90003,0x316a002d}},	//   _nowy, lább_, تركي_, йшло_
  { {0x40340014,0x90560009,0x3034003c,0x6e29005e}},	//   делс, ּסֶף_, делё, deeb
  { {0x20d00020,0x7e880066,0x26cc0164,0xe0430001}},	//   _vài_, měpi, _pudo_, енљи
  { {0xe1ff0002,0x61e40028,0x91e61496,0xd9b90011}},	//   chów_, ðils, _нове, _इण्ट
  { {0x20d0008a,0xfaa3007c,0x7d040027,0xdceb003a}},	//   _tài_, _засо, oris, _aygı
  { {0x2ab2000e,0x628200e6,0xb5fd0035,0x90e50012}},	//   kább_, mioo, ukša, _يسكن
  { {0x26cc0149,0xd4d70003,0x61ed1497,0xf3f10081}},	//   _tudo_, أبيض_, _seal, _ột_
  { {0x61ed0005,0xa3b60037,0x60cd00b6,0xe61a1498}},	//   _peal, चें_, _suam, _где_
  { {0xaf49000a,0xcf250003,0x6fd80011,0x7d041499}},	//   _بشكل_, _تركي, नुरू, kris
  { {0x7d090164,0xe5340015,0xb5fb0042,0x1e570009}},	//   cues, _цель, _kláv, _משאר_
  { {0x61e000a2,0x55bb000b,0x629d004a,0x61ed002a}},	//   ımla, _המדו, soso, _weal
  { {0x8c1b007e,0xda0d0037,0xf429004a,0x7c35017b}},	//   _הווי, _हालत_, smää_, _razr
  { {0x443f00a2,0xdb0300d9,0xe0df00b8,0x9f47009e}},	//   _şu_, _uzná, ppò_, naná_
  { {0x81fc000b,0xaffd002d,0x22490029,0x82340012}},	// [2c70] _ההחז, _копi, _inak_, _سريا
  { {0xdfd10003,0xfbd00012,0x734b0048,0x68f80030}},	//   _جيد_, هتم_, йчев_, řadí
  { {0xde59002d,0xaac70003,0x68e9149a,0xd3710012}},	//   _дані_, ستان, _swed, خها_
  { {0xe3b0000a,0x62820051,0x68e9002c,0x7d040082}},	//   ارك_, gioo, _pwed, bris
  { {0x9179008a,0xdddb0002,0x9f4701bd,0xf6560009}},	//   _bấm_, ykuł, daná_, _חסרי_
  { {0x0138000b,0xc7a5002d,0x07a5011f,0x8fa502ac}},	//   פרות_, милк, малн, мале
  { {0x76590002,0x6626000e,0xc7d8000b,0xddc90002}},	//   _powy, _ütkö, לוגי_, pież
  { {0xb4db03eb,0x645c0163,0x56920001,0xb5fd009b}},	//   _gràc, örin, кајт, akšn
  { {0x58050012,0xa5250024,0xdb1c0248,0xb815004c}},	//   _يورك, ємод, _egrä, _одај
  { {0x22490535,0x7870008e,0xab650024,0x38350024}},	//   _anak_, _käve, двол, _інер
  { {0x6ee7000a,0x2ab2000e,0x1a2a0014,0x29190c25}},	//   _رسال, vább_, ожни_, etsa_
  { {0x7d0902d1,0x1dbf0037,0xc869000b,0x4a43002d}},	//   pues, ्शात, _דן_, внюв
  { {0x7d09149b,0x9f64008e,0x66c70060,0x91f60009}},	//   ques, ätön_, _fıkr, ומרו_
  { {0x63851154,0x22490f49,0xcb690dd8,0x55ba0009}},	//   _огла, _enak_, _мале_, _ומנו
  { {0xe29f0065,0x75450002,0x82860012,0x2bf60009}},	//   boð_, łrzę, _يجعل, _חמצן_
  { {0x39400010,0xd9f20011,0x38a40097,0x7af50031}},	//   _tris_, _अजित_, vöru_, áztu
  { {0x32d30020,0x6fa40011,0x38a40248,0x51fb0009}},	// [2c80] _hãy_, _चुनू, fört_, _והפצ
  { {0x88c60003,0xa2e60015,0x26cc0056,0x7d04149c}},	//   _تتعل, дожд, ídos_, rris
  { {0xb4db0054,0x6282149d,0x3ea9149e,0x7d04149f}},	//   _pràc, tioo, blat_, sris
  { {0x41aa0014,0x2a88000e,0x3ea90054,0xf1260024}},	//   овен_, lőbb_, clat_, дько
  { {0x62820005,0x9f4700f1,0xb5fb14a0,0x20d40269}},	//   rioo, vaná_, _cláu, _jäi_
  { {0x6282035f,0xd6da14a1,0xa3c80011,0x3ea014a2}},	//   sioo, оти_, _उलट_, loit_
  { {0x4438007d,0x7ea50065,0x6564008e,0x3ea00227}},	//   _iar_, hópu, lyih, ooit_
  { {0xa3c30037,0x1d3405cc,0x9f450061,0xc7b30009}},	//   ्शन_, ения, _delà_, כבו_
  { {0x645c14a3,0x44380660,0x64c80011,0x5c060148}},	//   _kori, _kar_, रदेश, мяна
  { {0x986a0012,0x515b0009,0xac26003c,0x3b540469}},	//   _بحرف_, _וכמו, ффик, екор
  { {0xd37a022e,0x2a88000e,0xe29f0097,0x88c50012}},	//   ючи_, zőbe_, toð_, _ستكل
  { {0xaacf0037,0x32d3001a,0x443814a4,0x7ea50031}},	//   _संरक, _dãy_, _lar_, fópu
  { {0xa2ca0037,0xd1260003,0x76bb000b,0x394d0018}},	//   _संक्, دم_, _ומאפ, ães_
  { {0x645c039c,0x104b002d,0x9f430029,0x291914a5}},	//   _nori, цями_, majú_, rtsa_
  { {0xc058002d,0x61ed0028,0x67d4002d,0x9f430029}},	//   фія_, ðalk, тосу, lajú_
  { {0xe4e7002d,0x92580003,0x38a4006f,0x5afb000b}},	//   діжн, _يشير_, förs_, _ולהצ
  { {0xdfd50047,0x865b000b,0x7c38003a,0x9f430029}},	// [2c90] _попы, קדמי, _kavr, najú_
  { {0xb5fd0039,0x443814a6,0x442c14a7,0x3ea914a8}},	//   ekšl, _car_, ned_, slat_
  { {0x645c007d,0xf2d00003,0x3e7a001e,0x443814a9}},	//   _dori, لآن_, lūtu_, _dar_
  { {0x23df015f,0x2bdf015f,0x53df0044,0xfbdf0044}},	//   _प्रद, _प्रा, _प्रश, _प्रम
  { {0x81f60003,0x6d440010,0x26de00c1,0x4dda000b}},	//   رفور_, _šian, _atto_, _מחרו
  { {0x9f430029,0x3e7100f1,0x443814aa,0x442c14ab}},	//   dajú_, _máte_, _gar_, jed_
  { {0x442c0b7b,0xa2ca0037,0x8fa20a1a,0x60c80010}},	//   ded_, _संग्, лаше, _didm
  { {0xee32000b,0x2ab2000e,0x38b60260,0x9f450042}},	//   ָֽה_, kába_, mære_, _celá_
  { {0xd14b000a,0x2ab2000f,0x79a70001,0x6606000e}},	//   _بشأن_, jába_, _црве, ókka
  { {0xa2ca0044,0xe451000a,0x6aa414ac,0x442c14ad}},	//   _संख्, اضة_, _skif, ged_
  { {0x6d420352,0x6a860014,0x7c38003a,0xae0f0037}},	//   _eroa, елна, _davr, िलान_
  { {0xdb1e0066,0x644a0c4d,0x5ee80009,0x7d0d14ae}},	//   áván, _enfi, _חַסְ, kuas
  { {0x3e7a0039,0x7e690028,0x3e6e0028,0x442c0087}},	//   gūtu_, mkep, _nýta_, bed_
  { {0x442c0036,0x7ea50028,0xa2ca0321,0x8d5a0009}},	//   ced_, rópu, _सूक्, _מכני
  { {0xd5b70020,0x7f190024,0x443814af,0x3ea014b0}},	//   ếng_, міту_, _rar_, toit_
  { {0x2a88000f,0x26de001e,0x3e7a001e,0x7c3814b1}},	//   sőbb_, īto_, būtu_, _zavr
  { {0xeb1f0044,0x765d00a2,0x443814b2,0x3ea00ca7}},	// [2ca0] _बहुत_, _dosy, _par_, roit_
  { {0x7d1b0006,0xc19b000b,0xf9770009,0xe3b20012}},	//   itus, _משפי, _נגיש_, هرا_
  { {0x7d1b0051,0x9f430029,0x09ba0037,0x961d001e}},	//   htus, zajú_, ेश्य, ziņa
  { {0x443814b3,0x442c14b4,0xe1f20003,0xd259002d}},	//   _war_, zed_, اسا_, мці_
  { {0x442c0036,0x21670e0f,0x7ea50028,0x443814b5}},	//   yed_, ници_, hóps, _tar_
  { {0x9f430026,0x442c002a,0x628614b6,0x81430012}},	//   vajú_, xed_, hiko, انون
  { {0x442c0036,0xe6660001,0xab090003,0x7d1b00ff}},	//   ved_, етпо, _يتفق_, etus
  { {0x442c0036,0x9f47003a,0x7c380027,0x9f430029}},	//   wed_, zanç_, _savr, tajú_
  { {0x2dd70003,0xb5fb0028,0x3cf90037,0x442c14b7}},	//   ربية_, _klár, ोंगे_, ted_
  { {0x9980007a,0x7d7b000b,0x60fb000b,0x9f430029}},	//   žių_, פניו, _מהמק, rajú_
  { {0x7d1b0051,0x442c14b8,0xaf490003,0xdf490012}},	//   atus, red_, _يشمل_, _يؤمن_
  { {0x62860005,0x99890029,0x442c14b9,0x58d50024}},	//   giko, žať_, sed_, комт
  { {0x765d0002,0x61ed0028,0x60f80015,0x442c14ba}},	//   _rosy, ðali, нняя_, ped_
  { {0xd259001e,0x765d14bb,0x62860079,0xc0580024}},	//   _viņi_, _sosy, aiko, ніс_
  { {0x6e2d14bc,0x02a714bd,0x36d5020e,0x8bd70009}},	//   teab, _прим, тобр, _טוגו_
  { {0x99850012,0x7d0d14be,0x25dc0011,0xb21b0506}},	//   _للعو, tuas, गुली_, rnæs
  { {0x68ed0002,0xa3d5003c,0x2439004c,0x8d740012}},	// [2cb0] _uwad, возч, мпањ_, هاكا
  { {0xb4ab0037,0xf8b8001a,0x9c38004c,0x6e2d14bf}},	//   खते_, _nhĩ_, нпут_, seab
  { {0x3944002a,0x72190109,0x749b0009,0x307c0009}},	//   _arms_, джер_, לימפ, _מאזנ
  { {0xd7f1008a,0x61cb0037,0x636b000e,0xa9350012}},	//   _sẽ_, िशेष, lönö, َّاب
  { {0xe0d8002d,0x229c0066,0x865a0009,0x26da03a7}},	//   еві_, níky_, _חדרי, ípon_
  { {0x99920002,0x717c0009,0xc0c8004c,0x628614c0}},	//   _abyś_, הנדס, нује_, ziko
  { {0x201a0054,0xd00e0003,0xa6950001,0xf8380009}},	//   òpia_, زلي_, криј, גנות_
  { {0x7bda000d,0x8aa40024,0x99d40012,0xc1050012}},	//   ectu, _бруд, _متكا, _لوري
  { {0x7d1b14c1,0x58d5002d,0x7a42000e,0x7e6906d2}},	//   utus, _розт, nítő, rkep
  { {0x44ef0002,0x446504f0,0x58d414c2,0x290f005e}},	//   iż_, твов, _софт, muga_
  { {0xfbd2000b,0x7d1b14c3,0xe29a0751,0x290f14c4}},	//   יתי_, stus, дан_, luga_
  { {0x7de70003,0x7ea514c5,0xc3320009,0xf9870012}},	//   _أسام, róps, בוט_, لب_
  { {0xa5640003,0x290f0051,0x6fd80011,0x2d640012}},	//   _مدون, nuga_, नुकू, _مطوّ
  { {0x3ea014b1,0x628614c6,0x291d0034,0x88e30024}},	//   čite_, siko, itwa_, ржре
  { {0x44ef003e,0x8fa60014,0x290f03c2,0x07a602e3}},	//   eż_, таве, huga_, тавн
  { {0x290f0051,0x7aed0002,0x7bdc00c1,0xf2d20009}},	//   kuga_, _łatw, _sfru, _דעה_
  { {0xc5f20009,0x290f005e,0x62840034,0x7e23004c}},	// [2cc0] ידן_, juga_, _imio, јдуж
  { {0xb4db0054,0x20040010,0xad650003,0x6aca0011}},	//   _tràn, ėmis_, دافه, िद्र
  { {0x7d090052,0x753c001e,0x3ead14c7,0x26cb14c8}},	//   hres, ārzi, klet_, _fico_
  { {0x6d44007a,0x290f14c9,0x7d0914ca,0xf98a0012}},	//   _šiam, fuga_, kres, وناي_
  { {0xc05a002d,0x01330003,0xd98d0009,0x290f005e}},	//   дій_, لعود, ּנוֹ, guga_
  { {0xdc080039,0xc013002d,0x7afc0027,0xa7fc003a}},	//   _mēģi, иміщ, _tvrt, _alır
  { {0x7d09000f,0xceba0001,0xba0a0012,0x291d14cb}},	//   eres, мљи_, _يترك_, atwa_
  { {0x539b000b,0x3ead14cc,0xcf930009,0x6e440012}},	//   _חילו, glet_, יטו_, انظم
  { {0x291d0002,0xdd110060,0x27f80159,0x7d0914cd}},	//   ctwa_, _müşe, karn_, gres
  { {0xccf30009,0xa3b90011,0x3ead04e2,0x3e67005e}},	//   סכת_, _चरम_, alet_, _võti_
  { {0x1877000b,0x961d001e,0x7c3c14ce,0xc3340009}},	//   _שעבר_, ciņo, _marr, נוֹ_
  { {0x87170009,0x2179003c,0x55e6004c,0x9e6614cf}},	//   _יקבע_, еймы_, _родб, _швед
  { {0x58870015,0x2ab9000e,0x644e0060,0x5e570009}},	//   выва, jébe_, _onbi, _שידע_
  { {0x3e750119,0x5c73002d,0x8cd60011,0xa3d30048}},	//   _måte_, _кліт, _बढ़ो, _кошч
  { {0x59a5015f,0x6d4600a2,0x54330003,0xd259001e}},	//   _ऐडवर, _arka, _ضرور, _ziņu_
  { {0x644e0052,0x3cfe0037,0x7f3b0009,0x443e14d0}},	//   _anbi, _लिखे_, ועלו, ldt_
  { {0x961d0039,0x44ef0002,0xdd11003a,0x65150012}},	// [2cd0] ziņo, uż_, _düşe, طوائ
  { {0x291e000d,0x3e710028,0x443c08dd,0x443e14d1}},	//   ătat_, _máta_, _jav_, ndt_
  { {0x44e20020,0x3e710065,0x7c3c14d2,0x6d460052}},	//   hư_, _láta_, _darr, _erka
  { {0x69dd000f,0x99840010,0x290f0688,0xf5e40024}},	//   ncse, _namų_, tuga_, _вірм
  { {0x3ead003a,0xc27c000b,0xe8df0081,0x764f0034}},	//   vlet_, וראי, _trọn_, _incy
  { {0x443c0333,0xad1a000b,0xfc640014,0x443e0070}},	//   _nav_, _אושר, _късн, jdt_
  { {0x290f0051,0x291d0002,0x28da0037,0x7e770227}},	//   suga_, stwa_, _यूनि, ëxpo
  { {0x443e0070,0xc1e30321,0x72190009,0x7d0914d3}},	//   edt_, _क्लब_, _רוּח, tres
  { {0x3ead14d4,0x7e6d07cc,0xc0ab0012,0x61ed0097}},	//   rlet_, ikap, _قائل_, ðalu
  { {0x40e8000b,0xd259001e,0x649d0054,0x3e710029}},	//   _יַעֲ, _viņu_, nèix, _dáta_
  { {0x46150012,0xbe150012,0x7c2e005e,0x7e6d12fb}},	//   _موار, _مواع, õbra, kkap
  { {0x32ba0003,0x99160024,0x6e3d0030,0x6d030011}},	//   عددة_, льгі, _nasb, _लिंग_
  { {0xf9920003,0x321e0002,0x9dd6000b,0x7e6d0040}},	//   صبح_, ęty_, _עוסק_, dkap
  { {0x38b60028,0xdfd20003,0x9be7002d,0xe73a0015}},	//   færa_, صير_, _рідк, нег_
  { {0xdc9a000b,0xdbd10051,0x4c9a0009,0xbc1a0009}},	//   _איסל, _müük, _אבסו, _נוקש
  { {0xd7f10020,0x9e750001,0x93bc004b,0x69dd0031}},	//   _dõi_, аћуј, sfăc, ccse
  { {0x261b0037,0xbda50003,0x12a90012,0x657b0032}},	// [2ce0] _यानी_, لحكو, _جدوى_, nzuh
  { {0x3157000b,0x7e6d14d5,0x7e7614d6,0x2ab90031}},	//   _עיין_, akap, shyp, rébe_
  { {0x645c0005,0xa3b90037,0x8e860014,0x629d0025}},	//   örii, _चरण_, _бгне, érog
  { {0x7c3c0614,0x998d0034,0x26da0064,0x20d30011}},	//   _warr, _oceń_, ípom_, _धूँध
  { {0x64430017,0x6a660097,0x0d8304a5,0x7c3c14d7}},	//   ônic, _hófs, _глян, _tarr
  { {0x8d4b000b,0x3e7114d8,0x10a303b0,0x20f20035}},	//   _אֲלֵ, _ráta_, бичн, iņi_
  { {0x87260012,0x7fd70009,0xcf260012,0x2bc30011}},	//   اعتم, נוקס_, ارتي, वेदा
  { {0x9b930003,0x61ed0028,0x443c0027,0xfaa60dd8}},	//   _الفت, ðalt, _sav_, _сабо
  { {0xa2a10044,0x6d4414d9,0x10160003,0x443c0010}},	//   गकर्, nvia, _مباد, _pav_
  { {0xd5c00044,0x1dc00037,0xe8d7000b,0x74140012}},	//   शेषज, शेषत, _עובר_, جودا
  { {0x443e01e4,0x68e4007a,0xfeea0012,0x7e6d020d}},	//   rdt_, _atid, _أعطى_, ykap
  { {0x8f9b0009,0x6f790009,0xdd000060,0x673a001b}},	//   _איבי, _בְנו, ştık, _istj
  { {0x786b0051,0x6d440029,0x9f5100d9,0x1dc00011}},	//   _hüvi, jvia, razí_, शेशत
  { {0x6d3b0093,0x9182001a,0x9f470029,0x60d6003a}},	//   _נתונ, _mềm_, vanú_, _duym
  { {0x9999000f,0xb4c20037,0xb4c00037,0xcebb0001}},	//   reső_, ्दी_, ंगी_, еља_
  { {0x58d50098,0xe80e0037,0x539b0009,0x9f470064}},	//   _коит, _साझा_, _ריהו, tanú_
  { {0x5d550014,0xd7fb004c,0xb4db01a0,0xa5bb0034}},	// [2cf0] шкат, _пун_, _tràm, _zbój
  { {0xd0110003,0x9ed90014,0x673a0051,0x7e6214da}},	//   _بلد_, _имот_, _ostj, _loop
  { {0x649d0054,0xca150048,0x998d0034,0x988c0009}},	//   rèix, иджъ, żeń_, _רָחֵ
  { {0xeb91000b,0xe3c40012,0x8bc4003c,0xbddb01a0}},	//   חָד_, حْمَ, ссуд, _enèr
  { {0xc5fa000b,0x8dfa000b,0x61f914db,0x95670048}},	//   _בפרט, _שהשת, rawl, _сънд
  { {0x21660001,0xd0060048,0x1bd404ac,0xa3d40217}},	//   риши_, аеше_, _горя, _горч
  { {0x61ed0028,0xdc9a0009,0xcee80012,0x4c9a0009}},	//   ðals, _יישל, هرين_, _יבשו
  { {0x39490101,0x0f58000b,0xa2950024,0xfde60048}},	//   _oras_, ריהם_, _табі, адък_
  { {0xd455002d,0x7ae4058a,0x7d0d004e,0xb4c20011}},	//   атнь, _čita, nras, ्दू_
  { {0xddc40073,0x4c6900b5,0x69a90011,0x4b250d7c}},	//   nkiš, тион_, _घड़ी, амов
  { {0xe1ff003e,0x96550014,0x3a3f14dc,0xa0c40012}},	//   nków_, _вълч, _kaup_, _ايلو
  { {0xa96a0046,0x216a002d,0x39490061,0x7d0d0755}},	//   вима_, вими_, _bras_, kras
  { {0xe2970075,0xee780003,0xec6e01b6,0x9975004c}},	//   рая_, _حصلت_, _дп_, бурш
  { {0xd4660046,0xb4fa0093,0x6d4400c1,0xd00f0003}},	//   _више_, _ספצי, vvia, ولُ_
  { {0xe8170037,0x8c1a0009,0x6ec60012,0xe7e50011}},	//   _तारा_, _יוסי, لترق, कड़ा_
  { {0x539a0214,0xcce60003,0xe1ff0002,0x7afa0028}},	//   _ביצו, لسطي, dków_, _ætti
  { {0xf652000b,0x9f450029,0xd4da002d,0x628b0d85}},	// [2d00] חצן_, _celú_, тьбі_, digo
  { {0xe0fb0093,0x628b0010,0x78fb0009,0xec7714dd}},	//   _שליל, eigo, _שליפ, апу_
  { {0xdddd000f,0x0ca90003,0x2bab0037,0x2abc01e3}},	//   _első, اطقي_, _घुमा, híbe_
  { {0x6da6002d,0xd36f0003,0x8b650003,0x9f4c01e9}},	//   _вима, بهم_, حاكم, _nedá_
  { {0x29000017,0x90c6035c,0x9f4301e3,0x7a460031}},	//   éia_, абде, bajó_, jétő
  { {0x201814de,0x201a0051,0xf1a90003,0x3eb2004a}},	//   ngri_, üpi_, دامه_, llyt_
  { {0xa067004c,0x628b14df,0x26cf020d,0x644114e0}},	//   раја_, bigo, _bigo_, ddli
  { {0xeb97007c,0x224000c6,0x64410052,0x290c0002}},	//   _тис_, _naik_, edli, ądaj_
  { {0xdcba002d,0xd5b7064f,0x61ed0164,0xb9290012}},	//   кщо_, ись_, ñale, _مثلك_
  { {0xb4c00044,0xceea002d,0x9169001a,0xb4c20037}},	//   ंगे_, _адже_, _lựa_, ्दे_
  { {0x224000c6,0xf8bf0061,0x36060003,0x3e75006f}},	//   _baik_, ntée_, _نواف, _låta_
  { {0x1bf20037,0xf8bf0025,0xfe790030,0x6fb30012}},	//   _आजकल_, itée_, chů_, _بمما
  { {0x867b0009,0x265b0009,0x50670048,0x78700248}},	//   _בראו, _שכדא, атва, _tävl
  { {0x5d7b000b,0x27fc038e,0x4d7b000b,0x39460017}},	//   _שָׁנ, navn_, _שָׁא, ivos_
  { {0x06fd0066,0x94bb0009,0x1cbb0009,0xa8570009}},	//   žívá_, _שמות, _שמוע, סילה_
  { {0x394902d1,0x8f9b0009,0xaa2d008e,0xf7770009}},	//   _tras_, דילי, ämää_, בעלי_
  { {0x9169001a,0x6ac40003,0xb2bc0009,0x05a70011}},	// [2d10] _dựa_, _بقيم, _במהר, _कुशब
  { {0xc3cb0003,0xe1ff0002,0xeaca001a,0x25bd0060}},	//   نظام_, tków_, _hẹp_, _ızlı_
  { {0x628b0149,0x309a000b,0x99d50012,0x389c0009}},	//   tigo, _תשתמ, مقات, _ביזנ
  { {0xde59002d,0x7d0d14e1,0x8f360009,0xda080012}},	//   _самі_, pras, _פארו_, ليمه_
  { {0x394902d1,0xe1ff0002,0x95cb0001,0x6441100c}},	//   ías_, sków_, _јуна_, ydli
  { {0x753d000e,0xb4c00011,0xd7f10081,0x22920159}},	//   _issz, ंगो_, ữu_, mške_
  { {0xf8bf0025,0xb21b0097,0x6d400097,0x83340012}},	//   ctée_, mhæf, _ámar, _ورفض
  { {0x2f98000b,0x2a64000e,0x7c2a0052,0x1798000b}},	//   יכון_, _gomb_, _abfr, ידול_
  { {0xc212000b,0x88070003,0x61fd0060,0x99850012}},	//   _מהן_, _نظام, dasl, _الذو
  { {0x3e710026,0x7d020604,0x98170012,0xd5780009}},	//   _táto_, _dvos, _خبرا, יתחה_
  { {0x69cb0037,0x7c640012,0x5f740012,0x9f580025}},	//   _तृती, تايل, _وامر, paré_
  { {0x6f1502d1,0xc869000b,0x272114e2,0x2d7f0034}},	//   duzc, _אן_, món_, _płeć_
  { {0xeaca0081,0x2c690064,0x272114e3,0xa3d70011}},	//   _dẹp_, _súdu_, lón_, ाखा_
  { {0x6ca40012,0xec780024,0x05a80024,0x9f430097}},	//   _وصول, _кпі_, _твій_, _þjó_
  { {0xb21b0058,0x66e609cc,0x753d0031,0x84560009}},	//   dhæf, соба, _assz, _לבסס_
  { {0xbda60003,0xaad00011,0xd1320012,0x39460073}},	//   محذو, _सूचक, _فمع_, yvos_
  { {0x442a00b6,0xee370001,0xed5704ac,0xba170009}},	// [2d20] _pbb_, љну_, бот_, _החפץ_
  { {0x98a90010,0xa3ab0011,0x290214e4,0x74160012}},	//   _ypač_, कअप_, mska_, صوصا
  { {0x272114e5,0x5f460012,0xf8bf0025,0x7fd70009}},	//   jón_, _انجل, utée_, _לויס_
  { {0xfad60093,0xf1fa000a,0xd7bb000b,0xd9fa0037}},	//   צונך_, اعات_, _תצטר, ्णित_
  { {0x186a0dc2,0x290214e6,0x61140024,0xf8bf0025}},	//   лади_, nska_, ідку, stée_
  { {0xf8bf0061,0x2721134c,0x76440060,0xa967004c}},	//   ptée_, fón_, ldiy, сиља_
  { {0x5f43000a,0x444400c7,0x290f01eb,0x272114e7}},	//   كنول, md_, arga_, gón_
  { {0x2296000a,0x32960003,0x3ea000eb,0x76440060}},	//   _الرس, _الرأ, čito_, ndiy
  { {0x61fd000f,0x99920002,0xb5fd001e,0x752414e8}},	//   vasl, żył_, ekšs, ntiz
  { {0xd6d2000a,0xb8650003,0x61e206b5,0xe56f0012}},	//   _فقط_, _والو, lcol, عطي_
  { {0x444414e9,0xaf9a0024,0xd00f0012,0x7e2a0024}},	//   id_, _стах_, _ألم_, _біла_
  { {0x6d440010,0x0bb7000b,0x539b000b,0xb5fd0010}},	//   _šiau, מלים_, ריטו, ukšt
  { {0xd5a70037,0x61fd017b,0x05a70011,0x76440060}},	//   _कुंज, rasl, _कुंब, ddiy
  { {0x444400bd,0x2d8004fa,0x69d6000e,0x8cd30011}},	//   jd_, dzie_, _egye, _भूगो
  { {0x7e66006f,0x1bfb000b,0x4fc400ac,0xaae60003}},	//   _bokp, _גלוב, зста, _استو
  { {0x6397000b,0xd6d801d4,0xa1950048,0x5f9414ea}},	//   _לדוא_, стр_, _майч, чист
  { {0x27210164,0x44440070,0x2d580055,0x9f4701bd}},	// [2d30] zón_, fd_, бить_, daný_
  { {0x444414eb,0xaae70003,0x80dc0037,0xebc70001}},	//   gd_, مسؤو, _पढ़े, бљен
  { {0xb21b0028,0xb5fd04d2,0x57fa0009,0xdb510012}},	//   rhæf, ljše, _דלתו, بَا_
  { {0xdb1f0028,0x656d002c,0x73c40003,0xf1bd0037}},	//   _ávís, pyah, سينم, _ईरान
  { {0xb5fd09d2,0x89370012,0x290f14ec,0x444414ed}},	//   njše, إعصا, urga_, bd_
  { {0x272102d1,0x07390003,0xcee90015,0x61e200b8}},	//   tón_, لسبب_, адке_, acol
  { {0x6d47001e,0xe7080012,0xcf240012,0x645514ee}},	//   ājam, متين_, كريي, _inzi
  { {0x61e201a2,0xb5fd001e,0x272114ef,0xc1050012}},	//   ccol, ekšr, rón_, _ووزي
  { {0x628f14f0,0x272101e3,0xec7914f1,0xb5fb14f2}},	//   dico, són_, ипи_, _bláz
  { {0x7305007c,0x917a001a,0x3209003a,0x272114f3}},	//   опоз, hập_, _aday_, pón_
  { {0xf412000b,0x29020002,0x8c1a000b,0xe3b10003}},	//   ופי_, wska_, בותי, برة_
  { {0x5cf5002d,0xd57501d4,0x290211f9,0xc2c60012}},	//   _дяку, _муль, tska_, تيجي
  { {0xd5480003,0xddc20029,0x29040bb3,0x787001a3}},	//   _هجوم_, _zlož, éma_, _hävi
  { {0x38b600c5,0x78700006,0x9f4701e9,0xd0120012}},	//   mærk_, _kävi, zaný_, بلس_
  { {0x44440348,0xe73a025c,0x6d4914f4,0xe81c0011}},	//   vd_, шев_, lvea, _नासा_
  { {0xee3a0001,0x661b0289,0x44440644,0x645514f5}},	//   јна_, nguk, wd_, _anzi
  { {0x7fd6007c,0x64430101,0x9f4700f1,0xa3c30037}},	// [2d40] _міні, _kani, vaný_, ्शक_
  { {0x2d800026,0x752414f6,0x44440b6a,0x93260012}},	//   rzie_, rtiz, ud_, قرصن
  { {0xe2860047,0x673e001c,0x6a860015,0xd2aa0015}},	//   олжи, _uspj, олжа, акже_
  { {0x9c870066,0x539a000b,0xe5670012,0x72290024}},	//   _počá, ביעו, _قط_, йців_
  { {0x01360003,0xa50a0001,0xdb070066,0xddc212b0}},	//   تعاد, _њега_, _vyjá, _slož
  { {0xc173000b,0x1df20037,0xb87b0066,0x644314f7}},	//   וחד_, घर्ष_, spív, _nani
  { {0x8b230046,0xd6d70015,0xea5a0001,0xdfcf0003}},	//   _одре, оты_, _крај_, نيه_
  { {0x3e78000e,0xddc214f8,0x9e660012,0xba1a0012}},	//   _béta_, _vlož, تاتن, _خيرا_
  { {0x3eb8001e,0x9f580029,0x91030001,0xe4c6003c}},	//   ērt_, darí_, _опте, жённ
  { {0xf8780009,0x67560012,0xdca3004c,0x628f0034}},	//   _פְּל, _وخار, мањи, wico
  { {0xee3a0015,0xddc214f9,0x33db0009,0x7bdb0009}},	//   _вне_, _ulož, יחיד, יקיו
  { {0x7d0414fa,0xdb21000e,0x9f4c004a,0x7f3b000b}},	//   ksis, étét, _vedä_, _כעבו
  { {0x212600c6,0x66d50010,0x22460002,0x394d01e3}},	//   ntoh_, _iška, idok_, íes_
  { {0x64430101,0x3ea90d6c,0x8c430001,0xdfd80014}},	//   _gani, čate_, _жеље, жът_
  { {0x64430017,0x628f0e0a,0x4e8b0048,0xfe730012}},	//   ônim, pico, ащам_, ودر_
  { {0xcb130093,0x6609001e,0x66000a12,0x6b7b0009}},	//   _חלק_, _ķeks, namk, _כרונ
  { {0x7d040101,0x95cb0014,0xdddd0002,0x9d15002d}},	// [2d50] gsis, рува_, _posł, ядач
  { {0x61fb0108,0xfc330003,0x18680001,0xa0680001}},	//   _seul, بحر_, _мањи_, _мања_
  { {0x2c180011,0x44e00081,0x68e914fb,0x6600016d}},	//   _दाईं_, _lò_, _sted, kamk
  { {0x05870046,0xa4d5002d,0xc175000b,0x9f4501bd}},	//   _дугм, _номі, ּחַ_, _celý_
  { {0x9e5a000b,0xd2b8000b,0xd13b066f,0x865a0009}},	//   _הכרט, קלדת_, рхе_, _הדרי
  { {0x68e90029,0xe042002d,0x3e7c0066,0x21580003}},	//   _vted, енши, _víte_, تجمع_
  { {0xf771000a,0xa08c000b,0x68e90002,0x644314fc}},	//   عات_, יְהִ, _wted, _rani
  { {0xe1ff0065,0x394d14fd,0x05650594,0x4f9c0009}},	//   _þó_, _tres_, звин, יבוצ
  { {0x79820656,0xfd110003,0xceb4000b,0x644314fe}},	//   czow, رجة_, ויק_, _pani
  { {0xe8200037,0x3b850001,0x44e0001a,0x03d50009}},	//   _बाधा_, злог, _dò_, ּוֹם_
  { {0x2292007a,0xcf780012,0x11d60024,0x3b09004c}},	//   eška_, _وإما_, зігр, љемо_
  { {0x67ba000b,0x644300b6,0x5fba0009,0x7d0414ff}},	//   _המעק, _wani, _הצענ, ysis
  { {0x2bb80037,0xcdf6000b,0xa7fc003a,0x4dda0009}},	//   _अर्थ, _זמני_, _alıy, _החנו
  { {0xb87b0029,0x7ae9024e,0xdd940012,0xb7da0012}},	//   dpís, _četn, _تجمع, صورا_
  { {0x6e2f0017,0x9bfa0009,0x7bfa0009,0xeb9603b0}},	//   _bbcb, _ההצט, _הפצצ, _ниш_
  { {0x3e6e0065,0xc7b2000b,0xb9060014,0xe9a6002d}},	//   _nýtt_, גבל_, _език, _найп
  { {0xceb2000b,0x3ae10028,0x621b0009,0x721b0009}},	// [2d60] תין_, _hóp_, _הופק, _הופח
  { {0x14d60009,0xf507003c,0xb5640009,0x7d041500}},	//   פועל_, янул_, וֹעַ_, rsis
  { {0xe7db000b,0xb7db0009,0x3fdb0009,0x6fdb0009}},	//   _לקיש, _לקיי, _לקיב, _לקיס
  { {0x8289002d,0xf8bf000e,0xfaa300b3,0xf09f01a0}},	//   осіб_, ntén_, нахо, bràs_
  { {0x25d7000b,0x2246000e,0xda650012,0x3ead0227}},	//   _מוכן_, rdok_, بالي, doet_
  { {0x91bb000b,0x38b60028,0xf7720003,0x55bb000b}},	//   זמני, færi_, فاع_, _למכו
  { {0xa3ab0044,0x9f580054,0x79820002,0x90290012}},	//   _कुल_, narà_, szow, تأنف_
  { {0x3ead0058,0x8b9b000b,0x139b0009,0xe39b0009}},	//   goet_, _הבלת, _הבלע, _השלכ
  { {0xa3c90037,0xfaa30a32,0x66001501,0x89eb00af}},	//   लेस_, _чато, ramk, _הַבֵ
  { {0x95880002,0x66000052,0x1ab70037,0xb1170003}},	//   ciąż, samk, ृष्ठ, _رقما_
  { {0x59a50037,0x4adc0037,0xe215003c,0x443a0227}},	//   _गुजर, यदिव, ммны, iep_
  { {0x9f580054,0x11d90003,0xa75b0009,0x2919139a}},	//   darà_, توحة_, _לדבר, tusa_
  { {0x3d130044,0xc05b002d,0x1ea90012,0x443a016d}},	//   _दिये_, бів_, _بالي_, kep_
  { {0xdd3b000b,0xc19b0009,0x4ee70024,0xa3cd0011}},	//   _לעדכ, משכי, зіаз, शेड_
  { {0x3ae1001a,0x57a40001,0xb5fd048b,0x9f580054}},	//   _góp_, ешта, ljša, garà_
  { {0x2919000e,0xfbb7000b,0x2906004a,0x539b0009}},	//   pusa_, _מפות_, ksoa_, _ליוו
  { {0xb5fd009b,0x2d580109,0xe5340024,0x98cc0011}},	// [2d70] njša, пить_, неть, ाषाए
  { {0xebc70001,0x9f5801a0,0x7c970012,0x19b80012}},	//   пљен, barà_, أشرا, _عطية_
  { {0x9f580054,0x04c80012,0x69c01502,0x99820073}},	//   carà_, أولي_, _azme, bekų_
  { {0x63b50042,0x629d00b0,0x2003008e,0x8b3b00af}},	//   _vyzn, nnso, laji_, מתבצ
  { {0x63b50002,0x443a003a,0x26de1503,0xc1040012}},	//   _wyzn, bep_, _auto_, فوني
  { {0x9f580b45,0x89a80024,0x8d5a0009,0x2d840064}},	//   lará_, чків_, _וכשי, dzme_
  { {0x61e6006f,0x22950048,0x6d4d0d78,0x9f4a0031}},	//   yckl, _живя, lvaa, obbá_
  { {0x95880002,0x9f580d85,0xece91504,0xa3c20011}},	//   siąż, nará_, одил_, ्धन_
  { {0x644700b6,0x200300b6,0xf2d20009,0x3ead13af}},	//   _kaji, kaji_, _יעל_, roet_
  { {0xeb990001,0xc1040012,0xcc890024,0x1309003c}},	//   жио_, _أولي, ібне_, оной_
  { {0x2909004a,0x3e7c0028,0x9f580054,0xe8170037}},	//   _avaa_, _líta_, xarà_, _ताजा_
  { {0x6447004a,0x9f581505,0x6d4d005e,0x6ee70060}},	//   _laji, varà_, kvaa, _tıbb
  { {0xda1f0044,0x764600c6,0x5d690294,0xe8f7027f}},	//   _भारत_, _raky, _филм_, мля_
  { {0x9f580054,0xe5880009,0x76460073,0x61e90031}},	//   tarà_, _מָצָ, _saky, _lfel
  { {0xa0880009,0xe7270012,0x8b940048,0xd00f0012}},	//   פְשִ, خص_, _пръч, ؤلف_
  { {0x9f581506,0xfbd20009,0x8afa0009,0x76490060}},	//   rarà_, _בתו_, _והקי, ndey
  { {0xdb0e0066,0xb2290003,0x9f580054,0xc6920009}},	// [2d80] _vybí, _رأيك_, sarà_, דאן_
  { {0xe73a0046,0x28e10037,0x61e900c1,0x3ea00082}},	//   _део_, _पढ़ि, _afel, čiti_
  { {0xab270867,0x0ae90012,0x6d4d008e,0xb87b0097}},	//   доха_, كرني_, avaa, ppír
  { {0x99dd022d,0x7d1b019a,0x9f58052e,0x2906008e}},	//   _daňo, kuus, cará_, tsoa_
  { {0xa2b50037,0xa967035c,0xd1300012,0xda650012}},	//   ेषज्, мица_, امت_, عامي
  { {0x66041507,0xd6ea0103,0x3ead0c82,0xd7ef0012}},	//   laik, офил_, čete_, لكه_
  { {0xdfd0000a,0x57fb000b,0x29060017,0x8a060001}},	//   ديث_, קלקו, ssoa_, _озве
  { {0x64470013,0x941e0037,0xc9560015,0x66041508}},	//   _zaji, _पाँच_, _отзы, naik
  { {0xceb30009,0xf1a80011,0x69c0013c,0x66d50073}},	//   כיה_, _छँटन, _uzme, _iškl
  { {0x3e780013,0x26de0145,0xb4b80037,0xf55b000b}},	//   _této_, _tuto_, चते_, קדימ
  { {0x6e47006f,0x6d5d1509,0xd62a150a,0x24170009}},	//   örbä, äsar, _може_, וחין_
  { {0x6f1c008b,0xed5a0063,0x6604150b,0x6282150c}},	//   durc, _мое_, jaik, nhoo
  { {0x984b0014,0x7529000d,0x1ea90012,0x941e0011}},	//   оява_, ctez, _عامي_, _पांच_
  { {0x656f0052,0x55bb0009,0x27170081,0x7bdc016d}},	//   äche, _ומדו, ũng_, _ngru
  { {0xf413000b,0xd0d40014,0xe2ab0003,0x9f58052e}},	//   _ספק_, торъ, _وابن_, tará_
  { {0x4ea40014,0x9f5c0029,0x6d4d0070,0x644700b6}},	//   вруа, javí_, tvaa, _saji
  { {0x9f580d85,0x81fc0009,0xdd94003c,0x9e080012}},	// [2d90] rará_, _והחז, ваты, بيقك_
  { {0x31560093,0x3e710065,0x9f5801c5,0x76490060}},	//   _ניתן_, _hátt_, sará_, zdey
  { {0xf8bf0017,0x6604055c,0xdee70012,0x82150012}},	//   ntém_, baik, _تأخي, فواص
  { {0x644700b6,0x44e4006f,0xfd5e001a,0x8f1a0009}},	//   _waji, _fö_, _quyể, _צורת
  { {0xc6160093,0xeab00003,0x22490070,0x3e710028}},	//   _אחרי_, جعل_, _maak_, _mátt_
  { {0x7d1b004a,0x91780009,0xc0c8004c,0x34fa00af}},	//   vuus, ועדף_, мује_, _מהשד
  { {0xfd5e001a,0x20010051,0x38b60192,0xcb690012}},	//   _tuyể, _mehi_, mært_, _عمره_
  { {0x752900c1,0x7d1b004a,0x060903e2,0x38b60262}},	//   ttez, tuus, чник_, lært_
  { {0xf5480020,0x8c95002d,0x78f80012,0x41770012}},	//   _cụ_, ерні, _يعكس_, _غارس
  { {0xf5480020,0x2db8000b,0x00d80003,0x7529150d}},	//   _dụ_, ולחן_, _قبلت_, rtez
  { {0xa3c90044,0x7d1b004a,0xe667010c,0xe8d60009}},	//   लें_, suus, _отдо, _נוער_
  { {0x26d9012e,0xbbdc0037,0x6e450012,0x9f580097}},	//   _niso_, _बल्क, _سنتم, _þrá_
  { {0x6119000b,0xceb20009,0xfe790030,0x6604150e}},	//   הוָה, _גיא_, mků_, vaik
  { {0x2d940002,0xfe790030,0x38a90064,0x2a6d0b5e}},	//   ódeł_, lků_, túry_, _loeb_
  { {0x2baf0044,0x6604069c,0x9be4002d,0x7e56013b}},	//   _जुला, taik, _річк, нтац
  { {0x9f5c014d,0x683300a2,0x9f9b005e,0xfe790030}},	//   _því_, lıdı, määr_, nků_
  { {0x7d09150f,0x38b60028,0x5a9b0009,0xd10a0012}},	// [2da0] nses, fært_, _משקא, _عقده_
  { {0xe72a0014,0x69c4001e,0x7d09015e,0x6833003a}},	//   _еоод_, _izie, ises, nıdı
  { {0x6bd70003,0xbfa3001a,0x7aeb004b,0x66041510}},	//   فوكس_, uyế, _întă, paik
  { {0x7d0903fc,0x23660027,0xdceb003a,0xb906003c}},	//   kses, ćoj_, _çiğn, ездк
  { {0xfe790013,0x9f5c00d9,0x62820be9,0x75d60012}},	//   dků_, raví_, rhoo, _سيسا
  { {0x6d46102b,0x9fe60012,0x3b0a0426,0x3ea01511}},	//   _iska, رسته, _него_, lnit_
  { {0x501b000b,0x645c02f1,0x64a31003,0xbcb70009}},	//   לוסו, _inri, _сара, _נפלו_
  { {0x1d340014,0x3ea01512,0x02d60012,0x9f5e0025}},	//   вния, nnit_, _ستأخ, _jeté_
  { {0x62800006,0xfe37000b,0xb21b0058,0xd6220024}},	//   _ilmo, גרפי_, fhæn, _фiна
  { {0xf5480020,0x3e710097,0xa9230073,0xa3d40048}},	//   _vụ_, _sátt_, ėžta, копч
  { {0x69c400c1,0x7c3e0f62,0xfe790030,0x9c0b00af}},	//   _azie, iepr, bků_, הִכִ
  { {0xd62a0015,0xc333000b,0xf548001a,0xa2950024}},	//   _ходе_, נור_, _tụ_, тамі
  { {0xc05b002d,0x63860061,0x22490070,0xf8bf00f1}},	//   пів_, _béné, _vaak_, stém_
  { {0x69c4003e,0xf7730012,0x3ea01513,0xba3b0025}},	//   _dzie, هاز_, čitu_, roïq
  { {0x60da0005,0x270c0066,0xf8bf000e,0x9f34002d}},	//   _mitm, něn_, lték_, лері
  { {0x62670003,0x644a1514,0x3bbb000b,0x03bb0009}},	//   _سابق, _hafi, _ממוד, _מצול
  { {0x443e0070,0x5ff50014,0x644a1515,0x26d91516}},	// [2db0] oet_, _изпу, _kafi, _viso_
  { {0x44210036,0x63860108,0xad9d0002,0xfe790066}},	//   ugh_, _géné, kaźn, zků_
  { {0x443e00bd,0x57670003,0xa3c20037,0xe4a40560}},	//   iet_, _أدخِ, ्धि_, урто
  { {0xa3cd0044,0xd9990003,0x25b90003,0x7afc000e}},	//   शेष_, ونات_, _يهدد_, árty
  { {0xfe790066,0xd9450146,0x443e1517,0x7c3e0010}},	//   vků_, тели, ket_, bepr
  { {0x22490027,0x1d16000b,0x443e1518,0xa3c20011}},	//   žak_, _בקשר_, jet_, ्धा_
  { {0xfe790066,0x8aa70024,0x6bd70012,0xb4bd0011}},	//   tků_, _зрад, _ستسر, आती_
  { {0x7d090005,0x443e1519,0x57de0011,0x752d151a}},	//   tses, eet_, _मल्ह, otaz
  { {0x752d01a2,0x290b0002,0xe5710003,0x443e151b}},	//   ntaz, jsca_, شطة_, fet_
  { {0x60da003a,0x3ea00066,0x5d480009,0xfe790030}},	//   _gitm, znit_, תָהּ_, sků_
  { {0x8c3c00a2,0x6ee70003,0x6833003a,0xb35f0024}},	//   toğr, _أسئل, rıdı, имiщ
  { {0x7c3e151c,0x6833003a,0x8bd60009,0xaf340012}},	//   zepr, sıdı, כותו_, _حركت
  { {0x63860061,0x3ea00066,0x443e151d,0xb1430a32}},	//   _péné, vnit_, bet_, анял
  { {0xd7f20003,0x6143004c,0x62880073,0xd943004c}},	//   شكر_, јера, _įdom, јери
  { {0xc0030001,0x66e605f7,0x2919151e,0x63860025}},	//   рпск, тоба, arsa_, _véné
  { {0x2007151f,0xd3360009,0x6d4603d3,0xb9960012}},	//   hani_, _ירצה_, _pska, _للعب
  { {0x7ae31520,0x7c3e1521,0x1d070662,0xe4e50024}},	// [2dc0] _hunt, tepr, кети_, гієн
  { {0x9177000b,0x3ea01522,0x3e7c0029,0x764b002c}},	//   _סעיף_, snit_, _títo_, _lagy
  { {0x6d46003e,0x290d007d,0x68e400bd,0x73360003}},	//   _wska, _avea_, _huid, ضرائ
  { {0x68e40005,0x443e1523,0x35fa0012,0xa1f70012}},	//   _kuid, zet_, _تردد_, نّما_
  { {0x443e1524,0x99340012,0x7e6913c3,0x7ae31525}},	//   yet_, افتت, djep, _lunt
  { {0x443e1526,0x68e40038,0x3cfb0011,0xd00f0012}},	//   _út_, _muid, _लौटे_, قله_
  { {0x68e40227,0x443e1527,0x81fa0012,0x6602005e}},	//   _luid, vet_, _يفسر_, _peok
  { {0xf8bf000e,0xad9d0002,0x6d440002,0x443e1528}},	//   tték_, raźn, owia, wet_
  { {0x48e6007c,0xc6930093,0xc0e6002d,0x7ae90027}},	//   _розв, יאה_, _розк, _četi
  { {0xa0c90003,0x54530015,0xf8bf000e,0x60da0070}},	//   _كذلك_, авьт, rték_, _uitm
  { {0x66020006,0x8c1b000b,0x57fb0009,0x443e1529}},	//   _teok, וויי, _חלבו, ret_
  { {0x92580015,0x443e152a,0x68e40685,0xbb93003c}},	//   вают_, set_, _buid, рающ
  { {0xc0970012,0x3e750248,0x644a0097,0x443e152b}},	//   نجست, _mått_, _tafi, pet_
  { {0x8438000a,0xa8a40146,0x68e40070,0xcb540012}},	//   _أكثر_, арск, _duid, _منتظ
  { {0x66c5000e,0x138a0012,0xa7d40012,0x7ae300b1}},	//   lóka, _تخشى_, لتفص, _gunt
  { {0x0bb70093,0x645d0039,0xa3d60037,0x2ebf0037}},	//   _שלהם_, ēsie, ाइन_, ्षेत
  { {0x5187002d,0x764d00b6,0x2007010a,0xd7fb0198}},	// [2dd0] _шука, rday, yani_, _оун_
  { {0x1acb0037,0x4427003a,0x752d152c,0xfdc30011}},	//   िष्ठ, ün_, rtaz, _शरीफ
  { {0x752d01a2,0x68e40070,0xf4130009,0xa3cd0011}},	//   staz, _zuid, שפע_, शें_
  { {0xc333000b,0xdcf70003,0x20070bca,0xcf560009}},	//   יוע_, _لأسب, wani_, _עברת_
  { {0x95640014,0x2007152d,0xae1a0009,0x361a0009}},	//   _кърд, tani_, _אורכ, _אורד
  { {0x66d50010,0x34950001,0xb97c0009,0xbae50012}},	//   _iški, _сагр, ונדי, _مكسي
  { {0x2007152e,0x9f51000e,0xe7080003,0x3e75152f}},	//   rani_, mazó_, نتين_, _fått_
  { {0x39490051,0xc1050003,0xdb25000e,0x78b5000e}},	//   _osas_, _موري, épít, hozv
  { {0xdd1200a2,0x7ae3007d,0x7e690cb1,0x95550012}},	//   _müşt, _sunt, rjep, اخبا
  { {0x62990002,0x9b150009,0x1abe0011,0x7ae31530}},	//   liwo, ְחָה_, ोष्ठ, _punt
  { {0x6d440034,0x6d460097,0xc7590035,0x8b640012}},	//   zwia, ækar, šībā, لاَم
  { {0x95550003,0xc049000b,0x8f88000b,0xcb360009}},	//   _مختا, _מז_, _בְנֵ, נארי_
  { {0x20050b86,0x72b60009,0x44270081,0x9f580025}},	//   _keli_, רִיב_, _tcn_, mbré_
  { {0xad1a000b,0x3ebf1531,0xd3780002,0xc4840024}},	//   _נוצר, llut_, być_, _клік
  { {0xe29a09f0,0xa3c90037,0x39491532,0x8cb90011}},	//   _пак_, लेख_, _esas_, ्तनो
  { {0x539a0009,0xdd920012,0x6d440034,0x26dd016d}},	//   _ריקו, موز_, twia, _jiwo_
  { {0x7d0d0101,0xee5c0028,0x6c1a0012,0x98c30011}},	// [2de0] gsas, æðið_, فتاح_, षताए
  { {0x76400002,0x20050051,0x6d440034,0x5046004c}},	//   zemy, _neli_, rwia, _сеоб
  { {0x61e9009b,0x9bc90009,0x6e2e0031,0xaae50012}},	//   žele, תֶּ֖, őbbi, لسنو
  { {0xa3ab0044,0x644107f6,0x479b0009,0xd67a0012}},	//   _कुछ_, heli, _טייס, _أحدا_
  { {0x44e90065,0xd378003e,0xf2d30009,0xa9960012}},	//   _nú_, zyć_, צעד_, دشات
  { {0x7ae90027,0xc3060003,0x200a002c,0x64411533}},	//   _četv, _مبرو, nabi_, jeli
  { {0xeef6000b,0x31790002,0xd6da1534,0x7d1b1535}},	//   אמֶר_, zysz_, нти_, erus
  { {0x66c5000e,0x9b930012,0x224200b0,0xb5fb0420}},	//   tóka, _طلقت, jekk_, _inác
  { {0x49ca0046,0xd24f0003,0xe29b000b,0x44e9001a}},	//   _члан_, _عنك_, _נשמר, _cú_
  { {0x27f70145,0xb8ea0037,0x64411536,0x66061537}},	//   čení_, ोष_, geli, _lekk
  { {0x644e0101,0xa4b7000b,0xa857000b,0x26c00010}},	//   _mabi, רליה_, _תיבה_, klio_
  { {0x66c5000e,0xf127002d,0x35fa0003,0x7d0d004a}},	//   lókn, льго, _أراد_, ysas
  { {0xa3d60037,0x443800d9,0x85760012,0xd3780034}},	//   ाइड_, _obr_, _حدائ, syć_
  { {0xac181128,0x64411538,0xf1b30009,0x230a0012}},	//   _року_, celi, מסר_, _كتبي_
  { {0xdfd50015,0xbca30012,0x66190034,0x78b50482}},	//   ровы, _دموي, ówko, rozv
  { {0x26c001a2,0x7d0d00ff,0x758b0024,0x20050034}},	//   glio_, tsas, нсзв_, źli_
  { {0xe2140003,0x65150003,0x66061124,0x320b0132}},	// [2df0] _طبيع, شوائ, _dekk, macy_
  { {0x45b80015,0x7d0d1539,0x2dd80012,0x320b0034}},	//   угую_, rsas, طبقة_, lacy_
  { {0x7d0d0006,0x6284004a,0x66d50010,0x8c1b0009}},	//   ssas, _ylio, _iškv, תובי
  { {0xd357000b,0x41550109,0x01d90012,0x32b80012}},	//   טיבי_, ивес, نواع_, هدنة_
  { {0x6441003a,0xa1580024,0x98a20034,0x9f5e0064}},	//   yeli, лацу_, stką_, _detí_
  { {0x7e6d0051,0xfc670014,0xdc1e0037,0x8f150e8a}},	//   ljap, _съмн, पलोड_, афич
  { {0x44e9153a,0xb5fd009b,0xfe710003,0x18780009}},	//   _sú_, ljši, قدة_, רעור_
  { {0x64410070,0x7be3003a,0xfe710012,0xcee80012}},	//   weli, ştuğ, تدت_, درون_
  { {0x26c30039,0x78270003,0xc4850001,0xc68e0003}},	//   ējo_, _معال, илик, بِي_
  { {0x9984000a,0x98db0003,0x3ebf153b,0xec76003c}},	//   _الكو, _أبرز_, slut_, ипы_
  { {0xc169000b,0x200a009b,0x626602ad,0xebd70009}},	//   _קח_, vabi_, авна, נֵ֖י_
  { {0xc5d5007c,0xeb960015,0xa5f90001,0x93b60009}},	//   _кіль, рию_, _реду_, ילתו_
  { {0x2731008a,0x66060033,0x200a002c,0xa3c90037}},	//   _hơn_, _rekk, tabi_, लेज_
  { {0x66060269,0x960e0011,0x6d59016d,0x224212e8}},	//   _sekk, िण्ट_, _irwa, sekk_
  { {0x672300c6,0xd0070a15,0x200a0d6c,0xb4c30037}},	//   nunj, ресе_, rabi_, ्षी_
  { {0x66c501c4,0x200a14d5,0x320b0132,0x6d590034}},	//   ióko, sabi_, cacy_, _krwa
  { {0xb2bb000b,0xa2bb0009,0x6cd60012,0x98a60024}},	// [2e00] _במקר, _במקט, لقرا, _випе
  { {0x4463007c,0xf8bf0061,0x26c0001b,0x6723016d}},	//   овув, tuée_, slio_, kunj
  { {0x66060005,0x644e012e,0x57fb000b,0x0b46077e}},	//   _tekk, _vabi, _שלטו, рнен
  { {0xb4c10037,0xc217002d,0xba170012,0xd2590024}},	//   ंतु_, аєш_, ليما_, лці_
  { {0xa06a0001,0x656f0052,0x66c5000e,0x11540055}},	//   када_, ächl, tókn, склю
  { {0x57f30001,0xf7720012,0x3e780097,0x2baf0011}},	//   општ, قاع_, _létt_, _जँचा
  { {0x61e40163,0xa7b80047,0xf8bf0061,0x2731001a}},	//   _ogil, ылку_, quée_, _cơn_
  { {0x66c50028,0x2baf0011,0x9df70048,0xfaa600f4}},	//   sókn, _जुटा, анът_, _табо
  { {0xf5360009,0x42530012,0xd5b00012,0x54b80048}},	//   ׁנֵי_, _بنقر, ثفة_, лгия_
  { {0x14180003,0x6723001b,0x44380097,0x84330024}},	//   ديدة_, bunj, ýr_, оньє
  { {0xe47b000b,0x6d590347,0x94730012,0x88bb0009}},	//   דריכ, _erwa, تديا, _יזמי
  { {0x4444153c,0x1eda0012,0x9f610025,0xbf9b0009}},	//   he_, _شباب_, _épée_, _ביבש
  { {0x8cf40003,0x320b0ee7,0x2e370009,0xb8b70012}},	//   _اكتش, racy_, _כראש_, لإست
  { {0x653b0009,0xdfa7004c,0x4035004c,0x04430198}},	//   _סעוד, ајбо, љевс, _мечн
  { {0xddc40039,0xcebb0001,0xddc60002,0x7e620ad2}},	//   ndiņ, вља_, _nakł, _knop
  { {0x33db000b,0x9f5e00c1,0x7bdb0009,0x6e640024}},	//   _בחוד, _metà_, _בקוו, отуж
  { {0x4444153d,0x66c50031,0x629d153e,0x7e6d0e7b}},	// [2e10] fe_, zóko, miso, rjap
  { {0xfd4d008a,0xc1bc000b,0x3ea90d6c,0x91bc000b}},	//   _khoả, _במחש, čati_, _במחי
  { {0xf3670046,0x7e620227,0xf09200af,0x9b4400ae}},	//   штан, _onop, _זני_, ينكو
  { {0x4b370093,0x6a940024,0x6d4b0097,0xa3ab0011}},	//   שראל_, оріє, ægas, कॅट_
  { {0x660d00bd,0x2731001a,0x27ec0029,0xaa560012}},	//   maak, _sơn_, ždne_, صلوا_
  { {0x6c85000a,0x672302b7,0xd0f80009,0x4dda0009}},	//   _السم, tunj, סמות_, _תחשו
  { {0x3e7c0066,0xf8bf0156,0xd7ee0012,0x46150012}},	//   _síti_, ltés_, ركي_, موغر
  { {0xc332000b,0x7ae00010,0x2bba0037,0xc668004c}},	//   _מול_, _gimt, _उड़ा, ишње_
  { {0x3e780065,0xddc6003e,0xf8bf153f,0xddc40030}},	//   _rétt_, _zakł, ntés_, ojiš
  { {0xd874000a,0x70740003,0x67230027,0xf8bf0061}},	//   _والب, _والذ, punj, ités_
  { {0x5f790003,0xbb4500b3,0x09e60511,0xe3b10012}},	//   _حماس_, щенк, йонн, ثرة_
  { {0x6d590002,0x44441540,0xa5c20097,0x216a0842}},	//   _trwa, ze_, þókn, гими_
  { {0x44441541,0x6d4b0052,0x68e10623,0x64450845}},	//   ye_, _usga, _kild, kehi
  { {0xfd56000b,0x6e2904a3,0xa4d40024,0xd4660048}},	//   _לשני_, lgeb, _дочі, _гише_
  { {0xcaf50003,0x177906e6,0x9a6a0003,0xf1bf000e}},	//   _استب, асть_, _ممثل_, lgál_
  { {0x681b0039,0x07a3007c,0x44441542,0x673c004a}},	//   lādē, часн, we_, _ärje
  { {0x7ae00010,0x7afb004b,0x22920030,0xe1ff0034}},	// [2e20] _rimt, _ăuta, ušku_, ejów_
  { {0xcb6a0001,0x2292001b,0xad250012,0xa3ea0148}},	//   лазе_, ršku_, ترفو, уджа_
  { {0x18770093,0x60db000b,0xb5fd009b,0xfcb50024}},	//   _העיר_, _תקינ, ljšu, іщую
  { {0x366a1543,0x41d90011,0xf8bf0031,0xacea0012}},	//   _само_, _बृहस, stét_, _مرسل_
  { {0x3913002d,0xdd8f0024,0xf8bf0025,0x1e570009}},	//   змір, _ншi_, ctés_, _השכר_
  { {0xbcfb0065,0x69c001e9,0xe1650012,0x629d1544}},	//   _bréf, _vyme, تدمي, ziso
  { {0xd6d0000a,0x4386000a,0xbb860003,0xb21b0058}},	//   وقت_, _الأق, _الأي, mhæv
  { {0xdd0804b4,0x994c0026,0x5678010c,0x8cf40b05}},	//   _môže, môže_, рбия_, озиц
  { {0xf653000b,0xa3d60011,0xb9960012,0xd5ba003c}},	//   לצה_, ाइव_, _الذب, ыск_
  { {0x68e10065,0x0577000b,0x5b1405f7,0xf8bf0031}},	//   _gild, צגים_, омот, mrég_
  { {0x66c5000e,0xcff70009,0x62821545,0x2d821546}},	//   iókj, _הצבה_, okoo, ške_
  { {0x5eeb000b,0x628213f2,0xc879004b,0xe1d90024}},	//   _עַבְ, nkoo, _ruşi_, идні_
  { {0x1e570009,0xc50a0012,0x25ab0064,0x6e2e0031}},	//   _לשאר_, _إتصل_, čilú_, őbbs
  { {0xd9180047,0xfd4d001a,0x7dc50003,0xcff40048}},	//   щью_, _thoả, _بتمك, зпръ
  { {0x5c37000b,0xe7f00037,0x66d50010,0xe437000b}},	//   _הטוב_, _चलना_, _iškr, _הרוח_
  { {0xf96b0098,0xe6940015,0x6e940339,0xfaa4004c}},	//   _брой_, писы, пису, _најо
  { {0xe29f0065,0xcc990001,0xf8bf0061,0x62820647}},	// [2e30] mið_, авац_, utés_, dkoo
  { {0xe29f0065,0xf8070001,0xdd7b0009,0x6bd70012}},	//   lið_, _учин, אטמל, متضر
  { {0xa036000b,0xda7b002d,0xe80c0037,0x644514d5}},	//   _ואתה_, ляд_, _सज़ा_, rehi
  { {0x68e906f4,0x66f10039,0xaac90037,0xe29f0028}},	//   _pued, _nāka, रतिक, nið_
  { {0x68e11547,0x8e560009,0xd2d40012,0xa9250024}},	//   _pild, _וירג_, أغلب, ідкл
  { {0xbcfb0108,0x7bc6003e,0x0138000b,0x11d40012}},	//   _préf, ękuj, צרות_, ستند
  { {0xe29f0065,0xf7710003,0x3ea91548,0x20c90028}},	//   kið_, ظات_, onat_, búin_
  { {0x3ea91512,0xb4c30011,0x62340400,0xdee20048}},	//   nnat_, ्ष्_, _несу, мощи
  { {0x6e290732,0x4d65002d,0x394d002a,0x7aea0052}},	//   rgeb, іков, _uses_, _auft
  { {0x9f63000e,0xf5360009,0xa4d6004c,0x9f880097}},	//   ívót_, קנתי_, одњу_, kóða_
  { {0xe29f0065,0x3b090001,0x37ab0447,0x39400404}},	//   fið_, јемо_, _стан_, _spis_
  { {0xe29f0065,0xc8690093,0x6d5d006f,0x66c5000e}},	//   gið_, _בן_, _orsa, iókk
  { {0x6dc70003,0x3ea91549,0xbbc60011,0x74290012}},	//   _ازال, dnat_, _वर्क, _نكشف_
  { {0xcfaa0003,0x3940154a,0x74f60012,0x7bc70097}},	//   لازم_, _vpis_, _بفوز_, ýjus
  { {0xf8bf000e,0x39400002,0xe4d20012,0xc7b20012}},	//   ttér_, _wpis_, _تقود, ذّر_
  { {0x3ea90054,0x9586003c,0x6aad0097,0xd1320012}},	//   gnat_, олбе, _gjaf, _قمع_
  { {0x660b000f,0x3ce30070,0x61f6006f,0xe6c50012}},	// [2e40] _megk, _bijv_, _ifyl, ستفي
  { {0xa3d60044,0x85210037,0xa7fc003a,0x660b000e}},	//   ाइल_, _मिनट_, _anın, _legk
  { {0x7ae403d5,0x9b460012,0x6d5d08ec,0xc1ea0048}},	//   _kiit, تناو, _ersa, адеж_
  { {0xe2460003,0x84e30011,0x26c401e3,0x6289154b}},	//   تخطي, कआउट_, _ómo_, _cleo
  { {0x200e0028,0x3ea00574,0x95e60011,0x6282154c}},	//   tafi_, miit_, कशीट_, rkoo
  { {0x3ea005cf,0x7ae402bd,0x67210133,0x66f1001e}},	//   liit_, _liit, šlje, _sāka
  { {0x8cb90011,0x865a0009,0xa3de0011,0x4e8a0024}},	//   ्तरो, ֹדִי, _दृढ_, ищим_
  { {0x7ae40006,0x877b000b,0xa9f40037,0x8e20002d}},	//   _niit, יאצי, ंडोज़_, _вiн_
  { {0x95d70048,0x0dca0024,0x66190034,0x66c50031}},	//   одът_, шуки_, ówki, iókh
  { {0x7d1d000e,0x3ead013a,0x3ea9154d,0x60860012}},	//   ássa, četi_, znat_, _بشرك
  { {0xe29f0065,0x5c5b0009,0xadfc0011,0xa3cf0011}},	//   tið_, בדיק, ौरान_, _शरण_
  { {0xe8d90020,0xfce6154e,0x200c016d,0x314a00af}},	//   _trị_, _додо, _hedi_, ֑תָּ
  { {0xe29f014d,0x3ea00051,0x3ea90dd1,0xc2130009}},	//   rið_, diit_, vnat_, והר_
  { {0xe29f0028,0xdfc60003,0xf8ca0037,0xc4c60012}},	//   sið_, في_, ितिय, _بتصو
  { {0xc058007c,0x3f850042,0xa6f80009,0xd6f80009}},	//   ція_, álu_, מִּי, מִּש
  { {0xe2980001,0x442c0070,0xce68002d,0x6448154f}},	//   _мај_, lgd_, оруд_, ledi
  { {0x442c0070,0xe534027f,0x6fbb0011,0xd7e70024}},	// [2e50] ogd_, меть, _शुरू, _міно
  { {0xebc70001,0x26cc0054,0x442c1550,0x645a0097}},	//   ољен, ïdor_, ngd_, _ótil
  { {0xaa4b0024,0xf8bf0025,0x442c0227,0x8c3c0060}},	//   иїде_, grée_, igd_, ciğe
  { {0x2011001c,0x7ae40017,0x77ba0009,0x67ba0009}},	//   lazi_, _xiit, _למתח, _למתק
  { {0xca740003,0x6d5d1551,0x4a5c0009,0xd5a60012}},	//   بالغ, _ursa, ידאו, _أف_
  { {0xbcfb0108,0x6448001c,0x4dda0009,0x8dda0009}},	//   _crée, jedi, _לחרו, _לקרק
  { {0x6d4d0070,0x644812d3,0x200c045b,0xf8bf0025}},	//   lwaa, dedi, _dedi_, crée_
  { {0x64551552,0x7a160034,0x915e0081,0xe29f0097}},	//   _hazi, rętó, hắc_, _öð_
  { {0x20110470,0x7ae4004a,0x6e2d0052,0xa0c50003}},	//   kazi_, _riit, igab, _فيرو
  { {0x7ae40006,0xe3b10012,0xa3cf0011,0x442c0248}},	//   _siit, فرج_, _शरद_, ggd_
  { {0xe7f00037,0x64551553,0x9cd80009,0x9ee90012}},	//   _चलता_, _mazi, חוזה_, _افصل_
  { {0x442c0070,0x539a000b,0x8d770012,0x68e5008e}},	//   agd_, מיתו, _واشا, _aihd
  { {0x6f15003e,0x68ed02d1,0x6464000d,0x20d60024}},	//   eszc, _cuad, _ştiţ, зівс
  { {0xb4fa000b,0xacfa000b,0x8d5a000b,0x64551554}},	//   _הפסי, _ההסכ, _לכני, _nazi
  { {0x6e2d0052,0x366a0014,0x2aa4000e,0x7ae4005e}},	//   fgab, баво_, rűbb_, _tiit
  { {0xfb1a000b,0xc3320009,0x531a0009,0xa206003c}},	//   _הוקמ, _נוח_, _הוקצ, _эпид
  { {0xb4d70037,0xceb20009,0x6d4d0227,0x1d260adc}},	// [2e60] ागू_, גין_, gwaa, ямам
  { {0x31370093,0xf8bf0061,0x66f1001e,0xa84a0003}},	//   _צריך_, trée_, _nāko, _الدم_
  { {0x307b0093,0xa87b0009,0x395f00b6,0x987b007e}},	//   _האינ, _האיר, _arus_, _האיט
  { {0x3d1c0037,0x01da0003,0x25ad0027,0x28c40011}},	//   _मिले_, موضع_, _žele_, _लीजि
  { {0xb9e3002d,0x6286008e,0x7bce0034,0x9f5801e3}},	//   ніши, ikko, _wzbu, paró_
  { {0x61e91555,0x6604005e,0xaf060198,0x91e301c6}},	//   _egel, lbik, пчик, хоче
  { {0x43430800,0xa7370003,0x200c00c1,0xddcb0002}},	//   _перв, كثير_, _vedi_, _nagł
  { {0xcb370009,0x2e4a0048,0x98ac0060,0x64551556}},	//   _מאלי_, сяко_, ılıp_, _zazi
  { {0x644800a2,0xc1060003,0x7d160e45,0xe6110009}},	//   tedi, _رواي, nsys, כִי_
  { {0x7ce90010,0x7c3a0052,0xdc980024,0x0d970009}},	//   _užre, uftr, івні_, פכים_
  { {0x442c0227,0x6d4d0227,0x57fb0009,0x64481557}},	//   rgd_, zwaa, _הלבו, redi
  { {0x64481558,0xa25b0025,0x02d90012,0x75d60012}},	//   sedi, plôm, توجب_, _فيضا
  { {0xc4be0044,0xd627002d,0xac180014,0x68ed1559}},	//   ्ताओ, _хоче_, _долу_, _quad
  { {0xf9930009,0x6286155a,0x26c20919,0xe8d90b24}},	//   גרש_, akko, _akko_, _trọ_
  { {0x6af30003,0x2fc50058,0xddc90027,0x643b000b}},	//   _كثير, ælg_, mješ, _העונ
  { {0x6455155b,0xddc90027,0x6ee7003a,0x6d4d0227}},	//   _sazi, lješ, _kıbr, twaa
  { {0xdddb0027,0x95cb0014,0xddcb0002,0xc86705fb}},	// [2e70] okuš, сува_, _zagł, _етни
  { {0x6d4d00bd,0x6e2d0052,0x89340012,0x787d0025}},	//   rwaa, sgab, _أعيا, _lèvr
  { {0x92590015,0x2900000d,0x6455155c,0x6d4d0c3b}},	//   жает_, ţial_, _vazi, swaa
  { {0xfbd0000a,0x6723012e,0x66f10039,0x7aee0054}},	//   اتك_, vrnj, _sāko, _dubt
  { {0xdb180006,0x752400c1,0x9e5a0009,0x865a0009}},	//   _hyvä, criz, _וכרט, _ודרי
  { {0xccf2000b,0xe7310012,0x1df70011,0xf9580009}},	//   _בכך_, نصب_, ीर्ष_, פסות_
  { {0xe7390021,0xdb18008e,0xd00e0012,0xe7fe05f3}},	//   цей_, _jyvä, جلى_, _उभरा_
  { {0x61e900eb,0x69ce0011,0x0565003c,0x7d1d0031}},	//   želj, _सरली, двин, ásso
  { {0xb3450149,0x9fe70003,0x06960003,0x067c0009}},	//   _opçã, _فساه, بنية_, מנהל
  { {0x628d0872,0xfce50024,0x3b85155d,0x212b155e}},	//   _alao, ьопо, длог, duch_
  { {0xf8bf0017,0x8c1a0009,0xa3d60011,0x96070012}},	//   guém_, חותי, ाइए_, _فبإم
  { {0xedd50003,0xd29a002d,0x78a3004a,0x11d6002d}},	//   _قياد, ітні_, linv, дігр
  { {0x62860006,0x3ead0163,0x6480005e,0x2240005e}},	//   rkko, mnet_, _köit, õiki_
  { {0x62860005,0x661d03ee,0x71880009,0xc0e30024}},	//   skko, _adsk, פְרַ, кояк
  { {0xae7a0015,0x93fa0009,0x9bfa0009,0x33920012}},	//   осах_, _ולצי, _והצט, _للوز
  { {0x3ebf0013,0x92b6000a,0x25f50037,0x6721000e}},	//   nout_, _تحتا, एँगी_, álja
  { {0xe5a3024d,0xcad70009,0x98a20035,0xc2370009}},	// [2e80] вити, _קופת_, aukā_, _חאפז_
  { {0x3ead0052,0x672100eb,0x70770012,0x3ebf155f}},	//   hnet_, šlja, _يميز_, hout_
  { {0xbcfb0108,0x93c3000d,0xa5bb000e,0x63030012}},	//   _préc, _ţări, _adód, َوْل
  { {0x8b65000a,0xd1ca0015,0xdddb009b,0x49ca0083}},	//   عالم, олее_, zkuš, олен_
  { {0x8f000024,0x7d030048,0x3ead1560,0x28ca05f3}},	//   цiю_, _изяж, dnet_, ितलि
  { {0x74e7002d,0x660f0032,0x89970009,0x787d1561}},	//   _одяг_, _zeck, וכנס_, _sèvr
  { {0xddc9001c,0x3ead0052,0x3ebf0070,0x93bc004b}},	//   vješ, fnet_, fout_, ngăt
  { {0xdb0e0002,0x8f1b0009,0x8b9b0009,0x3ead1562}},	//   _wybó, קופת, _ובלת, gnet_
  { {0xfaa30001,0x320601a6,0xbc4a0595,0x61e91563}},	//   _рато, mboy_, очне_, želk
  { {0xd1970009,0xe97b0009,0x27f70012,0xb21b0040}},	//   _חכמי_, _ונמש, _يفقد_, rkæm
  { {0xd2510003,0x3ebf1564,0x7d0b0031,0xda35003c}},	//   هند_, bout_, ágsz, нены
  { {0xbd460003,0x6d460058,0xcfa90003,0xdddb09d2}},	//   _يناي, _opka, _عالم_, skuš
  { {0xddc90027,0x656f0052,0x93bc000d,0x224b1565}},	//   pješ, ächt, egăt, reck_
  { {0x212b0052,0x68e81566,0x000000c4,0x000000c4}},	//   ruch_, _jidd,   ,
  { {0x212b0052,0x6d460708,0x889b0009,0xd4330012}},	//   such_, _apka, קבלי, _شعوب
  { {0x85050003,0x68e80f50,0xcf570009,0xe8d90081}},	//   فورن, _lidd, ובלת_, _trỏ_
  { {0x660f0163,0x61ed0051,0x7bca0052,0xb4d50063}},	// [2e90] _veck, _igal, üfun, ежащ
  { {0xbcfb0108,0xdb180163,0x443e0052,0x61fa0066}},	//   _créa, _tyvä, nft_, ětle
  { {0x660f0163,0x661d007a,0x443e1567,0x78a3008e}},	//   _teck, ųski, ift_, vinv
  { {0xe298007c,0x661d0058,0x29191568,0x80ad0011}},	//   має_, _udsk, ossa_, ँचवे
  { {0x29190006,0xe1670003,0x1e96000b,0x3ead038e}},	//   nssa_, بداي, _נכשל_, vnet_
  { {0x29191330,0xf536000b,0x443e0070,0x8f00002d}},	//   issa_, _אנשי_, jft_, цiя_
  { {0xf0940093,0xa295002d,0x5f770003,0xdbd60038}},	//   כנס_, _заві, باشر, _jääk
  { {0x443e0644,0xca24003c,0x61ed020d,0xddc405be}},	//   eft_, _аффи, _ngal, ndiş
  { {0xc0cb1128,0x443e0052,0x6e26000e,0xdbd6004a}},	//   _дуже_, fft_, ókba, _lääk
  { {0xe1fa0044,0xeb990001,0x65620052,0x61ed1569}},	//   ूर्ण_, зио_, _droh, _agal
  { {0x53c9002d,0x7ae90010,0xcb690345,0x2919156a}},	//   ягом_, _kiet, чане_, essa_
  { {0x7e7d001e,0x656f0052,0x2f5a0009,0x7afa0031}},	//   _nosp, ächs, _מדענ, _étte
  { {0x8d870012,0xe5690048,0x7ae9156b,0xdce70030}},	//   _تشان, _хилд_, _miet, áměs
  { {0x7ae9156c,0x6c350003,0x6458156d,0x61ed156e}},	//   _liet, _أفغا, _gavi, _egal
  { {0xb4cb0037,0x2ca50028,0x2bc60037,0xb2220028}},	//   लती_, mild_, _रुपा, _þægi
  { {0x139a000b,0x539a0009,0xc6a5004c,0x69c00060}},	//   _מבצע, _מיצו, врђи, ümes
  { {0xbcfb0061,0xdc390009,0x753b156f,0x79660012}},	// [2ea0] _préa, ּעֲר, ntuz, _أطعم
  { {0xe0d20003,0x6ab80037,0x7659002a,0x8f760024}},	//   _حزب_, इक्र, _lawy, _зумі
  { {0x7ae90052,0xcb09002d,0x10370009,0xda5a0009}},	//   _biet, дхід_, _אטים_, ּכְל
  { {0xc332000b,0xe9da00bb,0x7ae90035,0x22820097}},	//   רוא_, пке_, _ciet, _tóku_
  { {0xc1e70015,0x64430002,0xaa570003,0x443e0028}},	//   ньше_, _obni, علها_, yft_
  { {0x673c0159,0x7d041570,0x7e6b020d,0x03a60a36}},	//   otrj, mpis, _angp, _зиго
  { {0xce940014,0x7ce90010,0x64581571,0x56940048}},	//   какъ, _užra, _ravi, какт
  { {0xd6d70047,0x95080003,0xddcd0027,0x65621572}},	//   нты_, وقعك_, ljaš, _proh
  { {0x7ae30070,0xe5720003,0xa90a0012,0xb4cb0011}},	//   ïnte, اطع_, _ريال_, लतू_
  { {0xd91b0093,0x4f96057b,0x859b000b,0x64a30001}},	//   _מומל, _преу, פשיו, лања
  { {0xa3d60044,0x443e00a7,0xa295002d,0x3d100321}},	//   ाइट_, rft_, вані, _दौरे_
  { {0xda100044,0xdbd60051,0xaf490003,0x92100011}},	//   ारित_, _rääk, _تشكل_, ारिज_
  { {0x2919004a,0xd7f1001a,0xba9b000b,0x443e0052}},	//   ussa_, _mãn_, לסטי, pft_
  { {0x3a20003a,0x6721000e,0xb4fb000b,0x7e7d1573}},	//   _edip_, áljo, _צפוי, _sosp
  { {0x6e671574,0x2bf70009,0x4fe8003c,0x00e4003c}},	//   нтаж, _אמון_, емён_, ужён
  { {0x752d00c1,0x66c50031,0x44f60097,0xf8bf0031}},	//   tuaz, lókr, _bæ_, ntéz_
  { {0xac270469,0x7ae91575,0xdd94003c,0xdd910012}},	// [2eb0] ефек, _riet, гаты, جوء_
  { {0xd1400002,0x22b6001e,0x7ae90fb7,0xa6f5004c}},	//   żący_, māka_, _siet, _изош
  { {0x22b6001e,0x7ae91576,0x7d041577,0xf1bf0031}},	//   lāka_, _piet, apis, agát_
  { {0x44f60028,0x78a70227,0xe9f80024,0xc33300af}},	//   _fæ_, lijv, енці_, טוע_
  { {0xe8f8002d,0x273a0070,0x69da0002,0x7ae91578}},	//   елі_, eën_, ęteg, _viet
  { {0x07a5011f,0x27ab0009,0x7ae90034,0x6ce40024}},	//   калн, ּסֵּ, _wiet, _бісе
  { {0x7ae91579,0x648d0028,0x6b83006f,0xb8820066}},	//   _tiet, _búin, ängd, _říka
  { {0xdddd0039,0x0f58000b,0x22b6001e,0x61fb0262}},	//   _nosū, תיהם_, kāka_, _uful
  { {0x2d8b0042,0x765b00e8,0x6d3200ae,0xf5050b2b}},	//   áce_, rduy, لفيض, ъзпо
  { {0xb4cb0037,0x4c85002d,0x23750012,0x99d40012}},	//   लते_, тлов, ناجح, _إتفا
  { {0x907a000b,0xe4520009,0xb7670024,0xdc880009}},	//   _קטעי, בֶר_, _ятай, גְרָ
  { {0xfeb8000a,0x780a0037,0x0f180012,0x7afc0031}},	//   _كانت_, वर्क_, _أغلب_, írta
  { {0xe2970063,0x6aa60248,0x22b60035,0x6609157a}},	//   тая_, rikf, gāka_, mbek
  { {0xbcfb0061,0x934509ca,0x7d1b005e,0xdb080031}},	//   _prén, _анке, msus, őlép
  { {0x7d1b0051,0x12aa0003,0x3f8c00d9,0x8cca0011}},	//   lsus, _يدعى_, ádu_, _सीटो
  { {0x7d040027,0xcf92000b,0x601f0060,0xbcfb0025}},	//   tpis, בטל_, _açmı, _créo
  { {0xa8060014,0x1ea90003,0x7d1b0051,0x95830055}},	// [2ec0] _изпл, رافي_, nsus, алте
  { {0x0cbe0044,0x7d0400b6,0xe403002d,0xdbcc0028}},	//   ्तेम, rpis, изуп, _kóði
  { {0xe2a3001a,0x91f60011,0x2018157b,0xddc2001b}},	//   _trừ_, _इलाज_, mari_, _mnoš
  { {0xd36f000a,0x7d1b00b9,0xfa89002d,0xba290003}},	//   تهم_, ksus, нсій_, فسهم_
  { {0xdb0e006f,0x98a20073,0xf1bf0031,0x60c308aa}},	//   _nybö, auką_, lgár_, fonm
  { {0x66d50010,0xa3df0037,0x7d1b08ab,0xfc030695}},	//   _išky, देह_, dsus, _впро
  { {0xf093000b,0x22b6001e,0xd6da0001,0x20180054}},	//   שנו_, zāka_, мти_, iari_
  { {0x201800c6,0x7d780003,0x3eb2004a,0xc7b3000b}},	//   hari_, فمبر_, nnyt_, יבו_
  { {0xd9460046,0x20180065,0xdd900003,0x7d1b05cf}},	//   _јези, kari_, صود_, gsus
  { {0x0137000b,0x3eb2004a,0x645c157c,0x9f980042}},	//   _ברמת_, hnyt_, _jari, lším_
  { {0x2018157d,0x61480097,0x66090031,0x6280157e}},	//   dari_, _félö, bbek, _komo
  { {0xc333000b,0x558a0014,0x22b6001e,0x268a0012}},	//   סור_, _обем_, tāka_, _تخطي_
  { {0x9d9a0003,0xfd380012,0xf9890012,0x24990035}},	//   _تنشئ_, _أكتب_, رنسي_, ūsma_
  { {0x9f35002d,0x645c157f,0xf36605fb,0xcb340048}},	//   легі, _nari, _атин, _бекъ
  { {0x9cd7000b,0x78a70070,0x8e20002d,0xf7700012}},	//   _שווה_, rijv, _вiд_, ياف_
  { {0x628000b6,0x645c002c,0x20180532,0x9f980042}},	//   _nomo, _aari, aari_, jším_
  { {0xd2b80009,0xb5d5004c,0x3f9e0097,0x3f870034}},	// [2ed0] _שלחת_, ужај, útur_, zynu_
  { {0x1477000a,0xa8550a25,0x98a20010,0x645c1580}},	//   خارج, _скоч, tuką_, _cari
  { {0x8bd80009,0x6e22043a,0xe3b00012,0x645c1581}},	//   תַּח, _odob, يرم_, _dari
  { {0x3e040014,0xddcd0066,0xc333000b,0x6e950012}},	//   _вярв, zdař, שוף_, _إلحا
  { {0x7aed000f,0x645c1582,0x62340024,0xe29c0009}},	//   _miat, _fari, речу, ושאר
  { {0x99d40003,0x08c4002d,0x7c870345,0x765d00b6}},	//   جتما, абін, _руме, _hasy
  { {0xa3df0044,0xf6510003,0x46a50014,0x32bb0003}},	//   देश_, مئة_, лакв, _قدرة_
  { {0x7d1b0005,0x7529012e,0x72040003,0x645c0029}},	//   tsus, trez, _نوفم, _zari
  { {0xd4150047,0x20180101,0x765d0a26,0x5c150015}},	//   льны, yari_, _masy, льну
  { {0x13090047,0x752900c1,0x478b0014,0xb5fb0066}},	//   нной_, rrez, _осем_, _znát
  { {0x3eb20006,0xf9890009,0xe4c80012,0xb6350012}},	//   ynyt_, _צר_, خبين_, _مفاع
  { {0x7d1b0051,0xbcfb0061,0xfbd2000b,0x69c10060}},	//   psus, _prél, מתי_, ğlen
  { {0xe56e0046,0xe8f7002d,0x7aed00b6,0x3ea91583}},	//   _уз_, лля_, _diat, diat_
  { {0x6e220b32,0xddc20027,0x03190012,0x291d016d}},	//   _zdob, _unoš, _كتبت_, iswa_
  { {0x765d00b6,0x73c50012,0x20181584,0x4c3a0009}},	//   _basy, _حيثم, rari_, _נתקב
  { {0x645c0101,0xc3320009,0xa695004c,0x22b60035}},	//   _sari, _הוה_, аруј, māko_
  { {0x8d660047,0x9f980066,0x05660015,0xc5f2000b}},	// [2ee0] ывае, vším_, ыван, מדן_
  { {0x399b000b,0x62800b45,0x219b0009,0x59aa0011}},	//   _נייד, _somo, _נביא, _चेयर
  { {0x0c370003,0x22b6001e,0x883b000b,0xabd60001}},	//   اكمة_, nāko_, _אתיו, уцај
  { {0x6d4b0f00,0x3ea91585,0xf2c50024,0x99990073}},	//   _opga, ciat_, асін, cesų_
  { {0xa1580447,0x645c1586,0x22920030,0xa967038f}},	//   талу_, _tari, ušky_, лица_
  { {0x7e7b001e,0x61d7000b,0xe8d9001a,0xd91b0009}},	//   ejup, נוסף_, _trễ_, גוסל
  { {0x7d02003e,0xb4e00037,0x6d4b134f,0x9f9801e9}},	//   _stos, दगी_, _apga, pším_
  { {0x1ef70003,0x44441587,0x212000eb,0x91e60b4e}},	//   دعوة_, lf_, _ovih_, _бобе
  { {0x7aed00c1,0x0caa00f5,0xe297035c,0x18360012}},	//   _riat, етни_, _сат_, _مراح
  { {0x4438008b,0xb9930003,0xb80a0003,0x51930012}},	//   ür_, _الكب, _أيام_, _الكذ
  { {0x1bd4002d,0x6564004a,0xf8b30009,0x0463003c}},	//   роня, hvih, _פשע_, стым
  { {0x92580015,0xbb930015,0x7ae21588,0x6e221589}},	//   гают_, сающ, nmot, _udob
  { {0xa80200a2,0x3ea903eb,0x984b0014,0x212b0052}},	//   ğınd, viat_, нява_, urch_
  { {0x444400bd,0xa80200a2,0x22b6001e,0x68f6003a}},	//   jf_, şınd, bāko_, _duyd
  { {0x7ae2006f,0x6d40158a,0xd6db12f2,0xd7b80009}},	//   kmot, ltma, ета_, דֶּך
  { {0x5e58007c,0x4444158b,0x7bd8001b,0x6db50198}},	//   лися_, ef_, _izvu, айбу
  { {0x99990010,0xf1a40037,0x4444158c,0x3ea9158d}},	// [2ef0] resų_, _खेलन, ff_, riat_
  { {0xb8820030,0x78a50097,0xdce209df,0x6e360031}},	//   říjm, _umhv, _oroč, agyb
  { {0x75eb000e,0x8c1b0009,0xa3df0011,0xef670048}},	//   _közü, גובי, दें_, _съпо
  { {0xeaae002d,0x4444158e,0xfb1b0009,0x628f0227}},	//   ій_, af_, תואמ, nkco
  { {0xd9440003,0x224900b6,0x660d158f,0xe1f00012}},	//   مئوي, _mbak_, mbak, أسم_
  { {0x660d0f33,0xf7710003,0xbf650012,0xc9180009}},	//   lbak, قاب_, لدعو, נחות_
  { {0x8fa2003c,0xa695004c,0xdd0e0060,0xd00e0012}},	//   жаще, ириј, _kışl, ذلي_
  { {0x3169003e,0xa3de0066,0x22b6001e,0xc1050012}},	//   _oraz_, _běží_, vāko_, _نوري
  { {0x9875002d,0x212b001a,0xef190034,0x7e7b1590}},	//   _клац, _ích_, ąży_, rjup
  { {0x66f10039,0x3ea60163,0x2613001a,0x22b6001e}},	//   _sāku, _emot_, ảo_, tāko_
  { {0x2120001c,0xbb4500c0,0xe3b10003,0x752d0066}},	//   _svih_, шенк, ترة_, hraz
  { {0xfc3f0013,0x09e605cc,0x91e6010c,0xb3820024}},	//   ří_, ионн, ионе, ілял
  { {0x660d0058,0x661b004a,0x88c60012,0xa96a004c}},	//   dbak, mauk, لتسل, њига_
  { {0x859a000b,0x661b0757,0x7ae20b37,0x00f60009}},	//   _בשנו, lauk, zmot, ימשך_
  { {0x66e60012,0x7d091591,0xafe60198,0xa7a70048}},	//   لأرق, lpes, ровл, акра_
  { {0x44fb0020,0x75eb003a,0xcf920009,0x6bb40024}},	//   _kê_, _gözü, קטן_, _усіє
  { {0xa3e80044,0x752d00c1,0xdd0e003a,0x20d60024}},	// [2f00] मेन_, graz, _dışl, _вінс
  { {0x4444008b,0xc7a60024,0x61db0009,0x89db0009}},	//   uf_, _виок, _בקפד, _בחפי
  { {0x907b000b,0x66f1001e,0x44fb1592,0x752d1593}},	//   _סטטי, _māks, _lê_, araz
  { {0xd7bb0093,0x752d13b4,0x4fbb000b,0xe2460003}},	//   _יציר, braz, _יציא, شخصي
  { {0x28db0044,0xc05a002d,0x7bce0002,0x09b00037}},	//   _मीडि, вій_, _wybu, जपेय
  { {0xdce20580,0x7e0e0011,0x66f10035,0x394d0060}},	//   _proč, सर्ग_, _nāks, çesi_
  { {0xd3720003,0x7c47000e,0xa09b0009,0xc8290009}},	//   _ظهر_, ésrő, כיסט, אֵפֹ
  { {0x44fb1594,0x3546024d,0xe8d90081,0x661b1595}},	//   _bê_, ахов, _trệ_, gauk
  { {0x8c3c00a2,0x66f1001e,0x245b0010,0xddc90060}},	//   liği, _sākt, kšmė_, rdeş
  { {0x6721012e,0xf3f1000b,0x113b000b,0x44fb1596}},	//   šlji, ּ֣י_, _בתמל, _dê_
  { {0x8c1b000b,0x2bf7000b,0xcaa70012,0x9cd700