# Copyright (c) 2010 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'browser',
      'type': '<(library)',
      'msvs_guid': '5BF908A7-68FB-4A4B-99E3-8C749F1FE4EA',
      'dependencies': [
        'common',
        'common_net',
        'chrome_extra_resources',
        'chrome_resources',
        'chrome_strings',
        'chrome_version_info',
        'component_extensions',
        'installer_util',
        'platform_locale_settings',
        'profile_import',
        'browser/sync/protocol/sync_proto.gyp:sync_proto_cpp',
        'syncapi',
        'theme_resources',
        'userfeedback_proto',
        '../app/app.gyp:app_resources',
        '../app/app.gyp:app_strings',
        '../media/media.gyp:media',
        '../printing/printing.gyp:printing',
        '../skia/skia.gyp:skia',
        '../third_party/bzip2/bzip2.gyp:bzip2',
        '../third_party/expat/expat.gyp:expat',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libjingle/libjingle.gyp:libjingle',
        '../third_party/libxml/libxml.gyp:libxml',
        '../third_party/npapi/npapi.gyp:npapi',
        '../third_party/hunspell/hunspell.gyp:hunspell',
        '../webkit/support/webkit_support.gyp:appcache',
        '../webkit/support/webkit_support.gyp:database',
        '../webkit/support/webkit_support.gyp:glue',
        '../webkit/support/webkit_support.gyp:webkit_resources',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
      ],
      'defines': [
        '<@(nacl_defines)',
      ],
      'direct_dependent_settings': {
        'defines': [
          '<@(nacl_defines)',
        ],
      },
      'sources': [
        # All .cc, .h, .m, and .mm files under browser except for tests and
        # mocks.
        'browser/accessibility_events.h',
        'browser/accessibility_events.cc',
        'browser/aeropeek_manager.cc',
        'browser/aeropeek_manager.h',
        'browser/alternate_nav_url_fetcher.cc',
        'browser/alternate_nav_url_fetcher.h',
        'browser/app_controller_cppsafe_mac.h',
        'browser/app_controller_mac.h',
        'browser/app_controller_mac.mm',
        'browser/app_icon_win.cc',
        'browser/app_icon_win.h',
        'browser/app_launched_animation.h',
        'browser/app_modal_dialog.cc',
        'browser/app_modal_dialog.h',
        'browser/app_modal_dialog_gtk.cc',
        'browser/app_modal_dialog_mac.mm',
        'browser/app_modal_dialog_win.cc',
        'browser/app_modal_dialog_queue.cc',
        'browser/app_modal_dialog_queue.h',
        'browser/appcache/appcache_dispatcher_host.cc',
        'browser/appcache/appcache_dispatcher_host.h',
        'browser/appcache/appcache_frontend_proxy.cc',
        'browser/appcache/appcache_frontend_proxy.h',
        'browser/appcache/chrome_appcache_service.cc',
        'browser/appcache/chrome_appcache_service.h',
        'browser/appcache/view_appcache_internals_job_factory.cc',
        'browser/appcache/view_appcache_internals_job_factory.h',
        'browser/autocomplete/autocomplete.cc',
        'browser/autocomplete/autocomplete.h',
        'browser/autocomplete/autocomplete_accessibility.cc',
        'browser/autocomplete/autocomplete_accessibility.h',
        'browser/autocomplete/autocomplete_classifier.cc',
        'browser/autocomplete/autocomplete_classifier.h',
        'browser/autocomplete/autocomplete_edit.cc',
        'browser/autocomplete/autocomplete_edit.h',
        'browser/autocomplete/autocomplete_edit_view.h',
        'browser/autocomplete/autocomplete_edit_view_gtk.cc',
        'browser/autocomplete/autocomplete_edit_view_gtk.h',
        'browser/autocomplete/autocomplete_edit_view_mac.h',
        'browser/autocomplete/autocomplete_edit_view_mac.mm',
        'browser/autocomplete/autocomplete_edit_view_win.cc',
        'browser/autocomplete/autocomplete_edit_view_win.h',
        'browser/autocomplete/autocomplete_popup_model.cc',
        'browser/autocomplete/autocomplete_popup_model.h',
        'browser/autocomplete/autocomplete_popup_view.h',
        'browser/autocomplete/autocomplete_popup_view_gtk.cc',
        'browser/autocomplete/autocomplete_popup_view_gtk.h',
        'browser/autocomplete/autocomplete_popup_view_mac.h',
        'browser/autocomplete/autocomplete_popup_view_mac.mm',
        'browser/autocomplete/history_contents_provider.cc',
        'browser/autocomplete/history_contents_provider.h',
        'browser/autocomplete/history_url_provider.cc',
        'browser/autocomplete/history_url_provider.h',
        'browser/autocomplete/keyword_provider.cc',
        'browser/autocomplete/keyword_provider.h',
        'browser/autocomplete/search_provider.cc',
        'browser/autocomplete/search_provider.h',
        'browser/autocomplete_history_manager.cc',
        'browser/autocomplete_history_manager.h',
        'browser/autofill/address_field.cc',
        'browser/autofill/address_field.h',
        'browser/autofill/address.cc',
        'browser/autofill/address.h',
        'browser/autofill/autofill_address_model_mac.h',
        'browser/autofill/autofill_address_model_mac.mm',
        'browser/autofill/autofill_address_sheet_controller_mac.h',
        'browser/autofill/autofill_address_sheet_controller_mac.mm',
        'browser/autofill/autofill_cc_infobar.h',
        'browser/autofill/autofill_cc_infobar_win.cc',
        'browser/autofill/autofill_cc_infobar_delegate.h',
        'browser/autofill/autofill_cc_infobar_delegate.cc',
        'browser/autofill/autofill_credit_card_model_mac.h',
        'browser/autofill/autofill_credit_card_model_mac.mm',
        'browser/autofill/autofill_credit_card_sheet_controller_mac.h',
        'browser/autofill/autofill_credit_card_sheet_controller_mac.mm',
        'browser/autofill/autofill_dialog_controller_mac.h',
        'browser/autofill/autofill_dialog_controller_mac.mm',
        'browser/autofill/autofill_dialog_gtk.cc',
        'browser/autofill/autofill_dialog_mac.mm',
        # Windows version of autofill dialog is defined in
        # 'browser/views/autofill_profiles_view_win.cc'
        'browser/autofill/autofill_dialog.h',
        'browser/autofill/autofill_download.cc',
        'browser/autofill/autofill_download.h',
        'browser/autofill/autofill_field.cc',
        'browser/autofill/autofill_field.h',
        'browser/autofill/autofill_manager.cc',
        'browser/autofill/autofill_manager.h',
        'browser/autofill/autofill_profile.cc',
        'browser/autofill/autofill_profile.h',
        'browser/autofill/auto_fill_editor_gtk.cc',
        'browser/autofill/autofill_text_field_mac.h',
        'browser/autofill/autofill_text_field_mac.mm',
        'browser/autofill/autofill_type.cc',
        'browser/autofill/autofill_type.h',
        'browser/autofill/autofill_xml_parser.cc',
        'browser/autofill/autofill_xml_parser.h',
        'browser/autofill/billing_address.h',
        'browser/autofill/contact_info.cc',
        'browser/autofill/contact_info.h',
        'browser/autofill/credit_card_field.cc',
        'browser/autofill/credit_card_field.h',
        'browser/autofill/credit_card.cc',
        'browser/autofill/credit_card.h',
        'browser/autofill/fax_field.cc',
        'browser/autofill/fax_field.h',
        'browser/autofill/fax_number.h',
        'browser/autofill/field_types.h',
        'browser/autofill/form_field.cc',
        'browser/autofill/form_field.h',
        'browser/autofill/form_group.cc',
        'browser/autofill/form_group.h',
        'browser/autofill/form_structure.cc',
        'browser/autofill/form_structure.h',
        'browser/autofill/home_address.h',
        'browser/autofill/home_phone_number.h',
        'browser/autofill/name_field.cc',
        'browser/autofill/name_field.h',
        'browser/autofill/personal_data_manager.cc',
        'browser/autofill/personal_data_manager.h',
        'browser/autofill/personal_data_manager_mac.mm',
        'browser/autofill/phone_field.cc',
        'browser/autofill/phone_field.h',
        'browser/autofill/phone_number.cc',
        'browser/autofill/phone_number.h',
        'browser/autofill/select_control_handler.cc',
        'browser/autofill/select_control_handler.h',
        'browser/automation/automation_autocomplete_edit_tracker.h',
        'browser/automation/automation_browser_tracker.h',
        'browser/automation/extension_automation_constants.h',
        'browser/automation/extension_automation_constants.cc',
        'browser/automation/automation_extension_function.h',
        'browser/automation/automation_extension_function.cc',
        'browser/automation/automation_extension_tracker.cc',
        'browser/automation/automation_extension_tracker.h',
        'browser/automation/automation_provider_chromeos.cc',
        'browser/automation/automation_provider_gtk.cc',
        'browser/automation/automation_provider_mac.mm',
        'browser/automation/automation_provider_views.cc',
        'browser/automation/automation_provider_win.cc',
        'browser/automation/automation_provider.cc',
        'browser/automation/automation_provider.h',
        'browser/automation/automation_provider_json.h',
        'browser/automation/automation_provider_json.cc',
        'browser/automation/automation_provider_list.cc',
        'browser/automation/automation_provider_list_generic.cc',
        'browser/automation/automation_provider_list_mac.mm',
        'browser/automation/automation_provider_list.h',
        'browser/automation/automation_provider_observers.cc',
        'browser/automation/automation_provider_observers.h',
        'browser/automation/automation_resource_message_filter.cc',
        'browser/automation/automation_resource_message_filter.h',
        'browser/automation/automation_resource_routing_delegate.cc',
        'browser/automation/automation_resource_routing_delegate.h',
        'browser/automation/automation_resource_tracker.cc',
        'browser/automation/automation_resource_tracker.h',
        'browser/automation/automation_tab_tracker.h',
        'browser/automation/chrome_frame_automation_provider.cc',
        'browser/automation/chrome_frame_automation_provider.h',
        'browser/automation/url_request_automation_job.cc',
        'browser/automation/url_request_automation_job.h',
        'browser/automation/automation_window_tracker.h',
        'browser/automation/extension_port_container.cc',
        'browser/automation/extension_port_container.h',
        'browser/automation/ui_controls_linux.cc',
        'browser/automation/ui_controls_mac.mm',
        'browser/automation/ui_controls_win.cc',
        'browser/automation/ui_controls.h',
        'browser/back_forward_menu_model.cc',
        'browser/back_forward_menu_model.h',
        'browser/background_contents_service.h',
        'browser/background_contents_service.cc',
        'browser/blocked_popup_container.cc',
        'browser/blocked_popup_container.h',
        'browser/bookmarks/bookmark_codec.cc',
        'browser/bookmarks/bookmark_codec.h',
        'browser/bookmarks/bookmark_context_menu_controller.cc',
        'browser/bookmarks/bookmark_context_menu_controller.h',
        'browser/bookmarks/bookmark_drag_data.cc',
        'browser/bookmarks/bookmark_drag_data.h',
        'browser/bookmarks/bookmark_drop_info.cc',
        'browser/bookmarks/bookmark_drop_info.h',
        'browser/bookmarks/bookmark_editor.h',
        'browser/bookmarks/bookmark_folder_editor_controller.cc',
        'browser/bookmarks/bookmark_folder_editor_controller.h',
        'browser/bookmarks/bookmark_index.cc',
        'browser/bookmarks/bookmark_index.h',
        'browser/bookmarks/bookmark_html_writer.cc',
        'browser/bookmarks/bookmark_html_writer.h',
        'browser/bookmarks/bookmark_model.cc',
        'browser/bookmarks/bookmark_model.h',
        'browser/bookmarks/bookmark_model_observer.h',
        'browser/bookmarks/bookmark_pasteboard_helper_mac.h',
        'browser/bookmarks/bookmark_pasteboard_helper_mac.mm',
        'browser/bookmarks/bookmark_service.h',
        'browser/bookmarks/bookmark_storage.cc',
        'browser/bookmarks/bookmark_storage.h',
        'browser/bookmarks/bookmark_utils.cc',
        'browser/bookmarks/bookmark_utils.h',
        'browser/bookmarks/recently_used_folders_combo_model.cc',
        'browser/bookmarks/rencetly_used_folders_combo_model.h',
        'browser/browser.cc',
        'browser/browser.h',
        'browser/browser_about_handler.cc',
        'browser/browser_about_handler.h',
        'browser/browser_accessibility_win.cc',
        'browser/browser_accessibility_win.h',
        'browser/browser_accessibility_manager_win.cc',
        'browser/browser_accessibility_manager_win.h',
        'browser/browser_child_process_host.cc',
        'browser/browser_child_process_host.h',
        'browser/browser_init.cc',
        'browser/browser_init.h',
        'browser/browser_list_gtk.cc',
        'browser/browser_list_mac.mm',
        'browser/browser_list_stub.cc',
        'browser/browser_list_win.cc',
        'browser/browser_list.cc',
        'browser/browser_list.h',
        'browser/browser_main.cc',
        'browser/browser_main_gtk.cc',
        'browser/browser_main_mac.mm',
        'browser/browser_main_posix.cc',
        'browser/browser_main_win.cc',
        'browser/browser_main_win.h',
        'browser/browser_prefs.cc',
        'browser/browser_prefs.h',
        'browser/browser_process.cc',
        'browser/browser_process.h',
        'browser/browser_process_impl.cc',
        'browser/browser_process_impl.h',
        'browser/browser_process_sub_thread.cc',
        'browser/browser_process_sub_thread.h',
        'browser/browser_shutdown.cc',
        'browser/browser_shutdown.h',
        'browser/browser_theme_pack.cc',
        'browser/browser_theme_pack.h',
        'browser/browser_theme_provider_gtk.cc',
        'browser/browser_theme_provider_mac.mm',
        'browser/browser_theme_provider.cc',
        'browser/browser_theme_provider.h',
        'browser/browser_trial.cc',
        'browser/browser_trial.h',
        'browser/browser_url_handler.cc',
        'browser/browser_url_handler.h',
        'browser/browser_window.h',
        'browser/browsing_data_appcache_helper.cc',
        'browser/browsing_data_appcache_helper.h',
        'browser/browsing_data_database_helper.cc',
        'browser/browsing_data_database_helper.h',
        'browser/browsing_data_local_storage_helper.cc',
        'browser/browsing_data_local_storage_helper.h',
        'browser/browsing_data_remover.cc',
        'browser/browsing_data_remover.h',
        'browser/browsing_instance.cc',
        'browser/browsing_instance.h',
        'browser/bug_report_util.cc',
        'browser/bug_report_util.h',
        # TODO(rkc): Find a better way to include these files
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/annotations.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/common.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/config.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/dom.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/extension.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/math.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/web.pb.cc',
        'browser/cancelable_request.cc',
        'browser/cancelable_request.h',
        'browser/cert_store.cc',
        'browser/cert_store.h',
        'browser/certificate_viewer.cc',
        'browser/certificate_viewer.h',
        'browser/character_encoding.cc',
        'browser/character_encoding.h',
        'browser/child_process_launcher.cc',
        'browser/child_process_launcher.h',
        'browser/child_process_security_policy.cc',
        'browser/child_process_security_policy.h',
        'browser/chrome_browser_application_mac.h',
        'browser/chrome_browser_application_mac.mm',
        'browser/chrome_plugin_browsing_context.cc',
        'browser/chrome_plugin_browsing_context.h',
        'browser/chrome_plugin_host.cc',
        'browser/chrome_plugin_host.h',
        'browser/chrome_thread.cc',
        'browser/chrome_thread.h',
        'browser/chromeos/notifications/balloon_collection_impl.h',
        'browser/chromeos/notifications/balloon_collection_impl.cc',
        'browser/chromeos/notifications/balloon_view.h',
        'browser/chromeos/notifications/balloon_view.cc',
        'browser/chromeos/notifications/notification_panel.h',
        'browser/chromeos/notifications/notification_panel.cc',
        'browser/chromeos/notifications/system_notification.h',
        'browser/chromeos/notifications/system_notification.cc',
        'browser/chromeos/notifications/system_notification_factory.h',
        'browser/chromeos/notifications/system_notification_factory.cc',
        'browser/chromeos/audio_handler.cc',
        'browser/chromeos/audio_handler.h',
        'browser/chromeos/boot_times_loader.cc',
        'browser/chromeos/boot_times_loader.h',
        'browser/chromeos/browser_notification_observers.cc',
        'browser/chromeos/cros_settings.cc',
        'browser/chromeos/cros_settings.h',
        'browser/chromeos/cros_settings_names.cc',
        'browser/chromeos/cros_settings_names.h',
        'browser/chromeos/cros/cros_library.cc',
        'browser/chromeos/cros/cros_library.h',
        'browser/chromeos/cros/cros_library_loader.cc',
        'browser/chromeos/cros/cros_library_loader.h',
        'browser/chromeos/cros/cryptohome_library.cc',
        'browser/chromeos/cros/cryptohome_library.h',
        'browser/chromeos/cros/keyboard_library.cc',
        'browser/chromeos/cros/keyboard_library.h',
        'browser/chromeos/cros/input_method_library.cc',
        'browser/chromeos/cros/input_method_library.h',
        'browser/chromeos/cros/login_library.cc',
        'browser/chromeos/cros/login_library.h',
        'browser/chromeos/cros/mount_library.cc',
        'browser/chromeos/cros/mount_library.h',
        'browser/chromeos/cros/network_library.cc',
        'browser/chromeos/cros/network_library.h',
        'browser/chromeos/cros/power_library.cc',
        'browser/chromeos/cros/power_library.h',
        'browser/chromeos/cros/screen_lock_library.cc',
        'browser/chromeos/cros/screen_lock_library.h',
        'browser/chromeos/cros/speech_synthesis_library.cc',
        'browser/chromeos/cros/speech_synthesis_library.h',
        'browser/chromeos/cros/synaptics_library.cc',
        'browser/chromeos/cros/synaptics_library.h',
        'browser/chromeos/cros/syslogs_library.cc',
        'browser/chromeos/cros/syslogs_library.h',
        'browser/chromeos/cros/system_library.cc',
        'browser/chromeos/cros/system_library.h',
        'browser/chromeos/cros/update_library.cc',
        'browser/chromeos/cros/update_library.h',
        'browser/chromeos/customization_document.cc',
        'browser/chromeos/customization_document.h',
        'browser/chromeos/dom_ui/accounts_options_handler.cc',
        'browser/chromeos/dom_ui/accounts_options_handler.h',
        'browser/chromeos/dom_ui/core_chromeos_options_handler.cc',
        'browser/chromeos/dom_ui/core_chromeos_options_handler.h',
        'browser/chromeos/dom_ui/labs_handler.cc',
        'browser/chromeos/dom_ui/labs_handler.h',
        'browser/chromeos/dom_ui/language_hangul_options_handler.cc',
        'browser/chromeos/dom_ui/language_hangul_options_handler.h',
        'browser/chromeos/dom_ui/language_options_handler.cc',
        'browser/chromeos/dom_ui/language_options_handler.h',
        'browser/chromeos/dom_ui/sync_options_handler.cc',
        'browser/chromeos/dom_ui/sync_options_handler.h',
        'browser/chromeos/dom_ui/system_options_handler.cc',
        'browser/chromeos/dom_ui/system_options_handler.h',
        'browser/chromeos/drop_shadow_label.cc',
        'browser/chromeos/external_cookie_handler.cc',
        'browser/chromeos/external_cookie_handler.h',
        'browser/chromeos/external_metrics.cc',
        'browser/chromeos/external_metrics.h',
        'browser/chromeos/external_protocol_dialog.cc',
        'browser/chromeos/external_protocol_dialog.h',
        'browser/chromeos/frame/browser_frame_chromeos.cc',
        'browser/chromeos/frame/browser_frame_chromeos.h',
        'browser/chromeos/frame/browser_view.cc',
        'browser/chromeos/frame/browser_view.h',
        'browser/chromeos/frame/normal_browser_frame_view.cc',
        'browser/chromeos/frame/normal_browser_frame_view.h',
        'browser/chromeos/frame/panel_browser_view.cc',
        'browser/chromeos/frame/panel_browser_view.h',
        'browser/chromeos/frame/panel_controller.cc',
        'browser/chromeos/frame/panel_controller.h',
        'browser/chromeos/google_update_chromeos.cc',
        'browser/chromeos/gview_request_interceptor.cc',
        'browser/chromeos/gview_request_interceptor.h',
        'browser/chromeos/input_method/input_method_util.cc',
        'browser/chromeos/input_method/input_method_util.h',
        'browser/chromeos/login/account_creation_view.cc',
        'browser/chromeos/login/account_creation_view.h',
        'browser/chromeos/login/account_screen.cc',
        'browser/chromeos/login/account_screen.h',
        'browser/chromeos/login/authenticator.h',
        'browser/chromeos/login/auth_response_handler.cc',
        'browser/chromeos/login/auth_response_handler.h',
        'browser/chromeos/login/background_view.cc',
        'browser/chromeos/login/background_view.h',
        'browser/chromeos/login/camera.cc',
        'browser/chromeos/login/camera.h',
        'browser/chromeos/login/captcha_view.cc',
        'browser/chromeos/login/captcha_view.h',
        'browser/chromeos/login/client_login_response_handler.cc',
        'browser/chromeos/login/client_login_response_handler.h',
        'browser/chromeos/login/cookie_fetcher.cc',
        'browser/chromeos/login/cookie_fetcher.h',
        'browser/chromeos/login/eula_view.cc',
        'browser/chromeos/login/eula_view.h',
        'browser/chromeos/login/existing_user_controller.cc',
        'browser/chromeos/login/existing_user_controller.h',
        'browser/chromeos/login/image_decoder.cc',
        'browser/chromeos/login/image_decoder.h',
        'browser/chromeos/login/image_downloader.cc',
        'browser/chromeos/login/image_downloader.h',
        'browser/chromeos/login/issue_response_handler.cc',
        'browser/chromeos/login/issue_response_handler.h',
        'browser/chromeos/login/google_authenticator.cc',
        'browser/chromeos/login/google_authenticator.h',
        'browser/chromeos/login/helper.cc',
        'browser/chromeos/login/language_switch_menu.cc',
        'browser/chromeos/login/language_switch_menu.h',
        'browser/chromeos/login/login_html_dialog.cc',
        'browser/chromeos/login/login_html_dialog.h',
        'browser/chromeos/login/login_screen.cc',
        'browser/chromeos/login/login_screen.h',
        'browser/chromeos/login/login_status_consumer.h',
        'browser/chromeos/login/login_utils.cc',
        'browser/chromeos/login/login_utils.h',
        'browser/chromeos/login/message_bubble.h',
        'browser/chromeos/login/message_bubble.cc',
        'browser/chromeos/login/network_selection_view.cc',
        'browser/chromeos/login/network_selection_view.h',
        'browser/chromeos/login/network_screen.cc',
        'browser/chromeos/login/network_screen.h',
        'browser/chromeos/login/network_screen_delegate.h',
        'browser/chromeos/login/new_user_view.cc',
        'browser/chromeos/login/new_user_view.h',
        'browser/chromeos/login/password_changed_view.cc',
        'browser/chromeos/login/password_changed_view.h',
        'browser/chromeos/login/registration_screen.cc',
        'browser/chromeos/login/registration_screen.h',
        'browser/chromeos/login/rounded_rect_painter.cc',
        'browser/chromeos/login/rounded_rect_painter.h',
        'browser/chromeos/login/screen_locker.cc',
        'browser/chromeos/login/screen_locker.h',
        'browser/chromeos/login/screen_lock_view.cc',
        'browser/chromeos/login/screen_lock_view.h',
        'browser/chromeos/login/screen_observer.h',
        'browser/chromeos/login/update_screen.cc',
        'browser/chromeos/login/update_screen.h',
        'browser/chromeos/login/update_view.cc',
        'browser/chromeos/login/update_view.h',
        'browser/chromeos/login/user_controller.cc',
        'browser/chromeos/login/user_controller.h',
        'browser/chromeos/login/user_image_downloader.cc',
        'browser/chromeos/login/user_image_downloader.h',
        'browser/chromeos/login/user_image_loader.cc',
        'browser/chromeos/login/user_image_loader.h',
        'browser/chromeos/login/user_image_screen.cc',
        'browser/chromeos/login/user_image_screen.h',
        'browser/chromeos/login/user_image_view.cc',
        'browser/chromeos/login/user_image_view.h',
        'browser/chromeos/login/user_manager.cc',
        'browser/chromeos/login/user_manager.h',
        'browser/chromeos/login/user_view.cc',
        'browser/chromeos/login/user_view.h',
        'browser/chromeos/login/view_screen.h',
        'browser/chromeos/login/web_page_screen.cc',
        'browser/chromeos/login/web_page_screen.h',
        'browser/chromeos/login/web_page_view.cc',
        'browser/chromeos/login/web_page_view.h',
        'browser/chromeos/login/wizard_controller.cc',
        'browser/chromeos/login/wizard_controller.h',
        'browser/chromeos/login/wizard_screen.h',
        'browser/chromeos/low_battery_observer.cc',
        'browser/chromeos/low_battery_observer.h',
        # TODO(xiyuan): Remove mock_cros_settings once we have real stuff.
        'browser/chromeos/mock_cros_settings.cc',
        'browser/chromeos/mock_cros_settings.h',
        'browser/chromeos/native_dialog_window.cc',
        'browser/chromeos/native_dialog_window.h',
        'browser/chromeos/network_list.cc',
        'browser/chromeos/network_list.h',
        'browser/chromeos/network_state_notifier.cc',
        'browser/chromeos/network_state_notifier.h',
        'browser/chromeos/network_message_observer.cc',
        'browser/chromeos/network_message_observer.h',
        'browser/chromeos/options/cellular_config_view.cc',
        'browser/chromeos/options/cellular_config_view.h',
        'browser/chromeos/offline/offline_load_page.cc',
        'browser/chromeos/offline/offline_load_page.h',
        'browser/chromeos/offline/offline_load_service.cc',
        'browser/chromeos/offline/offline_load_service.h',
        'browser/chromeos/options/internet_page_view.cc',
        'browser/chromeos/options/internet_page_view.h',
        'browser/chromeos/options/ip_config_view.cc',
        'browser/chromeos/options/ip_config_view.h',
        'browser/chromeos/options/language_config_model.cc',
        'browser/chromeos/options/language_config_model.h',
        'browser/chromeos/options/language_config_util.h',
        'browser/chromeos/options/language_config_view.cc',
        'browser/chromeos/options/language_config_view.h',
        'browser/chromeos/options/language_chewing_config_view.cc',
        'browser/chromeos/options/language_chewing_config_view.h',
        'browser/chromeos/options/language_hangul_config_view.cc',
        'browser/chromeos/options/language_hangul_config_view.h',
        'browser/chromeos/options/language_pinyin_config_view.cc',
        'browser/chromeos/options/language_pinyin_config_view.h',
        'browser/chromeos/options/language_mozc_config_view.cc',
        'browser/chromeos/options/language_mozc_config_view.h',
        'browser/chromeos/options/network_config_view.cc',
        'browser/chromeos/options/network_config_view.h',
        'browser/chromeos/options/options_window_view.cc',
        'browser/chromeos/options/options_window_view.h',
        'browser/chromeos/options/settings_page_view.cc',
        'browser/chromeos/options/settings_page_view.h',
        'browser/chromeos/options/system_page_view.cc',
        'browser/chromeos/options/system_page_view.h',
        'browser/chromeos/options/wifi_config_view.cc',
        'browser/chromeos/options/wifi_config_view.h',
        'browser/chromeos/panels/panel_scroller.cc',
        'browser/chromeos/panels/panel_scroller.h',
        'browser/chromeos/panels/panel_scroller_container.cc',
        'browser/chromeos/panels/panel_scroller_container.h',
        'browser/chromeos/panels/panel_scroller_header.cc',
        'browser/chromeos/panels/panel_scroller_header.h',
        'browser/chromeos/pipe_reader.cc',
        'browser/chromeos/pipe_reader.h',
        'browser/chromeos/preferences.cc',
        'browser/chromeos/preferences.h',
        'browser/chromeos/pulse_audio_mixer.cc',
        'browser/chromeos/pulse_audio_mixer.h',
        'browser/chromeos/status/clock_menu_button.cc',
        'browser/chromeos/status/clock_menu_button.h',
        'browser/chromeos/status/feedback_menu_button.cc',
        'browser/chromeos/status/feedback_menu_button.h',
        'browser/chromeos/status/language_menu_button.cc',
        'browser/chromeos/status/language_menu_button.h',
        'browser/chromeos/status/network_menu_button.cc',
        'browser/chromeos/status/network_menu_button.h',
        'browser/chromeos/status/power_menu_button.cc',
        'browser/chromeos/status/power_menu_button.h',
        'browser/chromeos/status/status_area_button.cc',
        'browser/chromeos/status/status_area_button.h',
        'browser/chromeos/status/status_area_host.h',
        'browser/chromeos/status/status_area_view.cc',
        'browser/chromeos/status/status_area_view.h',
        'browser/chromeos/system_key_event_listener.cc',
        'browser/chromeos/system_key_event_listener.h',
        'browser/chromeos/tab_closeable_state_watcher.cc',
        'browser/chromeos/tab_closeable_state_watcher.h',
        'browser/chromeos/update_observer.cc',
        'browser/chromeos/update_observer.h',
        'browser/chromeos/usb_mount_observer.cc',
        'browser/chromeos/usb_mount_observer.h',
        'browser/chromeos/version_loader.cc',
        'browser/chromeos/version_loader.h',
        'browser/chromeos/view_ids.h',
        'browser/chromeos/volume_bubble.cc',
        'browser/chromeos/volume_bubble.h',
        'browser/chromeos/volume_bubble_view.cc',
        'browser/chromeos/volume_bubble_view.h',
        'browser/chromeos/wm_ipc.cc',
        'browser/chromeos/wm_ipc.h',
        'browser/chromeos/wm_message_listener.cc',
        'browser/chromeos/wm_message_listener.h',
        'browser/chromeos/wm_overview_controller.cc',
        'browser/chromeos/wm_overview_controller.h',
        'browser/chromeos/wm_overview_fav_icon.cc',
        'browser/chromeos/wm_overview_fav_icon.h',
        'browser/chromeos/wm_overview_snapshot.cc',
        'browser/chromeos/wm_overview_snapshot.h',
        'browser/chromeos/wm_overview_title.cc',
        'browser/chromeos/wm_overview_title.h',
        'browser/clipboard_dispatcher_gtk.cc',
        'browser/clipboard_dispatcher_mac.mm',
        'browser/clipboard_dispatcher_win.cc',
        'browser/clipboard_dispatcher.h',
        'browser/cocoa/about_ipc_bridge.h',
        'browser/cocoa/about_ipc_bridge.mm',
        'browser/cocoa/about_ipc_controller.h',
        'browser/cocoa/about_ipc_controller.mm',
        'browser/cocoa/about_ipc_dialog.h',
        'browser/cocoa/about_ipc_dialog.mm',
        'browser/cocoa/about_window_controller.h',
        'browser/cocoa/about_window_controller.mm',
        'browser/cocoa/accelerators_cocoa.h',
        'browser/cocoa/accelerators_cocoa.mm',
        'browser/cocoa/animatable_image.h',
        'browser/cocoa/animatable_image.mm',
        'browser/cocoa/animatable_view.h',
        'browser/cocoa/animatable_view.mm',
        'browser/cocoa/authorization_util.h',
        'browser/cocoa/authorization_util.mm',
        'browser/cocoa/back_forward_menu_controller.h',
        'browser/cocoa/back_forward_menu_controller.mm',
        'browser/cocoa/background_gradient_view.h',
        'browser/cocoa/background_gradient_view.mm',
        'browser/cocoa/background_tile_view.h',
        'browser/cocoa/background_tile_view.mm',
        'browser/cocoa/base_bubble_controller.h',
        'browser/cocoa/base_bubble_controller.mm',
        'browser/cocoa/base_view.h',
        'browser/cocoa/base_view.mm',
        'browser/cocoa/browser_accessibility.h',
        'browser/cocoa/browser_accessibility.mm',
        'browser/cocoa/browser_accessibility_delegate.h',
        'browser/cocoa/browser_window_factory.mm',
        'browser/cocoa/bookmark_all_tabs_controller.h',
        'browser/cocoa/bookmark_all_tabs_controller.mm',
        'browser/cocoa/bookmark_bar_bridge.h',
        'browser/cocoa/bookmark_bar_bridge.mm',
        'browser/cocoa/bookmark_bar_constants.h',
        'browser/cocoa/bookmark_bar_controller.h',
        'browser/cocoa/bookmark_bar_controller.mm',
        'browser/cocoa/bookmark_bar_folder_button_cell.h',
        'browser/cocoa/bookmark_bar_folder_button_cell.mm',
        'browser/cocoa/bookmark_bar_folder_controller.h',
        'browser/cocoa/bookmark_bar_folder_controller.mm',
        'browser/cocoa/bookmark_bar_folder_hover_state.h',
        'browser/cocoa/bookmark_bar_folder_hover_state.mm',
        'browser/cocoa/bookmark_bar_folder_view.h',
        'browser/cocoa/bookmark_bar_folder_view.mm',
        'browser/cocoa/bookmark_bar_folder_window.h',
        'browser/cocoa/bookmark_bar_folder_window.mm',
        'browser/cocoa/bookmark_bar_state.h',
        'browser/cocoa/bookmark_bar_toolbar_view.h',
        'browser/cocoa/bookmark_bar_toolbar_view.mm',
        'browser/cocoa/bookmark_bar_view.h',
        'browser/cocoa/bookmark_bar_view.mm',
        'browser/cocoa/bookmark_bubble_controller.h',
        'browser/cocoa/bookmark_bubble_controller.mm',
        'browser/cocoa/bookmark_button.h',
        'browser/cocoa/bookmark_button.mm',
        'browser/cocoa/bookmark_button_cell.h',
        'browser/cocoa/bookmark_button_cell.mm',
        'browser/cocoa/bookmark_drag_source.h',
        'browser/cocoa/bookmark_drag_source.mm',
        'browser/cocoa/bookmark_editor_base_controller.h',
        'browser/cocoa/bookmark_editor_base_controller.mm',
        'browser/cocoa/bookmark_editor_controller.h',
        'browser/cocoa/bookmark_editor_controller.mm',
        'browser/cocoa/bookmark_folder_target.h',
        'browser/cocoa/bookmark_folder_target.mm',
        'browser/cocoa/bookmark_menu.h',
        'browser/cocoa/bookmark_menu.mm',
        'browser/cocoa/bookmark_menu_bridge.h',
        'browser/cocoa/bookmark_menu_bridge.mm',
        'browser/cocoa/bookmark_menu_cocoa_controller.h',
        'browser/cocoa/bookmark_menu_cocoa_controller.mm',
        'browser/cocoa/bookmark_model_observer_for_cocoa.h',
        'browser/cocoa/bookmark_name_folder_controller.h',
        'browser/cocoa/bookmark_name_folder_controller.mm',
        'browser/cocoa/bookmark_tree_browser_cell.h',
        'browser/cocoa/bookmark_tree_browser_cell.mm',
        'browser/cocoa/browser_command_executor.h',
        'browser/cocoa/browser_frame_view.h',
        'browser/cocoa/browser_frame_view.mm',
        'browser/cocoa/browser_window_cocoa.h',
        'browser/cocoa/browser_window_cocoa.mm',
        'browser/cocoa/browser_window_controller.h',
        'browser/cocoa/browser_window_controller.mm',
        'browser/cocoa/browser_window_controller_private.h',
        'browser/cocoa/browser_window_controller_private.mm',
        'browser/cocoa/bubble_view.h',
        'browser/cocoa/bubble_view.mm',
        'browser/cocoa/bug_report_window_controller.h',
        'browser/cocoa/bug_report_window_controller.mm',
        'browser/cocoa/certificate_viewer.mm',
        'browser/cocoa/chrome_browser_window.h',
        'browser/cocoa/chrome_browser_window.mm',
        'browser/cocoa/chrome_event_processing_window.h',
        'browser/cocoa/chrome_event_processing_window.mm',
        'browser/cocoa/clear_browsing_data_controller.h',
        'browser/cocoa/clear_browsing_data_controller.mm',
        'browser/cocoa/clickhold_button_cell.h',
        'browser/cocoa/clickhold_button_cell.mm',
        'browser/cocoa/collected_cookies_mac.h',
        'browser/cocoa/collected_cookies_mac.mm',
        'browser/cocoa/command_observer_bridge.h',
        'browser/cocoa/command_observer_bridge.mm',
        'browser/cocoa/constrained_window_mac.h',
        'browser/cocoa/constrained_window_mac.mm',
        'browser/cocoa/content_blocked_bubble_controller.h',
        'browser/cocoa/content_blocked_bubble_controller.mm',
        'browser/cocoa/content_exceptions_window_controller.h',
        'browser/cocoa/content_exceptions_window_controller.mm',
        'browser/cocoa/content_settings_dialog_controller.h',
        'browser/cocoa/content_settings_dialog_controller.mm',
        'browser/cocoa/cookie_details.h',
        'browser/cocoa/cookie_details.mm',
        'browser/cocoa/cookie_details_view_controller.h',
        'browser/cocoa/cookie_details_view_controller.mm',
        'browser/cocoa/cookie_prompt_window_controller.h',
        'browser/cocoa/cookie_prompt_window_controller.mm',
        'browser/cocoa/cookie_tree_node.h',
        'browser/cocoa/cookie_tree_node.mm',
        'browser/cocoa/cookies_window_controller.h',
        'browser/cocoa/cookies_window_controller.mm',
        'browser/cocoa/custom_home_pages_model.h',
        'browser/cocoa/custom_home_pages_model.mm',
        'browser/cocoa/delayedmenu_button.h',
        'browser/cocoa/delayedmenu_button.mm',
        'browser/cocoa/dock_icon.h',
        'browser/cocoa/dock_icon.mm',
        'browser/cocoa/download_item_button.h',
        'browser/cocoa/download_item_button.mm',
        'browser/cocoa/download_item_cell.h',
        'browser/cocoa/download_item_cell.mm',
        'browser/cocoa/download_item_controller.h',
        'browser/cocoa/download_item_controller.mm',
        'browser/cocoa/download_item_mac.h',
        'browser/cocoa/download_item_mac.mm',
        'browser/cocoa/download_shelf_controller.h',
        'browser/cocoa/download_shelf_controller.mm',
        'browser/cocoa/download_shelf_mac.h',
        'browser/cocoa/download_shelf_mac.mm',
        'browser/cocoa/download_shelf_view.h',
        'browser/cocoa/download_shelf_view.mm',
        'browser/cocoa/download_started_animation_mac.mm',
        'browser/cocoa/download_util_mac.h',
        'browser/cocoa/download_util_mac.mm',
        'browser/cocoa/draggable_button.h',
        'browser/cocoa/draggable_button.mm',
        'browser/cocoa/edit_search_engine_cocoa_controller.h',
        'browser/cocoa/edit_search_engine_cocoa_controller.mm',
        'browser/cocoa/encoding_menu_controller_delegate_mac.h',
        'browser/cocoa/encoding_menu_controller_delegate_mac.mm',
        'browser/cocoa/event_utils.h',
        'browser/cocoa/event_utils.mm',
        'browser/cocoa/extension_install_prompt.mm',
        'browser/cocoa/extension_installed_bubble_bridge.h',
        'browser/cocoa/extension_installed_bubble_bridge.mm',
        'browser/cocoa/extension_installed_bubble_controller.h',
        'browser/cocoa/extension_installed_bubble_controller.mm',
        'browser/cocoa/extension_view_mac.h',
        'browser/cocoa/extension_view_mac.mm',
        'browser/cocoa/extensions/browser_action_button.h',
        'browser/cocoa/extensions/browser_action_button.mm',
        'browser/cocoa/extensions/browser_actions_container_view.h',
        'browser/cocoa/extensions/browser_actions_container_view.mm',
        'browser/cocoa/extensions/browser_actions_controller.h',
        'browser/cocoa/extensions/browser_actions_controller.mm',
        'browser/cocoa/extensions/chevron_menu_button.h',
        'browser/cocoa/extensions/chevron_menu_button.mm',
        'browser/cocoa/extensions/chevron_menu_button_cell.h',
        'browser/cocoa/extensions/chevron_menu_button_cell.mm',
        'browser/cocoa/extensions/extension_action_context_menu.h',
        'browser/cocoa/extensions/extension_action_context_menu.mm',
        'browser/cocoa/extensions/extension_infobar_controller.h',
        'browser/cocoa/extensions/extension_infobar_controller.mm',
        'browser/cocoa/extensions/extension_install_prompt_controller.h',
        'browser/cocoa/extensions/extension_install_prompt_controller.mm',
        'browser/cocoa/extensions/extension_popup_controller.h',
        'browser/cocoa/extensions/extension_popup_controller.mm',
        'browser/cocoa/external_protocol_dialog.h',
        'browser/cocoa/external_protocol_dialog.mm',
        'browser/cocoa/fast_resize_view.h',
        'browser/cocoa/fast_resize_view.mm',
        'browser/cocoa/file_metadata.h',
        'browser/cocoa/file_metadata.mm',
        'browser/cocoa/find_bar_bridge.h',
        'browser/cocoa/find_bar_bridge.mm',
        'browser/cocoa/find_bar_cocoa_controller.h',
        'browser/cocoa/find_bar_cocoa_controller.mm',
        'browser/cocoa/find_bar_text_field.h',
        'browser/cocoa/find_bar_text_field.mm',
        'browser/cocoa/find_bar_text_field_cell.h',
        'browser/cocoa/find_bar_text_field_cell.mm',
        'browser/cocoa/find_bar_view.h',
        'browser/cocoa/find_bar_view.mm',
        'browser/cocoa/find_pasteboard.h',
        'browser/cocoa/find_pasteboard.mm',
        'browser/cocoa/first_run_bubble_controller.h',
        'browser/cocoa/first_run_bubble_controller.mm',
        'browser/cocoa/first_run_dialog.h',
        'browser/cocoa/first_run_dialog.mm',
        'browser/cocoa/floating_bar_backing_view.h',
        'browser/cocoa/floating_bar_backing_view.mm',
        'browser/cocoa/focus_tracker.h',
        'browser/cocoa/focus_tracker.mm',
        'browser/cocoa/font_language_settings_controller.h',
        'browser/cocoa/font_language_settings_controller.mm',
        'browser/cocoa/fullscreen_controller.h',
        'browser/cocoa/fullscreen_controller.mm',
        'browser/cocoa/fullscreen_window.h',
        'browser/cocoa/fullscreen_window.mm',
        'browser/cocoa/gradient_button_cell.h',
        'browser/cocoa/gradient_button_cell.mm',
        'browser/cocoa/history_menu_bridge.h',
        'browser/cocoa/history_menu_bridge.mm',
        'browser/cocoa/history_menu_cocoa_controller.h',
        'browser/cocoa/history_menu_cocoa_controller.mm',
        'browser/cocoa/hover_button.h',
        'browser/cocoa/hover_button.mm',
        'browser/cocoa/hover_close_button.h',
        'browser/cocoa/hover_close_button.mm',
        'browser/cocoa/hover_image_button.h',
        'browser/cocoa/hover_image_button.mm',
        'browser/cocoa/html_dialog_window_controller.h',
        'browser/cocoa/html_dialog_window_controller_cppsafe.h',
        'browser/cocoa/html_dialog_window_controller.mm',
        'browser/cocoa/hyperlink_button_cell.h',
        'browser/cocoa/hyperlink_button_cell.mm',
        'browser/cocoa/hung_renderer_controller.h',
        'browser/cocoa/hung_renderer_controller.mm',
        'browser/cocoa/image_utils.h',
        'browser/cocoa/image_utils.mm',
        'browser/cocoa/import_progress_dialog.h',
        'browser/cocoa/import_progress_dialog.mm',
        'browser/cocoa/import_settings_dialog.h',
        'browser/cocoa/import_settings_dialog.mm',
        'browser/cocoa/importer_lock_dialog.h',
        'browser/cocoa/importer_lock_dialog.mm',
        'browser/cocoa/info_bubble_view.h',
        'browser/cocoa/info_bubble_view.mm',
        'browser/cocoa/info_bubble_window.h',
        'browser/cocoa/info_bubble_window.mm',
        'browser/cocoa/infobar.h',
        'browser/cocoa/infobar_container_controller.h',
        'browser/cocoa/infobar_container_controller.mm',
        'browser/cocoa/infobar_controller.h',
        'browser/cocoa/infobar_controller.mm',
        'browser/cocoa/infobar_gradient_view.h',
        'browser/cocoa/infobar_gradient_view.mm',
        'browser/cocoa/infobar_test_helper.h',
        'browser/cocoa/install_from_dmg.h',
        'browser/cocoa/install_from_dmg.mm',
        'browser/cocoa/keystone_glue.h',
        'browser/cocoa/keystone_glue.mm',
        'browser/cocoa/keystone_infobar.h',
        'browser/cocoa/keystone_infobar.mm',
        'browser/cocoa/keyword_editor_cocoa_controller.h',
        'browser/cocoa/keyword_editor_cocoa_controller.mm',
        'browser/cocoa/l10n_util.h',
        'browser/cocoa/l10n_util.mm',
        'browser/cocoa/location_bar/autocomplete_text_field.h',
        'browser/cocoa/location_bar/autocomplete_text_field.mm',
        'browser/cocoa/location_bar/autocomplete_text_field_cell.h',
        'browser/cocoa/location_bar/autocomplete_text_field_cell.mm',
        'browser/cocoa/location_bar/autocomplete_text_field_editor.h',
        'browser/cocoa/location_bar/autocomplete_text_field_editor.mm',
        'browser/cocoa/location_bar/bubble_decoration.h',
        'browser/cocoa/location_bar/bubble_decoration.mm',
        'browser/cocoa/location_bar/content_setting_decoration.h',
        'browser/cocoa/location_bar/content_setting_decoration.mm',
        'browser/cocoa/location_bar/ev_bubble_decoration.h',
        'browser/cocoa/location_bar/ev_bubble_decoration.mm',
        'browser/cocoa/location_bar/image_decoration.h',
        'browser/cocoa/location_bar/image_decoration.mm',
        'browser/cocoa/location_bar/keyword_hint_decoration.h',
        'browser/cocoa/location_bar/keyword_hint_decoration.mm',
        'browser/cocoa/location_bar/location_bar_decoration.h',
        'browser/cocoa/location_bar/location_bar_decoration.mm',
        'browser/cocoa/location_bar/location_bar_view_mac.h',
        'browser/cocoa/location_bar/location_bar_view_mac.mm',
        'browser/cocoa/location_bar/location_icon_decoration.h',
        'browser/cocoa/location_bar/location_icon_decoration.mm',
        'browser/cocoa/location_bar/page_action_decoration.h',
        'browser/cocoa/location_bar/page_action_decoration.mm',
        'browser/cocoa/location_bar/selected_keyword_decoration.h',
        'browser/cocoa/location_bar/selected_keyword_decoration.mm',
        'browser/cocoa/location_bar/star_decoration.h',
        'browser/cocoa/location_bar/star_decoration.mm',
        'browser/cocoa/menu_button.h',
        'browser/cocoa/menu_button.mm',
        'browser/cocoa/menu_controller.h',
        'browser/cocoa/menu_controller.mm',
        'browser/cocoa/menu_tracked_button.h',
        'browser/cocoa/menu_tracked_button.mm',
        'browser/cocoa/menu_tracked_root_view.h',
        'browser/cocoa/menu_tracked_root_view.mm',
        'browser/cocoa/multi_key_equivalent_button.h',
        'browser/cocoa/multi_key_equivalent_button.mm',
        'browser/cocoa/new_tab_button.h',
        'browser/cocoa/new_tab_button.mm',
        'browser/cocoa/notifications/balloon_controller.mm',
        'browser/cocoa/notifications/balloon_controller.h',
        'browser/cocoa/notifications/balloon_view_bridge.h',
        'browser/cocoa/notifications/balloon_view_bridge.mm',
        'browser/cocoa/notifications/balloon_view_host_mac.h',
        'browser/cocoa/notifications/balloon_view_host_mac.mm',
        'browser/cocoa/notifications/balloon_view.h',
        'browser/cocoa/notifications/balloon_view.mm',
        'browser/cocoa/nsmenuitem_additions.h',
        'browser/cocoa/nsmenuitem_additions.mm',
        'browser/cocoa/objc_method_swizzle.h',
        'browser/cocoa/objc_method_swizzle.mm',
        'browser/cocoa/objc_zombie.h',
        'browser/cocoa/objc_zombie.mm',
        'browser/cocoa/page_info_window_controller.h',
        'browser/cocoa/page_info_window_controller.mm',
        'browser/cocoa/page_info_window_mac.h',
        'browser/cocoa/page_info_window_mac.mm',
        'browser/cocoa/popup_blocked_animation_mac.mm',
        'browser/cocoa/preferences_window_controller.h',
        'browser/cocoa/preferences_window_controller.mm',
        'browser/cocoa/reload_button.h',
        'browser/cocoa/reload_button.mm',
        'browser/cocoa/repost_form_warning_mac.h',
        'browser/cocoa/repost_form_warning_mac.mm',
        'browser/cocoa/restart_browser.h',
        'browser/cocoa/restart_browser.mm',
        'browser/cocoa/rwhvm_editcommand_helper.h',
        'browser/cocoa/rwhvm_editcommand_helper.mm',
        'browser/cocoa/sad_tab_controller.h',
        'browser/cocoa/sad_tab_controller.mm',
        'browser/cocoa/sad_tab_view.h',
        'browser/cocoa/sad_tab_view.mm',
        'browser/cocoa/scoped_authorizationref.h',
        'browser/cocoa/search_engine_list_model.h',
        'browser/cocoa/search_engine_list_model.mm',
        'browser/cocoa/shell_dialogs_mac.mm',
        'browser/cocoa/side_tab_strip_controller.h',
        'browser/cocoa/side_tab_strip_controller.mm',
        'browser/cocoa/side_tab_strip_view.h',
        'browser/cocoa/side_tab_strip_view.mm',
        'browser/cocoa/simple_content_exceptions_window_controller.h',
        'browser/cocoa/simple_content_exceptions_window_controller.mm',
        'browser/cocoa/status_bubble_mac.h',
        'browser/cocoa/status_bubble_mac.mm',
        'browser/cocoa/status_icons/status_icon_mac.h',
        'browser/cocoa/status_icons/status_icon_mac.mm',
        'browser/cocoa/status_icons/status_tray_mac.h',
        'browser/cocoa/status_icons/status_tray_mac.mm',
        'browser/cocoa/styled_text_field.h',
        'browser/cocoa/styled_text_field.mm',
        'browser/cocoa/styled_text_field_cell.h',
        'browser/cocoa/styled_text_field_cell.mm',
        'browser/cocoa/tab_contents_controller.h',
        'browser/cocoa/tab_contents_controller.mm',
        'browser/cocoa/tab_controller.h',
        'browser/cocoa/tab_controller.mm',
        'browser/cocoa/tab_strip_controller.h',
        'browser/cocoa/tab_strip_controller.mm',
        'browser/cocoa/tab_strip_model_observer_bridge.h',
        'browser/cocoa/tab_strip_model_observer_bridge.mm',
        'browser/cocoa/tab_strip_view.h',
        'browser/cocoa/tab_strip_view.mm',
        'browser/cocoa/tab_view.h',
        'browser/cocoa/tab_view.mm',
        'browser/cocoa/tab_view_picker_table.h',
        'browser/cocoa/tab_view_picker_table.mm',
        'browser/cocoa/tab_window_controller.h',
        'browser/cocoa/tab_window_controller.mm',
        'browser/cocoa/table_row_nsimage_cache.h',
        'browser/cocoa/table_row_nsimage_cache.mm',
        'browser/cocoa/task_manager_mac.h',
        'browser/cocoa/task_manager_mac.mm',
        'browser/cocoa/themed_window.h',
        'browser/cocoa/themed_window.mm',
        'browser/cocoa/theme_install_bubble_view.h',
        'browser/cocoa/theme_install_bubble_view.mm',
        'browser/cocoa/throbber_view.h',
        'browser/cocoa/throbber_view.mm',
        'browser/cocoa/toolbar_controller.h',
        'browser/cocoa/toolbar_controller.mm',
        'browser/cocoa/toolbar_view.h',
        'browser/cocoa/toolbar_view.mm',
        'browser/cocoa/translate/after_translate_infobar_controller.h',
        'browser/cocoa/translate/after_translate_infobar_controller.mm',
        'browser/cocoa/translate/before_translate_infobar_controller.h',
        'browser/cocoa/translate/before_translate_infobar_controller.mm',
        'browser/cocoa/translate/translate_infobar_base.h',
        'browser/cocoa/translate/translate_infobar_base.mm',
        'browser/cocoa/translate/translate_message_infobar_controller.h',
        'browser/cocoa/translate/translate_message_infobar_controller.mm',
        'browser/cocoa/ui_localizer.h',
        'browser/cocoa/ui_localizer.mm',
        'browser/cocoa/url_drop_target.h',
        'browser/cocoa/url_drop_target.mm',
        'browser/cocoa/vertical_gradient_view.h',
        'browser/cocoa/vertical_gradient_view.mm',
        'browser/cocoa/view_resizer.h',
        'browser/cocoa/web_contents_drag_source.h',
        'browser/cocoa/web_contents_drag_source.mm',
        'browser/cocoa/web_drag_source.h',
        'browser/cocoa/web_drag_source.mm',
        'browser/cocoa/web_drop_target.h',
        'browser/cocoa/web_drop_target.mm',
        'browser/cocoa/window_size_autosaver.h',
        'browser/cocoa/window_size_autosaver.mm',
        'browser/cocoa/wrench_menu_button_cell.h',
        'browser/cocoa/wrench_menu_button_cell.mm',
        'browser/cocoa/wrench_menu_controller.h',
        'browser/cocoa/wrench_menu_controller.mm',
        'browser/command_line_pref_store.cc',
        'browser/command_line_pref_store.h',
        'browser/command_updater.cc',
        'browser/command_updater.h',
        'browser/config_dir_policy_provider.cc',
        'browser/config_dir_policy_provider.h',
        'browser/configuration_policy_store.h',
        'browser/configuration_policy_pref_store.cc',
        'browser/configuration_policy_pref_store.h',
        'browser/configuration_policy_provider.cc',
        'browser/configuration_policy_provider.h',
        'browser/configuration_policy_provider_mac.cc',
        'browser/configuration_policy_provider_mac.h',
        'browser/configuration_policy_provider_win.cc',
        'browser/configuration_policy_provider_win.h',
        'browser/content_exceptions_table_model.cc',
        'browser/content_exceptions_table_model.h',
        'browser/content_setting_bubble_model.cc',
        'browser/content_setting_bubble_model.h',
        'browser/content_setting_combo_model.cc',
        'browser/content_setting_combo_model.h',
        'browser/content_setting_image_model.cc',
        'browser/content_setting_image_model.h',
        'browser/cookie_modal_dialog.cc',
        'browser/cookie_modal_dialog.h',
        'browser/cookie_modal_dialog_mac.mm',
        'browser/cookie_modal_dialog_gtk.cc',
        'browser/cookie_modal_dialog_views.cc',
        'browser/cookie_prompt_modal_dialog_delegate.h',
        'browser/cookies_tree_model.cc',
        'browser/cookies_tree_model.h',
        'browser/cross_site_request_manager.cc',
        'browser/cross_site_request_manager.h',
        'browser/custom_home_pages_table_model.cc',
        'browser/custom_home_pages_table_model.h',
        'browser/default_encoding_combo_model.cc',
        'browser/default_encoding_combo_model.h',
        'browser/defaults.cc',
        'browser/defaults.h',
        'browser/diagnostics/diagnostics_main.cc',
        'browser/diagnostics/diagnostics_main.h',
        'browser/diagnostics/diagnostics_model.h',
        'browser/diagnostics/diagnostics_model.cc',
        'browser/diagnostics/diagnostics_test.h',
        'browser/diagnostics/sqlite_diagnostics.cc',
        'browser/diagnostics/sqlite_diagnostics.h',
        'browser/diagnostics/recon_diagnostics.cc',
        'browser/diagnostics/recon_diagnostics.h',
        'browser/dock_info_gtk.cc',
        'browser/dock_info_mac.cc',
        'browser/dock_info_win.cc',
        'browser/dock_info.cc',
        'browser/dock_info.h',
        'browser/dom_operation_notification_details.h',
        'browser/dom_ui/app_launcher_handler.cc',
        'browser/dom_ui/app_launcher_handler.h',
        'browser/dom_ui/bookmarks_ui.cc',
        'browser/dom_ui/bookmarks_ui.h',
        'browser/dom_ui/chrome_url_data_manager.cc',
        'browser/dom_ui/chrome_url_data_manager.h',
        'browser/dom_ui/advanced_options_handler.cc',
        'browser/dom_ui/advanced_options_handler.h',
        'browser/dom_ui/advanced_options_utils_mac.mm',
        'browser/dom_ui/advanced_options_utils_mac.h',
        'browser/dom_ui/browser_options_handler.cc',
        'browser/dom_ui/browser_options_handler.h',
        'browser/dom_ui/clear_browser_data_handler.cc',
        'browser/dom_ui/clear_browser_data_handler.h',
        'browser/dom_ui/content_settings_handler.cc',
        'browser/dom_ui/content_settings_handler.h',
        'browser/dom_ui/core_options_handler.cc',
        'browser/dom_ui/core_options_handler.h',
        'browser/dom_ui/font_settings_handler.cc',
        'browser/dom_ui/font_settings_handler.h',
        'browser/dom_ui/personal_options_handler.cc',
        'browser/dom_ui/personal_options_handler.h',
        'browser/dom_ui/devtools_ui.cc',
        'browser/dom_ui/devtools_ui.h',
        'browser/dom_ui/dom_ui.cc',
        'browser/dom_ui/dom_ui.h',
        'browser/dom_ui/dom_ui_factory.cc',
        'browser/dom_ui/dom_ui_factory.h',
        'browser/dom_ui/dom_ui_favicon_source.cc',
        'browser/dom_ui/dom_ui_favicon_source.h',
        'browser/dom_ui/dom_ui_theme_source.cc',
        'browser/dom_ui/dom_ui_theme_source.h',
        'browser/dom_ui/dom_ui_thumbnail_source.cc',
        'browser/dom_ui/dom_ui_thumbnail_source.h',
        'browser/dom_ui/dom_ui_util.cc',
        'browser/dom_ui/dom_ui_util.h',
        'browser/dom_ui/downloads_dom_handler.cc',
        'browser/dom_ui/downloads_dom_handler.h',
        'browser/dom_ui/downloads_ui.cc',
        'browser/dom_ui/downloads_ui.h',
        'browser/dom_ui/fileicon_source.cc',
        'browser/dom_ui/fileicon_source.h',
        'browser/dom_ui/filebrowse_ui.cc',
        'browser/dom_ui/filebrowse_ui.h',
        'browser/dom_ui/history_ui.cc',
        'browser/dom_ui/history_ui.h',
        'browser/dom_ui/history2_ui.cc',
        'browser/dom_ui/history2_ui.h',
        'browser/dom_ui/html_dialog_tab_contents_delegate.cc',
        'browser/dom_ui/html_dialog_tab_contents_delegate.h',
        'browser/dom_ui/html_dialog_ui.cc',
        'browser/dom_ui/html_dialog_ui.h',
        'browser/dom_ui/mediaplayer_ui.cc',
        'browser/dom_ui/mediaplayer_ui.h',
        'browser/dom_ui/most_visited_handler.cc',
        'browser/dom_ui/most_visited_handler.h',
        'browser/dom_ui/net_internals_ui.cc',
        'browser/dom_ui/net_internals_ui.h',
        'browser/dom_ui/new_tab_page_sync_handler.cc',
        'browser/dom_ui/new_tab_page_sync_handler.h',
        'browser/dom_ui/new_tab_ui.cc',
        'browser/dom_ui/new_tab_ui.h',
        'browser/dom_ui/ntp_resource_cache.cc',
        'browser/dom_ui/ntp_resource_cache.h',
        'browser/dom_ui/options_ui.cc',
        'browser/dom_ui/options_ui.h',
        'browser/dom_ui/plugins_ui.cc',
        'browser/dom_ui/plugins_ui.h',
        'browser/dom_ui/register_page_ui.cc',
        'browser/dom_ui/register_page_ui.h',        
        'browser/dom_ui/remoting_ui.cc',
        'browser/dom_ui/remoting_ui.h',
        'browser/dom_ui/shared_resources_data_source.cc',
        'browser/dom_ui/shared_resources_data_source.h',
        'browser/dom_ui/shown_sections_handler.cc',
        'browser/dom_ui/shown_sections_handler.h',
        'browser/dom_ui/slideshow_ui.cc',
        'browser/dom_ui/slideshow_ui.h',
        'browser/dom_ui/tips_handler.cc',
        'browser/dom_ui/tips_handler.h',
        'browser/download/download_exe.cc',
        'browser/download/download_file.cc',
        'browser/download/download_file.h',
        'browser/download/download_file_manager.cc',
        'browser/download/download_file_manager.h',
        'browser/download/download_item.cc',
        'browser/download/download_item.h',
        'browser/download/download_item_model.cc',
        'browser/download/download_item_model.h',
        'browser/download/download_manager.cc',
        'browser/download/download_manager.h',
        'browser/download/download_request_infobar_delegate.h',
        'browser/download/download_request_infobar_delegate.cc',
        'browser/download/download_request_limiter.cc',
        'browser/download/download_request_limiter.h',
        'browser/download/download_shelf.cc',
        'browser/download/download_shelf.h',
        'browser/download/download_started_animation.h',
        'browser/download/download_types.h',
        'browser/download/download_util.cc',
        'browser/download/download_util.h',
        'browser/download/drag_download_file.cc',
        'browser/download/drag_download_file.h',
        'browser/download/drag_download_util.cc',
        'browser/download/drag_download_util.h',
        'browser/download/save_file.cc',
        'browser/download/save_file.h',
        'browser/download/save_file_manager.cc',
        'browser/download/save_file_manager.h',
        'browser/download/save_item.cc',
        'browser/download/save_item.h',
        'browser/download/save_package.cc',
        'browser/download/save_package.h',
        'browser/download/save_types.h',
        'browser/dummy_configuration_policy_provider.h',
        'browser/encoding_menu_controller.cc',
        'browser/encoding_menu_controller.h',
        'browser/extensions/convert_user_script.cc',
        'browser/extensions/convert_user_script.h',
        'browser/extensions/crashed_extension_infobar.cc',
        'browser/extensions/crashed_extension_infobar.h',
        'browser/extensions/crx_installer.cc',
        'browser/extensions/crx_installer.h',
        'browser/extensions/extension_accessibility_api.cc',
        'browser/extensions/extension_accessibility_api.h',
        'browser/extensions/extension_accessibility_api_constants.cc',
        'browser/extensions/extension_accessibility_api_constants.h',
        'browser/extensions/extension_bookmark_helpers.cc',
        'browser/extensions/extension_bookmark_helpers.h',
        'browser/extensions/extension_bookmarks_module.cc',
        'browser/extensions/extension_bookmarks_module.h',
        'browser/extensions/extension_bookmarks_module_constants.cc',
        'browser/extensions/extension_bookmarks_module_constants.h',
        'browser/extensions/extension_bookmark_manager_api.cc',
        'browser/extensions/extension_bookmark_manager_api.h',
        'browser/extensions/extension_browser_actions_api.cc',
        'browser/extensions/extension_browser_actions_api.h',
        'browser/extensions/extension_clipboard_api.cc',
        'browser/extensions/extension_clipboard_api.h',
        'browser/extensions/extension_context_menu_api.cc',
        'browser/extensions/extension_context_menu_api.h',
        'browser/extensions/extension_context_menu_model.cc',
        'browser/extensions/extension_context_menu_model.h',
        'browser/extensions/extension_cookies_api.cc',
        'browser/extensions/extension_cookies_api.h',
        'browser/extensions/extension_cookies_api_constants.cc',
        'browser/extensions/extension_cookies_api_constants.h',
        'browser/extensions/extension_cookies_helpers.cc',
        'browser/extensions/extension_cookies_helpers.h',
        'browser/extensions/extension_creator.cc',
        'browser/extensions/extension_creator.h',
        'browser/extensions/extension_data_deleter.cc',
        'browser/extensions/extension_data_deleter.h',
        'browser/extensions/extension_disabled_infobar_delegate.cc',
        'browser/extensions/extension_disabled_infobar_delegate.h',
        'browser/extensions/extension_devtools_bridge.cc',
        'browser/extensions/extension_devtools_bridge.h',
        'browser/extensions/extension_devtools_events.cc',
        'browser/extensions/extension_devtools_events.h',
        'browser/extensions/extension_devtools_manager.cc',
        'browser/extensions/extension_devtools_manager.h',
        'browser/extensions/extension_dom_ui.cc',
        'browser/extensions/extension_dom_ui.h',
        'browser/extensions/extension_error_reporter.cc',
        'browser/extensions/extension_error_reporter.h',
        'browser/extensions/extension_event_names.cc',
        'browser/extensions/extension_event_names.h',
        'browser/extensions/execute_code_in_tab_function.cc',
        'browser/extensions/execute_code_in_tab_function.h',
        'browser/extensions/extension_browser_event_router.cc',
        'browser/extensions/extension_browser_event_router.h',
        'browser/extensions/extension_function.cc',
        'browser/extensions/extension_function.h',
        'browser/extensions/extension_function_dispatcher.cc',
        'browser/extensions/extension_function_dispatcher.h',
        'browser/extensions/extension_history_api.cc',
        'browser/extensions/extension_history_api.h',
        'browser/extensions/extension_history_api_constants.cc',
        'browser/extensions/extension_history_api_constants.h',
        'browser/extensions/extension_host.cc',
        'browser/extensions/extension_host.h',
        'browser/extensions/extension_host_mac.h',
        'browser/extensions/extension_host_mac.mm',
        'browser/extensions/extension_icon_manager.cc',
        'browser/extensions/extension_icon_manager.h',
        'browser/extensions/extension_idle_api.cc',
        'browser/extensions/extension_idle_api.h',
        'browser/extensions/extension_idle_api_constants.cc',
        'browser/extensions/extension_idle_api_constants.h',
        'browser/extensions/extension_i18n_api.cc',
        'browser/extensions/extension_i18n_api.h',
        'browser/extensions/extension_infobar_module.cc',
        'browser/extensions/extension_infobar_module.h',
        'browser/extensions/extension_infobar_module_constants.cc',
        'browser/extensions/extension_infobar_module_constants.h',
        'browser/extensions/extension_infobar_delegate.cc',
        'browser/extensions/extension_infobar_delegate.h',
        'browser/extensions/extension_install_ui.cc',
        'browser/extensions/extension_install_ui.h',
        'browser/extensions/extension_menu_manager.cc',
        'browser/extensions/extension_menu_manager.h',
        'browser/extensions/extension_message_service.cc',
        'browser/extensions/extension_message_service.h',
        'browser/extensions/extension_metrics_module.cc',
        'browser/extensions/extension_metrics_module.h',
        'browser/extensions/extension_omnibox_api.cc',
        'browser/extensions/extension_omnibox_api.h',
        'browser/extensions/extension_page_actions_module.cc',
        'browser/extensions/extension_page_actions_module.h',
        'browser/extensions/extension_page_actions_module_constants.cc',
        'browser/extensions/extension_page_actions_module_constants.h',
        'browser/extensions/extension_popup_api.cc',
        'browser/extensions/extension_popup_api.h',
        'browser/extensions/extension_prefs.cc',
        'browser/extensions/extension_prefs.h',
        'browser/extensions/extension_pref_store.cc',
        'browser/extensions/extension_pref_store.h',
        'browser/extensions/extension_process_manager.cc',
        'browser/extensions/extension_process_manager.h',
        'browser/extensions/extension_processes_api.cc',
        'browser/extensions/extension_processes_api.h',
        'browser/extensions/extension_processes_api_constants.cc',
        'browser/extensions/extension_processes_api_constants.h',
        'browser/extensions/extension_protocols.cc',
        'browser/extensions/extension_protocols.h',
        'browser/extensions/extension_rlz_module.cc',
        'browser/extensions/extension_rlz_module.h',
        'browser/extensions/extension_shelf_model.cc',
        'browser/extensions/extension_shelf_model.h',
        'browser/extensions/extension_tabs_module.cc',
        'browser/extensions/extension_tabs_module.h',
        'browser/extensions/extension_tabs_module_constants.cc',
        'browser/extensions/extension_tabs_module_constants.h',
        'browser/extensions/extension_test_api.cc',
        'browser/extensions/extension_test_api.h',
        'browser/extensions/extension_toolbar_model.cc',
        'browser/extensions/extension_toolbar_model.h',
        'browser/extensions/extension_toolstrip_api.cc',
        'browser/extensions/extension_toolstrip_api.h',
        'browser/extensions/extension_updater.cc',
        'browser/extensions/extension_updater.h',
        'browser/extensions/extensions_quota_service.cc',
        'browser/extensions/extensions_quota_service.h',
        'browser/extensions/extensions_service.cc',
        'browser/extensions/extensions_service.h',
        'browser/extensions/extensions_ui.cc',
        'browser/extensions/extensions_ui.h',
        'browser/extensions/external_extension_provider.h',
        'browser/extensions/external_registry_extension_provider_win.cc',
        'browser/extensions/external_registry_extension_provider_win.h',
        'browser/extensions/external_pref_extension_provider.cc',
        'browser/extensions/external_pref_extension_provider.h',
        'browser/extensions/file_reader.cc',
        'browser/extensions/file_reader.h',
        'browser/extensions/gtk_theme_installed_infobar_delegate.cc',
        'browser/extensions/gtk_theme_installed_infobar_delegate.h',
        'browser/extensions/image_loading_tracker.cc',
        'browser/extensions/image_loading_tracker.h',
        'browser/extensions/pack_extension_job.cc',
        'browser/extensions/pack_extension_job.h',
        'browser/extensions/sandboxed_extension_unpacker.cc',
        'browser/extensions/sandboxed_extension_unpacker.h',
        'browser/extensions/theme_installed_infobar_delegate.cc',
        'browser/extensions/theme_installed_infobar_delegate.h',
        'browser/extensions/user_script_listener.cc',
        'browser/extensions/user_script_listener.h',
        'browser/extensions/user_script_master.cc',
        'browser/extensions/user_script_master.h',
        'browser/external_protocol_handler.cc',
        'browser/external_protocol_handler.h',
        'browser/external_tab_container_win.cc',
        'browser/external_tab_container_win.h',
        'browser/global_keyboard_shortcuts_mac.h',
        'browser/global_keyboard_shortcuts_mac.mm',
        'browser/fav_icon_helper.cc',
        'browser/fav_icon_helper.h',
        'browser/favicon_service.cc',
        'browser/favicon_service.h',
        'browser/file_watcher.h',
        'browser/file_watcher_inotify.cc',
        'browser/file_watcher_mac.cc',
        'browser/file_watcher_win.cc',
        'browser/find_bar.h',
        'browser/find_bar_controller.cc',
        'browser/find_bar_controller.h',
        'browser/find_bar_state.h',
        'browser/find_bar_state.cc',
        'browser/find_notification_details.h',
        'browser/first_run.cc',
        'browser/first_run.h',
        'browser/first_run_mac.mm',
        'browser/first_run_win.cc',
        'browser/first_run_gtk.cc',
        'browser/fonts_languages_window.h',
        'browser/gears_integration.cc',
        'browser/gears_integration.h',
        'browser/geolocation/access_token_store.cc',
        'browser/geolocation/access_token_store.h',
        'browser/geolocation/device_data_provider.h',
        'browser/geolocation/empty_device_data_provider.cc',
        'browser/geolocation/empty_device_data_provider.h',
        'browser/geolocation/geolocation_dispatcher_host.cc',
        'browser/geolocation/geolocation_dispatcher_host.h',
        'browser/geolocation/geolocation_permission_context.cc',
        'browser/geolocation/geolocation_permission_context.h',
        'browser/geolocation/geolocation_prefs.cc',
        'browser/geolocation/geolocation_prefs.h',
        'browser/geolocation/geolocation_content_settings_map.cc',
        'browser/geolocation/geolocation_content_settings_map.h',
        'browser/geolocation/geolocation_exceptions_table_model.cc',
        'browser/geolocation/geolocation_exceptions_table_model.h',
        'browser/geolocation/geolocation_settings_state.cc',
        'browser/geolocation/geolocation_settings_state.h',
        'browser/geolocation/gps_location_provider_linux.cc',
        'browser/geolocation/gps_location_provider_linux.h',
        'browser/geolocation/libgps_2_38_wrapper_linux.cc',
        'browser/geolocation/libgps_2_94_wrapper_linux.cc',
        'browser/geolocation/libgps_wrapper_linux.cc',
        'browser/geolocation/libgps_wrapper_linux.h',
        'browser/geolocation/location_arbitrator.cc',
        'browser/geolocation/location_arbitrator.h',
        'browser/geolocation/location_provider.cc',
        'browser/geolocation/location_provider.h',
        'browser/geolocation/network_location_provider.cc',
        'browser/geolocation/network_location_provider.h',
        'browser/geolocation/network_location_request.cc',
        'browser/geolocation/network_location_request.h',
        'browser/geolocation/osx_wifi.h',
        'browser/geolocation/wifi_data_provider_chromeos.cc',
        'browser/geolocation/wifi_data_provider_chromeos.h',
        'browser/geolocation/wifi_data_provider_common.cc',
        'browser/geolocation/wifi_data_provider_common.h',
        'browser/geolocation/wifi_data_provider_corewlan_mac.mm',
        'browser/geolocation/wifi_data_provider_common_win.cc',
        'browser/geolocation/wifi_data_provider_common_win.h',
        'browser/geolocation/wifi_data_provider_linux.cc',
        'browser/geolocation/wifi_data_provider_linux.h',
        'browser/geolocation/wifi_data_provider_mac.cc',
        'browser/geolocation/wifi_data_provider_mac.h',
        'browser/geolocation/wifi_data_provider_win.cc',
        'browser/geolocation/wifi_data_provider_win.h',
        'browser/google_service_auth_error.h',
        'browser/google_update.cc',
        'browser/google_update.h',
        'browser/google_update_settings_posix.cc',
        'browser/google_url_tracker.cc',
        'browser/google_url_tracker.h',
        'browser/google_util.cc',
        'browser/google_util.h',
        'browser/gpu_process_host.cc',
        'browser/gpu_process_host.h',
        'browser/gpu_process_host_ui_shim.cc',
        'browser/gpu_process_host_ui_shim.h',
        'browser/gtk/about_chrome_dialog.cc',
        'browser/gtk/about_chrome_dialog.h',
        'browser/gtk/accelerators_gtk.cc',
        'browser/gtk/accelerators_gtk.h',
        'browser/gtk/accessibility_event_router_gtk.cc',
        'browser/gtk/accessibility_event_router_gtk.h',
        'browser/gtk/accessible_widget_helper_gtk.cc',
        'browser/gtk/accessible_widget_helper_gtk.h',
        'browser/gtk/back_forward_button_gtk.cc',
        'browser/gtk/back_forward_button_gtk.h',
        'browser/gtk/bookmark_bar_gtk.cc',
        'browser/gtk/bookmark_bar_gtk.h',
        'browser/gtk/bookmark_bar_instructions_gtk.cc',
        'browser/gtk/bookmark_bar_instructions_gtk.h',
        'browser/gtk/bookmark_bubble_gtk.cc',
        'browser/gtk/bookmark_bubble_gtk.h',
        'browser/gtk/bookmark_editor_gtk.cc',
        'browser/gtk/bookmark_editor_gtk.h',
        'browser/gtk/bookmark_menu_controller_gtk.cc',
        'browser/gtk/bookmark_menu_controller_gtk.h',
        'browser/gtk/bookmark_tree_model.cc',
        'browser/gtk/bookmark_tree_model.h',
        'browser/gtk/bookmark_utils_gtk.cc',
        'browser/gtk/bookmark_utils_gtk.h',
        'browser/gtk/browser_actions_toolbar_gtk.cc',
        'browser/gtk/browser_actions_toolbar_gtk.h',
        'browser/gtk/browser_titlebar.cc',
        'browser/gtk/browser_titlebar.h',
        'browser/gtk/browser_toolbar_gtk.cc',
        'browser/gtk/browser_toolbar_gtk.h',
        'browser/gtk/browser_window_factory_gtk.cc',
        'browser/gtk/browser_window_gtk.cc',
        'browser/gtk/browser_window_gtk.h',
        'browser/gtk/cairo_cached_surface.cc',
        'browser/gtk/cairo_cached_surface.h',
        'browser/gtk/certificate_manager.cc',
        'browser/gtk/certificate_manager.h',
        'browser/gtk/certificate_dialogs.cc',
        'browser/gtk/certificate_dialogs.h',
        'browser/gtk/certificate_viewer.cc',
        'browser/gtk/certificate_viewer.h',
        'browser/gtk/clear_browsing_data_dialog_gtk.cc',
        'browser/gtk/clear_browsing_data_dialog_gtk.h',
        'browser/gtk/collected_cookies_gtk.cc',
        'browser/gtk/collected_cookies_gtk.h',
        'browser/gtk/constrained_window_gtk.cc',
        'browser/gtk/constrained_window_gtk.h',
        'browser/gtk/content_setting_bubble_gtk.cc',
        'browser/gtk/content_setting_bubble_gtk.h',
        'browser/gtk/gconf_titlebar_listener.cc',
        'browser/gtk/gconf_titlebar_listener.h',
        'browser/gtk/gtk_chrome_cookie_view.cc',
        'browser/gtk/gtk_chrome_cookie_view.h',
        'browser/gtk/create_application_shortcuts_dialog_gtk.cc',
        'browser/gtk/create_application_shortcuts_dialog_gtk.h',
        'browser/gtk/custom_button.cc',
        'browser/gtk/custom_button.h',
        'browser/gtk/custom_drag.cc',
        'browser/gtk/custom_drag.h',
        'browser/gtk/dialogs_gtk.cc',
        'browser/gtk/download_in_progress_dialog_gtk.cc',
        'browser/gtk/download_in_progress_dialog_gtk.h',
        'browser/gtk/download_item_gtk.cc',
        'browser/gtk/download_item_gtk.h',
        'browser/gtk/download_shelf_gtk.cc',
        'browser/gtk/download_shelf_gtk.h',
        'browser/gtk/download_started_animation_gtk.cc',
        'browser/gtk/edit_search_engine_dialog.cc',
        'browser/gtk/edit_search_engine_dialog.h',
        'browser/gtk/extension_infobar_gtk.cc',
        'browser/gtk/extension_infobar_gtk.h',
        'browser/gtk/extension_install_prompt_gtk.cc',
        'browser/gtk/extension_install_prompt2_gtk.cc',
        'browser/gtk/extension_installed_bubble_gtk.cc',
        'browser/gtk/extension_installed_bubble_gtk.h',
        'browser/gtk/extension_view_gtk.cc',
        'browser/gtk/extension_view_gtk.h',
        'browser/gtk/extension_popup_gtk.cc',
        'browser/gtk/extension_popup_gtk.h',
        'browser/gtk/external_protocol_dialog_gtk.cc',
        'browser/gtk/external_protocol_dialog_gtk.h',
        'browser/gtk/find_bar_gtk.cc',
        'browser/gtk/find_bar_gtk.h',
        'browser/gtk/first_run_bubble.cc',
        'browser/gtk/first_run_bubble.h',
        'browser/gtk/first_run_dialog.cc',
        'browser/gtk/first_run_dialog.h',
        'browser/gtk/focus_store_gtk.cc',
        'browser/gtk/focus_store_gtk.h',
        'browser/gtk/fullscreen_exit_bubble_gtk.cc',
        'browser/gtk/fullscreen_exit_bubble_gtk.h',
        'browser/gtk/gtk_chrome_button.cc',
        'browser/gtk/gtk_chrome_button.h',
        'browser/gtk/gtk_chrome_link_button.cc',
        'browser/gtk/gtk_chrome_link_button.h',
        'browser/gtk/gtk_chrome_shrinkable_hbox.cc',
        'browser/gtk/gtk_chrome_shrinkable_hbox.h',
        'browser/gtk/gtk_custom_menu.cc',
        'browser/gtk/gtk_custom_menu.h',
        'browser/gtk/gtk_custom_menu_item.cc',
        'browser/gtk/gtk_custom_menu_item.h',
        'browser/gtk/gtk_expanded_container.cc',
        'browser/gtk/gtk_expanded_container.h',
        'browser/gtk/gtk_floating_container.cc',
        'browser/gtk/gtk_floating_container.h',
        'browser/gtk/gtk_theme_provider.cc',
        'browser/gtk/gtk_theme_provider.h',
        'browser/gtk/gtk_tree.cc',
        'browser/gtk/gtk_tree.h',
        'browser/gtk/gtk_util.cc',
        'browser/gtk/gtk_util.h',
        'browser/gtk/hover_controller_gtk.cc',
        'browser/gtk/hover_controller_gtk.h',
        'browser/gtk/html_dialog_gtk.cc',
        'browser/gtk/html_dialog_gtk.h',
        'browser/gtk/hung_renderer_dialog_gtk.cc',
        'browser/gtk/import_dialog_gtk.cc',
        'browser/gtk/import_dialog_gtk.h',
        'browser/gtk/import_lock_dialog_gtk.cc',
        'browser/gtk/import_lock_dialog_gtk.h',
        'browser/gtk/import_progress_dialog_gtk.cc',
        'browser/gtk/import_progress_dialog_gtk.h',
        'browser/gtk/info_bubble_gtk.cc',
        'browser/gtk/info_bubble_gtk.h',
        'browser/gtk/infobar_container_gtk.cc',
        'browser/gtk/infobar_container_gtk.h',
        'browser/gtk/infobar_gtk.cc',
        'browser/gtk/infobar_gtk.h',
        'browser/gtk/keyword_editor_view.cc',
        'browser/gtk/keyword_editor_view.h',
        'browser/gtk/location_bar_view_gtk.cc',
        'browser/gtk/location_bar_view_gtk.h',
        'browser/gtk/menu_bar_helper.cc',
        'browser/gtk/menu_bar_helper.h',
        'browser/gtk/menu_gtk.cc',
        'browser/gtk/menu_gtk.h',
        'browser/gtk/meta_frames.cc',
        'browser/gtk/meta_frames.h',
        'browser/gtk/nine_box.cc',
        'browser/gtk/nine_box.h',
        'browser/gtk/notifications/balloon_view_gtk.cc',
        'browser/gtk/notifications/balloon_view_gtk.h',
        'browser/gtk/notifications/balloon_view_host_gtk.cc',
        'browser/gtk/notifications/balloon_view_host_gtk.h',
        'browser/gtk/overflow_button.cc',
        'browser/gtk/overflow_button.h',
        'browser/gtk/options/advanced_contents_gtk.cc',
        'browser/gtk/options/advanced_contents_gtk.h',
        'browser/gtk/options/advanced_page_gtk.cc',
        'browser/gtk/options/advanced_page_gtk.h',
        'browser/gtk/options/content_exception_editor.cc',
        'browser/gtk/options/content_exception_editor.h',
        'browser/gtk/options/content_exceptions_window_gtk.cc',
        'browser/gtk/options/content_exceptions_window_gtk.h',
        'browser/gtk/options/content_filter_page_gtk.cc',
        'browser/gtk/options/content_filter_page_gtk.h',
        'browser/gtk/options/content_page_gtk.cc',
        'browser/gtk/options/content_page_gtk.h',
        'browser/gtk/options/content_settings_window_gtk.cc',
        'browser/gtk/options/content_settings_window_gtk.h',
        'browser/gtk/options/cookie_filter_page_gtk.cc',
        'browser/gtk/options/cookie_filter_page_gtk.h',
        'browser/gtk/options/cookies_view.cc',
        'browser/gtk/options/cookies_view.h',
        'browser/gtk/options/fonts_languages_window_gtk.cc',
        'browser/gtk/options/fonts_page_gtk.cc',
        'browser/gtk/options/fonts_page_gtk.h',
        'browser/gtk/options/general_page_gtk.cc',
        'browser/gtk/options/general_page_gtk.h',
        'browser/gtk/options/languages_page_gtk.cc',
        'browser/gtk/options/languages_page_gtk.h',
        'browser/gtk/options/managed_prefs_banner_gtk.cc',
        'browser/gtk/options/managed_prefs_banner_gtk.h',
        'browser/gtk/options/options_layout_gtk.cc',
        'browser/gtk/options/options_layout_gtk.h',
        'browser/gtk/options/options_window_gtk.cc',
        'browser/gtk/options/passwords_exceptions_page_gtk.cc',
        'browser/gtk/options/passwords_exceptions_page_gtk.h',
        'browser/gtk/options/passwords_exceptions_window_gtk.cc',
        'browser/gtk/options/passwords_exceptions_window_gtk.h',
        'browser/gtk/options/passwords_page_gtk.cc',
        'browser/gtk/options/passwords_page_gtk.h',
        'browser/gtk/options/simple_content_exceptions_window.cc',
        'browser/gtk/options/simple_content_exceptions_window.h',
        'browser/gtk/options/url_picker_dialog_gtk.cc',
        'browser/gtk/options/url_picker_dialog_gtk.h',
        'browser/gtk/page_info_window_gtk.cc',
        'browser/gtk/popup_blocked_animation_gtk.cc',
        'browser/gtk/process_singleton_dialog.cc',
        'browser/gtk/process_singleton_dialog.h',
        'browser/gtk/reload_button_gtk.cc',
        'browser/gtk/reload_button_gtk.h',
        'browser/gtk/repost_form_warning_gtk.cc',
        'browser/gtk/repost_form_warning_gtk.h',
        'browser/gtk/rounded_window.cc',
        'browser/gtk/rounded_window.h',
        'browser/gtk/sad_tab_gtk.cc',
        'browser/gtk/sad_tab_gtk.h',
        'browser/gtk/slide_animator_gtk.cc',
        'browser/gtk/slide_animator_gtk.h',
        'browser/gtk/status_bubble_gtk.cc',
        'browser/gtk/status_bubble_gtk.h',
        'browser/gtk/status_icons/status_icon_gtk.h',
        'browser/gtk/status_icons/status_icon_gtk.cc',
        'browser/gtk/status_icons/status_tray_gtk.h',
        'browser/gtk/status_icons/status_tray_gtk.cc',
        'browser/gtk/tab_contents_container_gtk.cc',
        'browser/gtk/tab_contents_container_gtk.h',
        'browser/gtk/tab_contents_drag_source.cc',
        'browser/gtk/tab_contents_drag_source.h',
        'browser/gtk/tabs/dragged_tab_controller_gtk.cc',
        'browser/gtk/tabs/dragged_tab_controller_gtk.h',
        'browser/gtk/tabs/dragged_tab_gtk.cc',
        'browser/gtk/tabs/dragged_tab_gtk.h',
        'browser/gtk/tabs/tab_gtk.cc',
        'browser/gtk/tabs/tab_gtk.h',
        'browser/gtk/tabs/tab_renderer_gtk.cc',
        'browser/gtk/tabs/tab_renderer_gtk.h',
        'browser/gtk/tabs/tab_strip_gtk.cc',
        'browser/gtk/tabs/tab_strip_gtk.h',
        'browser/gtk/task_manager_gtk.cc',
        'browser/gtk/task_manager_gtk.h',
        'browser/gtk/theme_install_bubble_view_gtk.cc',
        'browser/gtk/theme_install_bubble_view_gtk.h',
        'browser/gtk/translate/after_translate_infobar_gtk.cc',
        'browser/gtk/translate/after_translate_infobar_gtk.h',
        'browser/gtk/translate/before_translate_infobar_gtk.cc',
        'browser/gtk/translate/before_translate_infobar_gtk.h',
        'browser/gtk/translate/translate_infobar_base_gtk.cc',
        'browser/gtk/translate/translate_infobar_base_gtk.h',
        'browser/gtk/translate/translate_message_infobar_gtk.cc',
        'browser/gtk/translate/translate_message_infobar_gtk.h',
        'browser/gtk/update_recommended_dialog.cc',
        'browser/gtk/update_recommended_dialog.h',
        'browser/gtk/view_id_util.cc',
        'browser/gtk/view_id_util.h',
        'browser/hang_monitor/hung_plugin_action.cc',
        'browser/hang_monitor/hung_plugin_action.h',
        'browser/hang_monitor/hung_window_detector.cc',
        'browser/hang_monitor/hung_window_detector.h',
        'browser/history/archived_database.cc',
        'browser/history/archived_database.h',
        'browser/history/download_database.cc',
        'browser/history/download_database.h',
        'browser/history/download_types.h',
        'browser/history/expire_history_backend.cc',
        'browser/history/expire_history_backend.h',
        'browser/history/history.cc',
        'browser/history/history.h',
        'browser/history/history_backend.cc',
        'browser/history/history_backend.h',
        'browser/history/history_database.cc',
        'browser/history/history_database.h',
        'browser/history/history_marshaling.h',
        'browser/history/history_notifications.h',
        'browser/history/history_publisher.cc',
        'browser/history/history_publisher.h',
        'browser/history/history_publisher_none.cc',
        'browser/history/history_publisher_win.cc',
        'browser/history/history_types.cc',
        'browser/history/history_types.h',
        'browser/history/in_memory_database.cc',
        'browser/history/in_memory_database.h',
        'browser/history/in_memory_history_backend.cc',
        'browser/history/in_memory_history_backend.h',
        'browser/history/in_memory_url_index.cc',
        'browser/history/in_memory_url_index.h',
        'browser/history/page_usage_data.cc',
        'browser/history/page_usage_data.h',
        'browser/history/query_parser.cc',
        'browser/history/query_parser.h',
        'browser/history/snippet.cc',
        'browser/history/snippet.h',
        'browser/history/starred_url_database.cc',
        'browser/history/starred_url_database.h',
        'browser/history/text_database.cc',
        'browser/history/text_database.h',
        'browser/history/text_database_manager.cc',
        'browser/history/text_database_manager.h',
        'browser/history/thumbnail_database.cc',
        'browser/history/thumbnail_database.h',
        'browser/history/top_sites.cc',
        'browser/history/top_sites_database.cc',
        'browser/history/url_database.cc',
        'browser/history/url_database.h',
        'browser/history/visit_database.cc',
        'browser/history/visit_database.h',
        'browser/history/visit_tracker.cc',
        'browser/history/visit_tracker.h',
        'browser/history/visitsegment_database.cc',
        'browser/history/visitsegment_database.h',
        'browser/host_content_settings_map.cc',
        'browser/host_content_settings_map.h',
        'browser/host_zoom_map.cc',
        'browser/host_zoom_map.h',
        'browser/hung_renderer_dialog.h',
        'browser/icon_loader.h',
        'browser/icon_loader.cc',
        'browser/icon_loader_linux.cc',
        'browser/icon_loader_mac.mm',
        'browser/icon_loader_win.cc',
        'browser/icon_manager.cc',
        'browser/icon_manager.h',
        'browser/icon_manager_linux.cc',
        'browser/icon_manager_mac.mm',
        'browser/icon_manager_win.cc',
        'browser/idle_linux.cc',
        'browser/idle_mac.cc',
        'browser/idle_win.cc',
        'browser/ime_input.cc',
        'browser/ime_input.h',
        'browser/importer/firefox2_importer.cc',
        'browser/importer/firefox2_importer.h',
        'browser/importer/firefox3_importer.cc',
        'browser/importer/firefox3_importer.h',
        'browser/importer/firefox_importer_utils.cc',
        'browser/importer/firefox_importer_utils_linux.cc',
        'browser/importer/firefox_importer_utils_mac.mm',
        'browser/importer/firefox_importer_utils_win.cc',
        'browser/importer/firefox_importer_utils.h',
        'browser/importer/firefox_profile_lock.cc',
        'browser/importer/firefox_profile_lock.h',
        'browser/importer/firefox_profile_lock_posix.cc',
        'browser/importer/firefox_profile_lock_win.cc',
        'browser/importer/firefox_proxy_settings.cc',
        'browser/importer/firefox_proxy_settings.h',
        'browser/importer/ie_importer.cc',
        'browser/importer/ie_importer.h',
        'browser/importer/importer.cc',
        'browser/importer/importer.h',
        'browser/importer/importer_bridge.cc',
        'browser/importer/importer_bridge.h',
        'browser/importer/importer_data_types.h',
        'browser/importer/importer_list.cc',
        'browser/importer/importer_list.h',
        'browser/importer/importer_messages.h',
        'browser/importer/importer_messages_internal.h',
        'browser/importer/mork_reader.cc',
        'browser/importer/mork_reader.h',
        'browser/importer/nss_decryptor.cc',
        'browser/importer/nss_decryptor.h',
        'browser/importer/nss_decryptor_mac.h',
        'browser/importer/nss_decryptor_mac.mm',
        'browser/importer/nss_decryptor_system_nss.cc',
        'browser/importer/nss_decryptor_system_nss.h',
        'browser/importer/nss_decryptor_win.cc',
        'browser/importer/nss_decryptor_win.h',
        'browser/importer/profile_writer.cc',
        'browser/importer/profile_writer.h',
        'browser/importer/safari_importer.h',
        'browser/importer/safari_importer.mm',
        'browser/importer/toolbar_importer.cc',
        'browser/importer/toolbar_importer.h',
        'browser/in_process_webkit/browser_webkitclient_impl.cc',
        'browser/in_process_webkit/browser_webkitclient_impl.h',
        'browser/in_process_webkit/dom_storage_area.cc',
        'browser/in_process_webkit/dom_storage_area.h',
        'browser/in_process_webkit/dom_storage_context.cc',
        'browser/in_process_webkit/dom_storage_context.h',
        'browser/in_process_webkit/dom_storage_dispatcher_host.cc',
        'browser/in_process_webkit/dom_storage_dispatcher_host.h',
        'browser/in_process_webkit/dom_storage_namespace.cc',
        'browser/in_process_webkit/dom_storage_namespace.h',
        'browser/in_process_webkit/dom_storage_permission_request.cc',
        'browser/in_process_webkit/dom_storage_permission_request.h',
        'browser/in_process_webkit/indexed_db_callbacks.h',
        'browser/in_process_webkit/indexed_db_context.cc',
        'browser/in_process_webkit/indexed_db_context.h',
        'browser/in_process_webkit/indexed_db_dispatcher_host.cc',
        'browser/in_process_webkit/indexed_db_dispatcher_host.h',
        'browser/in_process_webkit/webkit_context.cc',
        'browser/in_process_webkit/webkit_context.h',
        'browser/in_process_webkit/webkit_thread.cc',
        'browser/in_process_webkit/webkit_thread.h',
        'browser/input_window_dialog.h',
        'browser/input_window_dialog_gtk.cc',
        'browser/input_window_dialog_win.cc',
        'browser/intranet_redirect_detector.cc',
        'browser/intranet_redirect_detector.h',
        'browser/io_thread.cc',
        'browser/io_thread.h',
        'browser/jankometer_mac.cc',
        'browser/jankometer.cc',
        'browser/jankometer.h',
        'browser/jumplist_win.cc',
        'browser/jumplist_win.h',
        'browser/js_modal_dialog.cc',
        'browser/js_modal_dialog.h',
        'browser/js_modal_dialog_gtk.cc',
        'browser/js_modal_dialog_mac.mm',
        'browser/js_modal_dialog_win.cc',
        'browser/jsmessage_box_client.h',
        'browser/keychain_mac.cc',
        'browser/keychain_mac.h',
        'browser/language_combobox_model.cc',
        'browser/language_combobox_model.h',
        'browser/language_order_table_model.cc',
        'browser/language_order_table_model.h',
        'browser/load_from_memory_cache_details.h',
        'browser/load_notification_details.h',
        'browser/location_bar.h',
        'browser/location_bar_util.cc',
        'browser/location_bar_util.h',
        'browser/login_model.h',
        'browser/login_prompt.cc',
        'browser/login_prompt.h',
        'browser/login_prompt_gtk.cc',
        'browser/login_prompt_mac.h',
        'browser/login_prompt_mac.mm',
        'browser/login_prompt_win.cc',
        'browser/mach_broker_mac.cc',
        'browser/mach_broker_mac.h',
        'browser/managed_prefs_banner_base.cc',
        'browser/managed_prefs_banner_base.h',
        'browser/memory_details.cc',
        'browser/memory_details_linux.cc',
        'browser/memory_details_mac.cc',
        'browser/memory_details_win.cc',
        'browser/memory_details.h',
        'browser/memory_purger.cc',
        'browser/memory_purger.h',
        'browser/message_box_handler.cc',
        'browser/message_box_handler.h',
        'browser/metrics/histogram_synchronizer.cc',
        'browser/metrics/histogram_synchronizer.h',
        'browser/metrics/metric_event_duration_details.h',
        'browser/metrics/metrics_log.cc',
        'browser/metrics/metrics_log.h',
        'browser/metrics/metrics_response.cc',
        'browser/metrics/metrics_response.h',
        'browser/metrics/metrics_service.cc',
        'browser/metrics/metrics_service.h',
        'browser/metrics/user_metrics.cc',
        'browser/metrics/user_metrics.h',
        'browser/modal_html_dialog_delegate.cc',
        'browser/modal_html_dialog_delegate.h',
        'browser/nacl_host/nacl_broker_host_win.cc',
        'browser/nacl_host/nacl_broker_host_win.h',
        'browser/nacl_host/nacl_broker_service_win.cc',
        'browser/nacl_host/nacl_broker_service_win.h',
        'browser/nacl_host/nacl_process_host.cc',
        'browser/nacl_host/nacl_process_host.h',
        'browser/net/browser_url_util.cc',
        'browser/net/browser_url_util.h',
        'browser/net/chrome_cookie_notification_details.h',
        'browser/net/chrome_cookie_policy.cc',
        'browser/net/chrome_cookie_policy.h',
        'browser/net/chrome_net_log.cc',
        'browser/net/chrome_net_log.h',
        'browser/net/chrome_network_delegate.cc',
        'browser/net/chrome_network_delegate.h',
        'browser/net/chrome_url_request_context.cc',
        'browser/net/chrome_url_request_context.h',
        'browser/net/connect_interceptor.cc',
        'browser/net/connect_interceptor.h',
        'browser/net/connection_tester.cc',
        'browser/net/connection_tester.h',
        'browser/net/gaia/token_service.cc',
        'browser/net/gaia/token_service.h',
        'browser/net/load_timing_observer.cc',
        'browser/net/load_timing_observer.h',
        'browser/net/metadata_url_request.cc',
        'browser/net/metadata_url_request.h',
        'browser/net/passive_log_collector.cc',
        'browser/net/passive_log_collector.h',
        'browser/net/preconnect.cc',
        'browser/net/preconnect.h',
        'browser/net/predictor.cc',
        'browser/net/predictor.h',
        'browser/net/predictor_api.cc',
        'browser/net/predictor_api.h',
        'browser/net/referrer.cc',
        'browser/net/referrer.h',
        'browser/net/resolve_proxy_msg_helper.cc',
        'browser/net/resolve_proxy_msg_helper.h',
        'browser/net/sdch_dictionary_fetcher.cc',
        'browser/net/sdch_dictionary_fetcher.h',
        'browser/net/sqlite_persistent_cookie_store.cc',
        'browser/net/sqlite_persistent_cookie_store.h',
        'browser/net/ssl_config_service_manager.h',
        'browser/net/url_fixer_upper.cc',
        'browser/net/url_fixer_upper.h',
        'browser/net/url_info.cc',
        'browser/net/url_info.h',
        'browser/net/url_request_failed_dns_job.cc',
        'browser/net/url_request_failed_dns_job.h',
        # TODO:  These should be moved to test_support (see below), but
        # are currently used by production code in automation_provider.cc.
        'browser/net/url_request_mock_http_job.cc',
        'browser/net/url_request_mock_http_job.h',
        'browser/net/url_request_mock_link_doctor_job.cc',
        'browser/net/url_request_mock_link_doctor_job.h',
        'browser/net/url_request_mock_util.cc',
        'browser/net/url_request_mock_util.h',
        'browser/net/url_request_slow_download_job.cc',
        'browser/net/url_request_slow_download_job.h',
        'browser/net/url_request_slow_http_job.cc',
        'browser/net/url_request_slow_http_job.h',
        'browser/net/url_request_tracking.cc',
        'browser/net/url_request_tracking.h',
        'browser/net/view_http_cache_job_factory.cc',
        'browser/net/view_http_cache_job_factory.h',
        'browser/net/websocket_experiment/websocket_experiment_runner.cc',
        'browser/net/websocket_experiment/websocket_experiment_runner.h',
        'browser/net/websocket_experiment/websocket_experiment_task.cc',
        'browser/net/websocket_experiment/websocket_experiment_task.h',
        'browser/notifications/balloon.cc',
        'browser/notifications/balloon.h',
        'browser/notifications/balloon_host.h',
        'browser/notifications/balloon_host.cc',
        'browser/notifications/balloon_collection.cc',
        'browser/notifications/balloon_collection.h',
        'browser/notifications/balloon_collection_impl.h',
        'browser/notifications/balloon_collection_win.cc',
        'browser/notifications/balloon_collection_mac.mm',
        'browser/notifications/balloon_collection_linux.cc',
        'browser/notifications/desktop_notification_service.cc',
        'browser/notifications/desktop_notification_service.h',
        'browser/notifications/notification.h',
        'browser/notifications/notification_delegate.h',
        'browser/notifications/notification_exceptions_table_model.cc',
        'browser/notifications/notification_exceptions_table_model.h',
        'browser/notifications/notification_object_proxy.cc',
        'browser/notifications/notification_object_proxy.h',
	'browser/notifications/notification_options_menu_model.cc',
	'browser/notifications/notification_options_menu_model.h',
        'browser/notifications/notification_ui_manager.cc',
        'browser/notifications/notification_ui_manager.h',
        'browser/notifications/notifications_prefs_cache.cc',
        'browser/notifications/notifications_prefs_cache.h',
        'browser/ntp_background_util.cc',
        'browser/ntp_background_util.h',
        'browser/omnibox_search_hint.cc',
        'browser/omnibox_search_hint.h',
        'browser/options_page_base.cc',
        'browser/options_page_base.h',
        'browser/options_util.cc',
        'browser/options_util.h',
        'browser/options_window.h',
        'browser/page_info_model.cc',
        'browser/page_info_model.h',
        'browser/page_state.cc',
        'browser/page_state.h',
        'browser/parsers/metadata_parser.h',
        'browser/parsers/metadata_parser_factory.h',
        'browser/parsers/metadata_parser_filebase.cc',
        'browser/parsers/metadata_parser_filebase.h',
        'browser/parsers/metadata_parser_jpeg.cc',
        'browser/parsers/metadata_parser_jpeg.h',
        'browser/parsers/metadata_parser_jpeg_factory.cc',
        'browser/parsers/metadata_parser_jpeg_factory.h',
        'browser/parsers/metadata_parser_manager.cc',
        'browser/parsers/metadata_parser_manager.h',
        'browser/parsers/metadata_parser.cc',
        'browser/password_manager/encryptor.h',
        'browser/password_manager/encryptor_linux.cc',
        'browser/password_manager/encryptor_mac.mm',
        'browser/password_manager/encryptor_win.cc',
        'browser/password_manager/encryptor_password_mac.h',
        'browser/password_manager/encryptor_password_mac.mm',
        'browser/password_manager/ie7_password.cc',
        'browser/password_manager/ie7_password.h',
        'browser/password_manager/login_database.cc',
        'browser/password_manager/login_database.h',
        'browser/password_manager/login_database_mac.cc',
        'browser/password_manager/login_database_posix.cc',
        'browser/password_manager/login_database_win.cc',
        'browser/password_manager/native_backend_gnome_x.cc',
        'browser/password_manager/native_backend_gnome_x.h',
        'browser/password_manager/native_backend_kwallet_x.cc',
        'browser/password_manager/native_backend_kwallet_x.h',
        'browser/password_manager/password_form_manager.cc',
        'browser/password_manager/password_form_manager.h',
        'browser/password_manager/password_manager.cc',
        'browser/password_manager/password_manager.h',
        'browser/password_manager/password_store.cc',
        'browser/password_manager/password_store.h',
        'browser/password_manager/password_store_default.cc',
        'browser/password_manager/password_store_default.h',
        'browser/password_manager/password_store_mac.cc',
        'browser/password_manager/password_store_mac.h',
        'browser/password_manager/password_store_mac_internal.h',
        'browser/password_manager/password_store_win.cc',
        'browser/password_manager/password_store_win.h',
        'browser/password_manager/password_store_x.cc',
        'browser/password_manager/password_store_x.h',
        'browser/platform_util.h',
        'browser/platform_util_linux.cc',
        'browser/platform_util_chromeos.cc',
        'browser/platform_util_common_linux.cc',
        'browser/platform_util_mac.mm',
        'browser/platform_util_win.cc',
        'browser/plugin_installer.cc',
        'browser/plugin_installer.h',
        'browser/plugin_process_host.cc',
        'browser/plugin_process_host.h',
        'browser/plugin_process_host_mac.cc',
        'browser/plugin_service.cc',
        'browser/plugin_service.h',
        'browser/plugin_updater.cc',
        'browser/plugin_updater.h',
        'browser/popup_blocked_animation.h',
        'browser/possible_url_model.cc',
        'browser/possible_url_model.h',
        'browser/power_save_blocker.h',
        'browser/power_save_blocker_common.cc',
        'browser/power_save_blocker_stub.cc',
        'browser/power_save_blocker_win.cc',
        'browser/pref_member.cc',
        'browser/pref_member.h',
        'browser/pref_service.cc',
        'browser/pref_service.h',
        'browser/pref_set_observer.cc',
        'browser/pref_set_observer.h',
        'browser/pref_value_store.cc',
        'browser/pref_value_store.h',
        'browser/preferences_mac.cc',
        'browser/preferences_mac.h',
        'browser/printing/print_dialog_gtk.cc',
        'browser/printing/print_dialog_gtk.h',
        'browser/printing/print_dialog_cloud.cc',
        'browser/printing/print_dialog_cloud.h',
        'browser/printing/print_job.cc',
        'browser/printing/print_job.h',
        'browser/printing/print_job_manager.cc',
        'browser/printing/print_job_manager.h',
        'browser/printing/print_job_worker.cc',
        'browser/printing/print_job_worker.h',
        'browser/printing/print_job_worker_owner.h',
        'browser/printing/print_view_manager.cc',
        'browser/printing/print_view_manager.h',
        'browser/printing/printer_query.cc',
        'browser/printing/printer_query.h',
        'browser/printing/cloud_print/cloud_print_proxy_service.cc',
        'browser/printing/cloud_print/cloud_print_proxy_service.h',
        'browser/process_info_snapshot_mac.cc',
        'browser/process_info_snapshot.h',
        'browser/process_singleton.h',
        'browser/process_singleton_linux.cc',
        'browser/process_singleton_mac.cc',
        'browser/process_singleton_win.cc',
        'browser/profile.cc',
        'browser/profile.h',
        'browser/profile_import_process_host.cc',
        'browser/profile_import_process_host.h',
        'browser/profile_manager.cc',
        'browser/profile_manager.h',
        'browser/remove_rows_table_model.h',
        'browser/renderer_host/async_resource_handler.cc',
        'browser/renderer_host/async_resource_handler.h',
        'browser/renderer_host/audio_renderer_host.cc',
        'browser/renderer_host/audio_renderer_host.h',
        'browser/renderer_host/audio_sync_reader.cc',
        'browser/renderer_host/audio_sync_reader.h',
        'browser/renderer_host/backing_store.cc',
        'browser/renderer_host/backing_store.h',
        'browser/renderer_host/backing_store_manager.cc',
        'browser/renderer_host/backing_store_manager.h',
        'browser/renderer_host/backing_store_mac.h',
        'browser/renderer_host/backing_store_mac.mm',
        'browser/renderer_host/backing_store_proxy.cc',
        'browser/renderer_host/backing_store_proxy.h',
        'browser/renderer_host/backing_store_win.cc',
        'browser/renderer_host/backing_store_win.h',
        'browser/renderer_host/backing_store_x.cc',
        'browser/renderer_host/backing_store_x.h',
        'browser/renderer_host/browser_render_process_host.cc',
        'browser/renderer_host/browser_render_process_host.h',
        'browser/renderer_host/buffered_resource_handler.cc',
        'browser/renderer_host/buffered_resource_handler.h',
        'browser/renderer_host/cross_site_resource_handler.cc',
        'browser/renderer_host/cross_site_resource_handler.h',
        'browser/renderer_host/database_dispatcher_host.cc',
        'browser/renderer_host/database_dispatcher_host.h',
        'browser/renderer_host/database_permission_request.cc',
        'browser/renderer_host/database_permission_request.h',
        'browser/renderer_host/download_resource_handler.cc',
        'browser/renderer_host/download_resource_handler.h',
        'browser/renderer_host/download_throttling_resource_handler.cc',
        'browser/renderer_host/download_throttling_resource_handler.h',
        'browser/renderer_host/global_request_id.h',
        'browser/renderer_host/gpu_view_host.cc',
        'browser/renderer_host/gpu_view_host.h',
        'browser/renderer_host/accelerated_surface_container_mac.cc',
        'browser/renderer_host/accelerated_surface_container_mac.h',
        'browser/renderer_host/accelerated_surface_container_manager_mac.cc',
        'browser/renderer_host/accelerated_surface_container_manager_mac.h',
        'browser/renderer_host/gtk_im_context_wrapper.cc',
        'browser/renderer_host/gtk_im_context_wrapper.h',
        'browser/renderer_host/gtk_key_bindings_handler.cc',
        'browser/renderer_host/gtk_key_bindings_handler.h',
        'browser/renderer_host/offline_resource_handler.cc',
        'browser/renderer_host/offline_resource_handler.h',
        'browser/renderer_host/render_process_host.cc',
        'browser/renderer_host/render_process_host.h',
        'browser/renderer_host/render_sandbox_host_linux.h',
        'browser/renderer_host/render_sandbox_host_linux.cc',
        'browser/renderer_host/render_view_host.cc',
        'browser/renderer_host/render_view_host.h',
        'browser/renderer_host/render_view_host_delegate.cc',
        'browser/renderer_host/render_view_host_delegate.h',
        'browser/renderer_host/render_view_host_factory.cc',
        'browser/renderer_host/render_view_host_factory.h',
        'browser/renderer_host/render_view_host_notification_task.h',
        'browser/renderer_host/render_widget_helper.cc',
        'browser/renderer_host/render_widget_helper.h',
        'browser/renderer_host/render_widget_host.cc',
        'browser/renderer_host/render_widget_host.h',
        'browser/renderer_host/render_widget_host_view.h',
        'browser/renderer_host/render_widget_host_view_gtk.cc',
        'browser/renderer_host/render_widget_host_view_gtk.h',
        'browser/renderer_host/render_widget_host_view_mac.h',
        'browser/renderer_host/render_widget_host_view_mac.mm',
        'browser/renderer_host/render_widget_host_view_win.cc',
        'browser/renderer_host/render_widget_host_view_win.h',
        'browser/renderer_host/resource_dispatcher_host.cc',
        'browser/renderer_host/resource_dispatcher_host.h',
        'browser/renderer_host/resource_dispatcher_host_request_info.cc',
        'browser/renderer_host/resource_dispatcher_host_request_info.h',
        'browser/renderer_host/resource_handler.h',
        'browser/renderer_host/resource_message_filter.cc',
        'browser/renderer_host/resource_message_filter.h',
        'browser/renderer_host/resource_message_filter_gtk.cc',
        'browser/renderer_host/resource_message_filter_mac.mm',
        'browser/renderer_host/resource_message_filter_win.cc',
        'browser/renderer_host/resource_queue.cc',
        'browser/renderer_host/resource_queue.h',
        'browser/renderer_host/resource_request_details.h',
        'browser/renderer_host/safe_browsing_resource_handler.cc',
        'browser/renderer_host/safe_browsing_resource_handler.h',
        'browser/renderer_host/save_file_resource_handler.cc',
        'browser/renderer_host/save_file_resource_handler.h',
        'browser/renderer_host/site_instance.cc',
        'browser/renderer_host/site_instance.h',
        'browser/renderer_host/socket_stream_dispatcher_host.cc',
        'browser/renderer_host/socket_stream_dispatcher_host.h',
        'browser/renderer_host/socket_stream_host.cc',
        'browser/renderer_host/socket_stream_host.h',
        'browser/renderer_host/sync_resource_handler.cc',
        'browser/renderer_host/sync_resource_handler.h',
        'browser/renderer_host/video_layer.cc',
        'browser/renderer_host/video_layer.h',
        'browser/renderer_host/video_layer_proxy.cc',
        'browser/renderer_host/video_layer_proxy.h',
        'browser/renderer_host/video_layer_x.cc',
        'browser/renderer_host/video_layer_x.h',
        'browser/renderer_host/web_cache_manager.cc',
        'browser/renderer_host/web_cache_manager.h',
        'browser/renderer_host/x509_user_cert_resource_handler.cc',
        'browser/renderer_host/x509_user_cert_resource_handler.h',
        'browser/renderer_preferences_util.cc',
        'browser/renderer_preferences_util.h',
        'browser/repost_form_warning_controller.cc',
        'browser/repost_form_warning_controller.h',
        'browser/resources_util.cc',
        'browser/resources_util.h',
        'browser/rlz/rlz.cc',
        'browser/rlz/rlz.h',
        'browser/safe_browsing/bloom_filter.cc',
        'browser/safe_browsing/bloom_filter.h',
        'browser/safe_browsing/chunk_range.cc',
        'browser/safe_browsing/chunk_range.h',
        'browser/safe_browsing/protocol_manager.cc',
        'browser/safe_browsing/protocol_manager.h',
        'browser/safe_browsing/protocol_parser.cc',
        'browser/safe_browsing/protocol_parser.h',
        'browser/safe_browsing/safe_browsing_blocking_page.cc',
        'browser/safe_browsing/safe_browsing_blocking_page.h',
        'browser/safe_browsing/safe_browsing_database.cc',
        'browser/safe_browsing/safe_browsing_database.h',
        'browser/safe_browsing/safe_browsing_database_bloom.cc',
        'browser/safe_browsing/safe_browsing_database_bloom.h',
        'browser/safe_browsing/safe_browsing_service.cc',
        'browser/safe_browsing/safe_browsing_service.h',
        'browser/safe_browsing/safe_browsing_store.cc',
        'browser/safe_browsing/safe_browsing_store.h',
        'browser/safe_browsing/safe_browsing_store_file.cc',
        'browser/safe_browsing/safe_browsing_store_file.h',
        'browser/safe_browsing/safe_browsing_store_sqlite.cc',
        'browser/safe_browsing/safe_browsing_store_sqlite.h',
        'browser/safe_browsing/safe_browsing_util.cc',
        'browser/safe_browsing/safe_browsing_util.h',
        'browser/scoped_pref_update.cc',
        'browser/scoped_pref_update.h',
        'browser/search_engines/edit_search_engine_controller.cc',
        'browser/search_engines/edit_search_engine_controller.h',
        'browser/search_engines/keyword_editor_controller.cc',
        'browser/search_engines/keyword_editor_controller.h',
        'browser/search_engines/template_url.cc',
        'browser/search_engines/template_url.h',
        'browser/search_engines/template_url_fetcher.cc',
        'browser/search_engines/template_url_fetcher.h',
        'browser/search_engines/template_url_model.cc',
        'browser/search_engines/template_url_model.h',
        'browser/search_engines/template_url_parser.cc',
        'browser/search_engines/template_url_parser.h',
        'browser/search_engines/template_url_prepopulate_data.cc',
        'browser/search_engines/template_url_prepopulate_data.h',
        'browser/search_engines/template_url_table_model.cc',
        'browser/search_engines/template_url_table_model.h',
        'browser/search_engines/util.cc',
        'browser/search_engines/util.h',
        'browser/session_startup_pref.cc',
        'browser/session_startup_pref.h',
        'browser/sessions/base_session_service.cc',
        'browser/sessions/base_session_service.h',
        'browser/sessions/session_backend.cc',
        'browser/sessions/session_backend.h',
        'browser/sessions/session_command.cc',
        'browser/sessions/session_command.h',
        'browser/sessions/session_id.cc',
        'browser/sessions/session_id.h',
        'browser/sessions/session_restore.cc',
        'browser/sessions/session_restore.h',
        'browser/sessions/session_service.cc',
        'browser/sessions/session_service.h',
        'browser/sessions/session_types.cc',
        'browser/sessions/session_types.h',
        'browser/sessions/tab_restore_service.cc',
        'browser/sessions/tab_restore_service.h',
        'browser/configuration_policy_provider.cc',
        'browser/configuration_policy_provider.h',
        'browser/shell_dialogs.h',
        'browser/shell_integration.cc',
        'browser/shell_integration.h',
        'browser/shell_integration_mac.mm',
        'browser/shell_integration_linux.cc',
        'browser/shell_integration_win.cc',
        'browser/spellcheck_host.cc',
        'browser/spellcheck_host.h',
        'browser/spellchecker_linux.cc',
        'browser/spellchecker_mac.mm',
        'browser/spellchecker_platform_engine.h',
        'browser/spellchecker_win.cc',
        'browser/ssl/ssl_add_cert_handler.cc',
        'browser/ssl/ssl_add_cert_handler.h',
        'browser/ssl/ssl_add_cert_handler_mac.mm',
        'browser/ssl/ssl_blocking_page.cc',
        'browser/ssl/ssl_blocking_page.h',
        'browser/ssl/ssl_cert_error_handler.cc',
        'browser/ssl/ssl_cert_error_handler.h',
        'browser/ssl/ssl_client_auth_handler.cc',
        'browser/ssl/ssl_client_auth_handler_mac.mm',
        'browser/ssl/ssl_client_auth_handler_win.cc',
        'browser/ssl/ssl_client_auth_handler_gtk.cc',
        'browser/ssl/ssl_client_auth_handler.h',
        'browser/ssl/ssl_error_handler.cc',
        'browser/ssl/ssl_error_handler.h',
        'browser/ssl/ssl_error_info.cc',
        'browser/ssl/ssl_error_info.h',
        'browser/ssl/ssl_host_state.cc',
        'browser/ssl/ssl_host_state.h',
        'browser/ssl/ssl_manager.cc',
        'browser/ssl/ssl_manager.h',
        'browser/ssl/ssl_policy.cc',
        'browser/ssl/ssl_policy.h',
        'browser/ssl/ssl_policy_backend.cc',
        'browser/ssl/ssl_policy_backend.h',
        'browser/ssl/ssl_request_info.h',
        'browser/status_bubble.h',
        'browser/status_icons/status_tray.cc',
        'browser/status_icons/status_tray.h',
        'browser/status_icons/status_tray_manager.cc',
        'browser/status_icons/status_tray_manager.h',
        'browser/status_icons/status_icon.cc',
        'browser/status_icons/status_icon.h',
        'browser/transport_security_persister.cc',
        'browser/transport_security_persister.h',
        'browser/sync/engine/syncapi.h',
        'browser/sync/glue/autofill_change_processor.h',
        'browser/sync/glue/autofill_change_processor.cc',
        'browser/sync/glue/autofill_data_type_controller.cc',
        'browser/sync/glue/autofill_data_type_controller.h',
        'browser/sync/glue/autofill_model_associator.h',
        'browser/sync/glue/autofill_model_associator.cc',
        'browser/sync/glue/bookmark_change_processor.cc',
        'browser/sync/glue/bookmark_change_processor.h',
        'browser/sync/glue/bookmark_data_type_controller.cc',
        'browser/sync/glue/bookmark_data_type_controller.h',
        'browser/sync/glue/bookmark_model_associator.h',
        'browser/sync/glue/bookmark_model_associator.cc',
        'browser/sync/glue/change_processor.cc',
        'browser/sync/glue/change_processor.h',
        'browser/sync/glue/data_type_controller.h',
        'browser/sync/glue/data_type_manager.h',
        'browser/sync/glue/data_type_manager_impl.cc',
        'browser/sync/glue/data_type_manager_impl.h',
        'browser/sync/glue/database_model_worker.cc',
        'browser/sync/glue/database_model_worker.h',
        'browser/sync/glue/extension_change_processor.cc',
        'browser/sync/glue/extension_change_processor.h',
        'browser/sync/glue/extension_data.cc',
        'browser/sync/glue/extension_data.h',
        'browser/sync/glue/extension_data_type_controller.cc',
        'browser/sync/glue/extension_data_type_controller.h',
        'browser/sync/glue/extension_model_associator.cc',
        'browser/sync/glue/extension_model_associator.h',
        'browser/sync/glue/extension_util.cc',
        'browser/sync/glue/extension_util.h',
        'browser/sync/glue/history_model_worker.cc',
        'browser/sync/glue/history_model_worker.h',
        'browser/sync/glue/password_model_worker.cc',
        'browser/sync/glue/password_model_worker.h',
        'browser/sync/glue/http_bridge.cc',
        'browser/sync/glue/http_bridge.h',
        'browser/sync/glue/model_associator.h',
        'browser/sync/glue/password_change_processor.cc',
        'browser/sync/glue/password_change_processor.h',
        'browser/sync/glue/password_data_type_controller.cc',
        'browser/sync/glue/password_data_type_controller.h',
        'browser/sync/glue/password_model_associator.cc',
        'browser/sync/glue/password_model_associator.h',
        'browser/sync/glue/preference_change_processor.cc',
        'browser/sync/glue/preference_change_processor.h',
        'browser/sync/glue/preference_data_type_controller.cc',
        'browser/sync/glue/preference_data_type_controller.h',
        'browser/sync/glue/preference_model_associator.cc',
        'browser/sync/glue/preference_model_associator.h',
        'browser/sync/glue/sync_backend_host.cc',
        'browser/sync/glue/sync_backend_host.h',
        'browser/sync/glue/synchronized_preferences.h',
        'browser/sync/glue/theme_change_processor.cc',
        'browser/sync/glue/theme_change_processor.h',
        'browser/sync/glue/theme_data_type_controller.cc',
        'browser/sync/glue/theme_data_type_controller.h',
        'browser/sync/glue/theme_model_associator.cc',
        'browser/sync/glue/theme_model_associator.h',
        'browser/sync/glue/theme_util.cc',
        'browser/sync/glue/theme_util.h',
        'browser/sync/glue/typed_url_change_processor.cc',
        'browser/sync/glue/typed_url_change_processor.h',
        'browser/sync/glue/typed_url_data_type_controller.cc',
        'browser/sync/glue/typed_url_data_type_controller.h',
        'browser/sync/glue/typed_url_model_associator.cc',
        'browser/sync/glue/typed_url_model_associator.h',
        'browser/sync/glue/ui_model_worker.cc',
        'browser/sync/glue/ui_model_worker.h',
        'browser/sync/notification_method.h',
        'browser/sync/notification_method.cc',
        'browser/sync/profile_sync_service.cc',
        'browser/sync/profile_sync_service.h',
        'browser/sync/profile_sync_factory.h',
        'browser/sync/profile_sync_factory_impl.cc',
        'browser/sync/profile_sync_factory_impl.h',
        'browser/sync/sync_constants.cc',
        'browser/sync/sync_constants.h',
        'browser/sync/sync_setup_flow.cc',
        'browser/sync/sync_setup_flow.h',
        'browser/sync/sync_setup_wizard.cc',
        'browser/sync/sync_setup_wizard.h',
        'browser/sync/sync_ui_util.cc',
        'browser/sync/sync_ui_util.h',
        'browser/sync/sync_ui_util_mac.mm',
        'browser/sync/sync_ui_util_mac.h',
        'browser/tab_closeable_state_watcher.cc',
        'browser/tab_closeable_state_watcher.h',
        'browser/tab_contents/background_contents.cc',
        'browser/tab_contents/background_contents.h',
        'browser/tab_contents/constrained_window.h',
        'browser/tab_contents/infobar_delegate.cc',
        'browser/tab_contents/infobar_delegate.h',
        'browser/tab_contents/interstitial_page.cc',
        'browser/tab_contents/interstitial_page.h',
        'browser/tab_contents/language_state.h',
        'browser/tab_contents/language_state.cc',
        'browser/tab_contents/navigation_controller.cc',
        'browser/tab_contents/navigation_controller.h',
        'browser/tab_contents/navigation_entry.cc',
        'browser/tab_contents/navigation_entry.h',
        'browser/tab_contents/page_navigator.h',
        'browser/tab_contents/provisional_load_details.cc',
        'browser/tab_contents/provisional_load_details.h',
        'browser/tab_contents/render_view_context_menu.cc',
        'browser/tab_contents/render_view_context_menu.h',
        'browser/tab_contents/render_view_context_menu_gtk.cc',
        'browser/tab_contents/render_view_context_menu_gtk.h',
        'browser/tab_contents/render_view_context_menu_mac.mm',
        'browser/tab_contents/render_view_context_menu_mac.h',
        'browser/tab_contents/render_view_host_delegate_helper.cc',
        'browser/tab_contents/render_view_host_delegate_helper.h',
        'browser/tab_contents/render_view_host_manager.cc',
        'browser/tab_contents/render_view_host_manager.h',
        'browser/tab_contents/security_style.h',
        'browser/tab_contents/tab_contents.cc',
        'browser/tab_contents/tab_contents.h',
        'browser/tab_contents/tab_contents_delegate.cc',
        'browser/tab_contents/tab_contents_delegate.h',
        'browser/tab_contents/tab_contents_view.cc',
        'browser/tab_contents/tab_contents_view.h',
        'browser/tab_contents/tab_contents_view_gtk.cc',
        'browser/tab_contents/tab_contents_view_gtk.h',
        'browser/tab_contents/tab_contents_view_mac.h',
        'browser/tab_contents/tab_contents_view_mac.mm',
        'browser/tab_contents/tab_specific_content_settings.h',
        'browser/tab_contents/tab_specific_content_settings.cc',
        'browser/tab_contents/tab_util.cc',
        'browser/tab_contents/tab_util.h',
        'browser/tab_contents/thumbnail_generator.cc',
        'browser/tab_contents/thumbnail_generator.h',
        'browser/tab_contents/web_drag_source_win.cc',
        'browser/tab_contents/web_drag_source_win.h',
        'browser/tab_contents/web_drag_dest_gtk.cc',
        'browser/tab_contents/web_drag_dest_gtk.h',
        'browser/tab_contents/web_drag_utils_win.cc',
        'browser/tab_contents/web_drag_utils_win.h',
        'browser/tab_contents/web_drop_target_win.cc',
        'browser/tab_contents/web_drop_target_win.h',
        'browser/tab_menu_model.cc',
        'browser/tab_menu_model.h',
        'browser/tabs/pinned_tab_codec.cc',
        'browser/tabs/pinned_tab_codec.h',
        'browser/tabs/pinned_tab_service.cc',
        'browser/tabs/pinned_tab_service.h',
        'browser/tabs/tab_strip_model.cc',
        'browser/tabs/tab_strip_model.h',
        'browser/tabs/tab_strip_model_order_controller.cc',
        'browser/tabs/tab_strip_model_order_controller.h',
        'browser/task_manager.cc',
        'browser/task_manager.h',
        'browser/task_manager_resource_providers.cc',
        'browser/task_manager_resource_providers.h',
        'browser/toolbar_model.cc',
        'browser/toolbar_model.h',
        'browser/translate/languages_menu_model.cc',
        'browser/translate/languages_menu_model.h',
        'browser/translate/options_menu_model.cc',
        'browser/translate/options_menu_model.h',
        'browser/translate/translate_infobar_view.h',
        'browser/translate/translate_infobar_delegate.cc',
        'browser/translate/translate_infobar_delegate.h',
        'browser/translate/translate_manager.cc',
        'browser/translate/translate_manager.h',
        'browser/translate/translate_prefs.cc',
        'browser/translate/translate_prefs.h',
        'browser/upgrade_detector.cc',
        'browser/upgrade_detector.h',
        'browser/user_style_sheet_watcher.cc',
        'browser/user_style_sheet_watcher.h',
        'browser/utility_process_host.cc',
        'browser/utility_process_host.h',
        'browser/view_ids.h',
        'browser/views/about_chrome_view.cc',
        'browser/views/about_chrome_view.h',
        'browser/views/about_ipc_dialog.cc',
        'browser/views/about_ipc_dialog.h',
        'browser/views/accelerator_table_gtk.cc',
        'browser/views/accelerator_table_gtk.h',
        'browser/views/accessibility_event_router_views.cc',
        'browser/views/accessibility_event_router_views.h',
        'browser/views/accessible_toolbar_view.cc',
        'browser/views/accessible_toolbar_view.h',
        'browser/views/accessible_view_helper.cc',
        'browser/views/accessible_view_helper.h',
        'browser/views/app_launched_animation_win.cc',
        'browser/views/app_launcher.cc',
        'browser/views/app_launcher.h',
        'browser/views/appcache_info_view.cc',
        'browser/views/appcache_info_view.h',
        'browser/views/autocomplete/autocomplete_popup_contents_view.cc',
        'browser/views/autocomplete/autocomplete_popup_contents_view.h',
        'browser/views/autocomplete/autocomplete_popup_win.cc',
        'browser/views/autocomplete/autocomplete_popup_win.h',
        'browser/views/autocomplete/autocomplete_popup_gtk.cc',
        'browser/views/autocomplete/autocomplete_popup_gtk.h',
        'browser/views/autofill_profiles_view_win.cc',
        'browser/views/autofill_profiles_view_win.h',
        'browser/views/bookmark_bar_instructions_view.cc',
        'browser/views/bookmark_bar_instructions_view.h',
        'browser/views/bookmark_bar_view.cc',
        'browser/views/bookmark_bar_view.h',
        'browser/views/bookmark_bubble_view.cc',
        'browser/views/bookmark_bubble_view.h',
        'browser/views/bookmark_context_menu.cc',
        'browser/views/bookmark_context_menu.h',
        'browser/views/bookmark_context_menu_controller_views.cc',
        'browser/views/bookmark_context_menu_controller_views.h',
        'browser/views/bookmark_editor_view.cc',
        'browser/views/bookmark_editor_view.h',
        'browser/views/bookmark_menu_controller_views.cc',
        'browser/views/bookmark_menu_controller_views.h',
        'browser/views/browser_actions_container.cc',
        'browser/views/browser_actions_container.h',
        'browser/views/browser_bubble.cc',
        'browser/views/browser_bubble.h',
        'browser/views/browser_bubble_gtk.cc',
        'browser/views/browser_bubble_win.cc',
        'browser/views/browser_dialogs.h',
        'browser/views/bubble_border.cc',
        'browser/views/bubble_border.h',
        'browser/views/bug_report_view.cc',
        'browser/views/bug_report_view.h',
        'browser/views/certificate_viewer_win.cc',
        'browser/views/chrome_views_delegate.cc',
        'browser/views/chrome_views_delegate.h',
        'browser/views/clear_browsing_data.cc',
        'browser/views/clear_browsing_data.h',
        'browser/views/collected_cookies_win.cc',
        'browser/views/collected_cookies_win.h',
        'browser/views/confirm_message_box_dialog.cc',
        'browser/views/confirm_message_box_dialog.h',
        'browser/views/constrained_window_win.cc',
        'browser/views/constrained_window_win.h',
        'browser/views/content_blocked_bubble_contents.cc',
        'browser/views/content_blocked_bubble_contents.h',
        'browser/views/cookie_info_view.cc',
        'browser/views/cookie_info_view.h',
        'browser/views/cookie_prompt_view.cc',
        'browser/views/cookie_prompt_view.h',
        'browser/views/create_application_shortcut_view.cc',
        'browser/views/create_application_shortcut_view.h',
        'browser/views/database_info_view.cc',
        'browser/views/database_info_view.h',
        'browser/views/database_open_info_view.cc',
        'browser/views/database_open_info_view.h',
        'browser/views/detachable_toolbar_view.cc',
        'browser/views/detachable_toolbar_view.h',
        'browser/views/dialog_stubs_gtk.cc',
        'browser/views/dom_view.cc',
        'browser/views/dom_view.h',
        'browser/views/download_item_view.cc',
        'browser/views/download_item_view.h',
        'browser/views/download_shelf_view.cc',
        'browser/views/download_shelf_view.h',
        'browser/views/download_started_animation_win.cc',
        'browser/views/dropdown_bar_host.cc',
        'browser/views/dropdown_bar_host.h',
        'browser/views/dropdown_bar_host_gtk.cc',
        'browser/views/dropdown_bar_host_win.cc',
        'browser/views/dropdown_bar_view.h',
        'browser/views/edit_search_engine_dialog.cc',
        'browser/views/edit_search_engine_dialog.h',
        'browser/views/event_utils.cc',
        'browser/views/event_utils.h',
        'browser/views/extensions/browser_action_drag_data.cc',
        'browser/views/extensions/browser_action_drag_data.h',
        'browser/views/extensions/browser_action_overflow_menu_controller.cc',
        'browser/views/extensions/browser_action_overflow_menu_controller.h',
        'browser/views/extensions/extension_install_prompt.cc',
        'browser/views/extensions/extension_install_prompt2.cc',
        'browser/views/extensions/extension_installed_bubble.cc',
        'browser/views/extensions/extension_installed_bubble.h',
        'browser/views/extensions/extension_popup.cc',
        'browser/views/extensions/extension_popup.h',
        'browser/views/extensions/extension_shelf.cc',
        'browser/views/extensions/extension_shelf.h',
        'browser/views/extensions/extension_view.cc',
        'browser/views/extensions/extension_view.h',
        'browser/views/external_protocol_dialog.cc',
        'browser/views/external_protocol_dialog.h',
        'browser/views/find_bar_host.cc',
        'browser/views/find_bar_host.h',
        'browser/views/find_bar_host_gtk.cc',
        'browser/views/find_bar_host_win.cc',
        'browser/views/find_bar_view.cc',
        'browser/views/find_bar_view.h',
        'browser/views/first_run_bubble.cc',
        'browser/views/first_run_bubble.h',
        'browser/views/first_run_search_engine_view.cc',
        'browser/views/first_run_search_engine_view.h',
        'browser/views/frame/app_panel_browser_frame_view.cc',
        'browser/views/frame/app_panel_browser_frame_view.h',
        'browser/views/frame/browser_bubble_host.cc',
        'browser/views/frame/browser_bubble_host.h',
        'browser/views/frame/browser_frame.h',
        'browser/views/frame/browser_frame_gtk.cc',
        'browser/views/frame/browser_frame_gtk.h',
        'browser/views/frame/browser_frame_win.cc',
        'browser/views/frame/browser_frame_win.h',
        'browser/views/frame/browser_non_client_frame_view.h',
        'browser/views/frame/browser_root_view.cc',
        'browser/views/frame/browser_root_view.h',
        'browser/views/frame/browser_view.cc',
        'browser/views/frame/browser_view.h',
        'browser/views/frame/browser_view_layout.cc',
        'browser/views/frame/browser_view_layout.h',
        'browser/views/frame/glass_browser_frame_view.cc',
        'browser/views/frame/glass_browser_frame_view.h',
        'browser/views/frame/opaque_browser_frame_view.cc',
        'browser/views/frame/opaque_browser_frame_view.h',
        'browser/views/fullscreen_exit_bubble.cc',
        'browser/views/fullscreen_exit_bubble.h',
        'browser/views/generic_info_view.cc',
        'browser/views/generic_info_view.h',
        'browser/views/html_dialog_view.cc',
        'browser/views/html_dialog_view.h',
        'browser/views/hung_renderer_view.cc',
        'browser/views/importer_lock_view.cc',
        'browser/views/importer_lock_view.h',
        'browser/views/importer_view.cc',
        'browser/views/importer_view.h',
        'browser/views/importing_progress_view.cc',
        'browser/views/importing_progress_view.h',
        'browser/views/info_bubble.cc',
        'browser/views/info_bubble.h',
        'browser/views/infobars/after_translate_infobar.cc',
        'browser/views/infobars/after_translate_infobar.h',
        'browser/views/infobars/before_translate_infobar.cc',
        'browser/views/infobars/before_translate_infobar.h',
        'browser/views/infobars/extension_infobar.cc',
        'browser/views/infobars/extension_infobar.h',
        'browser/views/infobars/infobar_button_border.cc',
        'browser/views/infobars/infobar_button_border.h',
        'browser/views/infobars/infobar_container.cc',
        'browser/views/infobars/infobar_container.h',
        'browser/views/infobars/infobar_text_button.cc',
        'browser/views/infobars/infobar_text_button.h',
        'browser/views/infobars/infobars.cc',
        'browser/views/infobars/infobars.h',
        'browser/views/infobars/translate_infobar_base.cc',
        'browser/views/infobars/translate_infobar_base.h',
        'browser/views/infobars/translate_message_infobar.cc',
        'browser/views/infobars/translate_message_infobar.h',
        'browser/views/jsmessage_box_dialog.cc',
        'browser/views/jsmessage_box_dialog.h',
        'browser/views/keyword_editor_view.cc',
        'browser/views/keyword_editor_view.h',
        'browser/views/list_background.h',
        'browser/views/local_storage_info_view.cc',
        'browser/views/local_storage_info_view.h',
        'browser/views/local_storage_set_item_info_view.cc',
        'browser/views/local_storage_set_item_info_view.h',
        'browser/views/location_bar/click_handler.cc',
        'browser/views/location_bar/click_handler.h',
        'browser/views/location_bar/content_setting_image_view.cc',
        'browser/views/location_bar/content_setting_image_view.h',
        'browser/views/location_bar/ev_bubble_view.cc',
        'browser/views/location_bar/ev_bubble_view.h',
        'browser/views/location_bar/icon_label_bubble_view.h',
        'browser/views/location_bar/icon_label_bubble_view.cc',
        'browser/views/location_bar/keyword_hint_view.cc',
        'browser/views/location_bar/keyword_hint_view.h',
        'browser/views/location_bar/location_icon_view.cc',
        'browser/views/location_bar/location_icon_view.h',
        'browser/views/location_bar/location_bar_view.cc',
        'browser/views/location_bar/location_bar_view.h',
        'browser/views/location_bar/page_action_image_view.cc',
        'browser/views/location_bar/page_action_image_view.h',
        'browser/views/location_bar/page_action_with_badge_view.cc',
        'browser/views/location_bar/page_action_with_badge_view.h',
        'browser/views/location_bar/selected_keyword_view.h',
        'browser/views/location_bar/selected_keyword_view.cc',
        'browser/views/location_bar/star_view.cc',
        'browser/views/location_bar/star_view.h',
        'browser/views/login_view.cc',
        'browser/views/login_view.h',
        'browser/views/modal_dialog_delegate.cc',
        'browser/views/modal_dialog_delegate.h',
        'browser/views/notifications/balloon_view_host.cc',
        'browser/views/notifications/balloon_view_host.h',
        'browser/views/notifications/balloon_view.cc',
        'browser/views/notifications/balloon_view.h',
        'browser/views/options/advanced_contents_view.cc',
        'browser/views/options/advanced_contents_view.h',
        'browser/views/options/advanced_page_view.cc',
        'browser/views/options/advanced_page_view.h',
        'browser/views/options/content_exceptions_table_view.cc',
        'browser/views/options/content_exceptions_table_view.h',
        'browser/views/options/content_page_view.cc',
        'browser/views/options/content_page_view.h',
        'browser/views/options/content_filter_page_view.cc',
        'browser/views/options/content_filter_page_view.h',
        'browser/views/options/content_settings_window_view.cc',
        'browser/views/options/content_settings_window_view.h',
        'browser/views/options/cookie_filter_page_view.cc',
        'browser/views/options/cookie_filter_page_view.h',
        'browser/views/options/cookies_view.cc',
        'browser/views/options/cookies_view.h',
        'browser/views/options/exception_editor_view.cc',
        'browser/views/options/exception_editor_view.h',
        'browser/views/options/exceptions_view.cc',
        'browser/views/options/exceptions_view.h',
        'browser/views/options/exceptions_page_view.cc',
        'browser/views/options/exceptions_page_view.h',
        'browser/views/options/fonts_languages_window_view.cc',
        'browser/views/options/fonts_languages_window_view.h',
        'browser/views/options/fonts_page_view.cc',
        'browser/views/options/fonts_page_view.h',
        'browser/views/options/general_page_view.cc',
        'browser/views/options/general_page_view.h',
        'browser/views/options/languages_page_view.cc',
        'browser/views/options/languages_page_view.h',
        'browser/views/options/managed_prefs_banner_view.cc',
        'browser/views/options/managed_prefs_banner_view.h',
        'browser/views/options/options_group_view.cc',
        'browser/views/options/options_group_view.h',
        'browser/views/options/options_page_view.cc',
        'browser/views/options/options_page_view.h',
        'browser/views/options/options_window_view.cc',
        'browser/views/options/passwords_exceptions_window_view.cc',
        'browser/views/options/passwords_exceptions_window_view.h',
        'browser/views/options/passwords_page_view.cc',
        'browser/views/options/passwords_page_view.h',
        'browser/views/options/plugin_filter_page_view.cc',
        'browser/views/options/plugin_filter_page_view.h',
        'browser/views/options/simple_content_exceptions_view.cc',
        'browser/views/options/simple_content_exceptions_view.h',
        'browser/views/page_info_window_view.cc',
        'browser/views/pinned_contents_info_bubble.cc',
        'browser/views/pinned_contents_info_bubble.h',
        'browser/views/popup_blocked_animation_win.cc',
        'browser/views/reload_button.cc',
        'browser/views/reload_button.h',
        'browser/views/repost_form_warning_view.cc',
        'browser/views/repost_form_warning_view.h',
        'browser/views/restart_message_box.cc',
        'browser/views/restart_message_box.h',
        'browser/views/sad_tab_view.cc',
        'browser/views/sad_tab_view.h',
        'browser/views/select_file_dialog.cc',
        'browser/views/shell_dialogs_win.cc',
        'browser/views/status_bubble_views.cc',
        'browser/views/status_bubble_views.h',
        'browser/views/status_icons/status_icon_win.cc',
        'browser/views/status_icons/status_icon_win.h',
        'browser/views/status_icons/status_tray_win.cc',
        'browser/views/status_icons/status_tray_win.h',
        'browser/views/tab_icon_view.cc',
        'browser/views/tab_icon_view.h',
        'browser/views/tab_contents/tab_contents_container.cc',
        'browser/views/tab_contents/tab_contents_container.h',
        'browser/views/tab_contents/native_tab_contents_container.h',
        'browser/views/tab_contents/native_tab_contents_container_gtk.cc',
        'browser/views/tab_contents/native_tab_contents_container_gtk.h',
        'browser/views/tab_contents/native_tab_contents_container_win.cc',
        'browser/views/tab_contents/native_tab_contents_container_win.h',
        'browser/views/tab_contents/render_view_context_menu_views.cc',
        'browser/views/tab_contents/render_view_context_menu_views.h',
        'browser/views/tab_contents/tab_contents_drag_win.cc',
        'browser/views/tab_contents/tab_contents_drag_win.h',
        'browser/views/tab_contents/tab_contents_view_gtk.cc',
        'browser/views/tab_contents/tab_contents_view_gtk.h',
        'browser/views/tab_contents/tab_contents_view_win.cc',
        'browser/views/tab_contents/tab_contents_view_win.h',
        'browser/views/tabs/base_tab.cc',
        'browser/views/tabs/base_tab.h',
        'browser/views/tabs/base_tab_strip.cc',
        'browser/views/tabs/base_tab_strip.h',
        'browser/views/tabs/browser_tab_strip_controller.cc',
        'browser/views/tabs/browser_tab_strip_controller.h',
        'browser/views/tabs/dragged_tab_controller.cc',
        'browser/views/tabs/dragged_tab_controller.h',
        'browser/views/tabs/dragged_tab_view.cc',
        'browser/views/tabs/dragged_tab_view.h',
        'browser/views/tabs/native_view_photobooth.h',
        'browser/views/tabs/native_view_photobooth_gtk.cc',
        'browser/views/tabs/native_view_photobooth_gtk.h',
        'browser/views/tabs/native_view_photobooth_win.cc',
        'browser/views/tabs/native_view_photobooth_win.h',
        'browser/views/tabs/side_tab.cc',
        'browser/views/tabs/side_tab.h',
        'browser/views/tabs/side_tab_strip.cc',
        'browser/views/tabs/side_tab_strip.h',
        'browser/views/tabs/tab.cc',
        'browser/views/tabs/tab.h',
        'browser/views/tabs/tab_controller.h',
        'browser/views/tabs/tab_renderer_data.h',
        'browser/views/tabs/tab_strip.cc',
        'browser/views/tabs/tab_strip.h',
        'browser/views/tabs/tab_strip_controller.h',
        'browser/views/task_manager_view.cc',
        'browser/views/theme_background.cc',
        'browser/views/theme_background.h',
        'browser/views/theme_helpers.cc',
        'browser/views/theme_helpers.h',
        'browser/views/theme_install_bubble_view.cc',
        'browser/views/theme_install_bubble_view.h',
        'browser/views/toolbar_view.cc',
        'browser/views/toolbar_view.h',
        'browser/views/uninstall_view.cc',
        'browser/views/uninstall_view.h',
        'browser/views/url_picker.cc',
        'browser/views/url_picker.h',
        'browser/views/unhandled_keyboard_event_handler.cc',
        'browser/views/unhandled_keyboard_event_handler.h',
        'browser/views/update_recommended_message_box.cc',
        'browser/views/update_recommended_message_box.h',
        'browser/views/user_data_dir_dialog.cc',
        'browser/views/user_data_dir_dialog.h',
        'browser/views/wrench_menu.cc',
        'browser/views/wrench_menu.h',
        'browser/visitedlink_master.cc',
        'browser/visitedlink_master.h',
        'browser/visitedlink_event_listener.cc',
        'browser/visitedlink_event_listener.h',
        'browser/webdata/autofill_change.h',
        'browser/webdata/autofill_entry.cc',
        'browser/webdata/autofill_entry.h',
        'browser/webdata/web_data_service.cc',
        'browser/webdata/web_data_service.h',
        'browser/webdata/web_data_service_win.cc',
        'browser/webdata/web_database.cc',
        'browser/webdata/web_database.h',
        'browser/webdata/web_database_win.cc',
        'browser/web_applications/web_app.cc',
        'browser/web_applications/web_app.h',
        'browser/web_resource/web_resource_service.h',
        'browser/web_resource/web_resource_service.cc',
        'browser/window_sizer.cc',
        'browser/window_sizer.h',
        'browser/window_sizer_mac.mm',
        'browser/window_sizer_linux.cc',
        'browser/window_sizer_win.cc',
        'browser/worker_host/message_port_dispatcher.cc',
        'browser/worker_host/message_port_dispatcher.h',
        'browser/worker_host/worker_document_set.cc',
        'browser/worker_host/worker_document_set.h',
        'browser/worker_host/worker_process_host.cc',
        'browser/worker_host/worker_process_host.h',
        'browser/worker_host/worker_service.cc',
        'browser/worker_host/worker_service.h',
        'browser/wrench_menu_model.cc',
        'browser/wrench_menu_model.h',
        'browser/zygote_host_linux.cc',
        'browser/zygote_main_linux.cc',

        # These files are generated by GRIT.
        '<(grit_out_dir)/grit/bookmark_manager_resources_map.cc',
        '<(grit_out_dir)/grit/shared_resources_map.cc',
        '<(grit_out_dir)/grit/theme_resources_map.cc',
      ],
      'conditions': [
        ['javascript_engine=="v8"', {
          'defines': [
            'CHROME_V8',
          ],
        }],
        ['chromeos==0', {
          'sources/': [
            ['exclude', '^browser/chromeos'],
            ['exclude', 'browser/dom_ui/filebrowse_ui.cc'],
            ['exclude', 'browser/dom_ui/mediaplayer_ui.cc'],
            ['exclude', 'browser/dom_ui/slideshow_ui.cc'],
            ['exclude', 'browser/renderer_host/offline_resource_handler.cc'],
            ['exclude', 'browser/renderer_host/offline_resource_handler.h'],
          ],
        }],
        ['chromeos==1', {
          'sources!': [
            'browser/password_manager/native_backend_gnome_x.h',
            'browser/password_manager/native_backend_gnome_x.cc',
            'browser/password_manager/native_backend_kwallet_x.h',
            'browser/password_manager/native_backend_kwallet_x.cc',
            'browser/platform_util_linux.cc',
          ],
          'link_settings': {
            'libraries': [
              '-lpulse',
            ],
          },
        }],
        ['touchui==0', {
          'sources!': [
            # Nothing yet.
          ],
        }],
        ['OS=="linux"', {
          'dependencies': [
            '../build/linux/system.gyp:dbus-glib',
            '../build/linux/system.gyp:gconf',
            '../build/linux/system.gyp:gtk',
            '../build/linux/system.gyp:gtkprint',
            '../build/linux/system.gyp:nss',
          ],
          'link_settings': {
            'libraries': [
              # For dlsym() in 'browser/zygote_main_linux.cc'
              '-ldl',
            ],
          },
          'sources!': [
             # Exclude extension shelf for toolstrips.
            'browser/views/extensions/extension_shelf.cc',
            'browser/views/extensions/extension_shelf.h',
            'browser/views/extensions/extension_view.cc',
            'browser/views/extensions/extension_view.h',
          ],
          'sources': [
            'browser/crash_handler_host_linux.h',
            'browser/net/ssl_config_service_manager_pref.cc',
            'third_party/mozilla_security_manager/nsNSSCertHelper.cpp',
            'third_party/mozilla_security_manager/nsNSSCertHelper.h',
            'third_party/mozilla_security_manager/nsNSSCertificate.cpp',
            'third_party/mozilla_security_manager/nsNSSCertificate.h',
            'third_party/mozilla_security_manager/nsNSSCertTrust.cpp',
            'third_party/mozilla_security_manager/nsNSSCertTrust.h',
            'third_party/mozilla_security_manager/nsUsageArrayHelper.cpp',
            'third_party/mozilla_security_manager/nsUsageArrayHelper.h',
          ],
          'conditions': [
            ['chromeos==0', {
              'dependencies': [
                '../build/linux/system.gyp:gnome-keyring',
              ],
            }],
            ['linux_breakpad==1', {
              'sources': [
                'app/breakpad_linux.cc',
                'app/breakpad_linux.h',
                'browser/crash_handler_host_linux.cc',
              ],
              'dependencies': [
                '../breakpad/breakpad.gyp:breakpad_client',
              ],
              'include_dirs': [
                # breakpad_linux.cc wants file_version_info_linux.h
                '<(SHARED_INTERMEDIATE_DIR)',
                '../breakpad/src',
              ],
            }, {  # linux_breakpad==0
              'sources': [
                'browser/crash_handler_host_linux_stub.cc',
              ],
            }],
          ],
        }, {  # OS != "linux"
          'sources!': [
            'browser/file_watcher_inotify.cc',
          ],
        }],
        ['OS=="freebsd" or OS=="openbsd"', {
          'dependencies': [
            '../build/linux/system.gyp:gtk',
            '../build/linux/system.gyp:gtkprint',
            '../build/linux/system.gyp:nss',
          ],
          'sources': [
            'browser/file_watcher_stub.cc',
          ],
        }],
        ['OS=="mac"', {
          'sources!': [
            'browser/automation/automation_provider_list_generic.cc',
            'browser/bookmarks/bookmark_context_menu.cc',
            'browser/bookmarks/bookmark_drop_info.cc',
            'browser/browser_list_stub.cc',
            'browser/dock_info.cc',
            'browser/importer/nss_decryptor_system_nss.cc',
            'browser/importer/nss_decryptor_system_nss.h',
            'browser/jankometer.cc',
            'browser/password_manager/login_database_posix.cc',
            'browser/renderer_host/backing_store_proxy.cc',
            'browser/renderer_host/backing_store_proxy.h',
            'browser/renderer_host/gpu_view_host.cc',
            'browser/renderer_host/gpu_view_host.h',
            'browser/renderer_host/video_layer_proxy.cc',
            'browser/renderer_host/video_layer_proxy.h',
            'browser/views/extensions/extension_shelf.cc',
            'browser/views/extensions/extension_shelf.h',
            'browser/views/extensions/extension_view.cc',
            'browser/views/extensions/extension_view.h',
          ],
          'sources': [
            'browser/net/ssl_config_service_manager_system.cc',
            # Build Apple sample code
            '../third_party/apple/ImageAndTextCell.h',
            '../third_party/apple/ImageAndTextCell.m',
            # Build the necessary GTM sources
            '../third_party/GTM/AppKit/GTMFadeTruncatingTextFieldCell.h',
            '../third_party/GTM/AppKit/GTMFadeTruncatingTextFieldCell.m',
            '../third_party/GTM/AppKit/GTMIBArray.h',
            '../third_party/GTM/AppKit/GTMIBArray.m',
            '../third_party/GTM/AppKit/GTMNSBezierPath+CGPath.h',
            '../third_party/GTM/AppKit/GTMNSBezierPath+CGPath.m',
            '../third_party/GTM/AppKit/GTMNSBezierPath+RoundRect.m',
            '../third_party/GTM/AppKit/GTMNSColor+Luminance.m',
            '../third_party/GTM/AppKit/GTMUILocalizer.h',
            '../third_party/GTM/AppKit/GTMUILocalizer.m',
            '../third_party/GTM/AppKit/GTMUILocalizerAndLayoutTweaker.h',
            '../third_party/GTM/AppKit/GTMUILocalizerAndLayoutTweaker.m',
            '../third_party/GTM/AppKit/GTMWindowSheetController.m',
            '../third_party/GTM/AppKit/GTMNSAnimation+Duration.m',
            '../third_party/GTM/AppKit/GTMNSAnimation+Duration.h',
            '../third_party/GTM/Foundation/GTMNSNumber+64Bit.h',
            '../third_party/GTM/Foundation/GTMNSNumber+64Bit.m',
            '../third_party/GTM/Foundation/GTMNSObject+KeyValueObserving.h',
            '../third_party/GTM/Foundation/GTMNSObject+KeyValueObserving.m',
            # MolokoCacao additions
            '../third_party/molokocacao/NSBezierPath+MCAdditions.h',
            '../third_party/molokocacao/NSBezierPath+MCAdditions.m',
            # Build necessary Mozilla sources
            '../third_party/mozilla/NSPasteboard+Utils.h',
            '../third_party/mozilla/NSPasteboard+Utils.mm',
            '../third_party/mozilla/NSScreen+Utils.h',
            '../third_party/mozilla/NSScreen+Utils.m',
            '../third_party/mozilla/NSString+Utils.h',
            '../third_party/mozilla/NSString+Utils.mm',
            '../third_party/mozilla/NSURL+Utils.h',
            '../third_party/mozilla/NSURL+Utils.m',
            '../third_party/mozilla/NSWorkspace+Utils.h',
            '../third_party/mozilla/NSWorkspace+Utils.m',
            # Headers so that IB can find classes it needs to resolve classes
            # in XIB files.
            '../base/chrome_application_mac.h',
          ],
          'include_dirs': [
            '../third_party/apple',
            '../third_party/GTM',
            '../third_party/GTM/AppKit',
            '../third_party/GTM/Foundation',
            '../third_party/GTM/DebugUtils',
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/AddressBook.framework',
              '$(SDKROOT)/System/Library/Frameworks/SecurityInterface.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
              '$(SDKROOT)/System/Library/Frameworks/OpenGL.framework',
            ],
            'mac_bundle_resources': [
              'browser/nacl_loader.sb',
              'browser/utility.sb',
              'browser/worker.sb',
            ],
          },
          'actions': [
            {
              # This action is used to extract the localization data from xib
              # files and generate table for the ui localizer from it.
              'variables': {
                'xib_localizer_tool_path':
                    'tools/build/mac/generate_localizer',
                'xib_files_to_scan': [
                  # The xibs that need localization
                  'app/nibs/About.xib',
                  'app/nibs/AutoFillAddressSheet.xib',
                  'app/nibs/AutoFillCreditCardSheet.xib',
                  'app/nibs/AutoFillDialog.xib',
                  'app/nibs/BookmarkAllTabs.xib',
                  'app/nibs/BookmarkBar.xib',
                  'app/nibs/BookmarkBubble.xib',
                  'app/nibs/BookmarkEditor.xib',
                  'app/nibs/BookmarkNameFolder.xib',
                  'app/nibs/ClearBrowsingData.xib',
                  'app/nibs/CollectedCookies.xib',
                  'app/nibs/Cookies.xib',
                  'app/nibs/CookieDetailsView.xib',
                  'app/nibs/CookiePrompt.xib',
                  'app/nibs/ContentBlockedCookies.xib',
                  'app/nibs/ContentBlockedImages.xib',
                  'app/nibs/ContentBlockedJavaScript.xib',
                  'app/nibs/ContentBlockedPlugins.xib',
                  'app/nibs/ContentBlockedPopups.xib',
                  'app/nibs/ContentBubbleGeolocation.xib',
                  'app/nibs/ContentExceptionsWindow.xib',
                  'app/nibs/ContentSettings.xib',
                  'app/nibs/DownloadItem.xib',
                  'app/nibs/DownloadShelf.xib',
                  'app/nibs/EditSearchEngine.xib',
                  'app/nibs/ExtensionInstalledBubble.xib',
                  'app/nibs/ExtensionInstallPrompt.xib',
                  'app/nibs/ExtensionInstallPromptNoWarnings.xib',
                  'app/nibs/FirstRunBubble.xib',
                  'app/nibs/FirstRunDialog.xib',
                  'app/nibs/FontLanguageSettings.xib',
                  'app/nibs/HttpAuthLoginSheet.xib',
                  'app/nibs/HungRendererDialog.xib',
                  'app/nibs/ImportSettingsDialog.xib',
                  'app/nibs/ImportProgressDialog.xib',
                  'app/nibs/KeywordEditor.xib',
                  'app/nibs/MainMenu.xib',
                  'app/nibs/Notification.xib',
                  'app/nibs/Preferences.xib',
                  'app/nibs/ReportBug.xib',
                  'app/nibs/SadTab.xib',
                  'app/nibs/SaveAccessoryView.xib',
                  'app/nibs/SimpleContentExceptionsWindow.xib',
                  'app/nibs/TaskManager.xib',
                  'app/nibs/Toolbar.xib',
                ],
              },
              'action_name': 'Process xibs for localization',
              'inputs': [
                '<(xib_localizer_tool_path)',
                '<@(xib_files_to_scan)',
              ],
              'outputs': [
                '<(INTERMEDIATE_DIR)/ui_localizer_table.h',
              ],
              'action': ['<(xib_localizer_tool_path)',
                          '<@(_outputs)',
                          '<@(xib_files_to_scan)'],
            },
          ],
        }],
        ['OS=="win"', {
          'defines': [
            '__STD_C',
            '_CRT_SECURE_NO_DEPRECATE',
            '_SCL_SECURE_NO_DEPRECATE',
          ],
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'dependencies': [
            '../gears/gears.gyp:gears',
            '../google_update/google_update.gyp:google_update',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../views/views.gyp:views',
            '../rlz/rlz.gyp:rlz_lib',
          ],
          'export_dependent_settings': [
            '../views/views.gyp:views',
          ],
          'sources': [
            'browser/net/ssl_config_service_manager_system.cc',
            # Using built-in rule in vstudio for midl.
            'browser/history/history_indexer.idl',
          ],
          'sources!': [
            'browser/browser_list_stub.cc',
            'browser/history/history_publisher_none.cc',
            'browser/importer/nss_decryptor_system_nss.cc',
            'browser/importer/nss_decryptor_system_nss.h',
            'browser/power_save_blocker_stub.cc',
            'browser/views/select_file_dialog.cc',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
        }, {  # 'OS!="win"
          'sources/': [
            # Exclude all of hang_monitor.
            ['exclude', '^browser/hang_monitor/'],

            # Exclude parts of password_manager.
            ['exclude', '^browser/password_manager/ie7_password\\.cc$'],

            # Exclude all of rlz.
            ['exclude', '^browser/rlz/'],
            ['exclude', '^browser/extensions/extension_rlz_module'],

            # Exclude all of views.
            ['exclude', '^browser/views/'],
          ],
          'conditions': [
            ['OS=="linux" and toolkit_views==1',{
              'dependencies': [
                '../views/views.gyp:views',
              ],
              'include_dirs': [
                '<(INTERMEDIATE_DIR)',
                '<(INTERMEDIATE_DIR)/chrome',
              ],
              'sources/': [
                ['exclude', '^browser/cookie_modal_dialog_views.cc'],
                ['include', '^browser/back_forward_menu_model_views.cc'],
                ['include', '^browser/back_forward_menu_model_views.h'],
                ['include', '^browser/dock_info_gtk.cc'],
                ['include', '^browser/dock_info.cc'],
                ['include', '^browser/dock_info.h'],
                ['include', '^browser/extensions/'],
                # This exclude duplicates the one just above because of the
                # order of evaluation of the 'sources/' rule above, the
                # conditions, and this 'sources/' rule.
                ['exclude', '^browser/extensions/extension_rlz_module'],
                ['include', 'browser/printing/print_dialog_cloud.cc'],
                ['include', 'browser/printing/print_dialog_cloud.h'],
                ['include', '^browser/views/about_chrome_view.cc'],
                ['include', '^browser/views/about_chrome_view.h'],
                ['include', '^browser/views/accelerator_table_gtk.cc'],
                ['include', '^browser/views/accelerator_table_gtk.h'],
                ['include', '^browser/views/accessibility_event_router_views.cc'],
                ['include', '^browser/views/accessibility_event_router_views.h'],
                ['include', '^browser/views/accessible_toolbar_view.cc'],
                ['include', '^browser/views/accessible_toolbar_view.h'],
                ['include', '^browser/views/accessible_view_helper.cc'],
                ['include', '^browser/views/accessible_view_helper.h'],
                ['include', '^browser/views/app_launcher.cc'],
                ['include', '^browser/views/app_launcher.cc'],
                ['include', '^browser/views/app_launcher.h'],
                ['include', '^browser/views/app_launcher.h'],
                ['include', '^browser/views/autocomplete/autocomplete_popup_contents_view.cc'],
                ['include', '^browser/views/autocomplete/autocomplete_popup_contents_view.h'],
                ['include', '^browser/views/autocomplete/autocomplete_popup_gtk.cc'],
                ['include', '^browser/views/autocomplete/autocomplete_popup_gtk.h'],
                ['include', '^browser/views/bookmark_bar_instructions_view.cc'],
                ['include', '^browser/views/bookmark_bar_instructions_view.h'],
                ['include', '^browser/views/bookmark_bar_view.cc'],
                ['include', '^browser/views/bookmark_bar_view.h'],
                ['include', '^browser/views/bookmark_bubble_view.cc'],
                ['include', '^browser/views/bookmark_bubble_view.h'],
                ['include', '^browser/views/bookmark_context_menu.cc'],
                ['include', '^browser/views/bookmark_context_menu.h'],
                ['include', '^browser/views/bookmark_context_menu_controller_views.cc'],
                ['include', '^browser/views/bookmark_context_menu_controller_views.h'],
                ['include', '^browser/views/bookmark_menu_controller_views.cc'],
                ['include', '^browser/views/browser_actions_container.cc'],
                ['include', '^browser/views/browser_actions_container.h'],
                ['include', '^browser/views/browser_bubble_gtk.cc'],
                ['include', '^browser/views/browser_bubble.cc'],
                ['include', '^browser/views/browser_bubble.h'],
                ['include', '^browser/views/bubble_border.cc'],
                ['include', '^browser/views/bubble_border.h'],
                ['include', '^browser/views/bug_report_view.cc'],
                ['include', '^browser/views/bug_report_view.h'],
                ['include', '^browser/views/chrome_views_delegate.cc'],
                ['include', '^browser/views/clear_browsing_data.cc'],
                ['include', '^browser/views/clear_browsing_data.h'],
                ['include', '^browser/views/content_blocked_bubble_contents.cc'],
                ['include', '^browser/views/content_blocked_bubble_contents.h'],
                ['include', '^browser/views/create_application_shortcut_view.cc'],
                ['include', '^browser/views/create_application_shortcut_view.h'],
                ['include', '^browser/views/detachable_toolbar_view.h'],
                ['include', '^browser/views/detachable_toolbar_view.cc'],
                ['include', '^browser/views/dialog_stubs_gtk.cc'],
                ['include', '^browser/views/dom_view.cc'],
                ['include', '^browser/views/dom_view.h'],
                ['include', '^browser/views/download_item_view.cc'],
                ['include', '^browser/views/download_item_view.h'],
                ['include', '^browser/views/download_shelf_view.cc'],
                ['include', '^browser/views/download_shelf_view.h'],
                ['include', '^browser/views/dragged_tab_controller.cc'],
                ['include', '^browser/views/dragged_tab_controller.h'],
                ['include', '^browser/views/dropdown_bar_host.cc'],
                ['include', '^browser/views/dropdown_bar_host.h'],
                ['include', '^browser/views/dropdown_bar_host_gtk.cc'],
                ['include', '^browser/views/dropdown_bar_view.h'],
                ['include', '^browser/views/event_utils.cc'],
                ['include', '^browser/views/event_utils.h'],
                ['include', '^browser/views/extensions/browser_action_drag_data.cc'],
                ['include', '^browser/views/extensions/browser_action_drag_data.h'],
                ['include', '^browser/views/extensions/browser_action_overflow_menu_controller.cc'],
                ['include', '^browser/views/extensions/browser_action_overflow_menu_controller.h'],
                ['include', '^browser/views/extensions/extension_install_prompt.cc'],
                ['include', '^browser/views/extensions/extension_install_prompt2.cc'],
                ['include', '^browser/views/extensions/extension_installed_bubble.cc'],
                ['include', '^browser/views/extensions/extension_installed_bubble.h'],
                ['include', '^browser/views/extensions/extension_popup.cc'],
                ['include', '^browser/views/extensions/extension_popup.h'],
                ['include', '^browser/views/extensions/extension_shelf.cc'],
                ['include', '^browser/views/extensions/extension_shelf.h'],
                ['include', '^browser/views/extensions/extension_view.cc'],
                ['include', '^browser/views/extensions/extension_view.h'],
                ['include', '^browser/views/extension_view.cc'],
                ['include', '^browser/views/extension_view.h'],
                ['include', '^browser/views/find_bar_view.cc'],
                ['include', '^browser/views/find_bar_view.h'],
                ['include', '^browser/views/find_bar_host_gtk.cc'],
                ['include', '^browser/views/find_bar_host.cc'],
                ['include', '^browser/views/find_bar_host.h'],
                ['include', '^browser/views/fullscreen_exit_bubble.cc'],
                ['include', '^browser/views/fullscreen_exit_bubble.h'],
                ['include', '^browser/views/html_dialog_view.cc'],
                ['include', '^browser/views/html_dialog_view.h'],
                ['include', '^browser/views/theme_install_bubble_view.cc'],
                ['include', '^browser/views/theme_install_bubble_view.h'],
                ['include', '^browser/views/frame/browser_bubble_host.cc'],
                ['include', '^browser/views/frame/browser_bubble_host.h'],
                ['include', '^browser/views/frame/browser_view_layout.cc'],
                ['include', '^browser/views/frame/browser_view_layout.h'],
                ['include', '^browser/views/frame/browser_view.cc'],
                ['include', '^browser/views/frame/browser_view.h'],
                ['include', '^browser/views/frame/browser_frame_gtk.cc'],
                ['include', '^browser/views/frame/browser_frame_gtk.h'],
                ['include', '^browser/views/frame/browser_root_view.cc'],
                ['include', '^browser/views/frame/browser_root_view.h'],
                ['include', '^browser/views/frame/opaque_browser_frame_view.cc'],
                ['include', '^browser/views/frame/opaque_browser_frame_view.h'],
                ['include', '^browser/views/infobars/*'],
                ['include', '^browser/views/info_bubble.cc'],
                ['include', '^browser/views/info_bubble.h'],
                ['include', '^browser/views/html_dialog_view.cc'],
                ['include', '^browser/views/html_dialog_view.h'],
                ['include', '^browser/views/location_bar/click_handler.cc'],
                ['include', '^browser/views/location_bar/click_handler.h'],
                ['include', '^browser/views/location_bar/content_setting_image_view.cc'],
                ['include', '^browser/views/location_bar/content_setting_image_view.h'],
                ['include', '^browser/views/location_bar/ev_bubble_view.cc'],
                ['include', '^browser/views/location_bar/ev_bubble_view.h'],
                ['include', '^browser/views/location_bar/icon_label_bubble_view.h'],
                ['include', '^browser/views/location_bar/icon_label_bubble_view.cc'],
                ['include', '^browser/views/location_bar/keyword_hint_view.cc'],
                ['include', '^browser/views/location_bar/keyword_hint_view.h'],
                ['include', '^browser/views/location_bar/location_icon_view.cc'],
                ['include', '^browser/views/location_bar/location_icon_view.h'],
                ['include', '^browser/views/location_bar/location_bar_view.cc'],
                ['include', '^browser/views/location_bar/location_bar_view.h'],
                ['include', '^browser/views/location_bar/page_action_image_view.cc'],
                ['include', '^browser/views/location_bar/page_action_image_view.h'],
                ['include', '^browser/views/location_bar/page_action_with_badge_view.h'],
                ['include', '^browser/views/location_bar/page_action_with_badge_view.cc'],
                ['include', '^browser/views/location_bar/selected_keyword_view.h'],
                ['include', '^browser/views/location_bar/selected_keyword_view.cc'],
                ['include', '^browser/views/location_bar/star_view.cc'],
                ['include', '^browser/views/location_bar/star_view.h'],
                ['include', '^browser/views/location_bar_view.cc'],
                ['include', '^browser/views/location_bar_view.h'],
                ['include', '^browser/views/modal_dialog_delegate.cc'],
                ['include', '^browser/views/modal_dialog_delegate.h'],
                ['include', '^browser/views/notifications/balloon_view_host.cc'],
                ['include', '^browser/views/notifications/balloon_view_host.h'],
                ['include', '^browser/views/options/options_page_view.cc'],
                ['include', '^browser/views/options/options_page_view.h'],
                ['include', '^browser/views/page_info_window_view.cc'],
                ['include', '^browser/views/panel_controller.cc'],
                ['include', '^browser/views/panel_controller.h'],
                ['include', '^browser/views/panels/panel_container.cc'],
                ['include', '^browser/views/panels/panel_container.h'],
                ['include', '^browser/views/panels/panel_scroller.cc'],
                ['include', '^browser/views/panels/panel_scroller.h'],
                # Not necessary unless you're trying to build ChromeOS+views.
                #['include', '^browser/views/panels/panel_scroller_container.cc'],
                #['include', '^browser/views/panels/panel_scroller_container.h'],
                ['include', '^browser/views/panels/panel_scroller_header.cc'],
                ['include', '^browser/views/panels/panel_scroller_header.h'],
                ['include', '^browser/views/pinned_contents_info_bubble.cc'],
                ['include', '^browser/views/pinned_contents_info_bubble.h'],
                ['include', '^browser/views/reload_button.cc'],
                ['include', '^browser/views/reload_button.h'],
                ['include', '^browser/views/restart_message_box.cc'],
                ['include', '^browser/views/restart_message_box.h'],
                ['include', '^browser/views/sad_tab_view.cc'],
                ['include', '^browser/views/sad_tab_view.h'],
                ['include', '^browser/views/select_file_dialog.cc'],
                ['include', '^browser/views/status_bubble_views.cc'],
                ['include', '^browser/views/status_bubble_views.h'],
                ['include', '^browser/views/tab_contents/native_tab_contents_container_gtk.cc'],
                ['include', '^browser/views/tab_contents/native_tab_contents_container_gtk.h'],
                ['include', '^browser/views/tab_contents/render_view_context_menu_views.cc'],
                ['include', '^browser/views/tab_contents/render_view_context_menu_views.h'],
                ['include', '^browser/views/tab_contents/tab_contents_container.cc'],
                ['include', '^browser/views/tab_contents/tab_contents_container.h'],
                ['include', '^browser/views/tab_contents/tab_contents_view_gtk.cc'],
                ['include', '^browser/views/tab_contents/tab_contents_view_gtk.h'],
                ['include', '^browser/views/tab_icon_view.cc'],
                ['include', '^browser/views/tab_icon_view.h'],
                ['include', '^browser/views/tabs/base_tab.cc'],
                ['include', '^browser/views/tabs/base_tab.h'],
                ['include', '^browser/views/tabs/base_tab_strip.cc'],
                ['include', '^browser/views/tabs/base_tab_strip.h'],
                ['include', '^browser/views/tabs/browser_tab_strip_controller.cc'],
                ['include', '^browser/views/tabs/browser_tab_strip_controller.h'],
                ['include', '^browser/views/tabs/browser_tab_strip.cc'],
                ['include', '^browser/views/tabs/browser_tab_strip.h'],
                ['include', '^browser/views/tabs/dragged_tab_controller.cc'],
                ['include', '^browser/views/tabs/dragged_tab_controller.h'],
                ['include', '^browser/views/tabs/dragged_tab_view.cc'],
                ['include', '^browser/views/tabs/dragged_tab_view.h'],
                ['include', '^browser/views/tabs/native_view_photobooth.h'],
                ['include', '^browser/views/tabs/native_view_photobooth_gtk.cc'],
                ['include', '^browser/views/tabs/native_view_photobooth_gtk.h'],
                ['include', '^browser/views/tabs/side_tab.cc'],
                ['include', '^browser/views/tabs/side_tab.h'],
                ['include', '^browser/views/tabs/side_tab_strip.cc'],
                ['include', '^browser/views/tabs/side_tab_strip.h'],
                ['include', '^browser/views/tabs/tab.cc'],
                ['include', '^browser/views/tabs/tab.h'],
                ['include', '^browser/views/tabs/tab_controller.h'],
                ['include', '^browser/views/tabs/tab_renderer_data.h'],
                ['include', '^browser/views/tabs/tab_strip.cc'],
                ['include', '^browser/views/tabs/tab_strip.h'],
                ['include', '^browser/views/tabs/tab_strip_2.cc'],
                ['include', '^browser/views/tabs/tab_strip_2.h'],
                ['include', '^browser/views/theme_background.cc'],
                ['include', '^browser/views/theme_background.h'],
                ['include', '^browser/views/toolbar_view.cc'],
                ['include', '^browser/views/toolbar_view.h'],
                ['include', '^browser/views/unhandled_keyboard_event_handler.cc'],
                ['include', '^browser/views/unhandled_keyboard_event_handler.h'],
                ['include', '^browser/views/view_text_utils.cc'],
                ['include', '^browser/views/view_text_utils.h'],
                ['include', '^browser/views/wrench_menu.cc'],
                ['include', '^browser/views/wrench_menu.h'],
                ['include', '^browser/window_sizer.cc'],
                ['include', '^browser/window_sizer.h'],
                # Exclude all of browser/gtk, then include the things we want.
                ['exclude', '^browser/gtk'],
                ['include', '^browser/gtk/accessibility_event_router_gtk.cc'],
                ['include', '^browser/gtk/accessibility_event_router_gtk.h'],
                ['include', '^browser/gtk/accessible_widget_helper_gtk.cc'],
                ['include', '^browser/gtk/accessible_widget_helper_gtk.h'],
                ['include', '^browser/gtk/bookmark_context_menu_gtk.cc'],
                ['include', '^browser/gtk/bookmark_context_menu_gtk.h'],
                ['include', '^browser/gtk/bookmark_editor_gtk.cc'],
                ['include', '^browser/gtk/bookmark_editor_gtk.h'],
                ['include', '^browser/gtk/bookmark_tree_model.cc'],
                ['include', '^browser/gtk/bookmark_tree_model.h'],
                ['include', '^browser/gtk/bookmark_utils_gtk.cc'],
                ['include', '^browser/gtk/bookmark_utils_gtk.h'],
                ['include', '^browser/gtk/cairo_cached_surface.cc'],
                ['include', '^browser/gtk/cairo_cached_surface.h'],
                ['include', '^browser/gtk/clear_browsing_data_dialog_gtk.cc'],
                ['include', '^browser/gtk/clear_browsing_data_dialog_gtk.h'],
                ['include', '^browser/gtk/certificate_dialogs.cc'],
                ['include', '^browser/gtk/certificate_dialogs.h'],
                ['include', '^browser/gtk/certificate_viewer.cc'],
                ['include', '^browser/gtk/certificate_viewer.h'],
                ['include', '^browser/gtk/collected_cookies_gtk.cc'],
                ['include', '^browser/gtk/collected_cookies_gtk.h'],
                ['include', '^browser/gtk/constrained_window_gtk.cc'],
                ['include', '^browser/gtk/constrained_window_gtk.h'],
                ['include', '^browser/gtk/gtk_chrome_cookie_view.cc'],
                ['include', '^browser/gtk/gtk_chrome_cookie_view.h'],
                ['include', '^browser/gtk/download_started_animation_gtk.cc'],
                ['include', '^browser/gtk/edit_search_engine_dialog.cc'],
                ['include', '^browser/gtk/edit_search_engine_dialog.h'],
                ['include', '^browser/gtk/first_run_dialog.cc'],
                ['include', '^browser/gtk/first_run_dialog.h'],
                ['include', '^browser/gtk/focus_store_gtk.cc'],
                ['include', '^browser/gtk/focus_store_gtk.h'],
                ['include', '^browser/gtk/gtk_chrome_button.cc'],
                ['include', '^browser/gtk/gtk_chrome_button.h'],
                ['include', '^browser/gtk/gtk_chrome_link_button.cc'],
                ['include', '^browser/gtk/gtk_chrome_link_button.h'],
                ['include', '^browser/gtk/gtk_custom_menu.cc'],
                ['include', '^browser/gtk/gtk_custom_menu.h'],
                ['include', '^browser/gtk/gtk_custom_menu_item.cc'],
                ['include', '^browser/gtk/gtk_custom_menu_item.h'],
                ['include', '^browser/gtk/gtk_theme_provider.cc'],
                ['include', '^browser/gtk/gtk_theme_provider.h'],
                ['include', '^browser/gtk/gtk_tree.cc'],
                ['include', '^browser/gtk/gtk_tree.h'],
                ['include', '^browser/gtk/gtk_util.cc'],
                ['include', '^browser/gtk/gtk_util.h'],
                ['include', '^browser/gtk/hover_controller_gtk.cc'],
                ['include', '^browser/gtk/hover_controller_gtk.h'],
                ['include', '^browser/gtk/hung_renderer_dialog_gtk.cc'],
                ['include', '^browser/gtk/import_dialog_gtk.cc'],
                ['include', '^browser/gtk/import_dialog_gtk.h'],
                ['include', '^browser/gtk/import_progress_dialog_gtk.cc'],
                ['include', '^browser/gtk/import_progress_dialog_gtk.h'],
                ['include', '^browser/gtk/import_lock_dialog_gtk.cc'],
                ['include', '^browser/gtk/import_lock_dialog_gtk.h'],
                ['include', '^browser/gtk/keyword_editor_view.cc'],
                ['include', '^browser/gtk/keyword_editor_view.h'],
                ['include', '^browser/gtk/list_store_favicon_loader.cc'],
                ['include', '^browser/gtk/list_store_favicon_loader.h'],
                ['include', '^browser/gtk/menu_gtk.cc'],
                ['include', '^browser/gtk/menu_gtk.h'],
                ['include', '^browser/gtk/meta_frames.cc'],
                ['include', '^browser/gtk/meta_frames.h'],
                ['include', '^browser/gtk/nine_box.cc'],
                ['include', '^browser/gtk/nine_box.h'],
                ['include', '^browser/gtk/options/'],
                ['include', '^browser/gtk/popup_blocked_animation_gtk.cc'],
                ['include', '^browser/gtk/repost_form_warning_gtk.cc'],
                ['include', '^browser/gtk/repost_form_warning_gtk.h'],
                ['include', '^browser/gtk/tab_contents_drag_source.cc'],
                ['include', '^browser/gtk/tab_contents_drag_source.h'],
                ['include', '^browser/gtk/task_manager_gtk.cc'],
                ['include', '^browser/gtk/task_manager_gtk.h'],
                ['include', '^browser/gtk/view_id_util.cc'],
                ['include', '^browser/gtk/view_id_util.h'],

                # Other excluded stuff.
                ['exclude', '^browser/autocomplete/autocomplete_popup_view_gtk.cc'],
                ['exclude', '^browser/autocomplete/autocomplete_popup_view_gtk.h'],
                ['exclude', '^browser/extensions/extension_host_mac.h'],
                ['exclude', '^browser/extensions/extension_host_mac.mm'],
                ['exclude', '^browser/extensions/external_registry_extension_provider_win.cc'],
                ['exclude', '^browser/tab_contents/tab_contents_view_gtk.cc'],
                ['exclude', '^browser/tab_contents/tab_contents_view_gtk.h'],
                ['exclude', '^browser/tab_contents/render_view_context_menu_gtk.cc'],
                ['exclude', '^browser/tab_contents/render_view_context_menu_gtk.h'],
                ['exclude', '^browser/browser_list_gtk.cc'],
              ],
            }],
            # These GTK files haven't been ported to views, while ChromeOS has
            # its own separate implementation below.  So re-include them only on
            # non-ChromeOS views Linux builds.
            ['OS=="linux" and toolkit_views==1 and chromeos==0', {
              'sources/': [
                ['include', '^browser/gtk/dialogs_gtk.cc'],
                ['include', '^browser/gtk/external_protocol_dialog_gtk.cc'],
                ['include', '^browser/gtk/external_protocol_dialog_gtk.h'],
                ['include', '^browser/views/notifications/balloon_view.cc'],
                ['include', '^browser/views/notifications/balloon_view.h'],

                ['exclude', '^browser/views/select_file_dialog.cc'],
              ],
            }],
            # GTK build only
            ['OS=="linux" and toolkit_views==0', {
              'sources/': [
                ['include', '^browser/printing/print_dialog_gtk.cc'],
                ['include', '^browser/printing/print_dialog_gtk.h'],
                ['exclude', '^browser/browser_list_stub.cc'],
                ['exclude', '^browser/bookmarks/bookmark_drop_info.cc'],
                ['exclude', '^browser/views/autocomplete/autocomplete_popup_gtk.cc'],
                ['exclude', '^browser/views/autocomplete/autocomplete_popup_gtk.h'],
              ],
            }],
            ['OS=="linux" and chromeos==1',{
              'sources/': [
                ['exclude', '^browser/notifications/balloon_collection.cc'],
                ['exclude', '^browser/notifications/balloon_collection_impl.h'],
                ['exclude', '^browser/notifications/balloon_collection_linux.cc'],
              ],
              'dependencies': [
                '../third_party/protobuf2/protobuf.gyp:protobuf_lite',
                #'../third_party/protobuf2/protobuf.gyp:protobuf',
                '../third_party/protobuf2/protobuf.gyp:protoc#host',
                '../third_party/cros/cros_api.gyp:cros_api',
              ],
              'actions': [
                {
                  'action_name': 'my_proto',
                  'inputs': [
                    '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
                    'browser/metrics/system_metrics.proto',
                  ],
                  'outputs': [
                    '<(INTERMEDIATE_DIR)/chrome/browser/metrics/system_metrics.pb.cc',
                    '<(INTERMEDIATE_DIR)/chrome/browser/metrics/system_metrics.pb.h',
                  ],
                  'dependencies': [
                    '../third_party/protobuf2/protobuf.gyp:protoc',
                  ],
                  'action': [
                    '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
                    'browser/metrics/system_metrics.proto',
                    '--cpp_out=<(INTERMEDIATE_DIR)/chrome',
                  ],
                },
              ],
            }],
          ],
          # Exclude files that should be excluded for all non-Windows platforms.
          'sources!': [
            'browser/aeropeek_manager.cc',
            'browser/autocomplete/autocomplete_accessibility.cc',
            'browser/bookmarks/bookmark_menu_controller.cc',
            'browser/bookmarks/bookmark_menu_controller.h',
            'browser/browser_accessibility_win.cc',
            'browser/browser_accessibility_manager_win.cc',
            'browser/google_update.cc',
            'browser/history/history_indexer.idl',
            'browser/history_tab_ui.cc',
            'browser/history_view.cc',
            'browser/ime_input.cc',
            'browser/importer/ie_importer.cc',
          ],
        }],
      ],
    },
    {
      'target_name': 'component_extensions',
      'type': 'none',
      'msvs_guid': '50B52703-525F-404C-BFE2-C46D3375D73E',
      # TODO(aa): Once the msvs port supports it, change this to recursively
      # copy the entire directory instead of listing the files.
      # http://code.google.com/p/gyp/issues/detail?id=143.
      'copies': [
        {
          'destination': '<(PRODUCT_DIR)/resources/gmail_app',
          'files': [
            'browser/resources/gmail_app/manifest.json',
            'browser/resources/gmail_app/128.png',
            'browser/resources/gmail_app/48.png',
            'browser/resources/gmail_app/32.png',
            'browser/resources/gmail_app/24.png',
          ]
        },
        {
          'destination': '<(PRODUCT_DIR)/resources/calendar_app',
          'files': [
            'browser/resources/calendar_app/manifest.json',
            'browser/resources/calendar_app/128.png',
            'browser/resources/calendar_app/48.png',
            'browser/resources/calendar_app/32.png',
            'browser/resources/calendar_app/24.png',
          ]
        },
        {
          'destination': '<(PRODUCT_DIR)/resources/docs_app',
          'files': [
            'browser/resources/docs_app/manifest.json',
            'browser/resources/docs_app/128.png',
            'browser/resources/docs_app/48.png',
            'browser/resources/docs_app/32.png',
            'browser/resources/docs_app/24.png',
          ]
        },
      ],
    },
    {
      # Protobuf compiler / generate rule for feedback
      'target_name': 'userfeedback_proto',
      'type': 'none',
      'sources': [
        'browser/userfeedback/proto/annotations.proto',
        'browser/userfeedback/proto/common.proto',
        'browser/userfeedback/proto/config.proto',
        'browser/userfeedback/proto/dom.proto',
        'browser/userfeedback/proto/extension.proto',
        'browser/userfeedback/proto/math.proto',
        'browser/userfeedback/proto/web.proto',
      ],
      'rules': [
        {
          'rule_name': 'genproto',
          'extension': 'proto',
          'inputs': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
          ],
          'variables': {
            # The protoc compiler requires a proto_path argument with the
            # directory containing the .proto file.
            # There's no generator variable that corresponds to this, so fake it.
            'rule_input_relpath': 'browser/userfeedback/proto',
          },
          'outputs': [
            '<(protoc_out_dir)/chrome/<(rule_input_relpath)/<(RULE_INPUT_ROOT).pb.h',
            '<(protoc_out_dir)/chrome/<(rule_input_relpath)/<(RULE_INPUT_ROOT).pb.cc',
          ],
          'action': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
            '--proto_path=./<(rule_input_relpath)',
            './<(rule_input_relpath)/<(RULE_INPUT_ROOT)<(RULE_INPUT_EXT)',
            '--cpp_out=<(protoc_out_dir)/chrome/<(rule_input_relpath)',
          ],
          'message': 'Generating C++ code from <(RULE_INPUT_PATH)',
        },
      ],
      'dependencies': [
        '../third_party/protobuf2/protobuf.gyp:protobuf',
        '../third_party/protobuf2/protobuf.gyp:protoc#host',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(protoc_out_dir)',
        ]
      },
      'export_dependent_settings': [
        '../third_party/protobuf2/protobuf.gyp:protobuf',
      ],
    },
  ],
}

# Local Variables:
# tab-width:2
# indent-tabs-mode:nil
# End:
# vim: set expandtab tabstop=2 shiftwidth=2:
