/* 

Copyright 2006 Eric Hakenholz

This file is part of C.a.R. software.

C.a.R. is a free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

C.a.R. is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */
package eric;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import rene.gui.Global;

/**
 * 
 * @author erichake
 */
public class JAboutDialog extends javax.swing.JDialog {

    /**
     *
     */
    private static final long serialVersionUID=1L;
    private final ImageIcon backimage=new ImageIcon(getClass().getResource(
            "/rene/zirkel/logowindow.jpg"));

    /**
     *
     * @param g
     */
    @Override
    public void paint(final java.awt.Graphics g) {
        super.paint(g);
        final java.awt.Dimension d=this.getSize();
        g.drawImage(backimage.getImage(), 0, 0, d.width, d.height, this);
        g.setFont(new Font("Dialog", Font.PLAIN, 11));
        String s=Global.Loc("version")+" "
                +Global.Loc("program.version");
        g.setColor(Color.darkGray);
        g.drawString(s, 115, 75);
        g.setFont(new Font("Dialog", Font.PLAIN, 11));
        g.setColor(Color.GRAY);
        s="java : "+System.getProperty("java.version");
        g.drawString(s, 125, 95);
    }

    public JAboutDialog(JComponent parent) {
        setSize(300, 150);
        setLocationRelativeTo(parent);
        this.setUndecorated(true);
        this.addMouseListener(new MouseAdapter() {

            @Override
            public void mousePressed(final MouseEvent e) {
                dispose();
            }
        });
        this.addWindowListener(new WindowAdapter() {

            @Override
            public void windowDeactivated(WindowEvent e) {
                dispose();
            }
        });
        setVisible(true);
    }
}
