/* (C) 2001  Vasyl Tsvirkunov */

#include <windows.h>
#include "gx.h"

extern "C"
{
#include "input.h"
#include "main.h"
#include "keyboard.h"
#include "screen.h"
#include "ui.h"
};

int currentKeyboardMode = 4;
int currentKeyboardColor = 0;

unsigned long* kbd_image;

/* Assumed to be 240x80 packed bitmap with buttons in 5 rows */
unsigned long kbd_image_800[] =
{
	0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 
	0x10004001, 0x31000400, 0x07100040, 0x40010004, 0x04001000, 0x00400100, 0x00040010, 0x00008000, 
	0xd00c403d, 0xf903340c, 0x0d903340, 0x407900c4, 0x64039038, 0x03401d06, 0x033440d3, 0x0000801c, 
	0xd00c400d, 0x0d07fc0c, 0x07101b40, 0x40cd00c4, 0x9407101c, 0x2558c964, 0xf3344d52, 0x00008f98, 
	0xd00c403d, 0x7903340c, 0x03900c40, 0x40ed00c4, 0x1406100c, 0x554549a4, 0x9bf554d2, 0x00009999, 
	0x100c400d, 0xc1033400, 0x1ed00640, 0x40ed0004, 0x1406100c, 0x35494924, 0xfb34c552, 0x00009999, 
	0x100040fd, 0x7d07fc00, 0x0cd03340, 0x400d0004, 0x9407101c, 0x15514924, 0x1b354552, 0x00008f98, 
	0x100c4031, 0x31033400, 0x1b903140, 0x40f90004, 0x64039038, 0x634d5d2e, 0xf33644d7, 0x000081bc, 
	0x100040f1, 0x01000400, 0x00100040, 0x40010004, 0x04001000, 0x00400d03, 0x00040010, 0x00008180, 
	0x900c4001, 0x6103f407, 0x07903f40, 0x407903f4, 0x8407901e, 0x00401901, 0x00040010, 0x00008000, 
	0xd00e4001, 0x7101840c, 0x00d00340, 0x40cd0304, 0xc40cd033, 0x00403100, 0x00040010, 0x00008000, 
	0x100c4001, 0x7900c406, 0x07d01f40, 0x40790184, 0x640ed03e, 0x00406100, 0x00040010, 0x00008000, 
	0x100c4001, 0x6d018403, 0x0cd03040, 0x40cd00c4, 0xc40dd030, 0x00403100, 0x00040010, 0x00008000, 
	0x900c4001, 0xfd033401, 0x0cd03340, 0x40cd0064, 0x840cd018, 0x00401901, 0x00040010, 0x00008000, 
	0xd03f4001, 0x6101e40f, 0x07901e40, 0x40790064, 0x0407900e, 0x00400d03, 0x00040010, 0x00008000, 
	0x10004001, 0x01000400, 0x00100040, 0x40010004, 0x04001000, 0x00400100, 0x00040010, 0x00008000, 
	0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x20008002, 0x00040000, 0x00008000, 
	0x0f20c07d, 0x81fa0c68, 0x681fa03e, 0x7e819a06, 0x03e80f20, 0x20188062, 0x61e40000, 0x00008c00, 
	0x19a0cf31, 0x801a0c68, 0x68062066, 0x18819a06, 0x066819a0, 0x201880f2, 0xf8340000, 0x0000bf7d, 
	0x19a7d831, 0x80fa0d68, 0xc8062066, 0x18819a03, 0x066819a0, 0x201881fa, 0x61e43000, 0x00008c4c, 
	0x19acdf31, 0x801a0fe8, 0x8806203e, 0x18819a01, 0x03e819a0, 0x207e8062, 0x63043000, 0x00008c0c, 
	0x0dacd9b1, 0x801a0ee8, 0x88062036, 0x18819a01, 0x006819a0, 0x203c8062, 0x63043000, 0x00008c0c, 
	0x1b27df31, 0x81fa0c68, 0x88062066, 0x7e81fa01, 0x00680f20, 0x20188062, 0xc1e43000, 0x0000b80d, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x20008002, 0x00043030, 0x00008000, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x20008002, 0x00043018, 0x00008000, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x207e8002, 0x00043ffc, 0x00008000, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x200081fa, 0x00040018, 0x00008000, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x20008002, 0x00040030, 0x00008000, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x207e8002, 0x00040000, 0x00008000, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x20008002, 0x00040000, 0x00008000, 
	0x00200001, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x20008002, 0x00040000, 0x00008000, 
	0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x00040002, 0x00008000, 
	0x62006089, 0x07a03c80, 0x81f207e8, 0x68182066, 0x00801a06, 0x01880620, 0x39e40012, 0x00008300, 
	0xf2004dd5, 0x0da00680, 0x801a0068, 0x68182066, 0x18801a03, 0x03080320, 0x3034002a, 0x00008fde, 
	0x9a005485, 0x19a03c81, 0x801a03e8, 0xe818207e, 0x18801a01, 0x07e81fa0, 0x31e5998a, 0x00008303, 
	0x9a004485, 0x19a06081, 0x81da0068, 0xe8182066, 0x00801a01, 0x03080320, 0x33046a0a, 0x00008303, 
	0xfa004495, 0x0da06081, 0x819a0068, 0x6819a066, 0x18801a03, 0x01880620, 0x3304ab0a, 0x00008303, 
	0x9a004509, 0x07a03c81, 0x81f20068, 0x680f2066, 0x1881fa06, 0x00080020, 0x79e51aaa, 0x00008e1e, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x00800200, 0x00080020, 0x0004cb12, 0x00008000, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x00800200, 0x0cc80620, 0x00040802, 0x00008000, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x18800200, 0x07880620, 0x00040002, 0x00008000, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x18800200, 0x1fe81fa0, 0x00040002, 0x00008000, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x00800200, 0x07880620, 0x00040002, 0x00008000, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x18800200, 0x0cc80620, 0x00040002, 0x00008000, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x18800200, 0x00080020, 0x00040002, 0x00008000, 
	0x02000001, 0x00200080, 0x80020008, 0x08002000, 0x0c800200, 0x00080020, 0x00040002, 0x00008000, 
	0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0x10004001, 0x00000400, 0x00040010, 0x00008000, 
	0x40024899, 0xe40cd03f, 0x1f40cd01, 0x06340cd0, 0x900f40f1, 0x09226407, 0x01e40fd0, 0x00008030, 
	0x40022085, 0x340cd018, 0x3340cd03, 0x07740dd0, 0xd00c4031, 0x0882140c, 0xfb340bd0, 0x000080fc, 
	0x40076999, 0x3407900c, 0x1f40cd00, 0x07f40fd0, 0x100c4031, 0x1da66406, 0x9b3409d0, 0x00008031, 
	0x40022aa1, 0x34079006, 0x3340cd00, 0x06b40fd0, 0x100c4031, 0x08aa8403, 0x9b3408d0, 0x00008031, 
	0x40022aa1, 0x340cd003, 0x33407903, 0x06340ed0, 0x100c4031, 0x08aa8400, 0xfb340850, 0x00008030, 
	0x40042a99, 0xe40cd03f, 0x1f403101, 0x06340cd0, 0x100f40f1, 0x10aa6403, 0x19e40fd0, 0x000080e0, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0x10004001, 0x00000400, 0x18040010, 0x00008000, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0x10004001, 0x0000040c, 0x00040010, 0x00008000, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0x10004001, 0x00000406, 0x00040010, 0x00008000, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0x10004001, 0x00000403, 0x00040010, 0x00008000, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0x90004001, 0x00000401, 0x00040010, 0x00008000, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0xd00c4031, 0x00000400, 0x00040010, 0x00008000, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0x500c4031, 0x00000400, 0x00040010, 0x00008000, 
	0x40000001, 0x04001000, 0x00400100, 0x00040010, 0x10004019, 0x00000400, 0x00040010, 0x00008000, 
	0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000ffff, 
	0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000000, 0x00000000, 
	0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000100, 0x00000000, 
	0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0xffc00040, 0x7ff00181, 0x00003ff8, 
	0x00000ffc, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00400040, 0x7ff001c1, 0x00002008, 
	0x00000804, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00400040, 0x7ff0ffe1, 0x00002828, 
	0x000009e4, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x80400040, 0x7ff0c1c1, 0x00002448, 
	0x00000b34, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x08400040, 0x7ff0c181, 0x00002288, 
	0x00000984, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x1c400040, 0x4010c101, 0x00002108, 
	0x000008c4, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x08400040, 0x4010c001, 0x00002288, 
	0x00000804, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00400040, 0x4010c001, 0x00002448, 
	0x000008c4, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x08400040, 0x4010c001, 0x00002828, 
	0x00000804, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x08400040, 0x4010ffe1, 0x00002008, 
	0x00000ffc, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0xffc00040, 0x7ff0ffe1, 0x00003ff8, 
	0x00000000, 0x00000400, 0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000000, 0x00000000, 
	0x00000000, 0xfffffc00, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000007f, 0x00000000, 0x00000000, 
};

unsigned long kbd_image_5200[] =
{
	0xc0000000, 0xffffffff, 0xfc0001ff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000000f, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0x40000000, 0x843c1060, 0x0400011f, 0x6000030f, 0x0007c080, 0xf8200000, 0x06000000, 0x00000008, 
	0x40000000, 0x04661070, 0x8400010c, 0xf9f3cfc1, 0x33ccc081, 0x982079f3, 0x1f9e7c79, 0x00000008, 
	0x40000000, 0x04301060, 0x04000106, 0x6336030f, 0x360cc080, 0x9820cc1b, 0x063306cd, 0x00000008, 
	0x40000000, 0x04181060, 0x0400010c, 0x6037c318, 0x37c7c080, 0xf820fcf3, 0x063f3cfc, 0x00000008, 
	0x40000000, 0x840c1060, 0x04000119, 0x60366318, 0x3660c080, 0xd8200d83, 0x0603600c, 0x00000008, 
	0x40000000, 0x047e11f8, 0x0400010f, 0xc037ce0f, 0xe7c0c081, 0x982078fb, 0x1c1e3e79, 0x00000008, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0x40000000, 0x04001000, 0x04000100, 0x00000000, 0x00000080, 0x00200000, 0x00000000, 0x00000008, 
	0xc0000000, 0xffffffff, 0xfc0001ff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x0000000f, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x047e10c0, 0x0000010f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x840610e0, 0x00000101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x843e10f0, 0x0000010f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x846010d8, 0x00000119, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x846611f8, 0x00000119, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x043c10c0, 0x0000010f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0xc0000000, 0xffffffff, 0x000001ff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x043c11f8, 0x0000010f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x84661180, 0x00000119, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x043c10c0, 0x0000011f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04661060, 0x00000118, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04661030, 0x0000010c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x043c1030, 0x00000107, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0xc0000000, 0xffffffff, 0x000001ff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x843c1198, 0x00000119, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0xc46610f0, 0x0000013f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x847613fc, 0x00000119, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x846e10f0, 0x00000119, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0xc4661198, 0x0000013f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x843c1000, 0x00000119, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x40000000, 0x04001000, 0x00000100, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0xc0000000, 0xffffffff, 0x000001ff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffc00000, 0x7ff00181, 0x00003ff8, 
	0x00000ffc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x7ff001c1, 0x00002008, 
	0x00000804, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x7ff0ffe1, 0x00002828, 
	0x000009e4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80400000, 0x7ff0c1c1, 0x00002448, 
	0x00000b34, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08400000, 0x7ff0c181, 0x00002288, 
	0x00000984, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1c400000, 0x4010c101, 0x00002108, 
	0x000008c4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08400000, 0x4010c001, 0x00002288, 
	0x00000804, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00400000, 0x4010c001, 0x00002448, 
	0x000008c4, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08400000, 0x4010c001, 0x00002828, 
	0x00000804, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08400000, 0x4010ffe1, 0x00002008, 
	0x00000ffc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffc00000, 0x7ff0ffe1, 0x00003ff8, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
};

unsigned long kbd_image_about[] =
{
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x000f8000, 0x06000180, 0x00060600, 0x00000600, 0x00001980, 0x00000600, 0x0f000600, 0x00000000, 
	0x0f198000, 0x1f8f018f, 0x8f1f8f00, 0x0000000f, 0x0f8f1980, 0x0f8f001f, 0x19800700, 0x00000000, 
	0x99998000, 0x06198d81, 0x98061980, 0x00000719, 0x99999980, 0x19998701, 0x1d800600, 0x00000000, 
	0x998f8000, 0x061f8781, 0x9f061980, 0x00000601, 0x019f9980, 0x1999860f, 0x1b800600, 0x00000000, 
	0x99818000, 0x06018d81, 0x99861f80, 0x00000601, 0x01818f00, 0x19998618, 0x19860600, 0x00000000, 
	0x0f018000, 0x1c0f198f, 0x9f1c1980, 0x00000f01, 0x818f0600, 0x198f0f0f, 0x0f061f80, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x000003e0, 0x00000600, 0x01818000, 0xc3c18000, 0x07e003c3, 0x8001c000, 0x00000001, 0x00000000, 
	0xc7c3c660, 0xe3c00603, 0xc7e3c003, 0x666003e3, 0x60600666, 0xe3c18666, 0x0003e3c7, 0x00000000, 
	0x606603e0, 0x666007c6, 0x01866006, 0x63c1c666, 0xe3e00767, 0x8601866f, 0x00066661, 0x00000000, 
	0xe3c7c660, 0x66600667, 0xc1866006, 0xe6618067, 0xe06006e6, 0x87c1866f, 0x00006661, 0x00000000, 
	0x66066660, 0x66600660, 0x6187e006, 0x66618066, 0x60600666, 0x8661866d, 0x00006661, 0x00000000, 
	0xc3e7c3e0, 0x63c007c3, 0xc7066006, 0xc3c3c067, 0x67e003c3, 0x07c3c7cc, 0x000063c7, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x80600000, 0x00000181, 0x00060606, 0x00000000, 0x00018060, 0x00000000, 0xc3c3c006, 0x00000603, 
	0xe0600000, 0x0183e7e7, 0x63c00303, 0xe3c7c006, 0xc3c00063, 0x07e3c007, 0x666663c3, 0x00000306, 
	0x83e00000, 0x81866181, 0x66660181, 0x66606006, 0x6061c3e6, 0x83006000, 0x6763c601, 0x00000187, 
	0x86600000, 0xc0066181, 0x666600c0, 0x6663c006, 0xc0618666, 0xc1806003, 0xe6e667c0, 0x000000c6, 
	0x86600000, 0x6183e181, 0xc6660060, 0xe6660187, 0x00618663, 0x60c06186, 0x66666660, 0x00000066, 
	0x06600000, 0x21806707, 0x03c60020, 0x63c3e183, 0xe3c3c660, 0x27e3c183, 0xc3c3c7c0, 0x00000023, 
	0x00000000, 0x00006000, 0xe003c000, 0x60000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x800003e0, 0x80060001, 0x03e00001, 0x80006000, 0x03c3e001, 0x00000060, 0x00000000, 0x00000000, 
	0xe3e3c660, 0xe00603c7, 0xc66003c7, 0xe3c063c3, 0x06666007, 0x00066060, 0x00000000, 0x00000000, 
	0x86666660, 0x8007c661, 0x66600661, 0x86636066, 0x00666001, 0x000663e0, 0x00000000, 0x00000000, 
	0x806663e0, 0x800667e1, 0x63e00661, 0x87e1e066, 0x0063e001, 0x00066660, 0x00000000, 0x00000000, 
	0x80666060, 0x80066061, 0x60600661, 0x80636066, 0x06606001, 0x0007c660, 0x00000000, 0x00000000, 
	0x0063c060, 0x0007c3c7, 0xc06003c7, 0x03c663c3, 0x03c06007, 0x000303e0, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0001e000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00066000, 0xe001c000, 0x01800007, 0x00000060, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0xc3c66000, 0x80018667, 0xe00667c1, 0xc3e66063, 0x00000663, 
	0x00000000, 0x00000000, 0x00000000, 0x66066000, 0x80018660, 0x61c66061, 0x66666366, 0x00000666, 
	0x00000000, 0x00000000, 0x00000000, 0xc7c66000, 0x80018663, 0x618663c1, 0x666661e0, 0x00000666, 
	0x00000000, 0x00000000, 0x00000000, 0x0663c000, 0x800187c6, 0x6183c601, 0x66666360, 0x000003c6, 
	0x00000000, 0x00000000, 0x00000000, 0xe7c18000, 0x8003c303, 0x63c183e1, 0xc667c660, 0x00000183, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000001e0, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x018067e0, 0x00000000, 0x00000000, 0x00018000, 0x00000700, 0x000001c0, 0x00000000, 0x00000000, 
	0xc0006180, 0xc3e3e007, 0x63c3e7c3, 0x07c00006, 0xc3c3e180, 0x00066183, 0x00000000, 0x00000000, 
	0x61c3e180, 0x66666000, 0xe6066666, 0x0061c00f, 0x666667c0, 0x00066186, 0x00000000, 0x00000000, 
	0xc1866180, 0x60666003, 0xe7c06666, 0x03c1800f, 0xe7e06180, 0x00066187, 0x00000000, 0x00000000, 
	0x01866180, 0x6063e006, 0x666067c6, 0x0601800d, 0x60606180, 0x0007c180, 0x00000000, 0x00000000, 
	0xe3c66180, 0xc0606003, 0x67c06603, 0x03e3c00c, 0xc3c06180, 0x000303c3, 0x00000000, 0x00000000, 
	0x00000000, 0x00006000, 0x000003e0, 0x00000000, 0x00000000, 0x0001e000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x80018600, 0x00618001, 0xc0600180, 0x00000001, 0x00000600, 0x00006180, 0x00000180, 0x00000000, 
	0xe7c00600, 0x606003e7, 0x8063c7e6, 0xe66003c1, 0x03e3c603, 0x03c067e0, 0x63e3c7e0, 0x000007c6, 
	0x8061c7c0, 0x63e1c661, 0x83e60186, 0x66600661, 0x066667c6, 0x0663e180, 0xe6666180, 0x0000006f, 
	0x83c18660, 0x66618061, 0x8667c186, 0x666007e1, 0x0067e666, 0x07e66180, 0xe067e180, 0x000003cf, 
	0x86018660, 0x66618061, 0x86666186, 0x66600061, 0x00606666, 0x00666180, 0x60606180, 0x0000060d, 
	0x03e3c7c0, 0xc3e3c067, 0xc3e7c707, 0x67c003c3, 0x0063c7c6, 0x03c66700, 0x6063c700, 0x000003ec, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0xc0070000, 0xc0066667, 0x00000007, 0xe001c000, 0x81c06003, 0x80600001, 0x00000001, 0x00000000, 
	0x600183c0, 0x600666e0, 0xe3c3e3c0, 0x600183c3, 0x01806666, 0x006003c0, 0xc3e3c3c0, 0x000003c7, 
	0x6007c660, 0x600667e0, 0x66666660, 0x60018606, 0xc183e666, 0xc0600061, 0x66666061, 0x00000660, 
	0x60018660, 0x600667e7, 0x67e667e7, 0xe00187c0, 0x81866663, 0x80600061, 0xc667e061, 0x000007e3, 
	0x60018660, 0x60066766, 0x60666066, 0x60018660, 0x81866660, 0x80600061, 0x06606061, 0x00000066, 
	0xc00183c0, 0xc007e667, 0x63c663c7, 0x6003c7c0, 0xc3c3e7c0, 0xc7e003c3, 0xe663c3c3, 0x000003c3, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
};

struct sKeydata
{
	short offset;
	short key;
};

#define KBD_ROTATE -100
#define KBD_NEGATE -101
#define KBD_HIDE   -102
#define KBD_ABOUT  -103

sKeydata* kbd_struct;
int keys;

sKeydata kbd_struct_800[] =
{
	/* first row */
	{0,AKEY_ESCAPE},{14,AKEY_1},{28,AKEY_2},{42,AKEY_3},
	{56,AKEY_4},{70,AKEY_5},{84,AKEY_6},{98,AKEY_7},
	{112,AKEY_8},{126,AKEY_9},{140,AKEY_0},{154,AKEY_LESS},
	{168,AKEY_GREATER},{182,AKEY_BACKSPACE},{196,AKEY_BREAK},{210,AKEY_HELP},
	/* second row */
	{240,AKEY_TAB},{261,AKEY_q},{275,AKEY_w},{289,AKEY_e},
	{303,AKEY_r},{317,AKEY_t},{331,AKEY_y},{345,AKEY_u},
	{359,AKEY_i},{373,AKEY_o},{387,AKEY_p},{401,AKEY_MINUS},
	{415,AKEY_EQUAL},{429,AKEY_RETURN},{450,AKEY_F4},
	/* third row */
	{480,AKEY_CTRL},{505,AKEY_a},{519,AKEY_s},{533,AKEY_d},
	{547,AKEY_f},{561,AKEY_g},{575,AKEY_h},{589,AKEY_j},
	{603,AKEY_k},{617,AKEY_l},{631,AKEY_SEMICOLON},{645,AKEY_PLUS},
	{659,AKEY_ASTERISK},{673,AKEY_CAPSTOGGLE},{690,AKEY_F3},
	/* fourth row */
	{720,AKEY_SHFT},{750,AKEY_z},{764,AKEY_x},{778,AKEY_c},
	{792,AKEY_v},{806,AKEY_b},{820,AKEY_n},{834,AKEY_m},
	{848,AKEY_COMMA},{862,AKEY_FULLSTOP},{876,AKEY_SLASH},{890,AKEY_SHFT},
	{916,AKEY_ATARI},{930,AKEY_F2},
	/* fifth row */
	{960,KBD_ABOUT},{975,AKEY_NONE},{1002,AKEY_SPACE},{1126,AKEY_NONE},
	{1140,AKEY_UI},{1155,KBD_ROTATE},{1169,KBD_NEGATE},{1184,KBD_HIDE},
	{1200, AKEY_NONE}
};

sKeydata kbd_struct_5200[] =
{
	{0,AKEY_NONE},  {30,0x3f}, {44,0x3d}, {58,0x3b}, {72,AKEY_NONE},
	{90,0x39},{135,0x31},{181,0x29},{227,AKEY_NONE},
	{240,AKEY_NONE},{270,0x37},{284,0x35},{298,0x33},{312,AKEY_NONE},
	{480,AKEY_NONE},{510,0x2f},{524,0x2d},{538,0x2b},{552,AKEY_NONE},
	{720,AKEY_NONE},{750,0x27},{764,0x25},{778,0x23},{792,AKEY_NONE},
	{960,KBD_ABOUT},{975,AKEY_NONE},{1140,AKEY_UI},{1155,KBD_ROTATE},
	{1169,KBD_NEGATE},{1184,KBD_HIDE},
	{1200,AKEY_NONE}
};

// Keyboard translation table
struct sKeyTranslation
{
	short winKey;
	short aKey;
};

sKeyTranslation kbd_translation[] =
{
// Mappable entries
	{0, AKEY_NONE}, // 5 joystick entries
	{0, AKEY_NONE},
	{0, AKEY_NONE},
	{0, AKEY_NONE},
	{0, AKEY_NONE},
	{0, AKEY_UI},
	{0, AKEY_F1},
	{0, AKEY_F2},
	{0, AKEY_F3},
	{0, AKEY_F4},
	{0, AKEY_HELP},
	{0, AKEY_WARMSTART},
	{0, AKEY_COLDSTART},
	{0, AKEY_BREAK},
// Non-mappable entries
	{VK_SHIFT, AKEY_SHFT},
	{VK_CONTROL, AKEY_CTRL},
	{'0', AKEY_0},
	{'1', AKEY_1},
	{'2', AKEY_2},
	{'3', AKEY_3},
	{'4', AKEY_4},
	{'5', AKEY_5},
	{'6', AKEY_6},
	{'7', AKEY_7},
	{'8', AKEY_8},
	{'9', AKEY_9},
	{'A', AKEY_a},
	{'B', AKEY_b},
	{'C', AKEY_c},
	{'D', AKEY_d},
	{'E', AKEY_e},
	{'F', AKEY_f},
	{'G', AKEY_g},
	{'H', AKEY_h},
	{'I', AKEY_i},
	{'J', AKEY_j},
	{'K', AKEY_k},
	{'L', AKEY_l},
	{'M', AKEY_m},
	{'N', AKEY_n},
	{'O', AKEY_o},
	{'P', AKEY_p},
	{'Q', AKEY_q},
	{'R', AKEY_r},
	{'S', AKEY_s},
	{'T', AKEY_t},
	{'U', AKEY_u},
	{'V', AKEY_v},
	{'W', AKEY_w},
	{'X', AKEY_x},
	{'Y', AKEY_y},
	{'Z', AKEY_z},
	{VK_LWIN, AKEY_HELP},
	{VK_BACK, AKEY_BACKSPACE},
	{VK_ESCAPE, AKEY_ESCAPE},
	{VK_BACKQUOTE, AKEY_ATARI},
	{VK_CAPITAL, AKEY_CAPSTOGGLE},
	{VK_TAB, AKEY_TAB},
	{VK_RETURN, AKEY_RETURN},
	{VK_SPACE, AKEY_SPACE},
	{VK_LBRACKET, AKEY_LESS},
	{VK_RBRACKET, AKEY_GREATER},
	{VK_EQUAL, AKEY_EQUAL},
	{VK_SUBTRACT, AKEY_MINUS},
	{VK_ADD, AKEY_PLUS},
	{VK_MULTIPLY, AKEY_ASTERISK},
	{VK_DIVIDE, AKEY_SLASH},
	{VK_SEMICOLON, AKEY_SEMICOLON},
	{VK_COMMA, AKEY_COMMA},
	{VK_PERIOD, AKEY_FULLSTOP},
	{VK_UP, AKEY_UP},
	{VK_DOWN, AKEY_DOWN},
	{VK_LEFT, AKEY_LEFT},
	{VK_RIGHT, AKEY_RIGHT},
};

#define KBDT_TRIGGER	0
#define KBDT_JOYUP		1
#define KBDT_JOYDOWN	2
#define KBDT_JOYLEFT	3
#define KBDT_JOYRIGHT	4
#define KBDT_UI			5
#define KBDT_F1			6
#define KBDT_F2			7
#define KBDT_F3			8
#define KBDT_F4			9
#define KBDT_HELP		10
#define KBDT_WARMSTART	11
#define KBDT_COLDSTART	12
#define KBDT_BREAK		13


void reset_kbd()
{
	if(machine_type == MACHINE_5200)
	{
		kbd_image = kbd_image_5200;
		kbd_struct = kbd_struct_5200;
		keys = sizeof(kbd_struct_5200)/sizeof(kbd_struct_5200[0]);
	}
	else
	{
		kbd_image = kbd_image_800;
		kbd_struct = kbd_struct_800;
		keys = sizeof(kbd_struct_800)/sizeof(kbd_struct_800[0]);
	}
}

short get_keypress(short x, short y)
{
	int offset;
	int i;
	
	if(currentKeyboardMode == 4 && get_screen_mode())
		return AKEY_NONE;
	
	offset = x + (y/16)*240;
	if(offset < 0)
		return AKEY_NONE;
	
	for(i=1; i<keys; i++)
		if(offset < kbd_struct[i].offset)
			return kbd_struct[i-1].key;
		
		return AKEY_NONE;
}

static GXKeyList klist;

/* map joystick direction to expected key code by screen orientation */
short joykey_map[3][4];

int activeKey;
int activeMod;
int stick0;
int trig0;

void push_key(short akey);
void release_key(short akey);

void hitbutton(short code)
{
	int kbcode;
	
	if(ui_is_active)
	{
		trig0 = 1;
		stick0 = 0xff;

		kbcode = AKEY_NONE;
		if(code == joykey_map[get_screen_mode()][0])
			kbcode = AKEY_UP;
		else if(code == joykey_map[get_screen_mode()][1])
			kbcode = AKEY_DOWN;
		else if(code == joykey_map[get_screen_mode()][2])
			kbcode = AKEY_LEFT;
		else if(code == joykey_map[get_screen_mode()][3])
			kbcode = AKEY_RIGHT;
		else if(code == klist.vkStart)
			kbcode = AKEY_RETURN;
		else if(code == klist.vkA)
			kbcode = AKEY_SPACE;
		else if(code == klist.vkB)
			kbcode = AKEY_TAB;
		else
			kbcode = AKEY_ESCAPE;
		
		push_key(kbcode);
	}
	else
	{
		kbcode = AKEY_NONE;
		if(code == joykey_map[get_screen_mode()][0])
			stick0 &= ~1;
		else if(code == joykey_map[get_screen_mode()][1])
			stick0 &= ~2;
		else if(code == joykey_map[get_screen_mode()][2])
			stick0 &= ~4;
		else if(code == joykey_map[get_screen_mode()][3])
			stick0 &= ~8;
		else if(code == klist.vkStart)
			trig0 = 0;
/*
		else if(code == klist.vkA)
			kbcode = AKEY_F3;
		else if(code == klist.vkB)
			kbcode = AKEY_F2;
		else if(code == klist.vkC)
			kbcode = AKEY_F4;
		else
			kbcode = AKEY_UI;
*/
		else
		for(int i=0; i<sizeof(kbd_translation)/sizeof(kbd_translation[0]); i++)
			if(code == kbd_translation[i].winKey)
			{
				kbcode = kbd_translation[i].aKey;
				break;
			}

		if(kbcode != AKEY_NONE)
			push_key(kbcode);
	}

	/* The way current UI works, it is not compatible with keyboard implementation
	in landscape mode */
	if(kbcode == AKEY_UI)
		set_screen_mode(0);
}

void releasebutton(short code)
{
	int kbcode;
	
	if(ui_is_active)
	{
		kbcode = AKEY_NONE;
		if(code == klist.vkUp)
			kbcode = AKEY_UP;
		else if(code == klist.vkDown)
			kbcode = AKEY_DOWN;
		else if(code == klist.vkLeft)
			kbcode = AKEY_LEFT;
		else if(code == klist.vkRight)
			kbcode = AKEY_RIGHT;
		else if(code == klist.vkStart)
			kbcode = AKEY_RETURN;
		else if(code == klist.vkA)
			kbcode = AKEY_SPACE;
		else if(code == klist.vkB)
			kbcode = AKEY_TAB;
		else
			kbcode = AKEY_ESCAPE;
		
		release_key(kbcode);
	}
	else
	{
		if(code == joykey_map[get_screen_mode()][0])
			stick0 |= 1;
		else if(code == joykey_map[get_screen_mode()][1])
			stick0 |= 2;
		else if(code == joykey_map[get_screen_mode()][2])
			stick0 |= 4;
		else if(code == joykey_map[get_screen_mode()][3])
			stick0 |= 8;
		else if(code == klist.vkStart)
			trig0 = 1;
/*
		else if(code == klist.vkA)
			kbcode = AKEY_F3;
		else if(code == klist.vkB)
			kbcode = AKEY_F2;
		else if(code == klist.vkC)
			kbcode = AKEY_F4;
		else
			kbcode = AKEY_UI;
*/
		else
		for(int i=0; i<sizeof(kbd_translation)/sizeof(kbd_translation[0]); i++)
			if(code == kbd_translation[i].winKey)
			{
				kbcode = kbd_translation[i].aKey;
				break;
			}

		
		if(kbcode != AKEY_NONE)
			release_key(kbcode);
	}
}


void tapscreen(short x, short y)
{
	short kbcode;
	
	translate_kbd(&x, &y);
	
	/* In landscape - show keyboard if clicked bottom right corner */
	if(get_screen_mode() && currentKeyboardMode == 4 && x > 300 && y > 220)
		return;
	
	kbcode = get_keypress(x, y);
	
	/* On-screen joystick trigger (in portrait or in landscape if no keyboard */
	if(kbcode == AKEY_NONE && currentKeyboardMode == 4)
	{
//		joyhits[0] = 1;
		trig0 = 0;
		return;
	}
	
	/* Special keys */
	switch(kbcode)
	{
	case KBD_ROTATE:
	case KBD_NEGATE:
	case KBD_HIDE:
		return;
	case KBD_ABOUT:
		kbd_image = kbd_image_about;
		return;
	}
	
	/* The way current UI works, it is not compatible with keyboard implementation
	in landscape mode */
	if(kbcode == AKEY_UI)
		set_screen_mode(0);
	
	/* Special translation to make on-screen UI easier to use */
	if(ui_is_active)
	{
		if(machine_type == MACHINE_5200)
		{
			switch(kbcode)
			{
			case 0x3d: /* 2 */
				kbcode = AKEY_UP;
				break;
			case 0x2d: /* 8 */
				kbcode = AKEY_DOWN;
				break;
			case 0x37: /* 4 */
				kbcode = AKEY_LEFT;
				break;
			case 0x33: /* 6 */
				kbcode = AKEY_RIGHT;
				break;
			case 0x39: /* Start */
				kbcode = AKEY_RETURN;
				break;
			case 0x27: /* * */
				kbcode = AKEY_ESCAPE;
				break;
			case 0x31: /* Pause */
				kbcode = AKEY_TAB;
				break;
			case 0x23: /* # */
				kbcode = AKEY_SPACE;
				break;
			}
		}
		else
		{
			switch(kbcode)
			{
			case AKEY_MINUS:
				kbcode = AKEY_UP;
				break;
			case AKEY_EQUAL:
				kbcode = AKEY_DOWN;
				break;
			case AKEY_PLUS:
				kbcode = AKEY_LEFT;
				break;
			case AKEY_ASTERISK:
				kbcode = AKEY_RIGHT;
				break;
			}
		}
	}

	if(kbcode == AKEY_BREAK)
		key_break = 1;

	push_key(kbcode);
}

void untapscreen(short x, short y)
{
	int kbcode;
	
	translate_kbd(&x, &y);
	
	/* Special tricks */
	/* In landscape - show keyboard if clicked bottom right corner */
	if(get_screen_mode() && currentKeyboardMode == 4)
	{
		if(x > 300 && y > 220 && !ui_is_active)
			currentKeyboardMode = 3;
		else if(ui_is_active)
			set_screen_mode(0);
		return;
	}
	
	/* In landscape -- move keyboard if clicked outside of it */
	int newKeyboardMode = currentKeyboardMode;
	if(get_screen_mode() && currentKeyboardMode != 4)
	{
		if(x<0 || x>=240)
			newKeyboardMode = newKeyboardMode ^ 1;
		if(y<0 || y>=80)
			newKeyboardMode = newKeyboardMode ^ 2;
	}
	if(newKeyboardMode != currentKeyboardMode)
	{
		currentKeyboardMode = newKeyboardMode;
		return;
	}
	
	kbcode = get_keypress(x, y);
	
	/* On-screen joystick trigger (in portrait or in landscape if no keyboard */
	if(kbcode == AKEY_NONE && currentKeyboardMode == 4)
	{
//		joyhits[0] = 0;
		trig0 = 1;
		return;
	}
	
	/* Special keys */
	switch(kbcode)
	{
	case KBD_ROTATE:
		if(!ui_is_active)
			set_screen_mode(get_screen_mode()+1);
		return;
	case KBD_NEGATE:
		currentKeyboardColor = 1-currentKeyboardColor;
		return;
	case KBD_HIDE:
		if(get_screen_mode())
			currentKeyboardMode = 4;
		return;
	case KBD_ABOUT:
		reset_kbd();
		return;
	}
	
	/* Special translation to make on-screen UI easier to use */
	if(ui_is_active)
	{
		if(machine_type == MACHINE_5200)
		{
			switch(kbcode)
			{
			case 0x3d: /* 2 */
				kbcode = AKEY_UP;
				break;
			case 0x2d: /* 8 */
				kbcode = AKEY_DOWN;
				break;
			case 0x37: /* 4 */
				kbcode = AKEY_LEFT;
				break;
			case 0x33: /* 6 */
				kbcode = AKEY_RIGHT;
				break;
			case 0x39: /* Start */
				kbcode = AKEY_RETURN;
				break;
			case 0x27: /* * */
				kbcode = AKEY_ESCAPE;
				break;
			case 0x31: /* Pause */
				kbcode = AKEY_TAB;
				break;
			case 0x23: /* # */
				kbcode = AKEY_SPACE;
				break;
			}
		}
		else
		{
			switch(kbcode)
			{
			case AKEY_MINUS:
				kbcode = AKEY_UP;
				break;
			case AKEY_EQUAL:
				kbcode = AKEY_DOWN;
				break;
			case AKEY_PLUS:
				kbcode = AKEY_LEFT;
				break;
			case AKEY_ASTERISK:
				kbcode = AKEY_RIGHT;
				break;
			}
		}
	}

	if(kbcode == AKEY_BREAK)
		key_break = 0;
	
	release_key(kbcode);
}

void push_key(short akey)
{
	switch(akey)
	{
	case AKEY_NONE:
	case AKEY_UI:
		activeKey = akey;
		activeMod = 0;
		break;
	case AKEY_SHFT:
		activeMod ^= 0x40;
		break;
	case AKEY_CTRL:
		activeMod ^= 0x80;
		break;
	case AKEY_F2:
		key_consol &= ~CONSOL_OPTION;
		break;
	case AKEY_F3:
		key_consol &= ~CONSOL_SELECT;
		break;
	case AKEY_F4:
		key_consol &= ~CONSOL_START;
		break;
	default:
		activeKey = akey|activeMod;
		activeMod = 0;
	}
}

void release_key(short akey)
{
	activeKey = AKEY_NONE;
	key_consol = CONSOL_NONE;
}

int get_last_key()
{
	if(activeKey != AKEY_BREAK)
		return activeKey;
	else
	{
		/* There is special case */
		release_key(AKEY_BREAK);
		return AKEY_BREAK;
	}
}

int prockb(void)
{
	static int framectr = 0;
#ifndef MULTITHREADED
	MsgPump();
#endif
/* UI.C violates the rest of architecture */
	if(ui_is_active && framectr++ == 5)
	{
		refresh_kbd();
		framectr = 0;
	}
	return 0;
}

void uninitinput(void)
{
	/* To prevent start key leak to OS */
	while(GetAsyncKeyState(klist.vkStart) & 0x8000)
#ifndef MULTITHREADED
		MsgPump();
#else
		Sleep(10);
#endif
	GXCloseInput();
}

int initinput(void)
{
	GXOpenInput();
	klist = GXGetDefaultKeys(GX_NORMALKEYS);
	
	joykey_map[0][0] = klist.vkUp;
	joykey_map[0][1] = klist.vkDown;
	joykey_map[0][2] = klist.vkLeft;
	joykey_map[0][3] = klist.vkRight;
	
	joykey_map[1][0] = klist.vkLeft;
	joykey_map[1][1] = klist.vkRight;
	joykey_map[1][2] = klist.vkDown;
	joykey_map[1][3] = klist.vkUp;
	
	joykey_map[2][0] = klist.vkRight;
	joykey_map[2][1] = klist.vkLeft;
	joykey_map[2][2] = klist.vkUp;
	joykey_map[2][3] = klist.vkDown;

	kbd_translation[KBDT_F3].winKey = klist.vkA;
	kbd_translation[KBDT_F2].winKey = klist.vkB;
	kbd_translation[KBDT_UI].winKey = klist.vkC;

	kbd_image = kbd_image_800;
	kbd_struct = kbd_struct_800;
	keys = sizeof(kbd_struct_800)/sizeof(kbd_struct_800[0]);

	clearkb();

	return 0;
}

void clearkb(void)
{
	activeKey = AKEY_NONE;
	activeMod = 0;
	key_consol = CONSOL_NONE;
	stick0 = 0xff;
	trig0 = 1;
}
