/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _dlhash_h_
#define _dlhash_h_

#include "dllist.h"

typedef unsigned int	(*dlhash_func)	(unsigned int, void *key);
typedef void *		(*dlkey_func)	(void *key_data);
typedef void 		(*dlkeyfree_func)(void *key);
typedef void		(*dlfree_func)	(void *key_data);

typedef struct _dlhash {
	unsigned int	size;
	dllist		**nodes;
	dlkey_func	key_func;
	dlkeyfree_func	keyfree_func;
	dlhash_func	hash_func;
	dlcomp_func	comp_func;
	dlfree_func	free_func;
} dlhash;

extern dlhash	*dlhash_new(unsigned int , dlkey_func, dlhash_func , dlcomp_func);
extern void	dlhash_set_free_func(dlhash *, dlfree_func, dlkeyfree_func);
extern void	dlhash_empty(dlhash *);
extern void	dlhash_free(dlhash *);
extern void	dlhash_insert(dlhash *, void* key_data);
extern void	dlhash_remove(dlhash *, void* key_data);
extern void	dlhash_exclude(dlhash *, void* key_data);
extern dllist	*dlhash_get_class(dlhash *, void* key_data);
extern void	*dlhash_find(dlhash *, void* key_data);
extern void	*dlhash_find_by_key(dlhash *, void* key);
extern void	dlhash_resize(dlhash *, unsigned int);

#endif

