/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _bufio_h_
#define _bufio_h_

typedef struct {
	int	fd;
	char	*buf;
	int	buf_size;
	int	buf_start;
	int	buf_end;
	int	bufio_errno;
	int	eof;
} bufio;

extern bufio	*bufio_fdopen(int);
extern bufio	*bufio_open(char *, int);
extern bufio	*bufio_copen(char *, int, int);
extern int	_bufio_read(bufio *, char *, int, void *);
extern int	_bufio_nbfread(bufio *, char *, int, void *);
extern int	_bufio_readln(bufio *, char *, int, void *);
extern void	bufio_unread(bufio *, char *, int);
extern int	_bufio_write(bufio * , char *, int, void *);
extern int	bufio_close(bufio *);
extern void	bufio_free(bufio *);
extern void	bufio_reset(bufio *);

#define	bufio_read(d , b , l) _bufio_read(d , b , l , NULL)
#define	bufio_sslread(d , b , l , s) _bufio_read(d , b , l , s)

#define	bufio_nbfread(d , b , l) _bufio_nbfread(d , b , l , NULL)
#define	bufio_sslnbfread(d , b , l , s) _bufio_nbfread(d , b , l , s)

#define	bufio_readln(d , b , l) _bufio_readln(d , b , l , NULL)
#define	bufio_sslreadln(d , b , l , s) _bufio_readln(d , b , l , s)

#define	bufio_write(d , b , l) _bufio_write(d , b , l , NULL)
#define	bufio_sslwrite(d , b , l , s) _bufio_write(d , b , l , s)

#define bufio_getfd(s) ((s)->fd)

#endif
