/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _Toggle_H_
#define _Toggle_H_

#include <X11/IntrinsicP.h>

typedef void (*ToggleCallbackProc)(
#if NeedFunctionPrototypes
	XtPointer , /* ToggleGroup * */
	Widget ,
	XtPointer
#endif
);

typedef struct _ToggleCallbackRec {
	ToggleCallbackProc	callback;
	XtPointer		adata;
} ToggleCallbackRec,*ToggleCallbackList;

typedef struct _ToggleGroup {
	Widget			*group;
	int			active;
	int			num;
	ToggleCallbackList	cb;
	int			cbnum;
} ToggleGroup;

#if NeedFunctionPrototypes
extern ToggleGroup * CreateToggleGroup();
extern void DestroyToggleGroup();
extern void ToggleAddCallback(ToggleGroup * , ToggleCallbackProc , XtPointer);
extern void ToggleRemoveCallback(ToggleGroup * , ToggleCallbackProc , XtPointer);
extern void AddWidgetToToggleGroup(ToggleGroup * , Widget);
extern void RemoveWidgetFromToggleGroup(ToggleGroup * , Widget);
extern void ToggleGroupSetActive(ToggleGroup *, Widget);
extern Widget ToggleGetWidgetByWid(ToggleGroup * , int);
#else
extern ToggleGroup * CreateToggleGroup();
extern void DestroyToggleGroup();
extern void ToggleAddCallback();
extern void ToggleRemoveCallback();
extern void AddWidgetToToggleGroup();
extern void RemoveWidgetFromToggleGroup();
extern void ToggleGroupSetActive();
extern Widget ToggleGetWidgetByWid();
#endif

#endif
