/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include	<Nws/MultiColP.h>
#include	<Nws/Init.h>
#include 	<Nws/misc.h>
#include	<Nws/cvt.h>

#define offset(field) XtOffsetOf(MultiColRec, multiCol.field)

static XtResource resources[] = {
	{
         XtNspacing ,
         XtCSpacing ,
         XtRInt ,
         sizeof(int) ,
         offset(spacing) ,
         XtRImmediate ,
         (XtPointer) 1
        },
};

static XtResource multiColConstraintsResources [] = {
        {
         XtNid ,
         XtCId ,
         XtRInt ,
         sizeof(int) ,
         XtOffsetOf(MultiColConstraintsRec , multiCol.id) ,
         XtRImmediate ,
         (XtPointer) -1
        },
};

static void ClassInitialize();
static void ChangeManaged ();
static XtGeometryResult GeometryManager ();
static XtGeometryResult QueryGeometry();
static void Resize ();

static void Layout();

MultiColClassRec multiColClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &baseConstClassRec,
    /* class_name            */ "MultiCol",
    /* widget_size           */ sizeof(MultiColRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ NULL,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ False,
    /* compress_enterleave   */ False,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ Resize,
    /* expose                */ XtInheritExpose,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ XtInheritTranslations,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* composite */
   {
    /* geometry_manager	     */ GeometryManager,
    /* change_managed	     */ ChangeManaged,
    /* insert_child	     */ XtInheritInsertChild,
    /* delete_child	     */ XtInheritDeleteChild,
    /* extension	     */ NULL
   },
   {
/* constraint */
    /* subresourses       */   multiColConstraintsResources,
    /* subresource_count  */   XtNumber(multiColConstraintsResources),
    /* constraint_size    */   sizeof(MultiColConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL,
    /* extension          */   NULL
   },
/* baseConst */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse		       */ XtInheritTraverse,
    /* traverseTo              */ XtInheritTraverseTo,
    /* traverseOut	       */ XtInheritTraverseOut,
    /* traverseInside          */ XtInheritTraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* multiCol */
   {
    /* empty		       */ 0
   },
};

WidgetClass multiColWidgetClass = (WidgetClass) & multiColClassRec;

#define ForAllChildren(cw, child) \
        for ( (child) = (cw)->composite.children ; \
                (child) < ((cw)->composite.children + \
                (cw)->composite.num_children ) ; \
                (child)++ )

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Resize(w)
Widget w;
{
	Layout(w);
}

static XtGeometryResult GeometryManager(w , request , reply)
Widget w;
XtWidgetGeometry * request;
XtWidgetGeometry * reply;
{

        return XtGeometryYes;
}


static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
        MultiColWidget cw = (MultiColWidget) w;
	XtWidgetGeometry pref_geom , inten_geom;
	Widget *child;
	Dimension width , height;
	Position x,y;
	int maxwidth,maxheight,nm,ncol,diff,diffp;
	
	multiColClassRec.baseConst_class.get_internal_dimension(w , &x , &y , &width,&height);

	preferred->request_mode = CWWidth | CWHeight;
	preferred->width = cw->core.width - width + cw->multiCol.spacing;
	preferred->height = cw->core.height - height + cw->multiCol.spacing;
	
	inten_geom.request_mode = CWWidth | CWHeight;
	inten_geom.width = width;
	inten_geom.height = height;

	nm = 0;

	maxheight = 0;
	maxwidth = 0;
	
	ForAllChildren(cw , child)
	{
		if (!XtIsManaged(*child)) continue;

		XtQueryGeometry(*child , &inten_geom , &pref_geom);		

		maxheight = MAX (pref_geom.height , maxheight);
		maxwidth = MAX (maxwidth , pref_geom.width);

		nm ++;
	}

	ncol = 0;
	diff = 20000000;
	do
	{
		diffp = diff;
		ncol++;
		diff = abs((nm/ncol + (nm % ncol != 0)) * maxheight - ncol * maxwidth);
	}while(diffp > diff);

	ncol--;

	if (nm)
	{
		preferred->width = preferred->width +
			 ncol * (maxwidth + cw->multiCol.spacing) + (cw->core.width - width);

		preferred->height = preferred->height +
			(nm/ncol + (nm % ncol != 0)) * (maxheight + cw->multiCol.spacing) +
			(cw->core.height - height);
	}

	if (((intended->request_mode & (CWWidth | CWHeight))
		== (CWWidth | CWHeight)) &&
		intended->width == preferred->width &&
		intended->height == preferred->height)
		return XtGeometryYes;

	else if (preferred->width == cw->core.width &&
		preferred->height == cw->core.height)

	return XtGeometryNo;

	else return XtGeometryAlmost;
        
}

static void ChangeManaged(w)
Widget w;
{
	if (!XtIsRealized(w))
	{
		XtWidgetGeometry pref_geom , inten_geom;

		inten_geom.request_mode = CWWidth | CWHeight;
		inten_geom.width = w->core.width;
		inten_geom.height = w->core.height;

		((MultiColWidgetClass)XtClass(w))->core_class.query_geometry(w ,
			&inten_geom , &pref_geom);

		if (!w->core.width) w->core.width = pref_geom.width;
		if (!w->core.height) w->core.height = pref_geom.height;
	}
	Layout(w);
}

static void Layout(w)
Widget w;
{
        MultiColWidget cw = (MultiColWidget) w;
	XtWidgetGeometry pref_geom , inten_geom;
	Widget *child;
	Dimension width , height;
	Position x,y;
	int maxwidth,maxheight,nrow,nm,col,row;

	multiColClassRec.baseConst_class.get_internal_dimension(w , &x , &y , &width,&height);

	inten_geom.request_mode = CWWidth | CWHeight;
	inten_geom.width = width;
	inten_geom.height = height;

	nm = 0;

	maxheight = 0;
	maxwidth = 0;

	ForAllChildren(cw , child)
	{
		if (!XtIsManaged(*child)) continue;

		XtQueryGeometry(*child , &inten_geom , &pref_geom);		

		maxheight = MAX (pref_geom.height , maxheight);
		maxwidth = MAX (maxwidth , pref_geom.width);
		nm++;
	}

	if (nm)
	{
		nrow = (height - cw->multiCol.spacing) /
			(maxheight + cw->multiCol.spacing);

		col = 0;
		row = 0;

		ForAllChildren(cw , child)
		{
			if (!XtIsManaged(*child)) continue;


			XtMoveWidget(*child , x + cw->multiCol.spacing + 
				col * (maxwidth + cw->multiCol.spacing) ,
				y + cw->multiCol.spacing +
				row * (maxheight + cw->multiCol.spacing));

			row++;

			if (row == nrow)
			{
				row = 0;
				col++;
			}
		}
	}
}
