/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include	"LineMEP.h"
#include	"Init.h"

static void ClassInitialize();
static void Initialize();
static void Redisplay ();

static XtResource resources[] = {
        {
         XtNheight ,
         XtCHeight ,
         XtRDimension ,
         sizeof(Dimension) ,
         XtOffsetOf(RectObjRec,rectangle.height) ,
         XtRImmediate ,
         (XtPointer) 2
        },
};

LineMEClassRec lineMEClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &baseMEClassRec,
    /* class_name            */ "LineME",
    /* widget_size           */ sizeof(LineMERec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ Initialize,
    /* initialize_hook       */ NULL,
    /* rect1                 */ NULL,
    /* rect2                 */ NULL,
    /* rect3                 */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* rect4                 */ False,
    /* rect5                 */ False,
    /* rect6                 */ False,
    /* rect7                 */ False,
    /* destroy               */ NULL,
    /* resize                */ XtInheritResize,
    /* expose                */ Redisplay,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* rect9                 */ NULL,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* rect10                */ NULL,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* rect11                */ NULL,
    /* extension             */ NULL
   },
/* baseME */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* enternotify	       */ NULL,
    /* leavenotify	       */ NULL,
    /* activate		       */ NULL,
   },
/* lineME */
   {
   /* empty		       */ 0
   }
};

WidgetClass lineMEObjectClass = (WidgetClass) &lineMEClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	LineMEObject nw = (LineMEObject) new_widget;
	Display * dpy = XtDisplayOfObject(new_widget);
	XGCValues gc_res;
	XtGCMask  gc_mask;

	gc_res.foreground = nw->baseME.foreground;
	gc_mask = GCForeground ;

	nw->lineME.gc = XCreateGC(dpy,DefaultRootWindow(dpy),
		gc_mask, &gc_res);

}

static void Redisplay(w , event , region)
Widget w;
XEvent *event;
Region region;
{
	LineMEObject cw = (LineMEObject) w;
	Display * dpy = XtDisplayOfObject(w);
	Window win = XtWindowOfObject(w);

	XSetForeground(dpy , cw->lineME.gc , cw->baseME.dark);
	XFillRectangle(dpy , win , cw->lineME.gc , cw->rectangle.x , cw->rectangle.y ,
		cw->rectangle.width , cw->rectangle.height / 2);

	XSetForeground(dpy , cw->lineME.gc , cw->baseME.light);
	XFillRectangle(dpy , win , cw->lineME.gc , cw->rectangle.x , cw->rectangle.y +
		cw->rectangle.height / 2  , cw->rectangle.width , cw->rectangle.height);

}
