/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _BaseCompP_H_
#define _BaseCompP_H_

#include <X11/Composite.h>
#include <Nws/BaseComp.h>
#include <Nws/dimdefP.h>

typedef struct {
	get_internal_dimension_Proc	get_internal_dimension;
	set_internal_dimension_Proc	set_internal_dimension;
	traverse_Proc			traverse;
	traverseTo_Proc			traverseTo;
	traverseOut_Proc		traverseOut;
	traverseInside_Proc		traverseInside;
	highlightBorder_Proc		highlightBorder;
	unhighlightBorder_Proc		unhighlightBorder;
} BaseCompClassPart;

typedef struct _BaseCompClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	BaseCompClassPart	baseComp_class;
} BaseCompClassRec;

extern BaseCompClassRec baseCompClassRec;

typedef struct _BaseCompPart {
	/* public resources */
	Boolean		highlight_on_enter;
	int		help_show_delay;
	Cursor		cursor;
	int		box_type;
	int		box_width;
	int		box_intensity;
	Pixel		box_color;
	XFontStruct	*font;
	String		label;
	String		help_text;
	Pixel		foreground;
	int		justify;
	int		traverse_direction;
	int		bd_width;
	Pixel		bd_color;
	/* private */
	XtIntervalId	timer;
	Widget		hlp;
	GC		gc;
	Pixel		dark,light;
	Boolean		have_shape;
	Boolean		focused;
	Boolean		traverse;
	Widget		current_focused;
} BaseCompPart;

typedef struct _BaseCompRec {
	CorePart	core;
	CompositePart	composite;
	BaseCompPart	baseComp;
} BaseCompRec;

#endif
