#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Default community names of the SNMP Agent";
 script_name(english:name["english"]);
 
 desc["english"] = "By allowing remote users access to the SNMP Agent with the well known public
community names, remote attackers may gain very valuable information
(depending on which MIBs are installed) about the system and networks they
are attacking. Also if a 'writeall' access can be gained, this could be a
huge security hole, enabling attackers to wreck complete havoc, route
packets and etc.

Risk factor : High

More Information:
http://www.securiteam.com/exploits/Windows_NT_s_SNMP_service_vulnerability.html
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Default community names of the SNMP Agent";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);

 
 exit(0);
}

#
# The script code starts here
#

for (i = 0; i < 3; i = i + 1)
{
	srcaddr = this_host();
	dstaddr = get_host_ip();

	if (i == 0)
	{
	 community = "public";
	}
	if (i == 1)
	{
	 community = "private";
	}
	if (i == 2)
	{
	 community = "system";
	}


	SNMP_BASE = 35;
	COMMUNITY_SIZE = strlen(community);
	RAW_COMMUNITY_SIZE = strtoint(number:COMMUNITY_SIZE, size:1);

	sendata = raw_string(
		0x30, 0x82, 0x00, 0x25, 
		0x02, 0x01, 0x00, 0x04) +
		RAW_COMMUNITY_SIZE + community +
		raw_string( 0xA1, 
		0x18, 0x02, 0x01, 0x01, 
		0x02, 0x01, 0x00, 0x02, 
		0x01, 0x00, 0x30, 0x0D, 
		0x30, 0x82, 0x00, 0x09, 
		0x06, 0x05, 0x2B, 0x06, 
		0x01, 0x02, 0x01, 0x05, 
		0x00); #35 + 6 (public)

	

	dstport = 161;
	soc = open_sock_udp(dstport);
	send(socket:soc, data:sendata);
	result = recv(socket:soc, length:4096);
	if (result)
	{
	  hole_data = string("SNMP Agent responded as expected with community name: ", community);
	  security_hole(port:161, data:hole_data);
	}
	close(soc);
}
