#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "NetBeans Java IDE";
 name["francais"] = "NetBeans Java IDE";
 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote host is running NetBeans (recently renamed to
Forte') Java IDE. There is a bug in this version that allows
anyone to browse the files on this system.


Solution : Set the HTTP server 'Enable' to FALSE in Project settings
Risk factor : High";

 desc["francais"] = "
Le systme distant fait tourner l'IDE Java NetBeans (renomm rcemment Forte')
Il y a un problme dans cette version qui permet  n'importe qui
de browser les fichiers prsents sur ce systme.

Solution : Mettez le 'Enable' de HTTP Server  FAUX dans les project settings
";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "determines whether the remote root directory is browseable";
 summary["francais"] = "determines whether the remote root directory is browseable";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Remote file access";
 family["francais"] = "Accs aux fichiers distants";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 8082);
 exit(0);
}

#
# The script code starts here
#

if(get_port_state(8082))
{
 port = 8082;
if(get_port_state(port))
{
  soc = open_sock_tcp(port);
 if(soc)
 {
  buffer = string("GET / HTTP/1.0\r\n\r\n");
  send(socket:soc, data:buffer);
  data = recv(socket:soc, length:2048);
  data_low = tolower(data);
  seek = "<title>index of /</title>";
  if(seek >< data_low)
  {
   security_hole(port);
  }
  close(soc);
  exit(0);
 } 
}
}
#
# NetBeans might be running on another port.
# 
port = get_kb_item("Services/www");
if(!port)exit(0);
if(port != 80)
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buffer = string("GET / HTTP/1.0\r\n\r\n");
  send(socket:soc, data:buffer);
  data = recv(socket:soc, length:2048);
  data_low = tolower(data);
  seek = "<title>index of /</title>";
  if(seek >< data_low)
  {
   security_hole(port);
  }
  close(soc);
 }
}
