#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Microsoft Frontpage exploits";
 name["francais"] = "Exploits Microsoft Frontpage"; 
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote web server appears to be running with
Frontpage extensions. 

You should double check the configuration since
a lot of security problems have been found with
FrontPage when the configuration file is
not well set up.

Risk factor : High if your configuration file is
not well set up";

 desc["francais"] = "
Le serveur web distant semble tourner avec
des extensions Frontpage.

Vous devriez vrifier votre configuration puisque
de nombreux problmes de scurit sont lis a la mauvaise
configuration de ces extensions.

Facteur de risque : Elev si votre fichier de configuration
n'est pas bien fait";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of Microsoft Frontpage extensions";
 summary["francais"] = "Vrifie la prsence des extensions Frontpage";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port) port = 80;

if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  str = string("POST /_vti_bin/shtml.exe/_vti_rpc HTTP/1.0\r\n\r\n");
  send(socket:soc, data:str);
  buf = recv_line(socket:soc, length:1024);
  buf = tolower(buf);
  if(("http/1.1 200" >< buf)||("http/1.0 200" >< buf))
  {
   security_warning(port);
   set_kb_item(name:"www/frontpage", value:TRUE);
  }
  close(soc);
 }
}
