/*
	float24.c - animate float24

	Author:	 Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern void XSlideshowRemoveWorkProc P_((int));
extern int XSlideshowAddWorkProc P_((void (*)(), dword, caddr_t));

static int curWindowIdx = -1;
static int freeWindowIdx = 0;
static int totalWindowIdx = 0;

typedef struct _FLOAT24_WINDOWS {
	Window	w;
	int		pId;
	int		sx,sy;
	int		ex,ey;
	long	start;
} FLOAT24_WINDOWS;
static FLOAT24_WINDOWS float24Windows[MAX_WINDOW_NUM];


/* move window */
#if defined(__STDC__) || defined(__cplusplus)
void removeFloat24Window(int idx)
#else
void removeFloat24Window(idx)
int idx;
#endif
{
	if(float24Windows[idx].w != (Window)0){

		XSlideshowRemoveWorkProc(float24Windows[idx].pId);
		XDestroyWindow(theDisp,float24Windows[idx].w);

		float24Windows[idx].pId = -1;
		float24Windows[idx].w = (Window)0;

	}
}

/*
* Move the window on the Bresenham line
*/
#if defined(__STDC__) || defined(__cplusplus)
static int sign(int x)
#else
static int sign(x)
int x;
#endif
{
	if(x == 0)     return(0);
	else if(x > 0) return(1);
	else		   return(-1);
}

#if defined(__STDC__) || defined(__cplusplus)
void float24(int idx)
#else
void float24(idx)
int idx;
#endif
{
int  i,j;
int  step,x1,y1,x2,y2;
int  x,y,dx,dy,sx,sy;
int  prex,prey,incli;
int  e,cons1,cons2;
Window w;
struct timeval tp;
struct timezone tzp;
long now;

	if(float24Windows[idx].w == (Window)0)
		return;

	/* Get now time */
	gettimeofday(&tp, &tzp);
	now = tp.tv_sec;
	if((now - float24Windows[idx].start) > app_data.floatImageLifeTime) {
		removeFloat24Window(idx);
		return;
	}

	x1 = float24Windows[idx].sx;
	y1 = float24Windows[idx].sy;
	x2 = float24Windows[idx].ex;
	y2 = float24Windows[idx].ey;
	w  = float24Windows[idx].w;

	step = app_data.float24Steps;
	prex = x1;
	prey = y1;

	dx = x2 - x1;
	dy = y2 - y1;
	sx = sign(dx);
	sy = sign(dy);
	dx = (dx < 0) ? -dx : dx; 
	dy = (dy < 0) ? -dy : dy; 

	if ( dy > dx ){
		incli = 1;
		cons2 = dx << 1;
		cons1 = cons2 - (dy << 1);
		e = (dx << 1) - dy;
		x = x1;
		y = y1 + sy;
		j = dy;
	}
	else{
		incli = 0;
		cons2 = dy << 1;
		cons1 = cons2 - (dx << 1);
		e = (dy << 1) - dx;
		y = y1;
		x = x1 + sx;
		j = dx;
	}

	for(i = 1; i <= j; i++){
		if(e > 0){
			if ( incli == 1 )
				x += sx;
			else
				y += sy;
			e += cons1;
		}
		else{
			e += cons2;
		}

		if(ABS(x,prex) > step || ABS(y,prey) > step){
			XMoveWindow(theDisp, w, x, y);
			float24Windows[idx].sx = x;
			float24Windows[idx].sy = y;
			return;
		}

		if(incli == 1)
			y += sy;
		else x += sx;
	}
	XMoveWindow(theDisp, w, x2, y2);

	/* Set next coordinate */
	x  = myrandom() % (windowWidth + app_data.floatImageSize) - app_data.floatImageSize;
	y  = myrandom() % (windowHeight + app_data.floatImageSize) - app_data.floatImageSize;

	float24Windows[idx].sx = x2;
	float24Windows[idx].sy = y2;
	float24Windows[idx].ex = x;
	float24Windows[idx].ey = y;
}

#if defined(__STDC__) || defined(__cplusplus)
void float24ShowImageWindow(Window *win,int x,int y,int w,int h)
#else
void float24ShowImageWindow(win,x,y,w,h)
Window *win;
int x,y,w,h;
#endif
{
Pixmap pic;
XSetWindowAttributes xswa;
XGCValues gcv;
GC gc;

	*win = XCreateSimpleWindow(theDisp,theWindow,x,y,w,h,0,bcol,bcol);
	xswa.override_redirect = True;
	XChangeWindowAttributes(theDisp,*win,CWOverrideRedirect,&xswa);

	pic = XCreatePixmap(theDisp,*win,w,h,DefaultDepth(theDisp,theScreenNumber));
	gcv.function = GXcopy;
	gcv.foreground = dbcol;
	gc = XCreateGC(theDisp,pic,GCForeground | GCFunction,&gcv);
	XFillRectangle(theDisp,pic,gc,0,0,w,h);
	XFreeGC(theDisp,gc);

	gcv.function = GXcopy;
	gc = XCreateGC(theDisp,pic,GCFunction,&gcv );
	XPutImage(theDisp,pic,gc,theImage,0,0,0,0,w,h);
	XSetWindowBackgroundPixmap(theDisp,*win,pic);
	XClearWindow(theDisp,*win);

	XFreePixmap(theDisp,pic);
	XFreeGC(theDisp,gc);

	XMapWindow(theDisp,*win);
}

static void createImage()
{
int	x,y,w,h,ex,ey;
Window Wd;
struct timeval tp;
struct timezone tzp;
long now;

	/* Get now time */
	gettimeofday(&tp, &tzp);
	now = tp.tv_sec;

	curWindowIdx++;
	totalWindowIdx++;

	if(totalWindowIdx >= MAX_WINDOW_NUM){

		/* Remove the most oldest window */
		if(float24Windows[freeWindowIdx].w != (Window)0){
			removeFloat24Window(freeWindowIdx);
		}
		curWindowIdx =	freeWindowIdx;
		freeWindowIdx++;
		totalWindowIdx--;
		if(freeWindowIdx >= MAX_WINDOW_NUM){
			freeWindowIdx = 0;
		}

	}

	x  = myrandom() % (windowWidth + app_data.floatImageSize) - app_data.floatImageSize;
	y  = myrandom() % (windowHeight + app_data.floatImageSize) - app_data.floatImageSize;
	ex = myrandom() % (windowWidth + app_data.floatImageSize) - app_data.floatImageSize;
	ey = myrandom() % (windowHeight + app_data.floatImageSize) - app_data.floatImageSize;

	w = gim.subImageList->width;
	h = gim.subImageList->height;
	float24ShowImageWindow(&Wd, x, y, w, h);
	float24Windows[curWindowIdx].w     = Wd;
	float24Windows[curWindowIdx].sx	   = x;
	float24Windows[curWindowIdx].sy	   = y;
	float24Windows[curWindowIdx].ex	   = ex;
	float24Windows[curWindowIdx].ey	   = ey;
	float24Windows[curWindowIdx].start = now;
	float24Windows[curWindowIdx].pId   = XSlideshowAddWorkProc(float24, app_data.float24Ticks, (caddr_t)curWindowIdx);
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xfloat24show(char *fname)
#else
ActionStatus xfloat24show(fname)
char *fname;
#endif
{
	PreDisplay2();
	createImage ();
	StoreColors(xcolors,gim.subImageList->mapsize);

	if(app_data.showFileName) {
		createFileNameWindow(fname);
		raiseFileNameWindow();
	}

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxfloat24show(char *fname)
#else
void postxfloat24show(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();
}

