(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*               Pierre Weis, projet Cristal, INRIA Rocquencourt       *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  only by permission.                                                *)
(*                                                                     *)
(***********************************************************************)
type type_simple and schma_de_types;;

val type_int : type_simple;;
val type_bool : type_simple;;
val type_flche : type_simple -> type_simple -> type_simple;;
val type_produit : type_simple -> type_simple -> type_simple;;
val type_liste : type_simple -> type_simple;;

val nouvelle_inconnue : unit -> type_simple;;
val unifie : type_simple -> type_simple -> unit;;
val gnralisation : type_simple -> schma_de_types;;
val spcialisation : schma_de_types -> type_simple;;
val schma_trivial : type_simple -> schma_de_types;;
val dbut_de_dfinition : unit -> unit;;
val fin_de_dfinition : unit -> unit;;

exception Conflit of type_simple * type_simple;;
exception Circularit of type_simple * type_simple;;

val imprime_type : type_simple -> unit;;
val imprime_schma : schma_de_types -> unit;;
