###################################################################################################
# zmsfile.py
#
# $Id: zmsfile.py,v 1.3 2004/02/24 19:57:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.3 $
#
# Implementation of class ZMSFile (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from Globals import HTMLFile, Persistent
from sys import *
import string 
import urllib
# Product imports.
from _metadata import Metadata
from zmsobject import ZMSObject
import _blobfields
import _fileutil
import _globals


###################################################################################################
###################################################################################################
###   
###   C o n s t r u c t o r ( s )
###   
###################################################################################################
###################################################################################################

manage_addZMSFileForm = HTMLFile('manage_addzmsfileform', globals()) 
def manage_addZMSFile(self, lang, manage_lang, _sort_id, REQUEST, RESPONSE):
  """ manage_addZMSFile """
    
  if REQUEST['btn'] == self.getLangStr('BTN_INSERT',manage_lang):
    
    ##### Create ####
    id_prefix = _globals.id_prefix(REQUEST.get('id','e'))
    obj = ZMSFile(self.getNewId(id_prefix),_sort_id+1)
    self._setObject(obj.id, obj)
        
    oItem = getattr(self,obj.id)
    ##### Object State ####
    oItem.setObjStateNew(REQUEST)
    ##### Init Properties ####
    oItem.manage_changeProperties(lang,manage_lang,REQUEST,RESPONSE)
    ##### VersionManager ####
    oItem.onChangeObj(REQUEST)

    ##### Normalize Sort-IDs ####
    self.normalizeSortIds(id_prefix)
    
    # Return with message.
    message = self.getLangStr('MSG_INSERTED',manage_lang)%obj.display_type(REQUEST)
    RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s#_%s'%(self.absolute_url(),lang,manage_lang,urllib.quote(message),obj.id))
                
  else:         
    RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s'%(self.absolute_url(),lang,manage_lang))



###################################################################################################
###################################################################################################
###   
###   C l a s s
###   
###################################################################################################
###################################################################################################
class ZMSFile(ZMSObject, Metadata): 
        
    # Properties.
    # -----------
    meta_type = 'ZMSFile'
    icon = "misc_/zms/zmsfile.gif"
    icon_disabled = 'misc_/zms/zmsfile_disabled.gif'

    # Management Options.
    # -------------------
    manage_options = ( 
	{'label': 'TAB_EDIT',       'action': 'manage_main'},
	{'label': 'TAB_REFERENCES', 'action': 'manage_RefForm'},
	{'label': 'TAB_HISTORY',    'action': 'manage_UndoVersionForm'},
	{'label': 'TAB_PREVIEW',    'action': 'preview_html'}, # empty string defaults to index_html
	)

    # Management Permissions.
    # -----------------------
    __authorPermissions__ = (
		'manage','manage_main','manage_workspace',
		'manage_moveObjUp','manage_moveObjDown',
		'manage_cutObjects','manage_copyObjects','manage_pasteObjs',
		'manage_changeProperties',
		'manage_userForm','manage_user',
		)
    __ac_permissions__=(
		('ZMS Author', __authorPermissions__),
		)

    # Properties.
    # -----------
    __obj_attrs__ = {
        # Changed by
        'change_uid':{'datatype':'string','multilang':1,'xml':0,'lang_inherit':0},
        'change_dt':{'datatype':'datetime','multilang':1,'xml':0,'lang_inherit':0},
        # Properties
        'sort_id':{'datatype':'string','xml':0},
        'active':{'datatype':'boolean','multilang':1},
        'attr_active_start':{'datatype':'datetime','multilang':1},
        'attr_active_end':{'datatype':'datetime','multilang':1},
        'title':{'datatype':'string','multilang':1,'size':40},
        'titleshort':{'datatype':'string','multilang':1,'size':20},
        'file':{'datatype':'file','multilang':1},
        # Meta-Data
        'attr_dc_coverage':{'datatype':'string'},
        # Meta-Dictionaries
        '$metadict':{'datatype':'MetaDict'},
    }


    # Management Interface.
    # ---------------------
    manage_main = HTMLFile('dtml/zmsfile/manage_main',globals()) 


    """
    ###############################################################################################    
    #
    #   CONSTRUCTOR
    #
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSFile.recurse_updateVersion:
    #
    #  Update version.
    # ---------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST):
      message = ''
        
      # Process super-objects.
      message += ZMSObject.recurse_updateVersion(self,REQUEST)
        
      # Process object.
      # [...]
      
      # Return with message.
      return message


    # ---------------------------------------------------------------------------------------------
    #  ZMSFile.getLinkList: 
    #
    #  Returns ZMSFile as link-URL.
    # ---------------------------------------------------------------------------------------------
    def getLinkList(self,REQUEST, allow_none=0):
      rtn = []
      append = 1
      append = append and self.isVisible(REQUEST)
      append = append and not self.isResource(REQUEST) # Object is not resource.
      if append:
        dct = {}
        dct['internal'] = 1
        dct['src'] = self
        dct['dst'] = self
        if self.getFile(REQUEST) is None:
          dct['url'] = ''
        else:
          dct['url'] = self.getFile(REQUEST).getHref(REQUEST)
        dct['title'] = self.getTitle(REQUEST)
        dct['description'] = _globals.nvl(self.getObjProperty('attr_dc_description',REQUEST),'')
        rtn.extend([dct])
      return rtn


    """
    ###############################################################################################    
    ###
    ###   P r o p e r t i e s
    ###
    ###############################################################################################    
    """

    ###############################################################################################
    #  ZMSFile.manage_changeProperties:
    #
    #  Change file properties.
    ###############################################################################################
    def manage_changeProperties(self, lang, manage_lang, REQUEST, RESPONSE):
      """ ZMSFile.manage_changeProperties """
      message = ''
      
      redirect_self = 0
      redirect_self = redirect_self or REQUEST.get('btn','') == '' 
      redirect_self = redirect_self and not REQUEST.get('btn','') == self.getLangStr('BTN_CANCEL',manage_lang)
      
      if REQUEST.get('btn','') != self.getLangStr('BTN_CANCEL',manage_lang):
      
        ##### Object State ####
        self.setObjStateModified(REQUEST)
        
        ##### Properties ####
        # Metadata.
        self.setMetadata(lang,manage_lang,REQUEST)
        # Active.
        self.setReqProperty('active',REQUEST)
        self.setReqProperty('attr_active_start',REQUEST)
        self.setReqProperty('attr_active_end',REQUEST)
        # Title.
        self.setReqProperty('title',REQUEST)
        self.setReqProperty('titleshort',REQUEST)
        # File.
        self.setReqProperty('file',REQUEST)
        file = self.getFile(REQUEST)
        if file is not None:
          if len(self.getObjProperty('title',REQUEST)) == 0:
            self.setObjProperty('title',getattr(file,'filename',''),lang)
          if len(self.getObjProperty('titleshort',REQUEST)) == 0:
            self.setObjProperty('titleshort',getattr(file,'filename',''),lang)
        
        ##### Blobs ####
        _blobfields.synchronizeBlobFields(self)
        
        ##### VersionManager ####
        self.onChangeObj(REQUEST)
        
        ##### Message ####
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      # Return with message.
      if redirect_self:
        return RESPONSE.redirect('manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,urllib.quote(message)))
      else:
        self.checkIn(REQUEST)
        return RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s#_%s'%(self.getParentNode().absolute_url(),lang,manage_lang,urllib.quote(message),self.id))


    # ---------------------------------------------------------------------------------------------
    #  ZMSFile.isPageElement:
    # ---------------------------------------------------------------------------------------------
    def isPageElement(self): return 1

    # ---------------------------------------------------------------------------------------------
    #	ZMSFile.getTitle
    # ---------------------------------------------------------------------------------------------
    def getTitle(self,REQUEST): return self.getObjProperty('title',REQUEST)

    # ---------------------------------------------------------------------------------------------
    #	ZMSFile.getTitlealt
    # ---------------------------------------------------------------------------------------------
    def getTitlealt(self,REQUEST): return self.getObjProperty('titleshort',REQUEST)

    # ---------------------------------------------------------------------------------------------
    #	ZMSFile.getFile
    # ---------------------------------------------------------------------------------------------
    def getFile(self,REQUEST): return self.getObjProperty('file',REQUEST)

    # ---------------------------------------------------------------------------------------------
    #	ZMSFile.getMimeTypeIcon (DEPRECATED!)
    # ---------------------------------------------------------------------------------------------
    def getMimeTypeIcon(self,REQUEST): 
      f = self.getFile(REQUEST)
      return '<img src="%s" border="0" alt="%s">'%(f.getMimeTypeIconSrc(),f.getContentType())

    # ---------------------------------------------------------------------------------------------
    #	ZMSFile.getContentType:
    # ---------------------------------------------------------------------------------------------
    def getContentType(self,REQUEST): 
      f = self.getFile(REQUEST)
      return f.getContentType()

               
    """
    ###############################################################################################
    ###
    ###  H T M L - P r e s e n t a t i o n 
    ###
    ###############################################################################################
    """
    
    # preload display interface
    rendershort_default = HTMLFile('dtml/zmsfile/render_default', globals()) 
    rendershort_print = HTMLFile('dtml/zmsfile/render_print', globals()) 
    
    # ------------------------------------------------------------------------------------------
    #  ZMSFile.renderShort:
    #
    #  Renders short presentation of File.
    # ------------------------------------------------------------------------------------------
    def renderShort(self, REQUEST):
      # Retrieve properties.
      file = self.getFile(REQUEST)
      url = None
      if file is not None:
        url = file.getHref(REQUEST)
      html = self.rendershort_default(self,url=url,REQUEST=REQUEST)
      # Process html <form>-tags.
      html = _globals.form_quote(html,REQUEST)
      # Return <html>.
      return html

    # ------------------------------------------------------------------------------------------
    #  ZMSFile.printHtml:
    #
    #  Renders print presentation of a File.
    # ------------------------------------------------------------------------------------------
    def printHtml(self, level, sectionize, sectionizer, REQUEST):
      # Retrieve properties.
      file = self.getFile(REQUEST)
      url = None
      if file is not None:
        url = file.getHref(REQUEST)
      # Return <html>-presentation.
      return self.rendershort_print(self,url=url,REQUEST=REQUEST)

###################################################################################################
