##############################################################################
# Initialisation file for the ZMS Product for Zope
#
# $Id: __init__.py,v 1.1 2003/08/31 13:29:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.1 $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

"""ZMS Product"""

# Documentation string.
__doc__ = """initialization module."""
# Version string.
__version__ = '0.1'

# Imports.
from Globals import ImageFile
from App.Common import package_home
import OFS.misc_
import os
import stat
# Product Imports.
import zms
import zmsrubrik
import zmsdocument
import zmstextarea 
import zmsgraphic
import zmstable
import zmsfile
import zmsnote
import zmsteasercontainer
import zmsteaserelement
import zmscustom
import zmssqldb
import zmssysfolder
import zmslinkcontainer
import zmslinkelement
import _sequence
import _mediadb

###################################################################################################
# Define the initialize() function. 
###################################################################################################

def initialize(context): 
    """Initialize the product."""
    
    try: 
        """Try to register the product."""
        
        context.registerClass(
            zms.ZMS,
            permission = 'Add ZMSs',
            constructors = ( zms.manage_addZMSForm, zms.manage_addZMS ),
            icon = 'images/zms.gif'                
            )
        context.registerClass(
            zmssysfolder.ZMSSysFolder,
            permission = 'Add ZMSs',
            constructors = ( zmssysfolder.manage_addZMSSysFolderForm, zmssysfolder.manage_addZMSSysFolder ),
            icon = 'images/zmssysfolder.gif'
            )
        context.registerClass(
            zmsrubrik.ZMSRubrik,
            permission = 'Add ZMSs',
            constructors = ( zmsrubrik.manage_addZMSRubrikForm, zmsrubrik.manage_addZMSRubrik ),
            icon = 'images/zmsrubrik.gif'
            )
        context.registerClass(
            zmsdocument.ZMSDocument,
            permission = 'Add ZMSs',
            constructors = ( zmsdocument.manage_addZMSDocumentForm, zmsdocument.manage_addZMSDocument),
            icon = 'images/zmsdocument.gif'
            )
        context.registerClass(
            zmstextarea.ZMSTextarea,
            permission = 'Add ZMSs',
            constructors = (zmstextarea.manage_addZMSTextarea, zmstextarea.manage_addZMSTextarea),
            icon = 'images/zmstextarea.gif'
            )
        context.registerClass(
            zmsnote.ZMSNote,
            permission = 'Add ZMSs',
            constructors = (zmsnote.manage_addZMSNote, zmsnote.manage_addZMSNote),
            icon = 'images/zmsnote.gif'
            )
        context.registerClass(
            zmscustom.ZMSCustom,
            permission = 'Add ZMSs',
            constructors = (zmscustom.manage_addZMSCustomForm, zmscustom.manage_addZMSCustom),
            icon = 'images/zmsdocument.gif'
            )
        context.registerClass(
            zmsteasercontainer.ZMSTeaserContainer,
            permission = 'Add ZMSs',
            constructors = (zmsteasercontainer.manage_addZMSTeaserContainer, zmsteasercontainer.manage_addZMSTeaserContainer),
            icon = 'images/zmsteaser.gif'
            )
        context.registerClass(
            zmsteaserelement.ZMSTeaserElement,
            permission = 'Add ZMSs',
            constructors = (zmsteaserelement.manage_addZMSTeaserElement, zmsteaserelement.manage_addZMSTeaserElement),
            icon = 'images/zmsteaser.gif'
            )
        context.registerClass(
            zmsgraphic.ZMSGraphic,
            permission = 'Add ZMSs',
            constructors = (zmsgraphic.manage_addZMSGraphic, zmsgraphic.manage_addZMSGraphic),
            icon = 'images/zmsgraphic.gif'
            )
        context.registerClass(
            zmstable.ZMSTable,
            permission = 'Add ZMSs',
            constructors = ( zmstable.manage_addZMSTableForm, zmstable.manage_addZMSTable),
            icon = 'images/zmstable.gif'
            )
        context.registerClass(
            zmsfile.ZMSFile,
            permission = 'Add ZMSs',
            constructors = ( zmsfile.manage_addZMSFileForm, zmsfile.manage_addZMSFile),
            icon = 'images/zmsfile.gif'
            )
        context.registerClass(
            zmssqldb.ZMSSqlDb,
            permission = 'Add ZMSs',
            constructors = (zmssqldb.manage_addZMSSqlDbForm, zmssqldb.manage_addZMSSqlDb),
            icon = 'images/zmssqldb.gif'
            )
        context.registerClass(
            zmslinkcontainer.ZMSLinkContainer,
            permission = 'Add ZMSs',
            constructors = (zmslinkcontainer.manage_addZMSLinkContainer, zmslinkcontainer.manage_addZMSLinkContainer),
            icon = 'images/zmslinkcontainer.gif'
            )
        context.registerClass(
            zmslinkelement.ZMSLinkElement,
            permission = 'Add ZMSs',
            constructors = (zmslinkelement.manage_addZMSLinkElementForm, zmslinkelement.manage_addZMSLinkElement),
            icon = 'images/zmslinkcontainer.gif'
            )
        context.registerClass(
            _sequence.Sequence,
            constructors = (_sequence.manage_addSequenceForm, _sequence.manage_addSequence),
            icon = 'images/acl_sequence.gif'
            )
        context.registerClass(
            _mediadb.MediaDb,
            constructors = (_mediadb.manage_addMediaDbForm, _mediadb.manage_addMediaDb),
            icon = 'images/acl_mediadb.gif'
            )
            
        context.registerBaseClass(zms.ZMS)
        
        # automated registration for other Images
        for img_path in ['images/','rte/images/']:
          path = package_home(globals()) + os.sep + img_path
          for file in os.listdir(path):
            filepath = path + os.sep + file 
            mode = os.stat(filepath)[stat.ST_MODE]
            if not stat.S_ISDIR(mode):
              registerImage(img_path,file)
    
    except:
        """If you can't register the product, dump error. 
        
        Zope will sometimes provide you with access to "broken product" and
        a backtrace of what went wrong, but not always; I think that only 
        works for errors caught in your main product module. 
        
        This code provides traceback for anything that happened in 
        registerClass(), assuming you're running Zope in debug mode."""
        
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb

def registerImage(img_path,s):
  """
  manual icon registration
  """
  icon=ImageFile(package_home(globals()) + os.sep + img_path + s)
  icon.__roles__ = None
  OFS.misc_.misc_.zms[s]=icon

###################################################################################################
