#####################################################################
#
# LDAPMembershipTool       LDAP-enabled CMF Membership Tool
#
# This software is governed by a license. See
# LICENSE.txt for the terms of this license.
#
#####################################################################
__version__='$Revision: 1.9 $'[11:-2]

from zLOG import LOG, ERROR, INFO, PROBLEM, DEBUG

import string
import DateTime
from AccessControl import ClassSecurityInfo
from Products.CMFCore.CMFCorePermissions import View
from Globals import InitializeClass
from Products.CMFDefault.MembershipTool import MembershipTool


class LDAPMembershipTool(MembershipTool):
    """ LDAP-enabled CMF Membership Tool """
    security = ClassSecurityInfo()
    meta_type = 'LDAP Membership Tool'
    title = 'LDAP Membership Tool'


    def __init__(self, id='portal_membership'):
        self.id = id


    def addMember(self, id, password, roles, domains, properties):
        """
            Adds a new member to the user folder.  Security checks will have
            already been performed.  Called by portal_registration.
        """
        args = {}
        acl = self.acl_users
        login_attr = acl.getProperty('_login_attr')
        
        args['user_pw'] = args['confirm_pw'] = password
        args[login_attr] = id
        args['user_roles'] = roles

        for key, val in properties.form.items():
            args[key] = val

        acl.manage_addUser(REQUEST=None, kwargs=args)
        self.createMemberarea(id)


    security.declareProtected(View, 'memberExists')
    def memberExists(self, properties):
        """ Does the incoming set of data collide with an existing member? """
        acl = self.acl_users
        rdn_attr = acl.getProperty('_rdnattr')
        login_attr = acl.getProperty('_login_attr')

        my_rdn = properties.get(rdn_attr, None)
        my_login = properties.get('username')

        if not acl.isUnique(login_attr, my_login):
            return 'Login name'

        if not acl.isUnique(rdn_attr, my_rdn):
            return 'Name'

        return 0
        

InitializeClass(LDAPMembershipTool)


def manage_addLDAPMembershipTool(self, REQUEST=None):
    """ Add an LDAP-based Membership Tool """

    tool_obj = LDAPMembershipTool()
    self._setObject(tool_obj.id, tool_obj)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST)


