#!/usr/local/bin/perl
# search.cgi
# Display a list of packages where the name or description matches some string

require './cluster-software-lib.pl';
&ReadParse();

$s = $in{'search'};
@hosts = &list_software_hosts();
foreach $h (@hosts) {
	foreach $p (@{$h->{'packages'}}) {
		if (($p->{'name'} =~ /\Q$s\E/i || $p->{'desc'} =~ /\Q$s\E/i) &&
		    !$already{$p->{'name'}}++) {
			push(@match, $p);
			}
		}
	}
if (@match == 1) {
	&redirect("edit_pack.cgi?package=".&urlize($match[0]->{'name'}));
	exit;
	}

&ui_print_header(undef, $text{'search_title'}, "", "search");
if (@match) {
	@match = sort { lc($a->{'name'}) cmp lc($b->{'name'}) } @match;
	print "<h3>",&text('search_match', "<tt>$s</tt>"),"</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'search_pack'}</b></td> ",
	      "<td><b>$text{'search_class'}</b></td> ",
	      "<td><b>$text{'search_desc'}</b></td> </tr>\n";
	foreach $i (@match) {
		print "<tr $cb>\n";
		print "<td><a href=\"edit_pack.cgi?search=$s&package=",
		      &urlize($i->{'name'}),"\">$i->{'name'}</a></td>\n";
		$c = $i->{'class'};
		print "<td>",$c ? $c : $text{'search_none'},"</td>\n";
		print "<td>$i->{'desc'}</td>\n";
		print "</tr>\n";
		}
	print "</table><p>\n";
	}
else {
	print "<h3>",&text('search_nomatch', "<tt>$s</tt>"),"</h3>\n";
	}

&ui_print_footer("", $text{'index_return'});

