<?php 	// TWIG		Common ToDo related functions ?>
<?php

 Function TWIGExpandToDoGroup( $groupid )
	{
	TWIGDebug( "TWIGExpandToDoGroup( \"" . $groupid . "\" );" );

	$members = TWIGGroupsMembers( $groupid );

	for( $i = 0, $j = count( $members ); $i < $j; $i++ )
		{
		if( $ret ) { $ret .= ", "; }
		$entry["email"] = $members[$i];
		$ret .= TWIGExpandToDoEntry( $entry, $subentry = "1" );
		}

	return $ret;
	}

 Function TWIGExpandToDoList( $listid )
	{
	GLOBAL $config, $dbconfig;

	TWIGDebug( "TWIGExpandToDoList( \"" . $listid . "\" );" );

	$ret = "";

	$query = "SELECT * FROM " . $dbconfig["todo_lists_entries_table"] . " WHERE listid = '" . $listid . "'";
	$result = dbquery( $query );

	$listq = "SELECT * FROM " . $dbconfig["todo_table"] . " WHERE";

	for( $i = 0, $j = dbNumRows( $result ), $k = 0; $i < $j; $i++ )
		{
		$data = dbResultArray( $result, $i );

		if( $data["type"] == 2 )
			{
			if( $ret != "" ) { $ret .= ", "; }
			$ret .= TWIGExpandToDoGroup( $data["item"] );
			}
		else
			{
			if( $k != 0 ) { $listq .= " OR"; $k++; }

			$listq .= " id = '" . $data["item"] . "'";
			$subparts[$data["item"]] = $data["subitem"];
			}
		}

	$listr = dbquery( $listq );

	for( $i = 0, $j = dbNumRows( $listr ); $i < $j; $i++ )
		{
		$listd = dbResultArray( $listr, $i );
		
		if( $ret != "" ) { $ret .= ", "; }
		$ret .= TWIGExpandToDoEntry( $listd, $subparts[$listd["id"]] );
		}

	return $ret;
	}

 Function TWIGExpandToDoEntry( $entry, $subentry = "1" )
	{
	GLOBAL $config;

	TWIGDebug( "TWIGExpandToDoEntry( \$entry, \"" . $subentry . "\" );" );

	if( $entry["firstname"] ) { $fullname = $entry["firstname"]; } else { $fullname = ""; }
	if( $entry["lastname"] )
		{
		if( $entry["firstname"] ) { $fullname .= " "; }
		$fullname .= $entry["lastname"];
		}

	$fullname = trim( $fullname );

	switch( $subentry )
		{
		case 2:
			$emailparts = explode( "@", $entry["email2"] );
			break;
		case 3:
			$emailparts = explode( "@", $entry["email3"] );
			break;
		default:
			$emailparts = explode( "@", $entry["email"] );
		}

	if( $emailparts[1] ) { $host = $emailparts[1]; } else { $host = $config["fromdomain"]; }

	$ret = "";
	if( $fullname ) { $ret .= "\"" . $fullname . "\" "; }
	$ret .= "<" . $emailparts[0] . "@" . $host . ">";

	return $ret;
	}

 Function TWIGToDoReplace( $str )
	{
	GLOBAL $login, $dbconfig, $groupquery, $config;

	TWIGDebug( "TWIGToDoReplace( \"" . $str . "\" );" );

	$ToDoEnabled = TWIGCheckACL( $login["username"], 2003, TWIGConvertAccess( "read" ) );

	$addresses = imap_rfc822_parse_adrlist( TWIGProcessGPCString( $str ), "" );
	$out = "";

	for( $i = 0, $j = count( $addresses ); $i < $j; $i++ )
		{
		if( !$addresses[$i]->host )
			{
			$caddress = "";

			if( $ToDoEnabled )
				{
				$query = "SELECT * FROM " . $dbconfig["todo_table"] . " WHERE ( $groupquery ) AND item = '" . $addresses[$i]->mailbox . "'";
				$result = dbQuery( $query );

                                if( dbNumRows( $result ) > 0 )
                                        {
                                        $data = dbResultArray( $result, 0 );

					if( $data["type"] == 2 )
						{
						$caddress = TWIGExpandToDoList( $data["id"] );
						}
					else
						{
						$caddress = TWIGExpandToDoEntry( $data, 1 );
						}
					}
				}
			
			if( $caddress == "" ) 
				{
				if( $addresses[$i]->personal ) { $caddress .= "\"" . $addresses[$i]->personal . "\" "; }
				$caddress .= "<" . $addresses[$i]->mailbox . "@" . $config["fromdomain"] . ">";
				}
			}

		// reassemble the adsress string properly
		if( $i > 0 ) { $out .= ", "; }
		$out .= $caddress;
		}

	TWIGDebug( "TWIGToDoReplace() returns: " . $out );
	return $out;
	}

 Function TWIGGenerateToDoList()
	{
	GLOBAL $config, $dbconfig, $login;

	$grouplist  = TWIGGroupsMembership( $login["username"] );

 	$sortorder = array( "nickname"=>"item", "name"=>"lastname,firstname", "company"=>"company", "group"=>"groupid", "email"=>"email" );
 	$orderby = $sortorder[GetPref( "sortby", $dbconfig["todo_prefs_table"], $config["defaults"]["todo"]["sortby"] )];
 	if( !$orderby ) { $orderby = "item"; }

	$query = "SELECT item, firstname, lastname, email, email2, email3, type FROM " . $dbconfig["todo_table"] . " WHERE " . TWIGGroupsCreateSQLGroupQuery( $login["username"], $grouplist ) . " ORDER BY " . $orderby;

	$result = dbquery( $query );

	for( $i = 0, $j = dbnumrows( $result ); $i < $j; $i++ )
		{
		$data = dbresultarray( $result, $i );

		$personal = trim( $data["firstname"] . " " . $data["lastname"] );
		if( $data["email"]  )
			{
			$ret .= "<option>";
			if( $personal ) {$ret .= "&quot;$personal&quot; ";}
			$ret .= "&lt;" . $data["email"]  . "&gt;</option>";
			}
		if( $data["email2"] )
			{
			$ret .= "<option>";
			if ($personal) {$ret .= "&quot;$personal&quot; ";}
			$ret .= "&lt;" . $data["email2"] . "&gt;</option>";
			}
		if( $data["email3"] )
			{
			$ret .= "<option>";
			if ($personal) {$ret .= "&quot;$personal&quot; ";}
			$ret .= "&lt;" . $data["email3"] . "&gt;</option>";
			}
		if( $data["type"] == 2 )
			{
			$ret .= "<option value=\"" . $data["item"] . "\">List: " . $data["item"] . "</option>";
			}
		}
	
	return $ret;
	}

 $included["features/shared/todo.inc.php3"] = 1;

?>
