<?php 	// TWIG		Common Contact related functions ?>
<?php

 Function TWIGExpandContactsGroup( $groupid )
	{
	TWIGDebug( "TWIGExpandContactsGroup( \"" . $groupid . "\" );" );

	$members = TWIGGroupsMembers( $groupid );

	for( $i = 0, $j = count( $members ); $i < $j; $i++ )
		{
		if( $ret ) { $ret .= ", "; }
		$entry["email"] = $members[$i];
		$ret .= TWIGExpandContactsEntry( $entry, $subentry = "1" );
		}

	return $ret;
	}

 Function TWIGExpandContactsList( $listid )
	{
	GLOBAL $config, $dbconfig;

	TWIGDebug( "TWIGExpandContactsList( \"" . $listid . "\" );" );

	$ret = "";

	$query = "SELECT * FROM " . $dbconfig["contacts_lists_entries_table"] . " WHERE listid = '" . $listid . "'";
	$result = dbquery( $query );

	$listq = "SELECT * FROM " . $dbconfig["contact_table"] . " WHERE";

	for( $i = 0, $j = dbNumRows( $result ), $k = 0; $i < $j; $i++ )
		{
		$data = dbResultArray( $result, $i );

		if( $data["type"] == 2 )
			{
			if( $ret != "" ) { $ret .= ", "; }
			$ret .= TWIGExpandContactsGroup( $data["item"] );
			}
		else
			{
			if( $k != 0 ) { $listq .= " OR"; }

			$k++;
			$listq .= " id = '" . $data["item"] . "'";
			$subparts[$data["item"]] = $data["subitem"];
			}
		}

	if( $k != 0 )
  		{
		$listr = dbquery( $listq );

		for( $i = 0, $j = dbNumRows( $listr ); $i < $j; $i++ )
			{
			$listd = dbResultArray( $listr, $i );
			
			if( $ret != "" ) { $ret .= ", "; }
			$ret .= TWIGExpandContactsEntry( $listd, $subparts[$listd["id"]] );
			}
		}

	return $ret;
	}

 Function TWIGExpandContactsEntry( $entry, $subentry = "1" )
	{
	GLOBAL $config;

	TWIGDebug( "TWIGExpandContactsEntry( \$entry, \"" . $subentry . "\" );" );

	if( $entry["firstname"] ) { $fullname = $entry["firstname"]; } else { $fullname = ""; }
	if( $entry["lastname"] )
		{
		if( $entry["firstname"] ) { $fullname .= " "; }
		$fullname .= $entry["lastname"];
		}

	$fullname = trim( $fullname );

	switch( $subentry )
		{
		case 2:
			$emailparts = explode( "@", $entry["email2"] );
			break;
		case 3:
			$emailparts = explode( "@", $entry["email3"] );
			break;
		default:
			$emailparts = explode( "@", $entry["email"] );
		}

	if( $emailparts[1] ) { $host = $emailparts[1]; } else { $host = $config["fromdomain"]; }

	$ret = "";
	if( $fullname ) { $ret .= "\"" . $fullname . "\" "; }
	$ret .= "<" . $emailparts[0] . "@" . $host . ">";

	return $ret;
	}

 Function TWIGContactReplace( $str )
	{
	GLOBAL $login, $dbconfig, $config;

	TWIGDebug( "TWIGContactReplace( \"$str\" );" );

	$grouplist  = TWIGGroupsMembership( $login["username"] );
	$grouplist[] = 0;

	$gquery = TWIGGroupsCreateSQLGroupQuery( $login["username"], $grouplist );

	$ContactsEnabled = TWIGCheckACL( $login["username"], 2003, TWIGConvertAccess( "read" ) );

	$addresses = imap_rfc822_parse_adrlist( TWIGProcessGPCString( $str ), "" );
	$out = "";

	for( $i = 0, $j = count( $addresses ); $i < $j; $i++ )
		{
		$caddress = "";

		if( !$addresses[$i]->host )
			{
			if( $ContactsEnabled )
				{
				$query = "SELECT * FROM " . $dbconfig["contact_table"] . " WHERE (" . $gquery . ") AND item = '" . $addresses[$i]->mailbox . "'";
				$result = dbQuery( $query );

                                if( dbNumRows( $result ) > 0 )
                                        {
                                        $data = dbResultArray( $result, 0 );

					if( $data["type"] == 2 )
						{
						$caddress = TWIGExpandContactsList( $data["id"] );
						}
					else
						{
						$caddress = TWIGExpandContactsEntry( $data, 1 );
						}
					}
				}
			
			if( $caddress == "" ) 
				{
				if( $addresses[$i]->personal ) { $caddress .= "\"" . $addresses[$i]->personal . "\" "; }
				$caddress .= "<" . $addresses[$i]->mailbox . "@" . $config["fromdomain"] . ">";
				}
			}
		else
			{
			if( $addresses[$i]->personal ) { $caddress .= "\"" . $addresses[$i]->personal . "\" "; }
			$caddress .= "<" . $addresses[$i]->mailbox . "@" . $addresses[$i]->host . ">";
			}

		// reassemble the adsress string properly
		if( $i > 0 ) { $out .= ", "; }
		$out .= $caddress;
		}

	TWIGDebug( "TWIGContactReplace() returns: " . $out );
	return $out;
	}

 Function TWIGGenerateContactsList()
	{
	GLOBAL $config, $dbconfig, $login;

	$grouplist  = TWIGGroupsMembership( $login["username"] );

	//Add Unfiled group
	$grouplist[] = 0;

 	$sortorder = array( "nickname"=>"item", "name"=>"lastname,firstname", "company"=>"company", "group"=>"groupid", "email"=>"email" );
 	$orderby = $sortorder[GetPref( "sortby", $dbconfig["contacts_prefs_table"], $config["defaults"]["contacts"]["sortby"] )];
 	if( !$orderby ) { $orderby = "item"; }

	$query = "SELECT item, firstname, lastname, email, email2, email3, type FROM " . $dbconfig["contact_table"] . " WHERE " . TWIGGroupsCreateSQLGroupQuery( $login["username"], $grouplist ) . " ORDER BY " . $orderby;

	$result = dbquery( $query );

	for( $i = 0, $j = dbnumrows( $result ); $i < $j; $i++ )
		{
		$data = dbresultarray( $result, $i );

		$personal = trim( $data["firstname"] . " " . $data["lastname"] );
		if( $data["email"]  )
			{
			$ret .= "<option>";
			if( $personal ) {$ret .= "&quot;$personal&quot; ";}
			$ret .= "&lt;" . $data["email"]  . "&gt;</option>";
			}
		if( $data["email2"] )
			{
			$ret .= "<option>";
			if ($personal) {$ret .= "&quot;$personal&quot; ";}
			$ret .= "&lt;" . $data["email2"] . "&gt;</option>";
			}
		if( $data["email3"] )
			{
			$ret .= "<option>";
			if ($personal) {$ret .= "&quot;$personal&quot; ";}
			$ret .= "&lt;" . $data["email3"] . "&gt;</option>";
			}
		if( $data["type"] == 2 )
			{
			$ret .= "<option value=\"&quot;" . $data["item"] . "&quot;\">List: " . $data["item"] . "</option>";
			}
		}
	
	return $ret;
	}

 $included["features/shared/contacts.inc.php3"] = 1;

?>
