<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 *  CVS Info:  $Id: timetrack_overview.php,v 1.81.2.11 2005/01/11 14:44:30 tapoueh Exp $
 *  $Author: tapoueh $
 *
 * an overview of all booked times
 *
 * @modulegroup timetrack
 * @module timetrack_overview
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'timetrack.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('timetrack','overview');

 /**
  * show a overview of timetracks
  */
 class timetrack_overview extends layout {
   /**
    * display the info
    */
   Function info() {
     global $lang,$tutos;

     $n = $this->result->numrows();
     
     if ( $this->format == "xml" ) {
       if ( 0 != $n) {
         $a = new timetrack($this->dbconn);
         echo $a->exportXMLHeader();
         echo $a->exportXML_head();
         echo "<timetrack_set>\n";
         $x = 0;
         while ( $x < $n ) {
           $a = new timetrack($this->dbconn);
           $a->read_result($this->result,$x);
           echo $a->exportXML(false);
           $x++;
         }
         echo "</timetrack_set>\n";
       }
       return;		
     }
     else if ($this->format == "excel") {
       include_once 'excel/Worksheet.php';
       include_once 'excel/Workbook.php';

       header("Content-type: application/vnd.ms-excel");
       header("Content-Disposition: attachment; filename=TimetrackExport.xls");
       header("Expires: 0");
       header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
       header("Pragma: public");

       $tmpname = tempnam ($tutos[sessionpath], "timetrackexport");
       $workbook = new Workbook($tmpname);
       $worksheet1 =& $workbook->add_worksheet('TUTOS');

       $x = 0;

       $format1 =& $workbook->add_format();
       $format1->set_size(12);
       $format1->set_bold(1);
       $format1->set_align('center');

       $format2 =& $workbook->add_format();
       $format1->set_size(10);
       $format2->set_size(10);

       $worksheet1->set_column(0,0,5);
       $worksheet1->set_column(1,3,25);
       $worksheet1->set_column(1,4,50);
       $worksheet1->set_column(1,5,25);

       $c = 0;
       $worksheet1->write_string($x,$c++, "#",$format1);
       $worksheet1->write_string($x,$c++, $lang['TimetrackBooked'],$format1);
       $worksheet1->write_string($x,$c++, $lang['TTcph'],$format1);
       $worksheet1->write_string($x,$c++, $lang['Currency'],$format1);
       $worksheet1->write_string($x,$c++, $lang['Description'],$format1);
       $worksheet1->write_string($x,$c++, $lang['atDateTime'],$format1);

       $x++;
       $cnt = 0;
       while ( $cnt < $n ) {
         $a = new timetrack($this->dbconn);
         $a->read_result($this->result,$cnt);

		 $c = 0;
         $worksheet1->write_number($x,$c++, $a->id);
         $worksheet1->write_number($x,$c++, $a->volume,$format2);
         $worksheet1->write_number($x,$c++, $a->cph,$format2);
         $worksheet1->write_string($x,$c++, $a->currency,$format2);
         $worksheet1->write_string($x,$c++, $a->desc,$format2);
         $worksheet1->write_string($x,$c++, $a->wday->getDate(),$format2);
         $x++;
         $cnt++;
       }

       $workbook->close();
       $fh = fopen($tmpname, "rb");
       if ($fh == false) {
         die("Can't read temporary file.");
       }
       fpassthru($fh);
       fclose($fh);
       @unlink($tmpname);
       return;		
     }
     else if ($this->format == "stat") {
       $this->statinfo();
       $this->result->free();
         return;
     }
     else if ($this->format == "csv") {
       $this->exportinfo();
       $this->result->free();
       return;
     }

     $this->assign('action', "timetrack_overview.php");
  
     $sum['v'] = 0.0;
     $sum[''] = 0.0;
     @reset($tutos[currencies]);
     while( list ($ia,$c) = @each ($tutos[currencies])) {
       $sum[$c] = 0.0;
     }
  
     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     }
     else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }
  
     // Fill the sum
     $x = 0;
     while ( $x < $a ) {
       $sum['v'] += $this->result->get($x, "volume");
       $sum[$this->result->get($x, "currency")] +=
	  ( $this->result->get($x, "cph") * $this->result->get($x, "volume") );
       $x++;
     }

     /**
      * We plan to support extended mode with $this->search, which is
      * to be filled with all search fields.
      */
     $this->assign_navbar($a, $end, $n, $this->search);

     $tts = array();
  
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $tt = new timetrack($this->dbconn);
       $tt->read_result($this->result,$a);

       $cur_tt = array();

       if ( $tt->mod_ok() ) {
	 $cur_tt['id'] = array('name'  => sprintf("%03d",($a + 1)),
			       'link'  => $tt->getModURL(),
			       'title' => $lang['TimetrackModify'],
			       'image' => 'modify');
       }
       else {
	 $cur_tt['id'] = array('name'  => sprintf("%03d",($a + 1)),
			       'image' => 'no-modify');
       }

       if( $tt->ref != -1 )
	 $cur_tt['ref'] = array('name'  => $tt->ref->getFullName(),
				'link'  => $tt->ref->getUrl(),
				'title' => $tt->ref->getFullName());
       else
	 $cur_tt['ref'] = "";

       $cur_tt['worker'] = array('name'  => $tt->worker->getFullName(),
				 'link'  => $tt->worker->getUrl(),
				 'title' => $tt->worker->getFullName());

       $cur_tt['volume_done'] = hour_format($tt->volume);
       $cur_tt['volume_todo'] = hour_format($tt->volume_todo);

       $sum['v'] += $tt->volume;
       $sum[$tt->currency] += ( $tt->cph * $tt->volume );

       $cur_tt['date']  = $tt->wday->getDate();
       $cur_tt['desc']  = myentities($tt->desc);
       $cur_tt['state'] = $lang['TTStates'][$tt->state];

       $x= array($tt->cph * $tt->volume, $tt->currency);
       $cur_tt['currency'] =
	  array('val' => handle('money', $x,
				  number_format($tt->cph * $tt->volume,2,
						$lang['DecPoint'],
						$lang['ThousandPoint'])),
		'cur' => myentities($tt->currency));
						     
       $a++;
       unset($tt);

       $tts[] = $cur_tt;
     }
     $this->assign('tts', $tts);
     // $this->debug($tts[0]);

     /*
     echo $this->list_navigation($this->link1,$cols ,$this->start,$a,$n);
  
     // Fill the sum
     while ( $a < $n ) {
       $sum['v'] += $this->result->get($a, "volume");
       $sum[$this->result->get($a, "currency")] += ( $this->result->get($a, "cph") * $this->result->get($a, "volume") );
       $a++;
     }
     echo "<tr>\n";
     echo " <td colspan=\"3\">&nbsp;</td>\n";
     echo " <td align=\"right\"><b>". hour_format($sum['v']) ."</b></td>\n";
     echo " <td colspan=\"4\">&nbsp;</td>\n";
     echo " <td align=\"right\"><b>\n";
     @reset($sum);
     while ( list ($s,$x) = @each ($sum) ) {
       if ( ($s != 'v') && ($x != 0.0) ) {
         $z= array($x,$s);
         echo  handle('money',$z,number_format($sum[$s],2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". myentities($s)) ."<br>\n";
       } else {
         echo "&nbsp;";
       }
     }
     echo "</b></td>\n";
     if ( $cols > 8 ) {
       echo " <td colspan=\"". ( $cols - 8 )."\">&nbsp;</td>\n";
     }
     echo "</tr>\n";

     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart(7);
       echo sprintf($lang['withmarked'],$lang['Timetracks']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
       @reset($lang['TTStates']);
       while ( list ($f,$i) = @each ($lang['TTStates']) ) {
         echo " <option value=\"S". $f ."\">". sprintf($lang['SetTo'],$lang['TTState'],$i) ."</option>\n";
       }
       echo "</select>\n";
       echo $this->UpdateRowEnd($cols - 7);
     }
  
     echo $this->DataTableEnd();
     echo $this->actionformEnd("timetrack_overview.php");
     */
     $this->result->free();

     $this->assign('TimetrackOverview', $lang['TimetrackOverview']);
     $this->assign('Description',       $lang['Description']);

     $this->template('timetrack_overview');
   }

   /**
    * Statistical Timetrack Info
    */
   Function exportinfo() {
     global $lang,$tutos;

     Header("Content-type: text");
     Header("Content-Disposition: attachment; filename=\"TUTOS_timetrack_export.csv\"");
     Header("Content-Description: Upload from TUTOS" );
     $n = $this->result->numrows();
     $a = 0;
     while ( $a < $n ) {
       $tt = new timetrack($this->dbconn);
       $tt->read_result($this->result,$a);
       echo $tt->exportCSV();
       $a++;
       flush();
       unset($tt);
     }
   }
   /**
    * Statistical Timetrack Info
    */
   Function statinfo() {
     global $lang,$tutos;

     $n = $this->result->numrows();
     $a = 0;
     $v = 0;
     while ( $a < $n ) {
       $tt = new timetrack($this->dbconn);
       $tt->read_result($this->result,$a);
       if ( !isset($w[$tt->worker->id]) ) {
         $w[$tt->worker->id] = 0;
       }
       if ( !isset($p[$tt->ref->id]) ) {
         $p[$tt->ref->id] = 0;
       }
       $w[$tt->worker->id] += $tt->volume;
       $p[$tt->ref->id] += $tt->volume;
       $v += $tt->volume;
       $a++;
       unset($tt);
     }
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"5\">". $lang['TTStatsTitle'] ."</th>\n";
     echo "</tr>\n";

     $link = "graph_bars.php";
     $link = addUrlParameter($link,"type=pie");
     $link = addUrlParameter($link,"title=".$lang['TimetrackWorker']);
     $link = addSessionKey($link);
     $c = 0;
     while ( list ($i,$f) = @each ($w) ) {
       if ( $v > 0 ) {
         $val = number_format($f * 100.0 / $v ,2);
       } else {
         $val = 0;
       }
       $worker = getObject($this->dbconn,$i);
       if ( $worker != -1 ) {
         $link = addUrlParameter($link,"f[". $c ."]=".$val);
         if ($worker->gettype() == "address") {
           $link = addUrlParameter($link,"t0[". $c  ."]=". UrlEncode($worker->getShortName()));
         } else {
           $link = addUrlParameter($link,"t0[". $c  ."]=". UrlEncode($worker->getFullName()));
         }
         $link = addUrlParameter($link,"t1[". $c ."]=". UrlEncode( hour_format($f) ." ". $lang['hours']));
         $c ++;
       }
     }
     echo "<tr>\n";
     echo $this->showfield($lang['TimetrackWorker']);
     echo " <td colspan=\"4\" valign=\"top\"><img src=\"". $link ."\"></td>";
     echo "</tr>\n";

     $c = 0;
     $r = 0;
     while ( list ($i,$f) = @each ($p) ) {
       if ( $c == 0 ) {
         $r++;
         $links[$r] = "graph_bars.php";
         $links[$r] = addUrlParameter($links[$r],"type=bar");
         $links[$r] = addUrlParameter($links[$r],"ytitle=".$lang['hours']);
         $links[$r] = addUrlParameter($links[$r],"title=".$lang['TimetrackRef']);
         $links[$r] = addSessionKey($links[$r]);
       }
       if ( $v > 0 ) {
         $val = number_format($f * 100.0 / $v ,2);
       } else {
         $val = 0;
       }
       $pp = getObject($this->dbconn,$i);
#       $links[$r] = addUrlParameter($links[$r],"f[". $c ."]=".$val);
       $links[$r] = addUrlParameter($links[$r],"f[". $c ."]=".$f);
       if ( $pp == -1 ) {
         $links[$r] = addUrlParameter($links[$r],"t0[". $c  ."]=". UrlEncode($lang['HistoryDeleted']));
       } else {
         $links[$r] = addUrlParameter($links[$r],"t0[". $c  ."]=". UrlEncode($pp->getFullName()));
       }
#       $links[$r] = addUrlParameter($links[$r],"t1[". $c ."]=". UrlEncode( hour_format($f) ." ". $lang['hours']));
       $c++;
       if ( $c == 10 ) {
         $c = 0;
       }
     }
     if ( function_exists('ImageCreate') ) {
       @reset($links);
       while ( list ($i,$f) = @each ($links) ) {
         echo "<tr>\n";
         echo $this->showfield($lang['TimetrackRef']);
         echo "<td colspan=\"4\" valign=\"top\">\n";
         echo "<img src=\"". $links[$i] ."\"><br>\n";
         echo "</td></tr>\n";
       }
     }
     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * action
    */
   Function action() {
     global $msg,$tutos,$lang;

     @reset($_GET['mark']);
     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $p = new timetrack($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           $msg .= "Unknown ". $lang['Timetrack'] ." ". $val ."<br>\n";
           continue;
         }
         if ( $p->ref->del_ok() ) {
           $msg .= sprintf($lang['Delete']) .":". $p->getFullName() ."<br>";
           $msg .= $p->delete();
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0023'],$lang[$p->getType()]) ."<br>\n";
         }
         unset($p);
       }
       $this->dbconn->Commit("WORK");
     } else if ( ereg("^([S])(.*)",$_GET['action'],$a) ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $p = new timetrack($this->dbconn);
         $p->read($val);
         if ( $p->id != $val ) {
           $msg .= "Unknown ". $lang['Timetrack'] ." ". $val ."<br>\n";
           continue;
         }
         if ( $p->mod_ok() ) {
           $x = (integer)$a[2];
           $msg .= $p->getLink() ." ". sprintf($lang['SetTo'],$lang['TTState'],$lang['TTStates'][$x]) ."<br>";
           $msg .= $p->setState($x);
           $msg .= $p->save();
         } else {
           $msg .= $p->getLink() .": ". sprintf($lang['Err0024'],$lang[$p->getType()]) ."<br>\n";
         }
         unset ($p);
       }
       $this->dbconn->Commit("WORK");
     }
   }

   /**
    * Provide a timetrack legend
    */
   function legend() {
     global $lang;

     $this->assign("legend", $lang['legend']);

     $this->assign('header',
		   array(
			 array('label' => $lang['TimetrackRef']),

			 array('name'  => 'adr_id',
			       'label' => $lang['TimetrackWorker']),

			 array('name'  => 'volume',
			       'label' => $lang['TaskVolumeDone']),

			 /*
			 array('name'  => 'volume_todo',
			       'label' => $lang['TaskVolumeTodo']),
			 */

			 array('name'  => 'creation',
			       'label' => $lang['TimetrackDate']),

			 /*
			 array('name'  => 'desc',
			       'label' => $lang['Description']),
			 */

			 array('name'  => 'state',
			       'label' => $lang['TTState'])

			 /*
			 array('label' => $lang['ProdCost'])
			 */
			 ));

     $this->template('timetrack_overview_legend');
   }


   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->name = $lang['TimetrackOverview'];

     $this->search = array();

     if ( ! $this->user->feature_ok(usetimetrack,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $this->link1 = "timetrack_overview.php";

     $q = "SELECT * FROM ". $this->dbconn->prefix ."timetrack";
     $pre = " WHERE ";

     if ( isset($_GET['id']) ) {
       if (false == is_numeric($_GET['id'])) {
         $msg .= sprintf($lang['Err0012'],"id",$_GET['id']);
         $this->stop = true;
       }
       $q .= $pre . "id =" . $_GET['id'];
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"id=".$_GET['id']);
       // $this->addHidden("id", $_GET['id']);
     }
     if ( isset($_GET['link_id']) ) {
       if (false == is_numeric($_GET['link_id'])) {
         $msg .= sprintf($lang['Err0012'],"link_id",$_GET['link_id']);
         $this->stop = true;
       }
       $ref = getObject($this->dbconn,$_GET['link_id']);
       $this->name .= " : ".$ref->getFullName();
       $q .= $pre . "link_id in (";
       $sep = "";
       if ( ! isset($_GET['show']) ) {
         $q .= $sep . $_GET['link_id'];
         $sep = ",";
       } else if ( $_GET['show'] == "Tasks" ) {
         $this->link1 = addUrlParameter($this->link1,"show=". $_GET['show']);
         // $this->addHidden("show",$_GET['show']);
         add_task_ids($ref,$q,$sep);
         $sep = ",";
       } else if ( $_GET['show'] == "Bugs" ) {
         $this->link1 = addUrlParameter($this->link1,"show=". $_GET['show']);
         // $this->addHidden("show",$_GET['show']);
         add_bugs_ids($ref,$q,$sep);
         $sep = ",";
       } else if ( $_GET['show'] == "Installations" ) {
         $this->link1 = addUrlParameter($this->link1,"show=". $_GET['show']);
         // $this->addHidden("show",$_GET['show']);
         add_inst_ids($ref,$q,$sep);
         $sep = ",";
       } else if ( $_GET['show'] == "all" ) {
         $this->link1 = addUrlParameter($this->link1,"show=". $_GET['show']);
         // $this->addHidden("show",$_GET['show']);
         $q .= $sep . $_GET['link_id'];
         $sep = ",";
         add_task_ids($ref,$q,$sep);
         add_bugs_ids($ref,$q,$sep);
         add_inst_ids($ref,$q,$sep);
       }

       $this->search['show'] = $_GET['show'];

       $q .= ")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"link_id=". $_GET['link_id']);
       // $this->addHidden("link_id",$_GET['link_id']);

       $this->search['link_id'] = $_GET['link_id'];
     }

     // Search in description
     if ( isset($_GET['name']) && ! empty($_GET['name']) ) {
       $this->search['name'] = $_GET['name'];

       $q .= $pre . $this->dbconn->Like("description",$_GET['name']);
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
       $pre = " AND ";
       // $this->addHidden("name",$_GET['name']);
     }

     # Start Date for search
     $from = new DateTime(0);
     if ( isset($_GET['fd']) ) {
       $from->setDateTime($_GET['fd']);
     } else {
       $from->setDateTimeF("f");
       # remember this
#       session_register('ttsearchfrom');
       $_SESSION['ttsearchfrom'] = $from->getYYYYMMDD();
     }
     if ( $from->notime != 1 ) {
       $q .= $pre ."( vtime >= ". $this->dbconn->Date($from) .")";
       $pre = "AND ";
       $this->link1 = addUrlParameter($this->link1,"fd=".$from->getYYYYMMDD());
       // $this->addHidden("fd",$from->getYYYYMMDD());
     }
     # End Date for search
     $to = new DateTime(0);
     if ( isset($_GET['td']) ) {
       $to->setDateTime($_GET['td']);
     } else {
       $to->setDateTimeF("t");
       # remember this
#       session_register('ttsearchto');
       $_SESSION['ttsearchto'] = $to->getYYYYMMDD();
     }
     if ( $to->notime != 1 ) {
       $q .= $pre ."( vtime <= ". $this->dbconn->Date($to) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"td=".$to->getYYYYMMDD());
       // $this->addHidden("td",$to->getYYYYMMDD());
     }
     # Search for state
     if ( isset($_GET['state']) && ($_GET['state'] != -2) ) {
       if (false == is_numeric($_GET['state'])) {
         $msg .= sprintf($lang['Err0012'],"state",$_GET['state']);
         $this->stop = true;
       }
       $q .= $pre ." (state = ". $_GET['state'] .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"state=".$_GET['state']);
#       session_register('ttsearchstate');
       $_SESSION['ttsearchstate'] = $_GET['state'];
       // $this->addHidden("state",$_GET['state']);
     }

     // Search for worker
     if ( isset($_GET['worker']) ) {
       $this->search['worker'] = $_GET['worker'];
       $x = getObject($this->dbconn,$_GET['worker']);
       
       if ($x == -1) {
         $msg .= sprintf($lang['Err0012'],
			 $lang['TimetrackWorker'],$_GET['worker']);
         $this->stop = true;
       }
       else if ( $x->getType() == "address" ) {
         $q .= $pre . "adr_id =" . $_GET['worker'];
       }
       else if ( $x->getType() == "user" ) {
         $q .= $pre . "adr_id =" . $_GET['worker'];
       }
       else if ( $x->getType() == "team" ) {
         $q .= $pre . "adr_id in (" . $_GET['worker'];
         $x->read_member();
         @reset($x->member);
         while ( list ($i1,$f1) = @each ($x->member) ) {
           $q .= "," . $i1;
         }
         $q .= ")";
       }
       else {
         $q .= $pre . "adr_id =" . $link_id;
       }
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"worker=".$_GET['worker']);
	   // $this->addHidden("worker",$_GET['worker']);
     }

     check_dbacl( $q, $this->user->id);

     # sorting
     $this->link2 = $this->link1;
     $xxx = "";
     order_parse($q,$this->link1,$xxx,$xxx,"vtime DESC");

     if ($this->stop) {
       return;
     }
     $this->result = $this->dbconn->Exec($q);

     if ( 0 == $this->result->numrows()) {
       $this->redirect = "timetrack_select.php?msg=".
	  UrlEncode($lang['Err0048']);
       $this->result->free();
     }

     $this->assign('xf', $_GET['xf']);
     $this->assign('xo', $_GET['xo']);

     # menu
     $x = timetrack::getSelectLink($this->user,$lang['Search']);
     $this->addmenu($x);

     $x = timetrack::getaddlink($this->user, $this->adr);
     $x['category'][] = 'obj';
     $this->addMenu($x);

     if ( $this->format != "stat" ) {
       $l = addUrlParameter($this->link1,"format=stat");
       $x = array('url'  => $l,
                  'text' => $lang['BugStats'],
                  'info' => $lang['BugStatsInfo'],
                  'category' => array("timetrack","view")
                 );
       $this->addMenu($x);
     }

     $l = addUrlParameter($this->link1,"format=csv");
     $x = array('url'  => $l,
                'text' => $lang['Export'] ."(CSV)",
                'info' => $lang['ExportInfo'],
                'category' => array("timetrack","view")
               );
     $this->addMenu($x);

     $l = addUrlParameter($this->link1,"format=excel");
     $x = array('url'  => $l,
                'text' => $lang['Export'] ."(EXCEL)",
                'info' => $lang['ExportInfo'],
                'category' => array("timetrack","view")
               );
     $this->addMenu($x);

     $this->assign('search', $this->search);
     $this->assign('useinvoice', $tutos[useinvoice]);
     
    web_StackStartLayout($this,"timetrack_overview.php","timetrack_overview.php?".$_SERVER['QUERY_STRING']);     
   }
 }


 $l = new timetrack_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
