<?php
/**
 * Copyright 2000 - 2004 by Gero Kohnert and ecosoft
 *
 * @modulegroup rate
 * @module rate_show
 * @package rate
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';


 /* Check if user is allowed to use it */
 check_user();
 loadmodules("rate","show");
 loadmodule("rate");
 loadlayout();
 
 /**
  * display a rate 
  */
 class rate_show extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$tutos;

     echo $this->DataTableStart();
     echo "<tr><th colspan=\"4\">". $lang['Rate'] ."</th></tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['createdby']);
     echo $this->showdata($this->obj->creator->getLink(),1);
     echo $this->showfield($lang['atDateTime']);
     echo $this->showdata($this->obj->creation->getLinkDateTime(),1);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['RateName']);
     echo $this->showdata(myentities($this->obj->name),3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['RateReference']);
     echo $this->showdata($this->obj->getRefLink(),3);
     echo "</tr>\n";
     
     echo "<tr>\n";
     echo $this->showfield($lang['RateWorkerReference']);
     if ( $this->obj->worker > 0 ) {
       echo $this->showdata($this->obj->worker->getLink(),1);
     } else {
       echo $this->showdata($this->obj->getRefLink(),3);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['RateRole']);
     echo $this->showdata($this->obj->getRole());
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['Rate']);
     echo $this->showdata(number_format($this->obj->cph,2,$lang['DecPoint'],$lang['ThousandPoint']) ." ". $this->obj->currency);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['RateVat']);
     echo $this->showdata(number_format($this->obj->vat,2,$lang['DecPoint'],$lang['ThousandPoint']));
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['TTState']);
     echo $this->showdata($this->obj->getState());
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['RatePriority']);
     echo $this->showdata($this->obj->priority,3);
     echo "</tr>\n";

     # References to modules
     show_module_infolists($this->user,$this->obj,4);
     echo $this->obj->getHistoryLink(4);

     echo $this->DataTableEnd();
   }
   /**
    * navigation
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['RateDetail'];
     $this->obj = new rate($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
	 } else {
       $msg .= $lang['Err0048'] ."<br>";
       $this->stop = true;
	 }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->obj->read_reference();
	 }
     # menu
     $m = rate::getSelectLink($this->user, $lang['Search']);
     $m[category][] = "obj";
     $this->addmenu($m);

     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => $this->obj->getModURL(),
                   text => $lang['Modify'],
                   info => $lang['RateMod'],
                   category => array("rate","mod","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => $this->obj->getDelURL(),
                   text => $lang['Delete'],
                   info => $lang['RateDelete'],
                   confirm => true,
                   category => array("rate","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_addlinks($this,$this->obj);
     # add this page to the browsehistory of the users session
	 $this->addtohistory();
	 web_StackStartLayoutObj($this); 
   }
 }

 $l = new rate_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  
    $Author: 
-->
