/* -*- mode: c; c-file-style: "gnu" -*-
 * list.h -- list handling routines, prototypes
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of BoneHunter Libs.
 *
 * BoneHunter Libs is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 dated June,
 * 1991.
 *
 * BoneHunter Libs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file list.h
 * List handling routines, prototypes.
 */

#ifndef _BHL_LIST_H
#define _BHL_LIST_H 1 /**< list.h multi-inclusion guard. */

#include "system.h"

#include <stddef.h>
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

/** Opaque type definition of a list.
 * Unless you are list.c, you do not need to know what is inside.
 * @see _bhl_list_t.
 */
typedef struct _bhl_list_t bhl_list_t;

/** Prototype for any list-element freeing function.
 * If a list contains anything more complicated than a simple pointer
 * which can be free()d, the _bhl_list_t routines provide a way to
 * free member elements of the struct/union/whatever - this hook.
 *
 * @param ptr is a pointer to the list element to free up, probably
 * needs typecasting.
 *
 * @see list.c.
 */
typedef void (*bhl_list_free_f) (void *ptr);

bhl_list_t *bhl_list_init (size_t initsize, bhl_list_free_f efree);
void bhl_list_free (bhl_list_t *list);
size_t bhl_list_append (bhl_list_t *list, const void *data, size_t size);
size_t bhl_list_append_string (bhl_list_t *list, const char *str);
size_t bhl_list_get (const bhl_list_t *list, size_t idx, void **data);
size_t bhl_list_size (const bhl_list_t *list);
size_t bhl_list_insert (bhl_list_t *list, const void *data, size_t size);
int bhl_list_delete (bhl_list_t *list, size_t idx);

#endif /* !_BHL_LIST_H */

/* arch-tag: a5c1af64-ee7c-4a4f-af2a-f68ac4ed55d1 */
