/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef LINKLIST_H_INCLUDED
#define LINKLIST_H_INCLUDED

#include <cstring>

#include <gtk--/clist.h>

#include "thoughttracker.h"
#include "database.h"

class TTLinkList : public Gtk::CList {
  public:
    TTLinkList();
    virtual ~TTLinkList() {};

    /* an own version of clear() making sure our parents get a proper
       notification of a possibly selected entry getting unselected in the
       process */
    virtual void clear() {
      unselect_all();
      Gtk::CList::clear();
    }

    /* appends a link given its <id>, <summary>, and information as to whether
       it is a hub */
    virtual void append_link(dbid_t id, const string &summary,
      bool is_hub = false, bool is_linked = false)
    {
      new_link(false, id, summary, is_hub, is_linked);
    };

    /* updates a link's row in the list, if it exists */
    virtual void update_link(dbid_t id, const string &summary,
      bool is_hub = false, bool is_linked = false)
    {
      new_link(true, id, summary, is_hub, is_linked);
    };

    /* deletes the link with the specified ID from the list, if present */
    virtual void delete_link(dbid_t);

    /* returns the entry id represented by row <row>, or -1 if the row doesn't
       exist */
    virtual dbid_t id_of_row(gint row) {
      dbid_t *id = (dbid_t*) get_row_data(row);
      return id ? *id : -1;
    };

  private:
    /* does the actual adding/updating offered by append_link/update_link */
    virtual void new_link(bool update, dbid_t id, const string &summary,
      bool is_hub = false, bool is_linked = false);

    /* frees a row's data after its destruction */
    static void free_row_data(gpointer data) { delete (dbid_t*) data; };

    /* compare function respecting the locale in use */
    static gint ll_cmp(GtkCList *list, const GtkCListRow *a,
      const GtkCListRow *b)
    {
#ifdef HAVE_STRCOLL
      return strcoll(GTK_CELL_TEXT(a->cell[1])->text,
        GTK_CELL_TEXT(b->cell[1])->text);
#else
      return strcmp(GTK_CELL_TEXT(a->cell[1])->text,
        GTK_CELL_TEXT(b->cell[1])->text);
#endif
    }
};

#endif  /* LINKLIST_H_INCLUDED */

