/*
 * socketinfo.h - C header for socketinfo.c
 * socket creation functions on top of getaddrinfo()
 * $Id: socketinfo.h,v 1.4 2003/01/26 09:09:08 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Pulic License   *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_SOCKETINFO_H
# define __TCPREEN_SOCKETINFO_H

# ifdef HAVE_SYS_TYPES
#  include <sys/types.h>
# endif
# include "getaddrinfo.h"
# ifdef HAVE_UNISTD_H
#  include <sys/time.h>
#  include <unistd.h>
# endif

typedef int *fd_array;

struct sockhostinfo
{
	char hostname[NI_MAXHOST], service[NI_MAXSERV];
	int family, socktype, protocol;
};

# ifdef __cplusplus
extern "C" {
# endif

int fdarray_close (fd_array array);
int fdarraytofdset (const int *array, fd_set *set);
int fdarray_dequeuefromset (const int *array, fd_set *set);
int fdarray_accept (const fd_array array);
void socket_perror (int errno, const char *nodename,
			const char *service);
int sockhostinfo_listen (fd_array *array,
				const struct sockhostinfo *hostinfo);
int sockhostinfo_connect (int *fd, const struct sockhostinfo *hostinfo);
void sockhostinfo_perror (int errno, const struct sockhostinfo *info);

# ifdef __cplusplus
}
# endif
#endif

