/*
 * basiclog.cc - basic log formats implementation
 * $Id: basiclog.cc,v 1.8 2003/01/26 09:09:07 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Pulic License   *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "output.h"
#include "basiclog.h"


/*** BasicDataLog class implementation ***/
BasicDataLog::~BasicDataLog (void)
{
	if (out != NULL)
		fputs (_("End of transmission.\n"), out);
}



void
BasicDataLog::Connect (const char *server, const char *client)
{
	fprintf (out, _("Connection from: %s\n"), client);
	fprintf (out, _("Connection to: %s\n"), server);
	fputs (_("Transmission follows...\n"), out);
}


int
BasicDataLog::WriteServerData (const void *data, int length, int oob)
{
	if (outcount >= 0)
		outcount += length;
	
	if ((oob && (fputs ("(OOB)", out) < 0))
	 || (fputs (">>> ", out) < 0))
		return-1;
	return logwrite (data, length, out);
}


int
BasicDataLog::WriteClientData (const void *data, int length, int oob)
{
	if (incount >= 0)
		incount += length;

	if ((oob && (fputs ("(OOB)", out) < 0))
	 || (fputs ("<<< ", out) < 0))
		return -1;
	return logwrite (data, length, out);
}


void
BasicDataLog::ShutdownServer (void)
{	
	fputs (_("End of output"), out);
	if (outcount >= 0)
		fprintf (out, _(": %ld byte(s) sent.\n"), outcount);
	else
		fputs (".\n", out);
}


void
BasicDataLog::ShutdownClient (void)
{
	fputs (_("End of input"), out);
	if (incount >= 0)
		fprintf (out, _(": %ld byte(s) received.\n"), incount);
	else
		fputs (".\n", out);
}


/* Makers */
DataLog *
CountDataLogMaker (void)
{
	return new CountDataLog;
}

	
DataLog *
CDataLogMaker (void)
{
	return new CDataLog;
}


DataLog *
HexDataLogMaker (void)
{
	return new HexDataLog;
}


DataLog *
RawDataLogMaker (void)
{
	return new RawDataLog;
}


DataLog *
StrippedDataLogMaker (void)
{
	return new StrippedDataLog;
}

