# A simple wrapper class for the gdchart module.  This code demonstrates one
# way to keep separate dictionaries of option values, in this case, one copy
# per object.

import gdchart

# Save the default option values in a module-level dictionary.  This way, each
# new instance of the Chart class can begin life with its own copy of the
# default option values.
gdchart.defaults = gdchart.option()

# This class is just a container for option values.
class Chart:
    def __init__(self):
        # Get a copy of the default options
        self.options = gdchart.defaults.copy()

    def option(self, **args):
        # Save option values in the object's dictionary.
        self.options.update(args)

    def draw(self):
	# Put options into effect.  Derived class implementations of draw()
	# should call this method before calling gdchart.chart().
        apply(gdchart.option, (), self.options)

if __name__ == '__main__':
    # An example derived class.
    class PieChart(Chart):
	def __init__(self):
	    Chart.__init__(self)

	def draw(self, size, file, labels, *data):
	    Chart.draw(self)
	    args = (gdchart.GDC_3DPIE, size, file, labels) + data
	    apply(gdchart.chart, args)

    c = PieChart()
    c.option(pie_color=(0xff8080, 0x80ff80, 0x8080ff, 0xffff80, 0xff80ff, 0x80ffff))
    c.option(edge_color=0x0, line_color=0xffffff)
    c.option(label_line=1)
    c.option(explode=(0,0,0,0,0,15))
    c.option(title='Have Some Pie')
    cities = ('Chicago', 'New York', 'L.A.', 'Atlanta', 'Paris, MD\n(USA)', 'London')
    values = (1.9, 1.3, 1.2, 0.75, 0.1, 2.0)
    c.draw((250, 250), 'pie.png', cities, values)
    print 'See pie.png'

