<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f	"http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss">
  <!ENTITY vcard "http://4suite.org/nexus/rdfs/vcard#">
]>
<xsl:stylesheet
  version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:fcore="http://xmlns.4suite.org/4ss/score" 
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" 
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;" 
  xmlns:fres="&fres;"
  xmlns:rdf="&rdf;" 
  xmlns:f="&f;" 
  xmlns:vcard="&vcard;" 
  xmlns:fschema="http://schemas.4suite.org/4ss"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <!--
File:  cards.xslt

Description:

    Common templates for the card games


WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->

  <xsl:template name='shuffle-cards'>
    <xsl:param name='num-decks' select='1'/>
    <xsl:variable name='decks'>
      <xsl:call-template name='create-decks'>
        <xsl:with-param name='num-decks' select='$num-decks'/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:for-each select='exslt:node-set($decks)/Card'>
      <xsl:sort select='@weight'/>
      <xsl:copy-of select='.'/>
    </xsl:for-each>
  </xsl:template>


  <xsl:template name = 'create-decks'>
    <xsl:param name='num-decks'/>
    <xsl:call-template name='create-suite'>
      <xsl:with-param name='suite' select='"Heart"'/>
      <xsl:with-param name='suite-abbr' select='"H"'/>
    </xsl:call-template>
    <xsl:call-template name='create-suite'>
      <xsl:with-param name='suite' select='"Diamond"'/>
      <xsl:with-param name='suite-abbr' select='"D"'/>
    </xsl:call-template>
    <xsl:call-template name='create-suite'>
      <xsl:with-param name='suite' select='"Club"'/>
      <xsl:with-param name='suite-abbr' select='"C"'/>
    </xsl:call-template>
    <xsl:call-template name='create-suite'>
      <xsl:with-param name='suite' select='"Spade"'/>
      <xsl:with-param name='suite-abbr' select='"S"'/>
    </xsl:call-template>
    <xsl:if test='$num-decks > 1'>
      <xsl:call-template name='create-decks'>
        <xsl:with-param name='num-decks' select='$num-decks - 1'/>
      </xsl:call-template>
    </xsl:if>

  </xsl:template>

  <xsl:template name='create-suite'>
    <xsl:param name='suite'/>
    <xsl:param name='suite-abbr'/>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"A"'/>
      <xsl:with-param name='value-int' select='"1"'/>
      <xsl:with-param name='point' select='1'/>
      <xsl:with-param name='name' select='"Ace"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"2"'/>
      <xsl:with-param name='value-int' select='"2"'/>
      <xsl:with-param name='point' select='2'/>
      <xsl:with-param name='name' select='"Two"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"3"'/>
      <xsl:with-param name='value-int' select='"3"'/>
      <xsl:with-param name='point' select='3'/>
      <xsl:with-param name='name' select='"Three"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"4"'/>
      <xsl:with-param name='value-int' select='"4"'/>
      <xsl:with-param name='point' select='4'/>
      <xsl:with-param name='name' select='"Four"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"5"'/>
      <xsl:with-param name='value-int' select='"5"'/>
      <xsl:with-param name='point' select='5'/>
      <xsl:with-param name='name' select='"Five"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"6"'/>
      <xsl:with-param name='value-int' select='"6"'/>
      <xsl:with-param name='point' select='6'/>
      <xsl:with-param name='name' select='"Six"'/>
    </xsl:call-template>


    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"7"'/>
      <xsl:with-param name='value-int' select='"7"'/>
      <xsl:with-param name='point' select='7'/>
      <xsl:with-param name='name' select='"Seven"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"8"'/>
      <xsl:with-param name='value-int' select='"8"'/>
      <xsl:with-param name='point' select='8'/>
      <xsl:with-param name='name' select='"Eight"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"9"'/>
      <xsl:with-param name='value-int' select='"9"'/>
      <xsl:with-param name='point' select='9'/>
      <xsl:with-param name='name' select='"Nine"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"T"'/>
      <xsl:with-param name='value-int' select='"10"'/>
      <xsl:with-param name='point' select='10'/>
      <xsl:with-param name='name' select='"Ten"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"J"'/>
      <xsl:with-param name='value-int' select='"11"'/>
      <xsl:with-param name='point' select='10'/>
      <xsl:with-param name='name' select='"Jack"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"Q"'/>
      <xsl:with-param name='value-int' select='"12"'/>
      <xsl:with-param name='point' select='10'/>
      <xsl:with-param name='name' select='"Queen"'/>
    </xsl:call-template>

    <xsl:call-template name='create-card'>
      <xsl:with-param name='suite' select='$suite'/>
      <xsl:with-param name='suite-abbr' select='$suite-abbr'/>
      <xsl:with-param name='value' select='"K"'/>
      <xsl:with-param name='value-int' select='"13"'/>
      <xsl:with-param name='point' select='10'/>
      <xsl:with-param name='name' select='"King"'/>
    </xsl:call-template>

  </xsl:template>


  <xsl:template name='create-card'>
    <xsl:param name='suite'/>
    <xsl:param name='suite-abbr'/>
    <xsl:param name='value'/>
    <xsl:param name='value-int'/>
    <xsl:param name='point'/>
    <xsl:param name='name'/>
    <Card suite='{$suite}' value='{$value}' point='{$point}' weight='{f:random(100)}' img='/images/cards/{$value}{$suite-abbr}.png' value-int='{$value-int}' short-name='{$value}{$suite-abbr}' formal-name='{$name} of {$suite}s'/>
  </xsl:template>

  <xsl:template match='Card' mode='serialize'>
    Card: <xsl:value-of select='@formal-name'/>,
  </xsl:template>


</xsl:stylesheet>