(* case insensitive, case perserving, unique lists based on 
hash tables *)

type t = (string, string) Hashtbl.t;;

let create n = Hashtbl.create n;;
let mem lst item = Hashtbl.mem lst (String.lowercase item);;
let add lst item =
  let lcitem = String.lowercase item in
    if (Hashtbl.mem lst lcitem) = false then
      Hashtbl.add lst lcitem item; ();;
let addlst lst lst1 = List.iter (fun i -> add lst i) lst1;;
let remove lst item = Hashtbl.remove lst (String.lowercase item);;
let iter func lst = Hashtbl.iter (fun key valu -> func key) lst;;
let tolst lst = Hashtbl.fold (fun k v l -> v :: l) lst [];;
